/* xoreos - A reimplementation of BioWare's Aurora engine
 *
 * xoreos is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Static sine tables.
 */

#include <cassert>

#include "src/common/sinetables.h"

namespace Common {

static const float sinTable16[8] = {
	 0.000000f,  0.382683f,  0.707107f,  0.923880f,  0.000000f, -0.382683f, -0.707107f, -0.923880f
};

static const float sinTable32[16] = {
	 0.000000f,  0.195090f,  0.382683f,  0.555570f,  0.707107f,  0.831470f,  0.923880f,  0.980785f,
	 0.000000f, -0.195090f, -0.382683f, -0.555570f, -0.707107f, -0.831470f, -0.923880f, -0.980785f
};

static const float sinTable64[32] = {
	 0.000000f,  0.098017f,  0.195090f,  0.290285f,  0.382683f,  0.471397f,  0.555570f,  0.634393f,
	 0.707107f,  0.773010f,  0.831470f,  0.881921f,  0.923880f,  0.956940f,  0.980785f,  0.995185f,
	 0.000000f, -0.098017f, -0.195090f, -0.290285f, -0.382683f, -0.471397f, -0.555570f, -0.634393f,
	-0.707107f, -0.773010f, -0.831470f, -0.881921f, -0.923880f, -0.956940f, -0.980785f, -0.995185f
};

static const float sinTable128[64] = {
	 0.000000f,  0.049068f,  0.098017f,  0.146730f,  0.195090f,  0.242980f,  0.290285f,  0.336890f,
	 0.382683f,  0.427555f,  0.471397f,  0.514103f,  0.555570f,  0.595699f,  0.634393f,  0.671559f,
	 0.707107f,  0.740951f,  0.773010f,  0.803208f,  0.831470f,  0.857729f,  0.881921f,  0.903989f,
	 0.923880f,  0.941544f,  0.956940f,  0.970031f,  0.980785f,  0.989177f,  0.995185f,  0.998795f,
	 0.000000f, -0.049068f, -0.098017f, -0.146730f, -0.195090f, -0.242980f, -0.290285f, -0.336890f,
	-0.382683f, -0.427555f, -0.471397f, -0.514103f, -0.555570f, -0.595699f, -0.634393f, -0.671559f,
	-0.707107f, -0.740951f, -0.773010f, -0.803208f, -0.831470f, -0.857729f, -0.881921f, -0.903989f,
	-0.923880f, -0.941544f, -0.956940f, -0.970031f, -0.980785f, -0.989177f, -0.995185f, -0.998795f
};

static const float sinTable256[128] = {
	 0.000000f,  0.024541f,  0.049068f,  0.073565f,  0.098017f,  0.122411f,  0.146730f,  0.170962f,
	 0.195090f,  0.219101f,  0.242980f,  0.266713f,  0.290285f,  0.313682f,  0.336890f,  0.359895f,
	 0.382683f,  0.405241f,  0.427555f,  0.449611f,  0.471397f,  0.492898f,  0.514103f,  0.534998f,
	 0.555570f,  0.575808f,  0.595699f,  0.615232f,  0.634393f,  0.653173f,  0.671559f,  0.689541f,
	 0.707107f,  0.724247f,  0.740951f,  0.757209f,  0.773010f,  0.788346f,  0.803208f,  0.817585f,
	 0.831470f,  0.844854f,  0.857729f,  0.870087f,  0.881921f,  0.893224f,  0.903989f,  0.914210f,
	 0.923880f,  0.932993f,  0.941544f,  0.949528f,  0.956940f,  0.963776f,  0.970031f,  0.975702f,
	 0.980785f,  0.985278f,  0.989177f,  0.992480f,  0.995185f,  0.997290f,  0.998795f,  0.999699f,
	 0.000000f, -0.024541f, -0.049068f, -0.073565f, -0.098017f, -0.122411f, -0.146730f, -0.170962f,
	-0.195090f, -0.219101f, -0.242980f, -0.266713f, -0.290285f, -0.313682f, -0.336890f, -0.359895f,
	-0.382683f, -0.405241f, -0.427555f, -0.449611f, -0.471397f, -0.492898f, -0.514103f, -0.534998f,
	-0.555570f, -0.575808f, -0.595699f, -0.615232f, -0.634393f, -0.653173f, -0.671559f, -0.689541f,
	-0.707107f, -0.724247f, -0.740951f, -0.757209f, -0.773010f, -0.788346f, -0.803208f, -0.817585f,
	-0.831470f, -0.844854f, -0.857729f, -0.870087f, -0.881921f, -0.893224f, -0.903989f, -0.914210f,
	-0.923880f, -0.932993f, -0.941544f, -0.949528f, -0.956940f, -0.963776f, -0.970031f, -0.975702f,
	-0.980785f, -0.985278f, -0.989177f, -0.992480f, -0.995185f, -0.997290f, -0.998795f, -0.999699f
};

static const float sinTable512[256] = {
	 0.000000f,  0.012272f,  0.024541f,  0.036807f,  0.049068f,  0.061321f,  0.073565f,  0.085797f,
	 0.098017f,  0.110222f,  0.122411f,  0.134581f,  0.146730f,  0.158858f,  0.170962f,  0.183040f,
	 0.195090f,  0.207111f,  0.219101f,  0.231058f,  0.242980f,  0.254866f,  0.266713f,  0.278520f,
	 0.290285f,  0.302006f,  0.313682f,  0.325310f,  0.336890f,  0.348419f,  0.359895f,  0.371317f,
	 0.382683f,  0.393992f,  0.405241f,  0.416430f,  0.427555f,  0.438616f,  0.449611f,  0.460539f,
	 0.471397f,  0.482184f,  0.492898f,  0.503538f,  0.514103f,  0.524590f,  0.534998f,  0.545325f,
	 0.555570f,  0.565732f,  0.575808f,  0.585798f,  0.595699f,  0.605511f,  0.615232f,  0.624860f,
	 0.634393f,  0.643832f,  0.653173f,  0.662416f,  0.671559f,  0.680601f,  0.689541f,  0.698376f,
	 0.707107f,  0.715731f,  0.724247f,  0.732654f,  0.740951f,  0.749136f,  0.757209f,  0.765167f,
	 0.773010f,  0.780737f,  0.788346f,  0.795837f,  0.803208f,  0.810457f,  0.817585f,  0.824589f,
	 0.831470f,  0.838225f,  0.844854f,  0.851355f,  0.857729f,  0.863973f,  0.870087f,  0.876070f,
	 0.881921f,  0.887640f,  0.893224f,  0.898674f,  0.903989f,  0.909168f,  0.914210f,  0.919114f,
	 0.923880f,  0.928506f,  0.932993f,  0.937339f,  0.941544f,  0.945607f,  0.949528f,  0.953306f,
	 0.956940f,  0.960431f,  0.963776f,  0.966976f,  0.970031f,  0.972940f,  0.975702f,  0.978317f,
	 0.980785f,  0.983105f,  0.985278f,  0.987301f,  0.989177f,  0.990903f,  0.992480f,  0.993907f,
	 0.995185f,  0.996313f,  0.997290f,  0.998118f,  0.998795f,  0.999322f,  0.999699f,  0.999925f,
	 0.000000f, -0.012272f, -0.024541f, -0.036807f, -0.049068f, -0.061321f, -0.073565f, -0.085797f,
	-0.098017f, -0.110222f, -0.122411f, -0.134581f, -0.146730f, -0.158858f, -0.170962f, -0.183040f,
	-0.195090f, -0.207111f, -0.219101f, -0.231058f, -0.242980f, -0.254866f, -0.266713f, -0.278520f,
	-0.290285f, -0.302006f, -0.313682f, -0.325310f, -0.336890f, -0.348419f, -0.359895f, -0.371317f,
	-0.382683f, -0.393992f, -0.405241f, -0.416430f, -0.427555f, -0.438616f, -0.449611f, -0.460539f,
	-0.471397f, -0.482184f, -0.492898f, -0.503538f, -0.514103f, -0.524590f, -0.534998f, -0.545325f,
	-0.555570f, -0.565732f, -0.575808f, -0.585798f, -0.595699f, -0.605511f, -0.615232f, -0.624860f,
	-0.634393f, -0.643832f, -0.653173f, -0.662416f, -0.671559f, -0.680601f, -0.689541f, -0.698376f,
	-0.707107f, -0.715731f, -0.724247f, -0.732654f, -0.740951f, -0.749136f, -0.757209f, -0.765167f,
	-0.773010f, -0.780737f, -0.788346f, -0.795837f, -0.803208f, -0.810457f, -0.817585f, -0.824589f,
	-0.831470f, -0.838225f, -0.844854f, -0.851355f, -0.857729f, -0.863973f, -0.870087f, -0.876070f,
	-0.881921f, -0.887640f, -0.893224f, -0.898674f, -0.903989f, -0.909168f, -0.914210f, -0.919114f,
	-0.923880f, -0.928506f, -0.932993f, -0.937339f, -0.941544f, -0.945607f, -0.949528f, -0.953306f,
	-0.956940f, -0.960431f, -0.963776f, -0.966976f, -0.970031f, -0.972940f, -0.975702f, -0.978317f,
	-0.980785f, -0.983105f, -0.985278f, -0.987301f, -0.989177f, -0.990903f, -0.992480f, -0.993907f,
	-0.995185f, -0.996313f, -0.997290f, -0.998118f, -0.998795f, -0.999322f, -0.999699f, -0.999925f
};

static const float sinTable1024[512] = {
	 0.000000f,  0.006136f,  0.012272f,  0.018407f,  0.024541f,  0.030675f,  0.036807f,  0.042938f,
	 0.049068f,  0.055195f,  0.061321f,  0.067444f,  0.073565f,  0.079682f,  0.085797f,  0.091909f,
	 0.098017f,  0.104122f,  0.110222f,  0.116319f,  0.122411f,  0.128498f,  0.134581f,  0.140658f,
	 0.146730f,  0.152797f,  0.158858f,  0.164913f,  0.170962f,  0.177004f,  0.183040f,  0.189069f,
	 0.195090f,  0.201105f,  0.207111f,  0.213110f,  0.219101f,  0.225084f,  0.231058f,  0.237024f,
	 0.242980f,  0.248928f,  0.254866f,  0.260794f,  0.266713f,  0.272621f,  0.278520f,  0.284408f,
	 0.290285f,  0.296151f,  0.302006f,  0.307850f,  0.313682f,  0.319502f,  0.325310f,  0.331106f,
	 0.336890f,  0.342661f,  0.348419f,  0.354164f,  0.359895f,  0.365613f,  0.371317f,  0.377007f,
	 0.382683f,  0.388345f,  0.393992f,  0.399624f,  0.405241f,  0.410843f,  0.416430f,  0.422000f,
	 0.427555f,  0.433094f,  0.438616f,  0.444122f,  0.449611f,  0.455084f,  0.460539f,  0.465977f,
	 0.471397f,  0.476799f,  0.482184f,  0.487550f,  0.492898f,  0.498228f,  0.503538f,  0.508830f,
	 0.514103f,  0.519356f,  0.524590f,  0.529804f,  0.534998f,  0.540171f,  0.545325f,  0.550458f,
	 0.555570f,  0.560662f,  0.565732f,  0.570781f,  0.575808f,  0.580814f,  0.585798f,  0.590760f,
	 0.595699f,  0.600616f,  0.605511f,  0.610383f,  0.615232f,  0.620057f,  0.624860f,  0.629638f,
	 0.634393f,  0.639124f,  0.643832f,  0.648514f,  0.653173f,  0.657807f,  0.662416f,  0.667000f,
	 0.671559f,  0.676093f,  0.680601f,  0.685084f,  0.689541f,  0.693971f,  0.698376f,  0.702755f,
	 0.707107f,  0.711432f,  0.715731f,  0.720003f,  0.724247f,  0.728464f,  0.732654f,  0.736817f,
	 0.740951f,  0.745058f,  0.749136f,  0.753187f,  0.757209f,  0.761202f,  0.765167f,  0.769103f,
	 0.773010f,  0.776888f,  0.780737f,  0.784557f,  0.788346f,  0.792107f,  0.795837f,  0.799537f,
	 0.803208f,  0.806848f,  0.810457f,  0.814036f,  0.817585f,  0.821102f,  0.824589f,  0.828045f,
	 0.831470f,  0.834863f,  0.838225f,  0.841555f,  0.844854f,  0.848120f,  0.851355f,  0.854558f,
	 0.857729f,  0.860867f,  0.863973f,  0.867046f,  0.870087f,  0.873095f,  0.876070f,  0.879012f,
	 0.881921f,  0.884797f,  0.887640f,  0.890449f,  0.893224f,  0.895966f,  0.898674f,  0.901349f,
	 0.903989f,  0.906596f,  0.909168f,  0.911706f,  0.914210f,  0.916679f,  0.919114f,  0.921514f,
	 0.923880f,  0.926210f,  0.928506f,  0.930767f,  0.932993f,  0.935184f,  0.937339f,  0.939459f,
	 0.941544f,  0.943593f,  0.945607f,  0.947586f,  0.949528f,  0.951435f,  0.953306f,  0.955141f,
	 0.956940f,  0.958703f,  0.960431f,  0.962121f,  0.963776f,  0.965394f,  0.966976f,  0.968522f,
	 0.970031f,  0.971504f,  0.972940f,  0.974339f,  0.975702f,  0.977028f,  0.978317f,  0.979570f,
	 0.980785f,  0.981964f,  0.983105f,  0.984210f,  0.985278f,  0.986308f,  0.987301f,  0.988258f,
	 0.989177f,  0.990058f,  0.990903f,  0.991710f,  0.992480f,  0.993212f,  0.993907f,  0.994565f,
	 0.995185f,  0.995767f,  0.996313f,  0.996820f,  0.997290f,  0.997723f,  0.998118f,  0.998476f,
	 0.998795f,  0.999078f,  0.999322f,  0.999529f,  0.999699f,  0.999831f,  0.999925f,  0.999981f,
	 0.000000f, -0.006136f, -0.012272f, -0.018407f, -0.024541f, -0.030675f, -0.036807f, -0.042938f,
	-0.049068f, -0.055195f, -0.061321f, -0.067444f, -0.073565f, -0.079682f, -0.085797f, -0.091909f,
	-0.098017f, -0.104122f, -0.110222f, -0.116319f, -0.122411f, -0.128498f, -0.134581f, -0.140658f,
	-0.146730f, -0.152797f, -0.158858f, -0.164913f, -0.170962f, -0.177004f, -0.183040f, -0.189069f,
	-0.195090f, -0.201105f, -0.207111f, -0.213110f, -0.219101f, -0.225084f, -0.231058f, -0.237024f,
	-0.242980f, -0.248928f, -0.254866f, -0.260794f, -0.266713f, -0.272621f, -0.278520f, -0.284408f,
	-0.290285f, -0.296151f, -0.302006f, -0.307850f, -0.313682f, -0.319502f, -0.325310f, -0.331106f,
	-0.336890f, -0.342661f, -0.348419f, -0.354164f, -0.359895f, -0.365613f, -0.371317f, -0.377007f,
	-0.382683f, -0.388345f, -0.393992f, -0.399624f, -0.405241f, -0.410843f, -0.416430f, -0.422000f,
	-0.427555f, -0.433094f, -0.438616f, -0.444122f, -0.449611f, -0.455084f, -0.460539f, -0.465977f,
	-0.471397f, -0.476799f, -0.482184f, -0.487550f, -0.492898f, -0.498228f, -0.503538f, -0.508830f,
	-0.514103f, -0.519356f, -0.524590f, -0.529804f, -0.534998f, -0.540171f, -0.545325f, -0.550458f,
	-0.555570f, -0.560662f, -0.565732f, -0.570781f, -0.575808f, -0.580814f, -0.585798f, -0.590760f,
	-0.595699f, -0.600616f, -0.605511f, -0.610383f, -0.615232f, -0.620057f, -0.624860f, -0.629638f,
	-0.634393f, -0.639124f, -0.643832f, -0.648514f, -0.653173f, -0.657807f, -0.662416f, -0.667000f,
	-0.671559f, -0.676093f, -0.680601f, -0.685084f, -0.689541f, -0.693971f, -0.698376f, -0.702755f,
	-0.707107f, -0.711432f, -0.715731f, -0.720003f, -0.724247f, -0.728464f, -0.732654f, -0.736817f,
	-0.740951f, -0.745058f, -0.749136f, -0.753187f, -0.757209f, -0.761202f, -0.765167f, -0.769103f,
	-0.773010f, -0.776888f, -0.780737f, -0.784557f, -0.788346f, -0.792107f, -0.795837f, -0.799537f,
	-0.803208f, -0.806848f, -0.810457f, -0.814036f, -0.817585f, -0.821102f, -0.824589f, -0.828045f,
	-0.831470f, -0.834863f, -0.838225f, -0.841555f, -0.844854f, -0.848120f, -0.851355f, -0.854558f,
	-0.857729f, -0.860867f, -0.863973f, -0.867046f, -0.870087f, -0.873095f, -0.876070f, -0.879012f,
	-0.881921f, -0.884797f, -0.887640f, -0.890449f, -0.893224f, -0.895966f, -0.898674f, -0.901349f,
	-0.903989f, -0.906596f, -0.909168f, -0.911706f, -0.914210f, -0.916679f, -0.919114f, -0.921514f,
	-0.923880f, -0.926210f, -0.928506f, -0.930767f, -0.932993f, -0.935184f, -0.937339f, -0.939459f,
	-0.941544f, -0.943593f, -0.945607f, -0.947586f, -0.949528f, -0.951435f, -0.953306f, -0.955141f,
	-0.956940f, -0.958703f, -0.960431f, -0.962121f, -0.963776f, -0.965394f, -0.966976f, -0.968522f,
	-0.970031f, -0.971504f, -0.972940f, -0.974339f, -0.975702f, -0.977028f, -0.978317f, -0.979570f,
	-0.980785f, -0.981964f, -0.983105f, -0.984210f, -0.985278f, -0.986308f, -0.987301f, -0.988258f,
	-0.989177f, -0.990058f, -0.990903f, -0.991710f, -0.992480f, -0.993212f, -0.993907f, -0.994565f,
	-0.995185f, -0.995767f, -0.996313f, -0.996820f, -0.997290f, -0.997723f, -0.998118f, -0.998476f,
	-0.998795f, -0.999078f, -0.999322f, -0.999529f, -0.999699f, -0.999831f, -0.999925f, -0.999981f
};

static const float sinTable2048[1024] = {
	 0.000000f,  0.003068f,  0.006136f,  0.009204f,  0.012272f,  0.015339f,  0.018407f,  0.021474f,
	 0.024541f,  0.027608f,  0.030675f,  0.033741f,  0.036807f,  0.039873f,  0.042938f,  0.046003f,
	 0.049068f,  0.052132f,  0.055195f,  0.058258f,  0.061321f,  0.064383f,  0.067444f,  0.070505f,
	 0.073565f,  0.076624f,  0.079682f,  0.082740f,  0.085797f,  0.088854f,  0.091909f,  0.094963f,
	 0.098017f,  0.101070f,  0.104122f,  0.107172f,  0.110222f,  0.113271f,  0.116319f,  0.119365f,
	 0.122411f,  0.125455f,  0.128498f,  0.131540f,  0.134581f,  0.137620f,  0.140658f,  0.143695f,
	 0.146730f,  0.149765f,  0.152797f,  0.155828f,  0.158858f,  0.161886f,  0.164913f,  0.167938f,
	 0.170962f,  0.173984f,  0.177004f,  0.180023f,  0.183040f,  0.186055f,  0.189069f,  0.192080f,
	 0.195090f,  0.198098f,  0.201105f,  0.204109f,  0.207111f,  0.210112f,  0.213110f,  0.216107f,
	 0.219101f,  0.222094f,  0.225084f,  0.228072f,  0.231058f,  0.234042f,  0.237024f,  0.240003f,
	 0.242980f,  0.245955f,  0.248928f,  0.251898f,  0.254866f,  0.257831f,  0.260794f,  0.263755f,
	 0.266713f,  0.269668f,  0.272621f,  0.275572f,  0.278520f,  0.281465f,  0.284408f,  0.287347f,
	 0.290285f,  0.293219f,  0.296151f,  0.299080f,  0.302006f,  0.304929f,  0.307850f,  0.310767f,
	 0.313682f,  0.316593f,  0.319502f,  0.322408f,  0.325310f,  0.328210f,  0.331106f,  0.334000f,
	 0.336890f,  0.339777f,  0.342661f,  0.345541f,  0.348419f,  0.351293f,  0.354164f,  0.357031f,
	 0.359895f,  0.362756f,  0.365613f,  0.368467f,  0.371317f,  0.374164f,  0.377007f,  0.379847f,
	 0.382683f,  0.385516f,  0.388345f,  0.391170f,  0.393992f,  0.396810f,  0.399624f,  0.402435f,
	 0.405241f,  0.408044f,  0.410843f,  0.413638f,  0.416430f,  0.419217f,  0.422000f,  0.424780f,
	 0.427555f,  0.430326f,  0.433094f,  0.435857f,  0.438616f,  0.441371f,  0.444122f,  0.446869f,
	 0.449611f,  0.452350f,  0.455084f,  0.457813f,  0.460539f,  0.463260f,  0.465977f,  0.468689f,
	 0.471397f,  0.474100f,  0.476799f,  0.479494f,  0.482184f,  0.484869f,  0.487550f,  0.490226f,
	 0.492898f,  0.495565f,  0.498228f,  0.500885f,  0.503538f,  0.506187f,  0.508830f,  0.511469f,
	 0.514103f,  0.516732f,  0.519356f,  0.521975f,  0.524590f,  0.527199f,  0.529804f,  0.532403f,
	 0.534998f,  0.537587f,  0.540171f,  0.542751f,  0.545325f,  0.547894f,  0.550458f,  0.553017f,
	 0.555570f,  0.558119f,  0.560662f,  0.563199f,  0.565732f,  0.568259f,  0.570781f,  0.573297f,
	 0.575808f,  0.578314f,  0.580814f,  0.583309f,  0.585798f,  0.588282f,  0.590760f,  0.593232f,
	 0.595699f,  0.598161f,  0.600616f,  0.603067f,  0.605511f,  0.607950f,  0.610383f,  0.612810f,
	 0.615232f,  0.617647f,  0.620057f,  0.622461f,  0.624860f,  0.627252f,  0.629638f,  0.632019f,
	 0.634393f,  0.636762f,  0.639124f,  0.641481f,  0.643832f,  0.646176f,  0.648514f,  0.650847f,
	 0.653173f,  0.655493f,  0.657807f,  0.660114f,  0.662416f,  0.664711f,  0.667000f,  0.669283f,
	 0.671559f,  0.673829f,  0.676093f,  0.678350f,  0.680601f,  0.682846f,  0.685084f,  0.687315f,
	 0.689541f,  0.691759f,  0.693971f,  0.696177f,  0.698376f,  0.700569f,  0.702755f,  0.704934f,
	 0.707107f,  0.709273f,  0.711432f,  0.713585f,  0.715731f,  0.717870f,  0.720003f,  0.722128f,
	 0.724247f,  0.726359f,  0.728464f,  0.730563f,  0.732654f,  0.734739f,  0.736817f,  0.738887f,
	 0.740951f,  0.743008f,  0.745058f,  0.747101f,  0.749136f,  0.751165f,  0.753187f,  0.755201f,
	 0.757209f,  0.759209f,  0.761202f,  0.763188f,  0.765167f,  0.767139f,  0.769103f,  0.771061f,
	 0.773010f,  0.774953f,  0.776888f,  0.778817f,  0.780737f,  0.782651f,  0.784557f,  0.786455f,
	 0.788346f,  0.790230f,  0.792107f,  0.793975f,  0.795837f,  0.797691f,  0.799537f,  0.801376f,
	 0.803208f,  0.805031f,  0.806848f,  0.808656f,  0.810457f,  0.812251f,  0.814036f,  0.815814f,
	 0.817585f,  0.819348f,  0.821102f,  0.822850f,  0.824589f,  0.826321f,  0.828045f,  0.829761f,
	 0.831470f,  0.833170f,  0.834863f,  0.836548f,  0.838225f,  0.839894f,  0.841555f,  0.843208f,
	 0.844854f,  0.846491f,  0.848120f,  0.849742f,  0.851355f,  0.852961f,  0.854558f,  0.856147f,
	 0.857729f,  0.859302f,  0.860867f,  0.862424f,  0.863973f,  0.865514f,  0.867046f,  0.868571f,
	 0.870087f,  0.871595f,  0.873095f,  0.874587f,  0.876070f,  0.877545f,  0.879012f,  0.880471f,
	 0.881921f,  0.883363f,  0.884797f,  0.886223f,  0.887640f,  0.889048f,  0.890449f,  0.891841f,
	 0.893224f,  0.894599f,  0.895966f,  0.897325f,  0.898674f,  0.900016f,  0.901349f,  0.902673f,
	 0.903989f,  0.905297f,  0.906596f,  0.907886f,  0.909168f,  0.910441f,  0.911706f,  0.912962f,
	 0.914210f,  0.915449f,  0.916679f,  0.917901f,  0.919114f,  0.920318f,  0.921514f,  0.922701f,
	 0.923880f,  0.925049f,  0.926210f,  0.927363f,  0.928506f,  0.929641f,  0.930767f,  0.931884f,
	 0.932993f,  0.934093f,  0.935184f,  0.936266f,  0.937339f,  0.938404f,  0.939459f,  0.940506f,
	 0.941544f,  0.942573f,  0.943593f,  0.944605f,  0.945607f,  0.946601f,  0.947586f,  0.948561f,
	 0.949528f,  0.950486f,  0.951435f,  0.952375f,  0.953306f,  0.954228f,  0.955141f,  0.956045f,
	 0.956940f,  0.957826f,  0.958703f,  0.959572f,  0.960431f,  0.961280f,  0.962121f,  0.962953f,
	 0.963776f,  0.964590f,  0.965394f,  0.966190f,  0.966976f,  0.967754f,  0.968522f,  0.969281f,
	 0.970031f,  0.970772f,  0.971504f,  0.972227f,  0.972940f,  0.973644f,  0.974339f,  0.975025f,
	 0.975702f,  0.976370f,  0.977028f,  0.977677f,  0.978317f,  0.978948f,  0.979570f,  0.980182f,
	 0.980785f,  0.981379f,  0.981964f,  0.982539f,  0.983105f,  0.983662f,  0.984210f,  0.984748f,
	 0.985278f,  0.985798f,  0.986308f,  0.986809f,  0.987301f,  0.987784f,  0.988258f,  0.988722f,
	 0.989177f,  0.989622f,  0.990058f,  0.990485f,  0.990903f,  0.991311f,  0.991710f,  0.992099f,
	 0.992480f,  0.992850f,  0.993212f,  0.993564f,  0.993907f,  0.994240f,  0.994565f,  0.994879f,
	 0.995185f,  0.995481f,  0.995767f,  0.996045f,  0.996313f,  0.996571f,  0.996820f,  0.997060f,
	 0.997290f,  0.997511f,  0.997723f,  0.997925f,  0.998118f,  0.998302f,  0.998476f,  0.998640f,
	 0.998795f,  0.998941f,  0.999078f,  0.999205f,  0.999322f,  0.999431f,  0.999529f,  0.999619f,
	 0.999699f,  0.999769f,  0.999831f,  0.999882f,  0.999925f,  0.999958f,  0.999981f,  0.999995f,
	 0.000000f, -0.003068f, -0.006136f, -0.009204f, -0.012272f, -0.015339f, -0.018407f, -0.021474f,
	-0.024541f, -0.027608f, -0.030675f, -0.033741f, -0.036807f, -0.039873f, -0.042938f, -0.046003f,
	-0.049068f, -0.052132f, -0.055195f, -0.058258f, -0.061321f, -0.064383f, -0.067444f, -0.070505f,
	-0.073565f, -0.076624f, -0.079682f, -0.082740f, -0.085797f, -0.088854f, -0.091909f, -0.094963f,
	-0.098017f, -0.101070f, -0.104122f, -0.107172f, -0.110222f, -0.113271f, -0.116319f, -0.119365f,
	-0.122411f, -0.125455f, -0.128498f, -0.131540f, -0.134581f, -0.137620f, -0.140658f, -0.143695f,
	-0.146730f, -0.149765f, -0.152797f, -0.155828f, -0.158858f, -0.161886f, -0.164913f, -0.167938f,
	-0.170962f, -0.173984f, -0.177004f, -0.180023f, -0.183040f, -0.186055f, -0.189069f, -0.192080f,
	-0.195090f, -0.198098f, -0.201105f, -0.204109f, -0.207111f, -0.210112f, -0.213110f, -0.216107f,
	-0.219101f, -0.222094f, -0.225084f, -0.228072f, -0.231058f, -0.234042f, -0.237024f, -0.240003f,
	-0.242980f, -0.245955f, -0.248928f, -0.251898f, -0.254866f, -0.257831f, -0.260794f, -0.263755f,
	-0.266713f, -0.269668f, -0.272621f, -0.275572f, -0.278520f, -0.281465f, -0.284408f, -0.287347f,
	-0.290285f, -0.293219f, -0.296151f, -0.299080f, -0.302006f, -0.304929f, -0.307850f, -0.310767f,
	-0.313682f, -0.316593f, -0.319502f, -0.322408f, -0.325310f, -0.328210f, -0.331106f, -0.334000f,
	-0.336890f, -0.339777f, -0.342661f, -0.345541f, -0.348419f, -0.351293f, -0.354164f, -0.357031f,
	-0.359895f, -0.362756f, -0.365613f, -0.368467f, -0.371317f, -0.374164f, -0.377007f, -0.379847f,
	-0.382683f, -0.385516f, -0.388345f, -0.391170f, -0.393992f, -0.396810f, -0.399624f, -0.402435f,
	-0.405241f, -0.408044f, -0.410843f, -0.413638f, -0.416430f, -0.419217f, -0.422000f, -0.424780f,
	-0.427555f, -0.430326f, -0.433094f, -0.435857f, -0.438616f, -0.441371f, -0.444122f, -0.446869f,
	-0.449611f, -0.452350f, -0.455084f, -0.457813f, -0.460539f, -0.463260f, -0.465977f, -0.468689f,
	-0.471397f, -0.474100f, -0.476799f, -0.479494f, -0.482184f, -0.484869f, -0.487550f, -0.490226f,
	-0.492898f, -0.495565f, -0.498228f, -0.500885f, -0.503538f, -0.506187f, -0.508830f, -0.511469f,
	-0.514103f, -0.516732f, -0.519356f, -0.521975f, -0.524590f, -0.527199f, -0.529804f, -0.532403f,
	-0.534998f, -0.537587f, -0.540171f, -0.542751f, -0.545325f, -0.547894f, -0.550458f, -0.553017f,
	-0.555570f, -0.558119f, -0.560662f, -0.563199f, -0.565732f, -0.568259f, -0.570781f, -0.573297f,
	-0.575808f, -0.578314f, -0.580814f, -0.583309f, -0.585798f, -0.588282f, -0.590760f, -0.593232f,
	-0.595699f, -0.598161f, -0.600616f, -0.603067f, -0.605511f, -0.607950f, -0.610383f, -0.612810f,
	-0.615232f, -0.617647f, -0.620057f, -0.622461f, -0.624860f, -0.627252f, -0.629638f, -0.632019f,
	-0.634393f, -0.636762f, -0.639124f, -0.641481f, -0.643832f, -0.646176f, -0.648514f, -0.650847f,
	-0.653173f, -0.655493f, -0.657807f, -0.660114f, -0.662416f, -0.664711f, -0.667000f, -0.669283f,
	-0.671559f, -0.673829f, -0.676093f, -0.678350f, -0.680601f, -0.682846f, -0.685084f, -0.687315f,
	-0.689541f, -0.691759f, -0.693971f, -0.696177f, -0.698376f, -0.700569f, -0.702755f, -0.704934f,
	-0.707107f, -0.709273f, -0.711432f, -0.713585f, -0.715731f, -0.717870f, -0.720003f, -0.722128f,
	-0.724247f, -0.726359f, -0.728464f, -0.730563f, -0.732654f, -0.734739f, -0.736817f, -0.738887f,
	-0.740951f, -0.743008f, -0.745058f, -0.747101f, -0.749136f, -0.751165f, -0.753187f, -0.755201f,
	-0.757209f, -0.759209f, -0.761202f, -0.763188f, -0.765167f, -0.767139f, -0.769103f, -0.771061f,
	-0.773010f, -0.774953f, -0.776888f, -0.778817f, -0.780737f, -0.782651f, -0.784557f, -0.786455f,
	-0.788346f, -0.790230f, -0.792107f, -0.793975f, -0.795837f, -0.797691f, -0.799537f, -0.801376f,
	-0.803208f, -0.805031f, -0.806848f, -0.808656f, -0.810457f, -0.812251f, -0.814036f, -0.815814f,
	-0.817585f, -0.819348f, -0.821102f, -0.822850f, -0.824589f, -0.826321f, -0.828045f, -0.829761f,
	-0.831470f, -0.833170f, -0.834863f, -0.836548f, -0.838225f, -0.839894f, -0.841555f, -0.843208f,
	-0.844854f, -0.846491f, -0.848120f, -0.849742f, -0.851355f, -0.852961f, -0.854558f, -0.856147f,
	-0.857729f, -0.859302f, -0.860867f, -0.862424f, -0.863973f, -0.865514f, -0.867046f, -0.868571f,
	-0.870087f, -0.871595f, -0.873095f, -0.874587f, -0.876070f, -0.877545f, -0.879012f, -0.880471f,
	-0.881921f, -0.883363f, -0.884797f, -0.886223f, -0.887640f, -0.889048f, -0.890449f, -0.891841f,
	-0.893224f, -0.894599f, -0.895966f, -0.897325f, -0.898674f, -0.900016f, -0.901349f, -0.902673f,
	-0.903989f, -0.905297f, -0.906596f, -0.907886f, -0.909168f, -0.910441f, -0.911706f, -0.912962f,
	-0.914210f, -0.915449f, -0.916679f, -0.917901f, -0.919114f, -0.920318f, -0.921514f, -0.922701f,
	-0.923880f, -0.925049f, -0.926210f, -0.927363f, -0.928506f, -0.929641f, -0.930767f, -0.931884f,
	-0.932993f, -0.934093f, -0.935184f, -0.936266f, -0.937339f, -0.938404f, -0.939459f, -0.940506f,
	-0.941544f, -0.942573f, -0.943593f, -0.944605f, -0.945607f, -0.946601f, -0.947586f, -0.948561f,
	-0.949528f, -0.950486f, -0.951435f, -0.952375f, -0.953306f, -0.954228f, -0.955141f, -0.956045f,
	-0.956940f, -0.957826f, -0.958703f, -0.959572f, -0.960431f, -0.961280f, -0.962121f, -0.962953f,
	-0.963776f, -0.964590f, -0.965394f, -0.966190f, -0.966976f, -0.967754f, -0.968522f, -0.969281f,
	-0.970031f, -0.970772f, -0.971504f, -0.972227f, -0.972940f, -0.973644f, -0.974339f, -0.975025f,
	-0.975702f, -0.976370f, -0.977028f, -0.977677f, -0.978317f, -0.978948f, -0.979570f, -0.980182f,
	-0.980785f, -0.981379f, -0.981964f, -0.982539f, -0.983105f, -0.983662f, -0.984210f, -0.984748f,
	-0.985278f, -0.985798f, -0.986308f, -0.986809f, -0.987301f, -0.987784f, -0.988258f, -0.988722f,
	-0.989177f, -0.989622f, -0.990058f, -0.990485f, -0.990903f, -0.991311f, -0.991710f, -0.992099f,
	-0.992480f, -0.992850f, -0.993212f, -0.993564f, -0.993907f, -0.994240f, -0.994565f, -0.994879f,
	-0.995185f, -0.995481f, -0.995767f, -0.996045f, -0.996313f, -0.996571f, -0.996820f, -0.997060f,
	-0.997290f, -0.997511f, -0.997723f, -0.997925f, -0.998118f, -0.998302f, -0.998476f, -0.998640f,
	-0.998795f, -0.998941f, -0.999078f, -0.999205f, -0.999322f, -0.999431f, -0.999529f, -0.999619f,
	-0.999699f, -0.999769f, -0.999831f, -0.999882f, -0.999925f, -0.999958f, -0.999981f, -0.999995f
};

static const float sinTable4096[2048] = {
	 0.000000f,  0.001534f,  0.003068f,  0.004602f,  0.006136f,  0.007670f,  0.009204f,  0.010738f,
	 0.012272f,  0.013805f,  0.015339f,  0.016873f,  0.018407f,  0.019940f,  0.021474f,  0.023008f,
	 0.024541f,  0.026075f,  0.027608f,  0.029142f,  0.030675f,  0.032208f,  0.033741f,  0.035274f,
	 0.036807f,  0.038340f,  0.039873f,  0.041406f,  0.042938f,  0.044471f,  0.046003f,  0.047535f,
	 0.049068f,  0.050600f,  0.052132f,  0.053664f,  0.055195f,  0.056727f,  0.058258f,  0.059790f,
	 0.061321f,  0.062852f,  0.064383f,  0.065913f,  0.067444f,  0.068974f,  0.070505f,  0.072035f,
	 0.073565f,  0.075094f,  0.076624f,  0.078153f,  0.079682f,  0.081211f,  0.082740f,  0.084269f,
	 0.085797f,  0.087326f,  0.088854f,  0.090381f,  0.091909f,  0.093436f,  0.094963f,  0.096490f,
	 0.098017f,  0.099544f,  0.101070f,  0.102596f,  0.104122f,  0.105647f,  0.107172f,  0.108697f,
	 0.110222f,  0.111747f,  0.113271f,  0.114795f,  0.116319f,  0.117842f,  0.119365f,  0.120888f,
	 0.122411f,  0.123933f,  0.125455f,  0.126977f,  0.128498f,  0.130019f,  0.131540f,  0.133061f,
	 0.134581f,  0.136101f,  0.137620f,  0.139139f,  0.140658f,  0.142177f,  0.143695f,  0.145213f,
	 0.146730f,  0.148248f,  0.149765f,  0.151281f,  0.152797f,  0.154313f,  0.155828f,  0.157343f,
	 0.158858f,  0.160372f,  0.161886f,  0.163400f,  0.164913f,  0.166426f,  0.167938f,  0.169450f,
	 0.170962f,  0.172473f,  0.173984f,  0.175494f,  0.177004f,  0.178514f,  0.180023f,  0.181532f,
	 0.183040f,  0.184548f,  0.186055f,  0.187562f,  0.189069f,  0.190575f,  0.192080f,  0.193586f,
	 0.195090f,  0.196595f,  0.198098f,  0.199602f,  0.201105f,  0.202607f,  0.204109f,  0.205610f,
	 0.207111f,  0.208612f,  0.210112f,  0.211611f,  0.213110f,  0.214609f,  0.216107f,  0.217604f,
	 0.219101f,  0.220598f,  0.222094f,  0.223589f,  0.225084f,  0.226578f,  0.228072f,  0.229565f,
	 0.231058f,  0.232550f,  0.234042f,  0.235533f,  0.237024f,  0.238514f,  0.240003f,  0.241492f,
	 0.242980f,  0.244468f,  0.245955f,  0.247442f,  0.248928f,  0.250413f,  0.251898f,  0.253382f,
	 0.254866f,  0.256349f,  0.257831f,  0.259313f,  0.260794f,  0.262275f,  0.263755f,  0.265234f,
	 0.266713f,  0.268191f,  0.269668f,  0.271145f,  0.272621f,  0.274097f,  0.275572f,  0.277046f,
	 0.278520f,  0.279993f,  0.281465f,  0.282937f,  0.284408f,  0.285878f,  0.287347f,  0.288816f,
	 0.290285f,  0.291752f,  0.293219f,  0.294685f,  0.296151f,  0.297616f,  0.299080f,  0.300543f,
	 0.302006f,  0.303468f,  0.304929f,  0.306390f,  0.307850f,  0.309309f,  0.310767f,  0.312225f,
	 0.313682f,  0.315138f,  0.316593f,  0.318048f,  0.319502f,  0.320955f,  0.322408f,  0.323859f,
	 0.325310f,  0.326760f,  0.328210f,  0.329658f,  0.331106f,  0.332553f,  0.334000f,  0.335445f,
	 0.336890f,  0.338334f,  0.339777f,  0.341219f,  0.342661f,  0.344101f,  0.345541f,  0.346980f,
	 0.348419f,  0.349856f,  0.351293f,  0.352729f,  0.354164f,  0.355598f,  0.357031f,  0.358463f,
	 0.359895f,  0.361326f,  0.362756f,  0.364185f,  0.365613f,  0.367040f,  0.368467f,  0.369892f,
	 0.371317f,  0.372741f,  0.374164f,  0.375586f,  0.377007f,  0.378428f,  0.379847f,  0.381266f,
	 0.382683f,  0.384100f,  0.385516f,  0.386931f,  0.388345f,  0.389758f,  0.391170f,  0.392582f,
	 0.393992f,  0.395401f,  0.396810f,  0.398218f,  0.399624f,  0.401030f,  0.402435f,  0.403838f,
	 0.405241f,  0.406643f,  0.408044f,  0.409444f,  0.410843f,  0.412241f,  0.413638f,  0.415034f,
	 0.416430f,  0.417824f,  0.419217f,  0.420609f,  0.422000f,  0.423390f,  0.424780f,  0.426168f,
	 0.427555f,  0.428941f,  0.430326f,  0.431711f,  0.433094f,  0.434476f,  0.435857f,  0.437237f,
	 0.438616f,  0.439994f,  0.441371f,  0.442747f,  0.444122f,  0.445496f,  0.446869f,  0.448241f,
	 0.449611f,  0.450981f,  0.452350f,  0.453717f,  0.455084f,  0.456449f,  0.457813f,  0.459177f,
	 0.460539f,  0.461900f,  0.463260f,  0.464619f,  0.465977f,  0.467333f,  0.468689f,  0.470043f,
	 0.471397f,  0.472749f,  0.474100f,  0.475450f,  0.476799f,  0.478147f,  0.479494f,  0.480839f,
	 0.482184f,  0.483527f,  0.484869f,  0.486210f,  0.487550f,  0.488889f,  0.490226f,  0.491563f,
	 0.492898f,  0.494232f,  0.495565f,  0.496897f,  0.498228f,  0.499557f,  0.500885f,  0.502212f,
	 0.503538f,  0.504863f,  0.506187f,  0.507509f,  0.508830f,  0.510150f,  0.511469f,  0.512786f,
	 0.514103f,  0.515418f,  0.516732f,  0.518045f,  0.519356f,  0.520666f,  0.521975f,  0.523283f,
	 0.524590f,  0.525895f,  0.527199f,  0.528502f,  0.529804f,  0.531104f,  0.532403f,  0.533701f,
	 0.534998f,  0.536293f,  0.537587f,  0.538880f,  0.540171f,  0.541462f,  0.542751f,  0.544039f,
	 0.545325f,  0.546610f,  0.547894f,  0.549177f,  0.550458f,  0.551738f,  0.553017f,  0.554294f,
	 0.555570f,  0.556845f,  0.558119f,  0.559391f,  0.560662f,  0.561931f,  0.563199f,  0.564466f,
	 0.565732f,  0.566996f,  0.568259f,  0.569521f,  0.570781f,  0.572040f,  0.573297f,  0.574553f,
	 0.575808f,  0.577062f,  0.578314f,  0.579565f,  0.580814f,  0.582062f,  0.583309f,  0.584554f,
	 0.585798f,  0.587040f,  0.588282f,  0.589521f,  0.590760f,  0.591997f,  0.593232f,  0.594467f,
	 0.595699f,  0.596931f,  0.598161f,  0.599389f,  0.600616f,  0.601842f,  0.603067f,  0.604290f,
	 0.605511f,  0.606731f,  0.607950f,  0.609167f,  0.610383f,  0.611597f,  0.612810f,  0.614022f,
	 0.615232f,  0.616440f,  0.617647f,  0.618853f,  0.620057f,  0.621260f,  0.622461f,  0.623661f,
	 0.624860f,  0.626056f,  0.627252f,  0.628446f,  0.629638f,  0.630829f,  0.632019f,  0.633207f,
	 0.634393f,  0.635578f,  0.636762f,  0.637944f,  0.639124f,  0.640303f,  0.641481f,  0.642657f,
	 0.643832f,  0.645005f,  0.646176f,  0.647346f,  0.648514f,  0.649681f,  0.650847f,  0.652011f,
	 0.653173f,  0.654334f,  0.655493f,  0.656651f,  0.657807f,  0.658961f,  0.660114f,  0.661266f,
	 0.662416f,  0.663564f,  0.664711f,  0.665856f,  0.667000f,  0.668142f,  0.669283f,  0.670422f,
	 0.671559f,  0.672695f,  0.673829f,  0.674962f,  0.676093f,  0.677222f,  0.678350f,  0.679476f,
	 0.680601f,  0.681724f,  0.682846f,  0.683965f,  0.685084f,  0.686200f,  0.687315f,  0.688429f,
	 0.689541f,  0.690651f,  0.691759f,  0.692866f,  0.693971f,  0.695075f,  0.696177f,  0.697277f,
	 0.698376f,  0.699473f,  0.700569f,  0.701663f,  0.702755f,  0.703845f,  0.704934f,  0.706021f,
	 0.707107f,  0.708191f,  0.709273f,  0.710353f,  0.711432f,  0.712509f,  0.713585f,  0.714659f,
	 0.715731f,  0.716801f,  0.717870f,  0.718937f,  0.720003f,  0.721066f,  0.722128f,  0.723188f,
	 0.724247f,  0.725304f,  0.726359f,  0.727413f,  0.728464f,  0.729514f,  0.730563f,  0.731609f,
	 0.732654f,  0.733697f,  0.734739f,  0.735779f,  0.736817f,  0.737853f,  0.738887f,  0.739920f,
	 0.740951f,  0.741980f,  0.743008f,  0.744034f,  0.745058f,  0.746080f,  0.747101f,  0.748119f,
	 0.749136f,  0.750152f,  0.751165f,  0.752177f,  0.753187f,  0.754195f,  0.755201f,  0.756206f,
	 0.757209f,  0.758210f,  0.759209f,  0.760207f,  0.761202f,  0.762196f,  0.763188f,  0.764179f,
	 0.765167f,  0.766154f,  0.767139f,  0.768122f,  0.769103f,  0.770083f,  0.771061f,  0.772036f,
	 0.773010f,  0.773983f,  0.774953f,  0.775922f,  0.776888f,  0.777853f,  0.778817f,  0.779778f,
	 0.780737f,  0.781695f,  0.782651f,  0.783605f,  0.784557f,  0.785507f,  0.786455f,  0.787402f,
	 0.788346f,  0.789289f,  0.790230f,  0.791169f,  0.792107f,  0.793042f,  0.793975f,  0.794907f,
	 0.795837f,  0.796765f,  0.797691f,  0.798615f,  0.799537f,  0.800458f,  0.801376f,  0.802293f,
	 0.803208f,  0.804120f,  0.805031f,  0.805940f,  0.806848f,  0.807753f,  0.808656f,  0.809558f,
	 0.810457f,  0.811355f,  0.812251f,  0.813144f,  0.814036f,  0.814926f,  0.815814f,  0.816701f,
	 0.817585f,  0.818467f,  0.819348f,  0.820226f,  0.821102f,  0.821977f,  0.822850f,  0.823721f,
	 0.824589f,  0.825456f,  0.826321f,  0.827184f,  0.828045f,  0.828904f,  0.829761f,  0.830616f,
	 0.831470f,  0.832321f,  0.833170f,  0.834018f,  0.834863f,  0.835706f,  0.836548f,  0.837387f,
	 0.838225f,  0.839060f,  0.839894f,  0.840725f,  0.841555f,  0.842383f,  0.843208f,  0.844032f,
	 0.844854f,  0.845673f,  0.846491f,  0.847307f,  0.848120f,  0.848932f,  0.849742f,  0.850549f,
	 0.851355f,  0.852159f,  0.852961f,  0.853760f,  0.854558f,  0.855354f,  0.856147f,  0.856939f,
	 0.857729f,  0.858516f,  0.859302f,  0.860085f,  0.860867f,  0.861646f,  0.862424f,  0.863199f,
	 0.863973f,  0.864744f,  0.865514f,  0.866281f,  0.867046f,  0.867809f,  0.868571f,  0.869330f,
	 0.870087f,  0.870842f,  0.871595f,  0.872346f,  0.873095f,  0.873842f,  0.874587f,  0.875329f,
	 0.876070f,  0.876809f,  0.877545f,  0.878280f,  0.879012f,  0.879743f,  0.880471f,  0.881197f,
	 0.881921f,  0.882643f,  0.883363f,  0.884081f,  0.884797f,  0.885511f,  0.886223f,  0.886932f,
	 0.887640f,  0.888345f,  0.889048f,  0.889750f,  0.890449f,  0.891146f,  0.891841f,  0.892534f,
	 0.893224f,  0.893913f,  0.894599f,  0.895284f,  0.895966f,  0.896646f,  0.897325f,  0.898001f,
	 0.898674f,  0.899346f,  0.900016f,  0.900683f,  0.901349f,  0.902012f,  0.902673f,  0.903332f,
	 0.903989f,  0.904644f,  0.905297f,  0.905947f,  0.906596f,  0.907242f,  0.907886f,  0.908528f,
	 0.909168f,  0.909806f,  0.910441f,  0.911075f,  0.911706f,  0.912335f,  0.912962f,  0.913587f,
	 0.914210f,  0.914830f,  0.915449f,  0.916065f,  0.916679f,  0.917291f,  0.917901f,  0.918508f,
	 0.919114f,  0.919717f,  0.920318f,  0.920917f,  0.921514f,  0.922109f,  0.922701f,  0.923291f,
	 0.923880f,  0.924465f,  0.925049f,  0.925631f,  0.926210f,  0.926787f,  0.927363f,  0.927935f,
	 0.928506f,  0.929075f,  0.929641f,  0.930205f,  0.930767f,  0.931327f,  0.931884f,  0.932440f,
	 0.932993f,  0.933544f,  0.934093f,  0.934639f,  0.935184f,  0.935726f,  0.936266f,  0.936803f,
	 0.937339f,  0.937872f,  0.938404f,  0.938932f,  0.939459f,  0.939984f,  0.940506f,  0.941026f,
	 0.941544f,  0.942060f,  0.942573f,  0.943084f,  0.943593f,  0.944100f,  0.944605f,  0.945107f,
	 0.945607f,  0.946105f,  0.946601f,  0.947094f,  0.947586f,  0.948075f,  0.948561f,  0.949046f,
	 0.949528f,  0.950008f,  0.950486f,  0.950962f,  0.951435f,  0.951906f,  0.952375f,  0.952842f,
	 0.953306f,  0.953768f,  0.954228f,  0.954686f,  0.955141f,  0.955594f,  0.956045f,  0.956494f,
	 0.956940f,  0.957385f,  0.957826f,  0.958266f,  0.958703f,  0.959139f,  0.959572f,  0.960002f,
	 0.960431f,  0.960857f,  0.961280f,  0.961702f,  0.962121f,  0.962538f,  0.962953f,  0.963366f,
	 0.963776f,  0.964184f,  0.964590f,  0.964993f,  0.965394f,  0.965793f,  0.966190f,  0.966584f,
	 0.966976f,  0.967366f,  0.967754f,  0.968139f,  0.968522f,  0.968903f,  0.969281f,  0.969657f,
	 0.970031f,  0.970403f,  0.970772f,  0.971139f,  0.971504f,  0.971866f,  0.972227f,  0.972584f,
	 0.972940f,  0.973293f,  0.973644f,  0.973993f,  0.974339f,  0.974684f,  0.975025f,  0.975365f,
	 0.975702f,  0.976037f,  0.976370f,  0.976700f,  0.977028f,  0.977354f,  0.977677f,  0.977998f,
	 0.978317f,  0.978634f,  0.978948f,  0.979260f,  0.979570f,  0.979877f,  0.980182f,  0.980485f,
	 0.980785f,  0.981083f,  0.981379f,  0.981673f,  0.981964f,  0.982253f,  0.982539f,  0.982824f,
	 0.983105f,  0.983385f,  0.983662f,  0.983937f,  0.984210f,  0.984480f,  0.984748f,  0.985014f,
	 0.985278f,  0.985539f,  0.985798f,  0.986054f,  0.986308f,  0.986560f,  0.986809f,  0.987057f,
	 0.987301f,  0.987544f,  0.987784f,  0.988022f,  0.988258f,  0.988491f,  0.988722f,  0.988950f,
	 0.989177f,  0.989400f,  0.989622f,  0.989841f,  0.990058f,  0.990273f,  0.990485f,  0.990695f,
	 0.990903f,  0.991108f,  0.991311f,  0.991511f,  0.991710f,  0.991906f,  0.992099f,  0.992291f,
	 0.992480f,  0.992666f,  0.992850f,  0.993032f,  0.993212f,  0.993389f,  0.993564f,  0.993737f,
	 0.993907f,  0.994075f,  0.994240f,  0.994404f,  0.994565f,  0.994723f,  0.994879f,  0.995033f,
	 0.995185f,  0.995334f,  0.995481f,  0.995625f,  0.995767f,  0.995907f,  0.996045f,  0.996180f,
	 0.996313f,  0.996443f,  0.996571f,  0.996697f,  0.996820f,  0.996941f,  0.997060f,  0.997176f,
	 0.997290f,  0.997402f,  0.997511f,  0.997618f,  0.997723f,  0.997825f,  0.997925f,  0.998023f,
	 0.998118f,  0.998211f,  0.998302f,  0.998390f,  0.998476f,  0.998559f,  0.998640f,  0.998719f,
	 0.998795f,  0.998870f,  0.998941f,  0.999011f,  0.999078f,  0.999142f,  0.999205f,  0.999265f,
	 0.999322f,  0.999378f,  0.999431f,  0.999481f,  0.999529f,  0.999575f,  0.999619f,  0.999660f,
	 0.999699f,  0.999735f,  0.999769f,  0.999801f,  0.999831f,  0.999858f,  0.999882f,  0.999905f,
	 0.999925f,  0.999942f,  0.999958f,  0.999971f,  0.999981f,  0.999989f,  0.999995f,  0.999999f,
	 0.000000f, -0.001534f, -0.003068f, -0.004602f, -0.006136f, -0.007670f, -0.009204f, -0.010738f,
	-0.012272f, -0.013805f, -0.015339f, -0.016873f, -0.018407f, -0.019940f, -0.021474f, -0.023008f,
	-0.024541f, -0.026075f, -0.027608f, -0.029142f, -0.030675f, -0.032208f, -0.033741f, -0.035274f,
	-0.036807f, -0.038340f, -0.039873f, -0.041406f, -0.042938f, -0.044471f, -0.046003f, -0.047535f,
	-0.049068f, -0.050600f, -0.052132f, -0.053664f, -0.055195f, -0.056727f, -0.058258f, -0.059790f,
	-0.061321f, -0.062852f, -0.064383f, -0.065913f, -0.067444f, -0.068974f, -0.070505f, -0.072035f,
	-0.073565f, -0.075094f, -0.076624f, -0.078153f, -0.079682f, -0.081211f, -0.082740f, -0.084269f,
	-0.085797f, -0.087326f, -0.088854f, -0.090381f, -0.091909f, -0.093436f, -0.094963f, -0.096490f,
	-0.098017f, -0.099544f, -0.101070f, -0.102596f, -0.104122f, -0.105647f, -0.107172f, -0.108697f,
	-0.110222f, -0.111747f, -0.113271f, -0.114795f, -0.116319f, -0.117842f, -0.119365f, -0.120888f,
	-0.122411f, -0.123933f, -0.125455f, -0.126977f, -0.128498f, -0.130019f, -0.131540f, -0.133061f,
	-0.134581f, -0.136101f, -0.137620f, -0.139139f, -0.140658f, -0.142177f, -0.143695f, -0.145213f,
	-0.146730f, -0.148248f, -0.149765f, -0.151281f, -0.152797f, -0.154313f, -0.155828f, -0.157343f,
	-0.158858f, -0.160372f, -0.161886f, -0.163400f, -0.164913f, -0.166426f, -0.167938f, -0.169450f,
	-0.170962f, -0.172473f, -0.173984f, -0.175494f, -0.177004f, -0.178514f, -0.180023f, -0.181532f,
	-0.183040f, -0.184548f, -0.186055f, -0.187562f, -0.189069f, -0.190575f, -0.192080f, -0.193586f,
	-0.195090f, -0.196595f, -0.198098f, -0.199602f, -0.201105f, -0.202607f, -0.204109f, -0.205610f,
	-0.207111f, -0.208612f, -0.210112f, -0.211611f, -0.213110f, -0.214609f, -0.216107f, -0.217604f,
	-0.219101f, -0.220598f, -0.222094f, -0.223589f, -0.225084f, -0.226578f, -0.228072f, -0.229565f,
	-0.231058f, -0.232550f, -0.234042f, -0.235533f, -0.237024f, -0.238514f, -0.240003f, -0.241492f,
	-0.242980f, -0.244468f, -0.245955f, -0.247442f, -0.248928f, -0.250413f, -0.251898f, -0.253382f,
	-0.254866f, -0.256349f, -0.257831f, -0.259313f, -0.260794f, -0.262275f, -0.263755f, -0.265234f,
	-0.266713f, -0.268191f, -0.269668f, -0.271145f, -0.272621f, -0.274097f, -0.275572f, -0.277046f,
	-0.278520f, -0.279993f, -0.281465f, -0.282937f, -0.284408f, -0.285878f, -0.287347f, -0.288816f,
	-0.290285f, -0.291752f, -0.293219f, -0.294685f, -0.296151f, -0.297616f, -0.299080f, -0.300543f,
	-0.302006f, -0.303468f, -0.304929f, -0.306390f, -0.307850f, -0.309309f, -0.310767f, -0.312225f,
	-0.313682f, -0.315138f, -0.316593f, -0.318048f, -0.319502f, -0.320955f, -0.322408f, -0.323859f,
	-0.325310f, -0.326760f, -0.328210f, -0.329658f, -0.331106f, -0.332553f, -0.334000f, -0.335445f,
	-0.336890f, -0.338334f, -0.339777f, -0.341219f, -0.342661f, -0.344101f, -0.345541f, -0.346980f,
	-0.348419f, -0.349856f, -0.351293f, -0.352729f, -0.354164f, -0.355598f, -0.357031f, -0.358463f,
	-0.359895f, -0.361326f, -0.362756f, -0.364185f, -0.365613f, -0.367040f, -0.368467f, -0.369892f,
	-0.371317f, -0.372741f, -0.374164f, -0.375586f, -0.377007f, -0.378428f, -0.379847f, -0.381266f,
	-0.382683f, -0.384100f, -0.385516f, -0.386931f, -0.388345f, -0.389758f, -0.391170f, -0.392582f,
	-0.393992f, -0.395401f, -0.396810f, -0.398218f, -0.399624f, -0.401030f, -0.402435f, -0.403838f,
	-0.405241f, -0.406643f, -0.408044f, -0.409444f, -0.410843f, -0.412241f, -0.413638f, -0.415034f,
	-0.416430f, -0.417824f, -0.419217f, -0.420609f, -0.422000f, -0.423390f, -0.424780f, -0.426168f,
	-0.427555f, -0.428941f, -0.430326f, -0.431711f, -0.433094f, -0.434476f, -0.435857f, -0.437237f,
	-0.438616f, -0.439994f, -0.441371f, -0.442747f, -0.444122f, -0.445496f, -0.446869f, -0.448241f,
	-0.449611f, -0.450981f, -0.452350f, -0.453717f, -0.455084f, -0.456449f, -0.457813f, -0.459177f,
	-0.460539f, -0.461900f, -0.463260f, -0.464619f, -0.465977f, -0.467333f, -0.468689f, -0.470043f,
	-0.471397f, -0.472749f, -0.474100f, -0.475450f, -0.476799f, -0.478147f, -0.479494f, -0.480839f,
	-0.482184f, -0.483527f, -0.484869f, -0.486210f, -0.487550f, -0.488889f, -0.490226f, -0.491563f,
	-0.492898f, -0.494232f, -0.495565f, -0.496897f, -0.498228f, -0.499557f, -0.500885f, -0.502212f,
	-0.503538f, -0.504863f, -0.506187f, -0.507509f, -0.508830f, -0.510150f, -0.511469f, -0.512786f,
	-0.514103f, -0.515418f, -0.516732f, -0.518045f, -0.519356f, -0.520666f, -0.521975f, -0.523283f,
	-0.524590f, -0.525895f, -0.527199f, -0.528502f, -0.529804f, -0.531104f, -0.532403f, -0.533701f,
	-0.534998f, -0.536293f, -0.537587f, -0.538880f, -0.540171f, -0.541462f, -0.542751f, -0.544039f,
	-0.545325f, -0.546610f, -0.547894f, -0.549177f, -0.550458f, -0.551738f, -0.553017f, -0.554294f,
	-0.555570f, -0.556845f, -0.558119f, -0.559391f, -0.560662f, -0.561931f, -0.563199f, -0.564466f,
	-0.565732f, -0.566996f, -0.568259f, -0.569521f, -0.570781f, -0.572040f, -0.573297f, -0.574553f,
	-0.575808f, -0.577062f, -0.578314f, -0.579565f, -0.580814f, -0.582062f, -0.583309f, -0.584554f,
	-0.585798f, -0.587040f, -0.588282f, -0.589521f, -0.590760f, -0.591997f, -0.593232f, -0.594467f,
	-0.595699f, -0.596931f, -0.598161f, -0.599389f, -0.600616f, -0.601842f, -0.603067f, -0.604290f,
	-0.605511f, -0.606731f, -0.607950f, -0.609167f, -0.610383f, -0.611597f, -0.612810f, -0.614022f,
	-0.615232f, -0.616440f, -0.617647f, -0.618853f, -0.620057f, -0.621260f, -0.622461f, -0.623661f,
	-0.624860f, -0.626056f, -0.627252f, -0.628446f, -0.629638f, -0.630829f, -0.632019f, -0.633207f,
	-0.634393f, -0.635578f, -0.636762f, -0.637944f, -0.639124f, -0.640303f, -0.641481f, -0.642657f,
	-0.643832f, -0.645005f, -0.646176f, -0.647346f, -0.648514f, -0.649681f, -0.650847f, -0.652011f,
	-0.653173f, -0.654334f, -0.655493f, -0.656651f, -0.657807f, -0.658961f, -0.660114f, -0.661266f,
	-0.662416f, -0.663564f, -0.664711f, -0.665856f, -0.667000f, -0.668142f, -0.669283f, -0.670422f,
	-0.671559f, -0.672695f, -0.673829f, -0.674962f, -0.676093f, -0.677222f, -0.678350f, -0.679476f,
	-0.680601f, -0.681724f, -0.682846f, -0.683965f, -0.685084f, -0.686200f, -0.687315f, -0.688429f,
	-0.689541f, -0.690651f, -0.691759f, -0.692866f, -0.693971f, -0.695075f, -0.696177f, -0.697277f,
	-0.698376f, -0.699473f, -0.700569f, -0.701663f, -0.702755f, -0.703845f, -0.704934f, -0.706021f,
	-0.707107f, -0.708191f, -0.709273f, -0.710353f, -0.711432f, -0.712509f, -0.713585f, -0.714659f,
	-0.715731f, -0.716801f, -0.717870f, -0.718937f, -0.720003f, -0.721066f, -0.722128f, -0.723188f,
	-0.724247f, -0.725304f, -0.726359f, -0.727413f, -0.728464f, -0.729514f, -0.730563f, -0.731609f,
	-0.732654f, -0.733697f, -0.734739f, -0.735779f, -0.736817f, -0.737853f, -0.738887f, -0.739920f,
	-0.740951f, -0.741980f, -0.743008f, -0.744034f, -0.745058f, -0.746080f, -0.747101f, -0.748119f,
	-0.749136f, -0.750152f, -0.751165f, -0.752177f, -0.753187f, -0.754195f, -0.755201f, -0.756206f,
	-0.757209f, -0.758210f, -0.759209f, -0.760207f, -0.761202f, -0.762196f, -0.763188f, -0.764179f,
	-0.765167f, -0.766154f, -0.767139f, -0.768122f, -0.769103f, -0.770083f, -0.771061f, -0.772036f,
	-0.773010f, -0.773983f, -0.774953f, -0.775922f, -0.776888f, -0.777853f, -0.778817f, -0.779778f,
	-0.780737f, -0.781695f, -0.782651f, -0.783605f, -0.784557f, -0.785507f, -0.786455f, -0.787402f,
	-0.788346f, -0.789289f, -0.790230f, -0.791169f, -0.792107f, -0.793042f, -0.793975f, -0.794907f,
	-0.795837f, -0.796765f, -0.797691f, -0.798615f, -0.799537f, -0.800458f, -0.801376f, -0.802293f,
	-0.803208f, -0.804120f, -0.805031f, -0.805940f, -0.806848f, -0.807753f, -0.808656f, -0.809558f,
	-0.810457f, -0.811355f, -0.812251f, -0.813144f, -0.814036f, -0.814926f, -0.815814f, -0.816701f,
	-0.817585f, -0.818467f, -0.819348f, -0.820226f, -0.821102f, -0.821977f, -0.822850f, -0.823721f,
	-0.824589f, -0.825456f, -0.826321f, -0.827184f, -0.828045f, -0.828904f, -0.829761f, -0.830616f,
	-0.831470f, -0.832321f, -0.833170f, -0.834018f, -0.834863f, -0.835706f, -0.836548f, -0.837387f,
	-0.838225f, -0.839060f, -0.839894f, -0.840725f, -0.841555f, -0.842383f, -0.843208f, -0.844032f,
	-0.844854f, -0.845673f, -0.846491f, -0.847307f, -0.848120f, -0.848932f, -0.849742f, -0.850549f,
	-0.851355f, -0.852159f, -0.852961f, -0.853760f, -0.854558f, -0.855354f, -0.856147f, -0.856939f,
	-0.857729f, -0.858516f, -0.859302f, -0.860085f, -0.860867f, -0.861646f, -0.862424f, -0.863199f,
	-0.863973f, -0.864744f, -0.865514f, -0.866281f, -0.867046f, -0.867809f, -0.868571f, -0.869330f,
	-0.870087f, -0.870842f, -0.871595f, -0.872346f, -0.873095f, -0.873842f, -0.874587f, -0.875329f,
	-0.876070f, -0.876809f, -0.877545f, -0.878280f, -0.879012f, -0.879743f, -0.880471f, -0.881197f,
	-0.881921f, -0.882643f, -0.883363f, -0.884081f, -0.884797f, -0.885511f, -0.886223f, -0.886932f,
	-0.887640f, -0.888345f, -0.889048f, -0.889750f, -0.890449f, -0.891146f, -0.891841f, -0.892534f,
	-0.893224f, -0.893913f, -0.894599f, -0.895284f, -0.895966f, -0.896646f, -0.897325f, -0.898001f,
	-0.898674f, -0.899346f, -0.900016f, -0.900683f, -0.901349f, -0.902012f, -0.902673f, -0.903332f,
	-0.903989f, -0.904644f, -0.905297f, -0.905947f, -0.906596f, -0.907242f, -0.907886f, -0.908528f,
	-0.909168f, -0.909806f, -0.910441f, -0.911075f, -0.911706f, -0.912335f, -0.912962f, -0.913587f,
	-0.914210f, -0.914830f, -0.915449f, -0.916065f, -0.916679f, -0.917291f, -0.917901f, -0.918508f,
	-0.919114f, -0.919717f, -0.920318f, -0.920917f, -0.921514f, -0.922109f, -0.922701f, -0.923291f,
	-0.923880f, -0.924465f, -0.925049f, -0.925631f, -0.926210f, -0.926787f, -0.927363f, -0.927935f,
	-0.928506f, -0.929075f, -0.929641f, -0.930205f, -0.930767f, -0.931327f, -0.931884f, -0.932440f,
	-0.932993f, -0.933544f, -0.934093f, -0.934639f, -0.935184f, -0.935726f, -0.936266f, -0.936803f,
	-0.937339f, -0.937872f, -0.938404f, -0.938932f, -0.939459f, -0.939984f, -0.940506f, -0.941026f,
	-0.941544f, -0.942060f, -0.942573f, -0.943084f, -0.943593f, -0.944100f, -0.944605f, -0.945107f,
	-0.945607f, -0.946105f, -0.946601f, -0.947094f, -0.947586f, -0.948075f, -0.948561f, -0.949046f,
	-0.949528f, -0.950008f, -0.950486f, -0.950962f, -0.951435f, -0.951906f, -0.952375f, -0.952842f,
	-0.953306f, -0.953768f, -0.954228f, -0.954686f, -0.955141f, -0.955594f, -0.956045f, -0.956494f,
	-0.956940f, -0.957385f, -0.957826f, -0.958266f, -0.958703f, -0.959139f, -0.959572f, -0.960002f,
	-0.960431f, -0.960857f, -0.961280f, -0.961702f, -0.962121f, -0.962538f, -0.962953f, -0.963366f,
	-0.963776f, -0.964184f, -0.964590f, -0.964993f, -0.965394f, -0.965793f, -0.966190f, -0.966584f,
	-0.966976f, -0.967366f, -0.967754f, -0.968139f, -0.968522f, -0.968903f, -0.969281f, -0.969657f,
	-0.970031f, -0.970403f, -0.970772f, -0.971139f, -0.971504f, -0.971866f, -0.972227f, -0.972584f,
	-0.972940f, -0.973293f, -0.973644f, -0.973993f, -0.974339f, -0.974684f, -0.975025f, -0.975365f,
	-0.975702f, -0.976037f, -0.976370f, -0.976700f, -0.977028f, -0.977354f, -0.977677f, -0.977998f,
	-0.978317f, -0.978634f, -0.978948f, -0.979260f, -0.979570f, -0.979877f, -0.980182f, -0.980485f,
	-0.980785f, -0.981083f, -0.981379f, -0.981673f, -0.981964f, -0.982253f, -0.982539f, -0.982824f,
	-0.983105f, -0.983385f, -0.983662f, -0.983937f, -0.984210f, -0.984480f, -0.984748f, -0.985014f,
	-0.985278f, -0.985539f, -0.985798f, -0.986054f, -0.986308f, -0.986560f, -0.986809f, -0.987057f,
	-0.987301f, -0.987544f, -0.987784f, -0.988022f, -0.988258f, -0.988491f, -0.988722f, -0.988950f,
	-0.989177f, -0.989400f, -0.989622f, -0.989841f, -0.990058f, -0.990273f, -0.990485f, -0.990695f,
	-0.990903f, -0.991108f, -0.991311f, -0.991511f, -0.991710f, -0.991906f, -0.992099f, -0.992291f,
	-0.992480f, -0.992666f, -0.992850f, -0.993032f, -0.993212f, -0.993389f, -0.993564f, -0.993737f,
	-0.993907f, -0.994075f, -0.994240f, -0.994404f, -0.994565f, -0.994723f, -0.994879f, -0.995033f,
	-0.995185f, -0.995334f, -0.995481f, -0.995625f, -0.995767f, -0.995907f, -0.996045f, -0.996180f,
	-0.996313f, -0.996443f, -0.996571f, -0.996697f, -0.996820f, -0.996941f, -0.997060f, -0.997176f,
	-0.997290f, -0.997402f, -0.997511f, -0.997618f, -0.997723f, -0.997825f, -0.997925f, -0.998023f,
	-0.998118f, -0.998211f, -0.998302f, -0.998390f, -0.998476f, -0.998559f, -0.998640f, -0.998719f,
	-0.998795f, -0.998870f, -0.998941f, -0.999011f, -0.999078f, -0.999142f, -0.999205f, -0.999265f,
	-0.999322f, -0.999378f, -0.999431f, -0.999481f, -0.999529f, -0.999575f, -0.999619f, -0.999660f,
	-0.999699f, -0.999735f, -0.999769f, -0.999801f, -0.999831f, -0.999858f, -0.999882f, -0.999905f,
	-0.999925f, -0.999942f, -0.999958f, -0.999971f, -0.999981f, -0.999989f, -0.999995f, -0.999999f
};

static const float sinTable8192[4096] = {
	 0.000000f,  0.000767f,  0.001534f,  0.002301f,  0.003068f,  0.003835f,  0.004602f,  0.005369f,
	 0.006136f,  0.006903f,  0.007670f,  0.008437f,  0.009204f,  0.009971f,  0.010738f,  0.011505f,
	 0.012272f,  0.013038f,  0.013805f,  0.014572f,  0.015339f,  0.016106f,  0.016873f,  0.017640f,
	 0.018407f,  0.019174f,  0.019940f,  0.020707f,  0.021474f,  0.022241f,  0.023008f,  0.023774f,
	 0.024541f,  0.025308f,  0.026075f,  0.026841f,  0.027608f,  0.028375f,  0.029142f,  0.029908f,
	 0.030675f,  0.031441f,  0.032208f,  0.032975f,  0.033741f,  0.034508f,  0.035274f,  0.036041f,
	 0.036807f,  0.037574f,  0.038340f,  0.039107f,  0.039873f,  0.040639f,  0.041406f,  0.042172f,
	 0.042938f,  0.043705f,  0.044471f,  0.045237f,  0.046003f,  0.046769f,  0.047535f,  0.048302f,
	 0.049068f,  0.049834f,  0.050600f,  0.051366f,  0.052132f,  0.052898f,  0.053664f,  0.054429f,
	 0.055195f,  0.055961f,  0.056727f,  0.057493f,  0.058258f,  0.059024f,  0.059790f,  0.060555f,
	 0.061321f,  0.062086f,  0.062852f,  0.063617f,  0.064383f,  0.065148f,  0.065913f,  0.066679f,
	 0.067444f,  0.068209f,  0.068974f,  0.069739f,  0.070505f,  0.071270f,  0.072035f,  0.072800f,
	 0.073565f,  0.074329f,  0.075094f,  0.075859f,  0.076624f,  0.077389f,  0.078153f,  0.078918f,
	 0.079682f,  0.080447f,  0.081211f,  0.081976f,  0.082740f,  0.083505f,  0.084269f,  0.085033f,
	 0.085797f,  0.086561f,  0.087326f,  0.088090f,  0.088854f,  0.089617f,  0.090381f,  0.091145f,
	 0.091909f,  0.092673f,  0.093436f,  0.094200f,  0.094963f,  0.095727f,  0.096490f,  0.097254f,
	 0.098017f,  0.098780f,  0.099544f,  0.100307f,  0.101070f,  0.101833f,  0.102596f,  0.103359f,
	 0.104122f,  0.104884f,  0.105647f,  0.106410f,  0.107172f,  0.107935f,  0.108697f,  0.109460f,
	 0.110222f,  0.110984f,  0.111747f,  0.112509f,  0.113271f,  0.114033f,  0.114795f,  0.115557f,
	 0.116319f,  0.117080f,  0.117842f,  0.118604f,  0.119365f,  0.120127f,  0.120888f,  0.121649f,
	 0.122411f,  0.123172f,  0.123933f,  0.124694f,  0.125455f,  0.126216f,  0.126977f,  0.127737f,
	 0.128498f,  0.129259f,  0.130019f,  0.130780f,  0.131540f,  0.132300f,  0.133061f,  0.133821f,
	 0.134581f,  0.135341f,  0.136101f,  0.136860f,  0.137620f,  0.138380f,  0.139139f,  0.139899f,
	 0.140658f,  0.141418f,  0.142177f,  0.142936f,  0.143695f,  0.144454f,  0.145213f,  0.145972f,
	 0.146730f,  0.147489f,  0.148248f,  0.149006f,  0.149765f,  0.150523f,  0.151281f,  0.152039f,
	 0.152797f,  0.153555f,  0.154313f,  0.155071f,  0.155828f,  0.156586f,  0.157343f,  0.158101f,
	 0.158858f,  0.159615f,  0.160372f,  0.161129f,  0.161886f,  0.162643f,  0.163400f,  0.164157f,
	 0.164913f,  0.165670f,  0.166426f,  0.167182f,  0.167938f,  0.168694f,  0.169450f,  0.170206f,
	 0.170962f,  0.171718f,  0.172473f,  0.173229f,  0.173984f,  0.174739f,  0.175494f,  0.176249f,
	 0.177004f,  0.177759f,  0.178514f,  0.179268f,  0.180023f,  0.180777f,  0.181532f,  0.182286f,
	 0.183040f,  0.183794f,  0.184548f,  0.185301f,  0.186055f,  0.186809f,  0.187562f,  0.188315f,
	 0.189069f,  0.189822f,  0.190575f,  0.191328f,  0.192080f,  0.192833f,  0.193586f,  0.194338f,
	 0.195090f,  0.195843f,  0.196595f,  0.197347f,  0.198098f,  0.198850f,  0.199602f,  0.200353f,
	 0.201105f,  0.201856f,  0.202607f,  0.203358f,  0.204109f,  0.204860f,  0.205610f,  0.206361f,
	 0.207111f,  0.207862f,  0.208612f,  0.209362f,  0.210112f,  0.210862f,  0.211611f,  0.212361f,
	 0.213110f,  0.213860f,  0.214609f,  0.215358f,  0.216107f,  0.216856f,  0.217604f,  0.218353f,
	 0.219101f,  0.219850f,  0.220598f,  0.221346f,  0.222094f,  0.222841f,  0.223589f,  0.224337f,
	 0.225084f,  0.225831f,  0.226578f,  0.227325f,  0.228072f,  0.228819f,  0.229565f,  0.230312f,
	 0.231058f,  0.231804f,  0.232550f,  0.233296f,  0.234042f,  0.234788f,  0.235533f,  0.236278f,
	 0.237024f,  0.237769f,  0.238514f,  0.239258f,  0.240003f,  0.240748f,  0.241492f,  0.242236f,
	 0.242980f,  0.243724f,  0.244468f,  0.245212f,  0.245955f,  0.246698f,  0.247442f,  0.248185f,
	 0.248928f,  0.249670f,  0.250413f,  0.251155f,  0.251898f,  0.252640f,  0.253382f,  0.254124f,
	 0.254866f,  0.255607f,  0.256349f,  0.257090f,  0.257831f,  0.258572f,  0.259313f,  0.260054f,
	 0.260794f,  0.261534f,  0.262275f,  0.263015f,  0.263755f,  0.264494f,  0.265234f,  0.265973f,
	 0.266713f,  0.267452f,  0.268191f,  0.268930f,  0.269668f,  0.270407f,  0.271145f,  0.271883f,
	 0.272621f,  0.273359f,  0.274097f,  0.274834f,  0.275572f,  0.276309f,  0.277046f,  0.277783f,
	 0.278520f,  0.279256f,  0.279993f,  0.280729f,  0.281465f,  0.282201f,  0.282937f,  0.283672f,
	 0.284408f,  0.285143f,  0.285878f,  0.286613f,  0.287347f,  0.288082f,  0.288816f,  0.289551f,
	 0.290285f,  0.291019f,  0.291752f,  0.292486f,  0.293219f,  0.293952f,  0.294685f,  0.295418f,
	 0.296151f,  0.296883f,  0.297616f,  0.298348f,  0.299080f,  0.299812f,  0.300543f,  0.301275f,
	 0.302006f,  0.302737f,  0.303468f,  0.304199f,  0.304929f,  0.305660f,  0.306390f,  0.307120f,
	 0.307850f,  0.308579f,  0.309309f,  0.310038f,  0.310767f,  0.311496f,  0.312225f,  0.312953f,
	 0.313682f,  0.314410f,  0.315138f,  0.315866f,  0.316593f,  0.317321f,  0.318048f,  0.318775f,
	 0.319502f,  0.320229f,  0.320955f,  0.321682f,  0.322408f,  0.323134f,  0.323859f,  0.324585f,
	 0.325310f,  0.326035f,  0.326760f,  0.327485f,  0.328210f,  0.328934f,  0.329658f,  0.330382f,
	 0.331106f,  0.331830f,  0.332553f,  0.333277f,  0.334000f,  0.334722f,  0.335445f,  0.336168f,
	 0.336890f,  0.337612f,  0.338334f,  0.339055f,  0.339777f,  0.340498f,  0.341219f,  0.341940f,
	 0.342661f,  0.343381f,  0.344101f,  0.344821f,  0.345541f,  0.346261f,  0.346980f,  0.347700f,
	 0.348419f,  0.349138f,  0.349856f,  0.350575f,  0.351293f,  0.352011f,  0.352729f,  0.353446f,
	 0.354164f,  0.354881f,  0.355598f,  0.356314f,  0.357031f,  0.357747f,  0.358463f,  0.359179f,
	 0.359895f,  0.360611f,  0.361326f,  0.362041f,  0.362756f,  0.363470f,  0.364185f,  0.364899f,
	 0.365613f,  0.366327f,  0.367040f,  0.367754f,  0.368467f,  0.369180f,  0.369892f,  0.370605f,
	 0.371317f,  0.372029f,  0.372741f,  0.373453f,  0.374164f,  0.374875f,  0.375586f,  0.376297f,
	 0.377007f,  0.377718f,  0.378428f,  0.379138f,  0.379847f,  0.380557f,  0.381266f,  0.381975f,
	 0.382683f,  0.383392f,  0.384100f,  0.384808f,  0.385516f,  0.386224f,  0.386931f,  0.387638f,
	 0.388345f,  0.389052f,  0.389758f,  0.390464f,  0.391170f,  0.391876f,  0.392582f,  0.393287f,
	 0.393992f,  0.394697f,  0.395401f,  0.396106f,  0.396810f,  0.397514f,  0.398218f,  0.398921f,
	 0.399624f,  0.400327f,  0.401030f,  0.401732f,  0.402435f,  0.403137f,  0.403838f,  0.404540f,
	 0.405241f,  0.405942f,  0.406643f,  0.407344f,  0.408044f,  0.408744f,  0.409444f,  0.410144f,
	 0.410843f,  0.411542f,  0.412241f,  0.412940f,  0.413638f,  0.414337f,  0.415034f,  0.415732f,
	 0.416430f,  0.417127f,  0.417824f,  0.418520f,  0.419217f,  0.419913f,  0.420609f,  0.421305f,
	 0.422000f,  0.422695f,  0.423390f,  0.424085f,  0.424780f,  0.425474f,  0.426168f,  0.426862f,
	 0.427555f,  0.428248f,  0.428941f,  0.429634f,  0.430326f,  0.431019f,  0.431711f,  0.432402f,
	 0.433094f,  0.433785f,  0.434476f,  0.435167f,  0.435857f,  0.436547f,  0.437237f,  0.437927f,
	 0.438616f,  0.439305f,  0.439994f,  0.440683f,  0.441371f,  0.442059f,  0.442747f,  0.443435f,
	 0.444122f,  0.444809f,  0.445496f,  0.446183f,  0.446869f,  0.447555f,  0.448241f,  0.448926f,
	 0.449611f,  0.450296f,  0.450981f,  0.451665f,  0.452350f,  0.453033f,  0.453717f,  0.454400f,
	 0.455084f,  0.455766f,  0.456449f,  0.457131f,  0.457813f,  0.458495f,  0.459177f,  0.459858f,
	 0.460539f,  0.461219f,  0.461900f,  0.462580f,  0.463260f,  0.463939f,  0.464619f,  0.465298f,
	 0.465977f,  0.466655f,  0.467333f,  0.468011f,  0.468689f,  0.469366f,  0.470043f,  0.470720f,
	 0.471397f,  0.472073f,  0.472749f,  0.473425f,  0.474100f,  0.474775f,  0.475450f,  0.476125f,
	 0.476799f,  0.477473f,  0.478147f,  0.478821f,  0.479494f,  0.480167f,  0.480839f,  0.481512f,
	 0.482184f,  0.482856f,  0.483527f,  0.484198f,  0.484869f,  0.485540f,  0.486210f,  0.486880f,
	 0.487550f,  0.488220f,  0.488889f,  0.489558f,  0.490226f,  0.490895f,  0.491563f,  0.492231f,
	 0.492898f,  0.493565f,  0.494232f,  0.494899f,  0.495565f,  0.496231f,  0.496897f,  0.497562f,
	 0.498228f,  0.498893f,  0.499557f,  0.500221f,  0.500885f,  0.501549f,  0.502212f,  0.502876f,
	 0.503538f,  0.504201f,  0.504863f,  0.505525f,  0.506187f,  0.506848f,  0.507509f,  0.508170f,
	 0.508830f,  0.509490f,  0.510150f,  0.510810f,  0.511469f,  0.512128f,  0.512786f,  0.513445f,
	 0.514103f,  0.514760f,  0.515418f,  0.516075f,  0.516732f,  0.517388f,  0.518045f,  0.518700f,
	 0.519356f,  0.520011f,  0.520666f,  0.521321f,  0.521975f,  0.522629f,  0.523283f,  0.523937f,
	 0.524590f,  0.525243f,  0.525895f,  0.526547f,  0.527199f,  0.527851f,  0.528502f,  0.529153f,
	 0.529804f,  0.530454f,  0.531104f,  0.531754f,  0.532403f,  0.533052f,  0.533701f,  0.534349f,
	 0.534998f,  0.535645f,  0.536293f,  0.536940f,  0.537587f,  0.538234f,  0.538880f,  0.539526f,
	 0.540171f,  0.540817f,  0.541462f,  0.542106f,  0.542751f,  0.543395f,  0.544039f,  0.544682f,
	 0.545325f,  0.545968f,  0.546610f,  0.547252f,  0.547894f,  0.548536f,  0.549177f,  0.549818f,
	 0.550458f,  0.551098f,  0.551738f,  0.552378f,  0.553017f,  0.553656f,  0.554294f,  0.554932f,
	 0.555570f,  0.556208f,  0.556845f,  0.557482f,  0.558119f,  0.558755f,  0.559391f,  0.560026f,
	 0.560662f,  0.561297f,  0.561931f,  0.562565f,  0.563199f,  0.563833f,  0.564466f,  0.565099f,
	 0.565732f,  0.566364f,  0.566996f,  0.567628f,  0.568259f,  0.568890f,  0.569521f,  0.570151f,
	 0.570781f,  0.571410f,  0.572040f,  0.572669f,  0.573297f,  0.573925f,  0.574553f,  0.575181f,
	 0.575808f,  0.576435f,  0.577062f,  0.577688f,  0.578314f,  0.578939f,  0.579565f,  0.580189f,
	 0.580814f,  0.581438f,  0.582062f,  0.582685f,  0.583309f,  0.583931f,  0.584554f,  0.585176f,
	 0.585798f,  0.586419f,  0.587040f,  0.587661f,  0.588282f,  0.588902f,  0.589521f,  0.590141f,
	 0.590760f,  0.591378f,  0.591997f,  0.592615f,  0.593232f,  0.593850f,  0.594467f,  0.595083f,
	 0.595699f,  0.596315f,  0.596931f,  0.597546f,  0.598161f,  0.598775f,  0.599389f,  0.600003f,
	 0.600616f,  0.601230f,  0.601842f,  0.602455f,  0.603067f,  0.603678f,  0.604290f,  0.604900f,
	 0.605511f,  0.606121f,  0.606731f,  0.607341f,  0.607950f,  0.608559f,  0.609167f,  0.609775f,
	 0.610383f,  0.610990f,  0.611597f,  0.612204f,  0.612810f,  0.613416f,  0.614022f,  0.614627f,
	 0.615232f,  0.615836f,  0.616440f,  0.617044f,  0.617647f,  0.618250f,  0.618853f,  0.619455f,
	 0.620057f,  0.620659f,  0.621260f,  0.621861f,  0.622461f,  0.623061f,  0.623661f,  0.624260f,
	 0.624860f,  0.625458f,  0.626056f,  0.626654f,  0.627252f,  0.627849f,  0.628446f,  0.629042f,
	 0.629638f,  0.630234f,  0.630829f,  0.631424f,  0.632019f,  0.632613f,  0.633207f,  0.633800f,
	 0.634393f,  0.634986f,  0.635578f,  0.636170f,  0.636762f,  0.637353f,  0.637944f,  0.638534f,
	 0.639124f,  0.639714f,  0.640303f,  0.640892f,  0.641481f,  0.642069f,  0.642657f,  0.643245f,
	 0.643832f,  0.644418f,  0.645005f,  0.645590f,  0.646176f,  0.646761f,  0.647346f,  0.647930f,
	 0.648514f,  0.649098f,  0.649681f,  0.650264f,  0.650847f,  0.651429f,  0.652011f,  0.652592f,
	 0.653173f,  0.653753f,  0.654334f,  0.654913f,  0.655493f,  0.656072f,  0.656651f,  0.657229f,
	 0.657807f,  0.658384f,  0.658961f,  0.659538f,  0.660114f,  0.660690f,  0.661266f,  0.661841f,
	 0.662416f,  0.662990f,  0.663564f,  0.664138f,  0.664711f,  0.665284f,  0.665856f,  0.666428f,
	 0.667000f,  0.667571f,  0.668142f,  0.668712f,  0.669283f,  0.669852f,  0.670422f,  0.670990f,
	 0.671559f,  0.672127f,  0.672695f,  0.673262f,  0.673829f,  0.674396f,  0.674962f,  0.675527f,
	 0.676093f,  0.676658f,  0.677222f,  0.677786f,  0.678350f,  0.678913f,  0.679476f,  0.680039f,
	 0.680601f,  0.681163f,  0.681724f,  0.682285f,  0.682846f,  0.683406f,  0.683965f,  0.684525f,
	 0.685084f,  0.685642f,  0.686200f,  0.686758f,  0.687315f,  0.687872f,  0.688429f,  0.688985f,
	 0.689541f,  0.690096f,  0.690651f,  0.691205f,  0.691759f,  0.692313f,  0.692866f,  0.693419f,
	 0.693971f,  0.694524f,  0.695075f,  0.695626f,  0.696177f,  0.696728f,  0.697277f,  0.697827f,
	 0.698376f,  0.698925f,  0.699473f,  0.700021f,  0.700569f,  0.701116f,  0.701663f,  0.702209f,
	 0.702755f,  0.703300f,  0.703845f,  0.704390f,  0.704934f,  0.705478f,  0.706021f,  0.706564f,
	 0.707107f,  0.707649f,  0.708191f,  0.708732f,  0.709273f,  0.709813f,  0.710353f,  0.710893f,
	 0.711432f,  0.711971f,  0.712509f,  0.713047f,  0.713585f,  0.714122f,  0.714659f,  0.715195f,
	 0.715731f,  0.716266f,  0.716801f,  0.717336f,  0.717870f,  0.718404f,  0.718937f,  0.719470f,
	 0.720003f,  0.720535f,  0.721066f,  0.721597f,  0.722128f,  0.722659f,  0.723188f,  0.723718f,
	 0.724247f,  0.724776f,  0.725304f,  0.725832f,  0.726359f,  0.726886f,  0.727413f,  0.727939f,
	 0.728464f,  0.728990f,  0.729514f,  0.730039f,  0.730563f,  0.731086f,  0.731609f,  0.732132f,
	 0.732654f,  0.733176f,  0.733697f,  0.734218f,  0.734739f,  0.735259f,  0.735779f,  0.736298f,
	 0.736817f,  0.737335f,  0.737853f,  0.738370f,  0.738887f,  0.739404f,  0.739920f,  0.740436f,
	 0.740951f,  0.741466f,  0.741980f,  0.742494f,  0.743008f,  0.743521f,  0.744034f,  0.744546f,
	 0.745058f,  0.745569f,  0.746080f,  0.746591f,  0.747101f,  0.747610f,  0.748119f,  0.748628f,
	 0.749136f,  0.749644f,  0.750152f,  0.750659f,  0.751165f,  0.751671f,  0.752177f,  0.752682f,
	 0.753187f,  0.753691f,  0.754195f,  0.754698f,  0.755201f,  0.755704f,  0.756206f,  0.756708f,
	 0.757209f,  0.757710f,  0.758210f,  0.758710f,  0.759209f,  0.759708f,  0.760207f,  0.760705f,
	 0.761202f,  0.761700f,  0.762196f,  0.762693f,  0.763188f,  0.763684f,  0.764179f,  0.764673f,
	 0.765167f,  0.765661f,  0.766154f,  0.766647f,  0.767139f,  0.767631f,  0.768122f,  0.768613f,
	 0.769103f,  0.769593f,  0.770083f,  0.770572f,  0.771061f,  0.771549f,  0.772036f,  0.772524f,
	 0.773010f,  0.773497f,  0.773983f,  0.774468f,  0.774953f,  0.775438f,  0.775922f,  0.776405f,
	 0.776888f,  0.777371f,  0.777853f,  0.778335f,  0.778817f,  0.779297f,  0.779778f,  0.780258f,
	 0.780737f,  0.781216f,  0.781695f,  0.782173f,  0.782651f,  0.783128f,  0.783605f,  0.784081f,
	 0.784557f,  0.785032f,  0.785507f,  0.785981f,  0.786455f,  0.786929f,  0.787402f,  0.787874f,
	 0.788346f,  0.788818f,  0.789289f,  0.789760f,  0.790230f,  0.790700f,  0.791169f,  0.791638f,
	 0.792107f,  0.792575f,  0.793042f,  0.793509f,  0.793975f,  0.794442f,  0.794907f,  0.795372f,
	 0.795837f,  0.796301f,  0.796765f,  0.797228f,  0.797691f,  0.798153f,  0.798615f,  0.799076f,
	 0.799537f,  0.799998f,  0.800458f,  0.800917f,  0.801376f,  0.801835f,  0.802293f,  0.802750f,
	 0.803208f,  0.803664f,  0.804120f,  0.804576f,  0.805031f,  0.805486f,  0.805940f,  0.806394f,
	 0.806848f,  0.807300f,  0.807753f,  0.808205f,  0.808656f,  0.809107f,  0.809558f,  0.810008f,
	 0.810457f,  0.810906f,  0.811355f,  0.811803f,  0.812251f,  0.812698f,  0.813144f,  0.813591f,
	 0.814036f,  0.814482f,  0.814926f,  0.815371f,  0.815814f,  0.816258f,  0.816701f,  0.817143f,
	 0.817585f,  0.818026f,  0.818467f,  0.818908f,  0.819348f,  0.819787f,  0.820226f,  0.820664f,
	 0.821102f,  0.821540f,  0.821977f,  0.822414f,  0.822850f,  0.823285f,  0.823721f,  0.824155f,
	 0.824589f,  0.825023f,  0.825456f,  0.825889f,  0.826321f,  0.826753f,  0.827184f,  0.827615f,
	 0.828045f,  0.828475f,  0.828904f,  0.829333f,  0.829761f,  0.830189f,  0.830616f,  0.831043f,
	 0.831470f,  0.831895f,  0.832321f,  0.832746f,  0.833170f,  0.833594f,  0.834018f,  0.834440f,
	 0.834863f,  0.835285f,  0.835706f,  0.836127f,  0.836548f,  0.836968f,  0.837387f,  0.837806f,
	 0.838225f,  0.838643f,  0.839060f,  0.839477f,  0.839894f,  0.840310f,  0.840725f,  0.841140f,
	 0.841555f,  0.841969f,  0.842383f,  0.842796f,  0.843208f,  0.843620f,  0.844032f,  0.844443f,
	 0.844854f,  0.845264f,  0.845673f,  0.846082f,  0.846491f,  0.846899f,  0.847307f,  0.847714f,
	 0.848120f,  0.848526f,  0.848932f,  0.849337f,  0.849742f,  0.850146f,  0.850549f,  0.850953f,
	 0.851355f,  0.851757f,  0.852159f,  0.852560f,  0.852961f,  0.853361f,  0.853760f,  0.854159f,
	 0.854558f,  0.854956f,  0.855354f,  0.855751f,  0.856147f,  0.856543f,  0.856939f,  0.857334f,
	 0.857729f,  0.858123f,  0.858516f,  0.858909f,  0.859302f,  0.859694f,  0.860085f,  0.860476f,
	 0.860867f,  0.861257f,  0.861646f,  0.862035f,  0.862424f,  0.862812f,  0.863199f,  0.863586f,
	 0.863973f,  0.864359f,  0.864744f,  0.865129f,  0.865514f,  0.865898f,  0.866281f,  0.866664f,
	 0.867046f,  0.867428f,  0.867809f,  0.868190f,  0.868571f,  0.868951f,  0.869330f,  0.869709f,
	 0.870087f,  0.870465f,  0.870842f,  0.871219f,  0.871595f,  0.871971f,  0.872346f,  0.872721f,
	 0.873095f,  0.873469f,  0.873842f,  0.874215f,  0.874587f,  0.874958f,  0.875329f,  0.875700f,
	 0.876070f,  0.876440f,  0.876809f,  0.877177f,  0.877545f,  0.877913f,  0.878280f,  0.878646f,
	 0.879012f,  0.879378f,  0.879743f,  0.880107f,  0.880471f,  0.880834f,  0.881197f,  0.881559f,
	 0.881921f,  0.882283f,  0.882643f,  0.883004f,  0.883363f,  0.883723f,  0.884081f,  0.884439f,
	 0.884797f,  0.885154f,  0.885511f,  0.885867f,  0.886223f,  0.886578f,  0.886932f,  0.887286f,
	 0.887640f,  0.887993f,  0.888345f,  0.888697f,  0.889048f,  0.889399f,  0.889750f,  0.890099f,
	 0.890449f,  0.890797f,  0.891146f,  0.891493f,  0.891841f,  0.892187f,  0.892534f,  0.892879f,
	 0.893224f,  0.893569f,  0.893913f,  0.894256f,  0.894599f,  0.894942f,  0.895284f,  0.895625f,
	 0.895966f,  0.896307f,  0.896646f,  0.896986f,  0.897325f,  0.897663f,  0.898001f,  0.898338f,
	 0.898674f,  0.899011f,  0.899346f,  0.899681f,  0.900016f,  0.900350f,  0.900683f,  0.901016f,
	 0.901349f,  0.901681f,  0.902012f,  0.902343f,  0.902673f,  0.903003f,  0.903332f,  0.903661f,
	 0.903989f,  0.904317f,  0.904644f,  0.904971f,  0.905297f,  0.905622f,  0.905947f,  0.906272f,
	 0.906596f,  0.906919f,  0.907242f,  0.907564f,  0.907886f,  0.908207f,  0.908528f,  0.908848f,
	 0.909168f,  0.909487f,  0.909806f,  0.910124f,  0.910441f,  0.910758f,  0.911075f,  0.911391f,
	 0.911706f,  0.912021f,  0.912335f,  0.912649f,  0.912962f,  0.913275f,  0.913587f,  0.913899f,
	 0.914210f,  0.914520f,  0.914830f,  0.915140f,  0.915449f,  0.915757f,  0.916065f,  0.916372f,
	 0.916679f,  0.916985f,  0.917291f,  0.917596f,  0.917901f,  0.918205f,  0.918508f,  0.918811f,
	 0.919114f,  0.919416f,  0.919717f,  0.920018f,  0.920318f,  0.920618f,  0.920917f,  0.921216f,
	 0.921514f,  0.921812f,  0.922109f,  0.922405f,  0.922701f,  0.922997f,  0.923291f,  0.923586f,
	 0.923880f,  0.924173f,  0.924465f,  0.924758f,  0.925049f,  0.925340f,  0.925631f,  0.925921f,
	 0.926210f,  0.926499f,  0.926787f,  0.927075f,  0.927363f,  0.927649f,  0.927935f,  0.928221f,
	 0.928506f,  0.928791f,  0.929075f,  0.929358f,  0.929641f,  0.929923f,  0.930205f,  0.930486f,
	 0.930767f,  0.931047f,  0.931327f,  0.931606f,  0.931884f,  0.932162f,  0.932440f,  0.932716f,
	 0.932993f,  0.933269f,  0.933544f,  0.933818f,  0.934093f,  0.934366f,  0.934639f,  0.934912f,
	 0.935184f,  0.935455f,  0.935726f,  0.935996f,  0.936266f,  0.936535f,  0.936803f,  0.937072f,
	 0.937339f,  0.937606f,  0.937872f,  0.938138f,  0.938404f,  0.938668f,  0.938932f,  0.939196f,
	 0.939459f,  0.939722f,  0.939984f,  0.940245f,  0.940506f,  0.940766f,  0.941026f,  0.941285f,
	 0.941544f,  0.941802f,  0.942060f,  0.942317f,  0.942573f,  0.942829f,  0.943084f,  0.943339f,
	 0.943593f,  0.943847f,  0.944100f,  0.944353f,  0.944605f,  0.944856f,  0.945107f,  0.945358f,
	 0.945607f,  0.945857f,  0.946105f,  0.946353f,  0.946601f,  0.946848f,  0.947094f,  0.947340f,
	 0.947586f,  0.947830f,  0.948075f,  0.948318f,  0.948561f,  0.948804f,  0.949046f,  0.949287f,
	 0.949528f,  0.949768f,  0.950008f,  0.950247f,  0.950486f,  0.950724f,  0.950962f,  0.951199f,
	 0.951435f,  0.951671f,  0.951906f,  0.952141f,  0.952375f,  0.952609f,  0.952842f,  0.953074f,
	 0.953306f,  0.953537f,  0.953768f,  0.953998f,  0.954228f,  0.954457f,  0.954686f,  0.954914f,
	 0.955141f,  0.955368f,  0.955594f,  0.955820f,  0.956045f,  0.956270f,  0.956494f,  0.956717f,
	 0.956940f,  0.957163f,  0.957385f,  0.957606f,  0.957826f,  0.958046f,  0.958266f,  0.958485f,
	 0.958703f,  0.958921f,  0.959139f,  0.959355f,  0.959572f,  0.959787f,  0.960002f,  0.960217f,
	 0.960431f,  0.960644f,  0.960857f,  0.961069f,  0.961280f,  0.961492f,  0.961702f,  0.961912f,
	 0.962121f,  0.962330f,  0.962538f,  0.962746f,  0.962953f,  0.963160f,  0.963366f,  0.963571f,
	 0.963776f,  0.963980f,  0.964184f,  0.964387f,  0.964590f,  0.964792f,  0.964993f,  0.965194f,
	 0.965394f,  0.965594f,  0.965793f,  0.965992f,  0.966190f,  0.966387f,  0.966584f,  0.966781f,
	 0.966976f,  0.967172f,  0.967366f,  0.967560f,  0.967754f,  0.967947f,  0.968139f,  0.968331f,
	 0.968522f,  0.968713f,  0.968903f,  0.969092f,  0.969281f,  0.969470f,  0.969657f,  0.969845f,
	 0.970031f,  0.970217f,  0.970403f,  0.970588f,  0.970772f,  0.970956f,  0.971139f,  0.971322f,
	 0.971504f,  0.971685f,  0.971866f,  0.972047f,  0.972227f,  0.972406f,  0.972584f,  0.972762f,
	 0.972940f,  0.973117f,  0.973293f,  0.973469f,  0.973644f,  0.973819f,  0.973993f,  0.974166f,
	 0.974339f,  0.974512f,  0.974684f,  0.974855f,  0.975025f,  0.975195f,  0.975365f,  0.975534f,
	 0.975702f,  0.975870f,  0.976037f,  0.976204f,  0.976370f,  0.976535f,  0.976700f,  0.976864f,
	 0.977028f,  0.977191f,  0.977354f,  0.977516f,  0.977677f,  0.977838f,  0.977998f,  0.978158f,
	 0.978317f,  0.978476f,  0.978634f,  0.978791f,  0.978948f,  0.979104f,  0.979260f,  0.979415f,
	 0.979570f,  0.979724f,  0.979877f,  0.980030f,  0.980182f,  0.980334f,  0.980485f,  0.980635f,
	 0.980785f,  0.980935f,  0.981083f,  0.981232f,  0.981379f,  0.981526f,  0.981673f,  0.981819f,
	 0.981964f,  0.982109f,  0.982253f,  0.982396f,  0.982539f,  0.982682f,  0.982824f,  0.982965f,
	 0.983105f,  0.983246f,  0.983385f,  0.983524f,  0.983662f,  0.983800f,  0.983937f,  0.984074f,
	 0.984210f,  0.984346f,  0.984480f,  0.984615f,  0.984748f,  0.984882f,  0.985014f,  0.985146f,
	 0.985278f,  0.985408f,  0.985539f,  0.985668f,  0.985798f,  0.985926f,  0.986054f,  0.986181f,
	 0.986308f,  0.986434f,  0.986560f,  0.986685f,  0.986809f,  0.986933f,  0.987057f,  0.987179f,
	 0.987301f,  0.987423f,  0.987544f,  0.987664f,  0.987784f,  0.987903f,  0.988022f,  0.988140f,
	 0.988258f,  0.988374f,  0.988491f,  0.988607f,  0.988722f,  0.988836f,  0.988950f,  0.989064f,
	 0.989177f,  0.989289f,  0.989400f,  0.989511f,  0.989622f,  0.989732f,  0.989841f,  0.989950f,
	 0.990058f,  0.990166f,  0.990273f,  0.990379f,  0.990485f,  0.990590f,  0.990695f,  0.990799f,
	 0.990903f,  0.991006f,  0.991108f,  0.991210f,  0.991311f,  0.991411f,  0.991511f,  0.991611f,
	 0.991710f,  0.991808f,  0.991906f,  0.992003f,  0.992099f,  0.992195f,  0.992291f,  0.992385f,
	 0.992480f,  0.992573f,  0.992666f,  0.992759f,  0.992850f,  0.992942f,  0.993032f,  0.993122f,
	 0.993212f,  0.993301f,  0.993389f,  0.993477f,  0.993564f,  0.993651f,  0.993737f,  0.993822f,
	 0.993907f,  0.993991f,  0.994075f,  0.994158f,  0.994240f,  0.994322f,  0.994404f,  0.994484f,
	 0.994565f,  0.994644f,  0.994723f,  0.994802f,  0.994879f,  0.994957f,  0.995033f,  0.995109f,
	 0.995185f,  0.995260f,  0.995334f,  0.995408f,  0.995481f,  0.995553f,  0.995625f,  0.995697f,
	 0.995767f,  0.995838f,  0.995907f,  0.995976f,  0.996045f,  0.996113f,  0.996180f,  0.996247f,
	 0.996313f,  0.996378f,  0.996443f,  0.996507f,  0.996571f,  0.996634f,  0.996697f,  0.996759f,
	 0.996820f,  0.996881f,  0.996941f,  0.997001f,  0.997060f,  0.997119f,  0.997176f,  0.997234f,
	 0.997290f,  0.997347f,  0.997402f,  0.997457f,  0.997511f,  0.997565f,  0.997618f,  0.997671f,
	 0.997723f,  0.997774f,  0.997825f,  0.997876f,  0.997925f,  0.997974f,  0.998023f,  0.998071f,
	 0.998118f,  0.998165f,  0.998211f,  0.998257f,  0.998302f,  0.998346f,  0.998390f,  0.998433f,
	 0.998476f,  0.998518f,  0.998559f,  0.998600f,  0.998640f,  0.998680f,  0.998719f,  0.998758f,
	 0.998795f,  0.998833f,  0.998870f,  0.998906f,  0.998941f,  0.998976f,  0.999011f,  0.999044f,
	 0.999078f,  0.999110f,  0.999142f,  0.999174f,  0.999205f,  0.999235f,  0.999265f,  0.999294f,
	 0.999322f,  0.999350f,  0.999378f,  0.999404f,  0.999431f,  0.999456f,  0.999481f,  0.999506f,
	 0.999529f,  0.999553f,  0.999575f,  0.999597f,  0.999619f,  0.999640f,  0.999660f,  0.999680f,
	 0.999699f,  0.999717f,  0.999735f,  0.999753f,  0.999769f,  0.999786f,  0.999801f,  0.999816f,
	 0.999831f,  0.999844f,  0.999858f,  0.999870f,  0.999882f,  0.999894f,  0.999905f,  0.999915f,
	 0.999925f,  0.999934f,  0.999942f,  0.999950f,  0.999958f,  0.999964f,  0.999971f,  0.999976f,
	 0.999981f,  0.999986f,  0.999989f,  0.999993f,  0.999995f,  0.999997f,  0.999999f,  1.000000f,
	 0.000000f, -0.000767f, -0.001534f, -0.002301f, -0.003068f, -0.003835f, -0.004602f, -0.005369f,
	-0.006136f, -0.006903f, -0.007670f, -0.008437f, -0.009204f, -0.009971f, -0.010738f, -0.011505f,
	-0.012272f, -0.013038f, -0.013805f, -0.014572f, -0.015339f, -0.016106f, -0.016873f, -0.017640f,
	-0.018407f, -0.019174f, -0.019940f, -0.020707f, -0.021474f, -0.022241f, -0.023008f, -0.023774f,
	-0.024541f, -0.025308f, -0.026075f, -0.026841f, -0.027608f, -0.028375f, -0.029142f, -0.029908f,
	-0.030675f, -0.031441f, -0.032208f, -0.032975f, -0.033741f, -0.034508f, -0.035274f, -0.036041f,
	-0.036807f, -0.037574f, -0.038340f, -0.039107f, -0.039873f, -0.040639f, -0.041406f, -0.042172f,
	-0.042938f, -0.043705f, -0.044471f, -0.045237f, -0.046003f, -0.046769f, -0.047535f, -0.048302f,
	-0.049068f, -0.049834f, -0.050600f, -0.051366f, -0.052132f, -0.052898f, -0.053664f, -0.054429f,
	-0.055195f, -0.055961f, -0.056727f, -0.057493f, -0.058258f, -0.059024f, -0.059790f, -0.060555f,
	-0.061321f, -0.062086f, -0.062852f, -0.063617f, -0.064383f, -0.065148f, -0.065913f, -0.066679f,
	-0.067444f, -0.068209f, -0.068974f, -0.069739f, -0.070505f, -0.071270f, -0.072035f, -0.072800f,
	-0.073565f, -0.074329f, -0.075094f, -0.075859f, -0.076624f, -0.077389f, -0.078153f, -0.078918f,
	-0.079682f, -0.080447f, -0.081211f, -0.081976f, -0.082740f, -0.083505f, -0.084269f, -0.085033f,
	-0.085797f, -0.086561f, -0.087326f, -0.088090f, -0.088854f, -0.089617f, -0.090381f, -0.091145f,
	-0.091909f, -0.092673f, -0.093436f, -0.094200f, -0.094963f, -0.095727f, -0.096490f, -0.097254f,
	-0.098017f, -0.098780f, -0.099544f, -0.100307f, -0.101070f, -0.101833f, -0.102596f, -0.103359f,
	-0.104122f, -0.104884f, -0.105647f, -0.106410f, -0.107172f, -0.107935f, -0.108697f, -0.109460f,
	-0.110222f, -0.110984f, -0.111747f, -0.112509f, -0.113271f, -0.114033f, -0.114795f, -0.115557f,
	-0.116319f, -0.117080f, -0.117842f, -0.118604f, -0.119365f, -0.120127f, -0.120888f, -0.121649f,
	-0.122411f, -0.123172f, -0.123933f, -0.124694f, -0.125455f, -0.126216f, -0.126977f, -0.127737f,
	-0.128498f, -0.129259f, -0.130019f, -0.130780f, -0.131540f, -0.132300f, -0.133061f, -0.133821f,
	-0.134581f, -0.135341f, -0.136101f, -0.136860f, -0.137620f, -0.138380f, -0.139139f, -0.139899f,
	-0.140658f, -0.141418f, -0.142177f, -0.142936f, -0.143695f, -0.144454f, -0.145213f, -0.145972f,
	-0.146730f, -0.147489f, -0.148248f, -0.149006f, -0.149765f, -0.150523f, -0.151281f, -0.152039f,
	-0.152797f, -0.153555f, -0.154313f, -0.155071f, -0.155828f, -0.156586f, -0.157343f, -0.158101f,
	-0.158858f, -0.159615f, -0.160372f, -0.161129f, -0.161886f, -0.162643f, -0.163400f, -0.164157f,
	-0.164913f, -0.165670f, -0.166426f, -0.167182f, -0.167938f, -0.168694f, -0.169450f, -0.170206f,
	-0.170962f, -0.171718f, -0.172473f, -0.173229f, -0.173984f, -0.174739f, -0.175494f, -0.176249f,
	-0.177004f, -0.177759f, -0.178514f, -0.179268f, -0.180023f, -0.180777f, -0.181532f, -0.182286f,
	-0.183040f, -0.183794f, -0.184548f, -0.185301f, -0.186055f, -0.186809f, -0.187562f, -0.188315f,
	-0.189069f, -0.189822f, -0.190575f, -0.191328f, -0.192080f, -0.192833f, -0.193586f, -0.194338f,
	-0.195090f, -0.195843f, -0.196595f, -0.197347f, -0.198098f, -0.198850f, -0.199602f, -0.200353f,
	-0.201105f, -0.201856f, -0.202607f, -0.203358f, -0.204109f, -0.204860f, -0.205610f, -0.206361f,
	-0.207111f, -0.207862f, -0.208612f, -0.209362f, -0.210112f, -0.210862f, -0.211611f, -0.212361f,
	-0.213110f, -0.213860f, -0.214609f, -0.215358f, -0.216107f, -0.216856f, -0.217604f, -0.218353f,
	-0.219101f, -0.219850f, -0.220598f, -0.221346f, -0.222094f, -0.222841f, -0.223589f, -0.224337f,
	-0.225084f, -0.225831f, -0.226578f, -0.227325f, -0.228072f, -0.228819f, -0.229565f, -0.230312f,
	-0.231058f, -0.231804f, -0.232550f, -0.233296f, -0.234042f, -0.234788f, -0.235533f, -0.236278f,
	-0.237024f, -0.237769f, -0.238514f, -0.239258f, -0.240003f, -0.240748f, -0.241492f, -0.242236f,
	-0.242980f, -0.243724f, -0.244468f, -0.245212f, -0.245955f, -0.246698f, -0.247442f, -0.248185f,
	-0.248928f, -0.249670f, -0.250413f, -0.251155f, -0.251898f, -0.252640f, -0.253382f, -0.254124f,
	-0.254866f, -0.255607f, -0.256349f, -0.257090f, -0.257831f, -0.258572f, -0.259313f, -0.260054f,
	-0.260794f, -0.261534f, -0.262275f, -0.263015f, -0.263755f, -0.264494f, -0.265234f, -0.265973f,
	-0.266713f, -0.267452f, -0.268191f, -0.268930f, -0.269668f, -0.270407f, -0.271145f, -0.271883f,
	-0.272621f, -0.273359f, -0.274097f, -0.274834f, -0.275572f, -0.276309f, -0.277046f, -0.277783f,
	-0.278520f, -0.279256f, -0.279993f, -0.280729f, -0.281465f, -0.282201f, -0.282937f, -0.283672f,
	-0.284408f, -0.285143f, -0.285878f, -0.286613f, -0.287347f, -0.288082f, -0.288816f, -0.289551f,
	-0.290285f, -0.291019f, -0.291752f, -0.292486f, -0.293219f, -0.293952f, -0.294685f, -0.295418f,
	-0.296151f, -0.296883f, -0.297616f, -0.298348f, -0.299080f, -0.299812f, -0.300543f, -0.301275f,
	-0.302006f, -0.302737f, -0.303468f, -0.304199f, -0.304929f, -0.305660f, -0.306390f, -0.307120f,
	-0.307850f, -0.308579f, -0.309309f, -0.310038f, -0.310767f, -0.311496f, -0.312225f, -0.312953f,
	-0.313682f, -0.314410f, -0.315138f, -0.315866f, -0.316593f, -0.317321f, -0.318048f, -0.318775f,
	-0.319502f, -0.320229f, -0.320955f, -0.321682f, -0.322408f, -0.323134f, -0.323859f, -0.324585f,
	-0.325310f, -0.326035f, -0.326760f, -0.327485f, -0.328210f, -0.328934f, -0.329658f, -0.330382f,
	-0.331106f, -0.331830f, -0.332553f, -0.333277f, -0.334000f, -0.334722f, -0.335445f, -0.336168f,
	-0.336890f, -0.337612f, -0.338334f, -0.339055f, -0.339777f, -0.340498f, -0.341219f, -0.341940f,
	-0.342661f, -0.343381f, -0.344101f, -0.344821f, -0.345541f, -0.346261f, -0.346980f, -0.347700f,
	-0.348419f, -0.349138f, -0.349856f, -0.350575f, -0.351293f, -0.352011f, -0.352729f, -0.353446f,
	-0.354164f, -0.354881f, -0.355598f, -0.356314f, -0.357031f, -0.357747f, -0.358463f, -0.359179f,
	-0.359895f, -0.360611f, -0.361326f, -0.362041f, -0.362756f, -0.363470f, -0.364185f, -0.364899f,
	-0.365613f, -0.366327f, -0.367040f, -0.367754f, -0.368467f, -0.369180f, -0.369892f, -0.370605f,
	-0.371317f, -0.372029f, -0.372741f, -0.373453f, -0.374164f, -0.374875f, -0.375586f, -0.376297f,
	-0.377007f, -0.377718f, -0.378428f, -0.379138f, -0.379847f, -0.380557f, -0.381266f, -0.381975f,
	-0.382683f, -0.383392f, -0.384100f, -0.384808f, -0.385516f, -0.386224f, -0.386931f, -0.387638f,
	-0.388345f, -0.389052f, -0.389758f, -0.390464f, -0.391170f, -0.391876f, -0.392582f, -0.393287f,
	-0.393992f, -0.394697f, -0.395401f, -0.396106f, -0.396810f, -0.397514f, -0.398218f, -0.398921f,
	-0.399624f, -0.400327f, -0.401030f, -0.401732f, -0.402435f, -0.403137f, -0.403838f, -0.404540f,
	-0.405241f, -0.405942f, -0.406643f, -0.407344f, -0.408044f, -0.408744f, -0.409444f, -0.410144f,
	-0.410843f, -0.411542f, -0.412241f, -0.412940f, -0.413638f, -0.414337f, -0.415034f, -0.415732f,
	-0.416430f, -0.417127f, -0.417824f, -0.418520f, -0.419217f, -0.419913f, -0.420609f, -0.421305f,
	-0.422000f, -0.422695f, -0.423390f, -0.424085f, -0.424780f, -0.425474f, -0.426168f, -0.426862f,
	-0.427555f, -0.428248f, -0.428941f, -0.429634f, -0.430326f, -0.431019f, -0.431711f, -0.432402f,
	-0.433094f, -0.433785f, -0.434476f, -0.435167f, -0.435857f, -0.436547f, -0.437237f, -0.437927f,
	-0.438616f, -0.439305f, -0.439994f, -0.440683f, -0.441371f, -0.442059f, -0.442747f, -0.443435f,
	-0.444122f, -0.444809f, -0.445496f, -0.446183f, -0.446869f, -0.447555f, -0.448241f, -0.448926f,
	-0.449611f, -0.450296f, -0.450981f, -0.451665f, -0.452350f, -0.453033f, -0.453717f, -0.454400f,
	-0.455084f, -0.455766f, -0.456449f, -0.457131f, -0.457813f, -0.458495f, -0.459177f, -0.459858f,
	-0.460539f, -0.461219f, -0.461900f, -0.462580f, -0.463260f, -0.463939f, -0.464619f, -0.465298f,
	-0.465977f, -0.466655f, -0.467333f, -0.468011f, -0.468689f, -0.469366f, -0.470043f, -0.470720f,
	-0.471397f, -0.472073f, -0.472749f, -0.473425f, -0.474100f, -0.474775f, -0.475450f, -0.476125f,
	-0.476799f, -0.477473f, -0.478147f, -0.478821f, -0.479494f, -0.480167f, -0.480839f, -0.481512f,
	-0.482184f, -0.482856f, -0.483527f, -0.484198f, -0.484869f, -0.485540f, -0.486210f, -0.486880f,
	-0.487550f, -0.488220f, -0.488889f, -0.489558f, -0.490226f, -0.490895f, -0.491563f, -0.492231f,
	-0.492898f, -0.493565f, -0.494232f, -0.494899f, -0.495565f, -0.496231f, -0.496897f, -0.497562f,
	-0.498228f, -0.498893f, -0.499557f, -0.500221f, -0.500885f, -0.501549f, -0.502212f, -0.502876f,
	-0.503538f, -0.504201f, -0.504863f, -0.505525f, -0.506187f, -0.506848f, -0.507509f, -0.508170f,
	-0.508830f, -0.509490f, -0.510150f, -0.510810f, -0.511469f, -0.512128f, -0.512786f, -0.513445f,
	-0.514103f, -0.514760f, -0.515418f, -0.516075f, -0.516732f, -0.517388f, -0.518045f, -0.518700f,
	-0.519356f, -0.520011f, -0.520666f, -0.521321f, -0.521975f, -0.522629f, -0.523283f, -0.523937f,
	-0.524590f, -0.525243f, -0.525895f, -0.526547f, -0.527199f, -0.527851f, -0.528502f, -0.529153f,
	-0.529804f, -0.530454f, -0.531104f, -0.531754f, -0.532403f, -0.533052f, -0.533701f, -0.534349f,
	-0.534998f, -0.535645f, -0.536293f, -0.536940f, -0.537587f, -0.538234f, -0.538880f, -0.539526f,
	-0.540171f, -0.540817f, -0.541462f, -0.542106f, -0.542751f, -0.543395f, -0.544039f, -0.544682f,
	-0.545325f, -0.545968f, -0.546610f, -0.547252f, -0.547894f, -0.548536f, -0.549177f, -0.549818f,
	-0.550458f, -0.551098f, -0.551738f, -0.552378f, -0.553017f, -0.553656f, -0.554294f, -0.554932f,
	-0.555570f, -0.556208f, -0.556845f, -0.557482f, -0.558119f, -0.558755f, -0.559391f, -0.560026f,
	-0.560662f, -0.561297f, -0.561931f, -0.562565f, -0.563199f, -0.563833f, -0.564466f, -0.565099f,
	-0.565732f, -0.566364f, -0.566996f, -0.567628f, -0.568259f, -0.568890f, -0.569521f, -0.570151f,
	-0.570781f, -0.571410f, -0.572040f, -0.572669f, -0.573297f, -0.573925f, -0.574553f, -0.575181f,
	-0.575808f, -0.576435f, -0.577062f, -0.577688f, -0.578314f, -0.578939f, -0.579565f, -0.580189f,
	-0.580814f, -0.581438f, -0.582062f, -0.582685f, -0.583309f, -0.583931f, -0.584554f, -0.585176f,
	-0.585798f, -0.586419f, -0.587040f, -0.587661f, -0.588282f, -0.588902f, -0.589521f, -0.590141f,
	-0.590760f, -0.591378f, -0.591997f, -0.592615f, -0.593232f, -0.593850f, -0.594467f, -0.595083f,
	-0.595699f, -0.596315f, -0.596931f, -0.597546f, -0.598161f, -0.598775f, -0.599389f, -0.600003f,
	-0.600616f, -0.601230f, -0.601842f, -0.602455f, -0.603067f, -0.603678f, -0.604290f, -0.604900f,
	-0.605511f, -0.606121f, -0.606731f, -0.607341f, -0.607950f, -0.608559f, -0.609167f, -0.609775f,
	-0.610383f, -0.610990f, -0.611597f, -0.612204f, -0.612810f, -0.613416f, -0.614022f, -0.614627f,
	-0.615232f, -0.615836f, -0.616440f, -0.617044f, -0.617647f, -0.618250f, -0.618853f, -0.619455f,
	-0.620057f, -0.620659f, -0.621260f, -0.621861f, -0.622461f, -0.623061f, -0.623661f, -0.624260f,
	-0.624860f, -0.625458f, -0.626056f, -0.626654f, -0.627252f, -0.627849f, -0.628446f, -0.629042f,
	-0.629638f, -0.630234f, -0.630829f, -0.631424f, -0.632019f, -0.632613f, -0.633207f, -0.633800f,
	-0.634393f, -0.634986f, -0.635578f, -0.636170f, -0.636762f, -0.637353f, -0.637944f, -0.638534f,
	-0.639124f, -0.639714f, -0.640303f, -0.640892f, -0.641481f, -0.642069f, -0.642657f, -0.643245f,
	-0.643832f, -0.644418f, -0.645005f, -0.645590f, -0.646176f, -0.646761f, -0.647346f, -0.647930f,
	-0.648514f, -0.649098f, -0.649681f, -0.650264f, -0.650847f, -0.651429f, -0.652011f, -0.652592f,
	-0.653173f, -0.653753f, -0.654334f, -0.654913f, -0.655493f, -0.656072f, -0.656651f, -0.657229f,
	-0.657807f, -0.658384f, -0.658961f, -0.659538f, -0.660114f, -0.660690f, -0.661266f, -0.661841f,
	-0.662416f, -0.662990f, -0.663564f, -0.664138f, -0.664711f, -0.665284f, -0.665856f, -0.666428f,
	-0.667000f, -0.667571f, -0.668142f, -0.668712f, -0.669283f, -0.669852f, -0.670422f, -0.670990f,
	-0.671559f, -0.672127f, -0.672695f, -0.673262f, -0.673829f, -0.674396f, -0.674962f, -0.675527f,
	-0.676093f, -0.676658f, -0.677222f, -0.677786f, -0.678350f, -0.678913f, -0.679476f, -0.680039f,
	-0.680601f, -0.681163f, -0.681724f, -0.682285f, -0.682846f, -0.683406f, -0.683965f, -0.684525f,
	-0.685084f, -0.685642f, -0.686200f, -0.686758f, -0.687315f, -0.687872f, -0.688429f, -0.688985f,
	-0.689541f, -0.690096f, -0.690651f, -0.691205f, -0.691759f, -0.692313f, -0.692866f, -0.693419f,
	-0.693971f, -0.694524f, -0.695075f, -0.695626f, -0.696177f, -0.696728f, -0.697277f, -0.697827f,
	-0.698376f, -0.698925f, -0.699473f, -0.700021f, -0.700569f, -0.701116f, -0.701663f, -0.702209f,
	-0.702755f, -0.703300f, -0.703845f, -0.704390f, -0.704934f, -0.705478f, -0.706021f, -0.706564f,
	-0.707107f, -0.707649f, -0.708191f, -0.708732f, -0.709273f, -0.709813f, -0.710353f, -0.710893f,
	-0.711432f, -0.711971f, -0.712509f, -0.713047f, -0.713585f, -0.714122f, -0.714659f, -0.715195f,
	-0.715731f, -0.716266f, -0.716801f, -0.717336f, -0.717870f, -0.718404f, -0.718937f, -0.719470f,
	-0.720003f, -0.720535f, -0.721066f, -0.721597f, -0.722128f, -0.722659f, -0.723188f, -0.723718f,
	-0.724247f, -0.724776f, -0.725304f, -0.725832f, -0.726359f, -0.726886f, -0.727413f, -0.727939f,
	-0.728464f, -0.728990f, -0.729514f, -0.730039f, -0.730563f, -0.731086f, -0.731609f, -0.732132f,
	-0.732654f, -0.733176f, -0.733697f, -0.734218f, -0.734739f, -0.735259f, -0.735779f, -0.736298f,
	-0.736817f, -0.737335f, -0.737853f, -0.738370f, -0.738887f, -0.739404f, -0.739920f, -0.740436f,
	-0.740951f, -0.741466f, -0.741980f, -0.742494f, -0.743008f, -0.743521f, -0.744034f, -0.744546f,
	-0.745058f, -0.745569f, -0.746080f, -0.746591f, -0.747101f, -0.747610f, -0.748119f, -0.748628f,
	-0.749136f, -0.749644f, -0.750152f, -0.750659f, -0.751165f, -0.751671f, -0.752177f, -0.752682f,
	-0.753187f, -0.753691f, -0.754195f, -0.754698f, -0.755201f, -0.755704f, -0.756206f, -0.756708f,
	-0.757209f, -0.757710f, -0.758210f, -0.758710f, -0.759209f, -0.759708f, -0.760207f, -0.760705f,
	-0.761202f, -0.761700f, -0.762196f, -0.762693f, -0.763188f, -0.763684f, -0.764179f, -0.764673f,
	-0.765167f, -0.765661f, -0.766154f, -0.766647f, -0.767139f, -0.767631f, -0.768122f, -0.768613f,
	-0.769103f, -0.769593f, -0.770083f, -0.770572f, -0.771061f, -0.771549f, -0.772036f, -0.772524f,
	-0.773010f, -0.773497f, -0.773983f, -0.774468f, -0.774953f, -0.775438f, -0.775922f, -0.776405f,
	-0.776888f, -0.777371f, -0.777853f, -0.778335f, -0.778817f, -0.779297f, -0.779778f, -0.780258f,
	-0.780737f, -0.781216f, -0.781695f, -0.782173f, -0.782651f, -0.783128f, -0.783605f, -0.784081f,
	-0.784557f, -0.785032f, -0.785507f, -0.785981f, -0.786455f, -0.786929f, -0.787402f, -0.787874f,
	-0.788346f, -0.788818f, -0.789289f, -0.789760f, -0.790230f, -0.790700f, -0.791169f, -0.791638f,
	-0.792107f, -0.792575f, -0.793042f, -0.793509f, -0.793975f, -0.794442f, -0.794907f, -0.795372f,
	-0.795837f, -0.796301f, -0.796765f, -0.797228f, -0.797691f, -0.798153f, -0.798615f, -0.799076f,
	-0.799537f, -0.799998f, -0.800458f, -0.800917f, -0.801376f, -0.801835f, -0.802293f, -0.802750f,
	-0.803208f, -0.803664f, -0.804120f, -0.804576f, -0.805031f, -0.805486f, -0.805940f, -0.806394f,
	-0.806848f, -0.807300f, -0.807753f, -0.808205f, -0.808656f, -0.809107f, -0.809558f, -0.810008f,
	-0.810457f, -0.810906f, -0.811355f, -0.811803f, -0.812251f, -0.812698f, -0.813144f, -0.813591f,
	-0.814036f, -0.814482f, -0.814926f, -0.815371f, -0.815814f, -0.816258f, -0.816701f, -0.817143f,
	-0.817585f, -0.818026f, -0.818467f, -0.818908f, -0.819348f, -0.819787f, -0.820226f, -0.820664f,
	-0.821102f, -0.821540f, -0.821977f, -0.822414f, -0.822850f, -0.823285f, -0.823721f, -0.824155f,
	-0.824589f, -0.825023f, -0.825456f, -0.825889f, -0.826321f, -0.826753f, -0.827184f, -0.827615f,
	-0.828045f, -0.828475f, -0.828904f, -0.829333f, -0.829761f, -0.830189f, -0.830616f, -0.831043f,
	-0.831470f, -0.831895f, -0.832321f, -0.832746f, -0.833170f, -0.833594f, -0.834018f, -0.834440f,
	-0.834863f, -0.835285f, -0.835706f, -0.836127f, -0.836548f, -0.836968f, -0.837387f, -0.837806f,
	-0.838225f, -0.838643f, -0.839060f, -0.839477f, -0.839894f, -0.840310f, -0.840725f, -0.841140f,
	-0.841555f, -0.841969f, -0.842383f, -0.842796f, -0.843208f, -0.843620f, -0.844032f, -0.844443f,
	-0.844854f, -0.845264f, -0.845673f, -0.846082f, -0.846491f, -0.846899f, -0.847307f, -0.847714f,
	-0.848120f, -0.848526f, -0.848932f, -0.849337f, -0.849742f, -0.850146f, -0.850549f, -0.850953f,
	-0.851355f, -0.851757f, -0.852159f, -0.852560f, -0.852961f, -0.853361f, -0.853760f, -0.854159f,
	-0.854558f, -0.854956f, -0.855354f, -0.855751f, -0.856147f, -0.856543f, -0.856939f, -0.857334f,
	-0.857729f, -0.858123f, -0.858516f, -0.858909f, -0.859302f, -0.859694f, -0.860085f, -0.860476f,
	-0.860867f, -0.861257f, -0.861646f, -0.862035f, -0.862424f, -0.862812f, -0.863199f, -0.863586f,
	-0.863973f, -0.864359f, -0.864744f, -0.865129f, -0.865514f, -0.865898f, -0.866281f, -0.866664f,
	-0.867046f, -0.867428f, -0.867809f, -0.868190f, -0.868571f, -0.868951f, -0.869330f, -0.869709f,
	-0.870087f, -0.870465f, -0.870842f, -0.871219f, -0.871595f, -0.871971f, -0.872346f, -0.872721f,
	-0.873095f, -0.873469f, -0.873842f, -0.874215f, -0.874587f, -0.874958f, -0.875329f, -0.875700f,
	-0.876070f, -0.876440f, -0.876809f, -0.877177f, -0.877545f, -0.877913f, -0.878280f, -0.878646f,
	-0.879012f, -0.879378f, -0.879743f, -0.880107f, -0.880471f, -0.880834f, -0.881197f, -0.881559f,
	-0.881921f, -0.882283f, -0.882643f, -0.883004f, -0.883363f, -0.883723f, -0.884081f, -0.884439f,
	-0.884797f, -0.885154f, -0.885511f, -0.885867f, -0.886223f, -0.886578f, -0.886932f, -0.887286f,
	-0.887640f, -0.887993f, -0.888345f, -0.888697f, -0.889048f, -0.889399f, -0.889750f, -0.890099f,
	-0.890449f, -0.890797f, -0.891146f, -0.891493f, -0.891841f, -0.892187f, -0.892534f, -0.892879f,
	-0.893224f, -0.893569f, -0.893913f, -0.894256f, -0.894599f, -0.894942f, -0.895284f, -0.895625f,
	-0.895966f, -0.896307f, -0.896646f, -0.896986f, -0.897325f, -0.897663f, -0.898001f, -0.898338f,
	-0.898674f, -0.899011f, -0.899346f, -0.899681f, -0.900016f, -0.900350f, -0.900683f, -0.901016f,
	-0.901349f, -0.901681f, -0.902012f, -0.902343f, -0.902673f, -0.903003f, -0.903332f, -0.903661f,
	-0.903989f, -0.904317f, -0.904644f, -0.904971f, -0.905297f, -0.905622f, -0.905947f, -0.906272f,
	-0.906596f, -0.906919f, -0.907242f, -0.907564f, -0.907886f, -0.908207f, -0.908528f, -0.908848f,
	-0.909168f, -0.909487f, -0.909806f, -0.910124f, -0.910441f, -0.910758f, -0.911075f, -0.911391f,
	-0.911706f, -0.912021f, -0.912335f, -0.912649f, -0.912962f, -0.913275f, -0.913587f, -0.913899f,
	-0.914210f, -0.914520f, -0.914830f, -0.915140f, -0.915449f, -0.915757f, -0.916065f, -0.916372f,
	-0.916679f, -0.916985f, -0.917291f, -0.917596f, -0.917901f, -0.918205f, -0.918508f, -0.918811f,
	-0.919114f, -0.919416f, -0.919717f, -0.920018f, -0.920318f, -0.920618f, -0.920917f, -0.921216f,
	-0.921514f, -0.921812f, -0.922109f, -0.922405f, -0.922701f, -0.922997f, -0.923291f, -0.923586f,
	-0.923880f, -0.924173f, -0.924465f, -0.924758f, -0.925049f, -0.925340f, -0.925631f, -0.925921f,
	-0.926210f, -0.926499f, -0.926787f, -0.927075f, -0.927363f, -0.927649f, -0.927935f, -0.928221f,
	-0.928506f, -0.928791f, -0.929075f, -0.929358f, -0.929641f, -0.929923f, -0.930205f, -0.930486f,
	-0.930767f, -0.931047f, -0.931327f, -0.931606f, -0.931884f, -0.932162f, -0.932440f, -0.932716f,
	-0.932993f, -0.933269f, -0.933544f, -0.933818f, -0.934093f, -0.934366f, -0.934639f, -0.934912f,
	-0.935184f, -0.935455f, -0.935726f, -0.935996f, -0.936266f, -0.936535f, -0.936803f, -0.937072f,
	-0.937339f, -0.937606f, -0.937872f, -0.938138f, -0.938404f, -0.938668f, -0.938932f, -0.939196f,
	-0.939459f, -0.939722f, -0.939984f, -0.940245f, -0.940506f, -0.940766f, -0.941026f, -0.941285f,
	-0.941544f, -0.941802f, -0.942060f, -0.942317f, -0.942573f, -0.942829f, -0.943084f, -0.943339f,
	-0.943593f, -0.943847f, -0.944100f, -0.944353f, -0.944605f, -0.944856f, -0.945107f, -0.945358f,
	-0.945607f, -0.945857f, -0.946105f, -0.946353f, -0.946601f, -0.946848f, -0.947094f, -0.947340f,
	-0.947586f, -0.947830f, -0.948075f, -0.948318f, -0.948561f, -0.948804f, -0.949046f, -0.949287f,
	-0.949528f, -0.949768f, -0.950008f, -0.950247f, -0.950486f, -0.950724f, -0.950962f, -0.951199f,
	-0.951435f, -0.951671f, -0.951906f, -0.952141f, -0.952375f, -0.952609f, -0.952842f, -0.953074f,
	-0.953306f, -0.953537f, -0.953768f, -0.953998f, -0.954228f, -0.954457f, -0.954686f, -0.954914f,
	-0.955141f, -0.955368f, -0.955594f, -0.955820f, -0.956045f, -0.956270f, -0.956494f, -0.956717f,
	-0.956940f, -0.957163f, -0.957385f, -0.957606f, -0.957826f, -0.958046f, -0.958266f, -0.958485f,
	-0.958703f, -0.958921f, -0.959139f, -0.959355f, -0.959572f, -0.959787f, -0.960002f, -0.960217f,
	-0.960431f, -0.960644f, -0.960857f, -0.961069f, -0.961280f, -0.961492f, -0.961702f, -0.961912f,
	-0.962121f, -0.962330f, -0.962538f, -0.962746f, -0.962953f, -0.963160f, -0.963366f, -0.963571f,
	-0.963776f, -0.963980f, -0.964184f, -0.964387f, -0.964590f, -0.964792f, -0.964993f, -0.965194f,
	-0.965394f, -0.965594f, -0.965793f, -0.965992f, -0.966190f, -0.966387f, -0.966584f, -0.966781f,
	-0.966976f, -0.967172f, -0.967366f, -0.967560f, -0.967754f, -0.967947f, -0.968139f, -0.968331f,
	-0.968522f, -0.968713f, -0.968903f, -0.969092f, -0.969281f, -0.969470f, -0.969657f, -0.969845f,
	-0.970031f, -0.970217f, -0.970403f, -0.970588f, -0.970772f, -0.970956f, -0.971139f, -0.971322f,
	-0.971504f, -0.971685f, -0.971866f, -0.972047f, -0.972227f, -0.972406f, -0.972584f, -0.972762f,
	-0.972940f, -0.973117f, -0.973293f, -0.973469f, -0.973644f, -0.973819f, -0.973993f, -0.974166f,
	-0.974339f, -0.974512f, -0.974684f, -0.974855f, -0.975025f, -0.975195f, -0.975365f, -0.975534f,
	-0.975702f, -0.975870f, -0.976037f, -0.976204f, -0.976370f, -0.976535f, -0.976700f, -0.976864f,
	-0.977028f, -0.977191f, -0.977354f, -0.977516f, -0.977677f, -0.977838f, -0.977998f, -0.978158f,
	-0.978317f, -0.978476f, -0.978634f, -0.978791f, -0.978948f, -0.979104f, -0.979260f, -0.979415f,
	-0.979570f, -0.979724f, -0.979877f, -0.980030f, -0.980182f, -0.980334f, -0.980485f, -0.980635f,
	-0.980785f, -0.980935f, -0.981083f, -0.981232f, -0.981379f, -0.981526f, -0.981673f, -0.981819f,
	-0.981964f, -0.982109f, -0.982253f, -0.982396f, -0.982539f, -0.982682f, -0.982824f, -0.982965f,
	-0.983105f, -0.983246f, -0.983385f, -0.983524f, -0.983662f, -0.983800f, -0.983937f, -0.984074f,
	-0.984210f, -0.984346f, -0.984480f, -0.984615f, -0.984748f, -0.984882f, -0.985014f, -0.985146f,
	-0.985278f, -0.985408f, -0.985539f, -0.985668f, -0.985798f, -0.985926f, -0.986054f, -0.986181f,
	-0.986308f, -0.986434f, -0.986560f, -0.986685f, -0.986809f, -0.986933f, -0.987057f, -0.987179f,
	-0.987301f, -0.987423f, -0.987544f, -0.987664f, -0.987784f, -0.987903f, -0.988022f, -0.988140f,
	-0.988258f, -0.988374f, -0.988491f, -0.988607f, -0.988722f, -0.988836f, -0.988950f, -0.989064f,
	-0.989177f, -0.989289f, -0.989400f, -0.989511f, -0.989622f, -0.989732f, -0.989841f, -0.989950f,
	-0.990058f, -0.990166f, -0.990273f, -0.990379f, -0.990485f, -0.990590f, -0.990695f, -0.990799f,
	-0.990903f, -0.991006f, -0.991108f, -0.991210f, -0.991311f, -0.991411f, -0.991511f, -0.991611f,
	-0.991710f, -0.991808f, -0.991906f, -0.992003f, -0.992099f, -0.992195f, -0.992291f, -0.992385f,
	-0.992480f, -0.992573f, -0.992666f, -0.992759f, -0.992850f, -0.992942f, -0.993032f, -0.993122f,
	-0.993212f, -0.993301f, -0.993389f, -0.993477f, -0.993564f, -0.993651f, -0.993737f, -0.993822f,
	-0.993907f, -0.993991f, -0.994075f, -0.994158f, -0.994240f, -0.994322f, -0.994404f, -0.994484f,
	-0.994565f, -0.994644f, -0.994723f, -0.994802f, -0.994879f, -0.994957f, -0.995033f, -0.995109f,
	-0.995185f, -0.995260f, -0.995334f, -0.995408f, -0.995481f, -0.995553f, -0.995625f, -0.995697f,
	-0.995767f, -0.995838f, -0.995907f, -0.995976f, -0.996045f, -0.996113f, -0.996180f, -0.996247f,
	-0.996313f, -0.996378f, -0.996443f, -0.996507f, -0.996571f, -0.996634f, -0.996697f, -0.996759f,
	-0.996820f, -0.996881f, -0.996941f, -0.997001f, -0.997060f, -0.997119f, -0.997176f, -0.997234f,
	-0.997290f, -0.997347f, -0.997402f, -0.997457f, -0.997511f, -0.997565f, -0.997618f, -0.997671f,
	-0.997723f, -0.997774f, -0.997825f, -0.997876f, -0.997925f, -0.997974f, -0.998023f, -0.998071f,
	-0.998118f, -0.998165f, -0.998211f, -0.998257f, -0.998302f, -0.998346f, -0.998390f, -0.998433f,
	-0.998476f, -0.998518f, -0.998559f, -0.998600f, -0.998640f, -0.998680f, -0.998719f, -0.998758f,
	-0.998795f, -0.998833f, -0.998870f, -0.998906f, -0.998941f, -0.998976f, -0.999011f, -0.999044f,
	-0.999078f, -0.999110f, -0.999142f, -0.999174f, -0.999205f, -0.999235f, -0.999265f, -0.999294f,
	-0.999322f, -0.999350f, -0.999378f, -0.999404f, -0.999431f, -0.999456f, -0.999481f, -0.999506f,
	-0.999529f, -0.999553f, -0.999575f, -0.999597f, -0.999619f, -0.999640f, -0.999660f, -0.999680f,
	-0.999699f, -0.999717f, -0.999735f, -0.999753f, -0.999769f, -0.999786f, -0.999801f, -0.999816f,
	-0.999831f, -0.999844f, -0.999858f, -0.999870f, -0.999882f, -0.999894f, -0.999905f, -0.999915f,
	-0.999925f, -0.999934f, -0.999942f, -0.999950f, -0.999958f, -0.999964f, -0.999971f, -0.999976f,
	-0.999981f, -0.999986f, -0.999989f, -0.999993f, -0.999995f, -0.999997f, -0.999999f, -1.000000f
};

static const float sinTable16384[8192] = {
	 0.000000f,  0.000383f,  0.000767f,  0.001150f,  0.001534f,  0.001917f,  0.002301f,  0.002684f,
	 0.003068f,  0.003451f,  0.003835f,  0.004218f,  0.004602f,  0.004985f,  0.005369f,  0.005752f,
	 0.006136f,  0.006519f,  0.006903f,  0.007286f,  0.007670f,  0.008053f,  0.008437f,  0.008820f,
	 0.009204f,  0.009587f,  0.009971f,  0.010354f,  0.010738f,  0.011121f,  0.011505f,  0.011888f,
	 0.012272f,  0.012655f,  0.013038f,  0.013422f,  0.013805f,  0.014189f,  0.014572f,  0.014956f,
	 0.015339f,  0.015723f,  0.016106f,  0.016490f,  0.016873f,  0.017256f,  0.017640f,  0.018023f,
	 0.018407f,  0.018790f,  0.019174f,  0.019557f,  0.019940f,  0.020324f,  0.020707f,  0.021091f,
	 0.021474f,  0.021857f,  0.022241f,  0.022624f,  0.023008f,  0.023391f,  0.023774f,  0.024158f,
	 0.024541f,  0.024925f,  0.025308f,  0.025691f,  0.026075f,  0.026458f,  0.026841f,  0.027225f,
	 0.027608f,  0.027991f,  0.028375f,  0.028758f,  0.029142f,  0.029525f,  0.029908f,  0.030291f,
	 0.030675f,  0.031058f,  0.031441f,  0.031825f,  0.032208f,  0.032591f,  0.032975f,  0.033358f,
	 0.033741f,  0.034124f,  0.034508f,  0.034891f,  0.035274f,  0.035657f,  0.036041f,  0.036424f,
	 0.036807f,  0.037190f,  0.037574f,  0.037957f,  0.038340f,  0.038723f,  0.039107f,  0.039490f,
	 0.039873f,  0.040256f,  0.040639f,  0.041022f,  0.041406f,  0.041789f,  0.042172f,  0.042555f,
	 0.042938f,  0.043321f,  0.043705f,  0.044088f,  0.044471f,  0.044854f,  0.045237f,  0.045620f,
	 0.046003f,  0.046386f,  0.046769f,  0.047152f,  0.047535f,  0.047919f,  0.048302f,  0.048685f,
	 0.049068f,  0.049451f,  0.049834f,  0.050217f,  0.050600f,  0.050983f,  0.051366f,  0.051749f,
	 0.052132f,  0.052515f,  0.052898f,  0.053281f,  0.053664f,  0.054046f,  0.054429f,  0.054812f,
	 0.055195f,  0.055578f,  0.055961f,  0.056344f,  0.056727f,  0.057110f,  0.057493f,  0.057875f,
	 0.058258f,  0.058641f,  0.059024f,  0.059407f,  0.059790f,  0.060172f,  0.060555f,  0.060938f,
	 0.061321f,  0.061704f,  0.062086f,  0.062469f,  0.062852f,  0.063234f,  0.063617f,  0.064000f,
	 0.064383f,  0.064765f,  0.065148f,  0.065531f,  0.065913f,  0.066296f,  0.066679f,  0.067061f,
	 0.067444f,  0.067827f,  0.068209f,  0.068592f,  0.068974f,  0.069357f,  0.069739f,  0.070122f,
	 0.070505f,  0.070887f,  0.071270f,  0.071652f,  0.072035f,  0.072417f,  0.072800f,  0.073182f,
	 0.073565f,  0.073947f,  0.074329f,  0.074712f,  0.075094f,  0.075477f,  0.075859f,  0.076241f,
	 0.076624f,  0.077006f,  0.077389f,  0.077771f,  0.078153f,  0.078536f,  0.078918f,  0.079300f,
	 0.079682f,  0.080065f,  0.080447f,  0.080829f,  0.081211f,  0.081594f,  0.081976f,  0.082358f,
	 0.082740f,  0.083122f,  0.083505f,  0.083887f,  0.084269f,  0.084651f,  0.085033f,  0.085415f,
	 0.085797f,  0.086179f,  0.086561f,  0.086943f,  0.087326f,  0.087708f,  0.088090f,  0.088472f,
	 0.088854f,  0.089236f,  0.089617f,  0.089999f,  0.090381f,  0.090763f,  0.091145f,  0.091527f,
	 0.091909f,  0.092291f,  0.092673f,  0.093055f,  0.093436f,  0.093818f,  0.094200f,  0.094582f,
	 0.094963f,  0.095345f,  0.095727f,  0.096109f,  0.096490f,  0.096872f,  0.097254f,  0.097635f,
	 0.098017f,  0.098399f,  0.098780f,  0.099162f,  0.099544f,  0.099925f,  0.100307f,  0.100688f,
	 0.101070f,  0.101451f,  0.101833f,  0.102214f,  0.102596f,  0.102977f,  0.103359f,  0.103740f,
	 0.104122f,  0.104503f,  0.104884f,  0.105266f,  0.105647f,  0.106028f,  0.106410f,  0.106791f,
	 0.107172f,  0.107554f,  0.107935f,  0.108316f,  0.108697f,  0.109079f,  0.109460f,  0.109841f,
	 0.110222f,  0.110603f,  0.110984f,  0.111366f,  0.111747f,  0.112128f,  0.112509f,  0.112890f,
	 0.113271f,  0.113652f,  0.114033f,  0.114414f,  0.114795f,  0.115176f,  0.115557f,  0.115938f,
	 0.116319f,  0.116700f,  0.117080f,  0.117461f,  0.117842f,  0.118223f,  0.118604f,  0.118984f,
	 0.119365f,  0.119746f,  0.120127f,  0.120507f,  0.120888f,  0.121269f,  0.121649f,  0.122030f,
	 0.122411f,  0.122791f,  0.123172f,  0.123552f,  0.123933f,  0.124314f,  0.124694f,  0.125075f,
	 0.125455f,  0.125835f,  0.126216f,  0.126596f,  0.126977f,  0.127357f,  0.127737f,  0.128118f,
	 0.128498f,  0.128878f,  0.129259f,  0.129639f,  0.130019f,  0.130399f,  0.130780f,  0.131160f,
	 0.131540f,  0.131920f,  0.132300f,  0.132680f,  0.133061f,  0.133441f,  0.133821f,  0.134201f,
	 0.134581f,  0.134961f,  0.135341f,  0.135721f,  0.136101f,  0.136480f,  0.136860f,  0.137240f,
	 0.137620f,  0.138000f,  0.138380f,  0.138760f,  0.139139f,  0.139519f,  0.139899f,  0.140279f,
	 0.140658f,  0.141038f,  0.141418f,  0.141797f,  0.142177f,  0.142556f,  0.142936f,  0.143316f,
	 0.143695f,  0.144075f,  0.144454f,  0.144833f,  0.145213f,  0.145592f,  0.145972f,  0.146351f,
	 0.146730f,  0.147110f,  0.147489f,  0.147868f,  0.148248f,  0.148627f,  0.149006f,  0.149385f,
	 0.149765f,  0.150144f,  0.150523f,  0.150902f,  0.151281f,  0.151660f,  0.152039f,  0.152418f,
	 0.152797f,  0.153176f,  0.153555f,  0.153934f,  0.154313f,  0.154692f,  0.155071f,  0.155450f,
	 0.155828f,  0.156207f,  0.156586f,  0.156965f,  0.157343f,  0.157722f,  0.158101f,  0.158480f,
	 0.158858f,  0.159237f,  0.159615f,  0.159994f,  0.160372f,  0.160751f,  0.161129f,  0.161508f,
	 0.161886f,  0.162265f,  0.162643f,  0.163022f,  0.163400f,  0.163778f,  0.164157f,  0.164535f,
	 0.164913f,  0.165291f,  0.165670f,  0.166048f,  0.166426f,  0.166804f,  0.167182f,  0.167560f,
	 0.167938f,  0.168316f,  0.168694f,  0.169072f,  0.169450f,  0.169828f,  0.170206f,  0.170584f,
	 0.170962f,  0.171340f,  0.171718f,  0.172095f,  0.172473f,  0.172851f,  0.173229f,  0.173606f,
	 0.173984f,  0.174362f,  0.174739f,  0.175117f,  0.175494f,  0.175872f,  0.176249f,  0.176627f,
	 0.177004f,  0.177382f,  0.177759f,  0.178136f,  0.178514f,  0.178891f,  0.179268f,  0.179646f,
	 0.180023f,  0.180400f,  0.180777f,  0.181154f,  0.181532f,  0.181909f,  0.182286f,  0.182663f,
	 0.183040f,  0.183417f,  0.183794f,  0.184171f,  0.184548f,  0.184925f,  0.185301f,  0.185678f,
	 0.186055f,  0.186432f,  0.186809f,  0.187185f,  0.187562f,  0.187939f,  0.188315f,  0.188692f,
	 0.189069f,  0.189445f,  0.189822f,  0.190198f,  0.190575f,  0.190951f,  0.191328f,  0.191704f,
	 0.192080f,  0.192457f,  0.192833f,  0.193209f,  0.193586f,  0.193962f,  0.194338f,  0.194714f,
	 0.195090f,  0.195466f,  0.195843f,  0.196219f,  0.196595f,  0.196971f,  0.197347f,  0.197722f,
	 0.198098f,  0.198474f,  0.198850f,  0.199226f,  0.199602f,  0.199978f,  0.200353f,  0.200729f,
	 0.201105f,  0.201480f,  0.201856f,  0.202231f,  0.202607f,  0.202983f,  0.203358f,  0.203734f,
	 0.204109f,  0.204484f,  0.204860f,  0.205235f,  0.205610f,  0.205986f,  0.206361f,  0.206736f,
	 0.207111f,  0.207487f,  0.207862f,  0.208237f,  0.208612f,  0.208987f,  0.209362f,  0.209737f,
	 0.210112f,  0.210487f,  0.210862f,  0.211237f,  0.211611f,  0.211986f,  0.212361f,  0.212736f,
	 0.213110f,  0.213485f,  0.213860f,  0.214234f,  0.214609f,  0.214983f,  0.215358f,  0.215732f,
	 0.216107f,  0.216481f,  0.216856f,  0.217230f,  0.217604f,  0.217979f,  0.218353f,  0.218727f,
	 0.219101f,  0.219475f,  0.219850f,  0.220224f,  0.220598f,  0.220972f,  0.221346f,  0.221720f,
	 0.222094f,  0.222468f,  0.222841f,  0.223215f,  0.223589f,  0.223963f,  0.224337f,  0.224710f,
	 0.225084f,  0.225458f,  0.225831f,  0.226205f,  0.226578f,  0.226952f,  0.227325f,  0.227699f,
	 0.228072f,  0.228445f,  0.228819f,  0.229192f,  0.229565f,  0.229939f,  0.230312f,  0.230685f,
	 0.231058f,  0.231431f,  0.231804f,  0.232177f,  0.232550f,  0.232923f,  0.233296f,  0.233669f,
	 0.234042f,  0.234415f,  0.234788f,  0.235160f,  0.235533f,  0.235906f,  0.236278f,  0.236651f,
	 0.237024f,  0.237396f,  0.237769f,  0.238141f,  0.238514f,  0.238886f,  0.239258f,  0.239631f,
	 0.240003f,  0.240375f,  0.240748f,  0.241120f,  0.241492f,  0.241864f,  0.242236f,  0.242608f,
	 0.242980f,  0.243352f,  0.243724f,  0.244096f,  0.244468f,  0.244840f,  0.245212f,  0.245583f,
	 0.245955f,  0.246327f,  0.246698f,  0.247070f,  0.247442f,  0.247813f,  0.248185f,  0.248556f,
	 0.248928f,  0.249299f,  0.249670f,  0.250042f,  0.250413f,  0.250784f,  0.251155f,  0.251527f,
	 0.251898f,  0.252269f,  0.252640f,  0.253011f,  0.253382f,  0.253753f,  0.254124f,  0.254495f,
	 0.254866f,  0.255236f,  0.255607f,  0.255978f,  0.256349f,  0.256719f,  0.257090f,  0.257461f,
	 0.257831f,  0.258202f,  0.258572f,  0.258943f,  0.259313f,  0.259683f,  0.260054f,  0.260424f,
	 0.260794f,  0.261164f,  0.261534f,  0.261905f,  0.262275f,  0.262645f,  0.263015f,  0.263385f,
	 0.263755f,  0.264125f,  0.264494f,  0.264864f,  0.265234f,  0.265604f,  0.265973f,  0.266343f,
	 0.266713f,  0.267082f,  0.267452f,  0.267821f,  0.268191f,  0.268560f,  0.268930f,  0.269299f,
	 0.269668f,  0.270038f,  0.270407f,  0.270776f,  0.271145f,  0.271514f,  0.271883f,  0.272252f,
	 0.272621f,  0.272990f,  0.273359f,  0.273728f,  0.274097f,  0.274466f,  0.274834f,  0.275203f,
	 0.275572f,  0.275940f,  0.276309f,  0.276678f,  0.277046f,  0.277415f,  0.277783f,  0.278151f,
	 0.278520f,  0.278888f,  0.279256f,  0.279624f,  0.279993f,  0.280361f,  0.280729f,  0.281097f,
	 0.281465f,  0.281833f,  0.282201f,  0.282569f,  0.282937f,  0.283304f,  0.283672f,  0.284040f,
	 0.284408f,  0.284775f,  0.285143f,  0.285510f,  0.285878f,  0.286245f,  0.286613f,  0.286980f,
	 0.287347f,  0.287715f,  0.288082f,  0.288449f,  0.288816f,  0.289184f,  0.289551f,  0.289918f,
	 0.290285f,  0.290652f,  0.291019f,  0.291385f,  0.291752f,  0.292119f,  0.292486f,  0.292852f,
	 0.293219f,  0.293586f,  0.293952f,  0.294319f,  0.294685f,  0.295052f,  0.295418f,  0.295785f,
	 0.296151f,  0.296517f,  0.296883f,  0.297250f,  0.297616f,  0.297982f,  0.298348f,  0.298714f,
	 0.299080f,  0.299446f,  0.299812f,  0.300177f,  0.300543f,  0.300909f,  0.301275f,  0.301640f,
	 0.302006f,  0.302372f,  0.302737f,  0.303103f,  0.303468f,  0.303833f,  0.304199f,  0.304564f,
	 0.304929f,  0.305294f,  0.305660f,  0.306025f,  0.306390f,  0.306755f,  0.307120f,  0.307485f,
	 0.307850f,  0.308214f,  0.308579f,  0.308944f,  0.309309f,  0.309673f,  0.310038f,  0.310403f,
	 0.310767f,  0.311132f,  0.311496f,  0.311860f,  0.312225f,  0.312589f,  0.312953f,  0.313318f,
	 0.313682f,  0.314046f,  0.314410f,  0.314774f,  0.315138f,  0.315502f,  0.315866f,  0.316230f,
	 0.316593f,  0.316957f,  0.317321f,  0.317684f,  0.318048f,  0.318412f,  0.318775f,  0.319139f,
	 0.319502f,  0.319865f,  0.320229f,  0.320592f,  0.320955f,  0.321318f,  0.321682f,  0.322045f,
	 0.322408f,  0.322771f,  0.323134f,  0.323497f,  0.323859f,  0.324222f,  0.324585f,  0.324948f,
	 0.325310f,  0.325673f,  0.326035f,  0.326398f,  0.326760f,  0.327123f,  0.327485f,  0.327848f,
	 0.328210f,  0.328572f,  0.328934f,  0.329296f,  0.329658f,  0.330020f,  0.330382f,  0.330744f,
	 0.331106f,  0.331468f,  0.331830f,  0.332192f,  0.332553f,  0.332915f,  0.333277f,  0.333638f,
	 0.334000f,  0.334361f,  0.334722f,  0.335084f,  0.335445f,  0.335806f,  0.336168f,  0.336529f,
	 0.336890f,  0.337251f,  0.337612f,  0.337973f,  0.338334f,  0.338695f,  0.339055f,  0.339416f,
	 0.339777f,  0.340138f,  0.340498f,  0.340859f,  0.341219f,  0.341580f,  0.341940f,  0.342300f,
	 0.342661f,  0.343021f,  0.343381f,  0.343741f,  0.344101f,  0.344461f,  0.344821f,  0.345181f,
	 0.345541f,  0.345901f,  0.346261f,  0.346621f,  0.346980f,  0.347340f,  0.347700f,  0.348059f,
	 0.348419f,  0.348778f,  0.349138f,  0.349497f,  0.349856f,  0.350215f,  0.350575f,  0.350934f,
	 0.351293f,  0.351652f,  0.352011f,  0.352370f,  0.352729f,  0.353087f,  0.353446f,  0.353805f,
	 0.354164f,  0.354522f,  0.354881f,  0.355239f,  0.355598f,  0.355956f,  0.356314f,  0.356673f,
	 0.357031f,  0.357389f,  0.357747f,  0.358105f,  0.358463f,  0.358821f,  0.359179f,  0.359537f,
	 0.359895f,  0.360253f,  0.360611f,  0.360968f,  0.361326f,  0.361683f,  0.362041f,  0.362398f,
	 0.362756f,  0.363113f,  0.363470f,  0.363828f,  0.364185f,  0.364542f,  0.364899f,  0.365256f,
	 0.365613f,  0.365970f,  0.366327f,  0.366684f,  0.367040f,  0.367397f,  0.367754f,  0.368110f,
	 0.368467f,  0.368823f,  0.369180f,  0.369536f,  0.369892f,  0.370249f,  0.370605f,  0.370961f,
	 0.371317f,  0.371673f,  0.372029f,  0.372385f,  0.372741f,  0.373097f,  0.373453f,  0.373808f,
	 0.374164f,  0.374520f,  0.374875f,  0.375231f,  0.375586f,  0.375942f,  0.376297f,  0.376652f,
	 0.377007f,  0.377363f,  0.377718f,  0.378073f,  0.378428f,  0.378783f,  0.379138f,  0.379492f,
	 0.379847f,  0.380202f,  0.380557f,  0.380911f,  0.381266f,  0.381620f,  0.381975f,  0.382329f,
	 0.382683f,  0.383038f,  0.383392f,  0.383746f,  0.384100f,  0.384454f,  0.384808f,  0.385162f,
	 0.385516f,  0.385870f,  0.386224f,  0.386577f,  0.386931f,  0.387285f,  0.387638f,  0.387992f,
	 0.388345f,  0.388698f,  0.389052f,  0.389405f,  0.389758f,  0.390111f,  0.390464f,  0.390817f,
	 0.391170f,  0.391523f,  0.391876f,  0.392229f,  0.392582f,  0.392934f,  0.393287f,  0.393640f,
	 0.393992f,  0.394344f,  0.394697f,  0.395049f,  0.395401f,  0.395754f,  0.396106f,  0.396458f,
	 0.396810f,  0.397162f,  0.397514f,  0.397866f,  0.398218f,  0.398569f,  0.398921f,  0.399273f,
	 0.399624f,  0.399976f,  0.400327f,  0.400679f,  0.401030f,  0.401381f,  0.401732f,  0.402084f,
	 0.402435f,  0.402786f,  0.403137f,  0.403488f,  0.403838f,  0.404189f,  0.404540f,  0.404891f,
	 0.405241f,  0.405592f,  0.405942f,  0.406293f,  0.406643f,  0.406994f,  0.407344f,  0.407694f,
	 0.408044f,  0.408394f,  0.408744f,  0.409094f,  0.409444f,  0.409794f,  0.410144f,  0.410493f,
	 0.410843f,  0.411193f,  0.411542f,  0.411892f,  0.412241f,  0.412591f,  0.412940f,  0.413289f,
	 0.413638f,  0.413987f,  0.414337f,  0.414685f,  0.415034f,  0.415383f,  0.415732f,  0.416081f,
	 0.416430f,  0.416778f,  0.417127f,  0.417475f,  0.417824f,  0.418172f,  0.418520f,  0.418869f,
	 0.419217f,  0.419565f,  0.419913f,  0.420261f,  0.420609f,  0.420957f,  0.421305f,  0.421653f,
	 0.422000f,  0.422348f,  0.422695f,  0.423043f,  0.423390f,  0.423738f,  0.424085f,  0.424432f,
	 0.424780f,  0.425127f,  0.425474f,  0.425821f,  0.426168f,  0.426515f,  0.426862f,  0.427208f,
	 0.427555f,  0.427902f,  0.428248f,  0.428595f,  0.428941f,  0.429288f,  0.429634f,  0.429980f,
	 0.430326f,  0.430673f,  0.431019f,  0.431365f,  0.431711f,  0.432057f,  0.432402f,  0.432748f,
	 0.433094f,  0.433439f,  0.433785f,  0.434131f,  0.434476f,  0.434821f,  0.435167f,  0.435512f,
	 0.435857f,  0.436202f,  0.436547f,  0.436892f,  0.437237f,  0.437582f,  0.437927f,  0.438272f,
	 0.438616f,  0.438961f,  0.439305f,  0.439650f,  0.439994f,  0.440339f,  0.440683f,  0.441027f,
	 0.441371f,  0.441715f,  0.442059f,  0.442403f,  0.442747f,  0.443091f,  0.443435f,  0.443779f,
	 0.444122f,  0.444466f,  0.444809f,  0.445153f,  0.445496f,  0.445839f,  0.446183f,  0.446526f,
	 0.446869f,  0.447212f,  0.447555f,  0.447898f,  0.448241f,  0.448583f,  0.448926f,  0.449269f,
	 0.449611f,  0.449954f,  0.450296f,  0.450639f,  0.450981f,  0.451323f,  0.451665f,  0.452008f,
	 0.452350f,  0.452692f,  0.453033f,  0.453375f,  0.453717f,  0.454059f,  0.454400f,  0.454742f,
	 0.455084f,  0.455425f,  0.455766f,  0.456108f,  0.456449f,  0.456790f,  0.457131f,  0.457472f,
	 0.457813f,  0.458154f,  0.458495f,  0.458836f,  0.459177f,  0.459517f,  0.459858f,  0.460198f,
	 0.460539f,  0.460879f,  0.461219f,  0.461560f,  0.461900f,  0.462240f,  0.462580f,  0.462920f,
	 0.463260f,  0.463600f,  0.463939f,  0.464279f,  0.464619f,  0.464958f,  0.465298f,  0.465637f,
	 0.465977f,  0.466316f,  0.466655f,  0.466994f,  0.467333f,  0.467672f,  0.468011f,  0.468350f,
	 0.468689f,  0.469028f,  0.469366f,  0.469705f,  0.470043f,  0.470382f,  0.470720f,  0.471058f,
	 0.471397f,  0.471735f,  0.472073f,  0.472411f,  0.472749f,  0.473087f,  0.473425f,  0.473763f,
	 0.474100f,  0.474438f,  0.474775f,  0.475113f,  0.475450f,  0.475788f,  0.476125f,  0.476462f,
	 0.476799f,  0.477136f,  0.477473f,  0.477810f,  0.478147f,  0.478484f,  0.478821f,  0.479157f,
	 0.479494f,  0.479830f,  0.480167f,  0.480503f,  0.480839f,  0.481176f,  0.481512f,  0.481848f,
	 0.482184f,  0.482520f,  0.482856f,  0.483191f,  0.483527f,  0.483863f,  0.484198f,  0.484534f,
	 0.484869f,  0.485205f,  0.485540f,  0.485875f,  0.486210f,  0.486545f,  0.486880f,  0.487215f,
	 0.487550f,  0.487885f,  0.488220f,  0.488554f,  0.488889f,  0.489223f,  0.489558f,  0.489892f,
	 0.490226f,  0.490561f,  0.490895f,  0.491229f,  0.491563f,  0.491897f,  0.492231f,  0.492564f,
	 0.492898f,  0.493232f,  0.493565f,  0.493899f,  0.494232f,  0.494566f,  0.494899f,  0.495232f,
	 0.495565f,  0.495898f,  0.496231f,  0.496564f,  0.496897f,  0.497230f,  0.497562f,  0.497895f,
	 0.498228f,  0.498560f,  0.498893f,  0.499225f,  0.499557f,  0.499889f,  0.500221f,  0.500553f,
	 0.500885f,  0.501217f,  0.501549f,  0.501881f,  0.502212f,  0.502544f,  0.502876f,  0.503207f,
	 0.503538f,  0.503870f,  0.504201f,  0.504532f,  0.504863f,  0.505194f,  0.505525f,  0.505856f,
	 0.506187f,  0.506517f,  0.506848f,  0.507179f,  0.507509f,  0.507839f,  0.508170f,  0.508500f,
	 0.508830f,  0.509160f,  0.509490f,  0.509820f,  0.510150f,  0.510480f,  0.510810f,  0.511139f,
	 0.511469f,  0.511798f,  0.512128f,  0.512457f,  0.512786f,  0.513116f,  0.513445f,  0.513774f,
	 0.514103f,  0.514432f,  0.514760f,  0.515089f,  0.515418f,  0.515746f,  0.516075f,  0.516403f,
	 0.516732f,  0.517060f,  0.517388f,  0.517716f,  0.518045f,  0.518372f,  0.518700f,  0.519028f,
	 0.519356f,  0.519684f,  0.520011f,  0.520339f,  0.520666f,  0.520994f,  0.521321f,  0.521648f,
	 0.521975f,  0.522302f,  0.522629f,  0.522956f,  0.523283f,  0.523610f,  0.523937f,  0.524263f,
	 0.524590f,  0.524916f,  0.525243f,  0.525569f,  0.525895f,  0.526221f,  0.526547f,  0.526873f,
	 0.527199f,  0.527525f,  0.527851f,  0.528176f,  0.528502f,  0.528828f,  0.529153f,  0.529478f,
	 0.529804f,  0.530129f,  0.530454f,  0.530779f,  0.531104f,  0.531429f,  0.531754f,  0.532078f,
	 0.532403f,  0.532728f,  0.533052f,  0.533377f,  0.533701f,  0.534025f,  0.534349f,  0.534674f,
	 0.534998f,  0.535322f,  0.535645f,  0.535969f,  0.536293f,  0.536617f,  0.536940f,  0.537264f,
	 0.537587f,  0.537910f,  0.538234f,  0.538557f,  0.538880f,  0.539203f,  0.539526f,  0.539849f,
	 0.540171f,  0.540494f,  0.540817f,  0.541139f,  0.541462f,  0.541784f,  0.542106f,  0.542429f,
	 0.542751f,  0.543073f,  0.543395f,  0.543717f,  0.544039f,  0.544360f,  0.544682f,  0.545003f,
	 0.545325f,  0.545646f,  0.545968f,  0.546289f,  0.546610f,  0.546931f,  0.547252f,  0.547573f,
	 0.547894f,  0.548215f,  0.548536f,  0.548856f,  0.549177f,  0.549497f,  0.549818f,  0.550138f,
	 0.550458f,  0.550778f,  0.551098f,  0.551418f,  0.551738f,  0.552058f,  0.552378f,  0.552697f,
	 0.553017f,  0.553336f,  0.553656f,  0.553975f,  0.554294f,  0.554613f,  0.554932f,  0.555251f,
	 0.555570f,  0.555889f,  0.556208f,  0.556526f,  0.556845f,  0.557164f,  0.557482f,  0.557800f,
	 0.558119f,  0.558437f,  0.558755f,  0.559073f,  0.559391f,  0.559709f,  0.560026f,  0.560344f,
	 0.560662f,  0.560979f,  0.561297f,  0.561614f,  0.561931f,  0.562248f,  0.562565f,  0.562882f,
	 0.563199f,  0.563516f,  0.563833f,  0.564150f,  0.564466f,  0.564783f,  0.565099f,  0.565416f,
	 0.565732f,  0.566048f,  0.566364f,  0.566680f,  0.566996f,  0.567312f,  0.567628f,  0.567943f,
	 0.568259f,  0.568574f,  0.568890f,  0.569205f,  0.569521f,  0.569836f,  0.570151f,  0.570466f,
	 0.570781f,  0.571096f,  0.571410f,  0.571725f,  0.572040f,  0.572354f,  0.572669f,  0.572983f,
	 0.573297f,  0.573611f,  0.573925f,  0.574239f,  0.574553f,  0.574867f,  0.575181f,  0.575495f,
	 0.575808f,  0.576122f,  0.576435f,  0.576748f,  0.577062f,  0.577375f,  0.577688f,  0.578001f,
	 0.578314f,  0.578627f,  0.578939f,  0.579252f,  0.579565f,  0.579877f,  0.580189f,  0.580502f,
	 0.580814f,  0.581126f,  0.581438f,  0.581750f,  0.582062f,  0.582374f,  0.582685f,  0.582997f,
	 0.583309f,  0.583620f,  0.583931f,  0.584243f,  0.584554f,  0.584865f,  0.585176f,  0.585487f,
	 0.585798f,  0.586109f,  0.586419f,  0.586730f,  0.587040f,  0.587351f,  0.587661f,  0.587971f,
	 0.588282f,  0.588592f,  0.588902f,  0.589212f,  0.589521f,  0.589831f,  0.590141f,  0.590450f,
	 0.590760f,  0.591069f,  0.591378f,  0.591688f,  0.591997f,  0.592306f,  0.592615f,  0.592924f,
	 0.593232f,  0.593541f,  0.593850f,  0.594158f,  0.594467f,  0.594775f,  0.595083f,  0.595391f,
	 0.595699f,  0.596007f,  0.596315f,  0.596623f,  0.596931f,  0.597238f,  0.597546f,  0.597853f,
	 0.598161f,  0.598468f,  0.598775f,  0.599082f,  0.599389f,  0.599696f,  0.600003f,  0.600310f,
	 0.600616f,  0.600923f,  0.601230f,  0.601536f,  0.601842f,  0.602148f,  0.602455f,  0.602761f,
	 0.603067f,  0.603372f,  0.603678f,  0.603984f,  0.604290f,  0.604595f,  0.604900f,  0.605206f,
	 0.605511f,  0.605816f,  0.606121f,  0.606426f,  0.606731f,  0.607036f,  0.607341f,  0.607645f,
	 0.607950f,  0.608254f,  0.608559f,  0.608863f,  0.609167f,  0.609471f,  0.609775f,  0.610079f,
	 0.610383f,  0.610687f,  0.610990f,  0.611294f,  0.611597f,  0.611901f,  0.612204f,  0.612507f,
	 0.612810f,  0.613113f,  0.613416f,  0.613719f,  0.614022f,  0.614324f,  0.614627f,  0.614929f,
	 0.615232f,  0.615534f,  0.615836f,  0.616138f,  0.616440f,  0.616742f,  0.617044f,  0.617346f,
	 0.617647f,  0.617949f,  0.618250f,  0.618552f,  0.618853f,  0.619154f,  0.619455f,  0.619756f,
	 0.620057f,  0.620358f,  0.620659f,  0.620959f,  0.621260f,  0.621560f,  0.621861f,  0.622161f,
	 0.622461f,  0.622761f,  0.623061f,  0.623361f,  0.623661f,  0.623961f,  0.624260f,  0.624560f,
	 0.624860f,  0.625159f,  0.625458f,  0.625757f,  0.626056f,  0.626355f,  0.626654f,  0.626953f,
	 0.627252f,  0.627550f,  0.627849f,  0.628147f,  0.628446f,  0.628744f,  0.629042f,  0.629340f,
	 0.629638f,  0.629936f,  0.630234f,  0.630532f,  0.630829f,  0.631127f,  0.631424f,  0.631721f,
	 0.632019f,  0.632316f,  0.632613f,  0.632910f,  0.633207f,  0.633504f,  0.633800f,  0.634097f,
	 0.634393f,  0.634690f,  0.634986f,  0.635282f,  0.635578f,  0.635874f,  0.636170f,  0.636466f,
	 0.636762f,  0.637057f,  0.637353f,  0.637649f,  0.637944f,  0.638239f,  0.638534f,  0.638829f,
	 0.639124f,  0.639419f,  0.639714f,  0.640009f,  0.640303f,  0.640598f,  0.640892f,  0.641187f,
	 0.641481f,  0.641775f,  0.642069f,  0.642363f,  0.642657f,  0.642951f,  0.643245f,  0.643538f,
	 0.643832f,  0.644125f,  0.644418f,  0.644711f,  0.645005f,  0.645298f,  0.645590f,  0.645883f,
	 0.646176f,  0.646469f,  0.646761f,  0.647054f,  0.647346f,  0.647638f,  0.647930f,  0.648222f,
	 0.648514f,  0.648806f,  0.649098f,  0.649390f,  0.649681f,  0.649973f,  0.650264f,  0.650555f,
	 0.650847f,  0.651138f,  0.651429f,  0.651720f,  0.652011f,  0.652301f,  0.652592f,  0.652882f,
	 0.653173f,  0.653463f,  0.653753f,  0.654044f,  0.654334f,  0.654624f,  0.654913f,  0.655203f,
	 0.655493f,  0.655782f,  0.656072f,  0.656361f,  0.656651f,  0.656940f,  0.657229f,  0.657518f,
	 0.657807f,  0.658095f,  0.658384f,  0.658673f,  0.658961f,  0.659250f,  0.659538f,  0.659826f,
	 0.660114f,  0.660402f,  0.660690f,  0.660978f,  0.661266f,  0.661553f,  0.661841f,  0.662128f,
	 0.662416f,  0.662703f,  0.662990f,  0.663277f,  0.663564f,  0.663851f,  0.664138f,  0.664424f,
	 0.664711f,  0.664997f,  0.665284f,  0.665570f,  0.665856f,  0.666142f,  0.666428f,  0.666714f,
	 0.667000f,  0.667286f,  0.667571f,  0.667857f,  0.668142f,  0.668427f,  0.668712f,  0.668998f,
	 0.669283f,  0.669567f,  0.669852f,  0.670137f,  0.670422f,  0.670706f,  0.670990f,  0.671275f,
	 0.671559f,  0.671843f,  0.672127f,  0.672411f,  0.672695f,  0.672978f,  0.673262f,  0.673546f,
	 0.673829f,  0.674112f,  0.674396f,  0.674679f,  0.674962f,  0.675245f,  0.675527f,  0.675810f,
	 0.676093f,  0.676375f,  0.676658f,  0.676940f,  0.677222f,  0.677504f,  0.677786f,  0.678068f,
	 0.678350f,  0.678632f,  0.678913f,  0.679195f,  0.679476f,  0.679758f,  0.680039f,  0.680320f,
	 0.680601f,  0.680882f,  0.681163f,  0.681443f,  0.681724f,  0.682005f,  0.682285f,  0.682565f,
	 0.682846f,  0.683126f,  0.683406f,  0.683686f,  0.683965f,  0.684245f,  0.684525f,  0.684804f,
	 0.685084f,  0.685363f,  0.685642f,  0.685921f,  0.686200f,  0.686479f,  0.686758f,  0.687037f,
	 0.687315f,  0.687594f,  0.687872f,  0.688151f,  0.688429f,  0.688707f,  0.688985f,  0.689263f,
	 0.689541f,  0.689818f,  0.690096f,  0.690373f,  0.690651f,  0.690928f,  0.691205f,  0.691482f,
	 0.691759f,  0.692036f,  0.692313f,  0.692590f,  0.692866f,  0.693143f,  0.693419f,  0.693695f,
	 0.693971f,  0.694248f,  0.694524f,  0.694799f,  0.695075f,  0.695351f,  0.695626f,  0.695902f,
	 0.696177f,  0.696452f,  0.696728f,  0.697003f,  0.697277f,  0.697552f,  0.697827f,  0.698102f,
	 0.698376f,  0.698651f,  0.698925f,  0.699199f,  0.699473f,  0.699747f,  0.700021f,  0.700295f,
	 0.700569f,  0.700842f,  0.701116f,  0.701389f,  0.701663f,  0.701936f,  0.702209f,  0.702482f,
	 0.702755f,  0.703028f,  0.703300f,  0.703573f,  0.703845f,  0.704118f,  0.704390f,  0.704662f,
	 0.704934f,  0.705206f,  0.705478f,  0.705750f,  0.706021f,  0.706293f,  0.706564f,  0.706836f,
	 0.707107f,  0.707378f,  0.707649f,  0.707920f,  0.708191f,  0.708461f,  0.708732f,  0.709002f,
	 0.709273f,  0.709543f,  0.709813f,  0.710083f,  0.710353f,  0.710623f,  0.710893f,  0.711163f,
	 0.711432f,  0.711702f,  0.711971f,  0.712240f,  0.712509f,  0.712778f,  0.713047f,  0.713316f,
	 0.713585f,  0.713853f,  0.714122f,  0.714390f,  0.714659f,  0.714927f,  0.715195f,  0.715463f,
	 0.715731f,  0.715999f,  0.716266f,  0.716534f,  0.716801f,  0.717069f,  0.717336f,  0.717603f,
	 0.717870f,  0.718137f,  0.718404f,  0.718670f,  0.718937f,  0.719204f,  0.719470f,  0.719736f,
	 0.720003f,  0.720269f,  0.720535f,  0.720800f,  0.721066f,  0.721332f,  0.721597f,  0.721863f,
	 0.722128f,  0.722393f,  0.722659f,  0.722924f,  0.723188f,  0.723453f,  0.723718f,  0.723983f,
	 0.724247f,  0.724511f,  0.724776f,  0.725040f,  0.725304f,  0.725568f,  0.725832f,  0.726095f,
	 0.726359f,  0.726623f,  0.726886f,  0.727149f,  0.727413f,  0.727676f,  0.727939f,  0.728202f,
	 0.728464f,  0.728727f,  0.728990f,  0.729252f,  0.729514f,  0.729777f,  0.730039f,  0.730301f,
	 0.730563f,  0.730825f,  0.731086f,  0.731348f,  0.731609f,  0.731871f,  0.732132f,  0.732393f,
	 0.732654f,  0.732915f,  0.733176f,  0.733437f,  0.733697f,  0.733958f,  0.734218f,  0.734479f,
	 0.734739f,  0.734999f,  0.735259f,  0.735519f,  0.735779f,  0.736038f,  0.736298f,  0.736557f,
	 0.736817f,  0.737076f,  0.737335f,  0.737594f,  0.737853f,  0.738112f,  0.738370f,  0.738629f,
	 0.738887f,  0.739146f,  0.739404f,  0.739662f,  0.739920f,  0.740178f,  0.740436f,  0.740694f,
	 0.740951f,  0.741209f,  0.741466f,  0.741723f,  0.741980f,  0.742237f,  0.742494f,  0.742751f,
	 0.743008f,  0.743265f,  0.743521f,  0.743777f,  0.744034f,  0.744290f,  0.744546f,  0.744802f,
	 0.745058f,  0.745314f,  0.745569f,  0.745825f,  0.746080f,  0.746335f,  0.746591f,  0.746846f,
	 0.747101f,  0.747355f,  0.747610f,  0.747865f,  0.748119f,  0.748374f,  0.748628f,  0.748882f,
	 0.749136f,  0.749390f,  0.749644f,  0.749898f,  0.750152f,  0.750405f,  0.750659f,  0.750912f,
	 0.751165f,  0.751418f,  0.751671f,  0.751924f,  0.752177f,  0.752429f,  0.752682f,  0.752934f,
	 0.753187f,  0.753439f,  0.753691f,  0.753943f,  0.754195f,  0.754447f,  0.754698f,  0.754950f,
	 0.755201f,  0.755453f,  0.755704f,  0.755955f,  0.756206f,  0.756457f,  0.756708f,  0.756958f,
	 0.757209f,  0.757459f,  0.757710f,  0.757960f,  0.758210f,  0.758460f,  0.758710f,  0.758960f,
	 0.759209f,  0.759459f,  0.759708f,  0.759957f,  0.760207f,  0.760456f,  0.760705f,  0.760954f,
	 0.761202f,  0.761451f,  0.761700f,  0.761948f,  0.762196f,  0.762444f,  0.762693f,  0.762941f,
	 0.763188f,  0.763436f,  0.763684f,  0.763931f,  0.764179f,  0.764426f,  0.764673f,  0.764920f,
	 0.765167f,  0.765414f,  0.765661f,  0.765907f,  0.766154f,  0.766400f,  0.766647f,  0.766893f,
	 0.767139f,  0.767385f,  0.767631f,  0.767876f,  0.768122f,  0.768368f,  0.768613f,  0.768858f,
	 0.769103f,  0.769348f,  0.769593f,  0.769838f,  0.770083f,  0.770327f,  0.770572f,  0.770816f,
	 0.771061f,  0.771305f,  0.771549f,  0.771793f,  0.772036f,  0.772280f,  0.772524f,  0.772767f,
	 0.773010f,  0.773254f,  0.773497f,  0.773740f,  0.773983f,  0.774225f,  0.774468f,  0.774711f,
	 0.774953f,  0.775195f,  0.775438f,  0.775680f,  0.775922f,  0.776164f,  0.776405f,  0.776647f,
	 0.776888f,  0.777130f,  0.777371f,  0.777612f,  0.777853f,  0.778094f,  0.778335f,  0.778576f,
	 0.778817f,  0.779057f,  0.779297f,  0.779538f,  0.779778f,  0.780018f,  0.780258f,  0.780498f,
	 0.780737f,  0.780977f,  0.781216f,  0.781456f,  0.781695f,  0.781934f,  0.782173f,  0.782412f,
	 0.782651f,  0.782889f,  0.783128f,  0.783366f,  0.783605f,  0.783843f,  0.784081f,  0.784319f,
	 0.784557f,  0.784794f,  0.785032f,  0.785269f,  0.785507f,  0.785744f,  0.785981f,  0.786218f,
	 0.786455f,  0.786692f,  0.786929f,  0.787165f,  0.787402f,  0.787638f,  0.787874f,  0.788110f,
	 0.788346f,  0.788582f,  0.788818f,  0.789054f,  0.789289f,  0.789525f,  0.789760f,  0.789995f,
	 0.790230f,  0.790465f,  0.790700f,  0.790935f,  0.791169f,  0.791404f,  0.791638f,  0.791872f,
	 0.792107f,  0.792341f,  0.792575f,  0.792808f,  0.793042f,  0.793276f,  0.793509f,  0.793742f,
	 0.793975f,  0.794209f,  0.794442f,  0.794674f,  0.794907f,  0.795140f,  0.795372f,  0.795605f,
	 0.795837f,  0.796069f,  0.796301f,  0.796533f,  0.796765f,  0.796996f,  0.797228f,  0.797459f,
	 0.797691f,  0.797922f,  0.798153f,  0.798384f,  0.798615f,  0.798846f,  0.799076f,  0.799307f,
	 0.799537f,  0.799768f,  0.799998f,  0.800228f,  0.800458f,  0.800687f,  0.800917f,  0.801147f,
	 0.801376f,  0.801606f,  0.801835f,  0.802064f,  0.802293f,  0.802522f,  0.802750f,  0.802979f,
	 0.803208f,  0.803436f,  0.803664f,  0.803892f,  0.804120f,  0.804348f,  0.804576f,  0.804804f,
	 0.805031f,  0.805259f,  0.805486f,  0.805713f,  0.805940f,  0.806167f,  0.806394f,  0.806621f,
	 0.806848f,  0.807074f,  0.807300f,  0.807527f,  0.807753f,  0.807979f,  0.808205f,  0.808430f,
	 0.808656f,  0.808882f,  0.809107f,  0.809332f,  0.809558f,  0.809783f,  0.810008f,  0.810232f,
	 0.810457f,  0.810682f,  0.810906f,  0.811131f,  0.811355f,  0.811579f,  0.811803f,  0.812027f,
	 0.812251f,  0.812474f,  0.812698f,  0.812921f,  0.813144f,  0.813368f,  0.813591f,  0.813814f,
	 0.814036f,  0.814259f,  0.814482f,  0.814704f,  0.814926f,  0.815149f,  0.815371f,  0.815593f,
	 0.815814f,  0.816036f,  0.816258f,  0.816479f,  0.816701f,  0.816922f,  0.817143f,  0.817364f,
	 0.817585f,  0.817806f,  0.818026f,  0.818247f,  0.818467f,  0.818687f,  0.818908f,  0.819128f,
	 0.819348f,  0.819567f,  0.819787f,  0.820007f,  0.820226f,  0.820445f,  0.820664f,  0.820884f,
	 0.821102f,  0.821321f,  0.821540f,  0.821759f,  0.821977f,  0.822195f,  0.822414f,  0.822632f,
	 0.822850f,  0.823068f,  0.823285f,  0.823503f,  0.823721f,  0.823938f,  0.824155f,  0.824372f,
	 0.824589f,  0.824806f,  0.825023f,  0.825240f,  0.825456f,  0.825673f,  0.825889f,  0.826105f,
	 0.826321f,  0.826537f,  0.826753f,  0.826968f,  0.827184f,  0.827399f,  0.827615f,  0.827830f,
	 0.828045f,  0.828260f,  0.828475f,  0.828690f,  0.828904f,  0.829119f,  0.829333f,  0.829547f,
	 0.829761f,  0.829975f,  0.830189f,  0.830403f,  0.830616f,  0.830830f,  0.831043f,  0.831257f,
	 0.831470f,  0.831683f,  0.831895f,  0.832108f,  0.832321f,  0.832533f,  0.832746f,  0.832958f,
	 0.833170f,  0.833382f,  0.833594f,  0.833806f,  0.834018f,  0.834229f,  0.834440f,  0.834652f,
	 0.834863f,  0.835074f,  0.835285f,  0.835496f,  0.835706f,  0.835917f,  0.836127f,  0.836338f,
	 0.836548f,  0.836758f,  0.836968f,  0.837178f,  0.837387f,  0.837597f,  0.837806f,  0.838015f,
	 0.838225f,  0.838434f,  0.838643f,  0.838852f,  0.839060f,  0.839269f,  0.839477f,  0.839686f,
	 0.839894f,  0.840102f,  0.840310f,  0.840518f,  0.840725f,  0.840933f,  0.841140f,  0.841348f,
	 0.841555f,  0.841762f,  0.841969f,  0.842176f,  0.842383f,  0.842589f,  0.842796f,  0.843002f,
	 0.843208f,  0.843414f,  0.843620f,  0.843826f,  0.844032f,  0.844238f,  0.844443f,  0.844648f,
	 0.844854f,  0.845059f,  0.845264f,  0.845469f,  0.845673f,  0.845878f,  0.846082f,  0.846287f,
	 0.846491f,  0.846695f,  0.846899f,  0.847103f,  0.847307f,  0.847510f,  0.847714f,  0.847917f,
	 0.848120f,  0.848323f,  0.848526f,  0.848729f,  0.848932f,  0.849135f,  0.849337f,  0.849540f,
	 0.849742f,  0.849944f,  0.850146f,  0.850348f,  0.850549f,  0.850751f,  0.850953f,  0.851154f,
	 0.851355f,  0.851556f,  0.851757f,  0.851958f,  0.852159f,  0.852360f,  0.852560f,  0.852760f,
	 0.852961f,  0.853161f,  0.853361f,  0.853561f,  0.853760f,  0.853960f,  0.854159f,  0.854359f,
	 0.854558f,  0.854757f,  0.854956f,  0.855155f,  0.855354f,  0.855552f,  0.855751f,  0.855949f,
	 0.856147f,  0.856345f,  0.856543f,  0.856741f,  0.856939f,  0.857137f,  0.857334f,  0.857531f,
	 0.857729f,  0.857926f,  0.858123f,  0.858320f,  0.858516f,  0.858713f,  0.858909f,  0.859106f,
	 0.859302f,  0.859498f,  0.859694f,  0.859890f,  0.860085f,  0.860281f,  0.860476f,  0.860672f,
	 0.860867f,  0.861062f,  0.861257f,  0.861452f,  0.861646f,  0.861841f,  0.862035f,  0.862230f,
	 0.862424f,  0.862618f,  0.862812f,  0.863006f,  0.863199f,  0.863393f,  0.863586f,  0.863780f,
	 0.863973f,  0.864166f,  0.864359f,  0.864552f,  0.864744f,  0.864937f,  0.865129f,  0.865321f,
	 0.865514f,  0.865706f,  0.865898f,  0.866089f,  0.866281f,  0.866472f,  0.866664f,  0.866855f,
	 0.867046f,  0.867237f,  0.867428f,  0.867619f,  0.867809f,  0.868000f,  0.868190f,  0.868381f,
	 0.868571f,  0.868761f,  0.868951f,  0.869140f,  0.869330f,  0.869519f,  0.869709f,  0.869898f,
	 0.870087f,  0.870276f,  0.870465f,  0.870654f,  0.870842f,  0.871031f,  0.871219f,  0.871407f,
	 0.871595f,  0.871783f,  0.871971f,  0.872159f,  0.872346f,  0.872534f,  0.872721f,  0.872908f,
	 0.873095f,  0.873282f,  0.873469f,  0.873655f,  0.873842f,  0.874028f,  0.874215f,  0.874401f,
	 0.874587f,  0.874773f,  0.874958f,  0.875144f,  0.875329f,  0.875515f,  0.875700f,  0.875885f,
	 0.876070f,  0.876255f,  0.876440f,  0.876624f,  0.876809f,  0.876993f,  0.877177f,  0.877361f,
	 0.877545f,  0.877729f,  0.877913f,  0.878096f,  0.878280f,  0.878463f,  0.878646f,  0.878829f,
	 0.879012f,  0.879195f,  0.879378f,  0.879560f,  0.879743f,  0.879925f,  0.880107f,  0.880289f,
	 0.880471f,  0.880653f,  0.880834f,  0.881016f,  0.881197f,  0.881378f,  0.881559f,  0.881740f,
	 0.881921f,  0.882102f,  0.882283f,  0.882463f,  0.882643f,  0.882824f,  0.883004f,  0.883184f,
	 0.883363f,  0.883543f,  0.883723f,  0.883902f,  0.884081f,  0.884260f,  0.884439f,  0.884618f,
	 0.884797f,  0.884976f,  0.885154f,  0.885333f,  0.885511f,  0.885689f,  0.885867f,  0.886045f,
	 0.886223f,  0.886400f,  0.886578f,  0.886755f,  0.886932f,  0.887109f,  0.887286f,  0.887463f,
	 0.887640f,  0.887816f,  0.887993f,  0.888169f,  0.888345f,  0.888521f,  0.888697f,  0.888873f,
	 0.889048f,  0.889224f,  0.889399f,  0.889574f,  0.889750f,  0.889925f,  0.890099f,  0.890274f,
	 0.890449f,  0.890623f,  0.890797f,  0.890972f,  0.891146f,  0.891320f,  0.891493f,  0.891667f,
	 0.891841f,  0.892014f,  0.892187f,  0.892361f,  0.892534f,  0.892706f,  0.892879f,  0.893052f,
	 0.893224f,  0.893397f,  0.893569f,  0.893741f,  0.893913f,  0.894085f,  0.894256f,  0.894428f,
	 0.894599f,  0.894771f,  0.894942f,  0.895113f,  0.895284f,  0.895455f,  0.895625f,  0.895796f,
	 0.895966f,  0.896137f,  0.896307f,  0.896477f,  0.896646f,  0.896816f,  0.896986f,  0.897155f,
	 0.897325f,  0.897494f,  0.897663f,  0.897832f,  0.898001f,  0.898169f,  0.898338f,  0.898506f,
	 0.898674f,  0.898843f,  0.899011f,  0.899179f,  0.899346f,  0.899514f,  0.899681f,  0.899849f,
	 0.900016f,  0.900183f,  0.900350f,  0.900517f,  0.900683f,  0.900850f,  0.901016f,  0.901183f,
	 0.901349f,  0.901515f,  0.901681f,  0.901847f,  0.902012f,  0.902178f,  0.902343f,  0.902508f,
	 0.902673f,  0.902838f,  0.903003f,  0.903168f,  0.903332f,  0.903497f,  0.903661f,  0.903825f,
	 0.903989f,  0.904153f,  0.904317f,  0.904481f,  0.904644f,  0.904807f,  0.904971f,  0.905134f,
	 0.905297f,  0.905460f,  0.905622f,  0.905785f,  0.905947f,  0.906110f,  0.906272f,  0.906434f,
	 0.906596f,  0.906757f,  0.906919f,  0.907081f,  0.907242f,  0.907403f,  0.907564f,  0.907725f,
	 0.907886f,  0.908047f,  0.908207f,  0.908368f,  0.908528f,  0.908688f,  0.908848f,  0.909008f,
	 0.909168f,  0.909328f,  0.909487f,  0.909646f,  0.909806f,  0.909965f,  0.910124f,  0.910283f,
	 0.910441f,  0.910600f,  0.910758f,  0.910917f,  0.911075f,  0.911233f,  0.911391f,  0.911548f,
	 0.911706f,  0.911864f,  0.912021f,  0.912178f,  0.912335f,  0.912492f,  0.912649f,  0.912806f,
	 0.912962f,  0.913119f,  0.913275f,  0.913431f,  0.913587f,  0.913743f,  0.913899f,  0.914054f,
	 0.914210f,  0.914365f,  0.914520f,  0.914675f,  0.914830f,  0.914985f,  0.915140f,  0.915294f,
	 0.915449f,  0.915603f,  0.915757f,  0.915911f,  0.916065f,  0.916219f,  0.916372f,  0.916526f,
	 0.916679f,  0.916832f,  0.916985f,  0.917138f,  0.917291f,  0.917444f,  0.917596f,  0.917749f,
	 0.917901f,  0.918053f,  0.918205f,  0.918357f,  0.918508f,  0.918660f,  0.918811f,  0.918963f,
	 0.919114f,  0.919265f,  0.919416f,  0.919567f,  0.919717f,  0.919868f,  0.920018f,  0.920168f,
	 0.920318f,  0.920468f,  0.920618f,  0.920768f,  0.920917f,  0.921067f,  0.921216f,  0.921365f,
	 0.921514f,  0.921663f,  0.921812f,  0.921960f,  0.922109f,  0.922257f,  0.922405f,  0.922553f,
	 0.922701f,  0.922849f,  0.922997f,  0.923144f,  0.923291f,  0.923439f,  0.923586f,  0.923733f,
	 0.923880f,  0.924026f,  0.924173f,  0.924319f,  0.924465f,  0.924612f,  0.924758f,  0.924904f,
	 0.925049f,  0.925195f,  0.925340f,  0.925486f,  0.925631f,  0.925776f,  0.925921f,  0.926066f,
	 0.926210f,  0.926355f,  0.926499f,  0.926643f,  0.926787f,  0.926931f,  0.927075f,  0.927219f,
	 0.927363f,  0.927506f,  0.927649f,  0.927792f,  0.927935f,  0.928078f,  0.928221f,  0.928364f,
	 0.928506f,  0.928648f,  0.928791f,  0.928933f,  0.929075f,  0.929216f,  0.929358f,  0.929500f,
	 0.929641f,  0.929782f,  0.929923f,  0.930064f,  0.930205f,  0.930346f,  0.930486f,  0.930627f,
	 0.930767f,  0.930907f,  0.931047f,  0.931187f,  0.931327f,  0.931466f,  0.931606f,  0.931745f,
	 0.931884f,  0.932023f,  0.932162f,  0.932301f,  0.932440f,  0.932578f,  0.932716f,  0.932855f,
	 0.932993f,  0.933131f,  0.933269f,  0.933406f,  0.933544f,  0.933681f,  0.933818f,  0.933956f,
	 0.934093f,  0.934229f,  0.934366f,  0.934503f,  0.934639f,  0.934775f,  0.934912f,  0.935048f,
	 0.935184f,  0.935319f,  0.935455f,  0.935590f,  0.935726f,  0.935861f,  0.935996f,  0.936131f,
	 0.936266f,  0.936400f,  0.936535f,  0.936669f,  0.936803f,  0.936938f,  0.937072f,  0.937205f,
	 0.937339f,  0.937473f,  0.937606f,  0.937739f,  0.937872f,  0.938005f,  0.938138f,  0.938271f,
	 0.938404f,  0.938536f,  0.938668f,  0.938800f,  0.938932f,  0.939064f,  0.939196f,  0.939328f,
	 0.939459f,  0.939591f,  0.939722f,  0.939853f,  0.939984f,  0.940115f,  0.940245f,  0.940376f,
	 0.940506f,  0.940636f,  0.940766f,  0.940896f,  0.941026f,  0.941156f,  0.941285f,  0.941415f,
	 0.941544f,  0.941673f,  0.941802f,  0.941931f,  0.942060f,  0.942188f,  0.942317f,  0.942445f,
	 0.942573f,  0.942701f,  0.942829f,  0.942957f,  0.943084f,  0.943212f,  0.943339f,  0.943466f,
	 0.943593f,  0.943720f,  0.943847f,  0.943974f,  0.944100f,  0.944227f,  0.944353f,  0.944479f,
	 0.944605f,  0.944731f,  0.944856f,  0.944982f,  0.945107f,  0.945232f,  0.945358f,  0.945482f,
	 0.945607f,  0.945732f,  0.945857f,  0.945981f,  0.946105f,  0.946229f,  0.946353f,  0.946477f,
	 0.946601f,  0.946724f,  0.946848f,  0.946971f,  0.947094f,  0.947217f,  0.947340f,  0.947463f,
	 0.947586f,  0.947708f,  0.947830f,  0.947953f,  0.948075f,  0.948196f,  0.948318f,  0.948440f,
	 0.948561f,  0.948683f,  0.948804f,  0.948925f,  0.949046f,  0.949167f,  0.949287f,  0.949408f,
	 0.949528f,  0.949648f,  0.949768f,  0.949888f,  0.950008f,  0.950128f,  0.950247f,  0.950367f,
	 0.950486f,  0.950605f,  0.950724f,  0.950843f,  0.950962f,  0.951080f,  0.951199f,  0.951317f,
	 0.951435f,  0.951553f,  0.951671f,  0.951789f,  0.951906f,  0.952024f,  0.952141f,  0.952258f,
	 0.952375f,  0.952492f,  0.952609f,  0.952725f,  0.952842f,  0.952958f,  0.953074f,  0.953190f,
	 0.953306f,  0.953422f,  0.953537f,  0.953653f,  0.953768f,  0.953883f,  0.953998f,  0.954113f,
	 0.954228f,  0.954343f,  0.954457f,  0.954572f,  0.954686f,  0.954800f,  0.954914f,  0.955028f,
	 0.955141f,  0.955255f,  0.955368f,  0.955481f,  0.955594f,  0.955707f,  0.955820f,  0.955933f,
	 0.956045f,  0.956158f,  0.956270f,  0.956382f,  0.956494f,  0.956606f,  0.956717f,  0.956829f,
	 0.956940f,  0.957052f,  0.957163f,  0.957274f,  0.957385f,  0.957495f,  0.957606f,  0.957716f,
	 0.957826f,  0.957937f,  0.958046f,  0.958156f,  0.958266f,  0.958376f,  0.958485f,  0.958594f,
	 0.958703f,  0.958812f,  0.958921f,  0.959030f,  0.959139f,  0.959247f,  0.959355f,  0.959463f,
	 0.959572f,  0.959679f,  0.959787f,  0.959895f,  0.960002f,  0.960109f,  0.960217f,  0.960324f,
	 0.960431f,  0.960537f,  0.960644f,  0.960750f,  0.960857f,  0.960963f,  0.961069f,  0.961175f,
	 0.961280f,  0.961386f,  0.961492f,  0.961597f,  0.961702f,  0.961807f,  0.961912f,  0.962017f,
	 0.962121f,  0.962226f,  0.962330f,  0.962434f,  0.962538f,  0.962642f,  0.962746f,  0.962850f,
	 0.962953f,  0.963057f,  0.963160f,  0.963263f,  0.963366f,  0.963469f,  0.963571f,  0.963674f,
	 0.963776f,  0.963878f,  0.963980f,  0.964082f,  0.964184f,  0.964286f,  0.964387f,  0.964489f,
	 0.964590f,  0.964691f,  0.964792f,  0.964893f,  0.964993f,  0.965094f,  0.965194f,  0.965294f,
	 0.965394f,  0.965494f,  0.965594f,  0.965694f,  0.965793f,  0.965893f,  0.965992f,  0.966091f,
	 0.966190f,  0.966289f,  0.966387f,  0.966486f,  0.966584f,  0.966683f,  0.966781f,  0.966879f,
	 0.966976f,  0.967074f,  0.967172f,  0.967269f,  0.967366f,  0.967463f,  0.967560f,  0.967657f,
	 0.967754f,  0.967850f,  0.967947f,  0.968043f,  0.968139f,  0.968235f,  0.968331f,  0.968427f,
	 0.968522f,  0.968617f,  0.968713f,  0.968808f,  0.968903f,  0.968998f,  0.969092f,  0.969187f,
	 0.969281f,  0.969375f,  0.969470f,  0.969564f,  0.969657f,  0.969751f,  0.969845f,  0.969938f,
	 0.970031f,  0.970124f,  0.970217f,  0.970310f,  0.970403f,  0.970495f,  0.970588f,  0.970680f,
	 0.970772f,  0.970864f,  0.970956f,  0.971048f,  0.971139f,  0.971231f,  0.971322f,  0.971413f,
	 0.971504f,  0.971595f,  0.971685f,  0.971776f,  0.971866f,  0.971957f,  0.972047f,  0.972137f,
	 0.972227f,  0.972316f,  0.972406f,  0.972495f,  0.972584f,  0.972673f,  0.972762f,  0.972851f,
	 0.972940f,  0.973028f,  0.973117f,  0.973205f,  0.973293f,  0.973381f,  0.973469f,  0.973557f,
	 0.973644f,  0.973732f,  0.973819f,  0.973906f,  0.973993f,  0.974080f,  0.974166f,  0.974253f,
	 0.974339f,  0.974426f,  0.974512f,  0.974598f,  0.974684f,  0.974769f,  0.974855f,  0.974940f,
	 0.975025f,  0.975110f,  0.975195f,  0.975280f,  0.975365f,  0.975449f,  0.975534f,  0.975618f,
	 0.975702f,  0.975786f,  0.975870f,  0.975954f,  0.976037f,  0.976120f,  0.976204f,  0.976287f,
	 0.976370f,  0.976453f,  0.976535f,  0.976618f,  0.976700f,  0.976782f,  0.976864f,  0.976946f,
	 0.977028f,  0.977110f,  0.977191f,  0.977273f,  0.977354f,  0.977435f,  0.977516f,  0.977597f,
	 0.977677f,  0.977758f,  0.977838f,  0.977918f,  0.977998f,  0.978078f,  0.978158f,  0.978238f,
	 0.978317f,  0.978397f,  0.978476f,  0.978555f,  0.978634f,  0.978713f,  0.978791f,  0.978870f,
	 0.978948f,  0.979026f,  0.979104f,  0.979182f,  0.979260f,  0.979338f,  0.979415f,  0.979493f,
	 0.979570f,  0.979647f,  0.979724f,  0.979800f,  0.979877f,  0.979954f,  0.980030f,  0.980106f,
	 0.980182f,  0.980258f,  0.980334f,  0.980409f,  0.980485f,  0.980560f,  0.980635f,  0.980710f,
	 0.980785f,  0.980860f,  0.980935f,  0.981009f,  0.981083f,  0.981158f,  0.981232f,  0.981305f,
	 0.981379f,  0.981453f,  0.981526f,  0.981600f,  0.981673f,  0.981746f,  0.981819f,  0.981891f,
	 0.981964f,  0.982036f,  0.982109f,  0.982181f,  0.982253f,  0.982325f,  0.982396f,  0.982468f,
	 0.982539f,  0.982611f,  0.982682f,  0.982753f,  0.982824f,  0.982894f,  0.982965f,  0.983035f,
	 0.983105f,  0.983176f,  0.983246f,  0.983315f,  0.983385f,  0.983455f,  0.983524f,  0.983593f,
	 0.983662f,  0.983731f,  0.983800f,  0.983869f,  0.983937f,  0.984006f,  0.984074f,  0.984142f,
	 0.984210f,  0.984278f,  0.984346f,  0.984413f,  0.984480f,  0.984548f,  0.984615f,  0.984682f,
	 0.984748f,  0.984815f,  0.984882f,  0.984948f,  0.985014f,  0.985080f,  0.985146f,  0.985212f,
	 0.985278f,  0.985343f,  0.985408f,  0.985474f,  0.985539f,  0.985604f,  0.985668f,  0.985733f,
	 0.985798f,  0.985862f,  0.985926f,  0.985990f,  0.986054f,  0.986118f,  0.986181f,  0.986245f,
	 0.986308f,  0.986371f,  0.986434f,  0.986497f,  0.986560f,  0.986623f,  0.986685f,  0.986747f,
	 0.986809f,  0.986871f,  0.986933f,  0.986995f,  0.987057f,  0.987118f,  0.987179f,  0.987240f,
	 0.987301f,  0.987362f,  0.987423f,  0.987484f,  0.987544f,  0.987604f,  0.987664f,  0.987724f,
	 0.987784f,  0.987844f,  0.987903f,  0.987963f,  0.988022f,  0.988081f,  0.988140f,  0.988199f,
	 0.988258f,  0.988316f,  0.988374f,  0.988433f,  0.988491f,  0.988549f,  0.988607f,  0.988664f,
	 0.988722f,  0.988779f,  0.988836f,  0.988893f,  0.988950f,  0.989007f,  0.989064f,  0.989120f,
	 0.989177f,  0.989233f,  0.989289f,  0.989345f,  0.989400f,  0.989456f,  0.989511f,  0.989567f,
	 0.989622f,  0.989677f,  0.989732f,  0.989787f,  0.989841f,  0.989896f,  0.989950f,  0.990004f,
	 0.990058f,  0.990112f,  0.990166f,  0.990219f,  0.990273f,  0.990326f,  0.990379f,  0.990432f,
	 0.990485f,  0.990538f,  0.990590f,  0.990643f,  0.990695f,  0.990747f,  0.990799f,  0.990851f,
	 0.990903f,  0.990954f,  0.991006f,  0.991057f,  0.991108f,  0.991159f,  0.991210f,  0.991260f,
	 0.991311f,  0.991361f,  0.991411f,  0.991462f,  0.991511f,  0.991561f,  0.991611f,  0.991660f,
	 0.991710f,  0.991759f,  0.991808f,  0.991857f,  0.991906f,  0.991954f,  0.992003f,  0.992051f,
	 0.992099f,  0.992147f,  0.992195f,  0.992243f,  0.992291f,  0.992338f,  0.992385f,  0.992433f,
	 0.992480f,  0.992526f,  0.992573f,  0.992620f,  0.992666f,  0.992712f,  0.992759f,  0.992805f,
	 0.992850f,  0.992896f,  0.992942f,  0.992987f,  0.993032f,  0.993077f,  0.993122f,  0.993167f,
	 0.993212f,  0.993257f,  0.993301f,  0.993345f,  0.993389f,  0.993433f,  0.993477f,  0.993521f,
	 0.993564f,  0.993608f,  0.993651f,  0.993694f,  0.993737f,  0.993779f,  0.993822f,  0.993865f,
	 0.993907f,  0.993949f,  0.993991f,  0.994033f,  0.994075f,  0.994116f,  0.994158f,  0.994199f,
	 0.994240f,  0.994281f,  0.994322f,  0.994363f,  0.994404f,  0.994444f,  0.994484f,  0.994525f,
	 0.994565f,  0.994604f,  0.994644f,  0.994684f,  0.994723f,  0.994762f,  0.994802f,  0.994841f,
	 0.994879f,  0.994918f,  0.994957f,  0.994995f,  0.995033f,  0.995071f,  0.995109f,  0.995147f,
	 0.995185f,  0.995222f,  0.995260f,  0.995297f,  0.995334f,  0.995371f,  0.995408f,  0.995444f,
	 0.995481f,  0.995517f,  0.995553f,  0.995589f,  0.995625f,  0.995661f,  0.995697f,  0.995732f,
	 0.995767f,  0.995803f,  0.995838f,  0.995872f,  0.995907f,  0.995942f,  0.995976f,  0.996011f,
	 0.996045f,  0.996079f,  0.996113f,  0.996146f,  0.996180f,  0.996213f,  0.996247f,  0.996280f,
	 0.996313f,  0.996345f,  0.996378f,  0.996411f,  0.996443f,  0.996475f,  0.996507f,  0.996539f,
	 0.996571f,  0.996603f,  0.996634f,  0.996666f,  0.996697f,  0.996728f,  0.996759f,  0.996790f,
	 0.996820f,  0.996851f,  0.996881f,  0.996911f,  0.996941f,  0.996971f,  0.997001f,  0.997031f,
	 0.997060f,  0.997089f,  0.997119f,  0.997148f,  0.997176f,  0.997205f,  0.997234f,  0.997262f,
	 0.997290f,  0.997319f,  0.997347f,  0.997374f,  0.997402f,  0.997430f,  0.997457f,  0.997484f,
	 0.997511f,  0.997538f,  0.997565f,  0.997592f,  0.997618f,  0.997645f,  0.997671f,  0.997697f,
	 0.997723f,  0.997749f,  0.997774f,  0.997800f,  0.997825f,  0.997851f,  0.997876f,  0.997901f,
	 0.997925f,  0.997950f,  0.997974f,  0.997999f,  0.998023f,  0.998047f,  0.998071f,  0.998094f,
	 0.998118f,  0.998142f,  0.998165f,  0.998188f,  0.998211f,  0.998234f,  0.998257f,  0.998279f,
	 0.998302f,  0.998324f,  0.998346f,  0.998368f,  0.998390f,  0.998411f,  0.998433f,  0.998454f,
	 0.998476f,  0.998497f,  0.998518f,  0.998538f,  0.998559f,  0.998580f,  0.998600f,  0.998620f,
	 0.998640f,  0.998660f,  0.998680f,  0.998700f,  0.998719f,  0.998738f,  0.998758f,  0.998777f,
	 0.998795f,  0.998814f,  0.998833f,  0.998851f,  0.998870f,  0.998888f,  0.998906f,  0.998924f,
	 0.998941f,  0.998959f,  0.998976f,  0.998994f,  0.999011f,  0.999028f,  0.999044f,  0.999061f,
	 0.999078f,  0.999094f,  0.999110f,  0.999126f,  0.999142f,  0.999158f,  0.999174f,  0.999189f,
	 0.999205f,  0.999220f,  0.999235f,  0.999250f,  0.999265f,  0.999279f,  0.999294f,  0.999308f,
	 0.999322f,  0.999336f,  0.999350f,  0.999364f,  0.999378f,  0.999391f,  0.999404f,  0.999418f,
	 0.999431f,  0.999443f,  0.999456f,  0.999469f,  0.999481f,  0.999493f,  0.999506f,  0.999518f,
	 0.999529f,  0.999541f,  0.999553f,  0.999564f,  0.999575f,  0.999586f,  0.999597f,  0.999608f,
	 0.999619f,  0.999629f,  0.999640f,  0.999650f,  0.999660f,  0.999670f,  0.999680f,  0.999689f,
	 0.999699f,  0.999708f,  0.999717f,  0.999726f,  0.999735f,  0.999744f,  0.999753f,  0.999761f,
	 0.999769f,  0.999778f,  0.999786f,  0.999793f,  0.999801f,  0.999809f,  0.999816f,  0.999823f,
	 0.999831f,  0.999838f,  0.999844f,  0.999851f,  0.999858f,  0.999864f,  0.999870f,  0.999876f,
	 0.999882f,  0.999888f,  0.999894f,  0.999899f,  0.999905f,  0.999910f,  0.999915f,  0.999920f,
	 0.999925f,  0.999929f,  0.999934f,  0.999938f,  0.999942f,  0.999946f,  0.999950f,  0.999954f,
	 0.999958f,  0.999961f,  0.999964f,  0.999968f,  0.999971f,  0.999973f,  0.999976f,  0.999979f,
	 0.999981f,  0.999983f,  0.999986f,  0.999988f,  0.999989f,  0.999991f,  0.999993f,  0.999994f,
	 0.999995f,  0.999996f,  0.999997f,  0.999998f,  0.999999f,  0.999999f,  1.000000f,  1.000000f,
	 0.000000f, -0.000383f, -0.000767f, -0.001150f, -0.001534f, -0.001917f, -0.002301f, -0.002684f,
	-0.003068f, -0.003451f, -0.003835f, -0.004218f, -0.004602f, -0.004985f, -0.005369f, -0.005752f,
	-0.006136f, -0.006519f, -0.006903f, -0.007286f, -0.007670f, -0.008053f, -0.008437f, -0.008820f,
	-0.009204f, -0.009587f, -0.009971f, -0.010354f, -0.010738f, -0.011121f, -0.011505f, -0.011888f,
	-0.012272f, -0.012655f, -0.013038f, -0.013422f, -0.013805f, -0.014189f, -0.014572f, -0.014956f,
	-0.015339f, -0.015723f, -0.016106f, -0.016490f, -0.016873f, -0.017256f, -0.017640f, -0.018023f,
	-0.018407f, -0.018790f, -0.019174f, -0.019557f, -0.019940f, -0.020324f, -0.020707f, -0.021091f,
	-0.021474f, -0.021857f, -0.022241f, -0.022624f, -0.023008f, -0.023391f, -0.023774f, -0.024158f,
	-0.024541f, -0.024925f, -0.025308f, -0.025691f, -0.026075f, -0.026458f, -0.026841f, -0.027225f,
	-0.027608f, -0.027991f, -0.028375f, -0.028758f, -0.029142f, -0.029525f, -0.029908f, -0.030291f,
	-0.030675f, -0.031058f, -0.031441f, -0.031825f, -0.032208f, -0.032591f, -0.032975f, -0.033358f,
	-0.033741f, -0.034124f, -0.034508f, -0.034891f, -0.035274f, -0.035657f, -0.036041f, -0.036424f,
	-0.036807f, -0.037190f, -0.037574f, -0.037957f, -0.038340f, -0.038723f, -0.039107f, -0.039490f,
	-0.039873f, -0.040256f, -0.040639f, -0.041022f, -0.041406f, -0.041789f, -0.042172f, -0.042555f,
	-0.042938f, -0.043321f, -0.043705f, -0.044088f, -0.044471f, -0.044854f, -0.045237f, -0.045620f,
	-0.046003f, -0.046386f, -0.046769f, -0.047152f, -0.047535f, -0.047919f, -0.048302f, -0.048685f,
	-0.049068f, -0.049451f, -0.049834f, -0.050217f, -0.050600f, -0.050983f, -0.051366f, -0.051749f,
	-0.052132f, -0.052515f, -0.052898f, -0.053281f, -0.053664f, -0.054046f, -0.054429f, -0.054812f,
	-0.055195f, -0.055578f, -0.055961f, -0.056344f, -0.056727f, -0.057110f, -0.057493f, -0.057875f,
	-0.058258f, -0.058641f, -0.059024f, -0.059407f, -0.059790f, -0.060172f, -0.060555f, -0.060938f,
	-0.061321f, -0.061704f, -0.062086f, -0.062469f, -0.062852f, -0.063234f, -0.063617f, -0.064000f,
	-0.064383f, -0.064765f, -0.065148f, -0.065531f, -0.065913f, -0.066296f, -0.066679f, -0.067061f,
	-0.067444f, -0.067827f, -0.068209f, -0.068592f, -0.068974f, -0.069357f, -0.069739f, -0.070122f,
	-0.070505f, -0.070887f, -0.071270f, -0.071652f, -0.072035f, -0.072417f, -0.072800f, -0.073182f,
	-0.073565f, -0.073947f, -0.074329f, -0.074712f, -0.075094f, -0.075477f, -0.075859f, -0.076241f,
	-0.076624f, -0.077006f, -0.077389f, -0.077771f, -0.078153f, -0.078536f, -0.078918f, -0.079300f,
	-0.079682f, -0.080065f, -0.080447f, -0.080829f, -0.081211f, -0.081594f, -0.081976f, -0.082358f,
	-0.082740f, -0.083122f, -0.083505f, -0.083887f, -0.084269f, -0.084651f, -0.085033f, -0.085415f,
	-0.085797f, -0.086179f, -0.086561f, -0.086943f, -0.087326f, -0.087708f, -0.088090f, -0.088472f,
	-0.088854f, -0.089236f, -0.089617f, -0.089999f, -0.090381f, -0.090763f, -0.091145f, -0.091527f,
	-0.091909f, -0.092291f, -0.092673f, -0.093055f, -0.093436f, -0.093818f, -0.094200f, -0.094582f,
	-0.094963f, -0.095345f, -0.095727f, -0.096109f, -0.096490f, -0.096872f, -0.097254f, -0.097635f,
	-0.098017f, -0.098399f, -0.098780f, -0.099162f, -0.099544f, -0.099925f, -0.100307f, -0.100688f,
	-0.101070f, -0.101451f, -0.101833f, -0.102214f, -0.102596f, -0.102977f, -0.103359f, -0.103740f,
	-0.104122f, -0.104503f, -0.104884f, -0.105266f, -0.105647f, -0.106028f, -0.106410f, -0.106791f,
	-0.107172f, -0.107554f, -0.107935f, -0.108316f, -0.108697f, -0.109079f, -0.109460f, -0.109841f,
	-0.110222f, -0.110603f, -0.110984f, -0.111366f, -0.111747f, -0.112128f, -0.112509f, -0.112890f,
	-0.113271f, -0.113652f, -0.114033f, -0.114414f, -0.114795f, -0.115176f, -0.115557f, -0.115938f,
	-0.116319f, -0.116700f, -0.117080f, -0.117461f, -0.117842f, -0.118223f, -0.118604f, -0.118984f,
	-0.119365f, -0.119746f, -0.120127f, -0.120507f, -0.120888f, -0.121269f, -0.121649f, -0.122030f,
	-0.122411f, -0.122791f, -0.123172f, -0.123552f, -0.123933f, -0.124314f, -0.124694f, -0.125075f,
	-0.125455f, -0.125835f, -0.126216f, -0.126596f, -0.126977f, -0.127357f, -0.127737f, -0.128118f,
	-0.128498f, -0.128878f, -0.129259f, -0.129639f, -0.130019f, -0.130399f, -0.130780f, -0.131160f,
	-0.131540f, -0.131920f, -0.132300f, -0.132680f, -0.133061f, -0.133441f, -0.133821f, -0.134201f,
	-0.134581f, -0.134961f, -0.135341f, -0.135721f, -0.136101f, -0.136480f, -0.136860f, -0.137240f,
	-0.137620f, -0.138000f, -0.138380f, -0.138760f, -0.139139f, -0.139519f, -0.139899f, -0.140279f,
	-0.140658f, -0.141038f, -0.141418f, -0.141797f, -0.142177f, -0.142556f, -0.142936f, -0.143316f,
	-0.143695f, -0.144075f, -0.144454f, -0.144833f, -0.145213f, -0.145592f, -0.145972f, -0.146351f,
	-0.146730f, -0.147110f, -0.147489f, -0.147868f, -0.148248f, -0.148627f, -0.149006f, -0.149385f,
	-0.149765f, -0.150144f, -0.150523f, -0.150902f, -0.151281f, -0.151660f, -0.152039f, -0.152418f,
	-0.152797f, -0.153176f, -0.153555f, -0.153934f, -0.154313f, -0.154692f, -0.155071f, -0.155450f,
	-0.155828f, -0.156207f, -0.156586f, -0.156965f, -0.157343f, -0.157722f, -0.158101f, -0.158480f,
	-0.158858f, -0.159237f, -0.159615f, -0.159994f, -0.160372f, -0.160751f, -0.161129f, -0.161508f,
	-0.161886f, -0.162265f, -0.162643f, -0.163022f, -0.163400f, -0.163778f, -0.164157f, -0.164535f,
	-0.164913f, -0.165291f, -0.165670f, -0.166048f, -0.166426f, -0.166804f, -0.167182f, -0.167560f,
	-0.167938f, -0.168316f, -0.168694f, -0.169072f, -0.169450f, -0.169828f, -0.170206f, -0.170584f,
	-0.170962f, -0.171340f, -0.171718f, -0.172095f, -0.172473f, -0.172851f, -0.173229f, -0.173606f,
	-0.173984f, -0.174362f, -0.174739f, -0.175117f, -0.175494f, -0.175872f, -0.176249f, -0.176627f,
	-0.177004f, -0.177382f, -0.177759f, -0.178136f, -0.178514f, -0.178891f, -0.179268f, -0.179646f,
	-0.180023f, -0.180400f, -0.180777f, -0.181154f, -0.181532f, -0.181909f, -0.182286f, -0.182663f,
	-0.183040f, -0.183417f, -0.183794f, -0.184171f, -0.184548f, -0.184925f, -0.185301f, -0.185678f,
	-0.186055f, -0.186432f, -0.186809f, -0.187185f, -0.187562f, -0.187939f, -0.188315f, -0.188692f,
	-0.189069f, -0.189445f, -0.189822f, -0.190198f, -0.190575f, -0.190951f, -0.191328f, -0.191704f,
	-0.192080f, -0.192457f, -0.192833f, -0.193209f, -0.193586f, -0.193962f, -0.194338f, -0.194714f,
	-0.195090f, -0.195466f, -0.195843f, -0.196219f, -0.196595f, -0.196971f, -0.197347f, -0.197722f,
	-0.198098f, -0.198474f, -0.198850f, -0.199226f, -0.199602f, -0.199978f, -0.200353f, -0.200729f,
	-0.201105f, -0.201480f, -0.201856f, -0.202231f, -0.202607f, -0.202983f, -0.203358f, -0.203734f,
	-0.204109f, -0.204484f, -0.204860f, -0.205235f, -0.205610f, -0.205986f, -0.206361f, -0.206736f,
	-0.207111f, -0.207487f, -0.207862f, -0.208237f, -0.208612f, -0.208987f, -0.209362f, -0.209737f,
	-0.210112f, -0.210487f, -0.210862f, -0.211237f, -0.211611f, -0.211986f, -0.212361f, -0.212736f,
	-0.213110f, -0.213485f, -0.213860f, -0.214234f, -0.214609f, -0.214983f, -0.215358f, -0.215732f,
	-0.216107f, -0.216481f, -0.216856f, -0.217230f, -0.217604f, -0.217979f, -0.218353f, -0.218727f,
	-0.219101f, -0.219475f, -0.219850f, -0.220224f, -0.220598f, -0.220972f, -0.221346f, -0.221720f,
	-0.222094f, -0.222468f, -0.222841f, -0.223215f, -0.223589f, -0.223963f, -0.224337f, -0.224710f,
	-0.225084f, -0.225458f, -0.225831f, -0.226205f, -0.226578f, -0.226952f, -0.227325f, -0.227699f,
	-0.228072f, -0.228445f, -0.228819f, -0.229192f, -0.229565f, -0.229939f, -0.230312f, -0.230685f,
	-0.231058f, -0.231431f, -0.231804f, -0.232177f, -0.232550f, -0.232923f, -0.233296f, -0.233669f,
	-0.234042f, -0.234415f, -0.234788f, -0.235160f, -0.235533f, -0.235906f, -0.236278f, -0.236651f,
	-0.237024f, -0.237396f, -0.237769f, -0.238141f, -0.238514f, -0.238886f, -0.239258f, -0.239631f,
	-0.240003f, -0.240375f, -0.240748f, -0.241120f, -0.241492f, -0.241864f, -0.242236f, -0.242608f,
	-0.242980f, -0.243352f, -0.243724f, -0.244096f, -0.244468f, -0.244840f, -0.245212f, -0.245583f,
	-0.245955f, -0.246327f, -0.246698f, -0.247070f, -0.247442f, -0.247813f, -0.248185f, -0.248556f,
	-0.248928f, -0.249299f, -0.249670f, -0.250042f, -0.250413f, -0.250784f, -0.251155f, -0.251527f,
	-0.251898f, -0.252269f, -0.252640f, -0.253011f, -0.253382f, -0.253753f, -0.254124f, -0.254495f,
	-0.254866f, -0.255236f, -0.255607f, -0.255978f, -0.256349f, -0.256719f, -0.257090f, -0.257461f,
	-0.257831f, -0.258202f, -0.258572f, -0.258943f, -0.259313f, -0.259683f, -0.260054f, -0.260424f,
	-0.260794f, -0.261164f, -0.261534f, -0.261905f, -0.262275f, -0.262645f, -0.263015f, -0.263385f,
	-0.263755f, -0.264125f, -0.264494f, -0.264864f, -0.265234f, -0.265604f, -0.265973f, -0.266343f,
	-0.266713f, -0.267082f, -0.267452f, -0.267821f, -0.268191f, -0.268560f, -0.268930f, -0.269299f,
	-0.269668f, -0.270038f, -0.270407f, -0.270776f, -0.271145f, -0.271514f, -0.271883f, -0.272252f,
	-0.272621f, -0.272990f, -0.273359f, -0.273728f, -0.274097f, -0.274466f, -0.274834f, -0.275203f,
	-0.275572f, -0.275940f, -0.276309f, -0.276678f, -0.277046f, -0.277415f, -0.277783f, -0.278151f,
	-0.278520f, -0.278888f, -0.279256f, -0.279624f, -0.279993f, -0.280361f, -0.280729f, -0.281097f,
	-0.281465f, -0.281833f, -0.282201f, -0.282569f, -0.282937f, -0.283304f, -0.283672f, -0.284040f,
	-0.284408f, -0.284775f, -0.285143f, -0.285510f, -0.285878f, -0.286245f, -0.286613f, -0.286980f,
	-0.287347f, -0.287715f, -0.288082f, -0.288449f, -0.288816f, -0.289184f, -0.289551f, -0.289918f,
	-0.290285f, -0.290652f, -0.291019f, -0.291385f, -0.291752f, -0.292119f, -0.292486f, -0.292852f,
	-0.293219f, -0.293586f, -0.293952f, -0.294319f, -0.294685f, -0.295052f, -0.295418f, -0.295785f,
	-0.296151f, -0.296517f, -0.296883f, -0.297250f, -0.297616f, -0.297982f, -0.298348f, -0.298714f,
	-0.299080f, -0.299446f, -0.299812f, -0.300177f, -0.300543f, -0.300909f, -0.301275f, -0.301640f,
	-0.302006f, -0.302372f, -0.302737f, -0.303103f, -0.303468f, -0.303833f, -0.304199f, -0.304564f,
	-0.304929f, -0.305294f, -0.305660f, -0.306025f, -0.306390f, -0.306755f, -0.307120f, -0.307485f,
	-0.307850f, -0.308214f, -0.308579f, -0.308944f, -0.309309f, -0.309673f, -0.310038f, -0.310403f,
	-0.310767f, -0.311132f, -0.311496f, -0.311860f, -0.312225f, -0.312589f, -0.312953f, -0.313318f,
	-0.313682f, -0.314046f, -0.314410f, -0.314774f, -0.315138f, -0.315502f, -0.315866f, -0.316230f,
	-0.316593f, -0.316957f, -0.317321f, -0.317684f, -0.318048f, -0.318412f, -0.318775f, -0.319139f,
	-0.319502f, -0.319865f, -0.320229f, -0.320592f, -0.320955f, -0.321318f, -0.321682f, -0.322045f,
	-0.322408f, -0.322771f, -0.323134f, -0.323497f, -0.323859f, -0.324222f, -0.324585f, -0.324948f,
	-0.325310f, -0.325673f, -0.326035f, -0.326398f, -0.326760f, -0.327123f, -0.327485f, -0.327848f,
	-0.328210f, -0.328572f, -0.328934f, -0.329296f, -0.329658f, -0.330020f, -0.330382f, -0.330744f,
	-0.331106f, -0.331468f, -0.331830f, -0.332192f, -0.332553f, -0.332915f, -0.333277f, -0.333638f,
	-0.334000f, -0.334361f, -0.334722f, -0.335084f, -0.335445f, -0.335806f, -0.336168f, -0.336529f,
	-0.336890f, -0.337251f, -0.337612f, -0.337973f, -0.338334f, -0.338695f, -0.339055f, -0.339416f,
	-0.339777f, -0.340138f, -0.340498f, -0.340859f, -0.341219f, -0.341580f, -0.341940f, -0.342300f,
	-0.342661f, -0.343021f, -0.343381f, -0.343741f, -0.344101f, -0.344461f, -0.344821f, -0.345181f,
	-0.345541f, -0.345901f, -0.346261f, -0.346621f, -0.346980f, -0.347340f, -0.347700f, -0.348059f,
	-0.348419f, -0.348778f, -0.349138f, -0.349497f, -0.349856f, -0.350215f, -0.350575f, -0.350934f,
	-0.351293f, -0.351652f, -0.352011f, -0.352370f, -0.352729f, -0.353087f, -0.353446f, -0.353805f,
	-0.354164f, -0.354522f, -0.354881f, -0.355239f, -0.355598f, -0.355956f, -0.356314f, -0.356673f,
	-0.357031f, -0.357389f, -0.357747f, -0.358105f, -0.358463f, -0.358821f, -0.359179f, -0.359537f,
	-0.359895f, -0.360253f, -0.360611f, -0.360968f, -0.361326f, -0.361683f, -0.362041f, -0.362398f,
	-0.362756f, -0.363113f, -0.363470f, -0.363828f, -0.364185f, -0.364542f, -0.364899f, -0.365256f,
	-0.365613f, -0.365970f, -0.366327f, -0.366684f, -0.367040f, -0.367397f, -0.367754f, -0.368110f,
	-0.368467f, -0.368823f, -0.369180f, -0.369536f, -0.369892f, -0.370249f, -0.370605f, -0.370961f,
	-0.371317f, -0.371673f, -0.372029f, -0.372385f, -0.372741f, -0.373097f, -0.373453f, -0.373808f,
	-0.374164f, -0.374520f, -0.374875f, -0.375231f, -0.375586f, -0.375942f, -0.376297f, -0.376652f,
	-0.377007f, -0.377363f, -0.377718f, -0.378073f, -0.378428f, -0.378783f, -0.379138f, -0.379492f,
	-0.379847f, -0.380202f, -0.380557f, -0.380911f, -0.381266f, -0.381620f, -0.381975f, -0.382329f,
	-0.382683f, -0.383038f, -0.383392f, -0.383746f, -0.384100f, -0.384454f, -0.384808f, -0.385162f,
	-0.385516f, -0.385870f, -0.386224f, -0.386577f, -0.386931f, -0.387285f, -0.387638f, -0.387992f,
	-0.388345f, -0.388698f, -0.389052f, -0.389405f, -0.389758f, -0.390111f, -0.390464f, -0.390817f,
	-0.391170f, -0.391523f, -0.391876f, -0.392229f, -0.392582f, -0.392934f, -0.393287f, -0.393640f,
	-0.393992f, -0.394344f, -0.394697f, -0.395049f, -0.395401f, -0.395754f, -0.396106f, -0.396458f,
	-0.396810f, -0.397162f, -0.397514f, -0.397866f, -0.398218f, -0.398569f, -0.398921f, -0.399273f,
	-0.399624f, -0.399976f, -0.400327f, -0.400679f, -0.401030f, -0.401381f, -0.401732f, -0.402084f,
	-0.402435f, -0.402786f, -0.403137f, -0.403488f, -0.403838f, -0.404189f, -0.404540f, -0.404891f,
	-0.405241f, -0.405592f, -0.405942f, -0.406293f, -0.406643f, -0.406994f, -0.407344f, -0.407694f,
	-0.408044f, -0.408394f, -0.408744f, -0.409094f, -0.409444f, -0.409794f, -0.410144f, -0.410493f,
	-0.410843f, -0.411193f, -0.411542f, -0.411892f, -0.412241f, -0.412591f, -0.412940f, -0.413289f,
	-0.413638f, -0.413987f, -0.414337f, -0.414685f, -0.415034f, -0.415383f, -0.415732f, -0.416081f,
	-0.416430f, -0.416778f, -0.417127f, -0.417475f, -0.417824f, -0.418172f, -0.418520f, -0.418869f,
	-0.419217f, -0.419565f, -0.419913f, -0.420261f, -0.420609f, -0.420957f, -0.421305f, -0.421653f,
	-0.422000f, -0.422348f, -0.422695f, -0.423043f, -0.423390f, -0.423738f, -0.424085f, -0.424432f,
	-0.424780f, -0.425127f, -0.425474f, -0.425821f, -0.426168f, -0.426515f, -0.426862f, -0.427208f,
	-0.427555f, -0.427902f, -0.428248f, -0.428595f, -0.428941f, -0.429288f, -0.429634f, -0.429980f,
	-0.430326f, -0.430673f, -0.431019f, -0.431365f, -0.431711f, -0.432057f, -0.432402f, -0.432748f,
	-0.433094f, -0.433439f, -0.433785f, -0.434131f, -0.434476f, -0.434821f, -0.435167f, -0.435512f,
	-0.435857f, -0.436202f, -0.436547f, -0.436892f, -0.437237f, -0.437582f, -0.437927f, -0.438272f,
	-0.438616f, -0.438961f, -0.439305f, -0.439650f, -0.439994f, -0.440339f, -0.440683f, -0.441027f,
	-0.441371f, -0.441715f, -0.442059f, -0.442403f, -0.442747f, -0.443091f, -0.443435f, -0.443779f,
	-0.444122f, -0.444466f, -0.444809f, -0.445153f, -0.445496f, -0.445839f, -0.446183f, -0.446526f,
	-0.446869f, -0.447212f, -0.447555f, -0.447898f, -0.448241f, -0.448583f, -0.448926f, -0.449269f,
	-0.449611f, -0.449954f, -0.450296f, -0.450639f, -0.450981f, -0.451323f, -0.451665f, -0.452008f,
	-0.452350f, -0.452692f, -0.453033f, -0.453375f, -0.453717f, -0.454059f, -0.454400f, -0.454742f,
	-0.455084f, -0.455425f, -0.455766f, -0.456108f, -0.456449f, -0.456790f, -0.457131f, -0.457472f,
	-0.457813f, -0.458154f, -0.458495f, -0.458836f, -0.459177f, -0.459517f, -0.459858f, -0.460198f,
	-0.460539f, -0.460879f, -0.461219f, -0.461560f, -0.461900f, -0.462240f, -0.462580f, -0.462920f,
	-0.463260f, -0.463600f, -0.463939f, -0.464279f, -0.464619f, -0.464958f, -0.465298f, -0.465637f,
	-0.465977f, -0.466316f, -0.466655f, -0.466994f, -0.467333f, -0.467672f, -0.468011f, -0.468350f,
	-0.468689f, -0.469028f, -0.469366f, -0.469705f, -0.470043f, -0.470382f, -0.470720f, -0.471058f,
	-0.471397f, -0.471735f, -0.472073f, -0.472411f, -0.472749f, -0.473087f, -0.473425f, -0.473763f,
	-0.474100f, -0.474438f, -0.474775f, -0.475113f, -0.475450f, -0.475788f, -0.476125f, -0.476462f,
	-0.476799f, -0.477136f, -0.477473f, -0.477810f, -0.478147f, -0.478484f, -0.478821f, -0.479157f,
	-0.479494f, -0.479830f, -0.480167f, -0.480503f, -0.480839f, -0.481176f, -0.481512f, -0.481848f,
	-0.482184f, -0.482520f, -0.482856f, -0.483191f, -0.483527f, -0.483863f, -0.484198f, -0.484534f,
	-0.484869f, -0.485205f, -0.485540f, -0.485875f, -0.486210f, -0.486545f, -0.486880f, -0.487215f,
	-0.487550f, -0.487885f, -0.488220f, -0.488554f, -0.488889f, -0.489223f, -0.489558f, -0.489892f,
	-0.490226f, -0.490561f, -0.490895f, -0.491229f, -0.491563f, -0.491897f, -0.492231f, -0.492564f,
	-0.492898f, -0.493232f, -0.493565f, -0.493899f, -0.494232f, -0.494566f, -0.494899f, -0.495232f,
	-0.495565f, -0.495898f, -0.496231f, -0.496564f, -0.496897f, -0.497230f, -0.497562f, -0.497895f,
	-0.498228f, -0.498560f, -0.498893f, -0.499225f, -0.499557f, -0.499889f, -0.500221f, -0.500553f,
	-0.500885f, -0.501217f, -0.501549f, -0.501881f, -0.502212f, -0.502544f, -0.502876f, -0.503207f,
	-0.503538f, -0.503870f, -0.504201f, -0.504532f, -0.504863f, -0.505194f, -0.505525f, -0.505856f,
	-0.506187f, -0.506517f, -0.506848f, -0.507179f, -0.507509f, -0.507839f, -0.508170f, -0.508500f,
	-0.508830f, -0.509160f, -0.509490f, -0.509820f, -0.510150f, -0.510480f, -0.510810f, -0.511139f,
	-0.511469f, -0.511798f, -0.512128f, -0.512457f, -0.512786f, -0.513116f, -0.513445f, -0.513774f,
	-0.514103f, -0.514432f, -0.514760f, -0.515089f, -0.515418f, -0.515746f, -0.516075f, -0.516403f,
	-0.516732f, -0.517060f, -0.517388f, -0.517716f, -0.518045f, -0.518372f, -0.518700f, -0.519028f,
	-0.519356f, -0.519684f, -0.520011f, -0.520339f, -0.520666f, -0.520994f, -0.521321f, -0.521648f,
	-0.521975f, -0.522302f, -0.522629f, -0.522956f, -0.523283f, -0.523610f, -0.523937f, -0.524263f,
	-0.524590f, -0.524916f, -0.525243f, -0.525569f, -0.525895f, -0.526221f, -0.526547f, -0.526873f,
	-0.527199f, -0.527525f, -0.527851f, -0.528176f, -0.528502f, -0.528828f, -0.529153f, -0.529478f,
	-0.529804f, -0.530129f, -0.530454f, -0.530779f, -0.531104f, -0.531429f, -0.531754f, -0.532078f,
	-0.532403f, -0.532728f, -0.533052f, -0.533377f, -0.533701f, -0.534025f, -0.534349f, -0.534674f,
	-0.534998f, -0.535322f, -0.535645f, -0.535969f, -0.536293f, -0.536617f, -0.536940f, -0.537264f,
	-0.537587f, -0.537910f, -0.538234f, -0.538557f, -0.538880f, -0.539203f, -0.539526f, -0.539849f,
	-0.540171f, -0.540494f, -0.540817f, -0.541139f, -0.541462f, -0.541784f, -0.542106f, -0.542429f,
	-0.542751f, -0.543073f, -0.543395f, -0.543717f, -0.544039f, -0.544360f, -0.544682f, -0.545003f,
	-0.545325f, -0.545646f, -0.545968f, -0.546289f, -0.546610f, -0.546931f, -0.547252f, -0.547573f,
	-0.547894f, -0.548215f, -0.548536f, -0.548856f, -0.549177f, -0.549497f, -0.549818f, -0.550138f,
	-0.550458f, -0.550778f, -0.551098f, -0.551418f, -0.551738f, -0.552058f, -0.552378f, -0.552697f,
	-0.553017f, -0.553336f, -0.553656f, -0.553975f, -0.554294f, -0.554613f, -0.554932f, -0.555251f,
	-0.555570f, -0.555889f, -0.556208f, -0.556526f, -0.556845f, -0.557164f, -0.557482f, -0.557800f,
	-0.558119f, -0.558437f, -0.558755f, -0.559073f, -0.559391f, -0.559709f, -0.560026f, -0.560344f,
	-0.560662f, -0.560979f, -0.561297f, -0.561614f, -0.561931f, -0.562248f, -0.562565f, -0.562882f,
	-0.563199f, -0.563516f, -0.563833f, -0.564150f, -0.564466f, -0.564783f, -0.565099f, -0.565416f,
	-0.565732f, -0.566048f, -0.566364f, -0.566680f, -0.566996f, -0.567312f, -0.567628f, -0.567943f,
	-0.568259f, -0.568574f, -0.568890f, -0.569205f, -0.569521f, -0.569836f, -0.570151f, -0.570466f,
	-0.570781f, -0.571096f, -0.571410f, -0.571725f, -0.572040f, -0.572354f, -0.572669f, -0.572983f,
	-0.573297f, -0.573611f, -0.573925f, -0.574239f, -0.574553f, -0.574867f, -0.575181f, -0.575495f,
	-0.575808f, -0.576122f, -0.576435f, -0.576748f, -0.577062f, -0.577375f, -0.577688f, -0.578001f,
	-0.578314f, -0.578627f, -0.578939f, -0.579252f, -0.579565f, -0.579877f, -0.580189f, -0.580502f,
	-0.580814f, -0.581126f, -0.581438f, -0.581750f, -0.582062f, -0.582374f, -0.582685f, -0.582997f,
	-0.583309f, -0.583620f, -0.583931f, -0.584243f, -0.584554f, -0.584865f, -0.585176f, -0.585487f,
	-0.585798f, -0.586109f, -0.586419f, -0.586730f, -0.587040f, -0.587351f, -0.587661f, -0.587971f,
	-0.588282f, -0.588592f, -0.588902f, -0.589212f, -0.589521f, -0.589831f, -0.590141f, -0.590450f,
	-0.590760f, -0.591069f, -0.591378f, -0.591688f, -0.591997f, -0.592306f, -0.592615f, -0.592924f,
	-0.593232f, -0.593541f, -0.593850f, -0.594158f, -0.594467f, -0.594775f, -0.595083f, -0.595391f,
	-0.595699f, -0.596007f, -0.596315f, -0.596623f, -0.596931f, -0.597238f, -0.597546f, -0.597853f,
	-0.598161f, -0.598468f, -0.598775f, -0.599082f, -0.599389f, -0.599696f, -0.600003f, -0.600310f,
	-0.600616f, -0.600923f, -0.601230f, -0.601536f, -0.601842f, -0.602148f, -0.602455f, -0.602761f,
	-0.603067f, -0.603372f, -0.603678f, -0.603984f, -0.604290f, -0.604595f, -0.604900f, -0.605206f,
	-0.605511f, -0.605816f, -0.606121f, -0.606426f, -0.606731f, -0.607036f, -0.607341f, -0.607645f,
	-0.607950f, -0.608254f, -0.608559f, -0.608863f, -0.609167f, -0.609471f, -0.609775f, -0.610079f,
	-0.610383f, -0.610687f, -0.610990f, -0.611294f, -0.611597f, -0.611901f, -0.612204f, -0.612507f,
	-0.612810f, -0.613113f, -0.613416f, -0.613719f, -0.614022f, -0.614324f, -0.614627f, -0.614929f,
	-0.615232f, -0.615534f, -0.615836f, -0.616138f, -0.616440f, -0.616742f, -0.617044f, -0.617346f,
	-0.617647f, -0.617949f, -0.618250f, -0.618552f, -0.618853f, -0.619154f, -0.619455f, -0.619756f,
	-0.620057f, -0.620358f, -0.620659f, -0.620959f, -0.621260f, -0.621560f, -0.621861f, -0.622161f,
	-0.622461f, -0.622761f, -0.623061f, -0.623361f, -0.623661f, -0.623961f, -0.624260f, -0.624560f,
	-0.624860f, -0.625159f, -0.625458f, -0.625757f, -0.626056f, -0.626355f, -0.626654f, -0.626953f,
	-0.627252f, -0.627550f, -0.627849f, -0.628147f, -0.628446f, -0.628744f, -0.629042f, -0.629340f,
	-0.629638f, -0.629936f, -0.630234f, -0.630532f, -0.630829f, -0.631127f, -0.631424f, -0.631721f,
	-0.632019f, -0.632316f, -0.632613f, -0.632910f, -0.633207f, -0.633504f, -0.633800f, -0.634097f,
	-0.634393f, -0.634690f, -0.634986f, -0.635282f, -0.635578f, -0.635874f, -0.636170f, -0.636466f,
	-0.636762f, -0.637057f, -0.637353f, -0.637649f, -0.637944f, -0.638239f, -0.638534f, -0.638829f,
	-0.639124f, -0.639419f, -0.639714f, -0.640009f, -0.640303f, -0.640598f, -0.640892f, -0.641187f,
	-0.641481f, -0.641775f, -0.642069f, -0.642363f, -0.642657f, -0.642951f, -0.643245f, -0.643538f,
	-0.643832f, -0.644125f, -0.644418f, -0.644711f, -0.645005f, -0.645298f, -0.645590f, -0.645883f,
	-0.646176f, -0.646469f, -0.646761f, -0.647054f, -0.647346f, -0.647638f, -0.647930f, -0.648222f,
	-0.648514f, -0.648806f, -0.649098f, -0.649390f, -0.649681f, -0.649973f, -0.650264f, -0.650555f,
	-0.650847f, -0.651138f, -0.651429f, -0.651720f, -0.652011f, -0.652301f, -0.652592f, -0.652882f,
	-0.653173f, -0.653463f, -0.653753f, -0.654044f, -0.654334f, -0.654624f, -0.654913f, -0.655203f,
	-0.655493f, -0.655782f, -0.656072f, -0.656361f, -0.656651f, -0.656940f, -0.657229f, -0.657518f,
	-0.657807f, -0.658095f, -0.658384f, -0.658673f, -0.658961f, -0.659250f, -0.659538f, -0.659826f,
	-0.660114f, -0.660402f, -0.660690f, -0.660978f, -0.661266f, -0.661553f, -0.661841f, -0.662128f,
	-0.662416f, -0.662703f, -0.662990f, -0.663277f, -0.663564f, -0.663851f, -0.664138f, -0.664424f,
	-0.664711f, -0.664997f, -0.665284f, -0.665570f, -0.665856f, -0.666142f, -0.666428f, -0.666714f,
	-0.667000f, -0.667286f, -0.667571f, -0.667857f, -0.668142f, -0.668427f, -0.668712f, -0.668998f,
	-0.669283f, -0.669567f, -0.669852f, -0.670137f, -0.670422f, -0.670706f, -0.670990f, -0.671275f,
	-0.671559f, -0.671843f, -0.672127f, -0.672411f, -0.672695f, -0.672978f, -0.673262f, -0.673546f,
	-0.673829f, -0.674112f, -0.674396f, -0.674679f, -0.674962f, -0.675245f, -0.675527f, -0.675810f,
	-0.676093f, -0.676375f, -0.676658f, -0.676940f, -0.677222f, -0.677504f, -0.677786f, -0.678068f,
	-0.678350f, -0.678632f, -0.678913f, -0.679195f, -0.679476f, -0.679758f, -0.680039f, -0.680320f,
	-0.680601f, -0.680882f, -0.681163f, -0.681443f, -0.681724f, -0.682005f, -0.682285f, -0.682565f,
	-0.682846f, -0.683126f, -0.683406f, -0.683686f, -0.683965f, -0.684245f, -0.684525f, -0.684804f,
	-0.685084f, -0.685363f, -0.685642f, -0.685921f, -0.686200f, -0.686479f, -0.686758f, -0.687037f,
	-0.687315f, -0.687594f, -0.687872f, -0.688151f, -0.688429f, -0.688707f, -0.688985f, -0.689263f,
	-0.689541f, -0.689818f, -0.690096f, -0.690373f, -0.690651f, -0.690928f, -0.691205f, -0.691482f,
	-0.691759f, -0.692036f, -0.692313f, -0.692590f, -0.692866f, -0.693143f, -0.693419f, -0.693695f,
	-0.693971f, -0.694248f, -0.694524f, -0.694799f, -0.695075f, -0.695351f, -0.695626f, -0.695902f,
	-0.696177f, -0.696452f, -0.696728f, -0.697003f, -0.697277f, -0.697552f, -0.697827f, -0.698102f,
	-0.698376f, -0.698651f, -0.698925f, -0.699199f, -0.699473f, -0.699747f, -0.700021f, -0.700295f,
	-0.700569f, -0.700842f, -0.701116f, -0.701389f, -0.701663f, -0.701936f, -0.702209f, -0.702482f,
	-0.702755f, -0.703028f, -0.703300f, -0.703573f, -0.703845f, -0.704118f, -0.704390f, -0.704662f,
	-0.704934f, -0.705206f, -0.705478f, -0.705750f, -0.706021f, -0.706293f, -0.706564f, -0.706836f,
	-0.707107f, -0.707378f, -0.707649f, -0.707920f, -0.708191f, -0.708461f, -0.708732f, -0.709002f,
	-0.709273f, -0.709543f, -0.709813f, -0.710083f, -0.710353f, -0.710623f, -0.710893f, -0.711163f,
	-0.711432f, -0.711702f, -0.711971f, -0.712240f, -0.712509f, -0.712778f, -0.713047f, -0.713316f,
	-0.713585f, -0.713853f, -0.714122f, -0.714390f, -0.714659f, -0.714927f, -0.715195f, -0.715463f,
	-0.715731f, -0.715999f, -0.716266f, -0.716534f, -0.716801f, -0.717069f, -0.717336f, -0.717603f,
	-0.717870f, -0.718137f, -0.718404f, -0.718670f, -0.718937f, -0.719204f, -0.719470f, -0.719736f,
	-0.720003f, -0.720269f, -0.720535f, -0.720800f, -0.721066f, -0.721332f, -0.721597f, -0.721863f,
	-0.722128f, -0.722393f, -0.722659f, -0.722924f, -0.723188f, -0.723453f, -0.723718f, -0.723983f,
	-0.724247f, -0.724511f, -0.724776f, -0.725040f, -0.725304f, -0.725568f, -0.725832f, -0.726095f,
	-0.726359f, -0.726623f, -0.726886f, -0.727149f, -0.727413f, -0.727676f, -0.727939f, -0.728202f,
	-0.728464f, -0.728727f, -0.728990f, -0.729252f, -0.729514f, -0.729777f, -0.730039f, -0.730301f,
	-0.730563f, -0.730825f, -0.731086f, -0.731348f, -0.731609f, -0.731871f, -0.732132f, -0.732393f,
	-0.732654f, -0.732915f, -0.733176f, -0.733437f, -0.733697f, -0.733958f, -0.734218f, -0.734479f,
	-0.734739f, -0.734999f, -0.735259f, -0.735519f, -0.735779f, -0.736038f, -0.736298f, -0.736557f,
	-0.736817f, -0.737076f, -0.737335f, -0.737594f, -0.737853f, -0.738112f, -0.738370f, -0.738629f,
	-0.738887f, -0.739146f, -0.739404f, -0.739662f, -0.739920f, -0.740178f, -0.740436f, -0.740694f,
	-0.740951f, -0.741209f, -0.741466f, -0.741723f, -0.741980f, -0.742237f, -0.742494f, -0.742751f,
	-0.743008f, -0.743265f, -0.743521f, -0.743777f, -0.744034f, -0.744290f, -0.744546f, -0.744802f,
	-0.745058f, -0.745314f, -0.745569f, -0.745825f, -0.746080f, -0.746335f, -0.746591f, -0.746846f,
	-0.747101f, -0.747355f, -0.747610f, -0.747865f, -0.748119f, -0.748374f, -0.748628f, -0.748882f,
	-0.749136f, -0.749390f, -0.749644f, -0.749898f, -0.750152f, -0.750405f, -0.750659f, -0.750912f,
	-0.751165f, -0.751418f, -0.751671f, -0.751924f, -0.752177f, -0.752429f, -0.752682f, -0.752934f,
	-0.753187f, -0.753439f, -0.753691f, -0.753943f, -0.754195f, -0.754447f, -0.754698f, -0.754950f,
	-0.755201f, -0.755453f, -0.755704f, -0.755955f, -0.756206f, -0.756457f, -0.756708f, -0.756958f,
	-0.757209f, -0.757459f, -0.757710f, -0.757960f, -0.758210f, -0.758460f, -0.758710f, -0.758960f,
	-0.759209f, -0.759459f, -0.759708f, -0.759957f, -0.760207f, -0.760456f, -0.760705f, -0.760954f,
	-0.761202f, -0.761451f, -0.761700f, -0.761948f, -0.762196f, -0.762444f, -0.762693f, -0.762941f,
	-0.763188f, -0.763436f, -0.763684f, -0.763931f, -0.764179f, -0.764426f, -0.764673f, -0.764920f,
	-0.765167f, -0.765414f, -0.765661f, -0.765907f, -0.766154f, -0.766400f, -0.766647f, -0.766893f,
	-0.767139f, -0.767385f, -0.767631f, -0.767876f, -0.768122f, -0.768368f, -0.768613f, -0.768858f,
	-0.769103f, -0.769348f, -0.769593f, -0.769838f, -0.770083f, -0.770327f, -0.770572f, -0.770816f,
	-0.771061f, -0.771305f, -0.771549f, -0.771793f, -0.772036f, -0.772280f, -0.772524f, -0.772767f,
	-0.773010f, -0.773254f, -0.773497f, -0.773740f, -0.773983f, -0.774225f, -0.774468f, -0.774711f,
	-0.774953f, -0.775195f, -0.775438f, -0.775680f, -0.775922f, -0.776164f, -0.776405f, -0.776647f,
	-0.776888f, -0.777130f, -0.777371f, -0.777612f, -0.777853f, -0.778094f, -0.778335f, -0.778576f,
	-0.778817f, -0.779057f, -0.779297f, -0.779538f, -0.779778f, -0.780018f, -0.780258f, -0.780498f,
	-0.780737f, -0.780977f, -0.781216f, -0.781456f, -0.781695f, -0.781934f, -0.782173f, -0.782412f,
	-0.782651f, -0.782889f, -0.783128f, -0.783366f, -0.783605f, -0.783843f, -0.784081f, -0.784319f,
	-0.784557f, -0.784794f, -0.785032f, -0.785269f, -0.785507f, -0.785744f, -0.785981f, -0.786218f,
	-0.786455f, -0.786692f, -0.786929f, -0.787165f, -0.787402f, -0.787638f, -0.787874f, -0.788110f,
	-0.788346f, -0.788582f, -0.788818f, -0.789054f, -0.789289f, -0.789525f, -0.789760f, -0.789995f,
	-0.790230f, -0.790465f, -0.790700f, -0.790935f, -0.791169f, -0.791404f, -0.791638f, -0.791872f,
	-0.792107f, -0.792341f, -0.792575f, -0.792808f, -0.793042f, -0.793276f, -0.793509f, -0.793742f,
	-0.793975f, -0.794209f, -0.794442f, -0.794674f, -0.794907f, -0.795140f, -0.795372f, -0.795605f,
	-0.795837f, -0.796069f, -0.796301f, -0.796533f, -0.796765f, -0.796996f, -0.797228f, -0.797459f,
	-0.797691f, -0.797922f, -0.798153f, -0.798384f, -0.798615f, -0.798846f, -0.799076f, -0.799307f,
	-0.799537f, -0.799768f, -0.799998f, -0.800228f, -0.800458f, -0.800687f, -0.800917f, -0.801147f,
	-0.801376f, -0.801606f, -0.801835f, -0.802064f, -0.802293f, -0.802522f, -0.802750f, -0.802979f,
	-0.803208f, -0.803436f, -0.803664f, -0.803892f, -0.804120f, -0.804348f, -0.804576f, -0.804804f,
	-0.805031f, -0.805259f, -0.805486f, -0.805713f, -0.805940f, -0.806167f, -0.806394f, -0.806621f,
	-0.806848f, -0.807074f, -0.807300f, -0.807527f, -0.807753f, -0.807979f, -0.808205f, -0.808430f,
	-0.808656f, -0.808882f, -0.809107f, -0.809332f, -0.809558f, -0.809783f, -0.810008f, -0.810232f,
	-0.810457f, -0.810682f, -0.810906f, -0.811131f, -0.811355f, -0.811579f, -0.811803f, -0.812027f,
	-0.812251f, -0.812474f, -0.812698f, -0.812921f, -0.813144f, -0.813368f, -0.813591f, -0.813814f,
	-0.814036f, -0.814259f, -0.814482f, -0.814704f, -0.814926f, -0.815149f, -0.815371f, -0.815593f,
	-0.815814f, -0.816036f, -0.816258f, -0.816479f, -0.816701f, -0.816922f, -0.817143f, -0.817364f,
	-0.817585f, -0.817806f, -0.818026f, -0.818247f, -0.818467f, -0.818687f, -0.818908f, -0.819128f,
	-0.819348f, -0.819567f, -0.819787f, -0.820007f, -0.820226f, -0.820445f, -0.820664f, -0.820884f,
	-0.821102f, -0.821321f, -0.821540f, -0.821759f, -0.821977f, -0.822195f, -0.822414f, -0.822632f,
	-0.822850f, -0.823068f, -0.823285f, -0.823503f, -0.823721f, -0.823938f, -0.824155f, -0.824372f,
	-0.824589f, -0.824806f, -0.825023f, -0.825240f, -0.825456f, -0.825673f, -0.825889f, -0.826105f,
	-0.826321f, -0.826537f, -0.826753f, -0.826968f, -0.827184f, -0.827399f, -0.827615f, -0.827830f,
	-0.828045f, -0.828260f, -0.828475f, -0.828690f, -0.828904f, -0.829119f, -0.829333f, -0.829547f,
	-0.829761f, -0.829975f, -0.830189f, -0.830403f, -0.830616f, -0.830830f, -0.831043f, -0.831257f,
	-0.831470f, -0.831683f, -0.831895f, -0.832108f, -0.832321f, -0.832533f, -0.832746f, -0.832958f,
	-0.833170f, -0.833382f, -0.833594f, -0.833806f, -0.834018f, -0.834229f, -0.834440f, -0.834652f,
	-0.834863f, -0.835074f, -0.835285f, -0.835496f, -0.835706f, -0.835917f, -0.836127f, -0.836338f,
	-0.836548f, -0.836758f, -0.836968f, -0.837178f, -0.837387f, -0.837597f, -0.837806f, -0.838015f,
	-0.838225f, -0.838434f, -0.838643f, -0.838852f, -0.839060f, -0.839269f, -0.839477f, -0.839686f,
	-0.839894f, -0.840102f, -0.840310f, -0.840518f, -0.840725f, -0.840933f, -0.841140f, -0.841348f,
	-0.841555f, -0.841762f, -0.841969f, -0.842176f, -0.842383f, -0.842589f, -0.842796f, -0.843002f,
	-0.843208f, -0.843414f, -0.843620f, -0.843826f, -0.844032f, -0.844238f, -0.844443f, -0.844648f,
	-0.844854f, -0.845059f, -0.845264f, -0.845469f, -0.845673f, -0.845878f, -0.846082f, -0.846287f,
	-0.846491f, -0.846695f, -0.846899f, -0.847103f, -0.847307f, -0.847510f, -0.847714f, -0.847917f,
	-0.848120f, -0.848323f, -0.848526f, -0.848729f, -0.848932f, -0.849135f, -0.849337f, -0.849540f,
	-0.849742f, -0.849944f, -0.850146f, -0.850348f, -0.850549f, -0.850751f, -0.850953f, -0.851154f,
	-0.851355f, -0.851556f, -0.851757f, -0.851958f, -0.852159f, -0.852360f, -0.852560f, -0.852760f,
	-0.852961f, -0.853161f, -0.853361f, -0.853561f, -0.853760f, -0.853960f, -0.854159f, -0.854359f,
	-0.854558f, -0.854757f, -0.854956f, -0.855155f, -0.855354f, -0.855552f, -0.855751f, -0.855949f,
	-0.856147f, -0.856345f, -0.856543f, -0.856741f, -0.856939f, -0.857137f, -0.857334f, -0.857531f,
	-0.857729f, -0.857926f, -0.858123f, -0.858320f, -0.858516f, -0.858713f, -0.858909f, -0.859106f,
	-0.859302f, -0.859498f, -0.859694f, -0.859890f, -0.860085f, -0.860281f, -0.860476f, -0.860672f,
	-0.860867f, -0.861062f, -0.861257f, -0.861452f, -0.861646f, -0.861841f, -0.862035f, -0.862230f,
	-0.862424f, -0.862618f, -0.862812f, -0.863006f, -0.863199f, -0.863393f, -0.863586f, -0.863780f,
	-0.863973f, -0.864166f, -0.864359f, -0.864552f, -0.864744f, -0.864937f, -0.865129f, -0.865321f,
	-0.865514f, -0.865706f, -0.865898f, -0.866089f, -0.866281f, -0.866472f, -0.866664f, -0.866855f,
	-0.867046f, -0.867237f, -0.867428f, -0.867619f, -0.867809f, -0.868000f, -0.868190f, -0.868381f,
	-0.868571f, -0.868761f, -0.868951f, -0.869140f, -0.869330f, -0.869519f, -0.869709f, -0.869898f,
	-0.870087f, -0.870276f, -0.870465f, -0.870654f, -0.870842f, -0.871031f, -0.871219f, -0.871407f,
	-0.871595f, -0.871783f, -0.871971f, -0.872159f, -0.872346f, -0.872534f, -0.872721f, -0.872908f,
	-0.873095f, -0.873282f, -0.873469f, -0.873655f, -0.873842f, -0.874028f, -0.874215f, -0.874401f,
	-0.874587f, -0.874773f, -0.874958f, -0.875144f, -0.875329f, -0.875515f, -0.875700f, -0.875885f,
	-0.876070f, -0.876255f, -0.876440f, -0.876624f, -0.876809f, -0.876993f, -0.877177f, -0.877361f,
	-0.877545f, -0.877729f, -0.877913f, -0.878096f, -0.878280f, -0.878463f, -0.878646f, -0.878829f,
	-0.879012f, -0.879195f, -0.879378f, -0.879560f, -0.879743f, -0.879925f, -0.880107f, -0.880289f,
	-0.880471f, -0.880653f, -0.880834f, -0.881016f, -0.881197f, -0.881378f, -0.881559f, -0.881740f,
	-0.881921f, -0.882102f, -0.882283f, -0.882463f, -0.882643f, -0.882824f, -0.883004f, -0.883184f,
	-0.883363f, -0.883543f, -0.883723f, -0.883902f, -0.884081f, -0.884260f, -0.884439f, -0.884618f,
	-0.884797f, -0.884976f, -0.885154f, -0.885333f, -0.885511f, -0.885689f, -0.885867f, -0.886045f,
	-0.886223f, -0.886400f, -0.886578f, -0.886755f, -0.886932f, -0.887109f, -0.887286f, -0.887463f,
	-0.887640f, -0.887816f, -0.887993f, -0.888169f, -0.888345f, -0.888521f, -0.888697f, -0.888873f,
	-0.889048f, -0.889224f, -0.889399f, -0.889574f, -0.889750f, -0.889925f, -0.890099f, -0.890274f,
	-0.890449f, -0.890623f, -0.890797f, -0.890972f, -0.891146f, -0.891320f, -0.891493f, -0.891667f,
	-0.891841f, -0.892014f, -0.892187f, -0.892361f, -0.892534f, -0.892706f, -0.892879f, -0.893052f,
	-0.893224f, -0.893397f, -0.893569f, -0.893741f, -0.893913f, -0.894085f, -0.894256f, -0.894428f,
	-0.894599f, -0.894771f, -0.894942f, -0.895113f, -0.895284f, -0.895455f, -0.895625f, -0.895796f,
	-0.895966f, -0.896137f, -0.896307f, -0.896477f, -0.896646f, -0.896816f, -0.896986f, -0.897155f,
	-0.897325f, -0.897494f, -0.897663f, -0.897832f, -0.898001f, -0.898169f, -0.898338f, -0.898506f,
	-0.898674f, -0.898843f, -0.899011f, -0.899179f, -0.899346f, -0.899514f, -0.899681f, -0.899849f,
	-0.900016f, -0.900183f, -0.900350f, -0.900517f, -0.900683f, -0.900850f, -0.901016f, -0.901183f,
	-0.901349f, -0.901515f, -0.901681f, -0.901847f, -0.902012f, -0.902178f, -0.902343f, -0.902508f,
	-0.902673f, -0.902838f, -0.903003f, -0.903168f, -0.903332f, -0.903497f, -0.903661f, -0.903825f,
	-0.903989f, -0.904153f, -0.904317f, -0.904481f, -0.904644f, -0.904807f, -0.904971f, -0.905134f,
	-0.905297f, -0.905460f, -0.905622f, -0.905785f, -0.905947f, -0.906110f, -0.906272f, -0.906434f,
	-0.906596f, -0.906757f, -0.906919f, -0.907081f, -0.907242f, -0.907403f, -0.907564f, -0.907725f,
	-0.907886f, -0.908047f, -0.908207f, -0.908368f, -0.908528f, -0.908688f, -0.908848f, -0.909008f,
	-0.909168f, -0.909328f, -0.909487f, -0.909646f, -0.909806f, -0.909965f, -0.910124f, -0.910283f,
	-0.910441f, -0.910600f, -0.910758f, -0.910917f, -0.911075f, -0.911233f, -0.911391f, -0.911548f,
	-0.911706f, -0.911864f, -0.912021f, -0.912178f, -0.912335f, -0.912492f, -0.912649f, -0.912806f,
	-0.912962f, -0.913119f, -0.913275f, -0.913431f, -0.913587f, -0.913743f, -0.913899f, -0.914054f,
	-0.914210f, -0.914365f, -0.914520f, -0.914675f, -0.914830f, -0.914985f, -0.915140f, -0.915294f,
	-0.915449f, -0.915603f, -0.915757f, -0.915911f, -0.916065f, -0.916219f, -0.916372f, -0.916526f,
	-0.916679f, -0.916832f, -0.916985f, -0.917138f, -0.917291f, -0.917444f, -0.917596f, -0.917749f,
	-0.917901f, -0.918053f, -0.918205f, -0.918357f, -0.918508f, -0.918660f, -0.918811f, -0.918963f,
	-0.919114f, -0.919265f, -0.919416f, -0.919567f, -0.919717f, -0.919868f, -0.920018f, -0.920168f,
	-0.920318f, -0.920468f, -0.920618f, -0.920768f, -0.920917f, -0.921067f, -0.921216f, -0.921365f,
	-0.921514f, -0.921663f, -0.921812f, -0.921960f, -0.922109f, -0.922257f, -0.922405f, -0.922553f,
	-0.922701f, -0.922849f, -0.922997f, -0.923144f, -0.923291f, -0.923439f, -0.923586f, -0.923733f,
	-0.923880f, -0.924026f, -0.924173f, -0.924319f, -0.924465f, -0.924612f, -0.924758f, -0.924904f,
	-0.925049f, -0.925195f, -0.925340f, -0.925486f, -0.925631f, -0.925776f, -0.925921f, -0.926066f,
	-0.926210f, -0.926355f, -0.926499f, -0.926643f, -0.926787f, -0.926931f, -0.927075f, -0.927219f,
	-0.927363f, -0.927506f, -0.927649f, -0.927792f, -0.927935f, -0.928078f, -0.928221f, -0.928364f,
	-0.928506f, -0.928648f, -0.928791f, -0.928933f, -0.929075f, -0.929216f, -0.929358f, -0.929500f,
	-0.929641f, -0.929782f, -0.929923f, -0.930064f, -0.930205f, -0.930346f, -0.930486f, -0.930627f,
	-0.930767f, -0.930907f, -0.931047f, -0.931187f, -0.931327f, -0.931466f, -0.931606f, -0.931745f,
	-0.931884f, -0.932023f, -0.932162f, -0.932301f, -0.932440f, -0.932578f, -0.932716f, -0.932855f,
	-0.932993f, -0.933131f, -0.933269f, -0.933406f, -0.933544f, -0.933681f, -0.933818f, -0.933956f,
	-0.934093f, -0.934229f, -0.934366f, -0.934503f, -0.934639f, -0.934775f, -0.934912f, -0.935048f,
	-0.935184f, -0.935319f, -0.935455f, -0.935590f, -0.935726f, -0.935861f, -0.935996f, -0.936131f,
	-0.936266f, -0.936400f, -0.936535f, -0.936669f, -0.936803f, -0.936938f, -0.937072f, -0.937205f,
	-0.937339f, -0.937473f, -0.937606f, -0.937739f, -0.937872f, -0.938005f, -0.938138f, -0.938271f,
	-0.938404f, -0.938536f, -0.938668f, -0.938800f, -0.938932f, -0.939064f, -0.939196f, -0.939328f,
	-0.939459f, -0.939591f, -0.939722f, -0.939853f, -0.939984f, -0.940115f, -0.940245f, -0.940376f,
	-0.940506f, -0.940636f, -0.940766f, -0.940896f, -0.941026f, -0.941156f, -0.941285f, -0.941415f,
	-0.941544f, -0.941673f, -0.941802f, -0.941931f, -0.942060f, -0.942188f, -0.942317f, -0.942445f,
	-0.942573f, -0.942701f, -0.942829f, -0.942957f, -0.943084f, -0.943212f, -0.943339f, -0.943466f,
	-0.943593f, -0.943720f, -0.943847f, -0.943974f, -0.944100f, -0.944227f, -0.944353f, -0.944479f,
	-0.944605f, -0.944731f, -0.944856f, -0.944982f, -0.945107f, -0.945232f, -0.945358f, -0.945482f,
	-0.945607f, -0.945732f, -0.945857f, -0.945981f, -0.946105f, -0.946229f, -0.946353f, -0.946477f,
	-0.946601f, -0.946724f, -0.946848f, -0.946971f, -0.947094f, -0.947217f, -0.947340f, -0.947463f,
	-0.947586f, -0.947708f, -0.947830f, -0.947953f, -0.948075f, -0.948196f, -0.948318f, -0.948440f,
	-0.948561f, -0.948683f, -0.948804f, -0.948925f, -0.949046f, -0.949167f, -0.949287f, -0.949408f,
	-0.949528f, -0.949648f, -0.949768f, -0.949888f, -0.950008f, -0.950128f, -0.950247f, -0.950367f,
	-0.950486f, -0.950605f, -0.950724f, -0.950843f, -0.950962f, -0.951080f, -0.951199f, -0.951317f,
	-0.951435f, -0.951553f, -0.951671f, -0.951789f, -0.951906f, -0.952024f, -0.952141f, -0.952258f,
	-0.952375f, -0.952492f, -0.952609f, -0.952725f, -0.952842f, -0.952958f, -0.953074f, -0.953190f,
	-0.953306f, -0.953422f, -0.953537f, -0.953653f, -0.953768f, -0.953883f, -0.953998f, -0.954113f,
	-0.954228f, -0.954343f, -0.954457f, -0.954572f, -0.954686f, -0.954800f, -0.954914f, -0.955028f,
	-0.955141f, -0.955255f, -0.955368f, -0.955481f, -0.955594f, -0.955707f, -0.955820f, -0.955933f,
	-0.956045f, -0.956158f, -0.956270f, -0.956382f, -0.956494f, -0.956606f, -0.956717f, -0.956829f,
	-0.956940f, -0.957052f, -0.957163f, -0.957274f, -0.957385f, -0.957495f, -0.957606f, -0.957716f,
	-0.957826f, -0.957937f, -0.958046f, -0.958156f, -0.958266f, -0.958376f, -0.958485f, -0.958594f,
	-0.958703f, -0.958812f, -0.958921f, -0.959030f, -0.959139f, -0.959247f, -0.959355f, -0.959463f,
	-0.959572f, -0.959679f, -0.959787f, -0.959895f, -0.960002f, -0.960109f, -0.960217f, -0.960324f,
	-0.960431f, -0.960537f, -0.960644f, -0.960750f, -0.960857f, -0.960963f, -0.961069f, -0.961175f,
	-0.961280f, -0.961386f, -0.961492f, -0.961597f, -0.961702f, -0.961807f, -0.961912f, -0.962017f,
	-0.962121f, -0.962226f, -0.962330f, -0.962434f, -0.962538f, -0.962642f, -0.962746f, -0.962850f,
	-0.962953f, -0.963057f, -0.963160f, -0.963263f, -0.963366f, -0.963469f, -0.963571f, -0.963674f,
	-0.963776f, -0.963878f, -0.963980f, -0.964082f, -0.964184f, -0.964286f, -0.964387f, -0.964489f,
	-0.964590f, -0.964691f, -0.964792f, -0.964893f, -0.964993f, -0.965094f, -0.965194f, -0.965294f,
	-0.965394f, -0.965494f, -0.965594f, -0.965694f, -0.965793f, -0.965893f, -0.965992f, -0.966091f,
	-0.966190f, -0.966289f, -0.966387f, -0.966486f, -0.966584f, -0.966683f, -0.966781f, -0.966879f,
	-0.966976f, -0.967074f, -0.967172f, -0.967269f, -0.967366f, -0.967463f, -0.967560f, -0.967657f,
	-0.967754f, -0.967850f, -0.967947f, -0.968043f, -0.968139f, -0.968235f, -0.968331f, -0.968427f,
	-0.968522f, -0.968617f, -0.968713f, -0.968808f, -0.968903f, -0.968998f, -0.969092f, -0.969187f,
	-0.969281f, -0.969375f, -0.969470f, -0.969564f, -0.969657f, -0.969751f, -0.969845f, -0.969938f,
	-0.970031f, -0.970124f, -0.970217f, -0.970310f, -0.970403f, -0.970495f, -0.970588f, -0.970680f,
	-0.970772f, -0.970864f, -0.970956f, -0.971048f, -0.971139f, -0.971231f, -0.971322f, -0.971413f,
	-0.971504f, -0.971595f, -0.971685f, -0.971776f, -0.971866f, -0.971957f, -0.972047f, -0.972137f,
	-0.972227f, -0.972316f, -0.972406f, -0.972495f, -0.972584f, -0.972673f, -0.972762f, -0.972851f,
	-0.972940f, -0.973028f, -0.973117f, -0.973205f, -0.973293f, -0.973381f, -0.973469f, -0.973557f,
	-0.973644f, -0.973732f, -0.973819f, -0.973906f, -0.973993f, -0.974080f, -0.974166f, -0.974253f,
	-0.974339f, -0.974426f, -0.974512f, -0.974598f, -0.974684f, -0.974769f, -0.974855f, -0.974940f,
	-0.975025f, -0.975110f, -0.975195f, -0.975280f, -0.975365f, -0.975449f, -0.975534f, -0.975618f,
	-0.975702f, -0.975786f, -0.975870f, -0.975954f, -0.976037f, -0.976120f, -0.976204f, -0.976287f,
	-0.976370f, -0.976453f, -0.976535f, -0.976618f, -0.976700f, -0.976782f, -0.976864f, -0.976946f,
	-0.977028f, -0.977110f, -0.977191f, -0.977273f, -0.977354f, -0.977435f, -0.977516f, -0.977597f,
	-0.977677f, -0.977758f, -0.977838f, -0.977918f, -0.977998f, -0.978078f, -0.978158f, -0.978238f,
	-0.978317f, -0.978397f, -0.978476f, -0.978555f, -0.978634f, -0.978713f, -0.978791f, -0.978870f,
	-0.978948f, -0.979026f, -0.979104f, -0.979182f, -0.979260f, -0.979338f, -0.979415f, -0.979493f,
	-0.979570f, -0.979647f, -0.979724f, -0.979800f, -0.979877f, -0.979954f, -0.980030f, -0.980106f,
	-0.980182f, -0.980258f, -0.980334f, -0.980409f, -0.980485f, -0.980560f, -0.980635f, -0.980710f,
	-0.980785f, -0.980860f, -0.980935f, -0.981009f, -0.981083f, -0.981158f, -0.981232f, -0.981305f,
	-0.981379f, -0.981453f, -0.981526f, -0.981600f, -0.981673f, -0.981746f, -0.981819f, -0.981891f,
	-0.981964f, -0.982036f, -0.982109f, -0.982181f, -0.982253f, -0.982325f, -0.982396f, -0.982468f,
	-0.982539f, -0.982611f, -0.982682f, -0.982753f, -0.982824f, -0.982894f, -0.982965f, -0.983035f,
	-0.983105f, -0.983176f, -0.983246f, -0.983315f, -0.983385f, -0.983455f, -0.983524f, -0.983593f,
	-0.983662f, -0.983731f, -0.983800f, -0.983869f, -0.983937f, -0.984006f, -0.984074f, -0.984142f,
	-0.984210f, -0.984278f, -0.984346f, -0.984413f, -0.984480f, -0.984548f, -0.984615f, -0.984682f,
	-0.984748f, -0.984815f, -0.984882f, -0.984948f, -0.985014f, -0.985080f, -0.985146f, -0.985212f,
	-0.985278f, -0.985343f, -0.985408f, -0.985474f, -0.985539f, -0.985604f, -0.985668f, -0.985733f,
	-0.985798f, -0.985862f, -0.985926f, -0.985990f, -0.986054f, -0.986118f, -0.986181f, -0.986245f,
	-0.986308f, -0.986371f, -0.986434f, -0.986497f, -0.986560f, -0.986623f, -0.986685f, -0.986747f,
	-0.986809f, -0.986871f, -0.986933f, -0.986995f, -0.987057f, -0.987118f, -0.987179f, -0.987240f,
	-0.987301f, -0.987362f, -0.987423f, -0.987484f, -0.987544f, -0.987604f, -0.987664f, -0.987724f,
	-0.987784f, -0.987844f, -0.987903f, -0.987963f, -0.988022f, -0.988081f, -0.988140f, -0.988199f,
	-0.988258f, -0.988316f, -0.988374f, -0.988433f, -0.988491f, -0.988549f, -0.988607f, -0.988664f,
	-0.988722f, -0.988779f, -0.988836f, -0.988893f, -0.988950f, -0.989007f, -0.989064f, -0.989120f,
	-0.989177f, -0.989233f, -0.989289f, -0.989345f, -0.989400f, -0.989456f, -0.989511f, -0.989567f,
	-0.989622f, -0.989677f, -0.989732f, -0.989787f, -0.989841f, -0.989896f, -0.989950f, -0.990004f,
	-0.990058f, -0.990112f, -0.990166f, -0.990219f, -0.990273f, -0.990326f, -0.990379f, -0.990432f,
	-0.990485f, -0.990538f, -0.990590f, -0.990643f, -0.990695f, -0.990747f, -0.990799f, -0.990851f,
	-0.990903f, -0.990954f, -0.991006f, -0.991057f, -0.991108f, -0.991159f, -0.991210f, -0.991260f,
	-0.991311f, -0.991361f, -0.991411f, -0.991462f, -0.991511f, -0.991561f, -0.991611f, -0.991660f,
	-0.991710f, -0.991759f, -0.991808f, -0.991857f, -0.991906f, -0.991954f, -0.992003f, -0.992051f,
	-0.992099f, -0.992147f, -0.992195f, -0.992243f, -0.992291f, -0.992338f, -0.992385f, -0.992433f,
	-0.992480f, -0.992526f, -0.992573f, -0.992620f, -0.992666f, -0.992712f, -0.992759f, -0.992805f,
	-0.992850f, -0.992896f, -0.992942f, -0.992987f, -0.993032f, -0.993077f, -0.993122f, -0.993167f,
	-0.993212f, -0.993257f, -0.993301f, -0.993345f, -0.993389f, -0.993433f, -0.993477f, -0.993521f,
	-0.993564f, -0.993608f, -0.993651f, -0.993694f, -0.993737f, -0.993779f, -0.993822f, -0.993865f,
	-0.993907f, -0.993949f, -0.993991f, -0.994033f, -0.994075f, -0.994116f, -0.994158f, -0.994199f,
	-0.994240f, -0.994281f, -0.994322f, -0.994363f, -0.994404f, -0.994444f, -0.994484f, -0.994525f,
	-0.994565f, -0.994604f, -0.994644f, -0.994684f, -0.994723f, -0.994762f, -0.994802f, -0.994841f,
	-0.994879f, -0.994918f, -0.994957f, -0.994995f, -0.995033f, -0.995071f, -0.995109f, -0.995147f,
	-0.995185f, -0.995222f, -0.995260f, -0.995297f, -0.995334f, -0.995371f, -0.995408f, -0.995444f,
	-0.995481f, -0.995517f, -0.995553f, -0.995589f, -0.995625f, -0.995661f, -0.995697f, -0.995732f,
	-0.995767f, -0.995803f, -0.995838f, -0.995872f, -0.995907f, -0.995942f, -0.995976f, -0.996011f,
	-0.996045f, -0.996079f, -0.996113f, -0.996146f, -0.996180f, -0.996213f, -0.996247f, -0.996280f,
	-0.996313f, -0.996345f, -0.996378f, -0.996411f, -0.996443f, -0.996475f, -0.996507f, -0.996539f,
	-0.996571f, -0.996603f, -0.996634f, -0.996666f, -0.996697f, -0.996728f, -0.996759f, -0.996790f,
	-0.996820f, -0.996851f, -0.996881f, -0.996911f, -0.996941f, -0.996971f, -0.997001f, -0.997031f,
	-0.997060f, -0.997089f, -0.997119f, -0.997148f, -0.997176f, -0.997205f, -0.997234f, -0.997262f,
	-0.997290f, -0.997319f, -0.997347f, -0.997374f, -0.997402f, -0.997430f, -0.997457f, -0.997484f,
	-0.997511f, -0.997538f, -0.997565f, -0.997592f, -0.997618f, -0.997645f, -0.997671f, -0.997697f,
	-0.997723f, -0.997749f, -0.997774f, -0.997800f, -0.997825f, -0.997851f, -0.997876f, -0.997901f,
	-0.997925f, -0.997950f, -0.997974f, -0.997999f, -0.998023f, -0.998047f, -0.998071f, -0.998094f,
	-0.998118f, -0.998142f, -0.998165f, -0.998188f, -0.998211f, -0.998234f, -0.998257f, -0.998279f,
	-0.998302f, -0.998324f, -0.998346f, -0.998368f, -0.998390f, -0.998411f, -0.998433f, -0.998454f,
	-0.998476f, -0.998497f, -0.998518f, -0.998538f, -0.998559f, -0.998580f, -0.998600f, -0.998620f,
	-0.998640f, -0.998660f, -0.998680f, -0.998700f, -0.998719f, -0.998738f, -0.998758f, -0.998777f,
	-0.998795f, -0.998814f, -0.998833f, -0.998851f, -0.998870f, -0.998888f, -0.998906f, -0.998924f,
	-0.998941f, -0.998959f, -0.998976f, -0.998994f, -0.999011f, -0.999028f, -0.999044f, -0.999061f,
	-0.999078f, -0.999094f, -0.999110f, -0.999126f, -0.999142f, -0.999158f, -0.999174f, -0.999189f,
	-0.999205f, -0.999220f, -0.999235f, -0.999250f, -0.999265f, -0.999279f, -0.999294f, -0.999308f,
	-0.999322f, -0.999336f, -0.999350f, -0.999364f, -0.999378f, -0.999391f, -0.999404f, -0.999418f,
	-0.999431f, -0.999443f, -0.999456f, -0.999469f, -0.999481f, -0.999493f, -0.999506f, -0.999518f,
	-0.999529f, -0.999541f, -0.999553f, -0.999564f, -0.999575f, -0.999586f, -0.999597f, -0.999608f,
	-0.999619f, -0.999629f, -0.999640f, -0.999650f, -0.999660f, -0.999670f, -0.999680f, -0.999689f,
	-0.999699f, -0.999708f, -0.999717f, -0.999726f, -0.999735f, -0.999744f, -0.999753f, -0.999761f,
	-0.999769f, -0.999778f, -0.999786f, -0.999793f, -0.999801f, -0.999809f, -0.999816f, -0.999823f,
	-0.999831f, -0.999838f, -0.999844f, -0.999851f, -0.999858f, -0.999864f, -0.999870f, -0.999876f,
	-0.999882f, -0.999888f, -0.999894f, -0.999899f, -0.999905f, -0.999910f, -0.999915f, -0.999920f,
	-0.999925f, -0.999929f, -0.999934f, -0.999938f, -0.999942f, -0.999946f, -0.999950f, -0.999954f,
	-0.999958f, -0.999961f, -0.999964f, -0.999968f, -0.999971f, -0.999973f, -0.999976f, -0.999979f,
	-0.999981f, -0.999983f, -0.999986f, -0.999988f, -0.999989f, -0.999991f, -0.999993f, -0.999994f,
	-0.999995f, -0.999996f, -0.999997f, -0.999998f, -0.999999f, -0.999999f, -1.000000f, -1.000000f
};

static const float sinTable32768[16384] = {
	 0.000000f,  0.000192f,  0.000383f,  0.000575f,  0.000767f,  0.000959f,  0.001150f,  0.001342f,
	 0.001534f,  0.001726f,  0.001917f,  0.002109f,  0.002301f,  0.002493f,  0.002684f,  0.002876f,
	 0.003068f,  0.003260f,  0.003451f,  0.003643f,  0.003835f,  0.004027f,  0.004218f,  0.004410f,
	 0.004602f,  0.004794f,  0.004985f,  0.005177f,  0.005369f,  0.005561f,  0.005752f,  0.005944f,
	 0.006136f,  0.006328f,  0.006519f,  0.006711f,  0.006903f,  0.007095f,  0.007286f,  0.007478f,
	 0.007670f,  0.007862f,  0.008053f,  0.008245f,  0.008437f,  0.008629f,  0.008820f,  0.009012f,
	 0.009204f,  0.009395f,  0.009587f,  0.009779f,  0.009971f,  0.010162f,  0.010354f,  0.010546f,
	 0.010738f,  0.010929f,  0.011121f,  0.011313f,  0.011505f,  0.011696f,  0.011888f,  0.012080f,
	 0.012272f,  0.012463f,  0.012655f,  0.012847f,  0.013038f,  0.013230f,  0.013422f,  0.013614f,
	 0.013805f,  0.013997f,  0.014189f,  0.014381f,  0.014572f,  0.014764f,  0.014956f,  0.015147f,
	 0.015339f,  0.015531f,  0.015723f,  0.015914f,  0.016106f,  0.016298f,  0.016490f,  0.016681f,
	 0.016873f,  0.017065f,  0.017256f,  0.017448f,  0.017640f,  0.017832f,  0.018023f,  0.018215f,
	 0.018407f,  0.018598f,  0.018790f,  0.018982f,  0.019174f,  0.019365f,  0.019557f,  0.019749f,
	 0.019940f,  0.020132f,  0.020324f,  0.020516f,  0.020707f,  0.020899f,  0.021091f,  0.021282f,
	 0.021474f,  0.021666f,  0.021857f,  0.022049f,  0.022241f,  0.022433f,  0.022624f,  0.022816f,
	 0.023008f,  0.023199f,  0.023391f,  0.023583f,  0.023774f,  0.023966f,  0.024158f,  0.024350f,
	 0.024541f,  0.024733f,  0.024925f,  0.025116f,  0.025308f,  0.025500f,  0.025691f,  0.025883f,
	 0.026075f,  0.026266f,  0.026458f,  0.026650f,  0.026841f,  0.027033f,  0.027225f,  0.027416f,
	 0.027608f,  0.027800f,  0.027991f,  0.028183f,  0.028375f,  0.028567f,  0.028758f,  0.028950f,
	 0.029142f,  0.029333f,  0.029525f,  0.029717f,  0.029908f,  0.030100f,  0.030291f,  0.030483f,
	 0.030675f,  0.030866f,  0.031058f,  0.031250f,  0.031441f,  0.031633f,  0.031825f,  0.032016f,
	 0.032208f,  0.032400f,  0.032591f,  0.032783f,  0.032975f,  0.033166f,  0.033358f,  0.033550f,
	 0.033741f,  0.033933f,  0.034124f,  0.034316f,  0.034508f,  0.034699f,  0.034891f,  0.035083f,
	 0.035274f,  0.035466f,  0.035657f,  0.035849f,  0.036041f,  0.036232f,  0.036424f,  0.036616f,
	 0.036807f,  0.036999f,  0.037190f,  0.037382f,  0.037574f,  0.037765f,  0.037957f,  0.038149f,
	 0.038340f,  0.038532f,  0.038723f,  0.038915f,  0.039107f,  0.039298f,  0.039490f,  0.039681f,
	 0.039873f,  0.040065f,  0.040256f,  0.040448f,  0.040639f,  0.040831f,  0.041022f,  0.041214f,
	 0.041406f,  0.041597f,  0.041789f,  0.041980f,  0.042172f,  0.042364f,  0.042555f,  0.042747f,
	 0.042938f,  0.043130f,  0.043321f,  0.043513f,  0.043705f,  0.043896f,  0.044088f,  0.044279f,
	 0.044471f,  0.044662f,  0.044854f,  0.045045f,  0.045237f,  0.045429f,  0.045620f,  0.045812f,
	 0.046003f,  0.046195f,  0.046386f,  0.046578f,  0.046769f,  0.046961f,  0.047152f,  0.047344f,
	 0.047535f,  0.047727f,  0.047919f,  0.048110f,  0.048302f,  0.048493f,  0.048685f,  0.048876f,
	 0.049068f,  0.049259f,  0.049451f,  0.049642f,  0.049834f,  0.050025f,  0.050217f,  0.050408f,
	 0.050600f,  0.050791f,  0.050983f,  0.051174f,  0.051366f,  0.051557f,  0.051749f,  0.051940f,
	 0.052132f,  0.052323f,  0.052515f,  0.052706f,  0.052898f,  0.053089f,  0.053281f,  0.053472f,
	 0.053664f,  0.053855f,  0.054046f,  0.054238f,  0.054429f,  0.054621f,  0.054812f,  0.055004f,
	 0.055195f,  0.055387f,  0.055578f,  0.055770f,  0.055961f,  0.056152f,  0.056344f,  0.056535f,
	 0.056727f,  0.056918f,  0.057110f,  0.057301f,  0.057493f,  0.057684f,  0.057875f,  0.058067f,
	 0.058258f,  0.058450f,  0.058641f,  0.058833f,  0.059024f,  0.059215f,  0.059407f,  0.059598f,
	 0.059790f,  0.059981f,  0.060172f,  0.060364f,  0.060555f,  0.060747f,  0.060938f,  0.061129f,
	 0.061321f,  0.061512f,  0.061704f,  0.061895f,  0.062086f,  0.062278f,  0.062469f,  0.062660f,
	 0.062852f,  0.063043f,  0.063234f,  0.063426f,  0.063617f,  0.063809f,  0.064000f,  0.064191f,
	 0.064383f,  0.064574f,  0.064765f,  0.064957f,  0.065148f,  0.065339f,  0.065531f,  0.065722f,
	 0.065913f,  0.066105f,  0.066296f,  0.066487f,  0.066679f,  0.066870f,  0.067061f,  0.067253f,
	 0.067444f,  0.067635f,  0.067827f,  0.068018f,  0.068209f,  0.068400f,  0.068592f,  0.068783f,
	 0.068974f,  0.069166f,  0.069357f,  0.069548f,  0.069739f,  0.069931f,  0.070122f,  0.070313f,
	 0.070505f,  0.070696f,  0.070887f,  0.071078f,  0.071270f,  0.071461f,  0.071652f,  0.071843f,
	 0.072035f,  0.072226f,  0.072417f,  0.072608f,  0.072800f,  0.072991f,  0.073182f,  0.073373f,
	 0.073565f,  0.073756f,  0.073947f,  0.074138f,  0.074329f,  0.074521f,  0.074712f,  0.074903f,
	 0.075094f,  0.075286f,  0.075477f,  0.075668f,  0.075859f,  0.076050f,  0.076241f,  0.076433f,
	 0.076624f,  0.076815f,  0.077006f,  0.077197f,  0.077389f,  0.077580f,  0.077771f,  0.077962f,
	 0.078153f,  0.078344f,  0.078536f,  0.078727f,  0.078918f,  0.079109f,  0.079300f,  0.079491f,
	 0.079682f,  0.079874f,  0.080065f,  0.080256f,  0.080447f,  0.080638f,  0.080829f,  0.081020f,
	 0.081211f,  0.081403f,  0.081594f,  0.081785f,  0.081976f,  0.082167f,  0.082358f,  0.082549f,
	 0.082740f,  0.082931f,  0.083122f,  0.083314f,  0.083505f,  0.083696f,  0.083887f,  0.084078f,
	 0.084269f,  0.084460f,  0.084651f,  0.084842f,  0.085033f,  0.085224f,  0.085415f,  0.085606f,
	 0.085797f,  0.085988f,  0.086179f,  0.086370f,  0.086561f,  0.086752f,  0.086943f,  0.087135f,
	 0.087326f,  0.087517f,  0.087708f,  0.087899f,  0.088090f,  0.088281f,  0.088472f,  0.088663f,
	 0.088854f,  0.089045f,  0.089236f,  0.089427f,  0.089617f,  0.089808f,  0.089999f,  0.090190f,
	 0.090381f,  0.090572f,  0.090763f,  0.090954f,  0.091145f,  0.091336f,  0.091527f,  0.091718f,
	 0.091909f,  0.092100f,  0.092291f,  0.092482f,  0.092673f,  0.092864f,  0.093055f,  0.093245f,
	 0.093436f,  0.093627f,  0.093818f,  0.094009f,  0.094200f,  0.094391f,  0.094582f,  0.094773f,
	 0.094963f,  0.095154f,  0.095345f,  0.095536f,  0.095727f,  0.095918f,  0.096109f,  0.096300f,
	 0.096490f,  0.096681f,  0.096872f,  0.097063f,  0.097254f,  0.097445f,  0.097635f,  0.097826f,
	 0.098017f,  0.098208f,  0.098399f,  0.098590f,  0.098780f,  0.098971f,  0.099162f,  0.099353f,
	 0.099544f,  0.099734f,  0.099925f,  0.100116f,  0.100307f,  0.100498f,  0.100688f,  0.100879f,
	 0.101070f,  0.101261f,  0.101451f,  0.101642f,  0.101833f,  0.102024f,  0.102214f,  0.102405f,
	 0.102596f,  0.102787f,  0.102977f,  0.103168f,  0.103359f,  0.103550f,  0.103740f,  0.103931f,
	 0.104122f,  0.104312f,  0.104503f,  0.104694f,  0.104884f,  0.105075f,  0.105266f,  0.105456f,
	 0.105647f,  0.105838f,  0.106028f,  0.106219f,  0.106410f,  0.106600f,  0.106791f,  0.106982f,
	 0.107172f,  0.107363f,  0.107554f,  0.107744f,  0.107935f,  0.108126f,  0.108316f,  0.108507f,
	 0.108697f,  0.108888f,  0.109079f,  0.109269f,  0.109460f,  0.109650f,  0.109841f,  0.110032f,
	 0.110222f,  0.110413f,  0.110603f,  0.110794f,  0.110984f,  0.111175f,  0.111366f,  0.111556f,
	 0.111747f,  0.111937f,  0.112128f,  0.112318f,  0.112509f,  0.112699f,  0.112890f,  0.113080f,
	 0.113271f,  0.113461f,  0.113652f,  0.113842f,  0.114033f,  0.114223f,  0.114414f,  0.114604f,
	 0.114795f,  0.114985f,  0.115176f,  0.115366f,  0.115557f,  0.115747f,  0.115938f,  0.116128f,
	 0.116319f,  0.116509f,  0.116700f,  0.116890f,  0.117080f,  0.117271f,  0.117461f,  0.117652f,
	 0.117842f,  0.118032f,  0.118223f,  0.118413f,  0.118604f,  0.118794f,  0.118984f,  0.119175f,
	 0.119365f,  0.119556f,  0.119746f,  0.119936f,  0.120127f,  0.120317f,  0.120507f,  0.120698f,
	 0.120888f,  0.121078f,  0.121269f,  0.121459f,  0.121649f,  0.121840f,  0.122030f,  0.122220f,
	 0.122411f,  0.122601f,  0.122791f,  0.122982f,  0.123172f,  0.123362f,  0.123552f,  0.123743f,
	 0.123933f,  0.124123f,  0.124314f,  0.124504f,  0.124694f,  0.124884f,  0.125075f,  0.125265f,
	 0.125455f,  0.125645f,  0.125835f,  0.126026f,  0.126216f,  0.126406f,  0.126596f,  0.126787f,
	 0.126977f,  0.127167f,  0.127357f,  0.127547f,  0.127737f,  0.127928f,  0.128118f,  0.128308f,
	 0.128498f,  0.128688f,  0.128878f,  0.129069f,  0.129259f,  0.129449f,  0.129639f,  0.129829f,
	 0.130019f,  0.130209f,  0.130399f,  0.130590f,  0.130780f,  0.130970f,  0.131160f,  0.131350f,
	 0.131540f,  0.131730f,  0.131920f,  0.132110f,  0.132300f,  0.132490f,  0.132680f,  0.132870f,
	 0.133061f,  0.133251f,  0.133441f,  0.133631f,  0.133821f,  0.134011f,  0.134201f,  0.134391f,
	 0.134581f,  0.134771f,  0.134961f,  0.135151f,  0.135341f,  0.135531f,  0.135721f,  0.135911f,
	 0.136101f,  0.136291f,  0.136480f,  0.136670f,  0.136860f,  0.137050f,  0.137240f,  0.137430f,
	 0.137620f,  0.137810f,  0.138000f,  0.138190f,  0.138380f,  0.138570f,  0.138760f,  0.138949f,
	 0.139139f,  0.139329f,  0.139519f,  0.139709f,  0.139899f,  0.140089f,  0.140279f,  0.140468f,
	 0.140658f,  0.140848f,  0.141038f,  0.141228f,  0.141418f,  0.141607f,  0.141797f,  0.141987f,
	 0.142177f,  0.142367f,  0.142556f,  0.142746f,  0.142936f,  0.143126f,  0.143316f,  0.143505f,
	 0.143695f,  0.143885f,  0.144075f,  0.144264f,  0.144454f,  0.144644f,  0.144833f,  0.145023f,
	 0.145213f,  0.145403f,  0.145592f,  0.145782f,  0.145972f,  0.146161f,  0.146351f,  0.146541f,
	 0.146730f,  0.146920f,  0.147110f,  0.147299f,  0.147489f,  0.147679f,  0.147868f,  0.148058f,
	 0.148248f,  0.148437f,  0.148627f,  0.148817f,  0.149006f,  0.149196f,  0.149385f,  0.149575f,
	 0.149765f,  0.149954f,  0.150144f,  0.150333f,  0.150523f,  0.150712f,  0.150902f,  0.151092f,
	 0.151281f,  0.151471f,  0.151660f,  0.151850f,  0.152039f,  0.152229f,  0.152418f,  0.152608f,
	 0.152797f,  0.152987f,  0.153176f,  0.153366f,  0.153555f,  0.153745f,  0.153934f,  0.154124f,
	 0.154313f,  0.154502f,  0.154692f,  0.154881f,  0.155071f,  0.155260f,  0.155450f,  0.155639f,
	 0.155828f,  0.156018f,  0.156207f,  0.156397f,  0.156586f,  0.156775f,  0.156965f,  0.157154f,
	 0.157343f,  0.157533f,  0.157722f,  0.157912f,  0.158101f,  0.158290f,  0.158480f,  0.158669f,
	 0.158858f,  0.159047f,  0.159237f,  0.159426f,  0.159615f,  0.159805f,  0.159994f,  0.160183f,
	 0.160372f,  0.160562f,  0.160751f,  0.160940f,  0.161129f,  0.161319f,  0.161508f,  0.161697f,
	 0.161886f,  0.162076f,  0.162265f,  0.162454f,  0.162643f,  0.162832f,  0.163022f,  0.163211f,
	 0.163400f,  0.163589f,  0.163778f,  0.163967f,  0.164157f,  0.164346f,  0.164535f,  0.164724f,
	 0.164913f,  0.165102f,  0.165291f,  0.165480f,  0.165670f,  0.165859f,  0.166048f,  0.166237f,
	 0.166426f,  0.166615f,  0.166804f,  0.166993f,  0.167182f,  0.167371f,  0.167560f,  0.167749f,
	 0.167938f,  0.168127f,  0.168316f,  0.168505f,  0.168694f,  0.168883f,  0.169072f,  0.169261f,
	 0.169450f,  0.169639f,  0.169828f,  0.170017f,  0.170206f,  0.170395f,  0.170584f,  0.170773f,
	 0.170962f,  0.171151f,  0.171340f,  0.171529f,  0.171718f,  0.171906f,  0.172095f,  0.172284f,
	 0.172473f,  0.172662f,  0.172851f,  0.173040f,  0.173229f,  0.173417f,  0.173606f,  0.173795f,
	 0.173984f,  0.174173f,  0.174362f,  0.174550f,  0.174739f,  0.174928f,  0.175117f,  0.175305f,
	 0.175494f,  0.175683f,  0.175872f,  0.176061f,  0.176249f,  0.176438f,  0.176627f,  0.176815f,
	 0.177004f,  0.177193f,  0.177382f,  0.177570f,  0.177759f,  0.177948f,  0.178136f,  0.178325f,
	 0.178514f,  0.178702f,  0.178891f,  0.179080f,  0.179268f,  0.179457f,  0.179646f,  0.179834f,
	 0.180023f,  0.180212f,  0.180400f,  0.180589f,  0.180777f,  0.180966f,  0.181154f,  0.181343f,
	 0.181532f,  0.181720f,  0.181909f,  0.182097f,  0.182286f,  0.182474f,  0.182663f,  0.182851f,
	 0.183040f,  0.183228f,  0.183417f,  0.183605f,  0.183794f,  0.183982f,  0.184171f,  0.184359f,
	 0.184548f,  0.184736f,  0.184925f,  0.185113f,  0.185301f,  0.185490f,  0.185678f,  0.185867f,
	 0.186055f,  0.186244f,  0.186432f,  0.186620f,  0.186809f,  0.186997f,  0.187185f,  0.187374f,
	 0.187562f,  0.187750f,  0.187939f,  0.188127f,  0.188315f,  0.188504f,  0.188692f,  0.188880f,
	 0.189069f,  0.189257f,  0.189445f,  0.189634f,  0.189822f,  0.190010f,  0.190198f,  0.190387f,
	 0.190575f,  0.190763f,  0.190951f,  0.191139f,  0.191328f,  0.191516f,  0.191704f,  0.191892f,
	 0.192080f,  0.192269f,  0.192457f,  0.192645f,  0.192833f,  0.193021f,  0.193209f,  0.193397f,
	 0.193586f,  0.193774f,  0.193962f,  0.194150f,  0.194338f,  0.194526f,  0.194714f,  0.194902f,
	 0.195090f,  0.195278f,  0.195466f,  0.195654f,  0.195843f,  0.196031f,  0.196219f,  0.196407f,
	 0.196595f,  0.196783f,  0.196971f,  0.197159f,  0.197347f,  0.197535f,  0.197722f,  0.197910f,
	 0.198098f,  0.198286f,  0.198474f,  0.198662f,  0.198850f,  0.199038f,  0.199226f,  0.199414f,
	 0.199602f,  0.199790f,  0.199978f,  0.200165f,  0.200353f,  0.200541f,  0.200729f,  0.200917f,
	 0.201105f,  0.201292f,  0.201480f,  0.201668f,  0.201856f,  0.202044f,  0.202231f,  0.202419f,
	 0.202607f,  0.202795f,  0.202983f,  0.203170f,  0.203358f,  0.203546f,  0.203734f,  0.203921f,
	 0.204109f,  0.204297f,  0.204484f,  0.204672f,  0.204860f,  0.205047f,  0.205235f,  0.205423f,
	 0.205610f,  0.205798f,  0.205986f,  0.206173f,  0.206361f,  0.206549f,  0.206736f,  0.206924f,
	 0.207111f,  0.207299f,  0.207487f,  0.207674f,  0.207862f,  0.208049f,  0.208237f,  0.208424f,
	 0.208612f,  0.208799f,  0.208987f,  0.209174f,  0.209362f,  0.209549f,  0.209737f,  0.209924f,
	 0.210112f,  0.210299f,  0.210487f,  0.210674f,  0.210862f,  0.211049f,  0.211237f,  0.211424f,
	 0.211611f,  0.211799f,  0.211986f,  0.212174f,  0.212361f,  0.212548f,  0.212736f,  0.212923f,
	 0.213110f,  0.213298f,  0.213485f,  0.213672f,  0.213860f,  0.214047f,  0.214234f,  0.214422f,
	 0.214609f,  0.214796f,  0.214983f,  0.215171f,  0.215358f,  0.215545f,  0.215732f,  0.215920f,
	 0.216107f,  0.216294f,  0.216481f,  0.216668f,  0.216856f,  0.217043f,  0.217230f,  0.217417f,
	 0.217604f,  0.217791f,  0.217979f,  0.218166f,  0.218353f,  0.218540f,  0.218727f,  0.218914f,
	 0.219101f,  0.219288f,  0.219475f,  0.219662f,  0.219850f,  0.220037f,  0.220224f,  0.220411f,
	 0.220598f,  0.220785f,  0.220972f,  0.221159f,  0.221346f,  0.221533f,  0.221720f,  0.221907f,
	 0.222094f,  0.222281f,  0.222468f,  0.222654f,  0.222841f,  0.223028f,  0.223215f,  0.223402f,
	 0.223589f,  0.223776f,  0.223963f,  0.224150f,  0.224337f,  0.224523f,  0.224710f,  0.224897f,
	 0.225084f,  0.225271f,  0.225458f,  0.225644f,  0.225831f,  0.226018f,  0.226205f,  0.226391f,
	 0.226578f,  0.226765f,  0.226952f,  0.227139f,  0.227325f,  0.227512f,  0.227699f,  0.227885f,
	 0.228072f,  0.228259f,  0.228445f,  0.228632f,  0.228819f,  0.229005f,  0.229192f,  0.229379f,
	 0.229565f,  0.229752f,  0.229939f,  0.230125f,  0.230312f,  0.230498f,  0.230685f,  0.230872f,
	 0.231058f,  0.231245f,  0.231431f,  0.231618f,  0.231804f,  0.231991f,  0.232177f,  0.232364f,
	 0.232550f,  0.232737f,  0.232923f,  0.233110f,  0.233296f,  0.233483f,  0.233669f,  0.233856f,
	 0.234042f,  0.234228f,  0.234415f,  0.234601f,  0.234788f,  0.234974f,  0.235160f,  0.235347f,
	 0.235533f,  0.235719f,  0.235906f,  0.236092f,  0.236278f,  0.236465f,  0.236651f,  0.236837f,
	 0.237024f,  0.237210f,  0.237396f,  0.237582f,  0.237769f,  0.237955f,  0.238141f,  0.238327f,
	 0.238514f,  0.238700f,  0.238886f,  0.239072f,  0.239258f,  0.239445f,  0.239631f,  0.239817f,
	 0.240003f,  0.240189f,  0.240375f,  0.240561f,  0.240748f,  0.240934f,  0.241120f,  0.241306f,
	 0.241492f,  0.241678f,  0.241864f,  0.242050f,  0.242236f,  0.242422f,  0.242608f,  0.242794f,
	 0.242980f,  0.243166f,  0.243352f,  0.243538f,  0.243724f,  0.243910f,  0.244096f,  0.244282f,
	 0.244468f,  0.244654f,  0.244840f,  0.245026f,  0.245212f,  0.245397f,  0.245583f,  0.245769f,
	 0.245955f,  0.246141f,  0.246327f,  0.246513f,  0.246698f,  0.246884f,  0.247070f,  0.247256f,
	 0.247442f,  0.247627f,  0.247813f,  0.247999f,  0.248185f,  0.248370f,  0.248556f,  0.248742f,
	 0.248928f,  0.249113f,  0.249299f,  0.249485f,  0.249670f,  0.249856f,  0.250042f,  0.250227f,
	 0.250413f,  0.250599f,  0.250784f,  0.250970f,  0.251155f,  0.251341f,  0.251527f,  0.251712f,
	 0.251898f,  0.252083f,  0.252269f,  0.252454f,  0.252640f,  0.252826f,  0.253011f,  0.253197f,
	 0.253382f,  0.253568f,  0.253753f,  0.253938f,  0.254124f,  0.254309f,  0.254495f,  0.254680f,
	 0.254866f,  0.255051f,  0.255236f,  0.255422f,  0.255607f,  0.255793f,  0.255978f,  0.256163f,
	 0.256349f,  0.256534f,  0.256719f,  0.256905f,  0.257090f,  0.257275f,  0.257461f,  0.257646f,
	 0.257831f,  0.258016f,  0.258202f,  0.258387f,  0.258572f,  0.258757f,  0.258943f,  0.259128f,
	 0.259313f,  0.259498f,  0.259683f,  0.259868f,  0.260054f,  0.260239f,  0.260424f,  0.260609f,
	 0.260794f,  0.260979f,  0.261164f,  0.261349f,  0.261534f,  0.261720f,  0.261905f,  0.262090f,
	 0.262275f,  0.262460f,  0.262645f,  0.262830f,  0.263015f,  0.263200f,  0.263385f,  0.263570f,
	 0.263755f,  0.263940f,  0.264125f,  0.264309f,  0.264494f,  0.264679f,  0.264864f,  0.265049f,
	 0.265234f,  0.265419f,  0.265604f,  0.265789f,  0.265973f,  0.266158f,  0.266343f,  0.266528f,
	 0.266713f,  0.266898f,  0.267082f,  0.267267f,  0.267452f,  0.267637f,  0.267821f,  0.268006f,
	 0.268191f,  0.268376f,  0.268560f,  0.268745f,  0.268930f,  0.269114f,  0.269299f,  0.269484f,
	 0.269668f,  0.269853f,  0.270038f,  0.270222f,  0.270407f,  0.270591f,  0.270776f,  0.270961f,
	 0.271145f,  0.271330f,  0.271514f,  0.271699f,  0.271883f,  0.272068f,  0.272252f,  0.272437f,
	 0.272621f,  0.272806f,  0.272990f,  0.273175f,  0.273359f,  0.273544f,  0.273728f,  0.273912f,
	 0.274097f,  0.274281f,  0.274466f,  0.274650f,  0.274834f,  0.275019f,  0.275203f,  0.275387f,
	 0.275572f,  0.275756f,  0.275940f,  0.276125f,  0.276309f,  0.276493f,  0.276678f,  0.276862f,
	 0.277046f,  0.277230f,  0.277415f,  0.277599f,  0.277783f,  0.277967f,  0.278151f,  0.278336f,
	 0.278520f,  0.278704f,  0.278888f,  0.279072f,  0.279256f,  0.279440f,  0.279624f,  0.279809f,
	 0.279993f,  0.280177f,  0.280361f,  0.280545f,  0.280729f,  0.280913f,  0.281097f,  0.281281f,
	 0.281465f,  0.281649f,  0.281833f,  0.282017f,  0.282201f,  0.282385f,  0.282569f,  0.282753f,
	 0.282937f,  0.283120f,  0.283304f,  0.283488f,  0.283672f,  0.283856f,  0.284040f,  0.284224f,
	 0.284408f,  0.284591f,  0.284775f,  0.284959f,  0.285143f,  0.285327f,  0.285510f,  0.285694f,
	 0.285878f,  0.286062f,  0.286245f,  0.286429f,  0.286613f,  0.286796f,  0.286980f,  0.287164f,
	 0.287347f,  0.287531f,  0.287715f,  0.287898f,  0.288082f,  0.288266f,  0.288449f,  0.288633f,
	 0.288816f,  0.289000f,  0.289184f,  0.289367f,  0.289551f,  0.289734f,  0.289918f,  0.290101f,
	 0.290285f,  0.290468f,  0.290652f,  0.290835f,  0.291019f,  0.291202f,  0.291385f,  0.291569f,
	 0.291752f,  0.291936f,  0.292119f,  0.292302f,  0.292486f,  0.292669f,  0.292852f,  0.293036f,
	 0.293219f,  0.293402f,  0.293586f,  0.293769f,  0.293952f,  0.294136f,  0.294319f,  0.294502f,
	 0.294685f,  0.294869f,  0.295052f,  0.295235f,  0.295418f,  0.295601f,  0.295785f,  0.295968f,
	 0.296151f,  0.296334f,  0.296517f,  0.296700f,  0.296883f,  0.297066f,  0.297250f,  0.297433f,
	 0.297616f,  0.297799f,  0.297982f,  0.298165f,  0.298348f,  0.298531f,  0.298714f,  0.298897f,
	 0.299080f,  0.299263f,  0.299446f,  0.299629f,  0.299812f,  0.299995f,  0.300177f,  0.300360f,
	 0.300543f,  0.300726f,  0.300909f,  0.301092f,  0.301275f,  0.301458f,  0.301640f,  0.301823f,
	 0.302006f,  0.302189f,  0.302372f,  0.302554f,  0.302737f,  0.302920f,  0.303103f,  0.303285f,
	 0.303468f,  0.303651f,  0.303833f,  0.304016f,  0.304199f,  0.304381f,  0.304564f,  0.304747f,
	 0.304929f,  0.305112f,  0.305294f,  0.305477f,  0.305660f,  0.305842f,  0.306025f,  0.306207f,
	 0.306390f,  0.306572f,  0.306755f,  0.306937f,  0.307120f,  0.307302f,  0.307485f,  0.307667f,
	 0.307850f,  0.308032f,  0.308214f,  0.308397f,  0.308579f,  0.308762f,  0.308944f,  0.309126f,
	 0.309309f,  0.309491f,  0.309673f,  0.309856f,  0.310038f,  0.310220f,  0.310403f,  0.310585f,
	 0.310767f,  0.310949f,  0.311132f,  0.311314f,  0.311496f,  0.311678f,  0.311860f,  0.312043f,
	 0.312225f,  0.312407f,  0.312589f,  0.312771f,  0.312953f,  0.313135f,  0.313318f,  0.313500f,
	 0.313682f,  0.313864f,  0.314046f,  0.314228f,  0.314410f,  0.314592f,  0.314774f,  0.314956f,
	 0.315138f,  0.315320f,  0.315502f,  0.315684f,  0.315866f,  0.316048f,  0.316230f,  0.316411f,
	 0.316593f,  0.316775f,  0.316957f,  0.317139f,  0.317321f,  0.317503f,  0.317684f,  0.317866f,
	 0.318048f,  0.318230f,  0.318412f,  0.318593f,  0.318775f,  0.318957f,  0.319139f,  0.319320f,
	 0.319502f,  0.319684f,  0.319865f,  0.320047f,  0.320229f,  0.320410f,  0.320592f,  0.320774f,
	 0.320955f,  0.321137f,  0.321318f,  0.321500f,  0.321682f,  0.321863f,  0.322045f,  0.322226f,
	 0.322408f,  0.322589f,  0.322771f,  0.322952f,  0.323134f,  0.323315f,  0.323497f,  0.323678f,
	 0.323859f,  0.324041f,  0.324222f,  0.324404f,  0.324585f,  0.324766f,  0.324948f,  0.325129f,
	 0.325310f,  0.325492f,  0.325673f,  0.325854f,  0.326035f,  0.326217f,  0.326398f,  0.326579f,
	 0.326760f,  0.326942f,  0.327123f,  0.327304f,  0.327485f,  0.327666f,  0.327848f,  0.328029f,
	 0.328210f,  0.328391f,  0.328572f,  0.328753f,  0.328934f,  0.329115f,  0.329296f,  0.329477f,
	 0.329658f,  0.329839f,  0.330020f,  0.330202f,  0.330382f,  0.330563f,  0.330744f,  0.330925f,
	 0.331106f,  0.331287f,  0.331468f,  0.331649f,  0.331830f,  0.332011f,  0.332192f,  0.332373f,
	 0.332553f,  0.332734f,  0.332915f,  0.333096f,  0.333277f,  0.333457f,  0.333638f,  0.333819f,
	 0.334000f,  0.334180f,  0.334361f,  0.334542f,  0.334722f,  0.334903f,  0.335084f,  0.335265f,
	 0.335445f,  0.335626f,  0.335806f,  0.335987f,  0.336168f,  0.336348f,  0.336529f,  0.336709f,
	 0.336890f,  0.337070f,  0.337251f,  0.337431f,  0.337612f,  0.337792f,  0.337973f,  0.338153f,
	 0.338334f,  0.338514f,  0.338695f,  0.338875f,  0.339055f,  0.339236f,  0.339416f,  0.339597f,
	 0.339777f,  0.339957f,  0.340138f,  0.340318f,  0.340498f,  0.340678f,  0.340859f,  0.341039f,
	 0.341219f,  0.341399f,  0.341580f,  0.341760f,  0.341940f,  0.342120f,  0.342300f,  0.342481f,
	 0.342661f,  0.342841f,  0.343021f,  0.343201f,  0.343381f,  0.343561f,  0.343741f,  0.343921f,
	 0.344101f,  0.344281f,  0.344461f,  0.344641f,  0.344821f,  0.345001f,  0.345181f,  0.345361f,
	 0.345541f,  0.345721f,  0.345901f,  0.346081f,  0.346261f,  0.346441f,  0.346621f,  0.346801f,
	 0.346980f,  0.347160f,  0.347340f,  0.347520f,  0.347700f,  0.347879f,  0.348059f,  0.348239f,
	 0.348419f,  0.348598f,  0.348778f,  0.348958f,  0.349138f,  0.349317f,  0.349497f,  0.349676f,
	 0.349856f,  0.350036f,  0.350215f,  0.350395f,  0.350575f,  0.350754f,  0.350934f,  0.351113f,
	 0.351293f,  0.351472f,  0.351652f,  0.351831f,  0.352011f,  0.352190f,  0.352370f,  0.352549f,
	 0.352729f,  0.352908f,  0.353087f,  0.353267f,  0.353446f,  0.353626f,  0.353805f,  0.353984f,
	 0.354164f,  0.354343f,  0.354522f,  0.354701f,  0.354881f,  0.355060f,  0.355239f,  0.355418f,
	 0.355598f,  0.355777f,  0.355956f,  0.356135f,  0.356314f,  0.356494f,  0.356673f,  0.356852f,
	 0.357031f,  0.357210f,  0.357389f,  0.357568f,  0.357747f,  0.357926f,  0.358105f,  0.358284f,
	 0.358463f,  0.358642f,  0.358821f,  0.359000f,  0.359179f,  0.359358f,  0.359537f,  0.359716f,
	 0.359895f,  0.360074f,  0.360253f,  0.360432f,  0.360611f,  0.360789f,  0.360968f,  0.361147f,
	 0.361326f,  0.361505f,  0.361683f,  0.361862f,  0.362041f,  0.362220f,  0.362398f,  0.362577f,
	 0.362756f,  0.362934f,  0.363113f,  0.363292f,  0.363470f,  0.363649f,  0.363828f,  0.364006f,
	 0.364185f,  0.364363f,  0.364542f,  0.364720f,  0.364899f,  0.365078f,  0.365256f,  0.365435f,
	 0.365613f,  0.365791f,  0.365970f,  0.366148f,  0.366327f,  0.366505f,  0.366684f,  0.366862f,
	 0.367040f,  0.367219f,  0.367397f,  0.367575f,  0.367754f,  0.367932f,  0.368110f,  0.368289f,
	 0.368467f,  0.368645f,  0.368823f,  0.369002f,  0.369180f,  0.369358f,  0.369536f,  0.369714f,
	 0.369892f,  0.370071f,  0.370249f,  0.370427f,  0.370605f,  0.370783f,  0.370961f,  0.371139f,
	 0.371317f,  0.371495f,  0.371673f,  0.371851f,  0.372029f,  0.372207f,  0.372385f,  0.372563f,
	 0.372741f,  0.372919f,  0.373097f,  0.373275f,  0.373453f,  0.373631f,  0.373808f,  0.373986f,
	 0.374164f,  0.374342f,  0.374520f,  0.374697f,  0.374875f,  0.375053f,  0.375231f,  0.375408f,
	 0.375586f,  0.375764f,  0.375942f,  0.376119f,  0.376297f,  0.376475f,  0.376652f,  0.376830f,
	 0.377007f,  0.377185f,  0.377363f,  0.377540f,  0.377718f,  0.377895f,  0.378073f,  0.378250f,
	 0.378428f,  0.378605f,  0.378783f,  0.378960f,  0.379138f,  0.379315f,  0.379492f,  0.379670f,
	 0.379847f,  0.380025f,  0.380202f,  0.380379f,  0.380557f,  0.380734f,  0.380911f,  0.381088f,
	 0.381266f,  0.381443f,  0.381620f,  0.381797f,  0.381975f,  0.382152f,  0.382329f,  0.382506f,
	 0.382683f,  0.382861f,  0.383038f,  0.383215f,  0.383392f,  0.383569f,  0.383746f,  0.383923f,
	 0.384100f,  0.384277f,  0.384454f,  0.384631f,  0.384808f,  0.384985f,  0.385162f,  0.385339f,
	 0.385516f,  0.385693f,  0.385870f,  0.386047f,  0.386224f,  0.386400f,  0.386577f,  0.386754f,
	 0.386931f,  0.387108f,  0.387285f,  0.387461f,  0.387638f,  0.387815f,  0.387992f,  0.388168f,
	 0.388345f,  0.388522f,  0.388698f,  0.388875f,  0.389052f,  0.389228f,  0.389405f,  0.389582f,
	 0.389758f,  0.389935f,  0.390111f,  0.390288f,  0.390464f,  0.390641f,  0.390817f,  0.390994f,
	 0.391170f,  0.391347f,  0.391523f,  0.391700f,  0.391876f,  0.392053f,  0.392229f,  0.392405f,
	 0.392582f,  0.392758f,  0.392934f,  0.393111f,  0.393287f,  0.393463f,  0.393640f,  0.393816f,
	 0.393992f,  0.394168f,  0.394344f,  0.394521f,  0.394697f,  0.394873f,  0.395049f,  0.395225f,
	 0.395401f,  0.395578f,  0.395754f,  0.395930f,  0.396106f,  0.396282f,  0.396458f,  0.396634f,
	 0.396810f,  0.396986f,  0.397162f,  0.397338f,  0.397514f,  0.397690f,  0.397866f,  0.398042f,
	 0.398218f,  0.398393f,  0.398569f,  0.398745f,  0.398921f,  0.399097f,  0.399273f,  0.399448f,
	 0.399624f,  0.399800f,  0.399976f,  0.400151f,  0.400327f,  0.400503f,  0.400679f,  0.400854f,
	 0.401030f,  0.401206f,  0.401381f,  0.401557f,  0.401732f,  0.401908f,  0.402084f,  0.402259f,
	 0.402435f,  0.402610f,  0.402786f,  0.402961f,  0.403137f,  0.403312f,  0.403488f,  0.403663f,
	 0.403838f,  0.404014f,  0.404189f,  0.404365f,  0.404540f,  0.404715f,  0.404891f,  0.405066f,
	 0.405241f,  0.405417f,  0.405592f,  0.405767f,  0.405942f,  0.406118f,  0.406293f,  0.406468f,
	 0.406643f,  0.406818f,  0.406994f,  0.407169f,  0.407344f,  0.407519f,  0.407694f,  0.407869f,
	 0.408044f,  0.408219f,  0.408394f,  0.408569f,  0.408744f,  0.408919f,  0.409094f,  0.409269f,
	 0.409444f,  0.409619f,  0.409794f,  0.409969f,  0.410144f,  0.410319f,  0.410493f,  0.410668f,
	 0.410843f,  0.411018f,  0.411193f,  0.411368f,  0.411542f,  0.411717f,  0.411892f,  0.412067f,
	 0.412241f,  0.412416f,  0.412591f,  0.412765f,  0.412940f,  0.413115f,  0.413289f,  0.413464f,
	 0.413638f,  0.413813f,  0.413987f,  0.414162f,  0.414337f,  0.414511f,  0.414685f,  0.414860f,
	 0.415034f,  0.415209f,  0.415383f,  0.415558f,  0.415732f,  0.415906f,  0.416081f,  0.416255f,
	 0.416430f,  0.416604f,  0.416778f,  0.416952f,  0.417127f,  0.417301f,  0.417475f,  0.417650f,
	 0.417824f,  0.417998f,  0.418172f,  0.418346f,  0.418520f,  0.418695f,  0.418869f,  0.419043f,
	 0.419217f,  0.419391f,  0.419565f,  0.419739f,  0.419913f,  0.420087f,  0.420261f,  0.420435f,
	 0.420609f,  0.420783f,  0.420957f,  0.421131f,  0.421305f,  0.421479f,  0.421653f,  0.421826f,
	 0.422000f,  0.422174f,  0.422348f,  0.422522f,  0.422695f,  0.422869f,  0.423043f,  0.423217f,
	 0.423390f,  0.423564f,  0.423738f,  0.423912f,  0.424085f,  0.424259f,  0.424432f,  0.424606f,
	 0.424780f,  0.424953f,  0.425127f,  0.425300f,  0.425474f,  0.425647f,  0.425821f,  0.425994f,
	 0.426168f,  0.426341f,  0.426515f,  0.426688f,  0.426862f,  0.427035f,  0.427208f,  0.427382f,
	 0.427555f,  0.427728f,  0.427902f,  0.428075f,  0.428248f,  0.428422f,  0.428595f,  0.428768f,
	 0.428941f,  0.429114f,  0.429288f,  0.429461f,  0.429634f,  0.429807f,  0.429980f,  0.430153f,
	 0.430326f,  0.430500f,  0.430673f,  0.430846f,  0.431019f,  0.431192f,  0.431365f,  0.431538f,
	 0.431711f,  0.431884f,  0.432057f,  0.432229f,  0.432402f,  0.432575f,  0.432748f,  0.432921f,
	 0.433094f,  0.433267f,  0.433439f,  0.433612f,  0.433785f,  0.433958f,  0.434131f,  0.434303f,
	 0.434476f,  0.434649f,  0.434821f,  0.434994f,  0.435167f,  0.435339f,  0.435512f,  0.435685f,
	 0.435857f,  0.436030f,  0.436202f,  0.436375f,  0.436547f,  0.436720f,  0.436892f,  0.437065f,
	 0.437237f,  0.437410f,  0.437582f,  0.437754f,  0.437927f,  0.438099f,  0.438272f,  0.438444f,
	 0.438616f,  0.438789f,  0.438961f,  0.439133f,  0.439305f,  0.439478f,  0.439650f,  0.439822f,
	 0.439994f,  0.440166f,  0.440339f,  0.440511f,  0.440683f,  0.440855f,  0.441027f,  0.441199f,
	 0.441371f,  0.441543f,  0.441715f,  0.441887f,  0.442059f,  0.442231f,  0.442403f,  0.442575f,
	 0.442747f,  0.442919f,  0.443091f,  0.443263f,  0.443435f,  0.443607f,  0.443779f,  0.443950f,
	 0.444122f,  0.444294f,  0.444466f,  0.444637f,  0.444809f,  0.444981f,  0.445153f,  0.445324f,
	 0.445496f,  0.445668f,  0.445839f,  0.446011f,  0.446183f,  0.446354f,  0.446526f,  0.446697f,
	 0.446869f,  0.447040f,  0.447212f,  0.447383f,  0.447555f,  0.447726f,  0.447898f,  0.448069f,
	 0.448241f,  0.448412f,  0.448583f,  0.448755f,  0.448926f,  0.449097f,  0.449269f,  0.449440f,
	 0.449611f,  0.449783f,  0.449954f,  0.450125f,  0.450296f,  0.450467f,  0.450639f,  0.450810f,
	 0.450981f,  0.451152f,  0.451323f,  0.451494f,  0.451665f,  0.451836f,  0.452008f,  0.452179f,
	 0.452350f,  0.452521f,  0.452692f,  0.452863f,  0.453033f,  0.453204f,  0.453375f,  0.453546f,
	 0.453717f,  0.453888f,  0.454059f,  0.454230f,  0.454400f,  0.454571f,  0.454742f,  0.454913f,
	 0.455084f,  0.455254f,  0.455425f,  0.455596f,  0.455766f,  0.455937f,  0.456108f,  0.456278f,
	 0.456449f,  0.456620f,  0.456790f,  0.456961f,  0.457131f,  0.457302f,  0.457472f,  0.457643f,
	 0.457813f,  0.457984f,  0.458154f,  0.458325f,  0.458495f,  0.458665f,  0.458836f,  0.459006f,
	 0.459177f,  0.459347f,  0.459517f,  0.459687f,  0.459858f,  0.460028f,  0.460198f,  0.460369f,
	 0.460539f,  0.460709f,  0.460879f,  0.461049f,  0.461219f,  0.461390f,  0.461560f,  0.461730f,
	 0.461900f,  0.462070f,  0.462240f,  0.462410f,  0.462580f,  0.462750f,  0.462920f,  0.463090f,
	 0.463260f,  0.463430f,  0.463600f,  0.463769f,  0.463939f,  0.464109f,  0.464279f,  0.464449f,
	 0.464619f,  0.464788f,  0.464958f,  0.465128f,  0.465298f,  0.465467f,  0.465637f,  0.465807f,
	 0.465977f,  0.466146f,  0.466316f,  0.466485f,  0.466655f,  0.466825f,  0.466994f,  0.467164f,
	 0.467333f,  0.467503f,  0.467672f,  0.467842f,  0.468011f,  0.468181f,  0.468350f,  0.468519f,
	 0.468689f,  0.468858f,  0.469028f,  0.469197f,  0.469366f,  0.469536f,  0.469705f,  0.469874f,
	 0.470043f,  0.470213f,  0.470382f,  0.470551f,  0.470720f,  0.470889f,  0.471058f,  0.471228f,
	 0.471397f,  0.471566f,  0.471735f,  0.471904f,  0.472073f,  0.472242f,  0.472411f,  0.472580f,
	 0.472749f,  0.472918f,  0.473087f,  0.473256f,  0.473425f,  0.473594f,  0.473763f,  0.473931f,
	 0.474100f,  0.474269f,  0.474438f,  0.474607f,  0.474775f,  0.474944f,  0.475113f,  0.475282f,
	 0.475450f,  0.475619f,  0.475788f,  0.475956f,  0.476125f,  0.476294f,  0.476462f,  0.476631f,
	 0.476799f,  0.476968f,  0.477136f,  0.477305f,  0.477473f,  0.477642f,  0.477810f,  0.477979f,
	 0.478147f,  0.478315f,  0.478484f,  0.478652f,  0.478821f,  0.478989f,  0.479157f,  0.479325f,
	 0.479494f,  0.479662f,  0.479830f,  0.479998f,  0.480167f,  0.480335f,  0.480503f,  0.480671f,
	 0.480839f,  0.481007f,  0.481176f,  0.481344f,  0.481512f,  0.481680f,  0.481848f,  0.482016f,
	 0.482184f,  0.482352f,  0.482520f,  0.482688f,  0.482856f,  0.483023f,  0.483191f,  0.483359f,
	 0.483527f,  0.483695f,  0.483863f,  0.484031f,  0.484198f,  0.484366f,  0.484534f,  0.484702f,
	 0.484869f,  0.485037f,  0.485205f,  0.485372f,  0.485540f,  0.485708f,  0.485875f,  0.486043f,
	 0.486210f,  0.486378f,  0.486545f,  0.486713f,  0.486880f,  0.487048f,  0.487215f,  0.487383f,
	 0.487550f,  0.487718f,  0.487885f,  0.488052f,  0.488220f,  0.488387f,  0.488554f,  0.488722f,
	 0.488889f,  0.489056f,  0.489223f,  0.489391f,  0.489558f,  0.489725f,  0.489892f,  0.490059f,
	 0.490226f,  0.490394f,  0.490561f,  0.490728f,  0.490895f,  0.491062f,  0.491229f,  0.491396f,
	 0.491563f,  0.491730f,  0.491897f,  0.492064f,  0.492231f,  0.492398f,  0.492564f,  0.492731f,
	 0.492898f,  0.493065f,  0.493232f,  0.493399f,  0.493565f,  0.493732f,  0.493899f,  0.494066f,
	 0.494232f,  0.494399f,  0.494566f,  0.494732f,  0.494899f,  0.495066f,  0.495232f,  0.495399f,
	 0.495565f,  0.495732f,  0.495898f,  0.496065f,  0.496231f,  0.496398f,  0.496564f,  0.496731f,
	 0.496897f,  0.497063f,  0.497230f,  0.497396f,  0.497562f,  0.497729f,  0.497895f,  0.498061f,
	 0.498228f,  0.498394f,  0.498560f,  0.498726f,  0.498893f,  0.499059f,  0.499225f,  0.499391f,
	 0.499557f,  0.499723f,  0.499889f,  0.500055f,  0.500221f,  0.500387f,  0.500553f,  0.500719f,
	 0.500885f,  0.501051f,  0.501217f,  0.501383f,  0.501549f,  0.501715f,  0.501881f,  0.502047f,
	 0.502212f,  0.502378f,  0.502544f,  0.502710f,  0.502876f,  0.503041f,  0.503207f,  0.503373f,
	 0.503538f,  0.503704f,  0.503870f,  0.504035f,  0.504201f,  0.504366f,  0.504532f,  0.504698f,
	 0.504863f,  0.505029f,  0.505194f,  0.505360f,  0.505525f,  0.505690f,  0.505856f,  0.506021f,
	 0.506187f,  0.506352f,  0.506517f,  0.506683f,  0.506848f,  0.507013f,  0.507179f,  0.507344f,
	 0.507509f,  0.507674f,  0.507839f,  0.508005f,  0.508170f,  0.508335f,  0.508500f,  0.508665f,
	 0.508830f,  0.508995f,  0.509160f,  0.509325f,  0.509490f,  0.509655f,  0.509820f,  0.509985f,
	 0.510150f,  0.510315f,  0.510480f,  0.510645f,  0.510810f,  0.510974f,  0.511139f,  0.511304f,
	 0.511469f,  0.511634f,  0.511798f,  0.511963f,  0.512128f,  0.512292f,  0.512457f,  0.512622f,
	 0.512786f,  0.512951f,  0.513116f,  0.513280f,  0.513445f,  0.513609f,  0.513774f,  0.513938f,
	 0.514103f,  0.514267f,  0.514432f,  0.514596f,  0.514760f,  0.514925f,  0.515089f,  0.515254f,
	 0.515418f,  0.515582f,  0.515746f,  0.515911f,  0.516075f,  0.516239f,  0.516403f,  0.516568f,
	 0.516732f,  0.516896f,  0.517060f,  0.517224f,  0.517388f,  0.517552f,  0.517716f,  0.517880f,
	 0.518045f,  0.518209f,  0.518372f,  0.518536f,  0.518700f,  0.518864f,  0.519028f,  0.519192f,
	 0.519356f,  0.519520f,  0.519684f,  0.519848f,  0.520011f,  0.520175f,  0.520339f,  0.520503f,
	 0.520666f,  0.520830f,  0.520994f,  0.521157f,  0.521321f,  0.521485f,  0.521648f,  0.521812f,
	 0.521975f,  0.522139f,  0.522302f,  0.522466f,  0.522629f,  0.522793f,  0.522956f,  0.523120f,
	 0.523283f,  0.523447f,  0.523610f,  0.523773f,  0.523937f,  0.524100f,  0.524263f,  0.524426f,
	 0.524590f,  0.524753f,  0.524916f,  0.525079f,  0.525243f,  0.525406f,  0.525569f,  0.525732f,
	 0.525895f,  0.526058f,  0.526221f,  0.526384f,  0.526547f,  0.526710f,  0.526873f,  0.527036f,
	 0.527199f,  0.527362f,  0.527525f,  0.527688f,  0.527851f,  0.528014f,  0.528176f,  0.528339f,
	 0.528502f,  0.528665f,  0.528828f,  0.528990f,  0.529153f,  0.529316f,  0.529478f,  0.529641f,
	 0.529804f,  0.529966f,  0.530129f,  0.530291f,  0.530454f,  0.530617f,  0.530779f,  0.530942f,
	 0.531104f,  0.531266f,  0.531429f,  0.531591f,  0.531754f,  0.531916f,  0.532078f,  0.532241f,
	 0.532403f,  0.532565f,  0.532728f,  0.532890f,  0.533052f,  0.533214f,  0.533377f,  0.533539f,
	 0.533701f,  0.533863f,  0.534025f,  0.534187f,  0.534349f,  0.534512f,  0.534674f,  0.534836f,
	 0.534998f,  0.535160f,  0.535322f,  0.535484f,  0.535645f,  0.535807f,  0.535969f,  0.536131f,
	 0.536293f,  0.536455f,  0.536617f,  0.536778f,  0.536940f,  0.537102f,  0.537264f,  0.537425f,
	 0.537587f,  0.537749f,  0.537910f,  0.538072f,  0.538234f,  0.538395f,  0.538557f,  0.538718f,
	 0.538880f,  0.539041f,  0.539203f,  0.539364f,  0.539526f,  0.539687f,  0.539849f,  0.540010f,
	 0.540171f,  0.540333f,  0.540494f,  0.540655f,  0.540817f,  0.540978f,  0.541139f,  0.541301f,
	 0.541462f,  0.541623f,  0.541784f,  0.541945f,  0.542106f,  0.542268f,  0.542429f,  0.542590f,
	 0.542751f,  0.542912f,  0.543073f,  0.543234f,  0.543395f,  0.543556f,  0.543717f,  0.543878f,
	 0.544039f,  0.544199f,  0.544360f,  0.544521f,  0.544682f,  0.544843f,  0.545003f,  0.545164f,
	 0.545325f,  0.545486f,  0.545646f,  0.545807f,  0.545968f,  0.546128f,  0.546289f,  0.546450f,
	 0.546610f,  0.546771f,  0.546931f,  0.547092f,  0.547252f,  0.547413f,  0.547573f,  0.547734f,
	 0.547894f,  0.548054f,  0.548215f,  0.548375f,  0.548536f,  0.548696f,  0.548856f,  0.549016f,
	 0.549177f,  0.549337f,  0.549497f,  0.549657f,  0.549818f,  0.549978f,  0.550138f,  0.550298f,
	 0.550458f,  0.550618f,  0.550778f,  0.550938f,  0.551098f,  0.551258f,  0.551418f,  0.551578f,
	 0.551738f,  0.551898f,  0.552058f,  0.552218f,  0.552378f,  0.552537f,  0.552697f,  0.552857f,
	 0.553017f,  0.553176f,  0.553336f,  0.553496f,  0.553656f,  0.553815f,  0.553975f,  0.554134f,
	 0.554294f,  0.554454f,  0.554613f,  0.554773f,  0.554932f,  0.555092f,  0.555251f,  0.555411f,
	 0.555570f,  0.555730f,  0.555889f,  0.556048f,  0.556208f,  0.556367f,  0.556526f,  0.556686f,
	 0.556845f,  0.557004f,  0.557164f,  0.557323f,  0.557482f,  0.557641f,  0.557800f,  0.557959f,
	 0.558119f,  0.558278f,  0.558437f,  0.558596f,  0.558755f,  0.558914f,  0.559073f,  0.559232f,
	 0.559391f,  0.559550f,  0.559709f,  0.559867f,  0.560026f,  0.560185f,  0.560344f,  0.560503f,
	 0.560662f,  0.560820f,  0.560979f,  0.561138f,  0.561297f,  0.561455f,  0.561614f,  0.561773f,
	 0.561931f,  0.562090f,  0.562248f,  0.562407f,  0.562565f,  0.562724f,  0.562882f,  0.563041f,
	 0.563199f,  0.563358f,  0.563516f,  0.563675f,  0.563833f,  0.563991f,  0.564150f,  0.564308f,
	 0.564466f,  0.564624f,  0.564783f,  0.564941f,  0.565099f,  0.565257f,  0.565416f,  0.565574f,
	 0.565732f,  0.565890f,  0.566048f,  0.566206f,  0.566364f,  0.566522f,  0.566680f,  0.566838f,
	 0.566996f,  0.567154f,  0.567312f,  0.567470f,  0.567628f,  0.567786f,  0.567943f,  0.568101f,
	 0.568259f,  0.568417f,  0.568574f,  0.568732f,  0.568890f,  0.569048f,  0.569205f,  0.569363f,
	 0.569521f,  0.569678f,  0.569836f,  0.569993f,  0.570151f,  0.570308f,  0.570466f,  0.570623f,
	 0.570781f,  0.570938f,  0.571096f,  0.571253f,  0.571410f,  0.571568f,  0.571725f,  0.571882f,
	 0.572040f,  0.572197f,  0.572354f,  0.572511f,  0.572669f,  0.572826f,  0.572983f,  0.573140f,
	 0.573297f,  0.573454f,  0.573611f,  0.573768f,  0.573925f,  0.574082f,  0.574239f,  0.574396f,
	 0.574553f,  0.574710f,  0.574867f,  0.575024f,  0.575181f,  0.575338f,  0.575495f,  0.575651f,
	 0.575808f,  0.575965f,  0.576122f,  0.576278f,  0.576435f,  0.576592f,  0.576748f,  0.576905f,
	 0.577062f,  0.577218f,  0.577375f,  0.577531f,  0.577688f,  0.577844f,  0.578001f,  0.578157f,
	 0.578314f,  0.578470f,  0.578627f,  0.578783f,  0.578939f,  0.579096f,  0.579252f,  0.579408f,
	 0.579565f,  0.579721f,  0.579877f,  0.580033f,  0.580189f,  0.580346f,  0.580502f,  0.580658f,
	 0.580814f,  0.580970f,  0.581126f,  0.581282f,  0.581438f,  0.581594f,  0.581750f,  0.581906f,
	 0.582062f,  0.582218f,  0.582374f,  0.582530f,  0.582685f,  0.582841f,  0.582997f,  0.583153f,
	 0.583309f,  0.583464f,  0.583620f,  0.583776f,  0.583931f,  0.584087f,  0.584243f,  0.584398f,
	 0.584554f,  0.584710f,  0.584865f,  0.585021f,  0.585176f,  0.585332f,  0.585487f,  0.585642f,
	 0.585798f,  0.585953f,  0.586109f,  0.586264f,  0.586419f,  0.586575f,  0.586730f,  0.586885f,
	 0.587040f,  0.587196f,  0.587351f,  0.587506f,  0.587661f,  0.587816f,  0.587971f,  0.588126f,
	 0.588282f,  0.588437f,  0.588592f,  0.588747f,  0.588902f,  0.589057f,  0.589212f,  0.589366f,
	 0.589521f,  0.589676f,  0.589831f,  0.589986f,  0.590141f,  0.590295f,  0.590450f,  0.590605f,
	 0.590760f,  0.590914f,  0.591069f,  0.591224f,  0.591378f,  0.591533f,  0.591688f,  0.591842f,
	 0.591997f,  0.592151f,  0.592306f,  0.592460f,  0.592615f,  0.592769f,  0.592924f,  0.593078f,
	 0.593232f,  0.593387f,  0.593541f,  0.593695f,  0.593850f,  0.594004f,  0.594158f,  0.594312f,
	 0.594467f,  0.594621f,  0.594775f,  0.594929f,  0.595083f,  0.595237f,  0.595391f,  0.595545f,
	 0.595699f,  0.595853f,  0.596007f,  0.596161f,  0.596315f,  0.596469f,  0.596623f,  0.596777f,
	 0.596931f,  0.597085f,  0.597238f,  0.597392f,  0.597546f,  0.597700f,  0.597853f,  0.598007f,
	 0.598161f,  0.598314f,  0.598468f,  0.598622f,  0.598775f,  0.598929f,  0.599082f,  0.599236f,
	 0.599389f,  0.599543f,  0.599696f,  0.599850f,  0.600003f,  0.600156f,  0.600310f,  0.600463f,
	 0.600616f,  0.600770f,  0.600923f,  0.601076f,  0.601230f,  0.601383f,  0.601536f,  0.601689f,
	 0.601842f,  0.601995f,  0.602148f,  0.602302f,  0.602455f,  0.602608f,  0.602761f,  0.602914f,
	 0.603067f,  0.603220f,  0.603372f,  0.603525f,  0.603678f,  0.603831f,  0.603984f,  0.604137f,
	 0.604290f,  0.604442f,  0.604595f,  0.604748f,  0.604900f,  0.605053f,  0.605206f,  0.605358f,
	 0.605511f,  0.605664f,  0.605816f,  0.605969f,  0.606121f,  0.606274f,  0.606426f,  0.606579f,
	 0.606731f,  0.606884f,  0.607036f,  0.607188f,  0.607341f,  0.607493f,  0.607645f,  0.607798f,
	 0.607950f,  0.608102f,  0.608254f,  0.608406f,  0.608559f,  0.608711f,  0.608863f,  0.609015f,
	 0.609167f,  0.609319f,  0.609471f,  0.609623f,  0.609775f,  0.609927f,  0.610079f,  0.610231f,
	 0.610383f,  0.610535f,  0.610687f,  0.610838f,  0.610990f,  0.611142f,  0.611294f,  0.611445f,
	 0.611597f,  0.611749f,  0.611901f,  0.612052f,  0.612204f,  0.612355f,  0.612507f,  0.612659f,
	 0.612810f,  0.612962f,  0.613113f,  0.613265f,  0.613416f,  0.613567f,  0.613719f,  0.613870f,
	 0.614022f,  0.614173f,  0.614324f,  0.614475f,  0.614627f,  0.614778f,  0.614929f,  0.615080f,
	 0.615232f,  0.615383f,  0.615534f,  0.615685f,  0.615836f,  0.615987f,  0.616138f,  0.616289f,
	 0.616440f,  0.616591f,  0.616742f,  0.616893f,  0.617044f,  0.617195f,  0.617346f,  0.617496f,
	 0.617647f,  0.617798f,  0.617949f,  0.618100f,  0.618250f,  0.618401f,  0.618552f,  0.618702f,
	 0.618853f,  0.619004f,  0.619154f,  0.619305f,  0.619455f,  0.619606f,  0.619756f,  0.619907f,
	 0.620057f,  0.620208f,  0.620358f,  0.620508f,  0.620659f,  0.620809f,  0.620959f,  0.621110f,
	 0.621260f,  0.621410f,  0.621560f,  0.621711f,  0.621861f,  0.622011f,  0.622161f,  0.622311f,
	 0.622461f,  0.622611f,  0.622761f,  0.622911f,  0.623061f,  0.623211f,  0.623361f,  0.623511f,
	 0.623661f,  0.623811f,  0.623961f,  0.624111f,  0.624260f,  0.624410f,  0.624560f,  0.624710f,
	 0.624860f,  0.625009f,  0.625159f,  0.625309f,  0.625458f,  0.625608f,  0.625757f,  0.625907f,
	 0.626056f,  0.626206f,  0.626355f,  0.626505f,  0.626654f,  0.626804f,  0.626953f,  0.627102f,
	 0.627252f,  0.627401f,  0.627550f,  0.627700f,  0.627849f,  0.627998f,  0.628147f,  0.628297f,
	 0.628446f,  0.628595f,  0.628744f,  0.628893f,  0.629042f,  0.629191f,  0.629340f,  0.629489f,
	 0.629638f,  0.629787f,  0.629936f,  0.630085f,  0.630234f,  0.630383f,  0.630532f,  0.630680f,
	 0.630829f,  0.630978f,  0.631127f,  0.631275f,  0.631424f,  0.631573f,  0.631721f,  0.631870f,
	 0.632019f,  0.632167f,  0.632316f,  0.632464f,  0.632613f,  0.632761f,  0.632910f,  0.633058f,
	 0.633207f,  0.633355f,  0.633504f,  0.633652f,  0.633800f,  0.633949f,  0.634097f,  0.634245f,
	 0.634393f,  0.634542f,  0.634690f,  0.634838f,  0.634986f,  0.635134f,  0.635282f,  0.635430f,
	 0.635578f,  0.635726f,  0.635874f,  0.636022f,  0.636170f,  0.636318f,  0.636466f,  0.636614f,
	 0.636762f,  0.636910f,  0.637057f,  0.637205f,  0.637353f,  0.637501f,  0.637649f,  0.637796f,
	 0.637944f,  0.638092f,  0.638239f,  0.638387f,  0.638534f,  0.638682f,  0.638829f,  0.638977f,
	 0.639124f,  0.639272f,  0.639419f,  0.639567f,  0.639714f,  0.639862f,  0.640009f,  0.640156f,
	 0.640303f,  0.640451f,  0.640598f,  0.640745f,  0.640892f,  0.641040f,  0.641187f,  0.641334f,
	 0.641481f,  0.641628f,  0.641775f,  0.641922f,  0.642069f,  0.642216f,  0.642363f,  0.642510f,
	 0.642657f,  0.642804f,  0.642951f,  0.643098f,  0.643245f,  0.643391f,  0.643538f,  0.643685f,
	 0.643832f,  0.643978f,  0.644125f,  0.644272f,  0.644418f,  0.644565f,  0.644711f,  0.644858f,
	 0.645005f,  0.645151f,  0.645298f,  0.645444f,  0.645590f,  0.645737f,  0.645883f,  0.646030f,
	 0.646176f,  0.646322f,  0.646469f,  0.646615f,  0.646761f,  0.646907f,  0.647054f,  0.647200f,
	 0.647346f,  0.647492f,  0.647638f,  0.647784f,  0.647930f,  0.648076f,  0.648222f,  0.648368f,
	 0.648514f,  0.648660f,  0.648806f,  0.648952f,  0.649098f,  0.649244f,  0.649390f,  0.649536f,
	 0.649681f,  0.649827f,  0.649973f,  0.650119f,  0.650264f,  0.650410f,  0.650555f,  0.650701f,
	 0.650847f,  0.650992f,  0.651138f,  0.651283f,  0.651429f,  0.651574f,  0.651720f,  0.651865f,
	 0.652011f,  0.652156f,  0.652301f,  0.652447f,  0.652592f,  0.652737f,  0.652882f,  0.653028f,
	 0.653173f,  0.653318f,  0.653463f,  0.653608f,  0.653753f,  0.653899f,  0.654044f,  0.654189f,
	 0.654334f,  0.654479f,  0.654624f,  0.654769f,  0.654913f,  0.655058f,  0.655203f,  0.655348f,
	 0.655493f,  0.655638f,  0.655782f,  0.655927f,  0.656072f,  0.656217f,  0.656361f,  0.656506f,
	 0.656651f,  0.656795f,  0.656940f,  0.657084f,  0.657229f,  0.657373f,  0.657518f,  0.657662f,
	 0.657807f,  0.657951f,  0.658095f,  0.658240f,  0.658384f,  0.658529f,  0.658673f,  0.658817f,
	 0.658961f,  0.659105f,  0.659250f,  0.659394f,  0.659538f,  0.659682f,  0.659826f,  0.659970f,
	 0.660114f,  0.660258f,  0.660402f,  0.660546f,  0.660690f,  0.660834f,  0.660978f,  0.661122f,
	 0.661266f,  0.661410f,  0.661553f,  0.661697f,  0.661841f,  0.661985f,  0.662128f,  0.662272f,
	 0.662416f,  0.662559f,  0.662703f,  0.662847f,  0.662990f,  0.663134f,  0.663277f,  0.663421f,
	 0.663564f,  0.663708f,  0.663851f,  0.663994f,  0.664138f,  0.664281f,  0.664424f,  0.664568f,
	 0.664711f,  0.664854f,  0.664997f,  0.665141f,  0.665284f,  0.665427f,  0.665570f,  0.665713f,
	 0.665856f,  0.665999f,  0.666142f,  0.666285f,  0.666428f,  0.666571f,  0.666714f,  0.666857f,
	 0.667000f,  0.667143f,  0.667286f,  0.667428f,  0.667571f,  0.667714f,  0.667857f,  0.667999f,
	 0.668142f,  0.668285f,  0.668427f,  0.668570f,  0.668712f,  0.668855f,  0.668998f,  0.669140f,
	 0.669283f,  0.669425f,  0.669567f,  0.669710f,  0.669852f,  0.669995f,  0.670137f,  0.670279f,
	 0.670422f,  0.670564f,  0.670706f,  0.670848f,  0.670990f,  0.671133f,  0.671275f,  0.671417f,
	 0.671559f,  0.671701f,  0.671843f,  0.671985f,  0.672127f,  0.672269f,  0.672411f,  0.672553f,
	 0.672695f,  0.672837f,  0.672978f,  0.673120f,  0.673262f,  0.673404f,  0.673546f,  0.673687f,
	 0.673829f,  0.673971f,  0.674112f,  0.674254f,  0.674396f,  0.674537f,  0.674679f,  0.674820f,
	 0.674962f,  0.675103f,  0.675245f,  0.675386f,  0.675527f,  0.675669f,  0.675810f,  0.675951f,
	 0.676093f,  0.676234f,  0.676375f,  0.676516f,  0.676658f,  0.676799f,  0.676940f,  0.677081f,
	 0.677222f,  0.677363f,  0.677504f,  0.677645f,  0.677786f,  0.677927f,  0.678068f,  0.678209f,
	 0.678350f,  0.678491f,  0.678632f,  0.678773f,  0.678913f,  0.679054f,  0.679195f,  0.679336f,
	 0.679476f,  0.679617f,  0.679758f,  0.679898f,  0.680039f,  0.680179f,  0.680320f,  0.680461f,
	 0.680601f,  0.680741f,  0.680882f,  0.681022f,  0.681163f,  0.681303f,  0.681443f,  0.681584f,
	 0.681724f,  0.681864f,  0.682005f,  0.682145f,  0.682285f,  0.682425f,  0.682565f,  0.682705f,
	 0.682846f,  0.682986f,  0.683126f,  0.683266f,  0.683406f,  0.683546f,  0.683686f,  0.683825f,
	 0.683965f,  0.684105f,  0.684245f,  0.684385f,  0.684525f,  0.684664f,  0.684804f,  0.684944f,
	 0.685084f,  0.685223f,  0.685363f,  0.685503f,  0.685642f,  0.685782f,  0.685921f,  0.686061f,
	 0.686200f,  0.686340f,  0.686479f,  0.686619f,  0.686758f,  0.686897f,  0.687037f,  0.687176f,
	 0.687315f,  0.687455f,  0.687594f,  0.687733f,  0.687872f,  0.688011f,  0.688151f,  0.688290f,
	 0.688429f,  0.688568f,  0.688707f,  0.688846f,  0.688985f,  0.689124f,  0.689263f,  0.689402f,
	 0.689541f,  0.689679f,  0.689818f,  0.689957f,  0.690096f,  0.690235f,  0.690373f,  0.690512f,
	 0.690651f,  0.690789f,  0.690928f,  0.691067f,  0.691205f,  0.691344f,  0.691482f,  0.691621f,
	 0.691759f,  0.691898f,  0.692036f,  0.692175f,  0.692313f,  0.692451f,  0.692590f,  0.692728f,
	 0.692866f,  0.693004f,  0.693143f,  0.693281f,  0.693419f,  0.693557f,  0.693695f,  0.693833f,
	 0.693971f,  0.694109f,  0.694248f,  0.694386f,  0.694524f,  0.694661f,  0.694799f,  0.694937f,
	 0.695075f,  0.695213f,  0.695351f,  0.695489f,  0.695626f,  0.695764f,  0.695902f,  0.696039f,
	 0.696177f,  0.696315f,  0.696452f,  0.696590f,  0.696728f,  0.696865f,  0.697003f,  0.697140f,
	 0.697277f,  0.697415f,  0.697552f,  0.697690f,  0.697827f,  0.697964f,  0.698102f,  0.698239f,
	 0.698376f,  0.698513f,  0.698651f,  0.698788f,  0.698925f,  0.699062f,  0.699199f,  0.699336f,
	 0.699473f,  0.699610f,  0.699747f,  0.699884f,  0.700021f,  0.700158f,  0.700295f,  0.700432f,
	 0.700569f,  0.700706f,  0.700842f,  0.700979f,  0.701116f,  0.701253f,  0.701389f,  0.701526f,
	 0.701663f,  0.701799f,  0.701936f,  0.702072f,  0.702209f,  0.702345f,  0.702482f,  0.702618f,
	 0.702755f,  0.702891f,  0.703028f,  0.703164f,  0.703300f,  0.703436f,  0.703573f,  0.703709f,
	 0.703845f,  0.703981f,  0.704118f,  0.704254f,  0.704390f,  0.704526f,  0.704662f,  0.704798f,
	 0.704934f,  0.705070f,  0.705206f,  0.705342f,  0.705478f,  0.705614f,  0.705750f,  0.705885f,
	 0.706021f,  0.706157f,  0.706293f,  0.706429f,  0.706564f,  0.706700f,  0.706836f,  0.706971f,
	 0.707107f,  0.707242f,  0.707378f,  0.707513f,  0.707649f,  0.707784f,  0.707920f,  0.708055f,
	 0.708191f,  0.708326f,  0.708461f,  0.708597f,  0.708732f,  0.708867f,  0.709002f,  0.709138f,
	 0.709273f,  0.709408f,  0.709543f,  0.709678f,  0.709813f,  0.709948f,  0.710083f,  0.710218f,
	 0.710353f,  0.710488f,  0.710623f,  0.710758f,  0.710893f,  0.711028f,  0.711163f,  0.711297f,
	 0.711432f,  0.711567f,  0.711702f,  0.711836f,  0.711971f,  0.712106f,  0.712240f,  0.712375f,
	 0.712509f,  0.712644f,  0.712778f,  0.712913f,  0.713047f,  0.713182f,  0.713316f,  0.713451f,
	 0.713585f,  0.713719f,  0.713853f,  0.713988f,  0.714122f,  0.714256f,  0.714390f,  0.714525f,
	 0.714659f,  0.714793f,  0.714927f,  0.715061f,  0.715195f,  0.715329f,  0.715463f,  0.715597f,
	 0.715731f,  0.715865f,  0.715999f,  0.716132f,  0.716266f,  0.716400f,  0.716534f,  0.716668f,
	 0.716801f,  0.716935f,  0.717069f,  0.717202f,  0.717336f,  0.717469f,  0.717603f,  0.717737f,
	 0.717870f,  0.718004f,  0.718137f,  0.718270f,  0.718404f,  0.718537f,  0.718670f,  0.718804f,
	 0.718937f,  0.719070f,  0.719204f,  0.719337f,  0.719470f,  0.719603f,  0.719736f,  0.719869f,
	 0.720003f,  0.720136f,  0.720269f,  0.720402f,  0.720535f,  0.720668f,  0.720800f,  0.720933f,
	 0.721066f,  0.721199f,  0.721332f,  0.721465f,  0.721597f,  0.721730f,  0.721863f,  0.721996f,
	 0.722128f,  0.722261f,  0.722393f,  0.722526f,  0.722659f,  0.722791f,  0.722924f,  0.723056f,
	 0.723188f,  0.723321f,  0.723453f,  0.723586f,  0.723718f,  0.723850f,  0.723983f,  0.724115f,
	 0.724247f,  0.724379f,  0.724511f,  0.724644f,  0.724776f,  0.724908f,  0.725040f,  0.725172f,
	 0.725304f,  0.725436f,  0.725568f,  0.725700f,  0.725832f,  0.725964f,  0.726095f,  0.726227f,
	 0.726359f,  0.726491f,  0.726623f,  0.726754f,  0.726886f,  0.727018f,  0.727149f,  0.727281f,
	 0.727413f,  0.727544f,  0.727676f,  0.727807f,  0.727939f,  0.728070f,  0.728202f,  0.728333f,
	 0.728464f,  0.728596f,  0.728727f,  0.728858f,  0.728990f,  0.729121f,  0.729252f,  0.729383f,
	 0.729514f,  0.729646f,  0.729777f,  0.729908f,  0.730039f,  0.730170f,  0.730301f,  0.730432f,
	 0.730563f,  0.730694f,  0.730825f,  0.730955f,  0.731086f,  0.731217f,  0.731348f,  0.731479f,
	 0.731609f,  0.731740f,  0.731871f,  0.732001f,  0.732132f,  0.732263f,  0.732393f,  0.732524f,
	 0.732654f,  0.732785f,  0.732915f,  0.733046f,  0.733176f,  0.733306f,  0.733437f,  0.733567f,
	 0.733697f,  0.733828f,  0.733958f,  0.734088f,  0.734218f,  0.734349f,  0.734479f,  0.734609f,
	 0.734739f,  0.734869f,  0.734999f,  0.735129f,  0.735259f,  0.735389f,  0.735519f,  0.735649f,
	 0.735779f,  0.735908f,  0.736038f,  0.736168f,  0.736298f,  0.736428f,  0.736557f,  0.736687f,
	 0.736817f,  0.736946f,  0.737076f,  0.737205f,  0.737335f,  0.737464f,  0.737594f,  0.737723f,
	 0.737853f,  0.737982f,  0.738112f,  0.738241f,  0.738370f,  0.738500f,  0.738629f,  0.738758f,
	 0.738887f,  0.739017f,  0.739146f,  0.739275f,  0.739404f,  0.739533f,  0.739662f,  0.739791f,
	 0.739920f,  0.740049f,  0.740178f,  0.740307f,  0.740436f,  0.740565f,  0.740694f,  0.740822f,
	 0.740951f,  0.741080f,  0.741209f,  0.741337f,  0.741466f,  0.741595f,  0.741723f,  0.741852f,
	 0.741980f,  0.742109f,  0.742237f,  0.742366f,  0.742494f,  0.742623f,  0.742751f,  0.742880f,
	 0.743008f,  0.743136f,  0.743265f,  0.743393f,  0.743521f,  0.743649f,  0.743777f,  0.743906f,
	 0.744034f,  0.744162f,  0.744290f,  0.744418f,  0.744546f,  0.744674f,  0.744802f,  0.744930f,
	 0.745058f,  0.745186f,  0.745314f,  0.745441f,  0.745569f,  0.745697f,  0.745825f,  0.745952f,
	 0.746080f,  0.746208f,  0.746335f,  0.746463f,  0.746591f,  0.746718f,  0.746846f,  0.746973f,
	 0.747101f,  0.747228f,  0.747355f,  0.747483f,  0.747610f,  0.747738f,  0.747865f,  0.747992f,
	 0.748119f,  0.748247f,  0.748374f,  0.748501f,  0.748628f,  0.748755f,  0.748882f,  0.749009f,
	 0.749136f,  0.749263f,  0.749390f,  0.749517f,  0.749644f,  0.749771f,  0.749898f,  0.750025f,
	 0.750152f,  0.750278f,  0.750405f,  0.750532f,  0.750659f,  0.750785f,  0.750912f,  0.751039f,
	 0.751165f,  0.751292f,  0.751418f,  0.751545f,  0.751671f,  0.751798f,  0.751924f,  0.752050f,
	 0.752177f,  0.752303f,  0.752429f,  0.752556f,  0.752682f,  0.752808f,  0.752934f,  0.753061f,
	 0.753187f,  0.753313f,  0.753439f,  0.753565f,  0.753691f,  0.753817f,  0.753943f,  0.754069f,
	 0.754195f,  0.754321f,  0.754447f,  0.754573f,  0.754698f,  0.754824f,  0.754950f,  0.755076f,
	 0.755201f,  0.755327f,  0.755453f,  0.755578f,  0.755704f,  0.755829f,  0.755955f,  0.756081f,
	 0.756206f,  0.756331f,  0.756457f,  0.756582f,  0.756708f,  0.756833f,  0.756958f,  0.757084f,
	 0.757209f,  0.757334f,  0.757459f,  0.757584f,  0.757710f,  0.757835f,  0.757960f,  0.758085f,
	 0.758210f,  0.758335f,  0.758460f,  0.758585f,  0.758710f,  0.758835f,  0.758960f,  0.759084f,
	 0.759209f,  0.759334f,  0.759459f,  0.759583f,  0.759708f,  0.759833f,  0.759957f,  0.760082f,
	 0.760207f,  0.760331f,  0.760456f,  0.760580f,  0.760705f,  0.760829f,  0.760954f,  0.761078f,
	 0.761202f,  0.761327f,  0.761451f,  0.761575f,  0.761700f,  0.761824f,  0.761948f,  0.762072f,
	 0.762196f,  0.762320f,  0.762444f,  0.762569f,  0.762693f,  0.762817f,  0.762941f,  0.763065f,
	 0.763188f,  0.763312f,  0.763436f,  0.763560f,  0.763684f,  0.763808f,  0.763931f,  0.764055f,
	 0.764179f,  0.764302f,  0.764426f,  0.764550f,  0.764673f,  0.764797f,  0.764920f,  0.765044f,
	 0.765167f,  0.765291f,  0.765414f,  0.765538f,  0.765661f,  0.765784f,  0.765907f,  0.766031f,
	 0.766154f,  0.766277f,  0.766400f,  0.766524f,  0.766647f,  0.766770f,  0.766893f,  0.767016f,
	 0.767139f,  0.767262f,  0.767385f,  0.767508f,  0.767631f,  0.767754f,  0.767876f,  0.767999f,
	 0.768122f,  0.768245f,  0.768368f,  0.768490f,  0.768613f,  0.768736f,  0.768858f,  0.768981f,
	 0.769103f,  0.769226f,  0.769348f,  0.769471f,  0.769593f,  0.769716f,  0.769838f,  0.769961f,
	 0.770083f,  0.770205f,  0.770327f,  0.770450f,  0.770572f,  0.770694f,  0.770816f,  0.770938f,
	 0.771061f,  0.771183f,  0.771305f,  0.771427f,  0.771549f,  0.771671f,  0.771793f,  0.771915f,
	 0.772036f,  0.772158f,  0.772280f,  0.772402f,  0.772524f,  0.772645f,  0.772767f,  0.772889f,
	 0.773010f,  0.773132f,  0.773254f,  0.773375f,  0.773497f,  0.773618f,  0.773740f,  0.773861f,
	 0.773983f,  0.774104f,  0.774225f,  0.774347f,  0.774468f,  0.774589f,  0.774711f,  0.774832f,
	 0.774953f,  0.775074f,  0.775195f,  0.775317f,  0.775438f,  0.775559f,  0.775680f,  0.775801f,
	 0.775922f,  0.776043f,  0.776164f,  0.776284f,  0.776405f,  0.776526f,  0.776647f,  0.776768f,
	 0.776888f,  0.777009f,  0.777130f,  0.777251f,  0.777371f,  0.777492f,  0.777612f,  0.777733f,
	 0.777853f,  0.777974f,  0.778094f,  0.778215f,  0.778335f,  0.778456f,  0.778576f,  0.778696f,
	 0.778817f,  0.778937f,  0.779057f,  0.779177f,  0.779297f,  0.779418f,  0.779538f,  0.779658f,
	 0.779778f,  0.779898f,  0.780018f,  0.780138f,  0.780258f,  0.780378f,  0.780498f,  0.780617f,
	 0.780737f,  0.780857f,  0.780977f,  0.781097f,  0.781216f,  0.781336f,  0.781456f,  0.781575f,
	 0.781695f,  0.781814f,  0.781934f,  0.782053f,  0.782173f,  0.782292f,  0.782412f,  0.782531f,
	 0.782651f,  0.782770f,  0.782889f,  0.783009f,  0.783128f,  0.783247f,  0.783366f,  0.783485f,
	 0.783605f,  0.783724f,  0.783843f,  0.783962f,  0.784081f,  0.784200f,  0.784319f,  0.784438f,
	 0.784557f,  0.784675f,  0.784794f,  0.784913f,  0.785032f,  0.785151f,  0.785269f,  0.785388f,
	 0.785507f,  0.785625f,  0.785744f,  0.785863f,  0.785981f,  0.786100f,  0.786218f,  0.786337f,
	 0.786455f,  0.786574f,  0.786692f,  0.786810f,  0.786929f,  0.787047f,  0.787165f,  0.787284f,
	 0.787402f,  0.787520f,  0.787638f,  0.787756f,  0.787874f,  0.787992f,  0.788110f,  0.788228f,
	 0.788346f,  0.788464f,  0.788582f,  0.788700f,  0.788818f,  0.788936f,  0.789054f,  0.789172f,
	 0.789289f,  0.789407f,  0.789525f,  0.789642f,  0.789760f,  0.789878f,  0.789995f,  0.790113f,
	 0.790230f,  0.790348f,  0.790465f,  0.790583f,  0.790700f,  0.790817f,  0.790935f,  0.791052f,
	 0.791169f,  0.791287f,  0.791404f,  0.791521f,  0.791638f,  0.791755f,  0.791872f,  0.791990f,
	 0.792107f,  0.792224f,  0.792341f,  0.792458f,  0.792575f,  0.792691f,  0.792808f,  0.792925f,
	 0.793042f,  0.793159f,  0.793276f,  0.793392f,  0.793509f,  0.793626f,  0.793742f,  0.793859f,
	 0.793975f,  0.794092f,  0.794209f,  0.794325f,  0.794442f,  0.794558f,  0.794674f,  0.794791f,
	 0.794907f,  0.795023f,  0.795140f,  0.795256f,  0.795372f,  0.795488f,  0.795605f,  0.795721f,
	 0.795837f,  0.795953f,  0.796069f,  0.796185f,  0.796301f,  0.796417f,  0.796533f,  0.796649f,
	 0.796765f,  0.796881f,  0.796996f,  0.797112f,  0.797228f,  0.797344f,  0.797459f,  0.797575f,
	 0.797691f,  0.797806f,  0.797922f,  0.798038f,  0.798153f,  0.798269f,  0.798384f,  0.798500f,
	 0.798615f,  0.798730f,  0.798846f,  0.798961f,  0.799076f,  0.799192f,  0.799307f,  0.799422f,
	 0.799537f,  0.799652f,  0.799768f,  0.799883f,  0.799998f,  0.800113f,  0.800228f,  0.800343f,
	 0.800458f,  0.800573f,  0.800687f,  0.800802f,  0.800917f,  0.801032f,  0.801147f,  0.801261f,
	 0.801376f,  0.801491f,  0.801606f,  0.801720f,  0.801835f,  0.801949f,  0.802064f,  0.802178f,
	 0.802293f,  0.802407f,  0.802522f,  0.802636f,  0.802750f,  0.802865f,  0.802979f,  0.803093f,
	 0.803208f,  0.803322f,  0.803436f,  0.803550f,  0.803664f,  0.803778f,  0.803892f,  0.804006f,
	 0.804120f,  0.804234f,  0.804348f,  0.804462f,  0.804576f,  0.804690f,  0.804804f,  0.804918f,
	 0.805031f,  0.805145f,  0.805259f,  0.805372f,  0.805486f,  0.805600f,  0.805713f,  0.805827f,
	 0.805940f,  0.806054f,  0.806167f,  0.806281f,  0.806394f,  0.806508f,  0.806621f,  0.806734f,
	 0.806848f,  0.806961f,  0.807074f,  0.807187f,  0.807300f,  0.807414f,  0.807527f,  0.807640f,
	 0.807753f,  0.807866f,  0.807979f,  0.808092f,  0.808205f,  0.808318f,  0.808430f,  0.808543f,
	 0.808656f,  0.808769f,  0.808882f,  0.808994f,  0.809107f,  0.809220f,  0.809332f,  0.809445f,
	 0.809558f,  0.809670f,  0.809783f,  0.809895f,  0.810008f,  0.810120f,  0.810232f,  0.810345f,
	 0.810457f,  0.810570f,  0.810682f,  0.810794f,  0.810906f,  0.811018f,  0.811131f,  0.811243f,
	 0.811355f,  0.811467f,  0.811579f,  0.811691f,  0.811803f,  0.811915f,  0.812027f,  0.812139f,
	 0.812251f,  0.812362f,  0.812474f,  0.812586f,  0.812698f,  0.812809f,  0.812921f,  0.813033f,
	 0.813144f,  0.813256f,  0.813368f,  0.813479f,  0.813591f,  0.813702f,  0.813814f,  0.813925f,
	 0.814036f,  0.814148f,  0.814259f,  0.814370f,  0.814482f,  0.814593f,  0.814704f,  0.814815f,
	 0.814926f,  0.815037f,  0.815149f,  0.815260f,  0.815371f,  0.815482f,  0.815593f,  0.815704f,
	 0.815814f,  0.815925f,  0.816036f,  0.816147f,  0.816258f,  0.816368f,  0.816479f,  0.816590f,
	 0.816701f,  0.816811f,  0.816922f,  0.817032f,  0.817143f,  0.817253f,  0.817364f,  0.817474f,
	 0.817585f,  0.817695f,  0.817806f,  0.817916f,  0.818026f,  0.818137f,  0.818247f,  0.818357f,
	 0.818467f,  0.818577f,  0.818687f,  0.818798f,  0.818908f,  0.819018f,  0.819128f,  0.819238f,
	 0.819348f,  0.819457f,  0.819567f,  0.819677f,  0.819787f,  0.819897f,  0.820007f,  0.820116f,
	 0.820226f,  0.820336f,  0.820445f,  0.820555f,  0.820664f,  0.820774f,  0.820884f,  0.820993f,
	 0.821102f,  0.821212f,  0.821321f,  0.821431f,  0.821540f,  0.821649f,  0.821759f,  0.821868f,
	 0.821977f,  0.822086f,  0.822195f,  0.822305f,  0.822414f,  0.822523f,  0.822632f,  0.822741f,
	 0.822850f,  0.822959f,  0.823068f,  0.823177f,  0.823285f,  0.823394f,  0.823503f,  0.823612f,
	 0.823721f,  0.823829f,  0.823938f,  0.824047f,  0.824155f,  0.824264f,  0.824372f,  0.824481f,
	 0.824589f,  0.824698f,  0.824806f,  0.824915f,  0.825023f,  0.825131f,  0.825240f,  0.825348f,
	 0.825456f,  0.825564f,  0.825673f,  0.825781f,  0.825889f,  0.825997f,  0.826105f,  0.826213f,
	 0.826321f,  0.826429f,  0.826537f,  0.826645f,  0.826753f,  0.826861f,  0.826968f,  0.827076f,
	 0.827184f,  0.827292f,  0.827399f,  0.827507f,  0.827615f,  0.827722f,  0.827830f,  0.827938f,
	 0.828045f,  0.828153f,  0.828260f,  0.828367f,  0.828475f,  0.828582f,  0.828690f,  0.828797f,
	 0.828904f,  0.829011f,  0.829119f,  0.829226f,  0.829333f,  0.829440f,  0.829547f,  0.829654f,
	 0.829761f,  0.829868f,  0.829975f,  0.830082f,  0.830189f,  0.830296f,  0.830403f,  0.830510f,
	 0.830616f,  0.830723f,  0.830830f,  0.830937f,  0.831043f,  0.831150f,  0.831257f,  0.831363f,
	 0.831470f,  0.831576f,  0.831683f,  0.831789f,  0.831895f,  0.832002f,  0.832108f,  0.832215f,
	 0.832321f,  0.832427f,  0.832533f,  0.832640f,  0.832746f,  0.832852f,  0.832958f,  0.833064f,
	 0.833170f,  0.833276f,  0.833382f,  0.833488f,  0.833594f,  0.833700f,  0.833806f,  0.833912f,
	 0.834018f,  0.834123f,  0.834229f,  0.834335f,  0.834440f,  0.834546f,  0.834652f,  0.834757f,
	 0.834863f,  0.834968f,  0.835074f,  0.835179f,  0.835285f,  0.835390f,  0.835496f,  0.835601f,
	 0.835706f,  0.835812f,  0.835917f,  0.836022f,  0.836127f,  0.836232f,  0.836338f,  0.836443f,
	 0.836548f,  0.836653f,  0.836758f,  0.836863f,  0.836968f,  0.837073f,  0.837178f,  0.837282f,
	 0.837387f,  0.837492f,  0.837597f,  0.837701f,  0.837806f,  0.837911f,  0.838015f,  0.838120f,
	 0.838225f,  0.838329f,  0.838434f,  0.838538f,  0.838643f,  0.838747f,  0.838852f,  0.838956f,
	 0.839060f,  0.839165f,  0.839269f,  0.839373f,  0.839477f,  0.839581f,  0.839686f,  0.839790f,
	 0.839894f,  0.839998f,  0.840102f,  0.840206f,  0.840310f,  0.840414f,  0.840518f,  0.840622f,
	 0.840725f,  0.840829f,  0.840933f,  0.841037f,  0.841140f,  0.841244f,  0.841348f,  0.841451f,
	 0.841555f,  0.841659f,  0.841762f,  0.841866f,  0.841969f,  0.842072f,  0.842176f,  0.842279f,
	 0.842383f,  0.842486f,  0.842589f,  0.842692f,  0.842796f,  0.842899f,  0.843002f,  0.843105f,
	 0.843208f,  0.843311f,  0.843414f,  0.843517f,  0.843620f,  0.843723f,  0.843826f,  0.843929f,
	 0.844032f,  0.844135f,  0.844238f,  0.844340f,  0.844443f,  0.844546f,  0.844648f,  0.844751f,
	 0.844854f,  0.844956f,  0.845059f,  0.845161f,  0.845264f,  0.845366f,  0.845469f,  0.845571f,
	 0.845673f,  0.845776f,  0.845878f,  0.845980f,  0.846082f,  0.846185f,  0.846287f,  0.846389f,
	 0.846491f,  0.846593f,  0.846695f,  0.846797f,  0.846899f,  0.847001f,  0.847103f,  0.847205f,
	 0.847307f,  0.847408f,  0.847510f,  0.847612f,  0.847714f,  0.847815f,  0.847917f,  0.848019f,
	 0.848120f,  0.848222f,  0.848323f,  0.848425f,  0.848526f,  0.848628f,  0.848729f,  0.848831f,
	 0.848932f,  0.849033f,  0.849135f,  0.849236f,  0.849337f,  0.849438f,  0.849540f,  0.849641f,
	 0.849742f,  0.849843f,  0.849944f,  0.850045f,  0.850146f,  0.850247f,  0.850348f,  0.850449f,
	 0.850549f,  0.850650f,  0.850751f,  0.850852f,  0.850953f,  0.851053f,  0.851154f,  0.851255f,
	 0.851355f,  0.851456f,  0.851556f,  0.851657f,  0.851757f,  0.851858f,  0.851958f,  0.852059f,
	 0.852159f,  0.852259f,  0.852360f,  0.852460f,  0.852560f,  0.852660f,  0.852760f,  0.852861f,
	 0.852961f,  0.853061f,  0.853161f,  0.853261f,  0.853361f,  0.853461f,  0.853561f,  0.853660f,
	 0.853760f,  0.853860f,  0.853960f,  0.854060f,  0.854159f,  0.854259f,  0.854359f,  0.854458f,
	 0.854558f,  0.854658f,  0.854757f,  0.854857f,  0.854956f,  0.855056f,  0.855155f,  0.855254f,
	 0.855354f,  0.855453f,  0.855552f,  0.855651f,  0.855751f,  0.855850f,  0.855949f,  0.856048f,
	 0.856147f,  0.856246f,  0.856345f,  0.856444f,  0.856543f,  0.856642f,  0.856741f,  0.856840f,
	 0.856939f,  0.857038f,  0.857137f,  0.857235f,  0.857334f,  0.857433f,  0.857531f,  0.857630f,
	 0.857729f,  0.857827f,  0.857926f,  0.858024f,  0.858123f,  0.858221f,  0.858320f,  0.858418f,
	 0.858516f,  0.858615f,  0.858713f,  0.858811f,  0.858909f,  0.859007f,  0.859106f,  0.859204f,
	 0.859302f,  0.859400f,  0.859498f,  0.859596f,  0.859694f,  0.859792f,  0.859890f,  0.859988f,
	 0.860085f,  0.860183f,  0.860281f,  0.860379f,  0.860476f,  0.860574f,  0.860672f,  0.860769f,
	 0.860867f,  0.860964f,  0.861062f,  0.861160f,  0.861257f,  0.861354f,  0.861452f,  0.861549f,
	 0.861646f,  0.861744f,  0.861841f,  0.861938f,  0.862035f,  0.862133f,  0.862230f,  0.862327f,
	 0.862424f,  0.862521f,  0.862618f,  0.862715f,  0.862812f,  0.862909f,  0.863006f,  0.863103f,
	 0.863199f,  0.863296f,  0.863393f,  0.863490f,  0.863586f,  0.863683f,  0.863780f,  0.863876f,
	 0.863973f,  0.864069f,  0.864166f,  0.864262f,  0.864359f,  0.864455f,  0.864552f,  0.864648f,
	 0.864744f,  0.864841f,  0.864937f,  0.865033f,  0.865129f,  0.865225f,  0.865321f,  0.865418f,
	 0.865514f,  0.865610f,  0.865706f,  0.865802f,  0.865898f,  0.865993f,  0.866089f,  0.866185f,
	 0.866281f,  0.866377f,  0.866472f,  0.866568f,  0.866664f,  0.866759f,  0.866855f,  0.866951f,
	 0.867046f,  0.867142f,  0.867237f,  0.867333f,  0.867428f,  0.867523f,  0.867619f,  0.867714f,
	 0.867809f,  0.867905f,  0.868000f,  0.868095f,  0.868190f,  0.868285f,  0.868381f,  0.868476f,
	 0.868571f,  0.868666f,  0.868761f,  0.868856f,  0.868951f,  0.869045f,  0.869140f,  0.869235f,
	 0.869330f,  0.869425f,  0.869519f,  0.869614f,  0.869709f,  0.869803f,  0.869898f,  0.869992f,
	 0.870087f,  0.870182f,  0.870276f,  0.870370f,  0.870465f,  0.870559f,  0.870654f,  0.870748f,
	 0.870842f,  0.870936f,  0.871031f,  0.871125f,  0.871219f,  0.871313f,  0.871407f,  0.871501f,
	 0.871595f,  0.871689f,  0.871783f,  0.871877f,  0.871971f,  0.872065f,  0.872159f,  0.872252f,
	 0.872346f,  0.872440f,  0.872534f,  0.872627f,  0.872721f,  0.872814f,  0.872908f,  0.873001f,
	 0.873095f,  0.873188f,  0.873282f,  0.873375f,  0.873469f,  0.873562f,  0.873655f,  0.873749f,
	 0.873842f,  0.873935f,  0.874028f,  0.874121f,  0.874215f,  0.874308f,  0.874401f,  0.874494f,
	 0.874587f,  0.874680f,  0.874773f,  0.874865f,  0.874958f,  0.875051f,  0.875144f,  0.875237f,
	 0.875329f,  0.875422f,  0.875515f,  0.875607f,  0.875700f,  0.875793f,  0.875885f,  0.875978f,
	 0.876070f,  0.876163f,  0.876255f,  0.876347f,  0.876440f,  0.876532f,  0.876624f,  0.876716f,
	 0.876809f,  0.876901f,  0.876993f,  0.877085f,  0.877177f,  0.877269f,  0.877361f,  0.877453f,
	 0.877545f,  0.877637f,  0.877729f,  0.877821f,  0.877913f,  0.878005f,  0.878096f,  0.878188f,
	 0.878280f,  0.878371f,  0.878463f,  0.878555f,  0.878646f,  0.878738f,  0.878829f,  0.878921f,
	 0.879012f,  0.879104f,  0.879195f,  0.879286f,  0.879378f,  0.879469f,  0.879560f,  0.879651f,
	 0.879743f,  0.879834f,  0.879925f,  0.880016f,  0.880107f,  0.880198f,  0.880289f,  0.880380f,
	 0.880471f,  0.880562f,  0.880653f,  0.880743f,  0.880834f,  0.880925f,  0.881016f,  0.881106f,
	 0.881197f,  0.881288f,  0.881378f,  0.881469f,  0.881559f,  0.881650f,  0.881740f,  0.881831f,
	 0.881921f,  0.882012f,  0.882102f,  0.882192f,  0.882283f,  0.882373f,  0.882463f,  0.882553f,
	 0.882643f,  0.882733f,  0.882824f,  0.882914f,  0.883004f,  0.883094f,  0.883184f,  0.883273f,
	 0.883363f,  0.883453f,  0.883543f,  0.883633f,  0.883723f,  0.883812f,  0.883902f,  0.883992f,
	 0.884081f,  0.884171f,  0.884260f,  0.884350f,  0.884439f,  0.884529f,  0.884618f,  0.884708f,
	 0.884797f,  0.884886f,  0.884976f,  0.885065f,  0.885154f,  0.885243f,  0.885333f,  0.885422f,
	 0.885511f,  0.885600f,  0.885689f,  0.885778f,  0.885867f,  0.885956f,  0.886045f,  0.886134f,
	 0.886223f,  0.886311f,  0.886400f,  0.886489f,  0.886578f,  0.886666f,  0.886755f,  0.886844f,
	 0.886932f,  0.887021f,  0.887109f,  0.887198f,  0.887286f,  0.887375f,  0.887463f,  0.887551f,
	 0.887640f,  0.887728f,  0.887816f,  0.887904f,  0.887993f,  0.888081f,  0.888169f,  0.888257f,
	 0.888345f,  0.888433f,  0.888521f,  0.888609f,  0.888697f,  0.888785f,  0.888873f,  0.888961f,
	 0.889048f,  0.889136f,  0.889224f,  0.889312f,  0.889399f,  0.889487f,  0.889574f,  0.889662f,
	 0.889750f,  0.889837f,  0.889925f,  0.890012f,  0.890099f,  0.890187f,  0.890274f,  0.890361f,
	 0.890449f,  0.890536f,  0.890623f,  0.890710f,  0.890797f,  0.890885f,  0.890972f,  0.891059f,
	 0.891146f,  0.891233f,  0.891320f,  0.891407f,  0.891493f,  0.891580f,  0.891667f,  0.891754f,
	 0.891841f,  0.891927f,  0.892014f,  0.892101f,  0.892187f,  0.892274f,  0.892361f,  0.892447f,
	 0.892534f,  0.892620f,  0.892706f,  0.892793f,  0.892879f,  0.892965f,  0.893052f,  0.893138f,
	 0.893224f,  0.893310f,  0.893397f,  0.893483f,  0.893569f,  0.893655f,  0.893741f,  0.893827f,
	 0.893913f,  0.893999f,  0.894085f,  0.894171f,  0.894256f,  0.894342f,  0.894428f,  0.894514f,
	 0.894599f,  0.894685f,  0.894771f,  0.894856f,  0.894942f,  0.895028f,  0.895113f,  0.895198f,
	 0.895284f,  0.895369f,  0.895455f,  0.895540f,  0.895625f,  0.895711f,  0.895796f,  0.895881f,
	 0.895966f,  0.896051f,  0.896137f,  0.896222f,  0.896307f,  0.896392f,  0.896477f,  0.896562f,
	 0.896646f,  0.896731f,  0.896816f,  0.896901f,  0.896986f,  0.897071f,  0.897155f,  0.897240f,
	 0.897325f,  0.897409f,  0.897494f,  0.897578f,  0.897663f,  0.897747f,  0.897832f,  0.897916f,
	 0.898001f,  0.898085f,  0.898169f,  0.898254f,  0.898338f,  0.898422f,  0.898506f,  0.898590f,
	 0.898674f,  0.898759f,  0.898843f,  0.898927f,  0.899011f,  0.899095f,  0.899179f,  0.899262f,
	 0.899346f,  0.899430f,  0.899514f,  0.899598f,  0.899681f,  0.899765f,  0.899849f,  0.899932f,
	 0.900016f,  0.900099f,  0.900183f,  0.900266f,  0.900350f,  0.900433f,  0.900517f,  0.900600f,
	 0.900683f,  0.900767f,  0.900850f,  0.900933f,  0.901016f,  0.901100f,  0.901183f,  0.901266f,
	 0.901349f,  0.901432f,  0.901515f,  0.901598f,  0.901681f,  0.901764f,  0.901847f,  0.901929f,
	 0.902012f,  0.902095f,  0.902178f,  0.902260f,  0.902343f,  0.902426f,  0.902508f,  0.902591f,
	 0.902673f,  0.902756f,  0.902838f,  0.902921f,  0.903003f,  0.903085f,  0.903168f,  0.903250f,
	 0.903332f,  0.903415f,  0.903497f,  0.903579f,  0.903661f,  0.903743f,  0.903825f,  0.903907f,
	 0.903989f,  0.904071f,  0.904153f,  0.904235f,  0.904317f,  0.904399f,  0.904481f,  0.904562f,
	 0.904644f,  0.904726f,  0.904807f,  0.904889f,  0.904971f,  0.905052f,  0.905134f,  0.905215f,
	 0.905297f,  0.905378f,  0.905460f,  0.905541f,  0.905622f,  0.905704f,  0.905785f,  0.905866f,
	 0.905947f,  0.906028f,  0.906110f,  0.906191f,  0.906272f,  0.906353f,  0.906434f,  0.906515f,
	 0.906596f,  0.906677f,  0.906757f,  0.906838f,  0.906919f,  0.907000f,  0.907081f,  0.907161f,
	 0.907242f,  0.907323f,  0.907403f,  0.907484f,  0.907564f,  0.907645f,  0.907725f,  0.907806f,
	 0.907886f,  0.907966f,  0.908047f,  0.908127f,  0.908207f,  0.908288f,  0.908368f,  0.908448f,
	 0.908528f,  0.908608f,  0.908688f,  0.908768f,  0.908848f,  0.908928f,  0.909008f,  0.909088f,
	 0.909168f,  0.909248f,  0.909328f,  0.909407f,  0.909487f,  0.909567f,  0.909646f,  0.909726f,
	 0.909806f,  0.909885f,  0.909965f,  0.910044f,  0.910124f,  0.910203f,  0.910283f,  0.910362f,
	 0.910441f,  0.910521f,  0.910600f,  0.910679f,  0.910758f,  0.910837f,  0.910917f,  0.910996f,
	 0.911075f,  0.911154f,  0.911233f,  0.911312f,  0.911391f,  0.911470f,  0.911548f,  0.911627f,
	 0.911706f,  0.911785f,  0.911864f,  0.911942f,  0.912021f,  0.912099f,  0.912178f,  0.912257f,
	 0.912335f,  0.912414f,  0.912492f,  0.912571f,  0.912649f,  0.912727f,  0.912806f,  0.912884f,
	 0.912962f,  0.913040f,  0.913119f,  0.913197f,  0.913275f,  0.913353f,  0.913431f,  0.913509f,
	 0.913587f,  0.913665f,  0.913743f,  0.913821f,  0.913899f,  0.913976f,  0.914054f,  0.914132f,
	 0.914210f,  0.914287f,  0.914365f,  0.914443f,  0.914520f,  0.914598f,  0.914675f,  0.914753f,
	 0.914830f,  0.914908f,  0.914985f,  0.915062f,  0.915140f,  0.915217f,  0.915294f,  0.915372f,
	 0.915449f,  0.915526f,  0.915603f,  0.915680f,  0.915757f,  0.915834f,  0.915911f,  0.915988f,
	 0.916065f,  0.916142f,  0.916219f,  0.916296f,  0.916372f,  0.916449f,  0.916526f,  0.916602f,
	 0.916679f,  0.916756f,  0.916832f,  0.916909f,  0.916985f,  0.917062f,  0.917138f,  0.917215f,
	 0.917291f,  0.917367f,  0.917444f,  0.917520f,  0.917596f,  0.917672f,  0.917749f,  0.917825f,
	 0.917901f,  0.917977f,  0.918053f,  0.918129f,  0.918205f,  0.918281f,  0.918357f,  0.918433f,
	 0.918508f,  0.918584f,  0.918660f,  0.918736f,  0.918811f,  0.918887f,  0.918963f,  0.919038f,
	 0.919114f,  0.919189f,  0.919265f,  0.919340f,  0.919416f,  0.919491f,  0.919567f,  0.919642f,
	 0.919717f,  0.919792f,  0.919868f,  0.919943f,  0.920018f,  0.920093f,  0.920168f,  0.920243f,
	 0.920318f,  0.920393f,  0.920468f,  0.920543f,  0.920618f,  0.920693f,  0.920768f,  0.920842f,
	 0.920917f,  0.920992f,  0.921067f,  0.921141f,  0.921216f,  0.921291f,  0.921365f,  0.921440f,
	 0.921514f,  0.921588f,  0.921663f,  0.921737f,  0.921812f,  0.921886f,  0.921960f,  0.922034f,
	 0.922109f,  0.922183f,  0.922257f,  0.922331f,  0.922405f,  0.922479f,  0.922553f,  0.922627f,
	 0.922701f,  0.922775f,  0.922849f,  0.922923f,  0.922997f,  0.923070f,  0.923144f,  0.923218f,
	 0.923291f,  0.923365f,  0.923439f,  0.923512f,  0.923586f,  0.923659f,  0.923733f,  0.923806f,
	 0.923880f,  0.923953f,  0.924026f,  0.924100f,  0.924173f,  0.924246f,  0.924319f,  0.924392f,
	 0.924465f,  0.924539f,  0.924612f,  0.924685f,  0.924758f,  0.924831f,  0.924904f,  0.924976f,
	 0.925049f,  0.925122f,  0.925195f,  0.925268f,  0.925340f,  0.925413f,  0.925486f,  0.925558f,
	 0.925631f,  0.925703f,  0.925776f,  0.925848f,  0.925921f,  0.925993f,  0.926066f,  0.926138f,
	 0.926210f,  0.926283f,  0.926355f,  0.926427f,  0.926499f,  0.926571f,  0.926643f,  0.926715f,
	 0.926787f,  0.926859f,  0.926931f,  0.927003f,  0.927075f,  0.927147f,  0.927219f,  0.927291f,
	 0.927363f,  0.927434f,  0.927506f,  0.927578f,  0.927649f,  0.927721f,  0.927792f,  0.927864f,
	 0.927935f,  0.928007f,  0.928078f,  0.928150f,  0.928221f,  0.928292f,  0.928364f,  0.928435f,
	 0.928506f,  0.928577f,  0.928648f,  0.928720f,  0.928791f,  0.928862f,  0.928933f,  0.929004f,
	 0.929075f,  0.929146f,  0.929216f,  0.929287f,  0.929358f,  0.929429f,  0.929500f,  0.929570f,
	 0.929641f,  0.929712f,  0.929782f,  0.929853f,  0.929923f,  0.929994f,  0.930064f,  0.930135f,
	 0.930205f,  0.930275f,  0.930346f,  0.930416f,  0.930486f,  0.930556f,  0.930627f,  0.930697f,
	 0.930767f,  0.930837f,  0.930907f,  0.930977f,  0.931047f,  0.931117f,  0.931187f,  0.931257f,
	 0.931327f,  0.931397f,  0.931466f,  0.931536f,  0.931606f,  0.931675f,  0.931745f,  0.931815f,
	 0.931884f,  0.931954f,  0.932023f,  0.932093f,  0.932162f,  0.932232f,  0.932301f,  0.932370f,
	 0.932440f,  0.932509f,  0.932578f,  0.932647f,  0.932716f,  0.932786f,  0.932855f,  0.932924f,
	 0.932993f,  0.933062f,  0.933131f,  0.933200f,  0.933269f,  0.933337f,  0.933406f,  0.933475f,
	 0.933544f,  0.933612f,  0.933681f,  0.933750f,  0.933818f,  0.933887f,  0.933956f,  0.934024f,
	 0.934093f,  0.934161f,  0.934229f,  0.934298f,  0.934366f,  0.934434f,  0.934503f,  0.934571f,
	 0.934639f,  0.934707f,  0.934775f,  0.934844f,  0.934912f,  0.934980f,  0.935048f,  0.935116f,
	 0.935184f,  0.935251f,  0.935319f,  0.935387f,  0.935455f,  0.935523f,  0.935590f,  0.935658f,
	 0.935726f,  0.935793f,  0.935861f,  0.935928f,  0.935996f,  0.936063f,  0.936131f,  0.936198f,
	 0.936266f,  0.936333f,  0.936400f,  0.936468f,  0.936535f,  0.936602f,  0.936669f,  0.936736f,
	 0.936803f,  0.936871f,  0.936938f,  0.937005f,  0.937072f,  0.937138f,  0.937205f,  0.937272f,
	 0.937339f,  0.937406f,  0.937473f,  0.937539f,  0.937606f,  0.937673f,  0.937739f,  0.937806f,
	 0.937872f,  0.937939f,  0.938005f,  0.938072f,  0.938138f,  0.938205f,  0.938271f,  0.938337f,
	 0.938404f,  0.938470f,  0.938536f,  0.938602f,  0.938668f,  0.938734f,  0.938800f,  0.938866f,
	 0.938932f,  0.938998f,  0.939064f,  0.939130f,  0.939196f,  0.939262f,  0.939328f,  0.939394f,
	 0.939459f,  0.939525f,  0.939591f,  0.939656f,  0.939722f,  0.939787f,  0.939853f,  0.939918f,
	 0.939984f,  0.940049f,  0.940115f,  0.940180f,  0.940245f,  0.940310f,  0.940376f,  0.940441f,
	 0.940506f,  0.940571f,  0.940636f,  0.940701f,  0.940766f,  0.940831f,  0.940896f,  0.940961f,
	 0.941026f,  0.941091f,  0.941156f,  0.941221f,  0.941285f,  0.941350f,  0.941415f,  0.941479f,
	 0.941544f,  0.941609f,  0.941673f,  0.941738f,  0.941802f,  0.941867f,  0.941931f,  0.941995f,
	 0.942060f,  0.942124f,  0.942188f,  0.942253f,  0.942317f,  0.942381f,  0.942445f,  0.942509f,
	 0.942573f,  0.942637f,  0.942701f,  0.942765f,  0.942829f,  0.942893f,  0.942957f,  0.943021f,
	 0.943084f,  0.943148f,  0.943212f,  0.943276f,  0.943339f,  0.943403f,  0.943466f,  0.943530f,
	 0.943593f,  0.943657f,  0.943720f,  0.943784f,  0.943847f,  0.943910f,  0.943974f,  0.944037f,
	 0.944100f,  0.944163f,  0.944227f,  0.944290f,  0.944353f,  0.944416f,  0.944479f,  0.944542f,
	 0.944605f,  0.944668f,  0.944731f,  0.944793f,  0.944856f,  0.944919f,  0.944982f,  0.945045f,
	 0.945107f,  0.945170f,  0.945232f,  0.945295f,  0.945358f,  0.945420f,  0.945482f,  0.945545f,
	 0.945607f,  0.945670f,  0.945732f,  0.945794f,  0.945857f,  0.945919f,  0.945981f,  0.946043f,
	 0.946105f,  0.946167f,  0.946229f,  0.946291f,  0.946353f,  0.946415f,  0.946477f,  0.946539f,
	 0.946601f,  0.946663f,  0.946724f,  0.946786f,  0.946848f,  0.946910f,  0.946971f,  0.947033f,
	 0.947094f,  0.947156f,  0.947217f,  0.947279f,  0.947340f,  0.947402f,  0.947463f,  0.947524f,
	 0.947586f,  0.947647f,  0.947708f,  0.947769f,  0.947830f,  0.947891f,  0.947953f,  0.948014f,
	 0.948075f,  0.948136f,  0.948196f,  0.948257f,  0.948318f,  0.948379f,  0.948440f,  0.948501f,
	 0.948561f,  0.948622f,  0.948683f,  0.948743f,  0.948804f,  0.948864f,  0.948925f,  0.948985f,
	 0.949046f,  0.949106f,  0.949167f,  0.949227f,  0.949287f,  0.949348f,  0.949408f,  0.949468f,
	 0.949528f,  0.949588f,  0.949648f,  0.949708f,  0.949768f,  0.949829f,  0.949888f,  0.949948f,
	 0.950008f,  0.950068f,  0.950128f,  0.950188f,  0.950247f,  0.950307f,  0.950367f,  0.950426f,
	 0.950486f,  0.950546f,  0.950605f,  0.950665f,  0.950724f,  0.950784f,  0.950843f,  0.950902f,
	 0.950962f,  0.951021f,  0.951080f,  0.951139f,  0.951199f,  0.951258f,  0.951317f,  0.951376f,
	 0.951435f,  0.951494f,  0.951553f,  0.951612f,  0.951671f,  0.951730f,  0.951789f,  0.951847f,
	 0.951906f,  0.951965f,  0.952024f,  0.952082f,  0.952141f,  0.952199f,  0.952258f,  0.952317f,
	 0.952375f,  0.952433f,  0.952492f,  0.952550f,  0.952609f,  0.952667f,  0.952725f,  0.952783f,
	 0.952842f,  0.952900f,  0.952958f,  0.953016f,  0.953074f,  0.953132f,  0.953190f,  0.953248f,
	 0.953306f,  0.953364f,  0.953422f,  0.953480f,  0.953537f,  0.953595f,  0.953653f,  0.953711f,
	 0.953768f,  0.953826f,  0.953883f,  0.953941f,  0.953998f,  0.954056f,  0.954113f,  0.954171f,
	 0.954228f,  0.954285f,  0.954343f,  0.954400f,  0.954457f,  0.954514f,  0.954572f,  0.954629f,
	 0.954686f,  0.954743f,  0.954800f,  0.954857f,  0.954914f,  0.954971f,  0.955028f,  0.955084f,
	 0.955141f,  0.955198f,  0.955255f,  0.955311f,  0.955368f,  0.955425f,  0.955481f,  0.955538f,
	 0.955594f,  0.955651f,  0.955707f,  0.955764f,  0.955820f,  0.955876f,  0.955933f,  0.955989f,
	 0.956045f,  0.956101f,  0.956158f,  0.956214f,  0.956270f,  0.956326f,  0.956382f,  0.956438f,
	 0.956494f,  0.956550f,  0.956606f,  0.956662f,  0.956717f,  0.956773f,  0.956829f,  0.956885f,
	 0.956940f,  0.956996f,  0.957052f,  0.957107f,  0.957163f,  0.957218f,  0.957274f,  0.957329f,
	 0.957385f,  0.957440f,  0.957495f,  0.957550f,  0.957606f,  0.957661f,  0.957716f,  0.957771f,
	 0.957826f,  0.957882f,  0.957937f,  0.957992f,  0.958046f,  0.958101f,  0.958156f,  0.958211f,
	 0.958266f,  0.958321f,  0.958376f,  0.958430f,  0.958485f,  0.958540f,  0.958594f,  0.958649f,
	 0.958703f,  0.958758f,  0.958812f,  0.958867f,  0.958921f,  0.958976f,  0.959030f,  0.959084f,
	 0.959139f,  0.959193f,  0.959247f,  0.959301f,  0.959355f,  0.959409f,  0.959463f,  0.959518f,
	 0.959572f,  0.959625f,  0.959679f,  0.959733f,  0.959787f,  0.959841f,  0.959895f,  0.959948f,
	 0.960002f,  0.960056f,  0.960109f,  0.960163f,  0.960217f,  0.960270f,  0.960324f,  0.960377f,
	 0.960431f,  0.960484f,  0.960537f,  0.960591f,  0.960644f,  0.960697f,  0.960750f,  0.960804f,
	 0.960857f,  0.960910f,  0.960963f,  0.961016f,  0.961069f,  0.961122f,  0.961175f,  0.961228f,
	 0.961280f,  0.961333f,  0.961386f,  0.961439f,  0.961492f,  0.961544f,  0.961597f,  0.961649f,
	 0.961702f,  0.961755f,  0.961807f,  0.961860f,  0.961912f,  0.961964f,  0.962017f,  0.962069f,
	 0.962121f,  0.962174f,  0.962226f,  0.962278f,  0.962330f,  0.962382f,  0.962434f,  0.962486f,
	 0.962538f,  0.962590f,  0.962642f,  0.962694f,  0.962746f,  0.962798f,  0.962850f,  0.962902f,
	 0.962953f,  0.963005f,  0.963057f,  0.963108f,  0.963160f,  0.963211f,  0.963263f,  0.963314f,
	 0.963366f,  0.963417f,  0.963469f,  0.963520f,  0.963571f,  0.963623f,  0.963674f,  0.963725f,
	 0.963776f,  0.963827f,  0.963878f,  0.963929f,  0.963980f,  0.964031f,  0.964082f,  0.964133f,
	 0.964184f,  0.964235f,  0.964286f,  0.964336f,  0.964387f,  0.964438f,  0.964489f,  0.964539f,
	 0.964590f,  0.964640f,  0.964691f,  0.964741f,  0.964792f,  0.964842f,  0.964893f,  0.964943f,
	 0.964993f,  0.965044f,  0.965094f,  0.965144f,  0.965194f,  0.965244f,  0.965294f,  0.965344f,
	 0.965394f,  0.965444f,  0.965494f,  0.965544f,  0.965594f,  0.965644f,  0.965694f,  0.965744f,
	 0.965793f,  0.965843f,  0.965893f,  0.965942f,  0.965992f,  0.966042f,  0.966091f,  0.966141f,
	 0.966190f,  0.966239f,  0.966289f,  0.966338f,  0.966387f,  0.966437f,  0.966486f,  0.966535f,
	 0.966584f,  0.966633f,  0.966683f,  0.966732f,  0.966781f,  0.966830f,  0.966879f,  0.966928f,
	 0.966976f,  0.967025f,  0.967074f,  0.967123f,  0.967172f,  0.967220f,  0.967269f,  0.967318f,
	 0.967366f,  0.967415f,  0.967463f,  0.967512f,  0.967560f,  0.967609f,  0.967657f,  0.967706f,
	 0.967754f,  0.967802f,  0.967850f,  0.967899f,  0.967947f,  0.967995f,  0.968043f,  0.968091f,
	 0.968139f,  0.968187f,  0.968235f,  0.968283f,  0.968331f,  0.968379f,  0.968427f,  0.968474f,
	 0.968522f,  0.968570f,  0.968617f,  0.968665f,  0.968713f,  0.968760f,  0.968808f,  0.968855f,
	 0.968903f,  0.968950f,  0.968998f,  0.969045f,  0.969092f,  0.969140f,  0.969187f,  0.969234f,
	 0.969281f,  0.969328f,  0.969375f,  0.969423f,  0.969470f,  0.969517f,  0.969564f,  0.969611f,
	 0.969657f,  0.969704f,  0.969751f,  0.969798f,  0.969845f,  0.969891f,  0.969938f,  0.969985f,
	 0.970031f,  0.970078f,  0.970124f,  0.970171f,  0.970217f,  0.970264f,  0.970310f,  0.970357f,
	 0.970403f,  0.970449f,  0.970495f,  0.970542f,  0.970588f,  0.970634f,  0.970680f,  0.970726f,
	 0.970772f,  0.970818f,  0.970864f,  0.970910f,  0.970956f,  0.971002f,  0.971048f,  0.971093f,
	 0.971139f,  0.971185f,  0.971231f,  0.971276f,  0.971322f,  0.971367f,  0.971413f,  0.971458f,
	 0.971504f,  0.971549f,  0.971595f,  0.971640f,  0.971685f,  0.971731f,  0.971776f,  0.971821f,
	 0.971866f,  0.971911f,  0.971957f,  0.972002f,  0.972047f,  0.972092f,  0.972137f,  0.972182f,
	 0.972227f,  0.972271f,  0.972316f,  0.972361f,  0.972406f,  0.972450f,  0.972495f,  0.972540f,
	 0.972584f,  0.972629f,  0.972673f,  0.972718f,  0.972762f,  0.972807f,  0.972851f,  0.972896f,
	 0.972940f,  0.972984f,  0.973028f,  0.973073f,  0.973117f,  0.973161f,  0.973205f,  0.973249f,
	 0.973293f,  0.973337f,  0.973381f,  0.973425f,  0.973469f,  0.973513f,  0.973557f,  0.973601f,
	 0.973644f,  0.973688f,  0.973732f,  0.973775f,  0.973819f,  0.973862f,  0.973906f,  0.973949f,
	 0.973993f,  0.974036f,  0.974080f,  0.974123f,  0.974166f,  0.974210f,  0.974253f,  0.974296f,
	 0.974339f,  0.974383f,  0.974426f,  0.974469f,  0.974512f,  0.974555f,  0.974598f,  0.974641f,
	 0.974684f,  0.974726f,  0.974769f,  0.974812f,  0.974855f,  0.974897f,  0.974940f,  0.974983f,
	 0.975025f,  0.975068f,  0.975110f,  0.975153f,  0.975195f,  0.975238f,  0.975280f,  0.975323f,
	 0.975365f,  0.975407f,  0.975449f,  0.975492f,  0.975534f,  0.975576f,  0.975618f,  0.975660f,
	 0.975702f,  0.975744f,  0.975786f,  0.975828f,  0.975870f,  0.975912f,  0.975954f,  0.975995f,
	 0.976037f,  0.976079f,  0.976120f,  0.976162f,  0.976204f,  0.976245f,  0.976287f,  0.976328f,
	 0.976370f,  0.976411f,  0.976453f,  0.976494f,  0.976535f,  0.976576f,  0.976618f,  0.976659f,
	 0.976700f,  0.976741f,  0.976782f,  0.976823f,  0.976864f,  0.976905f,  0.976946f,  0.976987f,
	 0.977028f,  0.977069f,  0.977110f,  0.977151f,  0.977191f,  0.977232f,  0.977273f,  0.977313f,
	 0.977354f,  0.977394f,  0.977435f,  0.977475f,  0.977516f,  0.977556f,  0.977597f,  0.977637f,
	 0.977677f,  0.977718f,  0.977758f,  0.977798f,  0.977838f,  0.977878f,  0.977918f,  0.977959f,
	 0.977998f,  0.978038f,  0.978078f,  0.978118f,  0.978158f,  0.978198f,  0.978238f,  0.978278f,
	 0.978317f,  0.978357f,  0.978397f,  0.978436f,  0.978476f,  0.978516f,  0.978555f,  0.978594f,
	 0.978634f,  0.978673f,  0.978713f,  0.978752f,  0.978791f,  0.978831f,  0.978870f,  0.978909f,
	 0.978948f,  0.978987f,  0.979026f,  0.979065f,  0.979104f,  0.979143f,  0.979182f,  0.979221f,
	 0.979260f,  0.979299f,  0.979338f,  0.979376f,  0.979415f,  0.979454f,  0.979493f,  0.979531f,
	 0.979570f,  0.979608f,  0.979647f,  0.979685f,  0.979724f,  0.979762f,  0.979800f,  0.979839f,
	 0.979877f,  0.979915f,  0.979954f,  0.979992f,  0.980030f,  0.980068f,  0.980106f,  0.980144f,
	 0.980182f,  0.980220f,  0.980258f,  0.980296f,  0.980334f,  0.980372f,  0.980409f,  0.980447f,
	 0.980485f,  0.980523f,  0.980560f,  0.980598f,  0.980635f,  0.980673f,  0.980710f,  0.980748f,
	 0.980785f,  0.980823f,  0.980860f,  0.980897f,  0.980935f,  0.980972f,  0.981009f,  0.981046f,
	 0.981083f,  0.981120f,  0.981158f,  0.981195f,  0.981232f,  0.981269f,  0.981305f,  0.981342f,
	 0.981379f,  0.981416f,  0.981453f,  0.981490f,  0.981526f,  0.981563f,  0.981600f,  0.981636f,
	 0.981673f,  0.981709f,  0.981746f,  0.981782f,  0.981819f,  0.981855f,  0.981891f,  0.981928f,
	 0.981964f,  0.982000f,  0.982036f,  0.982072f,  0.982109f,  0.982145f,  0.982181f,  0.982217f,
	 0.982253f,  0.982289f,  0.982325f,  0.982360f,  0.982396f,  0.982432f,  0.982468f,  0.982504f,
	 0.982539f,  0.982575f,  0.982611f,  0.982646f,  0.982682f,  0.982717f,  0.982753f,  0.982788f,
	 0.982824f,  0.982859f,  0.982894f,  0.982930f,  0.982965f,  0.983000f,  0.983035f,  0.983070f,
	 0.983105f,  0.983141f,  0.983176f,  0.983211f,  0.983246f,  0.983281f,  0.983315f,  0.983350f,
	 0.983385f,  0.983420f,  0.983455f,  0.983489f,  0.983524f,  0.983559f,  0.983593f,  0.983628f,
	 0.983662f,  0.983697f,  0.983731f,  0.983766f,  0.983800f,  0.983835f,  0.983869f,  0.983903f,
	 0.983937f,  0.983972f,  0.984006f,  0.984040f,  0.984074f,  0.984108f,  0.984142f,  0.984176f,
	 0.984210f,  0.984244f,  0.984278f,  0.984312f,  0.984346f,  0.984379f,  0.984413f,  0.984447f,
	 0.984480f,  0.984514f,  0.984548f,  0.984581f,  0.984615f,  0.984648f,  0.984682f,  0.984715f,
	 0.984748f,  0.984782f,  0.984815f,  0.984848f,  0.984882f,  0.984915f,  0.984948f,  0.984981f,
	 0.985014f,  0.985047f,  0.985080f,  0.985113f,  0.985146f,  0.985179f,  0.985212f,  0.985245f,
	 0.985278f,  0.985310f,  0.985343f,  0.985376f,  0.985408f,  0.985441f,  0.985474f,  0.985506f,
	 0.985539f,  0.985571f,  0.985604f,  0.985636f,  0.985668f,  0.985701f,  0.985733f,  0.985765f,
	 0.985798f,  0.985830f,  0.985862f,  0.985894f,  0.985926f,  0.985958f,  0.985990f,  0.986022f,
	 0.986054f,  0.986086f,  0.986118f,  0.986150f,  0.986181f,  0.986213f,  0.986245f,  0.986276f,
	 0.986308f,  0.986340f,  0.986371f,  0.986403f,  0.986434f,  0.986466f,  0.986497f,  0.986529f,
	 0.986560f,  0.986591f,  0.986623f,  0.986654f,  0.986685f,  0.986716f,  0.986747f,  0.986778f,
	 0.986809f,  0.986840f,  0.986871f,  0.986902f,  0.986933f,  0.986964f,  0.986995f,  0.987026f,
	 0.987057f,  0.987087f,  0.987118f,  0.987149f,  0.987179f,  0.987210f,  0.987240f,  0.987271f,
	 0.987301f,  0.987332f,  0.987362f,  0.987393f,  0.987423f,  0.987453f,  0.987484f,  0.987514f,
	 0.987544f,  0.987574f,  0.987604f,  0.987634f,  0.987664f,  0.987694f,  0.987724f,  0.987754f,
	 0.987784f,  0.987814f,  0.987844f,  0.987874f,  0.987903f,  0.987933f,  0.987963f,  0.987992f,
	 0.988022f,  0.988052f,  0.988081f,  0.988111f,  0.988140f,  0.988169f,  0.988199f,  0.988228f,
	 0.988258f,  0.988287f,  0.988316f,  0.988345f,  0.988374f,  0.988404f,  0.988433f,  0.988462f,
	 0.988491f,  0.988520f,  0.988549f,  0.988578f,  0.988607f,  0.988635f,  0.988664f,  0.988693f,
	 0.988722f,  0.988750f,  0.988779f,  0.988808f,  0.988836f,  0.988865f,  0.988893f,  0.988922f,
	 0.988950f,  0.988979f,  0.989007f,  0.989035f,  0.989064f,  0.989092f,  0.989120f,  0.989148f,
	 0.989177f,  0.989205f,  0.989233f,  0.989261f,  0.989289f,  0.989317f,  0.989345f,  0.989373f,
	 0.989400f,  0.989428f,  0.989456f,  0.989484f,  0.989511f,  0.989539f,  0.989567f,  0.989594f,
	 0.989622f,  0.989650f,  0.989677f,  0.989704f,  0.989732f,  0.989759f,  0.989787f,  0.989814f,
	 0.989841f,  0.989869f,  0.989896f,  0.989923f,  0.989950f,  0.989977f,  0.990004f,  0.990031f,
	 0.990058f,  0.990085f,  0.990112f,  0.990139f,  0.990166f,  0.990193f,  0.990219f,  0.990246f,
	 0.990273f,  0.990299f,  0.990326f,  0.990353f,  0.990379f,  0.990406f,  0.990432f,  0.990459f,
	 0.990485f,  0.990511f,  0.990538f,  0.990564f,  0.990590f,  0.990617f,  0.990643f,  0.990669f,
	 0.990695f,  0.990721f,  0.990747f,  0.990773f,  0.990799f,  0.990825f,  0.990851f,  0.990877f,
	 0.990903f,  0.990928f,  0.990954f,  0.990980f,  0.991006f,  0.991031f,  0.991057f,  0.991082f,
	 0.991108f,  0.991133f,  0.991159f,  0.991184f,  0.991210f,  0.991235f,  0.991260f,  0.991286f,
	 0.991311f,  0.991336f,  0.991361f,  0.991386f,  0.991411f,  0.991437f,  0.991462f,  0.991487f,
	 0.991511f,  0.991536f,  0.991561f,  0.991586f,  0.991611f,  0.991636f,  0.991660f,  0.991685f,
	 0.991710f,  0.991734f,  0.991759f,  0.991783f,  0.991808f,  0.991832f,  0.991857f,  0.991881f,
	 0.991906f,  0.991930f,  0.991954f,  0.991979f,  0.992003f,  0.992027f,  0.992051f,  0.992075f,
	 0.992099f,  0.992123f,  0.992147f,  0.992171f,  0.992195f,  0.992219f,  0.992243f,  0.992267f,
	 0.992291f,  0.992314f,  0.992338f,  0.992362f,  0.992385f,  0.992409f,  0.992433f,  0.992456f,
	 0.992480f,  0.992503f,  0.992526f,  0.992550f,  0.992573f,  0.992596f,  0.992620f,  0.992643f,
	 0.992666f,  0.992689f,  0.992712f,  0.992736f,  0.992759f,  0.992782f,  0.992805f,  0.992828f,
	 0.992850f,  0.992873f,  0.992896f,  0.992919f,  0.992942f,  0.992964f,  0.992987f,  0.993010f,
	 0.993032f,  0.993055f,  0.993077f,  0.993100f,  0.993122f,  0.993145f,  0.993167f,  0.993190f,
	 0.993212f,  0.993234f,  0.993257f,  0.993279f,  0.993301f,  0.993323f,  0.993345f,  0.993367f,
	 0.993389f,  0.993411f,  0.993433f,  0.993455f,  0.993477f,  0.993499f,  0.993521f,  0.993542f,
	 0.993564f,  0.993586f,  0.993608f,  0.993629f,  0.993651f,  0.993672f,  0.993694f,  0.993715f,
	 0.993737f,  0.993758f,  0.993779f,  0.993801f,  0.993822f,  0.993843f,  0.993865f,  0.993886f,
	 0.993907f,  0.993928f,  0.993949f,  0.993970f,  0.993991f,  0.994012f,  0.994033f,  0.994054f,
	 0.994075f,  0.994096f,  0.994116f,  0.994137f,  0.994158f,  0.994179f,  0.994199f,  0.994220f,
	 0.994240f,  0.994261f,  0.994281f,  0.994302f,  0.994322f,  0.994343f,  0.994363f,  0.994383f,
	 0.994404f,  0.994424f,  0.994444f,  0.994464f,  0.994484f,  0.994505f,  0.994525f,  0.994545f,
	 0.994565f,  0.994585f,  0.994604f,  0.994624f,  0.994644f,  0.994664f,  0.994684f,  0.994703f,
	 0.994723f,  0.994743f,  0.994762f,  0.994782f,  0.994802f,  0.994821f,  0.994841f,  0.994860f,
	 0.994879f,  0.994899f,  0.994918f,  0.994937f,  0.994957f,  0.994976f,  0.994995f,  0.995014f,
	 0.995033f,  0.995052f,  0.995071f,  0.995090f,  0.995109f,  0.995128f,  0.995147f,  0.995166f,
	 0.995185f,  0.995203f,  0.995222f,  0.995241f,  0.995260f,  0.995278f,  0.995297f,  0.995315f,
	 0.995334f,  0.995352f,  0.995371f,  0.995389f,  0.995408f,  0.995426f,  0.995444f,  0.995463f,
	 0.995481f,  0.995499f,  0.995517f,  0.995535f,  0.995553f,  0.995571f,  0.995589f,  0.995607f,
	 0.995625f,  0.995643f,  0.995661f,  0.995679f,  0.995697f,  0.995714f,  0.995732f,  0.995750f,
	 0.995767f,  0.995785f,  0.995803f,  0.995820f,  0.995838f,  0.995855f,  0.995872f,  0.995890f,
	 0.995907f,  0.995925f,  0.995942f,  0.995959f,  0.995976f,  0.995993f,  0.996011f,  0.996028f,
	 0.996045f,  0.996062f,  0.996079f,  0.996096f,  0.996113f,  0.996129f,  0.996146f,  0.996163f,
	 0.996180f,  0.996197f,  0.996213f,  0.996230f,  0.996247f,  0.996263f,  0.996280f,  0.996296f,
	 0.996313f,  0.996329f,  0.996345f,  0.996362f,  0.996378f,  0.996394f,  0.996411f,  0.996427f,
	 0.996443f,  0.996459f,  0.996475f,  0.996491f,  0.996507f,  0.996523f,  0.996539f,  0.996555f,
	 0.996571f,  0.996587f,  0.996603f,  0.996619f,  0.996634f,  0.996650f,  0.996666f,  0.996681f,
	 0.996697f,  0.996712f,  0.996728f,  0.996743f,  0.996759f,  0.996774f,  0.996790f,  0.996805f,
	 0.996820f,  0.996836f,  0.996851f,  0.996866f,  0.996881f,  0.996896f,  0.996911f,  0.996926f,
	 0.996941f,  0.996956f,  0.996971f,  0.996986f,  0.997001f,  0.997016f,  0.997031f,  0.997045f,
	 0.997060f,  0.997075f,  0.997089f,  0.997104f,  0.997119f,  0.997133f,  0.997148f,  0.997162f,
	 0.997176f,  0.997191f,  0.997205f,  0.997219f,  0.997234f,  0.997248f,  0.997262f,  0.997276f,
	 0.997290f,  0.997305f,  0.997319f,  0.997333f,  0.997347f,  0.997361f,  0.997374f,  0.997388f,
	 0.997402f,  0.997416f,  0.997430f,  0.997443f,  0.997457f,  0.997471f,  0.997484f,  0.997498f,
	 0.997511f,  0.997525f,  0.997538f,  0.997552f,  0.997565f,  0.997579f,  0.997592f,  0.997605f,
	 0.997618f,  0.997632f,  0.997645f,  0.997658f,  0.997671f,  0.997684f,  0.997697f,  0.997710f,
	 0.997723f,  0.997736f,  0.997749f,  0.997762f,  0.997774f,  0.997787f,  0.997800f,  0.997813f,
	 0.997825f,  0.997838f,  0.997851f,  0.997863f,  0.997876f,  0.997888f,  0.997901f,  0.997913f,
	 0.997925f,  0.997938f,  0.997950f,  0.997962f,  0.997974f,  0.997987f,  0.997999f,  0.998011f,
	 0.998023f,  0.998035f,  0.998047f,  0.998059f,  0.998071f,  0.998083f,  0.998094f,  0.998106f,
	 0.998118f,  0.998130f,  0.998142f,  0.998153f,  0.998165f,  0.998176f,  0.998188f,  0.998200f,
	 0.998211f,  0.998222f,  0.998234f,  0.998245f,  0.998257f,  0.998268f,  0.998279f,  0.998290f,
	 0.998302f,  0.998313f,  0.998324f,  0.998335f,  0.998346f,  0.998357f,  0.998368f,  0.998379f,
	 0.998390f,  0.998401f,  0.998411f,  0.998422f,  0.998433f,  0.998444f,  0.998454f,  0.998465f,
	 0.998476f,  0.998486f,  0.998497f,  0.998507f,  0.998518f,  0.998528f,  0.998538f,  0.998549f,
	 0.998559f,  0.998569f,  0.998580f,  0.998590f,  0.998600f,  0.998610f,  0.998620f,  0.998630f,
	 0.998640f,  0.998650f,  0.998660f,  0.998670f,  0.998680f,  0.998690f,  0.998700f,  0.998709f,
	 0.998719f,  0.998729f,  0.998738f,  0.998748f,  0.998758f,  0.998767f,  0.998777f,  0.998786f,
	 0.998795f,  0.998805f,  0.998814f,  0.998824f,  0.998833f,  0.998842f,  0.998851f,  0.998860f,
	 0.998870f,  0.998879f,  0.998888f,  0.998897f,  0.998906f,  0.998915f,  0.998924f,  0.998932f,
	 0.998941f,  0.998950f,  0.998959f,  0.998968f,  0.998976f,  0.998985f,  0.998994f,  0.999002f,
	 0.999011f,  0.999019f,  0.999028f,  0.999036f,  0.999044f,  0.999053f,  0.999061f,  0.999069f,
	 0.999078f,  0.999086f,  0.999094f,  0.999102f,  0.999110f,  0.999118f,  0.999126f,  0.999134f,
	 0.999142f,  0.999150f,  0.999158f,  0.999166f,  0.999174f,  0.999182f,  0.999189f,  0.999197f,
	 0.999205f,  0.999212f,  0.999220f,  0.999228f,  0.999235f,  0.999243f,  0.999250f,  0.999257f,
	 0.999265f,  0.999272f,  0.999279f,  0.999287f,  0.999294f,  0.999301f,  0.999308f,  0.999315f,
	 0.999322f,  0.999329f,  0.999336f,  0.999343f,  0.999350f,  0.999357f,  0.999364f,  0.999371f,
	 0.999378f,  0.999384f,  0.999391f,  0.999398f,  0.999404f,  0.999411f,  0.999418f,  0.999424f,
	 0.999431f,  0.999437f,  0.999443f,  0.999450f,  0.999456f,  0.999462f,  0.999469f,  0.999475f,
	 0.999481f,  0.999487f,  0.999493f,  0.999500f,  0.999506f,  0.999512f,  0.999518f,  0.999524f,
	 0.999529f,  0.999535f,  0.999541f,  0.999547f,  0.999553f,  0.999558f,  0.999564f,  0.999570f,
	 0.999575f,  0.999581f,  0.999586f,  0.999592f,  0.999597f,  0.999603f,  0.999608f,  0.999614f,
	 0.999619f,  0.999624f,  0.999629f,  0.999635f,  0.999640f,  0.999645f,  0.999650f,  0.999655f,
	 0.999660f,  0.999665f,  0.999670f,  0.999675f,  0.999680f,  0.999685f,  0.999689f,  0.999694f,
	 0.999699f,  0.999704f,  0.999708f,  0.999713f,  0.999717f,  0.999722f,  0.999726f,  0.999731f,
	 0.999735f,  0.999740f,  0.999744f,  0.999748f,  0.999753f,  0.999757f,  0.999761f,  0.999765f,
	 0.999769f,  0.999774f,  0.999778f,  0.999782f,  0.999786f,  0.999790f,  0.999793f,  0.999797f,
	 0.999801f,  0.999805f,  0.999809f,  0.999812f,  0.999816f,  0.999820f,  0.999823f,  0.999827f,
	 0.999831f,  0.999834f,  0.999838f,  0.999841f,  0.999844f,  0.999848f,  0.999851f,  0.999854f,
	 0.999858f,  0.999861f,  0.999864f,  0.999867f,  0.999870f,  0.999873f,  0.999876f,  0.999879f,
	 0.999882f,  0.999885f,  0.999888f,  0.999891f,  0.999894f,  0.999897f,  0.999899f,  0.999902f,
	 0.999905f,  0.999907f,  0.999910f,  0.999913f,  0.999915f,  0.999917f,  0.999920f,  0.999922f,
	 0.999925f,  0.999927f,  0.999929f,  0.999932f,  0.999934f,  0.999936f,  0.999938f,  0.999940f,
	 0.999942f,  0.999944f,  0.999946f,  0.999948f,  0.999950f,  0.999952f,  0.999954f,  0.999956f,
	 0.999958f,  0.999959f,  0.999961f,  0.999963f,  0.999964f,  0.999966f,  0.999968f,  0.999969f,
	 0.999971f,  0.999972f,  0.999973f,  0.999975f,  0.999976f,  0.999977f,  0.999979f,  0.999980f,
	 0.999981f,  0.999982f,  0.999983f,  0.999985f,  0.999986f,  0.999987f,  0.999988f,  0.999988f,
	 0.999989f,  0.999990f,  0.999991f,  0.999992f,  0.999993f,  0.999993f,  0.999994f,  0.999995f,
	 0.999995f,  0.999996f,  0.999996f,  0.999997f,  0.999997f,  0.999998f,  0.999998f,  0.999999f,
	 0.999999f,  0.999999f,  0.999999f,  1.000000f,  1.000000f,  1.000000f,  1.000000f,  1.000000f,
	 0.000000f, -0.000192f, -0.000383f, -0.000575f, -0.000767f, -0.000959f, -0.001150f, -0.001342f,
	-0.001534f, -0.001726f, -0.001917f, -0.002109f, -0.002301f, -0.002493f, -0.002684f, -0.002876f,
	-0.003068f, -0.003260f, -0.003451f, -0.003643f, -0.003835f, -0.004027f, -0.004218f, -0.004410f,
	-0.004602f, -0.004794f, -0.004985f, -0.005177f, -0.005369f, -0.005561f, -0.005752f, -0.005944f,
	-0.006136f, -0.006328f, -0.006519f, -0.006711f, -0.006903f, -0.007095f, -0.007286f, -0.007478f,
	-0.007670f, -0.007862f, -0.008053f, -0.008245f, -0.008437f, -0.008629f, -0.008820f, -0.009012f,
	-0.009204f, -0.009395f, -0.009587f, -0.009779f, -0.009971f, -0.010162f, -0.010354f, -0.010546f,
	-0.010738f, -0.010929f, -0.011121f, -0.011313f, -0.011505f, -0.011696f, -0.011888f, -0.012080f,
	-0.012272f, -0.012463f, -0.012655f, -0.012847f, -0.013038f, -0.013230f, -0.013422f, -0.013614f,
	-0.013805f, -0.013997f, -0.014189f, -0.014381f, -0.014572f, -0.014764f, -0.014956f, -0.015147f,
	-0.015339f, -0.015531f, -0.015723f, -0.015914f, -0.016106f, -0.016298f, -0.016490f, -0.016681f,
	-0.016873f, -0.017065f, -0.017256f, -0.017448f, -0.017640f, -0.017832f, -0.018023f, -0.018215f,
	-0.018407f, -0.018598f, -0.018790f, -0.018982f, -0.019174f, -0.019365f, -0.019557f, -0.019749f,
	-0.019940f, -0.020132f, -0.020324f, -0.020516f, -0.020707f, -0.020899f, -0.021091f, -0.021282f,
	-0.021474f, -0.021666f, -0.021857f, -0.022049f, -0.022241f, -0.022433f, -0.022624f, -0.022816f,
	-0.023008f, -0.023199f, -0.023391f, -0.023583f, -0.023774f, -0.023966f, -0.024158f, -0.024350f,
	-0.024541f, -0.024733f, -0.024925f, -0.025116f, -0.025308f, -0.025500f, -0.025691f, -0.025883f,
	-0.026075f, -0.026266f, -0.026458f, -0.026650f, -0.026841f, -0.027033f, -0.027225f, -0.027416f,
	-0.027608f, -0.027800f, -0.027991f, -0.028183f, -0.028375f, -0.028567f, -0.028758f, -0.028950f,
	-0.029142f, -0.029333f, -0.029525f, -0.029717f, -0.029908f, -0.030100f, -0.030291f, -0.030483f,
	-0.030675f, -0.030866f, -0.031058f, -0.031250f, -0.031441f, -0.031633f, -0.031825f, -0.032016f,
	-0.032208f, -0.032400f, -0.032591f, -0.032783f, -0.032975f, -0.033166f, -0.033358f, -0.033550f,
	-0.033741f, -0.033933f, -0.034124f, -0.034316f, -0.034508f, -0.034699f, -0.034891f, -0.035083f,
	-0.035274f, -0.035466f, -0.035657f, -0.035849f, -0.036041f, -0.036232f, -0.036424f, -0.036616f,
	-0.036807f, -0.036999f, -0.037190f, -0.037382f, -0.037574f, -0.037765f, -0.037957f, -0.038149f,
	-0.038340f, -0.038532f, -0.038723f, -0.038915f, -0.039107f, -0.039298f, -0.039490f, -0.039681f,
	-0.039873f, -0.040065f, -0.040256f, -0.040448f, -0.040639f, -0.040831f, -0.041022f, -0.041214f,
	-0.041406f, -0.041597f, -0.041789f, -0.041980f, -0.042172f, -0.042364f, -0.042555f, -0.042747f,
	-0.042938f, -0.043130f, -0.043321f, -0.043513f, -0.043705f, -0.043896f, -0.044088f, -0.044279f,
	-0.044471f, -0.044662f, -0.044854f, -0.045045f, -0.045237f, -0.045429f, -0.045620f, -0.045812f,
	-0.046003f, -0.046195f, -0.046386f, -0.046578f, -0.046769f, -0.046961f, -0.047152f, -0.047344f,
	-0.047535f, -0.047727f, -0.047919f, -0.048110f, -0.048302f, -0.048493f, -0.048685f, -0.048876f,
	-0.049068f, -0.049259f, -0.049451f, -0.049642f, -0.049834f, -0.050025f, -0.050217f, -0.050408f,
	-0.050600f, -0.050791f, -0.050983f, -0.051174f, -0.051366f, -0.051557f, -0.051749f, -0.051940f,
	-0.052132f, -0.052323f, -0.052515f, -0.052706f, -0.052898f, -0.053089f, -0.053281f, -0.053472f,
	-0.053664f, -0.053855f, -0.054046f, -0.054238f, -0.054429f, -0.054621f, -0.054812f, -0.055004f,
	-0.055195f, -0.055387f, -0.055578f, -0.055770f, -0.055961f, -0.056152f, -0.056344f, -0.056535f,
	-0.056727f, -0.056918f, -0.057110f, -0.057301f, -0.057493f, -0.057684f, -0.057875f, -0.058067f,
	-0.058258f, -0.058450f, -0.058641f, -0.058833f, -0.059024f, -0.059215f, -0.059407f, -0.059598f,
	-0.059790f, -0.059981f, -0.060172f, -0.060364f, -0.060555f, -0.060747f, -0.060938f, -0.061129f,
	-0.061321f, -0.061512f, -0.061704f, -0.061895f, -0.062086f, -0.062278f, -0.062469f, -0.062660f,
	-0.062852f, -0.063043f, -0.063234f, -0.063426f, -0.063617f, -0.063809f, -0.064000f, -0.064191f,
	-0.064383f, -0.064574f, -0.064765f, -0.064957f, -0.065148f, -0.065339f, -0.065531f, -0.065722f,
	-0.065913f, -0.066105f, -0.066296f, -0.066487f, -0.066679f, -0.066870f, -0.067061f, -0.067253f,
	-0.067444f, -0.067635f, -0.067827f, -0.068018f, -0.068209f, -0.068400f, -0.068592f, -0.068783f,
	-0.068974f, -0.069166f, -0.069357f, -0.069548f, -0.069739f, -0.069931f, -0.070122f, -0.070313f,
	-0.070505f, -0.070696f, -0.070887f, -0.071078f, -0.071270f, -0.071461f, -0.071652f, -0.071843f,
	-0.072035f, -0.072226f, -0.072417f, -0.072608f, -0.072800f, -0.072991f, -0.073182f, -0.073373f,
	-0.073565f, -0.073756f, -0.073947f, -0.074138f, -0.074329f, -0.074521f, -0.074712f, -0.074903f,
	-0.075094f, -0.075286f, -0.075477f, -0.075668f, -0.075859f, -0.076050f, -0.076241f, -0.076433f,
	-0.076624f, -0.076815f, -0.077006f, -0.077197f, -0.077389f, -0.077580f, -0.077771f, -0.077962f,
	-0.078153f, -0.078344f, -0.078536f, -0.078727f, -0.078918f, -0.079109f, -0.079300f, -0.079491f,
	-0.079682f, -0.079874f, -0.080065f, -0.080256f, -0.080447f, -0.080638f, -0.080829f, -0.081020f,
	-0.081211f, -0.081403f, -0.081594f, -0.081785f, -0.081976f, -0.082167f, -0.082358f, -0.082549f,
	-0.082740f, -0.082931f, -0.083122f, -0.083314f, -0.083505f, -0.083696f, -0.083887f, -0.084078f,
	-0.084269f, -0.084460f, -0.084651f, -0.084842f, -0.085033f, -0.085224f, -0.085415f, -0.085606f,
	-0.085797f, -0.085988f, -0.086179f, -0.086370f, -0.086561f, -0.086752f, -0.086943f, -0.087135f,
	-0.087326f, -0.087517f, -0.087708f, -0.087899f, -0.088090f, -0.088281f, -0.088472f, -0.088663f,
	-0.088854f, -0.089045f, -0.089236f, -0.089427f, -0.089617f, -0.089808f, -0.089999f, -0.090190f,
	-0.090381f, -0.090572f, -0.090763f, -0.090954f, -0.091145f, -0.091336f, -0.091527f, -0.091718f,
	-0.091909f, -0.092100f, -0.092291f, -0.092482f, -0.092673f, -0.092864f, -0.093055f, -0.093245f,
	-0.093436f, -0.093627f, -0.093818f, -0.094009f, -0.094200f, -0.094391f, -0.094582f, -0.094773f,
	-0.094963f, -0.095154f, -0.095345f, -0.095536f, -0.095727f, -0.095918f, -0.096109f, -0.096300f,
	-0.096490f, -0.096681f, -0.096872f, -0.097063f, -0.097254f, -0.097445f, -0.097635f, -0.097826f,
	-0.098017f, -0.098208f, -0.098399f, -0.098590f, -0.098780f, -0.098971f, -0.099162f, -0.099353f,
	-0.099544f, -0.099734f, -0.099925f, -0.100116f, -0.100307f, -0.100498f, -0.100688f, -0.100879f,
	-0.101070f, -0.101261f, -0.101451f, -0.101642f, -0.101833f, -0.102024f, -0.102214f, -0.102405f,
	-0.102596f, -0.102787f, -0.102977f, -0.103168f, -0.103359f, -0.103550f, -0.103740f, -0.103931f,
	-0.104122f, -0.104312f, -0.104503f, -0.104694f, -0.104884f, -0.105075f, -0.105266f, -0.105456f,
	-0.105647f, -0.105838f, -0.106028f, -0.106219f, -0.106410f, -0.106600f, -0.106791f, -0.106982f,
	-0.107172f, -0.107363f, -0.107554f, -0.107744f, -0.107935f, -0.108126f, -0.108316f, -0.108507f,
	-0.108697f, -0.108888f, -0.109079f, -0.109269f, -0.109460f, -0.109650f, -0.109841f, -0.110032f,
	-0.110222f, -0.110413f, -0.110603f, -0.110794f, -0.110984f, -0.111175f, -0.111366f, -0.111556f,
	-0.111747f, -0.111937f, -0.112128f, -0.112318f, -0.112509f, -0.112699f, -0.112890f, -0.113080f,
	-0.113271f, -0.113461f, -0.113652f, -0.113842f, -0.114033f, -0.114223f, -0.114414f, -0.114604f,
	-0.114795f, -0.114985f, -0.115176f, -0.115366f, -0.115557f, -0.115747f, -0.115938f, -0.116128f,
	-0.116319f, -0.116509f, -0.116700f, -0.116890f, -0.117080f, -0.117271f, -0.117461f, -0.117652f,
	-0.117842f, -0.118032f, -0.118223f, -0.118413f, -0.118604f, -0.118794f, -0.118984f, -0.119175f,
	-0.119365f, -0.119556f, -0.119746f, -0.119936f, -0.120127f, -0.120317f, -0.120507f, -0.120698f,
	-0.120888f, -0.121078f, -0.121269f, -0.121459f, -0.121649f, -0.121840f, -0.122030f, -0.122220f,
	-0.122411f, -0.122601f, -0.122791f, -0.122982f, -0.123172f, -0.123362f, -0.123552f, -0.123743f,
	-0.123933f, -0.124123f, -0.124314f, -0.124504f, -0.124694f, -0.124884f, -0.125075f, -0.125265f,
	-0.125455f, -0.125645f, -0.125835f, -0.126026f, -0.126216f, -0.126406f, -0.126596f, -0.126787f,
	-0.126977f, -0.127167f, -0.127357f, -0.127547f, -0.127737f, -0.127928f, -0.128118f, -0.128308f,
	-0.128498f, -0.128688f, -0.128878f, -0.129069f, -0.129259f, -0.129449f, -0.129639f, -0.129829f,
	-0.130019f, -0.130209f, -0.130399f, -0.130590f, -0.130780f, -0.130970f, -0.131160f, -0.131350f,
	-0.131540f, -0.131730f, -0.131920f, -0.132110f, -0.132300f, -0.132490f, -0.132680f, -0.132870f,
	-0.133061f, -0.133251f, -0.133441f, -0.133631f, -0.133821f, -0.134011f, -0.134201f, -0.134391f,
	-0.134581f, -0.134771f, -0.134961f, -0.135151f, -0.135341f, -0.135531f, -0.135721f, -0.135911f,
	-0.136101f, -0.136291f, -0.136480f, -0.136670f, -0.136860f, -0.137050f, -0.137240f, -0.137430f,
	-0.137620f, -0.137810f, -0.138000f, -0.138190f, -0.138380f, -0.138570f, -0.138760f, -0.138949f,
	-0.139139f, -0.139329f, -0.139519f, -0.139709f, -0.139899f, -0.140089f, -0.140279f, -0.140468f,
	-0.140658f, -0.140848f, -0.141038f, -0.141228f, -0.141418f, -0.141607f, -0.141797f, -0.141987f,
	-0.142177f, -0.142367f, -0.142556f, -0.142746f, -0.142936f, -0.143126f, -0.143316f, -0.143505f,
	-0.143695f, -0.143885f, -0.144075f, -0.144264f, -0.144454f, -0.144644f, -0.144833f, -0.145023f,
	-0.145213f, -0.145403f, -0.145592f, -0.145782f, -0.145972f, -0.146161f, -0.146351f, -0.146541f,
	-0.146730f, -0.146920f, -0.147110f, -0.147299f, -0.147489f, -0.147679f, -0.147868f, -0.148058f,
	-0.148248f, -0.148437f, -0.148627f, -0.148817f, -0.149006f, -0.149196f, -0.149385f, -0.149575f,
	-0.149765f, -0.149954f, -0.150144f, -0.150333f, -0.150523f, -0.150712f, -0.150902f, -0.151092f,
	-0.151281f, -0.151471f, -0.151660f, -0.151850f, -0.152039f, -0.152229f, -0.152418f, -0.152608f,
	-0.152797f, -0.152987f, -0.153176f, -0.153366f, -0.153555f, -0.153745f, -0.153934f, -0.154124f,
	-0.154313f, -0.154502f, -0.154692f, -0.154881f, -0.155071f, -0.155260f, -0.155450f, -0.155639f,
	-0.155828f, -0.156018f, -0.156207f, -0.156397f, -0.156586f, -0.156775f, -0.156965f, -0.157154f,
	-0.157343f, -0.157533f, -0.157722f, -0.157912f, -0.158101f, -0.158290f, -0.158480f, -0.158669f,
	-0.158858f, -0.159047f, -0.159237f, -0.159426f, -0.159615f, -0.159805f, -0.159994f, -0.160183f,
	-0.160372f, -0.160562f, -0.160751f, -0.160940f, -0.161129f, -0.161319f, -0.161508f, -0.161697f,
	-0.161886f, -0.162076f, -0.162265f, -0.162454f, -0.162643f, -0.162832f, -0.163022f, -0.163211f,
	-0.163400f, -0.163589f, -0.163778f, -0.163967f, -0.164157f, -0.164346f, -0.164535f, -0.164724f,
	-0.164913f, -0.165102f, -0.165291f, -0.165480f, -0.165670f, -0.165859f, -0.166048f, -0.166237f,
	-0.166426f, -0.166615f, -0.166804f, -0.166993f, -0.167182f, -0.167371f, -0.167560f, -0.167749f,
	-0.167938f, -0.168127f, -0.168316f, -0.168505f, -0.168694f, -0.168883f, -0.169072f, -0.169261f,
	-0.169450f, -0.169639f, -0.169828f, -0.170017f, -0.170206f, -0.170395f, -0.170584f, -0.170773f,
	-0.170962f, -0.171151f, -0.171340f, -0.171529f, -0.171718f, -0.171906f, -0.172095f, -0.172284f,
	-0.172473f, -0.172662f, -0.172851f, -0.173040f, -0.173229f, -0.173417f, -0.173606f, -0.173795f,
	-0.173984f, -0.174173f, -0.174362f, -0.174550f, -0.174739f, -0.174928f, -0.175117f, -0.175305f,
	-0.175494f, -0.175683f, -0.175872f, -0.176061f, -0.176249f, -0.176438f, -0.176627f, -0.176815f,
	-0.177004f, -0.177193f, -0.177382f, -0.177570f, -0.177759f, -0.177948f, -0.178136f, -0.178325f,
	-0.178514f, -0.178702f, -0.178891f, -0.179080f, -0.179268f, -0.179457f, -0.179646f, -0.179834f,
	-0.180023f, -0.180212f, -0.180400f, -0.180589f, -0.180777f, -0.180966f, -0.181154f, -0.181343f,
	-0.181532f, -0.181720f, -0.181909f, -0.182097f, -0.182286f, -0.182474f, -0.182663f, -0.182851f,
	-0.183040f, -0.183228f, -0.183417f, -0.183605f, -0.183794f, -0.183982f, -0.184171f, -0.184359f,
	-0.184548f, -0.184736f, -0.184925f, -0.185113f, -0.185301f, -0.185490f, -0.185678f, -0.185867f,
	-0.186055f, -0.186244f, -0.186432f, -0.186620f, -0.186809f, -0.186997f, -0.187185f, -0.187374f,
	-0.187562f, -0.187750f, -0.187939f, -0.188127f, -0.188315f, -0.188504f, -0.188692f, -0.188880f,
	-0.189069f, -0.189257f, -0.189445f, -0.189634f, -0.189822f, -0.190010f, -0.190198f, -0.190387f,
	-0.190575f, -0.190763f, -0.190951f, -0.191139f, -0.191328f, -0.191516f, -0.191704f, -0.191892f,
	-0.192080f, -0.192269f, -0.192457f, -0.192645f, -0.192833f, -0.193021f, -0.193209f, -0.193397f,
	-0.193586f, -0.193774f, -0.193962f, -0.194150f, -0.194338f, -0.194526f, -0.194714f, -0.194902f,
	-0.195090f, -0.195278f, -0.195466f, -0.195654f, -0.195843f, -0.196031f, -0.196219f, -0.196407f,
	-0.196595f, -0.196783f, -0.196971f, -0.197159f, -0.197347f, -0.197535f, -0.197722f, -0.197910f,
	-0.198098f, -0.198286f, -0.198474f, -0.198662f, -0.198850f, -0.199038f, -0.199226f, -0.199414f,
	-0.199602f, -0.199790f, -0.199978f, -0.200165f, -0.200353f, -0.200541f, -0.200729f, -0.200917f,
	-0.201105f, -0.201292f, -0.201480f, -0.201668f, -0.201856f, -0.202044f, -0.202231f, -0.202419f,
	-0.202607f, -0.202795f, -0.202983f, -0.203170f, -0.203358f, -0.203546f, -0.203734f, -0.203921f,
	-0.204109f, -0.204297f, -0.204484f, -0.204672f, -0.204860f, -0.205047f, -0.205235f, -0.205423f,
	-0.205610f, -0.205798f, -0.205986f, -0.206173f, -0.206361f, -0.206549f, -0.206736f, -0.206924f,
	-0.207111f, -0.207299f, -0.207487f, -0.207674f, -0.207862f, -0.208049f, -0.208237f, -0.208424f,
	-0.208612f, -0.208799f, -0.208987f, -0.209174f, -0.209362f, -0.209549f, -0.209737f, -0.209924f,
	-0.210112f, -0.210299f, -0.210487f, -0.210674f, -0.210862f, -0.211049f, -0.211237f, -0.211424f,
	-0.211611f, -0.211799f, -0.211986f, -0.212174f, -0.212361f, -0.212548f, -0.212736f, -0.212923f,
	-0.213110f, -0.213298f, -0.213485f, -0.213672f, -0.213860f, -0.214047f, -0.214234f, -0.214422f,
	-0.214609f, -0.214796f, -0.214983f, -0.215171f, -0.215358f, -0.215545f, -0.215732f, -0.215920f,
	-0.216107f, -0.216294f, -0.216481f, -0.216668f, -0.216856f, -0.217043f, -0.217230f, -0.217417f,
	-0.217604f, -0.217791f, -0.217979f, -0.218166f, -0.218353f, -0.218540f, -0.218727f, -0.218914f,
	-0.219101f, -0.219288f, -0.219475f, -0.219662f, -0.219850f, -0.220037f, -0.220224f, -0.220411f,
	-0.220598f, -0.220785f, -0.220972f, -0.221159f, -0.221346f, -0.221533f, -0.221720f, -0.221907f,
	-0.222094f, -0.222281f, -0.222468f, -0.222654f, -0.222841f, -0.223028f, -0.223215f, -0.223402f,
	-0.223589f, -0.223776f, -0.223963f, -0.224150f, -0.224337f, -0.224523f, -0.224710f, -0.224897f,
	-0.225084f, -0.225271f, -0.225458f, -0.225644f, -0.225831f, -0.226018f, -0.226205f, -0.226391f,
	-0.226578f, -0.226765f, -0.226952f, -0.227139f, -0.227325f, -0.227512f, -0.227699f, -0.227885f,
	-0.228072f, -0.228259f, -0.228445f, -0.228632f, -0.228819f, -0.229005f, -0.229192f, -0.229379f,
	-0.229565f, -0.229752f, -0.229939f, -0.230125f, -0.230312f, -0.230498f, -0.230685f, -0.230872f,
	-0.231058f, -0.231245f, -0.231431f, -0.231618f, -0.231804f, -0.231991f, -0.232177f, -0.232364f,
	-0.232550f, -0.232737f, -0.232923f, -0.233110f, -0.233296f, -0.233483f, -0.233669f, -0.233856f,
	-0.234042f, -0.234228f, -0.234415f, -0.234601f, -0.234788f, -0.234974f, -0.235160f, -0.235347f,
	-0.235533f, -0.235719f, -0.235906f, -0.236092f, -0.236278f, -0.236465f, -0.236651f, -0.236837f,
	-0.237024f, -0.237210f, -0.237396f, -0.237582f, -0.237769f, -0.237955f, -0.238141f, -0.238327f,
	-0.238514f, -0.238700f, -0.238886f, -0.239072f, -0.239258f, -0.239445f, -0.239631f, -0.239817f,
	-0.240003f, -0.240189f, -0.240375f, -0.240561f, -0.240748f, -0.240934f, -0.241120f, -0.241306f,
	-0.241492f, -0.241678f, -0.241864f, -0.242050f, -0.242236f, -0.242422f, -0.242608f, -0.242794f,
	-0.242980f, -0.243166f, -0.243352f, -0.243538f, -0.243724f, -0.243910f, -0.244096f, -0.244282f,
	-0.244468f, -0.244654f, -0.244840f, -0.245026f, -0.245212f, -0.245397f, -0.245583f, -0.245769f,
	-0.245955f, -0.246141f, -0.246327f, -0.246513f, -0.246698f, -0.246884f, -0.247070f, -0.247256f,
	-0.247442f, -0.247627f, -0.247813f, -0.247999f, -0.248185f, -0.248370f, -0.248556f, -0.248742f,
	-0.248928f, -0.249113f, -0.249299f, -0.249485f, -0.249670f, -0.249856f, -0.250042f, -0.250227f,
	-0.250413f, -0.250599f, -0.250784f, -0.250970f, -0.251155f, -0.251341f, -0.251527f, -0.251712f,
	-0.251898f, -0.252083f, -0.252269f, -0.252454f, -0.252640f, -0.252826f, -0.253011f, -0.253197f,
	-0.253382f, -0.253568f, -0.253753f, -0.253938f, -0.254124f, -0.254309f, -0.254495f, -0.254680f,
	-0.254866f, -0.255051f, -0.255236f, -0.255422f, -0.255607f, -0.255793f, -0.255978f, -0.256163f,
	-0.256349f, -0.256534f, -0.256719f, -0.256905f, -0.257090f, -0.257275f, -0.257461f, -0.257646f,
	-0.257831f, -0.258016f, -0.258202f, -0.258387f, -0.258572f, -0.258757f, -0.258943f, -0.259128f,
	-0.259313f, -0.259498f, -0.259683f, -0.259868f, -0.260054f, -0.260239f, -0.260424f, -0.260609f,
	-0.260794f, -0.260979f, -0.261164f, -0.261349f, -0.261534f, -0.261720f, -0.261905f, -0.262090f,
	-0.262275f, -0.262460f, -0.262645f, -0.262830f, -0.263015f, -0.263200f, -0.263385f, -0.263570f,
	-0.263755f, -0.263940f, -0.264125f, -0.264309f, -0.264494f, -0.264679f, -0.264864f, -0.265049f,
	-0.265234f, -0.265419f, -0.265604f, -0.265789f, -0.265973f, -0.266158f, -0.266343f, -0.266528f,
	-0.266713f, -0.266898f, -0.267082f, -0.267267f, -0.267452f, -0.267637f, -0.267821f, -0.268006f,
	-0.268191f, -0.268376f, -0.268560f, -0.268745f, -0.268930f, -0.269114f, -0.269299f, -0.269484f,
	-0.269668f, -0.269853f, -0.270038f, -0.270222f, -0.270407f, -0.270591f, -0.270776f, -0.270961f,
	-0.271145f, -0.271330f, -0.271514f, -0.271699f, -0.271883f, -0.272068f, -0.272252f, -0.272437f,
	-0.272621f, -0.272806f, -0.272990f, -0.273175f, -0.273359f, -0.273544f, -0.273728f, -0.273912f,
	-0.274097f, -0.274281f, -0.274466f, -0.274650f, -0.274834f, -0.275019f, -0.275203f, -0.275387f,
	-0.275572f, -0.275756f, -0.275940f, -0.276125f, -0.276309f, -0.276493f, -0.276678f, -0.276862f,
	-0.277046f, -0.277230f, -0.277415f, -0.277599f, -0.277783f, -0.277967f, -0.278151f, -0.278336f,
	-0.278520f, -0.278704f, -0.278888f, -0.279072f, -0.279256f, -0.279440f, -0.279624f, -0.279809f,
	-0.279993f, -0.280177f, -0.280361f, -0.280545f, -0.280729f, -0.280913f, -0.281097f, -0.281281f,
	-0.281465f, -0.281649f, -0.281833f, -0.282017f, -0.282201f, -0.282385f, -0.282569f, -0.282753f,
	-0.282937f, -0.283120f, -0.283304f, -0.283488f, -0.283672f, -0.283856f, -0.284040f, -0.284224f,
	-0.284408f, -0.284591f, -0.284775f, -0.284959f, -0.285143f, -0.285327f, -0.285510f, -0.285694f,
	-0.285878f, -0.286062f, -0.286245f, -0.286429f, -0.286613f, -0.286796f, -0.286980f, -0.287164f,
	-0.287347f, -0.287531f, -0.287715f, -0.287898f, -0.288082f, -0.288266f, -0.288449f, -0.288633f,
	-0.288816f, -0.289000f, -0.289184f, -0.289367f, -0.289551f, -0.289734f, -0.289918f, -0.290101f,
	-0.290285f, -0.290468f, -0.290652f, -0.290835f, -0.291019f, -0.291202f, -0.291385f, -0.291569f,
	-0.291752f, -0.291936f, -0.292119f, -0.292302f, -0.292486f, -0.292669f, -0.292852f, -0.293036f,
	-0.293219f, -0.293402f, -0.293586f, -0.293769f, -0.293952f, -0.294136f, -0.294319f, -0.294502f,
	-0.294685f, -0.294869f, -0.295052f, -0.295235f, -0.295418f, -0.295601f, -0.295785f, -0.295968f,
	-0.296151f, -0.296334f, -0.296517f, -0.296700f, -0.296883f, -0.297066f, -0.297250f, -0.297433f,
	-0.297616f, -0.297799f, -0.297982f, -0.298165f, -0.298348f, -0.298531f, -0.298714f, -0.298897f,
	-0.299080f, -0.299263f, -0.299446f, -0.299629f, -0.299812f, -0.299995f, -0.300177f, -0.300360f,
	-0.300543f, -0.300726f, -0.300909f, -0.301092f, -0.301275f, -0.301458f, -0.301640f, -0.301823f,
	-0.302006f, -0.302189f, -0.302372f, -0.302554f, -0.302737f, -0.302920f, -0.303103f, -0.303285f,
	-0.303468f, -0.303651f, -0.303833f, -0.304016f, -0.304199f, -0.304381f, -0.304564f, -0.304747f,
	-0.304929f, -0.305112f, -0.305294f, -0.305477f, -0.305660f, -0.305842f, -0.306025f, -0.306207f,
	-0.306390f, -0.306572f, -0.306755f, -0.306937f, -0.307120f, -0.307302f, -0.307485f, -0.307667f,
	-0.307850f, -0.308032f, -0.308214f, -0.308397f, -0.308579f, -0.308762f, -0.308944f, -0.309126f,
	-0.309309f, -0.309491f, -0.309673f, -0.309856f, -0.310038f, -0.310220f, -0.310403f, -0.310585f,
	-0.310767f, -0.310949f, -0.311132f, -0.311314f, -0.311496f, -0.311678f, -0.311860f, -0.312043f,
	-0.312225f, -0.312407f, -0.312589f, -0.312771f, -0.312953f, -0.313135f, -0.313318f, -0.313500f,
	-0.313682f, -0.313864f, -0.314046f, -0.314228f, -0.314410f, -0.314592f, -0.314774f, -0.314956f,
	-0.315138f, -0.315320f, -0.315502f, -0.315684f, -0.315866f, -0.316048f, -0.316230f, -0.316411f,
	-0.316593f, -0.316775f, -0.316957f, -0.317139f, -0.317321f, -0.317503f, -0.317684f, -0.317866f,
	-0.318048f, -0.318230f, -0.318412f, -0.318593f, -0.318775f, -0.318957f, -0.319139f, -0.319320f,
	-0.319502f, -0.319684f, -0.319865f, -0.320047f, -0.320229f, -0.320410f, -0.320592f, -0.320774f,
	-0.320955f, -0.321137f, -0.321318f, -0.321500f, -0.321682f, -0.321863f, -0.322045f, -0.322226f,
	-0.322408f, -0.322589f, -0.322771f, -0.322952f, -0.323134f, -0.323315f, -0.323497f, -0.323678f,
	-0.323859f, -0.324041f, -0.324222f, -0.324404f, -0.324585f, -0.324766f, -0.324948f, -0.325129f,
	-0.325310f, -0.325492f, -0.325673f, -0.325854f, -0.326035f, -0.326217f, -0.326398f, -0.326579f,
	-0.326760f, -0.326942f, -0.327123f, -0.327304f, -0.327485f, -0.327666f, -0.327848f, -0.328029f,
	-0.328210f, -0.328391f, -0.328572f, -0.328753f, -0.328934f, -0.329115f, -0.329296f, -0.329477f,
	-0.329658f, -0.329839f, -0.330020f, -0.330202f, -0.330382f, -0.330563f, -0.330744f, -0.330925f,
	-0.331106f, -0.331287f, -0.331468f, -0.331649f, -0.331830f, -0.332011f, -0.332192f, -0.332373f,
	-0.332553f, -0.332734f, -0.332915f, -0.333096f, -0.333277f, -0.333457f, -0.333638f, -0.333819f,
	-0.334000f, -0.334180f, -0.334361f, -0.334542f, -0.334722f, -0.334903f, -0.335084f, -0.335265f,
	-0.335445f, -0.335626f, -0.335806f, -0.335987f, -0.336168f, -0.336348f, -0.336529f, -0.336709f,
	-0.336890f, -0.337070f, -0.337251f, -0.337431f, -0.337612f, -0.337792f, -0.337973f, -0.338153f,
	-0.338334f, -0.338514f, -0.338695f, -0.338875f, -0.339055f, -0.339236f, -0.339416f, -0.339597f,
	-0.339777f, -0.339957f, -0.340138f, -0.340318f, -0.340498f, -0.340678f, -0.340859f, -0.341039f,
	-0.341219f, -0.341399f, -0.341580f, -0.341760f, -0.341940f, -0.342120f, -0.342300f, -0.342481f,
	-0.342661f, -0.342841f, -0.343021f, -0.343201f, -0.343381f, -0.343561f, -0.343741f, -0.343921f,
	-0.344101f, -0.344281f, -0.344461f, -0.344641f, -0.344821f, -0.345001f, -0.345181f, -0.345361f,
	-0.345541f, -0.345721f, -0.345901f, -0.346081f, -0.346261f, -0.346441f, -0.346621f, -0.346801f,
	-0.346980f, -0.347160f, -0.347340f, -0.347520f, -0.347700f, -0.347879f, -0.348059f, -0.348239f,
	-0.348419f, -0.348598f, -0.348778f, -0.348958f, -0.349138f, -0.349317f, -0.349497f, -0.349676f,
	-0.349856f, -0.350036f, -0.350215f, -0.350395f, -0.350575f, -0.350754f, -0.350934f, -0.351113f,
	-0.351293f, -0.351472f, -0.351652f, -0.351831f, -0.352011f, -0.352190f, -0.352370f, -0.352549f,
	-0.352729f, -0.352908f, -0.353087f, -0.353267f, -0.353446f, -0.353626f, -0.353805f, -0.353984f,
	-0.354164f, -0.354343f, -0.354522f, -0.354701f, -0.354881f, -0.355060f, -0.355239f, -0.355418f,
	-0.355598f, -0.355777f, -0.355956f, -0.356135f, -0.356314f, -0.356494f, -0.356673f, -0.356852f,
	-0.357031f, -0.357210f, -0.357389f, -0.357568f, -0.357747f, -0.357926f, -0.358105f, -0.358284f,
	-0.358463f, -0.358642f, -0.358821f, -0.359000f, -0.359179f, -0.359358f, -0.359537f, -0.359716f,
	-0.359895f, -0.360074f, -0.360253f, -0.360432f, -0.360611f, -0.360789f, -0.360968f, -0.361147f,
	-0.361326f, -0.361505f, -0.361683f, -0.361862f, -0.362041f, -0.362220f, -0.362398f, -0.362577f,
	-0.362756f, -0.362934f, -0.363113f, -0.363292f, -0.363470f, -0.363649f, -0.363828f, -0.364006f,
	-0.364185f, -0.364363f, -0.364542f, -0.364720f, -0.364899f, -0.365078f, -0.365256f, -0.365435f,
	-0.365613f, -0.365791f, -0.365970f, -0.366148f, -0.366327f, -0.366505f, -0.366684f, -0.366862f,
	-0.367040f, -0.367219f, -0.367397f, -0.367575f, -0.367754f, -0.367932f, -0.368110f, -0.368289f,
	-0.368467f, -0.368645f, -0.368823f, -0.369002f, -0.369180f, -0.369358f, -0.369536f, -0.369714f,
	-0.369892f, -0.370071f, -0.370249f, -0.370427f, -0.370605f, -0.370783f, -0.370961f, -0.371139f,
	-0.371317f, -0.371495f, -0.371673f, -0.371851f, -0.372029f, -0.372207f, -0.372385f, -0.372563f,
	-0.372741f, -0.372919f, -0.373097f, -0.373275f, -0.373453f, -0.373631f, -0.373808f, -0.373986f,
	-0.374164f, -0.374342f, -0.374520f, -0.374697f, -0.374875f, -0.375053f, -0.375231f, -0.375408f,
	-0.375586f, -0.375764f, -0.375942f, -0.376119f, -0.376297f, -0.376475f, -0.376652f, -0.376830f,
	-0.377007f, -0.377185f, -0.377363f, -0.377540f, -0.377718f, -0.377895f, -0.378073f, -0.378250f,
	-0.378428f, -0.378605f, -0.378783f, -0.378960f, -0.379138f, -0.379315f, -0.379492f, -0.379670f,
	-0.379847f, -0.380025f, -0.380202f, -0.380379f, -0.380557f, -0.380734f, -0.380911f, -0.381088f,
	-0.381266f, -0.381443f, -0.381620f, -0.381797f, -0.381975f, -0.382152f, -0.382329f, -0.382506f,
	-0.382683f, -0.382861f, -0.383038f, -0.383215f, -0.383392f, -0.383569f, -0.383746f, -0.383923f,
	-0.384100f, -0.384277f, -0.384454f, -0.384631f, -0.384808f, -0.384985f, -0.385162f, -0.385339f,
	-0.385516f, -0.385693f, -0.385870f, -0.386047f, -0.386224f, -0.386400f, -0.386577f, -0.386754f,
	-0.386931f, -0.387108f, -0.387285f, -0.387461f, -0.387638f, -0.387815f, -0.387992f, -0.388168f,
	-0.388345f, -0.388522f, -0.388698f, -0.388875f, -0.389052f, -0.389228f, -0.389405f, -0.389582f,
	-0.389758f, -0.389935f, -0.390111f, -0.390288f, -0.390464f, -0.390641f, -0.390817f, -0.390994f,
	-0.391170f, -0.391347f, -0.391523f, -0.391700f, -0.391876f, -0.392053f, -0.392229f, -0.392405f,
	-0.392582f, -0.392758f, -0.392934f, -0.393111f, -0.393287f, -0.393463f, -0.393640f, -0.393816f,
	-0.393992f, -0.394168f, -0.394344f, -0.394521f, -0.394697f, -0.394873f, -0.395049f, -0.395225f,
	-0.395401f, -0.395578f, -0.395754f, -0.395930f, -0.396106f, -0.396282f, -0.396458f, -0.396634f,
	-0.396810f, -0.396986f, -0.397162f, -0.397338f, -0.397514f, -0.397690f, -0.397866f, -0.398042f,
	-0.398218f, -0.398393f, -0.398569f, -0.398745f, -0.398921f, -0.399097f, -0.399273f, -0.399448f,
	-0.399624f, -0.399800f, -0.399976f, -0.400151f, -0.400327f, -0.400503f, -0.400679f, -0.400854f,
	-0.401030f, -0.401206f, -0.401381f, -0.401557f, -0.401732f, -0.401908f, -0.402084f, -0.402259f,
	-0.402435f, -0.402610f, -0.402786f, -0.402961f, -0.403137f, -0.403312f, -0.403488f, -0.403663f,
	-0.403838f, -0.404014f, -0.404189f, -0.404365f, -0.404540f, -0.404715f, -0.404891f, -0.405066f,
	-0.405241f, -0.405417f, -0.405592f, -0.405767f, -0.405942f, -0.406118f, -0.406293f, -0.406468f,
	-0.406643f, -0.406818f, -0.406994f, -0.407169f, -0.407344f, -0.407519f, -0.407694f, -0.407869f,
	-0.408044f, -0.408219f, -0.408394f, -0.408569f, -0.408744f, -0.408919f, -0.409094f, -0.409269f,
	-0.409444f, -0.409619f, -0.409794f, -0.409969f, -0.410144f, -0.410319f, -0.410493f, -0.410668f,
	-0.410843f, -0.411018f, -0.411193f, -0.411368f, -0.411542f, -0.411717f, -0.411892f, -0.412067f,
	-0.412241f, -0.412416f, -0.412591f, -0.412765f, -0.412940f, -0.413115f, -0.413289f, -0.413464f,
	-0.413638f, -0.413813f, -0.413987f, -0.414162f, -0.414337f, -0.414511f, -0.414685f, -0.414860f,
	-0.415034f, -0.415209f, -0.415383f, -0.415558f, -0.415732f, -0.415906f, -0.416081f, -0.416255f,
	-0.416430f, -0.416604f, -0.416778f, -0.416952f, -0.417127f, -0.417301f, -0.417475f, -0.417650f,
	-0.417824f, -0.417998f, -0.418172f, -0.418346f, -0.418520f, -0.418695f, -0.418869f, -0.419043f,
	-0.419217f, -0.419391f, -0.419565f, -0.419739f, -0.419913f, -0.420087f, -0.420261f, -0.420435f,
	-0.420609f, -0.420783f, -0.420957f, -0.421131f, -0.421305f, -0.421479f, -0.421653f, -0.421826f,
	-0.422000f, -0.422174f, -0.422348f, -0.422522f, -0.422695f, -0.422869f, -0.423043f, -0.423217f,
	-0.423390f, -0.423564f, -0.423738f, -0.423912f, -0.424085f, -0.424259f, -0.424432f, -0.424606f,
	-0.424780f, -0.424953f, -0.425127f, -0.425300f, -0.425474f, -0.425647f, -0.425821f, -0.425994f,
	-0.426168f, -0.426341f, -0.426515f, -0.426688f, -0.426862f, -0.427035f, -0.427208f, -0.427382f,
	-0.427555f, -0.427728f, -0.427902f, -0.428075f, -0.428248f, -0.428422f, -0.428595f, -0.428768f,
	-0.428941f, -0.429114f, -0.429288f, -0.429461f, -0.429634f, -0.429807f, -0.429980f, -0.430153f,
	-0.430326f, -0.430500f, -0.430673f, -0.430846f, -0.431019f, -0.431192f, -0.431365f, -0.431538f,
	-0.431711f, -0.431884f, -0.432057f, -0.432229f, -0.432402f, -0.432575f, -0.432748f, -0.432921f,
	-0.433094f, -0.433267f, -0.433439f, -0.433612f, -0.433785f, -0.433958f, -0.434131f, -0.434303f,
	-0.434476f, -0.434649f, -0.434821f, -0.434994f, -0.435167f, -0.435339f, -0.435512f, -0.435685f,
	-0.435857f, -0.436030f, -0.436202f, -0.436375f, -0.436547f, -0.436720f, -0.436892f, -0.437065f,
	-0.437237f, -0.437410f, -0.437582f, -0.437754f, -0.437927f, -0.438099f, -0.438272f, -0.438444f,
	-0.438616f, -0.438789f, -0.438961f, -0.439133f, -0.439305f, -0.439478f, -0.439650f, -0.439822f,
	-0.439994f, -0.440166f, -0.440339f, -0.440511f, -0.440683f, -0.440855f, -0.441027f, -0.441199f,
	-0.441371f, -0.441543f, -0.441715f, -0.441887f, -0.442059f, -0.442231f, -0.442403f, -0.442575f,
	-0.442747f, -0.442919f, -0.443091f, -0.443263f, -0.443435f, -0.443607f, -0.443779f, -0.443950f,
	-0.444122f, -0.444294f, -0.444466f, -0.444637f, -0.444809f, -0.444981f, -0.445153f, -0.445324f,
	-0.445496f, -0.445668f, -0.445839f, -0.446011f, -0.446183f, -0.446354f, -0.446526f, -0.446697f,
	-0.446869f, -0.447040f, -0.447212f, -0.447383f, -0.447555f, -0.447726f, -0.447898f, -0.448069f,
	-0.448241f, -0.448412f, -0.448583f, -0.448755f, -0.448926f, -0.449097f, -0.449269f, -0.449440f,
	-0.449611f, -0.449783f, -0.449954f, -0.450125f, -0.450296f, -0.450467f, -0.450639f, -0.450810f,
	-0.450981f, -0.451152f, -0.451323f, -0.451494f, -0.451665f, -0.451836f, -0.452008f, -0.452179f,
	-0.452350f, -0.452521f, -0.452692f, -0.452863f, -0.453033f, -0.453204f, -0.453375f, -0.453546f,
	-0.453717f, -0.453888f, -0.454059f, -0.454230f, -0.454400f, -0.454571f, -0.454742f, -0.454913f,
	-0.455084f, -0.455254f, -0.455425f, -0.455596f, -0.455766f, -0.455937f, -0.456108f, -0.456278f,
	-0.456449f, -0.456620f, -0.456790f, -0.456961f, -0.457131f, -0.457302f, -0.457472f, -0.457643f,
	-0.457813f, -0.457984f, -0.458154f, -0.458325f, -0.458495f, -0.458665f, -0.458836f, -0.459006f,
	-0.459177f, -0.459347f, -0.459517f, -0.459687f, -0.459858f, -0.460028f, -0.460198f, -0.460369f,
	-0.460539f, -0.460709f, -0.460879f, -0.461049f, -0.461219f, -0.461390f, -0.461560f, -0.461730f,
	-0.461900f, -0.462070f, -0.462240f, -0.462410f, -0.462580f, -0.462750f, -0.462920f, -0.463090f,
	-0.463260f, -0.463430f, -0.463600f, -0.463769f, -0.463939f, -0.464109f, -0.464279f, -0.464449f,
	-0.464619f, -0.464788f, -0.464958f, -0.465128f, -0.465298f, -0.465467f, -0.465637f, -0.465807f,
	-0.465977f, -0.466146f, -0.466316f, -0.466485f, -0.466655f, -0.466825f, -0.466994f, -0.467164f,
	-0.467333f, -0.467503f, -0.467672f, -0.467842f, -0.468011f, -0.468181f, -0.468350f, -0.468519f,
	-0.468689f, -0.468858f, -0.469028f, -0.469197f, -0.469366f, -0.469536f, -0.469705f, -0.469874f,
	-0.470043f, -0.470213f, -0.470382f, -0.470551f, -0.470720f, -0.470889f, -0.471058f, -0.471228f,
	-0.471397f, -0.471566f, -0.471735f, -0.471904f, -0.472073f, -0.472242f, -0.472411f, -0.472580f,
	-0.472749f, -0.472918f, -0.473087f, -0.473256f, -0.473425f, -0.473594f, -0.473763f, -0.473931f,
	-0.474100f, -0.474269f, -0.474438f, -0.474607f, -0.474775f, -0.474944f, -0.475113f, -0.475282f,
	-0.475450f, -0.475619f, -0.475788f, -0.475956f, -0.476125f, -0.476294f, -0.476462f, -0.476631f,
	-0.476799f, -0.476968f, -0.477136f, -0.477305f, -0.477473f, -0.477642f, -0.477810f, -0.477979f,
	-0.478147f, -0.478315f, -0.478484f, -0.478652f, -0.478821f, -0.478989f, -0.479157f, -0.479325f,
	-0.479494f, -0.479662f, -0.479830f, -0.479998f, -0.480167f, -0.480335f, -0.480503f, -0.480671f,
	-0.480839f, -0.481007f, -0.481176f, -0.481344f, -0.481512f, -0.481680f, -0.481848f, -0.482016f,
	-0.482184f, -0.482352f, -0.482520f, -0.482688f, -0.482856f, -0.483023f, -0.483191f, -0.483359f,
	-0.483527f, -0.483695f, -0.483863f, -0.484031f, -0.484198f, -0.484366f, -0.484534f, -0.484702f,
	-0.484869f, -0.485037f, -0.485205f, -0.485372f, -0.485540f, -0.485708f, -0.485875f, -0.486043f,
	-0.486210f, -0.486378f, -0.486545f, -0.486713f, -0.486880f, -0.487048f, -0.487215f, -0.487383f,
	-0.487550f, -0.487718f, -0.487885f, -0.488052f, -0.488220f, -0.488387f, -0.488554f, -0.488722f,
	-0.488889f, -0.489056f, -0.489223f, -0.489391f, -0.489558f, -0.489725f, -0.489892f, -0.490059f,
	-0.490226f, -0.490394f, -0.490561f, -0.490728f, -0.490895f, -0.491062f, -0.491229f, -0.491396f,
	-0.491563f, -0.491730f, -0.491897f, -0.492064f, -0.492231f, -0.492398f, -0.492564f, -0.492731f,
	-0.492898f, -0.493065f, -0.493232f, -0.493399f, -0.493565f, -0.493732f, -0.493899f, -0.494066f,
	-0.494232f, -0.494399f, -0.494566f, -0.494732f, -0.494899f, -0.495066f, -0.495232f, -0.495399f,
	-0.495565f, -0.495732f, -0.495898f, -0.496065f, -0.496231f, -0.496398f, -0.496564f, -0.496731f,
	-0.496897f, -0.497063f, -0.497230f, -0.497396f, -0.497562f, -0.497729f, -0.497895f, -0.498061f,
	-0.498228f, -0.498394f, -0.498560f, -0.498726f, -0.498893f, -0.499059f, -0.499225f, -0.499391f,
	-0.499557f, -0.499723f, -0.499889f, -0.500055f, -0.500221f, -0.500387f, -0.500553f, -0.500719f,
	-0.500885f, -0.501051f, -0.501217f, -0.501383f, -0.501549f, -0.501715f, -0.501881f, -0.502047f,
	-0.502212f, -0.502378f, -0.502544f, -0.502710f, -0.502876f, -0.503041f, -0.503207f, -0.503373f,
	-0.503538f, -0.503704f, -0.503870f, -0.504035f, -0.504201f, -0.504366f, -0.504532f, -0.504698f,
	-0.504863f, -0.505029f, -0.505194f, -0.505360f, -0.505525f, -0.505690f, -0.505856f, -0.506021f,
	-0.506187f, -0.506352f, -0.506517f, -0.506683f, -0.506848f, -0.507013f, -0.507179f, -0.507344f,
	-0.507509f, -0.507674f, -0.507839f, -0.508005f, -0.508170f, -0.508335f, -0.508500f, -0.508665f,
	-0.508830f, -0.508995f, -0.509160f, -0.509325f, -0.509490f, -0.509655f, -0.509820f, -0.509985f,
	-0.510150f, -0.510315f, -0.510480f, -0.510645f, -0.510810f, -0.510974f, -0.511139f, -0.511304f,
	-0.511469f, -0.511634f, -0.511798f, -0.511963f, -0.512128f, -0.512292f, -0.512457f, -0.512622f,
	-0.512786f, -0.512951f, -0.513116f, -0.513280f, -0.513445f, -0.513609f, -0.513774f, -0.513938f,
	-0.514103f, -0.514267f, -0.514432f, -0.514596f, -0.514760f, -0.514925f, -0.515089f, -0.515254f,
	-0.515418f, -0.515582f, -0.515746f, -0.515911f, -0.516075f, -0.516239f, -0.516403f, -0.516568f,
	-0.516732f, -0.516896f, -0.517060f, -0.517224f, -0.517388f, -0.517552f, -0.517716f, -0.517880f,
	-0.518045f, -0.518209f, -0.518372f, -0.518536f, -0.518700f, -0.518864f, -0.519028f, -0.519192f,
	-0.519356f, -0.519520f, -0.519684f, -0.519848f, -0.520011f, -0.520175f, -0.520339f, -0.520503f,
	-0.520666f, -0.520830f, -0.520994f, -0.521157f, -0.521321f, -0.521485f, -0.521648f, -0.521812f,
	-0.521975f, -0.522139f, -0.522302f, -0.522466f, -0.522629f, -0.522793f, -0.522956f, -0.523120f,
	-0.523283f, -0.523447f, -0.523610f, -0.523773f, -0.523937f, -0.524100f, -0.524263f, -0.524426f,
	-0.524590f, -0.524753f, -0.524916f, -0.525079f, -0.525243f, -0.525406f, -0.525569f, -0.525732f,
	-0.525895f, -0.526058f, -0.526221f, -0.526384f, -0.526547f, -0.526710f, -0.526873f, -0.527036f,
	-0.527199f, -0.527362f, -0.527525f, -0.527688f, -0.527851f, -0.528014f, -0.528176f, -0.528339f,
	-0.528502f, -0.528665f, -0.528828f, -0.528990f, -0.529153f, -0.529316f, -0.529478f, -0.529641f,
	-0.529804f, -0.529966f, -0.530129f, -0.530291f, -0.530454f, -0.530617f, -0.530779f, -0.530942f,
	-0.531104f, -0.531266f, -0.531429f, -0.531591f, -0.531754f, -0.531916f, -0.532078f, -0.532241f,
	-0.532403f, -0.532565f, -0.532728f, -0.532890f, -0.533052f, -0.533214f, -0.533377f, -0.533539f,
	-0.533701f, -0.533863f, -0.534025f, -0.534187f, -0.534349f, -0.534512f, -0.534674f, -0.534836f,
	-0.534998f, -0.535160f, -0.535322f, -0.535484f, -0.535645f, -0.535807f, -0.535969f, -0.536131f,
	-0.536293f, -0.536455f, -0.536617f, -0.536778f, -0.536940f, -0.537102f, -0.537264f, -0.537425f,
	-0.537587f, -0.537749f, -0.537910f, -0.538072f, -0.538234f, -0.538395f, -0.538557f, -0.538718f,
	-0.538880f, -0.539041f, -0.539203f, -0.539364f, -0.539526f, -0.539687f, -0.539849f, -0.540010f,
	-0.540171f, -0.540333f, -0.540494f, -0.540655f, -0.540817f, -0.540978f, -0.541139f, -0.541301f,
	-0.541462f, -0.541623f, -0.541784f, -0.541945f, -0.542106f, -0.542268f, -0.542429f, -0.542590f,
	-0.542751f, -0.542912f, -0.543073f, -0.543234f, -0.543395f, -0.543556f, -0.543717f, -0.543878f,
	-0.544039f, -0.544199f, -0.544360f, -0.544521f, -0.544682f, -0.544843f, -0.545003f, -0.545164f,
	-0.545325f, -0.545486f, -0.545646f, -0.545807f, -0.545968f, -0.546128f, -0.546289f, -0.546450f,
	-0.546610f, -0.546771f, -0.546931f, -0.547092f, -0.547252f, -0.547413f, -0.547573f, -0.547734f,
	-0.547894f, -0.548054f, -0.548215f, -0.548375f, -0.548536f, -0.548696f, -0.548856f, -0.549016f,
	-0.549177f, -0.549337f, -0.549497f, -0.549657f, -0.549818f, -0.549978f, -0.550138f, -0.550298f,
	-0.550458f, -0.550618f, -0.550778f, -0.550938f, -0.551098f, -0.551258f, -0.551418f, -0.551578f,
	-0.551738f, -0.551898f, -0.552058f, -0.552218f, -0.552378f, -0.552537f, -0.552697f, -0.552857f,
	-0.553017f, -0.553176f, -0.553336f, -0.553496f, -0.553656f, -0.553815f, -0.553975f, -0.554134f,
	-0.554294f, -0.554454f, -0.554613f, -0.554773f, -0.554932f, -0.555092f, -0.555251f, -0.555411f,
	-0.555570f, -0.555730f, -0.555889f, -0.556048f, -0.556208f, -0.556367f, -0.556526f, -0.556686f,
	-0.556845f, -0.557004f, -0.557164f, -0.557323f, -0.557482f, -0.557641f, -0.557800f, -0.557959f,
	-0.558119f, -0.558278f, -0.558437f, -0.558596f, -0.558755f, -0.558914f, -0.559073f, -0.559232f,
	-0.559391f, -0.559550f, -0.559709f, -0.559867f, -0.560026f, -0.560185f, -0.560344f, -0.560503f,
	-0.560662f, -0.560820f, -0.560979f, -0.561138f, -0.561297f, -0.561455f, -0.561614f, -0.561773f,
	-0.561931f, -0.562090f, -0.562248f, -0.562407f, -0.562565f, -0.562724f, -0.562882f, -0.563041f,
	-0.563199f, -0.563358f, -0.563516f, -0.563675f, -0.563833f, -0.563991f, -0.564150f, -0.564308f,
	-0.564466f, -0.564624f, -0.564783f, -0.564941f, -0.565099f, -0.565257f, -0.565416f, -0.565574f,
	-0.565732f, -0.565890f, -0.566048f, -0.566206f, -0.566364f, -0.566522f, -0.566680f, -0.566838f,
	-0.566996f, -0.567154f, -0.567312f, -0.567470f, -0.567628f, -0.567786f, -0.567943f, -0.568101f,
	-0.568259f, -0.568417f, -0.568574f, -0.568732f, -0.568890f, -0.569048f, -0.569205f, -0.569363f,
	-0.569521f, -0.569678f, -0.569836f, -0.569993f, -0.570151f, -0.570308f, -0.570466f, -0.570623f,
	-0.570781f, -0.570938f, -0.571096f, -0.571253f, -0.571410f, -0.571568f, -0.571725f, -0.571882f,
	-0.572040f, -0.572197f, -0.572354f, -0.572511f, -0.572669f, -0.572826f, -0.572983f, -0.573140f,
	-0.573297f, -0.573454f, -0.573611f, -0.573768f, -0.573925f, -0.574082f, -0.574239f, -0.574396f,
	-0.574553f, -0.574710f, -0.574867f, -0.575024f, -0.575181f, -0.575338f, -0.575495f, -0.575651f,
	-0.575808f, -0.575965f, -0.576122f, -0.576278f, -0.576435f, -0.576592f, -0.576748f, -0.576905f,
	-0.577062f, -0.577218f, -0.577375f, -0.577531f, -0.577688f, -0.577844f, -0.578001f, -0.578157f,
	-0.578314f, -0.578470f, -0.578627f, -0.578783f, -0.578939f, -0.579096f, -0.579252f, -0.579408f,
	-0.579565f, -0.579721f, -0.579877f, -0.580033f, -0.580189f, -0.580346f, -0.580502f, -0.580658f,
	-0.580814f, -0.580970f, -0.581126f, -0.581282f, -0.581438f, -0.581594f, -0.581750f, -0.581906f,
	-0.582062f, -0.582218f, -0.582374f, -0.582530f, -0.582685f, -0.582841f, -0.582997f, -0.583153f,
	-0.583309f, -0.583464f, -0.583620f, -0.583776f, -0.583931f, -0.584087f, -0.584243f, -0.584398f,
	-0.584554f, -0.584710f, -0.584865f, -0.585021f, -0.585176f, -0.585332f, -0.585487f, -0.585642f,
	-0.585798f, -0.585953f, -0.586109f, -0.586264f, -0.586419f, -0.586575f, -0.586730f, -0.586885f,
	-0.587040f, -0.587196f, -0.587351f, -0.587506f, -0.587661f, -0.587816f, -0.587971f, -0.588126f,
	-0.588282f, -0.588437f, -0.588592f, -0.588747f, -0.588902f, -0.589057f, -0.589212f, -0.589366f,
	-0.589521f, -0.589676f, -0.589831f, -0.589986f, -0.590141f, -0.590295f, -0.590450f, -0.590605f,
	-0.590760f, -0.590914f, -0.591069f, -0.591224f, -0.591378f, -0.591533f, -0.591688f, -0.591842f,
	-0.591997f, -0.592151f, -0.592306f, -0.592460f, -0.592615f, -0.592769f, -0.592924f, -0.593078f,
	-0.593232f, -0.593387f, -0.593541f, -0.593695f, -0.593850f, -0.594004f, -0.594158f, -0.594312f,
	-0.594467f, -0.594621f, -0.594775f, -0.594929f, -0.595083f, -0.595237f, -0.595391f, -0.595545f,
	-0.595699f, -0.595853f, -0.596007f, -0.596161f, -0.596315f, -0.596469f, -0.596623f, -0.596777f,
	-0.596931f, -0.597085f, -0.597238f, -0.597392f, -0.597546f, -0.597700f, -0.597853f, -0.598007f,
	-0.598161f, -0.598314f, -0.598468f, -0.598622f, -0.598775f, -0.598929f, -0.599082f, -0.599236f,
	-0.599389f, -0.599543f, -0.599696f, -0.599850f, -0.600003f, -0.600156f, -0.600310f, -0.600463f,
	-0.600616f, -0.600770f, -0.600923f, -0.601076f, -0.601230f, -0.601383f, -0.601536f, -0.601689f,
	-0.601842f, -0.601995f, -0.602148f, -0.602302f, -0.602455f, -0.602608f, -0.602761f, -0.602914f,
	-0.603067f, -0.603220f, -0.603372f, -0.603525f, -0.603678f, -0.603831f, -0.603984f, -0.604137f,
	-0.604290f, -0.604442f, -0.604595f, -0.604748f, -0.604900f, -0.605053f, -0.605206f, -0.605358f,
	-0.605511f, -0.605664f, -0.605816f, -0.605969f, -0.606121f, -0.606274f, -0.606426f, -0.606579f,
	-0.606731f, -0.606884f, -0.607036f, -0.607188f, -0.607341f, -0.607493f, -0.607645f, -0.607798f,
	-0.607950f, -0.608102f, -0.608254f, -0.608406f, -0.608559f, -0.608711f, -0.608863f, -0.609015f,
	-0.609167f, -0.609319f, -0.609471f, -0.609623f, -0.609775f, -0.609927f, -0.610079f, -0.610231f,
	-0.610383f, -0.610535f, -0.610687f, -0.610838f, -0.610990f, -0.611142f, -0.611294f, -0.611445f,
	-0.611597f, -0.611749f, -0.611901f, -0.612052f, -0.612204f, -0.612355f, -0.612507f, -0.612659f,
	-0.612810f, -0.612962f, -0.613113f, -0.613265f, -0.613416f, -0.613567f, -0.613719f, -0.613870f,
	-0.614022f, -0.614173f, -0.614324f, -0.614475f, -0.614627f, -0.614778f, -0.614929f, -0.615080f,
	-0.615232f, -0.615383f, -0.615534f, -0.615685f, -0.615836f, -0.615987f, -0.616138f, -0.616289f,
	-0.616440f, -0.616591f, -0.616742f, -0.616893f, -0.617044f, -0.617195f, -0.617346f, -0.617496f,
	-0.617647f, -0.617798f, -0.617949f, -0.618100f, -0.618250f, -0.618401f, -0.618552f, -0.618702f,
	-0.618853f, -0.619004f, -0.619154f, -0.619305f, -0.619455f, -0.619606f, -0.619756f, -0.619907f,
	-0.620057f, -0.620208f, -0.620358f, -0.620508f, -0.620659f, -0.620809f, -0.620959f, -0.621110f,
	-0.621260f, -0.621410f, -0.621560f, -0.621711f, -0.621861f, -0.622011f, -0.622161f, -0.622311f,
	-0.622461f, -0.622611f, -0.622761f, -0.622911f, -0.623061f, -0.623211f, -0.623361f, -0.623511f,
	-0.623661f, -0.623811f, -0.623961f, -0.624111f, -0.624260f, -0.624410f, -0.624560f, -0.624710f,
	-0.624860f, -0.625009f, -0.625159f, -0.625309f, -0.625458f, -0.625608f, -0.625757f, -0.625907f,
	-0.626056f, -0.626206f, -0.626355f, -0.626505f, -0.626654f, -0.626804f, -0.626953f, -0.627102f,
	-0.627252f, -0.627401f, -0.627550f, -0.627700f, -0.627849f, -0.627998f, -0.628147f, -0.628297f,
	-0.628446f, -0.628595f, -0.628744f, -0.628893f, -0.629042f, -0.629191f, -0.629340f, -0.629489f,
	-0.629638f, -0.629787f, -0.629936f, -0.630085f, -0.630234f, -0.630383f, -0.630532f, -0.630680f,
	-0.630829f, -0.630978f, -0.631127f, -0.631275f, -0.631424f, -0.631573f, -0.631721f, -0.631870f,
	-0.632019f, -0.632167f, -0.632316f, -0.632464f, -0.632613f, -0.632761f, -0.632910f, -0.633058f,
	-0.633207f, -0.633355f, -0.633504f, -0.633652f, -0.633800f, -0.633949f, -0.634097f, -0.634245f,
	-0.634393f, -0.634542f, -0.634690f, -0.634838f, -0.634986f, -0.635134f, -0.635282f, -0.635430f,
	-0.635578f, -0.635726f, -0.635874f, -0.636022f, -0.636170f, -0.636318f, -0.636466f, -0.636614f,
	-0.636762f, -0.636910f, -0.637057f, -0.637205f, -0.637353f, -0.637501f, -0.637649f, -0.637796f,
	-0.637944f, -0.638092f, -0.638239f, -0.638387f, -0.638534f, -0.638682f, -0.638829f, -0.638977f,
	-0.639124f, -0.639272f, -0.639419f, -0.639567f, -0.639714f, -0.639862f, -0.640009f, -0.640156f,
	-0.640303f, -0.640451f, -0.640598f, -0.640745f, -0.640892f, -0.641040f, -0.641187f, -0.641334f,
	-0.641481f, -0.641628f, -0.641775f, -0.641922f, -0.642069f, -0.642216f, -0.642363f, -0.642510f,
	-0.642657f, -0.642804f, -0.642951f, -0.643098f, -0.643245f, -0.643391f, -0.643538f, -0.643685f,
	-0.643832f, -0.643978f, -0.644125f, -0.644272f, -0.644418f, -0.644565f, -0.644711f, -0.644858f,
	-0.645005f, -0.645151f, -0.645298f, -0.645444f, -0.645590f, -0.645737f, -0.645883f, -0.646030f,
	-0.646176f, -0.646322f, -0.646469f, -0.646615f, -0.646761f, -0.646907f, -0.647054f, -0.647200f,
	-0.647346f, -0.647492f, -0.647638f, -0.647784f, -0.647930f, -0.648076f, -0.648222f, -0.648368f,
	-0.648514f, -0.648660f, -0.648806f, -0.648952f, -0.649098f, -0.649244f, -0.649390f, -0.649536f,
	-0.649681f, -0.649827f, -0.649973f, -0.650119f, -0.650264f, -0.650410f, -0.650555f, -0.650701f,
	-0.650847f, -0.650992f, -0.651138f, -0.651283f, -0.651429f, -0.651574f, -0.651720f, -0.651865f,
	-0.652011f, -0.652156f, -0.652301f, -0.652447f, -0.652592f, -0.652737f, -0.652882f, -0.653028f,
	-0.653173f, -0.653318f, -0.653463f, -0.653608f, -0.653753f, -0.653899f, -0.654044f, -0.654189f,
	-0.654334f, -0.654479f, -0.654624f, -0.654769f, -0.654913f, -0.655058f, -0.655203f, -0.655348f,
	-0.655493f, -0.655638f, -0.655782f, -0.655927f, -0.656072f, -0.656217f, -0.656361f, -0.656506f,
	-0.656651f, -0.656795f, -0.656940f, -0.657084f, -0.657229f, -0.657373f, -0.657518f, -0.657662f,
	-0.657807f, -0.657951f, -0.658095f, -0.658240f, -0.658384f, -0.658529f, -0.658673f, -0.658817f,
	-0.658961f, -0.659105f, -0.659250f, -0.659394f, -0.659538f, -0.659682f, -0.659826f, -0.659970f,
	-0.660114f, -0.660258f, -0.660402f, -0.660546f, -0.660690f, -0.660834f, -0.660978f, -0.661122f,
	-0.661266f, -0.661410f, -0.661553f, -0.661697f, -0.661841f, -0.661985f, -0.662128f, -0.662272f,
	-0.662416f, -0.662559f, -0.662703f, -0.662847f, -0.662990f, -0.663134f, -0.663277f, -0.663421f,
	-0.663564f, -0.663708f, -0.663851f, -0.663994f, -0.664138f, -0.664281f, -0.664424f, -0.664568f,
	-0.664711f, -0.664854f, -0.664997f, -0.665141f, -0.665284f, -0.665427f, -0.665570f, -0.665713f,
	-0.665856f, -0.665999f, -0.666142f, -0.666285f, -0.666428f, -0.666571f, -0.666714f, -0.666857f,
	-0.667000f, -0.667143f, -0.667286f, -0.667428f, -0.667571f, -0.667714f, -0.667857f, -0.667999f,
	-0.668142f, -0.668285f, -0.668427f, -0.668570f, -0.668712f, -0.668855f, -0.668998f, -0.669140f,
	-0.669283f, -0.669425f, -0.669567f, -0.669710f, -0.669852f, -0.669995f, -0.670137f, -0.670279f,
	-0.670422f, -0.670564f, -0.670706f, -0.670848f, -0.670990f, -0.671133f, -0.671275f, -0.671417f,
	-0.671559f, -0.671701f, -0.671843f, -0.671985f, -0.672127f, -0.672269f, -0.672411f, -0.672553f,
	-0.672695f, -0.672837f, -0.672978f, -0.673120f, -0.673262f, -0.673404f, -0.673546f, -0.673687f,
	-0.673829f, -0.673971f, -0.674112f, -0.674254f, -0.674396f, -0.674537f, -0.674679f, -0.674820f,
	-0.674962f, -0.675103f, -0.675245f, -0.675386f, -0.675527f, -0.675669f, -0.675810f, -0.675951f,
	-0.676093f, -0.676234f, -0.676375f, -0.676516f, -0.676658f, -0.676799f, -0.676940f, -0.677081f,
	-0.677222f, -0.677363f, -0.677504f, -0.677645f, -0.677786f, -0.677927f, -0.678068f, -0.678209f,
	-0.678350f, -0.678491f, -0.678632f, -0.678773f, -0.678913f, -0.679054f, -0.679195f, -0.679336f,
	-0.679476f, -0.679617f, -0.679758f, -0.679898f, -0.680039f, -0.680179f, -0.680320f, -0.680461f,
	-0.680601f, -0.680741f, -0.680882f, -0.681022f, -0.681163f, -0.681303f, -0.681443f, -0.681584f,
	-0.681724f, -0.681864f, -0.682005f, -0.682145f, -0.682285f, -0.682425f, -0.682565f, -0.682705f,
	-0.682846f, -0.682986f, -0.683126f, -0.683266f, -0.683406f, -0.683546f, -0.683686f, -0.683825f,
	-0.683965f, -0.684105f, -0.684245f, -0.684385f, -0.684525f, -0.684664f, -0.684804f, -0.684944f,
	-0.685084f, -0.685223f, -0.685363f, -0.685503f, -0.685642f, -0.685782f, -0.685921f, -0.686061f,
	-0.686200f, -0.686340f, -0.686479f, -0.686619f, -0.686758f, -0.686897f, -0.687037f, -0.687176f,
	-0.687315f, -0.687455f, -0.687594f, -0.687733f, -0.687872f, -0.688011f, -0.688151f, -0.688290f,
	-0.688429f, -0.688568f, -0.688707f, -0.688846f, -0.688985f, -0.689124f, -0.689263f, -0.689402f,
	-0.689541f, -0.689679f, -0.689818f, -0.689957f, -0.690096f, -0.690235f, -0.690373f, -0.690512f,
	-0.690651f, -0.690789f, -0.690928f, -0.691067f, -0.691205f, -0.691344f, -0.691482f, -0.691621f,
	-0.691759f, -0.691898f, -0.692036f, -0.692175f, -0.692313f, -0.692451f, -0.692590f, -0.692728f,
	-0.692866f, -0.693004f, -0.693143f, -0.693281f, -0.693419f, -0.693557f, -0.693695f, -0.693833f,
	-0.693971f, -0.694109f, -0.694248f, -0.694386f, -0.694524f, -0.694661f, -0.694799f, -0.694937f,
	-0.695075f, -0.695213f, -0.695351f, -0.695489f, -0.695626f, -0.695764f, -0.695902f, -0.696039f,
	-0.696177f, -0.696315f, -0.696452f, -0.696590f, -0.696728f, -0.696865f, -0.697003f, -0.697140f,
	-0.697277f, -0.697415f, -0.697552f, -0.697690f, -0.697827f, -0.697964f, -0.698102f, -0.698239f,
	-0.698376f, -0.698513f, -0.698651f, -0.698788f, -0.698925f, -0.699062f, -0.699199f, -0.699336f,
	-0.699473f, -0.699610f, -0.699747f, -0.699884f, -0.700021f, -0.700158f, -0.700295f, -0.700432f,
	-0.700569f, -0.700706f, -0.700842f, -0.700979f, -0.701116f, -0.701253f, -0.701389f, -0.701526f,
	-0.701663f, -0.701799f, -0.701936f, -0.702072f, -0.702209f, -0.702345f, -0.702482f, -0.702618f,
	-0.702755f, -0.702891f, -0.703028f, -0.703164f, -0.703300f, -0.703436f, -0.703573f, -0.703709f,
	-0.703845f, -0.703981f, -0.704118f, -0.704254f, -0.704390f, -0.704526f, -0.704662f, -0.704798f,
	-0.704934f, -0.705070f, -0.705206f, -0.705342f, -0.705478f, -0.705614f, -0.705750f, -0.705885f,
	-0.706021f, -0.706157f, -0.706293f, -0.706429f, -0.706564f, -0.706700f, -0.706836f, -0.706971f,
	-0.707107f, -0.707242f, -0.707378f, -0.707513f, -0.707649f, -0.707784f, -0.707920f, -0.708055f,
	-0.708191f, -0.708326f, -0.708461f, -0.708597f, -0.708732f, -0.708867f, -0.709002f, -0.709138f,
	-0.709273f, -0.709408f, -0.709543f, -0.709678f, -0.709813f, -0.709948f, -0.710083f, -0.710218f,
	-0.710353f, -0.710488f, -0.710623f, -0.710758f, -0.710893f, -0.711028f, -0.711163f, -0.711297f,
	-0.711432f, -0.711567f, -0.711702f, -0.711836f, -0.711971f, -0.712106f, -0.712240f, -0.712375f,
	-0.712509f, -0.712644f, -0.712778f, -0.712913f, -0.713047f, -0.713182f, -0.713316f, -0.713451f,
	-0.713585f, -0.713719f, -0.713853f, -0.713988f, -0.714122f, -0.714256f, -0.714390f, -0.714525f,
	-0.714659f, -0.714793f, -0.714927f, -0.715061f, -0.715195f, -0.715329f, -0.715463f, -0.715597f,
	-0.715731f, -0.715865f, -0.715999f, -0.716132f, -0.716266f, -0.716400f, -0.716534f, -0.716668f,
	-0.716801f, -0.716935f, -0.717069f, -0.717202f, -0.717336f, -0.717469f, -0.717603f, -0.717737f,
	-0.717870f, -0.718004f, -0.718137f, -0.718270f, -0.718404f, -0.718537f, -0.718670f, -0.718804f,
	-0.718937f, -0.719070f, -0.719204f, -0.719337f, -0.719470f, -0.719603f, -0.719736f, -0.719869f,
	-0.720003f, -0.720136f, -0.720269f, -0.720402f, -0.720535f, -0.720668f, -0.720800f, -0.720933f,
	-0.721066f, -0.721199f, -0.721332f, -0.721465f, -0.721597f, -0.721730f, -0.721863f, -0.721996f,
	-0.722128f, -0.722261f, -0.722393f, -0.722526f, -0.722659f, -0.722791f, -0.722924f, -0.723056f,
	-0.723188f, -0.723321f, -0.723453f, -0.723586f, -0.723718f, -0.723850f, -0.723983f, -0.724115f,
	-0.724247f, -0.724379f, -0.724511f, -0.724644f, -0.724776f, -0.724908f, -0.725040f, -0.725172f,
	-0.725304f, -0.725436f, -0.725568f, -0.725700f, -0.725832f, -0.725964f, -0.726095f, -0.726227f,
	-0.726359f, -0.726491f, -0.726623f, -0.726754f, -0.726886f, -0.727018f, -0.727149f, -0.727281f,
	-0.727413f, -0.727544f, -0.727676f, -0.727807f, -0.727939f, -0.728070f, -0.728202f, -0.728333f,
	-0.728464f, -0.728596f, -0.728727f, -0.728858f, -0.728990f, -0.729121f, -0.729252f, -0.729383f,
	-0.729514f, -0.729646f, -0.729777f, -0.729908f, -0.730039f, -0.730170f, -0.730301f, -0.730432f,
	-0.730563f, -0.730694f, -0.730825f, -0.730955f, -0.731086f, -0.731217f, -0.731348f, -0.731479f,
	-0.731609f, -0.731740f, -0.731871f, -0.732001f, -0.732132f, -0.732263f, -0.732393f, -0.732524f,
	-0.732654f, -0.732785f, -0.732915f, -0.733046f, -0.733176f, -0.733306f, -0.733437f, -0.733567f,
	-0.733697f, -0.733828f, -0.733958f, -0.734088f, -0.734218f, -0.734349f, -0.734479f, -0.734609f,
	-0.734739f, -0.734869f, -0.734999f, -0.735129f, -0.735259f, -0.735389f, -0.735519f, -0.735649f,
	-0.735779f, -0.735908f, -0.736038f, -0.736168f, -0.736298f, -0.736428f, -0.736557f, -0.736687f,
	-0.736817f, -0.736946f, -0.737076f, -0.737205f, -0.737335f, -0.737464f, -0.737594f, -0.737723f,
	-0.737853f, -0.737982f, -0.738112f, -0.738241f, -0.738370f, -0.738500f, -0.738629f, -0.738758f,
	-0.738887f, -0.739017f, -0.739146f, -0.739275f, -0.739404f, -0.739533f, -0.739662f, -0.739791f,
	-0.739920f, -0.740049f, -0.740178f, -0.740307f, -0.740436f, -0.740565f, -0.740694f, -0.740822f,
	-0.740951f, -0.741080f, -0.741209f, -0.741337f, -0.741466f, -0.741595f, -0.741723f, -0.741852f,
	-0.741980f, -0.742109f, -0.742237f, -0.742366f, -0.742494f, -0.742623f, -0.742751f, -0.742880f,
	-0.743008f, -0.743136f, -0.743265f, -0.743393f, -0.743521f, -0.743649f, -0.743777f, -0.743906f,
	-0.744034f, -0.744162f, -0.744290f, -0.744418f, -0.744546f, -0.744674f, -0.744802f, -0.744930f,
	-0.745058f, -0.745186f, -0.745314f, -0.745441f, -0.745569f, -0.745697f, -0.745825f, -0.745952f,
	-0.746080f, -0.746208f, -0.746335f, -0.746463f, -0.746591f, -0.746718f, -0.746846f, -0.746973f,
	-0.747101f, -0.747228f, -0.747355f, -0.747483f, -0.747610f, -0.747738f, -0.747865f, -0.747992f,
	-0.748119f, -0.748247f, -0.748374f, -0.748501f, -0.748628f, -0.748755f, -0.748882f, -0.749009f,
	-0.749136f, -0.749263f, -0.749390f, -0.749517f, -0.749644f, -0.749771f, -0.749898f, -0.750025f,
	-0.750152f, -0.750278f, -0.750405f, -0.750532f, -0.750659f, -0.750785f, -0.750912f, -0.751039f,
	-0.751165f, -0.751292f, -0.751418f, -0.751545f, -0.751671f, -0.751798f, -0.751924f, -0.752050f,
	-0.752177f, -0.752303f, -0.752429f, -0.752556f, -0.752682f, -0.752808f, -0.752934f, -0.753061f,
	-0.753187f, -0.753313f, -0.753439f, -0.753565f, -0.753691f, -0.753817f, -0.753943f, -0.754069f,
	-0.754195f, -0.754321f, -0.754447f, -0.754573f, -0.754698f, -0.754824f, -0.754950f, -0.755076f,
	-0.755201f, -0.755327f, -0.755453f, -0.755578f, -0.755704f, -0.755829f, -0.755955f, -0.756081f,
	-0.756206f, -0.756331f, -0.756457f, -0.756582f, -0.756708f, -0.756833f, -0.756958f, -0.757084f,
	-0.757209f, -0.757334f, -0.757459f, -0.757584f, -0.757710f, -0.757835f, -0.757960f, -0.758085f,
	-0.758210f, -0.758335f, -0.758460f, -0.758585f, -0.758710f, -0.758835f, -0.758960f, -0.759084f,
	-0.759209f, -0.759334f, -0.759459f, -0.759583f, -0.759708f, -0.759833f, -0.759957f, -0.760082f,
	-0.760207f, -0.760331f, -0.760456f, -0.760580f, -0.760705f, -0.760829f, -0.760954f, -0.761078f,
	-0.761202f, -0.761327f, -0.761451f, -0.761575f, -0.761700f, -0.761824f, -0.761948f, -0.762072f,
	-0.762196f, -0.762320f, -0.762444f, -0.762569f, -0.762693f, -0.762817f, -0.762941f, -0.763065f,
	-0.763188f, -0.763312f, -0.763436f, -0.763560f, -0.763684f, -0.763808f, -0.763931f, -0.764055f,
	-0.764179f, -0.764302f, -0.764426f, -0.764550f, -0.764673f, -0.764797f, -0.764920f, -0.765044f,
	-0.765167f, -0.765291f, -0.765414f, -0.765538f, -0.765661f, -0.765784f, -0.765907f, -0.766031f,
	-0.766154f, -0.766277f, -0.766400f, -0.766524f, -0.766647f, -0.766770f, -0.766893f, -0.767016f,
	-0.767139f, -0.767262f, -0.767385f, -0.767508f, -0.767631f, -0.767754f, -0.767876f, -0.767999f,
	-0.768122f, -0.768245f, -0.768368f, -0.768490f, -0.768613f, -0.768736f, -0.768858f, -0.768981f,
	-0.769103f, -0.769226f, -0.769348f, -0.769471f, -0.769593f, -0.769716f, -0.769838f, -0.769961f,
	-0.770083f, -0.770205f, -0.770327f, -0.770450f, -0.770572f, -0.770694f, -0.770816f, -0.770938f,
	-0.771061f, -0.771183f, -0.771305f, -0.771427f, -0.771549f, -0.771671f, -0.771793f, -0.771915f,
	-0.772036f, -0.772158f, -0.772280f, -0.772402f, -0.772524f, -0.772645f, -0.772767f, -0.772889f,
	-0.773010f, -0.773132f, -0.773254f, -0.773375f, -0.773497f, -0.773618f, -0.773740f, -0.773861f,
	-0.773983f, -0.774104f, -0.774225f, -0.774347f, -0.774468f, -0.774589f, -0.774711f, -0.774832f,
	-0.774953f, -0.775074f, -0.775195f, -0.775317f, -0.775438f, -0.775559f, -0.775680f, -0.775801f,
	-0.775922f, -0.776043f, -0.776164f, -0.776284f, -0.776405f, -0.776526f, -0.776647f, -0.776768f,
	-0.776888f, -0.777009f, -0.777130f, -0.777251f, -0.777371f, -0.777492f, -0.777612f, -0.777733f,
	-0.777853f, -0.777974f, -0.778094f, -0.778215f, -0.778335f, -0.778456f, -0.778576f, -0.778696f,
	-0.778817f, -0.778937f, -0.779057f, -0.779177f, -0.779297f, -0.779418f, -0.779538f, -0.779658f,
	-0.779778f, -0.779898f, -0.780018f, -0.780138f, -0.780258f, -0.780378f, -0.780498f, -0.780617f,
	-0.780737f, -0.780857f, -0.780977f, -0.781097f, -0.781216f, -0.781336f, -0.781456f, -0.781575f,
	-0.781695f, -0.781814f, -0.781934f, -0.782053f, -0.782173f, -0.782292f, -0.782412f, -0.782531f,
	-0.782651f, -0.782770f, -0.782889f, -0.783009f, -0.783128f, -0.783247f, -0.783366f, -0.783485f,
	-0.783605f, -0.783724f, -0.783843f, -0.783962f, -0.784081f, -0.784200f, -0.784319f, -0.784438f,
	-0.784557f, -0.784675f, -0.784794f, -0.784913f, -0.785032f, -0.785151f, -0.785269f, -0.785388f,
	-0.785507f, -0.785625f, -0.785744f, -0.785863f, -0.785981f, -0.786100f, -0.786218f, -0.786337f,
	-0.786455f, -0.786574f, -0.786692f, -0.786810f, -0.786929f, -0.787047f, -0.787165f, -0.787284f,
	-0.787402f, -0.787520f, -0.787638f, -0.787756f, -0.787874f, -0.787992f, -0.788110f, -0.788228f,
	-0.788346f, -0.788464f, -0.788582f, -0.788700f, -0.788818f, -0.788936f, -0.789054f, -0.789172f,
	-0.789289f, -0.789407f, -0.789525f, -0.789642f, -0.789760f, -0.789878f, -0.789995f, -0.790113f,
	-0.790230f, -0.790348f, -0.790465f, -0.790583f, -0.790700f, -0.790817f, -0.790935f, -0.791052f,
	-0.791169f, -0.791287f, -0.791404f, -0.791521f, -0.791638f, -0.791755f, -0.791872f, -0.791990f,
	-0.792107f, -0.792224f, -0.792341f, -0.792458f, -0.792575f, -0.792691f, -0.792808f, -0.792925f,
	-0.793042f, -0.793159f, -0.793276f, -0.793392f, -0.793509f, -0.793626f, -0.793742f, -0.793859f,
	-0.793975f, -0.794092f, -0.794209f, -0.794325f, -0.794442f, -0.794558f, -0.794674f, -0.794791f,
	-0.794907f, -0.795023f, -0.795140f, -0.795256f, -0.795372f, -0.795488f, -0.795605f, -0.795721f,
	-0.795837f, -0.795953f, -0.796069f, -0.796185f, -0.796301f, -0.796417f, -0.796533f, -0.796649f,
	-0.796765f, -0.796881f, -0.796996f, -0.797112f, -0.797228f, -0.797344f, -0.797459f, -0.797575f,
	-0.797691f, -0.797806f, -0.797922f, -0.798038f, -0.798153f, -0.798269f, -0.798384f, -0.798500f,
	-0.798615f, -0.798730f, -0.798846f, -0.798961f, -0.799076f, -0.799192f, -0.799307f, -0.799422f,
	-0.799537f, -0.799652f, -0.799768f, -0.799883f, -0.799998f, -0.800113f, -0.800228f, -0.800343f,
	-0.800458f, -0.800573f, -0.800687f, -0.800802f, -0.800917f, -0.801032f, -0.801147f, -0.801261f,
	-0.801376f, -0.801491f, -0.801606f, -0.801720f, -0.801835f, -0.801949f, -0.802064f, -0.802178f,
	-0.802293f, -0.802407f, -0.802522f, -0.802636f, -0.802750f, -0.802865f, -0.802979f, -0.803093f,
	-0.803208f, -0.803322f, -0.803436f, -0.803550f, -0.803664f, -0.803778f, -0.803892f, -0.804006f,
	-0.804120f, -0.804234f, -0.804348f, -0.804462f, -0.804576f, -0.804690f, -0.804804f, -0.804918f,
	-0.805031f, -0.805145f, -0.805259f, -0.805372f, -0.805486f, -0.805600f, -0.805713f, -0.805827f,
	-0.805940f, -0.806054f, -0.806167f, -0.806281f, -0.806394f, -0.806508f, -0.806621f, -0.806734f,
	-0.806848f, -0.806961f, -0.807074f, -0.807187f, -0.807300f, -0.807414f, -0.807527f, -0.807640f,
	-0.807753f, -0.807866f, -0.807979f, -0.808092f, -0.808205f, -0.808318f, -0.808430f, -0.808543f,
	-0.808656f, -0.808769f, -0.808882f, -0.808994f, -0.809107f, -0.809220f, -0.809332f, -0.809445f,
	-0.809558f, -0.809670f, -0.809783f, -0.809895f, -0.810008f, -0.810120f, -0.810232f, -0.810345f,
	-0.810457f, -0.810570f, -0.810682f, -0.810794f, -0.810906f, -0.811018f, -0.811131f, -0.811243f,
	-0.811355f, -0.811467f, -0.811579f, -0.811691f, -0.811803f, -0.811915f, -0.812027f, -0.812139f,
	-0.812251f, -0.812362f, -0.812474f, -0.812586f, -0.812698f, -0.812809f, -0.812921f, -0.813033f,
	-0.813144f, -0.813256f, -0.813368f, -0.813479f, -0.813591f, -0.813702f, -0.813814f, -0.813925f,
	-0.814036f, -0.814148f, -0.814259f, -0.814370f, -0.814482f, -0.814593f, -0.814704f, -0.814815f,
	-0.814926f, -0.815037f, -0.815149f, -0.815260f, -0.815371f, -0.815482f, -0.815593f, -0.815704f,
	-0.815814f, -0.815925f, -0.816036f, -0.816147f, -0.816258f, -0.816368f, -0.816479f, -0.816590f,
	-0.816701f, -0.816811f, -0.816922f, -0.817032f, -0.817143f, -0.817253f, -0.817364f, -0.817474f,
	-0.817585f, -0.817695f, -0.817806f, -0.817916f, -0.818026f, -0.818137f, -0.818247f, -0.818357f,
	-0.818467f, -0.818577f, -0.818687f, -0.818798f, -0.818908f, -0.819018f, -0.819128f, -0.819238f,
	-0.819348f, -0.819457f, -0.819567f, -0.819677f, -0.819787f, -0.819897f, -0.820007f, -0.820116f,
	-0.820226f, -0.820336f, -0.820445f, -0.820555f, -0.820664f, -0.820774f, -0.820884f, -0.820993f,
	-0.821102f, -0.821212f, -0.821321f, -0.821431f, -0.821540f, -0.821649f, -0.821759f, -0.821868f,
	-0.821977f, -0.822086f, -0.822195f, -0.822305f, -0.822414f, -0.822523f, -0.822632f, -0.822741f,
	-0.822850f, -0.822959f, -0.823068f, -0.823177f, -0.823285f, -0.823394f, -0.823503f, -0.823612f,
	-0.823721f, -0.823829f, -0.823938f, -0.824047f, -0.824155f, -0.824264f, -0.824372f, -0.824481f,
	-0.824589f, -0.824698f, -0.824806f, -0.824915f, -0.825023f, -0.825131f, -0.825240f, -0.825348f,
	-0.825456f, -0.825564f, -0.825673f, -0.825781f, -0.825889f, -0.825997f, -0.826105f, -0.826213f,
	-0.826321f, -0.826429f, -0.826537f, -0.826645f, -0.826753f, -0.826861f, -0.826968f, -0.827076f,
	-0.827184f, -0.827292f, -0.827399f, -0.827507f, -0.827615f, -0.827722f, -0.827830f, -0.827938f,
	-0.828045f, -0.828153f, -0.828260f, -0.828367f, -0.828475f, -0.828582f, -0.828690f, -0.828797f,
	-0.828904f, -0.829011f, -0.829119f, -0.829226f, -0.829333f, -0.829440f, -0.829547f, -0.829654f,
	-0.829761f, -0.829868f, -0.829975f, -0.830082f, -0.830189f, -0.830296f, -0.830403f, -0.830510f,
	-0.830616f, -0.830723f, -0.830830f, -0.830937f, -0.831043f, -0.831150f, -0.831257f, -0.831363f,
	-0.831470f, -0.831576f, -0.831683f, -0.831789f, -0.831895f, -0.832002f, -0.832108f, -0.832215f,
	-0.832321f, -0.832427f, -0.832533f, -0.832640f, -0.832746f, -0.832852f, -0.832958f, -0.833064f,
	-0.833170f, -0.833276f, -0.833382f, -0.833488f, -0.833594f, -0.833700f, -0.833806f, -0.833912f,
	-0.834018f, -0.834123f, -0.834229f, -0.834335f, -0.834440f, -0.834546f, -0.834652f, -0.834757f,
	-0.834863f, -0.834968f, -0.835074f, -0.835179f, -0.835285f, -0.835390f, -0.835496f, -0.835601f,
	-0.835706f, -0.835812f, -0.835917f, -0.836022f, -0.836127f, -0.836232f, -0.836338f, -0.836443f,
	-0.836548f, -0.836653f, -0.836758f, -0.836863f, -0.836968f, -0.837073f, -0.837178f, -0.837282f,
	-0.837387f, -0.837492f, -0.837597f, -0.837701f, -0.837806f, -0.837911f, -0.838015f, -0.838120f,
	-0.838225f, -0.838329f, -0.838434f, -0.838538f, -0.838643f, -0.838747f, -0.838852f, -0.838956f,
	-0.839060f, -0.839165f, -0.839269f, -0.839373f, -0.839477f, -0.839581f, -0.839686f, -0.839790f,
	-0.839894f, -0.839998f, -0.840102f, -0.840206f, -0.840310f, -0.840414f, -0.840518f, -0.840622f,
	-0.840725f, -0.840829f, -0.840933f, -0.841037f, -0.841140f, -0.841244f, -0.841348f, -0.841451f,
	-0.841555f, -0.841659f, -0.841762f, -0.841866f, -0.841969f, -0.842072f, -0.842176f, -0.842279f,
	-0.842383f, -0.842486f, -0.842589f, -0.842692f, -0.842796f, -0.842899f, -0.843002f, -0.843105f,
	-0.843208f, -0.843311f, -0.843414f, -0.843517f, -0.843620f, -0.843723f, -0.843826f, -0.843929f,
	-0.844032f, -0.844135f, -0.844238f, -0.844340f, -0.844443f, -0.844546f, -0.844648f, -0.844751f,
	-0.844854f, -0.844956f, -0.845059f, -0.845161f, -0.845264f, -0.845366f, -0.845469f, -0.845571f,
	-0.845673f, -0.845776f, -0.845878f, -0.845980f, -0.846082f, -0.846185f, -0.846287f, -0.846389f,
	-0.846491f, -0.846593f, -0.846695f, -0.846797f, -0.846899f, -0.847001f, -0.847103f, -0.847205f,
	-0.847307f, -0.847408f, -0.847510f, -0.847612f, -0.847714f, -0.847815f, -0.847917f, -0.848019f,
	-0.848120f, -0.848222f, -0.848323f, -0.848425f, -0.848526f, -0.848628f, -0.848729f, -0.848831f,
	-0.848932f, -0.849033f, -0.849135f, -0.849236f, -0.849337f, -0.849438f, -0.849540f, -0.849641f,
	-0.849742f, -0.849843f, -0.849944f, -0.850045f, -0.850146f, -0.850247f, -0.850348f, -0.850449f,
	-0.850549f, -0.850650f, -0.850751f, -0.850852f, -0.850953f, -0.851053f, -0.851154f, -0.851255f,
	-0.851355f, -0.851456f, -0.851556f, -0.851657f, -0.851757f, -0.851858f, -0.851958f, -0.852059f,
	-0.852159f, -0.852259f, -0.852360f, -0.852460f, -0.852560f, -0.852660f, -0.852760f, -0.852861f,
	-0.852961f, -0.853061f, -0.853161f, -0.853261f, -0.853361f, -0.853461f, -0.853561f, -0.853660f,
	-0.853760f, -0.853860f, -0.853960f, -0.854060f, -0.854159f, -0.854259f, -0.854359f, -0.854458f,
	-0.854558f, -0.854658f, -0.854757f, -0.854857f, -0.854956f, -0.855056f, -0.855155f, -0.855254f,
	-0.855354f, -0.855453f, -0.855552f, -0.855651f, -0.855751f, -0.855850f, -0.855949f, -0.856048f,
	-0.856147f, -0.856246f, -0.856345f, -0.856444f, -0.856543f, -0.856642f, -0.856741f, -0.856840f,
	-0.856939f, -0.857038f, -0.857137f, -0.857235f, -0.857334f, -0.857433f, -0.857531f, -0.857630f,
	-0.857729f, -0.857827f, -0.857926f, -0.858024f, -0.858123f, -0.858221f, -0.858320f, -0.858418f,
	-0.858516f, -0.858615f, -0.858713f, -0.858811f, -0.858909f, -0.859007f, -0.859106f, -0.859204f,
	-0.859302f, -0.859400f, -0.859498f, -0.859596f, -0.859694f, -0.859792f, -0.859890f, -0.859988f,
	-0.860085f, -0.860183f, -0.860281f, -0.860379f, -0.860476f, -0.860574f, -0.860672f, -0.860769f,
	-0.860867f, -0.860964f, -0.861062f, -0.861160f, -0.861257f, -0.861354f, -0.861452f, -0.861549f,
	-0.861646f, -0.861744f, -0.861841f, -0.861938f, -0.862035f, -0.862133f, -0.862230f, -0.862327f,
	-0.862424f, -0.862521f, -0.862618f, -0.862715f, -0.862812f, -0.862909f, -0.863006f, -0.863103f,
	-0.863199f, -0.863296f, -0.863393f, -0.863490f, -0.863586f, -0.863683f, -0.863780f, -0.863876f,
	-0.863973f, -0.864069f, -0.864166f, -0.864262f, -0.864359f, -0.864455f, -0.864552f, -0.864648f,
	-0.864744f, -0.864841f, -0.864937f, -0.865033f, -0.865129f, -0.865225f, -0.865321f, -0.865418f,
	-0.865514f, -0.865610f, -0.865706f, -0.865802f, -0.865898f, -0.865993f, -0.866089f, -0.866185f,
	-0.866281f, -0.866377f, -0.866472f, -0.866568f, -0.866664f, -0.866759f, -0.866855f, -0.866951f,
	-0.867046f, -0.867142f, -0.867237f, -0.867333f, -0.867428f, -0.867523f, -0.867619f, -0.867714f,
	-0.867809f, -0.867905f, -0.868000f, -0.868095f, -0.868190f, -0.868285f, -0.868381f, -0.868476f,
	-0.868571f, -0.868666f, -0.868761f, -0.868856f, -0.868951f, -0.869045f, -0.869140f, -0.869235f,
	-0.869330f, -0.869425f, -0.869519f, -0.869614f, -0.869709f, -0.869803f, -0.869898f, -0.869992f,
	-0.870087f, -0.870182f, -0.870276f, -0.870370f, -0.870465f, -0.870559f, -0.870654f, -0.870748f,
	-0.870842f, -0.870936f, -0.871031f, -0.871125f, -0.871219f, -0.871313f, -0.871407f, -0.871501f,
	-0.871595f, -0.871689f, -0.871783f, -0.871877f, -0.871971f, -0.872065f, -0.872159f, -0.872252f,
	-0.872346f, -0.872440f, -0.872534f, -0.872627f, -0.872721f, -0.872814f, -0.872908f, -0.873001f,
	-0.873095f, -0.873188f, -0.873282f, -0.873375f, -0.873469f, -0.873562f, -0.873655f, -0.873749f,
	-0.873842f, -0.873935f, -0.874028f, -0.874121f, -0.874215f, -0.874308f, -0.874401f, -0.874494f,
	-0.874587f, -0.874680f, -0.874773f, -0.874865f, -0.874958f, -0.875051f, -0.875144f, -0.875237f,
	-0.875329f, -0.875422f, -0.875515f, -0.875607f, -0.875700f, -0.875793f, -0.875885f, -0.875978f,
	-0.876070f, -0.876163f, -0.876255f, -0.876347f, -0.876440f, -0.876532f, -0.876624f, -0.876716f,
	-0.876809f, -0.876901f, -0.876993f, -0.877085f, -0.877177f, -0.877269f, -0.877361f, -0.877453f,
	-0.877545f, -0.877637f, -0.877729f, -0.877821f, -0.877913f, -0.878005f, -0.878096f, -0.878188f,
	-0.878280f, -0.878371f, -0.878463f, -0.878555f, -0.878646f, -0.878738f, -0.878829f, -0.878921f,
	-0.879012f, -0.879104f, -0.879195f, -0.879286f, -0.879378f, -0.879469f, -0.879560f, -0.879651f,
	-0.879743f, -0.879834f, -0.879925f, -0.880016f, -0.880107f, -0.880198f, -0.880289f, -0.880380f,
	-0.880471f, -0.880562f, -0.880653f, -0.880743f, -0.880834f, -0.880925f, -0.881016f, -0.881106f,
	-0.881197f, -0.881288f, -0.881378f, -0.881469f, -0.881559f, -0.881650f, -0.881740f, -0.881831f,
	-0.881921f, -0.882012f, -0.882102f, -0.882192f, -0.882283f, -0.882373f, -0.882463f, -0.882553f,
	-0.882643f, -0.882733f, -0.882824f, -0.882914f, -0.883004f, -0.883094f, -0.883184f, -0.883273f,
	-0.883363f, -0.883453f, -0.883543f, -0.883633f, -0.883723f, -0.883812f, -0.883902f, -0.883992f,
	-0.884081f, -0.884171f, -0.884260f, -0.884350f, -0.884439f, -0.884529f, -0.884618f, -0.884708f,
	-0.884797f, -0.884886f, -0.884976f, -0.885065f, -0.885154f, -0.885243f, -0.885333f, -0.885422f,
	-0.885511f, -0.885600f, -0.885689f, -0.885778f, -0.885867f, -0.885956f, -0.886045f, -0.886134f,
	-0.886223f, -0.886311f, -0.886400f, -0.886489f, -0.886578f, -0.886666f, -0.886755f, -0.886844f,
	-0.886932f, -0.887021f, -0.887109f, -0.887198f, -0.887286f, -0.887375f, -0.887463f, -0.887551f,
	-0.887640f, -0.887728f, -0.887816f, -0.887904f, -0.887993f, -0.888081f, -0.888169f, -0.888257f,
	-0.888345f, -0.888433f, -0.888521f, -0.888609f, -0.888697f, -0.888785f, -0.888873f, -0.888961f,
	-0.889048f, -0.889136f, -0.889224f, -0.889312f, -0.889399f, -0.889487f, -0.889574f, -0.889662f,
	-0.889750f, -0.889837f, -0.889925f, -0.890012f, -0.890099f, -0.890187f, -0.890274f, -0.890361f,
	-0.890449f, -0.890536f, -0.890623f, -0.890710f, -0.890797f, -0.890885f, -0.890972f, -0.891059f,
	-0.891146f, -0.891233f, -0.891320f, -0.891407f, -0.891493f, -0.891580f, -0.891667f, -0.891754f,
	-0.891841f, -0.891927f, -0.892014f, -0.892101f, -0.892187f, -0.892274f, -0.892361f, -0.892447f,
	-0.892534f, -0.892620f, -0.892706f, -0.892793f, -0.892879f, -0.892965f, -0.893052f, -0.893138f,
	-0.893224f, -0.893310f, -0.893397f, -0.893483f, -0.893569f, -0.893655f, -0.893741f, -0.893827f,
	-0.893913f, -0.893999f, -0.894085f, -0.894171f, -0.894256f, -0.894342f, -0.894428f, -0.894514f,
	-0.894599f, -0.894685f, -0.894771f, -0.894856f, -0.894942f, -0.895028f, -0.895113f, -0.895198f,
	-0.895284f, -0.895369f, -0.895455f, -0.895540f, -0.895625f, -0.895711f, -0.895796f, -0.895881f,
	-0.895966f, -0.896051f, -0.896137f, -0.896222f, -0.896307f, -0.896392f, -0.896477f, -0.896562f,
	-0.896646f, -0.896731f, -0.896816f, -0.896901f, -0.896986f, -0.897071f, -0.897155f, -0.897240f,
	-0.897325f, -0.897409f, -0.897494f, -0.897578f, -0.897663f, -0.897747f, -0.897832f, -0.897916f,
	-0.898001f, -0.898085f, -0.898169f, -0.898254f, -0.898338f, -0.898422f, -0.898506f, -0.898590f,
	-0.898674f, -0.898759f, -0.898843f, -0.898927f, -0.899011f, -0.899095f, -0.899179f, -0.899262f,
	-0.899346f, -0.899430f, -0.899514f, -0.899598f, -0.899681f, -0.899765f, -0.899849f, -0.899932f,
	-0.900016f, -0.900099f, -0.900183f, -0.900266f, -0.900350f, -0.900433f, -0.900517f, -0.900600f,
	-0.900683f, -0.900767f, -0.900850f, -0.900933f, -0.901016f, -0.901100f, -0.901183f, -0.901266f,
	-0.901349f, -0.901432f, -0.901515f, -0.901598f, -0.901681f, -0.901764f, -0.901847f, -0.901929f,
	-0.902012f, -0.902095f, -0.902178f, -0.902260f, -0.902343f, -0.902426f, -0.902508f, -0.902591f,
	-0.902673f, -0.902756f, -0.902838f, -0.902921f, -0.903003f, -0.903085f, -0.903168f, -0.903250f,
	-0.903332f, -0.903415f, -0.903497f, -0.903579f, -0.903661f, -0.903743f, -0.903825f, -0.903907f,
	-0.903989f, -0.904071f, -0.904153f, -0.904235f, -0.904317f, -0.904399f, -0.904481f, -0.904562f,
	-0.904644f, -0.904726f, -0.904807f, -0.904889f, -0.904971f, -0.905052f, -0.905134f, -0.905215f,
	-0.905297f, -0.905378f, -0.905460f, -0.905541f, -0.905622f, -0.905704f, -0.905785f, -0.905866f,
	-0.905947f, -0.906028f, -0.906110f, -0.906191f, -0.906272f, -0.906353f, -0.906434f, -0.906515f,
	-0.906596f, -0.906677f, -0.906757f, -0.906838f, -0.906919f, -0.907000f, -0.907081f, -0.907161f,
	-0.907242f, -0.907323f, -0.907403f, -0.907484f, -0.907564f, -0.907645f, -0.907725f, -0.907806f,
	-0.907886f, -0.907966f, -0.908047f, -0.908127f, -0.908207f, -0.908288f, -0.908368f, -0.908448f,
	-0.908528f, -0.908608f, -0.908688f, -0.908768f, -0.908848f, -0.908928f, -0.909008f, -0.909088f,
	-0.909168f, -0.909248f, -0.909328f, -0.909407f, -0.909487f, -0.909567f, -0.909646f, -0.909726f,
	-0.909806f, -0.909885f, -0.909965f, -0.910044f, -0.910124f, -0.910203f, -0.910283f, -0.910362f,
	-0.910441f, -0.910521f, -0.910600f, -0.910679f, -0.910758f, -0.910837f, -0.910917f, -0.910996f,
	-0.911075f, -0.911154f, -0.911233f, -0.911312f, -0.911391f, -0.911470f, -0.911548f, -0.911627f,
	-0.911706f, -0.911785f, -0.911864f, -0.911942f, -0.912021f, -0.912099f, -0.912178f, -0.912257f,
	-0.912335f, -0.912414f, -0.912492f, -0.912571f, -0.912649f, -0.912727f, -0.912806f, -0.912884f,
	-0.912962f, -0.913040f, -0.913119f, -0.913197f, -0.913275f, -0.913353f, -0.913431f, -0.913509f,
	-0.913587f, -0.913665f, -0.913743f, -0.913821f, -0.913899f, -0.913976f, -0.914054f, -0.914132f,
	-0.914210f, -0.914287f, -0.914365f, -0.914443f, -0.914520f, -0.914598f, -0.914675f, -0.914753f,
	-0.914830f, -0.914908f, -0.914985f, -0.915062f, -0.915140f, -0.915217f, -0.915294f, -0.915372f,
	-0.915449f, -0.915526f, -0.915603f, -0.915680f, -0.915757f, -0.915834f, -0.915911f, -0.915988f,
	-0.916065f, -0.916142f, -0.916219f, -0.916296f, -0.916372f, -0.916449f, -0.916526f, -0.916602f,
	-0.916679f, -0.916756f, -0.916832f, -0.916909f, -0.916985f, -0.917062f, -0.917138f, -0.917215f,
	-0.917291f, -0.917367f, -0.917444f, -0.917520f, -0.917596f, -0.917672f, -0.917749f, -0.917825f,
	-0.917901f, -0.917977f, -0.918053f, -0.918129f, -0.918205f, -0.918281f, -0.918357f, -0.918433f,
	-0.918508f, -0.918584f, -0.918660f, -0.918736f, -0.918811f, -0.918887f, -0.918963f, -0.919038f,
	-0.919114f, -0.919189f, -0.919265f, -0.919340f, -0.919416f, -0.919491f, -0.919567f, -0.919642f,
	-0.919717f, -0.919792f, -0.919868f, -0.919943f, -0.920018f, -0.920093f, -0.920168f, -0.920243f,
	-0.920318f, -0.920393f, -0.920468f, -0.920543f, -0.920618f, -0.920693f, -0.920768f, -0.920842f,
	-0.920917f, -0.920992f, -0.921067f, -0.921141f, -0.921216f, -0.921291f, -0.921365f, -0.921440f,
	-0.921514f, -0.921588f, -0.921663f, -0.921737f, -0.921812f, -0.921886f, -0.921960f, -0.922034f,
	-0.922109f, -0.922183f, -0.922257f, -0.922331f, -0.922405f, -0.922479f, -0.922553f, -0.922627f,
	-0.922701f, -0.922775f, -0.922849f, -0.922923f, -0.922997f, -0.923070f, -0.923144f, -0.923218f,
	-0.923291f, -0.923365f, -0.923439f, -0.923512f, -0.923586f, -0.923659f, -0.923733f, -0.923806f,
	-0.923880f, -0.923953f, -0.924026f, -0.924100f, -0.924173f, -0.924246f, -0.924319f, -0.924392f,
	-0.924465f, -0.924539f, -0.924612f, -0.924685f, -0.924758f, -0.924831f, -0.924904f, -0.924976f,
	-0.925049f, -0.925122f, -0.925195f, -0.925268f, -0.925340f, -0.925413f, -0.925486f, -0.925558f,
	-0.925631f, -0.925703f, -0.925776f, -0.925848f, -0.925921f, -0.925993f, -0.926066f, -0.926138f,
	-0.926210f, -0.926283f, -0.926355f, -0.926427f, -0.926499f, -0.926571f, -0.926643f, -0.926715f,
	-0.926787f, -0.926859f, -0.926931f, -0.927003f, -0.927075f, -0.927147f, -0.927219f, -0.927291f,
	-0.927363f, -0.927434f, -0.927506f, -0.927578f, -0.927649f, -0.927721f, -0.927792f, -0.927864f,
	-0.927935f, -0.928007f, -0.928078f, -0.928150f, -0.928221f, -0.928292f, -0.928364f, -0.928435f,
	-0.928506f, -0.928577f, -0.928648f, -0.928720f, -0.928791f, -0.928862f, -0.928933f, -0.929004f,
	-0.929075f, -0.929146f, -0.929216f, -0.929287f, -0.929358f, -0.929429f, -0.929500f, -0.929570f,
	-0.929641f, -0.929712f, -0.929782f, -0.929853f, -0.929923f, -0.929994f, -0.930064f, -0.930135f,
	-0.930205f, -0.930275f, -0.930346f, -0.930416f, -0.930486f, -0.930556f, -0.930627f, -0.930697f,
	-0.930767f, -0.930837f, -0.930907f, -0.930977f, -0.931047f, -0.931117f, -0.931187f, -0.931257f,
	-0.931327f, -0.931397f, -0.931466f, -0.931536f, -0.931606f, -0.931675f, -0.931745f, -0.931815f,
	-0.931884f, -0.931954f, -0.932023f, -0.932093f, -0.932162f, -0.932232f, -0.932301f, -0.932370f,
	-0.932440f, -0.932509f, -0.932578f, -0.932647f, -0.932716f, -0.932786f, -0.932855f, -0.932924f,
	-0.932993f, -0.933062f, -0.933131f, -0.933200f, -0.933269f, -0.933337f, -0.933406f, -0.933475f,
	-0.933544f, -0.933612f, -0.933681f, -0.933750f, -0.933818f, -0.933887f, -0.933956f, -0.934024f,
	-0.934093f, -0.934161f, -0.934229f, -0.934298f, -0.934366f, -0.934434f, -0.934503f, -0.934571f,
	-0.934639f, -0.934707f, -0.934775f, -0.934844f, -0.934912f, -0.934980f, -0.935048f, -0.935116f,
	-0.935184f, -0.935251f, -0.935319f, -0.935387f, -0.935455f, -0.935523f, -0.935590f, -0.935658f,
	-0.935726f, -0.935793f, -0.935861f, -0.935928f, -0.935996f, -0.936063f, -0.936131f, -0.936198f,
	-0.936266f, -0.936333f, -0.936400f, -0.936468f, -0.936535f, -0.936602f, -0.936669f, -0.936736f,
	-0.936803f, -0.936871f, -0.936938f, -0.937005f, -0.937072f, -0.937138f, -0.937205f, -0.937272f,
	-0.937339f, -0.937406f, -0.937473f, -0.937539f, -0.937606f, -0.937673f, -0.937739f, -0.937806f,
	-0.937872f, -0.937939f, -0.938005f, -0.938072f, -0.938138f, -0.938205f, -0.938271f, -0.938337f,
	-0.938404f, -0.938470f, -0.938536f, -0.938602f, -0.938668f, -0.938734f, -0.938800f, -0.938866f,
	-0.938932f, -0.938998f, -0.939064f, -0.939130f, -0.939196f, -0.939262f, -0.939328f, -0.939394f,
	-0.939459f, -0.939525f, -0.939591f, -0.939656f, -0.939722f, -0.939787f, -0.939853f, -0.939918f,
	-0.939984f, -0.940049f, -0.940115f, -0.940180f, -0.940245f, -0.940310f, -0.940376f, -0.940441f,
	-0.940506f, -0.940571f, -0.940636f, -0.940701f, -0.940766f, -0.940831f, -0.940896f, -0.940961f,
	-0.941026f, -0.941091f, -0.941156f, -0.941221f, -0.941285f, -0.941350f, -0.941415f, -0.941479f,
	-0.941544f, -0.941609f, -0.941673f, -0.941738f, -0.941802f, -0.941867f, -0.941931f, -0.941995f,
	-0.942060f, -0.942124f, -0.942188f, -0.942253f, -0.942317f, -0.942381f, -0.942445f, -0.942509f,
	-0.942573f, -0.942637f, -0.942701f, -0.942765f, -0.942829f, -0.942893f, -0.942957f, -0.943021f,
	-0.943084f, -0.943148f, -0.943212f, -0.943276f, -0.943339f, -0.943403f, -0.943466f, -0.943530f,
	-0.943593f, -0.943657f, -0.943720f, -0.943784f, -0.943847f, -0.943910f, -0.943974f, -0.944037f,
	-0.944100f, -0.944163f, -0.944227f, -0.944290f, -0.944353f, -0.944416f, -0.944479f, -0.944542f,
	-0.944605f, -0.944668f, -0.944731f, -0.944793f, -0.944856f, -0.944919f, -0.944982f, -0.945045f,
	-0.945107f, -0.945170f, -0.945232f, -0.945295f, -0.945358f, -0.945420f, -0.945482f, -0.945545f,
	-0.945607f, -0.945670f, -0.945732f, -0.945794f, -0.945857f, -0.945919f, -0.945981f, -0.946043f,
	-0.946105f, -0.946167f, -0.946229f, -0.946291f, -0.946353f, -0.946415f, -0.946477f, -0.946539f,
	-0.946601f, -0.946663f, -0.946724f, -0.946786f, -0.946848f, -0.946910f, -0.946971f, -0.947033f,
	-0.947094f, -0.947156f, -0.947217f, -0.947279f, -0.947340f, -0.947402f, -0.947463f, -0.947524f,
	-0.947586f, -0.947647f, -0.947708f, -0.947769f, -0.947830f, -0.947891f, -0.947953f, -0.948014f,
	-0.948075f, -0.948136f, -0.948196f, -0.948257f, -0.948318f, -0.948379f, -0.948440f, -0.948501f,
	-0.948561f, -0.948622f, -0.948683f, -0.948743f, -0.948804f, -0.948864f, -0.948925f, -0.948985f,
	-0.949046f, -0.949106f, -0.949167f, -0.949227f, -0.949287f, -0.949348f, -0.949408f, -0.949468f,
	-0.949528f, -0.949588f, -0.949648f, -0.949708f, -0.949768f, -0.949829f, -0.949888f, -0.949948f,
	-0.950008f, -0.950068f, -0.950128f, -0.950188f, -0.950247f, -0.950307f, -0.950367f, -0.950426f,
	-0.950486f, -0.950546f, -0.950605f, -0.950665f, -0.950724f, -0.950784f, -0.950843f, -0.950902f,
	-0.950962f, -0.951021f, -0.951080f, -0.951139f, -0.951199f, -0.951258f, -0.951317f, -0.951376f,
	-0.951435f, -0.951494f, -0.951553f, -0.951612f, -0.951671f, -0.951730f, -0.951789f, -0.951847f,
	-0.951906f, -0.951965f, -0.952024f, -0.952082f, -0.952141f, -0.952199f, -0.952258f, -0.952317f,
	-0.952375f, -0.952433f, -0.952492f, -0.952550f, -0.952609f, -0.952667f, -0.952725f, -0.952783f,
	-0.952842f, -0.952900f, -0.952958f, -0.953016f, -0.953074f, -0.953132f, -0.953190f, -0.953248f,
	-0.953306f, -0.953364f, -0.953422f, -0.953480f, -0.953537f, -0.953595f, -0.953653f, -0.953711f,
	-0.953768f, -0.953826f, -0.953883f, -0.953941f, -0.953998f, -0.954056f, -0.954113f, -0.954171f,
	-0.954228f, -0.954285f, -0.954343f, -0.954400f, -0.954457f, -0.954514f, -0.954572f, -0.954629f,
	-0.954686f, -0.954743f, -0.954800f, -0.954857f, -0.954914f, -0.954971f, -0.955028f, -0.955084f,
	-0.955141f, -0.955198f, -0.955255f, -0.955311f, -0.955368f, -0.955425f, -0.955481f, -0.955538f,
	-0.955594f, -0.955651f, -0.955707f, -0.955764f, -0.955820f, -0.955876f, -0.955933f, -0.955989f,
	-0.956045f, -0.956101f, -0.956158f, -0.956214f, -0.956270f, -0.956326f, -0.956382f, -0.956438f,
	-0.956494f, -0.956550f, -0.956606f, -0.956662f, -0.956717f, -0.956773f, -0.956829f, -0.956885f,
	-0.956940f, -0.956996f, -0.957052f, -0.957107f, -0.957163f, -0.957218f, -0.957274f, -0.957329f,
	-0.957385f, -0.957440f, -0.957495f, -0.957550f, -0.957606f, -0.957661f, -0.957716f, -0.957771f,
	-0.957826f, -0.957882f, -0.957937f, -0.957992f, -0.958046f, -0.958101f, -0.958156f, -0.958211f,
	-0.958266f, -0.958321f, -0.958376f, -0.958430f, -0.958485f, -0.958540f, -0.958594f, -0.958649f,
	-0.958703f, -0.958758f, -0.958812f, -0.958867f, -0.958921f, -0.958976f, -0.959030f, -0.959084f,
	-0.959139f, -0.959193f, -0.959247f, -0.959301f, -0.959355f, -0.959409f, -0.959463f, -0.959518f,
	-0.959572f, -0.959625f, -0.959679f, -0.959733f, -0.959787f, -0.959841f, -0.959895f, -0.959948f,
	-0.960002f, -0.960056f, -0.960109f, -0.960163f, -0.960217f, -0.960270f, -0.960324f, -0.960377f,
	-0.960431f, -0.960484f, -0.960537f, -0.960591f, -0.960644f, -0.960697f, -0.960750f, -0.960804f,
	-0.960857f, -0.960910f, -0.960963f, -0.961016f, -0.961069f, -0.961122f, -0.961175f, -0.961228f,
	-0.961280f, -0.961333f, -0.961386f, -0.961439f, -0.961492f, -0.961544f, -0.961597f, -0.961649f,
	-0.961702f, -0.961755f, -0.961807f, -0.961860f, -0.961912f, -0.961964f, -0.962017f, -0.962069f,
	-0.962121f, -0.962174f, -0.962226f, -0.962278f, -0.962330f, -0.962382f, -0.962434f, -0.962486f,
	-0.962538f, -0.962590f, -0.962642f, -0.962694f, -0.962746f, -0.962798f, -0.962850f, -0.962902f,
	-0.962953f, -0.963005f, -0.963057f, -0.963108f, -0.963160f, -0.963211f, -0.963263f, -0.963314f,
	-0.963366f, -0.963417f, -0.963469f, -0.963520f, -0.963571f, -0.963623f, -0.963674f, -0.963725f,
	-0.963776f, -0.963827f, -0.963878f, -0.963929f, -0.963980f, -0.964031f, -0.964082f, -0.964133f,
	-0.964184f, -0.964235f, -0.964286f, -0.964336f, -0.964387f, -0.964438f, -0.964489f, -0.964539f,
	-0.964590f, -0.964640f, -0.964691f, -0.964741f, -0.964792f, -0.964842f, -0.964893f, -0.964943f,
	-0.964993f, -0.965044f, -0.965094f, -0.965144f, -0.965194f, -0.965244f, -0.965294f, -0.965344f,
	-0.965394f, -0.965444f, -0.965494f, -0.965544f, -0.965594f, -0.965644f, -0.965694f, -0.965744f,
	-0.965793f, -0.965843f, -0.965893f, -0.965942f, -0.965992f, -0.966042f, -0.966091f, -0.966141f,
	-0.966190f, -0.966239f, -0.966289f, -0.966338f, -0.966387f, -0.966437f, -0.966486f, -0.966535f,
	-0.966584f, -0.966633f, -0.966683f, -0.966732f, -0.966781f, -0.966830f, -0.966879f, -0.966928f,
	-0.966976f, -0.967025f, -0.967074f, -0.967123f, -0.967172f, -0.967220f, -0.967269f, -0.967318f,
	-0.967366f, -0.967415f, -0.967463f, -0.967512f, -0.967560f, -0.967609f, -0.967657f, -0.967706f,
	-0.967754f, -0.967802f, -0.967850f, -0.967899f, -0.967947f, -0.967995f, -0.968043f, -0.968091f,
	-0.968139f, -0.968187f, -0.968235f, -0.968283f, -0.968331f, -0.968379f, -0.968427f, -0.968474f,
	-0.968522f, -0.968570f, -0.968617f, -0.968665f, -0.968713f, -0.968760f, -0.968808f, -0.968855f,
	-0.968903f, -0.968950f, -0.968998f, -0.969045f, -0.969092f, -0.969140f, -0.969187f, -0.969234f,
	-0.969281f, -0.969328f, -0.969375f, -0.969423f, -0.969470f, -0.969517f, -0.969564f, -0.969611f,
	-0.969657f, -0.969704f, -0.969751f, -0.969798f, -0.969845f, -0.969891f, -0.969938f, -0.969985f,
	-0.970031f, -0.970078f, -0.970124f, -0.970171f, -0.970217f, -0.970264f, -0.970310f, -0.970357f,
	-0.970403f, -0.970449f, -0.970495f, -0.970542f, -0.970588f, -0.970634f, -0.970680f, -0.970726f,
	-0.970772f, -0.970818f, -0.970864f, -0.970910f, -0.970956f, -0.971002f, -0.971048f, -0.971093f,
	-0.971139f, -0.971185f, -0.971231f, -0.971276f, -0.971322f, -0.971367f, -0.971413f, -0.971458f,
	-0.971504f, -0.971549f, -0.971595f, -0.971640f, -0.971685f, -0.971731f, -0.971776f, -0.971821f,
	-0.971866f, -0.971911f, -0.971957f, -0.972002f, -0.972047f, -0.972092f, -0.972137f, -0.972182f,
	-0.972227f, -0.972271f, -0.972316f, -0.972361f, -0.972406f, -0.972450f, -0.972495f, -0.972540f,
	-0.972584f, -0.972629f, -0.972673f, -0.972718f, -0.972762f, -0.972807f, -0.972851f, -0.972896f,
	-0.972940f, -0.972984f, -0.973028f, -0.973073f, -0.973117f, -0.973161f, -0.973205f, -0.973249f,
	-0.973293f, -0.973337f, -0.973381f, -0.973425f, -0.973469f, -0.973513f, -0.973557f, -0.973601f,
	-0.973644f, -0.973688f, -0.973732f, -0.973775f, -0.973819f, -0.973862f, -0.973906f, -0.973949f,
	-0.973993f, -0.974036f, -0.974080f, -0.974123f, -0.974166f, -0.974210f, -0.974253f, -0.974296f,
	-0.974339f, -0.974383f, -0.974426f, -0.974469f, -0.974512f, -0.974555f, -0.974598f, -0.974641f,
	-0.974684f, -0.974726f, -0.974769f, -0.974812f, -0.974855f, -0.974897f, -0.974940f, -0.974983f,
	-0.975025f, -0.975068f, -0.975110f, -0.975153f, -0.975195f, -0.975238f, -0.975280f, -0.975323f,
	-0.975365f, -0.975407f, -0.975449f, -0.975492f, -0.975534f, -0.975576f, -0.975618f, -0.975660f,
	-0.975702f, -0.975744f, -0.975786f, -0.975828f, -0.975870f, -0.975912f, -0.975954f, -0.975995f,
	-0.976037f, -0.976079f, -0.976120f, -0.976162f, -0.976204f, -0.976245f, -0.976287f, -0.976328f,
	-0.976370f, -0.976411f, -0.976453f, -0.976494f, -0.976535f, -0.976576f, -0.976618f, -0.976659f,
	-0.976700f, -0.976741f, -0.976782f, -0.976823f, -0.976864f, -0.976905f, -0.976946f, -0.976987f,
	-0.977028f, -0.977069f, -0.977110f, -0.977151f, -0.977191f, -0.977232f, -0.977273f, -0.977313f,
	-0.977354f, -0.977394f, -0.977435f, -0.977475f, -0.977516f, -0.977556f, -0.977597f, -0.977637f,
	-0.977677f, -0.977718f, -0.977758f, -0.977798f, -0.977838f, -0.977878f, -0.977918f, -0.977959f,
	-0.977998f, -0.978038f, -0.978078f, -0.978118f, -0.978158f, -0.978198f, -0.978238f, -0.978278f,
	-0.978317f, -0.978357f, -0.978397f, -0.978436f, -0.978476f, -0.978516f, -0.978555f, -0.978594f,
	-0.978634f, -0.978673f, -0.978713f, -0.978752f, -0.978791f, -0.978831f, -0.978870f, -0.978909f,
	-0.978948f, -0.978987f, -0.979026f, -0.979065f, -0.979104f, -0.979143f, -0.979182f, -0.979221f,
	-0.979260f, -0.979299f, -0.979338f, -0.979376f, -0.979415f, -0.979454f, -0.979493f, -0.979531f,
	-0.979570f, -0.979608f, -0.979647f, -0.979685f, -0.979724f, -0.979762f, -0.979800f, -0.979839f,
	-0.979877f, -0.979915f, -0.979954f, -0.979992f, -0.980030f, -0.980068f, -0.980106f, -0.980144f,
	-0.980182f, -0.980220f, -0.980258f, -0.980296f, -0.980334f, -0.980372f, -0.980409f, -0.980447f,
	-0.980485f, -0.980523f, -0.980560f, -0.980598f, -0.980635f, -0.980673f, -0.980710f, -0.980748f,
	-0.980785f, -0.980823f, -0.980860f, -0.980897f, -0.980935f, -0.980972f, -0.981009f, -0.981046f,
	-0.981083f, -0.981120f, -0.981158f, -0.981195f, -0.981232f, -0.981269f, -0.981305f, -0.981342f,
	-0.981379f, -0.981416f, -0.981453f, -0.981490f, -0.981526f, -0.981563f, -0.981600f, -0.981636f,
	-0.981673f, -0.981709f, -0.981746f, -0.981782f, -0.981819f, -0.981855f, -0.981891f, -0.981928f,
	-0.981964f, -0.982000f, -0.982036f, -0.982072f, -0.982109f, -0.982145f, -0.982181f, -0.982217f,
	-0.982253f, -0.982289f, -0.982325f, -0.982360f, -0.982396f, -0.982432f, -0.982468f, -0.982504f,
	-0.982539f, -0.982575f, -0.982611f, -0.982646f, -0.982682f, -0.982717f, -0.982753f, -0.982788f,
	-0.982824f, -0.982859f, -0.982894f, -0.982930f, -0.982965f, -0.983000f, -0.983035f, -0.983070f,
	-0.983105f, -0.983141f, -0.983176f, -0.983211f, -0.983246f, -0.983281f, -0.983315f, -0.983350f,
	-0.983385f, -0.983420f, -0.983455f, -0.983489f, -0.983524f, -0.983559f, -0.983593f, -0.983628f,
	-0.983662f, -0.983697f, -0.983731f, -0.983766f, -0.983800f, -0.983835f, -0.983869f, -0.983903f,
	-0.983937f, -0.983972f, -0.984006f, -0.984040f, -0.984074f, -0.984108f, -0.984142f, -0.984176f,
	-0.984210f, -0.984244f, -0.984278f, -0.984312f, -0.984346f, -0.984379f, -0.984413f, -0.984447f,
	-0.984480f, -0.984514f, -0.984548f, -0.984581f, -0.984615f, -0.984648f, -0.984682f, -0.984715f,
	-0.984748f, -0.984782f, -0.984815f, -0.984848f, -0.984882f, -0.984915f, -0.984948f, -0.984981f,
	-0.985014f, -0.985047f, -0.985080f, -0.985113f, -0.985146f, -0.985179f, -0.985212f, -0.985245f,
	-0.985278f, -0.985310f, -0.985343f, -0.985376f, -0.985408f, -0.985441f, -0.985474f, -0.985506f,
	-0.985539f, -0.985571f, -0.985604f, -0.985636f, -0.985668f, -0.985701f, -0.985733f, -0.985765f,
	-0.985798f, -0.985830f, -0.985862f, -0.985894f, -0.985926f, -0.985958f, -0.985990f, -0.986022f,
	-0.986054f, -0.986086f, -0.986118f, -0.986150f, -0.986181f, -0.986213f, -0.986245f, -0.986276f,
	-0.986308f, -0.986340f, -0.986371f, -0.986403f, -0.986434f, -0.986466f, -0.986497f, -0.986529f,
	-0.986560f, -0.986591f, -0.986623f, -0.986654f, -0.986685f, -0.986716f, -0.986747f, -0.986778f,
	-0.986809f, -0.986840f, -0.986871f, -0.986902f, -0.986933f, -0.986964f, -0.986995f, -0.987026f,
	-0.987057f, -0.987087f, -0.987118f, -0.987149f, -0.987179f, -0.987210f, -0.987240f, -0.987271f,
	-0.987301f, -0.987332f, -0.987362f, -0.987393f, -0.987423f, -0.987453f, -0.987484f, -0.987514f,
	-0.987544f, -0.987574f, -0.987604f, -0.987634f, -0.987664f, -0.987694f, -0.987724f, -0.987754f,
	-0.987784f, -0.987814f, -0.987844f, -0.987874f, -0.987903f, -0.987933f, -0.987963f, -0.987992f,
	-0.988022f, -0.988052f, -0.988081f, -0.988111f, -0.988140f, -0.988169f, -0.988199f, -0.988228f,
	-0.988258f, -0.988287f, -0.988316f, -0.988345f, -0.988374f, -0.988404f, -0.988433f, -0.988462f,
	-0.988491f, -0.988520f, -0.988549f, -0.988578f, -0.988607f, -0.988635f, -0.988664f, -0.988693f,
	-0.988722f, -0.988750f, -0.988779f, -0.988808f, -0.988836f, -0.988865f, -0.988893f, -0.988922f,
	-0.988950f, -0.988979f, -0.989007f, -0.989035f, -0.989064f, -0.989092f, -0.989120f, -0.989148f,
	-0.989177f, -0.989205f, -0.989233f, -0.989261f, -0.989289f, -0.989317f, -0.989345f, -0.989373f,
	-0.989400f, -0.989428f, -0.989456f, -0.989484f, -0.989511f, -0.989539f, -0.989567f, -0.989594f,
	-0.989622f, -0.989650f, -0.989677f, -0.989704f, -0.989732f, -0.989759f, -0.989787f, -0.989814f,
	-0.989841f, -0.989869f, -0.989896f, -0.989923f, -0.989950f, -0.989977f, -0.990004f, -0.990031f,
	-0.990058f, -0.990085f, -0.990112f, -0.990139f, -0.990166f, -0.990193f, -0.990219f, -0.990246f,
	-0.990273f, -0.990299f, -0.990326f, -0.990353f, -0.990379f, -0.990406f, -0.990432f, -0.990459f,
	-0.990485f, -0.990511f, -0.990538f, -0.990564f, -0.990590f, -0.990617f, -0.990643f, -0.990669f,
	-0.990695f, -0.990721f, -0.990747f, -0.990773f, -0.990799f, -0.990825f, -0.990851f, -0.990877f,
	-0.990903f, -0.990928f, -0.990954f, -0.990980f, -0.991006f, -0.991031f, -0.991057f, -0.991082f,
	-0.991108f, -0.991133f, -0.991159f, -0.991184f, -0.991210f, -0.991235f, -0.991260f, -0.991286f,
	-0.991311f, -0.991336f, -0.991361f, -0.991386f, -0.991411f, -0.991437f, -0.991462f, -0.991487f,
	-0.991511f, -0.991536f, -0.991561f, -0.991586f, -0.991611f, -0.991636f, -0.991660f, -0.991685f,
	-0.991710f, -0.991734f, -0.991759f, -0.991783f, -0.991808f, -0.991832f, -0.991857f, -0.991881f,
	-0.991906f, -0.991930f, -0.991954f, -0.991979f, -0.992003f, -0.992027f, -0.992051f, -0.992075f,
	-0.992099f, -0.992123f, -0.992147f, -0.992171f, -0.992195f, -0.992219f, -0.992243f, -0.992267f,
	-0.992291f, -0.992314f, -0.992338f, -0.992362f, -0.992385f, -0.992409f, -0.992433f, -0.992456f,
	-0.992480f, -0.992503f, -0.992526f, -0.992550f, -0.992573f, -0.992596f, -0.992620f, -0.992643f,
	-0.992666f, -0.992689f, -0.992712f, -0.992736f, -0.992759f, -0.992782f, -0.992805f, -0.992828f,
	-0.992850f, -0.992873f, -0.992896f, -0.992919f, -0.992942f, -0.992964f, -0.992987f, -0.993010f,
	-0.993032f, -0.993055f, -0.993077f, -0.993100f, -0.993122f, -0.993145f, -0.993167f, -0.993190f,
	-0.993212f, -0.993234f, -0.993257f, -0.993279f, -0.993301f, -0.993323f, -0.993345f, -0.993367f,
	-0.993389f, -0.993411f, -0.993433f, -0.993455f, -0.993477f, -0.993499f, -0.993521f, -0.993542f,
	-0.993564f, -0.993586f, -0.993608f, -0.993629f, -0.993651f, -0.993672f, -0.993694f, -0.993715f,
	-0.993737f, -0.993758f, -0.993779f, -0.993801f, -0.993822f, -0.993843f, -0.993865f, -0.993886f,
	-0.993907f, -0.993928f, -0.993949f, -0.993970f, -0.993991f, -0.994012f, -0.994033f, -0.994054f,
	-0.994075f, -0.994096f, -0.994116f, -0.994137f, -0.994158f, -0.994179f, -0.994199f, -0.994220f,
	-0.994240f, -0.994261f, -0.994281f, -0.994302f, -0.994322f, -0.994343f, -0.994363f, -0.994383f,
	-0.994404f, -0.994424f, -0.994444f, -0.994464f, -0.994484f, -0.994505f, -0.994525f, -0.994545f,
	-0.994565f, -0.994585f, -0.994604f, -0.994624f, -0.994644f, -0.994664f, -0.994684f, -0.994703f,
	-0.994723f, -0.994743f, -0.994762f, -0.994782f, -0.994802f, -0.994821f, -0.994841f, -0.994860f,
	-0.994879f, -0.994899f, -0.994918f, -0.994937f, -0.994957f, -0.994976f, -0.994995f, -0.995014f,
	-0.995033f, -0.995052f, -0.995071f, -0.995090f, -0.995109f, -0.995128f, -0.995147f, -0.995166f,
	-0.995185f, -0.995203f, -0.995222f, -0.995241f, -0.995260f, -0.995278f, -0.995297f, -0.995315f,
	-0.995334f, -0.995352f, -0.995371f, -0.995389f, -0.995408f, -0.995426f, -0.995444f, -0.995463f,
	-0.995481f, -0.995499f, -0.995517f, -0.995535f, -0.995553f, -0.995571f, -0.995589f, -0.995607f,
	-0.995625f, -0.995643f, -0.995661f, -0.995679f, -0.995697f, -0.995714f, -0.995732f, -0.995750f,
	-0.995767f, -0.995785f, -0.995803f, -0.995820f, -0.995838f, -0.995855f, -0.995872f, -0.995890f,
	-0.995907f, -0.995925f, -0.995942f, -0.995959f, -0.995976f, -0.995993f, -0.996011f, -0.996028f,
	-0.996045f, -0.996062f, -0.996079f, -0.996096f, -0.996113f, -0.996129f, -0.996146f, -0.996163f,
	-0.996180f, -0.996197f, -0.996213f, -0.996230f, -0.996247f, -0.996263f, -0.996280f, -0.996296f,
	-0.996313f, -0.996329f, -0.996345f, -0.996362f, -0.996378f, -0.996394f, -0.996411f, -0.996427f,
	-0.996443f, -0.996459f, -0.996475f, -0.996491f, -0.996507f, -0.996523f, -0.996539f, -0.996555f,
	-0.996571f, -0.996587f, -0.996603f, -0.996619f, -0.996634f, -0.996650f, -0.996666f, -0.996681f,
	-0.996697f, -0.996712f, -0.996728f, -0.996743f, -0.996759f, -0.996774f, -0.996790f, -0.996805f,
	-0.996820f, -0.996836f, -0.996851f, -0.996866f, -0.996881f, -0.996896f, -0.996911f, -0.996926f,
	-0.996941f, -0.996956f, -0.996971f, -0.996986f, -0.997001f, -0.997016f, -0.997031f, -0.997045f,
	-0.997060f, -0.997075f, -0.997089f, -0.997104f, -0.997119f, -0.997133f, -0.997148f, -0.997162f,
	-0.997176f, -0.997191f, -0.997205f, -0.997219f, -0.997234f, -0.997248f, -0.997262f, -0.997276f,
	-0.997290f, -0.997305f, -0.997319f, -0.997333f, -0.997347f, -0.997361f, -0.997374f, -0.997388f,
	-0.997402f, -0.997416f, -0.997430f, -0.997443f, -0.997457f, -0.997471f, -0.997484f, -0.997498f,
	-0.997511f, -0.997525f, -0.997538f, -0.997552f, -0.997565f, -0.997579f, -0.997592f, -0.997605f,
	-0.997618f, -0.997632f, -0.997645f, -0.997658f, -0.997671f, -0.997684f, -0.997697f, -0.997710f,
	-0.997723f, -0.997736f, -0.997749f, -0.997762f, -0.997774f, -0.997787f, -0.997800f, -0.997813f,
	-0.997825f, -0.997838f, -0.997851f, -0.997863f, -0.997876f, -0.997888f, -0.997901f, -0.997913f,
	-0.997925f, -0.997938f, -0.997950f, -0.997962f, -0.997974f, -0.997987f, -0.997999f, -0.998011f,
	-0.998023f, -0.998035f, -0.998047f, -0.998059f, -0.998071f, -0.998083f, -0.998094f, -0.998106f,
	-0.998118f, -0.998130f, -0.998142f, -0.998153f, -0.998165f, -0.998176f, -0.998188f, -0.998200f,
	-0.998211f, -0.998222f, -0.998234f, -0.998245f, -0.998257f, -0.998268f, -0.998279f, -0.998290f,
	-0.998302f, -0.998313f, -0.998324f, -0.998335f, -0.998346f, -0.998357f, -0.998368f, -0.998379f,
	-0.998390f, -0.998401f, -0.998411f, -0.998422f, -0.998433f, -0.998444f, -0.998454f, -0.998465f,
	-0.998476f, -0.998486f, -0.998497f, -0.998507f, -0.998518f, -0.998528f, -0.998538f, -0.998549f,
	-0.998559f, -0.998569f, -0.998580f, -0.998590f, -0.998600f, -0.998610f, -0.998620f, -0.998630f,
	-0.998640f, -0.998650f, -0.998660f, -0.998670f, -0.998680f, -0.998690f, -0.998700f, -0.998709f,
	-0.998719f, -0.998729f, -0.998738f, -0.998748f, -0.998758f, -0.998767f, -0.998777f, -0.998786f,
	-0.998795f, -0.998805f, -0.998814f, -0.998824f, -0.998833f, -0.998842f, -0.998851f, -0.998860f,
	-0.998870f, -0.998879f, -0.998888f, -0.998897f, -0.998906f, -0.998915f, -0.998924f, -0.998932f,
	-0.998941f, -0.998950f, -0.998959f, -0.998968f, -0.998976f, -0.998985f, -0.998994f, -0.999002f,
	-0.999011f, -0.999019f, -0.999028f, -0.999036f, -0.999044f, -0.999053f, -0.999061f, -0.999069f,
	-0.999078f, -0.999086f, -0.999094f, -0.999102f, -0.999110f, -0.999118f, -0.999126f, -0.999134f,
	-0.999142f, -0.999150f, -0.999158f, -0.999166f, -0.999174f, -0.999182f, -0.999189f, -0.999197f,
	-0.999205f, -0.999212f, -0.999220f, -0.999228f, -0.999235f, -0.999243f, -0.999250f, -0.999257f,
	-0.999265f, -0.999272f, -0.999279f, -0.999287f, -0.999294f, -0.999301f, -0.999308f, -0.999315f,
	-0.999322f, -0.999329f, -0.999336f, -0.999343f, -0.999350f, -0.999357f, -0.999364f, -0.999371f,
	-0.999378f, -0.999384f, -0.999391f, -0.999398f, -0.999404f, -0.999411f, -0.999418f, -0.999424f,
	-0.999431f, -0.999437f, -0.999443f, -0.999450f, -0.999456f, -0.999462f, -0.999469f, -0.999475f,
	-0.999481f, -0.999487f, -0.999493f, -0.999500f, -0.999506f, -0.999512f, -0.999518f, -0.999524f,
	-0.999529f, -0.999535f, -0.999541f, -0.999547f, -0.999553f, -0.999558f, -0.999564f, -0.999570f,
	-0.999575f, -0.999581f, -0.999586f, -0.999592f, -0.999597f, -0.999603f, -0.999608f, -0.999614f,
	-0.999619f, -0.999624f, -0.999629f, -0.999635f, -0.999640f, -0.999645f, -0.999650f, -0.999655f,
	-0.999660f, -0.999665f, -0.999670f, -0.999675f, -0.999680f, -0.999685f, -0.999689f, -0.999694f,
	-0.999699f, -0.999704f, -0.999708f, -0.999713f, -0.999717f, -0.999722f, -0.999726f, -0.999731f,
	-0.999735f, -0.999740f, -0.999744f, -0.999748f, -0.999753f, -0.999757f, -0.999761f, -0.999765f,
	-0.999769f, -0.999774f, -0.999778f, -0.999782f, -0.999786f, -0.999790f, -0.999793f, -0.999797f,
	-0.999801f, -0.999805f, -0.999809f, -0.999812f, -0.999816f, -0.999820f, -0.999823f, -0.999827f,
	-0.999831f, -0.999834f, -0.999838f, -0.999841f, -0.999844f, -0.999848f, -0.999851f, -0.999854f,
	-0.999858f, -0.999861f, -0.999864f, -0.999867f, -0.999870f, -0.999873f, -0.999876f, -0.999879f,
	-0.999882f, -0.999885f, -0.999888f, -0.999891f, -0.999894f, -0.999897f, -0.999899f, -0.999902f,
	-0.999905f, -0.999907f, -0.999910f, -0.999913f, -0.999915f, -0.999917f, -0.999920f, -0.999922f,
	-0.999925f, -0.999927f, -0.999929f, -0.999932f, -0.999934f, -0.999936f, -0.999938f, -0.999940f,
	-0.999942f, -0.999944f, -0.999946f, -0.999948f, -0.999950f, -0.999952f, -0.999954f, -0.999956f,
	-0.999958f, -0.999959f, -0.999961f, -0.999963f, -0.999964f, -0.999966f, -0.999968f, -0.999969f,
	-0.999971f, -0.999972f, -0.999973f, -0.999975f, -0.999976f, -0.999977f, -0.999979f, -0.999980f,
	-0.999981f, -0.999982f, -0.999983f, -0.999985f, -0.999986f, -0.999987f, -0.999988f, -0.999988f,
	-0.999989f, -0.999990f, -0.999991f, -0.999992f, -0.999993f, -0.999993f, -0.999994f, -0.999995f,
	-0.999995f, -0.999996f, -0.999996f, -0.999997f, -0.999997f, -0.999998f, -0.999998f, -0.999999f,
	-0.999999f, -0.999999f, -0.999999f, -1.000000f, -1.000000f, -1.000000f, -1.000000f, -1.000000f
};

static const float sinTable65536[32768] = {
	 0.000000f,  0.000096f,  0.000192f,  0.000288f,  0.000383f,  0.000479f,  0.000575f,  0.000671f,
	 0.000767f,  0.000863f,  0.000959f,  0.001055f,  0.001150f,  0.001246f,  0.001342f,  0.001438f,
	 0.001534f,  0.001630f,  0.001726f,  0.001822f,  0.001917f,  0.002013f,  0.002109f,  0.002205f,
	 0.002301f,  0.002397f,  0.002493f,  0.002589f,  0.002684f,  0.002780f,  0.002876f,  0.002972f,
	 0.003068f,  0.003164f,  0.003260f,  0.003356f,  0.003451f,  0.003547f,  0.003643f,  0.003739f,
	 0.003835f,  0.003931f,  0.004027f,  0.004123f,  0.004218f,  0.004314f,  0.004410f,  0.004506f,
	 0.004602f,  0.004698f,  0.004794f,  0.004890f,  0.004985f,  0.005081f,  0.005177f,  0.005273f,
	 0.005369f,  0.005465f,  0.005561f,  0.005657f,  0.005752f,  0.005848f,  0.005944f,  0.006040f,
	 0.006136f,  0.006232f,  0.006328f,  0.006424f,  0.006519f,  0.006615f,  0.006711f,  0.006807f,
	 0.006903f,  0.006999f,  0.007095f,  0.007190f,  0.007286f,  0.007382f,  0.007478f,  0.007574f,
	 0.007670f,  0.007766f,  0.007862f,  0.007957f,  0.008053f,  0.008149f,  0.008245f,  0.008341f,
	 0.008437f,  0.008533f,  0.008629f,  0.008724f,  0.008820f,  0.008916f,  0.009012f,  0.009108f,
	 0.009204f,  0.009300f,  0.009395f,  0.009491f,  0.009587f,  0.009683f,  0.009779f,  0.009875f,
	 0.009971f,  0.010067f,  0.010162f,  0.010258f,  0.010354f,  0.010450f,  0.010546f,  0.010642f,
	 0.010738f,  0.010834f,  0.010929f,  0.011025f,  0.011121f,  0.011217f,  0.011313f,  0.011409f,
	 0.011505f,  0.011600f,  0.011696f,  0.011792f,  0.011888f,  0.011984f,  0.012080f,  0.012176f,
	 0.012272f,  0.012367f,  0.012463f,  0.012559f,  0.012655f,  0.012751f,  0.012847f,  0.012943f,
	 0.013038f,  0.013134f,  0.013230f,  0.013326f,  0.013422f,  0.013518f,  0.013614f,  0.013710f,
	 0.013805f,  0.013901f,  0.013997f,  0.014093f,  0.014189f,  0.014285f,  0.014381f,  0.014476f,
	 0.014572f,  0.014668f,  0.014764f,  0.014860f,  0.014956f,  0.015052f,  0.015147f,  0.015243f,
	 0.015339f,  0.015435f,  0.015531f,  0.015627f,  0.015723f,  0.015819f,  0.015914f,  0.016010f,
	 0.016106f,  0.016202f,  0.016298f,  0.016394f,  0.016490f,  0.016585f,  0.016681f,  0.016777f,
	 0.016873f,  0.016969f,  0.017065f,  0.017161f,  0.017256f,  0.017352f,  0.017448f,  0.017544f,
	 0.017640f,  0.017736f,  0.017832f,  0.017927f,  0.018023f,  0.018119f,  0.018215f,  0.018311f,
	 0.018407f,  0.018503f,  0.018598f,  0.018694f,  0.018790f,  0.018886f,  0.018982f,  0.019078f,
	 0.019174f,  0.019269f,  0.019365f,  0.019461f,  0.019557f,  0.019653f,  0.019749f,  0.019845f,
	 0.019940f,  0.020036f,  0.020132f,  0.020228f,  0.020324f,  0.020420f,  0.020516f,  0.020611f,
	 0.020707f,  0.020803f,  0.020899f,  0.020995f,  0.021091f,  0.021187f,  0.021282f,  0.021378f,
	 0.021474f,  0.021570f,  0.021666f,  0.021762f,  0.021857f,  0.021953f,  0.022049f,  0.022145f,
	 0.022241f,  0.022337f,  0.022433f,  0.022528f,  0.022624f,  0.022720f,  0.022816f,  0.022912f,
	 0.023008f,  0.023104f,  0.023199f,  0.023295f,  0.023391f,  0.023487f,  0.023583f,  0.023679f,
	 0.023774f,  0.023870f,  0.023966f,  0.024062f,  0.024158f,  0.024254f,  0.024350f,  0.024445f,
	 0.024541f,  0.024637f,  0.024733f,  0.024829f,  0.024925f,  0.025020f,  0.025116f,  0.025212f,
	 0.025308f,  0.025404f,  0.025500f,  0.025596f,  0.025691f,  0.025787f,  0.025883f,  0.025979f,
	 0.026075f,  0.026171f,  0.026266f,  0.026362f,  0.026458f,  0.026554f,  0.026650f,  0.026746f,
	 0.026841f,  0.026937f,  0.027033f,  0.027129f,  0.027225f,  0.027321f,  0.027416f,  0.027512f,
	 0.027608f,  0.027704f,  0.027800f,  0.027896f,  0.027991f,  0.028087f,  0.028183f,  0.028279f,
	 0.028375f,  0.028471f,  0.028567f,  0.028662f,  0.028758f,  0.028854f,  0.028950f,  0.029046f,
	 0.029142f,  0.029237f,  0.029333f,  0.029429f,  0.029525f,  0.029621f,  0.029717f,  0.029812f,
	 0.029908f,  0.030004f,  0.030100f,  0.030196f,  0.030291f,  0.030387f,  0.030483f,  0.030579f,
	 0.030675f,  0.030771f,  0.030866f,  0.030962f,  0.031058f,  0.031154f,  0.031250f,  0.031346f,
	 0.031441f,  0.031537f,  0.031633f,  0.031729f,  0.031825f,  0.031921f,  0.032016f,  0.032112f,
	 0.032208f,  0.032304f,  0.032400f,  0.032495f,  0.032591f,  0.032687f,  0.032783f,  0.032879f,
	 0.032975f,  0.033070f,  0.033166f,  0.033262f,  0.033358f,  0.033454f,  0.033550f,  0.033645f,
	 0.033741f,  0.033837f,  0.033933f,  0.034029f,  0.034124f,  0.034220f,  0.034316f,  0.034412f,
	 0.034508f,  0.034604f,  0.034699f,  0.034795f,  0.034891f,  0.034987f,  0.035083f,  0.035178f,
	 0.035274f,  0.035370f,  0.035466f,  0.035562f,  0.035657f,  0.035753f,  0.035849f,  0.035945f,
	 0.036041f,  0.036137f,  0.036232f,  0.036328f,  0.036424f,  0.036520f,  0.036616f,  0.036711f,
	 0.036807f,  0.036903f,  0.036999f,  0.037095f,  0.037190f,  0.037286f,  0.037382f,  0.037478f,
	 0.037574f,  0.037669f,  0.037765f,  0.037861f,  0.037957f,  0.038053f,  0.038149f,  0.038244f,
	 0.038340f,  0.038436f,  0.038532f,  0.038628f,  0.038723f,  0.038819f,  0.038915f,  0.039011f,
	 0.039107f,  0.039202f,  0.039298f,  0.039394f,  0.039490f,  0.039586f,  0.039681f,  0.039777f,
	 0.039873f,  0.039969f,  0.040065f,  0.040160f,  0.040256f,  0.040352f,  0.040448f,  0.040544f,
	 0.040639f,  0.040735f,  0.040831f,  0.040927f,  0.041022f,  0.041118f,  0.041214f,  0.041310f,
	 0.041406f,  0.041501f,  0.041597f,  0.041693f,  0.041789f,  0.041885f,  0.041980f,  0.042076f,
	 0.042172f,  0.042268f,  0.042364f,  0.042459f,  0.042555f,  0.042651f,  0.042747f,  0.042842f,
	 0.042938f,  0.043034f,  0.043130f,  0.043226f,  0.043321f,  0.043417f,  0.043513f,  0.043609f,
	 0.043705f,  0.043800f,  0.043896f,  0.043992f,  0.044088f,  0.044183f,  0.044279f,  0.044375f,
	 0.044471f,  0.044567f,  0.044662f,  0.044758f,  0.044854f,  0.044950f,  0.045045f,  0.045141f,
	 0.045237f,  0.045333f,  0.045429f,  0.045524f,  0.045620f,  0.045716f,  0.045812f,  0.045907f,
	 0.046003f,  0.046099f,  0.046195f,  0.046290f,  0.046386f,  0.046482f,  0.046578f,  0.046674f,
	 0.046769f,  0.046865f,  0.046961f,  0.047057f,  0.047152f,  0.047248f,  0.047344f,  0.047440f,
	 0.047535f,  0.047631f,  0.047727f,  0.047823f,  0.047919f,  0.048014f,  0.048110f,  0.048206f,
	 0.048302f,  0.048397f,  0.048493f,  0.048589f,  0.048685f,  0.048780f,  0.048876f,  0.048972f,
	 0.049068f,  0.049163f,  0.049259f,  0.049355f,  0.049451f,  0.049546f,  0.049642f,  0.049738f,
	 0.049834f,  0.049929f,  0.050025f,  0.050121f,  0.050217f,  0.050312f,  0.050408f,  0.050504f,
	 0.050600f,  0.050696f,  0.050791f,  0.050887f,  0.050983f,  0.051078f,  0.051174f,  0.051270f,
	 0.051366f,  0.051461f,  0.051557f,  0.051653f,  0.051749f,  0.051844f,  0.051940f,  0.052036f,
	 0.052132f,  0.052227f,  0.052323f,  0.052419f,  0.052515f,  0.052610f,  0.052706f,  0.052802f,
	 0.052898f,  0.052993f,  0.053089f,  0.053185f,  0.053281f,  0.053376f,  0.053472f,  0.053568f,
	 0.053664f,  0.053759f,  0.053855f,  0.053951f,  0.054046f,  0.054142f,  0.054238f,  0.054334f,
	 0.054429f,  0.054525f,  0.054621f,  0.054717f,  0.054812f,  0.054908f,  0.055004f,  0.055100f,
	 0.055195f,  0.055291f,  0.055387f,  0.055482f,  0.055578f,  0.055674f,  0.055770f,  0.055865f,
	 0.055961f,  0.056057f,  0.056152f,  0.056248f,  0.056344f,  0.056440f,  0.056535f,  0.056631f,
	 0.056727f,  0.056823f,  0.056918f,  0.057014f,  0.057110f,  0.057205f,  0.057301f,  0.057397f,
	 0.057493f,  0.057588f,  0.057684f,  0.057780f,  0.057875f,  0.057971f,  0.058067f,  0.058163f,
	 0.058258f,  0.058354f,  0.058450f,  0.058545f,  0.058641f,  0.058737f,  0.058833f,  0.058928f,
	 0.059024f,  0.059120f,  0.059215f,  0.059311f,  0.059407f,  0.059502f,  0.059598f,  0.059694f,
	 0.059790f,  0.059885f,  0.059981f,  0.060077f,  0.060172f,  0.060268f,  0.060364f,  0.060459f,
	 0.060555f,  0.060651f,  0.060747f,  0.060842f,  0.060938f,  0.061034f,  0.061129f,  0.061225f,
	 0.061321f,  0.061416f,  0.061512f,  0.061608f,  0.061704f,  0.061799f,  0.061895f,  0.061991f,
	 0.062086f,  0.062182f,  0.062278f,  0.062373f,  0.062469f,  0.062565f,  0.062660f,  0.062756f,
	 0.062852f,  0.062947f,  0.063043f,  0.063139f,  0.063234f,  0.063330f,  0.063426f,  0.063522f,
	 0.063617f,  0.063713f,  0.063809f,  0.063904f,  0.064000f,  0.064096f,  0.064191f,  0.064287f,
	 0.064383f,  0.064478f,  0.064574f,  0.064670f,  0.064765f,  0.064861f,  0.064957f,  0.065052f,
	 0.065148f,  0.065244f,  0.065339f,  0.065435f,  0.065531f,  0.065626f,  0.065722f,  0.065818f,
	 0.065913f,  0.066009f,  0.066105f,  0.066200f,  0.066296f,  0.066392f,  0.066487f,  0.066583f,
	 0.066679f,  0.066774f,  0.066870f,  0.066966f,  0.067061f,  0.067157f,  0.067253f,  0.067348f,
	 0.067444f,  0.067540f,  0.067635f,  0.067731f,  0.067827f,  0.067922f,  0.068018f,  0.068113f,
	 0.068209f,  0.068305f,  0.068400f,  0.068496f,  0.068592f,  0.068687f,  0.068783f,  0.068879f,
	 0.068974f,  0.069070f,  0.069166f,  0.069261f,  0.069357f,  0.069453f,  0.069548f,  0.069644f,
	 0.069739f,  0.069835f,  0.069931f,  0.070026f,  0.070122f,  0.070218f,  0.070313f,  0.070409f,
	 0.070505f,  0.070600f,  0.070696f,  0.070791f,  0.070887f,  0.070983f,  0.071078f,  0.071174f,
	 0.071270f,  0.071365f,  0.071461f,  0.071557f,  0.071652f,  0.071748f,  0.071843f,  0.071939f,
	 0.072035f,  0.072130f,  0.072226f,  0.072322f,  0.072417f,  0.072513f,  0.072608f,  0.072704f,
	 0.072800f,  0.072895f,  0.072991f,  0.073086f,  0.073182f,  0.073278f,  0.073373f,  0.073469f,
	 0.073565f,  0.073660f,  0.073756f,  0.073851f,  0.073947f,  0.074043f,  0.074138f,  0.074234f,
	 0.074329f,  0.074425f,  0.074521f,  0.074616f,  0.074712f,  0.074807f,  0.074903f,  0.074999f,
	 0.075094f,  0.075190f,  0.075286f,  0.075381f,  0.075477f,  0.075572f,  0.075668f,  0.075764f,
	 0.075859f,  0.075955f,  0.076050f,  0.076146f,  0.076241f,  0.076337f,  0.076433f,  0.076528f,
	 0.076624f,  0.076719f,  0.076815f,  0.076911f,  0.077006f,  0.077102f,  0.077197f,  0.077293f,
	 0.077389f,  0.077484f,  0.077580f,  0.077675f,  0.077771f,  0.077866f,  0.077962f,  0.078058f,
	 0.078153f,  0.078249f,  0.078344f,  0.078440f,  0.078536f,  0.078631f,  0.078727f,  0.078822f,
	 0.078918f,  0.079013f,  0.079109f,  0.079205f,  0.079300f,  0.079396f,  0.079491f,  0.079587f,
	 0.079682f,  0.079778f,  0.079874f,  0.079969f,  0.080065f,  0.080160f,  0.080256f,  0.080351f,
	 0.080447f,  0.080543f,  0.080638f,  0.080734f,  0.080829f,  0.080925f,  0.081020f,  0.081116f,
	 0.081211f,  0.081307f,  0.081403f,  0.081498f,  0.081594f,  0.081689f,  0.081785f,  0.081880f,
	 0.081976f,  0.082071f,  0.082167f,  0.082263f,  0.082358f,  0.082454f,  0.082549f,  0.082645f,
	 0.082740f,  0.082836f,  0.082931f,  0.083027f,  0.083122f,  0.083218f,  0.083314f,  0.083409f,
	 0.083505f,  0.083600f,  0.083696f,  0.083791f,  0.083887f,  0.083982f,  0.084078f,  0.084173f,
	 0.084269f,  0.084364f,  0.084460f,  0.084555f,  0.084651f,  0.084747f,  0.084842f,  0.084938f,
	 0.085033f,  0.085129f,  0.085224f,  0.085320f,  0.085415f,  0.085511f,  0.085606f,  0.085702f,
	 0.085797f,  0.085893f,  0.085988f,  0.086084f,  0.086179f,  0.086275f,  0.086370f,  0.086466f,
	 0.086561f,  0.086657f,  0.086752f,  0.086848f,  0.086943f,  0.087039f,  0.087135f,  0.087230f,
	 0.087326f,  0.087421f,  0.087517f,  0.087612f,  0.087708f,  0.087803f,  0.087899f,  0.087994f,
	 0.088090f,  0.088185f,  0.088281f,  0.088376f,  0.088472f,  0.088567f,  0.088663f,  0.088758f,
	 0.088854f,  0.088949f,  0.089045f,  0.089140f,  0.089236f,  0.089331f,  0.089427f,  0.089522f,
	 0.089617f,  0.089713f,  0.089808f,  0.089904f,  0.089999f,  0.090095f,  0.090190f,  0.090286f,
	 0.090381f,  0.090477f,  0.090572f,  0.090668f,  0.090763f,  0.090859f,  0.090954f,  0.091050f,
	 0.091145f,  0.091241f,  0.091336f,  0.091432f,  0.091527f,  0.091623f,  0.091718f,  0.091813f,
	 0.091909f,  0.092004f,  0.092100f,  0.092195f,  0.092291f,  0.092386f,  0.092482f,  0.092577f,
	 0.092673f,  0.092768f,  0.092864f,  0.092959f,  0.093055f,  0.093150f,  0.093245f,  0.093341f,
	 0.093436f,  0.093532f,  0.093627f,  0.093723f,  0.093818f,  0.093914f,  0.094009f,  0.094104f,
	 0.094200f,  0.094295f,  0.094391f,  0.094486f,  0.094582f,  0.094677f,  0.094773f,  0.094868f,
	 0.094963f,  0.095059f,  0.095154f,  0.095250f,  0.095345f,  0.095441f,  0.095536f,  0.095632f,
	 0.095727f,  0.095822f,  0.095918f,  0.096013f,  0.096109f,  0.096204f,  0.096300f,  0.096395f,
	 0.096490f,  0.096586f,  0.096681f,  0.096777f,  0.096872f,  0.096968f,  0.097063f,  0.097158f,
	 0.097254f,  0.097349f,  0.097445f,  0.097540f,  0.097635f,  0.097731f,  0.097826f,  0.097922f,
	 0.098017f,  0.098113f,  0.098208f,  0.098303f,  0.098399f,  0.098494f,  0.098590f,  0.098685f,
	 0.098780f,  0.098876f,  0.098971f,  0.099067f,  0.099162f,  0.099257f,  0.099353f,  0.099448f,
	 0.099544f,  0.099639f,  0.099734f,  0.099830f,  0.099925f,  0.100021f,  0.100116f,  0.100211f,
	 0.100307f,  0.100402f,  0.100498f,  0.100593f,  0.100688f,  0.100784f,  0.100879f,  0.100974f,
	 0.101070f,  0.101165f,  0.101261f,  0.101356f,  0.101451f,  0.101547f,  0.101642f,  0.101738f,
	 0.101833f,  0.101928f,  0.102024f,  0.102119f,  0.102214f,  0.102310f,  0.102405f,  0.102500f,
	 0.102596f,  0.102691f,  0.102787f,  0.102882f,  0.102977f,  0.103073f,  0.103168f,  0.103263f,
	 0.103359f,  0.103454f,  0.103550f,  0.103645f,  0.103740f,  0.103836f,  0.103931f,  0.104026f,
	 0.104122f,  0.104217f,  0.104312f,  0.104408f,  0.104503f,  0.104598f,  0.104694f,  0.104789f,
	 0.104884f,  0.104980f,  0.105075f,  0.105170f,  0.105266f,  0.105361f,  0.105456f,  0.105552f,
	 0.105647f,  0.105742f,  0.105838f,  0.105933f,  0.106028f,  0.106124f,  0.106219f,  0.106314f,
	 0.106410f,  0.106505f,  0.106600f,  0.106696f,  0.106791f,  0.106886f,  0.106982f,  0.107077f,
	 0.107172f,  0.107268f,  0.107363f,  0.107458f,  0.107554f,  0.107649f,  0.107744f,  0.107840f,
	 0.107935f,  0.108030f,  0.108126f,  0.108221f,  0.108316f,  0.108412f,  0.108507f,  0.108602f,
	 0.108697f,  0.108793f,  0.108888f,  0.108983f,  0.109079f,  0.109174f,  0.109269f,  0.109365f,
	 0.109460f,  0.109555f,  0.109650f,  0.109746f,  0.109841f,  0.109936f,  0.110032f,  0.110127f,
	 0.110222f,  0.110317f,  0.110413f,  0.110508f,  0.110603f,  0.110699f,  0.110794f,  0.110889f,
	 0.110984f,  0.111080f,  0.111175f,  0.111270f,  0.111366f,  0.111461f,  0.111556f,  0.111651f,
	 0.111747f,  0.111842f,  0.111937f,  0.112033f,  0.112128f,  0.112223f,  0.112318f,  0.112414f,
	 0.112509f,  0.112604f,  0.112699f,  0.112795f,  0.112890f,  0.112985f,  0.113080f,  0.113176f,
	 0.113271f,  0.113366f,  0.113461f,  0.113557f,  0.113652f,  0.113747f,  0.113842f,  0.113938f,
	 0.114033f,  0.114128f,  0.114223f,  0.114319f,  0.114414f,  0.114509f,  0.114604f,  0.114700f,
	 0.114795f,  0.114890f,  0.114985f,  0.115081f,  0.115176f,  0.115271f,  0.115366f,  0.115462f,
	 0.115557f,  0.115652f,  0.115747f,  0.115842f,  0.115938f,  0.116033f,  0.116128f,  0.116223f,
	 0.116319f,  0.116414f,  0.116509f,  0.116604f,  0.116700f,  0.116795f,  0.116890f,  0.116985f,
	 0.117080f,  0.117176f,  0.117271f,  0.117366f,  0.117461f,  0.117556f,  0.117652f,  0.117747f,
	 0.117842f,  0.117937f,  0.118032f,  0.118128f,  0.118223f,  0.118318f,  0.118413f,  0.118508f,
	 0.118604f,  0.118699f,  0.118794f,  0.118889f,  0.118984f,  0.119080f,  0.119175f,  0.119270f,
	 0.119365f,  0.119460f,  0.119556f,  0.119651f,  0.119746f,  0.119841f,  0.119936f,  0.120032f,
	 0.120127f,  0.120222f,  0.120317f,  0.120412f,  0.120507f,  0.120603f,  0.120698f,  0.120793f,
	 0.120888f,  0.120983f,  0.121078f,  0.121174f,  0.121269f,  0.121364f,  0.121459f,  0.121554f,
	 0.121649f,  0.121745f,  0.121840f,  0.121935f,  0.122030f,  0.122125f,  0.122220f,  0.122316f,
	 0.122411f,  0.122506f,  0.122601f,  0.122696f,  0.122791f,  0.122886f,  0.122982f,  0.123077f,
	 0.123172f,  0.123267f,  0.123362f,  0.123457f,  0.123552f,  0.123648f,  0.123743f,  0.123838f,
	 0.123933f,  0.124028f,  0.124123f,  0.124218f,  0.124314f,  0.124409f,  0.124504f,  0.124599f,
	 0.124694f,  0.124789f,  0.124884f,  0.124979f,  0.125075f,  0.125170f,  0.125265f,  0.125360f,
	 0.125455f,  0.125550f,  0.125645f,  0.125740f,  0.125835f,  0.125931f,  0.126026f,  0.126121f,
	 0.126216f,  0.126311f,  0.126406f,  0.126501f,  0.126596f,  0.126691f,  0.126787f,  0.126882f,
	 0.126977f,  0.127072f,  0.127167f,  0.127262f,  0.127357f,  0.127452f,  0.127547f,  0.127642f,
	 0.127737f,  0.127833f,  0.127928f,  0.128023f,  0.128118f,  0.128213f,  0.128308f,  0.128403f,
	 0.128498f,  0.128593f,  0.128688f,  0.128783f,  0.128878f,  0.128973f,  0.129069f,  0.129164f,
	 0.129259f,  0.129354f,  0.129449f,  0.129544f,  0.129639f,  0.129734f,  0.129829f,  0.129924f,
	 0.130019f,  0.130114f,  0.130209f,  0.130304f,  0.130399f,  0.130495f,  0.130590f,  0.130685f,
	 0.130780f,  0.130875f,  0.130970f,  0.131065f,  0.131160f,  0.131255f,  0.131350f,  0.131445f,
	 0.131540f,  0.131635f,  0.131730f,  0.131825f,  0.131920f,  0.132015f,  0.132110f,  0.132205f,
	 0.132300f,  0.132395f,  0.132490f,  0.132585f,  0.132680f,  0.132775f,  0.132870f,  0.132966f,
	 0.133061f,  0.133156f,  0.133251f,  0.133346f,  0.133441f,  0.133536f,  0.133631f,  0.133726f,
	 0.133821f,  0.133916f,  0.134011f,  0.134106f,  0.134201f,  0.134296f,  0.134391f,  0.134486f,
	 0.134581f,  0.134676f,  0.134771f,  0.134866f,  0.134961f,  0.135056f,  0.135151f,  0.135246f,
	 0.135341f,  0.135436f,  0.135531f,  0.135626f,  0.135721f,  0.135816f,  0.135911f,  0.136006f,
	 0.136101f,  0.136196f,  0.136291f,  0.136386f,  0.136480f,  0.136575f,  0.136670f,  0.136765f,
	 0.136860f,  0.136955f,  0.137050f,  0.137145f,  0.137240f,  0.137335f,  0.137430f,  0.137525f,
	 0.137620f,  0.137715f,  0.137810f,  0.137905f,  0.138000f,  0.138095f,  0.138190f,  0.138285f,
	 0.138380f,  0.138475f,  0.138570f,  0.138665f,  0.138760f,  0.138855f,  0.138949f,  0.139044f,
	 0.139139f,  0.139234f,  0.139329f,  0.139424f,  0.139519f,  0.139614f,  0.139709f,  0.139804f,
	 0.139899f,  0.139994f,  0.140089f,  0.140184f,  0.140279f,  0.140373f,  0.140468f,  0.140563f,
	 0.140658f,  0.140753f,  0.140848f,  0.140943f,  0.141038f,  0.141133f,  0.141228f,  0.141323f,
	 0.141418f,  0.141512f,  0.141607f,  0.141702f,  0.141797f,  0.141892f,  0.141987f,  0.142082f,
	 0.142177f,  0.142272f,  0.142367f,  0.142461f,  0.142556f,  0.142651f,  0.142746f,  0.142841f,
	 0.142936f,  0.143031f,  0.143126f,  0.143221f,  0.143316f,  0.143410f,  0.143505f,  0.143600f,
	 0.143695f,  0.143790f,  0.143885f,  0.143980f,  0.144075f,  0.144169f,  0.144264f,  0.144359f,
	 0.144454f,  0.144549f,  0.144644f,  0.144739f,  0.144833f,  0.144928f,  0.145023f,  0.145118f,
	 0.145213f,  0.145308f,  0.145403f,  0.145497f,  0.145592f,  0.145687f,  0.145782f,  0.145877f,
	 0.145972f,  0.146067f,  0.146161f,  0.146256f,  0.146351f,  0.146446f,  0.146541f,  0.146636f,
	 0.146730f,  0.146825f,  0.146920f,  0.147015f,  0.147110f,  0.147205f,  0.147299f,  0.147394f,
	 0.147489f,  0.147584f,  0.147679f,  0.147774f,  0.147868f,  0.147963f,  0.148058f,  0.148153f,
	 0.148248f,  0.148342f,  0.148437f,  0.148532f,  0.148627f,  0.148722f,  0.148817f,  0.148911f,
	 0.149006f,  0.149101f,  0.149196f,  0.149291f,  0.149385f,  0.149480f,  0.149575f,  0.149670f,
	 0.149765f,  0.149859f,  0.149954f,  0.150049f,  0.150144f,  0.150238f,  0.150333f,  0.150428f,
	 0.150523f,  0.150618f,  0.150712f,  0.150807f,  0.150902f,  0.150997f,  0.151092f,  0.151186f,
	 0.151281f,  0.151376f,  0.151471f,  0.151565f,  0.151660f,  0.151755f,  0.151850f,  0.151944f,
	 0.152039f,  0.152134f,  0.152229f,  0.152323f,  0.152418f,  0.152513f,  0.152608f,  0.152702f,
	 0.152797f,  0.152892f,  0.152987f,  0.153081f,  0.153176f,  0.153271f,  0.153366f,  0.153460f,
	 0.153555f,  0.153650f,  0.153745f,  0.153839f,  0.153934f,  0.154029f,  0.154124f,  0.154218f,
	 0.154313f,  0.154408f,  0.154502f,  0.154597f,  0.154692f,  0.154787f,  0.154881f,  0.154976f,
	 0.155071f,  0.155165f,  0.155260f,  0.155355f,  0.155450f,  0.155544f,  0.155639f,  0.155734f,
	 0.155828f,  0.155923f,  0.156018f,  0.156112f,  0.156207f,  0.156302f,  0.156397f,  0.156491f,
	 0.156586f,  0.156681f,  0.156775f,  0.156870f,  0.156965f,  0.157059f,  0.157154f,  0.157249f,
	 0.157343f,  0.157438f,  0.157533f,  0.157627f,  0.157722f,  0.157817f,  0.157912f,  0.158006f,
	 0.158101f,  0.158196f,  0.158290f,  0.158385f,  0.158480f,  0.158574f,  0.158669f,  0.158763f,
	 0.158858f,  0.158953f,  0.159047f,  0.159142f,  0.159237f,  0.159331f,  0.159426f,  0.159521f,
	 0.159615f,  0.159710f,  0.159805f,  0.159899f,  0.159994f,  0.160089f,  0.160183f,  0.160278f,
	 0.160372f,  0.160467f,  0.160562f,  0.160656f,  0.160751f,  0.160846f,  0.160940f,  0.161035f,
	 0.161129f,  0.161224f,  0.161319f,  0.161413f,  0.161508f,  0.161603f,  0.161697f,  0.161792f,
	 0.161886f,  0.161981f,  0.162076f,  0.162170f,  0.162265f,  0.162359f,  0.162454f,  0.162549f,
	 0.162643f,  0.162738f,  0.162832f,  0.162927f,  0.163022f,  0.163116f,  0.163211f,  0.163305f,
	 0.163400f,  0.163495f,  0.163589f,  0.163684f,  0.163778f,  0.163873f,  0.163967f,  0.164062f,
	 0.164157f,  0.164251f,  0.164346f,  0.164440f,  0.164535f,  0.164629f,  0.164724f,  0.164819f,
	 0.164913f,  0.165008f,  0.165102f,  0.165197f,  0.165291f,  0.165386f,  0.165480f,  0.165575f,
	 0.165670f,  0.165764f,  0.165859f,  0.165953f,  0.166048f,  0.166142f,  0.166237f,  0.166331f,
	 0.166426f,  0.166520f,  0.166615f,  0.166710f,  0.166804f,  0.166899f,  0.166993f,  0.167088f,
	 0.167182f,  0.167277f,  0.167371f,  0.167466f,  0.167560f,  0.167655f,  0.167749f,  0.167844f,
	 0.167938f,  0.168033f,  0.168127f,  0.168222f,  0.168316f,  0.168411f,  0.168505f,  0.168600f,
	 0.168694f,  0.168789f,  0.168883f,  0.168978f,  0.169072f,  0.169167f,  0.169261f,  0.169356f,
	 0.169450f,  0.169545f,  0.169639f,  0.169734f,  0.169828f,  0.169923f,  0.170017f,  0.170112f,
	 0.170206f,  0.170301f,  0.170395f,  0.170490f,  0.170584f,  0.170678f,  0.170773f,  0.170867f,
	 0.170962f,  0.171056f,  0.171151f,  0.171245f,  0.171340f,  0.171434f,  0.171529f,  0.171623f,
	 0.171718f,  0.171812f,  0.171906f,  0.172001f,  0.172095f,  0.172190f,  0.172284f,  0.172379f,
	 0.172473f,  0.172568f,  0.172662f,  0.172756f,  0.172851f,  0.172945f,  0.173040f,  0.173134f,
	 0.173229f,  0.173323f,  0.173417f,  0.173512f,  0.173606f,  0.173701f,  0.173795f,  0.173889f,
	 0.173984f,  0.174078f,  0.174173f,  0.174267f,  0.174362f,  0.174456f,  0.174550f,  0.174645f,
	 0.174739f,  0.174834f,  0.174928f,  0.175022f,  0.175117f,  0.175211f,  0.175305f,  0.175400f,
	 0.175494f,  0.175589f,  0.175683f,  0.175777f,  0.175872f,  0.175966f,  0.176061f,  0.176155f,
	 0.176249f,  0.176344f,  0.176438f,  0.176532f,  0.176627f,  0.176721f,  0.176815f,  0.176910f,
	 0.177004f,  0.177099f,  0.177193f,  0.177287f,  0.177382f,  0.177476f,  0.177570f,  0.177665f,
	 0.177759f,  0.177853f,  0.177948f,  0.178042f,  0.178136f,  0.178231f,  0.178325f,  0.178419f,
	 0.178514f,  0.178608f,  0.178702f,  0.178797f,  0.178891f,  0.178985f,  0.179080f,  0.179174f,
	 0.179268f,  0.179363f,  0.179457f,  0.179551f,  0.179646f,  0.179740f,  0.179834f,  0.179929f,
	 0.180023f,  0.180117f,  0.180212f,  0.180306f,  0.180400f,  0.180494f,  0.180589f,  0.180683f,
	 0.180777f,  0.180872f,  0.180966f,  0.181060f,  0.181154f,  0.181249f,  0.181343f,  0.181437f,
	 0.181532f,  0.181626f,  0.181720f,  0.181814f,  0.181909f,  0.182003f,  0.182097f,  0.182192f,
	 0.182286f,  0.182380f,  0.182474f,  0.182569f,  0.182663f,  0.182757f,  0.182851f,  0.182946f,
	 0.183040f,  0.183134f,  0.183228f,  0.183323f,  0.183417f,  0.183511f,  0.183605f,  0.183700f,
	 0.183794f,  0.183888f,  0.183982f,  0.184077f,  0.184171f,  0.184265f,  0.184359f,  0.184454f,
	 0.184548f,  0.184642f,  0.184736f,  0.184830f,  0.184925f,  0.185019f,  0.185113f,  0.185207f,
	 0.185301f,  0.185396f,  0.185490f,  0.185584f,  0.185678f,  0.185773f,  0.185867f,  0.185961f,
	 0.186055f,  0.186149f,  0.186244f,  0.186338f,  0.186432f,  0.186526f,  0.186620f,  0.186715f,
	 0.186809f,  0.186903f,  0.186997f,  0.187091f,  0.187185f,  0.187280f,  0.187374f,  0.187468f,
	 0.187562f,  0.187656f,  0.187750f,  0.187845f,  0.187939f,  0.188033f,  0.188127f,  0.188221f,
	 0.188315f,  0.188410f,  0.188504f,  0.188598f,  0.188692f,  0.188786f,  0.188880f,  0.188975f,
	 0.189069f,  0.189163f,  0.189257f,  0.189351f,  0.189445f,  0.189539f,  0.189634f,  0.189728f,
	 0.189822f,  0.189916f,  0.190010f,  0.190104f,  0.190198f,  0.190292f,  0.190387f,  0.190481f,
	 0.190575f,  0.190669f,  0.190763f,  0.190857f,  0.190951f,  0.191045f,  0.191139f,  0.191234f,
	 0.191328f,  0.191422f,  0.191516f,  0.191610f,  0.191704f,  0.191798f,  0.191892f,  0.191986f,
	 0.192080f,  0.192174f,  0.192269f,  0.192363f,  0.192457f,  0.192551f,  0.192645f,  0.192739f,
	 0.192833f,  0.192927f,  0.193021f,  0.193115f,  0.193209f,  0.193303f,  0.193397f,  0.193492f,
	 0.193586f,  0.193680f,  0.193774f,  0.193868f,  0.193962f,  0.194056f,  0.194150f,  0.194244f,
	 0.194338f,  0.194432f,  0.194526f,  0.194620f,  0.194714f,  0.194808f,  0.194902f,  0.194996f,
	 0.195090f,  0.195184f,  0.195278f,  0.195372f,  0.195466f,  0.195560f,  0.195654f,  0.195748f,
	 0.195843f,  0.195937f,  0.196031f,  0.196125f,  0.196219f,  0.196313f,  0.196407f,  0.196501f,
	 0.196595f,  0.196689f,  0.196783f,  0.196877f,  0.196971f,  0.197065f,  0.197159f,  0.197253f,
	 0.197347f,  0.197441f,  0.197535f,  0.197629f,  0.197722f,  0.197816f,  0.197910f,  0.198004f,
	 0.198098f,  0.198192f,  0.198286f,  0.198380f,  0.198474f,  0.198568f,  0.198662f,  0.198756f,
	 0.198850f,  0.198944f,  0.199038f,  0.199132f,  0.199226f,  0.199320f,  0.199414f,  0.199508f,
	 0.199602f,  0.199696f,  0.199790f,  0.199884f,  0.199978f,  0.200071f,  0.200165f,  0.200259f,
	 0.200353f,  0.200447f,  0.200541f,  0.200635f,  0.200729f,  0.200823f,  0.200917f,  0.201011f,
	 0.201105f,  0.201199f,  0.201292f,  0.201386f,  0.201480f,  0.201574f,  0.201668f,  0.201762f,
	 0.201856f,  0.201950f,  0.202044f,  0.202138f,  0.202231f,  0.202325f,  0.202419f,  0.202513f,
	 0.202607f,  0.202701f,  0.202795f,  0.202889f,  0.202983f,  0.203076f,  0.203170f,  0.203264f,
	 0.203358f,  0.203452f,  0.203546f,  0.203640f,  0.203734f,  0.203827f,  0.203921f,  0.204015f,
	 0.204109f,  0.204203f,  0.204297f,  0.204391f,  0.204484f,  0.204578f,  0.204672f,  0.204766f,
	 0.204860f,  0.204954f,  0.205047f,  0.205141f,  0.205235f,  0.205329f,  0.205423f,  0.205517f,
	 0.205610f,  0.205704f,  0.205798f,  0.205892f,  0.205986f,  0.206080f,  0.206173f,  0.206267f,
	 0.206361f,  0.206455f,  0.206549f,  0.206642f,  0.206736f,  0.206830f,  0.206924f,  0.207018f,
	 0.207111f,  0.207205f,  0.207299f,  0.207393f,  0.207487f,  0.207580f,  0.207674f,  0.207768f,
	 0.207862f,  0.207955f,  0.208049f,  0.208143f,  0.208237f,  0.208331f,  0.208424f,  0.208518f,
	 0.208612f,  0.208706f,  0.208799f,  0.208893f,  0.208987f,  0.209081f,  0.209174f,  0.209268f,
	 0.209362f,  0.209456f,  0.209549f,  0.209643f,  0.209737f,  0.209831f,  0.209924f,  0.210018f,
	 0.210112f,  0.210206f,  0.210299f,  0.210393f,  0.210487f,  0.210580f,  0.210674f,  0.210768f,
	 0.210862f,  0.210955f,  0.211049f,  0.211143f,  0.211237f,  0.211330f,  0.211424f,  0.211518f,
	 0.211611f,  0.211705f,  0.211799f,  0.211892f,  0.211986f,  0.212080f,  0.212174f,  0.212267f,
	 0.212361f,  0.212455f,  0.212548f,  0.212642f,  0.212736f,  0.212829f,  0.212923f,  0.213017f,
	 0.213110f,  0.213204f,  0.213298f,  0.213391f,  0.213485f,  0.213579f,  0.213672f,  0.213766f,
	 0.213860f,  0.213953f,  0.214047f,  0.214141f,  0.214234f,  0.214328f,  0.214422f,  0.214515f,
	 0.214609f,  0.214702f,  0.214796f,  0.214890f,  0.214983f,  0.215077f,  0.215171f,  0.215264f,
	 0.215358f,  0.215451f,  0.215545f,  0.215639f,  0.215732f,  0.215826f,  0.215920f,  0.216013f,
	 0.216107f,  0.216200f,  0.216294f,  0.216388f,  0.216481f,  0.216575f,  0.216668f,  0.216762f,
	 0.216856f,  0.216949f,  0.217043f,  0.217136f,  0.217230f,  0.217324f,  0.217417f,  0.217511f,
	 0.217604f,  0.217698f,  0.217791f,  0.217885f,  0.217979f,  0.218072f,  0.218166f,  0.218259f,
	 0.218353f,  0.218446f,  0.218540f,  0.218633f,  0.218727f,  0.218821f,  0.218914f,  0.219008f,
	 0.219101f,  0.219195f,  0.219288f,  0.219382f,  0.219475f,  0.219569f,  0.219662f,  0.219756f,
	 0.219850f,  0.219943f,  0.220037f,  0.220130f,  0.220224f,  0.220317f,  0.220411f,  0.220504f,
	 0.220598f,  0.220691f,  0.220785f,  0.220878f,  0.220972f,  0.221065f,  0.221159f,  0.221252f,
	 0.221346f,  0.221439f,  0.221533f,  0.221626f,  0.221720f,  0.221813f,  0.221907f,  0.222000f,
	 0.222094f,  0.222187f,  0.222281f,  0.222374f,  0.222468f,  0.222561f,  0.222654f,  0.222748f,
	 0.222841f,  0.222935f,  0.223028f,  0.223122f,  0.223215f,  0.223309f,  0.223402f,  0.223496f,
	 0.223589f,  0.223682f,  0.223776f,  0.223869f,  0.223963f,  0.224056f,  0.224150f,  0.224243f,
	 0.224337f,  0.224430f,  0.224523f,  0.224617f,  0.224710f,  0.224804f,  0.224897f,  0.224991f,
	 0.225084f,  0.225177f,  0.225271f,  0.225364f,  0.225458f,  0.225551f,  0.225644f,  0.225738f,
	 0.225831f,  0.225925f,  0.226018f,  0.226111f,  0.226205f,  0.226298f,  0.226391f,  0.226485f,
	 0.226578f,  0.226672f,  0.226765f,  0.226858f,  0.226952f,  0.227045f,  0.227139f,  0.227232f,
	 0.227325f,  0.227419f,  0.227512f,  0.227605f,  0.227699f,  0.227792f,  0.227885f,  0.227979f,
	 0.228072f,  0.228165f,  0.228259f,  0.228352f,  0.228445f,  0.228539f,  0.228632f,  0.228725f,
	 0.228819f,  0.228912f,  0.229005f,  0.229099f,  0.229192f,  0.229285f,  0.229379f,  0.229472f,
	 0.229565f,  0.229659f,  0.229752f,  0.229845f,  0.229939f,  0.230032f,  0.230125f,  0.230218f,
	 0.230312f,  0.230405f,  0.230498f,  0.230592f,  0.230685f,  0.230778f,  0.230872f,  0.230965f,
	 0.231058f,  0.231151f,  0.231245f,  0.231338f,  0.231431f,  0.231524f,  0.231618f,  0.231711f,
	 0.231804f,  0.231898f,  0.231991f,  0.232084f,  0.232177f,  0.232271f,  0.232364f,  0.232457f,
	 0.232550f,  0.232644f,  0.232737f,  0.232830f,  0.232923f,  0.233017f,  0.233110f,  0.233203f,
	 0.233296f,  0.233389f,  0.233483f,  0.233576f,  0.233669f,  0.233762f,  0.233856f,  0.233949f,
	 0.234042f,  0.234135f,  0.234228f,  0.234322f,  0.234415f,  0.234508f,  0.234601f,  0.234694f,
	 0.234788f,  0.234881f,  0.234974f,  0.235067f,  0.235160f,  0.235254f,  0.235347f,  0.235440f,
	 0.235533f,  0.235626f,  0.235719f,  0.235813f,  0.235906f,  0.235999f,  0.236092f,  0.236185f,
	 0.236278f,  0.236372f,  0.236465f,  0.236558f,  0.236651f,  0.236744f,  0.236837f,  0.236930f,
	 0.237024f,  0.237117f,  0.237210f,  0.237303f,  0.237396f,  0.237489f,  0.237582f,  0.237676f,
	 0.237769f,  0.237862f,  0.237955f,  0.238048f,  0.238141f,  0.238234f,  0.238327f,  0.238420f,
	 0.238514f,  0.238607f,  0.238700f,  0.238793f,  0.238886f,  0.238979f,  0.239072f,  0.239165f,
	 0.239258f,  0.239351f,  0.239445f,  0.239538f,  0.239631f,  0.239724f,  0.239817f,  0.239910f,
	 0.240003f,  0.240096f,  0.240189f,  0.240282f,  0.240375f,  0.240468f,  0.240561f,  0.240654f,
	 0.240748f,  0.240841f,  0.240934f,  0.241027f,  0.241120f,  0.241213f,  0.241306f,  0.241399f,
	 0.241492f,  0.241585f,  0.241678f,  0.241771f,  0.241864f,  0.241957f,  0.242050f,  0.242143f,
	 0.242236f,  0.242329f,  0.242422f,  0.242515f,  0.242608f,  0.242701f,  0.242794f,  0.242887f,
	 0.242980f,  0.243073f,  0.243166f,  0.243259f,  0.243352f,  0.243445f,  0.243538f,  0.243631f,
	 0.243724f,  0.243817f,  0.243910f,  0.244003f,  0.244096f,  0.244189f,  0.244282f,  0.244375f,
	 0.244468f,  0.244561f,  0.244654f,  0.244747f,  0.244840f,  0.244933f,  0.245026f,  0.245119f,
	 0.245212f,  0.245304f,  0.245397f,  0.245490f,  0.245583f,  0.245676f,  0.245769f,  0.245862f,
	 0.245955f,  0.246048f,  0.246141f,  0.246234f,  0.246327f,  0.246420f,  0.246513f,  0.246606f,
	 0.246698f,  0.246791f,  0.246884f,  0.246977f,  0.247070f,  0.247163f,  0.247256f,  0.247349f,
	 0.247442f,  0.247535f,  0.247627f,  0.247720f,  0.247813f,  0.247906f,  0.247999f,  0.248092f,
	 0.248185f,  0.248278f,  0.248370f,  0.248463f,  0.248556f,  0.248649f,  0.248742f,  0.248835f,
	 0.248928f,  0.249020f,  0.249113f,  0.249206f,  0.249299f,  0.249392f,  0.249485f,  0.249578f,
	 0.249670f,  0.249763f,  0.249856f,  0.249949f,  0.250042f,  0.250135f,  0.250227f,  0.250320f,
	 0.250413f,  0.250506f,  0.250599f,  0.250691f,  0.250784f,  0.250877f,  0.250970f,  0.251063f,
	 0.251155f,  0.251248f,  0.251341f,  0.251434f,  0.251527f,  0.251619f,  0.251712f,  0.251805f,
	 0.251898f,  0.251991f,  0.252083f,  0.252176f,  0.252269f,  0.252362f,  0.252454f,  0.252547f,
	 0.252640f,  0.252733f,  0.252826f,  0.252918f,  0.253011f,  0.253104f,  0.253197f,  0.253289f,
	 0.253382f,  0.253475f,  0.253568f,  0.253660f,  0.253753f,  0.253846f,  0.253938f,  0.254031f,
	 0.254124f,  0.254217f,  0.254309f,  0.254402f,  0.254495f,  0.254588f,  0.254680f,  0.254773f,
	 0.254866f,  0.254958f,  0.255051f,  0.255144f,  0.255236f,  0.255329f,  0.255422f,  0.255515f,
	 0.255607f,  0.255700f,  0.255793f,  0.255885f,  0.255978f,  0.256071f,  0.256163f,  0.256256f,
	 0.256349f,  0.256441f,  0.256534f,  0.256627f,  0.256719f,  0.256812f,  0.256905f,  0.256997f,
	 0.257090f,  0.257183f,  0.257275f,  0.257368f,  0.257461f,  0.257553f,  0.257646f,  0.257738f,
	 0.257831f,  0.257924f,  0.258016f,  0.258109f,  0.258202f,  0.258294f,  0.258387f,  0.258479f,
	 0.258572f,  0.258665f,  0.258757f,  0.258850f,  0.258943f,  0.259035f,  0.259128f,  0.259220f,
	 0.259313f,  0.259405f,  0.259498f,  0.259591f,  0.259683f,  0.259776f,  0.259868f,  0.259961f,
	 0.260054f,  0.260146f,  0.260239f,  0.260331f,  0.260424f,  0.260516f,  0.260609f,  0.260702f,
	 0.260794f,  0.260887f,  0.260979f,  0.261072f,  0.261164f,  0.261257f,  0.261349f,  0.261442f,
	 0.261534f,  0.261627f,  0.261720f,  0.261812f,  0.261905f,  0.261997f,  0.262090f,  0.262182f,
	 0.262275f,  0.262367f,  0.262460f,  0.262552f,  0.262645f,  0.262737f,  0.262830f,  0.262922f,
	 0.263015f,  0.263107f,  0.263200f,  0.263292f,  0.263385f,  0.263477f,  0.263570f,  0.263662f,
	 0.263755f,  0.263847f,  0.263940f,  0.264032f,  0.264125f,  0.264217f,  0.264309f,  0.264402f,
	 0.264494f,  0.264587f,  0.264679f,  0.264772f,  0.264864f,  0.264957f,  0.265049f,  0.265142f,
	 0.265234f,  0.265326f,  0.265419f,  0.265511f,  0.265604f,  0.265696f,  0.265789f,  0.265881f,
	 0.265973f,  0.266066f,  0.266158f,  0.266251f,  0.266343f,  0.266436f,  0.266528f,  0.266620f,
	 0.266713f,  0.266805f,  0.266898f,  0.266990f,  0.267082f,  0.267175f,  0.267267f,  0.267359f,
	 0.267452f,  0.267544f,  0.267637f,  0.267729f,  0.267821f,  0.267914f,  0.268006f,  0.268099f,
	 0.268191f,  0.268283f,  0.268376f,  0.268468f,  0.268560f,  0.268653f,  0.268745f,  0.268837f,
	 0.268930f,  0.269022f,  0.269114f,  0.269207f,  0.269299f,  0.269391f,  0.269484f,  0.269576f,
	 0.269668f,  0.269761f,  0.269853f,  0.269945f,  0.270038f,  0.270130f,  0.270222f,  0.270315f,
	 0.270407f,  0.270499f,  0.270591f,  0.270684f,  0.270776f,  0.270868f,  0.270961f,  0.271053f,
	 0.271145f,  0.271237f,  0.271330f,  0.271422f,  0.271514f,  0.271607f,  0.271699f,  0.271791f,
	 0.271883f,  0.271976f,  0.272068f,  0.272160f,  0.272252f,  0.272345f,  0.272437f,  0.272529f,
	 0.272621f,  0.272714f,  0.272806f,  0.272898f,  0.272990f,  0.273083f,  0.273175f,  0.273267f,
	 0.273359f,  0.273451f,  0.273544f,  0.273636f,  0.273728f,  0.273820f,  0.273912f,  0.274005f,
	 0.274097f,  0.274189f,  0.274281f,  0.274374f,  0.274466f,  0.274558f,  0.274650f,  0.274742f,
	 0.274834f,  0.274927f,  0.275019f,  0.275111f,  0.275203f,  0.275295f,  0.275387f,  0.275480f,
	 0.275572f,  0.275664f,  0.275756f,  0.275848f,  0.275940f,  0.276033f,  0.276125f,  0.276217f,
	 0.276309f,  0.276401f,  0.276493f,  0.276585f,  0.276678f,  0.276770f,  0.276862f,  0.276954f,
	 0.277046f,  0.277138f,  0.277230f,  0.277322f,  0.277415f,  0.277507f,  0.277599f,  0.277691f,
	 0.277783f,  0.277875f,  0.277967f,  0.278059f,  0.278151f,  0.278243f,  0.278336f,  0.278428f,
	 0.278520f,  0.278612f,  0.278704f,  0.278796f,  0.278888f,  0.278980f,  0.279072f,  0.279164f,
	 0.279256f,  0.279348f,  0.279440f,  0.279532f,  0.279624f,  0.279717f,  0.279809f,  0.279901f,
	 0.279993f,  0.280085f,  0.280177f,  0.280269f,  0.280361f,  0.280453f,  0.280545f,  0.280637f,
	 0.280729f,  0.280821f,  0.280913f,  0.281005f,  0.281097f,  0.281189f,  0.281281f,  0.281373f,
	 0.281465f,  0.281557f,  0.281649f,  0.281741f,  0.281833f,  0.281925f,  0.282017f,  0.282109f,
	 0.282201f,  0.282293f,  0.282385f,  0.282477f,  0.282569f,  0.282661f,  0.282753f,  0.282845f,
	 0.282937f,  0.283029f,  0.283120f,  0.283212f,  0.283304f,  0.283396f,  0.283488f,  0.283580f,
	 0.283672f,  0.283764f,  0.283856f,  0.283948f,  0.284040f,  0.284132f,  0.284224f,  0.284316f,
	 0.284408f,  0.284499f,  0.284591f,  0.284683f,  0.284775f,  0.284867f,  0.284959f,  0.285051f,
	 0.285143f,  0.285235f,  0.285327f,  0.285418f,  0.285510f,  0.285602f,  0.285694f,  0.285786f,
	 0.285878f,  0.285970f,  0.286062f,  0.286153f,  0.286245f,  0.286337f,  0.286429f,  0.286521f,
	 0.286613f,  0.286705f,  0.286796f,  0.286888f,  0.286980f,  0.287072f,  0.287164f,  0.287256f,
	 0.287347f,  0.287439f,  0.287531f,  0.287623f,  0.287715f,  0.287807f,  0.287898f,  0.287990f,
	 0.288082f,  0.288174f,  0.288266f,  0.288357f,  0.288449f,  0.288541f,  0.288633f,  0.288725f,
	 0.288816f,  0.288908f,  0.289000f,  0.289092f,  0.289184f,  0.289275f,  0.289367f,  0.289459f,
	 0.289551f,  0.289642f,  0.289734f,  0.289826f,  0.289918f,  0.290009f,  0.290101f,  0.290193f,
	 0.290285f,  0.290376f,  0.290468f,  0.290560f,  0.290652f,  0.290743f,  0.290835f,  0.290927f,
	 0.291019f,  0.291110f,  0.291202f,  0.291294f,  0.291385f,  0.291477f,  0.291569f,  0.291661f,
	 0.291752f,  0.291844f,  0.291936f,  0.292027f,  0.292119f,  0.292211f,  0.292302f,  0.292394f,
	 0.292486f,  0.292577f,  0.292669f,  0.292761f,  0.292852f,  0.292944f,  0.293036f,  0.293128f,
	 0.293219f,  0.293311f,  0.293402f,  0.293494f,  0.293586f,  0.293677f,  0.293769f,  0.293861f,
	 0.293952f,  0.294044f,  0.294136f,  0.294227f,  0.294319f,  0.294410f,  0.294502f,  0.294594f,
	 0.294685f,  0.294777f,  0.294869f,  0.294960f,  0.295052f,  0.295143f,  0.295235f,  0.295327f,
	 0.295418f,  0.295510f,  0.295601f,  0.295693f,  0.295785f,  0.295876f,  0.295968f,  0.296059f,
	 0.296151f,  0.296242f,  0.296334f,  0.296426f,  0.296517f,  0.296609f,  0.296700f,  0.296792f,
	 0.296883f,  0.296975f,  0.297066f,  0.297158f,  0.297250f,  0.297341f,  0.297433f,  0.297524f,
	 0.297616f,  0.297707f,  0.297799f,  0.297890f,  0.297982f,  0.298073f,  0.298165f,  0.298256f,
	 0.298348f,  0.298439f,  0.298531f,  0.298622f,  0.298714f,  0.298805f,  0.298897f,  0.298988f,
	 0.299080f,  0.299171f,  0.299263f,  0.299354f,  0.299446f,  0.299537f,  0.299629f,  0.299720f,
	 0.299812f,  0.299903f,  0.299995f,  0.300086f,  0.300177f,  0.300269f,  0.300360f,  0.300452f,
	 0.300543f,  0.300635f,  0.300726f,  0.300818f,  0.300909f,  0.301000f,  0.301092f,  0.301183f,
	 0.301275f,  0.301366f,  0.301458f,  0.301549f,  0.301640f,  0.301732f,  0.301823f,  0.301915f,
	 0.302006f,  0.302097f,  0.302189f,  0.302280f,  0.302372f,  0.302463f,  0.302554f,  0.302646f,
	 0.302737f,  0.302828f,  0.302920f,  0.303011f,  0.303103f,  0.303194f,  0.303285f,  0.303377f,
	 0.303468f,  0.303559f,  0.303651f,  0.303742f,  0.303833f,  0.303925f,  0.304016f,  0.304107f,
	 0.304199f,  0.304290f,  0.304381f,  0.304473f,  0.304564f,  0.304655f,  0.304747f,  0.304838f,
	 0.304929f,  0.305021f,  0.305112f,  0.305203f,  0.305294f,  0.305386f,  0.305477f,  0.305568f,
	 0.305660f,  0.305751f,  0.305842f,  0.305933f,  0.306025f,  0.306116f,  0.306207f,  0.306299f,
	 0.306390f,  0.306481f,  0.306572f,  0.306664f,  0.306755f,  0.306846f,  0.306937f,  0.307029f,
	 0.307120f,  0.307211f,  0.307302f,  0.307394f,  0.307485f,  0.307576f,  0.307667f,  0.307758f,
	 0.307850f,  0.307941f,  0.308032f,  0.308123f,  0.308214f,  0.308306f,  0.308397f,  0.308488f,
	 0.308579f,  0.308670f,  0.308762f,  0.308853f,  0.308944f,  0.309035f,  0.309126f,  0.309218f,
	 0.309309f,  0.309400f,  0.309491f,  0.309582f,  0.309673f,  0.309765f,  0.309856f,  0.309947f,
	 0.310038f,  0.310129f,  0.310220f,  0.310311f,  0.310403f,  0.310494f,  0.310585f,  0.310676f,
	 0.310767f,  0.310858f,  0.310949f,  0.311041f,  0.311132f,  0.311223f,  0.311314f,  0.311405f,
	 0.311496f,  0.311587f,  0.311678f,  0.311769f,  0.311860f,  0.311952f,  0.312043f,  0.312134f,
	 0.312225f,  0.312316f,  0.312407f,  0.312498f,  0.312589f,  0.312680f,  0.312771f,  0.312862f,
	 0.312953f,  0.313044f,  0.313135f,  0.313227f,  0.313318f,  0.313409f,  0.313500f,  0.313591f,
	 0.313682f,  0.313773f,  0.313864f,  0.313955f,  0.314046f,  0.314137f,  0.314228f,  0.314319f,
	 0.314410f,  0.314501f,  0.314592f,  0.314683f,  0.314774f,  0.314865f,  0.314956f,  0.315047f,
	 0.315138f,  0.315229f,  0.315320f,  0.315411f,  0.315502f,  0.315593f,  0.315684f,  0.315775f,
	 0.315866f,  0.315957f,  0.316048f,  0.316139f,  0.316230f,  0.316321f,  0.316411f,  0.316502f,
	 0.316593f,  0.316684f,  0.316775f,  0.316866f,  0.316957f,  0.317048f,  0.317139f,  0.317230f,
	 0.317321f,  0.317412f,  0.317503f,  0.317594f,  0.317684f,  0.317775f,  0.317866f,  0.317957f,
	 0.318048f,  0.318139f,  0.318230f,  0.318321f,  0.318412f,  0.318503f,  0.318593f,  0.318684f,
	 0.318775f,  0.318866f,  0.318957f,  0.319048f,  0.319139f,  0.319229f,  0.319320f,  0.319411f,
	 0.319502f,  0.319593f,  0.319684f,  0.319775f,  0.319865f,  0.319956f,  0.320047f,  0.320138f,
	 0.320229f,  0.320320f,  0.320410f,  0.320501f,  0.320592f,  0.320683f,  0.320774f,  0.320864f,
	 0.320955f,  0.321046f,  0.321137f,  0.321228f,  0.321318f,  0.321409f,  0.321500f,  0.321591f,
	 0.321682f,  0.321772f,  0.321863f,  0.321954f,  0.322045f,  0.322135f,  0.322226f,  0.322317f,
	 0.322408f,  0.322498f,  0.322589f,  0.322680f,  0.322771f,  0.322861f,  0.322952f,  0.323043f,
	 0.323134f,  0.323224f,  0.323315f,  0.323406f,  0.323497f,  0.323587f,  0.323678f,  0.323769f,
	 0.323859f,  0.323950f,  0.324041f,  0.324131f,  0.324222f,  0.324313f,  0.324404f,  0.324494f,
	 0.324585f,  0.324676f,  0.324766f,  0.324857f,  0.324948f,  0.325038f,  0.325129f,  0.325220f,
	 0.325310f,  0.325401f,  0.325492f,  0.325582f,  0.325673f,  0.325764f,  0.325854f,  0.325945f,
	 0.326035f,  0.326126f,  0.326217f,  0.326307f,  0.326398f,  0.326489f,  0.326579f,  0.326670f,
	 0.326760f,  0.326851f,  0.326942f,  0.327032f,  0.327123f,  0.327213f,  0.327304f,  0.327395f,
	 0.327485f,  0.327576f,  0.327666f,  0.327757f,  0.327848f,  0.327938f,  0.328029f,  0.328119f,
	 0.328210f,  0.328300f,  0.328391f,  0.328482f,  0.328572f,  0.328663f,  0.328753f,  0.328844f,
	 0.328934f,  0.329025f,  0.329115f,  0.329206f,  0.329296f,  0.329387f,  0.329477f,  0.329568f,
	 0.329658f,  0.329749f,  0.329839f,  0.329930f,  0.330020f,  0.330111f,  0.330202f,  0.330292f,
	 0.330382f,  0.330473f,  0.330563f,  0.330654f,  0.330744f,  0.330835f,  0.330925f,  0.331016f,
	 0.331106f,  0.331197f,  0.331287f,  0.331378f,  0.331468f,  0.331559f,  0.331649f,  0.331739f,
	 0.331830f,  0.331920f,  0.332011f,  0.332101f,  0.332192f,  0.332282f,  0.332373f,  0.332463f,
	 0.332553f,  0.332644f,  0.332734f,  0.332825f,  0.332915f,  0.333005f,  0.333096f,  0.333186f,
	 0.333277f,  0.333367f,  0.333457f,  0.333548f,  0.333638f,  0.333729f,  0.333819f,  0.333909f,
	 0.334000f,  0.334090f,  0.334180f,  0.334271f,  0.334361f,  0.334451f,  0.334542f,  0.334632f,
	 0.334722f,  0.334813f,  0.334903f,  0.334994f,  0.335084f,  0.335174f,  0.335265f,  0.335355f,
	 0.335445f,  0.335535f,  0.335626f,  0.335716f,  0.335806f,  0.335897f,  0.335987f,  0.336077f,
	 0.336168f,  0.336258f,  0.336348f,  0.336438f,  0.336529f,  0.336619f,  0.336709f,  0.336800f,
	 0.336890f,  0.336980f,  0.337070f,  0.337161f,  0.337251f,  0.337341f,  0.337431f,  0.337522f,
	 0.337612f,  0.337702f,  0.337792f,  0.337883f,  0.337973f,  0.338063f,  0.338153f,  0.338244f,
	 0.338334f,  0.338424f,  0.338514f,  0.338604f,  0.338695f,  0.338785f,  0.338875f,  0.338965f,
	 0.339055f,  0.339146f,  0.339236f,  0.339326f,  0.339416f,  0.339506f,  0.339597f,  0.339687f,
	 0.339777f,  0.339867f,  0.339957f,  0.340047f,  0.340138f,  0.340228f,  0.340318f,  0.340408f,
	 0.340498f,  0.340588f,  0.340678f,  0.340769f,  0.340859f,  0.340949f,  0.341039f,  0.341129f,
	 0.341219f,  0.341309f,  0.341399f,  0.341490f,  0.341580f,  0.341670f,  0.341760f,  0.341850f,
	 0.341940f,  0.342030f,  0.342120f,  0.342210f,  0.342300f,  0.342391f,  0.342481f,  0.342571f,
	 0.342661f,  0.342751f,  0.342841f,  0.342931f,  0.343021f,  0.343111f,  0.343201f,  0.343291f,
	 0.343381f,  0.343471f,  0.343561f,  0.343651f,  0.343741f,  0.343831f,  0.343921f,  0.344011f,
	 0.344101f,  0.344191f,  0.344281f,  0.344371f,  0.344461f,  0.344551f,  0.344641f,  0.344731f,
	 0.344821f,  0.344911f,  0.345001f,  0.345091f,  0.345181f,  0.345271f,  0.345361f,  0.345451f,
	 0.345541f,  0.345631f,  0.345721f,  0.345811f,  0.345901f,  0.345991f,  0.346081f,  0.346171f,
	 0.346261f,  0.346351f,  0.346441f,  0.346531f,  0.346621f,  0.346711f,  0.346801f,  0.346890f,
	 0.346980f,  0.347070f,  0.347160f,  0.347250f,  0.347340f,  0.347430f,  0.347520f,  0.347610f,
	 0.347700f,  0.347790f,  0.347879f,  0.347969f,  0.348059f,  0.348149f,  0.348239f,  0.348329f,
	 0.348419f,  0.348509f,  0.348598f,  0.348688f,  0.348778f,  0.348868f,  0.348958f,  0.349048f,
	 0.349138f,  0.349227f,  0.349317f,  0.349407f,  0.349497f,  0.349587f,  0.349676f,  0.349766f,
	 0.349856f,  0.349946f,  0.350036f,  0.350126f,  0.350215f,  0.350305f,  0.350395f,  0.350485f,
	 0.350575f,  0.350664f,  0.350754f,  0.350844f,  0.350934f,  0.351023f,  0.351113f,  0.351203f,
	 0.351293f,  0.351383f,  0.351472f,  0.351562f,  0.351652f,  0.351742f,  0.351831f,  0.351921f,
	 0.352011f,  0.352100f,  0.352190f,  0.352280f,  0.352370f,  0.352459f,  0.352549f,  0.352639f,
	 0.352729f,  0.352818f,  0.352908f,  0.352998f,  0.353087f,  0.353177f,  0.353267f,  0.353356f,
	 0.353446f,  0.353536f,  0.353626f,  0.353715f,  0.353805f,  0.353895f,  0.353984f,  0.354074f,
	 0.354164f,  0.354253f,  0.354343f,  0.354432f,  0.354522f,  0.354612f,  0.354701f,  0.354791f,
	 0.354881f,  0.354970f,  0.355060f,  0.355150f,  0.355239f,  0.355329f,  0.355418f,  0.355508f,
	 0.355598f,  0.355687f,  0.355777f,  0.355866f,  0.355956f,  0.356046f,  0.356135f,  0.356225f,
	 0.356314f,  0.356404f,  0.356494f,  0.356583f,  0.356673f,  0.356762f,  0.356852f,  0.356941f,
	 0.357031f,  0.357121f,  0.357210f,  0.357300f,  0.357389f,  0.357479f,  0.357568f,  0.357658f,
	 0.357747f,  0.357837f,  0.357926f,  0.358016f,  0.358105f,  0.358195f,  0.358284f,  0.358374f,
	 0.358463f,  0.358553f,  0.358642f,  0.358732f,  0.358821f,  0.358911f,  0.359000f,  0.359090f,
	 0.359179f,  0.359269f,  0.359358f,  0.359448f,  0.359537f,  0.359627f,  0.359716f,  0.359806f,
	 0.359895f,  0.359984f,  0.360074f,  0.360163f,  0.360253f,  0.360342f,  0.360432f,  0.360521f,
	 0.360611f,  0.360700f,  0.360789f,  0.360879f,  0.360968f,  0.361058f,  0.361147f,  0.361236f,
	 0.361326f,  0.361415f,  0.361505f,  0.361594f,  0.361683f,  0.361773f,  0.361862f,  0.361952f,
	 0.362041f,  0.362130f,  0.362220f,  0.362309f,  0.362398f,  0.362488f,  0.362577f,  0.362666f,
	 0.362756f,  0.362845f,  0.362934f,  0.363024f,  0.363113f,  0.363202f,  0.363292f,  0.363381f,
	 0.363470f,  0.363560f,  0.363649f,  0.363738f,  0.363828f,  0.363917f,  0.364006f,  0.364096f,
	 0.364185f,  0.364274f,  0.364363f,  0.364453f,  0.364542f,  0.364631f,  0.364720f,  0.364810f,
	 0.364899f,  0.364988f,  0.365078f,  0.365167f,  0.365256f,  0.365345f,  0.365435f,  0.365524f,
	 0.365613f,  0.365702f,  0.365791f,  0.365881f,  0.365970f,  0.366059f,  0.366148f,  0.366238f,
	 0.366327f,  0.366416f,  0.366505f,  0.366594f,  0.366684f,  0.366773f,  0.366862f,  0.366951f,
	 0.367040f,  0.367130f,  0.367219f,  0.367308f,  0.367397f,  0.367486f,  0.367575f,  0.367665f,
	 0.367754f,  0.367843f,  0.367932f,  0.368021f,  0.368110f,  0.368199f,  0.368289f,  0.368378f,
	 0.368467f,  0.368556f,  0.368645f,  0.368734f,  0.368823f,  0.368912f,  0.369002f,  0.369091f,
	 0.369180f,  0.369269f,  0.369358f,  0.369447f,  0.369536f,  0.369625f,  0.369714f,  0.369803f,
	 0.369892f,  0.369982f,  0.370071f,  0.370160f,  0.370249f,  0.370338f,  0.370427f,  0.370516f,
	 0.370605f,  0.370694f,  0.370783f,  0.370872f,  0.370961f,  0.371050f,  0.371139f,  0.371228f,
	 0.371317f,  0.371406f,  0.371495f,  0.371584f,  0.371673f,  0.371762f,  0.371851f,  0.371940f,
	 0.372029f,  0.372118f,  0.372207f,  0.372296f,  0.372385f,  0.372474f,  0.372563f,  0.372652f,
	 0.372741f,  0.372830f,  0.372919f,  0.373008f,  0.373097f,  0.373186f,  0.373275f,  0.373364f,
	 0.373453f,  0.373542f,  0.373631f,  0.373719f,  0.373808f,  0.373897f,  0.373986f,  0.374075f,
	 0.374164f,  0.374253f,  0.374342f,  0.374431f,  0.374520f,  0.374609f,  0.374697f,  0.374786f,
	 0.374875f,  0.374964f,  0.375053f,  0.375142f,  0.375231f,  0.375320f,  0.375408f,  0.375497f,
	 0.375586f,  0.375675f,  0.375764f,  0.375853f,  0.375942f,  0.376030f,  0.376119f,  0.376208f,
	 0.376297f,  0.376386f,  0.376475f,  0.376563f,  0.376652f,  0.376741f,  0.376830f,  0.376919f,
	 0.377007f,  0.377096f,  0.377185f,  0.377274f,  0.377363f,  0.377451f,  0.377540f,  0.377629f,
	 0.377718f,  0.377806f,  0.377895f,  0.377984f,  0.378073f,  0.378162f,  0.378250f,  0.378339f,
	 0.378428f,  0.378516f,  0.378605f,  0.378694f,  0.378783f,  0.378871f,  0.378960f,  0.379049f,
	 0.379138f,  0.379226f,  0.379315f,  0.379404f,  0.379492f,  0.379581f,  0.379670f,  0.379759f,
	 0.379847f,  0.379936f,  0.380025f,  0.380113f,  0.380202f,  0.380291f,  0.380379f,  0.380468f,
	 0.380557f,  0.380645f,  0.380734f,  0.380823f,  0.380911f,  0.381000f,  0.381088f,  0.381177f,
	 0.381266f,  0.381354f,  0.381443f,  0.381532f,  0.381620f,  0.381709f,  0.381797f,  0.381886f,
	 0.381975f,  0.382063f,  0.382152f,  0.382241f,  0.382329f,  0.382418f,  0.382506f,  0.382595f,
	 0.382683f,  0.382772f,  0.382861f,  0.382949f,  0.383038f,  0.383126f,  0.383215f,  0.383303f,
	 0.383392f,  0.383480f,  0.383569f,  0.383658f,  0.383746f,  0.383835f,  0.383923f,  0.384012f,
	 0.384100f,  0.384189f,  0.384277f,  0.384366f,  0.384454f,  0.384543f,  0.384631f,  0.384720f,
	 0.384808f,  0.384897f,  0.384985f,  0.385074f,  0.385162f,  0.385251f,  0.385339f,  0.385428f,
	 0.385516f,  0.385605f,  0.385693f,  0.385781f,  0.385870f,  0.385958f,  0.386047f,  0.386135f,
	 0.386224f,  0.386312f,  0.386400f,  0.386489f,  0.386577f,  0.386666f,  0.386754f,  0.386843f,
	 0.386931f,  0.387019f,  0.387108f,  0.387196f,  0.387285f,  0.387373f,  0.387461f,  0.387550f,
	 0.387638f,  0.387727f,  0.387815f,  0.387903f,  0.387992f,  0.388080f,  0.388168f,  0.388257f,
	 0.388345f,  0.388433f,  0.388522f,  0.388610f,  0.388698f,  0.388787f,  0.388875f,  0.388963f,
	 0.389052f,  0.389140f,  0.389228f,  0.389317f,  0.389405f,  0.389493f,  0.389582f,  0.389670f,
	 0.389758f,  0.389846f,  0.389935f,  0.390023f,  0.390111f,  0.390200f,  0.390288f,  0.390376f,
	 0.390464f,  0.390553f,  0.390641f,  0.390729f,  0.390817f,  0.390906f,  0.390994f,  0.391082f,
	 0.391170f,  0.391259f,  0.391347f,  0.391435f,  0.391523f,  0.391612f,  0.391700f,  0.391788f,
	 0.391876f,  0.391964f,  0.392053f,  0.392141f,  0.392229f,  0.392317f,  0.392405f,  0.392493f,
	 0.392582f,  0.392670f,  0.392758f,  0.392846f,  0.392934f,  0.393023f,  0.393111f,  0.393199f,
	 0.393287f,  0.393375f,  0.393463f,  0.393551f,  0.393640f,  0.393728f,  0.393816f,  0.393904f,
	 0.393992f,  0.394080f,  0.394168f,  0.394256f,  0.394344f,  0.394433f,  0.394521f,  0.394609f,
	 0.394697f,  0.394785f,  0.394873f,  0.394961f,  0.395049f,  0.395137f,  0.395225f,  0.395313f,
	 0.395401f,  0.395490f,  0.395578f,  0.395666f,  0.395754f,  0.395842f,  0.395930f,  0.396018f,
	 0.396106f,  0.396194f,  0.396282f,  0.396370f,  0.396458f,  0.396546f,  0.396634f,  0.396722f,
	 0.396810f,  0.396898f,  0.396986f,  0.397074f,  0.397162f,  0.397250f,  0.397338f,  0.397426f,
	 0.397514f,  0.397602f,  0.397690f,  0.397778f,  0.397866f,  0.397954f,  0.398042f,  0.398130f,
	 0.398218f,  0.398306f,  0.398393f,  0.398481f,  0.398569f,  0.398657f,  0.398745f,  0.398833f,
	 0.398921f,  0.399009f,  0.399097f,  0.399185f,  0.399273f,  0.399361f,  0.399448f,  0.399536f,
	 0.399624f,  0.399712f,  0.399800f,  0.399888f,  0.399976f,  0.400064f,  0.400151f,  0.400239f,
	 0.400327f,  0.400415f,  0.400503f,  0.400591f,  0.400679f,  0.400766f,  0.400854f,  0.400942f,
	 0.401030f,  0.401118f,  0.401206f,  0.401293f,  0.401381f,  0.401469f,  0.401557f,  0.401645f,
	 0.401732f,  0.401820f,  0.401908f,  0.401996f,  0.402084f,  0.402171f,  0.402259f,  0.402347f,
	 0.402435f,  0.402522f,  0.402610f,  0.402698f,  0.402786f,  0.402873f,  0.402961f,  0.403049f,
	 0.403137f,  0.403224f,  0.403312f,  0.403400f,  0.403488f,  0.403575f,  0.403663f,  0.403751f,
	 0.403838f,  0.403926f,  0.404014f,  0.404102f,  0.404189f,  0.404277f,  0.404365f,  0.404452f,
	 0.404540f,  0.404628f,  0.404715f,  0.404803f,  0.404891f,  0.404978f,  0.405066f,  0.405154f,
	 0.405241f,  0.405329f,  0.405417f,  0.405504f,  0.405592f,  0.405680f,  0.405767f,  0.405855f,
	 0.405942f,  0.406030f,  0.406118f,  0.406205f,  0.406293f,  0.406380f,  0.406468f,  0.406556f,
	 0.406643f,  0.406731f,  0.406818f,  0.406906f,  0.406994f,  0.407081f,  0.407169f,  0.407256f,
	 0.407344f,  0.407431f,  0.407519f,  0.407606f,  0.407694f,  0.407782f,  0.407869f,  0.407957f,
	 0.408044f,  0.408132f,  0.408219f,  0.408307f,  0.408394f,  0.408482f,  0.408569f,  0.408657f,
	 0.408744f,  0.408832f,  0.408919f,  0.409007f,  0.409094f,  0.409182f,  0.409269f,  0.409357f,
	 0.409444f,  0.409532f,  0.409619f,  0.409707f,  0.409794f,  0.409881f,  0.409969f,  0.410056f,
	 0.410144f,  0.410231f,  0.410319f,  0.410406f,  0.410493f,  0.410581f,  0.410668f,  0.410756f,
	 0.410843f,  0.410931f,  0.411018f,  0.411105f,  0.411193f,  0.411280f,  0.411368f,  0.411455f,
	 0.411542f,  0.411630f,  0.411717f,  0.411804f,  0.411892f,  0.411979f,  0.412067f,  0.412154f,
	 0.412241f,  0.412329f,  0.412416f,  0.412503f,  0.412591f,  0.412678f,  0.412765f,  0.412853f,
	 0.412940f,  0.413027f,  0.413115f,  0.413202f,  0.413289f,  0.413376f,  0.413464f,  0.413551f,
	 0.413638f,  0.413726f,  0.413813f,  0.413900f,  0.413987f,  0.414075f,  0.414162f,  0.414249f,
	 0.414337f,  0.414424f,  0.414511f,  0.414598f,  0.414685f,  0.414773f,  0.414860f,  0.414947f,
	 0.415034f,  0.415122f,  0.415209f,  0.415296f,  0.415383f,  0.415471f,  0.415558f,  0.415645f,
	 0.415732f,  0.415819f,  0.415906f,  0.415994f,  0.416081f,  0.416168f,  0.416255f,  0.416342f,
	 0.416430f,  0.416517f,  0.416604f,  0.416691f,  0.416778f,  0.416865f,  0.416952f,  0.417040f,
	 0.417127f,  0.417214f,  0.417301f,  0.417388f,  0.417475f,  0.417562f,  0.417650f,  0.417737f,
	 0.417824f,  0.417911f,  0.417998f,  0.418085f,  0.418172f,  0.418259f,  0.418346f,  0.418433f,
	 0.418520f,  0.418608f,  0.418695f,  0.418782f,  0.418869f,  0.418956f,  0.419043f,  0.419130f,
	 0.419217f,  0.419304f,  0.419391f,  0.419478f,  0.419565f,  0.419652f,  0.419739f,  0.419826f,
	 0.419913f,  0.420000f,  0.420087f,  0.420174f,  0.420261f,  0.420348f,  0.420435f,  0.420522f,
	 0.420609f,  0.420696f,  0.420783f,  0.420870f,  0.420957f,  0.421044f,  0.421131f,  0.421218f,
	 0.421305f,  0.421392f,  0.421479f,  0.421566f,  0.421653f,  0.421739f,  0.421826f,  0.421913f,
	 0.422000f,  0.422087f,  0.422174f,  0.422261f,  0.422348f,  0.422435f,  0.422522f,  0.422609f,
	 0.422695f,  0.422782f,  0.422869f,  0.422956f,  0.423043f,  0.423130f,  0.423217f,  0.423304f,
	 0.423390f,  0.423477f,  0.423564f,  0.423651f,  0.423738f,  0.423825f,  0.423912f,  0.423998f,
	 0.424085f,  0.424172f,  0.424259f,  0.424346f,  0.424432f,  0.424519f,  0.424606f,  0.424693f,
	 0.424780f,  0.424866f,  0.424953f,  0.425040f,  0.425127f,  0.425214f,  0.425300f,  0.425387f,
	 0.425474f,  0.425561f,  0.425647f,  0.425734f,  0.425821f,  0.425908f,  0.425994f,  0.426081f,
	 0.426168f,  0.426255f,  0.426341f,  0.426428f,  0.426515f,  0.426601f,  0.426688f,  0.426775f,
	 0.426862f,  0.426948f,  0.427035f,  0.427122f,  0.427208f,  0.427295f,  0.427382f,  0.427468f,
	 0.427555f,  0.427642f,  0.427728f,  0.427815f,  0.427902f,  0.427988f,  0.428075f,  0.428162f,
	 0.428248f,  0.428335f,  0.428422f,  0.428508f,  0.428595f,  0.428681f,  0.428768f,  0.428855f,
	 0.428941f,  0.429028f,  0.429114f,  0.429201f,  0.429288f,  0.429374f,  0.429461f,  0.429547f,
	 0.429634f,  0.429721f,  0.429807f,  0.429894f,  0.429980f,  0.430067f,  0.430153f,  0.430240f,
	 0.430326f,  0.430413f,  0.430500f,  0.430586f,  0.430673f,  0.430759f,  0.430846f,  0.430932f,
	 0.431019f,  0.431105f,  0.431192f,  0.431278f,  0.431365f,  0.431451f,  0.431538f,  0.431624f,
	 0.431711f,  0.431797f,  0.431884f,  0.431970f,  0.432057f,  0.432143f,  0.432229f,  0.432316f,
	 0.432402f,  0.432489f,  0.432575f,  0.432662f,  0.432748f,  0.432835f,  0.432921f,  0.433007f,
	 0.433094f,  0.433180f,  0.433267f,  0.433353f,  0.433439f,  0.433526f,  0.433612f,  0.433699f,
	 0.433785f,  0.433871f,  0.433958f,  0.434044f,  0.434131f,  0.434217f,  0.434303f,  0.434390f,
	 0.434476f,  0.434562f,  0.434649f,  0.434735f,  0.434821f,  0.434908f,  0.434994f,  0.435080f,
	 0.435167f,  0.435253f,  0.435339f,  0.435426f,  0.435512f,  0.435598f,  0.435685f,  0.435771f,
	 0.435857f,  0.435943f,  0.436030f,  0.436116f,  0.436202f,  0.436288f,  0.436375f,  0.436461f,
	 0.436547f,  0.436633f,  0.436720f,  0.436806f,  0.436892f,  0.436978f,  0.437065f,  0.437151f,
	 0.437237f,  0.437323f,  0.437410f,  0.437496f,  0.437582f,  0.437668f,  0.437754f,  0.437841f,
	 0.437927f,  0.438013f,  0.438099f,  0.438185f,  0.438272f,  0.438358f,  0.438444f,  0.438530f,
	 0.438616f,  0.438702f,  0.438789f,  0.438875f,  0.438961f,  0.439047f,  0.439133f,  0.439219f,
	 0.439305f,  0.439392f,  0.439478f,  0.439564f,  0.439650f,  0.439736f,  0.439822f,  0.439908f,
	 0.439994f,  0.440080f,  0.440166f,  0.440253f,  0.440339f,  0.440425f,  0.440511f,  0.440597f,
	 0.440683f,  0.440769f,  0.440855f,  0.440941f,  0.441027f,  0.441113f,  0.441199f,  0.441285f,
	 0.441371f,  0.441457f,  0.441543f,  0.441629f,  0.441715f,  0.441801f,  0.441887f,  0.441973f,
	 0.442059f,  0.442145f,  0.442231f,  0.442317f,  0.442403f,  0.442489f,  0.442575f,  0.442661f,
	 0.442747f,  0.442833f,  0.442919f,  0.443005f,  0.443091f,  0.443177f,  0.443263f,  0.443349f,
	 0.443435f,  0.443521f,  0.443607f,  0.443693f,  0.443779f,  0.443864f,  0.443950f,  0.444036f,
	 0.444122f,  0.444208f,  0.444294f,  0.444380f,  0.444466f,  0.444552f,  0.444637f,  0.444723f,
	 0.444809f,  0.444895f,  0.444981f,  0.445067f,  0.445153f,  0.445239f,  0.445324f,  0.445410f,
	 0.445496f,  0.445582f,  0.445668f,  0.445754f,  0.445839f,  0.445925f,  0.446011f,  0.446097f,
	 0.446183f,  0.446268f,  0.446354f,  0.446440f,  0.446526f,  0.446612f,  0.446697f,  0.446783f,
	 0.446869f,  0.446955f,  0.447040f,  0.447126f,  0.447212f,  0.447298f,  0.447383f,  0.447469f,
	 0.447555f,  0.447641f,  0.447726f,  0.447812f,  0.447898f,  0.447983f,  0.448069f,  0.448155f,
	 0.448241f,  0.448326f,  0.448412f,  0.448498f,  0.448583f,  0.448669f,  0.448755f,  0.448840f,
	 0.448926f,  0.449012f,  0.449097f,  0.449183f,  0.449269f,  0.449354f,  0.449440f,  0.449526f,
	 0.449611f,  0.449697f,  0.449783f,  0.449868f,  0.449954f,  0.450039f,  0.450125f,  0.450211f,
	 0.450296f,  0.450382f,  0.450467f,  0.450553f,  0.450639f,  0.450724f,  0.450810f,  0.450895f,
	 0.450981f,  0.451067f,  0.451152f,  0.451238f,  0.451323f,  0.451409f,  0.451494f,  0.451580f,
	 0.451665f,  0.451751f,  0.451836f,  0.451922f,  0.452008f,  0.452093f,  0.452179f,  0.452264f,
	 0.452350f,  0.452435f,  0.452521f,  0.452606f,  0.452692f,  0.452777f,  0.452863f,  0.452948f,
	 0.453033f,  0.453119f,  0.453204f,  0.453290f,  0.453375f,  0.453461f,  0.453546f,  0.453632f,
	 0.453717f,  0.453803f,  0.453888f,  0.453973f,  0.454059f,  0.454144f,  0.454230f,  0.454315f,
	 0.454400f,  0.454486f,  0.454571f,  0.454657f,  0.454742f,  0.454827f,  0.454913f,  0.454998f,
	 0.455084f,  0.455169f,  0.455254f,  0.455340f,  0.455425f,  0.455510f,  0.455596f,  0.455681f,
	 0.455766f,  0.455852f,  0.455937f,  0.456022f,  0.456108f,  0.456193f,  0.456278f,  0.456364f,
	 0.456449f,  0.456534f,  0.456620f,  0.456705f,  0.456790f,  0.456875f,  0.456961f,  0.457046f,
	 0.457131f,  0.457217f,  0.457302f,  0.457387f,  0.457472f,  0.457558f,  0.457643f,  0.457728f,
	 0.457813f,  0.457899f,  0.457984f,  0.458069f,  0.458154f,  0.458239f,  0.458325f,  0.458410f,
	 0.458495f,  0.458580f,  0.458665f,  0.458751f,  0.458836f,  0.458921f,  0.459006f,  0.459091f,
	 0.459177f,  0.459262f,  0.459347f,  0.459432f,  0.459517f,  0.459602f,  0.459687f,  0.459773f,
	 0.459858f,  0.459943f,  0.460028f,  0.460113f,  0.460198f,  0.460283f,  0.460369f,  0.460454f,
	 0.460539f,  0.460624f,  0.460709f,  0.460794f,  0.460879f,  0.460964f,  0.461049f,  0.461134f,
	 0.461219f,  0.461304f,  0.461390f,  0.461475f,  0.461560f,  0.461645f,  0.461730f,  0.461815f,
	 0.461900f,  0.461985f,  0.462070f,  0.462155f,  0.462240f,  0.462325f,  0.462410f,  0.462495f,
	 0.462580f,  0.462665f,  0.462750f,  0.462835f,  0.462920f,  0.463005f,  0.463090f,  0.463175f,
	 0.463260f,  0.463345f,  0.463430f,  0.463515f,  0.463600f,  0.463685f,  0.463769f,  0.463854f,
	 0.463939f,  0.464024f,  0.464109f,  0.464194f,  0.464279f,  0.464364f,  0.464449f,  0.464534f,
	 0.464619f,  0.464704f,  0.464788f,  0.464873f,  0.464958f,  0.465043f,  0.465128f,  0.465213f,
	 0.465298f,  0.465383f,  0.465467f,  0.465552f,  0.465637f,  0.465722f,  0.465807f,  0.465892f,
	 0.465977f,  0.466061f,  0.466146f,  0.466231f,  0.466316f,  0.466401f,  0.466485f,  0.466570f,
	 0.466655f,  0.466740f,  0.466825f,  0.466909f,  0.466994f,  0.467079f,  0.467164f,  0.467248f,
	 0.467333f,  0.467418f,  0.467503f,  0.467587f,  0.467672f,  0.467757f,  0.467842f,  0.467926f,
	 0.468011f,  0.468096f,  0.468181f,  0.468265f,  0.468350f,  0.468435f,  0.468519f,  0.468604f,
	 0.468689f,  0.468774f,  0.468858f,  0.468943f,  0.469028f,  0.469112f,  0.469197f,  0.469282f,
	 0.469366f,  0.469451f,  0.469536f,  0.469620f,  0.469705f,  0.469789f,  0.469874f,  0.469959f,
	 0.470043f,  0.470128f,  0.470213f,  0.470297f,  0.470382f,  0.470466f,  0.470551f,  0.470636f,
	 0.470720f,  0.470805f,  0.470889f,  0.470974f,  0.471058f,  0.471143f,  0.471228f,  0.471312f,
	 0.471397f,  0.471481f,  0.471566f,  0.471650f,  0.471735f,  0.471819f,  0.471904f,  0.471988f,
	 0.472073f,  0.472158f,  0.472242f,  0.472327f,  0.472411f,  0.472496f,  0.472580f,  0.472665f,
	 0.472749f,  0.472834f,  0.472918f,  0.473002f,  0.473087f,  0.473171f,  0.473256f,  0.473340f,
	 0.473425f,  0.473509f,  0.473594f,  0.473678f,  0.473763f,  0.473847f,  0.473931f,  0.474016f,
	 0.474100f,  0.474185f,  0.474269f,  0.474353f,  0.474438f,  0.474522f,  0.474607f,  0.474691f,
	 0.474775f,  0.474860f,  0.474944f,  0.475029f,  0.475113f,  0.475197f,  0.475282f,  0.475366f,
	 0.475450f,  0.475535f,  0.475619f,  0.475703f,  0.475788f,  0.475872f,  0.475956f,  0.476041f,
	 0.476125f,  0.476209f,  0.476294f,  0.476378f,  0.476462f,  0.476546f,  0.476631f,  0.476715f,
	 0.476799f,  0.476884f,  0.476968f,  0.477052f,  0.477136f,  0.477221f,  0.477305f,  0.477389f,
	 0.477473f,  0.477558f,  0.477642f,  0.477726f,  0.477810f,  0.477894f,  0.477979f,  0.478063f,
	 0.478147f,  0.478231f,  0.478315f,  0.478400f,  0.478484f,  0.478568f,  0.478652f,  0.478736f,
	 0.478821f,  0.478905f,  0.478989f,  0.479073f,  0.479157f,  0.479241f,  0.479325f,  0.479410f,
	 0.479494f,  0.479578f,  0.479662f,  0.479746f,  0.479830f,  0.479914f,  0.479998f,  0.480083f,
	 0.480167f,  0.480251f,  0.480335f,  0.480419f,  0.480503f,  0.480587f,  0.480671f,  0.480755f,
	 0.480839f,  0.480923f,  0.481007f,  0.481091f,  0.481176f,  0.481260f,  0.481344f,  0.481428f,
	 0.481512f,  0.481596f,  0.481680f,  0.481764f,  0.481848f,  0.481932f,  0.482016f,  0.482100f,
	 0.482184f,  0.482268f,  0.482352f,  0.482436f,  0.482520f,  0.482604f,  0.482688f,  0.482772f,
	 0.482856f,  0.482940f,  0.483023f,  0.483107f,  0.483191f,  0.483275f,  0.483359f,  0.483443f,
	 0.483527f,  0.483611f,  0.483695f,  0.483779f,  0.483863f,  0.483947f,  0.484031f,  0.484114f,
	 0.484198f,  0.484282f,  0.484366f,  0.484450f,  0.484534f,  0.484618f,  0.484702f,  0.484785f,
	 0.484869f,  0.484953f,  0.485037f,  0.485121f,  0.485205f,  0.485288f,  0.485372f,  0.485456f,
	 0.485540f,  0.485624f,  0.485708f,  0.485791f,  0.485875f,  0.485959f,  0.486043f,  0.486126f,
	 0.486210f,  0.486294f,  0.486378f,  0.486462f,  0.486545f,  0.486629f,  0.486713f,  0.486797f,
	 0.486880f,  0.486964f,  0.487048f,  0.487132f,  0.487215f,  0.487299f,  0.487383f,  0.487466f,
	 0.487550f,  0.487634f,  0.487718f,  0.487801f,  0.487885f,  0.487969f,  0.488052f,  0.488136f,
	 0.488220f,  0.488303f,  0.488387f,  0.488471f,  0.488554f,  0.488638f,  0.488722f,  0.488805f,
	 0.488889f,  0.488973f,  0.489056f,  0.489140f,  0.489223f,  0.489307f,  0.489391f,  0.489474f,
	 0.489558f,  0.489641f,  0.489725f,  0.489809f,  0.489892f,  0.489976f,  0.490059f,  0.490143f,
	 0.490226f,  0.490310f,  0.490394f,  0.490477f,  0.490561f,  0.490644f,  0.490728f,  0.490811f,
	 0.490895f,  0.490978f,  0.491062f,  0.491145f,  0.491229f,  0.491312f,  0.491396f,  0.491479f,
	 0.491563f,  0.491646f,  0.491730f,  0.491813f,  0.491897f,  0.491980f,  0.492064f,  0.492147f,
	 0.492231f,  0.492314f,  0.492398f,  0.492481f,  0.492564f,  0.492648f,  0.492731f,  0.492815f,
	 0.492898f,  0.492982f,  0.493065f,  0.493148f,  0.493232f,  0.493315f,  0.493399f,  0.493482f,
	 0.493565f,  0.493649f,  0.493732f,  0.493816f,  0.493899f,  0.493982f,  0.494066f,  0.494149f,
	 0.494232f,  0.494316f,  0.494399f,  0.494482f,  0.494566f,  0.494649f,  0.494732f,  0.494816f,
	 0.494899f,  0.494982f,  0.495066f,  0.495149f,  0.495232f,  0.495315f,  0.495399f,  0.495482f,
	 0.495565f,  0.495649f,  0.495732f,  0.495815f,  0.495898f,  0.495982f,  0.496065f,  0.496148f,
	 0.496231f,  0.496315f,  0.496398f,  0.496481f,  0.496564f,  0.496647f,  0.496731f,  0.496814f,
	 0.496897f,  0.496980f,  0.497063f,  0.497147f,  0.497230f,  0.497313f,  0.497396f,  0.497479f,
	 0.497562f,  0.497646f,  0.497729f,  0.497812f,  0.497895f,  0.497978f,  0.498061f,  0.498145f,
	 0.498228f,  0.498311f,  0.498394f,  0.498477f,  0.498560f,  0.498643f,  0.498726f,  0.498809f,
	 0.498893f,  0.498976f,  0.499059f,  0.499142f,  0.499225f,  0.499308f,  0.499391f,  0.499474f,
	 0.499557f,  0.499640f,  0.499723f,  0.499806f,  0.499889f,  0.499972f,  0.500055f,  0.500138f,
	 0.500221f,  0.500304f,  0.500387f,  0.500470f,  0.500553f,  0.500636f,  0.500719f,  0.500802f,
	 0.500885f,  0.500968f,  0.501051f,  0.501134f,  0.501217f,  0.501300f,  0.501383f,  0.501466f,
	 0.501549f,  0.501632f,  0.501715f,  0.501798f,  0.501881f,  0.501964f,  0.502047f,  0.502130f,
	 0.502212f,  0.502295f,  0.502378f,  0.502461f,  0.502544f,  0.502627f,  0.502710f,  0.502793f,
	 0.502876f,  0.502958f,  0.503041f,  0.503124f,  0.503207f,  0.503290f,  0.503373f,  0.503456f,
	 0.503538f,  0.503621f,  0.503704f,  0.503787f,  0.503870f,  0.503953f,  0.504035f,  0.504118f,
	 0.504201f,  0.504284f,  0.504366f,  0.504449f,  0.504532f,  0.504615f,  0.504698f,  0.504780f,
	 0.504863f,  0.504946f,  0.505029f,  0.505111f,  0.505194f,  0.505277f,  0.505360f,  0.505442f,
	 0.505525f,  0.505608f,  0.505690f,  0.505773f,  0.505856f,  0.505939f,  0.506021f,  0.506104f,
	 0.506187f,  0.506269f,  0.506352f,  0.506435f,  0.506517f,  0.506600f,  0.506683f,  0.506765f,
	 0.506848f,  0.506931f,  0.507013f,  0.507096f,  0.507179f,  0.507261f,  0.507344f,  0.507426f,
	 0.507509f,  0.507592f,  0.507674f,  0.507757f,  0.507839f,  0.507922f,  0.508005f,  0.508087f,
	 0.508170f,  0.508252f,  0.508335f,  0.508417f,  0.508500f,  0.508583f,  0.508665f,  0.508748f,
	 0.508830f,  0.508913f,  0.508995f,  0.509078f,  0.509160f,  0.509243f,  0.509325f,  0.509408f,
	 0.509490f,  0.509573f,  0.509655f,  0.509738f,  0.509820f,  0.509903f,  0.509985f,  0.510068f,
	 0.510150f,  0.510233f,  0.510315f,  0.510397f,  0.510480f,  0.510562f,  0.510645f,  0.510727f,
	 0.510810f,  0.510892f,  0.510974f,  0.511057f,  0.511139f,  0.511222f,  0.511304f,  0.511386f,
	 0.511469f,  0.511551f,  0.511634f,  0.511716f,  0.511798f,  0.511881f,  0.511963f,  0.512045f,
	 0.512128f,  0.512210f,  0.512292f,  0.512375f,  0.512457f,  0.512539f,  0.512622f,  0.512704f,
	 0.512786f,  0.512869f,  0.512951f,  0.513033f,  0.513116f,  0.513198f,  0.513280f,  0.513362f,
	 0.513445f,  0.513527f,  0.513609f,  0.513692f,  0.513774f,  0.513856f,  0.513938f,  0.514021f,
	 0.514103f,  0.514185f,  0.514267f,  0.514349f,  0.514432f,  0.514514f,  0.514596f,  0.514678f,
	 0.514760f,  0.514843f,  0.514925f,  0.515007f,  0.515089f,  0.515171f,  0.515254f,  0.515336f,
	 0.515418f,  0.515500f,  0.515582f,  0.515664f,  0.515746f,  0.515829f,  0.515911f,  0.515993f,
	 0.516075f,  0.516157f,  0.516239f,  0.516321f,  0.516403f,  0.516486f,  0.516568f,  0.516650f,
	 0.516732f,  0.516814f,  0.516896f,  0.516978f,  0.517060f,  0.517142f,  0.517224f,  0.517306f,
	 0.517388f,  0.517470f,  0.517552f,  0.517634f,  0.517716f,  0.517798f,  0.517880f,  0.517963f,
	 0.518045f,  0.518126f,  0.518209f,  0.518291f,  0.518372f,  0.518454f,  0.518536f,  0.518618f,
	 0.518700f,  0.518782f,  0.518864f,  0.518946f,  0.519028f,  0.519110f,  0.519192f,  0.519274f,
	 0.519356f,  0.519438f,  0.519520f,  0.519602f,  0.519684f,  0.519766f,  0.519848f,  0.519929f,
	 0.520011f,  0.520093f,  0.520175f,  0.520257f,  0.520339f,  0.520421f,  0.520503f,  0.520584f,
	 0.520666f,  0.520748f,  0.520830f,  0.520912f,  0.520994f,  0.521075f,  0.521157f,  0.521239f,
	 0.521321f,  0.521403f,  0.521485f,  0.521566f,  0.521648f,  0.521730f,  0.521812f,  0.521894f,
	 0.521975f,  0.522057f,  0.522139f,  0.522221f,  0.522302f,  0.522384f,  0.522466f,  0.522548f,
	 0.522629f,  0.522711f,  0.522793f,  0.522875f,  0.522956f,  0.523038f,  0.523120f,  0.523201f,
	 0.523283f,  0.523365f,  0.523447f,  0.523528f,  0.523610f,  0.523692f,  0.523773f,  0.523855f,
	 0.523937f,  0.524018f,  0.524100f,  0.524181f,  0.524263f,  0.524345f,  0.524426f,  0.524508f,
	 0.524590f,  0.524671f,  0.524753f,  0.524835f,  0.524916f,  0.524998f,  0.525079f,  0.525161f,
	 0.525243f,  0.525324f,  0.525406f,  0.525487f,  0.525569f,  0.525650f,  0.525732f,  0.525813f,
	 0.525895f,  0.525977f,  0.526058f,  0.526140f,  0.526221f,  0.526303f,  0.526384f,  0.526466f,
	 0.526547f,  0.526629f,  0.526710f,  0.526792f,  0.526873f,  0.526955f,  0.527036f,  0.527118f,
	 0.527199f,  0.527281f,  0.527362f,  0.527444f,  0.527525f,  0.527606f,  0.527688f,  0.527769f,
	 0.527851f,  0.527932f,  0.528014f,  0.528095f,  0.528176f,  0.528258f,  0.528339f,  0.528421f,
	 0.528502f,  0.528583f,  0.528665f,  0.528746f,  0.528828f,  0.528909f,  0.528990f,  0.529072f,
	 0.529153f,  0.529234f,  0.529316f,  0.529397f,  0.529478f,  0.529560f,  0.529641f,  0.529722f,
	 0.529804f,  0.529885f,  0.529966f,  0.530048f,  0.530129f,  0.530210f,  0.530291f,  0.530373f,
	 0.530454f,  0.530535f,  0.530617f,  0.530698f,  0.530779f,  0.530860f,  0.530942f,  0.531023f,
	 0.531104f,  0.531185f,  0.531266f,  0.531348f,  0.531429f,  0.531510f,  0.531591f,  0.531673f,
	 0.531754f,  0.531835f,  0.531916f,  0.531997f,  0.532078f,  0.532160f,  0.532241f,  0.532322f,
	 0.532403f,  0.532484f,  0.532565f,  0.532647f,  0.532728f,  0.532809f,  0.532890f,  0.532971f,
	 0.533052f,  0.533133f,  0.533214f,  0.533296f,  0.533377f,  0.533458f,  0.533539f,  0.533620f,
	 0.533701f,  0.533782f,  0.533863f,  0.533944f,  0.534025f,  0.534106f,  0.534187f,  0.534268f,
	 0.534349f,  0.534431f,  0.534512f,  0.534593f,  0.534674f,  0.534755f,  0.534836f,  0.534917f,
	 0.534998f,  0.535079f,  0.535160f,  0.535241f,  0.535322f,  0.535403f,  0.535484f,  0.535564f,
	 0.535645f,  0.535726f,  0.535807f,  0.535888f,  0.535969f,  0.536050f,  0.536131f,  0.536212f,
	 0.536293f,  0.536374f,  0.536455f,  0.536536f,  0.536617f,  0.536698f,  0.536778f,  0.536859f,
	 0.536940f,  0.537021f,  0.537102f,  0.537183f,  0.537264f,  0.537345f,  0.537425f,  0.537506f,
	 0.537587f,  0.537668f,  0.537749f,  0.537830f,  0.537910f,  0.537991f,  0.538072f,  0.538153f,
	 0.538234f,  0.538314f,  0.538395f,  0.538476f,  0.538557f,  0.538638f,  0.538718f,  0.538799f,
	 0.538880f,  0.538961f,  0.539041f,  0.539122f,  0.539203f,  0.539284f,  0.539364f,  0.539445f,
	 0.539526f,  0.539607f,  0.539687f,  0.539768f,  0.539849f,  0.539929f,  0.540010f,  0.540091f,
	 0.540171f,  0.540252f,  0.540333f,  0.540413f,  0.540494f,  0.540575f,  0.540655f,  0.540736f,
	 0.540817f,  0.540897f,  0.540978f,  0.541059f,  0.541139f,  0.541220f,  0.541301f,  0.541381f,
	 0.541462f,  0.541542f,  0.541623f,  0.541704f,  0.541784f,  0.541865f,  0.541945f,  0.542026f,
	 0.542106f,  0.542187f,  0.542268f,  0.542348f,  0.542429f,  0.542509f,  0.542590f,  0.542670f,
	 0.542751f,  0.542831f,  0.542912f,  0.542992f,  0.543073f,  0.543153f,  0.543234f,  0.543314f,
	 0.543395f,  0.543475f,  0.543556f,  0.543636f,  0.543717f,  0.543797f,  0.543878f,  0.543958f,
	 0.544039f,  0.544119f,  0.544199f,  0.544280f,  0.544360f,  0.544441f,  0.544521f,  0.544602f,
	 0.544682f,  0.544762f,  0.544843f,  0.544923f,  0.545003f,  0.545084f,  0.545164f,  0.545245f,
	 0.545325f,  0.545405f,  0.545486f,  0.545566f,  0.545646f,  0.545727f,  0.545807f,  0.545887f,
	 0.545968f,  0.546048f,  0.546128f,  0.546209f,  0.546289f,  0.546369f,  0.546450f,  0.546530f,
	 0.546610f,  0.546690f,  0.546771f,  0.546851f,  0.546931f,  0.547011f,  0.547092f,  0.547172f,
	 0.547252f,  0.547333f,  0.547413f,  0.547493f,  0.547573f,  0.547653f,  0.547734f,  0.547814f,
	 0.547894f,  0.547974f,  0.548054f,  0.548135f,  0.548215f,  0.548295f,  0.548375f,  0.548455f,
	 0.548536f,  0.548616f,  0.548696f,  0.548776f,  0.548856f,  0.548936f,  0.549016f,  0.549097f,
	 0.549177f,  0.549257f,  0.549337f,  0.549417f,  0.549497f,  0.549577f,  0.549657f,  0.549737f,
	 0.549818f,  0.549898f,  0.549978f,  0.550058f,  0.550138f,  0.550218f,  0.550298f,  0.550378f,
	 0.550458f,  0.550538f,  0.550618f,  0.550698f,  0.550778f,  0.550858f,  0.550938f,  0.551018f,
	 0.551098f,  0.551178f,  0.551258f,  0.551338f,  0.551418f,  0.551498f,  0.551578f,  0.551658f,
	 0.551738f,  0.551818f,  0.551898f,  0.551978f,  0.552058f,  0.552138f,  0.552218f,  0.552298f,
	 0.552378f,  0.552457f,  0.552537f,  0.552617f,  0.552697f,  0.552777f,  0.552857f,  0.552937f,
	 0.553017f,  0.553097f,  0.553176f,  0.553256f,  0.553336f,  0.553416f,  0.553496f,  0.553576f,
	 0.553656f,  0.553735f,  0.553815f,  0.553895f,  0.553975f,  0.554055f,  0.554134f,  0.554214f,
	 0.554294f,  0.554374f,  0.554454f,  0.554533f,  0.554613f,  0.554693f,  0.554773f,  0.554853f,
	 0.554932f,  0.555012f,  0.555092f,  0.555172f,  0.555251f,  0.555331f,  0.555411f,  0.555490f,
	 0.555570f,  0.555650f,  0.555730f,  0.555809f,  0.555889f,  0.555969f,  0.556048f,  0.556128f,
	 0.556208f,  0.556287f,  0.556367f,  0.556447f,  0.556526f,  0.556606f,  0.556686f,  0.556765f,
	 0.556845f,  0.556925f,  0.557004f,  0.557084f,  0.557164f,  0.557243f,  0.557323f,  0.557402f,
	 0.557482f,  0.557562f,  0.557641f,  0.557721f,  0.557800f,  0.557880f,  0.557959f,  0.558039f,
	 0.558119f,  0.558198f,  0.558278f,  0.558357f,  0.558437f,  0.558516f,  0.558596f,  0.558675f,
	 0.558755f,  0.558834f,  0.558914f,  0.558993f,  0.559073f,  0.559152f,  0.559232f,  0.559311f,
	 0.559391f,  0.559470f,  0.559550f,  0.559629f,  0.559709f,  0.559788f,  0.559867f,  0.559947f,
	 0.560026f,  0.560106f,  0.560185f,  0.560265f,  0.560344f,  0.560423f,  0.560503f,  0.560582f,
	 0.560662f,  0.560741f,  0.560820f,  0.560900f,  0.560979f,  0.561058f,  0.561138f,  0.561217f,
	 0.561297f,  0.561376f,  0.561455f,  0.561535f,  0.561614f,  0.561693f,  0.561773f,  0.561852f,
	 0.561931f,  0.562010f,  0.562090f,  0.562169f,  0.562248f,  0.562328f,  0.562407f,  0.562486f,
	 0.562565f,  0.562645f,  0.562724f,  0.562803f,  0.562882f,  0.562962f,  0.563041f,  0.563120f,
	 0.563199f,  0.563279f,  0.563358f,  0.563437f,  0.563516f,  0.563595f,  0.563675f,  0.563754f,
	 0.563833f,  0.563912f,  0.563991f,  0.564070f,  0.564150f,  0.564229f,  0.564308f,  0.564387f,
	 0.564466f,  0.564545f,  0.564624f,  0.564704f,  0.564783f,  0.564862f,  0.564941f,  0.565020f,
	 0.565099f,  0.565178f,  0.565257f,  0.565336f,  0.565416f,  0.565495f,  0.565574f,  0.565653f,
	 0.565732f,  0.565811f,  0.565890f,  0.565969f,  0.566048f,  0.566127f,  0.566206f,  0.566285f,
	 0.566364f,  0.566443f,  0.566522f,  0.566601f,  0.566680f,  0.566759f,  0.566838f,  0.566917f,
	 0.566996f,  0.567075f,  0.567154f,  0.567233f,  0.567312f,  0.567391f,  0.567470f,  0.567549f,
	 0.567628f,  0.567707f,  0.567786f,  0.567864f,  0.567943f,  0.568022f,  0.568101f,  0.568180f,
	 0.568259f,  0.568338f,  0.568417f,  0.568496f,  0.568574f,  0.568653f,  0.568732f,  0.568811f,
	 0.568890f,  0.568969f,  0.569048f,  0.569126f,  0.569205f,  0.569284f,  0.569363f,  0.569442f,
	 0.569521f,  0.569599f,  0.569678f,  0.569757f,  0.569836f,  0.569914f,  0.569993f,  0.570072f,
	 0.570151f,  0.570230f,  0.570308f,  0.570387f,  0.570466f,  0.570545f,  0.570623f,  0.570702f,
	 0.570781f,  0.570859f,  0.570938f,  0.571017f,  0.571096f,  0.571174f,  0.571253f,  0.571332f,
	 0.571410f,  0.571489f,  0.571568f,  0.571646f,  0.571725f,  0.571804f,  0.571882f,  0.571961f,
	 0.572040f,  0.572118f,  0.572197f,  0.572276f,  0.572354f,  0.572433f,  0.572511f,  0.572590f,
	 0.572669f,  0.572747f,  0.572826f,  0.572904f,  0.572983f,  0.573061f,  0.573140f,  0.573219f,
	 0.573297f,  0.573376f,  0.573454f,  0.573533f,  0.573611f,  0.573690f,  0.573768f,  0.573847f,
	 0.573925f,  0.574004f,  0.574082f,  0.574161f,  0.574239f,  0.574318f,  0.574396f,  0.574475f,
	 0.574553f,  0.574632f,  0.574710f,  0.574789f,  0.574867f,  0.574946f,  0.575024f,  0.575103f,
	 0.575181f,  0.575259f,  0.575338f,  0.575416f,  0.575495f,  0.575573f,  0.575651f,  0.575730f,
	 0.575808f,  0.575887f,  0.575965f,  0.576043f,  0.576122f,  0.576200f,  0.576278f,  0.576357f,
	 0.576435f,  0.576513f,  0.576592f,  0.576670f,  0.576748f,  0.576827f,  0.576905f,  0.576983f,
	 0.577062f,  0.577140f,  0.577218f,  0.577297f,  0.577375f,  0.577453f,  0.577531f,  0.577610f,
	 0.577688f,  0.577766f,  0.577844f,  0.577923f,  0.578001f,  0.578079f,  0.578157f,  0.578236f,
	 0.578314f,  0.578392f,  0.578470f,  0.578548f,  0.578627f,  0.578705f,  0.578783f,  0.578861f,
	 0.578939f,  0.579018f,  0.579096f,  0.579174f,  0.579252f,  0.579330f,  0.579408f,  0.579486f,
	 0.579565f,  0.579643f,  0.579721f,  0.579799f,  0.579877f,  0.579955f,  0.580033f,  0.580111f,
	 0.580189f,  0.580267f,  0.580346f,  0.580424f,  0.580502f,  0.580580f,  0.580658f,  0.580736f,
	 0.580814f,  0.580892f,  0.580970f,  0.581048f,  0.581126f,  0.581204f,  0.581282f,  0.581360f,
	 0.581438f,  0.581516f,  0.581594f,  0.581672f,  0.581750f,  0.581828f,  0.581906f,  0.581984f,
	 0.582062f,  0.582140f,  0.582218f,  0.582296f,  0.582374f,  0.582452f,  0.582530f,  0.582608f,
	 0.582685f,  0.582763f,  0.582841f,  0.582919f,  0.582997f,  0.583075f,  0.583153f,  0.583231f,
	 0.583309f,  0.583387f,  0.583464f,  0.583542f,  0.583620f,  0.583698f,  0.583776f,  0.583854f,
	 0.583931f,  0.584009f,  0.584087f,  0.584165f,  0.584243f,  0.584321f,  0.584398f,  0.584476f,
	 0.584554f,  0.584632f,  0.584710f,  0.584787f,  0.584865f,  0.584943f,  0.585021f,  0.585098f,
	 0.585176f,  0.585254f,  0.585332f,  0.585409f,  0.585487f,  0.585565f,  0.585642f,  0.585720f,
	 0.585798f,  0.585876f,  0.585953f,  0.586031f,  0.586109f,  0.586186f,  0.586264f,  0.586342f,
	 0.586419f,  0.586497f,  0.586575f,  0.586652f,  0.586730f,  0.586808f,  0.586885f,  0.586963f,
	 0.587040f,  0.587118f,  0.587196f,  0.587273f,  0.587351f,  0.587428f,  0.587506f,  0.587584f,
	 0.587661f,  0.587739f,  0.587816f,  0.587894f,  0.587971f,  0.588049f,  0.588126f,  0.588204f,
	 0.588282f,  0.588359f,  0.588437f,  0.588514f,  0.588592f,  0.588669f,  0.588747f,  0.588824f,
	 0.588902f,  0.588979f,  0.589057f,  0.589134f,  0.589212f,  0.589289f,  0.589366f,  0.589444f,
	 0.589521f,  0.589599f,  0.589676f,  0.589754f,  0.589831f,  0.589908f,  0.589986f,  0.590063f,
	 0.590141f,  0.590218f,  0.590295f,  0.590373f,  0.590450f,  0.590528f,  0.590605f,  0.590682f,
	 0.590760f,  0.590837f,  0.590914f,  0.590992f,  0.591069f,  0.591146f,  0.591224f,  0.591301f,
	 0.591378f,  0.591456f,  0.591533f,  0.591610f,  0.591688f,  0.591765f,  0.591842f,  0.591919f,
	 0.591997f,  0.592074f,  0.592151f,  0.592228f,  0.592306f,  0.592383f,  0.592460f,  0.592537f,
	 0.592615f,  0.592692f,  0.592769f,  0.592846f,  0.592924f,  0.593001f,  0.593078f,  0.593155f,
	 0.593232f,  0.593309f,  0.593387f,  0.593464f,  0.593541f,  0.593618f,  0.593695f,  0.593772f,
	 0.593850f,  0.593927f,  0.594004f,  0.594081f,  0.594158f,  0.594235f,  0.594312f,  0.594389f,
	 0.594467f,  0.594544f,  0.594621f,  0.594698f,  0.594775f,  0.594852f,  0.594929f,  0.595006f,
	 0.595083f,  0.595160f,  0.595237f,  0.595314f,  0.595391f,  0.595468f,  0.595545f,  0.595622f,
	 0.595699f,  0.595776f,  0.595853f,  0.595930f,  0.596007f,  0.596084f,  0.596161f,  0.596238f,
	 0.596315f,  0.596392f,  0.596469f,  0.596546f,  0.596623f,  0.596700f,  0.596777f,  0.596854f,
	 0.596931f,  0.597008f,  0.597085f,  0.597161f,  0.597238f,  0.597315f,  0.597392f,  0.597469f,
	 0.597546f,  0.597623f,  0.597700f,  0.597776f,  0.597853f,  0.597930f,  0.598007f,  0.598084f,
	 0.598161f,  0.598238f,  0.598314f,  0.598391f,  0.598468f,  0.598545f,  0.598622f,  0.598698f,
	 0.598775f,  0.598852f,  0.598929f,  0.599006f,  0.599082f,  0.599159f,  0.599236f,  0.599313f,
	 0.599389f,  0.599466f,  0.599543f,  0.599620f,  0.599696f,  0.599773f,  0.599850f,  0.599926f,
	 0.600003f,  0.600080f,  0.600156f,  0.600233f,  0.600310f,  0.600387f,  0.600463f,  0.600540f,
	 0.600616f,  0.600693f,  0.600770f,  0.600846f,  0.600923f,  0.601000f,  0.601076f,  0.601153f,
	 0.601230f,  0.601306f,  0.601383f,  0.601459f,  0.601536f,  0.601613f,  0.601689f,  0.601766f,
	 0.601842f,  0.601919f,  0.601995f,  0.602072f,  0.602148f,  0.602225f,  0.602302f,  0.602378f,
	 0.602455f,  0.602531f,  0.602608f,  0.602684f,  0.602761f,  0.602837f,  0.602914f,  0.602990f,
	 0.603067f,  0.603143f,  0.603220f,  0.603296f,  0.603372f,  0.603449f,  0.603525f,  0.603602f,
	 0.603678f,  0.603755f,  0.603831f,  0.603908f,  0.603984f,  0.604060f,  0.604137f,  0.604213f,
	 0.604290f,  0.604366f,  0.604442f,  0.604519f,  0.604595f,  0.604671f,  0.604748f,  0.604824f,
	 0.604900f,  0.604977f,  0.605053f,  0.605129f,  0.605206f,  0.605282f,  0.605358f,  0.605435f,
	 0.605511f,  0.605587f,  0.605664f,  0.605740f,  0.605816f,  0.605892f,  0.605969f,  0.606045f,
	 0.606121f,  0.606198f,  0.606274f,  0.606350f,  0.606426f,  0.606502f,  0.606579f,  0.606655f,
	 0.606731f,  0.606807f,  0.606884f,  0.606960f,  0.607036f,  0.607112f,  0.607188f,  0.607264f,
	 0.607341f,  0.607417f,  0.607493f,  0.607569f,  0.607645f,  0.607721f,  0.607798f,  0.607874f,
	 0.607950f,  0.608026f,  0.608102f,  0.608178f,  0.608254f,  0.608330f,  0.608406f,  0.608482f,
	 0.608559f,  0.608635f,  0.608711f,  0.608787f,  0.608863f,  0.608939f,  0.609015f,  0.609091f,
	 0.609167f,  0.609243f,  0.609319f,  0.609395f,  0.609471f,  0.609547f,  0.609623f,  0.609699f,
	 0.609775f,  0.609851f,  0.609927f,  0.610003f,  0.610079f,  0.610155f,  0.610231f,  0.610307f,
	 0.610383f,  0.610459f,  0.610535f,  0.610611f,  0.610687f,  0.610762f,  0.610838f,  0.610914f,
	 0.610990f,  0.611066f,  0.611142f,  0.611218f,  0.611294f,  0.611370f,  0.611445f,  0.611521f,
	 0.611597f,  0.611673f,  0.611749f,  0.611825f,  0.611901f,  0.611976f,  0.612052f,  0.612128f,
	 0.612204f,  0.612280f,  0.612355f,  0.612431f,  0.612507f,  0.612583f,  0.612659f,  0.612734f,
	 0.612810f,  0.612886f,  0.612962f,  0.613037f,  0.613113f,  0.613189f,  0.613265f,  0.613340f,
	 0.613416f,  0.613492f,  0.613567f,  0.613643f,  0.613719f,  0.613795f,  0.613870f,  0.613946f,
	 0.614022f,  0.614097f,  0.614173f,  0.614249f,  0.614324f,  0.614400f,  0.614475f,  0.614551f,
	 0.614627f,  0.614702f,  0.614778f,  0.614854f,  0.614929f,  0.615005f,  0.615080f,  0.615156f,
	 0.615232f,  0.615307f,  0.615383f,  0.615458f,  0.615534f,  0.615609f,  0.615685f,  0.615761f,
	 0.615836f,  0.615912f,  0.615987f,  0.616063f,  0.616138f,  0.616214f,  0.616289f,  0.616365f,
	 0.616440f,  0.616516f,  0.616591f,  0.616667f,  0.616742f,  0.616818f,  0.616893f,  0.616968f,
	 0.617044f,  0.617119f,  0.617195f,  0.617270f,  0.617346f,  0.617421f,  0.617496f,  0.617572f,
	 0.617647f,  0.617723f,  0.617798f,  0.617873f,  0.617949f,  0.618024f,  0.618100f,  0.618175f,
	 0.618250f,  0.618326f,  0.618401f,  0.618476f,  0.618552f,  0.618627f,  0.618702f,  0.618778f,
	 0.618853f,  0.618928f,  0.619004f,  0.619079f,  0.619154f,  0.619229f,  0.619305f,  0.619380f,
	 0.619455f,  0.619531f,  0.619606f,  0.619681f,  0.619756f,  0.619832f,  0.619907f,  0.619982f,
	 0.620057f,  0.620132f,  0.620208f,  0.620283f,  0.620358f,  0.620433f,  0.620508f,  0.620584f,
	 0.620659f,  0.620734f,  0.620809f,  0.620884f,  0.620959f,  0.621035f,  0.621110f,  0.621185f,
	 0.621260f,  0.621335f,  0.621410f,  0.621485f,  0.621560f,  0.621636f,  0.621711f,  0.621786f,
	 0.621861f,  0.621936f,  0.622011f,  0.622086f,  0.622161f,  0.622236f,  0.622311f,  0.622386f,
	 0.622461f,  0.622536f,  0.622611f,  0.622686f,  0.622761f,  0.622836f,  0.622911f,  0.622986f,
	 0.623061f,  0.623136f,  0.623211f,  0.623286f,  0.623361f,  0.623436f,  0.623511f,  0.623586f,
	 0.623661f,  0.623736f,  0.623811f,  0.623886f,  0.623961f,  0.624036f,  0.624111f,  0.624186f,
	 0.624260f,  0.624335f,  0.624410f,  0.624485f,  0.624560f,  0.624635f,  0.624710f,  0.624785f,
	 0.624860f,  0.624934f,  0.625009f,  0.625084f,  0.625159f,  0.625234f,  0.625309f,  0.625383f,
	 0.625458f,  0.625533f,  0.625608f,  0.625683f,  0.625757f,  0.625832f,  0.625907f,  0.625982f,
	 0.626056f,  0.626131f,  0.626206f,  0.626281f,  0.626355f,  0.626430f,  0.626505f,  0.626580f,
	 0.626654f,  0.626729f,  0.626804f,  0.626878f,  0.626953f,  0.627028f,  0.627102f,  0.627177f,
	 0.627252f,  0.627326f,  0.627401f,  0.627476f,  0.627550f,  0.627625f,  0.627700f,  0.627774f,
	 0.627849f,  0.627924f,  0.627998f,  0.628073f,  0.628147f,  0.628222f,  0.628297f,  0.628371f,
	 0.628446f,  0.628520f,  0.628595f,  0.628669f,  0.628744f,  0.628819f,  0.628893f,  0.628968f,
	 0.629042f,  0.629117f,  0.629191f,  0.629266f,  0.629340f,  0.629415f,  0.629489f,  0.629564f,
	 0.629638f,  0.629713f,  0.629787f,  0.629862f,  0.629936f,  0.630011f,  0.630085f,  0.630159f,
	 0.630234f,  0.630308f,  0.630383f,  0.630457f,  0.630532f,  0.630606f,  0.630680f,  0.630755f,
	 0.630829f,  0.630904f,  0.630978f,  0.631052f,  0.631127f,  0.631201f,  0.631275f,  0.631350f,
	 0.631424f,  0.631499f,  0.631573f,  0.631647f,  0.631721f,  0.631796f,  0.631870f,  0.631944f,
	 0.632019f,  0.632093f,  0.632167f,  0.632242f,  0.632316f,  0.632390f,  0.632464f,  0.632539f,
	 0.632613f,  0.632687f,  0.632761f,  0.632836f,  0.632910f,  0.632984f,  0.633058f,  0.633133f,
	 0.633207f,  0.633281f,  0.633355f,  0.633429f,  0.633504f,  0.633578f,  0.633652f,  0.633726f,
	 0.633800f,  0.633874f,  0.633949f,  0.634023f,  0.634097f,  0.634171f,  0.634245f,  0.634319f,
	 0.634393f,  0.634467f,  0.634542f,  0.634616f,  0.634690f,  0.634764f,  0.634838f,  0.634912f,
	 0.634986f,  0.635060f,  0.635134f,  0.635208f,  0.635282f,  0.635356f,  0.635430f,  0.635504f,
	 0.635578f,  0.635652f,  0.635726f,  0.635800f,  0.635874f,  0.635948f,  0.636022f,  0.636096f,
	 0.636170f,  0.636244f,  0.636318f,  0.636392f,  0.636466f,  0.636540f,  0.636614f,  0.636688f,
	 0.636762f,  0.636836f,  0.636910f,  0.636984f,  0.637057f,  0.637131f,  0.637205f,  0.637279f,
	 0.637353f,  0.637427f,  0.637501f,  0.637575f,  0.637649f,  0.637722f,  0.637796f,  0.637870f,
	 0.637944f,  0.638018f,  0.638092f,  0.638165f,  0.638239f,  0.638313f,  0.638387f,  0.638461f,
	 0.638534f,  0.638608f,  0.638682f,  0.638756f,  0.638829f,  0.638903f,  0.638977f,  0.639051f,
	 0.639124f,  0.639198f,  0.639272f,  0.639346f,  0.639419f,  0.639493f,  0.639567f,  0.639640f,
	 0.639714f,  0.639788f,  0.639862f,  0.639935f,  0.640009f,  0.640083f,  0.640156f,  0.640230f,
	 0.640303f,  0.640377f,  0.640451f,  0.640524f,  0.640598f,  0.640672f,  0.640745f,  0.640819f,
	 0.640892f,  0.640966f,  0.641040f,  0.641113f,  0.641187f,  0.641260f,  0.641334f,  0.641407f,
	 0.641481f,  0.641555f,  0.641628f,  0.641702f,  0.641775f,  0.641849f,  0.641922f,  0.641996f,
	 0.642069f,  0.642143f,  0.642216f,  0.642290f,  0.642363f,  0.642437f,  0.642510f,  0.642584f,
	 0.642657f,  0.642730f,  0.642804f,  0.642877f,  0.642951f,  0.643024f,  0.643098f,  0.643171f,
	 0.643245f,  0.643318f,  0.643391f,  0.643465f,  0.643538f,  0.643611f,  0.643685f,  0.643758f,
	 0.643832f,  0.643905f,  0.643978f,  0.644052f,  0.644125f,  0.644198f,  0.644272f,  0.644345f,
	 0.644418f,  0.644492f,  0.644565f,  0.644638f,  0.644711f,  0.644785f,  0.644858f,  0.644931f,
	 0.645005f,  0.645078f,  0.645151f,  0.645224f,  0.645298f,  0.645371f,  0.645444f,  0.645517f,
	 0.645590f,  0.645664f,  0.645737f,  0.645810f,  0.645883f,  0.645956f,  0.646030f,  0.646103f,
	 0.646176f,  0.646249f,  0.646322f,  0.646396f,  0.646469f,  0.646542f,  0.646615f,  0.646688f,
	 0.646761f,  0.646834f,  0.646907f,  0.646981f,  0.647054f,  0.647127f,  0.647200f,  0.647273f,
	 0.647346f,  0.647419f,  0.647492f,  0.647565f,  0.647638f,  0.647711f,  0.647784f,  0.647857f,
	 0.647930f,  0.648003f,  0.648076f,  0.648149f,  0.648222f,  0.648295f,  0.648368f,  0.648441f,
	 0.648514f,  0.648587f,  0.648660f,  0.648733f,  0.648806f,  0.648879f,  0.648952f,  0.649025f,
	 0.649098f,  0.649171f,  0.649244f,  0.649317f,  0.649390f,  0.649463f,  0.649536f,  0.649608f,
	 0.649681f,  0.649754f,  0.649827f,  0.649900f,  0.649973f,  0.650046f,  0.650119f,  0.650191f,
	 0.650264f,  0.650337f,  0.650410f,  0.650483f,  0.650555f,  0.650628f,  0.650701f,  0.650774f,
	 0.650847f,  0.650919f,  0.650992f,  0.651065f,  0.651138f,  0.651211f,  0.651283f,  0.651356f,
	 0.651429f,  0.651502f,  0.651574f,  0.651647f,  0.651720f,  0.651792f,  0.651865f,  0.651938f,
	 0.652011f,  0.652083f,  0.652156f,  0.652229f,  0.652301f,  0.652374f,  0.652447f,  0.652519f,
	 0.652592f,  0.652665f,  0.652737f,  0.652810f,  0.652882f,  0.652955f,  0.653028f,  0.653100f,
	 0.653173f,  0.653245f,  0.653318f,  0.653391f,  0.653463f,  0.653536f,  0.653608f,  0.653681f,
	 0.653753f,  0.653826f,  0.653899f,  0.653971f,  0.654044f,  0.654116f,  0.654189f,  0.654261f,
	 0.654334f,  0.654406f,  0.654479f,  0.654551f,  0.654624f,  0.654696f,  0.654769f,  0.654841f,
	 0.654913f,  0.654986f,  0.655058f,  0.655131f,  0.655203f,  0.655276f,  0.655348f,  0.655420f,
	 0.655493f,  0.655565f,  0.655638f,  0.655710f,  0.655782f,  0.655855f,  0.655927f,  0.656000f,
	 0.656072f,  0.656144f,  0.656217f,  0.656289f,  0.656361f,  0.656434f,  0.656506f,  0.656578f,
	 0.656651f,  0.656723f,  0.656795f,  0.656867f,  0.656940f,  0.657012f,  0.657084f,  0.657157f,
	 0.657229f,  0.657301f,  0.657373f,  0.657446f,  0.657518f,  0.657590f,  0.657662f,  0.657734f,
	 0.657807f,  0.657879f,  0.657951f,  0.658023f,  0.658095f,  0.658168f,  0.658240f,  0.658312f,
	 0.658384f,  0.658456f,  0.658529f,  0.658601f,  0.658673f,  0.658745f,  0.658817f,  0.658889f,
	 0.658961f,  0.659033f,  0.659105f,  0.659178f,  0.659250f,  0.659322f,  0.659394f,  0.659466f,
	 0.659538f,  0.659610f,  0.659682f,  0.659754f,  0.659826f,  0.659898f,  0.659970f,  0.660042f,
	 0.660114f,  0.660186f,  0.660258f,  0.660330f,  0.660402f,  0.660474f,  0.660546f,  0.660618f,
	 0.660690f,  0.660762f,  0.660834f,  0.660906f,  0.660978f,  0.661050f,  0.661122f,  0.661194f,
	 0.661266f,  0.661338f,  0.661410f,  0.661482f,  0.661553f,  0.661625f,  0.661697f,  0.661769f,
	 0.661841f,  0.661913f,  0.661985f,  0.662057f,  0.662128f,  0.662200f,  0.662272f,  0.662344f,
	 0.662416f,  0.662488f,  0.662559f,  0.662631f,  0.662703f,  0.662775f,  0.662847f,  0.662918f,
	 0.662990f,  0.663062f,  0.663134f,  0.663205f,  0.663277f,  0.663349f,  0.663421f,  0.663492f,
	 0.663564f,  0.663636f,  0.663708f,  0.663779f,  0.663851f,  0.663923f,  0.663994f,  0.664066f,
	 0.664138f,  0.664209f,  0.664281f,  0.664353f,  0.664424f,  0.664496f,  0.664568f,  0.664639f,
	 0.664711f,  0.664783f,  0.664854f,  0.664926f,  0.664997f,  0.665069f,  0.665141f,  0.665212f,
	 0.665284f,  0.665355f,  0.665427f,  0.665498f,  0.665570f,  0.665642f,  0.665713f,  0.665785f,
	 0.665856f,  0.665928f,  0.665999f,  0.666071f,  0.666142f,  0.666214f,  0.666285f,  0.666357f,
	 0.666428f,  0.666500f,  0.666571f,  0.666643f,  0.666714f,  0.666786f,  0.666857f,  0.666928f,
	 0.667000f,  0.667071f,  0.667143f,  0.667214f,  0.667286f,  0.667357f,  0.667428f,  0.667500f,
	 0.667571f,  0.667643f,  0.667714f,  0.667785f,  0.667857f,  0.667928f,  0.667999f,  0.668071f,
	 0.668142f,  0.668213f,  0.668285f,  0.668356f,  0.668427f,  0.668499f,  0.668570f,  0.668641f,
	 0.668712f,  0.668784f,  0.668855f,  0.668926f,  0.668998f,  0.669069f,  0.669140f,  0.669211f,
	 0.669283f,  0.669354f,  0.669425f,  0.669496f,  0.669567f,  0.669639f,  0.669710f,  0.669781f,
	 0.669852f,  0.669923f,  0.669995f,  0.670066f,  0.670137f,  0.670208f,  0.670279f,  0.670350f,
	 0.670422f,  0.670493f,  0.670564f,  0.670635f,  0.670706f,  0.670777f,  0.670848f,  0.670919f,
	 0.670990f,  0.671062f,  0.671133f,  0.671204f,  0.671275f,  0.671346f,  0.671417f,  0.671488f,
	 0.671559f,  0.671630f,  0.671701f,  0.671772f,  0.671843f,  0.671914f,  0.671985f,  0.672056f,
	 0.672127f,  0.672198f,  0.672269f,  0.672340f,  0.672411f,  0.672482f,  0.672553f,  0.672624f,
	 0.672695f,  0.672766f,  0.672837f,  0.672908f,  0.672978f,  0.673049f,  0.673120f,  0.673191f,
	 0.673262f,  0.673333f,  0.673404f,  0.673475f,  0.673546f,  0.673616f,  0.673687f,  0.673758f,
	 0.673829f,  0.673900f,  0.673971f,  0.674042f,  0.674112f,  0.674183f,  0.674254f,  0.674325f,
	 0.674396f,  0.674466f,  0.674537f,  0.674608f,  0.674679f,  0.674749f,  0.674820f,  0.674891f,
	 0.674962f,  0.675032f,  0.675103f,  0.675174f,  0.675245f,  0.675315f,  0.675386f,  0.675457f,
	 0.675527f,  0.675598f,  0.675669f,  0.675739f,  0.675810f,  0.675881f,  0.675951f,  0.676022f,
	 0.676093f,  0.676163f,  0.676234f,  0.676305f,  0.676375f,  0.676446f,  0.676516f,  0.676587f,
	 0.676658f,  0.676728f,  0.676799f,  0.676869f,  0.676940f,  0.677011f,  0.677081f,  0.677152f,
	 0.677222f,  0.677293f,  0.677363f,  0.677434f,  0.677504f,  0.677575f,  0.677645f,  0.677716f,
	 0.677786f,  0.677857f,  0.677927f,  0.677998f,  0.678068f,  0.678139f,  0.678209f,  0.678280f,
	 0.678350f,  0.678420f,  0.678491f,  0.678561f,  0.678632f,  0.678702f,  0.678773f,  0.678843f,
	 0.678913f,  0.678984f,  0.679054f,  0.679125f,  0.679195f,  0.679265f,  0.679336f,  0.679406f,
	 0.679476f,  0.679547f,  0.679617f,  0.679687f,  0.679758f,  0.679828f,  0.679898f,  0.679969f,
	 0.680039f,  0.680109f,  0.680179f,  0.680250f,  0.680320f,  0.680390f,  0.680461f,  0.680531f,
	 0.680601f,  0.680671f,  0.680741f,  0.680812f,  0.680882f,  0.680952f,  0.681022f,  0.681093f,
	 0.681163f,  0.681233f,  0.681303f,  0.681373f,  0.681443f,  0.681514f,  0.681584f,  0.681654f,
	 0.681724f,  0.681794f,  0.681864f,  0.681934f,  0.682005f,  0.682075f,  0.682145f,  0.682215f,
	 0.682285f,  0.682355f,  0.682425f,  0.682495f,  0.682565f,  0.682635f,  0.682705f,  0.682775f,
	 0.682846f,  0.682916f,  0.682986f,  0.683056f,  0.683126f,  0.683196f,  0.683266f,  0.683336f,
	 0.683406f,  0.683476f,  0.683546f,  0.683616f,  0.683686f,  0.683756f,  0.683825f,  0.683895f,
	 0.683965f,  0.684035f,  0.684105f,  0.684175f,  0.684245f,  0.684315f,  0.684385f,  0.684455f,
	 0.684525f,  0.684595f,  0.684664f,  0.684734f,  0.684804f,  0.684874f,  0.684944f,  0.685014f,
	 0.685084f,  0.685153f,  0.685223f,  0.685293f,  0.685363f,  0.685433f,  0.685503f,  0.685572f,
	 0.685642f,  0.685712f,  0.685782f,  0.685852f,  0.685921f,  0.685991f,  0.686061f,  0.686131f,
	 0.686200f,  0.686270f,  0.686340f,  0.686409f,  0.686479f,  0.686549f,  0.686619f,  0.686688f,
	 0.686758f,  0.686828f,  0.686897f,  0.686967f,  0.687037f,  0.687106f,  0.687176f,  0.687246f,
	 0.687315f,  0.687385f,  0.687455f,  0.687524f,  0.687594f,  0.687663f,  0.687733f,  0.687803f,
	 0.687872f,  0.687942f,  0.688011f,  0.688081f,  0.688151f,  0.688220f,  0.688290f,  0.688359f,
	 0.688429f,  0.688498f,  0.688568f,  0.688637f,  0.688707f,  0.688776f,  0.688846f,  0.688915f,
	 0.688985f,  0.689054f,  0.689124f,  0.689193f,  0.689263f,  0.689332f,  0.689402f,  0.689471f,
	 0.689541f,  0.689610f,  0.689679f,  0.689749f,  0.689818f,  0.689888f,  0.689957f,  0.690026f,
	 0.690096f,  0.690165f,  0.690235f,  0.690304f,  0.690373f,  0.690443f,  0.690512f,  0.690581f,
	 0.690651f,  0.690720f,  0.690789f,  0.690859f,  0.690928f,  0.690997f,  0.691067f,  0.691136f,
	 0.691205f,  0.691274f,  0.691344f,  0.691413f,  0.691482f,  0.691552f,  0.691621f,  0.691690f,
	 0.691759f,  0.691828f,  0.691898f,  0.691967f,  0.692036f,  0.692105f,  0.692175f,  0.692244f,
	 0.692313f,  0.692382f,  0.692451f,  0.692520f,  0.692590f,  0.692659f,  0.692728f,  0.692797f,
	 0.692866f,  0.692935f,  0.693004f,  0.693074f,  0.693143f,  0.693212f,  0.693281f,  0.693350f,
	 0.693419f,  0.693488f,  0.693557f,  0.693626f,  0.693695f,  0.693764f,  0.693833f,  0.693902f,
	 0.693971f,  0.694040f,  0.694109f,  0.694179f,  0.694248f,  0.694317f,  0.694386f,  0.694454f,
	 0.694524f,  0.694592f,  0.694661f,  0.694730f,  0.694799f,  0.694868f,  0.694937f,  0.695006f,
	 0.695075f,  0.695144f,  0.695213f,  0.695282f,  0.695351f,  0.695420f,  0.695489f,  0.695557f,
	 0.695626f,  0.695695f,  0.695764f,  0.695833f,  0.695902f,  0.695971f,  0.696039f,  0.696108f,
	 0.696177f,  0.696246f,  0.696315f,  0.696384f,  0.696452f,  0.696521f,  0.696590f,  0.696659f,
	 0.696728f,  0.696796f,  0.696865f,  0.696934f,  0.697003f,  0.697071f,  0.697140f,  0.697209f,
	 0.697277f,  0.697346f,  0.697415f,  0.697484f,  0.697552f,  0.697621f,  0.697690f,  0.697758f,
	 0.697827f,  0.697896f,  0.697964f,  0.698033f,  0.698102f,  0.698170f,  0.698239f,  0.698308f,
	 0.698376f,  0.698445f,  0.698513f,  0.698582f,  0.698651f,  0.698719f,  0.698788f,  0.698856f,
	 0.698925f,  0.698994f,  0.699062f,  0.699131f,  0.699199f,  0.699268f,  0.699336f,  0.699405f,
	 0.699473f,  0.699542f,  0.699610f,  0.699679f,  0.699747f,  0.699816f,  0.699884f,  0.699953f,
	 0.700021f,  0.700090f,  0.700158f,  0.700227f,  0.700295f,  0.700364f,  0.700432f,  0.700500f,
	 0.700569f,  0.700637f,  0.700706f,  0.700774f,  0.700842f,  0.700911f,  0.700979f,  0.701048f,
	 0.701116f,  0.701184f,  0.701253f,  0.701321f,  0.701389f,  0.701458f,  0.701526f,  0.701594f,
	 0.701663f,  0.701731f,  0.701799f,  0.701868f,  0.701936f,  0.702004f,  0.702072f,  0.702141f,
	 0.702209f,  0.702277f,  0.702345f,  0.702414f,  0.702482f,  0.702550f,  0.702618f,  0.702687f,
	 0.702755f,  0.702823f,  0.702891f,  0.702959f,  0.703028f,  0.703096f,  0.703164f,  0.703232f,
	 0.703300f,  0.703368f,  0.703436f,  0.703505f,  0.703573f,  0.703641f,  0.703709f,  0.703777f,
	 0.703845f,  0.703913f,  0.703981f,  0.704050f,  0.704118f,  0.704186f,  0.704254f,  0.704322f,
	 0.704390f,  0.704458f,  0.704526f,  0.704594f,  0.704662f,  0.704730f,  0.704798f,  0.704866f,
	 0.704934f,  0.705002f,  0.705070f,  0.705138f,  0.705206f,  0.705274f,  0.705342f,  0.705410f,
	 0.705478f,  0.705546f,  0.705614f,  0.705682f,  0.705750f,  0.705818f,  0.705885f,  0.705953f,
	 0.706021f,  0.706089f,  0.706157f,  0.706225f,  0.706293f,  0.706361f,  0.706429f,  0.706496f,
	 0.706564f,  0.706632f,  0.706700f,  0.706768f,  0.706836f,  0.706903f,  0.706971f,  0.707039f,
	 0.707107f,  0.707175f,  0.707242f,  0.707310f,  0.707378f,  0.707446f,  0.707513f,  0.707581f,
	 0.707649f,  0.707717f,  0.707784f,  0.707852f,  0.707920f,  0.707988f,  0.708055f,  0.708123f,
	 0.708191f,  0.708258f,  0.708326f,  0.708394f,  0.708461f,  0.708529f,  0.708597f,  0.708664f,
	 0.708732f,  0.708800f,  0.708867f,  0.708935f,  0.709002f,  0.709070f,  0.709138f,  0.709205f,
	 0.709273f,  0.709340f,  0.709408f,  0.709476f,  0.709543f,  0.709611f,  0.709678f,  0.709746f,
	 0.709813f,  0.709881f,  0.709948f,  0.710016f,  0.710083f,  0.710151f,  0.710218f,  0.710286f,
	 0.710353f,  0.710421f,  0.710488f,  0.710556f,  0.710623f,  0.710691f,  0.710758f,  0.710826f,
	 0.710893f,  0.710960f,  0.711028f,  0.711095f,  0.711163f,  0.711230f,  0.711297f,  0.711365f,
	 0.711432f,  0.711500f,  0.711567f,  0.711634f,  0.711702f,  0.711769f,  0.711836f,  0.711904f,
	 0.711971f,  0.712038f,  0.712106f,  0.712173f,  0.712240f,  0.712308f,  0.712375f,  0.712442f,
	 0.712509f,  0.712577f,  0.712644f,  0.712711f,  0.712778f,  0.712846f,  0.712913f,  0.712980f,
	 0.713047f,  0.713115f,  0.713182f,  0.713249f,  0.713316f,  0.713383f,  0.713451f,  0.713518f,
	 0.713585f,  0.713652f,  0.713719f,  0.713786f,  0.713853f,  0.713921f,  0.713988f,  0.714055f,
	 0.714122f,  0.714189f,  0.714256f,  0.714323f,  0.714390f,  0.714457f,  0.714525f,  0.714592f,
	 0.714659f,  0.714726f,  0.714793f,  0.714860f,  0.714927f,  0.714994f,  0.715061f,  0.715128f,
	 0.715195f,  0.715262f,  0.715329f,  0.715396f,  0.715463f,  0.715530f,  0.715597f,  0.715664f,
	 0.715731f,  0.715798f,  0.715865f,  0.715932f,  0.715999f,  0.716066f,  0.716132f,  0.716199f,
	 0.716266f,  0.716333f,  0.716400f,  0.716467f,  0.716534f,  0.716601f,  0.716668f,  0.716734f,
	 0.716801f,  0.716868f,  0.716935f,  0.717002f,  0.717069f,  0.717135f,  0.717202f,  0.717269f,
	 0.717336f,  0.717403f,  0.717469f,  0.717536f,  0.717603f,  0.717670f,  0.717737f,  0.717803f,
	 0.717870f,  0.717937f,  0.718004f,  0.718070f,  0.718137f,  0.718204f,  0.718270f,  0.718337f,
	 0.718404f,  0.718471f,  0.718537f,  0.718604f,  0.718670f,  0.718737f,  0.718804f,  0.718870f,
	 0.718937f,  0.719004f,  0.719070f,  0.719137f,  0.719204f,  0.719270f,  0.719337f,  0.719403f,
	 0.719470f,  0.719537f,  0.719603f,  0.719670f,  0.719736f,  0.719803f,  0.719869f,  0.719936f,
	 0.720003f,  0.720069f,  0.720136f,  0.720202f,  0.720269f,  0.720335f,  0.720402f,  0.720468f,
	 0.720535f,  0.720601f,  0.720668f,  0.720734f,  0.720800f,  0.720867f,  0.720933f,  0.721000f,
	 0.721066f,  0.721133f,  0.721199f,  0.721265f,  0.721332f,  0.721398f,  0.721465f,  0.721531f,
	 0.721597f,  0.721664f,  0.721730f,  0.721797f,  0.721863f,  0.721929f,  0.721996f,  0.722062f,
	 0.722128f,  0.722194f,  0.722261f,  0.722327f,  0.722393f,  0.722460f,  0.722526f,  0.722592f,
	 0.722659f,  0.722725f,  0.722791f,  0.722857f,  0.722924f,  0.722990f,  0.723056f,  0.723122f,
	 0.723188f,  0.723255f,  0.723321f,  0.723387f,  0.723453f,  0.723520f,  0.723586f,  0.723652f,
	 0.723718f,  0.723784f,  0.723850f,  0.723916f,  0.723983f,  0.724049f,  0.724115f,  0.724181f,
	 0.724247f,  0.724313f,  0.724379f,  0.724445f,  0.724511f,  0.724578f,  0.724644f,  0.724710f,
	 0.724776f,  0.724842f,  0.724908f,  0.724974f,  0.725040f,  0.725106f,  0.725172f,  0.725238f,
	 0.725304f,  0.725370f,  0.725436f,  0.725502f,  0.725568f,  0.725634f,  0.725700f,  0.725766f,
	 0.725832f,  0.725898f,  0.725964f,  0.726030f,  0.726095f,  0.726161f,  0.726227f,  0.726293f,
	 0.726359f,  0.726425f,  0.726491f,  0.726557f,  0.726623f,  0.726689f,  0.726754f,  0.726820f,
	 0.726886f,  0.726952f,  0.727018f,  0.727084f,  0.727149f,  0.727215f,  0.727281f,  0.727347f,
	 0.727413f,  0.727478f,  0.727544f,  0.727610f,  0.727676f,  0.727741f,  0.727807f,  0.727873f,
	 0.727939f,  0.728004f,  0.728070f,  0.728136f,  0.728202f,  0.728267f,  0.728333f,  0.728399f,
	 0.728464f,  0.728530f,  0.728596f,  0.728661f,  0.728727f,  0.728793f,  0.728858f,  0.728924f,
	 0.728990f,  0.729055f,  0.729121f,  0.729186f,  0.729252f,  0.729318f,  0.729383f,  0.729449f,
	 0.729514f,  0.729580f,  0.729646f,  0.729711f,  0.729777f,  0.729842f,  0.729908f,  0.729973f,
	 0.730039f,  0.730104f,  0.730170f,  0.730235f,  0.730301f,  0.730366f,  0.730432f,  0.730497f,
	 0.730563f,  0.730628f,  0.730694f,  0.730759f,  0.730825f,  0.730890f,  0.730955f,  0.731021f,
	 0.731086f,  0.731152f,  0.731217f,  0.731282f,  0.731348f,  0.731413f,  0.731479f,  0.731544f,
	 0.731609f,  0.731675f,  0.731740f,  0.731805f,  0.731871f,  0.731936f,  0.732001f,  0.732067f,
	 0.732132f,  0.732197f,  0.732263f,  0.732328f,  0.732393f,  0.732458f,  0.732524f,  0.732589f,
	 0.732654f,  0.732720f,  0.732785f,  0.732850f,  0.732915f,  0.732980f,  0.733046f,  0.733111f,
	 0.733176f,  0.733241f,  0.733306f,  0.733372f,  0.733437f,  0.733502f,  0.733567f,  0.733632f,
	 0.733697f,  0.733763f,  0.733828f,  0.733893f,  0.733958f,  0.734023f,  0.734088f,  0.734153f,
	 0.734218f,  0.734283f,  0.734349f,  0.734414f,  0.734479f,  0.734544f,  0.734609f,  0.734674f,
	 0.734739f,  0.734804f,  0.734869f,  0.734934f,  0.734999f,  0.735064f,  0.735129f,  0.735194f,
	 0.735259f,  0.735324f,  0.735389f,  0.735454f,  0.735519f,  0.735584f,  0.735649f,  0.735714f,
	 0.735779f,  0.735844f,  0.735908f,  0.735973f,  0.736038f,  0.736103f,  0.736168f,  0.736233f,
	 0.736298f,  0.736363f,  0.736428f,  0.736492f,  0.736557f,  0.736622f,  0.736687f,  0.736752f,
	 0.736817f,  0.736881f,  0.736946f,  0.737011f,  0.737076f,  0.737141f,  0.737205f,  0.737270f,
	 0.737335f,  0.737400f,  0.737464f,  0.737529f,  0.737594f,  0.737659f,  0.737723f,  0.737788f,
	 0.737853f,  0.737918f,  0.737982f,  0.738047f,  0.738112f,  0.738176f,  0.738241f,  0.738306f,
	 0.738370f,  0.738435f,  0.738500f,  0.738564f,  0.738629f,  0.738693f,  0.738758f,  0.738823f,
	 0.738887f,  0.738952f,  0.739017f,  0.739081f,  0.739146f,  0.739210f,  0.739275f,  0.739339f,
	 0.739404f,  0.739468f,  0.739533f,  0.739598f,  0.739662f,  0.739727f,  0.739791f,  0.739856f,
	 0.739920f,  0.739985f,  0.740049f,  0.740114f,  0.740178f,  0.740242f,  0.740307f,  0.740371f,
	 0.740436f,  0.740500f,  0.740565f,  0.740629f,  0.740694f,  0.740758f,  0.740822f,  0.740887f,
	 0.740951f,  0.741015f,  0.741080f,  0.741144f,  0.741209f,  0.741273f,  0.741337f,  0.741402f,
	 0.741466f,  0.741530f,  0.741595f,  0.741659f,  0.741723f,  0.741788f,  0.741852f,  0.741916f,
	 0.741980f,  0.742045f,  0.742109f,  0.742173f,  0.742237f,  0.742302f,  0.742366f,  0.742430f,
	 0.742494f,  0.742559f,  0.742623f,  0.742687f,  0.742751f,  0.742815f,  0.742880f,  0.742944f,
	 0.743008f,  0.743072f,  0.743136f,  0.743200f,  0.743265f,  0.743329f,  0.743393f,  0.743457f,
	 0.743521f,  0.743585f,  0.743649f,  0.743713f,  0.743777f,  0.743842f,  0.743906f,  0.743970f,
	 0.744034f,  0.744098f,  0.744162f,  0.744226f,  0.744290f,  0.744354f,  0.744418f,  0.744482f,
	 0.744546f,  0.744610f,  0.744674f,  0.744738f,  0.744802f,  0.744866f,  0.744930f,  0.744994f,
	 0.745058f,  0.745122f,  0.745186f,  0.745250f,  0.745314f,  0.745377f,  0.745441f,  0.745505f,
	 0.745569f,  0.745633f,  0.745697f,  0.745761f,  0.745825f,  0.745889f,  0.745952f,  0.746016f,
	 0.746080f,  0.746144f,  0.746208f,  0.746272f,  0.746335f,  0.746399f,  0.746463f,  0.746527f,
	 0.746591f,  0.746654f,  0.746718f,  0.746782f,  0.746846f,  0.746909f,  0.746973f,  0.747037f,
	 0.747101f,  0.747164f,  0.747228f,  0.747292f,  0.747355f,  0.747419f,  0.747483f,  0.747547f,
	 0.747610f,  0.747674f,  0.747738f,  0.747801f,  0.747865f,  0.747929f,  0.747992f,  0.748056f,
	 0.748119f,  0.748183f,  0.748247f,  0.748310f,  0.748374f,  0.748437f,  0.748501f,  0.748565f,
	 0.748628f,  0.748692f,  0.748755f,  0.748819f,  0.748882f,  0.748946f,  0.749009f,  0.749073f,
	 0.749136f,  0.749200f,  0.749263f,  0.749327f,  0.749390f,  0.749454f,  0.749517f,  0.749581f,
	 0.749644f,  0.749708f,  0.749771f,  0.749835f,  0.749898f,  0.749961f,  0.750025f,  0.750088f,
	 0.750152f,  0.750215f,  0.750278f,  0.750342f,  0.750405f,  0.750469f,  0.750532f,  0.750595f,
	 0.750659f,  0.750722f,  0.750785f,  0.750849f,  0.750912f,  0.750975f,  0.751039f,  0.751102f,
	 0.751165f,  0.751228f,  0.751292f,  0.751355f,  0.751418f,  0.751481f,  0.751545f,  0.751608f,
	 0.751671f,  0.751734f,  0.751798f,  0.751861f,  0.751924f,  0.751987f,  0.752050f,  0.752114f,
	 0.752177f,  0.752240f,  0.752303f,  0.752366f,  0.752429f,  0.752493f,  0.752556f,  0.752619f,
	 0.752682f,  0.752745f,  0.752808f,  0.752871f,  0.752934f,  0.752998f,  0.753061f,  0.753124f,
	 0.753187f,  0.753250f,  0.753313f,  0.753376f,  0.753439f,  0.753502f,  0.753565f,  0.753628f,
	 0.753691f,  0.753754f,  0.753817f,  0.753880f,  0.753943f,  0.754006f,  0.754069f,  0.754132f,
	 0.754195f,  0.754258f,  0.754321f,  0.754384f,  0.754447f,  0.754510f,  0.754573f,  0.754636f,
	 0.754698f,  0.754761f,  0.754824f,  0.754887f,  0.754950f,  0.755013f,  0.755076f,  0.755139f,
	 0.755201f,  0.755264f,  0.755327f,  0.755390f,  0.755453f,  0.755516f,  0.755578f,  0.755641f,
	 0.755704f,  0.755767f,  0.755829f,  0.755892f,  0.755955f,  0.756018f,  0.756081f,  0.756143f,
	 0.756206f,  0.756269f,  0.756331f,  0.756394f,  0.756457f,  0.756520f,  0.756582f,  0.756645f,
	 0.756708f,  0.756770f,  0.756833f,  0.756896f,  0.756958f,  0.757021f,  0.757084f,  0.757146f,
	 0.757209f,  0.757271f,  0.757334f,  0.757397f,  0.757459f,  0.757522f,  0.757584f,  0.757647f,
	 0.757710f,  0.757772f,  0.757835f,  0.757897f,  0.757960f,  0.758022f,  0.758085f,  0.758147f,
	 0.758210f,  0.758272f,  0.758335f,  0.758397f,  0.758460f,  0.758522f,  0.758585f,  0.758647f,
	 0.758710f,  0.758772f,  0.758835f,  0.758897f,  0.758960f,  0.759022f,  0.759084f,  0.759147f,
	 0.759209f,  0.759272f,  0.759334f,  0.759396f,  0.759459f,  0.759521f,  0.759583f,  0.759646f,
	 0.759708f,  0.759771f,  0.759833f,  0.759895f,  0.759957f,  0.760020f,  0.760082f,  0.760144f,
	 0.760207f,  0.760269f,  0.760331f,  0.760394f,  0.760456f,  0.760518f,  0.760580f,  0.760643f,
	 0.760705f,  0.760767f,  0.760829f,  0.760891f,  0.760954f,  0.761016f,  0.761078f,  0.761140f,
	 0.761202f,  0.761265f,  0.761327f,  0.761389f,  0.761451f,  0.761513f,  0.761575f,  0.761637f,
	 0.761700f,  0.761762f,  0.761824f,  0.761886f,  0.761948f,  0.762010f,  0.762072f,  0.762134f,
	 0.762196f,  0.762258f,  0.762320f,  0.762382f,  0.762444f,  0.762507f,  0.762569f,  0.762631f,
	 0.762693f,  0.762755f,  0.762817f,  0.762879f,  0.762941f,  0.763003f,  0.763065f,  0.763126f,
	 0.763188f,  0.763250f,  0.763312f,  0.763374f,  0.763436f,  0.763498f,  0.763560f,  0.763622f,
	 0.763684f,  0.763746f,  0.763808f,  0.763869f,  0.763931f,  0.763993f,  0.764055f,  0.764117f,
	 0.764179f,  0.764241f,  0.764302f,  0.764364f,  0.764426f,  0.764488f,  0.764550f,  0.764611f,
	 0.764673f,  0.764735f,  0.764797f,  0.764859f,  0.764920f,  0.764982f,  0.765044f,  0.765106f,
	 0.765167f,  0.765229f,  0.765291f,  0.765352f,  0.765414f,  0.765476f,  0.765538f,  0.765599f,
	 0.765661f,  0.765723f,  0.765784f,  0.765846f,  0.765907f,  0.765969f,  0.766031f,  0.766092f,
	 0.766154f,  0.766216f,  0.766277f,  0.766339f,  0.766400f,  0.766462f,  0.766524f,  0.766585f,
	 0.766647f,  0.766708f,  0.766770f,  0.766831f,  0.766893f,  0.766954f,  0.767016f,  0.767077f,
	 0.767139f,  0.767200f,  0.767262f,  0.767323f,  0.767385f,  0.767446f,  0.767508f,  0.767569f,
	 0.767631f,  0.767692f,  0.767754f,  0.767815f,  0.767876f,  0.767938f,  0.767999f,  0.768061f,
	 0.768122f,  0.768183f,  0.768245f,  0.768306f,  0.768368f,  0.768429f,  0.768490f,  0.768552f,
	 0.768613f,  0.768674f,  0.768736f,  0.768797f,  0.768858f,  0.768919f,  0.768981f,  0.769042f,
	 0.769103f,  0.769165f,  0.769226f,  0.769287f,  0.769348f,  0.769410f,  0.769471f,  0.769532f,
	 0.769593f,  0.769655f,  0.769716f,  0.769777f,  0.769838f,  0.769899f,  0.769961f,  0.770022f,
	 0.770083f,  0.770144f,  0.770205f,  0.770266f,  0.770327f,  0.770389f,  0.770450f,  0.770511f,
	 0.770572f,  0.770633f,  0.770694f,  0.770755f,  0.770816f,  0.770877f,  0.770938f,  0.770999f,
	 0.771061f,  0.771122f,  0.771183f,  0.771244f,  0.771305f,  0.771366f,  0.771427f,  0.771488f,
	 0.771549f,  0.771610f,  0.771671f,  0.771732f,  0.771793f,  0.771854f,  0.771915f,  0.771975f,
	 0.772036f,  0.772097f,  0.772158f,  0.772219f,  0.772280f,  0.772341f,  0.772402f,  0.772463f,
	 0.772524f,  0.772584f,  0.772645f,  0.772706f,  0.772767f,  0.772828f,  0.772889f,  0.772950f,
	 0.773010f,  0.773071f,  0.773132f,  0.773193f,  0.773254f,  0.773314f,  0.773375f,  0.773436f,
	 0.773497f,  0.773558f,  0.773618f,  0.773679f,  0.773740f,  0.773801f,  0.773861f,  0.773922f,
	 0.773983f,  0.774043f,  0.774104f,  0.774165f,  0.774225f,  0.774286f,  0.774347f,  0.774407f,
	 0.774468f,  0.774529f,  0.774589f,  0.774650f,  0.774711f,  0.774771f,  0.774832f,  0.774893f,
	 0.774953f,  0.775014f,  0.775074f,  0.775135f,  0.775195f,  0.775256f,  0.775317f,  0.775377f,
	 0.775438f,  0.775498f,  0.775559f,  0.775619f,  0.775680f,  0.775740f,  0.775801f,  0.775861f,
	 0.775922f,  0.775982f,  0.776043f,  0.776103f,  0.776164f,  0.776224f,  0.776284f,  0.776345f,
	 0.776405f,  0.776466f,  0.776526f,  0.776587f,  0.776647f,  0.776707f,  0.776768f,  0.776828f,
	 0.776888f,  0.776949f,  0.777009f,  0.777070f,  0.777130f,  0.777190f,  0.777251f,  0.777311f,
	 0.777371f,  0.777431f,  0.777492f,  0.777552f,  0.777612f,  0.777673f,  0.777733f,  0.777793f,
	 0.777853f,  0.777914f,  0.777974f,  0.778034f,  0.778094f,  0.778155f,  0.778215f,  0.778275f,
	 0.778335f,  0.778395f,  0.778456f,  0.778516f,  0.778576f,  0.778636f,  0.778696f,  0.778756f,
	 0.778817f,  0.778877f,  0.778937f,  0.778997f,  0.779057f,  0.779117f,  0.779177f,  0.779237f,
	 0.779297f,  0.779357f,  0.779418f,  0.779478f,  0.779538f,  0.779598f,  0.779658f,  0.779718f,
	 0.779778f,  0.779838f,  0.779898f,  0.779958f,  0.780018f,  0.780078f,  0.780138f,  0.780198f,
	 0.780258f,  0.780318f,  0.780378f,  0.780438f,  0.780498f,  0.780557f,  0.780617f,  0.780677f,
	 0.780737f,  0.780797f,  0.780857f,  0.780917f,  0.780977f,  0.781037f,  0.781097f,  0.781156f,
	 0.781216f,  0.781276f,  0.781336f,  0.781396f,  0.781456f,  0.781515f,  0.781575f,  0.781635f,
	 0.781695f,  0.781755f,  0.781814f,  0.781874f,  0.781934f,  0.781994f,  0.782053f,  0.782113f,
	 0.782173f,  0.782233f,  0.782292f,  0.782352f,  0.782412f,  0.782472f,  0.782531f,  0.782591f,
	 0.782651f,  0.782710f,  0.782770f,  0.782830f,  0.782889f,  0.782949f,  0.783009f,  0.783068f,
	 0.783128f,  0.783187f,  0.783247f,  0.783307f,  0.783366f,  0.783426f,  0.783485f,  0.783545f,
	 0.783605f,  0.783664f,  0.783724f,  0.783783f,  0.783843f,  0.783902f,  0.783962f,  0.784021f,
	 0.784081f,  0.784140f,  0.784200f,  0.784259f,  0.784319f,  0.784378f,  0.784438f,  0.784497f,
	 0.784557f,  0.784616f,  0.784675f,  0.784735f,  0.784794f,  0.784854f,  0.784913f,  0.784973f,
	 0.785032f,  0.785091f,  0.785151f,  0.785210f,  0.785269f,  0.785329f,  0.785388f,  0.785447f,
	 0.785507f,  0.785566f,  0.785625f,  0.785685f,  0.785744f,  0.785803f,  0.785863f,  0.785922f,
	 0.785981f,  0.786041f,  0.786100f,  0.786159f,  0.786218f,  0.786278f,  0.786337f,  0.786396f,
	 0.786455f,  0.786514f,  0.786574f,  0.786633f,  0.786692f,  0.786751f,  0.786810f,  0.786870f,
	 0.786929f,  0.786988f,  0.787047f,  0.787106f,  0.787165f,  0.787224f,  0.787284f,  0.787343f,
	 0.787402f,  0.787461f,  0.787520f,  0.787579f,  0.787638f,  0.787697f,  0.787756f,  0.787815f,
	 0.787874f,  0.787933f,  0.787992f,  0.788051f,  0.788110f,  0.788169f,  0.788228f,  0.788287f,
	 0.788346f,  0.788405f,  0.788464f,  0.788523f,  0.788582f,  0.788641f,  0.788700f,  0.788759f,
	 0.788818f,  0.788877f,  0.788936f,  0.788995f,  0.789054f,  0.789113f,  0.789172f,  0.789230f,
	 0.789289f,  0.789348f,  0.789407f,  0.789466f,  0.789525f,  0.789584f,  0.789642f,  0.789701f,
	 0.789760f,  0.789819f,  0.789878f,  0.789936f,  0.789995f,  0.790054f,  0.790113f,  0.790171f,
	 0.790230f,  0.790289f,  0.790348f,  0.790406f,  0.790465f,  0.790524f,  0.790583f,  0.790641f,
	 0.790700f,  0.790759f,  0.790817f,  0.790876f,  0.790935f,  0.790993f,  0.791052f,  0.791111f,
	 0.791169f,  0.791228f,  0.791287f,  0.791345f,  0.791404f,  0.791462f,  0.791521f,  0.791580f,
	 0.791638f,  0.791697f,  0.791755f,  0.791814f,  0.791872f,  0.791931f,  0.791990f,  0.792048f,
	 0.792107f,  0.792165f,  0.792224f,  0.792282f,  0.792341f,  0.792399f,  0.792458f,  0.792516f,
	 0.792575f,  0.792633f,  0.792691f,  0.792750f,  0.792808f,  0.792867f,  0.792925f,  0.792984f,
	 0.793042f,  0.793100f,  0.793159f,  0.793217f,  0.793276f,  0.793334f,  0.793392f,  0.793451f,
	 0.793509f,  0.793567f,  0.793626f,  0.793684f,  0.793742f,  0.793801f,  0.793859f,  0.793917f,
	 0.793975f,  0.794034f,  0.794092f,  0.794150f,  0.794209f,  0.794267f,  0.794325f,  0.794383f,
	 0.794442f,  0.794500f,  0.794558f,  0.794616f,  0.794674f,  0.794733f,  0.794791f,  0.794849f,
	 0.794907f,  0.794965f,  0.795023f,  0.795082f,  0.795140f,  0.795198f,  0.795256f,  0.795314f,
	 0.795372f,  0.795430f,  0.795488f,  0.795547f,  0.795605f,  0.795663f,  0.795721f,  0.795779f,
	 0.795837f,  0.795895f,  0.795953f,  0.796011f,  0.796069f,  0.796127f,  0.796185f,  0.796243f,
	 0.796301f,  0.796359f,  0.796417f,  0.796475f,  0.796533f,  0.796591f,  0.796649f,  0.796707f,
	 0.796765f,  0.796823f,  0.796881f,  0.796939f,  0.796996f,  0.797054f,  0.797112f,  0.797170f,
	 0.797228f,  0.797286f,  0.797344f,  0.797402f,  0.797459f,  0.797517f,  0.797575f,  0.797633f,
	 0.797691f,  0.797749f,  0.797806f,  0.797864f,  0.797922f,  0.797980f,  0.798038f,  0.798095f,
	 0.798153f,  0.798211f,  0.798269f,  0.798326f,  0.798384f,  0.798442f,  0.798500f,  0.798557f,
	 0.798615f,  0.798673f,  0.798730f,  0.798788f,  0.798846f,  0.798903f,  0.798961f,  0.799019f,
	 0.799076f,  0.799134f,  0.799192f,  0.799249f,  0.799307f,  0.799365f,  0.799422f,  0.799480f,
	 0.799537f,  0.799595f,  0.799652f,  0.799710f,  0.799768f,  0.799825f,  0.799883f,  0.799940f,
	 0.799998f,  0.800055f,  0.800113f,  0.800170f,  0.800228f,  0.800285f,  0.800343f,  0.800400f,
	 0.800458f,  0.800515f,  0.800573f,  0.800630f,  0.800687f,  0.800745f,  0.800802f,  0.800860f,
	 0.800917f,  0.800975f,  0.801032f,  0.801089f,  0.801147f,  0.801204f,  0.801261f,  0.801319f,
	 0.801376f,  0.801434f,  0.801491f,  0.801548f,  0.801606f,  0.801663f,  0.801720f,  0.801777f,
	 0.801835f,  0.801892f,  0.801949f,  0.802007f,  0.802064f,  0.802121f,  0.802178f,  0.802236f,
	 0.802293f,  0.802350f,  0.802407f,  0.802464f,  0.802522f,  0.802579f,  0.802636f,  0.802693f,
	 0.802750f,  0.802808f,  0.802865f,  0.802922f,  0.802979f,  0.803036f,  0.803093f,  0.803150f,
	 0.803208f,  0.803265f,  0.803322f,  0.803379f,  0.803436f,  0.803493f,  0.803550f,  0.803607f,
	 0.803664f,  0.803721f,  0.803778f,  0.803835f,  0.803892f,  0.803949f,  0.804006f,  0.804063f,
	 0.804120f,  0.804177f,  0.804234f,  0.804291f,  0.804348f,  0.804405f,  0.804462f,  0.804519f,
	 0.804576f,  0.804633f,  0.804690f,  0.804747f,  0.804804f,  0.804861f,  0.804918f,  0.804974f,
	 0.805031f,  0.805088f,  0.805145f,  0.805202f,  0.805259f,  0.805316f,  0.805372f,  0.805429f,
	 0.805486f,  0.805543f,  0.805600f,  0.805656f,  0.805713f,  0.805770f,  0.805827f,  0.805884f,
	 0.805940f,  0.805997f,  0.806054f,  0.806111f,  0.806167f,  0.806224f,  0.806281f,  0.806338f,
	 0.806394f,  0.806451f,  0.806508f,  0.806564f,  0.806621f,  0.806678f,  0.806734f,  0.806791f,
	 0.806848f,  0.806904f,  0.806961f,  0.807017f,  0.807074f,  0.807131f,  0.807187f,  0.807244f,
	 0.807300f,  0.807357f,  0.807414f,  0.807470f,  0.807527f,  0.807583f,  0.807640f,  0.807696f,
	 0.807753f,  0.807809f,  0.807866f,  0.807922f,  0.807979f,  0.808035f,  0.808092f,  0.808148f,
	 0.808205f,  0.808261f,  0.808318f,  0.808374f,  0.808430f,  0.808487f,  0.808543f,  0.808600f,
	 0.808656f,  0.808713f,  0.808769f,  0.808825f,  0.808882f,  0.808938f,  0.808994f,  0.809051f,
	 0.809107f,  0.809164f,  0.809220f,  0.809276f,  0.809332f,  0.809389f,  0.809445f,  0.809501f,
	 0.809558f,  0.809614f,  0.809670f,  0.809726f,  0.809783f,  0.809839f,  0.809895f,  0.809951f,
	 0.810008f,  0.810064f,  0.810120f,  0.810176f,  0.810232f,  0.810289f,  0.810345f,  0.810401f,
	 0.810457f,  0.810513f,  0.810570f,  0.810626f,  0.810682f,  0.810738f,  0.810794f,  0.810850f,
	 0.810906f,  0.810962f,  0.811018f,  0.811075f,  0.811131f,  0.811187f,  0.811243f,  0.811299f,
	 0.811355f,  0.811411f,  0.811467f,  0.811523f,  0.811579f,  0.811635f,  0.811691f,  0.811747f,
	 0.811803f,  0.811859f,  0.811915f,  0.811971f,  0.812027f,  0.812083f,  0.812139f,  0.812195f,
	 0.812251f,  0.812307f,  0.812362f,  0.812418f,  0.812474f,  0.812530f,  0.812586f,  0.812642f,
	 0.812698f,  0.812754f,  0.812809f,  0.812865f,  0.812921f,  0.812977f,  0.813033f,  0.813089f,
	 0.813144f,  0.813200f,  0.813256f,  0.813312f,  0.813368f,  0.813423f,  0.813479f,  0.813535f,
	 0.813591f,  0.813646f,  0.813702f,  0.813758f,  0.813814f,  0.813869f,  0.813925f,  0.813981f,
	 0.814036f,  0.814092f,  0.814148f,  0.814203f,  0.814259f,  0.814315f,  0.814370f,  0.814426f,
	 0.814482f,  0.814537f,  0.814593f,  0.814648f,  0.814704f,  0.814760f,  0.814815f,  0.814871f,
	 0.814926f,  0.814982f,  0.815037f,  0.815093f,  0.815149f,  0.815204f,  0.815260f,  0.815315f,
	 0.815371f,  0.815426f,  0.815482f,  0.815537f,  0.815593f,  0.815648f,  0.815704f,  0.815759f,
	 0.815814f,  0.815870f,  0.815925f,  0.815981f,  0.816036f,  0.816092f,  0.816147f,  0.816202f,
	 0.816258f,  0.816313f,  0.816368f,  0.816424f,  0.816479f,  0.816535f,  0.816590f,  0.816645f,
	 0.816701f,  0.816756f,  0.816811f,  0.816867f,  0.816922f,  0.816977f,  0.817032f,  0.817088f,
	 0.817143f,  0.817198f,  0.817253f,  0.817309f,  0.817364f,  0.817419f,  0.817474f,  0.817530f,
	 0.817585f,  0.817640f,  0.817695f,  0.817750f,  0.817806f,  0.817861f,  0.817916f,  0.817971f,
	 0.818026f,  0.818081f,  0.818137f,  0.818192f,  0.818247f,  0.818302f,  0.818357f,  0.818412f,
	 0.818467f,  0.818522f,  0.818577f,  0.818632f,  0.818687f,  0.818742f,  0.818798f,  0.818853f,
	 0.818908f,  0.818963f,  0.819018f,  0.819073f,  0.819128f,  0.819183f,  0.819238f,  0.819293f,
	 0.819348f,  0.819402f,  0.819457f,  0.819512f,  0.819567f,  0.819622f,  0.819677f,  0.819732f,
	 0.819787f,  0.819842f,  0.819897f,  0.819952f,  0.820007f,  0.820061f,  0.820116f,  0.820171f,
	 0.820226f,  0.820281f,  0.820336f,  0.820390f,  0.820445f,  0.820500f,  0.820555f,  0.820610f,
	 0.820664f,  0.820719f,  0.820774f,  0.820829f,  0.820884f,  0.820938f,  0.820993f,  0.821048f,
	 0.821102f,  0.821157f,  0.821212f,  0.821267f,  0.821321f,  0.821376f,  0.821431f,  0.821485f,
	 0.821540f,  0.821595f,  0.821649f,  0.821704f,  0.821759f,  0.821813f,  0.821868f,  0.821922f,
	 0.821977f,  0.822032f,  0.822086f,  0.822141f,  0.822195f,  0.822250f,  0.822305f,  0.822359f,
	 0.822414f,  0.822468f,  0.822523f,  0.822577f,  0.822632f,  0.822686f,  0.822741f,  0.822795f,
	 0.822850f,  0.822904f,  0.822959f,  0.823013f,  0.823068f,  0.823122f,  0.823177f,  0.823231f,
	 0.823285f,  0.823340f,  0.823394f,  0.823449f,  0.823503f,  0.823557f,  0.823612f,  0.823666f,
	 0.823721f,  0.823775f,  0.823829f,  0.823884f,  0.823938f,  0.823992f,  0.824047f,  0.824101f,
	 0.824155f,  0.824209f,  0.824264f,  0.824318f,  0.824372f,  0.824427f,  0.824481f,  0.824535f,
	 0.824589f,  0.824644f,  0.824698f,  0.824752f,  0.824806f,  0.824860f,  0.824915f,  0.824969f,
	 0.825023f,  0.825077f,  0.825131f,  0.825185f,  0.825240f,  0.825294f,  0.825348f,  0.825402f,
	 0.825456f,  0.825510f,  0.825564f,  0.825618f,  0.825673f,  0.825727f,  0.825781f,  0.825835f,
	 0.825889f,  0.825943f,  0.825997f,  0.826051f,  0.826105f,  0.826159f,  0.826213f,  0.826267f,
	 0.826321f,  0.826375f,  0.826429f,  0.826483f,  0.826537f,  0.826591f,  0.826645f,  0.826699f,
	 0.826753f,  0.826807f,  0.826861f,  0.826915f,  0.826968f,  0.827022f,  0.827076f,  0.827130f,
	 0.827184f,  0.827238f,  0.827292f,  0.827346f,  0.827399f,  0.827453f,  0.827507f,  0.827561f,
	 0.827615f,  0.827669f,  0.827722f,  0.827776f,  0.827830f,  0.827884f,  0.827938f,  0.827991f,
	 0.828045f,  0.828099f,  0.828153f,  0.828206f,  0.828260f,  0.828314f,  0.828367f,  0.828421f,
	 0.828475f,  0.828529f,  0.828582f,  0.828636f,  0.828690f,  0.828743f,  0.828797f,  0.828851f,
	 0.828904f,  0.828958f,  0.829011f,  0.829065f,  0.829119f,  0.829172f,  0.829226f,  0.829279f,
	 0.829333f,  0.829386f,  0.829440f,  0.829494f,  0.829547f,  0.829601f,  0.829654f,  0.829708f,
	 0.829761f,  0.829815f,  0.829868f,  0.829922f,  0.829975f,  0.830029f,  0.830082f,  0.830136f,
	 0.830189f,  0.830243f,  0.830296f,  0.830349f,  0.830403f,  0.830456f,  0.830510f,  0.830563f,
	 0.830616f,  0.830670f,  0.830723f,  0.830777f,  0.830830f,  0.830883f,  0.830937f,  0.830990f,
	 0.831043f,  0.831097f,  0.831150f,  0.831203f,  0.831257f,  0.831310f,  0.831363f,  0.831416f,
	 0.831470f,  0.831523f,  0.831576f,  0.831629f,  0.831683f,  0.831736f,  0.831789f,  0.831842f,
	 0.831895f,  0.831949f,  0.832002f,  0.832055f,  0.832108f,  0.832161f,  0.832215f,  0.832268f,
	 0.832321f,  0.832374f,  0.832427f,  0.832480f,  0.832533f,  0.832586f,  0.832640f,  0.832693f,
	 0.832746f,  0.832799f,  0.832852f,  0.832905f,  0.832958f,  0.833011f,  0.833064f,  0.833117f,
	 0.833170f,  0.833223f,  0.833276f,  0.833329f,  0.833382f,  0.833435f,  0.833488f,  0.833541f,
	 0.833594f,  0.833647f,  0.833700f,  0.833753f,  0.833806f,  0.833859f,  0.833912f,  0.833965f,
	 0.834018f,  0.834070f,  0.834123f,  0.834176f,  0.834229f,  0.834282f,  0.834335f,  0.834388f,
	 0.834440f,  0.834493f,  0.834546f,  0.834599f,  0.834652f,  0.834705f,  0.834757f,  0.834810f,
	 0.834863f,  0.834916f,  0.834968f,  0.835021f,  0.835074f,  0.835127f,  0.835179f,  0.835232f,
	 0.835285f,  0.835338f,  0.835390f,  0.835443f,  0.835496f,  0.835548f,  0.835601f,  0.835654f,
	 0.835706f,  0.835759f,  0.835812f,  0.835864f,  0.835917f,  0.835969f,  0.836022f,  0.836075f,
	 0.836127f,  0.836180f,  0.836232f,  0.836285f,  0.836338f,  0.836390f,  0.836443f,  0.836495f,
	 0.836548f,  0.836600f,  0.836653f,  0.836705f,  0.836758f,  0.836810f,  0.836863f,  0.836915f,
	 0.836968f,  0.837020f,  0.837073f,  0.837125f,  0.837178f,  0.837230f,  0.837282f,  0.837335f,
	 0.837387f,  0.837440f,  0.837492f,  0.837544f,  0.837597f,  0.837649f,  0.837701f,  0.837754f,
	 0.837806f,  0.837859f,  0.837911f,  0.837963f,  0.838015f,  0.838068f,  0.838120f,  0.838172f,
	 0.838225f,  0.838277f,  0.838329f,  0.838382f,  0.838434f,  0.838486f,  0.838538f,  0.838591f,
	 0.838643f,  0.838695f,  0.838747f,  0.838799f,  0.838852f,  0.838904f,  0.838956f,  0.839008f,
	 0.839060f,  0.839112f,  0.839165f,  0.839217f,  0.839269f,  0.839321f,  0.839373f,  0.839425f,
	 0.839477f,  0.839529f,  0.839581f,  0.839634f,  0.839686f,  0.839738f,  0.839790f,  0.839842f,
	 0.839894f,  0.839946f,  0.839998f,  0.840050f,  0.840102f,  0.840154f,  0.840206f,  0.840258f,
	 0.840310f,  0.840362f,  0.840414f,  0.840466f,  0.840518f,  0.840570f,  0.840622f,  0.840673f,
	 0.840725f,  0.840777f,  0.840829f,  0.840881f,  0.840933f,  0.840985f,  0.841037f,  0.841089f,
	 0.841140f,  0.841192f,  0.841244f,  0.841296f,  0.841348f,  0.841400f,  0.841451f,  0.841503f,
	 0.841555f,  0.841607f,  0.841659f,  0.841710f,  0.841762f,  0.841814f,  0.841866f,  0.841917f,
	 0.841969f,  0.842021f,  0.842072f,  0.842124f,  0.842176f,  0.842228f,  0.842279f,  0.842331f,
	 0.842383f,  0.842434f,  0.842486f,  0.842538f,  0.842589f,  0.842641f,  0.842692f,  0.842744f,
	 0.842796f,  0.842847f,  0.842899f,  0.842950f,  0.843002f,  0.843054f,  0.843105f,  0.843157f,
	 0.843208f,  0.843260f,  0.843311f,  0.843363f,  0.843414f,  0.843466f,  0.843517f,  0.843569f,
	 0.843620f,  0.843672f,  0.843723f,  0.843775f,  0.843826f,  0.843878f,  0.843929f,  0.843980f,
	 0.844032f,  0.844083f,  0.844135f,  0.844186f,  0.844238f,  0.844289f,  0.844340f,  0.844392f,
	 0.844443f,  0.844494f,  0.844546f,  0.844597f,  0.844648f,  0.844700f,  0.844751f,  0.844802f,
	 0.844854f,  0.844905f,  0.844956f,  0.845007f,  0.845059f,  0.845110f,  0.845161f,  0.845212f,
	 0.845264f,  0.845315f,  0.845366f,  0.845417f,  0.845469f,  0.845520f,  0.845571f,  0.845622f,
	 0.845673f,  0.845724f,  0.845776f,  0.845827f,  0.845878f,  0.845929f,  0.845980f,  0.846031f,
	 0.846082f,  0.846133f,  0.846185f,  0.846236f,  0.846287f,  0.846338f,  0.846389f,  0.846440f,
	 0.846491f,  0.846542f,  0.846593f,  0.846644f,  0.846695f,  0.846746f,  0.846797f,  0.846848f,
	 0.846899f,  0.846950f,  0.847001f,  0.847052f,  0.847103f,  0.847154f,  0.847205f,  0.847256f,
	 0.847307f,  0.847358f,  0.847408f,  0.847459f,  0.847510f,  0.847561f,  0.847612f,  0.847663f,
	 0.847714f,  0.847765f,  0.847815f,  0.847866f,  0.847917f,  0.847968f,  0.848019f,  0.848070f,
	 0.848120f,  0.848171f,  0.848222f,  0.848273f,  0.848323f,  0.848374f,  0.848425f,  0.848476f,
	 0.848526f,  0.848577f,  0.848628f,  0.848679f,  0.848729f,  0.848780f,  0.848831f,  0.848881f,
	 0.848932f,  0.848983f,  0.849033f,  0.849084f,  0.849135f,  0.849185f,  0.849236f,  0.849287f,
	 0.849337f,  0.849388f,  0.849438f,  0.849489f,  0.849540f,  0.849590f,  0.849641f,  0.849691f,
	 0.849742f,  0.849792f,  0.849843f,  0.849893f,  0.849944f,  0.849994f,  0.850045f,  0.850095f,
	 0.850146f,  0.850196f,  0.850247f,  0.850297f,  0.850348f,  0.850398f,  0.850449f,  0.850499f,
	 0.850549f,  0.850600f,  0.850650f,  0.850701f,  0.850751f,  0.850801f,  0.850852f,  0.850902f,
	 0.850953f,  0.851003f,  0.851053f,  0.851104f,  0.851154f,  0.851204f,  0.851255f,  0.851305f,
	 0.851355f,  0.851406f,  0.851456f,  0.851506f,  0.851556f,  0.851607f,  0.851657f,  0.851707f,
	 0.851757f,  0.851808f,  0.851858f,  0.851908f,  0.851958f,  0.852008f,  0.852059f,  0.852109f,
	 0.852159f,  0.852209f,  0.852259f,  0.852309f,  0.852360f,  0.852410f,  0.852460f,  0.852510f,
	 0.852560f,  0.852610f,  0.852660f,  0.852710f,  0.852760f,  0.852810f,  0.852861f,  0.852911f,
	 0.852961f,  0.853011f,  0.853061f,  0.853111f,  0.853161f,  0.853211f,  0.853261f,  0.853311f,
	 0.853361f,  0.853411f,  0.853461f,  0.853511f,  0.853561f,  0.853611f,  0.853660f,  0.853710f,
	 0.853760f,  0.853810f,  0.853860f,  0.853910f,  0.853960f,  0.854010f,  0.854060f,  0.854110f,
	 0.854159f,  0.854209f,  0.854259f,  0.854309f,  0.854359f,  0.854409f,  0.854458f,  0.854508f,
	 0.854558f,  0.854608f,  0.854658f,  0.854707f,  0.854757f,  0.854807f,  0.854857f,  0.854906f,
	 0.854956f,  0.855006f,  0.855056f,  0.855105f,  0.855155f,  0.855205f,  0.855254f,  0.855304f,
	 0.855354f,  0.855403f,  0.855453f,  0.855503f,  0.855552f,  0.855602f,  0.855651f,  0.855701f,
	 0.855751f,  0.855800f,  0.855850f,  0.855900f,  0.855949f,  0.855999f,  0.856048f,  0.856098f,
	 0.856147f,  0.856197f,  0.856246f,  0.856296f,  0.856345f,  0.856395f,  0.856444f,  0.856494f,
	 0.856543f,  0.856593f,  0.856642f,  0.856692f,  0.856741f,  0.856791f,  0.856840f,  0.856890f,
	 0.856939f,  0.856988f,  0.857038f,  0.857087f,  0.857137f,  0.857186f,  0.857235f,  0.857285f,
	 0.857334f,  0.857383f,  0.857433f,  0.857482f,  0.857531f,  0.857581f,  0.857630f,  0.857679f,
	 0.857729f,  0.857778f,  0.857827f,  0.857876f,  0.857926f,  0.857975f,  0.858024f,  0.858073f,
	 0.858123f,  0.858172f,  0.858221f,  0.858270f,  0.858320f,  0.858369f,  0.858418f,  0.858467f,
	 0.858516f,  0.858565f,  0.858615f,  0.858664f,  0.858713f,  0.858762f,  0.858811f,  0.858860f,
	 0.858909f,  0.858958f,  0.859007f,  0.859057f,  0.859106f,  0.859155f,  0.859204f,  0.859253f,
	 0.859302f,  0.859351f,  0.859400f,  0.859449f,  0.859498f,  0.859547f,  0.859596f,  0.859645f,
	 0.859694f,  0.859743f,  0.859792f,  0.859841f,  0.859890f,  0.859939f,  0.859988f,  0.860036f,
	 0.860085f,  0.860134f,  0.860183f,  0.860232f,  0.860281f,  0.860330f,  0.860379f,  0.860428f,
	 0.860476f,  0.860525f,  0.860574f,  0.860623f,  0.860672f,  0.860721f,  0.860769f,  0.860818f,
	 0.860867f,  0.860916f,  0.860964f,  0.861013f,  0.861062f,  0.861111f,  0.861160f,  0.861208f,
	 0.861257f,  0.861306f,  0.861354f,  0.861403f,  0.861452f,  0.861500f,  0.861549f,  0.861598f,
	 0.861646f,  0.861695f,  0.861744f,  0.861792f,  0.861841f,  0.861890f,  0.861938f,  0.861987f,
	 0.862035f,  0.862084f,  0.862133f,  0.862181f,  0.862230f,  0.862278f,  0.862327f,  0.862375f,
	 0.862424f,  0.862472f,  0.862521f,  0.862570f,  0.862618f,  0.862666f,  0.862715f,  0.862763f,
	 0.862812f,  0.862860f,  0.862909f,  0.862957f,  0.863006f,  0.863054f,  0.863103f,  0.863151f,
	 0.863199f,  0.863248f,  0.863296f,  0.863345f,  0.863393f,  0.863441f,  0.863490f,  0.863538f,
	 0.863586f,  0.863635f,  0.863683f,  0.863731f,  0.863780f,  0.863828f,  0.863876f,  0.863925f,
	 0.863973f,  0.864021f,  0.864069f,  0.864118f,  0.864166f,  0.864214f,  0.864262f,  0.864311f,
	 0.864359f,  0.864407f,  0.864455f,  0.864503f,  0.864552f,  0.864600f,  0.864648f,  0.864696f,
	 0.864744f,  0.864792f,  0.864841f,  0.864889f,  0.864937f,  0.864985f,  0.865033f,  0.865081f,
	 0.865129f,  0.865177f,  0.865225f,  0.865273f,  0.865321f,  0.865369f,  0.865418f,  0.865466f,
	 0.865514f,  0.865562f,  0.865610f,  0.865658f,  0.865706f,  0.865754f,  0.865802f,  0.865850f,
	 0.865898f,  0.865946f,  0.865993f,  0.866041f,  0.866089f,  0.866137f,  0.866185f,  0.866233f,
	 0.866281f,  0.866329f,  0.866377f,  0.866425f,  0.866472f,  0.866520f,  0.866568f,  0.866616f,
	 0.866664f,  0.866712f,  0.866759f,  0.866807f,  0.866855f,  0.866903f,  0.866951f,  0.866998f,
	 0.867046f,  0.867094f,  0.867142f,  0.867190f,  0.867237f,  0.867285f,  0.867333f,  0.867380f,
	 0.867428f,  0.867476f,  0.867523f,  0.867571f,  0.867619f,  0.867667f,  0.867714f,  0.867762f,
	 0.867809f,  0.867857f,  0.867905f,  0.867952f,  0.868000f,  0.868048f,  0.868095f,  0.868143f,
	 0.868190f,  0.868238f,  0.868285f,  0.868333f,  0.868381f,  0.868428f,  0.868476f,  0.868523f,
	 0.868571f,  0.868618f,  0.868666f,  0.868713f,  0.868761f,  0.868808f,  0.868856f,  0.868903f,
	 0.868951f,  0.868998f,  0.869045f,  0.869093f,  0.869140f,  0.869188f,  0.869235f,  0.869282f,
	 0.869330f,  0.869377f,  0.869425f,  0.869472f,  0.869519f,  0.869567f,  0.869614f,  0.869661f,
	 0.869709f,  0.869756f,  0.869803f,  0.869851f,  0.869898f,  0.869945f,  0.869992f,  0.870040f,
	 0.870087f,  0.870134f,  0.870182f,  0.870229f,  0.870276f,  0.870323f,  0.870370f,  0.870418f,
	 0.870465f,  0.870512f,  0.870559f,  0.870606f,  0.870654f,  0.870701f,  0.870748f,  0.870795f,
	 0.870842f,  0.870889f,  0.870936f,  0.870983f,  0.871031f,  0.871078f,  0.871125f,  0.871172f,
	 0.871219f,  0.871266f,  0.871313f,  0.871360f,  0.871407f,  0.871454f,  0.871501f,  0.871548f,
	 0.871595f,  0.871642f,  0.871689f,  0.871736f,  0.871783f,  0.871830f,  0.871877f,  0.871924f,
	 0.871971f,  0.872018f,  0.872065f,  0.872112f,  0.872159f,  0.872205f,  0.872252f,  0.872299f,
	 0.872346f,  0.872393f,  0.872440f,  0.872487f,  0.872534f,  0.872580f,  0.872627f,  0.872674f,
	 0.872721f,  0.872768f,  0.872814f,  0.872861f,  0.872908f,  0.872955f,  0.873001f,  0.873048f,
	 0.873095f,  0.873142f,  0.873188f,  0.873235f,  0.873282f,  0.873329f,  0.873375f,  0.873422f,
	 0.873469f,  0.873515f,  0.873562f,  0.873609f,  0.873655f,  0.873702f,  0.873749f,  0.873795f,
	 0.873842f,  0.873888f,  0.873935f,  0.873982f,  0.874028f,  0.874075f,  0.874121f,  0.874168f,
	 0.874215f,  0.874261f,  0.874308f,  0.874354f,  0.874401f,  0.874447f,  0.874494f,  0.874540f,
	 0.874587f,  0.874633f,  0.874680f,  0.874726f,  0.874773f,  0.874819f,  0.874865f,  0.874912f,
	 0.874958f,  0.875005f,  0.875051f,  0.875098f,  0.875144f,  0.875190f,  0.875237f,  0.875283f,
	 0.875329f,  0.875376f,  0.875422f,  0.875468f,  0.875515f,  0.875561f,  0.875607f,  0.875654f,
	 0.875700f,  0.875746f,  0.875793f,  0.875839f,  0.875885f,  0.875931f,  0.875978f,  0.876024f,
	 0.876070f,  0.876116f,  0.876163f,  0.876209f,  0.876255f,  0.876301f,  0.876347f,  0.876393f,
	 0.876440f,  0.876486f,  0.876532f,  0.876578f,  0.876624f,  0.876670f,  0.876716f,  0.876763f,
	 0.876809f,  0.876855f,  0.876901f,  0.876947f,  0.876993f,  0.877039f,  0.877085f,  0.877131f,
	 0.877177f,  0.877223f,  0.877269f,  0.877315f,  0.877361f,  0.877407f,  0.877453f,  0.877499f,
	 0.877545f,  0.877591f,  0.877637f,  0.877683f,  0.877729f,  0.877775f,  0.877821f,  0.877867f,
	 0.877913f,  0.877959f,  0.878005f,  0.878051f,  0.878096f,  0.878142f,  0.878188f,  0.878234f,
	 0.878280f,  0.878326f,  0.878371f,  0.878417f,  0.878463f,  0.878509f,  0.878555f,  0.878600f,
	 0.878646f,  0.878692f,  0.878738f,  0.878784f,  0.878829f,  0.878875f,  0.878921f,  0.878967f,
	 0.879012f,  0.879058f,  0.879104f,  0.879149f,  0.879195f,  0.879241f,  0.879286f,  0.879332f,
	 0.879378f,  0.879423f,  0.879469f,  0.879515f,  0.879560f,  0.879606f,  0.879651f,  0.879697f,
	 0.879743f,  0.879788f,  0.879834f,  0.879879f,  0.879925f,  0.879970f,  0.880016f,  0.880061f,
	 0.880107f,  0.880153f,  0.880198f,  0.880244f,  0.880289f,  0.880334f,  0.880380f,  0.880425f,
	 0.880471f,  0.880516f,  0.880562f,  0.880607f,  0.880653f,  0.880698f,  0.880743f,  0.880789f,
	 0.880834f,  0.880880f,  0.880925f,  0.880970f,  0.881016f,  0.881061f,  0.881106f,  0.881152f,
	 0.881197f,  0.881242f,  0.881288f,  0.881333f,  0.881378f,  0.881424f,  0.881469f,  0.881514f,
	 0.881559f,  0.881605f,  0.881650f,  0.881695f,  0.881740f,  0.881786f,  0.881831f,  0.881876f,
	 0.881921f,  0.881966f,  0.882012f,  0.882057f,  0.882102f,  0.882147f,  0.882192f,  0.882237f,
	 0.882283f,  0.882328f,  0.882373f,  0.882418f,  0.882463f,  0.882508f,  0.882553f,  0.882598f,
	 0.882643f,  0.882688f,  0.882733f,  0.882779f,  0.882824f,  0.882869f,  0.882914f,  0.882959f,
	 0.883004f,  0.883049f,  0.883094f,  0.883139f,  0.883184f,  0.883228f,  0.883273f,  0.883318f,
	 0.883363f,  0.883408f,  0.883453f,  0.883498f,  0.883543f,  0.883588f,  0.883633f,  0.883678f,
	 0.883723f,  0.883767f,  0.883812f,  0.883857f,  0.883902f,  0.883947f,  0.883992f,  0.884036f,
	 0.884081f,  0.884126f,  0.884171f,  0.884216f,  0.884260f,  0.884305f,  0.884350f,  0.884395f,
	 0.884439f,  0.884484f,  0.884529f,  0.884574f,  0.884618f,  0.884663f,  0.884708f,  0.884752f,
	 0.884797f,  0.884842f,  0.884886f,  0.884931f,  0.884976f,  0.885020f,  0.885065f,  0.885110f,
	 0.885154f,  0.885199f,  0.885243f,  0.885288f,  0.885333f,  0.885377f,  0.885422f,  0.885466f,
	 0.885511f,  0.885555f,  0.885600f,  0.885644f,  0.885689f,  0.885733f,  0.885778f,  0.885822f,
	 0.885867f,  0.885911f,  0.885956f,  0.886000f,  0.886045f,  0.886089f,  0.886134f,  0.886178f,
	 0.886223f,  0.886267f,  0.886311f,  0.886356f,  0.886400f,  0.886445f,  0.886489f,  0.886533f,
	 0.886578f,  0.886622f,  0.886666f,  0.886711f,  0.886755f,  0.886799f,  0.886844f,  0.886888f,
	 0.886932f,  0.886976f,  0.887021f,  0.887065f,  0.887109f,  0.887153f,  0.887198f,  0.887242f,
	 0.887286f,  0.887330f,  0.887375f,  0.887419f,  0.887463f,  0.887507f,  0.887551f,  0.887595f,
	 0.887640f,  0.887684f,  0.887728f,  0.887772f,  0.887816f,  0.887860f,  0.887904f,  0.887949f,
	 0.887993f,  0.888037f,  0.888081f,  0.888125f,  0.888169f,  0.888213f,  0.888257f,  0.888301f,
	 0.888345f,  0.888389f,  0.888433f,  0.888477f,  0.888521f,  0.888565f,  0.888609f,  0.888653f,
	 0.888697f,  0.888741f,  0.888785f,  0.888829f,  0.888873f,  0.888917f,  0.888961f,  0.889004f,
	 0.889048f,  0.889092f,  0.889136f,  0.889180f,  0.889224f,  0.889268f,  0.889312f,  0.889355f,
	 0.889399f,  0.889443f,  0.889487f,  0.889531f,  0.889574f,  0.889618f,  0.889662f,  0.889706f,
	 0.889750f,  0.889793f,  0.889837f,  0.889881f,  0.889925f,  0.889968f,  0.890012f,  0.890056f,
	 0.890099f,  0.890143f,  0.890187f,  0.890230f,  0.890274f,  0.890318f,  0.890361f,  0.890405f,
	 0.890449f,  0.890492f,  0.890536f,  0.890580f,  0.890623f,  0.890667f,  0.890710f,  0.890754f,
	 0.890797f,  0.890841f,  0.890885f,  0.890928f,  0.890972f,  0.891015f,  0.891059f,  0.891102f,
	 0.891146f,  0.891189f,  0.891233f,  0.891276f,  0.891320f,  0.891363f,  0.891407f,  0.891450f,
	 0.891493f,  0.891537f,  0.891580f,  0.891624f,  0.891667f,  0.891711f,  0.891754f,  0.891797f,
	 0.891841f,  0.891884f,  0.891927f,  0.891971f,  0.892014f,  0.892057f,  0.892101f,  0.892144f,
	 0.892187f,  0.892231f,  0.892274f,  0.892317f,  0.892361f,  0.892404f,  0.892447f,  0.892490f,
	 0.892534f,  0.892577f,  0.892620f,  0.892663f,  0.892706f,  0.892750f,  0.892793f,  0.892836f,
	 0.892879f,  0.892922f,  0.892965f,  0.893009f,  0.893052f,  0.893095f,  0.893138f,  0.893181f,
	 0.893224f,  0.893267f,  0.893310f,  0.893354f,  0.893397f,  0.893440f,  0.893483f,  0.893526f,
	 0.893569f,  0.893612f,  0.893655f,  0.893698f,  0.893741f,  0.893784f,  0.893827f,  0.893870f,
	 0.893913f,  0.893956f,  0.893999f,  0.894042f,  0.894085f,  0.894128f,  0.894171f,  0.894214f,
	 0.894256f,  0.894299f,  0.894342f,  0.894385f,  0.894428f,  0.894471f,  0.894514f,  0.894557f,
	 0.894599f,  0.894642f,  0.894685f,  0.894728f,  0.894771f,  0.894814f,  0.894856f,  0.894899f,
	 0.894942f,  0.894985f,  0.895028f,  0.895070f,  0.895113f,  0.895156f,  0.895198f,  0.895241f,
	 0.895284f,  0.895327f,  0.895369f,  0.895412f,  0.895455f,  0.895497f,  0.895540f,  0.895583f,
	 0.895625f,  0.895668f,  0.895711f,  0.895753f,  0.895796f,  0.895838f,  0.895881f,  0.895924f,
	 0.895966f,  0.896009f,  0.896051f,  0.896094f,  0.896137f,  0.896179f,  0.896222f,  0.896264f,
	 0.896307f,  0.896349f,  0.896392f,  0.896434f,  0.896477f,  0.896519f,  0.896562f,  0.896604f,
	 0.896646f,  0.896689f,  0.896731f,  0.896774f,  0.896816f,  0.896859f,  0.896901f,  0.896943f,
	 0.896986f,  0.897028f,  0.897071f,  0.897113f,  0.897155f,  0.897198f,  0.897240f,  0.897282f,
	 0.897325f,  0.897367f,  0.897409f,  0.897452f,  0.897494f,  0.897536f,  0.897578f,  0.897621f,
	 0.897663f,  0.897705f,  0.897747f,  0.897790f,  0.897832f,  0.897874f,  0.897916f,  0.897958f,
	 0.898001f,  0.898043f,  0.898085f,  0.898127f,  0.898169f,  0.898211f,  0.898254f,  0.898296f,
	 0.898338f,  0.898380f,  0.898422f,  0.898464f,  0.898506f,  0.898548f,  0.898590f,  0.898632f,
	 0.898674f,  0.898717f,  0.898759f,  0.898801f,  0.898843f,  0.898885f,  0.898927f,  0.898969f,
	 0.899011f,  0.899053f,  0.899095f,  0.899137f,  0.899179f,  0.899220f,  0.899262f,  0.899304f,
	 0.899346f,  0.899388f,  0.899430f,  0.899472f,  0.899514f,  0.899556f,  0.899598f,  0.899639f,
	 0.899681f,  0.899723f,  0.899765f,  0.899807f,  0.899849f,  0.899890f,  0.899932f,  0.899974f,
	 0.900016f,  0.900058f,  0.900099f,  0.900141f,  0.900183f,  0.900225f,  0.900266f,  0.900308f,
	 0.900350f,  0.900392f,  0.900433f,  0.900475f,  0.900517f,  0.900558f,  0.900600f,  0.900642f,
	 0.900683f,  0.900725f,  0.900767f,  0.900808f,  0.900850f,  0.900892f,  0.900933f,  0.900975f,
	 0.901016f,  0.901058f,  0.901100f,  0.901141f,  0.901183f,  0.901224f,  0.901266f,  0.901307f,
	 0.901349f,  0.901390f,  0.901432f,  0.901473f,  0.901515f,  0.901556f,  0.901598f,  0.901639f,
	 0.901681f,  0.901722f,  0.901764f,  0.901805f,  0.901847f,  0.901888f,  0.901929f,  0.901971f,
	 0.902012f,  0.902054f,  0.902095f,  0.902136f,  0.902178f,  0.902219f,  0.902260f,  0.902302f,
	 0.902343f,  0.902384f,  0.902426f,  0.902467f,  0.902508f,  0.902550f,  0.902591f,  0.902632f,
	 0.902673f,  0.902715f,  0.902756f,  0.902797f,  0.902838f,  0.902879f,  0.902921f,  0.902962f,
	 0.903003f,  0.903044f,  0.903085f,  0.903127f,  0.903168f,  0.903209f,  0.903250f,  0.903291f,
	 0.903332f,  0.903373f,  0.903415f,  0.903456f,  0.903497f,  0.903538f,  0.903579f,  0.903620f,
	 0.903661f,  0.903702f,  0.903743f,  0.903784f,  0.903825f,  0.903866f,  0.903907f,  0.903948f,
	 0.903989f,  0.904030f,  0.904071f,  0.904112f,  0.904153f,  0.904194f,  0.904235f,  0.904276f,
	 0.904317f,  0.904358f,  0.904399f,  0.904440f,  0.904481f,  0.904521f,  0.904562f,  0.904603f,
	 0.904644f,  0.904685f,  0.904726f,  0.904767f,  0.904807f,  0.904848f,  0.904889f,  0.904930f,
	 0.904971f,  0.905011f,  0.905052f,  0.905093f,  0.905134f,  0.905175f,  0.905215f,  0.905256f,
	 0.905297f,  0.905337f,  0.905378f,  0.905419f,  0.905460f,  0.905500f,  0.905541f,  0.905582f,
	 0.905622f,  0.905663f,  0.905704f,  0.905744f,  0.905785f,  0.905825f,  0.905866f,  0.905907f,
	 0.905947f,  0.905988f,  0.906028f,  0.906069f,  0.906110f,  0.906150f,  0.906191f,  0.906231f,
	 0.906272f,  0.906312f,  0.906353f,  0.906393f,  0.906434f,  0.906474f,  0.906515f,  0.906555f,
	 0.906596f,  0.906636f,  0.906677f,  0.906717f,  0.906757f,  0.906798f,  0.906838f,  0.906879f,
	 0.906919f,  0.906959f,  0.907000f,  0.907040f,  0.907081f,  0.907121f,  0.907161f,  0.907202f,
	 0.907242f,  0.907282f,  0.907323f,  0.907363f,  0.907403f,  0.907444f,  0.907484f,  0.907524f,
	 0.907564f,  0.907605f,  0.907645f,  0.907685f,  0.907725f,  0.907766f,  0.907806f,  0.907846f,
	 0.907886f,  0.907926f,  0.907966f,  0.908007f,  0.908047f,  0.908087f,  0.908127f,  0.908167f,
	 0.908207f,  0.908248f,  0.908288f,  0.908328f,  0.908368f,  0.908408f,  0.908448f,  0.908488f,
	 0.908528f,  0.908568f,  0.908608f,  0.908648f,  0.908688f,  0.908728f,  0.908768f,  0.908808f,
	 0.908848f,  0.908888f,  0.908928f,  0.908968f,  0.909008f,  0.909048f,  0.909088f,  0.909128f,
	 0.909168f,  0.909208f,  0.909248f,  0.909288f,  0.909328f,  0.909368f,  0.909407f,  0.909447f,
	 0.909487f,  0.909527f,  0.909567f,  0.909607f,  0.909646f,  0.909686f,  0.909726f,  0.909766f,
	 0.909806f,  0.909845f,  0.909885f,  0.909925f,  0.909965f,  0.910005f,  0.910044f,  0.910084f,
	 0.910124f,  0.910163f,  0.910203f,  0.910243f,  0.910283f,  0.910322f,  0.910362f,  0.910402f,
	 0.910441f,  0.910481f,  0.910521f,  0.910560f,  0.910600f,  0.910639f,  0.910679f,  0.910719f,
	 0.910758f,  0.910798f,  0.910837f,  0.910877f,  0.910917f,  0.910956f,  0.910996f,  0.911035f,
	 0.911075f,  0.911114f,  0.911154f,  0.911193f,  0.911233f,  0.911272f,  0.911312f,  0.911351f,
	 0.911391f,  0.911430f,  0.911470f,  0.911509f,  0.911548f,  0.911588f,  0.911627f,  0.911667f,
	 0.911706f,  0.911745f,  0.911785f,  0.911824f,  0.911864f,  0.911903f,  0.911942f,  0.911982f,
	 0.912021f,  0.912060f,  0.912099f,  0.912139f,  0.912178f,  0.912217f,  0.912257f,  0.912296f,
	 0.912335f,  0.912374f,  0.912414f,  0.912453f,  0.912492f,  0.912531f,  0.912571f,  0.912610f,
	 0.912649f,  0.912688f,  0.912727f,  0.912766f,  0.912806f,  0.912845f,  0.912884f,  0.912923f,
	 0.912962f,  0.913001f,  0.913040f,  0.913080f,  0.913119f,  0.913158f,  0.913197f,  0.913236f,
	 0.913275f,  0.913314f,  0.913353f,  0.913392f,  0.913431f,  0.913470f,  0.913509f,  0.913548f,
	 0.913587f,  0.913626f,  0.913665f,  0.913704f,  0.913743f,  0.913782f,  0.913821f,  0.913860f,
	 0.913899f,  0.913938f,  0.913976f,  0.914015f,  0.914054f,  0.914093f,  0.914132f,  0.914171f,
	 0.914210f,  0.914249f,  0.914287f,  0.914326f,  0.914365f,  0.914404f,  0.914443f,  0.914482f,
	 0.914520f,  0.914559f,  0.914598f,  0.914637f,  0.914675f,  0.914714f,  0.914753f,  0.914792f,
	 0.914830f,  0.914869f,  0.914908f,  0.914946f,  0.914985f,  0.915024f,  0.915062f,  0.915101f,
	 0.915140f,  0.915178f,  0.915217f,  0.915256f,  0.915294f,  0.915333f,  0.915372f,  0.915410f,
	 0.915449f,  0.915487f,  0.915526f,  0.915564f,  0.915603f,  0.915642f,  0.915680f,  0.915719f,
	 0.915757f,  0.915796f,  0.915834f,  0.915873f,  0.915911f,  0.915950f,  0.915988f,  0.916027f,
	 0.916065f,  0.916103f,  0.916142f,  0.916180f,  0.916219f,  0.916257f,  0.916296f,  0.916334f,
	 0.916372f,  0.916411f,  0.916449f,  0.916487f,  0.916526f,  0.916564f,  0.916602f,  0.916641f,
	 0.916679f,  0.916717f,  0.916756f,  0.916794f,  0.916832f,  0.916871f,  0.916909f,  0.916947f,
	 0.916985f,  0.917024f,  0.917062f,  0.917100f,  0.917138f,  0.917176f,  0.917215f,  0.917253f,
	 0.917291f,  0.917329f,  0.917367f,  0.917405f,  0.917444f,  0.917482f,  0.917520f,  0.917558f,
	 0.917596f,  0.917634f,  0.917672f,  0.917710f,  0.917749f,  0.917787f,  0.917825f,  0.917863f,
	 0.917901f,  0.917939f,  0.917977f,  0.918015f,  0.918053f,  0.918091f,  0.918129f,  0.918167f,
	 0.918205f,  0.918243f,  0.918281f,  0.918319f,  0.918357f,  0.918395f,  0.918433f,  0.918471f,
	 0.918508f,  0.918546f,  0.918584f,  0.918622f,  0.918660f,  0.918698f,  0.918736f,  0.918774f,
	 0.918811f,  0.918849f,  0.918887f,  0.918925f,  0.918963f,  0.919001f,  0.919038f,  0.919076f,
	 0.919114f,  0.919152f,  0.919189f,  0.919227f,  0.919265f,  0.919303f,  0.919340f,  0.919378f,
	 0.919416f,  0.919453f,  0.919491f,  0.919529f,  0.919567f,  0.919604f,  0.919642f,  0.919680f,
	 0.919717f,  0.919755f,  0.919792f,  0.919830f,  0.919868f,  0.919905f,  0.919943f,  0.919980f,
	 0.920018f,  0.920056f,  0.920093f,  0.920131f,  0.920168f,  0.920206f,  0.920243f,  0.920281f,
	 0.920318f,  0.920356f,  0.920393f,  0.920431f,  0.920468f,  0.920506f,  0.920543f,  0.920581f,
	 0.920618f,  0.920655f,  0.920693f,  0.920730f,  0.920768f,  0.920805f,  0.920842f,  0.920880f,
	 0.920917f,  0.920955f,  0.920992f,  0.921029f,  0.921067f,  0.921104f,  0.921141f,  0.921179f,
	 0.921216f,  0.921253f,  0.921291f,  0.921328f,  0.921365f,  0.921402f,  0.921440f,  0.921477f,
	 0.921514f,  0.921551f,  0.921588f,  0.921626f,  0.921663f,  0.921700f,  0.921737f,  0.921774f,
	 0.921812f,  0.921849f,  0.921886f,  0.921923f,  0.921960f,  0.921997f,  0.922034f,  0.922072f,
	 0.922109f,  0.922146f,  0.922183f,  0.922220f,  0.922257f,  0.922294f,  0.922331f,  0.922368f,
	 0.922405f,  0.922442f,  0.922479f,  0.922516f,  0.922553f,  0.922590f,  0.922627f,  0.922664f,
	 0.922701f,  0.922738f,  0.922775f,  0.922812f,  0.922849f,  0.922886f,  0.922923f,  0.922960f,
	 0.922997f,  0.923033f,  0.923070f,  0.923107f,  0.923144f,  0.923181f,  0.923218f,  0.923255f,
	 0.923291f,  0.923328f,  0.923365f,  0.923402f,  0.923439f,  0.923475f,  0.923512f,  0.923549f,
	 0.923586f,  0.923622f,  0.923659f,  0.923696f,  0.923733f,  0.923769f,  0.923806f,  0.923843f,
	 0.923880f,  0.923916f,  0.923953f,  0.923990f,  0.924026f,  0.924063f,  0.924100f,  0.924136f,
	 0.924173f,  0.924209f,  0.924246f,  0.924283f,  0.924319f,  0.924356f,  0.924392f,  0.924429f,
	 0.924465f,  0.924502f,  0.924539f,  0.924575f,  0.924612f,  0.924648f,  0.924685f,  0.924721f,
	 0.924758f,  0.924794f,  0.924831f,  0.924867f,  0.924904f,  0.924940f,  0.924976f,  0.925013f,
	 0.925049f,  0.925086f,  0.925122f,  0.925158f,  0.925195f,  0.925231f,  0.925268f,  0.925304f,
	 0.925340f,  0.925377f,  0.925413f,  0.925449f,  0.925486f,  0.925522f,  0.925558f,  0.925595f,
	 0.925631f,  0.925667f,  0.925703f,  0.925740f,  0.925776f,  0.925812f,  0.925848f,  0.925885f,
	 0.925921f,  0.925957f,  0.925993f,  0.926029f,  0.926066f,  0.926102f,  0.926138f,  0.926174f,
	 0.926210f,  0.926246f,  0.926283f,  0.926319f,  0.926355f,  0.926391f,  0.926427f,  0.926463f,
	 0.926499f,  0.926535f,  0.926571f,  0.926607f,  0.926643f,  0.926679f,  0.926715f,  0.926751f,
	 0.926787f,  0.926823f,  0.926859f,  0.926895f,  0.926931f,  0.926967f,  0.927003f,  0.927039f,
	 0.927075f,  0.927111f,  0.927147f,  0.927183f,  0.927219f,  0.927255f,  0.927291f,  0.927327f,
	 0.927363f,  0.927398f,  0.927434f,  0.927470f,  0.927506f,  0.927542f,  0.927578f,  0.927613f,
	 0.927649f,  0.927685f,  0.927721f,  0.927757f,  0.927792f,  0.927828f,  0.927864f,  0.927900f,
	 0.927935f,  0.927971f,  0.928007f,  0.928043f,  0.928078f,  0.928114f,  0.928150f,  0.928185f,
	 0.928221f,  0.928257f,  0.928292f,  0.928328f,  0.928364f,  0.928399f,  0.928435f,  0.928470f,
	 0.928506f,  0.928542f,  0.928577f,  0.928613f,  0.928648f,  0.928684f,  0.928720f,  0.928755f,
	 0.928791f,  0.928826f,  0.928862f,  0.928897f,  0.928933f,  0.928968f,  0.929004f,  0.929039f,
	 0.929075f,  0.929110f,  0.929146f,  0.929181f,  0.929216f,  0.929252f,  0.929287f,  0.929323f,
	 0.929358f,  0.929393f,  0.929429f,  0.929464f,  0.929500f,  0.929535f,  0.929570f,  0.929606f,
	 0.929641f,  0.929676f,  0.929712f,  0.929747f,  0.929782f,  0.929817f,  0.929853f,  0.929888f,
	 0.929923f,  0.929958f,  0.929994f,  0.930029f,  0.930064f,  0.930099f,  0.930135f,  0.930170f,
	 0.930205f,  0.930240f,  0.930275f,  0.930311f,  0.930346f,  0.930381f,  0.930416f,  0.930451f,
	 0.930486f,  0.930521f,  0.930556f,  0.930592f,  0.930627f,  0.930662f,  0.930697f,  0.930732f,
	 0.930767f,  0.930802f,  0.930837f,  0.930872f,  0.930907f,  0.930942f,  0.930977f,  0.931012f,
	 0.931047f,  0.931082f,  0.931117f,  0.931152f,  0.931187f,  0.931222f,  0.931257f,  0.931292f,
	 0.931327f,  0.931362f,  0.931397f,  0.931431f,  0.931466f,  0.931501f,  0.931536f,  0.931571f,
	 0.931606f,  0.931641f,  0.931675f,  0.931710f,  0.931745f,  0.931780f,  0.931815f,  0.931849f,
	 0.931884f,  0.931919f,  0.931954f,  0.931989f,  0.932023f,  0.932058f,  0.932093f,  0.932128f,
	 0.932162f,  0.932197f,  0.932232f,  0.932266f,  0.932301f,  0.932336f,  0.932370f,  0.932405f,
	 0.932440f,  0.932474f,  0.932509f,  0.932544f,  0.932578f,  0.932613f,  0.932647f,  0.932682f,
	 0.932716f,  0.932751f,  0.932786f,  0.932820f,  0.932855f,  0.932889f,  0.932924f,  0.932958f,
	 0.932993f,  0.933027f,  0.933062f,  0.933096f,  0.933131f,  0.933165f,  0.933200f,  0.933234f,
	 0.933269f,  0.933303f,  0.933337f,  0.933372f,  0.933406f,  0.933441f,  0.933475f,  0.933509f,
	 0.933544f,  0.933578f,  0.933612f,  0.933647f,  0.933681f,  0.933716f,  0.933750f,  0.933784f,
	 0.933818f,  0.933853f,  0.933887f,  0.933921f,  0.933956f,  0.933990f,  0.934024f,  0.934058f,
	 0.934093f,  0.934127f,  0.934161f,  0.934195f,  0.934229f,  0.934264f,  0.934298f,  0.934332f,
	 0.934366f,  0.934400f,  0.934434f,  0.934469f,  0.934503f,  0.934537f,  0.934571f,  0.934605f,
	 0.934639f,  0.934673f,  0.934707f,  0.934741f,  0.934775f,  0.934810f,  0.934844f,  0.934878f,
	 0.934912f,  0.934946f,  0.934980f,  0.935014f,  0.935048f,  0.935082f,  0.935116f,  0.935150f,
	 0.935184f,  0.935217f,  0.935251f,  0.935285f,  0.935319f,  0.935353f,  0.935387f,  0.935421f,
	 0.935455f,  0.935489f,  0.935523f,  0.935556f,  0.935590f,  0.935624f,  0.935658f,  0.935692f,
	 0.935726f,  0.935759f,  0.935793f,  0.935827f,  0.935861f,  0.935895f,  0.935928f,  0.935962f,
	 0.935996f,  0.936030f,  0.936063f,  0.936097f,  0.936131f,  0.936165f,  0.936198f,  0.936232f,
	 0.936266f,  0.936299f,  0.936333f,  0.936367f,  0.936400f,  0.936434f,  0.936468f,  0.936501f,
	 0.936535f,  0.936568f,  0.936602f,  0.936636f,  0.936669f,  0.936703f,  0.936736f,  0.936770f,
	 0.936803f,  0.936837f,  0.936871f,  0.936904f,  0.936938f,  0.936971f,  0.937005f,  0.937038f,
	 0.937072f,  0.937105f,  0.937138f,  0.937172f,  0.937205f,  0.937239f,  0.937272f,  0.937306f,
	 0.937339f,  0.937372f,  0.937406f,  0.937439f,  0.937473f,  0.937506f,  0.937539f,  0.937573f,
	 0.937606f,  0.937639f,  0.937673f,  0.937706f,  0.937739f,  0.937773f,  0.937806f,  0.937839f,
	 0.937872f,  0.937906f,  0.937939f,  0.937972f,  0.938005f,  0.938039f,  0.938072f,  0.938105f,
	 0.938138f,  0.938171f,  0.938205f,  0.938238f,  0.938271f,  0.938304f,  0.938337f,  0.938370f,
	 0.938404f,  0.938437f,  0.938470f,  0.938503f,  0.938536f,  0.938569f,  0.938602f,  0.938635f,
	 0.938668f,  0.938701f,  0.938734f,  0.938767f,  0.938800f,  0.938833f,  0.938866f,  0.938900f,
	 0.938932f,  0.938965f,  0.938998f,  0.939031f,  0.939064f,  0.939097f,  0.939130f,  0.939163f,
	 0.939196f,  0.939229f,  0.939262f,  0.939295f,  0.939328f,  0.939361f,  0.939394f,  0.939426f,
	 0.939459f,  0.939492f,  0.939525f,  0.939558f,  0.939591f,  0.939623f,  0.939656f,  0.939689f,
	 0.939722f,  0.939755f,  0.939787f,  0.939820f,  0.939853f,  0.939886f,  0.939918f,  0.939951f,
	 0.939984f,  0.940016f,  0.940049f,  0.940082f,  0.940115f,  0.940147f,  0.940180f,  0.940213f,
	 0.940245f,  0.940278f,  0.940310f,  0.940343f,  0.940376f,  0.940408f,  0.940441f,  0.940473f,
	 0.940506f,  0.940539f,  0.940571f,  0.940604f,  0.940636f,  0.940669f,  0.940701f,  0.940734f,
	 0.940766f,  0.940799f,  0.940831f,  0.940864f,  0.940896f,  0.940929f,  0.940961f,  0.940994f,
	 0.941026f,  0.941059f,  0.941091f,  0.941123f,  0.941156f,  0.941188f,  0.941221f,  0.941253f,
	 0.941285f,  0.941318f,  0.941350f,  0.941382f,  0.941415f,  0.941447f,  0.941479f,  0.941512f,
	 0.941544f,  0.941576f,  0.941609f,  0.941641f,  0.941673f,  0.941705f,  0.941738f,  0.941770f,
	 0.941802f,  0.941834f,  0.941867f,  0.941899f,  0.941931f,  0.941963f,  0.941995f,  0.942028f,
	 0.942060f,  0.942092f,  0.942124f,  0.942156f,  0.942188f,  0.942220f,  0.942253f,  0.942285f,
	 0.942317f,  0.942349f,  0.942381f,  0.942413f,  0.942445f,  0.942477f,  0.942509f,  0.942541f,
	 0.942573f,  0.942605f,  0.942637f,  0.942669f,  0.942701f,  0.942733f,  0.942765f,  0.942797f,
	 0.942829f,  0.942861f,  0.942893f,  0.942925f,  0.942957f,  0.942989f,  0.943021f,  0.943053f,
	 0.943084f,  0.943116f,  0.943148f,  0.943180f,  0.943212f,  0.943244f,  0.943276f,  0.943307f,
	 0.943339f,  0.943371f,  0.943403f,  0.943435f,  0.943466f,  0.943498f,  0.943530f,  0.943562f,
	 0.943593f,  0.943625f,  0.943657f,  0.943689f,  0.943720f,  0.943752f,  0.943784f,  0.943815f,
	 0.943847f,  0.943879f,  0.943910f,  0.943942f,  0.943974f,  0.944005f,  0.944037f,  0.944069f,
	 0.944100f,  0.944132f,  0.944163f,  0.944195f,  0.944227f,  0.944258f,  0.944290f,  0.944321f,
	 0.944353f,  0.944384f,  0.944416f,  0.944447f,  0.944479f,  0.944510f,  0.944542f,  0.944573f,
	 0.944605f,  0.944636f,  0.944668f,  0.944699f,  0.944731f,  0.944762f,  0.944793f,  0.944825f,
	 0.944856f,  0.944888f,  0.944919f,  0.944950f,  0.944982f,  0.945013f,  0.945045f,  0.945076f,
	 0.945107f,  0.945139f,  0.945170f,  0.945201f,  0.945232f,  0.945264f,  0.945295f,  0.945326f,
	 0.945358f,  0.945389f,  0.945420f,  0.945451f,  0.945482f,  0.945514f,  0.945545f,  0.945576f,
	 0.945607f,  0.945639f,  0.945670f,  0.945701f,  0.945732f,  0.945763f,  0.945794f,  0.945825f,
	 0.945857f,  0.945888f,  0.945919f,  0.945950f,  0.945981f,  0.946012f,  0.946043f,  0.946074f,
	 0.946105f,  0.946136f,  0.946167f,  0.946198f,  0.946229f,  0.946260f,  0.946291f,  0.946322f,
	 0.946353f,  0.946384f,  0.946415f,  0.946446f,  0.946477f,  0.946508f,  0.946539f,  0.946570f,
	 0.946601f,  0.946632f,  0.946663f,  0.946694f,  0.946724f,  0.946755f,  0.946786f,  0.946817f,
	 0.946848f,  0.946879f,  0.946910f,  0.946940f,  0.946971f,  0.947002f,  0.947033f,  0.947064f,
	 0.947094f,  0.947125f,  0.947156f,  0.947187f,  0.947217f,  0.947248f,  0.947279f,  0.947310f,
	 0.947340f,  0.947371f,  0.947402f,  0.947432f,  0.947463f,  0.947494f,  0.947524f,  0.947555f,
	 0.947586f,  0.947616f,  0.947647f,  0.947677f,  0.947708f,  0.947739f,  0.947769f,  0.947800f,
	 0.947830f,  0.947861f,  0.947891f,  0.947922f,  0.947953f,  0.947983f,  0.948014f,  0.948044f,
	 0.948075f,  0.948105f,  0.948136f,  0.948166f,  0.948196f,  0.948227f,  0.948257f,  0.948288f,
	 0.948318f,  0.948349f,  0.948379f,  0.948409f,  0.948440f,  0.948470f,  0.948501f,  0.948531f,
	 0.948561f,  0.948592f,  0.948622f,  0.948652f,  0.948683f,  0.948713f,  0.948743f,  0.948774f,
	 0.948804f,  0.948834f,  0.948864f,  0.948895f,  0.948925f,  0.948955f,  0.948985f,  0.949016f,
	 0.949046f,  0.949076f,  0.949106f,  0.949136f,  0.949167f,  0.949197f,  0.949227f,  0.949257f,
	 0.949287f,  0.949317f,  0.949348f,  0.949378f,  0.949408f,  0.949438f,  0.949468f,  0.949498f,
	 0.949528f,  0.949558f,  0.949588f,  0.949618f,  0.949648f,  0.949678f,  0.949708f,  0.949739f,
	 0.949768f,  0.949798f,  0.949829f,  0.949858f,  0.949888f,  0.949918f,  0.949948f,  0.949978f,
	 0.950008f,  0.950038f,  0.950068f,  0.950098f,  0.950128f,  0.950158f,  0.950188f,  0.950218f,
	 0.950247f,  0.950277f,  0.950307f,  0.950337f,  0.950367f,  0.950397f,  0.950426f,  0.950456f,
	 0.950486f,  0.950516f,  0.950546f,  0.950575f,  0.950605f,  0.950635f,  0.950665f,  0.950694f,
	 0.950724f,  0.950754f,  0.950784f,  0.950813f,  0.950843f,  0.950873f,  0.950902f,  0.950932f,
	 0.950962f,  0.950991f,  0.951021f,  0.951051f,  0.951080f,  0.951110f,  0.951139f,  0.951169f,
	 0.951199f,  0.951228f,  0.951258f,  0.951287f,  0.951317f,  0.951346f,  0.951376f,  0.951406f,
	 0.951435f,  0.951465f,  0.951494f,  0.951524f,  0.951553f,  0.951582f,  0.951612f,  0.951641f,
	 0.951671f,  0.951700f,  0.951730f,  0.951759f,  0.951789f,  0.951818f,  0.951847f,  0.951877f,
	 0.951906f,  0.951936f,  0.951965f,  0.951994f,  0.952024f,  0.952053f,  0.952082f,  0.952112f,
	 0.952141f,  0.952170f,  0.952199f,  0.952229f,  0.952258f,  0.952287f,  0.952317f,  0.952346f,
	 0.952375f,  0.952404f,  0.952433f,  0.952463f,  0.952492f,  0.952521f,  0.952550f,  0.952579f,
	 0.952609f,  0.952638f,  0.952667f,  0.952696f,  0.952725f,  0.952754f,  0.952783f,  0.952813f,
	 0.952842f,  0.952871f,  0.952900f,  0.952929f,  0.952958f,  0.952987f,  0.953016f,  0.953045f,
	 0.953074f,  0.953103f,  0.953132f,  0.953161f,  0.953190f,  0.953219f,  0.953248f,  0.953277f,
	 0.953306f,  0.953335f,  0.953364f,  0.953393f,  0.953422f,  0.953451f,  0.953480f,  0.953508f,
	 0.953537f,  0.953566f,  0.953595f,  0.953624f,  0.953653f,  0.953682f,  0.953711f,  0.953739f,
	 0.953768f,  0.953797f,  0.953826f,  0.953855f,  0.953883f,  0.953912f,  0.953941f,  0.953970f,
	 0.953998f,  0.954027f,  0.954056f,  0.954085f,  0.954113f,  0.954142f,  0.954171f,  0.954199f,
	 0.954228f,  0.954257f,  0.954285f,  0.954314f,  0.954343f,  0.954371f,  0.954400f,  0.954429f,
	 0.954457f,  0.954486f,  0.954514f,  0.954543f,  0.954572f,  0.954600f,  0.954629f,  0.954657f,
	 0.954686f,  0.954714f,  0.954743f,  0.954771f,  0.954800f,  0.954828f,  0.954857f,  0.954885f,
	 0.954914f,  0.954942f,  0.954971f,  0.954999f,  0.955028f,  0.955056f,  0.955084f,  0.955113f,
	 0.955141f,  0.955170f,  0.955198f,  0.955226f,  0.955255f,  0.955283f,  0.955311f,  0.955340f,
	 0.955368f,  0.955396f,  0.955425f,  0.955453f,  0.955481f,  0.955510f,  0.955538f,  0.955566f,
	 0.955594f,  0.955623f,  0.955651f,  0.955679f,  0.955707f,  0.955736f,  0.955764f,  0.955792f,
	 0.955820f,  0.955848f,  0.955876f,  0.955905f,  0.955933f,  0.955961f,  0.955989f,  0.956017f,
	 0.956045f,  0.956073f,  0.956101f,  0.956130f,  0.956158f,  0.956186f,  0.956214f,  0.956242f,
	 0.956270f,  0.956298f,  0.956326f,  0.956354f,  0.956382f,  0.956410f,  0.956438f,  0.956466f,
	 0.956494f,  0.956522f,  0.956550f,  0.956578f,  0.956606f,  0.956634f,  0.956662f,  0.956689f,
	 0.956717f,  0.956745f,  0.956773f,  0.956801f,  0.956829f,  0.956857f,  0.956885f,  0.956913f,
	 0.956940f,  0.956968f,  0.956996f,  0.957024f,  0.957052f,  0.957079f,  0.957107f,  0.957135f,
	 0.957163f,  0.957190f,  0.957218f,  0.957246f,  0.957274f,  0.957301f,  0.957329f,  0.957357f,
	 0.957385f,  0.957412f,  0.957440f,  0.957468f,  0.957495f,  0.957523f,  0.957550f,  0.957578f,
	 0.957606f,  0.957633f,  0.957661f,  0.957689f,  0.957716f,  0.957744f,  0.957771f,  0.957799f,
	 0.957826f,  0.957854f,  0.957882f,  0.957909f,  0.957937f,  0.957964f,  0.957992f,  0.958019f,
	 0.958046f,  0.958074f,  0.958101f,  0.958129f,  0.958156f,  0.958184f,  0.958211f,  0.958239f,
	 0.958266f,  0.958293f,  0.958321f,  0.958348f,  0.958376f,  0.958403f,  0.958430f,  0.958458f,
	 0.958485f,  0.958512f,  0.958540f,  0.958567f,  0.958594f,  0.958622f,  0.958649f,  0.958676f,
	 0.958703f,  0.958731f,  0.958758f,  0.958785f,  0.958812f,  0.958840f,  0.958867f,  0.958894f,
	 0.958921f,  0.958949f,  0.958976f,  0.959003f,  0.959030f,  0.959057f,  0.959084f,  0.959112f,
	 0.959139f,  0.959166f,  0.959193f,  0.959220f,  0.959247f,  0.959274f,  0.959301f,  0.959328f,
	 0.959355f,  0.959382f,  0.959409f,  0.959436f,  0.959463f,  0.959491f,  0.959518f,  0.959545f,
	 0.959572f,  0.959598f,  0.959625f,  0.959652f,  0.959679f,  0.959706f,  0.959733f,  0.959760f,
	 0.959787f,  0.959814f,  0.959841f,  0.959868f,  0.959895f,  0.959922f,  0.959948f,  0.959975f,
	 0.960002f,  0.960029f,  0.960056f,  0.960083f,  0.960109f,  0.960136f,  0.960163f,  0.960190f,
	 0.960217f,  0.960243f,  0.960270f,  0.960297f,  0.960324f,  0.960350f,  0.960377f,  0.960404f,
	 0.960431f,  0.960457f,  0.960484f,  0.960511f,  0.960537f,  0.960564f,  0.960591f,  0.960617f,
	 0.960644f,  0.960670f,  0.960697f,  0.960724f,  0.960750f,  0.960777f,  0.960804f,  0.960830f,
	 0.960857f,  0.960883f,  0.960910f,  0.960936f,  0.960963f,  0.960989f,  0.961016f,  0.961042f,
	 0.961069f,  0.961095f,  0.961122f,  0.961148f,  0.961175f,  0.961201f,  0.961228f,  0.961254f,
	 0.961280f,  0.961307f,  0.961333f,  0.961360f,  0.961386f,  0.961412f,  0.961439f,  0.961465f,
	 0.961492f,  0.961518f,  0.961544f,  0.961571f,  0.961597f,  0.961623f,  0.961649f,  0.961676f,
	 0.961702f,  0.961728f,  0.961755f,  0.961781f,  0.961807f,  0.961833f,  0.961860f,  0.961886f,
	 0.961912f,  0.961938f,  0.961964f,  0.961991f,  0.962017f,  0.962043f,  0.962069f,  0.962095f,
	 0.962121f,  0.962148f,  0.962174f,  0.962200f,  0.962226f,  0.962252f,  0.962278f,  0.962304f,
	 0.962330f,  0.962356f,  0.962382f,  0.962408f,  0.962434f,  0.962460f,  0.962486f,  0.962512f,
	 0.962538f,  0.962564f,  0.962590f,  0.962616f,  0.962642f,  0.962668f,  0.962694f,  0.962720f,
	 0.962746f,  0.962772f,  0.962798f,  0.962824f,  0.962850f,  0.962876f,  0.962902f,  0.962927f,
	 0.962953f,  0.962979f,  0.963005f,  0.963031f,  0.963057f,  0.963082f,  0.963108f,  0.963134f,
	 0.963160f,  0.963186f,  0.963211f,  0.963237f,  0.963263f,  0.963289f,  0.963314f,  0.963340f,
	 0.963366f,  0.963391f,  0.963417f,  0.963443f,  0.963469f,  0.963494f,  0.963520f,  0.963546f,
	 0.963571f,  0.963597f,  0.963623f,  0.963648f,  0.963674f,  0.963699f,  0.963725f,  0.963750f,
	 0.963776f,  0.963802f,  0.963827f,  0.963853f,  0.963878f,  0.963904f,  0.963929f,  0.963955f,
	 0.963980f,  0.964006f,  0.964031f,  0.964057f,  0.964082f,  0.964108f,  0.964133f,  0.964159f,
	 0.964184f,  0.964209f,  0.964235f,  0.964260f,  0.964286f,  0.964311f,  0.964336f,  0.964362f,
	 0.964387f,  0.964413f,  0.964438f,  0.964463f,  0.964489f,  0.964514f,  0.964539f,  0.964565f,
	 0.964590f,  0.964615f,  0.964640f,  0.964666f,  0.964691f,  0.964716f,  0.964741f,  0.964767f,
	 0.964792f,  0.964817f,  0.964842f,  0.964867f,  0.964893f,  0.964918f,  0.964943f,  0.964968f,
	 0.964993f,  0.965018f,  0.965044f,  0.965069f,  0.965094f,  0.965119f,  0.965144f,  0.965169f,
	 0.965194f,  0.965219f,  0.965244f,  0.965269f,  0.965294f,  0.965319f,  0.965344f,  0.965369f,
	 0.965394f,  0.965419f,  0.965444f,  0.965469f,  0.965494f,  0.965519f,  0.965544f,  0.965569f,
	 0.965594f,  0.965619f,  0.965644f,  0.965669f,  0.965694f,  0.965719f,  0.965744f,  0.965769f,
	 0.965793f,  0.965818f,  0.965843f,  0.965868f,  0.965893f,  0.965918f,  0.965942f,  0.965967f,
	 0.965992f,  0.966017f,  0.966042f,  0.966066f,  0.966091f,  0.966116f,  0.966141f,  0.966165f,
	 0.966190f,  0.966215f,  0.966239f,  0.966264f,  0.966289f,  0.966313f,  0.966338f,  0.966363f,
	 0.966387f,  0.966412f,  0.966437f,  0.966461f,  0.966486f,  0.966511f,  0.966535f,  0.966560f,
	 0.966584f,  0.966609f,  0.966633f,  0.966658f,  0.966683f,  0.966707f,  0.966732f,  0.966756f,
	 0.966781f,  0.966805f,  0.966830f,  0.966854f,  0.966879f,  0.966903f,  0.966928f,  0.966952f,
	 0.966976f,  0.967001f,  0.967025f,  0.967050f,  0.967074f,  0.967099f,  0.967123f,  0.967147f,
	 0.967172f,  0.967196f,  0.967220f,  0.967245f,  0.967269f,  0.967293f,  0.967318f,  0.967342f,
	 0.967366f,  0.967391f,  0.967415f,  0.967439f,  0.967463f,  0.967488f,  0.967512f,  0.967536f,
	 0.967560f,  0.967585f,  0.967609f,  0.967633f,  0.967657f,  0.967681f,  0.967706f,  0.967730f,
	 0.967754f,  0.967778f,  0.967802f,  0.967826f,  0.967850f,  0.967874f,  0.967899f,  0.967923f,
	 0.967947f,  0.967971f,  0.967995f,  0.968019f,  0.968043f,  0.968067f,  0.968091f,  0.968115f,
	 0.968139f,  0.968163f,  0.968187f,  0.968211f,  0.968235f,  0.968259f,  0.968283f,  0.968307f,
	 0.968331f,  0.968355f,  0.968379f,  0.968403f,  0.968427f,  0.968450f,  0.968474f,  0.968498f,
	 0.968522f,  0.968546f,  0.968570f,  0.968594f,  0.968617f,  0.968641f,  0.968665f,  0.968689f,
	 0.968713f,  0.968737f,  0.968760f,  0.968784f,  0.968808f,  0.968832f,  0.968855f,  0.968879f,
	 0.968903f,  0.968927f,  0.968950f,  0.968974f,  0.968998f,  0.969021f,  0.969045f,  0.969069f,
	 0.969092f,  0.969116f,  0.969140f,  0.969163f,  0.969187f,  0.969210f,  0.969234f,  0.969258f,
	 0.969281f,  0.969305f,  0.969328f,  0.969352f,  0.969375f,  0.969399f,  0.969423f,  0.969446f,
	 0.969470f,  0.969493f,  0.969517f,  0.969540f,  0.969564f,  0.969587f,  0.969611f,  0.969634f,
	 0.969657f,  0.969681f,  0.969704f,  0.969728f,  0.969751f,  0.969774f,  0.969798f,  0.969821f,
	 0.969845f,  0.969868f,  0.969891f,  0.969915f,  0.969938f,  0.969961f,  0.969985f,  0.970008f,
	 0.970031f,  0.970055f,  0.970078f,  0.970101f,  0.970124f,  0.970148f,  0.970171f,  0.970194f,
	 0.970217f,  0.970241f,  0.970264f,  0.970287f,  0.970310f,  0.970333f,  0.970357f,  0.970380f,
	 0.970403f,  0.970426f,  0.970449f,  0.970472f,  0.970495f,  0.970518f,  0.970542f,  0.970565f,
	 0.970588f,  0.970611f,  0.970634f,  0.970657f,  0.970680f,  0.970703f,  0.970726f,  0.970749f,
	 0.970772f,  0.970795f,  0.970818f,  0.970841f,  0.970864f,  0.970887f,  0.970910f,  0.970933f,
	 0.970956f,  0.970979f,  0.971002f,  0.971025f,  0.971048f,  0.971071f,  0.971093f,  0.971116f,
	 0.971139f,  0.971162f,  0.971185f,  0.971208f,  0.971231f,  0.971253f,  0.971276f,  0.971299f,
	 0.971322f,  0.971345f,  0.971367f,  0.971390f,  0.971413f,  0.971436f,  0.971458f,  0.971481f,
	 0.971504f,  0.971527f,  0.971549f,  0.971572f,  0.971595f,  0.971617f,  0.971640f,  0.971663f,
	 0.971685f,  0.971708f,  0.971731f,  0.971753f,  0.971776f,  0.971799f,  0.971821f,  0.971844f,
	 0.971866f,  0.971889f,  0.971911f,  0.971934f,  0.971957f,  0.971979f,  0.972002f,  0.972024f,
	 0.972047f,  0.972069f,  0.972092f,  0.972114f,  0.972137f,  0.972159f,  0.972182f,  0.972204f,
	 0.972227f,  0.972249f,  0.972271f,  0.972294f,  0.972316f,  0.972339f,  0.972361f,  0.972383f,
	 0.972406f,  0.972428f,  0.972450f,  0.972473f,  0.972495f,  0.972517f,  0.972540f,  0.972562f,
	 0.972584f,  0.972607f,  0.972629f,  0.972651f,  0.972673f,  0.972696f,  0.972718f,  0.972740f,
	 0.972762f,  0.972785f,  0.972807f,  0.972829f,  0.972851f,  0.972873f,  0.972896f,  0.972918f,
	 0.972940f,  0.972962f,  0.972984f,  0.973006f,  0.973028f,  0.973051f,  0.973073f,  0.973095f,
	 0.973117f,  0.973139f,  0.973161f,  0.973183f,  0.973205f,  0.973227f,  0.973249f,  0.973271f,
	 0.973293f,  0.973315f,  0.973337f,  0.973359f,  0.973381f,  0.973403f,  0.973425f,  0.973447f,
	 0.973469f,  0.973491f,  0.973513f,  0.973535f,  0.973557f,  0.973579f,  0.973601f,  0.973622f,
	 0.973644f,  0.973666f,  0.973688f,  0.973710f,  0.973732f,  0.973753f,  0.973775f,  0.973797f,
	 0.973819f,  0.973841f,  0.973862f,  0.973884f,  0.973906f,  0.973928f,  0.973949f,  0.973971f,
	 0.973993f,  0.974015f,  0.974036f,  0.974058f,  0.974080f,  0.974101f,  0.974123f,  0.974145f,
	 0.974166f,  0.974188f,  0.974210f,  0.974231f,  0.974253f,  0.974275f,  0.974296f,  0.974318f,
	 0.974339f,  0.974361f,  0.974383f,  0.974404f,  0.974426f,  0.974447f,  0.974469f,  0.974490f,
	 0.974512f,  0.974533f,  0.974555f,  0.974576f,  0.974598f,  0.974619f,  0.974641f,  0.974662f,
	 0.974684f,  0.974705f,  0.974726f,  0.974748f,  0.974769f,  0.974791f,  0.974812f,  0.974833f,
	 0.974855f,  0.974876f,  0.974897f,  0.974919f,  0.974940f,  0.974961f,  0.974983f,  0.975004f,
	 0.975025f,  0.975047f,  0.975068f,  0.975089f,  0.975110f,  0.975132f,  0.975153f,  0.975174f,
	 0.975195f,  0.975217f,  0.975238f,  0.975259f,  0.975280f,  0.975301f,  0.975323f,  0.975344f,
	 0.975365f,  0.975386f,  0.975407f,  0.975428f,  0.975449f,  0.975471f,  0.975492f,  0.975513f,
	 0.975534f,  0.975555f,  0.975576f,  0.975597f,  0.975618f,  0.975639f,  0.975660f,  0.975681f,
	 0.975702f,  0.975723f,  0.975744f,  0.975765f,  0.975786f,  0.975807f,  0.975828f,  0.975849f,
	 0.975870f,  0.975891f,  0.975912f,  0.975933f,  0.975954f,  0.975974f,  0.975995f,  0.976016f,
	 0.976037f,  0.976058f,  0.976079f,  0.976100f,  0.976120f,  0.976141f,  0.976162f,  0.976183f,
	 0.976204f,  0.976224f,  0.976245f,  0.976266f,  0.976287f,  0.976308f,  0.976328f,  0.976349f,
	 0.976370f,  0.976390f,  0.976411f,  0.976432f,  0.976453f,  0.976473f,  0.976494f,  0.976515f,
	 0.976535f,  0.976556f,  0.976576f,  0.976597f,  0.976618f,  0.976638f,  0.976659f,  0.976680f,
	 0.976700f,  0.976721f,  0.976741f,  0.976762f,  0.976782f,  0.976803f,  0.976823f,  0.976844f,
	 0.976864f,  0.976885f,  0.976905f,  0.976926f,  0.976946f,  0.976967f,  0.976987f,  0.977008f,
	 0.977028f,  0.977049f,  0.977069f,  0.977089f,  0.977110f,  0.977130f,  0.977151f,  0.977171f,
	 0.977191f,  0.977212f,  0.977232f,  0.977252f,  0.977273f,  0.977293f,  0.977313f,  0.977334f,
	 0.977354f,  0.977374f,  0.977394f,  0.977415f,  0.977435f,  0.977455f,  0.977475f,  0.977496f,
	 0.977516f,  0.977536f,  0.977556f,  0.977577f,  0.977597f,  0.977617f,  0.977637f,  0.977657f,
	 0.977677f,  0.977697f,  0.977718f,  0.977738f,  0.977758f,  0.977778f,  0.977798f,  0.977818f,
	 0.977838f,  0.977858f,  0.977878f,  0.977898f,  0.977918f,  0.977938f,  0.977959f,  0.977979f,
	 0.977998f,  0.978019f,  0.978038f,  0.978058f,  0.978078f,  0.978098f,  0.978118f,  0.978138f,
	 0.978158f,  0.978178f,  0.978198f,  0.978218f,  0.978238f,  0.978258f,  0.978278f,  0.978298f,
	 0.978317f,  0.978337f,  0.978357f,  0.978377f,  0.978397f,  0.978417f,  0.978436f,  0.978456f,
	 0.978476f,  0.978496f,  0.978516f,  0.978535f,  0.978555f,  0.978575f,  0.978594f,  0.978614f,
	 0.978634f,  0.978654f,  0.978673f,  0.978693f,  0.978713f,  0.978732f,  0.978752f,  0.978772f,
	 0.978791f,  0.978811f,  0.978831f,  0.978850f,  0.978870f,  0.978889f,  0.978909f,  0.978929f,
	 0.978948f,  0.978968f,  0.978987f,  0.979007f,  0.979026f,  0.979046f,  0.979065f,  0.979085f,
	 0.979104f,  0.979124f,  0.979143f,  0.979163f,  0.979182f,  0.979202f,  0.979221f,  0.979241f,
	 0.979260f,  0.979280f,  0.979299f,  0.979318f,  0.979338f,  0.979357f,  0.979376f,  0.979396f,
	 0.979415f,  0.979435f,  0.979454f,  0.979473f,  0.979493f,  0.979512f,  0.979531f,  0.979550f,
	 0.979570f,  0.979589f,  0.979608f,  0.979628f,  0.979647f,  0.979666f,  0.979685f,  0.979704f,
	 0.979724f,  0.979743f,  0.979762f,  0.979781f,  0.979800f,  0.979820f,  0.979839f,  0.979858f,
	 0.979877f,  0.979896f,  0.979915f,  0.979934f,  0.979954f,  0.979973f,  0.979992f,  0.980011f,
	 0.980030f,  0.980049f,  0.980068f,  0.980087f,  0.980106f,  0.980125f,  0.980144f,  0.980163f,
	 0.980182f,  0.980201f,  0.980220f,  0.980239f,  0.980258f,  0.980277f,  0.980296f,  0.980315f,
	 0.980334f,  0.980353f,  0.980372f,  0.980390f,  0.980409f,  0.980428f,  0.980447f,  0.980466f,
	 0.980485f,  0.980504f,  0.980523f,  0.980541f,  0.980560f,  0.980579f,  0.980598f,  0.980617f,
	 0.980635f,  0.980654f,  0.980673f,  0.980692f,  0.980710f,  0.980729f,  0.980748f,  0.980767f,
	 0.980785f,  0.980804f,  0.980823f,  0.980841f,  0.980860f,  0.980879f,  0.980897f,  0.980916f,
	 0.980935f,  0.980953f,  0.980972f,  0.980990f,  0.981009f,  0.981028f,  0.981046f,  0.981065f,
	 0.981083f,  0.981102f,  0.981120f,  0.981139f,  0.981158f,  0.981176f,  0.981195f,  0.981213f,
	 0.981232f,  0.981250f,  0.981269f,  0.981287f,  0.981305f,  0.981324f,  0.981342f,  0.981361f,
	 0.981379f,  0.981398f,  0.981416f,  0.981434f,  0.981453f,  0.981471f,  0.981490f,  0.981508f,
	 0.981526f,  0.981545f,  0.981563f,  0.981581f,  0.981600f,  0.981618f,  0.981636f,  0.981654f,
	 0.981673f,  0.981691f,  0.981709f,  0.981727f,  0.981746f,  0.981764f,  0.981782f,  0.981800f,
	 0.981819f,  0.981837f,  0.981855f,  0.981873f,  0.981891f,  0.981909f,  0.981928f,  0.981946f,
	 0.981964f,  0.981982f,  0.982000f,  0.982018f,  0.982036f,  0.982054f,  0.982072f,  0.982091f,
	 0.982109f,  0.982127f,  0.982145f,  0.982163f,  0.982181f,  0.982199f,  0.982217f,  0.982235f,
	 0.982253f,  0.982271f,  0.982289f,  0.982307f,  0.982325f,  0.982343f,  0.982360f,  0.982378f,
	 0.982396f,  0.982414f,  0.982432f,  0.982450f,  0.982468f,  0.982486f,  0.982504f,  0.982521f,
	 0.982539f,  0.982557f,  0.982575f,  0.982593f,  0.982611f,  0.982628f,  0.982646f,  0.982664f,
	 0.982682f,  0.982699f,  0.982717f,  0.982735f,  0.982753f,  0.982770f,  0.982788f,  0.982806f,
	 0.982824f,  0.982841f,  0.982859f,  0.982877f,  0.982894f,  0.982912f,  0.982930f,  0.982947f,
	 0.982965f,  0.982982f,  0.983000f,  0.983018f,  0.983035f,  0.983053f,  0.983070f,  0.983088f,
	 0.983105f,  0.983123f,  0.983141f,  0.983158f,  0.983176f,  0.983193f,  0.983211f,  0.983228f,
	 0.983246f,  0.983263f,  0.983281f,  0.983298f,  0.983315f,  0.983333f,  0.983350f,  0.983368f,
	 0.983385f,  0.983402f,  0.983420f,  0.983437f,  0.983455f,  0.983472f,  0.983489f,  0.983507f,
	 0.983524f,  0.983541f,  0.983559f,  0.983576f,  0.983593f,  0.983611f,  0.983628f,  0.983645f,
	 0.983662f,  0.983680f,  0.983697f,  0.983714f,  0.983731f,  0.983749f,  0.983766f,  0.983783f,
	 0.983800f,  0.983817f,  0.983835f,  0.983852f,  0.983869f,  0.983886f,  0.983903f,  0.983920f,
	 0.983937f,  0.983955f,  0.983972f,  0.983989f,  0.984006f,  0.984023f,  0.984040f,  0.984057f,
	 0.984074f,  0.984091f,  0.984108f,  0.984125f,  0.984142f,  0.984159f,  0.984176f,  0.984193f,
	 0.984210f,  0.984227f,  0.984244f,  0.984261f,  0.984278f,  0.984295f,  0.984312f,  0.984329f,
	 0.984346f,  0.984362f,  0.984379f,  0.984396f,  0.984413f,  0.984430f,  0.984447f,  0.984464f,
	 0.984480f,  0.984497f,  0.984514f,  0.984531f,  0.984548f,  0.984564f,  0.984581f,  0.984598f,
	 0.984615f,  0.984632f,  0.984648f,  0.984665f,  0.984682f,  0.984698f,  0.984715f,  0.984732f,
	 0.984748f,  0.984765f,  0.984782f,  0.984798f,  0.984815f,  0.984832f,  0.984848f,  0.984865f,
	 0.984882f,  0.984898f,  0.984915f,  0.984931f,  0.984948f,  0.984965f,  0.984981f,  0.984998f,
	 0.985014f,  0.985031f,  0.985047f,  0.985064f,  0.985080f,  0.985097f,  0.985113f,  0.985130f,
	 0.985146f,  0.985163f,  0.985179f,  0.985196f,  0.985212f,  0.985228f,  0.985245f,  0.985261f,
	 0.985278f,  0.985294f,  0.985310f,  0.985327f,  0.985343f,  0.985359f,  0.985376f,  0.985392f,
	 0.985408f,  0.985425f,  0.985441f,  0.985457f,  0.985474f,  0.985490f,  0.985506f,  0.985523f,
	 0.985539f,  0.985555f,  0.985571f,  0.985587f,  0.985604f,  0.985620f,  0.985636f,  0.985652f,
	 0.985668f,  0.985685f,  0.985701f,  0.985717f,  0.985733f,  0.985749f,  0.985765f,  0.985781f,
	 0.985798f,  0.985814f,  0.985830f,  0.985846f,  0.985862f,  0.985878f,  0.985894f,  0.985910f,
	 0.985926f,  0.985942f,  0.985958f,  0.985974f,  0.985990f,  0.986006f,  0.986022f,  0.986038f,
	 0.986054f,  0.986070f,  0.986086f,  0.986102f,  0.986118f,  0.986134f,  0.986150f,  0.986165f,
	 0.986181f,  0.986197f,  0.986213f,  0.986229f,  0.986245f,  0.986261f,  0.986276f,  0.986292f,
	 0.986308f,  0.986324f,  0.986340f,  0.986355f,  0.986371f,  0.986387f,  0.986403f,  0.986419f,
	 0.986434f,  0.986450f,  0.986466f,  0.986481f,  0.986497f,  0.986513f,  0.986529f,  0.986544f,
	 0.986560f,  0.986576f,  0.986591f,  0.986607f,  0.986623f,  0.986638f,  0.986654f,  0.986669f,
	 0.986685f,  0.986701f,  0.986716f,  0.986732f,  0.986747f,  0.986763f,  0.986778f,  0.986794f,
	 0.986809f,  0.986825f,  0.986840f,  0.986856f,  0.986871f,  0.986887f,  0.986902f,  0.986918f,
	 0.986933f,  0.986949f,  0.986964f,  0.986980f,  0.986995f,  0.987010f,  0.987026f,  0.987041f,
	 0.987057f,  0.987072f,  0.987087f,  0.987103f,  0.987118f,  0.987133f,  0.987149f,  0.987164f,
	 0.987179f,  0.987195f,  0.987210f,  0.987225f,  0.987240f,  0.987256f,  0.987271f,  0.987286f,
	 0.987301f,  0.987317f,  0.987332f,  0.987347f,  0.987362f,  0.987377f,  0.987393f,  0.987408f,
	 0.987423f,  0.987438f,  0.987453f,  0.987468f,  0.987484f,  0.987499f,  0.987514f,  0.987529f,
	 0.987544f,  0.987559f,  0.987574f,  0.987589f,  0.987604f,  0.987619f,  0.987634f,  0.987649f,
	 0.987664f,  0.987679f,  0.987694f,  0.987709f,  0.987724f,  0.987739f,  0.987754f,  0.987769f,
	 0.987784f,  0.987799f,  0.987814f,  0.987829f,  0.987844f,  0.987859f,  0.987874f,  0.987889f,
	 0.987903f,  0.987918f,  0.987933f,  0.987948f,  0.987963f,  0.987978f,  0.987992f,  0.988007f,
	 0.988022f,  0.988037f,  0.988052f,  0.988066f,  0.988081f,  0.988096f,  0.988111f,  0.988125f,
	 0.988140f,  0.988155f,  0.988169f,  0.988184f,  0.988199f,  0.988214f,  0.988228f,  0.988243f,
	 0.988258f,  0.988272f,  0.988287f,  0.988301f,  0.988316f,  0.988331f,  0.988345f,  0.988360f,
	 0.988374f,  0.988389f,  0.988404f,  0.988418f,  0.988433f,  0.988447f,  0.988462f,  0.988476f,
	 0.988491f,  0.988505f,  0.988520f,  0.988534f,  0.988549f,  0.988563f,  0.988578f,  0.988592f,
	 0.988607f,  0.988621f,  0.988635f,  0.988650f,  0.988664f,  0.988679f,  0.988693f,  0.988707f,
	 0.988722f,  0.988736f,  0.988750f,  0.988765f,  0.988779f,  0.988793f,  0.988808f,  0.988822f,
	 0.988836f,  0.988851f,  0.988865f,  0.988879f,  0.988893f,  0.988908f,  0.988922f,  0.988936f,
	 0.988950f,  0.988964f,  0.988979f,  0.988993f,  0.989007f,  0.989021f,  0.989035f,  0.989050f,
	 0.989064f,  0.989078f,  0.989092f,  0.989106f,  0.989120f,  0.989134f,  0.989148f,  0.989162f,
	 0.989177f,  0.989191f,  0.989205f,  0.989219f,  0.989233f,  0.989247f,  0.989261f,  0.989275f,
	 0.989289f,  0.989303f,  0.989317f,  0.989331f,  0.989345f,  0.989359f,  0.989373f,  0.989386f,
	 0.989400f,  0.989414f,  0.989428f,  0.989442f,  0.989456f,  0.989470f,  0.989484f,  0.989498f,
	 0.989511f,  0.989525f,  0.989539f,  0.989553f,  0.989567f,  0.989581f,  0.989594f,  0.989608f,
	 0.989622f,  0.989636f,  0.989650f,  0.989663f,  0.989677f,  0.989691f,  0.989704f,  0.989718f,
	 0.989732f,  0.989746f,  0.989759f,  0.989773f,  0.989787f,  0.989800f,  0.989814f,  0.989828f,
	 0.989841f,  0.989855f,  0.989869f,  0.989882f,  0.989896f,  0.989909f,  0.989923f,  0.989936f,
	 0.989950f,  0.989964f,  0.989977f,  0.989991f,  0.990004f,  0.990018f,  0.990031f,  0.990045f,
	 0.990058f,  0.990072f,  0.990085f,  0.990099f,  0.990112f,  0.990126f,  0.990139f,  0.990152f,
	 0.990166f,  0.990179f,  0.990193f,  0.990206f,  0.990219f,  0.990233f,  0.990246f,  0.990259f,
	 0.990273f,  0.990286f,  0.990299f,  0.990313f,  0.990326f,  0.990339f,  0.990353f,  0.990366f,
	 0.990379f,  0.990393f,  0.990406f,  0.990419f,  0.990432f,  0.990445f,  0.990459f,  0.990472f,
	 0.990485f,  0.990498f,  0.990511f,  0.990525f,  0.990538f,  0.990551f,  0.990564f,  0.990577f,
	 0.990590f,  0.990603f,  0.990617f,  0.990630f,  0.990643f,  0.990656f,  0.990669f,  0.990682f,
	 0.990695f,  0.990708f,  0.990721f,  0.990734f,  0.990747f,  0.990760f,  0.990773f,  0.990786f,
	 0.990799f,  0.990812f,  0.990825f,  0.990838f,  0.990851f,  0.990864f,  0.990877f,  0.990890f,
	 0.990903f,  0.990916f,  0.990928f,  0.990941f,  0.990954f,  0.990967f,  0.990980f,  0.990993f,
	 0.991006f,  0.991018f,  0.991031f,  0.991044f,  0.991057f,  0.991070f,  0.991082f,  0.991095f,
	 0.991108f,  0.991121f,  0.991133f,  0.991146f,  0.991159f,  0.991172f,  0.991184f,  0.991197f,
	 0.991210f,  0.991222f,  0.991235f,  0.991248f,  0.991260f,  0.991273f,  0.991286f,  0.991298f,
	 0.991311f,  0.991323f,  0.991336f,  0.991349f,  0.991361f,  0.991374f,  0.991386f,  0.991399f,
	 0.991411f,  0.991424f,  0.991437f,  0.991449f,  0.991462f,  0.991474f,  0.991487f,  0.991499f,
	 0.991511f,  0.991524f,  0.991536f,  0.991549f,  0.991561f,  0.991574f,  0.991586f,  0.991598f,
	 0.991611f,  0.991623f,  0.991636f,  0.991648f,  0.991660f,  0.991673f,  0.991685f,  0.991697f,
	 0.991710f,  0.991722f,  0.991734f,  0.991747f,  0.991759f,  0.991771f,  0.991783f,  0.991796f,
	 0.991808f,  0.991820f,  0.991832f,  0.991845f,  0.991857f,  0.991869f,  0.991881f,  0.991894f,
	 0.991906f,  0.991918f,  0.991930f,  0.991942f,  0.991954f,  0.991966f,  0.991979f,  0.991991f,
	 0.992003f,  0.992015f,  0.992027f,  0.992039f,  0.992051f,  0.992063f,  0.992075f,  0.992087f,
	 0.992099f,  0.992111f,  0.992123f,  0.992135f,  0.992147f,  0.992159f,  0.992171f,  0.992183f,
	 0.992195f,  0.992207f,  0.992219f,  0.992231f,  0.992243f,  0.992255f,  0.992267f,  0.992279f,
	 0.992291f,  0.992302f,  0.992314f,  0.992326f,  0.992338f,  0.992350f,  0.992362f,  0.992374f,
	 0.992385f,  0.992397f,  0.992409f,  0.992421f,  0.992433f,  0.992444f,  0.992456f,  0.992468f,
	 0.992480f,  0.992491f,  0.992503f,  0.992515f,  0.992526f,  0.992538f,  0.992550f,  0.992561f,
	 0.992573f,  0.992585f,  0.992596f,  0.992608f,  0.992620f,  0.992631f,  0.992643f,  0.992655f,
	 0.992666f,  0.992678f,  0.992689f,  0.992701f,  0.992712f,  0.992724f,  0.992736f,  0.992747f,
	 0.992759f,  0.992770f,  0.992782f,  0.992793f,  0.992805f,  0.992816f,  0.992828f,  0.992839f,
	 0.992850f,  0.992862f,  0.992873f,  0.992885f,  0.992896f,  0.992908f,  0.992919f,  0.992930f,
	 0.992942f,  0.992953f,  0.992964f,  0.992976f,  0.992987f,  0.992998f,  0.993010f,  0.993021f,
	 0.993032f,  0.993044f,  0.993055f,  0.993066f,  0.993077f,  0.993089f,  0.993100f,  0.993111f,
	 0.993122f,  0.993134f,  0.993145f,  0.993156f,  0.993167f,  0.993178f,  0.993190f,  0.993201f,
	 0.993212f,  0.993223f,  0.993234f,  0.993245f,  0.993257f,  0.993268f,  0.993279f,  0.993290f,
	 0.993301f,  0.993312f,  0.993323f,  0.993334f,  0.993345f,  0.993356f,  0.993367f,  0.993378f,
	 0.993389f,  0.993400f,  0.993411f,  0.993422f,  0.993433f,  0.993444f,  0.993455f,  0.993466f,
	 0.993477f,  0.993488f,  0.993499f,  0.993510f,  0.993521f,  0.993532f,  0.993542f,  0.993553f,
	 0.993564f,  0.993575f,  0.993586f,  0.993597f,  0.993608f,  0.993618f,  0.993629f,  0.993640f,
	 0.993651f,  0.993662f,  0.993672f,  0.993683f,  0.993694f,  0.993705f,  0.993715f,  0.993726f,
	 0.993737f,  0.993747f,  0.993758f,  0.993769f,  0.993779f,  0.993790f,  0.993801f,  0.993811f,
	 0.993822f,  0.993833f,  0.993843f,  0.993854f,  0.993865f,  0.993875f,  0.993886f,  0.993896f,
	 0.993907f,  0.993918f,  0.993928f,  0.993939f,  0.993949f,  0.993960f,  0.993970f,  0.993981f,
	 0.993991f,  0.994002f,  0.994012f,  0.994023f,  0.994033f,  0.994044f,  0.994054f,  0.994064f,
	 0.994075f,  0.994085f,  0.994096f,  0.994106f,  0.994116f,  0.994127f,  0.994137f,  0.994148f,
	 0.994158f,  0.994168f,  0.994179f,  0.994189f,  0.994199f,  0.994210f,  0.994220f,  0.994230f,
	 0.994240f,  0.994251f,  0.994261f,  0.994271f,  0.994281f,  0.994292f,  0.994302f,  0.994312f,
	 0.994322f,  0.994333f,  0.994343f,  0.994353f,  0.994363f,  0.994373f,  0.994383f,  0.994394f,
	 0.994404f,  0.994414f,  0.994424f,  0.994434f,  0.994444f,  0.994454f,  0.994464f,  0.994474f,
	 0.994484f,  0.994494f,  0.994505f,  0.994515f,  0.994525f,  0.994535f,  0.994545f,  0.994555f,
	 0.994565f,  0.994575f,  0.994585f,  0.994594f,  0.994604f,  0.994614f,  0.994624f,  0.994634f,
	 0.994644f,  0.994654f,  0.994664f,  0.994674f,  0.994684f,  0.994694f,  0.994703f,  0.994713f,
	 0.994723f,  0.994733f,  0.994743f,  0.994753f,  0.994762f,  0.994772f,  0.994782f,  0.994792f,
	 0.994802f,  0.994811f,  0.994821f,  0.994831f,  0.994841f,  0.994850f,  0.994860f,  0.994870f,
	 0.994879f,  0.994889f,  0.994899f,  0.994908f,  0.994918f,  0.994928f,  0.994937f,  0.994947f,
	 0.994957f,  0.994966f,  0.994976f,  0.994985f,  0.994995f,  0.995005f,  0.995014f,  0.995024f,
	 0.995033f,  0.995043f,  0.995052f,  0.995062f,  0.995071f,  0.995081f,  0.995090f,  0.995100f,
	 0.995109f,  0.995119f,  0.995128f,  0.995138f,  0.995147f,  0.995156f,  0.995166f,  0.995175f,
	 0.995185f,  0.995194f,  0.995203f,  0.995213f,  0.995222f,  0.995232f,  0.995241f,  0.995250f,
	 0.995260f,  0.995269f,  0.995278f,  0.995288f,  0.995297f,  0.995306f,  0.995315f,  0.995325f,
	 0.995334f,  0.995343f,  0.995352f,  0.995362f,  0.995371f,  0.995380f,  0.995389f,  0.995398f,
	 0.995408f,  0.995417f,  0.995426f,  0.995435f,  0.995444f,  0.995453f,  0.995463f,  0.995472f,
	 0.995481f,  0.995490f,  0.995499f,  0.995508f,  0.995517f,  0.995526f,  0.995535f,  0.995544f,
	 0.995553f,  0.995562f,  0.995571f,  0.995580f,  0.995589f,  0.995598f,  0.995607f,  0.995616f,
	 0.995625f,  0.995634f,  0.995643f,  0.995652f,  0.995661f,  0.995670f,  0.995679f,  0.995688f,
	 0.995697f,  0.995705f,  0.995714f,  0.995723f,  0.995732f,  0.995741f,  0.995750f,  0.995759f,
	 0.995767f,  0.995776f,  0.995785f,  0.995794f,  0.995803f,  0.995811f,  0.995820f,  0.995829f,
	 0.995838f,  0.995846f,  0.995855f,  0.995864f,  0.995872f,  0.995881f,  0.995890f,  0.995899f,
	 0.995907f,  0.995916f,  0.995925f,  0.995933f,  0.995942f,  0.995950f,  0.995959f,  0.995968f,
	 0.995976f,  0.995985f,  0.995993f,  0.996002f,  0.996011f,  0.996019f,  0.996028f,  0.996036f,
	 0.996045f,  0.996053f,  0.996062f,  0.996070f,  0.996079f,  0.996087f,  0.996096f,  0.996104f,
	 0.996113f,  0.996121f,  0.996129f,  0.996138f,  0.996146f,  0.996155f,  0.996163f,  0.996171f,
	 0.996180f,  0.996188f,  0.996197f,  0.996205f,  0.996213f,  0.996222f,  0.996230f,  0.996238f,
	 0.996247f,  0.996255f,  0.996263f,  0.996271f,  0.996280f,  0.996288f,  0.996296f,  0.996304f,
	 0.996313f,  0.996321f,  0.996329f,  0.996337f,  0.996345f,  0.996354f,  0.996362f,  0.996370f,
	 0.996378f,  0.996386f,  0.996394f,  0.996403f,  0.996411f,  0.996419f,  0.996427f,  0.996435f,
	 0.996443f,  0.996451f,  0.996459f,  0.996467f,  0.996475f,  0.996483f,  0.996491f,  0.996499f,
	 0.996507f,  0.996515f,  0.996523f,  0.996531f,  0.996539f,  0.996547f,  0.996555f,  0.996563f,
	 0.996571f,  0.996579f,  0.996587f,  0.996595f,  0.996603f,  0.996611f,  0.996619f,  0.996626f,
	 0.996634f,  0.996642f,  0.996650f,  0.996658f,  0.996666f,  0.996674f,  0.996681f,  0.996689f,
	 0.996697f,  0.996705f,  0.996712f,  0.996720f,  0.996728f,  0.996736f,  0.996743f,  0.996751f,
	 0.996759f,  0.996767f,  0.996774f,  0.996782f,  0.996790f,  0.996797f,  0.996805f,  0.996813f,
	 0.996820f,  0.996828f,  0.996836f,  0.996843f,  0.996851f,  0.996858f,  0.996866f,  0.996874f,
	 0.996881f,  0.996889f,  0.996896f,  0.996904f,  0.996911f,  0.996919f,  0.996926f,  0.996934f,
	 0.996941f,  0.996949f,  0.996956f,  0.996964f,  0.996971f,  0.996979f,  0.996986f,  0.996994f,
	 0.997001f,  0.997008f,  0.997016f,  0.997023f,  0.997031f,  0.997038f,  0.997045f,  0.997053f,
	 0.997060f,  0.997067f,  0.997075f,  0.997082f,  0.997089f,  0.997097f,  0.997104f,  0.997111f,
	 0.997119f,  0.997126f,  0.997133f,  0.997140f,  0.997148f,  0.997155f,  0.997162f,  0.997169f,
	 0.997176f,  0.997184f,  0.997191f,  0.997198f,  0.997205f,  0.997212f,  0.997219f,  0.997227f,
	 0.997234f,  0.997241f,  0.997248f,  0.997255f,  0.997262f,  0.997269f,  0.997276f,  0.997283f,
	 0.997290f,  0.997298f,  0.997305f,  0.997312f,  0.997319f,  0.997326f,  0.997333f,  0.997340f,
	 0.997347f,  0.997354f,  0.997361f,  0.997368f,  0.997374f,  0.997381f,  0.997388f,  0.997395f,
	 0.997402f,  0.997409f,  0.997416f,  0.997423f,  0.997430f,  0.997437f,  0.997443f,  0.997450f,
	 0.997457f,  0.997464f,  0.997471f,  0.997478f,  0.997484f,  0.997491f,  0.997498f,  0.997505f,
	 0.997511f,  0.997518f,  0.997525f,  0.997532f,  0.997538f,  0.997545f,  0.997552f,  0.997559f,
	 0.997565f,  0.997572f,  0.997579f,  0.997585f,  0.997592f,  0.997599f,  0.997605f,  0.997612f,
	 0.997618f,  0.997625f,  0.997632f,  0.997638f,  0.997645f,  0.997651f,  0.997658f,  0.997665f,
	 0.997671f,  0.997678f,  0.997684f,  0.997691f,  0.997697f,  0.997704f,  0.997710f,  0.997717f,
	 0.997723f,  0.997730f,  0.997736f,  0.997742f,  0.997749f,  0.997755f,  0.997762f,  0.997768f,
	 0.997774f,  0.997781f,  0.997787f,  0.997794f,  0.997800f,  0.997806f,  0.997813f,  0.997819f,
	 0.997825f,  0.997832f,  0.997838f,  0.997844f,  0.997851f,  0.997857f,  0.997863f,  0.997869f,
	 0.997876f,  0.997882f,  0.997888f,  0.997894f,  0.997901f,  0.997907f,  0.997913f,  0.997919f,
	 0.997925f,  0.997931f,  0.997938f,  0.997944f,  0.997950f,  0.997956f,  0.997962f,  0.997968f,
	 0.997974f,  0.997980f,  0.997987f,  0.997993f,  0.997999f,  0.998005f,  0.998011f,  0.998017f,
	 0.998023f,  0.998029f,  0.998035f,  0.998041f,  0.998047f,  0.998053f,  0.998059f,  0.998065f,
	 0.998071f,  0.998077f,  0.998083f,  0.998089f,  0.998094f,  0.998100f,  0.998106f,  0.998112f,
	 0.998118f,  0.998124f,  0.998130f,  0.998136f,  0.998142f,  0.998147f,  0.998153f,  0.998159f,
	 0.998165f,  0.998171f,  0.998176f,  0.998182f,  0.998188f,  0.998194f,  0.998200f,  0.998205f,
	 0.998211f,  0.998217f,  0.998222f,  0.998228f,  0.998234f,  0.998240f,  0.998245f,  0.998251f,
	 0.998257f,  0.998262f,  0.998268f,  0.998273f,  0.998279f,  0.998285f,  0.998290f,  0.998296f,
	 0.998302f,  0.998307f,  0.998313f,  0.998318f,  0.998324f,  0.998329f,  0.998335f,  0.998340f,
	 0.998346f,  0.998351f,  0.998357f,  0.998362f,  0.998368f,  0.998373f,  0.998379f,  0.998384f,
	 0.998390f,  0.998395f,  0.998401f,  0.998406f,  0.998411f,  0.998417f,  0.998422f,  0.998428f,
	 0.998433f,  0.998438f,  0.998444f,  0.998449f,  0.998454f,  0.998460f,  0.998465f,  0.998470f,
	 0.998476f,  0.998481f,  0.998486f,  0.998491f,  0.998497f,  0.998502f,  0.998507f,  0.998512f,
	 0.998518f,  0.998523f,  0.998528f,  0.998533f,  0.998538f,  0.998544f,  0.998549f,  0.998554f,
	 0.998559f,  0.998564f,  0.998569f,  0.998574f,  0.998580f,  0.998585f,  0.998590f,  0.998595f,
	 0.998600f,  0.998605f,  0.998610f,  0.998615f,  0.998620f,  0.998625f,  0.998630f,  0.998635f,
	 0.998640f,  0.998645f,  0.998650f,  0.998655f,  0.998660f,  0.998665f,  0.998670f,  0.998675f,
	 0.998680f,  0.998685f,  0.998690f,  0.998695f,  0.998700f,  0.998704f,  0.998709f,  0.998714f,
	 0.998719f,  0.998724f,  0.998729f,  0.998734f,  0.998738f,  0.998743f,  0.998748f,  0.998753f,
	 0.998758f,  0.998762f,  0.998767f,  0.998772f,  0.998777f,  0.998781f,  0.998786f,  0.998791f,
	 0.998795f,  0.998800f,  0.998805f,  0.998810f,  0.998814f,  0.998819f,  0.998824f,  0.998828f,
	 0.998833f,  0.998837f,  0.998842f,  0.998847f,  0.998851f,  0.998856f,  0.998860f,  0.998865f,
	 0.998870f,  0.998874f,  0.998879f,  0.998883f,  0.998888f,  0.998892f,  0.998897f,  0.998901f,
	 0.998906f,  0.998910f,  0.998915f,  0.998919f,  0.998924f,  0.998928f,  0.998932f,  0.998937f,
	 0.998941f,  0.998946f,  0.998950f,  0.998954f,  0.998959f,  0.998963f,  0.998968f,  0.998972f,
	 0.998976f,  0.998981f,  0.998985f,  0.998989f,  0.998994f,  0.998998f,  0.999002f,  0.999006f,
	 0.999011f,  0.999015f,  0.999019f,  0.999023f,  0.999028f,  0.999032f,  0.999036f,  0.999040f,
	 0.999044f,  0.999049f,  0.999053f,  0.999057f,  0.999061f,  0.999065f,  0.999069f,  0.999074f,
	 0.999078f,  0.999082f,  0.999086f,  0.999090f,  0.999094f,  0.999098f,  0.999102f,  0.999106f,
	 0.999110f,  0.999114f,  0.999118f,  0.999122f,  0.999126f,  0.999130f,  0.999134f,  0.999138f,
	 0.999142f,  0.999146f,  0.999150f,  0.999154f,  0.999158f,  0.999162f,  0.999166f,  0.999170f,
	 0.999174f,  0.999178f,  0.999182f,  0.999186f,  0.999189f,  0.999193f,  0.999197f,  0.999201f,
	 0.999205f,  0.999209f,  0.999212f,  0.999216f,  0.999220f,  0.999224f,  0.999228f,  0.999231f,
	 0.999235f,  0.999239f,  0.999243f,  0.999246f,  0.999250f,  0.999254f,  0.999257f,  0.999261f,
	 0.999265f,  0.999268f,  0.999272f,  0.999276f,  0.999279f,  0.999283f,  0.999287f,  0.999290f,
	 0.999294f,  0.999297f,  0.999301f,  0.999305f,  0.999308f,  0.999312f,  0.999315f,  0.999319f,
	 0.999322f,  0.999326f,  0.999329f,  0.999333f,  0.999336f,  0.999340f,  0.999343f,  0.999347f,
	 0.999350f,  0.999354f,  0.999357f,  0.999361f,  0.999364f,  0.999367f,  0.999371f,  0.999374f,
	 0.999378f,  0.999381f,  0.999384f,  0.999388f,  0.999391f,  0.999394f,  0.999398f,  0.999401f,
	 0.999404f,  0.999408f,  0.999411f,  0.999414f,  0.999418f,  0.999421f,  0.999424f,  0.999427f,
	 0.999431f,  0.999434f,  0.999437f,  0.999440f,  0.999443f,  0.999447f,  0.999450f,  0.999453f,
	 0.999456f,  0.999459f,  0.999462f,  0.999466f,  0.999469f,  0.999472f,  0.999475f,  0.999478f,
	 0.999481f,  0.999484f,  0.999487f,  0.999490f,  0.999493f,  0.999497f,  0.999500f,  0.999503f,
	 0.999506f,  0.999509f,  0.999512f,  0.999515f,  0.999518f,  0.999521f,  0.999524f,  0.999527f,
	 0.999529f,  0.999532f,  0.999535f,  0.999538f,  0.999541f,  0.999544f,  0.999547f,  0.999550f,
	 0.999553f,  0.999556f,  0.999558f,  0.999561f,  0.999564f,  0.999567f,  0.999570f,  0.999573f,
	 0.999575f,  0.999578f,  0.999581f,  0.999584f,  0.999586f,  0.999589f,  0.999592f,  0.999595f,
	 0.999597f,  0.999600f,  0.999603f,  0.999605f,  0.999608f,  0.999611f,  0.999614f,  0.999616f,
	 0.999619f,  0.999621f,  0.999624f,  0.999627f,  0.999629f,  0.999632f,  0.999635f,  0.999637f,
	 0.999640f,  0.999642f,  0.999645f,  0.999647f,  0.999650f,  0.999652f,  0.999655f,  0.999658f,
	 0.999660f,  0.999663f,  0.999665f,  0.999667f,  0.999670f,  0.999672f,  0.999675f,  0.999677f,
	 0.999680f,  0.999682f,  0.999685f,  0.999687f,  0.999689f,  0.999692f,  0.999694f,  0.999696f,
	 0.999699f,  0.999701f,  0.999704f,  0.999706f,  0.999708f,  0.999710f,  0.999713f,  0.999715f,
	 0.999717f,  0.999720f,  0.999722f,  0.999724f,  0.999726f,  0.999729f,  0.999731f,  0.999733f,
	 0.999735f,  0.999738f,  0.999740f,  0.999742f,  0.999744f,  0.999746f,  0.999748f,  0.999750f,
	 0.999753f,  0.999755f,  0.999757f,  0.999759f,  0.999761f,  0.999763f,  0.999765f,  0.999767f,
	 0.999769f,  0.999771f,  0.999774f,  0.999776f,  0.999778f,  0.999780f,  0.999782f,  0.999784f,
	 0.999786f,  0.999788f,  0.999790f,  0.999792f,  0.999793f,  0.999795f,  0.999797f,  0.999799f,
	 0.999801f,  0.999803f,  0.999805f,  0.999807f,  0.999809f,  0.999811f,  0.999812f,  0.999814f,
	 0.999816f,  0.999818f,  0.999820f,  0.999822f,  0.999823f,  0.999825f,  0.999827f,  0.999829f,
	 0.999831f,  0.999832f,  0.999834f,  0.999836f,  0.999838f,  0.999839f,  0.999841f,  0.999843f,
	 0.999844f,  0.999846f,  0.999848f,  0.999849f,  0.999851f,  0.999853f,  0.999854f,  0.999856f,
	 0.999858f,  0.999859f,  0.999861f,  0.999862f,  0.999864f,  0.999866f,  0.999867f,  0.999869f,
	 0.999870f,  0.999872f,  0.999873f,  0.999875f,  0.999876f,  0.999878f,  0.999879f,  0.999881f,
	 0.999882f,  0.999884f,  0.999885f,  0.999887f,  0.999888f,  0.999890f,  0.999891f,  0.999892f,
	 0.999894f,  0.999895f,  0.999897f,  0.999898f,  0.999899f,  0.999901f,  0.999902f,  0.999903f,
	 0.999905f,  0.999906f,  0.999907f,  0.999909f,  0.999910f,  0.999911f,  0.999913f,  0.999914f,
	 0.999915f,  0.999916f,  0.999917f,  0.999919f,  0.999920f,  0.999921f,  0.999922f,  0.999924f,
	 0.999925f,  0.999926f,  0.999927f,  0.999928f,  0.999929f,  0.999930f,  0.999932f,  0.999933f,
	 0.999934f,  0.999935f,  0.999936f,  0.999937f,  0.999938f,  0.999939f,  0.999940f,  0.999941f,
	 0.999942f,  0.999943f,  0.999944f,  0.999945f,  0.999946f,  0.999947f,  0.999948f,  0.999949f,
	 0.999950f,  0.999951f,  0.999952f,  0.999953f,  0.999954f,  0.999955f,  0.999956f,  0.999957f,
	 0.999958f,  0.999959f,  0.999959f,  0.999960f,  0.999961f,  0.999962f,  0.999963f,  0.999964f,
	 0.999964f,  0.999965f,  0.999966f,  0.999967f,  0.999968f,  0.999968f,  0.999969f,  0.999970f,
	 0.999971f,  0.999971f,  0.999972f,  0.999973f,  0.999973f,  0.999974f,  0.999975f,  0.999976f,
	 0.999976f,  0.999977f,  0.999977f,  0.999978f,  0.999979f,  0.999979f,  0.999980f,  0.999981f,
	 0.999981f,  0.999982f,  0.999982f,  0.999983f,  0.999983f,  0.999984f,  0.999985f,  0.999985f,
	 0.999986f,  0.999986f,  0.999987f,  0.999987f,  0.999988f,  0.999988f,  0.999988f,  0.999989f,
	 0.999989f,  0.999990f,  0.999990f,  0.999991f,  0.999991f,  0.999991f,  0.999992f,  0.999992f,
	 0.999993f,  0.999993f,  0.999993f,  0.999994f,  0.999994f,  0.999994f,  0.999995f,  0.999995f,
	 0.999995f,  0.999996f,  0.999996f,  0.999996f,  0.999996f,  0.999997f,  0.999997f,  0.999997f,
	 0.999997f,  0.999998f,  0.999998f,  0.999998f,  0.999998f,  0.999998f,  0.999999f,  0.999999f,
	 0.999999f,  0.999999f,  0.999999f,  0.999999f,  0.999999f,  0.999999f,  1.000000f,  1.000000f,
	 1.000000f,  1.000000f,  1.000000f,  1.000000f,  1.000000f,  1.000000f,  1.000000f,  1.000000f,
	 0.000000f, -0.000096f, -0.000192f, -0.000288f, -0.000383f, -0.000479f, -0.000575f, -0.000671f,
	-0.000767f, -0.000863f, -0.000959f, -0.001055f, -0.001150f, -0.001246f, -0.001342f, -0.001438f,
	-0.001534f, -0.001630f, -0.001726f, -0.001822f, -0.001917f, -0.002013f, -0.002109f, -0.002205f,
	-0.002301f, -0.002397f, -0.002493f, -0.002589f, -0.002684f, -0.002780f, -0.002876f, -0.002972f,
	-0.003068f, -0.003164f, -0.003260f, -0.003356f, -0.003451f, -0.003547f, -0.003643f, -0.003739f,
	-0.003835f, -0.003931f, -0.004027f, -0.004123f, -0.004218f, -0.004314f, -0.004410f, -0.004506f,
	-0.004602f, -0.004698f, -0.004794f, -0.004890f, -0.004985f, -0.005081f, -0.005177f, -0.005273f,
	-0.005369f, -0.005465f, -0.005561f, -0.005657f, -0.005752f, -0.005848f, -0.005944f, -0.006040f,
	-0.006136f, -0.006232f, -0.006328f, -0.006424f, -0.006519f, -0.006615f, -0.006711f, -0.006807f,
	-0.006903f, -0.006999f, -0.007095f, -0.007190f, -0.007286f, -0.007382f, -0.007478f, -0.007574f,
	-0.007670f, -0.007766f, -0.007862f, -0.007957f, -0.008053f, -0.008149f, -0.008245f, -0.008341f,
	-0.008437f, -0.008533f, -0.008629f, -0.008724f, -0.008820f, -0.008916f, -0.009012f, -0.009108f,
	-0.009204f, -0.009300f, -0.009395f, -0.009491f, -0.009587f, -0.009683f, -0.009779f, -0.009875f,
	-0.009971f, -0.010067f, -0.010162f, -0.010258f, -0.010354f, -0.010450f, -0.010546f, -0.010642f,
	-0.010738f, -0.010834f, -0.010929f, -0.011025f, -0.011121f, -0.011217f, -0.011313f, -0.011409f,
	-0.011505f, -0.011600f, -0.011696f, -0.011792f, -0.011888f, -0.011984f, -0.012080f, -0.012176f,
	-0.012272f, -0.012367f, -0.012463f, -0.012559f, -0.012655f, -0.012751f, -0.012847f, -0.012943f,
	-0.013038f, -0.013134f, -0.013230f, -0.013326f, -0.013422f, -0.013518f, -0.013614f, -0.013710f,
	-0.013805f, -0.013901f, -0.013997f, -0.014093f, -0.014189f, -0.014285f, -0.014381f, -0.014476f,
	-0.014572f, -0.014668f, -0.014764f, -0.014860f, -0.014956f, -0.015052f, -0.015147f, -0.015243f,
	-0.015339f, -0.015435f, -0.015531f, -0.015627f, -0.015723f, -0.015819f, -0.015914f, -0.016010f,
	-0.016106f, -0.016202f, -0.016298f, -0.016394f, -0.016490f, -0.016585f, -0.016681f, -0.016777f,
	-0.016873f, -0.016969f, -0.017065f, -0.017161f, -0.017256f, -0.017352f, -0.017448f, -0.017544f,
	-0.017640f, -0.017736f, -0.017832f, -0.017927f, -0.018023f, -0.018119f, -0.018215f, -0.018311f,
	-0.018407f, -0.018503f, -0.018598f, -0.018694f, -0.018790f, -0.018886f, -0.018982f, -0.019078f,
	-0.019174f, -0.019269f, -0.019365f, -0.019461f, -0.019557f, -0.019653f, -0.019749f, -0.019845f,
	-0.019940f, -0.020036f, -0.020132f, -0.020228f, -0.020324f, -0.020420f, -0.020516f, -0.020611f,
	-0.020707f, -0.020803f, -0.020899f, -0.020995f, -0.021091f, -0.021187f, -0.021282f, -0.021378f,
	-0.021474f, -0.021570f, -0.021666f, -0.021762f, -0.021857f, -0.021953f, -0.022049f, -0.022145f,
	-0.022241f, -0.022337f, -0.022433f, -0.022528f, -0.022624f, -0.022720f, -0.022816f, -0.022912f,
	-0.023008f, -0.023104f, -0.023199f, -0.023295f, -0.023391f, -0.023487f, -0.023583f, -0.023679f,
	-0.023774f, -0.023870f, -0.023966f, -0.024062f, -0.024158f, -0.024254f, -0.024350f, -0.024445f,
	-0.024541f, -0.024637f, -0.024733f, -0.024829f, -0.024925f, -0.025020f, -0.025116f, -0.025212f,
	-0.025308f, -0.025404f, -0.025500f, -0.025596f, -0.025691f, -0.025787f, -0.025883f, -0.025979f,
	-0.026075f, -0.026171f, -0.026266f, -0.026362f, -0.026458f, -0.026554f, -0.026650f, -0.026746f,
	-0.026841f, -0.026937f, -0.027033f, -0.027129f, -0.027225f, -0.027321f, -0.027416f, -0.027512f,
	-0.027608f, -0.027704f, -0.027800f, -0.027896f, -0.027991f, -0.028087f, -0.028183f, -0.028279f,
	-0.028375f, -0.028471f, -0.028567f, -0.028662f, -0.028758f, -0.028854f, -0.028950f, -0.029046f,
	-0.029142f, -0.029237f, -0.029333f, -0.029429f, -0.029525f, -0.029621f, -0.029717f, -0.029812f,
	-0.029908f, -0.030004f, -0.030100f, -0.030196f, -0.030291f, -0.030387f, -0.030483f, -0.030579f,
	-0.030675f, -0.030771f, -0.030866f, -0.030962f, -0.031058f, -0.031154f, -0.031250f, -0.031346f,
	-0.031441f, -0.031537f, -0.031633f, -0.031729f, -0.031825f, -0.031921f, -0.032016f, -0.032112f,
	-0.032208f, -0.032304f, -0.032400f, -0.032495f, -0.032591f, -0.032687f, -0.032783f, -0.032879f,
	-0.032975f, -0.033070f, -0.033166f, -0.033262f, -0.033358f, -0.033454f, -0.033550f, -0.033645f,
	-0.033741f, -0.033837f, -0.033933f, -0.034029f, -0.034124f, -0.034220f, -0.034316f, -0.034412f,
	-0.034508f, -0.034604f, -0.034699f, -0.034795f, -0.034891f, -0.034987f, -0.035083f, -0.035178f,
	-0.035274f, -0.035370f, -0.035466f, -0.035562f, -0.035657f, -0.035753f, -0.035849f, -0.035945f,
	-0.036041f, -0.036137f, -0.036232f, -0.036328f, -0.036424f, -0.036520f, -0.036616f, -0.036711f,
	-0.036807f, -0.036903f, -0.036999f, -0.037095f, -0.037190f, -0.037286f, -0.037382f, -0.037478f,
	-0.037574f, -0.037669f, -0.037765f, -0.037861f, -0.037957f, -0.038053f, -0.038149f, -0.038244f,
	-0.038340f, -0.038436f, -0.038532f, -0.038628f, -0.038723f, -0.038819f, -0.038915f, -0.039011f,
	-0.039107f, -0.039202f, -0.039298f, -0.039394f, -0.039490f, -0.039586f, -0.039681f, -0.039777f,
	-0.039873f, -0.039969f, -0.040065f, -0.040160f, -0.040256f, -0.040352f, -0.040448f, -0.040544f,
	-0.040639f, -0.040735f, -0.040831f, -0.040927f, -0.041022f, -0.041118f, -0.041214f, -0.041310f,
	-0.041406f, -0.041501f, -0.041597f, -0.041693f, -0.041789f, -0.041885f, -0.041980f, -0.042076f,
	-0.042172f, -0.042268f, -0.042364f, -0.042459f, -0.042555f, -0.042651f, -0.042747f, -0.042842f,
	-0.042938f, -0.043034f, -0.043130f, -0.043226f, -0.043321f, -0.043417f, -0.043513f, -0.043609f,
	-0.043705f, -0.043800f, -0.043896f, -0.043992f, -0.044088f, -0.044183f, -0.044279f, -0.044375f,
	-0.044471f, -0.044567f, -0.044662f, -0.044758f, -0.044854f, -0.044950f, -0.045045f, -0.045141f,
	-0.045237f, -0.045333f, -0.045429f, -0.045524f, -0.045620f, -0.045716f, -0.045812f, -0.045907f,
	-0.046003f, -0.046099f, -0.046195f, -0.046290f, -0.046386f, -0.046482f, -0.046578f, -0.046674f,
	-0.046769f, -0.046865f, -0.046961f, -0.047057f, -0.047152f, -0.047248f, -0.047344f, -0.047440f,
	-0.047535f, -0.047631f, -0.047727f, -0.047823f, -0.047919f, -0.048014f, -0.048110f, -0.048206f,
	-0.048302f, -0.048397f, -0.048493f, -0.048589f, -0.048685f, -0.048780f, -0.048876f, -0.048972f,
	-0.049068f, -0.049163f, -0.049259f, -0.049355f, -0.049451f, -0.049546f, -0.049642f, -0.049738f,
	-0.049834f, -0.049929f, -0.050025f, -0.050121f, -0.050217f, -0.050312f, -0.050408f, -0.050504f,
	-0.050600f, -0.050696f, -0.050791f, -0.050887f, -0.050983f, -0.051078f, -0.051174f, -0.051270f,
	-0.051366f, -0.051461f, -0.051557f, -0.051653f, -0.051749f, -0.051844f, -0.051940f, -0.052036f,
	-0.052132f, -0.052227f, -0.052323f, -0.052419f, -0.052515f, -0.052610f, -0.052706f, -0.052802f,
	-0.052898f, -0.052993f, -0.053089f, -0.053185f, -0.053281f, -0.053376f, -0.053472f, -0.053568f,
	-0.053664f, -0.053759f, -0.053855f, -0.053951f, -0.054046f, -0.054142f, -0.054238f, -0.054334f,
	-0.054429f, -0.054525f, -0.054621f, -0.054717f, -0.054812f, -0.054908f, -0.055004f, -0.055100f,
	-0.055195f, -0.055291f, -0.055387f, -0.055482f, -0.055578f, -0.055674f, -0.055770f, -0.055865f,
	-0.055961f, -0.056057f, -0.056152f, -0.056248f, -0.056344f, -0.056440f, -0.056535f, -0.056631f,
	-0.056727f, -0.056823f, -0.056918f, -0.057014f, -0.057110f, -0.057205f, -0.057301f, -0.057397f,
	-0.057493f, -0.057588f, -0.057684f, -0.057780f, -0.057875f, -0.057971f, -0.058067f, -0.058163f,
	-0.058258f, -0.058354f, -0.058450f, -0.058545f, -0.058641f, -0.058737f, -0.058833f, -0.058928f,
	-0.059024f, -0.059120f, -0.059215f, -0.059311f, -0.059407f, -0.059502f, -0.059598f, -0.059694f,
	-0.059790f, -0.059885f, -0.059981f, -0.060077f, -0.060172f, -0.060268f, -0.060364f, -0.060459f,
	-0.060555f, -0.060651f, -0.060747f, -0.060842f, -0.060938f, -0.061034f, -0.061129f, -0.061225f,
	-0.061321f, -0.061416f, -0.061512f, -0.061608f, -0.061704f, -0.061799f, -0.061895f, -0.061991f,
	-0.062086f, -0.062182f, -0.062278f, -0.062373f, -0.062469f, -0.062565f, -0.062660f, -0.062756f,
	-0.062852f, -0.062947f, -0.063043f, -0.063139f, -0.063234f, -0.063330f, -0.063426f, -0.063522f,
	-0.063617f, -0.063713f, -0.063809f, -0.063904f, -0.064000f, -0.064096f, -0.064191f, -0.064287f,
	-0.064383f, -0.064478f, -0.064574f, -0.064670f, -0.064765f, -0.064861f, -0.064957f, -0.065052f,
	-0.065148f, -0.065244f, -0.065339f, -0.065435f, -0.065531f, -0.065626f, -0.065722f, -0.065818f,
	-0.065913f, -0.066009f, -0.066105f, -0.066200f, -0.066296f, -0.066392f, -0.066487f, -0.066583f,
	-0.066679f, -0.066774f, -0.066870f, -0.066966f, -0.067061f, -0.067157f, -0.067253f, -0.067348f,
	-0.067444f, -0.067540f, -0.067635f, -0.067731f, -0.067827f, -0.067922f, -0.068018f, -0.068113f,
	-0.068209f, -0.068305f, -0.068400f, -0.068496f, -0.068592f, -0.068687f, -0.068783f, -0.068879f,
	-0.068974f, -0.069070f, -0.069166f, -0.069261f, -0.069357f, -0.069453f, -0.069548f, -0.069644f,
	-0.069739f, -0.069835f, -0.069931f, -0.070026f, -0.070122f, -0.070218f, -0.070313f, -0.070409f,
	-0.070505f, -0.070600f, -0.070696f, -0.070791f, -0.070887f, -0.070983f, -0.071078f, -0.071174f,
	-0.071270f, -0.071365f, -0.071461f, -0.071557f, -0.071652f, -0.071748f, -0.071843f, -0.071939f,
	-0.072035f, -0.072130f, -0.072226f, -0.072322f, -0.072417f, -0.072513f, -0.072608f, -0.072704f,
	-0.072800f, -0.072895f, -0.072991f, -0.073086f, -0.073182f, -0.073278f, -0.073373f, -0.073469f,
	-0.073565f, -0.073660f, -0.073756f, -0.073851f, -0.073947f, -0.074043f, -0.074138f, -0.074234f,
	-0.074329f, -0.074425f, -0.074521f, -0.074616f, -0.074712f, -0.074807f, -0.074903f, -0.074999f,
	-0.075094f, -0.075190f, -0.075286f, -0.075381f, -0.075477f, -0.075572f, -0.075668f, -0.075764f,
	-0.075859f, -0.075955f, -0.076050f, -0.076146f, -0.076241f, -0.076337f, -0.076433f, -0.076528f,
	-0.076624f, -0.076719f, -0.076815f, -0.076911f, -0.077006f, -0.077102f, -0.077197f, -0.077293f,
	-0.077389f, -0.077484f, -0.077580f, -0.077675f, -0.077771f, -0.077866f, -0.077962f, -0.078058f,
	-0.078153f, -0.078249f, -0.078344f, -0.078440f, -0.078536f, -0.078631f, -0.078727f, -0.078822f,
	-0.078918f, -0.079013f, -0.079109f, -0.079205f, -0.079300f, -0.079396f, -0.079491f, -0.079587f,
	-0.079682f, -0.079778f, -0.079874f, -0.079969f, -0.080065f, -0.080160f, -0.080256f, -0.080351f,
	-0.080447f, -0.080543f, -0.080638f, -0.080734f, -0.080829f, -0.080925f, -0.081020f, -0.081116f,
	-0.081211f, -0.081307f, -0.081403f, -0.081498f, -0.081594f, -0.081689f, -0.081785f, -0.081880f,
	-0.081976f, -0.082071f, -0.082167f, -0.082263f, -0.082358f, -0.082454f, -0.082549f, -0.082645f,
	-0.082740f, -0.082836f, -0.082931f, -0.083027f, -0.083122f, -0.083218f, -0.083314f, -0.083409f,
	-0.083505f, -0.083600f, -0.083696f, -0.083791f, -0.083887f, -0.083982f, -0.084078f, -0.084173f,
	-0.084269f, -0.084364f, -0.084460f, -0.084555f, -0.084651f, -0.084747f, -0.084842f, -0.084938f,
	-0.085033f, -0.085129f, -0.085224f, -0.085320f, -0.085415f, -0.085511f, -0.085606f, -0.085702f,
	-0.085797f, -0.085893f, -0.085988f, -0.086084f, -0.086179f, -0.086275f, -0.086370f, -0.086466f,
	-0.086561f, -0.086657f, -0.086752f, -0.086848f, -0.086943f, -0.087039f, -0.087135f, -0.087230f,
	-0.087326f, -0.087421f, -0.087517f, -0.087612f, -0.087708f, -0.087803f, -0.087899f, -0.087994f,
	-0.088090f, -0.088185f, -0.088281f, -0.088376f, -0.088472f, -0.088567f, -0.088663f, -0.088758f,
	-0.088854f, -0.088949f, -0.089045f, -0.089140f, -0.089236f, -0.089331f, -0.089427f, -0.089522f,
	-0.089617f, -0.089713f, -0.089808f, -0.089904f, -0.089999f, -0.090095f, -0.090190f, -0.090286f,
	-0.090381f, -0.090477f, -0.090572f, -0.090668f, -0.090763f, -0.090859f, -0.090954f, -0.091050f,
	-0.091145f, -0.091241f, -0.091336f, -0.091432f, -0.091527f, -0.091623f, -0.091718f, -0.091813f,
	-0.091909f, -0.092004f, -0.092100f, -0.092195f, -0.092291f, -0.092386f, -0.092482f, -0.092577f,
	-0.092673f, -0.092768f, -0.092864f, -0.092959f, -0.093055f, -0.093150f, -0.093245f, -0.093341f,
	-0.093436f, -0.093532f, -0.093627f, -0.093723f, -0.093818f, -0.093914f, -0.094009f, -0.094104f,
	-0.094200f, -0.094295f, -0.094391f, -0.094486f, -0.094582f, -0.094677f, -0.094773f, -0.094868f,
	-0.094963f, -0.095059f, -0.095154f, -0.095250f, -0.095345f, -0.095441f, -0.095536f, -0.095632f,
	-0.095727f, -0.095822f, -0.095918f, -0.096013f, -0.096109f, -0.096204f, -0.096300f, -0.096395f,
	-0.096490f, -0.096586f, -0.096681f, -0.096777f, -0.096872f, -0.096968f, -0.097063f, -0.097158f,
	-0.097254f, -0.097349f, -0.097445f, -0.097540f, -0.097635f, -0.097731f, -0.097826f, -0.097922f,
	-0.098017f, -0.098113f, -0.098208f, -0.098303f, -0.098399f, -0.098494f, -0.098590f, -0.098685f,
	-0.098780f, -0.098876f, -0.098971f, -0.099067f, -0.099162f, -0.099257f, -0.099353f, -0.099448f,
	-0.099544f, -0.099639f, -0.099734f, -0.099830f, -0.099925f, -0.100021f, -0.100116f, -0.100211f,
	-0.100307f, -0.100402f, -0.100498f, -0.100593f, -0.100688f, -0.100784f, -0.100879f, -0.100974f,
	-0.101070f, -0.101165f, -0.101261f, -0.101356f, -0.101451f, -0.101547f, -0.101642f, -0.101738f,
	-0.101833f, -0.101928f, -0.102024f, -0.102119f, -0.102214f, -0.102310f, -0.102405f, -0.102500f,
	-0.102596f, -0.102691f, -0.102787f, -0.102882f, -0.102977f, -0.103073f, -0.103168f, -0.103263f,
	-0.103359f, -0.103454f, -0.103550f, -0.103645f, -0.103740f, -0.103836f, -0.103931f, -0.104026f,
	-0.104122f, -0.104217f, -0.104312f, -0.104408f, -0.104503f, -0.104598f, -0.104694f, -0.104789f,
	-0.104884f, -0.104980f, -0.105075f, -0.105170f, -0.105266f, -0.105361f, -0.105456f, -0.105552f,
	-0.105647f, -0.105742f, -0.105838f, -0.105933f, -0.106028f, -0.106124f, -0.106219f, -0.106314f,
	-0.106410f, -0.106505f, -0.106600f, -0.106696f, -0.106791f, -0.106886f, -0.106982f, -0.107077f,
	-0.107172f, -0.107268f, -0.107363f, -0.107458f, -0.107554f, -0.107649f, -0.107744f, -0.107840f,
	-0.107935f, -0.108030f, -0.108126f, -0.108221f, -0.108316f, -0.108412f, -0.108507f, -0.108602f,
	-0.108697f, -0.108793f, -0.108888f, -0.108983f, -0.109079f, -0.109174f, -0.109269f, -0.109365f,
	-0.109460f, -0.109555f, -0.109650f, -0.109746f, -0.109841f, -0.109936f, -0.110032f, -0.110127f,
	-0.110222f, -0.110317f, -0.110413f, -0.110508f, -0.110603f, -0.110699f, -0.110794f, -0.110889f,
	-0.110984f, -0.111080f, -0.111175f, -0.111270f, -0.111366f, -0.111461f, -0.111556f, -0.111651f,
	-0.111747f, -0.111842f, -0.111937f, -0.112033f, -0.112128f, -0.112223f, -0.112318f, -0.112414f,
	-0.112509f, -0.112604f, -0.112699f, -0.112795f, -0.112890f, -0.112985f, -0.113080f, -0.113176f,
	-0.113271f, -0.113366f, -0.113461f, -0.113557f, -0.113652f, -0.113747f, -0.113842f, -0.113938f,
	-0.114033f, -0.114128f, -0.114223f, -0.114319f, -0.114414f, -0.114509f, -0.114604f, -0.114700f,
	-0.114795f, -0.114890f, -0.114985f, -0.115081f, -0.115176f, -0.115271f, -0.115366f, -0.115462f,
	-0.115557f, -0.115652f, -0.115747f, -0.115842f, -0.115938f, -0.116033f, -0.116128f, -0.116223f,
	-0.116319f, -0.116414f, -0.116509f, -0.116604f, -0.116700f, -0.116795f, -0.116890f, -0.116985f,
	-0.117080f, -0.117176f, -0.117271f, -0.117366f, -0.117461f, -0.117556f, -0.117652f, -0.117747f,
	-0.117842f, -0.117937f, -0.118032f, -0.118128f, -0.118223f, -0.118318f, -0.118413f, -0.118508f,
	-0.118604f, -0.118699f, -0.118794f, -0.118889f, -0.118984f, -0.119080f, -0.119175f, -0.119270f,
	-0.119365f, -0.119460f, -0.119556f, -0.119651f, -0.119746f, -0.119841f, -0.119936f, -0.120032f,
	-0.120127f, -0.120222f, -0.120317f, -0.120412f, -0.120507f, -0.120603f, -0.120698f, -0.120793f,
	-0.120888f, -0.120983f, -0.121078f, -0.121174f, -0.121269f, -0.121364f, -0.121459f, -0.121554f,
	-0.121649f, -0.121745f, -0.121840f, -0.121935f, -0.122030f, -0.122125f, -0.122220f, -0.122316f,
	-0.122411f, -0.122506f, -0.122601f, -0.122696f, -0.122791f, -0.122886f, -0.122982f, -0.123077f,
	-0.123172f, -0.123267f, -0.123362f, -0.123457f, -0.123552f, -0.123648f, -0.123743f, -0.123838f,
	-0.123933f, -0.124028f, -0.124123f, -0.124218f, -0.124314f, -0.124409f, -0.124504f, -0.124599f,
	-0.124694f, -0.124789f, -0.124884f, -0.124979f, -0.125075f, -0.125170f, -0.125265f, -0.125360f,
	-0.125455f, -0.125550f, -0.125645f, -0.125740f, -0.125835f, -0.125931f, -0.126026f, -0.126121f,
	-0.126216f, -0.126311f, -0.126406f, -0.126501f, -0.126596f, -0.126691f, -0.126787f, -0.126882f,
	-0.126977f, -0.127072f, -0.127167f, -0.127262f, -0.127357f, -0.127452f, -0.127547f, -0.127642f,
	-0.127737f, -0.127833f, -0.127928f, -0.128023f, -0.128118f, -0.128213f, -0.128308f, -0.128403f,
	-0.128498f, -0.128593f, -0.128688f, -0.128783f, -0.128878f, -0.128973f, -0.129069f, -0.129164f,
	-0.129259f, -0.129354f, -0.129449f, -0.129544f, -0.129639f, -0.129734f, -0.129829f, -0.129924f,
	-0.130019f, -0.130114f, -0.130209f, -0.130304f, -0.130399f, -0.130495f, -0.130590f, -0.130685f,
	-0.130780f, -0.130875f, -0.130970f, -0.131065f, -0.131160f, -0.131255f, -0.131350f, -0.131445f,
	-0.131540f, -0.131635f, -0.131730f, -0.131825f, -0.131920f, -0.132015f, -0.132110f, -0.132205f,
	-0.132300f, -0.132395f, -0.132490f, -0.132585f, -0.132680f, -0.132775f, -0.132870f, -0.132966f,
	-0.133061f, -0.133156f, -0.133251f, -0.133346f, -0.133441f, -0.133536f, -0.133631f, -0.133726f,
	-0.133821f, -0.133916f, -0.134011f, -0.134106f, -0.134201f, -0.134296f, -0.134391f, -0.134486f,
	-0.134581f, -0.134676f, -0.134771f, -0.134866f, -0.134961f, -0.135056f, -0.135151f, -0.135246f,
	-0.135341f, -0.135436f, -0.135531f, -0.135626f, -0.135721f, -0.135816f, -0.135911f, -0.136006f,
	-0.136101f, -0.136196f, -0.136291f, -0.136386f, -0.136480f, -0.136575f, -0.136670f, -0.136765f,
	-0.136860f, -0.136955f, -0.137050f, -0.137145f, -0.137240f, -0.137335f, -0.137430f, -0.137525f,
	-0.137620f, -0.137715f, -0.137810f, -0.137905f, -0.138000f, -0.138095f, -0.138190f, -0.138285f,
	-0.138380f, -0.138475f, -0.138570f, -0.138665f, -0.138760f, -0.138855f, -0.138949f, -0.139044f,
	-0.139139f, -0.139234f, -0.139329f, -0.139424f, -0.139519f, -0.139614f, -0.139709f, -0.139804f,
	-0.139899f, -0.139994f, -0.140089f, -0.140184f, -0.140279f, -0.140373f, -0.140468f, -0.140563f,
	-0.140658f, -0.140753f, -0.140848f, -0.140943f, -0.141038f, -0.141133f, -0.141228f, -0.141323f,
	-0.141418f, -0.141512f, -0.141607f, -0.141702f, -0.141797f, -0.141892f, -0.141987f, -0.142082f,
	-0.142177f, -0.142272f, -0.142367f, -0.142461f, -0.142556f, -0.142651f, -0.142746f, -0.142841f,
	-0.142936f, -0.143031f, -0.143126f, -0.143221f, -0.143316f, -0.143410f, -0.143505f, -0.143600f,
	-0.143695f, -0.143790f, -0.143885f, -0.143980f, -0.144075f, -0.144169f, -0.144264f, -0.144359f,
	-0.144454f, -0.144549f, -0.144644f, -0.144739f, -0.144833f, -0.144928f, -0.145023f, -0.145118f,
	-0.145213f, -0.145308f, -0.145403f, -0.145497f, -0.145592f, -0.145687f, -0.145782f, -0.145877f,
	-0.145972f, -0.146067f, -0.146161f, -0.146256f, -0.146351f, -0.146446f, -0.146541f, -0.146636f,
	-0.146730f, -0.146825f, -0.146920f, -0.147015f, -0.147110f, -0.147205f, -0.147299f, -0.147394f,
	-0.147489f, -0.147584f, -0.147679f, -0.147774f, -0.147868f, -0.147963f, -0.148058f, -0.148153f,
	-0.148248f, -0.148342f, -0.148437f, -0.148532f, -0.148627f, -0.148722f, -0.148817f, -0.148911f,
	-0.149006f, -0.149101f, -0.149196f, -0.149291f, -0.149385f, -0.149480f, -0.149575f, -0.149670f,
	-0.149765f, -0.149859f, -0.149954f, -0.150049f, -0.150144f, -0.150238f, -0.150333f, -0.150428f,
	-0.150523f, -0.150618f, -0.150712f, -0.150807f, -0.150902f, -0.150997f, -0.151092f, -0.151186f,
	-0.151281f, -0.151376f, -0.151471f, -0.151565f, -0.151660f, -0.151755f, -0.151850f, -0.151944f,
	-0.152039f, -0.152134f, -0.152229f, -0.152323f, -0.152418f, -0.152513f, -0.152608f, -0.152702f,
	-0.152797f, -0.152892f, -0.152987f, -0.153081f, -0.153176f, -0.153271f, -0.153366f, -0.153460f,
	-0.153555f, -0.153650f, -0.153745f, -0.153839f, -0.153934f, -0.154029f, -0.154124f, -0.154218f,
	-0.154313f, -0.154408f, -0.154502f, -0.154597f, -0.154692f, -0.154787f, -0.154881f, -0.154976f,
	-0.155071f, -0.155165f, -0.155260f, -0.155355f, -0.155450f, -0.155544f, -0.155639f, -0.155734f,
	-0.155828f, -0.155923f, -0.156018f, -0.156112f, -0.156207f, -0.156302f, -0.156397f, -0.156491f,
	-0.156586f, -0.156681f, -0.156775f, -0.156870f, -0.156965f, -0.157059f, -0.157154f, -0.157249f,
	-0.157343f, -0.157438f, -0.157533f, -0.157627f, -0.157722f, -0.157817f, -0.157912f, -0.158006f,
	-0.158101f, -0.158196f, -0.158290f, -0.158385f, -0.158480f, -0.158574f, -0.158669f, -0.158763f,
	-0.158858f, -0.158953f, -0.159047f, -0.159142f, -0.159237f, -0.159331f, -0.159426f, -0.159521f,
	-0.159615f, -0.159710f, -0.159805f, -0.159899f, -0.159994f, -0.160089f, -0.160183f, -0.160278f,
	-0.160372f, -0.160467f, -0.160562f, -0.160656f, -0.160751f, -0.160846f, -0.160940f, -0.161035f,
	-0.161129f, -0.161224f, -0.161319f, -0.161413f, -0.161508f, -0.161603f, -0.161697f, -0.161792f,
	-0.161886f, -0.161981f, -0.162076f, -0.162170f, -0.162265f, -0.162359f, -0.162454f, -0.162549f,
	-0.162643f, -0.162738f, -0.162832f, -0.162927f, -0.163022f, -0.163116f, -0.163211f, -0.163305f,
	-0.163400f, -0.163495f, -0.163589f, -0.163684f, -0.163778f, -0.163873f, -0.163967f, -0.164062f,
	-0.164157f, -0.164251f, -0.164346f, -0.164440f, -0.164535f, -0.164629f, -0.164724f, -0.164819f,
	-0.164913f, -0.165008f, -0.165102f, -0.165197f, -0.165291f, -0.165386f, -0.165480f, -0.165575f,
	-0.165670f, -0.165764f, -0.165859f, -0.165953f, -0.166048f, -0.166142f, -0.166237f, -0.166331f,
	-0.166426f, -0.166520f, -0.166615f, -0.166710f, -0.166804f, -0.166899f, -0.166993f, -0.167088f,
	-0.167182f, -0.167277f, -0.167371f, -0.167466f, -0.167560f, -0.167655f, -0.167749f, -0.167844f,
	-0.167938f, -0.168033f, -0.168127f, -0.168222f, -0.168316f, -0.168411f, -0.168505f, -0.168600f,
	-0.168694f, -0.168789f, -0.168883f, -0.168978f, -0.169072f, -0.169167f, -0.169261f, -0.169356f,
	-0.169450f, -0.169545f, -0.169639f, -0.169734f, -0.169828f, -0.169923f, -0.170017f, -0.170112f,
	-0.170206f, -0.170301f, -0.170395f, -0.170490f, -0.170584f, -0.170678f, -0.170773f, -0.170867f,
	-0.170962f, -0.171056f, -0.171151f, -0.171245f, -0.171340f, -0.171434f, -0.171529f, -0.171623f,
	-0.171718f, -0.171812f, -0.171906f, -0.172001f, -0.172095f, -0.172190f, -0.172284f, -0.172379f,
	-0.172473f, -0.172568f, -0.172662f, -0.172756f, -0.172851f, -0.172945f, -0.173040f, -0.173134f,
	-0.173229f, -0.173323f, -0.173417f, -0.173512f, -0.173606f, -0.173701f, -0.173795f, -0.173889f,
	-0.173984f, -0.174078f, -0.174173f, -0.174267f, -0.174362f, -0.174456f, -0.174550f, -0.174645f,
	-0.174739f, -0.174834f, -0.174928f, -0.175022f, -0.175117f, -0.175211f, -0.175305f, -0.175400f,
	-0.175494f, -0.175589f, -0.175683f, -0.175777f, -0.175872f, -0.175966f, -0.176061f, -0.176155f,
	-0.176249f, -0.176344f, -0.176438f, -0.176532f, -0.176627f, -0.176721f, -0.176815f, -0.176910f,
	-0.177004f, -0.177099f, -0.177193f, -0.177287f, -0.177382f, -0.177476f, -0.177570f, -0.177665f,
	-0.177759f, -0.177853f, -0.177948f, -0.178042f, -0.178136f, -0.178231f, -0.178325f, -0.178419f,
	-0.178514f, -0.178608f, -0.178702f, -0.178797f, -0.178891f, -0.178985f, -0.179080f, -0.179174f,
	-0.179268f, -0.179363f, -0.179457f, -0.179551f, -0.179646f, -0.179740f, -0.179834f, -0.179929f,
	-0.180023f, -0.180117f, -0.180212f, -0.180306f, -0.180400f, -0.180494f, -0.180589f, -0.180683f,
	-0.180777f, -0.180872f, -0.180966f, -0.181060f, -0.181154f, -0.181249f, -0.181343f, -0.181437f,
	-0.181532f, -0.181626f, -0.181720f, -0.181814f, -0.181909f, -0.182003f, -0.182097f, -0.182192f,
	-0.182286f, -0.182380f, -0.182474f, -0.182569f, -0.182663f, -0.182757f, -0.182851f, -0.182946f,
	-0.183040f, -0.183134f, -0.183228f, -0.183323f, -0.183417f, -0.183511f, -0.183605f, -0.183700f,
	-0.183794f, -0.183888f, -0.183982f, -0.184077f, -0.184171f, -0.184265f, -0.184359f, -0.184454f,
	-0.184548f, -0.184642f, -0.184736f, -0.184830f, -0.184925f, -0.185019f, -0.185113f, -0.185207f,
	-0.185301f, -0.185396f, -0.185490f, -0.185584f, -0.185678f, -0.185773f, -0.185867f, -0.185961f,
	-0.186055f, -0.186149f, -0.186244f, -0.186338f, -0.186432f, -0.186526f, -0.186620f, -0.186715f,
	-0.186809f, -0.186903f, -0.186997f, -0.187091f, -0.187185f, -0.187280f, -0.187374f, -0.187468f,
	-0.187562f, -0.187656f, -0.187750f, -0.187845f, -0.187939f, -0.188033f, -0.188127f, -0.188221f,
	-0.188315f, -0.188410f, -0.188504f, -0.188598f, -0.188692f, -0.188786f, -0.188880f, -0.188975f,
	-0.189069f, -0.189163f, -0.189257f, -0.189351f, -0.189445f, -0.189539f, -0.189634f, -0.189728f,
	-0.189822f, -0.189916f, -0.190010f, -0.190104f, -0.190198f, -0.190292f, -0.190387f, -0.190481f,
	-0.190575f, -0.190669f, -0.190763f, -0.190857f, -0.190951f, -0.191045f, -0.191139f, -0.191234f,
	-0.191328f, -0.191422f, -0.191516f, -0.191610f, -0.191704f, -0.191798f, -0.191892f, -0.191986f,
	-0.192080f, -0.192174f, -0.192269f, -0.192363f, -0.192457f, -0.192551f, -0.192645f, -0.192739f,
	-0.192833f, -0.192927f, -0.193021f, -0.193115f, -0.193209f, -0.193303f, -0.193397f, -0.193492f,
	-0.193586f, -0.193680f, -0.193774f, -0.193868f, -0.193962f, -0.194056f, -0.194150f, -0.194244f,
	-0.194338f, -0.194432f, -0.194526f, -0.194620f, -0.194714f, -0.194808f, -0.194902f, -0.194996f,
	-0.195090f, -0.195184f, -0.195278f, -0.195372f, -0.195466f, -0.195560f, -0.195654f, -0.195748f,
	-0.195843f, -0.195937f, -0.196031f, -0.196125f, -0.196219f, -0.196313f, -0.196407f, -0.196501f,
	-0.196595f, -0.196689f, -0.196783f, -0.196877f, -0.196971f, -0.197065f, -0.197159f, -0.197253f,
	-0.197347f, -0.197441f, -0.197535f, -0.197629f, -0.197722f, -0.197816f, -0.197910f, -0.198004f,
	-0.198098f, -0.198192f, -0.198286f, -0.198380f, -0.198474f, -0.198568f, -0.198662f, -0.198756f,
	-0.198850f, -0.198944f, -0.199038f, -0.199132f, -0.199226f, -0.199320f, -0.199414f, -0.199508f,
	-0.199602f, -0.199696f, -0.199790f, -0.199884f, -0.199978f, -0.200071f, -0.200165f, -0.200259f,
	-0.200353f, -0.200447f, -0.200541f, -0.200635f, -0.200729f, -0.200823f, -0.200917f, -0.201011f,
	-0.201105f, -0.201199f, -0.201292f, -0.201386f, -0.201480f, -0.201574f, -0.201668f, -0.201762f,
	-0.201856f, -0.201950f, -0.202044f, -0.202138f, -0.202231f, -0.202325f, -0.202419f, -0.202513f,
	-0.202607f, -0.202701f, -0.202795f, -0.202889f, -0.202983f, -0.203076f, -0.203170f, -0.203264f,
	-0.203358f, -0.203452f, -0.203546f, -0.203640f, -0.203734f, -0.203827f, -0.203921f, -0.204015f,
	-0.204109f, -0.204203f, -0.204297f, -0.204391f, -0.204484f, -0.204578f, -0.204672f, -0.204766f,
	-0.204860f, -0.204954f, -0.205047f, -0.205141f, -0.205235f, -0.205329f, -0.205423f, -0.205517f,
	-0.205610f, -0.205704f, -0.205798f, -0.205892f, -0.205986f, -0.206080f, -0.206173f, -0.206267f,
	-0.206361f, -0.206455f, -0.206549f, -0.206642f, -0.206736f, -0.206830f, -0.206924f, -0.207018f,
	-0.207111f, -0.207205f, -0.207299f, -0.207393f, -0.207487f, -0.207580f, -0.207674f, -0.207768f,
	-0.207862f, -0.207955f, -0.208049f, -0.208143f, -0.208237f, -0.208331f, -0.208424f, -0.208518f,
	-0.208612f, -0.208706f, -0.208799f, -0.208893f, -0.208987f, -0.209081f, -0.209174f, -0.209268f,
	-0.209362f, -0.209456f, -0.209549f, -0.209643f, -0.209737f, -0.209831f, -0.209924f, -0.210018f,
	-0.210112f, -0.210206f, -0.210299f, -0.210393f, -0.210487f, -0.210580f, -0.210674f, -0.210768f,
	-0.210862f, -0.210955f, -0.211049f, -0.211143f, -0.211237f, -0.211330f, -0.211424f, -0.211518f,
	-0.211611f, -0.211705f, -0.211799f, -0.211892f, -0.211986f, -0.212080f, -0.212174f, -0.212267f,
	-0.212361f, -0.212455f, -0.212548f, -0.212642f, -0.212736f, -0.212829f, -0.212923f, -0.213017f,
	-0.213110f, -0.213204f, -0.213298f, -0.213391f, -0.213485f, -0.213579f, -0.213672f, -0.213766f,
	-0.213860f, -0.213953f, -0.214047f, -0.214141f, -0.214234f, -0.214328f, -0.214422f, -0.214515f,
	-0.214609f, -0.214702f, -0.214796f, -0.214890f, -0.214983f, -0.215077f, -0.215171f, -0.215264f,
	-0.215358f, -0.215451f, -0.215545f, -0.215639f, -0.215732f, -0.215826f, -0.215920f, -0.216013f,
	-0.216107f, -0.216200f, -0.216294f, -0.216388f, -0.216481f, -0.216575f, -0.216668f, -0.216762f,
	-0.216856f, -0.216949f, -0.217043f, -0.217136f, -0.217230f, -0.217324f, -0.217417f, -0.217511f,
	-0.217604f, -0.217698f, -0.217791f, -0.217885f, -0.217979f, -0.218072f, -0.218166f, -0.218259f,
	-0.218353f, -0.218446f, -0.218540f, -0.218633f, -0.218727f, -0.218821f, -0.218914f, -0.219008f,
	-0.219101f, -0.219195f, -0.219288f, -0.219382f, -0.219475f, -0.219569f, -0.219662f, -0.219756f,
	-0.219850f, -0.219943f, -0.220037f, -0.220130f, -0.220224f, -0.220317f, -0.220411f, -0.220504f,
	-0.220598f, -0.220691f, -0.220785f, -0.220878f, -0.220972f, -0.221065f, -0.221159f, -0.221252f,
	-0.221346f, -0.221439f, -0.221533f, -0.221626f, -0.221720f, -0.221813f, -0.221907f, -0.222000f,
	-0.222094f, -0.222187f, -0.222281f, -0.222374f, -0.222468f, -0.222561f, -0.222654f, -0.222748f,
	-0.222841f, -0.222935f, -0.223028f, -0.223122f, -0.223215f, -0.223309f, -0.223402f, -0.223496f,
	-0.223589f, -0.223682f, -0.223776f, -0.223869f, -0.223963f, -0.224056f, -0.224150f, -0.224243f,
	-0.224337f, -0.224430f, -0.224523f, -0.224617f, -0.224710f, -0.224804f, -0.224897f, -0.224991f,
	-0.225084f, -0.225177f, -0.225271f, -0.225364f, -0.225458f, -0.225551f, -0.225644f, -0.225738f,
	-0.225831f, -0.225925f, -0.226018f, -0.226111f, -0.226205f, -0.226298f, -0.226391f, -0.226485f,
	-0.226578f, -0.226672f, -0.226765f, -0.226858f, -0.226952f, -0.227045f, -0.227139f, -0.227232f,
	-0.227325f, -0.227419f, -0.227512f, -0.227605f, -0.227699f, -0.227792f, -0.227885f, -0.227979f,
	-0.228072f, -0.228165f, -0.228259f, -0.228352f, -0.228445f, -0.228539f, -0.228632f, -0.228725f,
	-0.228819f, -0.228912f, -0.229005f, -0.229099f, -0.229192f, -0.229285f, -0.229379f, -0.229472f,
	-0.229565f, -0.229659f, -0.229752f, -0.229845f, -0.229939f, -0.230032f, -0.230125f, -0.230218f,
	-0.230312f, -0.230405f, -0.230498f, -0.230592f, -0.230685f, -0.230778f, -0.230872f, -0.230965f,
	-0.231058f, -0.231151f, -0.231245f, -0.231338f, -0.231431f, -0.231524f, -0.231618f, -0.231711f,
	-0.231804f, -0.231898f, -0.231991f, -0.232084f, -0.232177f, -0.232271f, -0.232364f, -0.232457f,
	-0.232550f, -0.232644f, -0.232737f, -0.232830f, -0.232923f, -0.233017f, -0.233110f, -0.233203f,
	-0.233296f, -0.233389f, -0.233483f, -0.233576f, -0.233669f, -0.233762f, -0.233856f, -0.233949f,
	-0.234042f, -0.234135f, -0.234228f, -0.234322f, -0.234415f, -0.234508f, -0.234601f, -0.234694f,
	-0.234788f, -0.234881f, -0.234974f, -0.235067f, -0.235160f, -0.235254f, -0.235347f, -0.235440f,
	-0.235533f, -0.235626f, -0.235719f, -0.235813f, -0.235906f, -0.235999f, -0.236092f, -0.236185f,
	-0.236278f, -0.236372f, -0.236465f, -0.236558f, -0.236651f, -0.236744f, -0.236837f, -0.236930f,
	-0.237024f, -0.237117f, -0.237210f, -0.237303f, -0.237396f, -0.237489f, -0.237582f, -0.237676f,
	-0.237769f, -0.237862f, -0.237955f, -0.238048f, -0.238141f, -0.238234f, -0.238327f, -0.238420f,
	-0.238514f, -0.238607f, -0.238700f, -0.238793f, -0.238886f, -0.238979f, -0.239072f, -0.239165f,
	-0.239258f, -0.239351f, -0.239445f, -0.239538f, -0.239631f, -0.239724f, -0.239817f, -0.239910f,
	-0.240003f, -0.240096f, -0.240189f, -0.240282f, -0.240375f, -0.240468f, -0.240561f, -0.240654f,
	-0.240748f, -0.240841f, -0.240934f, -0.241027f, -0.241120f, -0.241213f, -0.241306f, -0.241399f,
	-0.241492f, -0.241585f, -0.241678f, -0.241771f, -0.241864f, -0.241957f, -0.242050f, -0.242143f,
	-0.242236f, -0.242329f, -0.242422f, -0.242515f, -0.242608f, -0.242701f, -0.242794f, -0.242887f,
	-0.242980f, -0.243073f, -0.243166f, -0.243259f, -0.243352f, -0.243445f, -0.243538f, -0.243631f,
	-0.243724f, -0.243817f, -0.243910f, -0.244003f, -0.244096f, -0.244189f, -0.244282f, -0.244375f,
	-0.244468f, -0.244561f, -0.244654f, -0.244747f, -0.244840f, -0.244933f, -0.245026f, -0.245119f,
	-0.245212f, -0.245304f, -0.245397f, -0.245490f, -0.245583f, -0.245676f, -0.245769f, -0.245862f,
	-0.245955f, -0.246048f, -0.246141f, -0.246234f, -0.246327f, -0.246420f, -0.246513f, -0.246606f,
	-0.246698f, -0.246791f, -0.246884f, -0.246977f, -0.247070f, -0.247163f, -0.247256f, -0.247349f,
	-0.247442f, -0.247535f, -0.247627f, -0.247720f, -0.247813f, -0.247906f, -0.247999f, -0.248092f,
	-0.248185f, -0.248278f, -0.248370f, -0.248463f, -0.248556f, -0.248649f, -0.248742f, -0.248835f,
	-0.248928f, -0.249020f, -0.249113f, -0.249206f, -0.249299f, -0.249392f, -0.249485f, -0.249578f,
	-0.249670f, -0.249763f, -0.249856f, -0.249949f, -0.250042f, -0.250135f, -0.250227f, -0.250320f,
	-0.250413f, -0.250506f, -0.250599f, -0.250691f, -0.250784f, -0.250877f, -0.250970f, -0.251063f,
	-0.251155f, -0.251248f, -0.251341f, -0.251434f, -0.251527f, -0.251619f, -0.251712f, -0.251805f,
	-0.251898f, -0.251991f, -0.252083f, -0.252176f, -0.252269f, -0.252362f, -0.252454f, -0.252547f,
	-0.252640f, -0.252733f, -0.252826f, -0.252918f, -0.253011f, -0.253104f, -0.253197f, -0.253289f,
	-0.253382f, -0.253475f, -0.253568f, -0.253660f, -0.253753f, -0.253846f, -0.253938f, -0.254031f,
	-0.254124f, -0.254217f, -0.254309f, -0.254402f, -0.254495f, -0.254588f, -0.254680f, -0.254773f,
	-0.254866f, -0.254958f, -0.255051f, -0.255144f, -0.255236f, -0.255329f, -0.255422f, -0.255515f,
	-0.255607f, -0.255700f, -0.255793f, -0.255885f, -0.255978f, -0.256071f, -0.256163f, -0.256256f,
	-0.256349f, -0.256441f, -0.256534f, -0.256627f, -0.256719f, -0.256812f, -0.256905f, -0.256997f,
	-0.257090f, -0.257183f, -0.257275f, -0.257368f, -0.257461f, -0.257553f, -0.257646f, -0.257738f,
	-0.257831f, -0.257924f, -0.258016f, -0.258109f, -0.258202f, -0.258294f, -0.258387f, -0.258479f,
	-0.258572f, -0.258665f, -0.258757f, -0.258850f, -0.258943f, -0.259035f, -0.259128f, -0.259220f,
	-0.259313f, -0.259405f, -0.259498f, -0.259591f, -0.259683f, -0.259776f, -0.259868f, -0.259961f,
	-0.260054f, -0.260146f, -0.260239f, -0.260331f, -0.260424f, -0.260516f, -0.260609f, -0.260702f,
	-0.260794f, -0.260887f, -0.260979f, -0.261072f, -0.261164f, -0.261257f, -0.261349f, -0.261442f,
	-0.261534f, -0.261627f, -0.261720f, -0.261812f, -0.261905f, -0.261997f, -0.262090f, -0.262182f,
	-0.262275f, -0.262367f, -0.262460f, -0.262552f, -0.262645f, -0.262737f, -0.262830f, -0.262922f,
	-0.263015f, -0.263107f, -0.263200f, -0.263292f, -0.263385f, -0.263477f, -0.263570f, -0.263662f,
	-0.263755f, -0.263847f, -0.263940f, -0.264032f, -0.264125f, -0.264217f, -0.264309f, -0.264402f,
	-0.264494f, -0.264587f, -0.264679f, -0.264772f, -0.264864f, -0.264957f, -0.265049f, -0.265142f,
	-0.265234f, -0.265326f, -0.265419f, -0.265511f, -0.265604f, -0.265696f, -0.265789f, -0.265881f,
	-0.265973f, -0.266066f, -0.266158f, -0.266251f, -0.266343f, -0.266436f, -0.266528f, -0.266620f,
	-0.266713f, -0.266805f, -0.266898f, -0.266990f, -0.267082f, -0.267175f, -0.267267f, -0.267359f,
	-0.267452f, -0.267544f, -0.267637f, -0.267729f, -0.267821f, -0.267914f, -0.268006f, -0.268099f,
	-0.268191f, -0.268283f, -0.268376f, -0.268468f, -0.268560f, -0.268653f, -0.268745f, -0.268837f,
	-0.268930f, -0.269022f, -0.269114f, -0.269207f, -0.269299f, -0.269391f, -0.269484f, -0.269576f,
	-0.269668f, -0.269761f, -0.269853f, -0.269945f, -0.270038f, -0.270130f, -0.270222f, -0.270315f,
	-0.270407f, -0.270499f, -0.270591f, -0.270684f, -0.270776f, -0.270868f, -0.270961f, -0.271053f,
	-0.271145f, -0.271237f, -0.271330f, -0.271422f, -0.271514f, -0.271607f, -0.271699f, -0.271791f,
	-0.271883f, -0.271976f, -0.272068f, -0.272160f, -0.272252f, -0.272345f, -0.272437f, -0.272529f,
	-0.272621f, -0.272714f, -0.272806f, -0.272898f, -0.272990f, -0.273083f, -0.273175f, -0.273267f,
	-0.273359f, -0.273451f, -0.273544f, -0.273636f, -0.273728f, -0.273820f, -0.273912f, -0.274005f,
	-0.274097f, -0.274189f, -0.274281f, -0.274374f, -0.274466f, -0.274558f, -0.274650f, -0.274742f,
	-0.274834f, -0.274927f, -0.275019f, -0.275111f, -0.275203f, -0.275295f, -0.275387f, -0.275480f,
	-0.275572f, -0.275664f, -0.275756f, -0.275848f, -0.275940f, -0.276033f, -0.276125f, -0.276217f,
	-0.276309f, -0.276401f, -0.276493f, -0.276585f, -0.276678f, -0.276770f, -0.276862f, -0.276954f,
	-0.277046f, -0.277138f, -0.277230f, -0.277322f, -0.277415f, -0.277507f, -0.277599f, -0.277691f,
	-0.277783f, -0.277875f, -0.277967f, -0.278059f, -0.278151f, -0.278243f, -0.278336f, -0.278428f,
	-0.278520f, -0.278612f, -0.278704f, -0.278796f, -0.278888f, -0.278980f, -0.279072f, -0.279164f,
	-0.279256f, -0.279348f, -0.279440f, -0.279532f, -0.279624f, -0.279717f, -0.279809f, -0.279901f,
	-0.279993f, -0.280085f, -0.280177f, -0.280269f, -0.280361f, -0.280453f, -0.280545f, -0.280637f,
	-0.280729f, -0.280821f, -0.280913f, -0.281005f, -0.281097f, -0.281189f, -0.281281f, -0.281373f,
	-0.281465f, -0.281557f, -0.281649f, -0.281741f, -0.281833f, -0.281925f, -0.282017f, -0.282109f,
	-0.282201f, -0.282293f, -0.282385f, -0.282477f, -0.282569f, -0.282661f, -0.282753f, -0.282845f,
	-0.282937f, -0.283029f, -0.283120f, -0.283212f, -0.283304f, -0.283396f, -0.283488f, -0.283580f,
	-0.283672f, -0.283764f, -0.283856f, -0.283948f, -0.284040f, -0.284132f, -0.284224f, -0.284316f,
	-0.284408f, -0.284499f, -0.284591f, -0.284683f, -0.284775f, -0.284867f, -0.284959f, -0.285051f,
	-0.285143f, -0.285235f, -0.285327f, -0.285418f, -0.285510f, -0.285602f, -0.285694f, -0.285786f,
	-0.285878f, -0.285970f, -0.286062f, -0.286153f, -0.286245f, -0.286337f, -0.286429f, -0.286521f,
	-0.286613f, -0.286705f, -0.286796f, -0.286888f, -0.286980f, -0.287072f, -0.287164f, -0.287256f,
	-0.287347f, -0.287439f, -0.287531f, -0.287623f, -0.287715f, -0.287807f, -0.287898f, -0.287990f,
	-0.288082f, -0.288174f, -0.288266f, -0.288357f, -0.288449f, -0.288541f, -0.288633f, -0.288725f,
	-0.288816f, -0.288908f, -0.289000f, -0.289092f, -0.289184f, -0.289275f, -0.289367f, -0.289459f,
	-0.289551f, -0.289642f, -0.289734f, -0.289826f, -0.289918f, -0.290009f, -0.290101f, -0.290193f,
	-0.290285f, -0.290376f, -0.290468f, -0.290560f, -0.290652f, -0.290743f, -0.290835f, -0.290927f,
	-0.291019f, -0.291110f, -0.291202f, -0.291294f, -0.291385f, -0.291477f, -0.291569f, -0.291661f,
	-0.291752f, -0.291844f, -0.291936f, -0.292027f, -0.292119f, -0.292211f, -0.292302f, -0.292394f,
	-0.292486f, -0.292577f, -0.292669f, -0.292761f, -0.292852f, -0.292944f, -0.293036f, -0.293128f,
	-0.293219f, -0.293311f, -0.293402f, -0.293494f, -0.293586f, -0.293677f, -0.293769f, -0.293861f,
	-0.293952f, -0.294044f, -0.294136f, -0.294227f, -0.294319f, -0.294410f, -0.294502f, -0.294594f,
	-0.294685f, -0.294777f, -0.294869f, -0.294960f, -0.295052f, -0.295143f, -0.295235f, -0.295327f,
	-0.295418f, -0.295510f, -0.295601f, -0.295693f, -0.295785f, -0.295876f, -0.295968f, -0.296059f,
	-0.296151f, -0.296242f, -0.296334f, -0.296426f, -0.296517f, -0.296609f, -0.296700f, -0.296792f,
	-0.296883f, -0.296975f, -0.297066f, -0.297158f, -0.297250f, -0.297341f, -0.297433f, -0.297524f,
	-0.297616f, -0.297707f, -0.297799f, -0.297890f, -0.297982f, -0.298073f, -0.298165f, -0.298256f,
	-0.298348f, -0.298439f, -0.298531f, -0.298622f, -0.298714f, -0.298805f, -0.298897f, -0.298988f,
	-0.299080f, -0.299171f, -0.299263f, -0.299354f, -0.299446f, -0.299537f, -0.299629f, -0.299720f,
	-0.299812f, -0.299903f, -0.299995f, -0.300086f, -0.300177f, -0.300269f, -0.300360f, -0.300452f,
	-0.300543f, -0.300635f, -0.300726f, -0.300818f, -0.300909f, -0.301000f, -0.301092f, -0.301183f,
	-0.301275f, -0.301366f, -0.301458f, -0.301549f, -0.301640f, -0.301732f, -0.301823f, -0.301915f,
	-0.302006f, -0.302097f, -0.302189f, -0.302280f, -0.302372f, -0.302463f, -0.302554f, -0.302646f,
	-0.302737f, -0.302828f, -0.302920f, -0.303011f, -0.303103f, -0.303194f, -0.303285f, -0.303377f,
	-0.303468f, -0.303559f, -0.303651f, -0.303742f, -0.303833f, -0.303925f, -0.304016f, -0.304107f,
	-0.304199f, -0.304290f, -0.304381f, -0.304473f, -0.304564f, -0.304655f, -0.304747f, -0.304838f,
	-0.304929f, -0.305021f, -0.305112f, -0.305203f, -0.305294f, -0.305386f, -0.305477f, -0.305568f,
	-0.305660f, -0.305751f, -0.305842f, -0.305933f, -0.306025f, -0.306116f, -0.306207f, -0.306299f,
	-0.306390f, -0.306481f, -0.306572f, -0.306664f, -0.306755f, -0.306846f, -0.306937f, -0.307029f,
	-0.307120f, -0.307211f, -0.307302f, -0.307394f, -0.307485f, -0.307576f, -0.307667f, -0.307758f,
	-0.307850f, -0.307941f, -0.308032f, -0.308123f, -0.308214f, -0.308306f, -0.308397f, -0.308488f,
	-0.308579f, -0.308670f, -0.308762f, -0.308853f, -0.308944f, -0.309035f, -0.309126f, -0.309218f,
	-0.309309f, -0.309400f, -0.309491f, -0.309582f, -0.309673f, -0.309765f, -0.309856f, -0.309947f,
	-0.310038f, -0.310129f, -0.310220f, -0.310311f, -0.310403f, -0.310494f, -0.310585f, -0.310676f,
	-0.310767f, -0.310858f, -0.310949f, -0.311041f, -0.311132f, -0.311223f, -0.311314f, -0.311405f,
	-0.311496f, -0.311587f, -0.311678f, -0.311769f, -0.311860f, -0.311952f, -0.312043f, -0.312134f,
	-0.312225f, -0.312316f, -0.312407f, -0.312498f, -0.312589f, -0.312680f, -0.312771f, -0.312862f,
	-0.312953f, -0.313044f, -0.313135f, -0.313227f, -0.313318f, -0.313409f, -0.313500f, -0.313591f,
	-0.313682f, -0.313773f, -0.313864f, -0.313955f, -0.314046f, -0.314137f, -0.314228f, -0.314319f,
	-0.314410f, -0.314501f, -0.314592f, -0.314683f, -0.314774f, -0.314865f, -0.314956f, -0.315047f,
	-0.315138f, -0.315229f, -0.315320f, -0.315411f, -0.315502f, -0.315593f, -0.315684f, -0.315775f,
	-0.315866f, -0.315957f, -0.316048f, -0.316139f, -0.316230f, -0.316321f, -0.316411f, -0.316502f,
	-0.316593f, -0.316684f, -0.316775f, -0.316866f, -0.316957f, -0.317048f, -0.317139f, -0.317230f,
	-0.317321f, -0.317412f, -0.317503f, -0.317594f, -0.317684f, -0.317775f, -0.317866f, -0.317957f,
	-0.318048f, -0.318139f, -0.318230f, -0.318321f, -0.318412f, -0.318503f, -0.318593f, -0.318684f,
	-0.318775f, -0.318866f, -0.318957f, -0.319048f, -0.319139f, -0.319229f, -0.319320f, -0.319411f,
	-0.319502f, -0.319593f, -0.319684f, -0.319775f, -0.319865f, -0.319956f, -0.320047f, -0.320138f,
	-0.320229f, -0.320320f, -0.320410f, -0.320501f, -0.320592f, -0.320683f, -0.320774f, -0.320864f,
	-0.320955f, -0.321046f, -0.321137f, -0.321228f, -0.321318f, -0.321409f, -0.321500f, -0.321591f,
	-0.321682f, -0.321772f, -0.321863f, -0.321954f, -0.322045f, -0.322135f, -0.322226f, -0.322317f,
	-0.322408f, -0.322498f, -0.322589f, -0.322680f, -0.322771f, -0.322861f, -0.322952f, -0.323043f,
	-0.323134f, -0.323224f, -0.323315f, -0.323406f, -0.323497f, -0.323587f, -0.323678f, -0.323769f,
	-0.323859f, -0.323950f, -0.324041f, -0.324131f, -0.324222f, -0.324313f, -0.324404f, -0.324494f,
	-0.324585f, -0.324676f, -0.324766f, -0.324857f, -0.324948f, -0.325038f, -0.325129f, -0.325220f,
	-0.325310f, -0.325401f, -0.325492f, -0.325582f, -0.325673f, -0.325764f, -0.325854f, -0.325945f,
	-0.326035f, -0.326126f, -0.326217f, -0.326307f, -0.326398f, -0.326489f, -0.326579f, -0.326670f,
	-0.326760f, -0.326851f, -0.326942f, -0.327032f, -0.327123f, -0.327213f, -0.327304f, -0.327395f,
	-0.327485f, -0.327576f, -0.327666f, -0.327757f, -0.327848f, -0.327938f, -0.328029f, -0.328119f,
	-0.328210f, -0.328300f, -0.328391f, -0.328482f, -0.328572f, -0.328663f, -0.328753f, -0.328844f,
	-0.328934f, -0.329025f, -0.329115f, -0.329206f, -0.329296f, -0.329387f, -0.329477f, -0.329568f,
	-0.329658f, -0.329749f, -0.329839f, -0.329930f, -0.330020f, -0.330111f, -0.330202f, -0.330292f,
	-0.330382f, -0.330473f, -0.330563f, -0.330654f, -0.330744f, -0.330835f, -0.330925f, -0.331016f,
	-0.331106f, -0.331197f, -0.331287f, -0.331378f, -0.331468f, -0.331559f, -0.331649f, -0.331739f,
	-0.331830f, -0.331920f, -0.332011f, -0.332101f, -0.332192f, -0.332282f, -0.332373f, -0.332463f,
	-0.332553f, -0.332644f, -0.332734f, -0.332825f, -0.332915f, -0.333005f, -0.333096f, -0.333186f,
	-0.333277f, -0.333367f, -0.333457f, -0.333548f, -0.333638f, -0.333729f, -0.333819f, -0.333909f,
	-0.334000f, -0.334090f, -0.334180f, -0.334271f, -0.334361f, -0.334451f, -0.334542f, -0.334632f,
	-0.334722f, -0.334813f, -0.334903f, -0.334994f, -0.335084f, -0.335174f, -0.335265f, -0.335355f,
	-0.335445f, -0.335535f, -0.335626f, -0.335716f, -0.335806f, -0.335897f, -0.335987f, -0.336077f,
	-0.336168f, -0.336258f, -0.336348f, -0.336438f, -0.336529f, -0.336619f, -0.336709f, -0.336800f,
	-0.336890f, -0.336980f, -0.337070f, -0.337161f, -0.337251f, -0.337341f, -0.337431f, -0.337522f,
	-0.337612f, -0.337702f, -0.337792f, -0.337883f, -0.337973f, -0.338063f, -0.338153f, -0.338244f,
	-0.338334f, -0.338424f, -0.338514f, -0.338604f, -0.338695f, -0.338785f, -0.338875f, -0.338965f,
	-0.339055f, -0.339146f, -0.339236f, -0.339326f, -0.339416f, -0.339506f, -0.339597f, -0.339687f,
	-0.339777f, -0.339867f, -0.339957f, -0.340047f, -0.340138f, -0.340228f, -0.340318f, -0.340408f,
	-0.340498f, -0.340588f, -0.340678f, -0.340769f, -0.340859f, -0.340949f, -0.341039f, -0.341129f,
	-0.341219f, -0.341309f, -0.341399f, -0.341490f, -0.341580f, -0.341670f, -0.341760f, -0.341850f,
	-0.341940f, -0.342030f, -0.342120f, -0.342210f, -0.342300f, -0.342391f, -0.342481f, -0.342571f,
	-0.342661f, -0.342751f, -0.342841f, -0.342931f, -0.343021f, -0.343111f, -0.343201f, -0.343291f,
	-0.343381f, -0.343471f, -0.343561f, -0.343651f, -0.343741f, -0.343831f, -0.343921f, -0.344011f,
	-0.344101f, -0.344191f, -0.344281f, -0.344371f, -0.344461f, -0.344551f, -0.344641f, -0.344731f,
	-0.344821f, -0.344911f, -0.345001f, -0.345091f, -0.345181f, -0.345271f, -0.345361f, -0.345451f,
	-0.345541f, -0.345631f, -0.345721f, -0.345811f, -0.345901f, -0.345991f, -0.346081f, -0.346171f,
	-0.346261f, -0.346351f, -0.346441f, -0.346531f, -0.346621f, -0.346711f, -0.346801f, -0.346890f,
	-0.346980f, -0.347070f, -0.347160f, -0.347250f, -0.347340f, -0.347430f, -0.347520f, -0.347610f,
	-0.347700f, -0.347790f, -0.347879f, -0.347969f, -0.348059f, -0.348149f, -0.348239f, -0.348329f,
	-0.348419f, -0.348509f, -0.348598f, -0.348688f, -0.348778f, -0.348868f, -0.348958f, -0.349048f,
	-0.349138f, -0.349227f, -0.349317f, -0.349407f, -0.349497f, -0.349587f, -0.349676f, -0.349766f,
	-0.349856f, -0.349946f, -0.350036f, -0.350126f, -0.350215f, -0.350305f, -0.350395f, -0.350485f,
	-0.350575f, -0.350664f, -0.350754f, -0.350844f, -0.350934f, -0.351023f, -0.351113f, -0.351203f,
	-0.351293f, -0.351383f, -0.351472f, -0.351562f, -0.351652f, -0.351742f, -0.351831f, -0.351921f,
	-0.352011f, -0.352100f, -0.352190f, -0.352280f, -0.352370f, -0.352459f, -0.352549f, -0.352639f,
	-0.352729f, -0.352818f, -0.352908f, -0.352998f, -0.353087f, -0.353177f, -0.353267f, -0.353356f,
	-0.353446f, -0.353536f, -0.353626f, -0.353715f, -0.353805f, -0.353895f, -0.353984f, -0.354074f,
	-0.354164f, -0.354253f, -0.354343f, -0.354432f, -0.354522f, -0.354612f, -0.354701f, -0.354791f,
	-0.354881f, -0.354970f, -0.355060f, -0.355150f, -0.355239f, -0.355329f, -0.355418f, -0.355508f,
	-0.355598f, -0.355687f, -0.355777f, -0.355866f, -0.355956f, -0.356046f, -0.356135f, -0.356225f,
	-0.356314f, -0.356404f, -0.356494f, -0.356583f, -0.356673f, -0.356762f, -0.356852f, -0.356941f,
	-0.357031f, -0.357121f, -0.357210f, -0.357300f, -0.357389f, -0.357479f, -0.357568f, -0.357658f,
	-0.357747f, -0.357837f, -0.357926f, -0.358016f, -0.358105f, -0.358195f, -0.358284f, -0.358374f,
	-0.358463f, -0.358553f, -0.358642f, -0.358732f, -0.358821f, -0.358911f, -0.359000f, -0.359090f,
	-0.359179f, -0.359269f, -0.359358f, -0.359448f, -0.359537f, -0.359627f, -0.359716f, -0.359806f,
	-0.359895f, -0.359984f, -0.360074f, -0.360163f, -0.360253f, -0.360342f, -0.360432f, -0.360521f,
	-0.360611f, -0.360700f, -0.360789f, -0.360879f, -0.360968f, -0.361058f, -0.361147f, -0.361236f,
	-0.361326f, -0.361415f, -0.361505f, -0.361594f, -0.361683f, -0.361773f, -0.361862f, -0.361952f,
	-0.362041f, -0.362130f, -0.362220f, -0.362309f, -0.362398f, -0.362488f, -0.362577f, -0.362666f,
	-0.362756f, -0.362845f, -0.362934f, -0.363024f, -0.363113f, -0.363202f, -0.363292f, -0.363381f,
	-0.363470f, -0.363560f, -0.363649f, -0.363738f, -0.363828f, -0.363917f, -0.364006f, -0.364096f,
	-0.364185f, -0.364274f, -0.364363f, -0.364453f, -0.364542f, -0.364631f, -0.364720f, -0.364810f,
	-0.364899f, -0.364988f, -0.365078f, -0.365167f, -0.365256f, -0.365345f, -0.365435f, -0.365524f,
	-0.365613f, -0.365702f, -0.365791f, -0.365881f, -0.365970f, -0.366059f, -0.366148f, -0.366238f,
	-0.366327f, -0.366416f, -0.366505f, -0.366594f, -0.366684f, -0.366773f, -0.366862f, -0.366951f,
	-0.367040f, -0.367130f, -0.367219f, -0.367308f, -0.367397f, -0.367486f, -0.367575f, -0.367665f,
	-0.367754f, -0.367843f, -0.367932f, -0.368021f, -0.368110f, -0.368199f, -0.368289f, -0.368378f,
	-0.368467f, -0.368556f, -0.368645f, -0.368734f, -0.368823f, -0.368912f, -0.369002f, -0.369091f,
	-0.369180f, -0.369269f, -0.369358f, -0.369447f, -0.369536f, -0.369625f, -0.369714f, -0.369803f,
	-0.369892f, -0.369982f, -0.370071f, -0.370160f, -0.370249f, -0.370338f, -0.370427f, -0.370516f,
	-0.370605f, -0.370694f, -0.370783f, -0.370872f, -0.370961f, -0.371050f, -0.371139f, -0.371228f,
	-0.371317f, -0.371406f, -0.371495f, -0.371584f, -0.371673f, -0.371762f, -0.371851f, -0.371940f,
	-0.372029f, -0.372118f, -0.372207f, -0.372296f, -0.372385f, -0.372474f, -0.372563f, -0.372652f,
	-0.372741f, -0.372830f, -0.372919f, -0.373008f, -0.373097f, -0.373186f, -0.373275f, -0.373364f,
	-0.373453f, -0.373542f, -0.373631f, -0.373719f, -0.373808f, -0.373897f, -0.373986f, -0.374075f,
	-0.374164f, -0.374253f, -0.374342f, -0.374431f, -0.374520f, -0.374609f, -0.374697f, -0.374786f,
	-0.374875f, -0.374964f, -0.375053f, -0.375142f, -0.375231f, -0.375320f, -0.375408f, -0.375497f,
	-0.375586f, -0.375675f, -0.375764f, -0.375853f, -0.375942f, -0.376030f, -0.376119f, -0.376208f,
	-0.376297f, -0.376386f, -0.376475f, -0.376563f, -0.376652f, -0.376741f, -0.376830f, -0.376919f,
	-0.377007f, -0.377096f, -0.377185f, -0.377274f, -0.377363f, -0.377451f, -0.377540f, -0.377629f,
	-0.377718f, -0.377806f, -0.377895f, -0.377984f, -0.378073f, -0.378162f, -0.378250f, -0.378339f,
	-0.378428f, -0.378516f, -0.378605f, -0.378694f, -0.378783f, -0.378871f, -0.378960f, -0.379049f,
	-0.379138f, -0.379226f, -0.379315f, -0.379404f, -0.379492f, -0.379581f, -0.379670f, -0.379759f,
	-0.379847f, -0.379936f, -0.380025f, -0.380113f, -0.380202f, -0.380291f, -0.380379f, -0.380468f,
	-0.380557f, -0.380645f, -0.380734f, -0.380823f, -0.380911f, -0.381000f, -0.381088f, -0.381177f,
	-0.381266f, -0.381354f, -0.381443f, -0.381532f, -0.381620f, -0.381709f, -0.381797f, -0.381886f,
	-0.381975f, -0.382063f, -0.382152f, -0.382241f, -0.382329f, -0.382418f, -0.382506f, -0.382595f,
	-0.382683f, -0.382772f, -0.382861f, -0.382949f, -0.383038f, -0.383126f, -0.383215f, -0.383303f,
	-0.383392f, -0.383480f, -0.383569f, -0.383658f, -0.383746f, -0.383835f, -0.383923f, -0.384012f,
	-0.384100f, -0.384189f, -0.384277f, -0.384366f, -0.384454f, -0.384543f, -0.384631f, -0.384720f,
	-0.384808f, -0.384897f, -0.384985f, -0.385074f, -0.385162f, -0.385251f, -0.385339f, -0.385428f,
	-0.385516f, -0.385605f, -0.385693f, -0.385781f, -0.385870f, -0.385958f, -0.386047f, -0.386135f,
	-0.386224f, -0.386312f, -0.386400f, -0.386489f, -0.386577f, -0.386666f, -0.386754f, -0.386843f,
	-0.386931f, -0.387019f, -0.387108f, -0.387196f, -0.387285f, -0.387373f, -0.387461f, -0.387550f,
	-0.387638f, -0.387727f, -0.387815f, -0.387903f, -0.387992f, -0.388080f, -0.388168f, -0.388257f,
	-0.388345f, -0.388433f, -0.388522f, -0.388610f, -0.388698f, -0.388787f, -0.388875f, -0.388963f,
	-0.389052f, -0.389140f, -0.389228f, -0.389317f, -0.389405f, -0.389493f, -0.389582f, -0.389670f,
	-0.389758f, -0.389846f, -0.389935f, -0.390023f, -0.390111f, -0.390200f, -0.390288f, -0.390376f,
	-0.390464f, -0.390553f, -0.390641f, -0.390729f, -0.390817f, -0.390906f, -0.390994f, -0.391082f,
	-0.391170f, -0.391259f, -0.391347f, -0.391435f, -0.391523f, -0.391612f, -0.391700f, -0.391788f,
	-0.391876f, -0.391964f, -0.392053f, -0.392141f, -0.392229f, -0.392317f, -0.392405f, -0.392493f,
	-0.392582f, -0.392670f, -0.392758f, -0.392846f, -0.392934f, -0.393023f, -0.393111f, -0.393199f,
	-0.393287f, -0.393375f, -0.393463f, -0.393551f, -0.393640f, -0.393728f, -0.393816f, -0.393904f,
	-0.393992f, -0.394080f, -0.394168f, -0.394256f, -0.394344f, -0.394433f, -0.394521f, -0.394609f,
	-0.394697f, -0.394785f, -0.394873f, -0.394961f, -0.395049f, -0.395137f, -0.395225f, -0.395313f,
	-0.395401f, -0.395490f, -0.395578f, -0.395666f, -0.395754f, -0.395842f, -0.395930f, -0.396018f,
	-0.396106f, -0.396194f, -0.396282f, -0.396370f, -0.396458f, -0.396546f, -0.396634f, -0.396722f,
	-0.396810f, -0.396898f, -0.396986f, -0.397074f, -0.397162f, -0.397250f, -0.397338f, -0.397426f,
	-0.397514f, -0.397602f, -0.397690f, -0.397778f, -0.397866f, -0.397954f, -0.398042f, -0.398130f,
	-0.398218f, -0.398306f, -0.398393f, -0.398481f, -0.398569f, -0.398657f, -0.398745f, -0.398833f,
	-0.398921f, -0.399009f, -0.399097f, -0.399185f, -0.399273f, -0.399361f, -0.399448f, -0.399536f,
	-0.399624f, -0.399712f, -0.399800f, -0.399888f, -0.399976f, -0.400064f, -0.400151f, -0.400239f,
	-0.400327f, -0.400415f, -0.400503f, -0.400591f, -0.400679f, -0.400766f, -0.400854f, -0.400942f,
	-0.401030f, -0.401118f, -0.401206f, -0.401293f, -0.401381f, -0.401469f, -0.401557f, -0.401645f,
	-0.401732f, -0.401820f, -0.401908f, -0.401996f, -0.402084f, -0.402171f, -0.402259f, -0.402347f,
	-0.402435f, -0.402522f, -0.402610f, -0.402698f, -0.402786f, -0.402873f, -0.402961f, -0.403049f,
	-0.403137f, -0.403224f, -0.403312f, -0.403400f, -0.403488f, -0.403575f, -0.403663f, -0.403751f,
	-0.403838f, -0.403926f, -0.404014f, -0.404102f, -0.404189f, -0.404277f, -0.404365f, -0.404452f,
	-0.404540f, -0.404628f, -0.404715f, -0.404803f, -0.404891f, -0.404978f, -0.405066f, -0.405154f,
	-0.405241f, -0.405329f, -0.405417f, -0.405504f, -0.405592f, -0.405680f, -0.405767f, -0.405855f,
	-0.405942f, -0.406030f, -0.406118f, -0.406205f, -0.406293f, -0.406380f, -0.406468f, -0.406556f,
	-0.406643f, -0.406731f, -0.406818f, -0.406906f, -0.406994f, -0.407081f, -0.407169f, -0.407256f,
	-0.407344f, -0.407431f, -0.407519f, -0.407606f, -0.407694f, -0.407782f, -0.407869f, -0.407957f,
	-0.408044f, -0.408132f, -0.408219f, -0.408307f, -0.408394f, -0.408482f, -0.408569f, -0.408657f,
	-0.408744f, -0.408832f, -0.408919f, -0.409007f, -0.409094f, -0.409182f, -0.409269f, -0.409357f,
	-0.409444f, -0.409532f, -0.409619f, -0.409707f, -0.409794f, -0.409881f, -0.409969f, -0.410056f,
	-0.410144f, -0.410231f, -0.410319f, -0.410406f, -0.410493f, -0.410581f, -0.410668f, -0.410756f,
	-0.410843f, -0.410931f, -0.411018f, -0.411105f, -0.411193f, -0.411280f, -0.411368f, -0.411455f,
	-0.411542f, -0.411630f, -0.411717f, -0.411804f, -0.411892f, -0.411979f, -0.412067f, -0.412154f,
	-0.412241f, -0.412329f, -0.412416f, -0.412503f, -0.412591f, -0.412678f, -0.412765f, -0.412853f,
	-0.412940f, -0.413027f, -0.413115f, -0.413202f, -0.413289f, -0.413376f, -0.413464f, -0.413551f,
	-0.413638f, -0.413726f, -0.413813f, -0.413900f, -0.413987f, -0.414075f, -0.414162f, -0.414249f,
	-0.414337f, -0.414424f, -0.414511f, -0.414598f, -0.414685f, -0.414773f, -0.414860f, -0.414947f,
	-0.415034f, -0.415122f, -0.415209f, -0.415296f, -0.415383f, -0.415471f, -0.415558f, -0.415645f,
	-0.415732f, -0.415819f, -0.415906f, -0.415994f, -0.416081f, -0.416168f, -0.416255f, -0.416342f,
	-0.416430f, -0.416517f, -0.416604f, -0.416691f, -0.416778f, -0.416865f, -0.416952f, -0.417040f,
	-0.417127f, -0.417214f, -0.417301f, -0.417388f, -0.417475f, -0.417562f, -0.417650f, -0.417737f,
	-0.417824f, -0.417911f, -0.417998f, -0.418085f, -0.418172f, -0.418259f, -0.418346f, -0.418433f,
	-0.418520f, -0.418608f, -0.418695f, -0.418782f, -0.418869f, -0.418956f, -0.419043f, -0.419130f,
	-0.419217f, -0.419304f, -0.419391f, -0.419478f, -0.419565f, -0.419652f, -0.419739f, -0.419826f,
	-0.419913f, -0.420000f, -0.420087f, -0.420174f, -0.420261f, -0.420348f, -0.420435f, -0.420522f,
	-0.420609f, -0.420696f, -0.420783f, -0.420870f, -0.420957f, -0.421044f, -0.421131f, -0.421218f,
	-0.421305f, -0.421392f, -0.421479f, -0.421566f, -0.421653f, -0.421739f, -0.421826f, -0.421913f,
	-0.422000f, -0.422087f, -0.422174f, -0.422261f, -0.422348f, -0.422435f, -0.422522f, -0.422609f,
	-0.422695f, -0.422782f, -0.422869f, -0.422956f, -0.423043f, -0.423130f, -0.423217f, -0.423304f,
	-0.423390f, -0.423477f, -0.423564f, -0.423651f, -0.423738f, -0.423825f, -0.423912f, -0.423998f,
	-0.424085f, -0.424172f, -0.424259f, -0.424346f, -0.424432f, -0.424519f, -0.424606f, -0.424693f,
	-0.424780f, -0.424866f, -0.424953f, -0.425040f, -0.425127f, -0.425214f, -0.425300f, -0.425387f,
	-0.425474f, -0.425561f, -0.425647f, -0.425734f, -0.425821f, -0.425908f, -0.425994f, -0.426081f,
	-0.426168f, -0.426255f, -0.426341f, -0.426428f, -0.426515f, -0.426601f, -0.426688f, -0.426775f,
	-0.426862f, -0.426948f, -0.427035f, -0.427122f, -0.427208f, -0.427295f, -0.427382f, -0.427468f,
	-0.427555f, -0.427642f, -0.427728f, -0.427815f, -0.427902f, -0.427988f, -0.428075f, -0.428162f,
	-0.428248f, -0.428335f, -0.428422f, -0.428508f, -0.428595f, -0.428681f, -0.428768f, -0.428855f,
	-0.428941f, -0.429028f, -0.429114f, -0.429201f, -0.429288f, -0.429374f, -0.429461f, -0.429547f,
	-0.429634f, -0.429721f, -0.429807f, -0.429894f, -0.429980f, -0.430067f, -0.430153f, -0.430240f,
	-0.430326f, -0.430413f, -0.430500f, -0.430586f, -0.430673f, -0.430759f, -0.430846f, -0.430932f,
	-0.431019f, -0.431105f, -0.431192f, -0.431278f, -0.431365f, -0.431451f, -0.431538f, -0.431624f,
	-0.431711f, -0.431797f, -0.431884f, -0.431970f, -0.432057f, -0.432143f, -0.432229f, -0.432316f,
	-0.432402f, -0.432489f, -0.432575f, -0.432662f, -0.432748f, -0.432835f, -0.432921f, -0.433007f,
	-0.433094f, -0.433180f, -0.433267f, -0.433353f, -0.433439f, -0.433526f, -0.433612f, -0.433699f,
	-0.433785f, -0.433871f, -0.433958f, -0.434044f, -0.434131f, -0.434217f, -0.434303f, -0.434390f,
	-0.434476f, -0.434562f, -0.434649f, -0.434735f, -0.434821f, -0.434908f, -0.434994f, -0.435080f,
	-0.435167f, -0.435253f, -0.435339f, -0.435426f, -0.435512f, -0.435598f, -0.435685f, -0.435771f,
	-0.435857f, -0.435943f, -0.436030f, -0.436116f, -0.436202f, -0.436288f, -0.436375f, -0.436461f,
	-0.436547f, -0.436633f, -0.436720f, -0.436806f, -0.436892f, -0.436978f, -0.437065f, -0.437151f,
	-0.437237f, -0.437323f, -0.437410f, -0.437496f, -0.437582f, -0.437668f, -0.437754f, -0.437841f,
	-0.437927f, -0.438013f, -0.438099f, -0.438185f, -0.438272f, -0.438358f, -0.438444f, -0.438530f,
	-0.438616f, -0.438702f, -0.438789f, -0.438875f, -0.438961f, -0.439047f, -0.439133f, -0.439219f,
	-0.439305f, -0.439392f, -0.439478f, -0.439564f, -0.439650f, -0.439736f, -0.439822f, -0.439908f,
	-0.439994f, -0.440080f, -0.440166f, -0.440253f, -0.440339f, -0.440425f, -0.440511f, -0.440597f,
	-0.440683f, -0.440769f, -0.440855f, -0.440941f, -0.441027f, -0.441113f, -0.441199f, -0.441285f,
	-0.441371f, -0.441457f, -0.441543f, -0.441629f, -0.441715f, -0.441801f, -0.441887f, -0.441973f,
	-0.442059f, -0.442145f, -0.442231f, -0.442317f, -0.442403f, -0.442489f, -0.442575f, -0.442661f,
	-0.442747f, -0.442833f, -0.442919f, -0.443005f, -0.443091f, -0.443177f, -0.443263f, -0.443349f,
	-0.443435f, -0.443521f, -0.443607f, -0.443693f, -0.443779f, -0.443864f, -0.443950f, -0.444036f,
	-0.444122f, -0.444208f, -0.444294f, -0.444380f, -0.444466f, -0.444552f, -0.444637f, -0.444723f,
	-0.444809f, -0.444895f, -0.444981f, -0.445067f, -0.445153f, -0.445239f, -0.445324f, -0.445410f,
	-0.445496f, -0.445582f, -0.445668f, -0.445754f, -0.445839f, -0.445925f, -0.446011f, -0.446097f,
	-0.446183f, -0.446268f, -0.446354f, -0.446440f, -0.446526f, -0.446612f, -0.446697f, -0.446783f,
	-0.446869f, -0.446955f, -0.447040f, -0.447126f, -0.447212f, -0.447298f, -0.447383f, -0.447469f,
	-0.447555f, -0.447641f, -0.447726f, -0.447812f, -0.447898f, -0.447983f, -0.448069f, -0.448155f,
	-0.448241f, -0.448326f, -0.448412f, -0.448498f, -0.448583f, -0.448669f, -0.448755f, -0.448840f,
	-0.448926f, -0.449012f, -0.449097f, -0.449183f, -0.449269f, -0.449354f, -0.449440f, -0.449526f,
	-0.449611f, -0.449697f, -0.449783f, -0.449868f, -0.449954f, -0.450039f, -0.450125f, -0.450211f,
	-0.450296f, -0.450382f, -0.450467f, -0.450553f, -0.450639f, -0.450724f, -0.450810f, -0.450895f,
	-0.450981f, -0.451067f, -0.451152f, -0.451238f, -0.451323f, -0.451409f, -0.451494f, -0.451580f,
	-0.451665f, -0.451751f, -0.451836f, -0.451922f, -0.452008f, -0.452093f, -0.452179f, -0.452264f,
	-0.452350f, -0.452435f, -0.452521f, -0.452606f, -0.452692f, -0.452777f, -0.452863f, -0.452948f,
	-0.453033f, -0.453119f, -0.453204f, -0.453290f, -0.453375f, -0.453461f, -0.453546f, -0.453632f,
	-0.453717f, -0.453803f, -0.453888f, -0.453973f, -0.454059f, -0.454144f, -0.454230f, -0.454315f,
	-0.454400f, -0.454486f, -0.454571f, -0.454657f, -0.454742f, -0.454827f, -0.454913f, -0.454998f,
	-0.455084f, -0.455169f, -0.455254f, -0.455340f, -0.455425f, -0.455510f, -0.455596f, -0.455681f,
	-0.455766f, -0.455852f, -0.455937f, -0.456022f, -0.456108f, -0.456193f, -0.456278f, -0.456364f,
	-0.456449f, -0.456534f, -0.456620f, -0.456705f, -0.456790f, -0.456875f, -0.456961f, -0.457046f,
	-0.457131f, -0.457217f, -0.457302f, -0.457387f, -0.457472f, -0.457558f, -0.457643f, -0.457728f,
	-0.457813f, -0.457899f, -0.457984f, -0.458069f, -0.458154f, -0.458239f, -0.458325f, -0.458410f,
	-0.458495f, -0.458580f, -0.458665f, -0.458751f, -0.458836f, -0.458921f, -0.459006f, -0.459091f,
	-0.459177f, -0.459262f, -0.459347f, -0.459432f, -0.459517f, -0.459602f, -0.459687f, -0.459773f,
	-0.459858f, -0.459943f, -0.460028f, -0.460113f, -0.460198f, -0.460283f, -0.460369f, -0.460454f,
	-0.460539f, -0.460624f, -0.460709f, -0.460794f, -0.460879f, -0.460964f, -0.461049f, -0.461134f,
	-0.461219f, -0.461304f, -0.461390f, -0.461475f, -0.461560f, -0.461645f, -0.461730f, -0.461815f,
	-0.461900f, -0.461985f, -0.462070f, -0.462155f, -0.462240f, -0.462325f, -0.462410f, -0.462495f,
	-0.462580f, -0.462665f, -0.462750f, -0.462835f, -0.462920f, -0.463005f, -0.463090f, -0.463175f,
	-0.463260f, -0.463345f, -0.463430f, -0.463515f, -0.463600f, -0.463685f, -0.463769f, -0.463854f,
	-0.463939f, -0.464024f, -0.464109f, -0.464194f, -0.464279f, -0.464364f, -0.464449f, -0.464534f,
	-0.464619f, -0.464704f, -0.464788f, -0.464873f, -0.464958f, -0.465043f, -0.465128f, -0.465213f,
	-0.465298f, -0.465383f, -0.465467f, -0.465552f, -0.465637f, -0.465722f, -0.465807f, -0.465892f,
	-0.465977f, -0.466061f, -0.466146f, -0.466231f, -0.466316f, -0.466401f, -0.466485f, -0.466570f,
	-0.466655f, -0.466740f, -0.466825f, -0.466909f, -0.466994f, -0.467079f, -0.467164f, -0.467248f,
	-0.467333f, -0.467418f, -0.467503f, -0.467587f, -0.467672f, -0.467757f, -0.467842f, -0.467926f,
	-0.468011f, -0.468096f, -0.468181f, -0.468265f, -0.468350f, -0.468435f, -0.468519f, -0.468604f,
	-0.468689f, -0.468774f, -0.468858f, -0.468943f, -0.469028f, -0.469112f, -0.469197f, -0.469282f,
	-0.469366f, -0.469451f, -0.469536f, -0.469620f, -0.469705f, -0.469789f, -0.469874f, -0.469959f,
	-0.470043f, -0.470128f, -0.470213f, -0.470297f, -0.470382f, -0.470466f, -0.470551f, -0.470636f,
	-0.470720f, -0.470805f, -0.470889f, -0.470974f, -0.471058f, -0.471143f, -0.471228f, -0.471312f,
	-0.471397f, -0.471481f, -0.471566f, -0.471650f, -0.471735f, -0.471819f, -0.471904f, -0.471988f,
	-0.472073f, -0.472158f, -0.472242f, -0.472327f, -0.472411f, -0.472496f, -0.472580f, -0.472665f,
	-0.472749f, -0.472834f, -0.472918f, -0.473002f, -0.473087f, -0.473171f, -0.473256f, -0.473340f,
	-0.473425f, -0.473509f, -0.473594f, -0.473678f, -0.473763f, -0.473847f, -0.473931f, -0.474016f,
	-0.474100f, -0.474185f, -0.474269f, -0.474353f, -0.474438f, -0.474522f, -0.474607f, -0.474691f,
	-0.474775f, -0.474860f, -0.474944f, -0.475029f, -0.475113f, -0.475197f, -0.475282f, -0.475366f,
	-0.475450f, -0.475535f, -0.475619f, -0.475703f, -0.475788f, -0.475872f, -0.475956f, -0.476041f,
	-0.476125f, -0.476209f, -0.476294f, -0.476378f, -0.476462f, -0.476546f, -0.476631f, -0.476715f,
	-0.476799f, -0.476884f, -0.476968f, -0.477052f, -0.477136f, -0.477221f, -0.477305f, -0.477389f,
	-0.477473f, -0.477558f, -0.477642f, -0.477726f, -0.477810f, -0.477894f, -0.477979f, -0.478063f,
	-0.478147f, -0.478231f, -0.478315f, -0.478400f, -0.478484f, -0.478568f, -0.478652f, -0.478736f,
	-0.478821f, -0.478905f, -0.478989f, -0.479073f, -0.479157f, -0.479241f, -0.479325f, -0.479410f,
	-0.479494f, -0.479578f, -0.479662f, -0.479746f, -0.479830f, -0.479914f, -0.479998f, -0.480083f,
	-0.480167f, -0.480251f, -0.480335f, -0.480419f, -0.480503f, -0.480587f, -0.480671f, -0.480755f,
	-0.480839f, -0.480923f, -0.481007f, -0.481091f, -0.481176f, -0.481260f, -0.481344f, -0.481428f,
	-0.481512f, -0.481596f, -0.481680f, -0.481764f, -0.481848f, -0.481932f, -0.482016f, -0.482100f,
	-0.482184f, -0.482268f, -0.482352f, -0.482436f, -0.482520f, -0.482604f, -0.482688f, -0.482772f,
	-0.482856f, -0.482940f, -0.483023f, -0.483107f, -0.483191f, -0.483275f, -0.483359f, -0.483443f,
	-0.483527f, -0.483611f, -0.483695f, -0.483779f, -0.483863f, -0.483947f, -0.484031f, -0.484114f,
	-0.484198f, -0.484282f, -0.484366f, -0.484450f, -0.484534f, -0.484618f, -0.484702f, -0.484785f,
	-0.484869f, -0.484953f, -0.485037f, -0.485121f, -0.485205f, -0.485288f, -0.485372f, -0.485456f,
	-0.485540f, -0.485624f, -0.485708f, -0.485791f, -0.485875f, -0.485959f, -0.486043f, -0.486126f,
	-0.486210f, -0.486294f, -0.486378f, -0.486462f, -0.486545f, -0.486629f, -0.486713f, -0.486797f,
	-0.486880f, -0.486964f, -0.487048f, -0.487132f, -0.487215f, -0.487299f, -0.487383f, -0.487466f,
	-0.487550f, -0.487634f, -0.487718f, -0.487801f, -0.487885f, -0.487969f, -0.488052f, -0.488136f,
	-0.488220f, -0.488303f, -0.488387f, -0.488471f, -0.488554f, -0.488638f, -0.488722f, -0.488805f,
	-0.488889f, -0.488973f, -0.489056f, -0.489140f, -0.489223f, -0.489307f, -0.489391f, -0.489474f,
	-0.489558f, -0.489641f, -0.489725f, -0.489809f, -0.489892f, -0.489976f, -0.490059f, -0.490143f,
	-0.490226f, -0.490310f, -0.490394f, -0.490477f, -0.490561f, -0.490644f, -0.490728f, -0.490811f,
	-0.490895f, -0.490978f, -0.491062f, -0.491145f, -0.491229f, -0.491312f, -0.491396f, -0.491479f,
	-0.491563f, -0.491646f, -0.491730f, -0.491813f, -0.491897f, -0.491980f, -0.492064f, -0.492147f,
	-0.492231f, -0.492314f, -0.492398f, -0.492481f, -0.492564f, -0.492648f, -0.492731f, -0.492815f,
	-0.492898f, -0.492982f, -0.493065f, -0.493148f, -0.493232f, -0.493315f, -0.493399f, -0.493482f,
	-0.493565f, -0.493649f, -0.493732f, -0.493816f, -0.493899f, -0.493982f, -0.494066f, -0.494149f,
	-0.494232f, -0.494316f, -0.494399f, -0.494482f, -0.494566f, -0.494649f, -0.494732f, -0.494816f,
	-0.494899f, -0.494982f, -0.495066f, -0.495149f, -0.495232f, -0.495315f, -0.495399f, -0.495482f,
	-0.495565f, -0.495649f, -0.495732f, -0.495815f, -0.495898f, -0.495982f, -0.496065f, -0.496148f,
	-0.496231f, -0.496315f, -0.496398f, -0.496481f, -0.496564f, -0.496647f, -0.496731f, -0.496814f,
	-0.496897f, -0.496980f, -0.497063f, -0.497147f, -0.497230f, -0.497313f, -0.497396f, -0.497479f,
	-0.497562f, -0.497646f, -0.497729f, -0.497812f, -0.497895f, -0.497978f, -0.498061f, -0.498145f,
	-0.498228f, -0.498311f, -0.498394f, -0.498477f, -0.498560f, -0.498643f, -0.498726f, -0.498809f,
	-0.498893f, -0.498976f, -0.499059f, -0.499142f, -0.499225f, -0.499308f, -0.499391f, -0.499474f,
	-0.499557f, -0.499640f, -0.499723f, -0.499806f, -0.499889f, -0.499972f, -0.500055f, -0.500138f,
	-0.500221f, -0.500304f, -0.500387f, -0.500470f, -0.500553f, -0.500636f, -0.500719f, -0.500802f,
	-0.500885f, -0.500968f, -0.501051f, -0.501134f, -0.501217f, -0.501300f, -0.501383f, -0.501466f,
	-0.501549f, -0.501632f, -0.501715f, -0.501798f, -0.501881f, -0.501964f, -0.502047f, -0.502130f,
	-0.502212f, -0.502295f, -0.502378f, -0.502461f, -0.502544f, -0.502627f, -0.502710f, -0.502793f,
	-0.502876f, -0.502958f, -0.503041f, -0.503124f, -0.503207f, -0.503290f, -0.503373f, -0.503456f,
	-0.503538f, -0.503621f, -0.503704f, -0.503787f, -0.503870f, -0.503953f, -0.504035f, -0.504118f,
	-0.504201f, -0.504284f, -0.504366f, -0.504449f, -0.504532f, -0.504615f, -0.504698f, -0.504780f,
	-0.504863f, -0.504946f, -0.505029f, -0.505111f, -0.505194f, -0.505277f, -0.505360f, -0.505442f,
	-0.505525f, -0.505608f, -0.505690f, -0.505773f, -0.505856f, -0.505939f, -0.506021f, -0.506104f,
	-0.506187f, -0.506269f, -0.506352f, -0.506435f, -0.506517f, -0.506600f, -0.506683f, -0.506765f,
	-0.506848f, -0.506931f, -0.507013f, -0.507096f, -0.507179f, -0.507261f, -0.507344f, -0.507426f,
	-0.507509f, -0.507592f, -0.507674f, -0.507757f, -0.507839f, -0.507922f, -0.508005f, -0.508087f,
	-0.508170f, -0.508252f, -0.508335f, -0.508417f, -0.508500f, -0.508583f, -0.508665f, -0.508748f,
	-0.508830f, -0.508913f, -0.508995f, -0.509078f, -0.509160f, -0.509243f, -0.509325f, -0.509408f,
	-0.509490f, -0.509573f, -0.509655f, -0.509738f, -0.509820f, -0.509903f, -0.509985f, -0.510068f,
	-0.510150f, -0.510233f, -0.510315f, -0.510397f, -0.510480f, -0.510562f, -0.510645f, -0.510727f,
	-0.510810f, -0.510892f, -0.510974f, -0.511057f, -0.511139f, -0.511222f, -0.511304f, -0.511386f,
	-0.511469f, -0.511551f, -0.511634f, -0.511716f, -0.511798f, -0.511881f, -0.511963f, -0.512045f,
	-0.512128f, -0.512210f, -0.512292f, -0.512375f, -0.512457f, -0.512539f, -0.512622f, -0.512704f,
	-0.512786f, -0.512869f, -0.512951f, -0.513033f, -0.513116f, -0.513198f, -0.513280f, -0.513362f,
	-0.513445f, -0.513527f, -0.513609f, -0.513692f, -0.513774f, -0.513856f, -0.513938f, -0.514021f,
	-0.514103f, -0.514185f, -0.514267f, -0.514349f, -0.514432f, -0.514514f, -0.514596f, -0.514678f,
	-0.514760f, -0.514843f, -0.514925f, -0.515007f, -0.515089f, -0.515171f, -0.515254f, -0.515336f,
	-0.515418f, -0.515500f, -0.515582f, -0.515664f, -0.515746f, -0.515829f, -0.515911f, -0.515993f,
	-0.516075f, -0.516157f, -0.516239f, -0.516321f, -0.516403f, -0.516486f, -0.516568f, -0.516650f,
	-0.516732f, -0.516814f, -0.516896f, -0.516978f, -0.517060f, -0.517142f, -0.517224f, -0.517306f,
	-0.517388f, -0.517470f, -0.517552f, -0.517634f, -0.517716f, -0.517798f, -0.517880f, -0.517963f,
	-0.518045f, -0.518126f, -0.518209f, -0.518291f, -0.518372f, -0.518454f, -0.518536f, -0.518618f,
	-0.518700f, -0.518782f, -0.518864f, -0.518946f, -0.519028f, -0.519110f, -0.519192f, -0.519274f,
	-0.519356f, -0.519438f, -0.519520f, -0.519602f, -0.519684f, -0.519766f, -0.519848f, -0.519929f,
	-0.520011f, -0.520093f, -0.520175f, -0.520257f, -0.520339f, -0.520421f, -0.520503f, -0.520584f,
	-0.520666f, -0.520748f, -0.520830f, -0.520912f, -0.520994f, -0.521075f, -0.521157f, -0.521239f,
	-0.521321f, -0.521403f, -0.521485f, -0.521566f, -0.521648f, -0.521730f, -0.521812f, -0.521894f,
	-0.521975f, -0.522057f, -0.522139f, -0.522221f, -0.522302f, -0.522384f, -0.522466f, -0.522548f,
	-0.522629f, -0.522711f, -0.522793f, -0.522875f, -0.522956f, -0.523038f, -0.523120f, -0.523201f,
	-0.523283f, -0.523365f, -0.523447f, -0.523528f, -0.523610f, -0.523692f, -0.523773f, -0.523855f,
	-0.523937f, -0.524018f, -0.524100f, -0.524181f, -0.524263f, -0.524345f, -0.524426f, -0.524508f,
	-0.524590f, -0.524671f, -0.524753f, -0.524835f, -0.524916f, -0.524998f, -0.525079f, -0.525161f,
	-0.525243f, -0.525324f, -0.525406f, -0.525487f, -0.525569f, -0.525650f, -0.525732f, -0.525813f,
	-0.525895f, -0.525977f, -0.526058f, -0.526140f, -0.526221f, -0.526303f, -0.526384f, -0.526466f,
	-0.526547f, -0.526629f, -0.526710f, -0.526792f, -0.526873f, -0.526955f, -0.527036f, -0.527118f,
	-0.527199f, -0.527281f, -0.527362f, -0.527444f, -0.527525f, -0.527606f, -0.527688f, -0.527769f,
	-0.527851f, -0.527932f, -0.528014f, -0.528095f, -0.528176f, -0.528258f, -0.528339f, -0.528421f,
	-0.528502f, -0.528583f, -0.528665f, -0.528746f, -0.528828f, -0.528909f, -0.528990f, -0.529072f,
	-0.529153f, -0.529234f, -0.529316f, -0.529397f, -0.529478f, -0.529560f, -0.529641f, -0.529722f,
	-0.529804f, -0.529885f, -0.529966f, -0.530048f, -0.530129f, -0.530210f, -0.530291f, -0.530373f,
	-0.530454f, -0.530535f, -0.530617f, -0.530698f, -0.530779f, -0.530860f, -0.530942f, -0.531023f,
	-0.531104f, -0.531185f, -0.531266f, -0.531348f, -0.531429f, -0.531510f, -0.531591f, -0.531673f,
	-0.531754f, -0.531835f, -0.531916f, -0.531997f, -0.532078f, -0.532160f, -0.532241f, -0.532322f,
	-0.532403f, -0.532484f, -0.532565f, -0.532647f, -0.532728f, -0.532809f, -0.532890f, -0.532971f,
	-0.533052f, -0.533133f, -0.533214f, -0.533296f, -0.533377f, -0.533458f, -0.533539f, -0.533620f,
	-0.533701f, -0.533782f, -0.533863f, -0.533944f, -0.534025f, -0.534106f, -0.534187f, -0.534268f,
	-0.534349f, -0.534431f, -0.534512f, -0.534593f, -0.534674f, -0.534755f, -0.534836f, -0.534917f,
	-0.534998f, -0.535079f, -0.535160f, -0.535241f, -0.535322f, -0.535403f, -0.535484f, -0.535564f,
	-0.535645f, -0.535726f, -0.535807f, -0.535888f, -0.535969f, -0.536050f, -0.536131f, -0.536212f,
	-0.536293f, -0.536374f, -0.536455f, -0.536536f, -0.536617f, -0.536698f, -0.536778f, -0.536859f,
	-0.536940f, -0.537021f, -0.537102f, -0.537183f, -0.537264f, -0.537345f, -0.537425f, -0.537506f,
	-0.537587f, -0.537668f, -0.537749f, -0.537830f, -0.537910f, -0.537991f, -0.538072f, -0.538153f,
	-0.538234f, -0.538314f, -0.538395f, -0.538476f, -0.538557f, -0.538638f, -0.538718f, -0.538799f,
	-0.538880f, -0.538961f, -0.539041f, -0.539122f, -0.539203f, -0.539284f, -0.539364f, -0.539445f,
	-0.539526f, -0.539607f, -0.539687f, -0.539768f, -0.539849f, -0.539929f, -0.540010f, -0.540091f,
	-0.540171f, -0.540252f, -0.540333f, -0.540413f, -0.540494f, -0.540575f, -0.540655f, -0.540736f,
	-0.540817f, -0.540897f, -0.540978f, -0.541059f, -0.541139f, -0.541220f, -0.541301f, -0.541381f,
	-0.541462f, -0.541542f, -0.541623f, -0.541704f, -0.541784f, -0.541865f, -0.541945f, -0.542026f,
	-0.542106f, -0.542187f, -0.542268f, -0.542348f, -0.542429f, -0.542509f, -0.542590f, -0.542670f,
	-0.542751f, -0.542831f, -0.542912f, -0.542992f, -0.543073f, -0.543153f, -0.543234f, -0.543314f,
	-0.543395f, -0.543475f, -0.543556f, -0.543636f, -0.543717f, -0.543797f, -0.543878f, -0.543958f,
	-0.544039f, -0.544119f, -0.544199f, -0.544280f, -0.544360f, -0.544441f, -0.544521f, -0.544602f,
	-0.544682f, -0.544762f, -0.544843f, -0.544923f, -0.545003f, -0.545084f, -0.545164f, -0.545245f,
	-0.545325f, -0.545405f, -0.545486f, -0.545566f, -0.545646f, -0.545727f, -0.545807f, -0.545887f,
	-0.545968f, -0.546048f, -0.546128f, -0.546209f, -0.546289f, -0.546369f, -0.546450f, -0.546530f,
	-0.546610f, -0.546690f, -0.546771f, -0.546851f, -0.546931f, -0.547011f, -0.547092f, -0.547172f,
	-0.547252f, -0.547333f, -0.547413f, -0.547493f, -0.547573f, -0.547653f, -0.547734f, -0.547814f,
	-0.547894f, -0.547974f, -0.548054f, -0.548135f, -0.548215f, -0.548295f, -0.548375f, -0.548455f,
	-0.548536f, -0.548616f, -0.548696f, -0.548776f, -0.548856f, -0.548936f, -0.549016f, -0.549097f,
	-0.549177f, -0.549257f, -0.549337f, -0.549417f, -0.549497f, -0.549577f, -0.549657f, -0.549737f,
	-0.549818f, -0.549898f, -0.549978f, -0.550058f, -0.550138f, -0.550218f, -0.550298f, -0.550378f,
	-0.550458f, -0.550538f, -0.550618f, -0.550698f, -0.550778f, -0.550858f, -0.550938f, -0.551018f,
	-0.551098f, -0.551178f, -0.551258f, -0.551338f, -0.551418f, -0.551498f, -0.551578f, -0.551658f,
	-0.551738f, -0.551818f, -0.551898f, -0.551978f, -0.552058f, -0.552138f, -0.552218f, -0.552298f,
	-0.552378f, -0.552457f, -0.552537f, -0.552617f, -0.552697f, -0.552777f, -0.552857f, -0.552937f,
	-0.553017f, -0.553097f, -0.553176f, -0.553256f, -0.553336f, -0.553416f, -0.553496f, -0.553576f,
	-0.553656f, -0.553735f, -0.553815f, -0.553895f, -0.553975f, -0.554055f, -0.554134f, -0.554214f,
	-0.554294f, -0.554374f, -0.554454f, -0.554533f, -0.554613f, -0.554693f, -0.554773f, -0.554853f,
	-0.554932f, -0.555012f, -0.555092f, -0.555172f, -0.555251f, -0.555331f, -0.555411f, -0.555490f,
	-0.555570f, -0.555650f, -0.555730f, -0.555809f, -0.555889f, -0.555969f, -0.556048f, -0.556128f,
	-0.556208f, -0.556287f, -0.556367f, -0.556447f, -0.556526f, -0.556606f, -0.556686f, -0.556765f,
	-0.556845f, -0.556925f, -0.557004f, -0.557084f, -0.557164f, -0.557243f, -0.557323f, -0.557402f,
	-0.557482f, -0.557562f, -0.557641f, -0.557721f, -0.557800f, -0.557880f, -0.557959f, -0.558039f,
	-0.558119f, -0.558198f, -0.558278f, -0.558357f, -0.558437f, -0.558516f, -0.558596f, -0.558675f,
	-0.558755f, -0.558834f, -0.558914f, -0.558993f, -0.559073f, -0.559152f, -0.559232f, -0.559311f,
	-0.559391f, -0.559470f, -0.559550f, -0.559629f, -0.559709f, -0.559788f, -0.559867f, -0.559947f,
	-0.560026f, -0.560106f, -0.560185f, -0.560265f, -0.560344f, -0.560423f, -0.560503f, -0.560582f,
	-0.560662f, -0.560741f, -0.560820f, -0.560900f, -0.560979f, -0.561058f, -0.561138f, -0.561217f,
	-0.561297f, -0.561376f, -0.561455f, -0.561535f, -0.561614f, -0.561693f, -0.561773f, -0.561852f,
	-0.561931f, -0.562010f, -0.562090f, -0.562169f, -0.562248f, -0.562328f, -0.562407f, -0.562486f,
	-0.562565f, -0.562645f, -0.562724f, -0.562803f, -0.562882f, -0.562962f, -0.563041f, -0.563120f,
	-0.563199f, -0.563279f, -0.563358f, -0.563437f, -0.563516f, -0.563595f, -0.563675f, -0.563754f,
	-0.563833f, -0.563912f, -0.563991f, -0.564070f, -0.564150f, -0.564229f, -0.564308f, -0.564387f,
	-0.564466f, -0.564545f, -0.564624f, -0.564704f, -0.564783f, -0.564862f, -0.564941f, -0.565020f,
	-0.565099f, -0.565178f, -0.565257f, -0.565336f, -0.565416f, -0.565495f, -0.565574f, -0.565653f,
	-0.565732f, -0.565811f, -0.565890f, -0.565969f, -0.566048f, -0.566127f, -0.566206f, -0.566285f,
	-0.566364f, -0.566443f, -0.566522f, -0.566601f, -0.566680f, -0.566759f, -0.566838f, -0.566917f,
	-0.566996f, -0.567075f, -0.567154f, -0.567233f, -0.567312f, -0.567391f, -0.567470f, -0.567549f,
	-0.567628f, -0.567707f, -0.567786f, -0.567864f, -0.567943f, -0.568022f, -0.568101f, -0.568180f,
	-0.568259f, -0.568338f, -0.568417f, -0.568496f, -0.568574f, -0.568653f, -0.568732f, -0.568811f,
	-0.568890f, -0.568969f, -0.569048f, -0.569126f, -0.569205f, -0.569284f, -0.569363f, -0.569442f,
	-0.569521f, -0.569599f, -0.569678f, -0.569757f, -0.569836f, -0.569914f, -0.569993f, -0.570072f,
	-0.570151f, -0.570230f, -0.570308f, -0.570387f, -0.570466f, -0.570545f, -0.570623f, -0.570702f,
	-0.570781f, -0.570859f, -0.570938f, -0.571017f, -0.571096f, -0.571174f, -0.571253f, -0.571332f,
	-0.571410f, -0.571489f, -0.571568f, -0.571646f, -0.571725f, -0.571804f, -0.571882f, -0.571961f,
	-0.572040f, -0.572118f, -0.572197f, -0.572276f, -0.572354f, -0.572433f, -0.572511f, -0.572590f,
	-0.572669f, -0.572747f, -0.572826f, -0.572904f, -0.572983f, -0.573061f, -0.573140f, -0.573219f,
	-0.573297f, -0.573376f, -0.573454f, -0.573533f, -0.573611f, -0.573690f, -0.573768f, -0.573847f,
	-0.573925f, -0.574004f, -0.574082f, -0.574161f, -0.574239f, -0.574318f, -0.574396f, -0.574475f,
	-0.574553f, -0.574632f, -0.574710f, -0.574789f, -0.574867f, -0.574946f, -0.575024f, -0.575103f,
	-0.575181f, -0.575259f, -0.575338f, -0.575416f, -0.575495f, -0.575573f, -0.575651f, -0.575730f,
	-0.575808f, -0.575887f, -0.575965f, -0.576043f, -0.576122f, -0.576200f, -0.576278f, -0.576357f,
	-0.576435f, -0.576513f, -0.576592f, -0.576670f, -0.576748f, -0.576827f, -0.576905f, -0.576983f,
	-0.577062f, -0.577140f, -0.577218f, -0.577297f, -0.577375f, -0.577453f, -0.577531f, -0.577610f,
	-0.577688f, -0.577766f, -0.577844f, -0.577923f, -0.578001f, -0.578079f, -0.578157f, -0.578236f,
	-0.578314f, -0.578392f, -0.578470f, -0.578548f, -0.578627f, -0.578705f, -0.578783f, -0.578861f,
	-0.578939f, -0.579018f, -0.579096f, -0.579174f, -0.579252f, -0.579330f, -0.579408f, -0.579486f,
	-0.579565f, -0.579643f, -0.579721f, -0.579799f, -0.579877f, -0.579955f, -0.580033f, -0.580111f,
	-0.580189f, -0.580267f, -0.580346f, -0.580424f, -0.580502f, -0.580580f, -0.580658f, -0.580736f,
	-0.580814f, -0.580892f, -0.580970f, -0.581048f, -0.581126f, -0.581204f, -0.581282f, -0.581360f,
	-0.581438f, -0.581516f, -0.581594f, -0.581672f, -0.581750f, -0.581828f, -0.581906f, -0.581984f,
	-0.582062f, -0.582140f, -0.582218f, -0.582296f, -0.582374f, -0.582452f, -0.582530f, -0.582608f,
	-0.582685f, -0.582763f, -0.582841f, -0.582919f, -0.582997f, -0.583075f, -0.583153f, -0.583231f,
	-0.583309f, -0.583387f, -0.583464f, -0.583542f, -0.583620f, -0.583698f, -0.583776f, -0.583854f,
	-0.583931f, -0.584009f, -0.584087f, -0.584165f, -0.584243f, -0.584321f, -0.584398f, -0.584476f,
	-0.584554f, -0.584632f, -0.584710f, -0.584787f, -0.584865f, -0.584943f, -0.585021f, -0.585098f,
	-0.585176f, -0.585254f, -0.585332f, -0.585409f, -0.585487f, -0.585565f, -0.585642f, -0.585720f,
	-0.585798f, -0.585876f, -0.585953f, -0.586031f, -0.586109f, -0.586186f, -0.586264f, -0.586342f,
	-0.586419f, -0.586497f, -0.586575f, -0.586652f, -0.586730f, -0.586808f, -0.586885f, -0.586963f,
	-0.587040f, -0.587118f, -0.587196f, -0.587273f, -0.587351f, -0.587428f, -0.587506f, -0.587584f,
	-0.587661f, -0.587739f, -0.587816f, -0.587894f, -0.587971f, -0.588049f, -0.588126f, -0.588204f,
	-0.588282f, -0.588359f, -0.588437f, -0.588514f, -0.588592f, -0.588669f, -0.588747f, -0.588824f,
	-0.588902f, -0.588979f, -0.589057f, -0.589134f, -0.589212f, -0.589289f, -0.589366f, -0.589444f,
	-0.589521f, -0.589599f, -0.589676f, -0.589754f, -0.589831f, -0.589908f, -0.589986f, -0.590063f,
	-0.590141f, -0.590218f, -0.590295f, -0.590373f, -0.590450f, -0.590528f, -0.590605f, -0.590682f,
	-0.590760f, -0.590837f, -0.590914f, -0.590992f, -0.591069f, -0.591146f, -0.591224f, -0.591301f,
	-0.591378f, -0.591456f, -0.591533f, -0.591610f, -0.591688f, -0.591765f, -0.591842f, -0.591919f,
	-0.591997f, -0.592074f, -0.592151f, -0.592228f, -0.592306f, -0.592383f, -0.592460f, -0.592537f,
	-0.592615f, -0.592692f, -0.592769f, -0.592846f, -0.592924f, -0.593001f, -0.593078f, -0.593155f,
	-0.593232f, -0.593309f, -0.593387f, -0.593464f, -0.593541f, -0.593618f, -0.593695f, -0.593772f,
	-0.593850f, -0.593927f, -0.594004f, -0.594081f, -0.594158f, -0.594235f, -0.594312f, -0.594389f,
	-0.594467f, -0.594544f, -0.594621f, -0.594698f, -0.594775f, -0.594852f, -0.594929f, -0.595006f,
	-0.595083f, -0.595160f, -0.595237f, -0.595314f, -0.595391f, -0.595468f, -0.595545f, -0.595622f,
	-0.595699f, -0.595776f, -0.595853f, -0.595930f, -0.596007f, -0.596084f, -0.596161f, -0.596238f,
	-0.596315f, -0.596392f, -0.596469f, -0.596546f, -0.596623f, -0.596700f, -0.596777f, -0.596854f,
	-0.596931f, -0.597008f, -0.597085f, -0.597161f, -0.597238f, -0.597315f, -0.597392f, -0.597469f,
	-0.597546f, -0.597623f, -0.597700f, -0.597776f, -0.597853f, -0.597930f, -0.598007f, -0.598084f,
	-0.598161f, -0.598238f, -0.598314f, -0.598391f, -0.598468f, -0.598545f, -0.598622f, -0.598698f,
	-0.598775f, -0.598852f, -0.598929f, -0.599006f, -0.599082f, -0.599159f, -0.599236f, -0.599313f,
	-0.599389f, -0.599466f, -0.599543f, -0.599620f, -0.599696f, -0.599773f, -0.599850f, -0.599926f,
	-0.600003f, -0.600080f, -0.600156f, -0.600233f, -0.600310f, -0.600387f, -0.600463f, -0.600540f,
	-0.600616f, -0.600693f, -0.600770f, -0.600846f, -0.600923f, -0.601000f, -0.601076f, -0.601153f,
	-0.601230f, -0.601306f, -0.601383f, -0.601459f, -0.601536f, -0.601613f, -0.601689f, -0.601766f,
	-0.601842f, -0.601919f, -0.601995f, -0.602072f, -0.602148f, -0.602225f, -0.602302f, -0.602378f,
	-0.602455f, -0.602531f, -0.602608f, -0.602684f, -0.602761f, -0.602837f, -0.602914f, -0.602990f,
	-0.603067f, -0.603143f, -0.603220f, -0.603296f, -0.603372f, -0.603449f, -0.603525f, -0.603602f,
	-0.603678f, -0.603755f, -0.603831f, -0.603908f, -0.603984f, -0.604060f, -0.604137f, -0.604213f,
	-0.604290f, -0.604366f, -0.604442f, -0.604519f, -0.604595f, -0.604671f, -0.604748f, -0.604824f,
	-0.604900f, -0.604977f, -0.605053f, -0.605129f, -0.605206f, -0.605282f, -0.605358f, -0.605435f,
	-0.605511f, -0.605587f, -0.605664f, -0.605740f, -0.605816f, -0.605892f, -0.605969f, -0.606045f,
	-0.606121f, -0.606198f, -0.606274f, -0.606350f, -0.606426f, -0.606502f, -0.606579f, -0.606655f,
	-0.606731f, -0.606807f, -0.606884f, -0.606960f, -0.607036f, -0.607112f, -0.607188f, -0.607264f,
	-0.607341f, -0.607417f, -0.607493f, -0.607569f, -0.607645f, -0.607721f, -0.607798f, -0.607874f,
	-0.607950f, -0.608026f, -0.608102f, -0.608178f, -0.608254f, -0.608330f, -0.608406f, -0.608482f,
	-0.608559f, -0.608635f, -0.608711f, -0.608787f, -0.608863f, -0.608939f, -0.609015f, -0.609091f,
	-0.609167f, -0.609243f, -0.609319f, -0.609395f, -0.609471f, -0.609547f, -0.609623f, -0.609699f,
	-0.609775f, -0.609851f, -0.609927f, -0.610003f, -0.610079f, -0.610155f, -0.610231f, -0.610307f,
	-0.610383f, -0.610459f, -0.610535f, -0.610611f, -0.610687f, -0.610762f, -0.610838f, -0.610914f,
	-0.610990f, -0.611066f, -0.611142f, -0.611218f, -0.611294f, -0.611370f, -0.611445f, -0.611521f,
	-0.611597f, -0.611673f, -0.611749f, -0.611825f, -0.611901f, -0.611976f, -0.612052f, -0.612128f,
	-0.612204f, -0.612280f, -0.612355f, -0.612431f, -0.612507f, -0.612583f, -0.612659f, -0.612734f,
	-0.612810f, -0.612886f, -0.612962f, -0.613037f, -0.613113f, -0.613189f, -0.613265f, -0.613340f,
	-0.613416f, -0.613492f, -0.613567f, -0.613643f, -0.613719f, -0.613795f, -0.613870f, -0.613946f,
	-0.614022f, -0.614097f, -0.614173f, -0.614249f, -0.614324f, -0.614400f, -0.614475f, -0.614551f,
	-0.614627f, -0.614702f, -0.614778f, -0.614854f, -0.614929f, -0.615005f, -0.615080f, -0.615156f,
	-0.615232f, -0.615307f, -0.615383f, -0.615458f, -0.615534f, -0.615609f, -0.615685f, -0.615761f,
	-0.615836f, -0.615912f, -0.615987f, -0.616063f, -0.616138f, -0.616214f, -0.616289f, -0.616365f,
	-0.616440f, -0.616516f, -0.616591f, -0.616667f, -0.616742f, -0.616818f, -0.616893f, -0.616968f,
	-0.617044f, -0.617119f, -0.617195f, -0.617270f, -0.617346f, -0.617421f, -0.617496f, -0.617572f,
	-0.617647f, -0.617723f, -0.617798f, -0.617873f, -0.617949f, -0.618024f, -0.618100f, -0.618175f,
	-0.618250f, -0.618326f, -0.618401f, -0.618476f, -0.618552f, -0.618627f, -0.618702f, -0.618778f,
	-0.618853f, -0.618928f, -0.619004f, -0.619079f, -0.619154f, -0.619229f, -0.619305f, -0.619380f,
	-0.619455f, -0.619531f, -0.619606f, -0.619681f, -0.619756f, -0.619832f, -0.619907f, -0.619982f,
	-0.620057f, -0.620132f, -0.620208f, -0.620283f, -0.620358f, -0.620433f, -0.620508f, -0.620584f,
	-0.620659f, -0.620734f, -0.620809f, -0.620884f, -0.620959f, -0.621035f, -0.621110f, -0.621185f,
	-0.621260f, -0.621335f, -0.621410f, -0.621485f, -0.621560f, -0.621636f, -0.621711f, -0.621786f,
	-0.621861f, -0.621936f, -0.622011f, -0.622086f, -0.622161f, -0.622236f, -0.622311f, -0.622386f,
	-0.622461f, -0.622536f, -0.622611f, -0.622686f, -0.622761f, -0.622836f, -0.622911f, -0.622986f,
	-0.623061f, -0.623136f, -0.623211f, -0.623286f, -0.623361f, -0.623436f, -0.623511f, -0.623586f,
	-0.623661f, -0.623736f, -0.623811f, -0.623886f, -0.623961f, -0.624036f, -0.624111f, -0.624186f,
	-0.624260f, -0.624335f, -0.624410f, -0.624485f, -0.624560f, -0.624635f, -0.624710f, -0.624785f,
	-0.624860f, -0.624934f, -0.625009f, -0.625084f, -0.625159f, -0.625234f, -0.625309f, -0.625383f,
	-0.625458f, -0.625533f, -0.625608f, -0.625683f, -0.625757f, -0.625832f, -0.625907f, -0.625982f,
	-0.626056f, -0.626131f, -0.626206f, -0.626281f, -0.626355f, -0.626430f, -0.626505f, -0.626580f,
	-0.626654f, -0.626729f, -0.626804f, -0.626878f, -0.626953f, -0.627028f, -0.627102f, -0.627177f,
	-0.627252f, -0.627326f, -0.627401f, -0.627476f, -0.627550f, -0.627625f, -0.627700f, -0.627774f,
	-0.627849f, -0.627924f, -0.627998f, -0.628073f, -0.628147f, -0.628222f, -0.628297f, -0.628371f,
	-0.628446f, -0.628520f, -0.628595f, -0.628669f, -0.628744f, -0.628819f, -0.628893f, -0.628968f,
	-0.629042f, -0.629117f, -0.629191f, -0.629266f, -0.629340f, -0.629415f, -0.629489f, -0.629564f,
	-0.629638f, -0.629713f, -0.629787f, -0.629862f, -0.629936f, -0.630011f, -0.630085f, -0.630159f,
	-0.630234f, -0.630308f, -0.630383f, -0.630457f, -0.630532f, -0.630606f, -0.630680f, -0.630755f,
	-0.630829f, -0.630904f, -0.630978f, -0.631052f, -0.631127f, -0.631201f, -0.631275f, -0.631350f,
	-0.631424f, -0.631499f, -0.631573f, -0.631647f, -0.631721f, -0.631796f, -0.631870f, -0.631944f,
	-0.632019f, -0.632093f, -0.632167f, -0.632242f, -0.632316f, -0.632390f, -0.632464f, -0.632539f,
	-0.632613f, -0.632687f, -0.632761f, -0.632836f, -0.632910f, -0.632984f, -0.633058f, -0.633133f,
	-0.633207f, -0.633281f, -0.633355f, -0.633429f, -0.633504f, -0.633578f, -0.633652f, -0.633726f,
	-0.633800f, -0.633874f, -0.633949f, -0.634023f, -0.634097f, -0.634171f, -0.634245f, -0.634319f,
	-0.634393f, -0.634467f, -0.634542f, -0.634616f, -0.634690f, -0.634764f, -0.634838f, -0.634912f,
	-0.634986f, -0.635060f, -0.635134f, -0.635208f, -0.635282f, -0.635356f, -0.635430f, -0.635504f,
	-0.635578f, -0.635652f, -0.635726f, -0.635800f, -0.635874f, -0.635948f, -0.636022f, -0.636096f,
	-0.636170f, -0.636244f, -0.636318f, -0.636392f, -0.636466f, -0.636540f, -0.636614f, -0.636688f,
	-0.636762f, -0.636836f, -0.636910f, -0.636984f, -0.637057f, -0.637131f, -0.637205f, -0.637279f,
	-0.637353f, -0.637427f, -0.637501f, -0.637575f, -0.637649f, -0.637722f, -0.637796f, -0.637870f,
	-0.637944f, -0.638018f, -0.638092f, -0.638165f, -0.638239f, -0.638313f, -0.638387f, -0.638461f,
	-0.638534f, -0.638608f, -0.638682f, -0.638756f, -0.638829f, -0.638903f, -0.638977f, -0.639051f,
	-0.639124f, -0.639198f, -0.639272f, -0.639346f, -0.639419f, -0.639493f, -0.639567f, -0.639640f,
	-0.639714f, -0.639788f, -0.639862f, -0.639935f, -0.640009f, -0.640083f, -0.640156f, -0.640230f,
	-0.640303f, -0.640377f, -0.640451f, -0.640524f, -0.640598f, -0.640672f, -0.640745f, -0.640819f,
	-0.640892f, -0.640966f, -0.641040f, -0.641113f, -0.641187f, -0.641260f, -0.641334f, -0.641407f,
	-0.641481f, -0.641555f, -0.641628f, -0.641702f, -0.641775f, -0.641849f, -0.641922f, -0.641996f,
	-0.642069f, -0.642143f, -0.642216f, -0.642290f, -0.642363f, -0.642437f, -0.642510f, -0.642584f,
	-0.642657f, -0.642730f, -0.642804f, -0.642877f, -0.642951f, -0.643024f, -0.643098f, -0.643171f,
	-0.643245f, -0.643318f, -0.643391f, -0.643465f, -0.643538f, -0.643611f, -0.643685f, -0.643758f,
	-0.643832f, -0.643905f, -0.643978f, -0.644052f, -0.644125f, -0.644198f, -0.644272f, -0.644345f,
	-0.644418f, -0.644492f, -0.644565f, -0.644638f, -0.644711f, -0.644785f, -0.644858f, -0.644931f,
	-0.645005f, -0.645078f, -0.645151f, -0.645224f, -0.645298f, -0.645371f, -0.645444f, -0.645517f,
	-0.645590f, -0.645664f, -0.645737f, -0.645810f, -0.645883f, -0.645956f, -0.646030f, -0.646103f,
	-0.646176f, -0.646249f, -0.646322f, -0.646396f, -0.646469f, -0.646542f, -0.646615f, -0.646688f,
	-0.646761f, -0.646834f, -0.646907f, -0.646981f, -0.647054f, -0.647127f, -0.647200f, -0.647273f,
	-0.647346f, -0.647419f, -0.647492f, -0.647565f, -0.647638f, -0.647711f, -0.647784f, -0.647857f,
	-0.647930f, -0.648003f, -0.648076f, -0.648149f, -0.648222f, -0.648295f, -0.648368f, -0.648441f,
	-0.648514f, -0.648587f, -0.648660f, -0.648733f, -0.648806f, -0.648879f, -0.648952f, -0.649025f,
	-0.649098f, -0.649171f, -0.649244f, -0.649317f, -0.649390f, -0.649463f, -0.649536f, -0.649608f,
	-0.649681f, -0.649754f, -0.649827f, -0.649900f, -0.649973f, -0.650046f, -0.650119f, -0.650191f,
	-0.650264f, -0.650337f, -0.650410f, -0.650483f, -0.650555f, -0.650628f, -0.650701f, -0.650774f,
	-0.650847f, -0.650919f, -0.650992f, -0.651065f, -0.651138f, -0.651211f, -0.651283f, -0.651356f,
	-0.651429f, -0.651502f, -0.651574f, -0.651647f, -0.651720f, -0.651792f, -0.651865f, -0.651938f,
	-0.652011f, -0.652083f, -0.652156f, -0.652229f, -0.652301f, -0.652374f, -0.652447f, -0.652519f,
	-0.652592f, -0.652665f, -0.652737f, -0.652810f, -0.652882f, -0.652955f, -0.653028f, -0.653100f,
	-0.653173f, -0.653245f, -0.653318f, -0.653391f, -0.653463f, -0.653536f, -0.653608f, -0.653681f,
	-0.653753f, -0.653826f, -0.653899f, -0.653971f, -0.654044f, -0.654116f, -0.654189f, -0.654261f,
	-0.654334f, -0.654406f, -0.654479f, -0.654551f, -0.654624f, -0.654696f, -0.654769f, -0.654841f,
	-0.654913f, -0.654986f, -0.655058f, -0.655131f, -0.655203f, -0.655276f, -0.655348f, -0.655420f,
	-0.655493f, -0.655565f, -0.655638f, -0.655710f, -0.655782f, -0.655855f, -0.655927f, -0.656000f,
	-0.656072f, -0.656144f, -0.656217f, -0.656289f, -0.656361f, -0.656434f, -0.656506f, -0.656578f,
	-0.656651f, -0.656723f, -0.656795f, -0.656867f, -0.656940f, -0.657012f, -0.657084f, -0.657157f,
	-0.657229f, -0.657301f, -0.657373f, -0.657446f, -0.657518f, -0.657590f, -0.657662f, -0.657734f,
	-0.657807f, -0.657879f, -0.657951f, -0.658023f, -0.658095f, -0.658168f, -0.658240f, -0.658312f,
	-0.658384f, -0.658456f, -0.658529f, -0.658601f, -0.658673f, -0.658745f, -0.658817f, -0.658889f,
	-0.658961f, -0.659033f, -0.659105f, -0.659178f, -0.659250f, -0.659322f, -0.659394f, -0.659466f,
	-0.659538f, -0.659610f, -0.659682f, -0.659754f, -0.659826f, -0.659898f, -0.659970f, -0.660042f,
	-0.660114f, -0.660186f, -0.660258f, -0.660330f, -0.660402f, -0.660474f, -0.660546f, -0.660618f,
	-0.660690f, -0.660762f, -0.660834f, -0.660906f, -0.660978f, -0.661050f, -0.661122f, -0.661194f,
	-0.661266f, -0.661338f, -0.661410f, -0.661482f, -0.661553f, -0.661625f, -0.661697f, -0.661769f,
	-0.661841f, -0.661913f, -0.661985f, -0.662057f, -0.662128f, -0.662200f, -0.662272f, -0.662344f,
	-0.662416f, -0.662488f, -0.662559f, -0.662631f, -0.662703f, -0.662775f, -0.662847f, -0.662918f,
	-0.662990f, -0.663062f, -0.663134f, -0.663205f, -0.663277f, -0.663349f, -0.663421f, -0.663492f,
	-0.663564f, -0.663636f, -0.663708f, -0.663779f, -0.663851f, -0.663923f, -0.663994f, -0.664066f,
	-0.664138f, -0.664209f, -0.664281f, -0.664353f, -0.664424f, -0.664496f, -0.664568f, -0.664639f,
	-0.664711f, -0.664783f, -0.664854f, -0.664926f, -0.664997f, -0.665069f, -0.665141f, -0.665212f,
	-0.665284f, -0.665355f, -0.665427f, -0.665498f, -0.665570f, -0.665642f, -0.665713f, -0.665785f,
	-0.665856f, -0.665928f, -0.665999f, -0.666071f, -0.666142f, -0.666214f, -0.666285f, -0.666357f,
	-0.666428f, -0.666500f, -0.666571f, -0.666643f, -0.666714f, -0.666786f, -0.666857f, -0.666928f,
	-0.667000f, -0.667071f, -0.667143f, -0.667214f, -0.667286f, -0.667357f, -0.667428f, -0.667500f,
	-0.667571f, -0.667643f, -0.667714f, -0.667785f, -0.667857f, -0.667928f, -0.667999f, -0.668071f,
	-0.668142f, -0.668213f, -0.668285f, -0.668356f, -0.668427f, -0.668499f, -0.668570f, -0.668641f,
	-0.668712f, -0.668784f, -0.668855f, -0.668926f, -0.668998f, -0.669069f, -0.669140f, -0.669211f,
	-0.669283f, -0.669354f, -0.669425f, -0.669496f, -0.669567f, -0.669639f, -0.669710f, -0.669781f,
	-0.669852f, -0.669923f, -0.669995f, -0.670066f, -0.670137f, -0.670208f, -0.670279f, -0.670350f,
	-0.670422f, -0.670493f, -0.670564f, -0.670635f, -0.670706f, -0.670777f, -0.670848f, -0.670919f,
	-0.670990f, -0.671062f, -0.671133f, -0.671204f, -0.671275f, -0.671346f, -0.671417f, -0.671488f,
	-0.671559f, -0.671630f, -0.671701f, -0.671772f, -0.671843f, -0.671914f, -0.671985f, -0.672056f,
	-0.672127f, -0.672198f, -0.672269f, -0.672340f, -0.672411f, -0.672482f, -0.672553f, -0.672624f,
	-0.672695f, -0.672766f, -0.672837f, -0.672908f, -0.672978f, -0.673049f, -0.673120f, -0.673191f,
	-0.673262f, -0.673333f, -0.673404f, -0.673475f, -0.673546f, -0.673616f, -0.673687f, -0.673758f,
	-0.673829f, -0.673900f, -0.673971f, -0.674042f, -0.674112f, -0.674183f, -0.674254f, -0.674325f,
	-0.674396f, -0.674466f, -0.674537f, -0.674608f, -0.674679f, -0.674749f, -0.674820f, -0.674891f,
	-0.674962f, -0.675032f, -0.675103f, -0.675174f, -0.675245f, -0.675315f, -0.675386f, -0.675457f,
	-0.675527f, -0.675598f, -0.675669f, -0.675739f, -0.675810f, -0.675881f, -0.675951f, -0.676022f,
	-0.676093f, -0.676163f, -0.676234f, -0.676305f, -0.676375f, -0.676446f, -0.676516f, -0.676587f,
	-0.676658f, -0.676728f, -0.676799f, -0.676869f, -0.676940f, -0.677011f, -0.677081f, -0.677152f,
	-0.677222f, -0.677293f, -0.677363f, -0.677434f, -0.677504f, -0.677575f, -0.677645f, -0.677716f,
	-0.677786f, -0.677857f, -0.677927f, -0.677998f, -0.678068f, -0.678139f, -0.678209f, -0.678280f,
	-0.678350f, -0.678420f, -0.678491f, -0.678561f, -0.678632f, -0.678702f, -0.678773f, -0.678843f,
	-0.678913f, -0.678984f, -0.679054f, -0.679125f, -0.679195f, -0.679265f, -0.679336f, -0.679406f,
	-0.679476f, -0.679547f, -0.679617f, -0.679687f, -0.679758f, -0.679828f, -0.679898f, -0.679969f,
	-0.680039f, -0.680109f, -0.680179f, -0.680250f, -0.680320f, -0.680390f, -0.680461f, -0.680531f,
	-0.680601f, -0.680671f, -0.680741f, -0.680812f, -0.680882f, -0.680952f, -0.681022f, -0.681093f,
	-0.681163f, -0.681233f, -0.681303f, -0.681373f, -0.681443f, -0.681514f, -0.681584f, -0.681654f,
	-0.681724f, -0.681794f, -0.681864f, -0.681934f, -0.682005f, -0.682075f, -0.682145f, -0.682215f,
	-0.682285f, -0.682355f, -0.682425f, -0.682495f, -0.682565f, -0.682635f, -0.682705f, -0.682775f,
	-0.682846f, -0.682916f, -0.682986f, -0.683056f, -0.683126f, -0.683196f, -0.683266f, -0.683336f,
	-0.683406f, -0.683476f, -0.683546f, -0.683616f, -0.683686f, -0.683756f, -0.683825f, -0.683895f,
	-0.683965f, -0.684035f, -0.684105f, -0.684175f, -0.684245f, -0.684315f, -0.684385f, -0.684455f,
	-0.684525f, -0.684595f, -0.684664f, -0.684734f, -0.684804f, -0.684874f, -0.684944f, -0.685014f,
	-0.685084f, -0.685153f, -0.685223f, -0.685293f, -0.685363f, -0.685433f, -0.685503f, -0.685572f,
	-0.685642f, -0.685712f, -0.685782f, -0.685852f, -0.685921f, -0.685991f, -0.686061f, -0.686131f,
	-0.686200f, -0.686270f, -0.686340f, -0.686409f, -0.686479f, -0.686549f, -0.686619f, -0.686688f,
	-0.686758f, -0.686828f, -0.686897f, -0.686967f, -0.687037f, -0.687106f, -0.687176f, -0.687246f,
	-0.687315f, -0.687385f, -0.687455f, -0.687524f, -0.687594f, -0.687663f, -0.687733f, -0.687803f,
	-0.687872f, -0.687942f, -0.688011f, -0.688081f, -0.688151f, -0.688220f, -0.688290f, -0.688359f,
	-0.688429f, -0.688498f, -0.688568f, -0.688637f, -0.688707f, -0.688776f, -0.688846f, -0.688915f,
	-0.688985f, -0.689054f, -0.689124f, -0.689193f, -0.689263f, -0.689332f, -0.689402f, -0.689471f,
	-0.689541f, -0.689610f, -0.689679f, -0.689749f, -0.689818f, -0.689888f, -0.689957f, -0.690026f,
	-0.690096f, -0.690165f, -0.690235f, -0.690304f, -0.690373f, -0.690443f, -0.690512f, -0.690581f,
	-0.690651f, -0.690720f, -0.690789f, -0.690859f, -0.690928f, -0.690997f, -0.691067f, -0.691136f,
	-0.691205f, -0.691274f, -0.691344f, -0.691413f, -0.691482f, -0.691552f, -0.691621f, -0.691690f,
	-0.691759f, -0.691828f, -0.691898f, -0.691967f, -0.692036f, -0.692105f, -0.692175f, -0.692244f,
	-0.692313f, -0.692382f, -0.692451f, -0.692520f, -0.692590f, -0.692659f, -0.692728f, -0.692797f,
	-0.692866f, -0.692935f, -0.693004f, -0.693074f, -0.693143f, -0.693212f, -0.693281f, -0.693350f,
	-0.693419f, -0.693488f, -0.693557f, -0.693626f, -0.693695f, -0.693764f, -0.693833f, -0.693902f,
	-0.693971f, -0.694040f, -0.694109f, -0.694179f, -0.694248f, -0.694317f, -0.694386f, -0.694454f,
	-0.694524f, -0.694592f, -0.694661f, -0.694730f, -0.694799f, -0.694868f, -0.694937f, -0.695006f,
	-0.695075f, -0.695144f, -0.695213f, -0.695282f, -0.695351f, -0.695420f, -0.695489f, -0.695557f,
	-0.695626f, -0.695695f, -0.695764f, -0.695833f, -0.695902f, -0.695971f, -0.696039f, -0.696108f,
	-0.696177f, -0.696246f, -0.696315f, -0.696384f, -0.696452f, -0.696521f, -0.696590f, -0.696659f,
	-0.696728f, -0.696796f, -0.696865f, -0.696934f, -0.697003f, -0.697071f, -0.697140f, -0.697209f,
	-0.697277f, -0.697346f, -0.697415f, -0.697484f, -0.697552f, -0.697621f, -0.697690f, -0.697758f,
	-0.697827f, -0.697896f, -0.697964f, -0.698033f, -0.698102f, -0.698170f, -0.698239f, -0.698308f,
	-0.698376f, -0.698445f, -0.698513f, -0.698582f, -0.698651f, -0.698719f, -0.698788f, -0.698856f,
	-0.698925f, -0.698994f, -0.699062f, -0.699131f, -0.699199f, -0.699268f, -0.699336f, -0.699405f,
	-0.699473f, -0.699542f, -0.699610f, -0.699679f, -0.699747f, -0.699816f, -0.699884f, -0.699953f,
	-0.700021f, -0.700090f, -0.700158f, -0.700227f, -0.700295f, -0.700364f, -0.700432f, -0.700500f,
	-0.700569f, -0.700637f, -0.700706f, -0.700774f, -0.700842f, -0.700911f, -0.700979f, -0.701048f,
	-0.701116f, -0.701184f, -0.701253f, -0.701321f, -0.701389f, -0.701458f, -0.701526f, -0.701594f,
	-0.701663f, -0.701731f, -0.701799f, -0.701868f, -0.701936f, -0.702004f, -0.702072f, -0.702141f,
	-0.702209f, -0.702277f, -0.702345f, -0.702414f, -0.702482f, -0.702550f, -0.702618f, -0.702687f,
	-0.702755f, -0.702823f, -0.702891f, -0.702959f, -0.703028f, -0.703096f, -0.703164f, -0.703232f,
	-0.703300f, -0.703368f, -0.703436f, -0.703505f, -0.703573f, -0.703641f, -0.703709f, -0.703777f,
	-0.703845f, -0.703913f, -0.703981f, -0.704050f, -0.704118f, -0.704186f, -0.704254f, -0.704322f,
	-0.704390f, -0.704458f, -0.704526f, -0.704594f, -0.704662f, -0.704730f, -0.704798f, -0.704866f,
	-0.704934f, -0.705002f, -0.705070f, -0.705138f, -0.705206f, -0.705274f, -0.705342f, -0.705410f,
	-0.705478f, -0.705546f, -0.705614f, -0.705682f, -0.705750f, -0.705818f, -0.705885f, -0.705953f,
	-0.706021f, -0.706089f, -0.706157f, -0.706225f, -0.706293f, -0.706361f, -0.706429f, -0.706496f,
	-0.706564f, -0.706632f, -0.706700f, -0.706768f, -0.706836f, -0.706903f, -0.706971f, -0.707039f,
	-0.707107f, -0.707175f, -0.707242f, -0.707310f, -0.707378f, -0.707446f, -0.707513f, -0.707581f,
	-0.707649f, -0.707717f, -0.707784f, -0.707852f, -0.707920f, -0.707988f, -0.708055f, -0.708123f,
	-0.708191f, -0.708258f, -0.708326f, -0.708394f, -0.708461f, -0.708529f, -0.708597f, -0.708664f,
	-0.708732f, -0.708800f, -0.708867f, -0.708935f, -0.709002f, -0.709070f, -0.709138f, -0.709205f,
	-0.709273f, -0.709340f, -0.709408f, -0.709476f, -0.709543f, -0.709611f, -0.709678f, -0.709746f,
	-0.709813f, -0.709881f, -0.709948f, -0.710016f, -0.710083f, -0.710151f, -0.710218f, -0.710286f,
	-0.710353f, -0.710421f, -0.710488f, -0.710556f, -0.710623f, -0.710691f, -0.710758f, -0.710826f,
	-0.710893f, -0.710960f, -0.711028f, -0.711095f, -0.711163f, -0.711230f, -0.711297f, -0.711365f,
	-0.711432f, -0.711500f, -0.711567f, -0.711634f, -0.711702f, -0.711769f, -0.711836f, -0.711904f,
	-0.711971f, -0.712038f, -0.712106f, -0.712173f, -0.712240f, -0.712308f, -0.712375f, -0.712442f,
	-0.712509f, -0.712577f, -0.712644f, -0.712711f, -0.712778f, -0.712846f, -0.712913f, -0.712980f,
	-0.713047f, -0.713115f, -0.713182f, -0.713249f, -0.713316f, -0.713383f, -0.713451f, -0.713518f,
	-0.713585f, -0.713652f, -0.713719f, -0.713786f, -0.713853f, -0.713921f, -0.713988f, -0.714055f,
	-0.714122f, -0.714189f, -0.714256f, -0.714323f, -0.714390f, -0.714457f, -0.714525f, -0.714592f,
	-0.714659f, -0.714726f, -0.714793f, -0.714860f, -0.714927f, -0.714994f, -0.715061f, -0.715128f,
	-0.715195f, -0.715262f, -0.715329f, -0.715396f, -0.715463f, -0.715530f, -0.715597f, -0.715664f,
	-0.715731f, -0.715798f, -0.715865f, -0.715932f, -0.715999f, -0.716066f, -0.716132f, -0.716199f,
	-0.716266f, -0.716333f, -0.716400f, -0.716467f, -0.716534f, -0.716601f, -0.716668f, -0.716734f,
	-0.716801f, -0.716868f, -0.716935f, -0.717002f, -0.717069f, -0.717135f, -0.717202f, -0.717269f,
	-0.717336f, -0.717403f, -0.717469f, -0.717536f, -0.717603f, -0.717670f, -0.717737f, -0.717803f,
	-0.717870f, -0.717937f, -0.718004f, -0.718070f, -0.718137f, -0.718204f, -0.718270f, -0.718337f,
	-0.718404f, -0.718471f, -0.718537f, -0.718604f, -0.718670f, -0.718737f, -0.718804f, -0.718870f,
	-0.718937f, -0.719004f, -0.719070f, -0.719137f, -0.719204f, -0.719270f, -0.719337f, -0.719403f,
	-0.719470f, -0.719537f, -0.719603f, -0.719670f, -0.719736f, -0.719803f, -0.719869f, -0.719936f,
	-0.720003f, -0.720069f, -0.720136f, -0.720202f, -0.720269f, -0.720335f, -0.720402f, -0.720468f,
	-0.720535f, -0.720601f, -0.720668f, -0.720734f, -0.720800f, -0.720867f, -0.720933f, -0.721000f,
	-0.721066f, -0.721133f, -0.721199f, -0.721265f, -0.721332f, -0.721398f, -0.721465f, -0.721531f,
	-0.721597f, -0.721664f, -0.721730f, -0.721797f, -0.721863f, -0.721929f, -0.721996f, -0.722062f,
	-0.722128f, -0.722194f, -0.722261f, -0.722327f, -0.722393f, -0.722460f, -0.722526f, -0.722592f,
	-0.722659f, -0.722725f, -0.722791f, -0.722857f, -0.722924f, -0.722990f, -0.723056f, -0.723122f,
	-0.723188f, -0.723255f, -0.723321f, -0.723387f, -0.723453f, -0.723520f, -0.723586f, -0.723652f,
	-0.723718f, -0.723784f, -0.723850f, -0.723916f, -0.723983f, -0.724049f, -0.724115f, -0.724181f,
	-0.724247f, -0.724313f, -0.724379f, -0.724445f, -0.724511f, -0.724578f, -0.724644f, -0.724710f,
	-0.724776f, -0.724842f, -0.724908f, -0.724974f, -0.725040f, -0.725106f, -0.725172f, -0.725238f,
	-0.725304f, -0.725370f, -0.725436f, -0.725502f, -0.725568f, -0.725634f, -0.725700f, -0.725766f,
	-0.725832f, -0.725898f, -0.725964f, -0.726030f, -0.726095f, -0.726161f, -0.726227f, -0.726293f,
	-0.726359f, -0.726425f, -0.726491f, -0.726557f, -0.726623f, -0.726689f, -0.726754f, -0.726820f,
	-0.726886f, -0.726952f, -0.727018f, -0.727084f, -0.727149f, -0.727215f, -0.727281f, -0.727347f,
	-0.727413f, -0.727478f, -0.727544f, -0.727610f, -0.727676f, -0.727741f, -0.727807f, -0.727873f,
	-0.727939f, -0.728004f, -0.728070f, -0.728136f, -0.728202f, -0.728267f, -0.728333f, -0.728399f,
	-0.728464f, -0.728530f, -0.728596f, -0.728661f, -0.728727f, -0.728793f, -0.728858f, -0.728924f,
	-0.728990f, -0.729055f, -0.729121f, -0.729186f, -0.729252f, -0.729318f, -0.729383f, -0.729449f,
	-0.729514f, -0.729580f, -0.729646f, -0.729711f, -0.729777f, -0.729842f, -0.729908f, -0.729973f,
	-0.730039f, -0.730104f, -0.730170f, -0.730235f, -0.730301f, -0.730366f, -0.730432f, -0.730497f,
	-0.730563f, -0.730628f, -0.730694f, -0.730759f, -0.730825f, -0.730890f, -0.730955f, -0.731021f,
	-0.731086f, -0.731152f, -0.731217f, -0.731282f, -0.731348f, -0.731413f, -0.731479f, -0.731544f,
	-0.731609f, -0.731675f, -0.731740f, -0.731805f, -0.731871f, -0.731936f, -0.732001f, -0.732067f,
	-0.732132f, -0.732197f, -0.732263f, -0.732328f, -0.732393f, -0.732458f, -0.732524f, -0.732589f,
	-0.732654f, -0.732720f, -0.732785f, -0.732850f, -0.732915f, -0.732980f, -0.733046f, -0.733111f,
	-0.733176f, -0.733241f, -0.733306f, -0.733372f, -0.733437f, -0.733502f, -0.733567f, -0.733632f,
	-0.733697f, -0.733763f, -0.733828f, -0.733893f, -0.733958f, -0.734023f, -0.734088f, -0.734153f,
	-0.734218f, -0.734283f, -0.734349f, -0.734414f, -0.734479f, -0.734544f, -0.734609f, -0.734674f,
	-0.734739f, -0.734804f, -0.734869f, -0.734934f, -0.734999f, -0.735064f, -0.735129f, -0.735194f,
	-0.735259f, -0.735324f, -0.735389f, -0.735454f, -0.735519f, -0.735584f, -0.735649f, -0.735714f,
	-0.735779f, -0.735844f, -0.735908f, -0.735973f, -0.736038f, -0.736103f, -0.736168f, -0.736233f,
	-0.736298f, -0.736363f, -0.736428f, -0.736492f, -0.736557f, -0.736622f, -0.736687f, -0.736752f,
	-0.736817f, -0.736881f, -0.736946f, -0.737011f, -0.737076f, -0.737141f, -0.737205f, -0.737270f,
	-0.737335f, -0.737400f, -0.737464f, -0.737529f, -0.737594f, -0.737659f, -0.737723f, -0.737788f,
	-0.737853f, -0.737918f, -0.737982f, -0.738047f, -0.738112f, -0.738176f, -0.738241f, -0.738306f,
	-0.738370f, -0.738435f, -0.738500f, -0.738564f, -0.738629f, -0.738693f, -0.738758f, -0.738823f,
	-0.738887f, -0.738952f, -0.739017f, -0.739081f, -0.739146f, -0.739210f, -0.739275f, -0.739339f,
	-0.739404f, -0.739468f, -0.739533f, -0.739598f, -0.739662f, -0.739727f, -0.739791f, -0.739856f,
	-0.739920f, -0.739985f, -0.740049f, -0.740114f, -0.740178f, -0.740242f, -0.740307f, -0.740371f,
	-0.740436f, -0.740500f, -0.740565f, -0.740629f, -0.740694f, -0.740758f, -0.740822f, -0.740887f,
	-0.740951f, -0.741015f, -0.741080f, -0.741144f, -0.741209f, -0.741273f, -0.741337f, -0.741402f,
	-0.741466f, -0.741530f, -0.741595f, -0.741659f, -0.741723f, -0.741788f, -0.741852f, -0.741916f,
	-0.741980f, -0.742045f, -0.742109f, -0.742173f, -0.742237f, -0.742302f, -0.742366f, -0.742430f,
	-0.742494f, -0.742559f, -0.742623f, -0.742687f, -0.742751f, -0.742815f, -0.742880f, -0.742944f,
	-0.743008f, -0.743072f, -0.743136f, -0.743200f, -0.743265f, -0.743329f, -0.743393f, -0.743457f,
	-0.743521f, -0.743585f, -0.743649f, -0.743713f, -0.743777f, -0.743842f, -0.743906f, -0.743970f,
	-0.744034f, -0.744098f, -0.744162f, -0.744226f, -0.744290f, -0.744354f, -0.744418f, -0.744482f,
	-0.744546f, -0.744610f, -0.744674f, -0.744738f, -0.744802f, -0.744866f, -0.744930f, -0.744994f,
	-0.745058f, -0.745122f, -0.745186f, -0.745250f, -0.745314f, -0.745377f, -0.745441f, -0.745505f,
	-0.745569f, -0.745633f, -0.745697f, -0.745761f, -0.745825f, -0.745889f, -0.745952f, -0.746016f,
	-0.746080f, -0.746144f, -0.746208f, -0.746272f, -0.746335f, -0.746399f, -0.746463f, -0.746527f,
	-0.746591f, -0.746654f, -0.746718f, -0.746782f, -0.746846f, -0.746909f, -0.746973f, -0.747037f,
	-0.747101f, -0.747164f, -0.747228f, -0.747292f, -0.747355f, -0.747419f, -0.747483f, -0.747547f,
	-0.747610f, -0.747674f, -0.747738f, -0.747801f, -0.747865f, -0.747929f, -0.747992f, -0.748056f,
	-0.748119f, -0.748183f, -0.748247f, -0.748310f, -0.748374f, -0.748437f, -0.748501f, -0.748565f,
	-0.748628f, -0.748692f, -0.748755f, -0.748819f, -0.748882f, -0.748946f, -0.749009f, -0.749073f,
	-0.749136f, -0.749200f, -0.749263f, -0.749327f, -0.749390f, -0.749454f, -0.749517f, -0.749581f,
	-0.749644f, -0.749708f, -0.749771f, -0.749835f, -0.749898f, -0.749961f, -0.750025f, -0.750088f,
	-0.750152f, -0.750215f, -0.750278f, -0.750342f, -0.750405f, -0.750469f, -0.750532f, -0.750595f,
	-0.750659f, -0.750722f, -0.750785f, -0.750849f, -0.750912f, -0.750975f, -0.751039f, -0.751102f,
	-0.751165f, -0.751228f, -0.751292f, -0.751355f, -0.751418f, -0.751481f, -0.751545f, -0.751608f,
	-0.751671f, -0.751734f, -0.751798f, -0.751861f, -0.751924f, -0.751987f, -0.752050f, -0.752114f,
	-0.752177f, -0.752240f, -0.752303f, -0.752366f, -0.752429f, -0.752493f, -0.752556f, -0.752619f,
	-0.752682f, -0.752745f, -0.752808f, -0.752871f, -0.752934f, -0.752998f, -0.753061f, -0.753124f,
	-0.753187f, -0.753250f, -0.753313f, -0.753376f, -0.753439f, -0.753502f, -0.753565f, -0.753628f,
	-0.753691f, -0.753754f, -0.753817f, -0.753880f, -0.753943f, -0.754006f, -0.754069f, -0.754132f,
	-0.754195f, -0.754258f, -0.754321f, -0.754384f, -0.754447f, -0.754510f, -0.754573f, -0.754636f,
	-0.754698f, -0.754761f, -0.754824f, -0.754887f, -0.754950f, -0.755013f, -0.755076f, -0.755139f,
	-0.755201f, -0.755264f, -0.755327f, -0.755390f, -0.755453f, -0.755516f, -0.755578f, -0.755641f,
	-0.755704f, -0.755767f, -0.755829f, -0.755892f, -0.755955f, -0.756018f, -0.756081f, -0.756143f,
	-0.756206f, -0.756269f, -0.756331f, -0.756394f, -0.756457f, -0.756520f, -0.756582f, -0.756645f,
	-0.756708f, -0.756770f, -0.756833f, -0.756896f, -0.756958f, -0.757021f, -0.757084f, -0.757146f,
	-0.757209f, -0.757271f, -0.757334f, -0.757397f, -0.757459f, -0.757522f, -0.757584f, -0.757647f,
	-0.757710f, -0.757772f, -0.757835f, -0.757897f, -0.757960f, -0.758022f, -0.758085f, -0.758147f,
	-0.758210f, -0.758272f, -0.758335f, -0.758397f, -0.758460f, -0.758522f, -0.758585f, -0.758647f,
	-0.758710f, -0.758772f, -0.758835f, -0.758897f, -0.758960f, -0.759022f, -0.759084f, -0.759147f,
	-0.759209f, -0.759272f, -0.759334f, -0.759396f, -0.759459f, -0.759521f, -0.759583f, -0.759646f,
	-0.759708f, -0.759771f, -0.759833f, -0.759895f, -0.759957f, -0.760020f, -0.760082f, -0.760144f,
	-0.760207f, -0.760269f, -0.760331f, -0.760394f, -0.760456f, -0.760518f, -0.760580f, -0.760643f,
	-0.760705f, -0.760767f, -0.760829f, -0.760891f, -0.760954f, -0.761016f, -0.761078f, -0.761140f,
	-0.761202f, -0.761265f, -0.761327f, -0.761389f, -0.761451f, -0.761513f, -0.761575f, -0.761637f,
	-0.761700f, -0.761762f, -0.761824f, -0.761886f, -0.761948f, -0.762010f, -0.762072f, -0.762134f,
	-0.762196f, -0.762258f, -0.762320f, -0.762382f, -0.762444f, -0.762507f, -0.762569f, -0.762631f,
	-0.762693f, -0.762755f, -0.762817f, -0.762879f, -0.762941f, -0.763003f, -0.763065f, -0.763126f,
	-0.763188f, -0.763250f, -0.763312f, -0.763374f, -0.763436f, -0.763498f, -0.763560f, -0.763622f,
	-0.763684f, -0.763746f, -0.763808f, -0.763869f, -0.763931f, -0.763993f, -0.764055f, -0.764117f,
	-0.764179f, -0.764241f, -0.764302f, -0.764364f, -0.764426f, -0.764488f, -0.764550f, -0.764611f,
	-0.764673f, -0.764735f, -0.764797f, -0.764859f, -0.764920f, -0.764982f, -0.765044f, -0.765106f,
	-0.765167f, -0.765229f, -0.765291f, -0.765352f, -0.765414f, -0.765476f, -0.765538f, -0.765599f,
	-0.765661f, -0.765723f, -0.765784f, -0.765846f, -0.765907f, -0.765969f, -0.766031f, -0.766092f,
	-0.766154f, -0.766216f, -0.766277f, -0.766339f, -0.766400f, -0.766462f, -0.766524f, -0.766585f,
	-0.766647f, -0.766708f, -0.766770f, -0.766831f, -0.766893f, -0.766954f, -0.767016f, -0.767077f,
	-0.767139f, -0.767200f, -0.767262f, -0.767323f, -0.767385f, -0.767446f, -0.767508f, -0.767569f,
	-0.767631f, -0.767692f, -0.767754f, -0.767815f, -0.767876f, -0.767938f, -0.767999f, -0.768061f,
	-0.768122f, -0.768183f, -0.768245f, -0.768306f, -0.768368f, -0.768429f, -0.768490f, -0.768552f,
	-0.768613f, -0.768674f, -0.768736f, -0.768797f, -0.768858f, -0.768919f, -0.768981f, -0.769042f,
	-0.769103f, -0.769165f, -0.769226f, -0.769287f, -0.769348f, -0.769410f, -0.769471f, -0.769532f,
	-0.769593f, -0.769655f, -0.769716f, -0.769777f, -0.769838f, -0.769899f, -0.769961f, -0.770022f,
	-0.770083f, -0.770144f, -0.770205f, -0.770266f, -0.770327f, -0.770389f, -0.770450f, -0.770511f,
	-0.770572f, -0.770633f, -0.770694f, -0.770755f, -0.770816f, -0.770877f, -0.770938f, -0.770999f,
	-0.771061f, -0.771122f, -0.771183f, -0.771244f, -0.771305f, -0.771366f, -0.771427f, -0.771488f,
	-0.771549f, -0.771610f, -0.771671f, -0.771732f, -0.771793f, -0.771854f, -0.771915f, -0.771975f,
	-0.772036f, -0.772097f, -0.772158f, -0.772219f, -0.772280f, -0.772341f, -0.772402f, -0.772463f,
	-0.772524f, -0.772584f, -0.772645f, -0.772706f, -0.772767f, -0.772828f, -0.772889f, -0.772950f,
	-0.773010f, -0.773071f, -0.773132f, -0.773193f, -0.773254f, -0.773314f, -0.773375f, -0.773436f,
	-0.773497f, -0.773558f, -0.773618f, -0.773679f, -0.773740f, -0.773801f, -0.773861f, -0.773922f,
	-0.773983f, -0.774043f, -0.774104f, -0.774165f, -0.774225f, -0.774286f, -0.774347f, -0.774407f,
	-0.774468f, -0.774529f, -0.774589f, -0.774650f, -0.774711f, -0.774771f, -0.774832f, -0.774893f,
	-0.774953f, -0.775014f, -0.775074f, -0.775135f, -0.775195f, -0.775256f, -0.775317f, -0.775377f,
	-0.775438f, -0.775498f, -0.775559f, -0.775619f, -0.775680f, -0.775740f, -0.775801f, -0.775861f,
	-0.775922f, -0.775982f, -0.776043f, -0.776103f, -0.776164f, -0.776224f, -0.776284f, -0.776345f,
	-0.776405f, -0.776466f, -0.776526f, -0.776587f, -0.776647f, -0.776707f, -0.776768f, -0.776828f,
	-0.776888f, -0.776949f, -0.777009f, -0.777070f, -0.777130f, -0.777190f, -0.777251f, -0.777311f,
	-0.777371f, -0.777431f, -0.777492f, -0.777552f, -0.777612f, -0.777673f, -0.777733f, -0.777793f,
	-0.777853f, -0.777914f, -0.777974f, -0.778034f, -0.778094f, -0.778155f, -0.778215f, -0.778275f,
	-0.778335f, -0.778395f, -0.778456f, -0.778516f, -0.778576f, -0.778636f, -0.778696f, -0.778756f,
	-0.778817f, -0.778877f, -0.778937f, -0.778997f, -0.779057f, -0.779117f, -0.779177f, -0.779237f,
	-0.779297f, -0.779357f, -0.779418f, -0.779478f, -0.779538f, -0.779598f, -0.779658f, -0.779718f,
	-0.779778f, -0.779838f, -0.779898f, -0.779958f, -0.780018f, -0.780078f, -0.780138f, -0.780198f,
	-0.780258f, -0.780318f, -0.780378f, -0.780438f, -0.780498f, -0.780557f, -0.780617f, -0.780677f,
	-0.780737f, -0.780797f, -0.780857f, -0.780917f, -0.780977f, -0.781037f, -0.781097f, -0.781156f,
	-0.781216f, -0.781276f, -0.781336f, -0.781396f, -0.781456f, -0.781515f, -0.781575f, -0.781635f,
	-0.781695f, -0.781755f, -0.781814f, -0.781874f, -0.781934f, -0.781994f, -0.782053f, -0.782113f,
	-0.782173f, -0.782233f, -0.782292f, -0.782352f, -0.782412f, -0.782472f, -0.782531f, -0.782591f,
	-0.782651f, -0.782710f, -0.782770f, -0.782830f, -0.782889f, -0.782949f, -0.783009f, -0.783068f,
	-0.783128f, -0.783187f, -0.783247f, -0.783307f, -0.783366f, -0.783426f, -0.783485f, -0.783545f,
	-0.783605f, -0.783664f, -0.783724f, -0.783783f, -0.783843f, -0.783902f, -0.783962f, -0.784021f,
	-0.784081f, -0.784140f, -0.784200f, -0.784259f, -0.784319f, -0.784378f, -0.784438f, -0.784497f,
	-0.784557f, -0.784616f, -0.784675f, -0.784735f, -0.784794f, -0.784854f, -0.784913f, -0.784973f,
	-0.785032f, -0.785091f, -0.785151f, -0.785210f, -0.785269f, -0.785329f, -0.785388f, -0.785447f,
	-0.785507f, -0.785566f, -0.785625f, -0.785685f, -0.785744f, -0.785803f, -0.785863f, -0.785922f,
	-0.785981f, -0.786041f, -0.786100f, -0.786159f, -0.786218f, -0.786278f, -0.786337f, -0.786396f,
	-0.786455f, -0.786514f, -0.786574f, -0.786633f, -0.786692f, -0.786751f, -0.786810f, -0.786870f,
	-0.786929f, -0.786988f, -0.787047f, -0.787106f, -0.787165f, -0.787224f, -0.787284f, -0.787343f,
	-0.787402f, -0.787461f, -0.787520f, -0.787579f, -0.787638f, -0.787697f, -0.787756f, -0.787815f,
	-0.787874f, -0.787933f, -0.787992f, -0.788051f, -0.788110f, -0.788169f, -0.788228f, -0.788287f,
	-0.788346f, -0.788405f, -0.788464f, -0.788523f, -0.788582f, -0.788641f, -0.788700f, -0.788759f,
	-0.788818f, -0.788877f, -0.788936f, -0.788995f, -0.789054f, -0.789113f, -0.789172f, -0.789230f,
	-0.789289f, -0.789348f, -0.789407f, -0.789466f, -0.789525f, -0.789584f, -0.789642f, -0.789701f,
	-0.789760f, -0.789819f, -0.789878f, -0.789936f, -0.789995f, -0.790054f, -0.790113f, -0.790171f,
	-0.790230f, -0.790289f, -0.790348f, -0.790406f, -0.790465f, -0.790524f, -0.790583f, -0.790641f,
	-0.790700f, -0.790759f, -0.790817f, -0.790876f, -0.790935f, -0.790993f, -0.791052f, -0.791111f,
	-0.791169f, -0.791228f, -0.791287f, -0.791345f, -0.791404f, -0.791462f, -0.791521f, -0.791580f,
	-0.791638f, -0.791697f, -0.791755f, -0.791814f, -0.791872f, -0.791931f, -0.791990f, -0.792048f,
	-0.792107f, -0.792165f, -0.792224f, -0.792282f, -0.792341f, -0.792399f, -0.792458f, -0.792516f,
	-0.792575f, -0.792633f, -0.792691f, -0.792750f, -0.792808f, -0.792867f, -0.792925f, -0.792984f,
	-0.793042f, -0.793100f, -0.793159f, -0.793217f, -0.793276f, -0.793334f, -0.793392f, -0.793451f,
	-0.793509f, -0.793567f, -0.793626f, -0.793684f, -0.793742f, -0.793801f, -0.793859f, -0.793917f,
	-0.793975f, -0.794034f, -0.794092f, -0.794150f, -0.794209f, -0.794267f, -0.794325f, -0.794383f,
	-0.794442f, -0.794500f, -0.794558f, -0.794616f, -0.794674f, -0.794733f, -0.794791f, -0.794849f,
	-0.794907f, -0.794965f, -0.795023f, -0.795082f, -0.795140f, -0.795198f, -0.795256f, -0.795314f,
	-0.795372f, -0.795430f, -0.795488f, -0.795547f, -0.795605f, -0.795663f, -0.795721f, -0.795779f,
	-0.795837f, -0.795895f, -0.795953f, -0.796011f, -0.796069f, -0.796127f, -0.796185f, -0.796243f,
	-0.796301f, -0.796359f, -0.796417f, -0.796475f, -0.796533f, -0.796591f, -0.796649f, -0.796707f,
	-0.796765f, -0.796823f, -0.796881f, -0.796939f, -0.796996f, -0.797054f, -0.797112f, -0.797170f,
	-0.797228f, -0.797286f, -0.797344f, -0.797402f, -0.797459f, -0.797517f, -0.797575f, -0.797633f,
	-0.797691f, -0.797749f, -0.797806f, -0.797864f, -0.797922f, -0.797980f, -0.798038f, -0.798095f,
	-0.798153f, -0.798211f, -0.798269f, -0.798326f, -0.798384f, -0.798442f, -0.798500f, -0.798557f,
	-0.798615f, -0.798673f, -0.798730f, -0.798788f, -0.798846f, -0.798903f, -0.798961f, -0.799019f,
	-0.799076f, -0.799134f, -0.799192f, -0.799249f, -0.799307f, -0.799365f, -0.799422f, -0.799480f,
	-0.799537f, -0.799595f, -0.799652f, -0.799710f, -0.799768f, -0.799825f, -0.799883f, -0.799940f,
	-0.799998f, -0.800055f, -0.800113f, -0.800170f, -0.800228f, -0.800285f, -0.800343f, -0.800400f,
	-0.800458f, -0.800515f, -0.800573f, -0.800630f, -0.800687f, -0.800745f, -0.800802f, -0.800860f,
	-0.800917f, -0.800975f, -0.801032f, -0.801089f, -0.801147f, -0.801204f, -0.801261f, -0.801319f,
	-0.801376f, -0.801434f, -0.801491f, -0.801548f, -0.801606f, -0.801663f, -0.801720f, -0.801777f,
	-0.801835f, -0.801892f, -0.801949f, -0.802007f, -0.802064f, -0.802121f, -0.802178f, -0.802236f,
	-0.802293f, -0.802350f, -0.802407f, -0.802464f, -0.802522f, -0.802579f, -0.802636f, -0.802693f,
	-0.802750f, -0.802808f, -0.802865f, -0.802922f, -0.802979f, -0.803036f, -0.803093f, -0.803150f,
	-0.803208f, -0.803265f, -0.803322f, -0.803379f, -0.803436f, -0.803493f, -0.803550f, -0.803607f,
	-0.803664f, -0.803721f, -0.803778f, -0.803835f, -0.803892f, -0.803949f, -0.804006f, -0.804063f,
	-0.804120f, -0.804177f, -0.804234f, -0.804291f, -0.804348f, -0.804405f, -0.804462f, -0.804519f,
	-0.804576f, -0.804633f, -0.804690f, -0.804747f, -0.804804f, -0.804861f, -0.804918f, -0.804974f,
	-0.805031f, -0.805088f, -0.805145f, -0.805202f, -0.805259f, -0.805316f, -0.805372f, -0.805429f,
	-0.805486f, -0.805543f, -0.805600f, -0.805656f, -0.805713f, -0.805770f, -0.805827f, -0.805884f,
	-0.805940f, -0.805997f, -0.806054f, -0.806111f, -0.806167f, -0.806224f, -0.806281f, -0.806338f,
	-0.806394f, -0.806451f, -0.806508f, -0.806564f, -0.806621f, -0.806678f, -0.806734f, -0.806791f,
	-0.806848f, -0.806904f, -0.806961f, -0.807017f, -0.807074f, -0.807131f, -0.807187f, -0.807244f,
	-0.807300f, -0.807357f, -0.807414f, -0.807470f, -0.807527f, -0.807583f, -0.807640f, -0.807696f,
	-0.807753f, -0.807809f, -0.807866f, -0.807922f, -0.807979f, -0.808035f, -0.808092f, -0.808148f,
	-0.808205f, -0.808261f, -0.808318f, -0.808374f, -0.808430f, -0.808487f, -0.808543f, -0.808600f,
	-0.808656f, -0.808713f, -0.808769f, -0.808825f, -0.808882f, -0.808938f, -0.808994f, -0.809051f,
	-0.809107f, -0.809164f, -0.809220f, -0.809276f, -0.809332f, -0.809389f, -0.809445f, -0.809501f,
	-0.809558f, -0.809614f, -0.809670f, -0.809726f, -0.809783f, -0.809839f, -0.809895f, -0.809951f,
	-0.810008f, -0.810064f, -0.810120f, -0.810176f, -0.810232f, -0.810289f, -0.810345f, -0.810401f,
	-0.810457f, -0.810513f, -0.810570f, -0.810626f, -0.810682f, -0.810738f, -0.810794f, -0.810850f,
	-0.810906f, -0.810962f, -0.811018f, -0.811075f, -0.811131f, -0.811187f, -0.811243f, -0.811299f,
	-0.811355f, -0.811411f, -0.811467f, -0.811523f, -0.811579f, -0.811635f, -0.811691f, -0.811747f,
	-0.811803f, -0.811859f, -0.811915f, -0.811971f, -0.812027f, -0.812083f, -0.812139f, -0.812195f,
	-0.812251f, -0.812307f, -0.812362f, -0.812418f, -0.812474f, -0.812530f, -0.812586f, -0.812642f,
	-0.812698f, -0.812754f, -0.812809f, -0.812865f, -0.812921f, -0.812977f, -0.813033f, -0.813089f,
	-0.813144f, -0.813200f, -0.813256f, -0.813312f, -0.813368f, -0.813423f, -0.813479f, -0.813535f,
	-0.813591f, -0.813646f, -0.813702f, -0.813758f, -0.813814f, -0.813869f, -0.813925f, -0.813981f,
	-0.814036f, -0.814092f, -0.814148f, -0.814203f, -0.814259f, -0.814315f, -0.814370f, -0.814426f,
	-0.814482f, -0.814537f, -0.814593f, -0.814648f, -0.814704f, -0.814760f, -0.814815f, -0.814871f,
	-0.814926f, -0.814982f, -0.815037f, -0.815093f, -0.815149f, -0.815204f, -0.815260f, -0.815315f,
	-0.815371f, -0.815426f, -0.815482f, -0.815537f, -0.815593f, -0.815648f, -0.815704f, -0.815759f,
	-0.815814f, -0.815870f, -0.815925f, -0.815981f, -0.816036f, -0.816092f, -0.816147f, -0.816202f,
	-0.816258f, -0.816313f, -0.816368f, -0.816424f, -0.816479f, -0.816535f, -0.816590f, -0.816645f,
	-0.816701f, -0.816756f, -0.816811f, -0.816867f, -0.816922f, -0.816977f, -0.817032f, -0.817088f,
	-0.817143f, -0.817198f, -0.817253f, -0.817309f, -0.817364f, -0.817419f, -0.817474f, -0.817530f,
	-0.817585f, -0.817640f, -0.817695f, -0.817750f, -0.817806f, -0.817861f, -0.817916f, -0.817971f,
	-0.818026f, -0.818081f, -0.818137f, -0.818192f, -0.818247f, -0.818302f, -0.818357f, -0.818412f,
	-0.818467f, -0.818522f, -0.818577f, -0.818632f, -0.818687f, -0.818742f, -0.818798f, -0.818853f,
	-0.818908f, -0.818963f, -0.819018f, -0.819073f, -0.819128f, -0.819183f, -0.819238f, -0.819293f,
	-0.819348f, -0.819402f, -0.819457f, -0.819512f, -0.819567f, -0.819622f, -0.819677f, -0.819732f,
	-0.819787f, -0.819842f, -0.819897f, -0.819952f, -0.820007f, -0.820061f, -0.820116f, -0.820171f,
	-0.820226f, -0.820281f, -0.820336f, -0.820390f, -0.820445f, -0.820500f, -0.820555f, -0.820610f,
	-0.820664f, -0.820719f, -0.820774f, -0.820829f, -0.820884f, -0.820938f, -0.820993f, -0.821048f,
	-0.821102f, -0.821157f, -0.821212f, -0.821267f, -0.821321f, -0.821376f, -0.821431f, -0.821485f,
	-0.821540f, -0.821595f, -0.821649f, -0.821704f, -0.821759f, -0.821813f, -0.821868f, -0.821922f,
	-0.821977f, -0.822032f, -0.822086f, -0.822141f, -0.822195f, -0.822250f, -0.822305f, -0.822359f,
	-0.822414f, -0.822468f, -0.822523f, -0.822577f, -0.822632f, -0.822686f, -0.822741f, -0.822795f,
	-0.822850f, -0.822904f, -0.822959f, -0.823013f, -0.823068f, -0.823122f, -0.823177f, -0.823231f,
	-0.823285f, -0.823340f, -0.823394f, -0.823449f, -0.823503f, -0.823557f, -0.823612f, -0.823666f,
	-0.823721f, -0.823775f, -0.823829f, -0.823884f, -0.823938f, -0.823992f, -0.824047f, -0.824101f,
	-0.824155f, -0.824209f, -0.824264f, -0.824318f, -0.824372f, -0.824427f, -0.824481f, -0.824535f,
	-0.824589f, -0.824644f, -0.824698f, -0.824752f, -0.824806f, -0.824860f, -0.824915f, -0.824969f,
	-0.825023f, -0.825077f, -0.825131f, -0.825185f, -0.825240f, -0.825294f, -0.825348f, -0.825402f,
	-0.825456f, -0.825510f, -0.825564f, -0.825618f, -0.825673f, -0.825727f, -0.825781f, -0.825835f,
	-0.825889f, -0.825943f, -0.825997f, -0.826051f, -0.826105f, -0.826159f, -0.826213f, -0.826267f,
	-0.826321f, -0.826375f, -0.826429f, -0.826483f, -0.826537f, -0.826591f, -0.826645f, -0.826699f,
	-0.826753f, -0.826807f, -0.826861f, -0.826915f, -0.826968f, -0.827022f, -0.827076f, -0.827130f,
	-0.827184f, -0.827238f, -0.827292f, -0.827346f, -0.827399f, -0.827453f, -0.827507f, -0.827561f,
	-0.827615f, -0.827669f, -0.827722f, -0.827776f, -0.827830f, -0.827884f, -0.827938f, -0.827991f,
	-0.828045f, -0.828099f, -0.828153f, -0.828206f, -0.828260f, -0.828314f, -0.828367f, -0.828421f,
	-0.828475f, -0.828529f, -0.828582f, -0.828636f, -0.828690f, -0.828743f, -0.828797f, -0.828851f,
	-0.828904f, -0.828958f, -0.829011f, -0.829065f, -0.829119f, -0.829172f, -0.829226f, -0.829279f,
	-0.829333f, -0.829386f, -0.829440f, -0.829494f, -0.829547f, -0.829601f, -0.829654f, -0.829708f,
	-0.829761f, -0.829815f, -0.829868f, -0.829922f, -0.829975f, -0.830029f, -0.830082f, -0.830136f,
	-0.830189f, -0.830243f, -0.830296f, -0.830349f, -0.830403f, -0.830456f, -0.830510f, -0.830563f,
	-0.830616f, -0.830670f, -0.830723f, -0.830777f, -0.830830f, -0.830883f, -0.830937f, -0.830990f,
	-0.831043f, -0.831097f, -0.831150f, -0.831203f, -0.831257f, -0.831310f, -0.831363f, -0.831416f,
	-0.831470f, -0.831523f, -0.831576f, -0.831629f, -0.831683f, -0.831736f, -0.831789f, -0.831842f,
	-0.831895f, -0.831949f, -0.832002f, -0.832055f, -0.832108f, -0.832161f, -0.832215f, -0.832268f,
	-0.832321f, -0.832374f, -0.832427f, -0.832480f, -0.832533f, -0.832586f, -0.832640f, -0.832693f,
	-0.832746f, -0.832799f, -0.832852f, -0.832905f, -0.832958f, -0.833011f, -0.833064f, -0.833117f,
	-0.833170f, -0.833223f, -0.833276f, -0.833329f, -0.833382f, -0.833435f, -0.833488f, -0.833541f,
	-0.833594f, -0.833647f, -0.833700f, -0.833753f, -0.833806f, -0.833859f, -0.833912f, -0.833965f,
	-0.834018f, -0.834070f, -0.834123f, -0.834176f, -0.834229f, -0.834282f, -0.834335f, -0.834388f,
	-0.834440f, -0.834493f, -0.834546f, -0.834599f, -0.834652f, -0.834705f, -0.834757f, -0.834810f,
	-0.834863f, -0.834916f, -0.834968f, -0.835021f, -0.835074f, -0.835127f, -0.835179f, -0.835232f,
	-0.835285f, -0.835338f, -0.835390f, -0.835443f, -0.835496f, -0.835548f, -0.835601f, -0.835654f,
	-0.835706f, -0.835759f, -0.835812f, -0.835864f, -0.835917f, -0.835969f, -0.836022f, -0.836075f,
	-0.836127f, -0.836180f, -0.836232f, -0.836285f, -0.836338f, -0.836390f, -0.836443f, -0.836495f,
	-0.836548f, -0.836600f, -0.836653f, -0.836705f, -0.836758f, -0.836810f, -0.836863f, -0.836915f,
	-0.836968f, -0.837020f, -0.837073f, -0.837125f, -0.837178f, -0.837230f, -0.837282f, -0.837335f,
	-0.837387f, -0.837440f, -0.837492f, -0.837544f, -0.837597f, -0.837649f, -0.837701f, -0.837754f,
	-0.837806f, -0.837859f, -0.837911f, -0.837963f, -0.838015f, -0.838068f, -0.838120f, -0.838172f,
	-0.838225f, -0.838277f, -0.838329f, -0.838382f, -0.838434f, -0.838486f, -0.838538f, -0.838591f,
	-0.838643f, -0.838695f, -0.838747f, -0.838799f, -0.838852f, -0.838904f, -0.838956f, -0.839008f,
	-0.839060f, -0.839112f, -0.839165f, -0.839217f, -0.839269f, -0.839321f, -0.839373f, -0.839425f,
	-0.839477f, -0.839529f, -0.839581f, -0.839634f, -0.839686f, -0.839738f, -0.839790f, -0.839842f,
	-0.839894f, -0.839946f, -0.839998f, -0.840050f, -0.840102f, -0.840154f, -0.840206f, -0.840258f,
	-0.840310f, -0.840362f, -0.840414f, -0.840466f, -0.840518f, -0.840570f, -0.840622f, -0.840673f,
	-0.840725f, -0.840777f, -0.840829f, -0.840881f, -0.840933f, -0.840985f, -0.841037f, -0.841089f,
	-0.841140f, -0.841192f, -0.841244f, -0.841296f, -0.841348f, -0.841400f, -0.841451f, -0.841503f,
	-0.841555f, -0.841607f, -0.841659f, -0.841710f, -0.841762f, -0.841814f, -0.841866f, -0.841917f,
	-0.841969f, -0.842021f, -0.842072f, -0.842124f, -0.842176f, -0.842228f, -0.842279f, -0.842331f,
	-0.842383f, -0.842434f, -0.842486f, -0.842538f, -0.842589f, -0.842641f, -0.842692f, -0.842744f,
	-0.842796f, -0.842847f, -0.842899f, -0.842950f, -0.843002f, -0.843054f, -0.843105f, -0.843157f,
	-0.843208f, -0.843260f, -0.843311f, -0.843363f, -0.843414f, -0.843466f, -0.843517f, -0.843569f,
	-0.843620f, -0.843672f, -0.843723f, -0.843775f, -0.843826f, -0.843878f, -0.843929f, -0.843980f,
	-0.844032f, -0.844083f, -0.844135f, -0.844186f, -0.844238f, -0.844289f, -0.844340f, -0.844392f,
	-0.844443f, -0.844494f, -0.844546f, -0.844597f, -0.844648f, -0.844700f, -0.844751f, -0.844802f,
	-0.844854f, -0.844905f, -0.844956f, -0.845007f, -0.845059f, -0.845110f, -0.845161f, -0.845212f,
	-0.845264f, -0.845315f, -0.845366f, -0.845417f, -0.845469f, -0.845520f, -0.845571f, -0.845622f,
	-0.845673f, -0.845724f, -0.845776f, -0.845827f, -0.845878f, -0.845929f, -0.845980f, -0.846031f,
	-0.846082f, -0.846133f, -0.846185f, -0.846236f, -0.846287f, -0.846338f, -0.846389f, -0.846440f,
	-0.846491f, -0.846542f, -0.846593f, -0.846644f, -0.846695f, -0.846746f, -0.846797f, -0.846848f,
	-0.846899f, -0.846950f, -0.847001f, -0.847052f, -0.847103f, -0.847154f, -0.847205f, -0.847256f,
	-0.847307f, -0.847358f, -0.847408f, -0.847459f, -0.847510f, -0.847561f, -0.847612f, -0.847663f,
	-0.847714f, -0.847765f, -0.847815f, -0.847866f, -0.847917f, -0.847968f, -0.848019f, -0.848070f,
	-0.848120f, -0.848171f, -0.848222f, -0.848273f, -0.848323f, -0.848374f, -0.848425f, -0.848476f,
	-0.848526f, -0.848577f, -0.848628f, -0.848679f, -0.848729f, -0.848780f, -0.848831f, -0.848881f,
	-0.848932f, -0.848983f, -0.849033f, -0.849084f, -0.849135f, -0.849185f, -0.849236f, -0.849287f,
	-0.849337f, -0.849388f, -0.849438f, -0.849489f, -0.849540f, -0.849590f, -0.849641f, -0.849691f,
	-0.849742f, -0.849792f, -0.849843f, -0.849893f, -0.849944f, -0.849994f, -0.850045f, -0.850095f,
	-0.850146f, -0.850196f, -0.850247f, -0.850297f, -0.850348f, -0.850398f, -0.850449f, -0.850499f,
	-0.850549f, -0.850600f, -0.850650f, -0.850701f, -0.850751f, -0.850801f, -0.850852f, -0.850902f,
	-0.850953f, -0.851003f, -0.851053f, -0.851104f, -0.851154f, -0.851204f, -0.851255f, -0.851305f,
	-0.851355f, -0.851406f, -0.851456f, -0.851506f, -0.851556f, -0.851607f, -0.851657f, -0.851707f,
	-0.851757f, -0.851808f, -0.851858f, -0.851908f, -0.851958f, -0.852008f, -0.852059f, -0.852109f,
	-0.852159f, -0.852209f, -0.852259f, -0.852309f, -0.852360f, -0.852410f, -0.852460f, -0.852510f,
	-0.852560f, -0.852610f, -0.852660f, -0.852710f, -0.852760f, -0.852810f, -0.852861f, -0.852911f,
	-0.852961f, -0.853011f, -0.853061f, -0.853111f, -0.853161f, -0.853211f, -0.853261f, -0.853311f,
	-0.853361f, -0.853411f, -0.853461f, -0.853511f, -0.853561f, -0.853611f, -0.853660f, -0.853710f,
	-0.853760f, -0.853810f, -0.853860f, -0.853910f, -0.853960f, -0.854010f, -0.854060f, -0.854110f,
	-0.854159f, -0.854209f, -0.854259f, -0.854309f, -0.854359f, -0.854409f, -0.854458f, -0.854508f,
	-0.854558f, -0.854608f, -0.854658f, -0.854707f, -0.854757f, -0.854807f, -0.854857f, -0.854906f,
	-0.854956f, -0.855006f, -0.855056f, -0.855105f, -0.855155f, -0.855205f, -0.855254f, -0.855304f,
	-0.855354f, -0.855403f, -0.855453f, -0.855503f, -0.855552f, -0.855602f, -0.855651f, -0.855701f,
	-0.855751f, -0.855800f, -0.855850f, -0.855900f, -0.855949f, -0.855999f, -0.856048f, -0.856098f,
	-0.856147f, -0.856197f, -0.856246f, -0.856296f, -0.856345f, -0.856395f, -0.856444f, -0.856494f,
	-0.856543f, -0.856593f, -0.856642f, -0.856692f, -0.856741f, -0.856791f, -0.856840f, -0.856890f,
	-0.856939f, -0.856988f, -0.857038f, -0.857087f, -0.857137f, -0.857186f, -0.857235f, -0.857285f,
	-0.857334f, -0.857383f, -0.857433f, -0.857482f, -0.857531f, -0.857581f, -0.857630f, -0.857679f,
	-0.857729f, -0.857778f, -0.857827f, -0.857876f, -0.857926f, -0.857975f, -0.858024f, -0.858073f,
	-0.858123f, -0.858172f, -0.858221f, -0.858270f, -0.858320f, -0.858369f, -0.858418f, -0.858467f,
	-0.858516f, -0.858565f, -0.858615f, -0.858664f, -0.858713f, -0.858762f, -0.858811f, -0.858860f,
	-0.858909f, -0.858958f, -0.859007f, -0.859057f, -0.859106f, -0.859155f, -0.859204f, -0.859253f,
	-0.859302f, -0.859351f, -0.859400f, -0.859449f, -0.859498f, -0.859547f, -0.859596f, -0.859645f,
	-0.859694f, -0.859743f, -0.859792f, -0.859841f, -0.859890f, -0.859939f, -0.859988f, -0.860036f,
	-0.860085f, -0.860134f, -0.860183f, -0.860232f, -0.860281f, -0.860330f, -0.860379f, -0.860428f,
	-0.860476f, -0.860525f, -0.860574f, -0.860623f, -0.860672f, -0.860721f, -0.860769f, -0.860818f,
	-0.860867f, -0.860916f, -0.860964f, -0.861013f, -0.861062f, -0.861111f, -0.861160f, -0.861208f,
	-0.861257f, -0.861306f, -0.861354f, -0.861403f, -0.861452f, -0.861500f, -0.861549f, -0.861598f,
	-0.861646f, -0.861695f, -0.861744f, -0.861792f, -0.861841f, -0.861890f, -0.861938f, -0.861987f,
	-0.862035f, -0.862084f, -0.862133f, -0.862181f, -0.862230f, -0.862278f, -0.862327f, -0.862375f,
	-0.862424f, -0.862472f, -0.862521f, -0.862570f, -0.862618f, -0.862666f, -0.862715f, -0.862763f,
	-0.862812f, -0.862860f, -0.862909f, -0.862957f, -0.863006f, -0.863054f, -0.863103f, -0.863151f,
	-0.863199f, -0.863248f, -0.863296f, -0.863345f, -0.863393f, -0.863441f, -0.863490f, -0.863538f,
	-0.863586f, -0.863635f, -0.863683f, -0.863731f, -0.863780f, -0.863828f, -0.863876f, -0.863925f,
	-0.863973f, -0.864021f, -0.864069f, -0.864118f, -0.864166f, -0.864214f, -0.864262f, -0.864311f,
	-0.864359f, -0.864407f, -0.864455f, -0.864503f, -0.864552f, -0.864600f, -0.864648f, -0.864696f,
	-0.864744f, -0.864792f, -0.864841f, -0.864889f, -0.864937f, -0.864985f, -0.865033f, -0.865081f,
	-0.865129f, -0.865177f, -0.865225f, -0.865273f, -0.865321f, -0.865369f, -0.865418f, -0.865466f,
	-0.865514f, -0.865562f, -0.865610f, -0.865658f, -0.865706f, -0.865754f, -0.865802f, -0.865850f,
	-0.865898f, -0.865946f, -0.865993f, -0.866041f, -0.866089f, -0.866137f, -0.866185f, -0.866233f,
	-0.866281f, -0.866329f, -0.866377f, -0.866425f, -0.866472f, -0.866520f, -0.866568f, -0.866616f,
	-0.866664f, -0.866712f, -0.866759f, -0.866807f, -0.866855f, -0.866903f, -0.866951f, -0.866998f,
	-0.867046f, -0.867094f, -0.867142f, -0.867190f, -0.867237f, -0.867285f, -0.867333f, -0.867380f,
	-0.867428f, -0.867476f, -0.867523f, -0.867571f, -0.867619f, -0.867667f, -0.867714f, -0.867762f,
	-0.867809f, -0.867857f, -0.867905f, -0.867952f, -0.868000f, -0.868048f, -0.868095f, -0.868143f,
	-0.868190f, -0.868238f, -0.868285f, -0.868333f, -0.868381f, -0.868428f, -0.868476f, -0.868523f,
	-0.868571f, -0.868618f, -0.868666f, -0.868713f, -0.868761f, -0.868808f, -0.868856f, -0.868903f,
	-0.868951f, -0.868998f, -0.869045f, -0.869093f, -0.869140f, -0.869188f, -0.869235f, -0.869282f,
	-0.869330f, -0.869377f, -0.869425f, -0.869472f, -0.869519f, -0.869567f, -0.869614f, -0.869661f,
	-0.869709f, -0.869756f, -0.869803f, -0.869851f, -0.869898f, -0.869945f, -0.869992f, -0.870040f,
	-0.870087f, -0.870134f, -0.870182f, -0.870229f, -0.870276f, -0.870323f, -0.870370f, -0.870418f,
	-0.870465f, -0.870512f, -0.870559f, -0.870606f, -0.870654f, -0.870701f, -0.870748f, -0.870795f,
	-0.870842f, -0.870889f, -0.870936f, -0.870983f, -0.871031f, -0.871078f, -0.871125f, -0.871172f,
	-0.871219f, -0.871266f, -0.871313f, -0.871360f, -0.871407f, -0.871454f, -0.871501f, -0.871548f,
	-0.871595f, -0.871642f, -0.871689f, -0.871736f, -0.871783f, -0.871830f, -0.871877f, -0.871924f,
	-0.871971f, -0.872018f, -0.872065f, -0.872112f, -0.872159f, -0.872205f, -0.872252f, -0.872299f,
	-0.872346f, -0.872393f, -0.872440f, -0.872487f, -0.872534f, -0.872580f, -0.872627f, -0.872674f,
	-0.872721f, -0.872768f, -0.872814f, -0.872861f, -0.872908f, -0.872955f, -0.873001f, -0.873048f,
	-0.873095f, -0.873142f, -0.873188f, -0.873235f, -0.873282f, -0.873329f, -0.873375f, -0.873422f,
	-0.873469f, -0.873515f, -0.873562f, -0.873609f, -0.873655f, -0.873702f, -0.873749f, -0.873795f,
	-0.873842f, -0.873888f, -0.873935f, -0.873982f, -0.874028f, -0.874075f, -0.874121f, -0.874168f,
	-0.874215f, -0.874261f, -0.874308f, -0.874354f, -0.874401f, -0.874447f, -0.874494f, -0.874540f,
	-0.874587f, -0.874633f, -0.874680f, -0.874726f, -0.874773f, -0.874819f, -0.874865f, -0.874912f,
	-0.874958f, -0.875005f, -0.875051f, -0.875098f, -0.875144f, -0.875190f, -0.875237f, -0.875283f,
	-0.875329f, -0.875376f, -0.875422f, -0.875468f, -0.875515f, -0.875561f, -0.875607f, -0.875654f,
	-0.875700f, -0.875746f, -0.875793f, -0.875839f, -0.875885f, -0.875931f, -0.875978f, -0.876024f,
	-0.876070f, -0.876116f, -0.876163f, -0.876209f, -0.876255f, -0.876301f, -0.876347f, -0.876393f,
	-0.876440f, -0.876486f, -0.876532f, -0.876578f, -0.876624f, -0.876670f, -0.876716f, -0.876763f,
	-0.876809f, -0.876855f, -0.876901f, -0.876947f, -0.876993f, -0.877039f, -0.877085f, -0.877131f,
	-0.877177f, -0.877223f, -0.877269f, -0.877315f, -0.877361f, -0.877407f, -0.877453f, -0.877499f,
	-0.877545f, -0.877591f, -0.877637f, -0.877683f, -0.877729f, -0.877775f, -0.877821f, -0.877867f,
	-0.877913f, -0.877959f, -0.878005f, -0.878051f, -0.878096f, -0.878142f, -0.878188f, -0.878234f,
	-0.878280f, -0.878326f, -0.878371f, -0.878417f, -0.878463f, -0.878509f, -0.878555f, -0.878600f,
	-0.878646f, -0.878692f, -0.878738f, -0.878784f, -0.878829f, -0.878875f, -0.878921f, -0.878967f,
	-0.879012f, -0.879058f, -0.879104f, -0.879149f, -0.879195f, -0.879241f, -0.879286f, -0.879332f,
	-0.879378f, -0.879423f, -0.879469f, -0.879515f, -0.879560f, -0.879606f, -0.879651f, -0.879697f,
	-0.879743f, -0.879788f, -0.879834f, -0.879879f, -0.879925f, -0.879970f, -0.880016f, -0.880061f,
	-0.880107f, -0.880153f, -0.880198f, -0.880244f, -0.880289f, -0.880334f, -0.880380f, -0.880425f,
	-0.880471f, -0.880516f, -0.880562f, -0.880607f, -0.880653f, -0.880698f, -0.880743f, -0.880789f,
	-0.880834f, -0.880880f, -0.880925f, -0.880970f, -0.881016f, -0.881061f, -0.881106f, -0.881152f,
	-0.881197f, -0.881242f, -0.881288f, -0.881333f, -0.881378f, -0.881424f, -0.881469f, -0.881514f,
	-0.881559f, -0.881605f, -0.881650f, -0.881695f, -0.881740f, -0.881786f, -0.881831f, -0.881876f,
	-0.881921f, -0.881966f, -0.882012f, -0.882057f, -0.882102f, -0.882147f, -0.882192f, -0.882237f,
	-0.882283f, -0.882328f, -0.882373f, -0.882418f, -0.882463f, -0.882508f, -0.882553f, -0.882598f,
	-0.882643f, -0.882688f, -0.882733f, -0.882779f, -0.882824f, -0.882869f, -0.882914f, -0.882959f,
	-0.883004f, -0.883049f, -0.883094f, -0.883139f, -0.883184f, -0.883228f, -0.883273f, -0.883318f,
	-0.883363f, -0.883408f, -0.883453f, -0.883498f, -0.883543f, -0.883588f, -0.883633f, -0.883678f,
	-0.883723f, -0.883767f, -0.883812f, -0.883857f, -0.883902f, -0.883947f, -0.883992f, -0.884036f,
	-0.884081f, -0.884126f, -0.884171f, -0.884216f, -0.884260f, -0.884305f, -0.884350f, -0.884395f,
	-0.884439f, -0.884484f, -0.884529f, -0.884574f, -0.884618f, -0.884663f, -0.884708f, -0.884752f,
	-0.884797f, -0.884842f, -0.884886f, -0.884931f, -0.884976f, -0.885020f, -0.885065f, -0.885110f,
	-0.885154f, -0.885199f, -0.885243f, -0.885288f, -0.885333f, -0.885377f, -0.885422f, -0.885466f,
	-0.885511f, -0.885555f, -0.885600f, -0.885644f, -0.885689f, -0.885733f, -0.885778f, -0.885822f,
	-0.885867f, -0.885911f, -0.885956f, -0.886000f, -0.886045f, -0.886089f, -0.886134f, -0.886178f,
	-0.886223f, -0.886267f, -0.886311f, -0.886356f, -0.886400f, -0.886445f, -0.886489f, -0.886533f,
	-0.886578f, -0.886622f, -0.886666f, -0.886711f, -0.886755f, -0.886799f, -0.886844f, -0.886888f,
	-0.886932f, -0.886976f, -0.887021f, -0.887065f, -0.887109f, -0.887153f, -0.887198f, -0.887242f,
	-0.887286f, -0.887330f, -0.887375f, -0.887419f, -0.887463f, -0.887507f, -0.887551f, -0.887595f,
	-0.887640f, -0.887684f, -0.887728f, -0.887772f, -0.887816f, -0.887860f, -0.887904f, -0.887949f,
	-0.887993f, -0.888037f, -0.888081f, -0.888125f, -0.888169f, -0.888213f, -0.888257f, -0.888301f,
	-0.888345f, -0.888389f, -0.888433f, -0.888477f, -0.888521f, -0.888565f, -0.888609f, -0.888653f,
	-0.888697f, -0.888741f, -0.888785f, -0.888829f, -0.888873f, -0.888917f, -0.888961f, -0.889004f,
	-0.889048f, -0.889092f, -0.889136f, -0.889180f, -0.889224f, -0.889268f, -0.889312f, -0.889355f,
	-0.889399f, -0.889443f, -0.889487f, -0.889531f, -0.889574f, -0.889618f, -0.889662f, -0.889706f,
	-0.889750f, -0.889793f, -0.889837f, -0.889881f, -0.889925f, -0.889968f, -0.890012f, -0.890056f,
	-0.890099f, -0.890143f, -0.890187f, -0.890230f, -0.890274f, -0.890318f, -0.890361f, -0.890405f,
	-0.890449f, -0.890492f, -0.890536f, -0.890580f, -0.890623f, -0.890667f, -0.890710f, -0.890754f,
	-0.890797f, -0.890841f, -0.890885f, -0.890928f, -0.890972f, -0.891015f, -0.891059f, -0.891102f,
	-0.891146f, -0.891189f, -0.891233f, -0.891276f, -0.891320f, -0.891363f, -0.891407f, -0.891450f,
	-0.891493f, -0.891537f, -0.891580f, -0.891624f, -0.891667f, -0.891711f, -0.891754f, -0.891797f,
	-0.891841f, -0.891884f, -0.891927f, -0.891971f, -0.892014f, -0.892057f, -0.892101f, -0.892144f,
	-0.892187f, -0.892231f, -0.892274f, -0.892317f, -0.892361f, -0.892404f, -0.892447f, -0.892490f,
	-0.892534f, -0.892577f, -0.892620f, -0.892663f, -0.892706f, -0.892750f, -0.892793f, -0.892836f,
	-0.892879f, -0.892922f, -0.892965f, -0.893009f, -0.893052f, -0.893095f, -0.893138f, -0.893181f,
	-0.893224f, -0.893267f, -0.893310f, -0.893354f, -0.893397f, -0.893440f, -0.893483f, -0.893526f,
	-0.893569f, -0.893612f, -0.893655f, -0.893698f, -0.893741f, -0.893784f, -0.893827f, -0.893870f,
	-0.893913f, -0.893956f, -0.893999f, -0.894042f, -0.894085f, -0.894128f, -0.894171f, -0.894214f,
	-0.894256f, -0.894299f, -0.894342f, -0.894385f, -0.894428f, -0.894471f, -0.894514f, -0.894557f,
	-0.894599f, -0.894642f, -0.894685f, -0.894728f, -0.894771f, -0.894814f, -0.894856f, -0.894899f,
	-0.894942f, -0.894985f, -0.895028f, -0.895070f, -0.895113f, -0.895156f, -0.895198f, -0.895241f,
	-0.895284f, -0.895327f, -0.895369f, -0.895412f, -0.895455f, -0.895497f, -0.895540f, -0.895583f,
	-0.895625f, -0.895668f, -0.895711f, -0.895753f, -0.895796f, -0.895838f, -0.895881f, -0.895924f,
	-0.895966f, -0.896009f, -0.896051f, -0.896094f, -0.896137f, -0.896179f, -0.896222f, -0.896264f,
	-0.896307f, -0.896349f, -0.896392f, -0.896434f, -0.896477f, -0.896519f, -0.896562f, -0.896604f,
	-0.896646f, -0.896689f, -0.896731f, -0.896774f, -0.896816f, -0.896859f, -0.896901f, -0.896943f,
	-0.896986f, -0.897028f, -0.897071f, -0.897113f, -0.897155f, -0.897198f, -0.897240f, -0.897282f,
	-0.897325f, -0.897367f, -0.897409f, -0.897452f, -0.897494f, -0.897536f, -0.897578f, -0.897621f,
	-0.897663f, -0.897705f, -0.897747f, -0.897790f, -0.897832f, -0.897874f, -0.897916f, -0.897958f,
	-0.898001f, -0.898043f, -0.898085f, -0.898127f, -0.898169f, -0.898211f, -0.898254f, -0.898296f,
	-0.898338f, -0.898380f, -0.898422f, -0.898464f, -0.898506f, -0.898548f, -0.898590f, -0.898632f,
	-0.898674f, -0.898717f, -0.898759f, -0.898801f, -0.898843f, -0.898885f, -0.898927f, -0.898969f,
	-0.899011f, -0.899053f, -0.899095f, -0.899137f, -0.899179f, -0.899220f, -0.899262f, -0.899304f,
	-0.899346f, -0.899388f, -0.899430f, -0.899472f, -0.899514f, -0.899556f, -0.899598f, -0.899639f,
	-0.899681f, -0.899723f, -0.899765f, -0.899807f, -0.899849f, -0.899890f, -0.899932f, -0.899974f,
	-0.900016f, -0.900058f, -0.900099f, -0.900141f, -0.900183f, -0.900225f, -0.900266f, -0.900308f,
	-0.900350f, -0.900392f, -0.900433f, -0.900475f, -0.900517f, -0.900558f, -0.900600f, -0.900642f,
	-0.900683f, -0.900725f, -0.900767f, -0.900808f, -0.900850f, -0.900892f, -0.900933f, -0.900975f,
	-0.901016f, -0.901058f, -0.901100f, -0.901141f, -0.901183f, -0.901224f, -0.901266f, -0.901307f,
	-0.901349f, -0.901390f, -0.901432f, -0.901473f, -0.901515f, -0.901556f, -0.901598f, -0.901639f,
	-0.901681f, -0.901722f, -0.901764f, -0.901805f, -0.901847f, -0.901888f, -0.901929f, -0.901971f,
	-0.902012f, -0.902054f, -0.902095f, -0.902136f, -0.902178f, -0.902219f, -0.902260f, -0.902302f,
	-0.902343f, -0.902384f, -0.902426f, -0.902467f, -0.902508f, -0.902550f, -0.902591f, -0.902632f,
	-0.902673f, -0.902715f, -0.902756f, -0.902797f, -0.902838f, -0.902879f, -0.902921f, -0.902962f,
	-0.903003f, -0.903044f, -0.903085f, -0.903127f, -0.903168f, -0.903209f, -0.903250f, -0.903291f,
	-0.903332f, -0.903373f, -0.903415f, -0.903456f, -0.903497f, -0.903538f, -0.903579f, -0.903620f,
	-0.903661f, -0.903702f, -0.903743f, -0.903784f, -0.903825f, -0.903866f, -0.903907f, -0.903948f,
	-0.903989f, -0.904030f, -0.904071f, -0.904112f, -0.904153f, -0.904194f, -0.904235f, -0.904276f,
	-0.904317f, -0.904358f, -0.904399f, -0.904440f, -0.904481f, -0.904521f, -0.904562f, -0.904603f,
	-0.904644f, -0.904685f, -0.904726f, -0.904767f, -0.904807f, -0.904848f, -0.904889f, -0.904930f,
	-0.904971f, -0.905011f, -0.905052f, -0.905093f, -0.905134f, -0.905175f, -0.905215f, -0.905256f,
	-0.905297f, -0.905337f, -0.905378f, -0.905419f, -0.905460f, -0.905500f, -0.905541f, -0.905582f,
	-0.905622f, -0.905663f, -0.905704f, -0.905744f, -0.905785f, -0.905825f, -0.905866f, -0.905907f,
	-0.905947f, -0.905988f, -0.906028f, -0.906069f, -0.906110f, -0.906150f, -0.906191f, -0.906231f,
	-0.906272f, -0.906312f, -0.906353f, -0.906393f, -0.906434f, -0.906474f, -0.906515f, -0.906555f,
	-0.906596f, -0.906636f, -0.906677f, -0.906717f, -0.906757f, -0.906798f, -0.906838f, -0.906879f,
	-0.906919f, -0.906959f, -0.907000f, -0.907040f, -0.907081f, -0.907121f, -0.907161f, -0.907202f,
	-0.907242f, -0.907282f, -0.907323f, -0.907363f, -0.907403f, -0.907444f, -0.907484f, -0.907524f,
	-0.907564f, -0.907605f, -0.907645f, -0.907685f, -0.907725f, -0.907766f, -0.907806f, -0.907846f,
	-0.907886f, -0.907926f, -0.907966f, -0.908007f, -0.908047f, -0.908087f, -0.908127f, -0.908167f,
	-0.908207f, -0.908248f, -0.908288f, -0.908328f, -0.908368f, -0.908408f, -0.908448f, -0.908488f,
	-0.908528f, -0.908568f, -0.908608f, -0.908648f, -0.908688f, -0.908728f, -0.908768f, -0.908808f,
	-0.908848f, -0.908888f, -0.908928f, -0.908968f, -0.909008f, -0.909048f, -0.909088f, -0.909128f,
	-0.909168f, -0.909208f, -0.909248f, -0.909288f, -0.909328f, -0.909368f, -0.909407f, -0.909447f,
	-0.909487f, -0.909527f, -0.909567f, -0.909607f, -0.909646f, -0.909686f, -0.909726f, -0.909766f,
	-0.909806f, -0.909845f, -0.909885f, -0.909925f, -0.909965f, -0.910005f, -0.910044f, -0.910084f,
	-0.910124f, -0.910163f, -0.910203f, -0.910243f, -0.910283f, -0.910322f, -0.910362f, -0.910402f,
	-0.910441f, -0.910481f, -0.910521f, -0.910560f, -0.910600f, -0.910639f, -0.910679f, -0.910719f,
	-0.910758f, -0.910798f, -0.910837f, -0.910877f, -0.910917f, -0.910956f, -0.910996f, -0.911035f,
	-0.911075f, -0.911114f, -0.911154f, -0.911193f, -0.911233f, -0.911272f, -0.911312f, -0.911351f,
	-0.911391f, -0.911430f, -0.911470f, -0.911509f, -0.911548f, -0.911588f, -0.911627f, -0.911667f,
	-0.911706f, -0.911745f, -0.911785f, -0.911824f, -0.911864f, -0.911903f, -0.911942f, -0.911982f,
	-0.912021f, -0.912060f, -0.912099f, -0.912139f, -0.912178f, -0.912217f, -0.912257f, -0.912296f,
	-0.912335f, -0.912374f, -0.912414f, -0.912453f, -0.912492f, -0.912531f, -0.912571f, -0.912610f,
	-0.912649f, -0.912688f, -0.912727f, -0.912766f, -0.912806f, -0.912845f, -0.912884f, -0.912923f,
	-0.912962f, -0.913001f, -0.913040f, -0.913080f, -0.913119f, -0.913158f, -0.913197f, -0.913236f,
	-0.913275f, -0.913314f, -0.913353f, -0.913392f, -0.913431f, -0.913470f, -0.913509f, -0.913548f,
	-0.913587f, -0.913626f, -0.913665f, -0.913704f, -0.913743f, -0.913782f, -0.913821f, -0.913860f,
	-0.913899f, -0.913938f, -0.913976f, -0.914015f, -0.914054f, -0.914093f, -0.914132f, -0.914171f,
	-0.914210f, -0.914249f, -0.914287f, -0.914326f, -0.914365f, -0.914404f, -0.914443f, -0.914482f,
	-0.914520f, -0.914559f, -0.914598f, -0.914637f, -0.914675f, -0.914714f, -0.914753f, -0.914792f,
	-0.914830f, -0.914869f, -0.914908f, -0.914946f, -0.914985f, -0.915024f, -0.915062f, -0.915101f,
	-0.915140f, -0.915178f, -0.915217f, -0.915256f, -0.915294f, -0.915333f, -0.915372f, -0.915410f,
	-0.915449f, -0.915487f, -0.915526f, -0.915564f, -0.915603f, -0.915642f, -0.915680f, -0.915719f,
	-0.915757f, -0.915796f, -0.915834f, -0.915873f, -0.915911f, -0.915950f, -0.915988f, -0.916027f,
	-0.916065f, -0.916103f, -0.916142f, -0.916180f, -0.916219f, -0.916257f, -0.916296f, -0.916334f,
	-0.916372f, -0.916411f, -0.916449f, -0.916487f, -0.916526f, -0.916564f, -0.916602f, -0.916641f,
	-0.916679f, -0.916717f, -0.916756f, -0.916794f, -0.916832f, -0.916871f, -0.916909f, -0.916947f,
	-0.916985f, -0.917024f, -0.917062f, -0.917100f, -0.917138f, -0.917176f, -0.917215f, -0.917253f,
	-0.917291f, -0.917329f, -0.917367f, -0.917405f, -0.917444f, -0.917482f, -0.917520f, -0.917558f,
	-0.917596f, -0.917634f, -0.917672f, -0.917710f, -0.917749f, -0.917787f, -0.917825f, -0.917863f,
	-0.917901f, -0.917939f, -0.917977f, -0.918015f, -0.918053f, -0.918091f, -0.918129f, -0.918167f,
	-0.918205f, -0.918243f, -0.918281f, -0.918319f, -0.918357f, -0.918395f, -0.918433f, -0.918471f,
	-0.918508f, -0.918546f, -0.918584f, -0.918622f, -0.918660f, -0.918698f, -0.918736f, -0.918774f,
	-0.918811f, -0.918849f, -0.918887f, -0.918925f, -0.918963f, -0.919001f, -0.919038f, -0.919076f,
	-0.919114f, -0.919152f, -0.919189f, -0.919227f, -0.919265f, -0.919303f, -0.919340f, -0.919378f,
	-0.919416f, -0.919453f, -0.919491f, -0.919529f, -0.919567f, -0.919604f, -0.919642f, -0.919680f,
	-0.919717f, -0.919755f, -0.919792f, -0.919830f, -0.919868f, -0.919905f, -0.919943f, -0.919980f,
	-0.920018f, -0.920056f, -0.920093f, -0.920131f, -0.920168f, -0.920206f, -0.920243f, -0.920281f,
	-0.920318f, -0.920356f, -0.920393f, -0.920431f, -0.920468f, -0.920506f, -0.920543f, -0.920581f,
	-0.920618f, -0.920655f, -0.920693f, -0.920730f, -0.920768f, -0.920805f, -0.920842f, -0.920880f,
	-0.920917f, -0.920955f, -0.920992f, -0.921029f, -0.921067f, -0.921104f, -0.921141f, -0.921179f,
	-0.921216f, -0.921253f, -0.921291f, -0.921328f, -0.921365f, -0.921402f, -0.921440f, -0.921477f,
	-0.921514f, -0.921551f, -0.921588f, -0.921626f, -0.921663f, -0.921700f, -0.921737f, -0.921774f,
	-0.921812f, -0.921849f, -0.921886f, -0.921923f, -0.921960f, -0.921997f, -0.922034f, -0.922072f,
	-0.922109f, -0.922146f, -0.922183f, -0.922220f, -0.922257f, -0.922294f, -0.922331f, -0.922368f,
	-0.922405f, -0.922442f, -0.922479f, -0.922516f, -0.922553f, -0.922590f, -0.922627f, -0.922664f,
	-0.922701f, -0.922738f, -0.922775f, -0.922812f, -0.922849f, -0.922886f, -0.922923f, -0.922960f,
	-0.922997f, -0.923033f, -0.923070f, -0.923107f, -0.923144f, -0.923181f, -0.923218f, -0.923255f,
	-0.923291f, -0.923328f, -0.923365f, -0.923402f, -0.923439f, -0.923475f, -0.923512f, -0.923549f,
	-0.923586f, -0.923622f, -0.923659f, -0.923696f, -0.923733f, -0.923769f, -0.923806f, -0.923843f,
	-0.923880f, -0.923916f, -0.923953f, -0.923990f, -0.924026f, -0.924063f, -0.924100f, -0.924136f,
	-0.924173f, -0.924209f, -0.924246f, -0.924283f, -0.924319f, -0.924356f, -0.924392f, -0.924429f,
	-0.924465f, -0.924502f, -0.924539f, -0.924575f, -0.924612f, -0.924648f, -0.924685f, -0.924721f,
	-0.924758f, -0.924794f, -0.924831f, -0.924867f, -0.924904f, -0.924940f, -0.924976f, -0.925013f,
	-0.925049f, -0.925086f, -0.925122f, -0.925158f, -0.925195f, -0.925231f, -0.925268f, -0.925304f,
	-0.925340f, -0.925377f, -0.925413f, -0.925449f, -0.925486f, -0.925522f, -0.925558f, -0.925595f,
	-0.925631f, -0.925667f, -0.925703f, -0.925740f, -0.925776f, -0.925812f, -0.925848f, -0.925885f,
	-0.925921f, -0.925957f, -0.925993f, -0.926029f, -0.926066f, -0.926102f, -0.926138f, -0.926174f,
	-0.926210f, -0.926246f, -0.926283f, -0.926319f, -0.926355f, -0.926391f, -0.926427f, -0.926463f,
	-0.926499f, -0.926535f, -0.926571f, -0.926607f, -0.926643f, -0.926679f, -0.926715f, -0.926751f,
	-0.926787f, -0.926823f, -0.926859f, -0.926895f, -0.926931f, -0.926967f, -0.927003f, -0.927039f,
	-0.927075f, -0.927111f, -0.927147f, -0.927183f, -0.927219f, -0.927255f, -0.927291f, -0.927327f,
	-0.927363f, -0.927398f, -0.927434f, -0.927470f, -0.927506f, -0.927542f, -0.927578f, -0.927613f,
	-0.927649f, -0.927685f, -0.927721f, -0.927757f, -0.927792f, -0.927828f, -0.927864f, -0.927900f,
	-0.927935f, -0.927971f, -0.928007f, -0.928043f, -0.928078f, -0.928114f, -0.928150f, -0.928185f,
	-0.928221f, -0.928257f, -0.928292f, -0.928328f, -0.928364f, -0.928399f, -0.928435f, -0.928470f,
	-0.928506f, -0.928542f, -0.928577f, -0.928613f, -0.928648f, -0.928684f, -0.928720f, -0.928755f,
	-0.928791f, -0.928826f, -0.928862f, -0.928897f, -0.928933f, -0.928968f, -0.929004f, -0.929039f,
	-0.929075f, -0.929110f, -0.929146f, -0.929181f, -0.929216f, -0.929252f, -0.929287f, -0.929323f,
	-0.929358f, -0.929393f, -0.929429f, -0.929464f, -0.929500f, -0.929535f, -0.929570f, -0.929606f,
	-0.929641f, -0.929676f, -0.929712f, -0.929747f, -0.929782f, -0.929817f, -0.929853f, -0.929888f,
	-0.929923f, -0.929958f, -0.929994f, -0.930029f, -0.930064f, -0.930099f, -0.930135f, -0.930170f,
	-0.930205f, -0.930240f, -0.930275f, -0.930311f, -0.930346f, -0.930381f, -0.930416f, -0.930451f,
	-0.930486f, -0.930521f, -0.930556f, -0.930592f, -0.930627f, -0.930662f, -0.930697f, -0.930732f,
	-0.930767f, -0.930802f, -0.930837f, -0.930872f, -0.930907f, -0.930942f, -0.930977f, -0.931012f,
	-0.931047f, -0.931082f, -0.931117f, -0.931152f, -0.931187f, -0.931222f, -0.931257f, -0.931292f,
	-0.931327f, -0.931362f, -0.931397f, -0.931431f, -0.931466f, -0.931501f, -0.931536f, -0.931571f,
	-0.931606f, -0.931641f, -0.931675f, -0.931710f, -0.931745f, -0.931780f, -0.931815f, -0.931849f,
	-0.931884f, -0.931919f, -0.931954f, -0.931989f, -0.932023f, -0.932058f, -0.932093f, -0.932128f,
	-0.932162f, -0.932197f, -0.932232f, -0.932266f, -0.932301f, -0.932336f, -0.932370f, -0.932405f,
	-0.932440f, -0.932474f, -0.932509f, -0.932544f, -0.932578f, -0.932613f, -0.932647f, -0.932682f,
	-0.932716f, -0.932751f, -0.932786f, -0.932820f, -0.932855f, -0.932889f, -0.932924f, -0.932958f,
	-0.932993f, -0.933027f, -0.933062f, -0.933096f, -0.933131f, -0.933165f, -0.933200f, -0.933234f,
	-0.933269f, -0.933303f, -0.933337f, -0.933372f, -0.933406f, -0.933441f, -0.933475f, -0.933509f,
	-0.933544f, -0.933578f, -0.933612f, -0.933647f, -0.933681f, -0.933716f, -0.933750f, -0.933784f,
	-0.933818f, -0.933853f, -0.933887f, -0.933921f, -0.933956f, -0.933990f, -0.934024f, -0.934058f,
	-0.934093f, -0.934127f, -0.934161f, -0.934195f, -0.934229f, -0.934264f, -0.934298f, -0.934332f,
	-0.934366f, -0.934400f, -0.934434f, -0.934469f, -0.934503f, -0.934537f, -0.934571f, -0.934605f,
	-0.934639f, -0.934673f, -0.934707f, -0.934741f, -0.934775f, -0.934810f, -0.934844f, -0.934878f,
	-0.934912f, -0.934946f, -0.934980f, -0.935014f, -0.935048f, -0.935082f, -0.935116f, -0.935150f,
	-0.935184f, -0.935217f, -0.935251f, -0.935285f, -0.935319f, -0.935353f, -0.935387f, -0.935421f,
	-0.935455f, -0.935489f, -0.935523f, -0.935556f, -0.935590f, -0.935624f, -0.935658f, -0.935692f,
	-0.935726f, -0.935759f, -0.935793f, -0.935827f, -0.935861f, -0.935895f, -0.935928f, -0.935962f,
	-0.935996f, -0.936030f, -0.936063f, -0.936097f, -0.936131f, -0.936165f, -0.936198f, -0.936232f,
	-0.936266f, -0.936299f, -0.936333f, -0.936367f, -0.936400f, -0.936434f, -0.936468f, -0.936501f,
	-0.936535f, -0.936568f, -0.936602f, -0.936636f, -0.936669f, -0.936703f, -0.936736f, -0.936770f,
	-0.936803f, -0.936837f, -0.936871f, -0.936904f, -0.936938f, -0.936971f, -0.937005f, -0.937038f,
	-0.937072f, -0.937105f, -0.937138f, -0.937172f, -0.937205f, -0.937239f, -0.937272f, -0.937306f,
	-0.937339f, -0.937372f, -0.937406f, -0.937439f, -0.937473f, -0.937506f, -0.937539f, -0.937573f,
	-0.937606f, -0.937639f, -0.937673f, -0.937706f, -0.937739f, -0.937773f, -0.937806f, -0.937839f,
	-0.937872f, -0.937906f, -0.937939f, -0.937972f, -0.938005f, -0.938039f, -0.938072f, -0.938105f,
	-0.938138f, -0.938171f, -0.938205f, -0.938238f, -0.938271f, -0.938304f, -0.938337f, -0.938370f,
	-0.938404f, -0.938437f, -0.938470f, -0.938503f, -0.938536f, -0.938569f, -0.938602f, -0.938635f,
	-0.938668f, -0.938701f, -0.938734f, -0.938767f, -0.938800f, -0.938833f, -0.938866f, -0.938900f,
	-0.938932f, -0.938965f, -0.938998f, -0.939031f, -0.939064f, -0.939097f, -0.939130f, -0.939163f,
	-0.939196f, -0.939229f, -0.939262f, -0.939295f, -0.939328f, -0.939361f, -0.939394f, -0.939426f,
	-0.939459f, -0.939492f, -0.939525f, -0.939558f, -0.939591f, -0.939623f, -0.939656f, -0.939689f,
	-0.939722f, -0.939755f, -0.939787f, -0.939820f, -0.939853f, -0.939886f, -0.939918f, -0.939951f,
	-0.939984f, -0.940016f, -0.940049f, -0.940082f, -0.940115f, -0.940147f, -0.940180f, -0.940213f,
	-0.940245f, -0.940278f, -0.940310f, -0.940343f, -0.940376f, -0.940408f, -0.940441f, -0.940473f,
	-0.940506f, -0.940539f, -0.940571f, -0.940604f, -0.940636f, -0.940669f, -0.940701f, -0.940734f,
	-0.940766f, -0.940799f, -0.940831f, -0.940864f, -0.940896f, -0.940929f, -0.940961f, -0.940994f,
	-0.941026f, -0.941059f, -0.941091f, -0.941123f, -0.941156f, -0.941188f, -0.941221f, -0.941253f,
	-0.941285f, -0.941318f, -0.941350f, -0.941382f, -0.941415f, -0.941447f, -0.941479f, -0.941512f,
	-0.941544f, -0.941576f, -0.941609f, -0.941641f, -0.941673f, -0.941705f, -0.941738f, -0.941770f,
	-0.941802f, -0.941834f, -0.941867f, -0.941899f, -0.941931f, -0.941963f, -0.941995f, -0.942028f,
	-0.942060f, -0.942092f, -0.942124f, -0.942156f, -0.942188f, -0.942220f, -0.942253f, -0.942285f,
	-0.942317f, -0.942349f, -0.942381f, -0.942413f, -0.942445f, -0.942477f, -0.942509f, -0.942541f,
	-0.942573f, -0.942605f, -0.942637f, -0.942669f, -0.942701f, -0.942733f, -0.942765f, -0.942797f,
	-0.942829f, -0.942861f, -0.942893f, -0.942925f, -0.942957f, -0.942989f, -0.943021f, -0.943053f,
	-0.943084f, -0.943116f, -0.943148f, -0.943180f, -0.943212f, -0.943244f, -0.943276f, -0.943307f,
	-0.943339f, -0.943371f, -0.943403f, -0.943435f, -0.943466f, -0.943498f, -0.943530f, -0.943562f,
	-0.943593f, -0.943625f, -0.943657f, -0.943689f, -0.943720f, -0.943752f, -0.943784f, -0.943815f,
	-0.943847f, -0.943879f, -0.943910f, -0.943942f, -0.943974f, -0.944005f, -0.944037f, -0.944069f,
	-0.944100f, -0.944132f, -0.944163f, -0.944195f, -0.944227f, -0.944258f, -0.944290f, -0.944321f,
	-0.944353f, -0.944384f, -0.944416f, -0.944447f, -0.944479f, -0.944510f, -0.944542f, -0.944573f,
	-0.944605f, -0.944636f, -0.944668f, -0.944699f, -0.944731f, -0.944762f, -0.944793f, -0.944825f,
	-0.944856f, -0.944888f, -0.944919f, -0.944950f, -0.944982f, -0.945013f, -0.945045f, -0.945076f,
	-0.945107f, -0.945139f, -0.945170f, -0.945201f, -0.945232f, -0.945264f, -0.945295f, -0.945326f,
	-0.945358f, -0.945389f, -0.945420f, -0.945451f, -0.945482f, -0.945514f, -0.945545f, -0.945576f,
	-0.945607f, -0.945639f, -0.945670f, -0.945701f, -0.945732f, -0.945763f, -0.945794f, -0.945825f,
	-0.945857f, -0.945888f, -0.945919f, -0.945950f, -0.945981f, -0.946012f, -0.946043f, -0.946074f,
	-0.946105f, -0.946136f, -0.946167f, -0.946198f, -0.946229f, -0.946260f, -0.946291f, -0.946322f,
	-0.946353f, -0.946384f, -0.946415f, -0.946446f, -0.946477f, -0.946508f, -0.946539f, -0.946570f,
	-0.946601f, -0.946632f, -0.946663f, -0.946694f, -0.946724f, -0.946755f, -0.946786f, -0.946817f,
	-0.946848f, -0.946879f, -0.946910f, -0.946940f, -0.946971f, -0.947002f, -0.947033f, -0.947064f,
	-0.947094f, -0.947125f, -0.947156f, -0.947187f, -0.947217f, -0.947248f, -0.947279f, -0.947310f,
	-0.947340f, -0.947371f, -0.947402f, -0.947432f, -0.947463f, -0.947494f, -0.947524f, -0.947555f,
	-0.947586f, -0.947616f, -0.947647f, -0.947677f, -0.947708f, -0.947739f, -0.947769f, -0.947800f,
	-0.947830f, -0.947861f, -0.947891f, -0.947922f, -0.947953f, -0.947983f, -0.948014f, -0.948044f,
	-0.948075f, -0.948105f, -0.948136f, -0.948166f, -0.948196f, -0.948227f, -0.948257f, -0.948288f,
	-0.948318f, -0.948349f, -0.948379f, -0.948409f, -0.948440f, -0.948470f, -0.948501f, -0.948531f,
	-0.948561f, -0.948592f, -0.948622f, -0.948652f, -0.948683f, -0.948713f, -0.948743f, -0.948774f,
	-0.948804f, -0.948834f, -0.948864f, -0.948895f, -0.948925f, -0.948955f, -0.948985f, -0.949016f,
	-0.949046f, -0.949076f, -0.949106f, -0.949136f, -0.949167f, -0.949197f, -0.949227f, -0.949257f,
	-0.949287f, -0.949317f, -0.949348f, -0.949378f, -0.949408f, -0.949438f, -0.949468f, -0.949498f,
	-0.949528f, -0.949558f, -0.949588f, -0.949618f, -0.949648f, -0.949678f, -0.949708f, -0.949739f,
	-0.949768f, -0.949798f, -0.949829f, -0.949858f, -0.949888f, -0.949918f, -0.949948f, -0.949978f,
	-0.950008f, -0.950038f, -0.950068f, -0.950098f, -0.950128f, -0.950158f, -0.950188f, -0.950218f,
	-0.950247f, -0.950277f, -0.950307f, -0.950337f, -0.950367f, -0.950397f, -0.950426f, -0.950456f,
	-0.950486f, -0.950516f, -0.950546f, -0.950575f, -0.950605f, -0.950635f, -0.950665f, -0.950694f,
	-0.950724f, -0.950754f, -0.950784f, -0.950813f, -0.950843f, -0.950873f, -0.950902f, -0.950932f,
	-0.950962f, -0.950991f, -0.951021f, -0.951051f, -0.951080f, -0.951110f, -0.951139f, -0.951169f,
	-0.951199f, -0.951228f, -0.951258f, -0.951287f, -0.951317f, -0.951346f, -0.951376f, -0.951406f,
	-0.951435f, -0.951465f, -0.951494f, -0.951524f, -0.951553f, -0.951582f, -0.951612f, -0.951641f,
	-0.951671f, -0.951700f, -0.951730f, -0.951759f, -0.951789f, -0.951818f, -0.951847f, -0.951877f,
	-0.951906f, -0.951936f, -0.951965f, -0.951994f, -0.952024f, -0.952053f, -0.952082f, -0.952112f,
	-0.952141f, -0.952170f, -0.952199f, -0.952229f, -0.952258f, -0.952287f, -0.952317f, -0.952346f,
	-0.952375f, -0.952404f, -0.952433f, -0.952463f, -0.952492f, -0.952521f, -0.952550f, -0.952579f,
	-0.952609f, -0.952638f, -0.952667f, -0.952696f, -0.952725f, -0.952754f, -0.952783f, -0.952813f,
	-0.952842f, -0.952871f, -0.952900f, -0.952929f, -0.952958f, -0.952987f, -0.953016f, -0.953045f,
	-0.953074f, -0.953103f, -0.953132f, -0.953161f, -0.953190f, -0.953219f, -0.953248f, -0.953277f,
	-0.953306f, -0.953335f, -0.953364f, -0.953393f, -0.953422f, -0.953451f, -0.953480f, -0.953508f,
	-0.953537f, -0.953566f, -0.953595f, -0.953624f, -0.953653f, -0.953682f, -0.953711f, -0.953739f,
	-0.953768f, -0.953797f, -0.953826f, -0.953855f, -0.953883f, -0.953912f, -0.953941f, -0.953970f,
	-0.953998f, -0.954027f, -0.954056f, -0.954085f, -0.954113f, -0.954142f, -0.954171f, -0.954199f,
	-0.954228f, -0.954257f, -0.954285f, -0.954314f, -0.954343f, -0.954371f, -0.954400f, -0.954429f,
	-0.954457f, -0.954486f, -0.954514f, -0.954543f, -0.954572f, -0.954600f, -0.954629f, -0.954657f,
	-0.954686f, -0.954714f, -0.954743f, -0.954771f, -0.954800f, -0.954828f, -0.954857f, -0.954885f,
	-0.954914f, -0.954942f, -0.954971f, -0.954999f, -0.955028f, -0.955056f, -0.955084f, -0.955113f,
	-0.955141f, -0.955170f, -0.955198f, -0.955226f, -0.955255f, -0.955283f, -0.955311f, -0.955340f,
	-0.955368f, -0.955396f, -0.955425f, -0.955453f, -0.955481f, -0.955510f, -0.955538f, -0.955566f,
	-0.955594f, -0.955623f, -0.955651f, -0.955679f, -0.955707f, -0.955736f, -0.955764f, -0.955792f,
	-0.955820f, -0.955848f, -0.955876f, -0.955905f, -0.955933f, -0.955961f, -0.955989f, -0.956017f,
	-0.956045f, -0.956073f, -0.956101f, -0.956130f, -0.956158f, -0.956186f, -0.956214f, -0.956242f,
	-0.956270f, -0.956298f, -0.956326f, -0.956354f, -0.956382f, -0.956410f, -0.956438f, -0.956466f,
	-0.956494f, -0.956522f, -0.956550f, -0.956578f, -0.956606f, -0.956634f, -0.956662f, -0.956689f,
	-0.956717f, -0.956745f, -0.956773f, -0.956801f, -0.956829f, -0.956857f, -0.956885f, -0.956913f,
	-0.956940f, -0.956968f, -0.956996f, -0.957024f, -0.957052f, -0.957079f, -0.957107f, -0.957135f,
	-0.957163f, -0.957190f, -0.957218f, -0.957246f, -0.957274f, -0.957301f, -0.957329f, -0.957357f,
	-0.957385f, -0.957412f, -0.957440f, -0.957468f, -0.957495f, -0.957523f, -0.957550f, -0.957578f,
	-0.957606f, -0.957633f, -0.957661f, -0.957689f, -0.957716f, -0.957744f, -0.957771f, -0.957799f,
	-0.957826f, -0.957854f, -0.957882f, -0.957909f, -0.957937f, -0.957964f, -0.957992f, -0.958019f,
	-0.958046f, -0.958074f, -0.958101f, -0.958129f, -0.958156f, -0.958184f, -0.958211f, -0.958239f,
	-0.958266f, -0.958293f, -0.958321f, -0.958348f, -0.958376f, -0.958403f, -0.958430f, -0.958458f,
	-0.958485f, -0.958512f, -0.958540f, -0.958567f, -0.958594f, -0.958622f, -0.958649f, -0.958676f,
	-0.958703f, -0.958731f, -0.958758f, -0.958785f, -0.958812f, -0.958840f, -0.958867f, -0.958894f,
	-0.958921f, -0.958949f, -0.958976f, -0.959003f, -0.959030f, -0.959057f, -0.959084f, -0.959112f,
	-0.959139f, -0.959166f, -0.959193f, -0.959220f, -0.959247f, -0.959274f, -0.959301f, -0.959328f,
	-0.959355f, -0.959382f, -0.959409f, -0.959436f, -0.959463f, -0.959491f, -0.959518f, -0.959545f,
	-0.959572f, -0.959598f, -0.959625f, -0.959652f, -0.959679f, -0.959706f, -0.959733f, -0.959760f,
	-0.959787f, -0.959814f, -0.959841f, -0.959868f, -0.959895f, -0.959922f, -0.959948f, -0.959975f,
	-0.960002f, -0.960029f, -0.960056f, -0.960083f, -0.960109f, -0.960136f, -0.960163f, -0.960190f,
	-0.960217f, -0.960243f, -0.960270f, -0.960297f, -0.960324f, -0.960350f, -0.960377f, -0.960404f,
	-0.960431f, -0.960457f, -0.960484f, -0.960511f, -0.960537f, -0.960564f, -0.960591f, -0.960617f,
	-0.960644f, -0.960670f, -0.960697f, -0.960724f, -0.960750f, -0.960777f, -0.960804f, -0.960830f,
	-0.960857f, -0.960883f, -0.960910f, -0.960936f, -0.960963f, -0.960989f, -0.961016f, -0.961042f,
	-0.961069f, -0.961095f, -0.961122f, -0.961148f, -0.961175f, -0.961201f, -0.961228f, -0.961254f,
	-0.961280f, -0.961307f, -0.961333f, -0.961360f, -0.961386f, -0.961412f, -0.961439f, -0.961465f,
	-0.961492f, -0.961518f, -0.961544f, -0.961571f, -0.961597f, -0.961623f, -0.961649f, -0.961676f,
	-0.961702f, -0.961728f, -0.961755f, -0.961781f, -0.961807f, -0.961833f, -0.961860f, -0.961886f,
	-0.961912f, -0.961938f, -0.961964f, -0.961991f, -0.962017f, -0.962043f, -0.962069f, -0.962095f,
	-0.962121f, -0.962148f, -0.962174f, -0.962200f, -0.962226f, -0.962252f, -0.962278f, -0.962304f,
	-0.962330f, -0.962356f, -0.962382f, -0.962408f, -0.962434f, -0.962460f, -0.962486f, -0.962512f,
	-0.962538f, -0.962564f, -0.962590f, -0.962616f, -0.962642f, -0.962668f, -0.962694f, -0.962720f,
	-0.962746f, -0.962772f, -0.962798f, -0.962824f, -0.962850f, -0.962876f, -0.962902f, -0.962927f,
	-0.962953f, -0.962979f, -0.963005f, -0.963031f, -0.963057f, -0.963082f, -0.963108f, -0.963134f,
	-0.963160f, -0.963186f, -0.963211f, -0.963237f, -0.963263f, -0.963289f, -0.963314f, -0.963340f,
	-0.963366f, -0.963391f, -0.963417f, -0.963443f, -0.963469f, -0.963494f, -0.963520f, -0.963546f,
	-0.963571f, -0.963597f, -0.963623f, -0.963648f, -0.963674f, -0.963699f, -0.963725f, -0.963750f,
	-0.963776f, -0.963802f, -0.963827f, -0.963853f, -0.963878f, -0.963904f, -0.963929f, -0.963955f,
	-0.963980f, -0.964006f, -0.964031f, -0.964057f, -0.964082f, -0.964108f, -0.964133f, -0.964159f,
	-0.964184f, -0.964209f, -0.964235f, -0.964260f, -0.964286f, -0.964311f, -0.964336f, -0.964362f,
	-0.964387f, -0.964413f, -0.964438f, -0.964463f, -0.964489f, -0.964514f, -0.964539f, -0.964565f,
	-0.964590f, -0.964615f, -0.964640f, -0.964666f, -0.964691f, -0.964716f, -0.964741f, -0.964767f,
	-0.964792f, -0.964817f, -0.964842f, -0.964867f, -0.964893f, -0.964918f, -0.964943f, -0.964968f,
	-0.964993f, -0.965018f, -0.965044f, -0.965069f, -0.965094f, -0.965119f, -0.965144f, -0.965169f,
	-0.965194f, -0.965219f, -0.965244f, -0.965269f, -0.965294f, -0.965319f, -0.965344f, -0.965369f,
	-0.965394f, -0.965419f, -0.965444f, -0.965469f, -0.965494f, -0.965519f, -0.965544f, -0.965569f,
	-0.965594f, -0.965619f, -0.965644f, -0.965669f, -0.965694f, -0.965719f, -0.965744f, -0.965769f,
	-0.965793f, -0.965818f, -0.965843f, -0.965868f, -0.965893f, -0.965918f, -0.965942f, -0.965967f,
	-0.965992f, -0.966017f, -0.966042f, -0.966066f, -0.966091f, -0.966116f, -0.966141f, -0.966165f,
	-0.966190f, -0.966215f, -0.966239f, -0.966264f, -0.966289f, -0.966313f, -0.966338f, -0.966363f,
	-0.966387f, -0.966412f, -0.966437f, -0.966461f, -0.966486f, -0.966511f, -0.966535f, -0.966560f,
	-0.966584f, -0.966609f, -0.966633f, -0.966658f, -0.966683f, -0.966707f, -0.966732f, -0.966756f,
	-0.966781f, -0.966805f, -0.966830f, -0.966854f, -0.966879f, -0.966903f, -0.966928f, -0.966952f,
	-0.966976f, -0.967001f, -0.967025f, -0.967050f, -0.967074f, -0.967099f, -0.967123f, -0.967147f,
	-0.967172f, -0.967196f, -0.967220f, -0.967245f, -0.967269f, -0.967293f, -0.967318f, -0.967342f,
	-0.967366f, -0.967391f, -0.967415f, -0.967439f, -0.967463f, -0.967488f, -0.967512f, -0.967536f,
	-0.967560f, -0.967585f, -0.967609f, -0.967633f, -0.967657f, -0.967681f, -0.967706f, -0.967730f,
	-0.967754f, -0.967778f, -0.967802f, -0.967826f, -0.967850f, -0.967874f, -0.967899f, -0.967923f,
	-0.967947f, -0.967971f, -0.967995f, -0.968019f, -0.968043f, -0.968067f, -0.968091f, -0.968115f,
	-0.968139f, -0.968163f, -0.968187f, -0.968211f, -0.968235f, -0.968259f, -0.968283f, -0.968307f,
	-0.968331f, -0.968355f, -0.968379f, -0.968403f, -0.968427f, -0.968450f, -0.968474f, -0.968498f,
	-0.968522f, -0.968546f, -0.968570f, -0.968594f, -0.968617f, -0.968641f, -0.968665f, -0.968689f,
	-0.968713f, -0.968737f, -0.968760f, -0.968784f, -0.968808f, -0.968832f, -0.968855f, -0.968879f,
	-0.968903f, -0.968927f, -0.968950f, -0.968974f, -0.968998f, -0.969021f, -0.969045f, -0.969069f,
	-0.969092f, -0.969116f, -0.969140f, -0.969163f, -0.969187f, -0.969210f, -0.969234f, -0.969258f,
	-0.969281f, -0.969305f, -0.969328f, -0.969352f, -0.969375f, -0.969399f, -0.969423f, -0.969446f,
	-0.969470f, -0.969493f, -0.969517f, -0.969540f, -0.969564f, -0.969587f, -0.969611f, -0.969634f,
	-0.969657f, -0.969681f, -0.969704f, -0.969728f, -0.969751f, -0.969774f, -0.969798f, -0.969821f,
	-0.969845f, -0.969868f, -0.969891f, -0.969915f, -0.969938f, -0.969961f, -0.969985f, -0.970008f,
	-0.970031f, -0.970055f, -0.970078f, -0.970101f, -0.970124f, -0.970148f, -0.970171f, -0.970194f,
	-0.970217f, -0.970241f, -0.970264f, -0.970287f, -0.970310f, -0.970333f, -0.970357f, -0.970380f,
	-0.970403f, -0.970426f, -0.970449f, -0.970472f, -0.970495f, -0.970518f, -0.970542f, -0.970565f,
	-0.970588f, -0.970611f, -0.970634f, -0.970657f, -0.970680f, -0.970703f, -0.970726f, -0.970749f,
	-0.970772f, -0.970795f, -0.970818f, -0.970841f, -0.970864f, -0.970887f, -0.970910f, -0.970933f,
	-0.970956f, -0.970979f, -0.971002f, -0.971025f, -0.971048f, -0.971071f, -0.971093f, -0.971116f,
	-0.971139f, -0.971162f, -0.971185f, -0.971208f, -0.971231f, -0.971253f, -0.971276f, -0.971299f,
	-0.971322f, -0.971345f, -0.971367f, -0.971390f, -0.971413f, -0.971436f, -0.971458f, -0.971481f,
	-0.971504f, -0.971527f, -0.971549f, -0.971572f, -0.971595f, -0.971617f, -0.971640f, -0.971663f,
	-0.971685f, -0.971708f, -0.971731f, -0.971753f, -0.971776f, -0.971799f, -0.971821f, -0.971844f,
	-0.971866f, -0.971889f, -0.971911f, -0.971934f, -0.971957f, -0.971979f, -0.972002f, -0.972024f,
	-0.972047f, -0.972069f, -0.972092f, -0.972114f, -0.972137f, -0.972159f, -0.972182f, -0.972204f,
	-0.972227f, -0.972249f, -0.972271f, -0.972294f, -0.972316f, -0.972339f, -0.972361f, -0.972383f,
	-0.972406f, -0.972428f, -0.972450f, -0.972473f, -0.972495f, -0.972517f, -0.972540f, -0.972562f,
	-0.972584f, -0.972607f, -0.972629f, -0.972651f, -0.972673f, -0.972696f, -0.972718f, -0.972740f,
	-0.972762f, -0.972785f, -0.972807f, -0.972829f, -0.972851f, -0.972873f, -0.972896f, -0.972918f,
	-0.972940f, -0.972962f, -0.972984f, -0.973006f, -0.973028f, -0.973051f, -0.973073f, -0.973095f,
	-0.973117f, -0.973139f, -0.973161f, -0.973183f, -0.973205f, -0.973227f, -0.973249f, -0.973271f,
	-0.973293f, -0.973315f, -0.973337f, -0.973359f, -0.973381f, -0.973403f, -0.973425f, -0.973447f,
	-0.973469f, -0.973491f, -0.973513f, -0.973535f, -0.973557f, -0.973579f, -0.973601f, -0.973622f,
	-0.973644f, -0.973666f, -0.973688f, -0.973710f, -0.973732f, -0.973753f, -0.973775f, -0.973797f,
	-0.973819f, -0.973841f, -0.973862f, -0.973884f, -0.973906f, -0.973928f, -0.973949f, -0.973971f,
	-0.973993f, -0.974015f, -0.974036f, -0.974058f, -0.974080f, -0.974101f, -0.974123f, -0.974145f,
	-0.974166f, -0.974188f, -0.974210f, -0.974231f, -0.974253f, -0.974275f, -0.974296f, -0.974318f,
	-0.974339f, -0.974361f, -0.974383f, -0.974404f, -0.974426f, -0.974447f, -0.974469f, -0.974490f,
	-0.974512f, -0.974533f, -0.974555f, -0.974576f, -0.974598f, -0.974619f, -0.974641f, -0.974662f,
	-0.974684f, -0.974705f, -0.974726f, -0.974748f, -0.974769f, -0.974791f, -0.974812f, -0.974833f,
	-0.974855f, -0.974876f, -0.974897f, -0.974919f, -0.974940f, -0.974961f, -0.974983f, -0.975004f,
	-0.975025f, -0.975047f, -0.975068f, -0.975089f, -0.975110f, -0.975132f, -0.975153f, -0.975174f,
	-0.975195f, -0.975217f, -0.975238f, -0.975259f, -0.975280f, -0.975301f, -0.975323f, -0.975344f,
	-0.975365f, -0.975386f, -0.975407f, -0.975428f, -0.975449f, -0.975471f, -0.975492f, -0.975513f,
	-0.975534f, -0.975555f, -0.975576f, -0.975597f, -0.975618f, -0.975639f, -0.975660f, -0.975681f,
	-0.975702f, -0.975723f, -0.975744f, -0.975765f, -0.975786f, -0.975807f, -0.975828f, -0.975849f,
	-0.975870f, -0.975891f, -0.975912f, -0.975933f, -0.975954f, -0.975974f, -0.975995f, -0.976016f,
	-0.976037f, -0.976058f, -0.976079f, -0.976100f, -0.976120f, -0.976141f, -0.976162f, -0.976183f,
	-0.976204f, -0.976224f, -0.976245f, -0.976266f, -0.976287f, -0.976308f, -0.976328f, -0.976349f,
	-0.976370f, -0.976390f, -0.976411f, -0.976432f, -0.976453f, -0.976473f, -0.976494f, -0.976515f,
	-0.976535f, -0.976556f, -0.976576f, -0.976597f, -0.976618f, -0.976638f, -0.976659f, -0.976680f,
	-0.976700f, -0.976721f, -0.976741f, -0.976762f, -0.976782f, -0.976803f, -0.976823f, -0.976844f,
	-0.976864f, -0.976885f, -0.976905f, -0.976926f, -0.976946f, -0.976967f, -0.976987f, -0.977008f,
	-0.977028f, -0.977049f, -0.977069f, -0.977089f, -0.977110f, -0.977130f, -0.977151f, -0.977171f,
	-0.977191f, -0.977212f, -0.977232f, -0.977252f, -0.977273f, -0.977293f, -0.977313f, -0.977334f,
	-0.977354f, -0.977374f, -0.977394f, -0.977415f, -0.977435f, -0.977455f, -0.977475f, -0.977496f,
	-0.977516f, -0.977536f, -0.977556f, -0.977577f, -0.977597f, -0.977617f, -0.977637f, -0.977657f,
	-0.977677f, -0.977697f, -0.977718f, -0.977738f, -0.977758f, -0.977778f, -0.977798f, -0.977818f,
	-0.977838f, -0.977858f, -0.977878f, -0.977898f, -0.977918f, -0.977938f, -0.977959f, -0.977979f,
	-0.977998f, -0.978019f, -0.978038f, -0.978058f, -0.978078f, -0.978098f, -0.978118f, -0.978138f,
	-0.978158f, -0.978178f, -0.978198f, -0.978218f, -0.978238f, -0.978258f, -0.978278f, -0.978298f,
	-0.978317f, -0.978337f, -0.978357f, -0.978377f, -0.978397f, -0.978417f, -0.978436f, -0.978456f,
	-0.978476f, -0.978496f, -0.978516f, -0.978535f, -0.978555f, -0.978575f, -0.978594f, -0.978614f,
	-0.978634f, -0.978654f, -0.978673f, -0.978693f, -0.978713f, -0.978732f, -0.978752f, -0.978772f,
	-0.978791f, -0.978811f, -0.978831f, -0.978850f, -0.978870f, -0.978889f, -0.978909f, -0.978929f,
	-0.978948f, -0.978968f, -0.978987f, -0.979007f, -0.979026f, -0.979046f, -0.979065f, -0.979085f,
	-0.979104f, -0.979124f, -0.979143f, -0.979163f, -0.979182f, -0.979202f, -0.979221f, -0.979241f,
	-0.979260f, -0.979280f, -0.979299f, -0.979318f, -0.979338f, -0.979357f, -0.979376f, -0.979396f,
	-0.979415f, -0.979435f, -0.979454f, -0.979473f, -0.979493f, -0.979512f, -0.979531f, -0.979550f,
	-0.979570f, -0.979589f, -0.979608f, -0.979628f, -0.979647f, -0.979666f, -0.979685f, -0.979704f,
	-0.979724f, -0.979743f, -0.979762f, -0.979781f, -0.979800f, -0.979820f, -0.979839f, -0.979858f,
	-0.979877f, -0.979896f, -0.979915f, -0.979934f, -0.979954f, -0.979973f, -0.979992f, -0.980011f,
	-0.980030f, -0.980049f, -0.980068f, -0.980087f, -0.980106f, -0.980125f, -0.980144f, -0.980163f,
	-0.980182f, -0.980201f, -0.980220f, -0.980239f, -0.980258f, -0.980277f, -0.980296f, -0.980315f,
	-0.980334f, -0.980353f, -0.980372f, -0.980390f, -0.980409f, -0.980428f, -0.980447f, -0.980466f,
	-0.980485f, -0.980504f, -0.980523f, -0.980541f, -0.980560f, -0.980579f, -0.980598f, -0.980617f,
	-0.980635f, -0.980654f, -0.980673f, -0.980692f, -0.980710f, -0.980729f, -0.980748f, -0.980767f,
	-0.980785f, -0.980804f, -0.980823f, -0.980841f, -0.980860f, -0.980879f, -0.980897f, -0.980916f,
	-0.980935f, -0.980953f, -0.980972f, -0.980990f, -0.981009f, -0.981028f, -0.981046f, -0.981065f,
	-0.981083f, -0.981102f, -0.981120f, -0.981139f, -0.981158f, -0.981176f, -0.981195f, -0.981213f,
	-0.981232f, -0.981250f, -0.981269f, -0.981287f, -0.981305f, -0.981324f, -0.981342f, -0.981361f,
	-0.981379f, -0.981398f, -0.981416f, -0.981434f, -0.981453f, -0.981471f, -0.981490f, -0.981508f,
	-0.981526f, -0.981545f, -0.981563f, -0.981581f, -0.981600f, -0.981618f, -0.981636f, -0.981654f,
	-0.981673f, -0.981691f, -0.981709f, -0.981727f, -0.981746f, -0.981764f, -0.981782f, -0.981800f,
	-0.981819f, -0.981837f, -0.981855f, -0.981873f, -0.981891f, -0.981909f, -0.981928f, -0.981946f,
	-0.981964f, -0.981982f, -0.982000f, -0.982018f, -0.982036f, -0.982054f, -0.982072f, -0.982091f,
	-0.982109f, -0.982127f, -0.982145f, -0.982163f, -0.982181f, -0.982199f, -0.982217f, -0.982235f,
	-0.982253f, -0.982271f, -0.982289f, -0.982307f, -0.982325f, -0.982343f, -0.982360f, -0.982378f,
	-0.982396f, -0.982414f, -0.982432f, -0.982450f, -0.982468f, -0.982486f, -0.982504f, -0.982521f,
	-0.982539f, -0.982557f, -0.982575f, -0.982593f, -0.982611f, -0.982628f, -0.982646f, -0.982664f,
	-0.982682f, -0.982699f, -0.982717f, -0.982735f, -0.982753f, -0.982770f, -0.982788f, -0.982806f,
	-0.982824f, -0.982841f, -0.982859f, -0.982877f, -0.982894f, -0.982912f, -0.982930f, -0.982947f,
	-0.982965f, -0.982982f, -0.983000f, -0.983018f, -0.983035f, -0.983053f, -0.983070f, -0.983088f,
	-0.983105f, -0.983123f, -0.983141f, -0.983158f, -0.983176f, -0.983193f, -0.983211f, -0.983228f,
	-0.983246f, -0.983263f, -0.983281f, -0.983298f, -0.983315f, -0.983333f, -0.983350f, -0.983368f,
	-0.983385f, -0.983402f, -0.983420f, -0.983437f, -0.983455f, -0.983472f, -0.983489f, -0.983507f,
	-0.983524f, -0.983541f, -0.983559f, -0.983576f, -0.983593f, -0.983611f, -0.983628f, -0.983645f,
	-0.983662f, -0.983680f, -0.983697f, -0.983714f, -0.983731f, -0.983749f, -0.983766f, -0.983783f,
	-0.983800f, -0.983817f, -0.983835f, -0.983852f, -0.983869f, -0.983886f, -0.983903f, -0.983920f,
	-0.983937f, -0.983955f, -0.983972f, -0.983989f, -0.984006f, -0.984023f, -0.984040f, -0.984057f,
	-0.984074f, -0.984091f, -0.984108f, -0.984125f, -0.984142f, -0.984159f, -0.984176f, -0.984193f,
	-0.984210f, -0.984227f, -0.984244f, -0.984261f, -0.984278f, -0.984295f, -0.984312f, -0.984329f,
	-0.984346f, -0.984362f, -0.984379f, -0.984396f, -0.984413f, -0.984430f, -0.984447f, -0.984464f,
	-0.984480f, -0.984497f, -0.984514f, -0.984531f, -0.984548f, -0.984564f, -0.984581f, -0.984598f,
	-0.984615f, -0.984632f, -0.984648f, -0.984665f, -0.984682f, -0.984698f, -0.984715f, -0.984732f,
	-0.984748f, -0.984765f, -0.984782f, -0.984798f, -0.984815f, -0.984832f, -0.984848f, -0.984865f,
	-0.984882f, -0.984898f, -0.984915f, -0.984931f, -0.984948f, -0.984965f, -0.984981f, -0.984998f,
	-0.985014f, -0.985031f, -0.985047f, -0.985064f, -0.985080f, -0.985097f, -0.985113f, -0.985130f,
	-0.985146f, -0.985163f, -0.985179f, -0.985196f, -0.985212f, -0.985228f, -0.985245f, -0.985261f,
	-0.985278f, -0.985294f, -0.985310f, -0.985327f, -0.985343f, -0.985359f, -0.985376f, -0.985392f,
	-0.985408f, -0.985425f, -0.985441f, -0.985457f, -0.985474f, -0.985490f, -0.985506f, -0.985523f,
	-0.985539f, -0.985555f, -0.985571f, -0.985587f, -0.985604f, -0.985620f, -0.985636f, -0.985652f,
	-0.985668f, -0.985685f, -0.985701f, -0.985717f, -0.985733f, -0.985749f, -0.985765f, -0.985781f,
	-0.985798f, -0.985814f, -0.985830f, -0.985846f, -0.985862f, -0.985878f, -0.985894f, -0.985910f,
	-0.985926f, -0.985942f, -0.985958f, -0.985974f, -0.985990f, -0.986006f, -0.986022f, -0.986038f,
	-0.986054f, -0.986070f, -0.986086f, -0.986102f, -0.986118f, -0.986134f, -0.986150f, -0.986165f,
	-0.986181f, -0.986197f, -0.986213f, -0.986229f, -0.986245f, -0.986261f, -0.986276f, -0.986292f,
	-0.986308f, -0.986324f, -0.986340f, -0.986355f, -0.986371f, -0.986387f, -0.986403f, -0.986419f,
	-0.986434f, -0.986450f, -0.986466f, -0.986481f, -0.986497f, -0.986513f, -0.986529f, -0.986544f,
	-0.986560f, -0.986576f, -0.986591f, -0.986607f, -0.986623f, -0.986638f, -0.986654f, -0.986669f,
	-0.986685f, -0.986701f, -0.986716f, -0.986732f, -0.986747f, -0.986763f, -0.986778f, -0.986794f,
	-0.986809f, -0.986825f, -0.986840f, -0.986856f, -0.986871f, -0.986887f, -0.986902f, -0.986918f,
	-0.986933f, -0.986949f, -0.986964f, -0.986980f, -0.986995f, -0.987010f, -0.987026f, -0.987041f,
	-0.987057f, -0.987072f, -0.987087f, -0.987103f, -0.987118f, -0.987133f, -0.987149f, -0.987164f,
	-0.987179f, -0.987195f, -0.987210f, -0.987225f, -0.987240f, -0.987256f, -0.987271f, -0.987286f,
	-0.987301f, -0.987317f, -0.987332f, -0.987347f, -0.987362f, -0.987377f, -0.987393f, -0.987408f,
	-0.987423f, -0.987438f, -0.987453f, -0.987468f, -0.987484f, -0.987499f, -0.987514f, -0.987529f,
	-0.987544f, -0.987559f, -0.987574f, -0.987589f, -0.987604f, -0.987619f, -0.987634f, -0.987649f,
	-0.987664f, -0.987679f, -0.987694f, -0.987709f, -0.987724f, -0.987739f, -0.987754f, -0.987769f,
	-0.987784f, -0.987799f, -0.987814f, -0.987829f, -0.987844f, -0.987859f, -0.987874f, -0.987889f,
	-0.987903f, -0.987918f, -0.987933f, -0.987948f, -0.987963f, -0.987978f, -0.987992f, -0.988007f,
	-0.988022f, -0.988037f, -0.988052f, -0.988066f, -0.988081f, -0.988096f, -0.988111f, -0.988125f,
	-0.988140f, -0.988155f, -0.988169f, -0.988184f, -0.988199f, -0.988214f, -0.988228f, -0.988243f,
	-0.988258f, -0.988272f, -0.988287f, -0.988301f, -0.988316f, -0.988331f, -0.988345f, -0.988360f,
	-0.988374f, -0.988389f, -0.988404f, -0.988418f, -0.988433f, -0.988447f, -0.988462f, -0.988476f,
	-0.988491f, -0.988505f, -0.988520f, -0.988534f, -0.988549f, -0.988563f, -0.988578f, -0.988592f,
	-0.988607f, -0.988621f, -0.988635f, -0.988650f, -0.988664f, -0.988679f, -0.988693f, -0.988707f,
	-0.988722f, -0.988736f, -0.988750f, -0.988765f, -0.988779f, -0.988793f, -0.988808f, -0.988822f,
	-0.988836f, -0.988851f, -0.988865f, -0.988879f, -0.988893f, -0.988908f, -0.988922f, -0.988936f,
	-0.988950f, -0.988964f, -0.988979f, -0.988993f, -0.989007f, -0.989021f, -0.989035f, -0.989050f,
	-0.989064f, -0.989078f, -0.989092f, -0.989106f, -0.989120f, -0.989134f, -0.989148f, -0.989162f,
	-0.989177f, -0.989191f, -0.989205f, -0.989219f, -0.989233f, -0.989247f, -0.989261f, -0.989275f,
	-0.989289f, -0.989303f, -0.989317f, -0.989331f, -0.989345f, -0.989359f, -0.989373f, -0.989386f,
	-0.989400f, -0.989414f, -0.989428f, -0.989442f, -0.989456f, -0.989470f, -0.989484f, -0.989498f,
	-0.989511f, -0.989525f, -0.989539f, -0.989553f, -0.989567f, -0.989581f, -0.989594f, -0.989608f,
	-0.989622f, -0.989636f, -0.989650f, -0.989663f, -0.989677f, -0.989691f, -0.989704f, -0.989718f,
	-0.989732f, -0.989746f, -0.989759f, -0.989773f, -0.989787f, -0.989800f, -0.989814f, -0.989828f,
	-0.989841f, -0.989855f, -0.989869f, -0.989882f, -0.989896f, -0.989909f, -0.989923f, -0.989936f,
	-0.989950f, -0.989964f, -0.989977f, -0.989991f, -0.990004f, -0.990018f, -0.990031f, -0.990045f,
	-0.990058f, -0.990072f, -0.990085f, -0.990099f, -0.990112f, -0.990126f, -0.990139f, -0.990152f,
	-0.990166f, -0.990179f, -0.990193f, -0.990206f, -0.990219f, -0.990233f, -0.990246f, -0.990259f,
	-0.990273f, -0.990286f, -0.990299f, -0.990313f, -0.990326f, -0.990339f, -0.990353f, -0.990366f,
	-0.990379f, -0.990393f, -0.990406f, -0.990419f, -0.990432f, -0.990445f, -0.990459f, -0.990472f,
	-0.990485f, -0.990498f, -0.990511f, -0.990525f, -0.990538f, -0.990551f, -0.990564f, -0.990577f,
	-0.990590f, -0.990603f, -0.990617f, -0.990630f, -0.990643f, -0.990656f, -0.990669f, -0.990682f,
	-0.990695f, -0.990708f, -0.990721f, -0.990734f, -0.990747f, -0.990760f, -0.990773f, -0.990786f,
	-0.990799f, -0.990812f, -0.990825f, -0.990838f, -0.990851f, -0.990864f, -0.990877f, -0.990890f,
	-0.990903f, -0.990916f, -0.990928f, -0.990941f, -0.990954f, -0.990967f, -0.990980f, -0.990993f,
	-0.991006f, -0.991018f, -0.991031f, -0.991044f, -0.991057f, -0.991070f, -0.991082f, -0.991095f,
	-0.991108f, -0.991121f, -0.991133f, -0.991146f, -0.991159f, -0.991172f, -0.991184f, -0.991197f,
	-0.991210f, -0.991222f, -0.991235f, -0.991248f, -0.991260f, -0.991273f, -0.991286f, -0.991298f,
	-0.991311f, -0.991323f, -0.991336f, -0.991349f, -0.991361f, -0.991374f, -0.991386f, -0.991399f,
	-0.991411f, -0.991424f, -0.991437f, -0.991449f, -0.991462f, -0.991474f, -0.991487f, -0.991499f,
	-0.991511f, -0.991524f, -0.991536f, -0.991549f, -0.991561f, -0.991574f, -0.991586f, -0.991598f,
	-0.991611f, -0.991623f, -0.991636f, -0.991648f, -0.991660f, -0.991673f, -0.991685f, -0.991697f,
	-0.991710f, -0.991722f, -0.991734f, -0.991747f, -0.991759f, -0.991771f, -0.991783f, -0.991796f,
	-0.991808f, -0.991820f, -0.991832f, -0.991845f, -0.991857f, -0.991869f, -0.991881f, -0.991894f,
	-0.991906f, -0.991918f, -0.991930f, -0.991942f, -0.991954f, -0.991966f, -0.991979f, -0.991991f,
	-0.992003f, -0.992015f, -0.992027f, -0.992039f, -0.992051f, -0.992063f, -0.992075f, -0.992087f,
	-0.992099f, -0.992111f, -0.992123f, -0.992135f, -0.992147f, -0.992159f, -0.992171f, -0.992183f,
	-0.992195f, -0.992207f, -0.992219f, -0.992231f, -0.992243f, -0.992255f, -0.992267f, -0.992279f,
	-0.992291f, -0.992302f, -0.992314f, -0.992326f, -0.992338f, -0.992350f, -0.992362f, -0.992374f,
	-0.992385f, -0.992397f, -0.992409f, -0.992421f, -0.992433f, -0.992444f, -0.992456f, -0.992468f,
	-0.992480f, -0.992491f, -0.992503f, -0.992515f, -0.992526f, -0.992538f, -0.992550f, -0.992561f,
	-0.992573f, -0.992585f, -0.992596f, -0.992608f, -0.992620f, -0.992631f, -0.992643f, -0.992655f,
	-0.992666f, -0.992678f, -0.992689f, -0.992701f, -0.992712f, -0.992724f, -0.992736f, -0.992747f,
	-0.992759f, -0.992770f, -0.992782f, -0.992793f, -0.992805f, -0.992816f, -0.992828f, -0.992839f,
	-0.992850f, -0.992862f, -0.992873f, -0.992885f, -0.992896f, -0.992908f, -0.992919f, -0.992930f,
	-0.992942f, -0.992953f, -0.992964f, -0.992976f, -0.992987f, -0.992998f, -0.993010f, -0.993021f,
	-0.993032f, -0.993044f, -0.993055f, -0.993066f, -0.993077f, -0.993089f, -0.993100f, -0.993111f,
	-0.993122f, -0.993134f, -0.993145f, -0.993156f, -0.993167f, -0.993178f, -0.993190f, -0.993201f,
	-0.993212f, -0.993223f, -0.993234f, -0.993245f, -0.993257f, -0.993268f, -0.993279f, -0.993290f,
	-0.993301f, -0.993312f, -0.993323f, -0.993334f, -0.993345f, -0.993356f, -0.993367f, -0.993378f,
	-0.993389f, -0.993400f, -0.993411f, -0.993422f, -0.993433f, -0.993444f, -0.993455f, -0.993466f,
	-0.993477f, -0.993488f, -0.993499f, -0.993510f, -0.993521f, -0.993532f, -0.993542f, -0.993553f,
	-0.993564f, -0.993575f, -0.993586f, -0.993597f, -0.993608f, -0.993618f, -0.993629f, -0.993640f,
	-0.993651f, -0.993662f, -0.993672f, -0.993683f, -0.993694f, -0.993705f, -0.993715f, -0.993726f,
	-0.993737f, -0.993747f, -0.993758f, -0.993769f, -0.993779f, -0.993790f, -0.993801f, -0.993811f,
	-0.993822f, -0.993833f, -0.993843f, -0.993854f, -0.993865f, -0.993875f, -0.993886f, -0.993896f,
	-0.993907f, -0.993918f, -0.993928f, -0.993939f, -0.993949f, -0.993960f, -0.993970f, -0.993981f,
	-0.993991f, -0.994002f, -0.994012f, -0.994023f, -0.994033f, -0.994044f, -0.994054f, -0.994064f,
	-0.994075f, -0.994085f, -0.994096f, -0.994106f, -0.994116f, -0.994127f, -0.994137f, -0.994148f,
	-0.994158f, -0.994168f, -0.994179f, -0.994189f, -0.994199f, -0.994210f, -0.994220f, -0.994230f,
	-0.994240f, -0.994251f, -0.994261f, -0.994271f, -0.994281f, -0.994292f, -0.994302f, -0.994312f,
	-0.994322f, -0.994333f, -0.994343f, -0.994353f, -0.994363f, -0.994373f, -0.994383f, -0.994394f,
	-0.994404f, -0.994414f, -0.994424f, -0.994434f, -0.994444f, -0.994454f, -0.994464f, -0.994474f,
	-0.994484f, -0.994494f, -0.994505f, -0.994515f, -0.994525f, -0.994535f, -0.994545f, -0.994555f,
	-0.994565f, -0.994575f, -0.994585f, -0.994594f, -0.994604f, -0.994614f, -0.994624f, -0.994634f,
	-0.994644f, -0.994654f, -0.994664f, -0.994674f, -0.994684f, -0.994694f, -0.994703f, -0.994713f,
	-0.994723f, -0.994733f, -0.994743f, -0.994753f, -0.994762f, -0.994772f, -0.994782f, -0.994792f,
	-0.994802f, -0.994811f, -0.994821f, -0.994831f, -0.994841f, -0.994850f, -0.994860f, -0.994870f,
	-0.994879f, -0.994889f, -0.994899f, -0.994908f, -0.994918f, -0.994928f, -0.994937f, -0.994947f,
	-0.994957f, -0.994966f, -0.994976f, -0.994985f, -0.994995f, -0.995005f, -0.995014f, -0.995024f,
	-0.995033f, -0.995043f, -0.995052f, -0.995062f, -0.995071f, -0.995081f, -0.995090f, -0.995100f,
	-0.995109f, -0.995119f, -0.995128f, -0.995138f, -0.995147f, -0.995156f, -0.995166f, -0.995175f,
	-0.995185f, -0.995194f, -0.995203f, -0.995213f, -0.995222f, -0.995232f, -0.995241f, -0.995250f,
	-0.995260f, -0.995269f, -0.995278f, -0.995288f, -0.995297f, -0.995306f, -0.995315f, -0.995325f,
	-0.995334f, -0.995343f, -0.995352f, -0.995362f, -0.995371f, -0.995380f, -0.995389f, -0.995398f,
	-0.995408f, -0.995417f, -0.995426f, -0.995435f, -0.995444f, -0.995453f, -0.995463f, -0.995472f,
	-0.995481f, -0.995490f, -0.995499f, -0.995508f, -0.995517f, -0.995526f, -0.995535f, -0.995544f,
	-0.995553f, -0.995562f, -0.995571f, -0.995580f, -0.995589f, -0.995598f, -0.995607f, -0.995616f,
	-0.995625f, -0.995634f, -0.995643f, -0.995652f, -0.995661f, -0.995670f, -0.995679f, -0.995688f,
	-0.995697f, -0.995705f, -0.995714f, -0.995723f, -0.995732f, -0.995741f, -0.995750f, -0.995759f,
	-0.995767f, -0.995776f, -0.995785f, -0.995794f, -0.995803f, -0.995811f, -0.995820f, -0.995829f,
	-0.995838f, -0.995846f, -0.995855f, -0.995864f, -0.995872f, -0.995881f, -0.995890f, -0.995899f,
	-0.995907f, -0.995916f, -0.995925f, -0.995933f, -0.995942f, -0.995950f, -0.995959f, -0.995968f,
	-0.995976f, -0.995985f, -0.995993f, -0.996002f, -0.996011f, -0.996019f, -0.996028f, -0.996036f,
	-0.996045f, -0.996053f, -0.996062f, -0.996070f, -0.996079f, -0.996087f, -0.996096f, -0.996104f,
	-0.996113f, -0.996121f, -0.996129f, -0.996138f, -0.996146f, -0.996155f, -0.996163f, -0.996171f,
	-0.996180f, -0.996188f, -0.996197f, -0.996205f, -0.996213f, -0.996222f, -0.996230f, -0.996238f,
	-0.996247f, -0.996255f, -0.996263f, -0.996271f, -0.996280f, -0.996288f, -0.996296f, -0.996304f,
	-0.996313f, -0.996321f, -0.996329f, -0.996337f, -0.996345f, -0.996354f, -0.996362f, -0.996370f,
	-0.996378f, -0.996386f, -0.996394f, -0.996403f, -0.996411f, -0.996419f, -0.996427f, -0.996435f,
	-0.996443f, -0.996451f, -0.996459f, -0.996467f, -0.996475f, -0.996483f, -0.996491f, -0.996499f,
	-0.996507f, -0.996515f, -0.996523f, -0.996531f, -0.996539f, -0.996547f, -0.996555f, -0.996563f,
	-0.996571f, -0.996579f, -0.996587f, -0.996595f, -0.996603f, -0.996611f, -0.996619f, -0.996626f,
	-0.996634f, -0.996642f, -0.996650f, -0.996658f, -0.996666f, -0.996674f, -0.996681f, -0.996689f,
	-0.996697f, -0.996705f, -0.996712f, -0.996720f, -0.996728f, -0.996736f, -0.996743f, -0.996751f,
	-0.996759f, -0.996767f, -0.996774f, -0.996782f, -0.996790f, -0.996797f, -0.996805f, -0.996813f,
	-0.996820f, -0.996828f, -0.996836f, -0.996843f, -0.996851f, -0.996858f, -0.996866f, -0.996874f,
	-0.996881f, -0.996889f, -0.996896f, -0.996904f, -0.996911f, -0.996919f, -0.996926f, -0.996934f,
	-0.996941f, -0.996949f, -0.996956f, -0.996964f, -0.996971f, -0.996979f, -0.996986f, -0.996994f,
	-0.997001f, -0.997008f, -0.997016f, -0.997023f, -0.997031f, -0.997038f, -0.997045f, -0.997053f,
	-0.997060f, -0.997067f, -0.997075f, -0.997082f, -0.997089f, -0.997097f, -0.997104f, -0.997111f,
	-0.997119f, -0.997126f, -0.997133f, -0.997140f, -0.997148f, -0.997155f, -0.997162f, -0.997169f,
	-0.997176f, -0.997184f, -0.997191f, -0.997198f, -0.997205f, -0.997212f, -0.997219f, -0.997227f,
	-0.997234f, -0.997241f, -0.997248f, -0.997255f, -0.997262f, -0.997269f, -0.997276f, -0.997283f,
	-0.997290f, -0.997298f, -0.997305f, -0.997312f, -0.997319f, -0.997326f, -0.997333f, -0.997340f,
	-0.997347f, -0.997354f, -0.997361f, -0.997368f, -0.997374f, -0.997381f, -0.997388f, -0.997395f,
	-0.997402f, -0.997409f, -0.997416f, -0.997423f, -0.997430f, -0.997437f, -0.997443f, -0.997450f,
	-0.997457f, -0.997464f, -0.997471f, -0.997478f, -0.997484f, -0.997491f, -0.997498f, -0.997505f,
	-0.997511f, -0.997518f, -0.997525f, -0.997532f, -0.997538f, -0.997545f, -0.997552f, -0.997559f,
	-0.997565f, -0.997572f, -0.997579f, -0.997585f, -0.997592f, -0.997599f, -0.997605f, -0.997612f,
	-0.997618f, -0.997625f, -0.997632f, -0.997638f, -0.997645f, -0.997651f, -0.997658f, -0.997665f,
	-0.997671f, -0.997678f, -0.997684f, -0.997691f, -0.997697f, -0.997704f, -0.997710f, -0.997717f,
	-0.997723f, -0.997730f, -0.997736f, -0.997742f, -0.997749f, -0.997755f, -0.997762f, -0.997768f,
	-0.997774f, -0.997781f, -0.997787f, -0.997794f, -0.997800f, -0.997806f, -0.997813f, -0.997819f,
	-0.997825f, -0.997832f, -0.997838f, -0.997844f, -0.997851f, -0.997857f, -0.997863f, -0.997869f,
	-0.997876f, -0.997882f, -0.997888f, -0.997894f, -0.997901f, -0.997907f, -0.997913f, -0.997919f,
	-0.997925f, -0.997931f, -0.997938f, -0.997944f, -0.997950f, -0.997956f, -0.997962f, -0.997968f,
	-0.997974f, -0.997980f, -0.997987f, -0.997993f, -0.997999f, -0.998005f, -0.998011f, -0.998017f,
	-0.998023f, -0.998029f, -0.998035f, -0.998041f, -0.998047f, -0.998053f, -0.998059f, -0.998065f,
	-0.998071f, -0.998077f, -0.998083f, -0.998089f, -0.998094f, -0.998100f, -0.998106f, -0.998112f,
	-0.998118f, -0.998124f, -0.998130f, -0.998136f, -0.998142f, -0.998147f, -0.998153f, -0.998159f,
	-0.998165f, -0.998171f, -0.998176f, -0.998182f, -0.998188f, -0.998194f, -0.998200f, -0.998205f,
	-0.998211f, -0.998217f, -0.998222f, -0.998228f, -0.998234f, -0.998240f, -0.998245f, -0.998251f,
	-0.998257f, -0.998262f, -0.998268f, -0.998273f, -0.998279f, -0.998285f, -0.998290f, -0.998296f,
	-0.998302f, -0.998307f, -0.998313f, -0.998318f, -0.998324f, -0.998329f, -0.998335f, -0.998340f,
	-0.998346f, -0.998351f, -0.998357f, -0.998362f, -0.998368f, -0.998373f, -0.998379f, -0.998384f,
	-0.998390f, -0.998395f, -0.998401f, -0.998406f, -0.998411f, -0.998417f, -0.998422f, -0.998428f,
	-0.998433f, -0.998438f, -0.998444f, -0.998449f, -0.998454f, -0.998460f, -0.998465f, -0.998470f,
	-0.998476f, -0.998481f, -0.998486f, -0.998491f, -0.998497f, -0.998502f, -0.998507f, -0.998512f,
	-0.998518f, -0.998523f, -0.998528f, -0.998533f, -0.998538f, -0.998544f, -0.998549f, -0.998554f,
	-0.998559f, -0.998564f, -0.998569f, -0.998574f, -0.998580f, -0.998585f, -0.998590f, -0.998595f,
	-0.998600f, -0.998605f, -0.998610f, -0.998615f, -0.998620f, -0.998625f, -0.998630f, -0.998635f,
	-0.998640f, -0.998645f, -0.998650f, -0.998655f, -0.998660f, -0.998665f, -0.998670f, -0.998675f,
	-0.998680f, -0.998685f, -0.998690f, -0.998695f, -0.998700f, -0.998704f, -0.998709f, -0.998714f,
	-0.998719f, -0.998724f, -0.998729f, -0.998734f, -0.998738f, -0.998743f, -0.998748f, -0.998753f,
	-0.998758f, -0.998762f, -0.998767f, -0.998772f, -0.998777f, -0.998781f, -0.998786f, -0.998791f,
	-0.998795f, -0.998800f, -0.998805f, -0.998810f, -0.998814f, -0.998819f, -0.998824f, -0.998828f,
	-0.998833f, -0.998837f, -0.998842f, -0.998847f, -0.998851f, -0.998856f, -0.998860f, -0.998865f,
	-0.998870f, -0.998874f, -0.998879f, -0.998883f, -0.998888f, -0.998892f, -0.998897f, -0.998901f,
	-0.998906f, -0.998910f, -0.998915f, -0.998919f, -0.998924f, -0.998928f, -0.998932f, -0.998937f,
	-0.998941f, -0.998946f, -0.998950f, -0.998954f, -0.998959f, -0.998963f, -0.998968f, -0.998972f,
	-0.998976f, -0.998981f, -0.998985f, -0.998989f, -0.998994f, -0.998998f, -0.999002f, -0.999006f,
	-0.999011f, -0.999015f, -0.999019f, -0.999023f, -0.999028f, -0.999032f, -0.999036f, -0.999040f,
	-0.999044f, -0.999049f, -0.999053f, -0.999057f, -0.999061f, -0.999065f, -0.999069f, -0.999074f,
	-0.999078f, -0.999082f, -0.999086f, -0.999090f, -0.999094f, -0.999098f, -0.999102f, -0.999106f,
	-0.999110f, -0.999114f, -0.999118f, -0.999122f, -0.999126f, -0.999130f, -0.999134f, -0.999138f,
	-0.999142f, -0.999146f, -0.999150f, -0.999154f, -0.999158f, -0.999162f, -0.999166f, -0.999170f,
	-0.999174f, -0.999178f, -0.999182f, -0.999186f, -0.999189f, -0.999193f, -0.999197f, -0.999201f,
	-0.999205f, -0.999209f, -0.999212f, -0.999216f, -0.999220f, -0.999224f, -0.999228f, -0.999231f,
	-0.999235f, -0.999239f, -0.999243f, -0.999246f, -0.999250f, -0.999254f, -0.999257f, -0.999261f,
	-0.999265f, -0.999268f, -0.999272f, -0.999276f, -0.999279f, -0.999283f, -0.999287f, -0.999290f,
	-0.999294f, -0.999297f, -0.999301f, -0.999305f, -0.999308f, -0.999312f, -0.999315f, -0.999319f,
	-0.999322f, -0.999326f, -0.999329f, -0.999333f, -0.999336f, -0.999340f, -0.999343f, -0.999347f,
	-0.999350f, -0.999354f, -0.999357f, -0.999361f, -0.999364f, -0.999367f, -0.999371f, -0.999374f,
	-0.999378f, -0.999381f, -0.999384f, -0.999388f, -0.999391f, -0.999394f, -0.999398f, -0.999401f,
	-0.999404f, -0.999408f, -0.999411f, -0.999414f, -0.999418f, -0.999421f, -0.999424f, -0.999427f,
	-0.999431f, -0.999434f, -0.999437f, -0.999440f, -0.999443f, -0.999447f, -0.999450f, -0.999453f,
	-0.999456f, -0.999459f, -0.999462f, -0.999466f, -0.999469f, -0.999472f, -0.999475f, -0.999478f,
	-0.999481f, -0.999484f, -0.999487f, -0.999490f, -0.999493f, -0.999497f, -0.999500f, -0.999503f,
	-0.999506f, -0.999509f, -0.999512f, -0.999515f, -0.999518f, -0.999521f, -0.999524f, -0.999527f,
	-0.999529f, -0.999532f, -0.999535f, -0.999538f, -0.999541f, -0.999544f, -0.999547f, -0.999550f,
	-0.999553f, -0.999556f, -0.999558f, -0.999561f, -0.999564f, -0.999567f, -0.999570f, -0.999573f,
	-0.999575f, -0.999578f, -0.999581f, -0.999584f, -0.999586f, -0.999589f, -0.999592f, -0.999595f,
	-0.999597f, -0.999600f, -0.999603f, -0.999605f, -0.999608f, -0.999611f, -0.999614f, -0.999616f,
	-0.999619f, -0.999621f, -0.999624f, -0.999627f, -0.999629f, -0.999632f, -0.999635f, -0.999637f,
	-0.999640f, -0.999642f, -0.999645f, -0.999647f, -0.999650f, -0.999652f, -0.999655f, -0.999658f,
	-0.999660f, -0.999663f, -0.999665f, -0.999667f, -0.999670f, -0.999672f, -0.999675f, -0.999677f,
	-0.999680f, -0.999682f, -0.999685f, -0.999687f, -0.999689f, -0.999692f, -0.999694f, -0.999696f,
	-0.999699f, -0.999701f, -0.999704f, -0.999706f, -0.999708f, -0.999710f, -0.999713f, -0.999715f,
	-0.999717f, -0.999720f, -0.999722f, -0.999724f, -0.999726f, -0.999729f, -0.999731f, -0.999733f,
	-0.999735f, -0.999738f, -0.999740f, -0.999742f, -0.999744f, -0.999746f, -0.999748f, -0.999750f,
	-0.999753f, -0.999755f, -0.999757f, -0.999759f, -0.999761f, -0.999763f, -0.999765f, -0.999767f,
	-0.999769f, -0.999771f, -0.999774f, -0.999776f, -0.999778f, -0.999780f, -0.999782f, -0.999784f,
	-0.999786f, -0.999788f, -0.999790f, -0.999792f, -0.999793f, -0.999795f, -0.999797f, -0.999799f,
	-0.999801f, -0.999803f, -0.999805f, -0.999807f, -0.999809f, -0.999811f, -0.999812f, -0.999814f,
	-0.999816f, -0.999818f, -0.999820f, -0.999822f, -0.999823f, -0.999825f, -0.999827f, -0.999829f,
	-0.999831f, -0.999832f, -0.999834f, -0.999836f, -0.999838f, -0.999839f, -0.999841f, -0.999843f,
	-0.999844f, -0.999846f, -0.999848f, -0.999849f, -0.999851f, -0.999853f, -0.999854f, -0.999856f,
	-0.999858f, -0.999859f, -0.999861f, -0.999862f, -0.999864f, -0.999866f, -0.999867f, -0.999869f,
	-0.999870f, -0.999872f, -0.999873f, -0.999875f, -0.999876f, -0.999878f, -0.999879f, -0.999881f,
	-0.999882f, -0.999884f, -0.999885f, -0.999887f, -0.999888f, -0.999890f, -0.999891f, -0.999892f,
	-0.999894f, -0.999895f, -0.999897f, -0.999898f, -0.999899f, -0.999901f, -0.999902f, -0.999903f,
	-0.999905f, -0.999906f, -0.999907f, -0.999909f, -0.999910f, -0.999911f, -0.999913f, -0.999914f,
	-0.999915f, -0.999916f, -0.999917f, -0.999919f, -0.999920f, -0.999921f, -0.999922f, -0.999924f,
	-0.999925f, -0.999926f, -0.999927f, -0.999928f, -0.999929f, -0.999930f, -0.999932f, -0.999933f,
	-0.999934f, -0.999935f, -0.999936f, -0.999937f, -0.999938f, -0.999939f, -0.999940f, -0.999941f,
	-0.999942f, -0.999943f, -0.999944f, -0.999945f, -0.999946f, -0.999947f, -0.999948f, -0.999949f,
	-0.999950f, -0.999951f, -0.999952f, -0.999953f, -0.999954f, -0.999955f, -0.999956f, -0.999957f,
	-0.999958f, -0.999959f, -0.999959f, -0.999960f, -0.999961f, -0.999962f, -0.999963f, -0.999964f,
	-0.999964f, -0.999965f, -0.999966f, -0.999967f, -0.999968f, -0.999968f, -0.999969f, -0.999970f,
	-0.999971f, -0.999971f, -0.999972f, -0.999973f, -0.999973f, -0.999974f, -0.999975f, -0.999976f,
	-0.999976f, -0.999977f, -0.999977f, -0.999978f, -0.999979f, -0.999979f, -0.999980f, -0.999981f,
	-0.999981f, -0.999982f, -0.999982f, -0.999983f, -0.999983f, -0.999984f, -0.999985f, -0.999985f,
	-0.999986f, -0.999986f, -0.999987f, -0.999987f, -0.999988f, -0.999988f, -0.999988f, -0.999989f,
	-0.999989f, -0.999990f, -0.999990f, -0.999991f, -0.999991f, -0.999991f, -0.999992f, -0.999992f,
	-0.999993f, -0.999993f, -0.999993f, -0.999994f, -0.999994f, -0.999994f, -0.999995f, -0.999995f,
	-0.999995f, -0.999996f, -0.999996f, -0.999996f, -0.999996f, -0.999997f, -0.999997f, -0.999997f,
	-0.999997f, -0.999998f, -0.999998f, -0.999998f, -0.999998f, -0.999998f, -0.999999f, -0.999999f,
	-0.999999f, -0.999999f, -0.999999f, -0.999999f, -0.999999f, -0.999999f, -1.000000f, -1.000000f,
	-1.000000f, -1.000000f, -1.000000f, -1.000000f, -1.000000f, -1.000000f, -1.000000f, -1.000000f
};

static const float * const sinTables[17] = {
	0           , 0           , 0            , 0            ,
	sinTable16  , sinTable32  , sinTable64   , sinTable128  ,
	sinTable256 , sinTable512 , sinTable1024 , sinTable2048 ,
	sinTable4096, sinTable8192, sinTable16384, sinTable32768,
	sinTable65536
};

const float *getSineTable(int bits) {
	assert((bits >= 4) && (bits <= 16));

	return sinTables[bits];
}

} // End of namespace Common
