/* xoreos - A reimplementation of BioWare's Aurora engine
 *
 * xoreos is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  An NWScript engine type.
 */

#ifndef AURORA_NWSCRIPT_ENGINETYPE_H
#define AURORA_NWSCRIPT_ENGINETYPE_H

namespace Aurora {

namespace NWScript {

class EngineType {
public:
	EngineType() = default;
	EngineType(const EngineType &) = default;
	virtual ~EngineType() = default;

	/** Clone factory method. */
	virtual EngineType *clone() const = 0;
};

} // End of namespace NWScript

} // End of namespace Aurora

#endif // AURORA_NWSCRIPT_ENGINETYPE_H
