/*++

Copyright (c) 1997-2008 Microsoft Corporation

Module Name:

    VNDRLIST.H

Abstract:

    This header file contains a list of all currently known USB Vendor IDs
    and the vendor name associated with each Vendor ID.

Source:

    http://www.usb.org

Environment:

    Kernel & user mode

Revision History:

    04-25-97 : created
    03-28-03 : refreshed with latest list from usb.org
    05-04-05 : refreshed with latest list from usb.org
    05-02-07 : refreshed with latest list from usb.org
    03-19-08 : refreshed with latest list from usb.org

--*/

#ifndef   __VNDRLIST_H__
#define   __VNDRLIST_H__

//
// Vendor ID structure
//
typedef struct _VENDOR_ID {
    USHORT  usVendorID;
    PCHAR   szVendor;
} VENDOR_ID, *PVENDOR_ID;

//
// This list built from information obtained from
// http://www.usb.org/developers/tools/
//
// This information has not been independently verified and no claims
// are made here as to its accuracy.
//
// 10978 total
//
VENDOR_ID USBVendorIDs[] =
{
    { 0x0079, "Shenzhen Longshengwei Technology, Co., Ltd."  },
    { 0x013A, "Aimgene Technology Co., Ltd"  },
    { 0x03CC, "GN OTOMETRICS"  },
    { 0x03E8, "EndPoints Inc."  },
    { 0x03E9, "Thesys Microelectronics"  },
    { 0x03EA, "Data Broadcasting Corp."  },
    { 0x03EB, "Atmel Corporation"  },
    { 0x03EC, "Iwatsu America Inc."  },
    { 0x03ED, "Mitel Corporation"  },
    { 0x03EE, "Mitsumi"  },
    { 0x03F0, "HP Inc."  },
    { 0x03F1, "Genoa Technology"  },
    { 0x03F2, "Oak Technology, Inc"  },
    { 0x03F3, "Adaptec, Inc."  },
    { 0x03F4, "Diebold, Inc."  },
    { 0x03F5, "Siemens Electromechanical"  },
    { 0x03F7, "Tulip Computers International"  },
    { 0x03F8, "Epson Imaging Technology Center"  },
    { 0x03F9, "KeyTronic Corp."  },
    { 0x03FB, "OPTi Inc."  },
    { 0x03FC, "Elitegroup Computer Systems"  },
    { 0x03FD, "Xilinx Inc."  },
    { 0x03FE, "Farallon Comunications"  },
    { 0x03FF, "Weitek Corporation"  },
    { 0x0400, "National Semiconductor"  },
    { 0x0401, "National Registry Inc."  },
    { 0x0402, "ALi Corporation"  },
    { 0x0403, "Future Technology Devices International Limited"  },
    { 0x0404, "NCR Corporation"  },
    { 0x0405, "inSilicon"  },
    { 0x0406, "Fujitsu-ICL Computers"  },
    { 0x0407, "Fujitsu Personal Systems, Inc."  },
    { 0x0408, "Quanta Computer Inc."  },
    { 0x0409, "NEC Corporation"  },
    { 0x040A, "Eastman Kodak Company"  },
    { 0x040B, "Weltrend Semiconductor"  },
    { 0x040C, "VTech Computers Ltd"  },
    { 0x040D, "VIA Technologies, Inc."  },
    { 0x040E, "MCCI Corporation"  },
    { 0x040F, "Echo Speech Corporation"  },
    { 0x0410, "Isis Distributed Systems, Inc."  },
    { 0x0411, "BUFFALO INC."  },
    { 0x0412, "Award Software International"  },
    { 0x0413, "Leadtek Research Inc."  },
    { 0x0414, "Giga-Byte Technology Co., Ltd."  },
    { 0x0416, "Nuvoton Technology Corp."  },
    { 0x0417, "Symbios, Inc."  },
    { 0x0418, "AST Research"  },
    { 0x0419, "Samsung Info. Systems America Inc."  },
    { 0x041A, "Phoenix Technologies Ltd."  },
    { 0x041B, "d'TV"  },
    { 0x041D, "S3 Incorporated"  },
    { 0x041E, "Creative Labs"  },
    { 0x041F, "LCS Telegraphics"  },
    { 0x0420, "Chips and Technologies"  },
    { 0x0421, "Nokia Corporation"  },
    { 0x0422, "ADI Systems Inc."  },
    { 0x0423, "CATC"  },
    { 0x0424, "Microchip-SMSC"  },
    { 0x0425, "Freescale Semiconductor Hong Kong Limited"  },
    { 0x0426, "Integrated Device Technology"  },
    { 0x0427, "Motorola Electronics Taiwan Ltd."  },
    { 0x0428, "Advanced Gravis Computer Ltd."  },
    { 0x0429, "Cirrus Logic Inc."  },
    { 0x042A, "Ericsson Austrian, AG"  },
    { 0x042C, "Innovative Semiconductors, Inc."  },
    { 0x042D, "Micronics"  },
    { 0x042E, "Acer, Inc.(2)"  },
    { 0x042F, "Molex Inc."  },
    { 0x0430, "Fujitsu Component Limited"  },
    { 0x0431, "ITAC Systems, Inc."  },
    { 0x0432, "Unisys Corp."  },
    { 0x0433, "Alps Electric Inc."  },
    { 0x0434, "Samsung Info. Systems America Inc.(2)"  },
    { 0x0435, "Hyundai Electronics America"  },
    { 0x0436, "Taugagreining HF"  },
    { 0x0437, "Framatome Connectors USA"  },
    { 0x0438, "Advanced Micro Devices"  },
    { 0x0439, "Voice Technologies Group"  },
    { 0x043C, "Lucid Designs"  },
    { 0x043D, "Lexmark International Inc."  },
    { 0x043E, "LG Electronics USA Inc."  },
    { 0x043F, "RadiSys Corporation"  },
    { 0x0440, "EIZO NANAO CORPORATION"  },
    { 0x0441, "Winbond Systems Lab."  },
    { 0x0442, "Cygnion Corp."  },
    { 0x0443, "Gateway 2000"  },
    { 0x0445, "Agere Systems"  },
    { 0x0446, "NMB Technologies Corporation"  },
    { 0x0447, "Momentum Microsystems"  },
    { 0x0449, "Eldim"  },
    { 0x044A, "Shamrock Technology Co., Ltd."  },
    { 0x044B, "WSI"  },
    { 0x044C, "CCL/ITRI"  },
    { 0x044D, "Siemens Nixdorf AG"  },
    { 0x044E, "Alps Electric Co., Ltd."  },
    { 0x044F, "ThrustMaster, Inc."  },
    { 0x0450, "DFI Inc."  },
    { 0x0451, "Texas Instruments"  },
    { 0x0452, "Mitsubishi Electric & Electronics US, Inc."  },
    { 0x0453, "CMD Technology"  },
    { 0x0454, "Vobis Microcomputer AGO"  },
    { 0x0455, "Telematics International, Inc."  },
    { 0x0456, "Analog Devices, Inc."  },
    { 0x0457, "Silicon Integrated Systems Corp."  },
    { 0x0458, "KYE Systems Corp."  },
    { 0x0459, "Adobe Systems, Inc."  },
    { 0x045A, "SONICblue Incorporated"  },
    { 0x045B, "Renesas Electronics Corp."  },
    { 0x045D, "Nortel Networks"  },
    { 0x045E, "Microsoft Corporation"  },
    { 0x0460, "Ace Cad Enterprise Co., Ltd."  },
    { 0x0461, "Primax Electronics"  },
    { 0x0463, "EATON"  },
    { 0x0464, "AMP/Tycoelectronics"  },
    { 0x0465, "Pacific Micro Computing"  },
    { 0x0467, "AT&T Paradyne"  },
    { 0x0468, "Wieson Technologies Co., Ltd."  },
    { 0x046A, "CHERRY"  },
    { 0x046B, "American Megatrends"  },
    { 0x046C, "Toshiba Corporation, Digital Media Network Company"  },
    { 0x046D, "Logitech Inc."  },
    { 0x046E, "Behavior Tech Computer Corporation"  },
    { 0x046F, "Crystal Semiconductor"  },
    { 0x0471, "Philips Consumer Lifestyle BV"  },
    { 0x0472, "Oracle"  },
    { 0x0473, "Sanyo Information Business Co., Ltd."  },
    { 0x0474, "Sanyo Electric Co. Ltd."  },
    { 0x0475, "TECO Electric & Machinery Co., Ltd."  },
    { 0x0476, "AESP"  },
    { 0x0477, "Seagate Technology"  },
    { 0x0478, "Connectix Corp."  },
    { 0x0479, "Advanced Peripheral Laboratories"  },
    { 0x047A, "Semtech Corporation"  },
    { 0x047B, "Silitek Corp."  },
    { 0x047D, "Kensington"  },
    { 0x047E, "Avago Technologies Inc."  },
    { 0x047F, "Plantronics, Inc."  },
    { 0x0480, "Toshiba America Info. Systems, Inc."  },
    { 0x0481, "Zenith Data Systems"  },
    { 0x0482, "Kyocera Corporation"  },
    { 0x0483, "STMicroelectronics"  },
    { 0x0484, "Specialix"  },
    { 0x0485, "Nokia Monitors"  },
    { 0x0486, "ASUS Computers Inc."  },
    { 0x0487, "Stewart Connector"  },
    { 0x0488, "Cirque Corporation"  },
    { 0x0489, "Foxconn - Hon Hai"  },
    { 0x048A, "S-MOS Systems, Inc."  },
    { 0x048C, "Alps Electric Ireland Ltd."  },
    { 0x048D, "ITE Tech Inc."  },
    { 0x048F, "Eicon Tech."  },
    { 0x0490, "United Microelectronic Corporation (UMC)"  },
    { 0x0491, "Capetronic Kaohsiung Corp."  },
    { 0x0492, "Samsung Semiconductor, Inc."  },
    { 0x0493, "MAG Technology Co., Ltd."  },
    { 0x0495, "ESS Technology, Inc."  },
    { 0x0496, "Micron Electronics"  },
    { 0x0497, "Smile International, Inc."  },
    { 0x0498, "Capetronic (Kaohsiung) Corp."  },
    { 0x0499, "Yamaha Corporation"  },
    { 0x049A, "Gandalf Technologies Ltd."  },
    { 0x049B, "Curtis Computer Products"  },
    { 0x049C, "Acer Advanced Labs, Inc."  },
    { 0x049D, "VLSI Technology, Inc."  },
    { 0x049F, "Compaq Computer Corporation"  },
    { 0x04A0, "Digital Equipment Corp."  },
    { 0x04A1, "SystemSoft Corporation"  },
    { 0x04A2, "FirePower Systems"  },
    { 0x04A3, "Trident Microsystems Inc."  },
    { 0x04A4, "Hitachi, Ltd."  },
    { 0x04A5, "BenQ Corporation"  },
    { 0x04A6, "Nokia Display Products"  },
    { 0x04A7, "Visioneer"  },
    { 0x04A8, "Multivideo Labs, Inc."  },
    { 0x04A9, "Canon Inc."  },
    { 0x04AA, "Daewoo Teletech Co., Ltd."  },
    { 0x04AB, "Chromatic Research"  },
    { 0x04AC, "Micro Audiometrics Corp."  },
    { 0x04AD, "Dooin Electronics"  },
    { 0x04AE, "Brooktree Corporation"  },
    { 0x04AF, "Winnov L.P."  },
    { 0x04B0, "Nikon Corporation"  },
    { 0x04B1, "Pan International"  },
    { 0x04B3, "IBM Corporation"  },
    { 0x04B4, "Cypress Semiconductor"  },
    { 0x04B5, "ROHM Co., Ltd."  },
    { 0x04B6, "Hint Corporation"  },
    { 0x04B7, "Compal Electronics, Inc."  },
    { 0x04B8, "Seiko Epson Corp."  },
    { 0x04B9, "SafeNet, Inc."  },
    { 0x04BA, "Toucan Systems Limited"  },
    { 0x04BB, "I-O Data Device, Inc."  },
    { 0x04BC, "Digital Systems Associates"  },
    { 0x04BD, "Toshiba Electronics Taiwan Corp."  },
    { 0x04BE, "Telia Research AB"  },
    { 0x04BF, "TDK Corporation"  },
    { 0x04C2, "Methode Electronics Far East Pte Ltd."  },
    { 0x04C3, "Maxi Switch, Inc."  },
    { 0x04C4, "Lockheed Martin Energy Research"  },
    { 0x04C5, "Fujitsu Ltd."  },
    { 0x04C6, "Toshiba America Electronic Components"  },
    { 0x04C7, "Micro Macro Technologies"  },
    { 0x04C8, "Konica Corporation"  },
    { 0x04CA, "Lite-On Technology Corp."  },
    { 0x04CB, "FUJIFILM Corporation"  },
    { 0x04CC, "ST-Ericsson"  },
    { 0x04CD, "Tatung Company of America, Inc."  },
    { 0x04CE, "ScanLogic Corporation"  },
    { 0x04CF, "Myson Century, Inc."  },
    { 0x04D0, "Digi International"  },
    { 0x04D1, "ITT Cannon"  },
    { 0x04D2, "Altec Lansing Technologies, Inc."  },
    { 0x04D3, "VidUS, Inc."  },
    { 0x04D4, "LSI Logic Inc."  },
    { 0x04D5, "Forte Technologies, Inc."  },
    { 0x04D6, "Mentor Graphics"  },
    { 0x04D7, "Oki Semiconductor"  },
    { 0x04D8, "Microchip Technology Inc."  },
    { 0x04D9, "Holtek Semiconductor, Inc."  },
    { 0x04DA, "Panasonic Corporation"  },
    { 0x04DB, "Hypertec Ltd."  },
    { 0x04DC, "Huan Hsin Holdings Ltd."  },
    { 0x04DD, "Sharp Corporation"  },
    { 0x04DE, "MindShare, Inc."  },
    { 0x04DF, "ePadLink"  },
    { 0x04E1, "Iiyama Corporation"  },
    { 0x04E2, "Exar Corporation"  },
    { 0x04E3, "Zilog"  },
    { 0x04E4, "ACC Microelectronics"  },
    { 0x04E5, "Promise Technology"  },
    { 0x04E6, "Identiv, Inc."  },
    { 0x04E7, "Elo TouchSystems"  },
    { 0x04E8, "Samsung Electronics Co., Ltd."  },
    { 0x04E9, "PC-Tel, Inc."  },
    { 0x04EA, "Sipex Corporation"  },
    { 0x04EB, "Northstar Systems Corp."  },
    { 0x04EC, "Tokyo Electron Device Limited"  },
    { 0x04ED, "Annabooks"  },
    { 0x04EF, "Pacific Electronic International, Inc."  },
    { 0x04F0, "Daewoo Electronics Co., Ltd."  },
    { 0x04F1, "Victor Company of Japan, Limited"  },
    { 0x04F2, "Chicony Electronics Co., Ltd."  },
    { 0x04F3, "ELAN Microelectronics Corportation"  },
    { 0x04F4, "Harting Elektronik Inc."  },
    { 0x04F5, "Fujitsu-ICL Systems, Inc."  },
    { 0x04F6, "Norand Corporation"  },
    { 0x04F7, "Newnex Technology Corp."  },
    { 0x04F8, "FuturePlus Systems"  },
    { 0x04F9, "Brother Industries, Ltd."  },
    { 0x04FA, "Dallas Semiconductor"  },
    { 0x04FB, "Biostar Microtech Int'l Corp."  },
    { 0x04FC, "SUNPLUS TECHNOLOGY CO., LTD."  },
    { 0x04FD, "Soliton Systems K.K."  },
    { 0x04FE, "PFU Limited"  },
    { 0x04FF, "E-CMOS Corp."  },
    { 0x0500, "Siam United Hi-Tech"  },
    { 0x0501, "Fujikura/DDK"  },
    { 0x0502, "Acer, Inc."  },
    { 0x0503, "Hitachi America Ltd."  },
    { 0x0504, "Hayes Microcomputer Products"  },
    { 0x0505, "Digital Home Corporation"  },
    { 0x0506, "3Com Corporation"  },
    { 0x0507, "Hosiden Corporation"  },
    { 0x0508, "Clarion Co., Ltd."  },
    { 0x0509, "Aztech Systems Ltd"  },
    { 0x050A, "Cinch Connectors"  },
    { 0x050B, "Cable System International"  },
    { 0x050C, "InnoMedia, Inc."  },
    { 0x050D, "Belkin International, Inc."  },
    { 0x050E, "Neon Technology, Inc."  },
    { 0x050F, "KC Technology Inc."  },
    { 0x0510, "Sejin Electron Inc."  },
    { 0x0511, "N*ABLE Technologies, Inc (Data Book)"  },
    { 0x0512, "Hualon Microelectronics Corp."  },
    { 0x0513, "digital-X, Inc."  },
    { 0x0514, "FCI Electronics"  },
    { 0x0515, "ACTC"  },
    { 0x0516, "Longwell Electronics/Longwell Company"  },
    { 0x0517, "Butterfly Communications"  },
    { 0x0518, "EzKEY Corp."  },
    { 0x0519, "Star Micronics Co., LTD"  },
    { 0x051A, "WYSE Technology"  },
    { 0x051C, "Shuttle Inc."  },
    { 0x051D, "American Power Conversion"  },
    { 0x051E, "Scientific Atlanta, Inc."  },
    { 0x051F, "IO Systems Inc."  },
    { 0x0520, "Taiwan Semiconductor Manufacturing Co."  },
    { 0x0521, "Airborn Connectors"  },
    { 0x0522, "ACON, Advanced-Connectek, Inc."  },
    { 0x0523, "ATEN GMBH"  },
    { 0x0524, "Sola Electronics"  },
    { 0x0525, "PLX Technology, Inc."  },
    { 0x0526, "Temic MHS S.A."  },
    { 0x0527, "ALTRA"  },
    { 0x0528, "ATI Technologies, Inc."  },
    { 0x0529, "SafeNet Data Security (Israel) Ltd."  },
    { 0x052A, "Crescent Heart Software"  },
    { 0x052B, "Tekom Technologies, Inc"  },
    { 0x052C, "Canon Development Americas"  },
    { 0x052D, "Avid Electronics Corp."  },
    { 0x052E, "Standard Microsystems Corp. (1)"  },
    { 0x052F, "Unicore Software, Inc."  },
    { 0x0530, "American Microsystems Inc."  },
    { 0x0531, "Wacom Technology Corp."  },
    { 0x0532, "Systech Corporation"  },
    { 0x0533, "Alcatel Mobile Phones"  },
    { 0x0534, "Motorola"  },
    { 0x0535, "LIH TZU Electric Co., Ltd."  },
    { 0x0536, "Hand Held Products (Honeywell International Inc.)"  },
    { 0x0537, "Inventec Corporation"  },
    { 0x0538, "The SCO Group"  },
    { 0x0539, "Shyh Shiun Terminals Co. LTD"  },
    { 0x053A, "Preh KeyTec GmbH"  },
    { 0x053B, "Global Village Communication"  },
    { 0x053C, "Institut of Microelectronic & Mechatronic Systems"  },
    { 0x053D, "Silicon Architect"  },
    { 0x053E, "Mobility Electronics"  },
    { 0x053F, "Synopsys, Inc."  },
    { 0x0540, "UniAccess AB"  },
    { 0x0541, "Sirf Technology, Inc"  },
    { 0x0542, "MICOM Communications Corp."  },
    { 0x0543, "ViewSonic Corporation"  },
    { 0x0544, "Cristie Electronics Ltd."  },
    { 0x0545, "Veo"  },
    { 0x0546, "Polaroid Corporation"  },
    { 0x0547, "Anchor Chips Inc."  },
    { 0x0548, "Tyan Computer Corp."  },
    { 0x0549, "Pixera Corporation"  },
    { 0x054A, "Fujitsu Microelectronics, Inc."  },
    { 0x054B, "New Media Corporation"  },
    { 0x054C, "Sony Corporation"  },
    { 0x054D, "Try Corporation"  },
    { 0x054E, "Proside Corporation"  },
    { 0x054F, "WYSE Technology Taiwan"  },
    { 0x0550, "Fuji Xerox Co., Ltd."  },
    { 0x0551, "CompuTrend Systems, Inc."  },
    { 0x0552, "Philips Monitors"  },
    { 0x0553, "STMicroelectronics Imaging Division"  },
    { 0x0554, "Dictaphone Corp."  },
    { 0x0555, "ANAM S&T Co., Ltd."  },
    { 0x0556, "Asahi Kasei Microdevices Corporation"  },
    { 0x0557, "ATEN International Co. Ltd."  },
    { 0x0558, "Truevision, Inc."  },
    { 0x0559, "Cadence Design Systems, Inc."  },
    { 0x055A, "Kenwood USA"  },
    { 0x055B, "KnowledgeTek, Inc."  },
    { 0x055C, "Proton Electronic Ind."  },
    { 0x055D, "Samsung Electro-Mechanics Co."  },
    { 0x055E, "Optoma Corporation"  },
    { 0x055F, "Mustek Systems Inc."  },
    { 0x0560, "Interface Corporation"  },
    { 0x0561, "Oasis Design, Inc."  },
    { 0x0562, "Telex Communications Inc."  },
    { 0x0563, "Immersion Corporation"  },
    { 0x0564, "Kodak Digital Product Center, Japan Ltd."  },
    { 0x0565, "Peracom Networks, Inc."  },
    { 0x0566, "Monterey International Corp."  },
    { 0x0567, "Xyratex"  },
    { 0x0568, "Quartz Ingenierie"  },
    { 0x0569, "SegaSoft"  },
    { 0x056A, "WACOM Co., Ltd."  },
    { 0x056B, "Decicon Incorporated"  },
    { 0x056C, "Belkin Research & Development"  },
    { 0x056D, "EIZO Corporation"  },
    { 0x056E, "Elecom Co., Ltd."  },
    { 0x056F, "Korea Data Systems Co., Ltd."  },
    { 0x0570, "Epson America"  },
    { 0x0571, "XLR8, Inc."  },
    { 0x0572, "Conexant Systems, Inc."  },
    { 0x0573, "Zoran Corporation"  },
    { 0x0574, "City University of Hong Kong"  },
    { 0x0575, "Philips Creative Display Solutions"  },
    { 0x0576, "BAFO/Quality Computer Accessories"  },
    { 0x0577, "ELSA"  },
    { 0x0578, "Intrinsix Corp."  },
    { 0x0579, "GVC Corporation"  },
    { 0x057A, "Samsung Electronics America"  },
    { 0x057B, "Y-E Data, Inc."  },
    { 0x057C, "AVM GmbH"  },
    { 0x057D, "Shark Multimedia Inc."  },
    { 0x057E, "Nintendo Co., Ltd."  },
    { 0x057F, "QuickShot Limited"  },
    { 0x0580, "Denron Inc."  },
    { 0x0581, "Racal Data Group"  },
    { 0x0582, "Roland Corporation"  },
    { 0x0583, "Padix Co., Ltd."  },
    { 0x0584, "RATOC Systems, Inc."  },
    { 0x0585, "FlashPoint Technology, Inc."  },
    { 0x0586, "ZyXEL Communications Corp"  },
    { 0x0587, "Matsushita Kotobuki Electronics Industries America"  },
    { 0x0588, "Sapien Design"  },
    { 0x0589, "Victron"  },
    { 0x058A, "Nohau Corporation"  },
    { 0x058B, "Infineon Technologies"  },
    { 0x058C, "In Focus Systems"  },
    { 0x058D, "Micrel Semiconductor"  },
    { 0x058E, "Tripath Technology Inc."  },
    { 0x058F, "Alcor Micro, Corp."  },
    { 0x0590, "OMRON Corporation"  },
    { 0x0591, "Questra Consulting"  },
    { 0x0592, "Powerware Corporation"  },
    { 0x0593, "Incite"  },
    { 0x0594, "Princeton Graphic Systems"  },
    { 0x0595, "Zoran Microelectronics Ltd."  },
    { 0x0596, "3M Touch Systems"  },
    { 0x0597, "Trisignal Communications"  },
    { 0x0598, "Niigata Canotec Co., Inc."  },
    { 0x0599, "Brilliance Semiconductor Inc."  },
    { 0x059A, "Spectrum Signal Processing Inc."  },
    { 0x059B, "Iomega Corporation"  },
    { 0x059C, "A-Trend Technology Co., Ltd."  },
    { 0x059D, "Advanced Input Devices"  },
    { 0x059E, "Intelligent Instrumentation"  },
    { 0x059F, "LaCie"  },
    { 0x05A0, "Vetronix Corporation"  },
    { 0x05A1, "UKC Electronics Corporation"  },
    { 0x05A2, "Fuji Film Microdevices Co. Ltd."  },
    { 0x05A3, "TransDimension-NH LLC"  },
    { 0x05A4, "Ortek Technology, Inc."  },
    { 0x05A5, "Sampo Technology Corp."  },
    { 0x05A6, "Cisco Systems, Inc."  },
    { 0x05A7, "Bose Corporation"  },
    { 0x05A8, "Spacetec IMC Corporation"  },
    { 0x05A9, "OmniVision Technologies, Inc."  },
    { 0x05AA, "Utilux South China Ltd."  },
    { 0x05AB, "In-System Design"  },
    { 0x05AC, "Apple"  },
    { 0x05AD, "Y.C. Cable U.S.A., Inc"  },
    { 0x05AE, "Synopsys, Inc.(2)"  },
    { 0x05AF, "Sunrex Technology Corp."  },
    { 0x05B0, "Fountain Technologies, Inc"  },
    { 0x05B1, "First International Computer, Inc."  },
    { 0x05B2, "Focus Electronics"  },
    { 0x05B4, "HYUNDAI Electronics Industries Co., Ltd."  },
    { 0x05B5, "Dialogic Corp"  },
    { 0x05B6, "Proxima Corporation"  },
    { 0x05B7, "Medianix Semiconductor, Inc."  },
    { 0x05B8, "Sysgration"  },
    { 0x05B9, "Philips Research Laboratories"  },
    { 0x05BA, "DigitalPersona, Inc."  },
    { 0x05BB, "Grey Cell Systems"  },
    { 0x05BD, "RAFI GmbH & Co. KG"  },
    { 0x05BE, "Tyco Electronics Corp., a TE Connectivity Ltd. company"  },
    { 0x05BF, "S & S Research"  },
    { 0x05C0, "Keil Software"  },
    { 0x05C1, "MegaChips Corporation"  },
    { 0x05C2, "Media Phonics (Suisse) S.A."  },
    { 0x05C3, "VME Microsystems"  },
    { 0x05C5, "Digi International Inc."  },
    { 0x05C6, "Qualcomm, Inc"  },
    { 0x05C7, "Qtronix Corp"  },
    { 0x05C8, "Foxlink/Cheng Uei Precision Industry Co., Ltd"  },
    { 0x05C9, "Semtech"  },
    { 0x05CA, "Ricoh Company Ltd."  },
    { 0x05CB, "PowerVision Technologies Inc."  },
    { 0x05CC, "Neue ELSA GmbH"  },
    { 0x05CD, "Silicom LTD."  },
    { 0x05CE, "sci-worx GmbH"  },
    { 0x05CF, "Sung Forn Co. LTD."  },
    { 0x05D0, "GE Medical Systems Lunar"  },
    { 0x05D1, "Brainboxes Limited"  },
    { 0x05D2, "Wave Systems Corp."  },
    { 0x05D3, "Tohoku Ricoh Co., Ltd."  },
    { 0x05D5, "Super Gate Technology Co., LTD"  },
    { 0x05D6, "Philips Semiconductors, CICT"  },
    { 0x05D7, "Thomas & Betts"  },
    { 0x05D8, "Ultima Electronics Corp."  },
    { 0x05D9, "TPG IPB, Inc."  },
    { 0x05DA, "Microtek International Inc."  },
    { 0x05DB, "Sun Corporation"  },
    { 0x05DC, "Lexar Media, Inc."  },
    { 0x05DD, "Delta Electronics Inc."  },
    { 0x05DE, "Crucial Technology"  },
    { 0x05DF, "Silicon Vision Inc."  },
    { 0x05E0, "Symbol Technologies"  },
    { 0x05E1, "Syntek Semiconductor Co., Ltd."  },
    { 0x05E2, "ElecVision Inc."  },
    { 0x05E3, "Genesys Logic, Inc."  },
    { 0x05E4, "Red Wing Corporation"  },
    { 0x05E5, "Fuji Electric Co., Ltd."  },
    { 0x05E6, "Keithley Instruments"  },
    { 0x05E7, "EIZO Nanao Technologies Inc."  },
    { 0x05E8, "ICC, Inc."  },
    { 0x05E9, "Kawasaki Microelectronics America, Inc."  },
    { 0x05EA, "Evergreen Systems International"  },
    { 0x05EB, "FFC Limited"  },
    { 0x05EC, "COM21, Inc."  },
    { 0x05EE, "Cytechinfo Inc."  },
    { 0x05EF, "Anko Electronic Co., Ltd."  },
    { 0x05F0, "Canopus Co., Ltd."  },
    { 0x05F2, "Dexin Corporation, Ltd."  },
    { 0x05F3, "PI Engineering, Inc."  },
    { 0x05F4, "Davis AS"  },
    { 0x05F5, "Unixtar Technology Inc."  },
    { 0x05F6, "Envision Peripherals, Inc."  },
    { 0x05F7, "Silicon Portals Inc."  },
    { 0x05F8, "Phase Metrics"  },
    { 0x05F9, "Datalogic ADC"  },
    { 0x05FA, "Siemens Telecommunications Systems Limited"  },
    { 0x05FC, "Harman Multimedia"  },
    { 0x05FD, "STD Manufacturing Ltd."  },
    { 0x05FE, "CHIC TECHNOLOGY CORP"  },
    { 0x05FF, "LeCroy Corporation"  },
    { 0x0600, "Barco"  },
    { 0x0601, "Jazz Hipster Corporation"  },
    { 0x0602, "Vista Imaging Inc."  },
    { 0x0603, "Novatek Microelectronics Corp."  },
    { 0x0604, "Jean Co, Ltd."  },
    { 0x0605, "Anchor C&C Co., Ltd."  },
    { 0x0606, "Royal Information Electronics Co., Ltd."  },
    { 0x0607, "Bridge Information Co., Ltd."  },
    { 0x0608, "Genrad Ads"  },
    { 0x0609, "SMK Manufacturing Inc."  },
    { 0x060A, "Worth Data, Inc."  },
    { 0x060B, "Solid Year Co., LTD."  },
    { 0x060C, "EEH Datalink Gmbh"  },
    { 0x060D, "Auctor Corporation"  },
    { 0x060E, "Transmonde Technologies, Inc."  },
    { 0x060F, "Joinsoon Electronics Mfg. Co., Ltd."  },
    { 0x0610, "Costar Electronics Inc."  },
    { 0x0611, "JVCKENWOOD Nagaoka Corp."  },
    { 0x0612, "TV Interactive Corp."  },
    { 0x0613, "TransAct Technologies Incorporated"  },
    { 0x0614, "Bio-Rad Laboratories"  },
    { 0x0615, "Quabbin Wire & Cable Co., INC."  },
    { 0x0616, "Future Techno Designs PVT. LTD."  },
    { 0x0617, "Swiss Federal Institute of Technology"  },
    { 0x0618, "Chia Shin Technology Corp."  },
    { 0x0619, "Seiko Instruments Inc."  },
    { 0x061A, "Veridicom2"  },
    { 0x061B, "Promptus Communications, Inc."  },
    { 0x061C, "Act Labs, Ltd."  },
    { 0x061D, "Quatech, Inc."  },
    { 0x061E, "Nissei Electric Co."  },
    { 0x0620, "Alaris, Inc."  },
    { 0x0621, "ODU-Steckverbindungssysteme GmbH & Co. KG"  },
    { 0x0622, "Iotech, Inc."  },
    { 0x0623, "Littelfuse, Inc."  },
    { 0x0624, "Avocent Corporation"  },
    { 0x0625, "TiMedia Technology Co., Ltd."  },
    { 0x0626, "Nippon Systems Development Co., Ltd."  },
    { 0x0627, "Adomax Technology Co., Ltd."  },
    { 0x0628, "Tasking Software Inc."  },
    { 0x0629, "Zida Technologies Limited"  },
    { 0x062A, "MosArt Semiconductor Corp."  },
    { 0x062B, "Greatlink Electronics Taiwan Ltd."  },
    { 0x062C, "Institute for Information Industry"  },
    { 0x062D, "Taiwan Tai-Hao Enterprises Co. Ltd."  },
    { 0x062E, "JPC-MAIN SUPER Inc."  },
    { 0x062F, "Sin Sheng Terminal & Machine Inc."  },
    { 0x0630, "ORL"  },
    { 0x0631, "JUJO Electronics Corporation"  },
    { 0x0632, "Marquette Medical Systems, Inc."  },
    { 0x0633, "Cyrix Corporation"  },
    { 0x0634, "Micron Technology, Inc."  },
    { 0x0635, "Methode Electronics, Inc."  },
    { 0x0636, "Sierra Imaging, Inc."  },
    { 0x0637, "Gunz Limited"  },
    { 0x0638, "Avision, Inc."  },
    { 0x0639, "Chrontel, Inc."  },
    { 0x063A, "Techwin Corporation"  },
    { 0x063B, "Taugagreining HF (2)"  },
    { 0x063C, "Yamaichi Electronics Co., Ltd. (Sakura)"  },
    { 0x063D, "Fong Kai Industrial Co., Ltd."  },
    { 0x063E, "RealMedia Technology, Inc."  },
    { 0x063F, "New Technology Cable Ltd."  },
    { 0x0640, "Hitex Development Tools"  },
    { 0x0641, "Woods Industries, Inc."  },
    { 0x0642, "VIA Medical Corporation"  },
    { 0x0643, "NOVATUS, Inc."  },
    { 0x0644, "TEAC Corporation"  },
    { 0x0645, "Ethentica Inc."  },
    { 0x0647, "Acton Research Corporation"  },
    { 0x0649, "Weli Science Co., Ltd"  },
    { 0x064A, "Technical Corp."  },
    { 0x064B, "Analog Devices, Inc. Development Tools"  },
    { 0x064C, "Ji-Haw Industrial Co., Ltd"  },
    { 0x064D, "TriTech Microelectronics Ltd"  },
    { 0x064E, "Suyin Corporation"  },
    { 0x064F, "WIBU-Systems AG"  },
    { 0x0650, "Dynapro Systems"  },
    { 0x0651, "Likom Technology Sdn. Bhd."  },
    { 0x0652, "Stargate Solutions, Inc."  },
    { 0x0653, "CNF Inc."  },
    { 0x0654, "Granite Microsystems, Inc."  },
    { 0x0655, "Space Shuttle Hi-Tech Co.,Ltd."  },
    { 0x0656, "Glory Mark Electronic Ltd."  },
    { 0x0657, "Tekcon Electronics Corp."  },
    { 0x0658, "Sigma Designs, Inc."  },
    { 0x0659, "AETHRA"  },
    { 0x065A, "Optoelectronics Co., Ltd."  },
    { 0x065B, "Tracewell Systems"  },
    { 0x065C, "Brentwood Medical Technology Corp."  },
    { 0x065D, "ATTO Technology, Inc."  },
    { 0x065E, "Silicon Graphics"  },
    { 0x065F, "Good Way Technology Co., Ltd. & GWC technology Inc"  },
    { 0x0660, "TSAY-E (BVI) International Inc."  },
    { 0x0661, "Hamamatsu Photonics K.K."  },
    { 0x0662, "Kansai Electric Co., Ltd."  },
    { 0x0663, "Topmax Electronic Co., Ltd."  },
    { 0x0664, "ET&T"  },
    { 0x0665, "WayTech Development, Inc."  },
    { 0x0667, "Antona Corporation"  },
    { 0x0668, "WordWand"  },
    { 0x0669, "Oce' Printing Systems GmbH"  },
    { 0x066A, "Total Technologies, Ltd."  },
    { 0x066B, "SCM Microsystems Japan, Inc."  },
    { 0x066C, "ASK ASA"  },
    { 0x066D, "Entrega Technologies Inc."  },
    { 0x066E, "Acer Semiconductor America, Inc."  },
    { 0x066F, "Freescale Semiconductor, Inc. - Sigmatel"  },
    { 0x0670, "Sequel Imaging, Inc."  },
    { 0x0671, "Keisoku Giken Co., Ltd."  },
    { 0x0672, "Labtec Inc."  },
    { 0x0673, "HCL Peripherals Limited"  },
    { 0x0674, "Key Mouse Electronic Enterprise Co., Ltd."  },
    { 0x0675, "DrayTek Corp."  },
    { 0x0676, "Teles AG"  },
    { 0x0677, "Aiwa Co., Ltd."  },
    { 0x0678, "ACARD Technology Corp."  },
    { 0x0679, "WaterGate Software, Inc."  },
    { 0x067A, "ADS ANKER GmbH"  },
    { 0x067B, "Prolific Technology, Inc."  },
    { 0x067C, "Efficient Networks, Inc."  },
    { 0x067D, "Hohner Corp."  },
    { 0x067E, "Intermec Technologies (S) Pte Ltd."  },
    { 0x067F, "Virata Ltd."  },
    { 0x0680, "Realtek Semiconductor Corp., CPP Div."  },
    { 0x0681, "Siemens Information and Communication Products"  },
    { 0x0683, "Dataq Instruments, Inc."  },
    { 0x0684, "Cytec Corporation"  },
    { 0x0685, "ISDN*tek"  },
    { 0x0686, "KONICA MINOLTA TECHNOLOGY CENTER, INC."  },
    { 0x0687, "Sycard Technology"  },
    { 0x0688, "Microprocess Ingenierie"  },
    { 0x0689, "Elesys Inc."  },
    { 0x068A, "Pertech Inc."  },
    { 0x068B, "Potrans International, Inc."  },
    { 0x068C, "Tokin Corporation, Card Media Systems Department"  },
    { 0x068D, "Medical Measurement Systems B.V."  },
    { 0x068E, "CH Products"  },
    { 0x068F, "Nihon Kohden Corporation"  },
    { 0x0690, "Golden Bridge Electech Inc."  },
    { 0x0691, "Denter System Co., Ltd."  },
    { 0x0692, "Klippel GmbH"  },
    { 0x0693, "Hagiwara Solutions Co., Ltd."  },
    { 0x0694, "The LEGO Company"  },
    { 0x0695, "ODU-USA, Inc."  },
    { 0x0696, "Carroll Touch"  },
    { 0x0697, "Oxford Instruments (Medical Systems Division)"  },
    { 0x0698, "Chuntex (CTX)"  },
    { 0x0699, "Tektronix, Inc."  },
    { 0x069A, "Askey Computer Corporation"  },
    { 0x069B, "Technicolor SA"  },
    { 0x069C, "HST High Soft Tech GmbH"  },
    { 0x069D, "Hughes Network Systems (HNS)"  },
    { 0x069E, "Welcat Inc."  },
    { 0x069F, "Tron b.v."  },
    { 0x06A0, "USB Systems Design"  },
    { 0x06A1, "Alexon Co., Ltd."  },
    { 0x06A2, "Topro Technology Inc."  },
    { 0x06A3, "Logitech Europe S.A."  },
    { 0x06A4, "Xiamen Doowell Electron Co., Ltd."  },
    { 0x06A5, "Divio"  },
    { 0x06A7, "MicroStore, Inc."  },
    { 0x06A8, "Topaz Systems, Inc."  },
    { 0x06A9, "Westell"  },
    { 0x06AA, "Sysgration Ltd."  },
    { 0x06AB, "Johnathon Freeman Technologies"  },
    { 0x06AC, "Fujitsu Laboratories of America, Inc."  },
    { 0x06AD, "Greatland Electronics Taiwan Ltd."  },
    { 0x06AE, "Eurofins Digital Testing Belgium"  },
    { 0x06AF, "Harting, Inc. of North America"  },
    { 0x06B0, "Alva B.V."  },
    { 0x06B1, "Signtech USA, Ltd."  },
    { 0x06B2, "N*ABLE Technologies, Inc."  },
    { 0x06B3, "Galil Motion Control"  },
    { 0x06B4, "Citron GmbH"  },
    { 0x06B5, "Stanford Research Systems"  },
    { 0x06B6, "Leda Media Products"  },
    { 0x06B8, "Pixela Corporation"  },
    { 0x06B9, "Thomson Telecom"  },
    { 0x06BA, "Smooth Cord & Connector Co., Ltd."  },
    { 0x06BB, "EDA Inc."  },
    { 0x06BC, "Oki Data Corporation"  },
    { 0x06BD, "AGFA-Gevaert NV"  },
    { 0x06BE, "AME Optimedia Technology Co. Ltd."  },
    { 0x06BF, "Leoco Corporation"  },
    { 0x06C0, "AllSpirit Co., Ltd."  },
    { 0x06C2, "Microlynx Systems Ltd."  },
    { 0x06C3, "Foss Tecator AB"  },
    { 0x06C4, "Bizlink Technology, Inc."  },
    { 0x06C5, "Hagenuk, GmbH"  },
    { 0x06C6, "Infowave Software Inc."  },
    { 0x06C7, "Storm Technology Inc."  },
    { 0x06C8, "SIIG, Inc."  },
    { 0x06C9, "Taxan (Europe) Ltd."  },
    { 0x06CA, "Newer Technology, Inc."  },
    { 0x06CB, "Synaptics Inc."  },
    { 0x06CC, "Terayon Communication Systems"  },
    { 0x06CD, "Keyspan"  },
    { 0x06CE, "Contec Co., Ltd."  },
    { 0x06CF, "Spheron VR- Bonnet und Steuerwald GdbR"  },
    { 0x06D0, "LapLink, Inc."  },
    { 0x06D1, "Daewoo Electronics Co Ltd"  },
    { 0x06D2, "Pioneer Microsystems"  },
    { 0x06D3, "Mitsubishi Electric Corporation"  },
    { 0x06D4, "Cisco Systems(2)"  },
    { 0x06D5, "Toshiba America Electronic Components, Inc."  },
    { 0x06D6, "Aashima Technology B.V."  },
    { 0x06D7, "Network Computing Devices (NCD)"  },
    { 0x06D8, "Technical Marketing Research, Inc."  },
    { 0x06D9, "Atmel-TEMIC Semiconductor GmbH"  },
    { 0x06DA, "Phoenixtec Power Co., Ltd."  },
    { 0x06DB, "Paradyne"  },
    { 0x06DC, "Foxlink Image Technology Co., Ltd."  },
    { 0x06DD, "Impact Technologies"  },
    { 0x06DE, "Heisei Technology Co., Ltd."  },
    { 0x06E0, "Multi-Tech Systems, Inc."  },
    { 0x06E1, "ADS Technologies, Inc."  },
    { 0x06E2, "Trio Motion Technology Limited"  },
    { 0x06E4, "Alcatel Microelectronics"  },
    { 0x06E5, "Lusher Technologies"  },
    { 0x06E6, "Tiger Jet Network, Inc."  },
    { 0x06E7, "Universal Electronics Inc."  },
    { 0x06E8, "Braemar Inc."  },
    { 0x06E9, "Nippon Electric Industry Co., Ltd."  },
    { 0x06EA, "Sirius Technologies Limited"  },
    { 0x06EB, "PC Expert Tech. Co., Ltd."  },
    { 0x06EC, "ADInstruments Ltd."  },
    { 0x06ED, "Datastor Technology"  },
    { 0x06EF, "I.A.C. Geometrische Ingenieurs B.V."  },
    { 0x06F0, "T.N.C Industrial Co., Ltd."  },
    { 0x06F1, "Opcode Systems Inc."  },
    { 0x06F2, "Emine Technology Company"  },
    { 0x06F3, "Flexion Systems Ltd."  },
    { 0x06F4, "First Person Gaming"  },
    { 0x06F5, "Midian Production Distribution"  },
    { 0x06F6, "Wintrend Technology Co., Ltd."  },
    { 0x06F7, "Wish Technologies"  },
    { 0x06F8, "Guillemot Corporation"  },
    { 0x06F9, "Asyst Electronic"  },
    { 0x06FA, "HSD S.r.L"  },
    { 0x06FB, "Hitachi Device Engineering Ltd."  },
    { 0x06FC, "Motorola Semiconductor Products Sector/US"  },
    { 0x06FD, "Boston Acoustics"  },
    { 0x06FE, "Gallant Computer, Inc."  },
    { 0x06FF, "Mediacom Technologies Pte Ltd."  },
    { 0x0701, "Supercomal Wire & Cable SDN. BHD."  },
    { 0x0702, "PixStream Incorporated"  },
    { 0x0703, "Bvtech Industry Inc."  },
    { 0x0704, "Vorum Research Corporation"  },
    { 0x0705, "NKK Corporation"  },
    { 0x0706, "Ariel Corporation"  },
    { 0x0707, "SMC Networks, Inc."  },
    { 0x0708, "Putercom Co., Ltd."  },
    { 0x0709, "Parthus Technologies"  },
    { 0x070A, "Oki Electric Industry Co., Ltd."  },
    { 0x070B, "Hasco Int., Inc."  },
    { 0x070C, "Titan Electronics Inc."  },
    { 0x070D, "Comoss Electronic Co., Ltd."  },
    { 0x070E, "Excel Cell Electronic Co., Ltd."  },
    { 0x070F, "Oce' -Technologies B.V."  },
    { 0x0710, "Connect Tech Inc."  },
    { 0x0711, "Magic Control Technology Corp."  },
    { 0x0712, "Verity Instruments, Inc."  },
    { 0x0713, "Interval Research Corp."  },
    { 0x0714, "New Motion International Co., Ltd"  },
    { 0x0715, "Liang Tei Co., Ltd."  },
    { 0x0716, "Oxus Research S.A."  },
    { 0x0717, "ZNK Corporation"  },
    { 0x0718, "Imation Corp."  },
    { 0x0719, "Tremon Enterprises Co., Ltd."  },
    { 0x071A, "FLIR Explosives"  },
    { 0x071B, "Domain Technologies, Inc."  },
    { 0x071C, "Xionics Document Technologies, Inc."  },
    { 0x071D, "Dialogic Corporation"  },
    { 0x071E, "Ariston Technologies"  },
    { 0x071F, "ARS Technologies Ltd."  },
    { 0x0720, "Keyence Corporation"  },
    { 0x0721, "HMedia Technology Inc."  },
    { 0x0722, "Consero"  },
    { 0x0723, "Centillium Communications Corporation"  },
    { 0x0724, "Lawson Labs, Inc."  },
    { 0x0725, "Applied Precision Inc."  },
    { 0x0726, "Vanguard International Semiconductor-America"  },
    { 0x0727, "C&H Technologies, Inc."  },
    { 0x0728, "Avermedia"  },
    { 0x0729, "CY&S Industrial Co., Ltd."  },
    { 0x072A, "Luminex Corporation"  },
    { 0x072B, "Dnova Corporation"  },
    { 0x072C, "OTSO"  },
    { 0x072D, "Able Communications, Inc."  },
    { 0x072E, "Sunix Co., Ltd."  },
    { 0x072F, "Advanced Card Systems Ltd."  },
    { 0x0730, "Indus Instruments"  },
    { 0x0731, "Susteen, Inc."  },
    { 0x0732, "Goldfull Electronics & Telecommunications Corp."  },
    { 0x0733, "ViewQuest Technologies, Inc."  },
    { 0x0734, "LASAT Communications A/S"  },
    { 0x0735, "Asuscom Network, Inc."  },
    { 0x0736, "Lorom Industrial Co., Ltd."  },
    { 0x0737, "Snap-on Diagnostics"  },
    { 0x0738, "Mad Catz, Inc."  },
    { 0x0739, "Cue Network Corporation"  },
    { 0x073A, "Chaplet Systems, Inc."  },
    { 0x073B, "Suncom Technologies"  },
    { 0x073C, "Industrial Electronic Engineers, Inc."  },
    { 0x073D, "Eutronsec Spa"  },
    { 0x073E, "Sigma Itec, Inc."  },
    { 0x073F, "Data Electronics (Aust) Pty, Ltd."  },
    { 0x0740, "Full Enterprise Corp."  },
    { 0x0741, "Momentum US Inc."  },
    { 0x0742, "Stollmann EtV GmbH"  },
    { 0x0743, "Bonig und Kallenback oHG"  },
    { 0x0744, "GMK Electronic Design GmbH"  },
    { 0x0745, "Syntech Information Co., Ltd."  },
    { 0x0746, "ONKYO Corporation"  },
    { 0x0747, "Labway Corporation"  },
    { 0x0748, "Strong Man Enterprise Co., Ltd."  },
    { 0x0749, "EVer Electronics Corp."  },
    { 0x074A, "Ming Fortune Industry Co., Ltd."  },
    { 0x074B, "Polestar Tech. Corp."  },
    { 0x074C, "C-C-C Group PLC"  },
    { 0x074D, "Micronas GmbH"  },
    { 0x074E, "Digital Stream Corporation"  },
    { 0x074F, "Microflip, Inc"  },
    { 0x0750, "Innovative Integration"  },
    { 0x0751, "Info Network Systems"  },
    { 0x0752, "Non-Standard, TSG"  },
    { 0x0753, "Mocom Softeare GmbH & Co. KG"  },
    { 0x0754, "SyQuest Technology"  },
    { 0x0755, "Aureal Semiconductor"  },
    { 0x0756, "RSI Systems"  },
    { 0x0757, "Network Technologies, Inc."  },
    { 0x0758, "Carl Zeiss Jena GmbH"  },
    { 0x0759, "Cellvision Systems, Inc."  },
    { 0x075A, "SEL Inc."  },
    { 0x075B, "Sophisticated Circuits, Inc."  },
    { 0x075C, "Ulan Co., Ltd."  },
    { 0x075D, "Microdowell SRL"  },
    { 0x075E, "ABIT Corporation"  },
    { 0x075F, "CITEL Technologies, Ltd."  },
    { 0x0760, "JL Cooper Electronics"  },
    { 0x0761, "MasTech, Inc."  },
    { 0x0762, "Coretex Corporation"  },
    { 0x0763, "M-Audio"  },
    { 0x0764, "Cyber Power Systems, Inc."  },
    { 0x0765, "X-Rite Incorporated"  },
    { 0x0766, "Jess-Link Products Co., Ltd. (JPC)"  },
    { 0x0767, "Tokheim Corporation"  },
    { 0x0768, "Camtel Technology Corp."  },
    { 0x0769, "SURECOM Technology Corp."  },
    { 0x076A, "Conceptual Systems"  },
    { 0x076B, "HID Global GmbH"  },
    { 0x076C, "Partner Tech"  },
    { 0x076D, "Denso Corporation"  },
    { 0x076E, "Kuan Tech Enterprise Co., Ltd."  },
    { 0x076F, "Jhen Vei Electronic Co., Ltd."  },
    { 0x0770, "Welch Allyn, Inc - Medical Division"  },
    { 0x0771, "MicroCraft"  },
    { 0x0772, "TFL LAN, Inc"  },
    { 0x0773, "Spital Sangyo Co., Ltd."  },
    { 0x0774, "AmTRAN Technology Co., Ltd."  },
    { 0x0775, "Longshine Electronics Corp."  },
    { 0x0776, "Inalways Corporation"  },
    { 0x0777, "Comda Advanced Technology Corporation"  },
    { 0x0778, "Volex, Inc."  },
    { 0x0779, "Fairchild Semiconductor"  },
    { 0x077A, "NIDEC SANKYO CORPORATION"  },
    { 0x077B, "Linksys"  },
    { 0x077C, "Forward Electronics Co., Ltd."  },
    { 0x077D, "Griffin Technology LLC"  },
    { 0x077E, "Softing GmbH"  },
    { 0x077F, "Well Excellent & Most Corp."  },
    { 0x0780, "ORGA Kartensysteme GmbH"  },
    { 0x0781, "Western Digital, Sandisk"  },
    { 0x0782, "Trackerball"  },
    { 0x0783, "C3PO, S.L."  },
    { 0x0784, "Pretec Corporation"  },
    { 0x0785, "Willnet Inc."  },
    { 0x0786, "Jeil Data Systems Co., Ltd."  },
    { 0x0787, "Abera System Corp"  },
    { 0x0788, "3Cam Technology, Inc"  },
    { 0x0789, "Logitec Corporation"  },
    { 0x078A, "Tandy Electronics (China) Ltd."  },
    { 0x078B, "Happ Controls"  },
    { 0x078C, "CalComp"  },
    { 0x078D, "Presto Technologies Inc."  },
    { 0x078E, "San Shih Electrical Enterprise Co. Ltd."  },
    { 0x078F, "Troy XCD, Inc."  },
    { 0x0790, "Pro-Image Manufacturing Co., Ltd"  },
    { 0x0791, "Copartner Technology Corporation"  },
    { 0x0792, "Axis Communications AB"  },
    { 0x0793, "Wha Yu Industrial Co., Ltd."  },
    { 0x0794, "ABL Electronics Corporation"  },
    { 0x0795, "RealChip Inc."  },
    { 0x0796, "Certicom Corp."  },
    { 0x0797, "Grandtech Semiconductor Corporation"  },
    { 0x0798, "F.J. Tieman BV"  },
    { 0x0799, "Boulder Creek Engineering"  },
    { 0x079A, "Aptec Instruments"  },
    { 0x079B, "Sagem SA"  },
    { 0x079C, "Sun Communications Inc."  },
    { 0x079D, "Alfadata Computer Corp."  },
    { 0x079E, "Tokin Corporation"  },
    { 0x079F, "VMETRO asa"  },
    { 0x07A0, "Leiderdorp Instruments"  },
    { 0x07A1, "Digicom Spa"  },
    { 0x07A2, "National Technical Systems"  },
    { 0x07A3, "ONNTO Corp."  },
    { 0x07A4, "Be Incorporated"  },
    { 0x07A5, "Tietech Co., Ltd."  },
    { 0x07A6, "Infineon-ADMtek Co., Ltd."  },
    { 0x07A7, "Mediatronix BV"  },
    { 0x07A8, "Home Office PSDB"  },
    { 0x07A9, "Sandmartin Company Ltd."  },
    { 0x07AA, "Corega Inc."  },
    { 0x07AB, "Freecom Technologies"  },
    { 0x07AC, "Fortress U&T Ltd."  },
    { 0x07AD, "ECO Chemie"  },
    { 0x07AE, "C&C Technic Taiwan Co., Ltd."  },
    { 0x07AF, "Microtech International, Inc."  },
    { 0x07B0, "Billion Electric Co., Ltd"  },
    { 0x07B1, "IMP, Inc."  },
    { 0x07B2, "Motorola BCS"  },
    { 0x07B3, "Plustek, Inc."  },
    { 0x07B4, "OLYMPUS CORPORATION"  },
    { 0x07B5, "Mega World International Ltd."  },
    { 0x07B6, "Marubun Corp."  },
    { 0x07B7, "TIME Interconnect Ltd."  },
    { 0x07B8, "AboCom Systems, Inc."  },
    { 0x07B9, "Reynolds Medical"  },
    { 0x07BA, "Accurate Technologies, Inc."  },
    { 0x07BB, "Intelogis Inc"  },
    { 0x07BC, "Canon Computer Systems, Inc."  },
    { 0x07BD, "Webgear Inc."  },
    { 0x07BE, "Veridicom"  },
    { 0x07BF, "TestQuest, Inc."  },
    { 0x07C0, "Code Mercenaries"  },
    { 0x07C1, "Keisokugiken Corporation"  },
    { 0x07C2, "Varatouch Technology Inc."  },
    { 0x07C3, "J-Works, Inc."  },
    { 0x07C4, "Datafab Systems Inc."  },
    { 0x07C5, "APG Cash Drawer"  },
    { 0x07C6, "ShareWave, Inc."  },
    { 0x07C7, "Powertech Industrial Co., Ltd."  },
    { 0x07C8, "B.U.G., Inc."  },
    { 0x07C9, "Allied Telesis Inc"  },
    { 0x07CA, "AVerMedia Technologies, Inc."  },
    { 0x07CB, "Kingmax Technology Inc."  },
    { 0x07CC, "LIWANLI Innovation Co., Ltd"  },
    { 0x07CD, "Hteck Corp."  },
    { 0x07CE, "Nidec-Shimpo Corp."  },
    { 0x07CF, "Casio Computer Co., Ltd."  },
    { 0x07D0, "Dazzle Multimedia"  },
    { 0x07D2, "Aptio Products Inc."  },
    { 0x07D3, "Cyberdata Corp."  },
    { 0x07D4, "Aloka Co., Ltd."  },
    { 0x07D5, "Radiant Systems, Inc."  },
    { 0x07D6, "MENICX International Co., Ltd."  },
    { 0x07D7, "GCC Technologies, Inc."  },
    { 0x07D8, "Network Suginami Kokoto"  },
    { 0x07D9, "Compuapps"  },
    { 0x07DA, "Arasan Chip Systems Inc."  },
    { 0x07DB, "Mental Models, Inc."  },
    { 0x07DC, "OCTAL-Engenharia de Sistemas S.A."  },
    { 0x07DD, "Hampshire Company, Inc."  },
    { 0x07DE, "Best Data Products"  },
    { 0x07DF, "David Electronics Company, Ltd."  },
    { 0x07E0, "NCP Engineering"  },
    { 0x07E1, "Acer Netxus Incorporated"  },
    { 0x07E2, "Elmeg GmbH & Co., Ltd."  },
    { 0x07E3, "Planex Communications, Inc."  },
    { 0x07E4, "Movado Enterprise Co., Ltd."  },
    { 0x07E5, "QPS, Inc."  },
    { 0x07E6, "Allied Cable Corporation"  },
    { 0x07E7, "Mirvo Toys, Inc."  },
    { 0x07E8, "Labsystems"  },
    { 0x07E9, "Sanyo Technosound Co., Ltd."  },
    { 0x07EA, "Iwatsu Electric Co., Ltd."  },
    { 0x07EB, "Double-H Technology Co., Ltd."  },
    { 0x07EC, "Taiyo Electric Wire & Cable Co., Ltd."  },
    { 0x07ED, "Precision MicroDynamics, Inc."  },
    { 0x07EE, "Logware GmbH"  },
    { 0x07EF, "Suite Technology Systems"  },
    { 0x07F0, "PS Communications Ltd."  },
    { 0x07F1, "Picostar, Inc."  },
    { 0x07F2, "BPT Enterprises"  },
    { 0x07F3, "L3 Systems"  },
    { 0x07F4, "Joritel International B.V."  },
    { 0x07F5, "Amiable Technologies, Inc."  },
    { 0x07F6, "Circuit Assembly Corp."  },
    { 0x07F7, "Century Corporation"  },
    { 0x07F8, "Eskape Labs"  },
    { 0x07F9, "Dotop Technology, Inc."  },
    { 0x07FA, "FHLP"  },
    { 0x07FB, "Digi-Tek, Inc."  },
    { 0x07FC, "Protec Microsystems"  },
    { 0x07FD, "Mark of the Unicorn, Inc."  },
    { 0x07FE, "Net Eyes, Inc."  },
    { 0x07FF, "Sectra AB"  },
    { 0x0800, "Kortex International"  },
    { 0x0801, "Mag-Tek"  },
    { 0x0802, "Mako Technologies, LLC"  },
    { 0x0803, "Zoom Telephonics, Inc."  },
    { 0x0804, "Neuron Corporation"  },
    { 0x0805, "Iruma Soft Co., Ltd."  },
    { 0x0806, "Clinton Electronics Corp."  },
    { 0x0807, "SIIX Corporation"  },
    { 0x0808, "InfiMed, Inc."  },
    { 0x0809, "Genicom LP"  },
    { 0x080A, "Evermuch Technology Co., Ltd."  },
    { 0x080B, "Cross Match Technologies, Inc."  },
    { 0x080C, "Datalogic S.p.A."  },
    { 0x080D, "TECO Image Systems Co., Ltd."  },
    { 0x080E, "Sound Technology, Inc."  },
    { 0x080F, "Deschutes Corporation"  },
    { 0x0810, "Personal Communication Systems, Inc."  },
    { 0x0811, "Fimet"  },
    { 0x0812, "E-Tech, Inc."  },
    { 0x0813, "Mattel, Inc."  },
    { 0x0814, "EBI Systems, Inc."  },
    { 0x0815, "Scintrex"  },
    { 0x0816, "ABB Automation Products AB"  },
    { 0x0817, "Interzeag Medical Technology"  },
    { 0x0818, "NTT Electronics Corporation"  },
    { 0x0819, "Syncrosoft GMBH"  },
    { 0x081A, "MG Logic Pte Ltd."  },
    { 0x081B, "Indigita Corporation"  },
    { 0x081C, "MIPSYS"  },
    { 0x081D, "VlerZwo Software GbR"  },
    { 0x081E, "AlphaSmart, Inc."  },
    { 0x081F, "Totsu Engineering, Inc."  },
    { 0x0820, "Verax Engineering"  },
    { 0x0821, "A.T. Cross"  },
    { 0x0822, "REUDO Corporation"  },
    { 0x0823, "Tactex Controls, Inc."  },
    { 0x0824, "M.S.E. GmbH"  },
    { 0x0825, "GC Protronics"  },
    { 0x0826, "Data Transit"  },
    { 0x0827, "BroadLogic, Inc."  },
    { 0x0828, "Sato Corporation"  },
    { 0x0829, "DirecTV Broadband"  },
    { 0x082A, "Object Co., Ltd."  },
    { 0x082B, "TrophyTrex"  },
    { 0x082C, "Japan Digital Laboratory Co., Ltd."  },
    { 0x082D, "Handspring, Inc."  },
    { 0x082E, "Suni Imaging Microsystems, Inc."  },
    { 0x082F, "ACACIA"  },
    { 0x0830, "Palm Inc."  },
    { 0x0831, "Chong Tsi Su Enterprise Co., Ltd"  },
    { 0x0832, "Kouwell Electronics Corp."  },
    { 0x0833, "Sourcenext Corporation"  },
    { 0x0834, "Ciponic Technology Co., Ltd."  },
    { 0x0835, "Action Star Technology Co., Ltd."  },
    { 0x0836, "Evertz Microsystems Ltd."  },
    { 0x0837, "Renishaw PLC"  },
    { 0x0838, "Precision MicroControl Corporation"  },
    { 0x0839, "Samsung Techwin"  },
    { 0x083A, "Accton Technology Corporation"  },
    { 0x083B, "Dr. Neuhaus Telekommunikation GmbH"  },
    { 0x083C, "Jaeger Messtechnik GmbH"  },
    { 0x083D, "Nakayo Telecommunication, Inc."  },
    { 0x083E, "2-Tel B.V."  },
    { 0x083F, "Boca Global, Inc."  },
    { 0x0840, "Argosy Research Inc."  },
    { 0x0841, "Rioport.com Inc."  },
    { 0x0842, "ESA MESSTECHNIK GMBH"  },
    { 0x0843, "Mcom As"  },
    { 0x0844, "Welland Industrial Co., Ltd."  },
    { 0x0845, "EES Technik fur Musik"  },
    { 0x0846, "NETGEAR, Inc."  },
    { 0x0847, "Interack Communications Inc."  },
    { 0x0848, "Accton Technology Co., Ltd."  },
    { 0x0849, "SC&T International, Inc."  },
    { 0x084A, "Wipro Limited"  },
    { 0x084B, "Castlewood Systems"  },
    { 0x084C, "The Japan Steel Works, Ltd."  },
    { 0x084D, "Minton Optic Industry Co., Ltd."  },
    { 0x084E, "KidBoard, Inc. dba KBGear Interactive"  },
    { 0x084F, "EMPEG Ltd"  },
    { 0x0850, "FastPoint Technologies, Inc."  },
    { 0x0851, "Macronix International Co., Ltd."  },
    { 0x0852, "CSEM"  },
    { 0x0853, "Topre Corporation"  },
    { 0x0854, "Active Wire, Inc."  },
    { 0x0855, "JMBS Developpements"  },
    { 0x0856, "B&B Electronics"  },
    { 0x0857, "Gerber Scientific Products, Inc."  },
    { 0x0858, "Hitachi Maxell Ltd."  },
    { 0x0859, "Minolta Systems Laboratory, Inc."  },
    { 0x085A, "Xircom"  },
    { 0x085B, "Kurt Manufacturing"  },
    { 0x085C, "Color Vision Inc."  },
    { 0x085D, "Ambient Technologies, Inc."  },
    { 0x085E, "NaftEL Technologies LTD."  },
    { 0x085F, "Canberra Industries"  },
    { 0x0860, "Momentum Data System"  },
    { 0x0861, "Cambridge Research Systems Ltd."  },
    { 0x0862, "Teletrol Systems, Inc."  },
    { 0x0863, "Filanet Corporation"  },
    { 0x0864, "Roper International Ltd."  },
    { 0x0865, "MICROLAB"  },
    { 0x0866, "PEI Electronics, Inc."  },
    { 0x0867, "Data Translation, Inc."  },
    { 0x0868, "Electrical Geodesics, Inc."  },
    { 0x0869, "Visual Interaction"  },
    { 0x086A, "Emagic Soft-und Hardware Gmbh"  },
    { 0x086B, "ROHM Co. Ltd."  },
    { 0x086C, "DeTeWe"  },
    { 0x086D, "ICE Technology"  },
    { 0x086E, "System TALKS Inc."  },
    { 0x086F, "MEC IMEX INC-HPT"  },
    { 0x0870, "Metricom, Inc."  },
    { 0x0871, "Merge Technologies Inc."  },
    { 0x0872, "Broadxent, Inc."  },
    { 0x0873, "Xpeed Inc."  },
    { 0x0874, "A-Tec Subsystem, Inc."  },
    { 0x0875, "Mecel AB"  },
    { 0x0876, "3M Home Health Systems"  },
    { 0x0877, "Lew Engineering"  },
    { 0x0878, "SYSTEC Computer Gmbh"  },
    { 0x0879, "Comtrol Corporation"  },
    { 0x087A, "Getemed GmbH"  },
    { 0x087B, "Cornerstone Peripherals Technology"  },
    { 0x087C, "ADESSO/Kbtek America Inc."  },
    { 0x087D, "JATON Corporation"  },
    { 0x087E, "Fujitsu Computer Products of America"  },
    { 0x087F, "QualCore Logic Inc"  },
    { 0x0880, "APT Technologies Inc."  },
    { 0x0881, "Sistemas Y Redes Telematicas, Sire S.L."  },
    { 0x0882, "Rightec Research"  },
    { 0x0883, "Recording Industry Association of America (RIAA)"  },
    { 0x0884, "USB Systems"  },
    { 0x0885, "Boca Research, Inc."  },
    { 0x0887, "Hannstar Electronics Corp."  },
    { 0x0889, "Current Works, Inc."  },
    { 0x088A, "TechTools"  },
    { 0x088B, "MassWorks"  },
    { 0x088C, "Swecoin AB"  },
    { 0x088D, "Engineering Spirit"  },
    { 0x088E, "Pace Anti-Piracy, Inc."  },
    { 0x088F, "Husky Computers Limited"  },
    { 0x0890, "Consultronics Ltd."  },
    { 0x0891, "Drager Medizintechnik Gmbh."  },
    { 0x0892, "DioGraphy Inc."  },
    { 0x0893, "Bartec"  },
    { 0x0894, "TSI Incorporated"  },
    { 0x0895, "Kanitech A/S"  },
    { 0x0896, "Starseed Enterprises AG"  },
    { 0x0897, "Lauterbach GmbH"  },
    { 0x0898, "3M Canada"  },
    { 0x0899, "Grieshaber & Co. AG"  },
    { 0x089A, "Koepruelue Engineering"  },
    { 0x089B, "Digital-3, LLC."  },
    { 0x089C, "United Technologies Research Cntr."  },
    { 0x089D, "Icron Technologies Corporation"  },
    { 0x089E, "NST Co., Ltd."  },
    { 0x089F, "Primex Aerospace Co."  },
    { 0x08A0, "Logic Meca Co., Ltd."  },
    { 0x08A1, "Studio Zee"  },
    { 0x08A2, "Millennia Systems, Inc."  },
    { 0x08A3, "Hyowon Software"  },
    { 0x08A4, "YTG Smartech Inc."  },
    { 0x08A5, "e9 Inc."  },
    { 0x08A6, "Toshiba Tec Corporation"  },
    { 0x08A7, "General Cybernetics Inc."  },
    { 0x08A8, "Andrea Electronics"  },
    { 0x08A9, "CWAV"  },
    { 0x08AA, "Kernel Productions, Inc."  },
    { 0x08AB, "Innolab Pte. Ltd."  },
    { 0x08AC, "Macraigor Systems LLC"  },
    { 0x08AD, "Toyota Technical Development Corporation (TTDC)"  },
    { 0x08AE, "Macally (Mace Group, Inc.)"  },
    { 0x08AF, "Hamilton Co."  },
    { 0x08B0, "Metrohm Ltd."  },
    { 0x08B1, "High Technology Laboratory s.r.l"  },
    { 0x08B2, "BIOTRONIK GmbH & Co."  },
    { 0x08B3, "Voice It Worldwide, Inc."  },
    { 0x08B4, "Sorenson Communications"  },
    { 0x08B5, "Correlator.com"  },
    { 0x08B6, "Imagek, Inc."  },
    { 0x08B7, "NATSU Corporation Limited"  },
    { 0x08B8, "J. Gordon Electronic Design, Inc."  },
    { 0x08B9, "General Wireless Operations Inc"  },
    { 0x08BA, "Fujitsu General Limited"  },
    { 0x08BB, "Texas Instruments Japan"  },
    { 0x08BC, "Dr. G. Schuhfried GmbH"  },
    { 0x08BD, "Citizen Watch Co., Ltd."  },
    { 0x08BE, "Meilenstein GmbH"  },
    { 0x08BF, "Nova Engineering, Inc."  },
    { 0x08C0, "Braintronics B.V."  },
    { 0x08C1, "Timestep Electronics Ltd."  },
    { 0x08C2, "ArgoCraft Co., Ltd."  },
    { 0x08C3, "Precise Biometrics"  },
    { 0x08C4, "Proxim CBU"  },
    { 0x08C5, "Moreton Bay"  },
    { 0x08C6, "Scalex Corporation"  },
    { 0x08C7, "TAI TWUN ENTERPRISE CO., LTD."  },
    { 0x08C8, "2Wire, Inc"  },
    { 0x08C9, "Nippon Telegraph and Telephone Corp."  },
    { 0x08CA, "AIPTEK International Inc."  },
    { 0x08CB, "Cyber Innovate, Inc."  },
    { 0x08CC, "ifak system GmbH"  },
    { 0x08CD, "Jue Hsun Ind. Corp."  },
    { 0x08CE, "Long Well Electronics Corp."  },
    { 0x08CF, "Productivity Enhancement Products"  },
    { 0x08D0, "Tasco Electronics Co., Inc."  },
    { 0x08D1, "Smartbridges Pte. Ltd."  },
    { 0x08D2, "Dialog4 System Engineering Gmbh."  },
    { 0x08D3, "Virtual Ink"  },
    { 0x08D4, "Siemens PC Systeme GmbH"  },
    { 0x08D5, "Cambridge Heart, Inc."  },
    { 0x08D6, "Itautec Philco S.A."  },
    { 0x08D7, "Opticon, Inc."  },
    { 0x08D8, "Huntsville Microsystems, Inc."  },
    { 0x08D9, "Increment P Corporation"  },
    { 0x08DA, "A W Electronics, Inc."  },
    { 0x08DB, "IXXAT Automation GmbH"  },
    { 0x08DC, "Animo Limited"  },
    { 0x08DD, "Billionton Systems, Inc."  },
    { 0x08DE, "Touchstone Software"  },
    { 0x08DF, "Spyrus Inc."  },
    { 0x08E0, "Geodesic Designs, Inc."  },
    { 0x08E1, "LSI JAPAN Co., Ltd"  },
    { 0x08E2, "SafeNet China Ltd."  },
    { 0x08E3, "OLITEC"  },
    { 0x08E4, "Pioneer Corporation"  },
    { 0x08E5, "LITRONIC"  },
    { 0x08E6, "Gemalto SA"  },
    { 0x08E7, "PAN-INTERNATIONAL WIRE & CABLE (M) SDN BHD"  },
    { 0x08E8, "Integrated Memory Logic"  },
    { 0x08E9, "Extended Systems, Inc."  },
    { 0x08EA, "Ericsson Inc."  },
    { 0x08EB, "Asulab SA"  },
    { 0x08EC, "M-Systems Flash Disk Pioneers"  },
    { 0x08ED, "Instrumentation Metrics, Inc."  },
    { 0x08EE, "CCSI/HESSO"  },
    { 0x08EF, "PixelVision"  },
    { 0x08F0, "CardScan Inc."  },
    { 0x08F1, "CTI Electronics Corporation"  },
    { 0x08F2, "Constance Technology Co., Ltd."  },
    { 0x08F3, "Wintime Electronics Corp."  },
    { 0x08F4, "Telia ProSoft AB"  },
    { 0x08F5, "SYSTEC Co., Ltd."  },
    { 0x08F6, "Logic 3 International Limited"  },
    { 0x08F7, "Vernier Software"  },
    { 0x08F8, "Keen Top International Enterprise Co., Ltd."  },
    { 0x08F9, "Wipro Technologies"  },
    { 0x08FA, "CAERE"  },
    { 0x08FB, "Socket Mobile, Inc."  },
    { 0x08FC, "Sicon International"  },
    { 0x08FD, "Digianswer A/S"  },
    { 0x08FE, "GDSYSTEMS"  },
    { 0x08FF, "AuthenTec, Inc."  },
    { 0x0901, "VST Technologies"  },
    { 0x0902, "iDream Technologies Pte Ltd"  },
    { 0x0903, "Infolibria"  },
    { 0x0904, "Frank Audiodata"  },
    { 0x0905, "ISDG"  },
    { 0x0906, "FARADAY Technology Corp."  },
    { 0x0907, "Addison Technology Europe B.V."  },
    { 0x0908, "Siemens Automation & Drives"  },
    { 0x0909, "Audio-Technica Corp."  },
    { 0x090A, "Trumpion Microelectronics Inc"  },
    { 0x090B, "Neurosmith"  },
    { 0x090C, "Silicon Motion, Inc. - Taiwan"  },
    { 0x090D, "MULTIPORT Computer Vertriebs GmbH"  },
    { 0x090E, "Shining Technology, Inc."  },
    { 0x090F, "Fujitsu Devices Inc."  },
    { 0x0910, "Alation Systems, Inc."  },
    { 0x0911, "Philips Speech Processing"  },
    { 0x0912, "Voquette, Inc."  },
    { 0x0913, "Asante' Technologies, Inc."  },
    { 0x0914, "Bally Gaming, Inc."  },
    { 0x0915, "GlobespanVirata, Inc."  },
    { 0x0916, "DH electronics GmbH"  },
    { 0x0917, "SmartDisk Corporation"  },
    { 0x0918, "Planet Portal.com"  },
    { 0x0919, "Sound Vision Inc."  },
    { 0x091A, "Inter-Cable Systems, Inc."  },
    { 0x091B, "Raleigh Technology Corporation"  },
    { 0x091C, "Bormann EDV + Zubehoer GmbH"  },
    { 0x091D, "A. K. Barns Ltd."  },
    { 0x091E, "Garmin International"  },
    { 0x091F, "U-JIN Mesco Co., Ltd."  },
    { 0x0920, "Echelon Corporation"  },
    { 0x0921, "GoHubs, inc."  },
    { 0x0922, "Dymo Corporation"  },
    { 0x0923, "IC Media Corporation"  },
    { 0x0924, "Xerox Corporation"  },
    { 0x0925, "Lakeview Research"  },
    { 0x0926, "Sound Devices, LLC"  },
    { 0x0927, "Summus, Ltd."  },
    { 0x0928, "Oxford Semiconductor Ltd."  },
    { 0x0929, "American Biometric Company"  },
    { 0x092A, "Toshiba Information & Industrial Sys. And Services"  },
    { 0x092B, "Sena Technologies, Inc."  },
    { 0x092C, "Shanghai Bell Company Limited"  },
    { 0x092D, "OYO Instruments"  },
    { 0x092E, "Markpoint AB"  },
    { 0x092F, "Northern Embedded Science"  },
    { 0x0930, "Toshiba Corporation"  },
    { 0x0931, "Harmonic Data Systems Ltd."  },
    { 0x0932, "Crescentec Corporation"  },
    { 0x0933, "Quantum Corp."  },
    { 0x0934, "Spirent Communications"  },
    { 0x0935, "Accurite Technologies, Inc."  },
    { 0x0936, "DynamicNakedAudio Inc."  },
    { 0x0937, "Scania CV AB"  },
    { 0x0938, "Virtual DSP Corporation"  },
    { 0x0939, "Lumberg, Inc."  },
    { 0x093A, "Pixart Imaging, Inc."  },
    { 0x093B, "Plextor LLC"  },
    { 0x093C, "Intrepid Control Systems, Inc."  },
    { 0x093D, "InnoSync, Inc."  },
    { 0x093E, "J.S.T. Mfg. Co., Ltd."  },
    { 0x093F, "OLYMPIA Telecom Vertriebs GmbH"  },
    { 0x0940, "Japan Storage Battery Co., Ltd."  },
    { 0x0941, "Photobit Corporation"  },
    { 0x0942, "i2Go.com, LLC"  },
    { 0x0943, "HCL Technologies Ltd."  },
    { 0x0944, "KORG, Inc."  },
    { 0x0945, "PASCO Scientific"  },
    { 0x0946, "GEMSTAR TECHOLOGY DEVELOPMENT LIMITED"  },
    { 0x0947, "Videonics, Inc."  },
    { 0x0948, "Kronauer Music In Digital"  },
    { 0x0949, "Hitachi Kokusai Electric Inc."  },
    { 0x094A, "Luckytech Technology Co., Ltd"  },
    { 0x094B, "Linkup Systems Corporation"  },
    { 0x094C, "Metanetics Corporation"  },
    { 0x094D, "Cable Television Laboratories"  },
    { 0x094E, "Head Acoustics"  },
    { 0x094F, "Yano Electric Co., Ltd."  },
    { 0x0950, "TechniSat Sateliltenfernsehprodukte Gmbh"  },
    { 0x0951, "Kingston Technology Company"  },
    { 0x0952, "DCOM Enterprise Co., Ltd."  },
    { 0x0953, "PLG"  },
    { 0x0954, "RPM Systems Corporation"  },
    { 0x0955, "NVIDIA"  },
    { 0x0956, "BSquare Corporation"  },
    { 0x0957, "Agilent Technologies, Inc."  },
    { 0x0958, "BioLink Technologies International, Inc."  },
    { 0x0959, "Cologne Chip AG"  },
    { 0x095A, "Portsmith"  },
    { 0x095B, "Medialogic Corporation"  },
    { 0x095C, "K-Tec Electronics"  },
    { 0x095D, "Polycom, Inc."  },
    { 0x095E, "USB Design Labs"  },
    { 0x095F, "TTO Engineering"  },
    { 0x0960, "Bcom Electronics, Inc."  },
    { 0x0961, "Portatec Corporation"  },
    { 0x0962, "SAMx"  },
    { 0x0963, "Instrument Solutions"  },
    { 0x0964, "Bitran Corporation"  },
    { 0x0965, "PAR Technologies, Inc."  },
    { 0x0966, "HanGo Electronics Co., Ltd."  },
    { 0x0967, "Acer NeWeb Corporation"  },
    { 0x0969, "Magellan Corp."  },
    { 0x096A, "Koizumi Computer, Inc."  },
    { 0x096B, "ML Electronics Ltd."  },
    { 0x096C, "GOPEL electronic GmbH"  },
    { 0x096D, "PennyLan"  },
    { 0x096E, "Feitian Technologies Co., Ltd."  },
    { 0x096F, "Memory Link"  },
    { 0x0970, "K.S. Vector Co., Ltd."  },
    { 0x0971, "GretagMacbeth AG"  },
    { 0x0972, "Musicbird"  },
    { 0x0973, "Axalto"  },
    { 0x0974, "Eye Communication Systems, Inc"  },
    { 0x0975, "OL'E Communications, Inc."  },
    { 0x0976, "Adirondack Wire & Cable"  },
    { 0x0977, "Lightsurf Technologies"  },
    { 0x0978, "Beckhoff Gmbh"  },
    { 0x0979, "Jeilin Technology Corp., Ltd."  },
    { 0x097A, "Minds At Work LLC"  },
    { 0x097B, "Knudsen Engineering Limited"  },
    { 0x097C, "Marunix Co., Ltd."  },
    { 0x097D, "Rosun Technologies, Inc."  },
    { 0x097E, "Biopac Systems Inc."  },
    { 0x097F, "Barun Electronics Co. Ltd."  },
    { 0x0980, "Posh Mfg. Ltd."  },
    { 0x0981, "Oak Technology Ltd."  },
    { 0x0982, "Covadis S.A."  },
    { 0x0983, "Nissha Printing Co., Ltd."  },
    { 0x0984, "Apricorn"  },
    { 0x0985, "Cab Produkttechnik"  },
    { 0x0986, "Panasonic Electric Works Co., Ltd."  },
    { 0x0987, "MicroSpeed Inc"  },
    { 0x0988, "Teraoka Seiko Co. Ltd"  },
    { 0x0989, "Digitel Co. LTD"  },
    { 0x098A, "Neopost"  },
    { 0x098B, "Kingtel Telecommunication Corp."  },
    { 0x098C, "Vitana Corporation"  },
    { 0x098D, "INDesign"  },
    { 0x098E, "Integrated Intellectual Property Inc."  },
    { 0x098F, "TEXIO CORPORATION"  },
    { 0x0990, "General Instrument Corp."  },
    { 0x0992, "Bandai Co., Ltd."  },
    { 0x0993, "NuvoMedia, Inc."  },
    { 0x0994, "Dionex Softron GmbH"  },
    { 0x0995, "Simple Jet Technology Co., Ltd."  },
    { 0x0996, "Integrated Telecom Express, Inc."  },
    { 0x0997, "Xerox Corporation/Non-Networked Products"  },
    { 0x0998, "Atech Totalsolution Co., Ltd."  },
    { 0x0999, "Ocean Optics, Inc."  },
    { 0x099A, "ZIPPY TECHNOLOGY CORP."  },
    { 0x099B, "HIROTA SEISAKUSHO LTD."  },
    { 0x099C, "Florida Probe, Inc."  },
    { 0x099D, "NEC San-ei Instruments, Ltd."  },
    { 0x099E, "Trimble"  },
    { 0x099F, "Summa N.V."  },
    { 0x09A0, "Altec Computersysteme GmbH"  },
    { 0x09A1, "ELMO COMPANY, LIMITED"  },
    { 0x09A2, "Telemann Co., Ltd."  },
    { 0x09A3, "PairGain Technologies"  },
    { 0x09A4, "Contech Research, Inc."  },
    { 0x09A5, "VCON Telecommunications"  },
    { 0x09A6, "Poinchips"  },
    { 0x09A7, "Data Transmission Network Corp."  },
    { 0x09A8, "Lin Shiung Enterprise Co., Ltd."  },
    { 0x09A9, "Smart Card Technologies Co., Ltd."  },
    { 0x09AA, "Intersil Corporation"  },
    { 0x09AB, "Japan Cash Machine Co., Ltd."  },
    { 0x09AC, "DIGIGRAM"  },
    { 0x09AD, "The MITRE Corporation"  },
    { 0x09AE, "Tripp Lite"  },
    { 0x09AF, "G.i.N. mbH"  },
    { 0x09B0, "Fargo Electronics, Inc."  },
    { 0x09B1, "Ositech Communications Incorporated"  },
    { 0x09B2, "Franklin Electronic Publishers"  },
    { 0x09B3, "Simplex Solution Inc."  },
    { 0x09B4, "MDS Gateways"  },
    { 0x09B5, "Celltrix Technology Co., Ltd."  },
    { 0x09B6, "SmithMyers Communications Limited"  },
    { 0x09B7, "FAIRLIGHT ESP"  },
    { 0x09B8, "PhoeniX . Incorporated"  },
    { 0x09B9, "CentLand inc."  },
    { 0x09BA, "Chumtronix N.V."  },
    { 0x09BB, "Eule Industrie- & Datentechnik GmbH & Co. KG"  },
    { 0x09BC, "Audivo GmbH"  },
    { 0x09BD, "Haptix Creation Pte Ltd"  },
    { 0x09BE, "Prosisa Overseas LLC"  },
    { 0x09BF, "Auerswald GmbH & Co. KG"  },
    { 0x09C0, "Molecular Devices LLC"  },
    { 0x09C1, "ARRIS International"  },
    { 0x09C2, "NISCA Corporation"  },
    { 0x09C3, "ACTIVCARD, INC."  },
    { 0x09C4, "ACTiSYS Corporation"  },
    { 0x09C5, "Memory Corporation"  },
    { 0x09C6, "Inovatec S.p.A."  },
    { 0x09C7, "PUBCOMPANY s.r.l."  },
    { 0x09C8, "Carrot Systems Inc."  },
    { 0x09C9, "U.S. Digital Corp."  },
    { 0x09CA, "BMC Messsysteme GmbH"  },
    { 0x09CB, "Flir Systems"  },
    { 0x09CC, "Workbit Corporation"  },
    { 0x09CD, "Psion Connect Ltd."  },
    { 0x09CE, "City Electronics Ltd."  },
    { 0x09CF, "Electronics Testing Center, Taiwan"  },
    { 0x09D1, "NeoMagic Inc."  },
    { 0x09D2, "Vreelin Engineering Inc."  },
    { 0x09D3, "COM ONE"  },
    { 0x09D4, "Asahi Engineering Co., Ltd."  },
    { 0x09D5, "DigiTech"  },
    { 0x09D6, "Berkeley Varitronics Systems"  },
    { 0x09D7, "NovAtel Inc."  },
    { 0x09D8, "Elatec GmbH"  },
    { 0x09D9, "Jungo"  },
    { 0x09DA, "A-FOUR TECH CO., LTD."  },
    { 0x09DB, "Measurement Computing Corporation"  },
    { 0x09DC, "AIMEX Corporation"  },
    { 0x09DD, "Fellowes Inc."  },
    { 0x09DE, "ViQuest Technology"  },
    { 0x09DF, "Addonics Technologies Corp."  },
    { 0x09E0, "Johnson Matthey PLC, Trading as Tracerco"  },
    { 0x09E1, "Intellon Corporation"  },
    { 0x09E2, "Surface Imaging Systems (S.I.S.)"  },
    { 0x09E3, "WIZnet"  },
    { 0x09E4, "Unidata"  },
    { 0x09E5, "Jo-Dan International, Inc."  },
    { 0x09E6, "Silutia, Inc."  },
    { 0x09E7, "Real 3D, Inc."  },
    { 0x09E8, "AKAI professional M.I. Corp."  },
    { 0x09E9, "CHEN-SOURCE INC."  },
    { 0x09EA, "ShareCall Technologies"  },
    { 0x09EB, "Sonicbox, Inc."  },
    { 0x09EC, "COINT Multimedia Systems"  },
    { 0x09ED, "Viking Sewing Machines AB"  },
    { 0x09EE, "Jesmay Electronics Co., Ltd."  },
    { 0x09EF, "XITEL PTY Limited"  },
    { 0x09F0, "Perpetual Technologies, LLC"  },
    { 0x09F1, "Eshed Robotec"  },
    { 0x09F2, "hema Elektronik GmbH"  },
    { 0x09F3, "GoFlight, Inc."  },
    { 0x09F4, "Microlink Corporation"  },
    { 0x09F5, "ARESCOM"  },
    { 0x09F6, "RocketChips, Inc."  },
    { 0x09F7, "EDU-SCIENCE (H.K.) LIMITED"  },
    { 0x09F8, "SoftConnex Technologies, Inc."  },
    { 0x09F9, "Bay Associates"  },
    { 0x09FA, "Mtek Vision"  },
    { 0x09FB, "Altera"  },
    { 0x09FC, "Silicon Mountain Design"  },
    { 0x09FD, "MM - Manager Memory"  },
    { 0x09FE, "Goldteck International Inc."  },
    { 0x09FF, "Gain Technology Corp."  },
    { 0x0A00, "Liquid Audio"  },
    { 0x0A01, "ViA, Inc."  },
    { 0x0A02, "DIATECNIC"  },
    { 0x0A03, "Globe Wireless, Inc."  },
    { 0x0A04, "Star, Inc."  },
    { 0x0A05, "University of Kansas"  },
    { 0x0A06, "BSQUARE Slicon Valley"  },
    { 0x0A07, "Ontrak Control Systems Inc."  },
    { 0x0A08, "Lorenz GmbH"  },
    { 0x0A09, "Datadesk Technologies Inc."  },
    { 0x0A0A, "LIEWENTHAL ELECTRONICS LTD."  },
    { 0x0A0B, "Cybex Computer Products Corporation"  },
    { 0x0A0C, "MIRAD"  },
    { 0x0A0D, "VIPS France"  },
    { 0x0A0E, "AGFEO"  },
    { 0x0A0F, "Liesegang"  },
    { 0x0A10, "Combinova AB"  },
    { 0x0A11, "Xentec Incorporated"  },
    { 0x0A12, "Cambridge Silicon Radio Ltd."  },
    { 0x0A13, "Telebyte Inc."  },
    { 0x0A14, "Spacelabs Healthcare"  },
    { 0x0A15, "Scalar Corporation"  },
    { 0x0A16, "Trek Technology (S) Pte Ltd"  },
    { 0x0A17, "HOYA Corporation"  },
    { 0x0A18, "Heidelberger Druckmaschinen AG"  },
    { 0x0A19, "Hua Geng Technologies Inc."  },
    { 0x0A1A, "Astro-Med, Inc."  },
    { 0x0A1B, "Wolfvision GmbH"  },
    { 0x0A1C, "Micro Systemation AB"  },
    { 0x0A1D, "T-Nova Deutsche Telekom Innovationsgesellschaft"  },
    { 0x0A1E, "Netcraft (Pty) Ltd."  },
    { 0x0A1F, "Tesco Co."  },
    { 0x0A20, "SystemBase Co., Ltd."  },
    { 0x0A21, "Physio-Control, Inc."  },
    { 0x0A22, "Century Semiconductor USA, Inc."  },
    { 0x0A23, "NDS Technologies Israel Ltd."  },
    { 0x0A24, "Boca Design, Inc."  },
    { 0x0A25, "3M Germany"  },
    { 0x0A26, "Cyberware"  },
    { 0x0A27, "Datacard Group"  },
    { 0x0A28, "Ensure Technologies, Inc."  },
    { 0x0A29, "Marketcast"  },
    { 0x0A2A, "Fortune Electronics & Plastic (International) Ltd."  },
    { 0x0A2B, "Muller & Sebastiani Elektronik GmbH"  },
    { 0x0A2C, "Ak Modul Bus Computer GmbH"  },
    { 0x0A2D, "Advanced Measurement Technology"  },
    { 0x0A2E, "ONE-O-ONE iSOLUTIONS"  },
    { 0x0A2F, "Prime Systems, Inc."  },
    { 0x0A30, "WAW-Tronics"  },
    { 0x0A31, "Data System Co., Ltd."  },
    { 0x0A32, "Addatel ApS"  },
    { 0x0A33, "Intermind Inc."  },
    { 0x0A34, "TG3 Electronics, Inc."  },
    { 0x0A35, "Radikal Technologies"  },
    { 0x0A36, "GS Technical Support Center"  },
    { 0x0A37, "Concept Development"  },
    { 0x0A38, "I.R.I.S."  },
    { 0x0A39, "Gilat Satellite Networks Ltd."  },
    { 0x0A3A, "PentaMedia Co., Ltd."  },
    { 0x0A3B, "Hitachi Information Technology Co., Ltd."  },
    { 0x0A3C, "NTT DoCoMo,Inc."  },
    { 0x0A3D, "Varo Vision"  },
    { 0x0A3E, "REINHARDT System- und Messelectronic GmbH"  },
    { 0x0A3F, "Swissonic AG"  },
    { 0x0A40, "PaloDEx Group Oy"  },
    { 0x0A41, "SEKONIC corporation"  },
    { 0x0A42, "Medtronic Functional Diagnostics"  },
    { 0x0A43, "Boca Systems Inc."  },
    { 0x0A44, "TurboLinux"  },
    { 0x0A45, "Look&Say co., Ltd."  },
    { 0x0A46, "Davicom Semiconductor, Inc."  },
    { 0x0A47, "Hirose Electric Co., Ltd."  },
    { 0x0A48, "I/O Interconnect"  },
    { 0x0A4A, "propagamma kommunikation"  },
    { 0x0A4B, "Fujitsu Media Devices Limited"  },
    { 0x0A4C, "COMPUTEX Co., Ltd."  },
    { 0x0A4D, "Evolution Electronics Ltd."  },
    { 0x0A4E, "Steinberg Soft-und Hardware GmbH"  },
    { 0x0A4F, "Litton Systems Inc."  },
    { 0x0A50, "Mimaki Engineering Co., Ltd."  },
    { 0x0A51, "Sony Electronics Inc."  },
    { 0x0A52, "JEBSEE ELECTRONICS CO., LTD."  },
    { 0x0A53, "Portable Peripheral Co., Ltd."  },
    { 0x0A54, "Applied Signal Technology, Inc."  },
    { 0x0A55, "ThermoQuest Corporation"  },
    { 0x0A56, "EAE electronics GmbH"  },
    { 0x0A57, "Joachim Koopmann Software"  },
    { 0x0A58, "DIGIDENT LTD."  },
    { 0x0A59, "Convergence Instruments"  },
    { 0x0A5B, "EASICS NV"  },
    { 0x0A5C, "Broadcom Corp."  },
    { 0x0A5D, "Diatrend Corporation"  },
    { 0x0A5E, "Spinnaker Systems Inc."  },
    { 0x0A5F, "Zebra Technologies"  },
    { 0x0A60, "Future Networks, Inc."  },
    { 0x0A61, "DTI sa"  },
    { 0x0A62, "MPMan.com, Inc."  },
    { 0x0A63, "Prism Media Products Ltd."  },
    { 0x0A64, "Padcom Inc."  },
    { 0x0A65, "FullAudio, Inc."  },
    { 0x0A66, "ClearCube Technology"  },
    { 0x0A67, "Medeli Electronics Co, Ltd."  },
    { 0x0A68, "COMAIDE Corporation"  },
    { 0x0A69, "Chroma ate Inc."  },
    { 0x0A6A, "Newcom Inc."  },
    { 0x0A6B, "Green House Co., Ltd."  },
    { 0x0A6C, "Integrated Circuit Systems Inc."  },
    { 0x0A6D, "UPS Manufacturing"  },
    { 0x0A6E, "Benwin"  },
    { 0x0A6F, "Core Technology, Inc."  },
    { 0x0A70, "International Game Technology"  },
    { 0x0A71, "VIPColor Technologies USA, Inc."  },
    { 0x0A72, "Sanwa Denshi"  },
    { 0x0A73, "SYDEC N.V."  },
    { 0x0A74, "Adaptive Networks, Inc."  },
    { 0x0A75, "Jeol USA, Inc."  },
    { 0x0A76, "I-Jam Multi-Media, LLC"  },
    { 0x0A77, "Janome Sewing Machine Co., Ltd."  },
    { 0x0A78, "GREATSUN"  },
    { 0x0A79, "Geocast Network Systems, Inc."  },
    { 0x0A7A, "Towitoko AG"  },
    { 0x0A7B, "R & D Co., Ltd."  },
    { 0x0A7C, "QUANCOM Informationssysteme GmbH"  },
    { 0x0A7D, "Intertek NSTL"  },
    { 0x0A7E, "Octagon Systems Corporation"  },
    { 0x0A7F, "AVerMedia MicroSystems"  },
    { 0x0A80, "Rexon Technology Corp., Ltd"  },
    { 0x0A81, "CHESEN ELECTRONICS CORP."  },
    { 0x0A82, "SYSCAN"  },
    { 0x0A83, "NextComm, Inc."  },
    { 0x0A84, "Maui Innovative Peripherals"  },
    { 0x0A85, "IDEXX LABS"  },
    { 0x0A86, "NITGen Co., Ltd."  },
    { 0x0A87, "Tucker-Davis Technologies, Inc."  },
    { 0x0A88, "PAH-RAN TECH., INC."  },
    { 0x0A89, "Active Company"  },
    { 0x0A8A, "American Magnetics"  },
    { 0x0A8B, "Intelliworxx Inc."  },
    { 0x0A8C, "Tecmar"  },
    { 0x0A8D, "Picturetel"  },
    { 0x0A8E, "Japan Aviation Electronics Industry Ltd. (JAE)"  },
    { 0x0A8F, "Young Chang Co. Ltd."  },
    { 0x0A90, "Candy Technology Co., Ltd."  },
    { 0x0A91, "Globlink Technology Inc."  },
    { 0x0A92, "EGO SYStems Inc."  },
    { 0x0A93, "C Technologies AB (publ)"  },
    { 0x0A94, "Intersense"  },
    { 0x0A95, "Origin Instruments Corporation"  },
    { 0x0A96, "Evation.com"  },
    { 0x0A97, "Guardware Systems Ltd."  },
    { 0x0A98, "TECHNO ART CO., LTD"  },
    { 0x0A99, "Talon Technology"  },
    { 0x0A9A, "Business Navigator"  },
    { 0x0A9B, "Input/Output Inc."  },
    { 0x0A9C, "Applied Cytometry Systems"  },
    { 0x0A9D, "Jung & Dusch GmbH"  },
    { 0x0A9E, "Performance Concepts, Inc."  },
    { 0x0A9F, "Sim-Addicts Design Group"  },
    { 0x0AA0, "Vtech Communications Ltd."  },
    { 0x0AA1, "Amer.com"  },
    { 0x0AA2, "Delta Tau Data Systems, Inc."  },
    { 0x0AA3, "Lava Computer Mfg. Inc."  },
    { 0x0AA4, "Develco Elektronik"  },
    { 0x0AA5, "First International Digital"  },
    { 0x0AA6, "Perception Digital Limited"  },
    { 0x0AA7, "Wincor Nixdorf GmbH & Co KG"  },
    { 0x0AA8, "TriGem Computer, Inc."  },
    { 0x0AA9, "Baromtec Co."  },
    { 0x0AAA, "Japan CBM Corporation"  },
    { 0x0AAB, "Vision Shape Europe SA."  },
    { 0x0AAC, "iCompression Inc."  },
    { 0x0AAD, "Rohde & Schwarz GmbH & Co. KG"  },
    { 0x0AAE, "NEC infrontia Corporation"  },
    { 0x0AAF, "digitalway co., ltd."  },
    { 0x0AB0, "Arrow Strong Electronics CO. LTD"  },
    { 0x0AB1, "Feig Electronic GmbH"  },
    { 0x0AB2, "Sintefex Audio LDA"  },
    { 0x0AB3, "CANON FINETECH INC."  },
    { 0x0AB4, "esd electronic system design gmbh"  },
    { 0x0AB5, "Beckman Coulter, Inc."  },
    { 0x0AB6, "Labsystems Oy"  },
    { 0x0AB7, "Cross electronics, inc."  },
    { 0x0AB8, "TelePhotogenics, Inc."  },
    { 0x0AB9, "Identcode Ltd."  },
    { 0x0ABA, "University of Geneva"  },
    { 0x0ABB, "Travsys BV"  },
    { 0x0ABC, "Life-Tech, Inc."  },
    { 0x0ABD, "Wako Rubber Industries Co., Ltd."  },
    { 0x0ABE, "STEREOLINK.COM"  },
    { 0x0ABF, "DeVaSys"  },
    { 0x0AC0, "Nidek Co., Ltd."  },
    { 0x0AC1, "MicroDatec GmbH"  },
    { 0x0AC2, "BrainMaster Technologies, Inc."  },
    { 0x0AC3, "ON Semiconductor (System Solutions Co., Ltd)"  },
    { 0x0AC4, "LECO CORPORATION"  },
    { 0x0AC5, "I & C Corporation"  },
    { 0x0AC6, "Singing Electrons, Inc."  },
    { 0x0AC7, "Panwest Corporation"  },
    { 0x0AC8, "Vimicro Corporation"  },
    { 0x0AC9, "Micro Solutions, Inc."  },
    { 0x0ACA, "The Open Group"  },
    { 0x0ACB, "DEICY CORPORATION"  },
    { 0x0ACC, "Koga Electronics Co."  },
    { 0x0ACD, "ID Tech"  },
    { 0x0ACE, "ZyDAS Technology Corporation"  },
    { 0x0ACF, "Intoto, Inc."  },
    { 0x0AD0, "Intellix Corp."  },
    { 0x0AD1, "Remotec Technology Ltd."  },
    { 0x0AD2, "Service & Quality Technology Co., Ltd."  },
    { 0x0AD3, "Bolton Engineering, Inc."  },
    { 0x0AD4, "TIGEREX ENTERPRISE CO., LTD."  },
    { 0x0AD5, "kuwatec, Inc."  },
    { 0x0AD6, "Vir A/S"  },
    { 0x0AD7, "Lynium L.L.C."  },
    { 0x0AD8, "Aidonic Corporation"  },
    { 0x0AD9, "Avolites Ltd."  },
    { 0x0ADA, "Data Encryption Systems Ltd"  },
    { 0x0ADB, "T.A.M. Co., Ltd."  },
    { 0x0ADC, "KE Knestel Elektronik GmbH"  },
    { 0x0ADD, "Alliance Distribution"  },
    { 0x0ADE, "Microft Co., Ltd."  },
    { 0x0ADF, "Arial Phone L.L.C."  },
    { 0x0AE0, "Collins Medical"  },
    { 0x0AE1, "Protein Solutions, Inc."  },
    { 0x0AE2, "NERA SATCOM ASA"  },
    { 0x0AE3, "Allion Labs, Inc."  },
    { 0x0AE4, "Taito Corporation"  },
    { 0x0AE5, "MacroSystem Digital Video AG"  },
    { 0x0AE6, "EVI, Inc."  },
    { 0x0AE7, "Neodym Systems Inc."  },
    { 0x0AE8, "System Support Co., Ltd."  },
    { 0x0AE9, "North Shore Circuit Design L.L.P."  },
    { 0x0AEA, "SciEssence, LLC"  },
    { 0x0AEB, "TTP Communications Ltd."  },
    { 0x0AEC, "Neodio Technologies Corporation"  },
    { 0x0AED, "ScottCare Corporation"  },
    { 0x0AEE, "Max Co., Ltd."  },
    { 0x0AEF, "Simple Systems, Ltd."  },
    { 0x0AF0, "Option NV"  },
    { 0x0AF1, "KYOEI Co., Ltd."  },
    { 0x0AF2, "CARTS, LLC"  },
    { 0x0AF3, "Scale Master Technology, LLC."  },
    { 0x0AF4, "ARTRONICS CO. LTD"  },
    { 0x0AF5, "Nakamichi"  },
    { 0x0AF6, "SILVER I CO., LTD."  },
    { 0x0AF7, "B2C2, Inc."  },
    { 0x0AF8, "Taiwan Regular Electronics Co., Ltd."  },
    { 0x0AF9, "NEW AFA TECHNOLOGY CO., LTD"  },
    { 0x0AFA, "DMC Co., Ltd."  },
    { 0x0AFB, "OO-ALC/TISMD-CAPRE"  },
    { 0x0AFC, "Zaptronix Ltd"  },
    { 0x0AFD, "Tateno Dennou, Inc."  },
    { 0x0AFE, "Cummins Engine Company"  },
    { 0x0AFF, "Jump Zone Network Products, Inc."  },
    { 0x0B00, "INGENICO"  },
    { 0x0B01, "Techno-Holon Corporation"  },
    { 0x0B02, "Avery Weigh-Tronix"  },
    { 0x0B03, "ARCA TECHNOLOGIES, LTD."  },
    { 0x0B04, "EURESYS S.A."  },
    { 0x0B05, "ASUSTek Computer Inc."  },
    { 0x0B06, "Digital Ink, Inc."  },
    { 0x0B07, "Telebau GmbH"  },
    { 0x0B08, "Lightwell Co., Ltd ZAX Division"  },
    { 0x0B09, "Allophonic Electronics L.t.d."  },
    { 0x0B0A, "FARO Technologies INC."  },
    { 0x0B0B, "Datamax Corporation"  },
    { 0x0B0C, "Todos Data System AB"  },
    { 0x0B0D, "Project Lab"  },
    { 0x0B0E, "GN Audio"  },
    { 0x0B0F, "AVID Technology"  },
    { 0x0B10, "Pcally"  },
    { 0x0B11, "I Tech Solutions Co., Ltd."  },
    { 0x0B12, "T-Metrics, Inc."  },
    { 0x0B13, "Practical Micro Design, Inc."  },
    { 0x0B14, "Real Sport, Inc."  },
    { 0x0B15, "Actia Do Brasil Ind. E. Com. Ltda."  },
    { 0x0B16, "onscreen24"  },
    { 0x0B17, "Scantron Corporation"  },
    { 0x0B18, "Shimizu Works, Hitachi Air Conditioning Systems Co"  },
    { 0x0B19, "Color Kinetics Inc."  },
    { 0x0B1B, "Bematech Ind. Com. Equip. Elect. S.A."  },
    { 0x0B1C, "York Electronics Centre"  },
    { 0x0B1D, "Erich Jaeger GmbH"  },
    { 0x0B1E, "Electronic Warfare Associates, Inc. (EWA)"  },
    { 0x0B1F, "Insyde Software Corp."  },
    { 0x0B20, "TransDimension Inc."  },
    { 0x0B21, "Yokogawa Electric Corporation"  },
    { 0x0B22, "Japan System Development Co. Ltd."  },
    { 0x0B23, "Pan-Asia Electronics Co., Ltd."  },
    { 0x0B24, "ITX E-Globaledge Corporation"  },
    { 0x0B25, "Advanced Programming Concepts, Inc."  },
    { 0x0B26, "Applied Scientific Instrumentation Inc."  },
    { 0x0B27, "Ritek Corporation"  },
    { 0x0B28, "Kenwood Corporation"  },
    { 0x0B29, "Intertex Data AB"  },
    { 0x0B2A, "Glotrex Co., Ltd."  },
    { 0x0B2C, "Village Center, Inc."  },
    { 0x0B2D, "Akatsuki Electronic work & study Corp."  },
    { 0x0B2E, "CTL Inc."  },
    { 0x0B2F, "Clarkspur Design, Inc."  },
    { 0x0B30, "NewHeights Software"  },
    { 0x0B31, "Kyowa Electronic Instruments Co., Ltd."  },
    { 0x0B32, "Utrecht University MBF"  },
    { 0x0B33, "Contour Design, Inc."  },
    { 0x0B34, "KNP Technologies"  },
    { 0x0B35, "Solutions Cubed"  },
    { 0x0B36, "Iizuna Signal Processing Lab Inc."  },
    { 0x0B37, "Hitachi ULSI Systems Co., Ltd."  },
    { 0x0B39, "Omnidirectional Control Technology Inc."  },
    { 0x0B3A, "IPaxess"  },
    { 0x0B3B, "Bromax Communications, Inc."  },
    { 0x0B3C, "Olivetti S.p.A"  },
    { 0x0B3E, "Kikusui Electronics Corporation"  },
    { 0x0B3F, "Mitec Systems, Inc."  },
    { 0x0B40, "RF Solutions Ltd."  },
    { 0x0B41, "Hal Corporation"  },
    { 0x0B42, "LENZE GmbH & Co KG"  },
    { 0x0B43, "Sixth Avenue Designs"  },
    { 0x0B44, "Programa Tools, Inc."  },
    { 0x0B45, "Event Electronics, LLC"  },
    { 0x0B46, "Nuark Co., Ltd."  },
    { 0x0B47, "Sportbug.com, Inc"  },
    { 0x0B48, "TechnoTrend AG"  },
    { 0x0B49, "ASCII Corporation"  },
    { 0x0B4A, "Pocket Pyro, Inc."  },
    { 0x0B4B, "XFX Creation Inc."  },
    { 0x0B4C, "Comvurgent"  },
    { 0x0B4D, "Graphtec"  },
    { 0x0B4E, "Musical Electronics Ltd."  },
    { 0x0B4F, "Neuralog, Inc."  },
    { 0x0B50, "Starlight Marketing (H.K.) Ltd."  },
    { 0x0B51, "USB KITS"  },
    { 0x0B52, "Zight Corporation"  },
    { 0x0B54, "Sinbon Electronics Co., Ltd."  },
    { 0x0B55, "Sendtek Corporation"  },
    { 0x0B56, "TYI Systems Ltd."  },
    { 0x0B57, "Hanwang Technology Co., LTD."  },
    { 0x0B59, "Lake Communications Ltd."  },
    { 0x0B5A, "Corel Corporation"  },
    { 0x0B5B, "Anritsu Corporation"  },
    { 0x0B5C, "IDEAL Industries Inc."  },
    { 0x0B5D, "Music Playground Inc."  },
    { 0x0B5E, "Luciol Instruments"  },
    { 0x0B5F, "Green Electronics Co., Ltd."  },
    { 0x0B60, "SiConnect Ltd."  },
    { 0x0B61, "NEC Display Solutions, Ltd."  },
    { 0x0B62, "Orange Micro, Inc."  },
    { 0x0B63, "ADLink Technology Inc."  },
    { 0x0B64, "Wonderful Wire Cable Co., Ltd"  },
    { 0x0B65, "Expert Magnetics Corp."  },
    { 0x0B66, "Cybiko Inc."  },
    { 0x0B67, "Fairbanks Scales"  },
    { 0x0B68, "SenDEC Corporation"  },
    { 0x0B69, "CacheVision"  },
    { 0x0B6A, "Maxim Integrated Products"  },
    { 0x0B6B, "Ashling Microsystems Ltd."  },
    { 0x0B6C, "FreeSystems Pte Ltd"  },
    { 0x0B6D, "The Graphics Network Limited"  },
    { 0x0B6E, "Neurosoft, Inc."  },
    { 0x0B6F, "Nagano Japan Radio Co., Ltd"  },
    { 0x0B70, "PortalPlayer, Inc."  },
    { 0x0B71, "SHIN-EI Sangyo Co., Ltd."  },
    { 0x0B72, "Embedded Wireless Technology Co. Ltd."  },
    { 0x0B73, "Computone Corp."  },
    { 0x0B75, "Roland DG Corporation"  },
    { 0x0B76, "Pro-Tech Services Inc."  },
    { 0x0B77, "RJS, Inc."  },
    { 0x0B78, "ATSKY"  },
    { 0x0B79, "Sunrise Telecom, Inc."  },
    { 0x0B7A, "Zeevo, Inc."  },
    { 0x0B7B, "Taiko Denki Co., Ltd."  },
    { 0x0B7C, "ITRAN Communications Ltd."  },
    { 0x0B7D, "Astrodesign, Inc."  },
    { 0x0B7E, "Kurusugawa Electronics Incorporate"  },
    { 0x0B7F, "Scantech BV"  },
    { 0x0B80, "Omtronix Engineering Corp."  },
    { 0x0B81, "id3 Semiconductors"  },
    { 0x0B82, "TravRoute, a division of ALK Associates, Inc."  },
    { 0x0B83, "OCTAX Microscience"  },
    { 0x0B84, "Rextron Technology, Inc."  },
    { 0x0B85, "Elkat Electronics (M) SDN. BHD."  },
    { 0x0B86, "Exputer Systems, Inc."  },
    { 0x0B87, "Plus-One I & T Inc."  },
    { 0x0B88, "Sigma Koki Co., Ltd. Technology Center"  },
    { 0x0B89, "Advanced Digital Broadcast Ltd."  },
    { 0x0B8A, "YARC Systems Corporation"  },
    { 0x0B8B, "American Microsystems, Ltd."  },
    { 0x0B8C, "SMART Technologies Inc."  },
    { 0x0B8D, "Microsystems Development Technologies, Inc."  },
    { 0x0B8E, "Dartcom"  },
    { 0x0B8F, "Visual Environment"  },
    { 0x0B90, "DACTRON INC."  },
    { 0x0B91, "DesignTech International, Inc."  },
    { 0x0B92, "SINAR AG"  },
    { 0x0B93, "Marantz Japan, Inc."  },
    { 0x0B94, "NEOREX Co., Ltd."  },
    { 0x0B95, "ASIX Electronics Corporation"  },
    { 0x0B96, "SEWON TELECOM"  },
    { 0x0B97, "O2Micro, Inc."  },
    { 0x0B98, "Playmates Toys Inc."  },
    { 0x0B99, "Audio International, Inc."  },
    { 0x0B9A, "Namco Limited"  },
    { 0x0B9B, "Dipl.-Ing. Stefan Kunde"  },
    { 0x0B9C, "Melco Embroidery Systems"  },
    { 0x0B9D, "Softprotec Co."  },
    { 0x0B9E, "Asylum Research"  },
    { 0x0B9F, "Chippo Technologies"  },
    { 0x0BA0, "Turtle Industry Co., Ltd."  },
    { 0x0BA1, "Jowit Company Limited"  },
    { 0x0BA2, "Line Media Research CO., LTD."  },
    { 0x0BA3, "Taiko Electric Works, Ltd."  },
    { 0x0BA4, "Nagano Oki Electric Co., Ltd."  },
    { 0x0BA5, "Clemex Technologies Inc."  },
    { 0x0BA6, "3DM Devices Inc"  },
    { 0x0BA7, "CVC Networks Co., Ltd."  },
    { 0x0BA8, "CastleNet Technology Inc."  },
    { 0x0BA9, "Misawa Homes Co., Ltd."  },
    { 0x0BAA, "Dr. Gerhard Schmidt GmbH"  },
    { 0x0BAB, "House Ear Institute"  },
    { 0x0BAC, "Biometric Access Corporation"  },
    { 0x0BAD, "Festo Didactic Ltd/Ltee"  },
    { 0x0BAE, "IGEN International, Inc."  },
    { 0x0BAF, "U.S. Robotics"  },
    { 0x0BB0, "Concord Camera Corp."  },
    { 0x0BB1, "Infinilink Corporation"  },
    { 0x0BB2, "Ambit Microsystems Corporation"  },
    { 0x0BB3, "Ofuji Technology"  },
    { 0x0BB4, "HTC Corporation"  },
    { 0x0BB5, "Murata Manufacturing Co., Ltd."  },
    { 0x0BB6, "Network Alchemy"  },
    { 0x0BB7, "Joytech Computer Company Limited"  },
    { 0x0BB8, "Renesas Technology Sales Co., Ltd."  },
    { 0x0BB9, "Eiger M & C CO., LTD."  },
    { 0x0BBA, "ZACCESS Systems"  },
    { 0x0BBB, "General Meters Corporation"  },
    { 0x0BBC, "Assistive Technology, Inc."  },
    { 0x0BBD, "System Connection, Inc"  },
    { 0x0BBE, "ShibaSoku Co., Ltd."  },
    { 0x0BBF, "Algo Communication Products Ltd."  },
    { 0x0BC0, "Knilink Technology Inc."  },
    { 0x0BC1, "FUW YNG ELECTRONICS COMPANY LTD"  },
    { 0x0BC2, "Seagate Technology LLC"  },
    { 0x0BC3, "IPWireless, Inc."  },
    { 0x0BC4, "Microcube Corp."  },
    { 0x0BC5, "JCN Co., Ltd."  },
    { 0x0BC6, "ExWAY Inc."  },
    { 0x0BC7, "X10 Wireless Technology, Inc."  },
    { 0x0BC8, "Telmax Communications"  },
    { 0x0BC9, "ECI Telecom Ltd"  },
    { 0x0BCA, "Startek Engineering Incorporated"  },
    { 0x0BCB, "Perfect Technic Enterprise Co. LTD"  },
    { 0x0BCC, "Dolphin Interactive"  },
    { 0x0BCD, "Mbeware Inc."  },
    { 0x0BCE, "I-TEC hanshin Incorporated Company"  },
    { 0x0BCF, "Chuo-Engineering Ltd."  },
    { 0x0BD0, "Trenz Electronic"  },
    { 0x0BD1, "Blue Sky Labs, Inc."  },
    { 0x0BD2, "Union Biometrica"  },
    { 0x0BD3, "OPHIR OPTRONICS LTD"  },
    { 0x0BD4, "NISSIN INC."  },
    { 0x0BD5, "Rabbit House Corporation"  },
    { 0x0BD6, "Renaissance Learning Inc."  },
    { 0x0BD7, "Andrew Pargeter & Associates"  },
    { 0x0BD8, "Gamry Instruments, Inc."  },
    { 0x0BD9, "Liberty Instruments, Inc."  },
    { 0x0BDA, "Realtek Semiconductor Corp."  },
    { 0x0BDB, "Ericsson AB"  },
    { 0x0BDC, "Y Media Corporation"  },
    { 0x0BDD, "Orange PCS"  },
    { 0x0BDE, "Thuris Corporation"  },
    { 0x0BDF, "PopcomNet Co., Ltd"  },
    { 0x0BE0, "Silicon Magic Co., LTD"  },
    { 0x0BE1, "COM DEV Wireless"  },
    { 0x0BE2, "Kanda Tsushin Kogyo Co., LTD"  },
    { 0x0BE3, "TOYO Corporation"  },
    { 0x0BE4, "Elka International Ltd."  },
    { 0x0BE5, "DOME Imaging Systems, Inc"  },
    { 0x0BE6, "Wonderful Photoelectricity (DongGuan), Co., Ltd."  },
    { 0x0BE7, "Zanthic Technologies Inc."  },
    { 0x0BE8, "M@inNet Communication"  },
    { 0x0BE9, "Realistic Interactive, Inc."  },
    { 0x0BEA, "Bryce Office Systems"  },
    { 0x0BEB, "RPA Electronics Design, LLC"  },
    { 0x0BEC, "Idaho Technology"  },
    { 0x0BED, "MEI, Inc."  },
    { 0x0BEE, "LTK International Limited"  },
    { 0x0BEF, "Way2Call Communications"  },
    { 0x0BF0, "Pace Micro Technology PLC"  },
    { 0x0BF1, "Intracom S.A."  },
    { 0x0BF2, "Konexx"  },
    { 0x0BF3, "CTI Co., Ltd."  },
    { 0x0BF4, "Kuraya-Sanseido Co., Ltd."  },
    { 0x0BF5, "Xactex Corporation"  },
    { 0x0BF6, "Addonics Technologies, Inc."  },
    { 0x0BF7, "Sunny Giken Inc."  },
    { 0x0BF8, "Fujitsu Technology Solutions GmbH"  },
    { 0x0BF9, "QPICT, Inc."  },
    { 0x0BFA, "NKE Corporation"  },
    { 0x0BFB, "Grass Valley Group"  },
    { 0x0BFC, "Zero Mass Products Inc."  },
    { 0x0BFD, "KVASER AB"  },
    { 0x0BFE, "Morphy Planning & Co., Ltd"  },
    { 0x0BFF, "Damotech Inc."  },
    { 0x0C00, "ATM Computer"  },
    { 0x0C01, "K-One Telecom Co., Ltd."  },
    { 0x0C02, "Shinko Seisakusho Co., LTD"  },
    { 0x0C03, "SAXA Inc."  },
    { 0x0C04, "MOTO Development Group, Inc."  },
    { 0x0C05, "Appian Graphics"  },
    { 0x0C06, "Hasbro, Inc."  },
    { 0x0C07, "Infinite Data Storage LTD"  },
    { 0x0C08, "ei Corporation"  },
    { 0x0C09, "Comjet Information System"  },
    { 0x0C0A, "Highpoint Technologies, Inc."  },
    { 0x0C0B, "Dura Micro, Inc."  },
    { 0x0C0C, "OPTIKON 2000 S.P.A."  },
    { 0x0C0D, "Callify Communications & Software Ltd."  },
    { 0x0C0E, "Korea eBook Inc."  },
    { 0x0C0F, "IDS Innomic GmbH"  },
    { 0x0C10, "Silicon Wave"  },
    { 0x0C11, "Multigon Industries"  },
    { 0x0C12, "Zeroplus Technology Co; LTD"  },
    { 0x0C13, "Orion Electronics International"  },
    { 0x0C14, "Parallel Technologies, Inc."  },
    { 0x0C15, "Iris Graphics"  },
    { 0x0C16, "Gyration, Inc."  },
    { 0x0C17, "Cyberboard A/S"  },
    { 0x0C18, "SynerTek Korea, Inc."  },
    { 0x0C19, "cyberPIXIE, Inc."  },
    { 0x0C1A, "Silicon Motion, Inc."  },
    { 0x0C1B, "MIPS TECHNOLOGIES"  },
    { 0x0C1C, "Hang Zhou Silan Microelectronics Co. Ltd"  },
    { 0x0C1D, "Digital Audio Corporation"  },
    { 0x0C1E, "TAKAYA CORP."  },
    { 0x0C1F, "Magicard Ltd"  },
    { 0x0C20, "Viditec Inc."  },
    { 0x0C21, "Lunatronic"  },
    { 0x0C22, "TallyGenicom LP"  },
    { 0x0C23, "Lernout + Hauspie (L + H)"  },
    { 0x0C24, "Taiyo Yuden Co., Ltd."  },
    { 0x0C25, "Sampo Corporation"  },
    { 0x0C26, "Icom Inc."  },
    { 0x0C27, "RF Ideas"  },
    { 0x0C28, "ICCC"  },
    { 0x0C29, "SOGECLAIR aerospace"  },
    { 0x0C2A, "AFP Imaging Corp."  },
    { 0x0C2B, "AT system"  },
    { 0x0C2C, "Controller Technologies Corporation"  },
    { 0x0C2D, "Scientific Data Systems, Inc."  },
    { 0x0C2E, "Honeywell Scanning & Mobility"  },
    { 0x0C2F, "Starcover GmbH"  },
    { 0x0C30, "MUTOH EUROPE N.V."  },
    { 0x0C31, "Cosmo Techs Co., Ltd."  },
    { 0x0C32, "Weibel Scientific A/S"  },
    { 0x0C33, "GN Otometrics A/S"  },
    { 0x0C34, "Interisa Electronica"  },
    { 0x0C35, "Eagletron Inc."  },
    { 0x0C36, "E INK CORPORATION"  },
    { 0x0C37, "e.Digital"  },
    { 0x0C38, "Der An Electric Wire & Cable Co. Ltd."  },
    { 0x0C39, "Aeroflex"  },
    { 0x0C3A, "Furui Precise Component (Kunshan) Co., Ltd"  },
    { 0x0C3B, "Komatsu Ltd."  },
    { 0x0C3C, "Radius Co., Ltd."  },
    { 0x0C3D, "Innocom, Inc."  },
    { 0x0C3E, "NEXTCELL INC."  },
    { 0x0C3F, "Street Smart Security"  },
    { 0x0C40, "Navini Networks, Inc"  },
    { 0x0C41, "findtheDOT"  },
    { 0x0C42, "OMAX Corporation"  },
    { 0x0C43, "BIOMETRIKA"  },
    { 0x0C44, "Motorola iDEN"  },
    { 0x0C45, "Sonix Technology Co., Ltd."  },
    { 0x0C46, "WaveRider Communications, Inc"  },
    { 0x0C47, "TECAN Group AG"  },
    { 0x0C48, "MARPOSS S.p.A."  },
    { 0x0C49, "Gigahertz-Optik GmbH"  },
    { 0x0C4A, "ALGE-TIMING GmbH & Co"  },
    { 0x0C4B, "REINER Kartengeraete GmbH & Co.KG"  },
    { 0x0C4C, "Needham's Electronics Inc"  },
    { 0x0C4D, "ICHIRO.ORG"  },
    { 0x0C4E, "Sonic Innovations, Inc."  },
    { 0x0C4F, "01dB-Stell"  },
    { 0x0C50, "Forvus Research Inc."  },
    { 0x0C51, "Trax Softworks, Inc."  },
    { 0x0C52, "Sealevel Systems, Inc."  },
    { 0x0C53, "ViewPLUS Inc."  },
    { 0x0C54, "GLORY LTD."  },
    { 0x0C55, "Spectrum Digital Inc."  },
    { 0x0C56, "Billion Bright (HK) Corporation Limited"  },
    { 0x0C57, "Imaginative Design Operation Co. Ltd."  },
    { 0x0C58, "Vidar Systems Corporation"  },
    { 0x0C59, "Dong Guan Shinko Wire Co., Ltd."  },
    { 0x0C5A, "TRS International Mfg., Inc."  },
    { 0x0C5B, "EDEC Co., Ltd."  },
    { 0x0C5C, "Obbligato Objectives"  },
    { 0x0C5D, "Musitronics GmbH"  },
    { 0x0C5E, "Xytronix Research & Design"  },
    { 0x0C5F, "WAVESYSTEMS"  },
    { 0x0C60, "Apogee Electronics Corporation"  },
    { 0x0C61, "Network Security Technology Co."  },
    { 0x0C62, "Chant Sincere Co., Ltd"  },
    { 0x0C63, "Toko, Inc."  },
    { 0x0C64, "Signality System Engineering Co., Ltd."  },
    { 0x0C65, "Eminence Enterprise Co., Ltd."  },
    { 0x0C66, "REXON ELECTRONICS CORP."  },
    { 0x0C67, "Concept Telecom Ltd"  },
    { 0x0C68, "Whanam Electronics Co., Ltd."  },
    { 0x0C69, "COMPUTechnic AG"  },
    { 0x0C6A, "Ackerman Computer Sciences"  },
    { 0x0C6B, "Spectrum Techniques, Inc"  },
    { 0x0C6C, "JETI Technische Instrumente GmbH"  },
    { 0x0C6D, "Aardvark"  },
    { 0x0C6E, "Zaxus Limited"  },
    { 0x0C6F, "SCC Research"  },
    { 0x0C70, "MCT Elektronikladen"  },
    { 0x0C71, "Fa. Hydrotechnik"  },
    { 0x0C72, "PEAK-System-Technik"  },
    { 0x0C73, "Omega Well Monitoring"  },
    { 0x0C74, "Optronic Laboratories, Inc."  },
    { 0x0C75, "Ripmax Plc"  },
    { 0x0C76, "Solid State System Co., Ltd."  },
    { 0x0C77, "SIPIX GROUP LIMITED"  },
    { 0x0C78, "Detto Corporation"  },
    { 0x0C79, "NuConnex Technologies PTE LTD"  },
    { 0x0C7A, "Wing-Span Enterprise Co., Ltd."  },
    { 0x0C7B, "Link Instruments, Inc."  },
    { 0x0C7C, "TMS International BV"  },
    { 0x0C7E, "KIRK telecom"  },
    { 0x0C7F, "SoftBaugh, Inc."  },
    { 0x0C80, "Optim Electronics"  },
    { 0x0C81, "Dragon State Ltd."  },
    { 0x0C82, "Impeccable Instruments, LLC"  },
    { 0x0C83, "Cylink"  },
    { 0x0C84, "Howell Instruments, Inc."  },
    { 0x0C85, "Lectra Systemes"  },
    { 0x0C86, "NDA Technologies, Inc."  },
    { 0x0C87, "Aubit, Ltd."  },
    { 0x0C88, "Kyocera Wireless Inc."  },
    { 0x0C89, "Honda Tsushin Kogyo Co., Ltd"  },
    { 0x0C8A, "Cast Lighting Limited"  },
    { 0x0C8B, "Wavefly Corporation"  },
    { 0x0C8C, "Coactive Networks"  },
    { 0x0C8D, "Greenlee Textron, Inc."  },
    { 0x0C8E, "Cesscom Co., Ltd."  },
    { 0x0C8F, "Applied Microsystems"  },
    { 0x0C90, "American Arium"  },
    { 0x0C91, "FPGA Information"  },
    { 0x0C92, "Nixvue Systems PTE LTD"  },
    { 0x0C93, "Alara Inc."  },
    { 0x0C94, "SAGEM Denmark"  },
    { 0x0C95, "Kyushu-Kyohan Co., Ltd."  },
    { 0x0C96, "TOPCON Positioning Systems"  },
    { 0x0C97, "GRE America, Inc."  },
    { 0x0C98, "Berkshire Products, Inc."  },
    { 0x0C99, "Innochips Co., Ltd."  },
    { 0x0C9A, "Hanool Robotics Corp"  },
    { 0x0C9B, "Jobin Yvon, Inc."  },
    { 0x0C9C, "Brand Innovators"  },
    { 0x0C9D, "DyOcean"  },
    { 0x0C9E, "PLEXUS MULTIMEDIA PTE LTD"  },
    { 0x0C9F, "Extenex Corporation"  },
    { 0x0CA0, "Robert Bosch GmbH - Automotive Aftermarket"  },
    { 0x0CA1, "Mentor Engineering, Inc."  },
    { 0x0CA2, "Zyfer"  },
    { 0x0CA3, "SEGA CORPORATION"  },
    { 0x0CA4, "ST&T INSTRUMENT CORP."  },
    { 0x0CA5, "BAE SYSTEMS CANADA INC."  },
    { 0x0CA6, "Castles Technology Co. Ltd."  },
    { 0x0CA7, "Information Systems Laboratories"  },
    { 0x0CA8, "Digital Audio Labs, Inc."  },
    { 0x0CA9, "Institut fuer Rundfunktechnik"  },
    { 0x0CAA, "Allied Telesis K.K."  },
    { 0x0CAB, "Melon Technos Co., Ltd."  },
    { 0x0CAC, "NEC Electronics (Europe) GmbH"  },
    { 0x0CAD, "Motorola Solutions"  },
    { 0x0CAE, "swissvoice ag"  },
    { 0x0CAF, "Buslink"  },
    { 0x0CB0, "Flying Pig Systems"  },
    { 0x0CB1, "Innovonics, Inc."  },
    { 0x0CB2, "Softmark"  },
    { 0x0CB3, "FitzSimons Automation"  },
    { 0x0CB4, "PalmMicro Communications, Inc."  },
    { 0x0CB5, "Esel International Company Ltd."  },
    { 0x0CB6, "Celestix Networks PTE LTD"  },
    { 0x0CB7, "Singatron Enterprise Co. Ltd."  },
    { 0x0CB8, "Opticis Co., Ltd."  },
    { 0x0CB9, "VTECH INFORMATIONS LTD."  },
    { 0x0CBA, "Trust Electronic (Shanghai) Co., Ltd."  },
    { 0x0CBB, "Shanghai Darong Electronics Co., Ltd."  },
    { 0x0CBC, "PALMAX Technology Co., Ltd."  },
    { 0x0CBD, "Pentel Co., Ltd. (Electronics Equipment Div.)"  },
    { 0x0CBE, "Keryx Technologies, Inc."  },
    { 0x0CBF, "Union Genius Computer Co., Ltd"  },
    { 0x0CC0, "Kuon Yi Industrial Corp."  },
    { 0x0CC2, "Timex Corporation"  },
    { 0x0CC3, "Rimage Corporation"  },
    { 0x0CC4, "emsys Embedded Systems GmbH"  },
    { 0x0CC5, "SENDO"  },
    { 0x0CC6, "INTERMAGIC CORP."  },
    { 0x0CC7, "Kontron Medical AG"  },
    { 0x0CC8, "Technotools Corporation"  },
    { 0x0CC9, "BroadMAX Technologies, Inc."  },
    { 0x0CCA, "Amphenol Corporation"  },
    { 0x0CCB, "SKNET CORPORATION LTD."  },
    { 0x0CCC, "DOMEX TECHNOLOGY CORPORATION"  },
    { 0x0CCD, "TerraTec Electronic GmbH"  },
    { 0x0CCE, "Optical Imaging Inc."  },
    { 0x0CCF, "T&D CORPORATION"  },
    { 0x0CD0, "Art Haven 9 Co., Ltd"  },
    { 0x0CD1, "Premier Technologies, Inc."  },
    { 0x0CD2, "C-MAP SRL"  },
    { 0x0CD3, "Pretorian Manufacturing Ltd"  },
    { 0x0CD4, "Amplex"  },
    { 0x0CD5, "Colorado Circuitworks, Inc."  },
    { 0x0CD6, "Scheldt & Bachmann GmbH"  },
    { 0x0CD7, "NEWCHIP S.r.l."  },
    { 0x0CD8, "JS Digitech, Inc."  },
    { 0x0CD9, "Shin Din Cable Ltd."  },
    { 0x0CDA, "INTERFACE K.K."  },
    { 0x0CDB, "OSMOOZE S.A."  },
    { 0x0CDC, "HIJI HIGH-TECH CO., LTD."  },
    { 0x0CDD, "Fidelica Microsystems, Inc."  },
    { 0x0CDE, "Z-Com INC."  },
    { 0x0CDF, "BUZZ-VC"  },
    { 0x0CE0, "ZAPEX Research Ltd."  },
    { 0x0CE1, "Pepperoni Light"  },
    { 0x0CE2, "Eltech Solutions Inc."  },
    { 0x0CE3, "MaxVision Corporation"  },
    { 0x0CE4, "JOOHONG"  },
    { 0x0CE5, "Hemisphere West"  },
    { 0x0CE6, "First Silicon Solutions, Inc."  },
    { 0x0CE7, "Bakker IT Services BV"  },
    { 0x0CE8, "Interflex Datensysteme GmbH"  },
    { 0x0CE9, "Pico Technology Limited"  },
    { 0x0CEA, "PRO TECH COMMUNICATIONS INC."  },
    { 0x0CEB, "Sophia Systems Co., Ltd."  },
    { 0x0CEC, "Cyverse Corp."  },
    { 0x0CED, "MAYCOM Audio Systems b.v."  },
    { 0x0CEE, "Gaitmat II"  },
    { 0x0CEF, "Contex A/S"  },
    { 0x0CF0, "Cadac Electronics plc."  },
    { 0x0CF1, "e-CONN ELECTRONIC CO., LTD."  },
    { 0x0CF2, "ENE Technology Inc."  },
    { 0x0CF3, "Qualcomm Atheros, Inc."  },
    { 0x0CF4, "Fomtex Corporation"  },
    { 0x0CF5, "Cellink Co., Ltd."  },
    { 0x0CF6, "Compucable Corporation"  },
    { 0x0CF7, "ishoni Networks"  },
    { 0x0CF8, "Clarisys Incorporated"  },
    { 0x0CF9, "Central System Research Co., Ltd."  },
    { 0x0CFA, "Inviso, Inc."  },
    { 0x0CFB, "SEnergy Corporation"  },
    { 0x0CFC, "Konica-Minolta"  },
    { 0x0CFD, "Hitex UK Ltd."  },
    { 0x0CFE, "L.J. Technical Systems Ltd."  },
    { 0x0CFF, "SAFA MEDIA CO., LTD."  },
    { 0x0D00, "Polar Instruments Ltd"  },
    { 0x0D01, "Red Bird LLC"  },
    { 0x0D02, "Vestibular Technolgies"  },
    { 0x0D03, "Triad Spectrum Ltd."  },
    { 0x0D04, "Addmaster Corporation"  },
    { 0x0D05, "Chung Nam Electronics Co. Ltd."  },
    { 0x0D06, "telos EDV Systementwicklung GmbH"  },
    { 0x0D07, "TAUREUS s.r.o."  },
    { 0x0D08, "UTStarcom (Hangzhou) Telecom Co., Ltd"  },
    { 0x0D09, "MMELECTRONICS"  },
    { 0x0D0A, "Colourfull Creations"  },
    { 0x0D0B, "Contemporary Controls"  },
    { 0x0D0C, "Astron Electronics Co., Ltd."  },
    { 0x0D0D, "MKNet Corporation"  },
    { 0x0D0E, "Hybrid Networks, Inc"  },
    { 0x0D0F, "Feng Shin Cable Co. Ltd."  },
    { 0x0D10, "Elastic Networks"  },
    { 0x0D11, "Maspro Denkoh Corp."  },
    { 0x0D12, "Hansol Electronics Inc."  },
    { 0x0D13, "BMF CORPORATION"  },
    { 0x0D14, "Array Comm, Inc."  },
    { 0x0D15, "OnStream b.v."  },
    { 0x0D16, "Hi-Touch Imaging Technologies Co., Ltd."  },
    { 0x0D17, "NALTEC, Inc."  },
    { 0x0D18, "coaXmedia"  },
    { 0x0D19, "Shanghai Hank Connection Co., Ltd."  },
    { 0x0D1A, "COMTECH SYSTEMS, INC"  },
    { 0x0D1B, "EC Engineering, LLC"  },
    { 0x0D1C, "MACSEMA, INC"  },
    { 0x0D1D, "GEMAC mbH"  },
    { 0x0D1E, "Eone Inc."  },
    { 0x0D1F, "imc MessSysteme GmbH"  },
    { 0x0D20, "Malcom Co., Ltd."  },
    { 0x0D22, "Rojone Pty Ltd"  },
    { 0x0D23, "SATAKE USA INC."  },
    { 0x0D24, "Trapper Data AB"  },
    { 0x0D25, "PENTTECH Engineering Systems AB"  },
    { 0x0D26, "Micro-Vu"  },
    { 0x0D27, "CLEARJET GmbH"  },
    { 0x0D28, "ARM Ltd"  },
    { 0x0D29, "Eng Resource Inc"  },
    { 0x0D2A, "FIELDSERVER TECHNOLOGIES"  },
    { 0x0D2B, "DAINIPPON SCREEN"  },
    { 0x0D2C, "3M Library Systems"  },
    { 0x0D2D, "GigaSysNet"  },
    { 0x0D2E, "Feedback Instruments Ltd"  },
    { 0x0D2F, "Andamiro Co., Ltd."  },
    { 0x0D30, "Vision Electronics Co., Ltd."  },
    { 0x0D31, "Arizona Cooperative Power"  },
    { 0x0D32, "Leo Hui Electric Wire & Cable Co., Ltd."  },
    { 0x0D33, "AirSpeak Inc."  },
    { 0x0D34, "Moxi Digital, Inc."  },
    { 0x0D35, "Dah Kun Co., Ltd."  },
    { 0x0D36, "Tellabs"  },
    { 0x0D37, "PRISM"  },
    { 0x0D38, "Nihon Culture-soft Service Co., Ltd."  },
    { 0x0D3A, "Posiflex Technologies, Inc."  },
    { 0x0D3B, "SANYO TECNICA Co., Ltd."  },
    { 0x0D3C, "SRI CABLE TECHNOLOGY LTD."  },
    { 0x0D3D, "TANGTOP TECHNOLOGY CO., LTD."  },
    { 0x0D3E, "Fitcom, inc."  },
    { 0x0D3F, "MTS Systems Corporation"  },
    { 0x0D40, "Ascor Inc."  },
    { 0x0D41, "Ta Yun Electronic Technology Co., Ltd."  },
    { 0x0D42, "FULL DER CO., LTD."  },
    { 0x0D43, "iCableSystem Co., Ltd."  },
    { 0x0D44, "AFG Elektronik GmbH"  },
    { 0x0D45, "Union Data Corporation"  },
    { 0x0D46, "KOBIL Systems GmbH"  },
    { 0x0D47, "KOPEK PACIFIC LTD."  },
    { 0x0D48, "PROMETHEAN"  },
    { 0x0D49, "Maxtor"  },
    { 0x0D4A, "NF Corporation"  },
    { 0x0D4B, "Grape Systems Inc."  },
    { 0x0D4C, "TEDAS AG"  },
    { 0x0D4D, "Coherent Inc."  },
    { 0x0D4E, "Agere Systems Netherland BV"  },
    { 0x0D4F, "EADS AIRBUS FRANCE"  },
    { 0x0D50, "Cleware GmbH"  },
    { 0x0D51, "Volex (Asia) Pte Ltd"  },
    { 0x0D52, "YAMAHA Motor Co., Ltd"  },
    { 0x0D53, "HMI Co., Ltd."  },
    { 0x0D54, "HOLON Corporation"  },
    { 0x0D55, "ASKA Technologies Inc."  },
    { 0x0D56, "AVLAB Technology, Inc."  },
    { 0x0D57, "SOLOMON Microtech Ltd."  },
    { 0x0D59, "CDS electronics bv"  },
    { 0x0D5A, "Hoshino Metal Industries, Ltd."  },
    { 0x0D5B, "LOGIC CORPORATION"  },
    { 0x0D5C, "Eumitcom Technology Inc."  },
    { 0x0D5D, "Telesis Technologies, Inc."  },
    { 0x0D5E, "MYACOM LTD"  },
    { 0x0D5F, "CSI, Inc."  },
    { 0x0D60, "IVL Technologies Ltd."  },
    { 0x0D61, "MEILU ELECTRONICS (SHENZHEN) CO., LTD."  },
    { 0x0D62, "Darfon Electronics Corp."  },
    { 0x0D63, "Fritz Gegauf AG"  },
    { 0x0D64, "DXG Technology Corp."  },
    { 0x0D65, "KMJP CO., LTD."  },
    { 0x0D66, "TMT"  },
    { 0x0D67, "Advanet Inc."  },
    { 0x0D68, "Super Link Electronics Co., Ltd."  },
    { 0x0D69, "NSI"  },
    { 0x0D6A, "eMegaTech International Corp."  },
    { 0x0D6B, "And-Or Logic"  },
    { 0x0D6C, "CANMAX Technology Ltd."  },
    { 0x0D6D, "Mitsubishi Elec. Micro-Computer App. Software Co."  },
    { 0x0D6E, "Forum Trading Ltd. (UK)"  },
    { 0x0D70, "Try Computer Co. LTD."  },
    { 0x0D71, "Hirakawa Hewtech Corp."  },
    { 0x0D72, "Winmate Communication Inc."  },
    { 0x0D73, "Hit's Communications INC."  },
    { 0x0D74, "Dreams Come True Co., Ltd."  },
    { 0x0D75, "LET'S Corporation, Ltd."  },
    { 0x0D76, "MFP Korea, Inc."  },
    { 0x0D77, "Power Sentry/Newpoint"  },
    { 0x0D78, "Japan Distributor Corporation"  },
    { 0x0D79, "Assistive Technology Engineering Lab"  },
    { 0x0D7A, "MARX CryptoTech LP"  },
    { 0x0D7B, "Wellco Technology Co., Ltd."  },
    { 0x0D7C, "Taiwan Line Tek Electronic Co., Ltd."  },
    { 0x0D7D, "Add-On Technology Co., Ltd."  },
    { 0x0D7E, "American Computer & Digital Components"  },
    { 0x0D7F, "Essential Reality LLC"  },
    { 0x0D80, "H.R. Silvine Electronics Inc."  },
    { 0x0D81, "TechnoVision"  },
    { 0x0D83, "Think Outside, Inc."  },
    { 0x0D84, "ELECTRO-SYSTEM Co., Ltd."  },
    { 0x0D85, "Identix Incorporated"  },
    { 0x0D86, "Marconi"  },
    { 0x0D87, "Dolby Laboratories Inc."  },
    { 0x0D88, "Miyoshi Corp."  },
    { 0x0D89, "Oz Software"  },
    { 0x0D8A, "KING JIM CO., LTD."  },
    { 0x0D8B, "Ascom Telecommunications Ltd."  },
    { 0x0D8C, "C-MEDIA ELECTRONICS INC."  },
    { 0x0D8D, "Promotion & Display Technology Ltd."  },
    { 0x0D8E, "Global Sun Technology Inc."  },
    { 0x0D8F, "Pitney Bowes"  },
    { 0x0D90, "Sure-Fire Electrical Corporation"  },
    { 0x0D91, "ALPHA PROJECT Co., Ltd."  },
    { 0x0D92, "Mega & Game"  },
    { 0x0D93, "Nishitomo Co., Ltd."  },
    { 0x0D94, "Advanced Logic Technology (ALT)"  },
    { 0x0D95, "Numonics Corp."  },
    { 0x0D96, "Skanhex Technology Inc."  },
    { 0x0D97, "Santa Barbara Instrument Group (SBIG)"  },
    { 0x0D98, "Mars Semiconductor Corp."  },
    { 0x0D99, "Trazer Technologies Inc."  },
    { 0x0D9A, "RTX Telecom A/S"  },
    { 0x0D9B, "Tat Shing Electrical Co."  },
    { 0x0D9C, "Chee Chen Hi-Technology Co., Ltd."  },
    { 0x0D9D, "Sanwa Supply Inc"  },
    { 0x0D9E, "Avaya"  },
    { 0x0D9F, "Powercom Co., Ltd."  },
    { 0x0DA0, "Danger Research"  },
    { 0x0DA1, "Suzhou Peter's Precise Industrial Co., Ltd."  },
    { 0x0DA2, "Land Instruments International Ltd."  },
    { 0x0DA3, "Nippon Electro-Sensory Devices Corporation"  },
    { 0x0DA4, "POLAR ELECTRO OY"  },
    { 0x0DA5, "TOKYO MAGNETIC PRINTING CO., LTD."  },
    { 0x0DA6, "Aimtron Technology Corp."  },
    { 0x0DA7, "IOGEAR, Inc."  },
    { 0x0DA8, "softDSP Co., Ltd."  },
    { 0x0DA9, "DigiLife Technology Inc."  },
    { 0x0DAA, "Derelek"  },
    { 0x0DAB, "Diasonic Technology Co., Ltd."  },
    { 0x0DAC, "Smart Card Technology, Inc."  },
    { 0x0DAD, "Westover Scientific"  },
    { 0x0DAE, "SERIAL SYSTEM LTD"  },
    { 0x0DAF, "NXTV, Inc."  },
    { 0x0DB0, "Micro-Star International Co., Ltd."  },
    { 0x0DB1, "Wen Te Electronics Co., Ltd."  },
    { 0x0DB2, "Shian Hwi Plug Parts, Plastic Factory"  },
    { 0x0DB3, "Tekram Technology Co. Ltd."  },
    { 0x0DB4, "Chung Fu Chen Yeh Enterprise Corporation"  },
    { 0x0DB5, "Azio Ltd."  },
    { 0x0DB6, "SIMS Valley Co., Ltd."  },
    { 0x0DB7, "ELCON Systemtechnik GmbH"  },
    { 0x0DB8, "Garear Taiwan Co., Ltd."  },
    { 0x0DB9, "EMKAY"  },
    { 0x0DBA, "DIGIDESIGN"  },
    { 0x0DBB, "Luna Analytics, Inc."  },
    { 0x0DBC, "A&D Company, Limited"  },
    { 0x0DBD, "Bruker Biospin"  },
    { 0x0DBE, "Jiuh Shiuh Precision Industry Co., Ltd."  },
    { 0x0DBF, "Jess-Link International"  },
    { 0x0DC0, "G7 Solutions"  },
    { 0x0DC1, "Tamagawa Seiki Co., Ltd."  },
    { 0x0DC3, "Athena Smartcard Solutions Inc."  },
    { 0x0DC4, "inXtron, Inc."  },
    { 0x0DC5, "SDK Co, Ltd."  },
    { 0x0DC6, "Precision Squared Technology Corporation"  },
    { 0x0DC7, "First Cable Line, Inc."  },
    { 0x0DC8, "WINTEC Corporation"  },
    { 0x0DC9, "Arvel Corp."  },
    { 0x0DCA, "SMaL Camera Technologies, Inc."  },
    { 0x0DCB, "RocketPod, Inc."  },
    { 0x0DCC, "Largan Digital"  },
    { 0x0DCD, "NetworkFab Corporation"  },
    { 0x0DCE, "E-MU Systems, Inc., d.b.a. E-MU/ENSONIQ"  },
    { 0x0DCF, "Analytik Jena AG"  },
    { 0x0DD0, "Access Solutions"  },
    { 0x0DD1, "Contek Electronics Co., Ltd."  },
    { 0x0DD2, "Power Quotient International Co., Ltd."  },
    { 0x0DD3, "MediaQ"  },
    { 0x0DD4, "Custom Engineering SPA"  },
    { 0x0DD5, "California Micro Devices"  },
    { 0x0DD6, "TECHKON GmbH"  },
    { 0x0DD7, "KOCOM CO., LTD"  },
    { 0x0DD8, "Netac Technology Co., Ltd."  },
    { 0x0DD9, "HighSpeed Surfing"  },
    { 0x0DDA, "Integrated Silicon Solution, Inc"  },
    { 0x0DDB, "Tamarack Inc."  },
    { 0x0DDC, "Takaotec"  },
    { 0x0DDD, "Datelink Technology Co., Ltd."  },
    { 0x0DDE, "UBICOM, INC"  },
    { 0x0DDF, "DriveCam Video Systems"  },
    { 0x0DE1, "Vidicode Datacommunicatie BV"  },
    { 0x0DE2, "Acom Data"  },
    { 0x0DE3, "RFTECH CO., LTD."  },
    { 0x0DE4, "Aron Digital Inc."  },
    { 0x0DE5, "Secure2Net, Inc. USA"  },
    { 0x0DE6, "Dentsply Int'l - Gendex Dental Division"  },
    { 0x0DE7, "USBmicro"  },
    { 0x0DE8, "Delsy Electronic Components AG"  },
    { 0x0DE9, "Technische Industrie TACX BV"  },
    { 0x0DEA, "UTECH Electronic (D.G.) Co., Ltd."  },
    { 0x0DEB, "Lean Horn Co."  },
    { 0x0DEC, "Callserve Communications Ltd."  },
    { 0x0DED, "Novasonics"  },
    { 0x0DEE, "Lifetime Memory Products"  },
    { 0x0DEF, "Full Rise Electronic Co., Ltd."  },
    { 0x0DF0, "GE Yokogawa Medical Systems, Ltd."  },
    { 0x0DF1, "Envoy Medical Corporation"  },
    { 0x0DF2, "Nisshin Electronics Co., Ltd."  },
    { 0x0DF3, "VeriTek Co., Ltd."  },
    { 0x0DF4, "Net & Sys Co., Ltd."  },
    { 0x0DF5, "Yamatake Corporation"  },
    { 0x0DF6, "Sitecom Europe B.V."  },
    { 0x0DF7, "Mobile Action Technology Inc."  },
    { 0x0DF8, "Hoya Computer Co., Ltd."  },
    { 0x0DF9, "Nice Fountain Industrial Co., Ltd."  },
    { 0x0DFA, "Toyo Networks & System Integration Co., Ltd."  },
    { 0x0DFB, "Daisy Technology"  },
    { 0x0DFC, "General Touch Technology Co., Ltd."  },
    { 0x0DFD, "Suruga Seiki Co., Ltd."  },
    { 0x0DFE, "Interactive Metronome"  },
    { 0x0DFF, "Deodeo Corporation"  },
    { 0x0E00, "Novar GmbH"  },
    { 0x0E01, "Sheng Xiang Investment Ltd."  },
    { 0x0E02, "Doowon Co., LTD"  },
    { 0x0E03, "Nippon Systemware Co., Ltd."  },
    { 0x0E04, "PowerCom Technology Co., Ltd."  },
    { 0x0E05, "Nordic ID"  },
    { 0x0E06, "Personal Telecom, Inc."  },
    { 0x0E07, "Viewtek Co., Ltd"  },
    { 0x0E08, "Winbest Technology Co., Ltd."  },
    { 0x0E09, "Winskon Cabling Specialist Co., Ltd."  },
    { 0x0E0A, "JAEIK Information & Communication Co., Ltd."  },
    { 0x0E0B, "Fujitsu Denso Ltd."  },
    { 0x0E0C, "Gesytec GmbH"  },
    { 0x0E0D, "Picoquant GmbH"  },
    { 0x0E0E, "Fuji Data System Co., Ltd."  },
    { 0x0E0F, "VMWare, Inc."  },
    { 0x0E10, "TERUMO Corporation (Suruga Factory)"  },
    { 0x0E11, "Neurotec"  },
    { 0x0E12, "Danam Communications Inc."  },
    { 0x0E13, "Lugh Networks, Inc."  },
    { 0x0E14, "Hunter Engineering Co."  },
    { 0x0E15, "Tellert Elektronik GmbH"  },
    { 0x0E16, "JMTEK, LLC"  },
    { 0x0E17, "Walex Electronic Ltd."  },
    { 0x0E18, "UNIWIDE Technologies"  },
    { 0x0E19, "OeRSTED, Inc."  },
    { 0x0E1A, "RDM Corporation"  },
    { 0x0E1B, "Crewave Co., Ltd."  },
    { 0x0E1C, "Beijing Hi-tech Wealth Software Technology Co."  },
    { 0x0E1D, "International Parts & Information Co., Ltd."  },
    { 0x0E1E, "Green Hills Software, Inc."  },
    { 0x0E1F, "Cabin Industrial Co., Ltd."  },
    { 0x0E20, "Pegasus Technologies Ltd."  },
    { 0x0E21, "Cowon Systems, Inc."  },
    { 0x0E22, "Symbian Ltd."  },
    { 0x0E23, "Liou Yuane International Ltd."  },
    { 0x0E24, "Samson Electric Wire Co., Ltd."  },
    { 0x0E25, "VinChip Systems, Inc."  },
    { 0x0E26, "J-Phone East Co., Ltd."  },
    { 0x0E27, "Thunder Island Limited"  },
    { 0x0E28, "Industrial Control Systems"  },
    { 0x0E29, "CB Sciences, Inc."  },
    { 0x0E2A, "Flight Link Inc."  },
    { 0x0E2B, "Kumamoto Techno Corporation"  },
    { 0x0E2C, "Intersoft Electronics N.V."  },
    { 0x0E2D, "SKF Condition Monitoring"  },
    { 0x0E2E, "Brady Corporation"  },
    { 0x0E2F, "Daisen Electronic Industrial Co., Ltd."  },
    { 0x0E30, "HeartMath LLC"  },
    { 0x0E31, "Biosign"  },
    { 0x0E32, "ICONAG - Intelligent Control AG"  },
    { 0x0E33, "Luna Innovations, Inc."  },
    { 0x0E34, "Micro Computer Control Corp."  },
    { 0x0E35, "3Pea Technologies, Inc."  },
    { 0x0E36, "TiePie engineering"  },
    { 0x0E37, "Alpha Data Corp."  },
    { 0x0E38, "Stratitec, Inc."  },
    { 0x0E39, "Smart Modular Technologies, Inc."  },
    { 0x0E3A, "Neostar Technology Co., Ltd."  },
    { 0x0E3B, "Mansella Ltd."  },
    { 0x0E3C, "Raytec Electronic Co., Ltd."  },
    { 0x0E3D, "Metex Corporation"  },
    { 0x0E3E, "Good Technology, Inc."  },
    { 0x0E3F, "AM Group Corp."  },
    { 0x0E40, "Proteq LTDA"  },
    { 0x0E41, "Line 6, Inc."  },
    { 0x0E42, "Puretek Industrial Co., Ltd."  },
    { 0x0E43, "Holly Lin International Technology Inc."  },
    { 0x0E44, "Sun-Riseful Technology Co., Ltd."  },
    { 0x0E45, "SafeNet B.V."  },
    { 0x0E46, "Delphi Corporation"  },
    { 0x0E47, "AMANO Corporation"  },
    { 0x0E48, "Julia Corporation Limited"  },
    { 0x0E49, "Ingenieurbuero Chanda AG"  },
    { 0x0E4A, "Shenzhen Bao Hing Electric Wire & Cable Mfr. Co."  },
    { 0x0E4B, "System General Corp."  },
    { 0x0E4C, "Radica Games Ltd."  },
    { 0x0E4D, "Hong Shi Precision Corp."  },
    { 0x0E4E, "Lih Duo Intl. Co., Ltd."  },
    { 0x0E4F, "Data Ray Corp."  },
    { 0x0E50, "TDi GmbH TechnoData Interware"  },
    { 0x0E51, "Therapy Information & Communication System Inc."  },
    { 0x0E52, "Mindready Solutions (NI) Ltd."  },
    { 0x0E53, "King Tester Corporation"  },
    { 0x0E54, "KDE, Inc."  },
    { 0x0E55, "Speed Dragon Multimedia Ltd."  },
    { 0x0E56, "Cenix Digicom Co., Ltd."  },
    { 0x0E57, "Loas Co., Ltd"  },
    { 0x0E58, "Technology For Energy Corp."  },
    { 0x0E59, "Bourns, Inc."  },
    { 0x0E5A, "ACTIVE CO., LTD."  },
    { 0x0E5B, "Union Power Information Industrial Co., Ltd."  },
    { 0x0E5C, "Shenzhen Bitland Information Technology Co., Ltd."  },
    { 0x0E5D, "Neltron Industrial Co., Ltd."  },
    { 0x0E5E, "Conwise Technology Co., Ltd."  },
    { 0x0E5F, "Entone Technologies"  },
    { 0x0E60, "XAVi Technologies Corp."  },
    { 0x0E61, "E-Pen InMotion Inc."  },
    { 0x0E62, "Shandong CVIC Software Engineering Co., Ltd."  },
    { 0x0E63, "SECUREPIA Inc."  },
    { 0x0E64, "Nida Corporation"  },
    { 0x0E65, "Skycom Tek Co., Ltd"  },
    { 0x0E66, "Hawking Technologies, Inc."  },
    { 0x0E67, "Fossil"  },
    { 0x0E68, "Artec"  },
    { 0x0E69, "A Global Partner Corporation"  },
    { 0x0E6A, "Megawin Technology Co., Ltd."  },
    { 0x0E6B, "DMA Korea Co., Ltd"  },
    { 0x0E6C, "E & D Co., Ltd."  },
    { 0x0E6D, "Tenovis Business Communication"  },
    { 0x0E6E, "Volvo Car Corporation"  },
    { 0x0E6F, "Performance Designed Products, LLC"  },
    { 0x0E70, "Tokyo Electronic Industry Co, LTD."  },
    { 0x0E71, "Schwarzer GmbH"  },
    { 0x0E72, "Hsi-Chin Electronics Co., Ltd."  },
    { 0x0E73, "MCK Communications, Inc."  },
    { 0x0E74, "Accu-Automation Corp."  },
    { 0x0E75, "TVS Electronics Limited"  },
    { 0x0E76, "Seiko S-Yard Co., Ltd"  },
    { 0x0E77, "Weinzierl Engineering GmbH"  },
    { 0x0E78, "Ascom Powerline Communications Ltd."  },
    { 0x0E79, "ARCHOS SA"  },
    { 0x0E7A, "Indocomp Systems Inc."  },
    { 0x0E7B, "On-Tech Industry Co., Ltd."  },
    { 0x0E7C, "Legend Holdings Limited"  },
    { 0x0E7D, "Eutectics Inc."  },
    { 0x0E7E, "G.Mate, Inc."  },
    { 0x0E7F, "Keysight Technologies, Inc. - AFM division"  },
    { 0x0E80, "GateHouse A/S"  },
    { 0x0E81, "System Consultants Co., Ltd."  },
    { 0x0E82, "Ching Tai Electric Wire & Cable Co., Ltd."  },
    { 0x0E83, "Shin An Wire & Cable Co."  },
    { 0x0E84, "Elelux International Ltd."  },
    { 0x0E85, "Dynavox Systems LLC"  },
    { 0x0E86, "Watthour Engineering Co., Inc."  },
    { 0x0E87, "Internet Security Co., Ltd"  },
    { 0x0E88, "ELBIO"  },
    { 0x0E89, "PRT Manufacturing Ltd."  },
    { 0x0E8A, "FinePoint Innovations, Inc."  },
    { 0x0E8B, "KAO SHIN PRECISION INDUSTRY CO., LTD."  },
    { 0x0E8C, "Well Force Electronic Co., Ltd"  },
    { 0x0E8D, "MediaTek Inc."  },
    { 0x0E8E, "Stuart Tyrrell Developments"  },
    { 0x0E8F, "Pansignal Technology Inc."  },
    { 0x0E90, "CRU"  },
    { 0x0E91, "VTech Engineering Canada Ltd."  },
    { 0x0E92, "C'S GLORY ENTERPRISE CO., LTD."  },
    { 0x0E93, "eM Technics Co., Ltd."  },
    { 0x0E94, "Sirona Dental Systems GmbH"  },
    { 0x0E95, "Future Technology Co., Ltd"  },
    { 0x0E96, "APLUX Communications Ltd."  },
    { 0x0E97, "Fingerworks, Inc."  },
    { 0x0E98, "Advanced Analogic Technologies, Inc."  },
    { 0x0E99, "Parallel Dice Co., Ltd."  },
    { 0x0E9A, "TA HSING INDUSTRIES LTD."  },
    { 0x0E9B, "ADTEC CORPORATION"  },
    { 0x0E9C, "StreamZap, Inc."  },
    { 0x0E9D, "Hitron Technologies, Inc."  },
    { 0x0E9E, "Japan System Design Co."  },
    { 0x0E9F, "TAMURA CORPORATION"  },
    { 0x0EA0, "Ours Technology Inc."  },
    { 0x0EA1, "Infinite Communication Terminals Ltd."  },
    { 0x0EA2, "Triumph Technology Corp."  },
    { 0x0EA3, "Rion Co., Ltd."  },
    { 0x0EA4, "Intelligent Hearing Systems"  },
    { 0x0EA5, "DATA SYSTEM TECHNOLOGY CO., LTD."  },
    { 0x0EA6, "Nihon Computer Co., Ltd."  },
    { 0x0EA7, "MSL Enterprises Corp."  },
    { 0x0EA8, "CenDyne, Inc."  },
    { 0x0EA9, "J&J ENGINEERING INC."  },
    { 0x0EAA, "TOKYO SOKKI KENKYUJO CO., LTD."  },
    { 0x0EAB, "Yiso Telecom"  },
    { 0x0EAC, "ALCATech GmbH"  },
    { 0x0EAD, "HUMAX Co., Ltd."  },
    { 0x0EAE, "Alcon Labs"  },
    { 0x0EAF, "Grandex International Corporation"  },
    { 0x0EB0, "Amigo Technology Co., Ltd."  },
    { 0x0EB1, "WIS Technologies, Inc."  },
    { 0x0EB2, "Y-S ELECTRONIC CO., LTD."  },
    { 0x0EB3, "Saint Technology Corp."  },
    { 0x0EB4, "IPLAN Inc."  },
    { 0x0EB5, "@pos.com"  },
    { 0x0EB6, "GAMEPARK, Inc."  },
    { 0x0EB7, "Endor AG"  },
    { 0x0EB8, "Mettler-Toledo (Albstadt) GmbH"  },
    { 0x0EB9, "SKY Electronics"  },
    { 0x0EBA, "iWOW Connections Pte Ltd"  },
    { 0x0EBB, "Thermo Nicolet Corp."  },
    { 0x0EBC, "CHOIS Technology"  },
    { 0x0EBD, "Kyowa Electronics Co., Ltd."  },
    { 0x0EBE, "VWEB Corporation"  },
    { 0x0EBF, "Omega Technology Inc."  },
    { 0x0EC0, "LHI Technology (China) Co., Ltd."  },
    { 0x0EC1, "ABIT Computer Corporation"  },
    { 0x0EC2, "Sweetray Industrial Ltd."  },
    { 0x0EC3, "Axell Corporation"  },
    { 0x0EC4, "Ballracing Developments Ltd."  },
    { 0x0EC5, "GT Information System Co., Ltd."  },
    { 0x0EC6, "InnoVISION Multimedia Limited"  },
    { 0x0EC7, "Theta Link Corporation"  },
    { 0x0EC8, "Mitechno Co., Ltd."  },
    { 0x0EC9, "HemoCue AB"  },
    { 0x0ECA, "Mit System Co., Ltd."  },
    { 0x0ECB, "Harman Kardon"  },
    { 0x0ECC, "Samsung SDS"  },
    { 0x0ECD, "Lite-On IT Corp."  },
    { 0x0ECE, "TaiSol Electronics Co., Ltd."  },
    { 0x0ECF, "Phogenix Imaging, LLC"  },
    { 0x0ED0, "LANergy Limited"  },
    { 0x0ED1, "Tai Guen Enterprise Co., Ltd."  },
    { 0x0ED2, "Kyoto Micro Computer Co., LTD."  },
    { 0x0ED3, "Wing-Tech Enterprise Co., Ltd."  },
    { 0x0ED4, "Ross Video"  },
    { 0x0ED5, "ChronoLogic Pty. Ltd."  },
    { 0x0ED6, "TECHNOS JAPAN Co., LTD."  },
    { 0x0ED7, "COSMODOG, LTD."  },
    { 0x0ED8, "ASAHI SPECTRA CO., LTD."  },
    { 0x0ED9, "Holy Stone Enterprise Co., Ltd."  },
    { 0x0EDA, "NORITAKE ITRON CORPORATION"  },
    { 0x0EDB, "AboveTech, Inc."  },
    { 0x0EDC, "GALTRONICS"  },
    { 0x0EDD, "KOWA COMPANY, LTD."  },
    { 0x0EDE, "TOD Co., Ltd."  },
    { 0x0EDF, "e-MDT Co., Ltd."  },
    { 0x0EE0, "SHIMA SEIKI MFG., LTD."  },
    { 0x0EE1, "Sarotech Co., Ltd."  },
    { 0x0EE2, "AMI Semiconductor Inc."  },
    { 0x0EE3, "ComTrue Technology Corporation (Taiwan)"  },
    { 0x0EE4, "Sunrich Technology (H.K.) Ltd."  },
    { 0x0EE5, "Medical Graphics Corporation"  },
    { 0x0EE6, "Takacom Corporation"  },
    { 0x0EE7, "Furuno Electric Co., Ltd."  },
    { 0x0EE8, "Triz Communications Group"  },
    { 0x0EE9, "JPK Systems Limited"  },
    { 0x0EEA, "William Demant Holding A/S"  },
    { 0x0EEB, "Design Of Systems On Silicon, S.A. (DS2)"  },
    { 0x0EEC, "Tritek Co., Ltd."  },
    { 0x0EED, "CCP Co., Ltd."  },
    { 0x0EEE, "Digital STREAM Technology, Inc."  },
    { 0x0EEF, "eGalax Inc."  },
    { 0x0EF0, "Hitachi Cable, Ltd."  },
    { 0x0EF1, "Aichi Micro Intelligent Corporation"  },
    { 0x0EF2, "I/OMAGIC CORPORATION"  },
    { 0x0EF3, "Lynn Products, Inc."  },
    { 0x0EF4, "DSI Datotech"  },
    { 0x0EF5, "PointChips"  },
    { 0x0EF6, "Yield Microelectronics Corp."  },
    { 0x0EF7, "SM Tech Co., Ltd."  },
    { 0x0EF8, "ECT Inc."  },
    { 0x0EF9, "eHome TV, Inc. DBA Fuze3 Technologies"  },
    { 0x0EFA, "Corepro Entertainment"  },
    { 0x0EFB, "ARKRAY, Inc."  },
    { 0x0EFC, "ELMEX COMPANY Ltd."  },
    { 0x0EFD, "Oasis Semiconductor"  },
    { 0x0EFE, "WEM TECHNOLOGY INC."  },
    { 0x0EFF, "CSIRO-TIP"  },
    { 0x0F00, "ndd Medizintechnik AG"  },
    { 0x0F01, "EXPAN Electronics Co., Ltd."  },
    { 0x0F02, "MobileAria"  },
    { 0x0F03, "Jet Power Technology Co., Ltd."  },
    { 0x0F04, "Softlok International Limited"  },
    { 0x0F05, "Quanta Network Systems Inc."  },
    { 0x0F06, "Visual Frontier Precision Corp."  },
    { 0x0F07, "Pakon"  },
    { 0x0F08, "CSL Wire & Plug (Shen Zhen) Company"  },
    { 0x0F09, "Sandel Arionics Inc."  },
    { 0x0F0B, "Great Computer Corporation"  },
    { 0x0F0C, "CAS Corporation"  },
    { 0x0F0D, "HORI CO., LTD."  },
    { 0x0F0E, "Energyfull & Hi-Top International Ltd."  },
    { 0x0F0F, "NANOPTIX INC."  },
    { 0x0F10, "Personal Information Systems Co., Ltd."  },
    { 0x0F11, "Leybold Didactic GMBH"  },
    { 0x0F12, "MARS ENGINEERING CORPORATION"  },
    { 0x0F13, "Acetek Technology Co., Ltd."  },
    { 0x0F14, "XIRING"  },
    { 0x0F15, "PlayMore Corporation"  },
    { 0x0F16, "GLOBAL VIEW CO. LTD."  },
    { 0x0F17, "Correlant Communications"  },
    { 0x0F18, "Finger Lakes Instrumentation, LLC"  },
    { 0x0F19, "ORACOM CO., Ltd."  },
    { 0x0F1A, "General Information Systems Ltd."  },
    { 0x0F1B, "Onset Computer Corporation"  },
    { 0x0F1C, "Funai Electric Co., Ltd."  },
    { 0x0F1D, "Iwill Corporation"  },
    { 0x0F1E, "INVAIR Technologies AG"  },
    { 0x0F1F, "Laxtha"  },
    { 0x0F20, "GENNUM CORPORATION"  },
    { 0x0F21, "IOI Technology Corporation"  },
    { 0x0F22, "SENIOR INDUSTRIES, INC."  },
    { 0x0F23, "Leader Tech Manufacturer Co., Ltd"  },
    { 0x0F24, "FLEX-P INDUSTRIES SDN.BHD."  },
    { 0x0F25, "Primera Technology Inc."  },
    { 0x0F26, "B.G. Technologies, Inc."  },
    { 0x0F27, "Alpes DEIS"  },
    { 0x0F28, "ESEC SA"  },
    { 0x0F29, "TIPTEL AG"  },
    { 0x0F2A, "Marconi Data Systems"  },
    { 0x0F2B, "XEMICS SA"  },
    { 0x0F2D, "ViPower, Inc."  },
    { 0x0F2E, "Good Man Corporation"  },
    { 0x0F2F, "Priva Design Services"  },
    { 0x0F30, "Jess Technology Co., Ltd."  },
    { 0x0F31, "Chrysalis Development"  },
    { 0x0F32, "YFC-BonEagle Electric Co., Ltd."  },
    { 0x0F33, "Futek Electronics, Co., Ltd."  },
    { 0x0F34, "Hokuto Denshi Co., Ltd."  },
    { 0x0F35, "Kinpo Electronics, Inc."  },
    { 0x0F36, "Philips Medical Systems Ultrasound"  },
    { 0x0F37, "Kokuyo Co., Ltd."  },
    { 0x0F38, "Nien-Yi Industrial Corp."  },
    { 0x0F39, "Heng Yu Technology (HK) Ltd."  },
    { 0x0F3A, "Aidensi Giken"  },
    { 0x0F3B, "IR-LINK"  },
    { 0x0F3C, "Numesa, Inc."  },
    { 0x0F3D, "AirPrime Inc."  },
    { 0x0F3E, "Aastra Broadband"  },
    { 0x0F3F, "FEI Electron Optics B.V."  },
    { 0x0F40, "Denver Instrument Company"  },
    { 0x0F41, "RDC Semiconductor Co., Ltd."  },
    { 0x0F42, "Nital Consulting Services, Inc."  },
    { 0x0F43, "LiteON Semiconductor Corp."  },
    { 0x0F44, "Polhemus Incorporated"  },
    { 0x0F45, "International Road Dynamics"  },
    { 0x0F46, "KIHOKU Electronic Co., Ltd."  },
    { 0x0F47, "SN Systems Ltd."  },
    { 0x0F48, "Durand Interstellar, Inc."  },
    { 0x0F49, "Evolis"  },
    { 0x0F4A, "Planmeca Oy"  },
    { 0x0F4B, "St. John Technology Co., Ltd."  },
    { 0x0F4C, "WORLDWIDE CABLE OPTO CORP."  },
    { 0x0F4D, "Microtune, Inc."  },
    { 0x0F4E, "Freedom Scientific"  },
    { 0x0F4F, "INVENTEL"  },
    { 0x0F50, "LeadingSpect Corporation"  },
    { 0x0F51, "Zeta Broadband Inc."  },
    { 0x0F52, "Wing Kei Electrical Production Ltd."  },
    { 0x0F53, "Taiyo Cable (Dongguan) Co. Ltd."  },
    { 0x0F54, "Kawai Musical Instruments Mfg. Co., Ltd."  },
    { 0x0F55, "AmbiCom, Inc."  },
    { 0x0F56, "SecureTech Corp."  },
    { 0x0F57, "WavePlus Tech. Co., Ltd."  },
    { 0x0F58, "JASCO Corporation"  },
    { 0x0F59, "NCI/Newcomb Company, Inc."  },
    { 0x0F5A, "Cogency Semiconductor Inc."  },
    { 0x0F5B, "Ritech International Ltd."  },
    { 0x0F5C, "PRAIRIECOMM, INC."  },
    { 0x0F5D, "NewAge International, LLC"  },
    { 0x0F5E, "LEADER ELECTRONICS CORP."  },
    { 0x0F5F, "Key Technology Corporation"  },
    { 0x0F60, "GuangZhou Chief Tech Electronic Technology Co. Ltd."  },
    { 0x0F61, "Varian Inc."  },
    { 0x0F62, "Acrox Technologies Co., Ltd."  },
    { 0x0F63, "Leapfrog Enterprises"  },
    { 0x0F64, "ZAE Research, Inc."  },
    { 0x0F65, "Dataflex Design Communications Limited"  },
    { 0x0F66, "Toshiba Global Commerce Solutions"  },
    { 0x0F67, "Quantum3D, Inc."  },
    { 0x0F68, "UQUEST, LTD."  },
    { 0x0F69, "DIONEX CORPORATION"  },
    { 0x0F6A, "Vibren Technologies Inc."  },
    { 0x0F6B, "OHM ELECTRIC CO., LTD."  },
    { 0x0F6C, "DnC Tech., Inc."  },
    { 0x0F6D, "WillPoD Co., Ltd."  },
    { 0x0F6E, "INTELLIGENT SYSTEMS CO., LTD."  },
    { 0x0F6F, "Samtec GmbH"  },
    { 0x0F70, "YOZAN Inc."  },
    { 0x0F71, "Systems Integration Solutions Inc."  },
    { 0x0F72, "Robert Bosch GmbH - Chassis Systems Control"  },
    { 0x0F73, "DFI"  },
    { 0x0F74, "KOSUGI GIKEN Co, Ltd."  },
    { 0x0F75, "Future Internet"  },
    { 0x0F76, "Vacon Plc"  },
    { 0x0F77, "Fasstech"  },
    { 0x0F78, "Guntermann & Drunck GmbH"  },
    { 0x0F79, "Transonic Systems, Inc."  },
    { 0x0F7A, "EE Tools, Inc."  },
    { 0x0F7B, "Hivertec Inc."  },
    { 0x0F7C, "DQ Technology, Inc."  },
    { 0x0F7D, "NetBotz, Inc."  },
    { 0x0F7E, "Fluke"  },
    { 0x0F7F, "Lansmont Corporation"  },
    { 0x0F80, "OCULUS Optikgeraete GmbH"  },
    { 0x0F81, "DP Computers Pte. Ltd."  },
    { 0x0F82, "IMedia Semiconductor Corporation"  },
    { 0x0F83, "Ernst Reiner GmbH & Co. KG"  },
    { 0x0F84, "A.E.B. S.R.L."  },
    { 0x0F85, "IDX Company, Ltd."  },
    { 0x0F86, "Cedar Audio Limited"  },
    { 0x0F87, "HUMANDATA LTD."  },
    { 0x0F88, "VTech Holdings Ltd."  },
    { 0x0F89, "Leading Edge Co., Ltd."  },
    { 0x0F8A, "Centro De Tecnologia de las Comunicaciones, S.A."  },
    { 0x0F8B, "Yazaki Corporation"  },
    { 0x0F8C, "Young Generation International Corp."  },
    { 0x0F8D, "Uniwill Computer Corp."  },
    { 0x0F8E, "Kingnet Technology Co., Ltd."  },
    { 0x0F8F, "SOMA NETWORKS"  },
    { 0x0F90, "Quad Engineering Solutions LLC"  },
    { 0x0F91, "UNIPULSE Corporation"  },
    { 0x0F92, "JASTEC CO., LTD."  },
    { 0x0F93, "Sondex Limited"  },
    { 0x0F94, "FALCOM GmbH"  },
    { 0x0F95, "TOKYO SOKUSHIN CO., LTD."  },
    { 0x0F96, "NEC-Mitsubishi Electric Visual Systems Corp."  },
    { 0x0F97, "CviLux Corporation"  },
    { 0x0F98, "CYBERBANK CORP."  },
    { 0x0F99, "Biopia Co., Ltd."  },
    { 0x0F9A, "Sistel S.R.L."  },
    { 0x0F9B, "G-Card Technology Co., Ltd."  },
    { 0x0F9C, "HYUN WON INC."  },
    { 0x0F9D, "Opteon Corporation"  },
    { 0x0F9E, "Lucent Technologies"  },
    { 0x0F9F, "Racewood Technology Co., Ltd."  },
    { 0x0FA0, "TRITTON TECHNOLOGIES"  },
    { 0x0FA1, "AIJI System Co., Ltd."  },
    { 0x0FA2, "TAG Systems Racing Products, Inc."  },
    { 0x0FA3, "Chief Land Electronic Co., Ltd."  },
    { 0x0FA4, "ATL Technology"  },
    { 0x0FA5, "SOTEC CO., LTD."  },
    { 0x0FA6, "CMD AG"  },
    { 0x0FA7, "EPOX COMPUTER CO., LTD."  },
    { 0x0FA8, "Logic Controls, Inc."  },
    { 0x0FA9, "Shenzhen Motion Control Technology Co., Ltd."  },
    { 0x0FAA, "Changrime Telecom Co., Ltd."  },
    { 0x0FAB, "ISZ"  },
    { 0x0FAC, "Current Stone Co., Ltd."  },
    { 0x0FAD, "Ultravision Ltd."  },
    { 0x0FAE, "Redsun Technology Corp."  },
    { 0x0FAF, "Winpoint Electronic Corp."  },
    { 0x0FB0, "Haurtian Wire & Cable Co., Ltd."  },
    { 0x0FB1, "SuperGate Technologies"  },
    { 0x0FB2, "Conteck Co., Ltd."  },
    { 0x0FB3, "SYMAGERY MICROSYSTEMS INC."  },
    { 0x0FB4, "Smiths Detection"  },
    { 0x0FB5, "NIHON DENJI SOKKI CO., LTD."  },
    { 0x0FB6, "Heber Ltd."  },
    { 0x0FB7, "East Press Co., Ltd."  },
    { 0x0FB8, "Wistron Corporation"  },
    { 0x0FB9, "AACOM CORPORATION"  },
    { 0x0FBA, "SAN SHING ELECTRONICS CO., LTD.."  },
    { 0x0FBB, "Bitwise Systems, Inc."  },
    { 0x0FBC, "Schick Technologies"  },
    { 0x0FBD, "Siblings Investment Inc. (dba vantecusa)"  },
    { 0x0FBE, "Applied Diabetes Research, Inc."  },
    { 0x0FBF, "Certifiable Innovations"  },
    { 0x0FC0, "NUDIAN ELECTRON CO., LTD."  },
    { 0x0FC1, "MITAC INTERNATIONAL CORP."  },
    { 0x0FC2, "PLUG AND JACK INDUSTRIAL INC."  },
    { 0x0FC3, "BRAINTREE COMMUNICATIONS"  },
    { 0x0FC4, "Yamato Electric Industry Co., Ltd."  },
    { 0x0FC5, "Delcom Engineering"  },
    { 0x0FC6, "Dataplus Supplies, Inc."  },
    { 0x0FC7, "BES Technology Group"  },
    { 0x0FC8, "Phoenix Co., Ltd."  },
    { 0x0FC9, "Tecom Co., Ltd."  },
    { 0x0FCA, "BlackBerry Limited"  },
    { 0x0FCB, "Suzuken Co., Ltd."  },
    { 0x0FCC, "Marushin-Denshi Co., Ltd."  },
    { 0x0FCD, "Centurion, Inc."  },
    { 0x0FCE, "Sony Mobile Communications"  },
    { 0x0FCF, "Dynastream Innovations Inc."  },
    { 0x0FD0, "2L international B.V."  },
    { 0x0FD1, "Giant Electronics Ltd."  },
    { 0x0FD2, "SEAC BANCHE S.P.A."  },
    { 0x0FD3, "Marconi Applied Technologies Ltd."  },
    { 0x0FD4, "Tenovis GmbH & Co., KG"  },
    { 0x0FD5, "Direct Access Technology, Inc."  },
    { 0x0FD6, "Mexmal Mayorista S.A. de C.V."  },
    { 0x0FD7, "Jeulin S.A."  },
    { 0x0FD8, "LARSEN & BRUSGAARD"  },
    { 0x0FD9, "El Gato Software LLC"  },
    { 0x0FDA, "Quantec Networks GmbH"  },
    { 0x0FDB, "Comtech EF Data"  },
    { 0x0FDC, "Micro Plus"  },
    { 0x0FDD, "Yuyama Mfg. Co., Ltd."  },
    { 0x0FDE, "IDT DATA SYSTEM LIMITED"  },
    { 0x0FDF, "Foveon Inc."  },
    { 0x0FE0, "AONEPROTECH Co., Ltd."  },
    { 0x0FE1, "MADWAVES ApS"  },
    { 0x0FE2, "Air Techniques, Inc."  },
    { 0x0FE3, "ACCEL CORP."  },
    { 0x0FE4, "IN-TECH ELECTRONICS LIMITED"  },
    { 0x0FE5, "TC&C ELECTRONIC CO.,LTD (SUNTECC, INC.)"  },
    { 0x0FE6, "Sospita ASA"  },
    { 0x0FE7, "Mitutoyo Corporation"  },
    { 0x0FE8, "TurboComm Tech. Inc."  },
    { 0x0FE9, "DVICO Inc."  },
    { 0x0FEA, "United Computer Accessories"  },
    { 0x0FEB, "CRS ELECTRONIC CO., LTD."  },
    { 0x0FEC, "UMC Electronics Co., Ltd."  },
    { 0x0FED, "ACCESS CO., LTD."  },
    { 0x0FEE, "Xsido Corporation"  },
    { 0x0FEF, "MJ RESEARCH, INC."  },
    { 0x0FF0, "Physical Electronics"  },
    { 0x0FF1, "Minato Electronics, Inc."  },
    { 0x0FF2, "EZMAX CO., LTD."  },
    { 0x0FF3, "Dimentor"  },
    { 0x0FF4, "POLYMATECH CO., LTD."  },
    { 0x0FF5, "OYO-ELECTRIC CO., LTD."  },
    { 0x0FF6, "Core Valley Co., Ltd."  },
    { 0x0FF7, "CHI SHING COMPUTER ACCESSORIES CO., LTD."  },
    { 0x0FF8, "iXs Research Corporation"  },
    { 0x0FF9, "FHC., Inc. Frederick Haer & Co."  },
    { 0x0FFA, "ELENTEC CO., LTD."  },
    { 0x0FFB, "Avail Corporation"  },
    { 0x0FFC, "Clavia Digital Musical Instruments AB"  },
    { 0x0FFD, "AKATSUKI ELECTRIC MFG. CO., LTD."  },
    { 0x0FFE, "ASKA Corporation"  },
    { 0x0FFF, "Aopen Inc."  },
    { 0x1000, "Speed Tech Corp."  },
    { 0x1001, "Ritronics Components (S) Pte. Ltd."  },
    { 0x1002, "Spa Design Ltd."  },
    { 0x1003, "SIGMA CORPORATION"  },
    { 0x1004, "LG Electronics Inc."  },
    { 0x1005, "Apacer Technology Inc."  },
    { 0x1006, "Reign Com Ltd."  },
    { 0x1007, "Samphone Electronic Co., Ltd."  },
    { 0x1008, "Futaba Corporation"  },
    { 0x1009, "Lumanate, Inc."  },
    { 0x100A, "AVC Technology"  },
    { 0x100B, "Chou Chin Industrial Co., Ltd."  },
    { 0x100C, "eMachines, inc"  },
    { 0x100D, "NETOPIA, INC."  },
    { 0x100E, "North American Pacific Industries, Corp."  },
    { 0x100F, "Trek Inc."  },
    { 0x1010, "FUKUDA DENSHI CO., LTD."  },
    { 0x1011, "Mobile Media Tech."  },
    { 0x1012, "SDKM Fibres, Wires & Cables Berhad"  },
    { 0x1013, "TST-Touchless Sensor Technology AG"  },
    { 0x1014, "Densitron Technologies PLC"  },
    { 0x1015, "Softronics Pty. Ltd."  },
    { 0x1016, "Xiamen Hung's Enterprise Co., Ltd."  },
    { 0x1017, "SPEEDY INDUSTRIAL SUPPLIES PTE. LTD."  },
    { 0x1018, "Mindtell Inc."  },
    { 0x1019, "Fostex Corporation"  },
    { 0x101A, "Annecy Electronique"  },
    { 0x101B, "Digital Innovations"  },
    { 0x101C, "Teradyne Diagnostic Solutions Ltd."  },
    { 0x101D, "Aerospace Information Corporation Limited"  },
    { 0x101E, "Fronius International GmbH"  },
    { 0x101F, "Pocketec"  },
    { 0x1020, "Paten Wireless Technology Inc."  },
    { 0x1021, "Time Management, Inc."  },
    { 0x1022, "Shinko Shoji Co., Ltd."  },
    { 0x1023, "CHRONIX Inc."  },
    { 0x1024, "ASEC CO., LTD."  },
    { 0x1025, "Technology Testing Lab"  },
    { 0x1026, "Newly Corporation"  },
    { 0x1027, "Time Domain"  },
    { 0x1028, "Inovys Corporation"  },
    { 0x1029, "Atlantic Coast Telesys"  },
    { 0x102A, "RAMOS Technology Co., Ltd."  },
    { 0x102B, "Infotronic America, Inc."  },
    { 0x102C, "Etoms Electronics Corp."  },
    { 0x102D, "Winic Corporation"  },
    { 0x102E, "Binstead Systems Ltd."  },
    { 0x102F, "WENZHOU YIHUA CONNECTOR CO.,LTD."  },
    { 0x1030, "Asoka USA Corporation"  },
    { 0x1031, "Comax Technology Inc."  },
    { 0x1032, "C-One Technology Corp."  },
    { 0x1033, "Nucam Corporation"  },
    { 0x1034, "Teramecs Co., Ltd."  },
    { 0x1035, "Cyber Solid Laboratory"  },
    { 0x1036, "ELLAB A/S"  },
    { 0x1037, "Red Lion Controls LP"  },
    { 0x1038, "SteelSeries ApS"  },
    { 0x1039, "devolo AG"  },
    { 0x103A, "I+ME ACTIA GmbH"  },
    { 0x103B, "Quatographic AG"  },
    { 0x103C, "AMX Corp."  },
    { 0x103D, "Stanton Magnetics, Inc."  },
    { 0x103E, "Thurlby-Thandar Instruments Ltd."  },
    { 0x103F, "Tectech inc."  },
    { 0x1040, "Valiant Technology Ltd."  },
    { 0x1041, "Kongsberg Defence Communications AS"  },
    { 0x1042, "CARDIO SISTEMAS COML. INDL. LTDA."  },
    { 0x1043, "iCreate Technologies Corporation"  },
    { 0x1044, "Chu Yuen Enterprise Co., Ltd."  },
    { 0x1045, "Transiciel Technologies"  },
    { 0x1046, "Hitachi Asahi Electronics Co., Ltd."  },
    { 0x1047, "HOYA CORPORATION Vision Care Company"  },
    { 0x1048, "Targus International LLC"  },
    { 0x1049, "Studio Technologies, Inc."  },
    { 0x104A, "WACOH Corporation"  },
    { 0x104B, "CSM GmbH"  },
    { 0x104C, "AMCO TEC International Inc."  },
    { 0x104D, "Newport Corporation"  },
    { 0x104E, "Halliburton Energy Services"  },
    { 0x104F, "W B Electronics"  },
    { 0x1050, "Yubico AB"  },
    { 0x1051, "Nippon Printer Engineering Inc."  },
    { 0x1052, "U-Medica Inc."  },
    { 0x1053, "Immanuel Electronics Co., Ltd."  },
    { 0x1054, "BMS International Beheer N.V."  },
    { 0x1055, "Complex Micro Interconnection Co., Ltd."  },
    { 0x1056, "Hsin Chen Ent Co., Ltd."  },
    { 0x1057, "ON Semiconductor"  },
    { 0x1058, "Western Digital, Branded"  },
    { 0x1059, "Giesecke & Devrient GmbH"  },
    { 0x105A, "DDS, Inc."  },
    { 0x105B, "TOKIWA WEST Co., Ltd."  },
    { 0x105C, "Freeway Electronic Wire & Cable (Dongguan) Co., Ltd."  },
    { 0x105D, "Delkin Devices, Inc."  },
    { 0x105E, "Valence Semiconductor Design Limited"  },
    { 0x105F, "Chin Shong Enterprise Co., Ltd."  },
    { 0x1060, "Easthome Industrial Co., Ltd."  },
    { 0x1061, "Cardinal Components Inc."  },
    { 0x1062, "Sumitomo Electric Industries, Ltd."  },
    { 0x1063, "LPKF Laser & Electronics AG"  },
    { 0x1064, "INNOPLUS Co., Ltd."  },
    { 0x1065, "ImageQuest Co., Ltd."  },
    { 0x1066, "Eten Information Systems Co., Ltd."  },
    { 0x1067, "L-3 Communications"  },
    { 0x1068, "Micropi Elettronica"  },
    { 0x1069, "Easy Digital Concept"  },
    { 0x106A, "Loyal Legend Limited"  },
    { 0x106B, "MED Associates Inc. , sue@med-associates.com"  },
    { 0x106C, "Curitel Communications, Inc."  },
    { 0x106D, "San Chieh Manufacturing Ltd."  },
    { 0x106E, "ConectL"  },
    { 0x106F, "Money Controls"  },
    { 0x1070, "TAKAMISAWA CYBERNETICS CO., LTD."  },
    { 0x1071, "Paxton Access Ltd."  },
    { 0x1072, "FDI Matelec"  },
    { 0x1073, "Lifetron Co., Ltd."  },
    { 0x1074, "TECHNO SOFT SYSTEMNICS INC."  },
    { 0x1075, "TOKYO KEIKI INC."  },
    { 0x1076, "GCT Semiconductor, Inc."  },
    { 0x1077, "VoiceBox Technologies Inc."  },
    { 0x1078, "Maycom Co., Ltd."  },
    { 0x1079, "Suisei Electronics System Co., Ltd."  },
    { 0x107A, "Optionexist Limited"  },
    { 0x107B, "X E Systems Inc."  },
    { 0x107C, "Whelen Engineering Company Inc."  },
    { 0x107D, "Arlec Australia Limited"  },
    { 0x107E, "MIDORIYA ELECTRIC CO., LTD."  },
    { 0x107F, "KidzMouse, Inc."  },
    { 0x1080, "Musetel Co., Ltd."  },
    { 0x1081, "VG Electracon, Inc."  },
    { 0x1082, "Shin-Etsukaken Co., Ltd."  },
    { 0x1083, "CANON ELECTRONICS INC."  },
    { 0x1084, "PANTECH CO., LTD."  },
    { 0x1085, "Datalaster"  },
    { 0x1086, "Smart System Inc."  },
    { 0x1087, "Shanghai Ewaytek Co., Ltd."  },
    { 0x1088, "Archtek Telecom Co."  },
    { 0x1089, "On Track Innovations Ltd."  },
    { 0x108A, "Chloride Power Protection"  },
    { 0x108B, "Grand-tek Technology Co., Ltd."  },
    { 0x108C, "Robert Bosch GmbH"  },
    { 0x108D, "Mitsui Zosen Systems Research Inc."  },
    { 0x108E, "Lotes Co., Ltd."  },
    { 0x108F, "HIOKI E.E. CORPORATION"  },
    { 0x1090, "DSP Research Inc."  },
    { 0x1091, "DR. JOHANNES HEIDENHAIN GmbH"  },
    { 0x1092, "TOPDEK Semiconductor Inc."  },
    { 0x1093, "SongPro, Inc."  },
    { 0x1094, "NextEngine, Inc."  },
    { 0x1095, "Good Work Systems"  },
    { 0x1096, "NIO Corporation"  },
    { 0x1097, "Computational Systems Incorporated"  },
    { 0x1098, "Raytek Corp."  },
    { 0x1099, "Surface Optics Corporation"  },
    { 0x109A, "DATASOFT Systems GmbH"  },
    { 0x109B, "Qingdao Hisense Communication Co., Ltd."  },
    { 0x109C, "Electronic Trade Solutions Ltd."  },
    { 0x109D, "NAVIUS CO., LTD."  },
    { 0x109E, "Finger System Inc."  },
    { 0x109F, "eSOL Co., Ltd."  },
    { 0x10A0, "HIROTECH, INC."  },
    { 0x10A1, "target-systemelectronic gmbh"  },
    { 0x10A2, "HYUNDAI NETWORKS, INC."  },
    { 0x10A3, "MITSUBISHI MATERIALS CORPORATION"  },
    { 0x10A4, "Frontier Silicon Ltd."  },
    { 0x10A5, "FINGERPRINT CARDS AB"  },
    { 0x10A6, "SKYUP TECHNOLOGY CORPORATION"  },
    { 0x10A7, "3i techs Development Corp"  },
    { 0x10A8, "Imaging Devices, Inc."  },
    { 0x10A9, "SK Teletech Co., Ltd."  },
    { 0x10AA, "Cables To Go"  },
    { 0x10AB, "Universal Global Scientific Industrial Co., Ltd."  },
    { 0x10AC, "Honeywell, Inc."  },
    { 0x10AD, "Impact Instrumentation Inc."  },
    { 0x10AE, "Princeton Technology Corp."  },
    { 0x10AF, "Liebert Corporation"  },
    { 0x10B0, "IPmental Inc."  },
    { 0x10B1, "Safe Valley Inc."  },
    { 0x10B2, "Data East Corporation"  },
    { 0x10B3, "Roke Manor Research Limited"  },
    { 0x10B4, "Guardtec, Inc."  },
    { 0x10B5, "Comodo"  },
    { 0x10B6, "Dynojet Research, Inc."  },
    { 0x10B7, "VSM Medtech Ltd."  },
    { 0x10B8, "DIBCOM"  },
    { 0x10B9, "Prime Electronics & Satellitics, Inc."  },
    { 0x10BA, "Dong-Guan Sintai Optical Co., Ltd."  },
    { 0x10BB, "TM Technology Inc."  },
    { 0x10BC, "Dinging Technology Co., Ltd."  },
    { 0x10BD, "TMT TECHNOLOGY, INC."  },
    { 0x10BE, "KBM Electronic System Design"  },
    { 0x10BF, "Smarthome"  },
    { 0x10C0, "SougaSoft Co., Ltd."  },
    { 0x10C1, "Kyokuto Electric Co., Ltd."  },
    { 0x10C2, "Phasespace, Inc."  },
    { 0x10C3, "Universal Laser Systems"  },
    { 0x10C4, "Silicon Laboratories, Inc."  },
    { 0x10C5, "Sanei Electric Inc."  },
    { 0x10C6, "Intec, Inc."  },
    { 0x10C7, "Touchstone Technology Co., Ltd."  },
    { 0x10C8, "SIGMACOM CO., LTD."  },
    { 0x10C9, "ZUKEN Inc."  },
    { 0x10CA, "Xrosstech, Inc."  },
    { 0x10CB, "eratech"  },
    { 0x10CC, "GBM Connector Co., Ltd."  },
    { 0x10CD, "Kycon Inc."  },
    { 0x10CE, "Shinko Electric Co., Ltd."  },
    { 0x10CF, "Velleman Components"  },
    { 0x10D0, "Tokai University Educational System"  },
    { 0x10D1, "HBM GmbH"  },
    { 0x10D2, "Adams IT Services"  },
    { 0x10D3, "Trimos SA"  },
    { 0x10D4, "Man Boon Manufactory Ltd."  },
    { 0x10D5, "Uni Class Technology Co., Ltd."  },
    { 0x10D6, "Actions Semiconductor Co., Ltd."  },
    { 0x10D7, "Array Corporation"  },
    { 0x10D8, "ACTIKEY S.A."  },
    { 0x10D9, "Tecnova Corporation"  },
    { 0x10DA, "HOWTEL CO., LTD."  },
    { 0x10DB, "Prior Scientific Instruments Ltd."  },
    { 0x10DC, "Evolve Communications"  },
    { 0x10DD, "VerNova, Inc."  },
    { 0x10DE, "Authenex, Inc."  },
    { 0x10DF, "In-Win Development Inc."  },
    { 0x10E0, "Bella Corporation"  },
    { 0x10E1, "CABLEPLUS LTD."  },
    { 0x10E2, "Nada Electronics, Ltd."  },
    { 0x10E3, "tec5 AG"  },
    { 0x10E4, "Trans-Lux Corporation & Subsidiaries"  },
    { 0x10E5, "MACTek"  },
    { 0x10E6, "Altotec Hard- und Software GmbH"  },
    { 0x10E7, "dSPACE GmbH"  },
    { 0x10E8, "Kumahira Co., Ltd."  },
    { 0x10E9, "XIA LLC"  },
    { 0x10EA, "ELITRONIC s.r.o."  },
    { 0x10EB, "FREEBOX SA"  },
    { 0x10EC, "Vast Technologies Inc."  },
    { 0x10ED, "KDS USA, Inc."  },
    { 0x10EE, "Compuprint"  },
    { 0x10EF, "Integrity Instruments Inc."  },
    { 0x10F0, "Etronics Corp."  },
    { 0x10F1, "Inventec Multimedia & Telecom Corp."  },
    { 0x10F2, "Autonics Co., Ltd."  },
    { 0x10F3, "Vercel Development Inc."  },
    { 0x10F4, "INcoder Technology CO., Ltd."  },
    { 0x10F5, "Voyetra Turtle Beach, Inc."  },
    { 0x10F6, "IMAGENICS Co., Ltd."  },
    { 0x10F7, "Hando Computer Co., Ltd"  },
    { 0x10F8, "CESYS GmbH"  },
    { 0x10F9, "NSD Corporation"  },
    { 0x10FA, "CHINO Corporation"  },
    { 0x10FB, "Pictos Technologies, Inc."  },
    { 0x10FC, "MICRELEC"  },
    { 0x10FD, "Animation Technologies Inc."  },
    { 0x10FE, "Thrane & Thrane A/S"  },
    { 0x10FF, "Bellwave"  },
    { 0x1100, "VirTouch Ltd."  },
    { 0x1101, "EASYPASS INDUSTRIAL CO., LTD."  },
    { 0x1102, "Instrument Systems GmbH"  },
    { 0x1103, "Brain Products GmbH"  },
    { 0x1104, "TOA Corporation"  },
    { 0x1105, "MAP Medizin-Technologie GmbH"  },
    { 0x1106, "OrangeHouse Co., Ltd."  },
    { 0x1107, "CreamWare GmbH"  },
    { 0x1108, "BRIGHTCOM TECHNOLOGIES LTD."  },
    { 0x1109, "LG Industrial Systems Co., Ltd."  },
    { 0x110A, "Moxa Inc."  },
    { 0x110B, "NAKI INTERNATIONAL"  },
    { 0x110C, "Computer Network Technology"  },
    { 0x110D, "Hitachi Car Engineering Co., Ltd."  },
    { 0x110E, "Innotrac Diagnostics OY"  },
    { 0x110F, "OneVision Corporation"  },
    { 0x1110, "Analog Devices Canada Ltd."  },
    { 0x1111, "Siemens Healthcare Diagnostics Inc."  },
    { 0x1112, "Golden Bright (Sichuan) Electronic Technology Co Ltd"  },
    { 0x1113, "Medion AG"  },
    { 0x1114, "Psion Teklogix Inc."  },
    { 0x1115, "Data Link Co., Ltd."  },
    { 0x1116, "Compro Technology Inc."  },
    { 0x1117, "11 WAVE TECHNOLOGY, INC."  },
    { 0x1118, "MotoSAT"  },
    { 0x1119, "GCS General Control Systems GmbH"  },
    { 0x111A, "The Nippon Signal Co., Ltd."  },
    { 0x111B, "Kyusyu Ten Ltd."  },
    { 0x111C, "point electronic GmbH"  },
    { 0x111D, "Centon Electronics"  },
    { 0x111E, "VSO ELECTRONICS CO., LTD."  },
    { 0x111F, "BANCOR S.R.L."  },
    { 0x1120, "Voipac, s.r.o."  },
    { 0x1121, "Kore Technology Limited"  },
    { 0x1122, "Klein & Melgert Developments B.V."  },
    { 0x1123, "Hi-Tech Instruments, Inc."  },
    { 0x1124, "REnex Technology Limited"  },
    { 0x1125, "Industrial Computing Ltd."  },
    { 0x1126, "Protonic - Holland"  },
    { 0x1127, "BANK25 Co., Ltd."  },
    { 0x1128, "STEAG ETA-Optik GmbH"  },
    { 0x1129, "Jung Myung Telecom Co., Ltd."  },
    { 0x112A, "RedRat Ltd."  },
    { 0x112B, "Stenograph L.L.C."  },
    { 0x112C, "Ethics Organization of Computer Software"  },
    { 0x112D, "SYSMEX CORPORATION"  },
    { 0x112E, "Master Hill Electric Wire and Cable Co., Ltd."  },
    { 0x112F, "Cellon International"  },
    { 0x1130, "Tenx Technology, Inc."  },
    { 0x1131, "Integrated System Solution Corp."  },
    { 0x1132, "Visoduck discount GmbH"  },
    { 0x1133, "Sanei Electric Co., Ltd."  },
    { 0x1134, "Tri-L Data Systems, Inc."  },
    { 0x1135, "imo-elektronik GmbH"  },
    { 0x1136, "CTS ELECTRONICS"  },
    { 0x1137, "Beyond LSI, Inc."  },
    { 0x1138, "Greenwood Engineering A/S"  },
    { 0x1139, "Wavetrend"  },
    { 0x113B, "Hana Micron, Inc."  },
    { 0x113C, "Arintech Co., Ltd."  },
    { 0x113D, "Mapower Electronics Co. Ltd."  },
    { 0x113E, "KDK Electric Wire (H.K.) Co., Ltd."  },
    { 0x113F, "Integrated Biometrics"  },
    { 0x1140, "Ultra-Scan Corporation"  },
    { 0x1141, "V ONE MULTIMEDIA PTE LTD"  },
    { 0x1142, "CYBERSCAN TECH. INC."  },
    { 0x1143, "Wako Pure Chemical Industries, Ltd.."  },
    { 0x1144, "MURATA MACHINERY, LTD."  },
    { 0x1145, "Japan Radio Co., Ltd."  },
    { 0x1146, "Shimane SANYO Electric Co., Ltd."  },
    { 0x1147, "Ever Great Electric Wire and Cable Co., Ltd."  },
    { 0x1148, "KGS Corporation"  },
    { 0x1149, "TAMA TECH LAB CORP."  },
    { 0x114A, "TANITA Corporation (1)"  },
    { 0x114B, "Sphairon Technologies GmbH"  },
    { 0x114C, "Tinius Olsen Testing Machine Co., Inc."  },
    { 0x114D, "Alpha Imaging Technology Corp."  },
    { 0x114E, "Digital Electronics Corporation"  },
    { 0x114F, "WAVECOM"  },
    { 0x1150, "Don Alan Pty. Ltd."  },
    { 0x1151, "World Wide Licenses Limited"  },
    { 0x1152, "Codonics, Inc."  },
    { 0x1153, "Tritec Co., Ltd."  },
    { 0x1154, "BEB Industrie-Elektronik AG"  },
    { 0x1155, "DICESVA S.L."  },
    { 0x1156, "Cybertech bv"  },
    { 0x1157, "EKS Oy"  },
    { 0x1158, "Syn-Tech Systems Inc."  },
    { 0x1159, "Micro Application Laboratory Corp."  },
    { 0x115A, "Extreme Speed"  },
    { 0x115B, "Salix Technology Co., Ltd."  },
    { 0x115C, "CORESMA"  },
    { 0x115D, "ADTEK SYSTEM SCIENCE CO., LTD."  },
    { 0x115E, "Group Sense Ltd."  },
    { 0x115F, "Dataring Systems"  },
    { 0x1160, "Invocon, Inc."  },
    { 0x1161, "Port Denshi Co., Ltd."  },
    { 0x1162, "Secugen Corporation"  },
    { 0x1163, "DeLorme Publishing Inc."  },
    { 0x1164, "YUAN High-Tech Development Co., Ltd."  },
    { 0x1165, "Telson Electronics Co., Ltd."  },
    { 0x1166, "Bantam Interactive Technologies"  },
    { 0x1167, "Salient Systems Corporation"  },
    { 0x1168, "BizConn International Corp."  },
    { 0x1169, "Adirondack Optics"  },
    { 0x116A, "JJL Technologies, LLC"  },
    { 0x116B, "Pigeon Point Systems"  },
    { 0x116C, "SecureEye, Inc."  },
    { 0x116D, "Filmetrics, Inc."  },
    { 0x116E, "Gigastorage Corp."  },
    { 0x116F, "Silicon 10 Technology Corp."  },
    { 0x1170, "Tadiran Com. Ltd."  },
    { 0x1171, "CRE Technology Co., Ltd."  },
    { 0x1172, "Telegate Co., Ltd."  },
    { 0x1173, "Esko-Graphics"  },
    { 0x1174, "Techno-One Co., Ltd."  },
    { 0x1175, "Sheng Yih Technologies Co., Ltd."  },
    { 0x1176, "Japan Touchscreen Distributions, Inc."  },
    { 0x1177, "Hitachi Communication Technologies, Ltd."  },
    { 0x1178, "Kamaya Electric Co., Ltd."  },
    { 0x1179, "Bio-logic Systems Corp."  },
    { 0x117A, "Ishikawa Seisakusho, Ltd."  },
    { 0x117B, "Primetech Engineering Corporation"  },
    { 0x117C, "SOFTIDEA s.r.o."  },
    { 0x117D, "Santa Electronic Inc."  },
    { 0x117E, "JNC, Inc."  },
    { 0x117F, "Princeton Technology, Ltd."  },
    { 0x1180, "Spectra-Physics"  },
    { 0x1181, "USB NET"  },
    { 0x1182, "Venture Corporation Limited"  },
    { 0x1183, "Digital Dream Co. Europe Ltd."  },
    { 0x1184, "Kyocera Elco Corporation"  },
    { 0x1185, "Projectiondesign AS"  },
    { 0x1186, "Scientec System"  },
    { 0x1187, "Techno Valley Co., Ltd."  },
    { 0x1188, "Bloomberg L.P."  },
    { 0x1189, "Trisat IndTry Computer Co. LTD."  },
    { 0x118A, "KEBA AG"  },
    { 0x118B, "AXIOMTEK Co., Ltd."  },
    { 0x118C, "INFINIT GmbH"  },
    { 0x118D, "Gould Instrument Systems"  },
    { 0x118E, "Hermstedt AG"  },
    { 0x118F, "You Yang Technology Co., Ltd."  },
    { 0x1190, "Tripace"  },
    { 0x1191, "Loyalty Founder Enterprise Co., Ltd."  },
    { 0x1192, "Matsusada Precision Inc."  },
    { 0x1193, "H2I TECHNOLOGIES"  },
    { 0x1194, "GLORY AZ System Co., Ltd."  },
    { 0x1195, "ELECTROLINE"  },
    { 0x1196, "Yankee Robotics, LLC"  },
    { 0x1197, "Technoimagia Co., Ltd."  },
    { 0x1198, "StarShine Technology Corp."  },
    { 0x1199, "Sierra Wireless Inc."  },
    { 0x119A, "DONG GUAN JALINK ELECTRONICES CO.,LTD"  },
    { 0x119B, "ruwido austria GmbH"  },
    { 0x119C, "SK MEDICAL ELECTRONICS CO.,LTD"  },
    { 0x119D, "Saka-Techno Science Co., Ltd."  },
    { 0x119E, "Engineered Audio, LLC."  },
    { 0x119F, "TECNOS CO., LTD."  },
    { 0x11A0, "Chipcon"  },
    { 0x11A1, "Mikrap AG"  },
    { 0x11A2, "SitecSoft Co., Ltd."  },
    { 0x11A3, "Technovas Co., Ltd."  },
    { 0x11A4, "THE FURUKAWA ELECTRIC CO., LTD."  },
    { 0x11A5, "TOKYO RIKAKIKAI CO., LTD."  },
    { 0x11A6, "VRmagic GmbH"  },
    { 0x11A7, "SNAPSHIELD LTD."  },
    { 0x11A8, "Hoeft & Wessel AG"  },
    { 0x11A9, "Parker Hannifin"  },
    { 0x11AA, "GlobalMedia Group, LLC"  },
    { 0x11AB, "Exito Electronics Co., Ltd."  },
    { 0x11AC, "Nike, Inc."  },
    { 0x11AD, "SANWA ELECTRIC INSTRUMENT CO., LTD."  },
    { 0x11AE, "Stoelting Co."  },
    { 0x11AF, "Valence Semiconductor"  },
    { 0x11B0, "ATECH FLASH TECHNOLOGY"  },
    { 0x11B1, "New Motion Tec. Corp."  },
    { 0x11B2, "Bizerba GmbH & Co. KG"  },
    { 0x11B3, "MONYA Corporation"  },
    { 0x11B4, "SPIELO"  },
    { 0x11B5, "ADVANTECH EQUIPMENT CORP."  },
    { 0x11B6, "Diskware Co., Ltd."  },
    { 0x11B7, "Embla"  },
    { 0x11B8, "CROSS S&T Inc."  },
    { 0x11B9, "IST Electronics, Inc."  },
    { 0x11BA, "Sasem Co., Ltd."  },
    { 0x11BB, "YaMu Solutions"  },
    { 0x11BC, "Taipei EELY-ECW Co., Ltd."  },
    { 0x11BD, "UBINETICS LIMITED"  },
    { 0x11BE, "Martin Professional A/S"  },
    { 0x11BF, "SonoSite, Inc."  },
    { 0x11C0, "Sanmos Microelectronics Corp."  },
    { 0x11C1, "Wako Giken Kogyo Co., Ltd."  },
    { 0x11C2, "EYESPYFX"  },
    { 0x11C3, "Kaizen Frogpad, LLC"  },
    { 0x11C4, "DALLANTBANK, INC."  },
    { 0x11C5, "INMAX TECHNOLOGY CORP."  },
    { 0x11C6, "Guzik Technical Enterprises"  },
    { 0x11C7, "Reliance Electric Limited"  },
    { 0x11C8, "Fullcom Technology Corp."  },
    { 0x11C9, "Monster Cable Products, Inc."  },
    { 0x11CA, "VeriFone"  },
    { 0x11CB, "Magni Systems, Inc."  },
    { 0x11CC, "AIM SRL"  },
    { 0x11CD, "KTEK Co., Ltd."  },
    { 0x11CE, "Argolis BV"  },
    { 0x11CF, "Nemoto Kyorindo Co., Ltd."  },
    { 0x11D0, "TOPCON CORPORATION, Opthalmic & Medical Instrument Dept"  },
    { 0x11D1, "Far Touch Inc."  },
    { 0x11D2, "BW Technologies Ltd."  },
    { 0x11D3, "Elias Technology, Inc."  },
    { 0x11D4, "Unitac Co., Ltd."  },
    { 0x11D5, "Polyvision Corporation"  },
    { 0x11D6, "FUJIFILM AXIA CO., LTD."  },
    { 0x11D7, "Kokusai Electric Alpha Co., Ltd."  },
    { 0x11D8, "Zybertek"  },
    { 0x11D9, "Itronix Corporation"  },
    { 0x11DA, "Tekscan, Inc."  },
    { 0x11DB, "Topfield Co., Ltd."  },
    { 0x11DC, "STELECTRIC A/S"  },
    { 0x11DD, "DRAGONCHIP LTD."  },
    { 0x11DE, "La Generale Multimedia"  },
    { 0x11DF, "ROI Computer AG"  },
    { 0x11E0, "SUNX Limited"  },
    { 0x11E1, "Encentuate Pte. Ltd."  },
    { 0x11E2, "SPECSOFT CONSULTING INC"  },
    { 0x11E3, "GfS-Hofheim"  },
    { 0x11E4, "STANDARD ELECTRONICS TELECOM INC."  },
    { 0x11E5, "CHUFON Technology Co., Ltd."  },
    { 0x11E6, "K.I. Technology Co. Ltd."  },
    { 0x11E7, "Rockford Corporation"  },
    { 0x11E8, "NAAT Technology Corp."  },
    { 0x11E9, "Wincan Technology Co., Ltd."  },
    { 0x11EA, "Panram International Corp."  },
    { 0x11EB, "VTech Innovation L.P. dba Advanced American Telephones"  },
    { 0x11EC, "Hitachi Computer Peripherals Co., Ltd."  },
    { 0x11ED, "Shimizu Technology Inc."  },
    { 0x11EE, "ASAHI ELECTRIC CO., LTD."  },
    { 0x11EF, "Cableplus Industrial Co., Ltd."  },
    { 0x11F0, "Matthew Ward Solutions"  },
    { 0x11F1, "Cal-Comp Electronics (Thailand) Public Co., Ltd."  },
    { 0x11F2, "Chain Tay Technology Co., Ltd."  },
    { 0x11F3, "ROUND Co., Ltd."  },
    { 0x11F4, "Kyoritsu Electric Corporation"  },
    { 0x11F5, "Siemens Mobile Phones"  },
    { 0x11F6, "NetIndex Inc."  },
    { 0x11F7, "ALCATEL BUSINESS SYSTEMS"  },
    { 0x11F8, "BodyMedia, Inc."  },
    { 0x11F9, "Cryptocard Corporation"  },
    { 0x11FA, "Code Corporation"  },
    { 0x11FB, "HORIBA, Ltd."  },
    { 0x11FC, "ANCOT CORPORATION"  },
    { 0x11FD, "EKE-Electronics Ltd."  },
    { 0x11FE, "SHENZHEN CHANGXUNXING ELECTRONIC CO., LTD."  },
    { 0x11FF, "LITE STAR ELECTRONICS TECHNOLOGIES, CO. LTD."  },
    { 0x1200, "Spellman High Voltage Electronics Corp."  },
    { 0x1201, "Practical Automation, Inc."  },
    { 0x1202, "KUK JE TONG SHIN CO., LTD."  },
    { 0x1203, "Taiwan Semiconductor Co., Ltd."  },
    { 0x1204, "SATEC"  },
    { 0x1205, "NV ADB TTV TECHNOLOGIES SA"  },
    { 0x1206, "Synnix Technology Co."  },
    { 0x1207, "Cardinal Health UK 232 Ltd."  },
    { 0x1208, "Seiko Epson Corp.- System Device"  },
    { 0x120A, "Wintest Corp."  },
    { 0x120B, "Dension Audio Systems Ltd."  },
    { 0x120C, "ALF, Inc."  },
    { 0x120D, "(AVL) DiTEST Fahrzeugdiagnose GmbH"  },
    { 0x120E, "HUDSON SOFT CO., LTD."  },
    { 0x120F, "Magellan Navigation, Inc."  },
    { 0x1210, "Harman"  },
    { 0x1211, "COSMED S.r.l."  },
    { 0x1212, "D'Crypt Pte Ltd."  },
    { 0x1213, "Fukko System Co., Ltd."  },
    { 0x1214, "Dr. Bott KG"  },
    { 0x1215, "Towa Engineering Corporation"  },
    { 0x1216, "ProMinent Dosiertechnik GmbH"  },
    { 0x1217, "Goyatek Technology Inc."  },
    { 0x1218, "Geutebrueck GmbH"  },
    { 0x1219, "COMPAL COMMUNICATIONS, INC."  },
    { 0x121A, "TimeKeeping Systems, Inc."  },
    { 0x121B, "FEC Inc."  },
    { 0x121C, "Raysis Co., Ltd."  },
    { 0x121D, "Intelligent Computer Solutions"  },
    { 0x121E, "Jungsoft Co., Ltd."  },
    { 0x121F, "Panini S.P.A."  },
    { 0x1220, "TC Group A/S"  },
    { 0x1221, "Averatec, Inc."  },
    { 0x1222, "Tipro Keyboards D.O.O."  },
    { 0x1223, "SKYCABLE ENTERPRISE CO., LTD."  },
    { 0x1224, "SCATT, ZAO"  },
    { 0x1225, "HI-P Tech Corporation"  },
    { 0x1226, "Keihin Corporation"  },
    { 0x1227, "T-RAC INTERNATIONAL, INC."  },
    { 0x1228, "DATAPAQ"  },
    { 0x1229, "EPO Science & Technology Inc."  },
    { 0x122A, "WABCO GmbH & Co., OHG"  },
    { 0x122B, "Midas Lab Inc."  },
    { 0x122C, "Qbtech AB"  },
    { 0x122D, "Hitachi Information & Control Solutions, Ltd."  },
    { 0x122E, "IOLINE"  },
    { 0x122F, "Takimaging"  },
    { 0x1230, "MIPSABG Chipidea, Lda."  },
    { 0x1231, "CHI MEI COMMUNICATION SYSTEMS, INC."  },
    { 0x1232, "SolitonWave Co., Ltd."  },
    { 0x1233, "Targa Systems Div. L-3 Communications"  },
    { 0x1234, "Micro Science Co., Ltd."  },
    { 0x1235, "Focusrite Audio Engineering Ltd"  },
    { 0x1236, "Nozaki Insatsu Shigyo Co., Ltd."  },
    { 0x1237, "Technowave Ltd."  },
    { 0x1238, "Bridgekey Corp."  },
    { 0x1239, "Antex Electronics"  },
    { 0x123A, "Spectra Technologies Holdings Co., Ltd."  },
    { 0x123B, "De La Rue Systems Automatizacao"  },
    { 0x123C, "K-Won C & C Co., Ltd."  },
    { 0x123D, "Microplex Printware AG"  },
    { 0x123E, "A.T. WORKS, Inc."  },
    { 0x123F, "DURAPOWER TECHNOLOGY LTD."  },
    { 0x1240, "HUMUS MOG CO., LTD."  },
    { 0x1241, "OTSUKA ELECTRONICS CO., LTD."  },
    { 0x1242, "MAC SYSTEM CO., LTD."  },
    { 0x1243, "Fujikura Ltd., Fiber Optic System Division"  },
    { 0x1244, "DResearch Digital Media Systems GmbH"  },
    { 0x1245, "R/D Tech Inc."  },
    { 0x1246, "CTO S.p.A."  },
    { 0x1247, "JAPAN PRECISION INSTRUMENTS, INC."  },
    { 0x1248, "Vector Informatik GmbH"  },
    { 0x1249, "TRACESPAN Communications Ltd."  },
    { 0x124A, "AirVast Technology Inc."  },
    { 0x124B, "NYKO Technologies, Inc."  },
    { 0x124C, "MEMORY EXPERTS International Inc."  },
    { 0x124D, "Just Rams PLC"  },
    { 0x124E, "YEM Inc."  },
    { 0x124F, "Beijing JingHuiJiaDe Tech. Co., Ltd."  },
    { 0x1250, "TECMAG"  },
    { 0x1251, "Iwaya Corporation"  },
    { 0x1252, "Nextway Co., Ltd."  },
    { 0x1253, "Erebus Limited"  },
    { 0x1254, "Empirical Systems"  },
    { 0x1255, "ASCII Solutions, Inc."  },
    { 0x1256, "Spectronic Denmark A/S"  },
    { 0x1257, "AudioScience"  },
    { 0x1258, "Continental Automotive Trading UK Ltd."  },
    { 0x1259, "Deutsche Montan Technologie GmbH"  },
    { 0x125A, "Shintake Sangyo Co., Ltd."  },
    { 0x125B, "VIDEX"  },
    { 0x125C, "Apogee Instruments, Inc."  },
    { 0x125D, "Advanced Technology (UK) PLC"  },
    { 0x125E, "Bosch Automotive Service Solutions"  },
    { 0x125F, "ADATA Technology Co., Ltd."  },
    { 0x1260, "Cores Inc."  },
    { 0x1261, "All Ring Tech Co., Ltd."  },
    { 0x1262, "MICRO VISION CO., LTD."  },
    { 0x1263, "Opti Japan Corporation"  },
    { 0x1264, "Covidien Energy-based Devices"  },
    { 0x1265, "Good Mind Industries Co., Ltd."  },
    { 0x1266, "Pirelli Cavi e Sistemi Telecom S.p.A."  },
    { 0x1267, "SILCOR"  },
    { 0x1268, "icube Corp."  },
    { 0x1269, "Sequoia Voting Systems Inc."  },
    { 0x126A, "CHH Electronics Ltd."  },
    { 0x126B, "Veridian Systems"  },
    { 0x126C, "Aristocrat Technologies"  },
    { 0x126D, "Bel Stewart"  },
    { 0x126E, "Strobe Data, Inc."  },
    { 0x126F, "TwinMOS Technologies ME FZE"  },
    { 0x1270, "Procomp Informatics Ltd."  },
    { 0x1271, "Foxda Technology Industrial (Shenzhen) Co., Ltd."  },
    { 0x1272, "Linear Technology Corporation"  },
    { 0x1273, "HANEX Co., Ltd."  },
    { 0x1274, "Matin, Inc."  },
    { 0x1275, "Xaxero Marine Software Engineering Ltd."  },
    { 0x1276, "QVS"  },
    { 0x1277, "Silicon Media Inc."  },
    { 0x1278, "Starlight Xpress Ltd."  },
    { 0x1279, "Cheesecote Mountain Camac"  },
    { 0x127A, "Electrophysics Corp."  },
    { 0x127B, "The Technology Partnership (TTP)"  },
    { 0x127C, "Comarco Wireless"  },
    { 0x127D, "RAiO Technology Inc."  },
    { 0x127E, "Hugelent Telecommunication (SuZhou) Co., Ltd."  },
    { 0x127F, "IPACS Hans-Borchers-Gruentjens GbR (IPACS)"  },
    { 0x1280, "Animeta Systems Inc."  },
    { 0x1281, "Gean Sen Electronic Co., Ltd."  },
    { 0x1282, "Falco Electronics Mexico"  },
    { 0x1283, "zebris Medizintechnik GmbH"  },
    { 0x1284, "YEC Co., Ltd."  },
    { 0x1285, "Schindler Aufzuge AG"  },
    { 0x1286, "MARVELL SEMICONDUCTOR, INC."  },
    { 0x1287, "Infomove Co., Ltd."  },
    { 0x1288, "Micro Advantage Inc."  },
    { 0x1289, "Nippon Telesoft Co., Ltd."  },
    { 0x128A, "Asia Vital Components Co., Ltd."  },
    { 0x128B, "Medicapture, Inc."  },
    { 0x128C, "ITW Food Equipment Group, LLC dba Hobart Corporation"  },
    { 0x128D, "Testo AG"  },
    { 0x128E, "Stormblue Co., Ltd."  },
    { 0x128F, "Guidant Corporation"  },
    { 0x1290, "Musicus GmbH"  },
    { 0x1291, "Flarion Technologies"  },
    { 0x1292, "Fire International Ltd."  },
    { 0x1293, "Mitsubishi Electric Engineering Co., Ltd."  },
    { 0x1294, "RISO KAGAKU CORP."  },
    { 0x1295, "A & G Souzioni Digitali"  },
    { 0x1296, "RadioScape"  },
    { 0x1297, "DEKTEC Digital Video B.V."  },
    { 0x1298, "Genlyte Controls"  },
    { 0x1299, "DGStation Co., Ltd."  },
    { 0x129A, "PULSTEC INDUSTRIAL CO., LTD."  },
    { 0x129B, "CyberTAN Technology Inc."  },
    { 0x129C, "Min Aik Technology Co., Ltd."  },
    { 0x129D, "Yueqing Longhua Electronics Factory"  },
    { 0x129E, "Aceeca Limited"  },
    { 0x129F, "Howtek Devices Corp."  },
    { 0x12A0, "CDC Point S.p.A."  },
    { 0x12A1, "Tohken Co., Ltd."  },
    { 0x12A2, "E28 (Shanghai) Ltd."  },
    { 0x12A3, "KENT WORLD CO., LTD."  },
    { 0x12A4, "Guangdong Matsunichi Communications Technology Co., Ltd"  },
    { 0x12A5, "Sola/Hevi-Duty"  },
    { 0x12A6, "ULVAC-PHI, Inc."  },
    { 0x12A7, "Trendchip Technologies Corp."  },
    { 0x12A8, "Clovertech Inc."  },
    { 0x12A9, "Sunwave Technology Corp."  },
    { 0x12AA, "Bustec Production Ltd."  },
    { 0x12AB, "Honey Bee (Hong Kong) Limited"  },
    { 0x12AC, "Compact Light System Norway A/S"  },
    { 0x12AD, "Asahi Seiko Co., Ltd."  },
    { 0x12AE, "Matsunichi Communication Holdings Limited"  },
    { 0x12AF, "Baldor UK Ltd."  },
    { 0x12B0, "Axciton Systems, Inc."  },
    { 0x12B1, "HIMECS CO., LTD."  },
    { 0x12B2, "DICKSON Company"  },
    { 0x12B3, "Megaforce Company Ltd."  },
    { 0x12B4, "Hanchang System Corporation"  },
    { 0x12B5, "World Touch Gaming , Inc."  },
    { 0x12B6, "Naito Densei Machida Mfg. Co., Ltd."  },
    { 0x12B7, "Genesis Microchip Inc."  },
    { 0x12B8, "Zhejiang Xinya Electronic Technology Co., Ltd."  },
    { 0x12B9, "Freehand Systems, Inc."  },
    { 0x12BA, "Sony Computer Entertainment America"  },
    { 0x12BB, "Paltronics, Inc."  },
    { 0x12BC, "Hakusan Corporation"  },
    { 0x12BD, "Sun Light Application Co., Ltd."  },
    { 0x12BE, "Dynex Technologies"  },
    { 0x12BF, "Matrix Multimedia Ltd."  },
    { 0x12C0, "Sencore, Inc."  },
    { 0x12C1, "ARTRAY CO., LTD."  },
    { 0x12C2, "HHB Communications Ltd."  },
    { 0x12C3, "Fiso Technologies, Inc."  },
    { 0x12C4, "Autocue Ltd."  },
    { 0x12C5, "XN Technologies, Inc."  },
    { 0x12C6, "Bosch Security Systems"  },
    { 0x12C7, "Hismartech Co., Ltd."  },
    { 0x12C8, "XiMeta Inc."  },
    { 0x12C9, "Newmen Technology Corp. Ltd."  },
    { 0x12CA, "Cables To Go International Manufacturing Co., Ltd."  },
    { 0x12CB, "Dallmeier electronic GmbH"  },
    { 0x12CC, "Printherm"  },
    { 0x12CD, "Cables Unlimited"  },
    { 0x12CE, "Hakko Electronics Co., Ltd."  },
    { 0x12CF, "Dexin Corporation"  },
    { 0x12D0, "ITG Research & Development Center"  },
    { 0x12D1, "Huawei Technologies Co., Ltd."  },
    { 0x12D2, "LINE TECH INDUSTRIAL CO., LTD."  },
    { 0x12D3, "Linak A/S"  },
    { 0x12D4, "Infonics Pty. Limited"  },
    { 0x12D5, "Strategic Vista Corp."  },
    { 0x12D6, "EMS Dr. Thomas Wuensche"  },
    { 0x12D7, "Better Holdings (HK) Limited"  },
    { 0x12D8, "Araneus Information Systems Oy"  },
    { 0x12D9, "DIGITFAB INTERNATIONAL CO., LTD."  },
    { 0x12DA, "Simavionics, Inc."  },
    { 0x12DB, "Planar Systems, Inc."  },
    { 0x12DC, "MMGEAR Co., Ltd."  },
    { 0x12DD, "JFE Advantech Co., Ltd."  },
    { 0x12DE, "National Display Systems"  },
    { 0x12DF, "Sumitomo 3M Limited"  },
    { 0x12E0, "Electronica Mecanica Y Control S.A."  },
    { 0x12E1, "FDK CORPORATION"  },
    { 0x12E2, "Bonso Electronic Ltd."  },
    { 0x12E3, "1417188 Ontario Ltd."  },
    { 0x12E4, "Bruel & Kjaer Sound & Vibration Meas. A/S"  },
    { 0x12E5, "Interactive Computer Products, Inc."  },
    { 0x12E6, "Waldorf-Music AG"  },
    { 0x12E7, "Sugiyama Electron Co., Ltd."  },
    { 0x12E8, "ZAN Messgeraete"  },
    { 0x12E9, "Mindspeed Technologies"  },
    { 0x12EA, "Microlink Systems"  },
    { 0x12EB, "MITSUI & CO., LTD."  },
    { 0x12EC, "KYORITSU ELECTRICAL INSTRUMENTS WORKS, LTD. (R&D Center"  },
    { 0x12ED, "Techno Kit Corporation"  },
    { 0x12EE, "Avery Dennison Deutschland GmbH"  },
    { 0x12EF, "Tapwave, Inc."  },
    { 0x12F0, "KROHNE"  },
    { 0x12F1, "OHIRA GIKEN, IND. CO., LTD."  },
    { 0x12F2, "VIEWPLUS TECHNOLOGIES, INC."  },
    { 0x12F3, "FORMOSA TELETEK CORPORATION"  },
    { 0x12F4, "Glovic Electronics Corp."  },
    { 0x12F5, "Dynamic System Electronics Corp."  },
    { 0x12F6, "Aichi Tokei Denki Co., Ltd."  },
    { 0x12F7, "Memorex Products, Inc."  },
    { 0x12F8, "Evolution Technologies, Inc."  },
    { 0x12F9, "RF-LINK SYSTEMS, INC."  },
    { 0x12FA, "RF Micro Devices"  },
    { 0x12FB, "SSD JAPAN CO., Ltd"  },
    { 0x12FC, "eGenium S.r.l."  },
    { 0x12FD, "AIN COMM. TECHNOLOGY CO., LTD."  },
    { 0x12FE, "E.U CONNECTOR(M) SDN BHD."  },
    { 0x12FF, "Fascinating Electronics, Inc."  },
    { 0x1300, "Muscle Corporation"  },
    { 0x1301, "Woehler Messgeraete Kehrgeraete GmbH"  },
    { 0x1302, "Wildseed Ltd."  },
    { 0x1303, "Lloyd Research (Projects) Ltd."  },
    { 0x1304, "MEDIALINK-I, Inc."  },
    { 0x1305, "ELSE Ltd."  },
    { 0x1306, "Torcon Instruments Inc."  },
    { 0x1307, "USBest Technology Inc."  },
    { 0x1308, "Precision Photonics Corp."  },
    { 0x1309, "Sabine, Inc."  },
    { 0x130A, "SIBATA SCIENTIFIC TECHNOLOGY, LTD."  },
    { 0x130B, "MPC Products"  },
    { 0x130C, "Quest Technologies"  },
    { 0x130D, "Loyal Technology Corporation"  },
    { 0x130E, "Microlink Communications Inc."  },
    { 0x130F, "AGFA NDT, Krautkramer Ultrasonic Systems"  },
    { 0x1310, "Air2U Inc."  },
    { 0x1311, "EDX Epi-Scan Corp"  },
    { 0x1312, "ICS Electronics"  },
    { 0x1313, "THORLABS, INC"  },
    { 0x1314, "Ryoko Electric Co., Ltd."  },
    { 0x1315, "Prairie Systems & Equip. Ltd. O/A Massload Technologies"  },
    { 0x1316, "JUNGLE Inc"  },
    { 0x1317, "PC-CRAFT Co., Ltd."  },
    { 0x1318, "O'RITE TECHNOLOGY Co., Ltd."  },
    { 0x1319, "Peekel Instruments B.V."  },
    { 0x131A, "VERYWELL CO., LTD."  },
    { 0x131B, "Rowley Associates Ltd."  },
    { 0x131C, "Staples, Inc."  },
    { 0x131D, "Natural Point"  },
    { 0x131E, "Duerr Dental GmbH & Co., KG"  },
    { 0x131F, "Ayuttha Technology Corp."  },
    { 0x1320, "Jaguar International Corporation"  },
    { 0x1321, "Lectrosonics, Inc."  },
    { 0x1322, "Z/I Imaging"  },
    { 0x1323, "Zeustech Company Limited"  },
    { 0x1324, "H-Mod, Inc."  },
    { 0x1325, "Austriamicrosystems AG"  },
    { 0x1326, "Force Control Industries Inc."  },
    { 0x1327, "Avtec, Inc."  },
    { 0x1328, "Iris Power Engineering"  },
    { 0x1329, "Appairent Technologies, Inc."  },
    { 0x132A, "Envara"  },
    { 0x132B, "Konica Minolta, Inc."  },
    { 0x132C, "Le Prestique International (H.K.) Ltd."  },
    { 0x132D, "GE Healthcare Life Sciences"  },
    { 0x132E, "Kwang Jang Corporation"  },
    { 0x132F, "ViALUX GmbH"  },
    { 0x1330, "ALFANUCLEAR S.A."  },
    { 0x1331, "Panic Inc."  },
    { 0x1332, "Moral Follow System Co., Ltd."  },
    { 0x1333, "Ultra Electronics Precision Air & Land Systems"  },
    { 0x1334, "ADC Corporation"  },
    { 0x1335, "PLUS Corporation"  },
    { 0x1336, "IMM-Gruppe"  },
    { 0x1337, "Radiant Networks Plc"  },
    { 0x1338, "IT CONCEPTS LLC"  },
    { 0x1339, "Akashi Corporation"  },
    { 0x133A, "Vyyo Inc."  },
    { 0x133B, "FLASH SUPPORT GROUP, INC."  },
    { 0x133C, "G-Design Technology"  },
    { 0x133D, "Jasco Products Company"  },
    { 0x133E, "Kemper Digital GmbH"  },
    { 0x133F, "Hwayoung RF Solution Inc."  },
    { 0x1340, "Escherlogic Inc."  },
    { 0x1341, "Lavry Engineering"  },
    { 0x1342, "Sutter Instrument Company"  },
    { 0x1343, "Heiwa Tokei Mfg. Co., Ltd"  },
    { 0x1344, "TCI, Inc. d/b/a TCI Medical"  },
    { 0x1345, "Sino Lite Technology Corp."  },
    { 0x1346, "Mediatek Corp."  },
    { 0x1347, "Moravian Instruments, Inc."  },
    { 0x1348, "Katsuragawa Electric Co., Ltd."  },
    { 0x1349, "Esaote/Pie Medical Equipment"  },
    { 0x134A, "iX Group"  },
    { 0x134B, "El Pusk Co., Ltd."  },
    { 0x134C, "Panjit International Inc."  },
    { 0x134D, "Danfoss Drives A/S"  },
    { 0x134E, "Digby's Bitpile, Inc. D.B.A. D Bit"  },
    { 0x134F, "Addvalue Communications Pte Ltd."  },
    { 0x1350, "UniqueICs, LLC"  },
    { 0x1351, "Crossware Associates"  },
    { 0x1352, "Km2Net"  },
    { 0x1353, "Shenzhen Coship Software Co., Ltd."  },
    { 0x1354, "FACTS Engineering LLC"  },
    { 0x1355, "Ethicon Endo-Surgery, Inc."  },
    { 0x1356, "Techpoint Electric Wire & Cable Co., Ltd."  },
    { 0x1357, "P & E Microcomputer Systems, Inc."  },
    { 0x1358, "SKYLIGHT DIGITAL INC."  },
    { 0x1359, "RKC INSTRUMENT INC."  },
    { 0x135A, "URMET TLC S.p.A. - Servizio Amministrativo"  },
    { 0x135B, "M-System Co., Ltd."  },
    { 0x135C, "Real-Time Essentials, Inc."  },
    { 0x135D, "ALGOTEX SRL"  },
    { 0x135E, "Insta Elektro GmbH"  },
    { 0x135F, "Control Development, Inc."  },
    { 0x1360, "FREETRON COM LTD."  },
    { 0x1361, "Thinktel Korea Co., Ltd."  },
    { 0x1362, "IMAGICA Corp."  },
    { 0x1363, "Axsun Technologies, Inc."  },
    { 0x1364, "SHARP TAKAYA ELECTRONICS INDUSTRY CO., LTD."  },
    { 0x1365, "TOYO JIKI INDUSTRY CO., LTD."  },
    { 0x1366, "SEGGER Microcontroller Systems GmbH"  },
    { 0x1367, "The Soundbeam Project"  },
    { 0x1368, "TelePaq Technology Inc."  },
    { 0x1369, "FASL LLC."  },
    { 0x136A, "Pelco"  },
    { 0x136B, "STEC"  },
    { 0x136C, "Datastor Technology Co., Ltd."  },
    { 0x136D, "Brainchild"  },
    { 0x136E, "Andor Technology"  },
    { 0x136F, "Nielsen Media Research"  },
    { 0x1370, "Swissbit AG"  },
    { 0x1371, "Micro Technology Co., Ltd."  },
    { 0x1372, "AMAC Tek Co., Ltd."  },
    { 0x1373, "Radical Research, Inc."  },
    { 0x1374, "American Anko Co."  },
    { 0x1375, "TCL MOBILE COMMUNICATION CO., LTD."  },
    { 0x1376, "Vimtron Electronics Co., Ltd."  },
    { 0x1377, "Sennheiser Electronic"  },
    { 0x1378, "HIRATA Corporation"  },
    { 0x1379, "Inprocomm, Inc."  },
    { 0x137A, "Weldon Technologies, Inc."  },
    { 0x137B, "SCAPS GmbH"  },
    { 0x137C, "Yaskawa Electric Corporation"  },
    { 0x137D, "Diodes Incorporated"  },
    { 0x137E, "XL Microwave, Inc."  },
    { 0x137F, "Sata Hi Tech Services"  },
    { 0x1380, "Staveley Instruments"  },
    { 0x1381, "N-LINE SYSTEM CO., LTD."  },
    { 0x1382, "Systemware Inc."  },
    { 0x1383, "Application Corporation"  },
    { 0x1384, "Device Drivers Limited"  },
    { 0x1385, "Variscite Ltd."  },
    { 0x1386, "SCD Tech Inc."  },
    { 0x1387, "Advanced Technical Group"  },
    { 0x1388, "Southern Vision Systems, Inc."  },
    { 0x1389, "Coolnection Technology Co., Ltd."  },
    { 0x138A, "Validity Inc."  },
    { 0x138B, "AMS Limited, Integrated Systems"  },
    { 0x138C, "Fortemedia, Inc."  },
    { 0x138D, "CPI GmbH"  },
    { 0x138E, "RAISONANCE"  },
    { 0x138F, "Saia-Burgess Controls Ltd."  },
    { 0x1390, "TomTom International B.V."  },
    { 0x1391, "IdealTEK"  },
    { 0x1392, "SAGE INSTRUMENTS"  },
    { 0x1393, "ELNEC s.r.o."  },
    { 0x1394, "Gemini 2000 Ltd."  },
    { 0x1395, "Sennheiser Communications A/S"  },
    { 0x1396, "Greenliant Systems, Inc."  },
    { 0x1397, "Behringer Spezielle Studiotechnik GmbH"  },
    { 0x1398, "Nintendo of America"  },
    { 0x1399, "Thai Wonderful Wire Cable Co., Ltd."  },
    { 0x139A, "Infinitec Co., Ltd."  },
    { 0x139B, "Thomas Enterprises, Inc."  },
    { 0x139C, "Deltronics"  },
    { 0x139D, "Digisafe Pte. Ltd."  },
    { 0x139E, "Valueplus Inc."  },
    { 0x139F, "Audio Technology Switzerland SA"  },
    { 0x13A0, "Essilor International"  },
    { 0x13A1, "Canas Co., Ltd."  },
    { 0x13A2, "Pesa Switching Systems, Inc."  },
    { 0x13A3, "Dynon Instruments"  },
    { 0x13A4, "Equipment Systems & Devices"  },
    { 0x13A5, "Sammy Corporation"  },
    { 0x13A6, "Jeppesen Sanderson Inc."  },
    { 0x13A7, "Circuit Design, Inc."  },
    { 0x13A8, "Grandtec Electronic Corp"  },
    { 0x13A9, "YAMAMOTO-MS CO., LTD."  },
    { 0x13AA, "Sinar Electronics Limited"  },
    { 0x13AB, "MicroMade Galka i Drozdz sp.j"  },
    { 0x13AC, "DAQ Systems"  },
    { 0x13AD, "Baltech AG"  },
    { 0x13AE, "CIM-USA Inc."  },
    { 0x13AF, "Handheld Entertainment"  },
    { 0x13B0, "PerkinElmer Optoelectronics"  },
    { 0x13B1, "Cisco-Linksys, LLC"  },
    { 0x13B2, "ALESIS"  },
    { 0x13B3, "Nippon Dics Co., Ltd."  },
    { 0x13B4, "Dolch Computer Systems"  },
    { 0x13B5, "INVENTECH, INC."  },
    { 0x13B6, "ISABELLENHUETTE Heusler GmbH KG"  },
    { 0x13B7, "Keymark Technology Co., Ltd."  },
    { 0x13B8, "PDM Electronic Co., Ltd."  },
    { 0x13B9, "Cimcore"  },
    { 0x13BA, "Yung Ray Technology Co., Ltd."  },
    { 0x13BB, "Covidien Respiratory and Monitoring Solutions"  },
    { 0x13BC, "Imaging Supersonic Laboratories Co., Ltd."  },
    { 0x13BD, "Remote Technologies, Inc."  },
    { 0x13BE, "Ricoh Printing Systems, Ltd."  },
    { 0x13BF, "Accusys, Inc."  },
    { 0x13C0, "Stream Labs"  },
    { 0x13C1, "Vivitar Corporation"  },
    { 0x13C2, "SATO KEIRYOKI MFG. CO., LTD."  },
    { 0x13C3, "SCT Performance, LLC"  },
    { 0x13C4, "StationZ Inc."  },
    { 0x13C5, "MELFAS, INC."  },
    { 0x13C6, "Hasointech Co., Ltd."  },
    { 0x13C7, "ANDO ELECTRIC CO., LTD."  },
    { 0x13C8, "Togami Electric Mfg. Co., Ltd."  },
    { 0x13C9, "LinearX Systems Inc."  },
    { 0x13CA, "JyeTai Precision Industrial Co., Ltd."  },
    { 0x13CB, "JTEK Technology Corporation"  },
    { 0x13CC, "Cellvic Corporation"  },
    { 0x13CD, "ABCD Aging Biorhythms and Computer Diagnostics GmbH"  },
    { 0x13CE, "Cypherix (Pty) Ltd."  },
    { 0x13CF, "Wisair Ltd."  },
    { 0x13D0, "Swedect AB"  },
    { 0x13D1, "A-Max Technology Macao Commercial Offshore Co. Ltd."  },
    { 0x13D2, "Intelligraphics, Inc."  },
    { 0x13D3, "AzureWave Technologies, Inc."  },
    { 0x13D4, "IWATSU TEST INSTRUMENTS CORPORATION"  },
    { 0x13D5, "International Electronics Inc."  },
    { 0x13D6, "Appside"  },
    { 0x13D7, "Tableau, LLC"  },
    { 0x13D8, "University of Stirling"  },
    { 0x13D9, "Blazepoint Limited"  },
    { 0x13DA, "OPTEX CO., LTD."  },
    { 0x13DB, "Zastron Electronic (Shenzhen) Co. Ltd."  },
    { 0x13DC, "ALEREON, INC."  },
    { 0x13DD, "i.Tech Dynamic Limited"  },
    { 0x13DE, "LANKOM ELECTRONICS CO., LTD."  },
    { 0x13DF, "Good Fancy Enterprise Co., Ltd."  },
    { 0x13E0, "Taiwan Silicon Electronics Corp."  },
    { 0x13E1, "Kaibo Wire & Cable (Shenzhen) Co., Ltd."  },
    { 0x13E2, "Parallax, Inc."  },
    { 0x13E3, "SoniqCast, LLC"  },
    { 0x13E4, "Audio Precision"  },
    { 0x13E5, "Sigma Audio Research Ltd."  },
    { 0x13E6, "TechnoScope Co., Ltd."  },
    { 0x13E7, "Gantner Pigeon Systems GmbH"  },
    { 0x13E8, "PalmSource Inc."  },
    { 0x13E9, "Ununpentium, LLC"  },
    { 0x13EA, "I/F - COM A/S"  },
    { 0x13EB, "PILZ GMBH & CO. KG"  },
    { 0x13EC, "Chyau Yuan Technology Co., Ltd."  },
    { 0x13ED, "Wooju Communications Co., Ltd."  },
    { 0x13EE, "ATLab Inc."  },
    { 0x13EF, "Turner Technology"  },
    { 0x13F0, "DIGENT CO., Ltd."  },
    { 0x13F1, "AP Instruments"  },
    { 0x13F2, "Tech Micro Corporation"  },
    { 0x13F3, "Amulet Hotkey"  },
    { 0x13F4, "Verisity Design Inc."  },
    { 0x13F5, "X-TEL Communications, Inc."  },
    { 0x13F6, "Aspen Touch Solutions, Inc."  },
    { 0x13F7, "Corevalley Co., Ltd."  },
    { 0x13F8, "EZPnP Technologies Corp."  },
    { 0x13F9, "Impsys Digital Security AB"  },
    { 0x13FA, "Radiantech, Inc."  },
    { 0x13FB, "Noritsu Koki Co., Ltd."  },
    { 0x13FC, "Compucat Research Pty Limited"  },
    { 0x13FD, "Initio (HK) Corporation Limited"  },
    { 0x13FE, "Phison Electronics Corp."  },
    { 0x13FF, "VIEWCON ELECTRONIC LTD."  },
    { 0x1400, "Axxion Group Corp."  },
    { 0x1401, "Fulhua Microelectronics Corp."  },
    { 0x1402, "Bowe Bell & Howell"  },
    { 0x1403, "Sitronix Technology Corp."  },
    { 0x1404, "Fundamental Software Incorporated"  },
    { 0x1405, "Cooper Security Ltd."  },
    { 0x1406, "Systemneeds, Inc."  },
    { 0x1407, "Coin Mechanisms Inc."  },
    { 0x1408, "Comark Ltd."  },
    { 0x1409, "IDS Imaging Development Systems GmbH"  },
    { 0x140A, "Koyo Electronics Industries Co., Ltd."  },
    { 0x140B, "Vertex Standard Co., Ltd."  },
    { 0x140C, "MITS Electronics"  },
    { 0x140D, "Japan Novel Corporation"  },
    { 0x140E, "Telechips, Inc."  },
    { 0x140F, "i-WAVER"  },
    { 0x1410, "Novatel Wireless, Inc."  },
    { 0x1411, "SKIDATA AG"  },
    { 0x1412, "IMADA CO., LTD."  },
    { 0x1413, "Telsey S.p.A."  },
    { 0x1415, "Sony Computer Entertainment Europe"  },
    { 0x1416, "Axeon Limited"  },
    { 0x1417, "Butterfly Media"  },
    { 0x1418, "MediaPower Technology Corporation"  },
    { 0x1419, "ABILITY ENTERPRISE CO., LTD."  },
    { 0x141A, "Realm Systems Inc."  },
    { 0x141B, "METRAWARE"  },
    { 0x141C, "Leviton Manufacturing"  },
    { 0x141D, "J.FIT Co., Ltd."  },
    { 0x141E, "Ikegami Tsushinki Co., Ltd."  },
    { 0x141F, "SHIMADZU CORPORATION"  },
    { 0x1420, "Lyrtech Inc."  },
    { 0x1421, "Sentech Co., Ltd."  },
    { 0x1422, "Bird Electronic Corporation"  },
    { 0x1423, "ANCA Pty. Ltd."  },
    { 0x1424, "Posnet Polska S.A."  },
    { 0x1425, "IBEX Technology Co., Ltd."  },
    { 0x1426, "NADEX Co., Ltd."  },
    { 0x1427, "Global Display Solutions S.P.A."  },
    { 0x1428, "Improvision Ltd."  },
    { 0x1429, "Vega Technologies Industrial (Austria) Co."  },
    { 0x142A, "Thales-e-Transactions"  },
    { 0x142B, "Arbiter Systems, Inc."  },
    { 0x142C, "SOMA OPTICS, LTD."  },
    { 0x142D, "Sanblaze Technology, Inc."  },
    { 0x142E, "TAMS Inc."  },
    { 0x142F, "IO Display Systems"  },
    { 0x1430, "Activision"  },
    { 0x1431, "Pertech Resources, Inc."  },
    { 0x1432, "Beijing Watertek Information Technology Co., Ltd."  },
    { 0x1433, "TRANWO TECHNOLOGY CORP."  },
    { 0x1434, "Comart System Co., Ltd."  },
    { 0x1435, "Wistron NeWeb Corp."  },
    { 0x1436, "Denali Software, Inc."  },
    { 0x1437, "Carl Zeiss"  },
    { 0x1438, "My3ia (Beijing) Technology Ltd."  },
    { 0x1439, "Wind River Systems Inc."  },
    { 0x143A, "CP Technologies"  },
    { 0x143B, "RHESCA Company Limited"  },
    { 0x143C, "Altek Corporation"  },
    { 0x143D, "FUKOKU INDUSTRY CO., LTD."  },
    { 0x143E, "IAV GmbH"  },
    { 0x143F, "IDEC IZUMI CORPORATION"  },
    { 0x1440, "Jaalaa, Inc."  },
    { 0x1441, "MARIAN GbR"  },
    { 0x1442, "Canadian Bank Note Company, Limited"  },
    { 0x1443, "Digilent Inc."  },
    { 0x1444, "H & S Instruments Inc."  },
    { 0x1445, "JUSTER CO., LTD."  },
    { 0x1446, "X.J. Group Ltd."  },
    { 0x1447, "Cognex Corporation"  },
    { 0x1448, "Biosystems LLC"  },
    { 0x1449, "SHIMADEN CO., LTD."  },
    { 0x144A, "Megger"  },
    { 0x144B, "MADENTEC LTD."  },
    { 0x144C, "Always On UPS Systems Inc."  },
    { 0x144D, "K-SUN Corporation"  },
    { 0x144E, "Westar Corporation"  },
    { 0x144F, "K-jump Health Co., Ltd."  },
    { 0x1450, "Melec Inc."  },
    { 0x1451, "Force Dimension LLC"  },
    { 0x1452, "DAI NIPPON PRINTING CO., LTD."  },
    { 0x1453, "Epilog Corporation"  },
    { 0x1454, "China IWNCOMM Co., Ltd."  },
    { 0x1455, "Georgia Technology Corp."  },
    { 0x1456, "Extending Wire & Cable Co., Ltd."  },
    { 0x1457, "DAE-A Mediatech Co., Ltd."  },
    { 0x1458, "Rauland-Borg Corporation"  },
    { 0x1459, "Shanghai Simax Micro-electronics Co., Ltd."  },
    { 0x145A, "All-Systems Electronics Pty. Ltd."  },
    { 0x145B, "Lead-Type Precision Electronics Co., Ltd."  },
    { 0x145C, "Busch-Jaeger-Elektro GmbH"  },
    { 0x145D, "Sopac Ltd."  },
    { 0x145E, "Forschungszentrum Karlsruhe GmbH"  },
    { 0x145F, "Trust International BV"  },
    { 0x1460, "TATUNG Company"  },
    { 0x1461, "Staccato Communications"  },
    { 0x1462, "Bright Computech Co., Ltd."  },
    { 0x1463, "BBWM Corp."  },
    { 0x1464, "Asiamajor Inc."  },
    { 0x1465, "Michilin Prosperity Co., Ltd."  },
    { 0x1466, "H2 Developer Group"  },
    { 0x1467, "Clearly Superior Technologies"  },
    { 0x1468, "CSE Co., Ltd."  },
    { 0x1469, "ELECTRIM CORPORATION"  },
    { 0x146A, "Knobloch GmbH"  },
    { 0x146B, "BigBen Interactive Limited"  },
    { 0x146C, "HETEC Datensysteme GmbH"  },
    { 0x146D, "Progeny Inc."  },
    { 0x146E, "ClearOne Communications"  },
    { 0x146F, "Unity Electrical Ind. Ltd."  },
    { 0x1470, "STARRIVER TECHNOLOGY CO., LTD."  },
    { 0x1471, "Open Labs, Inc."  },
    { 0x1472, "Hangzhou H3C Technologies Co., Ltd."  },
    { 0x1473, "Dingo Incorporated"  },
    { 0x1474, "Lamp Express USA, Inc."  },
    { 0x1475, "NAC Image Technology Incorporated"  },
    { 0x1476, "Westech Korea Inc."  },
    { 0x1477, "XIROKU INC."  },
    { 0x1478, "Link World Electric Inc."  },
    { 0x1479, "Datalux Corporation"  },
    { 0x147A, "Formosa21 Inc."  },
    { 0x147B, "ABB STOTZ-KONTAKT GmbH"  },
    { 0x147C, "KeyGhost Ltd."  },
    { 0x147D, "Tosoh Corporation"  },
    { 0x147E, "UPEK Inc."  },
    { 0x147F, "Hama GmbH & Co., KG"  },
    { 0x1480, "SITEK S.p.a."  },
    { 0x1481, "MHT S.p.A."  },
    { 0x1482, "Vaillant GmbH"  },
    { 0x1483, "Shenzhen MingWah Aohan High Technology Co., Ltd."  },
    { 0x1484, "Triad Semiconductor, Inc."  },
    { 0x1485, "OrangeWare Corp."  },
    { 0x1486, "SCM PC-CARD GmbH"  },
    { 0x1487, "DSP Group, Ltd."  },
    { 0x1488, "Orion Technology Corp."  },
    { 0x1489, "Sakura Finetek USA, Inc."  },
    { 0x148A, "MICROVISION"  },
    { 0x148B, "HandEra, Inc."  },
    { 0x148C, "Colortrac Ltd."  },
    { 0x148D, "DESMA Co., Ltd."  },
    { 0x148E, "EVATRONIX SA"  },
    { 0x148F, "Ralink Technology, Corp."  },
    { 0x1490, "Digitek Spa"  },
    { 0x1491, "Futronic Technology Co., Ltd."  },
    { 0x1492, "Farsharp Imaging Technology Corp."  },
    { 0x1493, "Suunto"  },
    { 0x1495, "Elprotronic Inc."  },
    { 0x1496, "Tunturi Oy Ltd."  },
    { 0x1497, "Panstrong Company Ltd."  },
    { 0x1498, "ULi Electronics Inc."  },
    { 0x1499, "G-STAR Communications, Ltd."  },
    { 0x149A, "Imagination Technologies"  },
    { 0x149B, "Ivoclar Vivadent AG"  },
    { 0x149C, "TonerHead.com"  },
    { 0x149D, "QMotions Inc."  },
    { 0x149E, "Amkor Technology"  },
    { 0x149F, "Wits Technologies Pte. Ltd."  },
    { 0x14A0, "WAVE Corporation"  },
    { 0x14A1, "Sunhayato Corp."  },
    { 0x14A2, "Big Dutchman (Skandinavien) A/S"  },
    { 0x14A3, "Wipotec GmbH"  },
    { 0x14A4, "Kyerim Industrial Co."  },
    { 0x14A5, "I-ROCKS TECHNOLOGY CO., LTD."  },
    { 0x14A6, "Interface Masters, Inc."  },
    { 0x14A7, "LanReady Technologies, Inc."  },
    { 0x14A8, "1C Company"  },
    { 0x14A9, "Smar Research Corp."  },
    { 0x14AA, "WideView Technology Inc."  },
    { 0x14AB, "Technisches Buero Koenig"  },
    { 0x14AC, "Coolstf.com"  },
    { 0x14AD, "CTK Corporation"  },
    { 0x14AE, "Printronix Inc."  },
    { 0x14AF, "ATP Electronics Inc."  },
    { 0x14B0, "StarTech.com Ltd."  },
    { 0x14B1, "I.E. Gesellschaft fuer Industrieelektronik mbH"  },
    { 0x14B2, "Alpha Networks Inc."  },
    { 0x14B3, "CHUO ELECTRIC WORKS CO., LTD."  },
    { 0x14B4, "Appliances Corp."  },
    { 0x14B5, "NTS Telecom"  },
    { 0x14B6, "Mimic Technologies Inc."  },
    { 0x14B7, "In2Games Limited"  },
    { 0x14B8, "UNITEK TECHNOLOGY CORPORATION"  },
    { 0x14B9, "BP Microsystems"  },
    { 0x14BA, "FLOVEL CO., LTD."  },
    { 0x14BB, "Assembly Tech. Co., Ltd."  },
    { 0x14BC, "NordNav Technologies AB"  },
    { 0x14BD, "Eintech Co., Ltd."  },
    { 0x14BE, "Crestron Electronics, Inc."  },
    { 0x14BF, "Everbee Networks"  },
    { 0x14C0, "Rockwell Automation, Inc."  },
    { 0x14C1, "SOHYA TECHNOLOGY CO., LTD."  },
    { 0x14C2, "Gemlight Computer Ltd."  },
    { 0x14C3, "VOXELLE LTD."  },
    { 0x14C4, "CLOVER Electronics Co., Ltd."  },
    { 0x14C5, "AudioControl"  },
    { 0x14C6, "Trigon Components, Inc."  },
    { 0x14C7, "Hartmann GmbH"  },
    { 0x14C8, "Zytronic Displays Limited"  },
    { 0x14C9, "IXOS Ltd. Bvi"  },
    { 0x14CA, "Technol Seven Co., Ltd."  },
    { 0x14CB, "Dynapoint, Inc."  },
    { 0x14CC, "WIN TONG ELECTRONICS CO., LTD."  },
    { 0x14CD, "MOAI ELECTRONICS CORPORATION"  },
    { 0x14CE, "Spectra, Inc."  },
    { 0x14CF, "Measurement Systems Inc."  },
    { 0x14D0, "Dentrix Dental Systems, Inc."  },
    { 0x14D1, "Maximo Products LLC"  },
    { 0x14D2, "BITS CO., LTD."  },
    { 0x14D3, "Y2 Corporation"  },
    { 0x14D4, "Telequip Corporation"  },
    { 0x14D5, "Electronic Theatre Controls"  },
    { 0x14D6, "Beijing Zhijiu Technology Co., Ltd."  },
    { 0x14D7, "Toppan Printing Co., Ltd."  },
    { 0x14D8, "JAMER INDUSTRIES CO., LTD."  },
    { 0x14D9, "Advanced Flash Memory Card Technology Ltd."  },
    { 0x14DA, "Horng Technical Enterprise Co., Ltd."  },
    { 0x14DB, "TOA Musendenki Co., Ltd."  },
    { 0x14DC, "Ftech Co., Ltd."  },
    { 0x14DD, "Raritan Computer, Inc."  },
    { 0x14DE, "Jetway Information Co., Ltd."  },
    { 0x14DF, "COMPRION GmbH"  },
    { 0x14E0, "Winradio Communications"  },
    { 0x14E1, "Imagination Broadway Ltd"  },
    { 0x14E2, "Avistar Communications Corporation"  },
    { 0x14E3, "Medmont Pty Ltd."  },
    { 0x14E4, "S.CAM Co., Ltd."  },
    { 0x14E5, "Zinitix Co., Ltd"  },
    { 0x14E6, "Micromed Biotecnologia Ltda."  },
    { 0x14E7, "ISS Incorporated"  },
    { 0x14E8, "Animated Lighting LC"  },
    { 0x14E9, "Lifetouch, Inc."  },
    { 0x14EA, "Kosaka Laboratory Ltd."  },
    { 0x14EB, "Pendulum Instruments AB"  },
    { 0x14EC, "Vansco Electronics Ltd."  },
    { 0x14ED, "Shure Inc."  },
    { 0x14EE, "INFORAD Ltd."  },
    { 0x14EF, "AVICLink Corporation"  },
    { 0x14F0, "GE"  },
    { 0x14F1, "America Hears, LLC."  },
    { 0x14F2, "Axess AG"  },
    { 0x14F3, "BAP IMAGE SYSTEMS"  },
    { 0x14F4, "Accell Corporation"  },
    { 0x14F5, "SourceQuest, Inc."  },
    { 0x14F6, "Symbium Corporation"  },
    { 0x14F7, "TechniSat Digital GmbH"  },
    { 0x14F8, "Chenrol Electric Wire & Cable Co., Ltd."  },
    { 0x14F9, "Full Conductor Electric Appliance Manufacturer"  },
    { 0x14FA, "The Wild Divine Project"  },
    { 0x14FB, "JAI"  },
    { 0x14FC, "Signami LLC"  },
    { 0x14FD, "IPC Information Systems"  },
    { 0x14FE, "Madrics Media GmbH Europe"  },
    { 0x14FF, "Twinhead International Corp."  },
    { 0x1500, "Ellisys"  },
    { 0x1501, "Pine-Tum Enterprise Co., Ltd."  },
    { 0x1502, "Peavey Electronics"  },
    { 0x1503, "Stretch Inc."  },
    { 0x1504, "Bixolon Co., Ltd."  },
    { 0x1505, "Extraordinary Technologies Pty. Ltd.-Trading as Halcro"  },
    { 0x1506, "T.D. Technecon Ltd."  },
    { 0x1507, "APIM INFORMATIQUE"  },
    { 0x1508, "MAATEL"  },
    { 0x1509, "LI-COR Biosciences, Inc."  },
    { 0x150A, "TiVo Inc."  },
    { 0x150B, "COLLEX COMMUNICATION CORP."  },
    { 0x150C, "Brightwell Dispenses Ltd."  },
    { 0x150D, "PR Electronics A/S"  },
    { 0x150E, "Ono Sokki Co., Ltd."  },
    { 0x150F, "Nidec Nemicon Corporation"  },
    { 0x1510, "RACEWOOD TELECOM CO., LTD."  },
    { 0x1511, "BridgeCo, AG"  },
    { 0x1512, "Software Technologies Group, Inc."  },
    { 0x1513, "Hypercom"  },
    { 0x1514, "Microsemi, SOC Products Group"  },
    { 0x1515, "Hexon Media Pte Ltd"  },
    { 0x1516, "Skymedi Corporation"  },
    { 0x1517, "Precisa Instruments AG"  },
    { 0x1518, "Cheshire Engineering Corporation"  },
    { 0x1519, "Comneon GmbH Co., Ohg."  },
    { 0x151A, "RoyalTek Company Ltd."  },
    { 0x151B, "HOSTNET CO."  },
    { 0x151C, "VeriSilicon Holdings Co., Ltd."  },
    { 0x151D, "P W Allen & Co."  },
    { 0x151E, "Circad Design Ltd."  },
    { 0x151F, "Opal Kelly Incorporated"  },
    { 0x1520, "Bitwire Corp."  },
    { 0x1521, "S++ Simulation Services"  },
    { 0x1522, "Educational Insights"  },
    { 0x1523, "Hitachi High-Tech Science Corporation"  },
    { 0x1524, "SCIENTEX Inc."  },
    { 0x1525, "Newson Engineering NV"  },
    { 0x1526, "ARDUC Co., Ltd."  },
    { 0x1527, "iQue Ltd."  },
    { 0x1528, "HighAndes Limited"  },
    { 0x1529, "UBIQUAM CO., LTD."  },
    { 0x152A, "Thesycon Systemsoftware & Consulting GmbH"  },
    { 0x152B, "MIR-Medical International Research"  },
    { 0x152C, "titel++"  },
    { 0x152D, "JMicron Technology Corp."  },
    { 0x152E, "HLDS (Hitachi-LG Data Storage, Inc.)"  },
    { 0x152F, "PRO-MECH CORPORATION"  },
    { 0x1530, "Martsoft Corp."  },
    { 0x1531, "MICRODIA Ltd."  },
    { 0x1532, "Razer (Asia-Pacific) Pte Ltd."  },
    { 0x1533, "AEPTEC Microsystems, Inc."  },
    { 0x1534, "Advanced Research Corporation"  },
    { 0x1535, "Practical Engineering Incorporated"  },
    { 0x1536, "Neonode Technologies AB"  },
    { 0x1537, "Power Up Manufacturing"  },
    { 0x1538, "IES Elektronikentwicklung"  },
    { 0x1539, "AFG-Engineering GmbH"  },
    { 0x153A, "WMS Gaming Inc."  },
    { 0x153B, "ERCO Leuchten GmbH"  },
    { 0x153C, "Guger Technologies OEG"  },
    { 0x153D, "Adam Tech"  },
    { 0x153E, "abKey ptd ltd."  },
    { 0x153F, "UNIBRAIN S.A."  },
    { 0x1540, "Phihong Technology Co., Ltd."  },
    { 0x1541, "Better Light, Inc."  },
    { 0x1542, "Gemini Industries, Inc."  },
    { 0x1543, "Buxco Research Systems"  },
    { 0x1544, "Alphamosaic Ltd."  },
    { 0x1545, "Kistler Instrumente AG"  },
    { 0x1546, "u-blox AG"  },
    { 0x1547, "S. Goers IT-Solutions"  },
    { 0x1548, "Centrepoint Technologies"  },
    { 0x1549, "Beamex Oy Ab"  },
    { 0x154A, "ID Innovations Incorporated"  },
    { 0x154B, "PNY Technologies Inc."  },
    { 0x154C, "AutoXray Inc."  },
    { 0x154D, "Rapid Conn, Connect County Holdings Bhd"  },
    { 0x154E, "D & M Holdings, Inc."  },
    { 0x154F, "Shandong New Beiyang Information Technology Co., Ltd."  },
    { 0x1550, "Cardinal Health, Inc."  },
    { 0x1551, "SAIC/IISBU"  },
    { 0x1552, "DALLAB (M) SDN BHD (587734-A)"  },
    { 0x1553, "Raytheon Commercial Infrared"  },
    { 0x1554, "Prolink Microsystems Corporation"  },
    { 0x1555, "OWEN Ltd."  },
    { 0x1556, "CERN"  },
    { 0x1557, "OQO"  },
    { 0x1558, "Microbus Designs Ltd."  },
    { 0x1559, "The Toro Company"  },
    { 0x155A, "ELDAT GmbH"  },
    { 0x155B, "Shanghai Huahong Integrated Circuit Co., Ltd."  },
    { 0x155C, "Meyers Technology"  },
    { 0x155D, "National Rejectors, Inc. GmbH"  },
    { 0x155E, "DUPLO SEIKO CORPORATION"  },
    { 0x155F, "Cobra Electronics Corporation"  },
    { 0x1560, "Supra, A UTC Fire & Security Company"  },
    { 0x1561, "LaunchPadOffice Inc."  },
    { 0x1562, "Infowize Technologies Corporation"  },
    { 0x1563, "Micronet Corporation"  },
    { 0x1564, "Gizmondo Europe Ltd."  },
    { 0x1565, "Advance Modules"  },
    { 0x1566, "WIN ACCORD LTD."  },
    { 0x1567, "MUTOH Industries Ltd."  },
    { 0x1568, "Sunf Pu Technology (Dong-Guan) Co., Ltd."  },
    { 0x1569, "Mad City Labs, Inc."  },
    { 0x156A, "Logical Solutions, Inc."  },
    { 0x156B, "Cairn Research Ltd."  },
    { 0x156C, "Meade Instruments Corp."  },
    { 0x156D, "OMICRON electronics GmbH"  },
    { 0x156E, "MVox Electronics"  },
    { 0x156F, "Quantum Corporation"  },
    { 0x1570, "ALLTOP TECHNOLOGY CO., LTD."  },
    { 0x1571, "NIKON-TRIMBLE CO., LTD."  },
    { 0x1572, "Ricreations, Inc."  },
    { 0x1573, "Gradiente Eletronica S.A."  },
    { 0x1574, "HKW-Elektronik GmbH"  },
    { 0x1575, "Video Associates Labs, Inc."  },
    { 0x1576, "Maretron"  },
    { 0x1577, "MIYUKI ELEX CO., LTD."  },
    { 0x1578, "Beijing Huaqi Information Digital Technology Co., Ltd."  },
    { 0x1579, "Reputed Industrial Company Limited"  },
    { 0x157A, "Lowrance Electronics, Inc."  },
    { 0x157B, "Ketron SRL"  },
    { 0x157C, "Eurosoft (UK) Ltd."  },
    { 0x157D, "Tokyo Sokuteikizai Co., Ltd."  },
    { 0x157E, "U-MEDIA Communications, Inc."  },
    { 0x157F, "Levon Limited"  },
    { 0x1580, "Real Time Logic, Inc."  },
    { 0x1581, "IGB Communication Co., Ltd."  },
    { 0x1582, "Asia Pacifc Microsystems, Inc."  },
    { 0x1583, "EUCHNER GmbH & Co. KG"  },
    { 0x1584, "Prueftechnik AG"  },
    { 0x1585, "IKeyInfinity Inc."  },
    { 0x1586, "Palconn Technology Co., Ltd."  },
    { 0x1587, "SMA Solar Technology AG"  },
    { 0x1588, "Fine Instruments Corporation"  },
    { 0x1589, "Arcus Technology Inc."  },
    { 0x158A, "BOBE Industrie-Elektronik"  },
    { 0x158B, "Righttag Inc."  },
    { 0x158C, "LINFOS CO., LTD."  },
    { 0x158D, "Oakley Inc."  },
    { 0x158E, "Acterna Germany GmbH"  },
    { 0x158F, "Tai Yip Electrical Co., Ltd."  },
    { 0x1590, "Onsu Data Telecommunication Technology (Shenzhen) Fty."  },
    { 0x1591, "Advanced Product Design & Mfg. Inc."  },
    { 0x1592, "Tokyo Drawing Ltd."  },
    { 0x1593, "Vector International bvba"  },
    { 0x1594, "Lockheed Martin Missiles & Fire Control"  },
    { 0x1595, "Flexiworld Technologies, Inc."  },
    { 0x1596, "Kilodyne LLC"  },
    { 0x1597, "KCodes Corporation"  },
    { 0x1598, "Kunshan Guoji Electronics Co., Ltd."  },
    { 0x1599, "ANRITSU METER CO., LTD."  },
    { 0x159A, "SkuTek Instrumentation"  },
    { 0x159B, "Zitte Corporation"  },
    { 0x159C, "Binary Acoustic Technology"  },
    { 0x159D, "Boone Cable Works & Electronics"  },
    { 0x159E, "SmartSwing, Inc."  },
    { 0x159F, "Beijer Electronics AB"  },
    { 0x15A0, "Zarlink Semiconductor"  },
    { 0x15A1, "Nicety Technologies Inc."  },
    { 0x15A2, "Freescale Semiconductor, Inc."  },
    { 0x15A3, "Larson Davis, Inc."  },
    { 0x15A4, "Afa Technologies, Inc."  },
    { 0x15A5, "CIT Engineering NV"  },
    { 0x15A6, "Unicos Corporation"  },
    { 0x15A7, "APPSware Wireless LLC dba Apriva"  },
    { 0x15A8, "Shen Zhen Teamspower Electronics Co., Ltd."  },
    { 0x15A9, "Gemtek Technology Co., Ltd."  },
    { 0x15AA, "GuangDong Ya Lian Technology Co., Ltd"  },
    { 0x15AB, "Virgin HealthMiles, Inc."  },
    { 0x15AC, "Smartware"  },
    { 0x15AD, "Bleile Datentechnik GmbH"  },
    { 0x15AE, "KAYSER-THREDE GMBH"  },
    { 0x15AF, "Jenaer Antriebstechnik GmbH"  },
    { 0x15B0, "Pacific Instruments, Inc."  },
    { 0x15B1, "MiTAC Technology Corporation"  },
    { 0x15B2, "Audio Dev AB"  },
    { 0x15B3, "GL Sciences Inc."  },
    { 0x15B4, "Orient Power Multimedia Ltd."  },
    { 0x15B5, "ANUBIS ELECTRONIC GmbH"  },
    { 0x15B6, "Dialog Semiconductor GmbH"  },
    { 0x15B7, "Hyper Stimulator International Pty Ltd."  },
    { 0x15B8, "Serome Electronics, Inc."  },
    { 0x15B9, "USD Corporation"  },
    { 0x15BA, "Olimex Ltd."  },
    { 0x15BB, "CopyPro , Inc."  },
    { 0x15BC, "Daktronics Inc."  },
    { 0x15BD, "Sigmaelectronics Co., Ltd."  },
    { 0x15BE, "EssNet Interactive AB"  },
    { 0x15BF, "ESA, Inc."  },
    { 0x15C0, "CJM"  },
    { 0x15C1, "Amirix Systems Inc."  },
    { 0x15C2, "SoundGraph, Inc."  },
    { 0x15C3, "m.u.t - GmbH"  },
    { 0x15C4, "Global Marketing Alliance, Inc."  },
    { 0x15C5, "Pressure Profile Systems, Inc."  },
    { 0x15C6, "Laboratoires MXM"  },
    { 0x15C7, "IRI-Ubiteq, Inc."  },
    { 0x15C8, "KTF Technologies"  },
    { 0x15C9, "D-Box Technologies"  },
    { 0x15CA, "TEXTECH INTERNATIONAL LTD."  },
    { 0x15CB, "Activis Polska"  },
    { 0x15CC, "GL Communications Inc."  },
    { 0x15CD, "DeFelsko Corporation"  },
    { 0x15CE, "Oriental R&D Co., Ltd."  },
    { 0x15CF, "AVTOR Ltd.."  },
    { 0x15D0, "AIRSTAR Inc."  },
    { 0x15D1, "Hokuyo Automatic Co., Ltd."  },
    { 0x15D2, "REA Elektronik GmbH"  },
    { 0x15D3, "Symmetric Research"  },
    { 0x15D4, "Opinionmeter International, Ltd."  },
    { 0x15D5, "Coulomb Electronics Ltd."  },
    { 0x15D6, "Fitness Expert"  },
    { 0x15D7, "amaxa GmbH"  },
    { 0x15D8, "Grundig Business Systems GmbH"  },
    { 0x15D9, "Apexone Microelectronics Inc."  },
    { 0x15DA, "Cooper - Atkins Corporation"  },
    { 0x15DB, "Philip Harris Education"  },
    { 0x15DC, "Hynix Semiconductor Inc."  },
    { 0x15DD, "Axona Limited"  },
    { 0x15DE, "Spatial Freedom, Inc."  },
    { 0x15DF, "Helmut Fischer GmbH + Co. KG"  },
    { 0x15E0, "Seong Ji Industrial Co., Ltd."  },
    { 0x15E1, "RSA Security Inc."  },
    { 0x15E2, "Bionopoly LLC"  },
    { 0x15E3, "NEURICAM SPA"  },
    { 0x15E4, "Numark Industries"  },
    { 0x15E5, "Micro Systems Inc."  },
    { 0x15E6, "Turnkey Ltd."  },
    { 0x15E7, "Media Systems Ltd."  },
    { 0x15E8, "Micro Tools Inc."  },
    { 0x15E9, "Pacific Digital Corp."  },
    { 0x15EA, "C-guys Inc."  },
    { 0x15EB, "VIA Telecom"  },
    { 0x15EC, "Belcarra Technologies Corp."  },
    { 0x15ED, "UCA Technology Inc."  },
    { 0x15EE, "Quorum Communications, Inc."  },
    { 0x15EF, "MSilicon Electronics, Inc."  },
    { 0x15F0, "Technex Lab Co., Ltd."  },
    { 0x15F1, "Mortara Instrument, Inc."  },
    { 0x15F2, "Chyron Corp."  },
    { 0x15F3, "AquaCube Inc."  },
    { 0x15F4, "Computer & Entertainment, Inc."  },
    { 0x15F5, "Mobitek Communication Corp."  },
    { 0x15F6, "ASICS World Services Ltd."  },
    { 0x15F7, "HANTEL CO., LTD."  },
    { 0x15F8, "Vianet, Inc."  },
    { 0x15F9, "SunCorp Industrial Limited"  },
    { 0x15FA, "Department of Defense"  },
    { 0x15FB, "R-Quest Technologies , LLC"  },
    { 0x15FC, "Humen Xintai Electrical Wires Factory"  },
    { 0x15FD, "XEMAX Co., Ltd."  },
    { 0x15FE, "Bio-Rad Laboratories Deeside"  },
    { 0x15FF, "Heartsine Technologies Ltd."  },
    { 0x1600, "Monisys Limited"  },
    { 0x1601, "Avenues in Leather"  },
    { 0x1602, "CompUSA Inc."  },
    { 0x1603, "ERGODEX Corp."  },
    { 0x1604, "Kyokko Seiko Co., Ltd."  },
    { 0x1605, "Acces I/O Products, Inc."  },
    { 0x1606, "UMAX Data Systems Inc."  },
    { 0x1607, "ESE Corporate"  },
    { 0x1608, "Inside Out Networks, a division of Digi International"  },
    { 0x1609, "K-byte (ACI Group)"  },
    { 0x160A, "VIA Networking Technologies, Inc."  },
    { 0x160B, "CSI Wireless Inc."  },
    { 0x160C, "Shanghai Tiananxin Information & Tech., Co., Ltd."  },
    { 0x160D, "Samtec"  },
    { 0x160E, "INRO Consultants Inc."  },
    { 0x160F, "Strand Lighting Limited"  },
    { 0x1610, "Q-Sense AB"  },
    { 0x1611, "Vita-Mix Corporation"  },
    { 0x1612, "Soft DB Inc."  },
    { 0x1613, "Airconnect Solutions (Asia) Ltd."  },
    { 0x1614, "Amoi Electronics Co., Ltd."  },
    { 0x1615, "Rock Data Services Ltd."  },
    { 0x1616, "Cute Mobile Corp."  },
    { 0x1617, "Navman"  },
    { 0x1618, "Redpine Signals, Inc."  },
    { 0x1619, "L & K Precision Technology Co., Ltd."  },
    { 0x161A, "Celeraise Investments Ltd."  },
    { 0x161B, "MYCOM, INC."  },
    { 0x161C, "DigiTech Systems Co., Ltd."  },
    { 0x161D, "Delfin Technologies Ltd."  },
    { 0x161E, "Aerotech Inc."  },
    { 0x161F, "Prosisa International LLC"  },
    { 0x1620, "Accesstek Inc."  },
    { 0x1621, "Wionics Research"  },
    { 0x1622, "California Instruments"  },
    { 0x1623, "Mindtech Limited"  },
    { 0x1624, "AIOI Systems, USA Corp."  },
    { 0x1625, "ViaSat UK"  },
    { 0x1626, "Advance Data Technology Corporation"  },
    { 0x1627, "IPextreme, Inc."  },
    { 0x1628, "Stonestreet One, Inc."  },
    { 0x1629, "Erae Electronics"  },
    { 0x162A, "Airgo Networks Inc."  },
    { 0x162B, "Acksys"  },
    { 0x162C, "Ecler Laboratorio de Electroacustica S.A."  },
    { 0x162D, "Control Instruments Development (Pty) Ltd."  },
    { 0x162E, "Joytech Europe Ltd."  },
    { 0x162F, "WiQuest Communications, Inc."  },
    { 0x1630, "QformX"  },
    { 0x1631, "Focus Enhancements"  },
    { 0x1632, "Data Ray Inc."  },
    { 0x1633, "AIM GmbH"  },
    { 0x1634, "ABB Switzerland Ltd."  },
    { 0x1635, "Doble Engineering Co."  },
    { 0x1636, "Kobe-Addtech Co., Ltd."  },
    { 0x1637, "LZAE LUMEL SA"  },
    { 0x1638, "Skyworks Solutions"  },
    { 0x1639, "BeRiver Electronics Co., Ltd."  },
    { 0x163A, "Traficon N.V."  },
    { 0x163B, "Controlled Speed Engineering Ltd."  },
    { 0x163C, "Watchdata System Co., Ltd."  },
    { 0x163D, "Million Tech Dev. Ltd."  },
    { 0x163E, "Dezhou HongJu Communication Technology Co., Ltd."  },
    { 0x163F, "AVEX Technologies, Inc."  },
    { 0x1640, "M3 Electronics, Inc."  },
    { 0x1641, "eMagin Corporation"  },
    { 0x1642, "AquaSensors LLC"  },
    { 0x1643, "Sanwa Newtec Co., Ltd."  },
    { 0x1644, "Active Technologies SRL"  },
    { 0x1645, "Smiths Heimann Biometrics GmbH"  },
    { 0x1646, "Altronic, Inc."  },
    { 0x1647, "Horizon Navigation, Inc."  },
    { 0x1648, "Wood Head Software & Electronics"  },
    { 0x1649, "Softec Microsystems"  },
    { 0x164A, "ChipX"  },
    { 0x164B, "Lytech Technology Inc."  },
    { 0x164C, "Matrix Vision GmbH"  },
    { 0x164D, "DASAN Networks, Inc."  },
    { 0x164E, "Picotest Corp."  },
    { 0x164F, "Kinkei System Co., Ltd."  },
    { 0x1650, "Remopro Technology Inc."  },
    { 0x1651, "PACOMP"  },
    { 0x1652, "EFull Tech. Corp. Ltd."  },
    { 0x1653, "Nissho Electronics Co., Ltd."  },
    { 0x1654, "Stamer Musikanlagen GmbH"  },
    { 0x1655, "Dtron Co., Ltd."  },
    { 0x1656, "QSC Audio Products, Inc."  },
    { 0x1657, "Struck Innovative Systeme GmbH"  },
    { 0x1658, "Grayhill Inc."  },
    { 0x1659, "Lathem Time Corp."  },
    { 0x165A, "E.D.P. SRL"  },
    { 0x165B, "Frontier Design Group"  },
    { 0x165C, "Kondo Kagaku Co., Ltd."  },
    { 0x165D, "Orange Tree Technologies Ltd."  },
    { 0x165E, "Pangolin"  },
    { 0x165F, "Ansync Inc."  },
    { 0x1660, "Creatix Polymedia GmbH"  },
    { 0x1661, "DVS Korea Co., Ltd."  },
    { 0x1662, "Positivo Informatica LTDA"  },
    { 0x1663, "Sercel, Inc."  },
    { 0x1664, "ARGOX INFORMATION CO., LTD."  },
    { 0x1665, "General Dynamics Canada"  },
    { 0x1666, "Vanguard Instruments Co., Inc."  },
    { 0x1667, "GIGA-TMS, INC."  },
    { 0x1668, "Actiontec Electronics, Inc."  },
    { 0x1669, "PiKRON s.r.o."  },
    { 0x166A, "Clipsal Integrated Systems"  },
    { 0x166B, "PedalPax Corporation"  },
    { 0x166C, "Technology Driven Solutions Ltd"  },
    { 0x166D, "MCS Logic Inc."  },
    { 0x166E, "SerComm Corporation"  },
    { 0x166F, "Idetech Europe S.A."  },
    { 0x1670, "Hach Company"  },
    { 0x1671, "Telular Corporation"  },
    { 0x1672, "MBS GmbH"  },
    { 0x1673, "ROBOTIKER"  },
    { 0x1674, "Pantone, Inc."  },
    { 0x1675, "SE-IR Corporation"  },
    { 0x1676, "I-Ware Laboratory Co., Ltd."  },
    { 0x1677, "China Integrated Circuit Design Corp., Ltd."  },
    { 0x1678, "Matsunichi Information Technology (Shenzhen) Co., Ltd."  },
    { 0x1679, "Total Phase"  },
    { 0x167A, "USBWARE"  },
    { 0x167B, "Pure Digital Technologies"  },
    { 0x167C, "Vionics"  },
    { 0x167D, "SIM Security & Electronic System GmbH"  },
    { 0x167E, "Videa Technology Inc."  },
    { 0x167F, "Actigraph, LLC"  },
    { 0x1680, "KaVo Dental GmbH"  },
    { 0x1681, "Prevo Technologies, Inc."  },
    { 0x1682, "Maxwise Production Enterprise Ltd."  },
    { 0x1683, "DualCor Technologies, Inc."  },
    { 0x1684, "Godspeed Computer Corp."  },
    { 0x1685, "Tanic Electroics Ltd."  },
    { 0x1686, "ZOOM Corporation"  },
    { 0x1687, "Kingmax Digital Inc."  },
    { 0x1688, "AerotechTelub AB"  },
    { 0x1689, "Griffin International Companies, Inc."  },
    { 0x168A, "Veeco Instruments"  },
    { 0x168B, "BTC Secu Co., Ltd."  },
    { 0x168C, "Tabor Electroics Ltd."  },
    { 0x168D, "YSI, Inc."  },
    { 0x168E, "iMetrikus Inc."  },
    { 0x168F, "ETA S.A. Manufacture Horlogere Suisse"  },
    { 0x1690, "Simple Solutions"  },
    { 0x1691, "Landers Instruments"  },
    { 0x1692, "Weatherford"  },
    { 0x1693, "Zultys Technologies"  },
    { 0x1694, "Cassidian Communications"  },
    { 0x1695, "FATAR, S.r.l."  },
    { 0x1696, "Hitachi Advanced Digital, Inc."  },
    { 0x1697, "VTEC TEST, INC."  },
    { 0x1698, "Eurosmart"  },
    { 0x1699, "United RadioTek Inc."  },
    { 0x169A, "Ten X Technology Inc."  },
    { 0x169B, "aitronic GmbH"  },
    { 0x169C, "DMS"  },
    { 0x169E, "Groupics.com, Inc."  },
    { 0x169F, "Monolith Inc."  },
    { 0x16A0, "Real Thoughts GmbH"  },
    { 0x16A1, "Trilithic, Inc."  },
    { 0x16A2, "Sypris Test and Measurement (FW Bell)"  },
    { 0x16A3, "B & W Tek Inc."  },
    { 0x16A4, "Sagutech Microsystems"  },
    { 0x16A5, "Shenzhen Zhengerya Technology Co., Ltd."  },
    { 0x16A6, "UNIGRAF OY"  },
    { 0x16A7, "Sauer-Danfoss"  },
    { 0x16A8, "Nice Systems"  },
    { 0x16A9, "Worth-Pfaff Innovations, Inc."  },
    { 0x16AA, "Symtx Inc."  },
    { 0x16AB, "InnoWireless Co. Ltd."  },
    { 0x16AC, "Dongguan ChingLung Wire & Cable Co., Ltd."  },
    { 0x16AD, "Siemens VDO Trading GmbH"  },
    { 0x16AE, "ELSA Japan Inc."  },
    { 0x16AF, "Intelligent Mechatronic Systems"  },
    { 0x16B0, "Infosight Corp."  },
    { 0x16B1, "Cami Research Inc."  },
    { 0x16B2, "Bruxton Corporation"  },
    { 0x16B3, "Eizoken Inc."  },
    { 0x16B4, "Digital Cube"  },
    { 0x16B5, "PerSen Technologies, Inc."  },
    { 0x16B6, "Nexus Technology Inc."  },
    { 0x16B7, "Pulsafeeder Inc."  },
    { 0x16B8, "Honeywell Life Safety"  },
    { 0x16B9, "Origin Technologies Limited"  },
    { 0x16BA, "SmarTec"  },
    { 0x16BB, "Tomra Systems ASA"  },
    { 0x16BC, "JOBO AG"  },
    { 0x16BD, "Leica Geosystems AG"  },
    { 0x16BE, "RyuSyo Industrial Co., Ltd."  },
    { 0x16BF, "CAST, INC."  },
    { 0x16C0, "Van Ooijen Technische Informatica"  },
    { 0x16C1, "Lucas-Nuelle GmbH"  },
    { 0x16C2, "Amphenol-Data Telecom"  },
    { 0x16C3, "Nihon Kaiheiki Ind. Co., Ltd."  },
    { 0x16C4, "SavaJe Technologies, Inc."  },
    { 0x16C5, "Cryptek Inc."  },
    { 0x16C6, "NDS Surgical Imaging, LLC"  },
    { 0x16C7, "Crystal Technology, Inc."  },
    { 0x16C8, "Technische Universiteit Eindhoven"  },
    { 0x16C9, "OCT Co., Ltd."  },
    { 0x16CA, "Wireless Cables Inc."  },
    { 0x16CB, "Highwater Designs Limited"  },
    { 0x16CC, "silex technology, Inc."  },
    { 0x16CD, "Brian Moore Guitars, Inc."  },
    { 0x16CE, "IPFlex Inc."  },
    { 0x16CF, "YAZAKI PARTS CO., LTD."  },
    { 0x16D1, "SUPREMA, INC."  },
    { 0x16D2, "TOMEY"  },
    { 0x16D3, "Frontline Test Equipment, Inc."  },
    { 0x16D4, "SRTechnologies"  },
    { 0x16D5, "AnyDATA Corporation"  },
    { 0x16D6, "Jablotron"  },
    { 0x16D7, "Aprilis, Inc."  },
    { 0x16D8, "CMOTECH CO., LTD."  },
    { 0x16D9, "A7 Engineering, Inc."  },
    { 0x16DA, "Linkam Scientific Instruments Ltd."  },
    { 0x16DB, "Eridon Corporation"  },
    { 0x16DC, "W-IE-NE-R, Plein & Baus GmbH"  },
    { 0x16DD, "YOSHIDA SEIKI CO., LTD."  },
    { 0x16DE, "Schneider Electric"  },
    { 0x16DF, "King Billion Electronics Co., Ltd."  },
    { 0x16E0, "Lumex Ltd."  },
    { 0x16E1, "Bed Check Corporation"  },
    { 0x16E2, "Hitachi I E Systems Co., Ltd."  },
    { 0x16E3, "ITM Inc."  },
    { 0x16E4, "Franklin Electric Co., Inc."  },
    { 0x16E5, "TOKYO KEIKI RAIL TECHNO INC."  },
    { 0x16E6, "Diginfo Technology Corporation"  },
    { 0x16E7, "United Keys, Inc."  },
    { 0x16E8, "Frontier Information Enterprise, Inc."  },
    { 0x16E9, "Dr. Gal Ben-David"  },
    { 0x16EA, "Avionica, Inc."  },
    { 0x16EB, "Helvar"  },
    { 0x16EC, "ASAHI GLASS CO., LTD."  },
    { 0x16ED, "Parker Vision Inc."  },
    { 0x16EE, "Ryvor Corp."  },
    { 0x16EF, "Global Safety & Security Solutions OY"  },
    { 0x16F0, "GN ReSound"  },
    { 0x16F1, "Versus Technology, Inc."  },
    { 0x16F2, "St. Jude Medical AB"  },
    { 0x16F3, "Hammer Storage/Bell Microproducts"  },
    { 0x16F4, "Lineeye Co., Ltd."  },
    { 0x16F5, "Futurelogic Inc."  },
    { 0x16F6, "Shin Tek Inc."  },
    { 0x16F7, "Japan Gals Co., Ltd."  },
    { 0x16F8, "Ever Bright Wire Factory"  },
    { 0x16F9, "Astrosys International Limited"  },
    { 0x16FA, "Shachihata Inc."  },
    { 0x16FB, "MICRONIX CORPORATION"  },
    { 0x16FC, "TRICOM TECHNOLOGIES, INC."  },
    { 0x16FD, "Reakin Technology Corporation"  },
    { 0x16FE, "Su Zhou Song Qing Electronical Co., Ltd."  },
    { 0x16FF, "Ultimate Technology Corp."  },
    { 0x1700, "Hunt Engineering (UK) Ltd."  },
    { 0x1701, "Peyroutet Telecom"  },
    { 0x1702, "Softcare Ltd."  },
    { 0x1703, "NormSoft, Inc."  },
    { 0x1704, "ANIMATICS CORP."  },
    { 0x1705, "Aerosonic Corporation"  },
    { 0x1706, "BlueView Technologies, Inc."  },
    { 0x1707, "ARTIMI"  },
    { 0x1708, "Mibudenki Industrial Co., Ltd."  },
    { 0x1709, "Sanmina-SCI"  },
    { 0x170A, "MAXTEK, INC."  },
    { 0x170B, "Phonic Corp."  },
    { 0x170C, "BlueTree Wireless Data"  },
    { 0x170D, "Avnera"  },
    { 0x170E, "Iris Corporation Berhad"  },
    { 0x170F, "UbiBro Technolgies Inc."  },
    { 0x1710, "AZIO Corporation"  },
    { 0x1711, "Leica Microsystems CMS GmbH"  },
    { 0x1712, "Fujitsu LSI Technology Ltd."  },
    { 0x1713, "Enter Tech Co., Ltd"  },
    { 0x1714, "iCRco"  },
    { 0x1715, "NL Technology"  },
    { 0x1716, "LHR Technologies"  },
    { 0x1717, "Formats Unlimited, Inc."  },
    { 0x1718, "Mobile Doctor Co., Ltd."  },
    { 0x1719, "American Technology Corp."  },
    { 0x171A, "PSi Printer Systems international GmbH"  },
    { 0x171B, "NT Ware Systemprogrammierung GmbH"  },
    { 0x171C, "IER"  },
    { 0x171E, "PACIFIC CORPORATION"  },
    { 0x171F, "CHIPNUTS TECHNOLOGY INC."  },
    { 0x1720, "Innova Electronics Corp."  },
    { 0x1721, "ELAD SRL"  },
    { 0x1722, "Axicon Auto ID LTD"  },
    { 0x1723, "Datatronics Technology, Inc"  },
    { 0x1724, "Lumenera Corporation"  },
    { 0x1725, "HI-TECH Software"  },
    { 0x1726, "Axesstel, Inc."  },
    { 0x1727, "RiCHIP Incorporated"  },
    { 0x1728, "BYTE TOOLS INC."  },
    { 0x1729, "CONSULTRONICS EUROPE LTD."  },
    { 0x172A, "wenglor sensoric gmbh"  },
    { 0x172B, "CompuSoft A/S"  },
    { 0x172C, "Silicon Optix"  },
    { 0x172D, "AccFast Technology Corp."  },
    { 0x172E, "ELECTION SYSTEMS & Software"  },
    { 0x172F, "WALTOP International Corporation"  },
    { 0x1730, "MERCURY"  },
    { 0x1731, "DATA DISPLAY AG"  },
    { 0x1732, "NETENRICH INC."  },
    { 0x1733, "NUBYTECH INC."  },
    { 0x1734, "IPdrum AB"  },
    { 0x1735, "Satloc LLC (CSI Wireless)"  },
    { 0x1736, "CANON IMAGING SYSTEMS INC."  },
    { 0x1737, "Hong Kong Applied Science and Technology Research Inst."  },
    { 0x1738, "Asicen Technology Corp."  },
    { 0x1739, "Radiant Technologies Inc."  },
    { 0x173A, "F. Hoffmann-La Roche AG"  },
    { 0x173B, "Cadillac Jack Inc."  },
    { 0x173C, "Signalcraft Technologies Inc."  },
    { 0x173D, "Great Pleasure Electronics Co. LTD."  },
    { 0x173E, "Devlin Electronics Ltd."  },
    { 0x173F, "Peyer Engineering"  },
    { 0x1740, "Senao International Co., Ltd."  },
    { 0x1741, "Techino Science Co., Ltd."  },
    { 0x1742, "Nippon Chemi-Con Corp."  },
    { 0x1743, "General Atomics"  },
    { 0x1744, "Sanwa Electronic Instrument Co. Ltd."  },
    { 0x1745, "Video Simplex, Inc."  },
    { 0x1746, "Edge Products"  },
    { 0x1747, "CML MICROCIRCUITS (UK) LTD"  },
    { 0x1748, "MQP Electronics Ltd."  },
    { 0x1749, "MAGO MOBILE LTD"  },
    { 0x174A, "Endress + Hauser"  },
    { 0x174B, "BARACODA"  },
    { 0x174C, "ASMedia Technology Inc."  },
    { 0x174D, "Broadcast System & Design ApS"  },
    { 0x174E, "Xi'an Tongshi Data Co., Ltd."  },
    { 0x174F, "D-MAX Technology Co., Ltd."  },
    { 0x1750, "Hirschmann Automation and Control GmbH"  },
    { 0x1751, "EMPIRISOFT CORPORATION"  },
    { 0x1752, "Liyitec Incorporated"  },
    { 0x1753, "Tecvan Informatica LTDA"  },
    { 0x1754, "GERSTEL GmbH & Co. KG"  },
    { 0x1755, "Electronics and Telecommunication Research Institute"  },
    { 0x1756, "ENENSYS Technologies"  },
    { 0x1757, "ST-MICHAEL STRATEGIES"  },
    { 0x1758, "FUTURECOM SYSTEMS GROUP INC."  },
    { 0x1759, "LucidPort Technology, Inc."  },
    { 0x175A, "Lantronix"  },
    { 0x175B, "Dongguan Init Technology Co., Ltd."  },
    { 0x175C, "Isolcell Italia SpA"  },
    { 0x175D, "Caterpillar Inc."  },
    { 0x175E, "AT KidSystems Inc."  },
    { 0x175F, "I-BIT Corporation"  },
    { 0x1760, "RAYLASE AG"  },
    { 0x1761, "RC GROUP (Holdings) Limited"  },
    { 0x1763, "USAF"  },
    { 0x1764, "KANOMAX JAPAN INC."  },
    { 0x1765, "VK Corporation"  },
    { 0x1766, "Hip Interactive Inc."  },
    { 0x1767, "KIS Photo Mc Group"  },
    { 0x1769, "ARTEK Inc."  },
    { 0x176A, "GLOBALSAT TECHNOLOGY CORPORATION"  },
    { 0x176B, "ATOP ELECTRONICS CO., LTD."  },
    { 0x176C, "Advanced Electronic Designs"  },
    { 0x176D, "Mbridge Systems, Inc."  },
    { 0x176E, "UD electronic corp."  },
    { 0x176F, "Astralink Technology Pte Ltd"  },
    { 0x1770, "precisionWave Corporation"  },
    { 0x1771, "Shenzhen Alex Connector Co., Ltd."  },
    { 0x1772, "System Level Solutions, Inc."  },
    { 0x1773, "InSync Speech Technologies, Inc."  },
    { 0x1774, "Strawberry Linux Co., Ltd."  },
    { 0x1775, "RADAR-TRONIC KFT."  },
    { 0x1776, "HYPERLABS, Inc."  },
    { 0x1777, "Microscan Systems, Inc."  },
    { 0x1778, "PChome Online Inc."  },
    { 0x1779, "Optek Electronics Co., Ltd."  },
    { 0x177A, "Explore Semiconductor, Inc."  },
    { 0x177B, "Cetus Engineering"  },
    { 0x177C, "AD Information & Communications Co., Ltd"  },
    { 0x177D, "Delta Industrie Service"  },
    { 0x177E, "mils electronic GmbH & Co Kg"  },
    { 0x177F, "Sweex Europe B.V."  },
    { 0x1780, "TENDYRON CORPORATION"  },
    { 0x1781, "MECANIQUE"  },
    { 0x1782, "Spreadtrum Hong Kong Limited"  },
    { 0x1783, "Foster Flight, Inc."  },
    { 0x1784, "TopSeed Technology Corp."  },
    { 0x1785, "CARALLON LIMITED"  },
    { 0x1786, "Xeltek Inc."  },
    { 0x1787, "TRIDENT SYSTEMS, INC."  },
    { 0x1788, "ShenZhen Litkconn Technology Co., Ltd."  },
    { 0x1789, "Ascom (Schweiz) AG"  },
    { 0x178A, "Prentke Romich Company"  },
    { 0x178B, "Panduit Corp."  },
    { 0x178C, "URTEK TECHNOLOGIES INC."  },
    { 0x178D, "CEIVA Logic, Inc."  },
    { 0x178E, "Movimento Group AB"  },
    { 0x1790, "Ueda Japan Radio Co., Ltd."  },
    { 0x1791, "SYNTHETIC PLANNING INDUSTRY CO., LTD."  },
    { 0x1792, "LINK GmbH"  },
    { 0x1793, "Heim Systems GmbH"  },
    { 0x1794, "MA'AGALIM COMPUTER SYSTEMS Ltd."  },
    { 0x1795, "INTEGRATION ASSOCIATES INCORPORATED"  },
    { 0x1796, "Printrex, Inc."  },
    { 0x1797, "JALCO CO., LTD."  },
    { 0x1798, "TYPE TECHNOLOGY INC."  },
    { 0x1799, "Thales Norway AS"  },
    { 0x179A, "Conrad Electronic GmbH"  },
    { 0x179B, "HANDSFULL TECHNOLOGY CORP."  },
    { 0x179C, "Net-2Com Corporation"  },
    { 0x179D, "Ricavision International Inc."  },
    { 0x179E, "Silicon Engines"  },
    { 0x179F, "CLIQ LIMITED"  },
    { 0x17A0, "Samson Technologies Corp."  },
    { 0x17A1, "Taiwan Advanced Sensors Corporation"  },
    { 0x17A2, "Vantage Controls, Inc."  },
    { 0x17A3, "OnTime tek Inc."  },
    { 0x17A4, "Concept 2"  },
    { 0x17A5, "Advanced Connection Technology Inc."  },
    { 0x17A6, "Astron Clinica Ltd."  },
    { 0x17A7, "MICOMSOFT CO., LTD."  },
    { 0x17A8, "Kamstrup A/S"  },
    { 0x17A9, "MULTIMEDIA GAMES, INC."  },
    { 0x17AA, "SETEK Elektronik AB"  },
    { 0x17AB, "i-Bulldog Co., Ltd."  },
    { 0x17AC, "Dengen Automation Co., Ltd."  },
    { 0x17AD, "TRIOC AB"  },
    { 0x17AE, "NAD Electronics International/A Div. of Lenbrook Ind."  },
    { 0x17AF, "GIGABYTE Communications Inc."  },
    { 0x17B0, "Weinmann Geraete fuer Medizen GmbH+Co. KG"  },
    { 0x17B1, "ViaSat, Inc."  },
    { 0x17B2, "Metec GmbH"  },
    { 0x17B3, "Grey Innovation Pty., Ltd."  },
    { 0x17B4, "Apres Health & Fitness"  },
    { 0x17B5, "Lunatone Industrielle Elektronik GmbH"  },
    { 0x17B6, "Hydronix Limited"  },
    { 0x17B7, "Sinter Information Corp."  },
    { 0x17B8, "Trojan Technologies Private Limited"  },
    { 0x17B9, "Green Bit S.p.A."  },
    { 0x17BA, "Sauris GmbH"  },
    { 0x17BB, "Weihai Dongxing Electronics Co., Ltd."  },
    { 0x17BC, "Advanced Peripherals Technologies, Inc."  },
    { 0x17BD, "Citron Electronic Co., Ltd."  },
    { 0x17BE, "Dongguan Yangming Precision of Plastic Metal Elec Co Lt"  },
    { 0x17BF, "Ampere Inc."  },
    { 0x17C0, "ED Co., Ltd."  },
    { 0x17C1, "Sirius XM Radio"  },
    { 0x17C2, "Ingenient Technologies"  },
    { 0x17C3, "SGB Group Ltd."  },
    { 0x17C4, "VISIOWAVE SA"  },
    { 0x17C5, "Hantle System Co., Ltd."  },
    { 0x17C6, "Magnetox"  },
    { 0x17C7, "AIM Infrarot-Module GmbH"  },
    { 0x17C8, "Ringway Tech (JiangSu) Co., Ltd."  },
    { 0x17C9, "Andros Incorporated"  },
    { 0x17CA, "CyberPak Co."  },
    { 0x17CB, "CHINA HUAXU GOLDEN CARD CO., LTD."  },
    { 0x17CC, "Native Instruments Software Synthesis GmbH"  },
    { 0x17CD, "Basler Electric"  },
    { 0x17CE, "Keymile AG"  },
    { 0x17CF, "Hip Hing Cable & Plug Mfy. Ltd."  },
    { 0x17D0, "Sanford L.P."  },
    { 0x17D1, "ViDisys GmbH"  },
    { 0x17D2, "Radiometer Medical ApS"  },
    { 0x17D3, "Korea Techtron Co., Ltd."  },
    { 0x17D4, "Kenetics Innovations Pte. Ltd., Singapore"  },
    { 0x17D5, "ImageMap Inc."  },
    { 0x17D6, "Samsung Electronics Research Institute"  },
    { 0x17D7, "Copley Controls Corp."  },
    { 0x17D8, "Rapattoni Corporation"  },
    { 0x17D9, "Rasteme Systems Co., Ltd."  },
    { 0x17DA, "GEMIT GmbH"  },
    { 0x17DB, "CYNOVE"  },
    { 0x17DC, "Thermoteknix Systems Ltd."  },
    { 0x17DD, "Simply Automated, Incorporated"  },
    { 0x17DE, "Grant Instruments"  },
    { 0x17DF, "SOUTHWING"  },
    { 0x17E0, "Big Sky Laser"  },
    { 0x17E1, "ORTHOFIX"  },
    { 0x17E2, "PIKAONE"  },
    { 0x17E3, "Beck IPC GmbH"  },
    { 0x17E4, "OKB SAPR"  },
    { 0x17E5, "Memcorp Inc."  },
    { 0x17E6, "Quantel Medical"  },
    { 0x17E7, "Sirah Laser-und Plasmatechnik GmbH"  },
    { 0x17E8, "Visionee S.R.L."  },
    { 0x17E9, "DisplayLink (UK) Ltd."  },
    { 0x17EA, "Web Technology Corp"  },
    { 0x17EB, "Cornice, Inc."  },
    { 0x17EC, "Telsource"  },
    { 0x17ED, "Sumita Optical Glass, Inc."  },
    { 0x17EE, "Personal Media Corporation"  },
    { 0x17EF, "Lenovo"  },
    { 0x17F0, "Bestronic Industry Co., Ltd."  },
    { 0x17F1, "Microjet Technology Co., Ltd."  },
    { 0x17F2, "Xmultiple Technologies Inc."  },
    { 0x17F3, "Terascala, Inc."  },
    { 0x17F4, "AgaMatrix, Inc."  },
    { 0x17F5, "K.K. Rocky"  },
    { 0x17F6, "Unicomp, Inc"  },
    { 0x17F7, "Metroptic Technologies Ltd."  },
    { 0x17F8, "Enustech, Inc."  },
    { 0x17F9, "GIE Sesam-Vitale"  },
    { 0x17FA, "DOSHISHA CORPORATION"  },
    { 0x17FB, "Emutec Inc."  },
    { 0x17FC, "Vitesse Semiconductor Corp."  },
    { 0x17FD, "Formac GmbH"  },
    { 0x17FE, "NIPPON PULSE MOTOR CO., LTD."  },
    { 0x17FF, "Unication Co., Ltd"  },
    { 0x1800, "Shandong Yuanda Net & Multimedia Co., Ltd."  },
    { 0x1801, "Southern Data Comm, Inc."  },
    { 0x1802, "SYN-TEK Technologies Inc."  },
    { 0x1803, "Secutronix"  },
    { 0x1804, "Clemens GmbH"  },
    { 0x1805, "Digital Peripheral Solutions Inc."  },
    { 0x1806, "New Index AS"  },
    { 0x1807, "Par-Tech Inc."  },
    { 0x1808, "Multiplex Engineering Inc."  },
    { 0x1809, "Advantech Co., Ltd."  },
    { 0x180A, "Technosystem Co., Ltd."  },
    { 0x180B, "Photo Research, Inc."  },
    { 0x180C, "Power Digital Card Co., Ltd."  },
    { 0x180D, "U3, LLC"  },
    { 0x180E, "Audisoft Technologies"  },
    { 0x180F, "Phonak Communications AG"  },
    { 0x1810, "Wanshih Electronic Co., Ltd."  },
    { 0x1811, "Blackspot Interactive Ltd."  },
    { 0x1812, "GEWI GmbH"  },
    { 0x1813, "HAGIWARA ELECTRIC Co., Ltd."  },
    { 0x1814, "Fashionow Co. Ltd."  },
    { 0x1815, "Horizon Semiconductors Ltd."  },
    { 0x1816, "Directed Electronics"  },
    { 0x1817, "Digital Authentication Technologies, Inc."  },
    { 0x1818, "Osteosys Co., Ltd."  },
    { 0x1819, "Quality Vision International, Inc."  },
    { 0x181A, "Fotonation"  },
    { 0x181B, "Current Designs, Inc."  },
    { 0x181C, "Rensselaer Polytechnic Institute"  },
    { 0x181D, "Axon Systems Inc."  },
    { 0x181E, "Advanced Tracking Technologies, Inc."  },
    { 0x181F, "NAKAJIMA ALL Co., Ltd."  },
    { 0x1820, "DSM - Messtechnik GmbH"  },
    { 0x1821, "INwireless Co., Ltd"  },
    { 0x1822, "DIGIBIO TECHNOLOGY CORP."  },
    { 0x1823, "CelleBrite Mobile Synchronization"  },
    { 0x1824, "Aval Nagasaki Corp."  },
    { 0x1825, "Star-Dundee Ltd."  },
    { 0x1826, "Xitron Inc."  },
    { 0x1827, "Sanko Electronics Co., Ltd."  },
    { 0x1828, "TSR Silicon Resources, Inc."  },
    { 0x1829, "Dongguan YuQiu Electronics Co., Ltd."  },
    { 0x182A, "Signalion GmbH"  },
    { 0x182B, "Chest M.I., Incorporated"  },
    { 0x182C, "Caliper LifeSciences"  },
    { 0x182D, "Accutron Limited"  },
    { 0x182E, "System Instruments Co., Ltd."  },
    { 0x182F, "Worldwide Productions Inc."  },
    { 0x1830, "I CAP Technologies, Inc."  },
    { 0x1831, "Gwo Jinn Industries Co., Ltd."  },
    { 0x1832, "Huizhou Shenghua Industrial Co., Ltd."  },
    { 0x1833, "Genuine Technologies Co., Ltd."  },
    { 0x1834, "SONEL S.A."  },
    { 0x1835, "Lust Drivetronics GmbH"  },
    { 0x1836, "ePoint Technology"  },
    { 0x1837, "Hokuto Denko Corporation"  },
    { 0x1838, "Real Networks, Inc."  },
    { 0x1839, "AnexTEK Global Inc."  },
    { 0x183A, "Mediafour Corporation"  },
    { 0x183B, "SIDACON Systemtechnik GmbH"  },
    { 0x183C, "Saab AB"  },
    { 0x183D, "F3 Inc."  },
    { 0x183E, "Robonik India Pvt. Ltd."  },
    { 0x183F, "i-BEAD Co., Ltd."  },
    { 0x1840, "Cognitive Solutions, Inc."  },
    { 0x1841, "SEIKO TIME SYSTEM INC."  },
    { 0x1842, "Keen High Technologies (HK) Ltd."  },
    { 0x1843, "Vaisala"  },
    { 0x1844, "Radiotechnika Marketing Sp.zo.o"  },
    { 0x1845, "Cion Technology Corporation"  },
    { 0x1846, "microEngineering Labs, Inc."  },
    { 0x1847, "Global Payment Technologies, Inc."  },
    { 0x1848, "Eurochannels Holding B.V."  },
    { 0x1849, "Centurion Systems (Pty) Ltd."  },
    { 0x184A, "EB Neuro SPA"  },
    { 0x184B, "ARION Technology Inc."  },
    { 0x184C, "Centice"  },
    { 0x184D, "Dansk Automat Expert A/S"  },
    { 0x184E, "SyGade Solutions (Pty) Ltd."  },
    { 0x184F, "K2L GmbH"  },
    { 0x1850, "Andigilog, Inc."  },
    { 0x1851, "ULTRASONIC ENGINEERING CO., LTD."  },
    { 0x1852, "Galaxy Far East Corp"  },
    { 0x1853, "MITSUBISHI PRECISION CO., LTD."  },
    { 0x1854, "Memory Devices Ltd."  },
    { 0x1855, "Redpay Secure Payments"  },
    { 0x1856, "Imaginova"  },
    { 0x1857, "Picosecond Pulse Labs"  },
    { 0x1858, "CELLSYSTEM CO., LTD"  },
    { 0x1859, "Speech Technology Center, Ltd."  },
    { 0x185A, "WinProbe Corporation"  },
    { 0x185B, "IG-Development"  },
    { 0x185C, "Omnisec AG"  },
    { 0x185D, "Origgio Limited"  },
    { 0x185E, "Meritech Co., Ltd."  },
    { 0x185F, "Stinger Systems Inc."  },
    { 0x1860, "HYUPJIN I & C CO, LTD."  },
    { 0x1861, "Tech Technology Industrial Company"  },
    { 0x1862, "Teridian Semiconductor Corp."  },
    { 0x1863, "Wave Technology Co., Ltd."  },
    { 0x1864, "Digital Art System"  },
    { 0x1865, "Europlex Technologies"  },
    { 0x1866, "Union Community Co., Ltd."  },
    { 0x1867, "Control Microsystems"  },
    { 0x1868, "Index Braille AB"  },
    { 0x1869, "RTS Automation GmbH"  },
    { 0x186A, "Pivot International, Inc."  },
    { 0x186B, "Holophase Incorporated"  },
    { 0x186C, "Miyachi Corporation"  },
    { 0x186D, "Evermore Innovations"  },
    { 0x186E, "Reel Stream LLC"  },
    { 0x186F, "Motion Lingo, LLC"  },
    { 0x1870, "Nexio Co., Ltd."  },
    { 0x1871, "Aveo Technology Corp."  },
    { 0x1872, "Cobalt Technologies Co., Ltd."  },
    { 0x1873, "Etrovision Technology"  },
    { 0x1874, "Nexilion Inc."  },
    { 0x1875, "Humo Laboratory, Ltd."  },
    { 0x1876, "MG Industrieelektronik GmbH"  },
    { 0x1877, "SANEI HYTECHS Co., Ltd."  },
    { 0x1878, "Sumitomo Heavy Industries, Ltd."  },
    { 0x1879, "Spin Semiconductor Inc."  },
    { 0x187A, "Mediachorus Inc."  },
    { 0x187B, "Dent Instruments, Inc."  },
    { 0x187C, "Alienware Corporation"  },
    { 0x187D, "Ardware Ltd."  },
    { 0x187E, "Sentelic Corporation"  },
    { 0x187F, "Siano Mobile Silicon Ltd."  },
    { 0x1880, "Vericon Co., Ltd./Jinn Shyang Precision Industrial Co.,"  },
    { 0x1881, "Interactive Learning Technologies"  },
    { 0x1882, "TransChip Israel Ltd."  },
    { 0x1883, "Tanaka S/S Ltd."  },
    { 0x1884, "Liyuh Technology Ltd."  },
    { 0x1885, "Ascalade Communications Inc."  },
    { 0x1886, "Metalink Ltd."  },
    { 0x1887, "Fishcamp Engineering"  },
    { 0x1888, "Livingston Products, Inc."  },
    { 0x1889, "DME Corporation"  },
    { 0x188A, "Moeller"  },
    { 0x188B, "Showa Electric Laboratory Co., Ltd."  },
    { 0x188C, "Epos Development Ltd."  },
    { 0x188D, "Across Techno, Inc."  },
    { 0x188E, "Neopost Technologies"  },
    { 0x188F, "Zefatek Co., Ltd."  },
    { 0x1890, "MEDIAN Inc."  },
    { 0x1891, "XSENSOR Technology Corp."  },
    { 0x1892, "Accuri Instruments, Inc."  },
    { 0x1893, "Ginga Software, Inc."  },
    { 0x1894, "SyntheSys Research, Inc."  },
    { 0x1895, "tesa scribos GmbH"  },
    { 0x1896, "Legacy Electronics, Inc."  },
    { 0x1897, "Evertop Wire Cable Co."  },
    { 0x1898, "Summit Microelectronics"  },
    { 0x1899, "Linkiss Co., Ltd."  },
    { 0x189A, "Earth Computer Technologies, Inc."  },
    { 0x189B, "Trimax Electronics Co., Ltd."  },
    { 0x189C, "Walletex Microelectronics Ltd."  },
    { 0x189D, "Navionics Inc."  },
    { 0x189E, "Net Insight AB"  },
    { 0x189F, "3Shape A/S"  },
    { 0x18A0, "Kongsberg Maritime AS"  },
    { 0x18A1, "Ionwerks, Inc."  },
    { 0x18A2, "PSIA Corp."  },
    { 0x18A3, "DIGIFRIENDS CO., LTD."  },
    { 0x18A4, "CSSN, Inc. dba Card Scanning Solutions"  },
    { 0x18A5, "Verbatim Americas LLC"  },
    { 0x18A6, "Peripheral Dynamics Inc."  },
    { 0x18A7, "Omniprint Inc."  },
    { 0x18A8, "Smiths Medical MD"  },
    { 0x18A9, "Veri-Tek International"  },
    { 0x18AA, "MedRx Inc."  },
    { 0x18AB, "Applied Data Systems, Inc."  },
    { 0x18AC, "STRATEC Biomedical Systems AG"  },
    { 0x18AD, "Invisible Technologies, Inc."  },
    { 0x18AE, "MTT Corporation"  },
    { 0x18AF, "LN Systems Limited"  },
    { 0x18B0, "Mikrodidakt AB"  },
    { 0x18B1, "Elmak Ltd."  },
    { 0x18B2, "CINTEL FRANCE"  },
    { 0x18B3, "RAYDON Corporation"  },
    { 0x18B4, "e3C Inc."  },
    { 0x18B5, "Klipsch Audio"  },
    { 0x18B6, "Mikkon Technology Limited"  },
    { 0x18B7, "Zotek Electronic Co., Ltd."  },
    { 0x18B8, "Securewave SA"  },
    { 0x18B9, "Clixxun GmbH"  },
    { 0x18BA, "Bell Fruit Games"  },
    { 0x18BB, "G7 Productivity Systems"  },
    { 0x18BC, "Muro Co., Ltd"  },
    { 0x18BD, "MNBT Co., Ltd."  },
    { 0x18BE, "Kingfisher International"  },
    { 0x18BF, "Ensyc Technologies"  },
    { 0x18C0, "Gatekeeper Systems Inc."  },
    { 0x18C1, "Shenzhen SDMC Microelectronics Co., Ltd."  },
    { 0x18C2, "AccuSport International, Inc."  },
    { 0x18C3, "Elite Semiconductor Memory Technology Inc. (ESMT)"  },
    { 0x18C4, "ServerEngines LLC"  },
    { 0x18C5, "Corega Taiwan, Inc."  },
    { 0x18C6, "Aurora Photonics"  },
    { 0x18C7, "Nagano Tectron Co., Ltd"  },
    { 0x18C8, "Computerprox Corp."  },
    { 0x18C9, "Exfo Electro-Optical Engineering Inc."  },
    { 0x18CA, "Canon Korea Business Solutions Inc."  },
    { 0x18CB, "Fr. Sauter AG"  },
    { 0x18CC, "Osaki Electric Co., Ltd."  },
    { 0x18CD, "Pico Instruments LLC"  },
    { 0x18CE, "DTC Communications, Inc"  },
    { 0x18CF, "Tung Shu Mei Industrial Co., Ltd."  },
    { 0x18D0, "Uniform Industrial Corp."  },
    { 0x18D1, "Google Inc."  },
    { 0x18D2, "Raptor Gaming Technology GmbH"  },
    { 0x18D3, "L&V Design"  },
    { 0x18D4, "ABI Electronics Ltd."  },
    { 0x18D5, "Starline International Group Limited"  },
    { 0x18D6, "Ruetz Technologies"  },
    { 0x18D7, "New Scale Technologies"  },
    { 0x18D8, "Individual Computers"  },
    { 0x18D9, "Kaba"  },
    { 0x18DA, "Phonol Inc."  },
    { 0x18DB, "Compix Incorporated"  },
    { 0x18DC, "LKC Technologies, Inc."  },
    { 0x18DD, "Docuport WC"  },
    { 0x18DE, "Cyto Pulse Sciences, Inc"  },
    { 0x18DF, "Cinea Inc."  },
    { 0x18E0, "Source Technologies, LLC"  },
    { 0x18E1, "Drew Technologies Inc."  },
    { 0x18E2, "S.J. Electronics Co., Ltd"  },
    { 0x18E3, "Fitilink Integrated Technology, Inc."  },
    { 0x18E4, "SB Solutions, Inc"  },
    { 0x18E5, "Ablaze Systems LLC"  },
    { 0x18E6, "Gobex AS"  },
    { 0x18E7, "Truscott Designs"  },
    { 0x18E8, "Mondo Systems"  },
    { 0x18E9, "Numsite Corporation"  },
    { 0x18EA, "Matrox Electronic Systems"  },
    { 0x18EB, "nDezign, Inc."  },
    { 0x18EC, "Arkmicro Technologies Inc."  },
    { 0x18ED, "Tyco Safety Products"  },
    { 0x18EE, "Holm Acoustics"  },
    { 0x18EF, "ELV Elektronik AG"  },
    { 0x18F0, "AVAL DATA CORPORATION"  },
    { 0x18F1, "AL Tech, Inc."  },
    { 0x18F2, "Rasotto S.N.C."  },
    { 0x18F3, "Miglia Technology Ltd."  },
    { 0x18F4, "Vtech Engineering Corporation"  },
    { 0x18F5, "Esterline Mason"  },
    { 0x18F6, "Zermatt Systems Inc"  },
    { 0x18F7, "ImageStream Internet Solutions Inc.."  },
    { 0x18F8, "Teitsu Denshi Kenkyusho Co., Ltd."  },
    { 0x18F9, "EX COMPANY LIMITED"  },
    { 0x18FA, "Kuang Ying Computer Equipment Co., Ltd."  },
    { 0x18FB, "Scriptel Corporation"  },
    { 0x18FC, "Kinyo Co., Ltd."  },
    { 0x18FD, "FineArch Inc."  },
    { 0x18FE, "SecuriMetrics, Inc."  },
    { 0x18FF, "HYUNDAI Digital Technology Co., Ltd."  },
    { 0x1900, "Future Wave, Inc."  },
    { 0x1901, "GE Healthcare"  },
    { 0x1902, "CSIRO Marine & Atmospheric Research"  },
    { 0x1903, "ANEX SYSTEM LTD."  },
    { 0x1904, "LVI Low Vision International AB"  },
    { 0x1905, "EGEMEN Bilgisayar Muh ve San LTD STI"  },
    { 0x1906, "Seoro Tech Co., Ltd."  },
    { 0x1907, "Elcoteq Design Center Oy"  },
    { 0x1908, "APPOTECH LIMITED"  },
    { 0x1909, "ABB Inc. Totalflow Division"  },
    { 0x190A, "Freewide Inc."  },
    { 0x190B, "Metasoft S.C."  },
    { 0x190C, "ierise Inc."  },
    { 0x190D, "Motorola GSG"  },
    { 0x190E, "YAMASA Tokei-Keiki Co, Ltd"  },
    { 0x190F, "YA HORNG ELECTRONIC CO., LTD."  },
    { 0x1910, "Seriprint-Ziprip UK Limited"  },
    { 0x1911, "Nihon Dengyo Kosaku Co., Ltd."  },
    { 0x1912, "Yukyung Technologies Co, Ltd"  },
    { 0x1913, "Atomynet, Inc."  },
    { 0x1914, "Alco Digital Devices Limited"  },
    { 0x1915, "Nordic Semiconductor ASA"  },
    { 0x1916, "Juniper Systems, Inc."  },
    { 0x1917, "Imagetech Corporation"  },
    { 0x1918, "NanoSystem Solutions, Inc."  },
    { 0x1919, "Pixelworks"  },
    { 0x191A, "PATLITE Corporation"  },
    { 0x191B, "PICOCEL Co., Ltd."  },
    { 0x191C, "Innovative Technology Limited"  },
    { 0x191D, "Midtronics, Inc."  },
    { 0x191E, "Monsoon Multimedia Inc."  },
    { 0x191F, "Venetex Co., Ltd."  },
    { 0x1920, "U.S. Digital Television, LLC"  },
    { 0x1921, "Interson Corporation"  },
    { 0x1922, "Power 7 Technologies Corp."  },
    { 0x1923, "FitSense Technology, Inc."  },
    { 0x1924, "QnAp iT"  },
    { 0x1925, "InnoFaith beauty sciences B.V."  },
    { 0x1926, "NextWindow Limited"  },
    { 0x1927, "Vulcan Portals Inc."  },
    { 0x1928, "PROCEQ SA"  },
    { 0x1929, "Wagner Owen Corporation"  },
    { 0x192A, "Intek"  },
    { 0x192B, "KVH Industries, Inc."  },
    { 0x192C, "Twig Com Oy"  },
    { 0x192D, "AgileTV"  },
    { 0x192E, "Bioanalytical Systems"  },
    { 0x192F, "Avago Technologies, Pte."  },
    { 0x1930, "Shenzhen Xianhe Technology Co., Ltd."  },
    { 0x1931, "Ningbo Broad Telecommunication Co., Ltd."  },
    { 0x1932, "Daniels Electronics Ltd."  },
    { 0x1933, "TASER INTERNATIONAL INC."  },
    { 0x1934, "SAKAI Medical Co., Ltd."  },
    { 0x1935, "Elektron Music Machines AB"  },
    { 0x1936, "Asaka Riken Co., Ltd"  },
    { 0x1937, "Dynjab Technologies Pty. Ltd."  },
    { 0x1938, "Meinberg Funkuhren GmbH & Co. KG"  },
    { 0x1939, "Hilscher GmbH"  },
    { 0x193A, "Lipman Electronic Engineering Ltd."  },
    { 0x193B, "Power Monitors, Inc."  },
    { 0x193C, "COGELEC"  },
    { 0x193D, "MAXIAN Co., Ltd."  },
    { 0x193E, "Chestnut Hill Sound Inc."  },
    { 0x193F, "OPDICOM PTY LTD"  },
    { 0x1940, "U.S. Music Corporation"  },
    { 0x1941, "Top Eight Industrial Corp."  },
    { 0x1942, "GAMING PARTNERS INTERNATIONAL"  },
    { 0x1943, "Sensoray"  },
    { 0x1944, "Wegener Communications"  },
    { 0x1945, "O-Pen"  },
    { 0x1946, "Irisguard UK Ltd"  },
    { 0x1947, "Harris Corporation"  },
    { 0x1948, "Darlitech International Co., Ltd."  },
    { 0x1949, "Lab126"  },
    { 0x194A, "Secure Design Institute Co., Ltd."  },
    { 0x194B, "Yanago Design Inc."  },
    { 0x194C, "Scanivalve Corp."  },
    { 0x194D, "Kern AG"  },
    { 0x194E, "acam-messelectronic GmbH"  },
    { 0x194F, "PreSonus Audio Electronics"  },
    { 0x1950, "FUJINON CORPORATION"  },
    { 0x1951, "Hyperstone GmbH"  },
    { 0x1952, "X-TEMPO DESIGNS LLC"  },
    { 0x1953, "Ironkey Inc."  },
    { 0x1954, "Radiient Technologies"  },
    { 0x1955, "4G Systems GmbH"  },
    { 0x1956, "The SmartPill Corporation"  },
    { 0x1957, "BIOS Corporation"  },
    { 0x1958, "Office Depot, Inc."  },
    { 0x1959, "DRS Signal Solutions Inc."  },
    { 0x195A, "Technology Link Corporation"  },
    { 0x195B, "Huge China Industrial Ltd."  },
    { 0x195C, "NewSight"  },
    { 0x195D, "Itron Technology Inc."  },
    { 0x195E, "Datakey Electronics"  },
    { 0x195F, "GODEX INTERNATIONAL CO., LTD."  },
    { 0x1960, "Brains Corporation"  },
    { 0x1961, "Grupo CD World S.L."  },
    { 0x1962, "Vstone Corp."  },
    { 0x1963, "IK MULTIMEDIA PRODUCTION srl"  },
    { 0x1964, "ID Technica Sales Co., Ltd."  },
    { 0x1965, "Uniden Corporation"  },
    { 0x1966, "ELESTA GmbH"  },
    { 0x1967, "CASIO HITACHI Mobile Communications Co., Ltd."  },
    { 0x1968, "Global Silicon Ltd."  },
    { 0x1969, "TM-Research, Inc."  },
    { 0x196A, "SmartCom"  },
    { 0x196B, "Wispro Technology Inc."  },
    { 0x196C, "EMKA Technologies"  },
    { 0x196D, "InnoDisk Corporation"  },
    { 0x196E, "SEI"  },
    { 0x196F, "Otoichi Corporation"  },
    { 0x1970, "Dane-Elec Corp. USA"  },
    { 0x1971, "Real ID Technology Co., Ltd."  },
    { 0x1972, "Diagnostic Instruments, Inc."  },
    { 0x1973, "SpectraLink Corporation"  },
    { 0x1974, "LOSTEAKA, Inc."  },
    { 0x1975, "Dongguan Guneetal Wire & Cable Co., Ltd."  },
    { 0x1976, "Chipsbrand Microelectronics (HK) Co., Ltd."  },
    { 0x1977, "Thales"  },
    { 0x1978, "Lismore Instruments Limited"  },
    { 0x1979, "Suga Digital Technology Limited"  },
    { 0x197A, "Kellendonk Elektronik GmbH"  },
    { 0x197B, "Way Systems Inc."  },
    { 0x197C, "JSC Videofon MV"  },
    { 0x197D, "Leuze electronic GmbH & Co. KG"  },
    { 0x197E, "scemtec Transponder Technology GmbH"  },
    { 0x197F, "Triton"  },
    { 0x1980, "Storage Appliance Corp."  },
    { 0x1981, "Matrix Audio Designs Inc."  },
    { 0x1982, "Hitel Italia S.P.A."  },
    { 0x1983, "Icera Inc."  },
    { 0x1984, "Targetti Sankey S.P.A."  },
    { 0x1985, "Elmos Co., Ltd."  },
    { 0x1986, "Excelitas Technologies Corporation"  },
    { 0x1987, "Camille Bauer AG"  },
    { 0x1988, "Novar Controls"  },
    { 0x1989, "Nuconn Technology Corp."  },
    { 0x198A, "MODMEN Co., Ltd."  },
    { 0x198B, "Fluid Imaging Technologies, Inc"  },
    { 0x198C, "c-scape"  },
    { 0x198D, "Fairchild Imaging"  },
    { 0x198E, "Ingrid, Inc."  },
    { 0x198F, "Beceem Communications Inc."  },
    { 0x1990, "Acron Precision Industrial Co., Ltd."  },
    { 0x1991, "AAI Corporation"  },
    { 0x1992, "Avantes B.V."  },
    { 0x1993, "Bluetop Technology Co., Ltd."  },
    { 0x1994, "ZMM Ltd."  },
    { 0x1995, "Trillium Technology PTY LTD."  },
    { 0x1996, "PixeLINK"  },
    { 0x1997, "CEFLA S.C.R.L."  },
    { 0x1998, "JENOPTIK Laser, Optik, Systeme GmbH"  },
    { 0x1999, "iba AG"  },
    { 0x199A, "DNA-Technology"  },
    { 0x199B, "MicroStrain, Inc."  },
    { 0x199C, "Richnex Microelectronics Corporation"  },
    { 0x199D, "Dexxon Groupe"  },
    { 0x199E, "The Imaging Source Europe GmbH"  },
    { 0x199F, "Benica Corporation"  },
    { 0x19A0, "Krautkramer Japan Co., Ltd."  },
    { 0x19A1, "Zeecraft Tech."  },
    { 0x19A2, "SICK AG"  },
    { 0x19A3, "ASmobile Communication Inc."  },
    { 0x19A4, "Unique Medical Co., Ltd."  },
    { 0x19A5, "Harris RF Communication"  },
    { 0x19A6, "UBISYS TECHNOLOGIES"  },
    { 0x19A7, "SuperTop International Corp."  },
    { 0x19A8, "Biforst Technology Inc."  },
    { 0x19A9, "Musashi Co., Ltd."  },
    { 0x19AA, "musicobo"  },
    { 0x19AB, "Bodelin Technologies"  },
    { 0x19AC, "Hardworks, Inc."  },
    { 0x19AD, "RiTTO GmbH & Co. KG"  },
    { 0x19AE, "KeeLog"  },
    { 0x19AF, "Innomax Technology Ltd."  },
    { 0x19B0, "Sobal Corporation"  },
    { 0x19B1, "Kyoritsu Radio Co., Ltd."  },
    { 0x19B2, "Batronix Elektronik"  },
    { 0x19B3, "SPOTWAVE WIRELESS"  },
    { 0x19B4, "CELESTRON"  },
    { 0x19B5, "B & W Group"  },
    { 0x19B6, "Infotech Logistic, LLC"  },
    { 0x19B7, "SK-Electronics Co. Ltd."  },
    { 0x19B8, "Control Technology Inc."  },
    { 0x19B9, "Drobo, Inc."  },
    { 0x19BA, "ebro Electronic GmbH & Co. KG"  },
    { 0x19BB, "Informtest"  },
    { 0x19BC, "ioLab Systems Inc."  },
    { 0x19BD, "Celluon, Inc."  },
    { 0x19BE, "Guidance Software, Inc."  },
    { 0x19BF, "HASHIMOTO Electronic Industry Co., Ltd."  },
    { 0x19C0, "TeraTron GmbH"  },
    { 0x19C1, "Digital Info Technology Pte. Ltd."  },
    { 0x19C2, "TARGA GmbH"  },
    { 0x19C3, "Riskema Informatica e Automacao Ltda."  },
    { 0x19C4, "Control Gaging, Inc."  },
    { 0x19C5, "Danaher Sensors and Controls"  },
    { 0x19C6, "Harmony Microelectronic Inc."  },
    { 0x19C7, "WEG Equipamentos Eltricos S.A. - Automao"  },
    { 0x19C8, "Secure Key LLC"  },
    { 0x19C9, "Electronic Sports"  },
    { 0x19CA, "Sandio Technology Corp."  },
    { 0x19CB, "EMS (European) LTD."  },
    { 0x19CC, "SCIEN Co."  },
    { 0x19CD, "D. O. Tel Co., Ltd."  },
    { 0x19CE, "SINUS Messtechnik GmbH"  },
    { 0x19CF, "Parrot SA"  },
    { 0x19D0, "Pan Pacific Enterprise Co., Inc."  },
    { 0x19D1, "Channaa"  },
    { 0x19D2, "ZTE Corporation"  },
    { 0x19D3, "Zucchetti Centro Sistemi SPA"  },
    { 0x19D4, "I Bee, K.K."  },
    { 0x19D5, "CNB Technology Inc."  },
    { 0x19D6, "WIDE Corporation"  },
    { 0x19D7, "Unitop New Technology Co., Ltd."  },
    { 0x19D8, "Smart Point SA"  },
    { 0x19D9, "Fujitsu Ten Limited"  },
    { 0x19DA, "MUSE Inc."  },
    { 0x19DB, "GeBE Elektronik und Feinwerktechnik GmbH"  },
    { 0x19DC, "Communications & Power Industries"  },
    { 0x19DD, "NEXVU TECHNOLOGIES, Inc."  },
    { 0x19DE, "MITEQ Inc."  },
    { 0x19DF, "AlpnaCom"  },
    { 0x19E0, "Micro-Nits Co., Ltd."  },
    { 0x19E1, "WeiDuan Electronic Accessory (S.Z.) Co., Ltd."  },
    { 0x19E2, "Solomon Systech Limited"  },
    { 0x19E3, "Bae Systems IEWS"  },
    { 0x19E4, "In-Situ Inc."  },
    { 0x19E5, "Jetmobile"  },
    { 0x19E6, "Apex Digital Inc."  },
    { 0x19E7, "Charismathics GmbH"  },
    { 0x19E8, "Industrial Technology Research Institute"  },
    { 0x19E9, "Bartec Auto ID Ltd."  },
    { 0x19EA, "Lung Hwa Electronics Co., Ltd."  },
    { 0x19EB, "ACE Antenna, Advanced Technology R&D Team."  },
    { 0x19EC, "Forth Dimension Displays Ltd."  },
    { 0x19ED, "Plastic Logic Ltd."  },
    { 0x19EE, "Modern Marketing Concepts Inc."  },
    { 0x19EF, "Pak Heng Technology (Shenzhen) Co., Ltd."  },
    { 0x19F0, "Jyh Woei Industrial Co., Ltd."  },
    { 0x19F1, "SindoRicoh Co., LTD."  },
    { 0x19F2, "INFOMARK Co., Ltd."  },
    { 0x19F3, "JAPAN Kyastem Co., Ltd."  },
    { 0x19F4, "Malvern Instruments Ltd"  },
    { 0x19F5, "Nationz Technologies Inc."  },
    { 0x19F6, "J. A. Woollam Co. Inc."  },
    { 0x19F7, "Rode Microphones"  },
    { 0x19F8, "RoboTech srl"  },
    { 0x19F9, "Megadata (Europe) PLC"  },
    { 0x19FA, "SHENZHEN GAMEWARE ELECTRONIC CO., LTD."  },
    { 0x19FB, "VLSI Solution Oy"  },
    { 0x19FC, "BioControl A/S"  },
    { 0x19FD, "MTI Instruments"  },
    { 0x19FE, "Micromap Corporation"  },
    { 0x19FF, "Best Buy China Ltd."  },
    { 0x1A00, "Polymax Precision Industry Co., Ltd."  },
    { 0x1A01, "Siemens Power Transmission & Dist. Energy Automation"  },
    { 0x1A02, "DLoG GmbH"  },
    { 0x1A03, "HORIBA ITECH Co., Ltd."  },
    { 0x1A04, "ASTRO MACHINE CORP."  },
    { 0x1A05, "Media Lab., Inc"  },
    { 0x1A06, "Beijing Deng Hong Technology Co., Ltd."  },
    { 0x1A07, "HID"  },
    { 0x1A08, "Bellwood International, Inc."  },
    { 0x1A09, "DILANO GmbH"  },
    { 0x1A0B, "Teleste OYJ"  },
    { 0x1A0C, "Sunkorea Electronics Co., Ltd."  },
    { 0x1A0D, "Ladybug Technologies LLC"  },
    { 0x1A0E, "Sasse Elektronik GmbH"  },
    { 0x1A0F, "HT-ITALIA"  },
    { 0x1A10, "KWANG SUNG ELECTRONICS H.K. Co., Ltd."  },
    { 0x1A11, "eMDee Technology, Inc."  },
    { 0x1A12, "KES Co., Ltd."  },
    { 0x1A13, "Plasmon"  },
    { 0x1A14, "Brainvision Inc."  },
    { 0x1A15, "Amphenol-Tuchel Electronics GmbH"  },
    { 0x1A16, "General Dynamics"  },
    { 0x1A17, "Oticon A/S"  },
    { 0x1A18, "Quadzilla Performance Technologies, Inc."  },
    { 0x1A19, "DDTIC Corporation Ltd."  },
    { 0x1A1A, "ASIACORP INTERNATIONAL LTD."  },
    { 0x1A1B, "Fischer-Zoth GmbH"  },
    { 0x1A1C, "Mercury Computer Systems AG"  },
    { 0x1A1D, "Syncomm Technology Corp."  },
    { 0x1A1E, "Dekart s.r.l."  },
    { 0x1A1F, "Ikanos Communications Inc."  },
    { 0x1A20, "Mind Logic Co., Ltd."  },
    { 0x1A21, "ASITEQ Co., Ltd."  },
    { 0x1A22, "Kenwin Industrial (HK) Ltd."  },
    { 0x1A23, "Hangzhou YiHeng Technologies Co., Ltd."  },
    { 0x1A24, "Beyondwiz Co., Ltd."  },
    { 0x1A25, "Amphenol East Asia Ltd."  },
    { 0x1A26, "APSI (Asia Pacific Satellite Industry)"  },
    { 0x1A27, "Senior Technologies"  },
    { 0x1A28, "NOVITUS SA"  },
    { 0x1A29, "ABOV Semiconductor Co., Ltd."  },
    { 0x1A2A, "Seagate Branded Solutions"  },
    { 0x1A2B, "NTI Corporation"  },
    { 0x1A2C, "Wuxi China Resources Semico Co., Ltd."  },
    { 0x1A2D, "WEBSYNC Co., Ltd."  },
    { 0x1A2E, "Lanner Electronics Inc."  },
    { 0x1A2F, "Tetradyne Software Inc."  },
    { 0x1A30, "New Media Life"  },
    { 0x1A31, "SPEX SamplePrep, LLC"  },
    { 0x1A32, "Verint Video Technology GmbH"  },
    { 0x1A33, "Schmid & Partner Engineering AG"  },
    { 0x1A34, "King Chuang Tech & Electronic Co., Ltd."  },
    { 0x1A35, "Artesyn Technologies Inc."  },
    { 0x1A36, "Topdisk Technology Limited"  },
    { 0x1A37, "Stayhealthy Inc."  },
    { 0x1A38, "Nemo-Q International AB"  },
    { 0x1A39, "GBC Scientific Equipment"  },
    { 0x1A3A, "Laerdal Medical AS"  },
    { 0x1A3B, "South Mountain Technologies, Ltd."  },
    { 0x1A3C, "New Image Co., Ltd."  },
    { 0x1A3D, "ELGA LabWater (VWS UK LTD)"  },
    { 0x1A3E, "INTEVAC"  },
    { 0x1A3F, "Hokkei Industries Co., Ltd."  },
    { 0x1A40, "TERMINUS TECHNOLOGY INC."  },
    { 0x1A41, "Action Electronics Co., Ltd."  },
    { 0x1A42, "CROSSLINK GmbH"  },
    { 0x1A43, "JTEKT CORPORATION"  },
    { 0x1A44, "VASCO Data Security NV"  },
    { 0x1A45, "Wavelength Electronics Inc."  },
    { 0x1A46, "JAVAD GNSS, Inc."  },
    { 0x1A47, "iQBio, Inc."  },
    { 0x1A48, "KYOHRITSU ELECTRONIC INDUSTRY Co., Ltd."  },
    { 0x1A49, "TOKYO SEIMITSU CO., LTD."  },
    { 0x1A4A, "Silicon Image"  },
    { 0x1A4B, "SafeBoot International B.V."  },
    { 0x1A4C, "PMC"  },
    { 0x1A4D, "N-CRYPT, Inc."  },
    { 0x1A4E, "SIMS Corp."  },
    { 0x1A4F, "Haliplex PTY Ltd."  },
    { 0x1A50, "Mechatro Inc."  },
    { 0x1A51, "FRWD Technologies Ltd."  },
    { 0x1A52, "MediaPhy Corporation"  },
    { 0x1A53, "SANDBOX Co., Ltd"  },
    { 0x1A54, "Oestling Markiersysteme GmbH"  },
    { 0x1A55, "Raytheon Systems Limited"  },
    { 0x1A56, "East Port Technology Co., Ltd."  },
    { 0x1A57, "ARESIS d.o.o."  },
    { 0x1A58, "Miranda Technologies Inc."  },
    { 0x1A59, "HAAG-STREIT AG"  },
    { 0x1A5A, "Tandberg Data"  },
    { 0x1A5B, "Entner Electronics KEG"  },
    { 0x1A5C, "Arkino Corporation Limited"  },
    { 0x1A5D, "Daikin Denshi Kogyo Co., Ltd."  },
    { 0x1A5E, "Edixia"  },
    { 0x1A5F, "Sonatest Limited"  },
    { 0x1A60, "Joytoto Co., Ltd."  },
    { 0x1A61, "Abbott Diabetes Care"  },
    { 0x1A62, "DAT H.K. LIMITED"  },
    { 0x1A63, "Canfield Scientific, Inc."  },
    { 0x1A64, "MASTERVOLT INTERNATIONAL"  },
    { 0x1A65, "ELEKTRINA d.o.o., podjetje za razvoj elektronike"  },
    { 0x1A66, "Andatek Technology, Ltd."  },
    { 0x1A67, "Privaris"  },
    { 0x1A68, "Double Top Technology Ltd."  },
    { 0x1A69, "Kalon Semiconductor, Inc."  },
    { 0x1A6A, "Cypress Semiconductor GmbH"  },
    { 0x1A6B, "Taiwin Electronics Co., Ltd."  },
    { 0x1A6C, "Hivion Co., Ltd."  },
    { 0x1A6D, "SamYoung Electronics Co., Ltd"  },
    { 0x1A6E, "Global Unichip Corp."  },
    { 0x1A6F, "Sagem Orga GmbH"  },
    { 0x1A70, "Items Technology Co., Ltd."  },
    { 0x1A71, "SEIDEL Elektronik GmbH Nfg. KG"  },
    { 0x1A72, "Physik Instrumente (PI) GmbH & Co. KG"  },
    { 0x1A73, "Huntron Inc."  },
    { 0x1A74, "Oberthur Technologies"  },
    { 0x1A75, "Nautilus Hyosung"  },
    { 0x1A76, "JADAK Technologies, Inc."  },
    { 0x1A77, "American Master Import 26, Inc."  },
    { 0x1A78, "AirLink Communications, Inc."  },
    { 0x1A79, "Ascensia Diabetes Care"  },
    { 0x1A7A, "Softron Co., Ltd."  },
    { 0x1A7B, "Lumberg Connect GmbH"  },
    { 0x1A7C, "Evoluent LLC"  },
    { 0x1A7D, "Systex Corporation"  },
    { 0x1A7E, "MELTEC Systementwicklung"  },
    { 0x1A7F, "SSD COMPANY LIMITED"  },
    { 0x1A80, "Zhong Ming Wire Cable Technology (Xiamen) Co., Ltd."  },
    { 0x1A81, "G.Tech Technology Ltd."  },
    { 0x1A82, "Proconn Technology Co., Ltd."  },
    { 0x1A83, "Socle Technology Corp."  },
    { 0x1A84, "COBB Tuning, Inc."  },
    { 0x1A85, "Southwest Research Institute"  },
    { 0x1A86, "Nanjing Qinherg Electronics Co., Ltd."  },
    { 0x1A87, "TechLab 2000 Ltd. Co., Sp Zo.o."  },
    { 0x1A88, "WowWee Limited"  },
    { 0x1A89, "Dynalith Systems Co., Ltd."  },
    { 0x1A8A, "Simula Technology Inc."  },
    { 0x1A8B, "SGS Taiwan Ltd."  },
    { 0x1A8C, "MagicEyes Digital Co., Ltd"  },
    { 0x1A8D, "BandRich Inc."  },
    { 0x1A8E, "XiTRON Technologies"  },
    { 0x1A8F, "Harman Becker Automotive Systems, GmbH"  },
    { 0x1A90, "Resource Data Management"  },
    { 0x1A91, "GEOMC Co., Ltd."  },
    { 0x1A92, "Berkash Enterprise"  },
    { 0x1A93, "Promotional Technologies International Corp."  },
    { 0x1A94, "STWTECH Co., Ltd."  },
    { 0x1A95, "Sextant Labs, Inc."  },
    { 0x1A96, "Harman Becker Automotive Systems, Inc."  },
    { 0x1A97, "XM Satellite Radio Inc."  },
    { 0x1A98, "Leica Camera AG"  },
    { 0x1A99, "Asia Tai Technology (Dongguan) Co., Ltd."  },
    { 0x1A9A, "Verari Systems, Inc."  },
    { 0x1A9B, "Balboa Instruments"  },
    { 0x1A9C, "Inomed Medizintechnik GmbH"  },
    { 0x1A9D, "TrafficSim Co., Ltd."  },
    { 0x1A9E, "Epicenter, Inc."  },
    { 0x1A9F, "Hysitron Incorporated"  },
    { 0x1AA0, "Auto Enginuity, L.L.C."  },
    { 0x1AA1, "Vestax Corporation"  },
    { 0x1AA2, "ORIENTAL MOTOR CO., LTD."  },
    { 0x1AA3, "ZOLL Medical Corporation"  },
    { 0x1AA4, "Data Drive Thru, Inc."  },
    { 0x1AA5, "UBeacon Technologies, Inc."  },
    { 0x1AA6, "eFortune Technology Corp."  },
    { 0x1AA7, "SiliconSystems, Inc."  },
    { 0x1AA8, "Waves Audio Ltd."  },
    { 0x1AA9, "Home Phone Tunes Inc."  },
    { 0x1AAA, "Taylor Associates/Communications, Inc."  },
    { 0x1AAB, "SilverCreations Software AG"  },
    { 0x1AAC, "Witschi Electronic AG"  },
    { 0x1AAD, "KeeTouch Electronic Co., Ltd."  },
    { 0x1AAE, "Johnson Component & Equipments Co., Ltd."  },
    { 0x1AAF, "Intellectual Property Library Company"  },
    { 0x1AB0, "DAEWOO ELECTRONIC COMPONENTS CO., LTD."  },
    { 0x1AB1, "Rigol Technologies, Inc."  },
    { 0x1AB2, "Allied Vision Technologies GmbH"  },
    { 0x1AB3, "M and C System"  },
    { 0x1AB4, "Japan Remote Control Co., Ltd."  },
    { 0x1AB5, "Hamamatsu TOA Electronics, Inc."  },
    { 0x1AB6, "Integrated Technology Corp."  },
    { 0x1AB7, "GLOBAL VR, Inc."  },
    { 0x1AB8, "Pen Laboratory Inc."  },
    { 0x1AB9, "Nomadio Inc."  },
    { 0x1ABA, "Kenton Electronics Limited"  },
    { 0x1ABB, "Airo Wireless Media Inc."  },
    { 0x1ABC, "Fuji Photo Film USA"  },
    { 0x1ABD, "PERTO S.A."  },
    { 0x1ABE, "MP3Car.com Inc"  },
    { 0x1ABF, "ANIMA Corporation"  },
    { 0x1AC0, "SOKKIA Co., Ltd."  },
    { 0x1AC1, "LIANHE TECHNOLOGIES, INC."  },
    { 0x1AC2, "DESKO GmbH"  },
    { 0x1AC3, "DISK KING Technology Co., Ltd."  },
    { 0x1AC4, "CAO Group, Inc."  },
    { 0x1AC5, "Electronic Engineering Solutions S.L."  },
    { 0x1AC6, "JAPAN ADE LTD."  },
    { 0x1AC7, "Modular Communication Systems, Inc."  },
    { 0x1AC8, "Toyota Industries Corporation"  },
    { 0x1AC9, "Broadxent Pte. Ltd."  },
    { 0x1ACA, "Bluebird Soft Inc."  },
    { 0x1ACB, "Salcomp Plc"  },
    { 0x1ACC, "Ta Horng Musical Instrument Co., Ltd."  },
    { 0x1ACD, "MKS Instruments"  },
    { 0x1ACE, "Temento Systems"  },
    { 0x1ACF, "International Manufacturing & Engineering Services Co."  },
    { 0x1AD0, "Cygnetron, Inc."  },
    { 0x1AD1, "Desan Wire Co., Ltd."  },
    { 0x1AD2, "Mesa Imaging AG"  },
    { 0x1AD3, "Advanced Technetix, Inc."  },
    { 0x1AD4, "Advanced Printing Systems"  },
    { 0x1AD5, "Gentec-EO"  },
    { 0x1AD6, "General Dynamics SATCOM Technologies, State College Fac"  },
    { 0x1AD7, "A.B.O. Co., Ltd."  },
    { 0x1AD8, "Motion Control i Vsters AB"  },
    { 0x1AD9, "Rocket Gaming Systems"  },
    { 0x1ADA, "VEGA Grieshaber KG"  },
    { 0x1ADB, "Schweitzer Engineering Laboratories"  },
    { 0x1ADC, "Turbolinux, Inc."  },
    { 0x1ADD, "Marshall Electronics, Inc."  },
    { 0x1ADE, "SpinMaster Ltd."  },
    { 0x1ADF, "digital design GmbH"  },
    { 0x1AE0, "Axiomatic Technologies Corp."  },
    { 0x1AE1, "Hoffman Engineering"  },
    { 0x1AE2, "A-JET Technology Co., LTD."  },
    { 0x1AE3, "Chung Young Digital Corp., Ltd."  },
    { 0x1AE4, "ic-design Reinhard Gottinger GmbH"  },
    { 0x1AE5, "Jianduan Technology (Shenzhen) Co., Ltd"  },
    { 0x1AE6, "JOA Telecom Co., Ltd."  },
    { 0x1AE7, "Joellenbeck GmbH"  },
    { 0x1AE8, "Myway Labs Co., Ltd."  },
    { 0x1AE9, "arnotec GmbH"  },
    { 0x1AEA, "Mobilygen Corporation"  },
    { 0x1AEB, "NIHON UNICA CORPORATION"  },
    { 0x1AEC, "PORTEK TECHNOLOGY CORPORATION"  },
    { 0x1AED, "High Top Precision Electronic Co., Ltd."  },
    { 0x1AEE, "SHEN ZHEN REX TECHNOLOGY CO., LTD."  },
    { 0x1AEF, "Octekconn Incorporation"  },
    { 0x1AF0, "SuperPix Micro Technology Limited"  },
    { 0x1AF1, "Connect One, Ltd."  },
    { 0x1AF2, "AXSionics AG"  },
    { 0x1AF3, "Smarthome Technology Limited"  },
    { 0x1AF4, "NCS Pearson, Inc."  },
    { 0x1AF5, "Arima Communications Corp."  },
    { 0x1AF6, "SL International Ltd."  },
    { 0x1AF7, "GRAPHIN CO., LTD."  },
    { 0x1AF8, "JS-ROBOTICS"  },
    { 0x1AF9, "Alvarion Ltd."  },
    { 0x1AFA, "Mobinnova Corp."  },
    { 0x1AFB, "Kirche Jesu Christi der Heiligen der Letzten Tage"  },
    { 0x1AFC, "Blue Orb"  },
    { 0x1AFD, "FarSite Communications Limited"  },
    { 0x1AFE, "A. Eberle GmbH & Co. KG"  },
    { 0x1AFF, "Defibtech, LLC"  },
    { 0x1B00, "Uster Technologies, Inc."  },
    { 0x1B01, "ETA Chips, Co."  },
    { 0x1B02, "MEN Mikro Elektronik GmbH"  },
    { 0x1B03, "Moog Japan Ltd."  },
    { 0x1B04, "MEILHAUS Electronic GmbH"  },
    { 0x1B05, "Cracol Developments Ltd."  },
    { 0x1B06, "OPGAL"  },
    { 0x1B07, "WEY Technology AG"  },
    { 0x1B08, "Actimo Inc."  },
    { 0x1B09, "MISUZU INDUSTRIES CORPORATION"  },
    { 0x1B0A, "Sense Technology Inc."  },
    { 0x1B0B, "Lambda Systems Inc."  },
    { 0x1B0C, "MYTECS Co., Ltd."  },
    { 0x1B0D, "SmarDTV"  },
    { 0x1B0E, "BLUTRONICS S.R.L."  },
    { 0x1B0F, "EKS-ELEKTRONIKSERVICE GmbH"  },
    { 0x1B10, "KAGA COMPONENTS CO., LTD."  },
    { 0x1B11, "OneClick Technologies Ltd."  },
    { 0x1B12, "Eventide, Inc."  },
    { 0x1B13, "Neuf Cegetel"  },
    { 0x1B14, "Ergotron, Inc."  },
    { 0x1B15, "i3micro technology ab"  },
    { 0x1B16, "LinTech GmbH Berlin"  },
    { 0x1B17, "SHENZHEN e-loam Technology Co., Ltd."  },
    { 0x1B18, "Mikrolab Entwicklungsgesellschaft fur Elektroniksysteme"  },
    { 0x1B19, "RADA Electronic Industries Ltd."  },
    { 0x1B1A, "Tianjin China-Silicon Microelectronics Co., Ltd."  },
    { 0x1B1B, "Shenzhen MD Electric Co., Ltd."  },
    { 0x1B1C, "CORSAIR MEMORY INC."  },
    { 0x1B1D, "Torian Wireless Ltd."  },
    { 0x1B1E, "General Imaging Company"  },
    { 0x1B1F, "eQ-3 Entwicklung GmbH"  },
    { 0x1B20, "MStar Semiconductor, Inc."  },
    { 0x1B21, "XenICs nv"  },
    { 0x1B22, "WiLinx Corp."  },
    { 0x1B23, "Skyray Instrument Co., Ltd."  },
    { 0x1B24, "Telegent Systems Inc."  },
    { 0x1B25, "ALE"  },
    { 0x1B26, "Plug Power"  },
    { 0x1B27, "Current Electronics Inc."  },
    { 0x1B28, "NAVIsis Inc."  },
    { 0x1B29, "Industrie Dial Face S.p.A."  },
    { 0x1B2A, "MICRO EMISSION CO., LTD."  },
    { 0x1B2B, "Neural Image Co., Ltd."  },
    { 0x1B2C, "Advanced Thermal Solutions, Inc."  },
    { 0x1B2D, "Photon Inc."  },
    { 0x1B2E, "ETANI ELECTRONICS CO., LTD."  },
    { 0x1B2F, "Ihara Electronic Industries Co.,Ltd."  },
    { 0x1B30, "STZ QSBV Ilmenau"  },
    { 0x1B31, "Renu Electronics Pvt. Ltd."  },
    { 0x1B32, "Ugobe, Inc."  },
    { 0x1B33, "3DV Systems Ltd."  },
    { 0x1B34, "EyeTalk Systems, Inc."  },
    { 0x1B35, "Paradigm Electronics Inc."  },
    { 0x1B36, "ViXS Systems, Inc."  },
    { 0x1B37, "Savant Systems, LLC"  },
    { 0x1B38, "ALBAHITH TECHNOLOGIES"  },
    { 0x1B39, "ViaMichelin SAS"  },
    { 0x1B3A, "JUMO GmbH & Co. KG"  },
    { 0x1B3B, "iPassion Technology Inc."  },
    { 0x1B3C, "DEVI A/S"  },
    { 0x1B3D, "Matrix Orbital"  },
    { 0x1B3E, "STIL SA"  },
    { 0x1B3F, "Generalplus Technology Inc."  },
    { 0x1B40, "AISIN SEIKI CO., LTD."  },
    { 0x1B41, "Fujitsu Australia Limited"  },
    { 0x1B42, "Cardinal Scale Manufacturing Company"  },
    { 0x1B43, "Extron Design Services"  },
    { 0x1B44, "Elite Co., Ltd."  },
    { 0x1B45, "Cyan Technology Ltd."  },
    { 0x1B46, "Holylite Microelectronics Corp."  },
    { 0x1B47, "Energizer Holdings, Inc."  },
    { 0x1B48, "Plastron Precision Co., Ltd."  },
    { 0x1B49, "Applied Printed Electronics Research, LLC"  },
    { 0x1B4A, "Gem-Med, S.L."  },
    { 0x1B4B, "Watson Marlow Ltd."  },
    { 0x1B4C, "Unitron Group"  },
    { 0x1B4D, "Objet Geometries Ltd."  },
    { 0x1B4E, "ELPRO-BUCHS AG"  },
    { 0x1B4F, "Spark Fun Electronics"  },
    { 0x1B50, "DictaNet Software AG"  },
    { 0x1B51, "Kundisch GmbH & Co. KG"  },
    { 0x1B52, "A.R. Hungary, Inc."  },
    { 0x1B53, "DANI Instruments S.p.A."  },
    { 0x1B54, "COMMIT Incorporated"  },
    { 0x1B55, "ZKSoftware Inc."  },
    { 0x1B56, "V.I.O., Inc."  },
    { 0x1B57, "ATREE Inc."  },
    { 0x1B58, "Sumitomo Elec Ind Ltd. Lightwave Network Products Div."  },
    { 0x1B59, "K.S. Terminals Inc."  },
    { 0x1B5A, "Chao Zhou Kai Yuan Electric Co., Ltd."  },
    { 0x1B5B, "Homoth Medizinelektronik"  },
    { 0x1B5C, "ICP DAS Co., Ltd."  },
    { 0x1B5D, "MV Circuit Design, Inc."  },
    { 0x1B5E, "General Engine Management Systems Ltd."  },
    { 0x1B5F, "Wayne Dalton Corp."  },
    { 0x1B60, "NanoDrop Technologies, Inc."  },
    { 0x1B61, "n-Trance Security Ltd."  },
    { 0x1B62, "Shenzhen Aoni Electronic Industry Co., Ltd."  },
    { 0x1B63, "Seedsware Corporation"  },
    { 0x1B64, "C.G. Development Ltd."  },
    { 0x1B65, "The Hong Kong Standards and Testing Centre Ltd."  },
    { 0x1B66, "Bontempi-Farfisa Sigma S.p.A."  },
    { 0x1B67, "Toradex AG"  },
    { 0x1B68, "ZAFENA AB"  },
    { 0x1B69, "KLA-Tencor"  },
    { 0x1B6A, "HIKARI Co., Ltd."  },
    { 0x1B6B, "Modiotek Co., Ltd."  },
    { 0x1B6C, "Techno Veins Co., Ltd."  },
    { 0x1B6D, "IDpendant GmbH"  },
    { 0x1B6E, "HS Automatic ApS"  },
    { 0x1B6F, "Federal Signal Vama S.A."  },
    { 0x1B70, "Minicom Advanced Systems"  },
    { 0x1B71, "Huizhou 10Moons Technology Development Co., Ltd."  },
    { 0x1B72, "ATERGI TECHNOLOGY CO., LTD."  },
    { 0x1B73, "Vehicle Camera Systems Ltd"  },
    { 0x1B74, "MODAFUN, Inc."  },
    { 0x1B75, "OvisLink Corp."  },
    { 0x1B76, "Legend Silicon Corp."  },
    { 0x1B77, "Protec, Inc."  },
    { 0x1B78, "LOGICPACK CO., LTD."  },
    { 0x1B79, "WingsTek, Inc."  },
    { 0x1B7A, "Electrox"  },
    { 0x1B7B, "Ingersoll Rand Co."  },
    { 0x1B7C, "io Corporation"  },
    { 0x1B7D, "SUNGIL TELECOM"  },
    { 0x1B7E, "Lutron Electronics Inc."  },
    { 0x1B7F, "EMC Corporation"  },
    { 0x1B80, "KWorld Computer Co., Ltd."  },
    { 0x1B81, "Kratos Analytical Ltd."  },
    { 0x1B82, "Mcube Technology Co., Ltd."  },
    { 0x1B83, "Megatone systems and Technologies LTD."  },
    { 0x1B84, "WALTHER Data GmbH Scan-Solutions"  },
    { 0x1B85, "INNOVA S.A."  },
    { 0x1B86, "Dongguan Guanshang Electronics Co., Ltd."  },
    { 0x1B87, "Davis Instruments"  },
    { 0x1B88, "ShenMing Electron (Dong Guan) Co., Ltd."  },
    { 0x1B89, "iCache, Incorporated"  },
    { 0x1B8A, "Quellan, Inc."  },
    { 0x1B8B, "PROCES-DATA A/S"  },
    { 0x1B8C, "Altium Limited"  },
    { 0x1B8D, "e-MOVE Technology Co., Ltd."  },
    { 0x1B8E, "Amlogic, Inc."  },
    { 0x1B8F, "Super Talent Technology, Inc."  },
    { 0x1B90, "Deep Sea Electronics Plc"  },
    { 0x1B91, "Zicplay SA"  },
    { 0x1B92, "Trysys Co., Ltd."  },
    { 0x1B93, "Phoenix Contact GmbH & Co. KG"  },
    { 0x1B94, "Yoggie Security Systems"  },
    { 0x1B95, "EVC electronic GmbH"  },
    { 0x1B96, "N-Trig"  },
    { 0x1B97, "Metronix GmbH"  },
    { 0x1B98, "YMax Communications Corp."  },
    { 0x1B99, "Shenzhen Yuanchuan Electronic"  },
    { 0x1B9A, "Applied Vision Systems Corporation"  },
    { 0x1B9B, "Microtrac, Inc."  },
    { 0x1B9C, "Maki Manufacturing Co., Ltd."  },
    { 0x1B9D, "Sigma Instruments, Inc."  },
    { 0x1B9E, "ARCoptix S.A"  },
    { 0x1B9F, "GHI Electronics, LLC"  },
    { 0x1BA0, "Jiangmen Kong Yue Jolimark Information Technology Ltd."  },
    { 0x1BA1, "JINQ CHERN ENTERPRISE CO., LTD."  },
    { 0x1BA2, "Lite Metals & Plastic (Shenzhen) Co., Ltd."  },
    { 0x1BA3, "EmbeddedFusion Ltd."  },
    { 0x1BA4, "Ember Corporation"  },
    { 0x1BA5, "Futiro"  },
    { 0x1BA6, "Abilis Systems"  },
    { 0x1BA7, "Xantech Corporation"  },
    { 0x1BA8, "China Telecommunication Technology Labs"  },
    { 0x1BA9, "Renau Electronic Laboratories"  },
    { 0x1BAA, "Transcell Technology, Inc."  },
    { 0x1BAB, "MATT R.P.Traczynscy Sp.J."  },
    { 0x1BAC, "Bernecker + Rainer Industrie-Elektronik Ges.m.b.H."  },
    { 0x1BAD, "Harmonix Music Systems, Inc."  },
    { 0x1BAE, "Vuzix Corporation"  },
    { 0x1BAF, "NIIGATA SEIMITSU CO., LTD."  },
    { 0x1BB0, "LBS PLUS Co., Ltd."  },
    { 0x1BB1, "Commodore International Corporation"  },
    { 0x1BB2, "G.T. trading Srl"  },
    { 0x1BB3, "Holzworth Instrumentation LLC"  },
    { 0x1BB4, "Satmap Systems Ltd."  },
    { 0x1BB5, "SEF Roboter GmbH"  },
    { 0x1BB6, "PdMA Corporation"  },
    { 0x1BB7, "DGT Sp. z o.o."  },
    { 0x1BB8, "MIZOUE PROJECT JAPAN Corporation"  },
    { 0x1BB9, "Qpixel Technology, Inc."  },
    { 0x1BBA, "Medicomp, Inc."  },
    { 0x1BBB, "TCL Communication Ltd"  },
    { 0x1BBC, "KATHREIN-Werke KG"  },
    { 0x1BBD, "Videology Imaging Solutions, Inc."  },
    { 0x1BBE, "CE+T s.a."  },
    { 0x1BBF, "Littfinski DatenTechnik (LDT)"  },
    { 0x1BC0, "Senselock Software Technology Co.,Ltd"  },
    { 0x1BC1, "ACE ELECTRONIQUE"  },
    { 0x1BC2, "SEW-EURODRIVE GmbH & Co. KG"  },
    { 0x1BC3, "Fujian START Computer Equipment Co., Ltd."  },
    { 0x1BC4, "Ford Motor Co."  },
    { 0x1BC5, "AVIXE Technology (China) Ltd."  },
    { 0x1BC6, "Yurex, Inc."  },
    { 0x1BC7, "Telit Wireless Solutions"  },
    { 0x1BC8, "MDS Technology Co., Ltd."  },
    { 0x1BC9, "Alti-2 Inc."  },
    { 0x1BCA, "Ishii Hyoki Co., Ltd."  },
    { 0x1BCB, "Cubic Defence NZ Limited"  },
    { 0x1BCC, "TopScan Ltd."  },
    { 0x1BCD, "AZKOYEN"  },
    { 0x1BCE, "Contac Cable Industrial Limited"  },
    { 0x1BCF, "Sunplus Innovation Technology Inc."  },
    { 0x1BD0, "Hangzhou Riyue Electronics Co., Ltd."  },
    { 0x1BD1, "Companion Worlds, Inc."  },
    { 0x1BD2, "Beijing G & D Card Systems Co., Ltd."  },
    { 0x1BD3, "3layer Engineering"  },
    { 0x1BD4, "FastVDO Inc."  },
    { 0x1BD5, "BG Systems, Inc."  },
    { 0x1BD6, "Lodam electronics"  },
    { 0x1BD7, "TouchNetworks, Inc."  },
    { 0x1BD8, "Image Computer Systems Limited"  },
    { 0x1BD9, "Emerson"  },
    { 0x1BDA, "University of Southampton"  },
    { 0x1BDB, "Spectral Applied Research"  },
    { 0x1BDC, "Slacker"  },
    { 0x1BDD, "QiGO Inc"  },
    { 0x1BDE, "P-TWO INDUSTRIES, INC."  },
    { 0x1BDF, "Electrone Americas Ltd., Co."  },
    { 0x1BE0, "Analog Devices, Inc. - Test Technology Group"  },
    { 0x1BE1, "LG-Ericsson Co., Ltd"  },
    { 0x1BE2, "Shenzhen Fametech Electronic Co., Ltd."  },
    { 0x1BE3, "WAGO Kontakttechnik GmbH & Co. KG"  },
    { 0x1BE4, "Integrated Digital Technologies, Inc. (IDTI)"  },
    { 0x1BE5, "NetLogic Microsystems"  },
    { 0x1BE6, "NAVENTO TECHNOLOGIES"  },
    { 0x1BE7, "CPR Tools, Inc."  },
    { 0x1BE8, "MEDAV GmbH"  },
    { 0x1BE9, "CONCH ELECTRONIC CO., LTD."  },
    { 0x1BEA, "ATTO Corporation"  },
    { 0x1BEB, "HOYA CANDEO OPTRONICS CORPORATION"  },
    { 0x1BEC, "isMedia Co., Ltd."  },
    { 0x1BED, "OPT Corporation"  },
    { 0x1BEE, "KCI Medical Products (UK) Ltd."  },
    { 0x1BEF, "Shenzhen Tongyuan Network-Communication Cables Co., Ltd"  },
    { 0x1BF0, "RealVision Inc."  },
    { 0x1BF1, "HENGSTLER"  },
    { 0x1BF2, "Newport Media, Inc."  },
    { 0x1BF3, "WAVES SYSTEM / SONAMIX"  },
    { 0x1BF4, "ABB / Drives"  },
    { 0x1BF5, "Extranet Systems Inc."  },
    { 0x1BF6, "Orient Semiconductor Electronics, Ltd."  },
    { 0x1BF7, "Axiotron, Inc."  },
    { 0x1BF8, "Game Mechanisms LLC"  },
    { 0x1BF9, "TRACTEL SAS"  },
    { 0x1BFA, "METROLAB TECHNOLOGY SA"  },
    { 0x1BFB, "ALLIED PANELS"  },
    { 0x1BFC, "Guidance Interactive Healthcare"  },
    { 0x1BFD, "RISINTECH INC."  },
    { 0x1BFE, "SEOHWA TELECOM Co., LTD."  },
    { 0x1BFF, "IonOptix Corp."  },
    { 0x1C00, "prodaSafe GmbH"  },
    { 0x1C01, "No Climb Products Ltd."  },
    { 0x1C02, "Kreton Corporation"  },
    { 0x1C03, "DDL CO., LTD."  },
    { 0x1C04, "QNAP System Inc."  },
    { 0x1C05, "Rockwell Collins"  },
    { 0x1C06, "SeekTech, Inc."  },
    { 0x1C07, "CEntrance, Inc."  },
    { 0x1C08, "Arcus-EDS GmbH"  },
    { 0x1C09, "RAMTEX Engineering ApS"  },
    { 0x1C0A, "MaxRise Inc."  },
    { 0x1C0B, "Kato Tech Co., Ltd."  },
    { 0x1C0C, "Ionics EMS Inc."  },
    { 0x1C0D, "Relm Wireless"  },
    { 0x1C0E, "Qstik plc"  },
    { 0x1C0F, "NEOTECHKNO"  },
    { 0x1C10, "Lanterra Industrial Co., Ltd."  },
    { 0x1C11, "UNIMTEC Co., Ltd."  },
    { 0x1C12, "CONITEC DATENSYSTEME GmbH"  },
    { 0x1C13, "ALECTRONIC LIMITED"  },
    { 0x1C14, "SENSITIVE OBJECT"  },
    { 0x1C15, "TeleWell Oy"  },
    { 0x1C16, "Afit Corporation"  },
    { 0x1C17, "LAB REHAB PTE LTD."  },
    { 0x1C18, "Apria Technology"  },
    { 0x1C19, "Charder Electronic Co., Ltd."  },
    { 0x1C1A, "Datel Electronics Ltd."  },
    { 0x1C1B, "Volkswagen of America, Inc."  },
    { 0x1C1C, "Schmartz Inc."  },
    { 0x1C1D, "GASTEC CORPORATION"  },
    { 0x1C1E, "Focused Test, Inc."  },
    { 0x1C1F, "Goldvish S.A."  },
    { 0x1C20, "Fuji Electric Device Technology Co., Ltd."  },
    { 0x1C21, "ADDMM LLC"  },
    { 0x1C22, "ZHONGSHAN CHIANG YU ELECTRIC CO., LTD."  },
    { 0x1C23, "Enzytek Technology Inc."  },
    { 0x1C24, "DIGITAL IMAGING SYSTEMS GmbH"  },
    { 0x1C25, "Sunwell Electronics Ltd."  },
    { 0x1C26, "Shanghai Haiying Electronics Co., Ltd."  },
    { 0x1C27, "SHENZHEN DNS INDUSTRIES CO., LTD."  },
    { 0x1C28, "PMDTechnologies"  },
    { 0x1C29, "Elster Group"  },
    { 0x1C2A, "NAVIGON AG"  },
    { 0x1C2B, "SIEB & MEYER AG"  },
    { 0x1C2C, "QUANTEL LTD."  },
    { 0x1C2D, "Barloworld Scientific Limited"  },
    { 0x1C2E, "LiveWire Test Labs, Inc."  },
    { 0x1C2F, "Wessex Advanced Switching Products Ltd."  },
    { 0x1C30, "Li Creative Technologies, Inc."  },
    { 0x1C31, "LS Mtron Ltd."  },
    { 0x1C32, "INTELBANQ"  },
    { 0x1C33, "EK-TEAM GmbH"  },
    { 0x1C34, "Pro-Active"  },
    { 0x1C35, "Superna Inc."  },
    { 0x1C36, "Axiom Manufacturing"  },
    { 0x1C37, "Sonavation, Inc."  },
    { 0x1C38, "Kirin Techno-System Company, Limited"  },
    { 0x1C39, "Quantronix, Inc."  },
    { 0x1C3A, "CCV Deutschland GmbH"  },
    { 0x1C3B, "Nivis, LLC"  },
    { 0x1C3C, "INFOTURE, INC."  },
    { 0x1C3D, "NONIN MEDICAL INC."  },
    { 0x1C3E, "Wep Peripherals"  },
    { 0x1C3F, "Amfit, Inc."  },
    { 0x1C40, "EZ PROTOTYPES"  },
    { 0x1C41, "CompX Fort"  },
    { 0x1C42, "VERCET LLC"  },
    { 0x1C43, "PeCon GmbH"  },
    { 0x1C44, "Fukasawa Co."  },
    { 0x1C45, "NavCom Technology Inc."  },
    { 0x1C46, "Hitachi Zosen Corporation"  },
    { 0x1C47, "Andrew Telecommunication Product SRL"  },
    { 0x1C48, "International Truck and Engine Corporation"  },
    { 0x1C49, "Cherng Weei Technology Corp."  },
    { 0x1C4A, "Cathay Tri-Tech., Inc."  },
    { 0x1C4B, "Geratherm Respiratory GmbH"  },
    { 0x1C4C, "SYSTECH"  },
    { 0x1C4D, "Everest Display Inc."  },
    { 0x1C4E, "Koninklijke Gazelle N.V."  },
    { 0x1C4F, "Beijing Sigmachip Co., Ltd."  },
    { 0x1C50, "Chatsworth Data Corporation"  },
    { 0x1C51, "Wisecube Co., Ltd."  },
    { 0x1C52, "FLEETWOOD ELECTRONICS LTD."  },
    { 0x1C53, "Heartland Data Co."  },
    { 0x1C54, "NU-LEC INDUSTRIES"  },
    { 0x1C55, "LGS"  },
    { 0x1C56, "RED DIGITAL CINEMA"  },
    { 0x1C57, "Zalman Tech Co., Ltd."  },
    { 0x1C58, "IVA Corporation"  },
    { 0x1C59, "SIXNET, LLC"  },
    { 0x1C5A, "Fisher and Paykel Healthcare Limited"  },
    { 0x1C5B, "FUTURE WAVES PTE Ltd."  },
    { 0x1C5C, "CELLMETRIC LTD."  },
    { 0x1C5D, "KB Kommutatcionnoy apparatury LTD."  },
    { 0x1C5E, "Fueltech Ind. & Com. Prod. Elet. Ltda."  },
    { 0x1C5F, "Watec Co., Ltd."  },
    { 0x1C60, "Vision & Control GmbH"  },
    { 0x1C61, "ASI DataMyte, Inc."  },
    { 0x1C62, "LITEPOINT CORP."  },
    { 0x1C63, "DLP Design, Inc."  },
    { 0x1C64, "QSI Corporation"  },
    { 0x1C65, "PROCENTEC"  },
    { 0x1C66, "The Trane Company"  },
    { 0x1C67, "Sugar Creek Solutions LLC"  },
    { 0x1C68, "Trace Systems, Inc."  },
    { 0x1C69, "MPB Communications"  },
    { 0x1C6A, "Regula Ltd."  },
    { 0x1C6B, "Philips & Lite-ON Digital Solutions Corporation"  },
    { 0x1C6C, "Skydigital Inc."  },
    { 0x1C6D, "Bioptigen Inc."  },
    { 0x1C6E, "MINELAB ELECTRONICS PTY LTD."  },
    { 0x1C6F, "SUN-A CORPORATION"  },
    { 0x1C70, "Wessa Engineering"  },
    { 0x1C71, "HUMANWARE LTD."  },
    { 0x1C72, "EMTEC Elektronische Messtechnik GmbH"  },
    { 0x1C73, "AMT Co., Ltd."  },
    { 0x1C74, "PHOTOVOX srl"  },
    { 0x1C75, "ARTURIA"  },
    { 0x1C76, "Sun-Light Electronic Technologies Inc."  },
    { 0x1C77, "Kaetat Industrial Co., Ltd."  },
    { 0x1C78, "Mindray DS USA, Inc."  },
    { 0x1C79, "Unigen Corporation"  },
    { 0x1C7A, "Egis Technology, Inc."  },
    { 0x1C7B, "Shenzhen Luxshare Precision Industry Co., Ltd."  },
    { 0x1C7C, "DELCOP LLC"  },
    { 0x1C7D, "STARKEY LABORATORIES INC."  },
    { 0x1C7E, "Hydrometer GmbH"  },
    { 0x1C7F, "FILTRONIC DEFENCE LIMITED"  },
    { 0x1C80, "Hoffmann + Krippner GmbH"  },
    { 0x1C81, "MOTOSOFT b.v."  },
    { 0x1C82, "Atracsys LLC"  },
    { 0x1C83, "BEKA Elektronik"  },
    { 0x1C84, "DRS Tactical Systems"  },
    { 0x1C85, "Audyssey Laboratories, Inc."  },
    { 0x1C86, "Tallahassee Technologies, Inc."  },
    { 0x1C87, "2N TELEKOMUNIKACE a.s."  },
    { 0x1C88, "Somagic, Inc."  },
    { 0x1C89, "HONGKONG WEIDIDA ELECTRON LIMITED"  },
    { 0x1C8A, "SHIN HEUNG PRECISION CO., LTD."  },
    { 0x1C8B, "Bridgestone Cycle Co., Ltd."  },
    { 0x1C8C, "noax Technologies AG"  },
    { 0x1C8D, "Payter BV"  },
    { 0x1C8E, "ASTRON INTERNATIONAL CORP."  },
    { 0x1C8F, "Scolis Technologies (India) Pvt. Ltd."  },
    { 0x1C90, "Pixela (Shanghai) Co., Ltd."  },
    { 0x1C91, "Hutchinson Technology Incorporated"  },
    { 0x1C92, "JDD Enterprises"  },
    { 0x1C93, "Airspan Networks"  },
    { 0x1C94, "Maerzhaeuser Wetzlar GmbH & Co. KG."  },
    { 0x1C95, "OVATION SYSTEMS LIMITED"  },
    { 0x1C96, "Tesselon, LLC"  },
    { 0x1C97, "PEBBLE ENTERTAINMENT GmbH"  },
    { 0x1C98, "ALPINE ELECTRONICS, INC."  },
    { 0x1C99, "KETEREX, Inc."  },
    { 0x1C9A, "Simple Step LLC"  },
    { 0x1C9B, "Ohden Co., Ltd."  },
    { 0x1C9C, "Technological Solutions Laboratory"  },
    { 0x1C9D, "Descuentos y Electronicos AVA"  },
    { 0x1C9E, "Shanghai Longcheer 3G Technology Co., Ltd."  },
    { 0x1C9F, "SISS Technology Inc."  },
    { 0x1CA0, "ACCARIO Inc."  },
    { 0x1CA1, "Symwave, Inc."  },
    { 0x1CA2, "G-coder Systems AB"  },
    { 0x1CA3, "CAPAZ GmbH"  },
    { 0x1CA4, "METRICO WIRELESS INC."  },
    { 0x1CA5, "HASLER RAIL AG"  },
    { 0x1CA6, "TECHNO-AP Limited Company"  },
    { 0x1CA7, "BAE SYSTEMS AUSTRALIA LIMITED"  },
    { 0x1CA8, "ROCCAT STUDIO GmbH"  },
    { 0x1CA9, "THE TINTOMETER LTD."  },
    { 0x1CAA, "Accel Semiconductor Corp."  },
    { 0x1CAB, "SCS Engineering, Inc."  },
    { 0x1CAC, "SHENZHEN KINSTONE D&T DEVELOP CO., LTD."  },
    { 0x1CAD, "ONE-TOO"  },
    { 0x1CAE, "MPMAN"  },
    { 0x1CAF, "2WCOM GmbH"  },
    { 0x1CB0, "LEGRAND FRANCE"  },
    { 0x1CB1, "Enforce Device Inc."  },
    { 0x1CB2, "PCO AG"  },
    { 0x1CB3, "Aces Electronics Co., Ltd."  },
    { 0x1CB4, "OPEX CORPORATION"  },
    { 0x1CB5, "Boonton Electronics"  },
    { 0x1CB6, "IDEACOM TECHNOLOGY INC."  },
    { 0x1CB7, "EASTERN TIMES TECHNOLOGY CO., LTD."  },
    { 0x1CB8, "Ferguson Beauregard"  },
    { 0x1CB9, "DIVERSIFIED TECHNICAL SYSTEMS, INC."  },
    { 0x1CBA, "MERIDIAN AUDIO LTD."  },
    { 0x1CBB, "DATATEC CO., LTD."  },
    { 0x1CBC, "Zizzle, LLC"  },
    { 0x1CBD, "Wha Shin Co., Ltd."  },
    { 0x1CBE, "Texas Instruments - Stellaris"  },
    { 0x1CBF, "FORTAT SKYMARK INDUSTRIAL COMPANY"  },
    { 0x1CC0, "PlantSense"  },
    { 0x1CC1, "EXAKTIME INC."  },
    { 0x1CC2, "CC Systems AB"  },
    { 0x1CC3, "Biocomfort Diagnostics GmbH & Co. KG"  },
    { 0x1CC4, "Byte Paradigm sprl"  },
    { 0x1CC5, "Rane Corporation"  },
    { 0x1CC6, "Digital Force Technologies"  },
    { 0x1CC7, "GELOGIC"  },
    { 0x1CC8, "Iofy Corporation"  },
    { 0x1CC9, "COMAP, spol. s r. o."  },
    { 0x1CCA, "NextWave Broadband Inc."  },
    { 0x1CCB, "Lattebox Co., Ltd."  },
    { 0x1CCC, "DA-DESIGN OY"  },
    { 0x1CCD, "Bodatong Technology (Shenzhen) Co., Ltd."  },
    { 0x1CCE, "DATA MODUL"  },
    { 0x1CCF, "Konami Digital Entertainment Co., Ltd."  },
    { 0x1CD0, "VEGATECH CO., LTD."  },
    { 0x1CD1, "ARTAFLEX"  },
    { 0x1CD2, "Christ Elektronik GmbH"  },
    { 0x1CD3, "ATSUMI ELECTRIC CO., LTD."  },
    { 0x1CD4, "adp corporation"  },
    { 0x1CD5, "Firecomms Ltd."  },
    { 0x1CD6, "Antonio Precise Products Manufactory Ltd."  },
    { 0x1CD7, "GMC-I Gossen-Metrawatt GmbH"  },
    { 0x1CD8, "Dash Navigation, Inc."  },
    { 0x1CD9, "TL Industries"  },
    { 0x1CDA, "NAVICO"  },
    { 0x1CDB, "Cat Technologies Ltd."  },
    { 0x1CDC, "Advanced Medical Electronics Corp."  },
    { 0x1CDD, "YOOSAMFLUTE CO., LTD."  },
    { 0x1CDE, "Telecommunications Technology Association (TTA)"  },
    { 0x1CDF, "WonTen Technology Co., Ltd."  },
    { 0x1CE0, "EDIMAX TECHNOLOGY CO., LTD."  },
    { 0x1CE1, "Amphenol KAE"  },
    { 0x1CE2, "Extron Electronics"  },
    { 0x1CE3, "Australian Simulation Control Systems Pty., Ltd."  },
    { 0x1CE4, "High Leah Electronics, Inc."  },
    { 0x1CE5, "SimPhonics, Inc."  },
    { 0x1CE6, "SOPRO"  },
    { 0x1CE7, "FASY SPA"  },
    { 0x1CE8, "Alcorn McBride, Inc."  },
    { 0x1CE9, "Cadmus Payment Solutions Ltd."  },
    { 0x1CEA, "MESTEK, INC."  },
    { 0x1CEB, "SMARTWI"  },
    { 0x1CEC, "Siemens AG I & S Postal Automation"  },
    { 0x1CED, "DEWESOFT d.o.o."  },
    { 0x1CEE, "Production Technology Center Kyushuu"  },
    { 0x1CEF, "Siemens LD-A"  },
    { 0x1CF0, "SA VALIDY"  },
    { 0x1CF1, "dresden elektronik ingenieurtechnik gmbh"  },
    { 0x1CF2, "TrellisWare Technologies, Inc."  },
    { 0x1CF3, "Lion Power Co., Ltd."  },
    { 0x1CF4, "SK INTERFACES LTD."  },
    { 0x1CF5, "Swirlnet A/S"  },
    { 0x1CF6, "Atlantic Zeiser GmbH"  },
    { 0x1CF7, "Electric-Spin"  },
    { 0x1CF8, "Biometric Associates"  },
    { 0x1CF9, "Aipermon GmbH & Co. KG"  },
    { 0x1CFA, "Daco Scientific Limited"  },
    { 0x1CFB, "Livescribe Inc."  },
    { 0x1CFC, "ANDES TECHNOLOGY CORPORATION"  },
    { 0x1CFD, "Flextronics Digital Design Japan, LTD."  },
    { 0x1CFE, "Cryptsoft Pty. Ltd."  },
    { 0x1CFF, "Tad Radio of Canada Inc."  },
    { 0x1D00, "MicroStone Corporation"  },
    { 0x1D01, "SNIF Labs"  },
    { 0x1D02, "DevGuru"  },
    { 0x1D03, "ICON INTERNATIONAL DIGITAL LIMITED"  },
    { 0x1D04, "Itronics"  },
    { 0x1D05, "DESTURA S.R.L."  },
    { 0x1D06, "BBK ELECTRONICS CORPORATION LIMITED"  },
    { 0x1D07, "Solid-Motion"  },
    { 0x1D08, "NINGBO HENTEK DRAGON ELECTRONICS CO., LTD."  },
    { 0x1D09, "TechFaith Wireless Technology Limited"  },
    { 0x1D0A, "Visteon Corporation"  },
    { 0x1D0B, "HAN HUA CABLE & WIRE TECHNOLOGY (J.X.) CO., LTD."  },
    { 0x1D0C, "LAKS GmbH"  },
    { 0x1D0D, "TDK Marketing Europe GmbH"  },
    { 0x1D0E, "deister electronic GmbH"  },
    { 0x1D0F, "NEO ELECTRONICS (HK) CO., LIMITED"  },
    { 0x1D10, "Jiangsu Shinco Digital Technology Co., Ltd."  },
    { 0x1D11, "Xtend Technologies Pvt. Ltd."  },
    { 0x1D12, "UAB TELTONIKA"  },
    { 0x1D13, "L3 Communications - Telemetry West"  },
    { 0x1D14, "ALPHA-SAT TECHNOLOGY LIMITED"  },
    { 0x1D15, "FUJIFILM RECORDING MEDIA GmbH"  },
    { 0x1D16, "KABA MAS CORPORATION"  },
    { 0x1D17, "C-THRU MUSIC Ltd."  },
    { 0x1D18, "APICAL INSTRUMENTS, INC."  },
    { 0x1D19, "Dexatek Technology Ltd."  },
    { 0x1D1A, "Boeckeler Instruments, Inc."  },
    { 0x1D1B, "HumanBeams Inc."  },
    { 0x1D1C, "Novatron Oy"  },
    { 0x1D1D, "SYNESTHESIA CORPORATION"  },
    { 0x1D1E, "OFFCODE"  },
    { 0x1D1F, "Diostech Co., Ltd."  },
    { 0x1D20, "SAMTACK INC."  },
    { 0x1D21, "COMPUSULT LIMITED"  },
    { 0x1D22, "ELCOM s.r.o."  },
    { 0x1D23, "Netsushin Co., Ltd."  },
    { 0x1D24, "PHOTON KINETICS"  },
    { 0x1D25, "Trinity Security Systems, Inc."  },
    { 0x1D26, "ADVANCED ELECTRONICS LTD."  },
    { 0x1D27, "Prime Sense Ltd."  },
    { 0x1D28, "JORDAN VALLEY SEMICONDUCTORS LTD."  },
    { 0x1D29, "Horng Tong Enterprise Co., Ltd."  },
    { 0x1D2A, "LyconSys GmbH & Co. KG"  },
    { 0x1D2B, "BEN-RI ELECTRONICA S.A."  },
    { 0x1D2C, "equinux AG"  },
    { 0x1D2D, "Fraunhofer IBMT"  },
    { 0x1D2E, "I.S.V. Co., Ltd."  },
    { 0x1D2F, "JACO, INC."  },
    { 0x1D30, "Sinosun Technology Ltd."  },
    { 0x1D31, "XINTRONIX LIMITED"  },
    { 0x1D32, "ELECTRONICA MECHATRONIC SYSTEMS (I) PVT. LTD."  },
    { 0x1D33, "Lockheed Martin - Maritime Systems & Sensors"  },
    { 0x1D34, "DREAM LINK LTD."  },
    { 0x1D35, "ISS Manufacturing Limited"  },
    { 0x1D36, "Volucris, Inc."  },
    { 0x1D37, "Phoenix Microelectronics (China) Co., Ltd."  },
    { 0x1D38, "Ergowerx Int'l LLC/Smartfish Technologies"  },
    { 0x1D39, "XECURENEXUS Co., LTD."  },
    { 0x1D3A, "P. R. Glassel & Associates, Inc."  },
    { 0x1D3B, "J & C Technology Co., Ltd."  },
    { 0x1D3C, "Tomei Tsushin Kogyo Co., Ltd."  },
    { 0x1D3D, "R&D Center of Biometric Technology-BMSTU"  },
    { 0x1D3E, "EMCON Emanation Control Limited"  },
    { 0x1D3F, "Photon Control Inc."  },
    { 0x1D40, "EDANIS Elektronik AG"  },
    { 0x1D41, "Teletronic Rossendorf GmbH"  },
    { 0x1D42, "DRAGON JOY LIMITED"  },
    { 0x1D43, "Montage Technology, Inc."  },
    { 0x1D44, "Adirondack Digital Imaging Systems, Inc."  },
    { 0x1D45, "Qisda Corporation"  },
    { 0x1D46, "nSys Design Systems"  },
    { 0x1D47, "ATAUCE"  },
    { 0x1D48, "Shenzhen XinYonghui Precise Technology Co., Ltd."  },
    { 0x1D49, "SHENZHEN LINKCONN ELECTRONICS CO., LTD."  },
    { 0x1D4A, "HKS Co., Ltd."  },
    { 0x1D4B, "DARIM VISION CO."  },
    { 0x1D4C, "ARK-DESIGN Co., Ltd."  },
    { 0x1D4D, "Pegatron Corporation"  },
    { 0x1D4E, "INPHI CORPORATION"  },
    { 0x1D4F, "ADVANCED CHIP EXPRESS INC."  },
    { 0x1D50, "OPENMOKO, Inc."  },
    { 0x1D51, "Sengital Limited"  },
    { 0x1D52, "ELECTROBYTE di GARAVAGLIA MATTIA"  },
    { 0x1D53, "Innofidei Inc."  },
    { 0x1D54, "ZARAM TECHNOLOGY, Inc."  },
    { 0x1D55, "XRONet Corporation"  },
    { 0x1D56, "Verico International Co., Ltd."  },
    { 0x1D57, "Feeling Technology Corp."  },
    { 0x1D58, "SUZUKI Engineering"  },
    { 0x1D59, "3DSP"  },
    { 0x1D5A, "Hillcrest Laboratories, Inc."  },
    { 0x1D5B, "Smartronix, Inc."  },
    { 0x1D5C, "Fresco Logic Inc."  },
    { 0x1D5D, "QIXING INDUSTRIAL (HK) CO."  },
    { 0x1D5E, "Tonium AB"  },
    { 0x1D5F, "ViVOtech, Inc."  },
    { 0x1D60, "ASAP International Co., Ltd."  },
    { 0x1D61, "ACCEMIC GmbH & CO. KG"  },
    { 0x1D62, "KYORITSU ELECTRIC CO., LTD."  },
    { 0x1D63, "Nippon Seiki Co., Ltd."  },
    { 0x1D64, "MobilMAX Technology Inc."  },
    { 0x1D65, "Moteurs LEROY SOMER"  },
    { 0x1D66, "StreamBuster"  },
    { 0x1D67, "DYNAMIC INNOVATIONS LIMITED"  },
    { 0x1D68, "SEMA ELECTRONICS (H.K.) CO., Ltd."  },
    { 0x1D69, "Walta Electronic Co., Ltd."  },
    { 0x1D6A, "ARICENT TECHNOLOGIES (HOLDINGS) LTD."  },
    { 0x1D6B, "The Linux Foundation"  },
    { 0x1D6C, "Man & Machine, Inc."  },
    { 0x1D6D, "VARISYS LIMITED"  },
    { 0x1D6E, "EUROTECH"  },
    { 0x1D6F, "Seluxit"  },
    { 0x1D70, "MULTIPLE ACCESS COMMUNICATIONS LTD."  },
    { 0x1D71, "Finisar Corporation"  },
    { 0x1D72, "Mobiltex Data Ltd."  },
    { 0x1D73, "Signal Processing Devices Sweden AB"  },
    { 0x1D74, "LG Innotek Co., Ltd."  },
    { 0x1D75, "DICOM, spol. s r.o."  },
    { 0x1D76, "LongCheng Electronic & Communication CO., LTD."  },
    { 0x1D77, "Yueqing Changling Electronic Instrument Corp., Ltd."  },
    { 0x1D78, "CAMBRIDGE SEMICONDUCTOR LTD."  },
    { 0x1D79, "Shenzhen Innosystem Technology Ltd."  },
    { 0x1D7A, "SHINWA INTERNATIONAL HOLDINGS LTD."  },
    { 0x1D7B, "Single Strand Co., Ltd."  },
    { 0x1D7C, "KarmelSonix"  },
    { 0x1D7D, "Seoul Commtech Co., Ltd."  },
    { 0x1D7E, "WAVESAT"  },
    { 0x1D7F, "MoBeam, Inc."  },
    { 0x1D80, "PLDA"  },
    { 0x1D81, "YongXin Plastic & Hardware Co., Ltd."  },
    { 0x1D82, "HERTZ SYSTEMTECHNIK GmbH"  },
    { 0x1D83, "Mantech International"  },
    { 0x1D84, "Kechenda Plastic Electronic Factory"  },
    { 0x1D85, "NINGBO SHUNSHENG COMMUNICATION APPARATUS CO., LTD."  },
    { 0x1D86, "C.D.N. CORPORATION"  },
    { 0x1D87, "RHK TECHNOLOGY, INC."  },
    { 0x1D88, "Mahr GmbH"  },
    { 0x1D89, "Hunter Associates"  },
    { 0x1D8A, "OSASI Technos Inc. (Tokyo Headquarters)"  },
    { 0x1D8B, "MEDTRONIC"  },
    { 0x1D8C, "Wuxi AlphaScale IC Systems, Inc."  },
    { 0x1D8D, "EXEO SYSTEMS"  },
    { 0x1D8E, "Capistrano Labs, Inc."  },
    { 0x1D8F, "Viprinet GmbH"  },
    { 0x1D90, "CITIZEN SYSTEMS JAPAN CO., LTD."  },
    { 0x1D91, "BYD COMPANY LIMITED"  },
    { 0x1D92, "SPECTRONIC DEVICES LTD."  },
    { 0x1D93, "Tokyo System Development Co., Ltd."  },
    { 0x1D94, "ENCIRIS TECHNOLOGIES"  },
    { 0x1D95, "SYSTRONIK Elektronik und Systemtechnik GmbH"  },
    { 0x1D96, "CHIRSON LTD."  },
    { 0x1D97, "Telonics"  },
    { 0x1D98, "OUTLINE ELECTRONICS LTD."  },
    { 0x1D99, "Shanghai HSIC Application System Co., Ltd."  },
    { 0x1D9A, "Vubiq, Inc."  },
    { 0x1D9B, "Techno Source"  },
    { 0x1D9C, "SONIM TECHNOLOGIES, INC."  },
    { 0x1D9D, "Sigma Elektro GmbH"  },
    { 0x1D9E, "CSR, Inc."  },
    { 0x1D9F, "KUNMING ELECTRONICS CO., LTD."  },
    { 0x1DA0, "Parade Technologies, Inc."  },
    { 0x1DA1, "COVIDENCE A/S"  },
    { 0x1DA2, "LAMBDA, INC."  },
    { 0x1DA3, "bebro electronic GmbH"  },
    { 0x1DA4, "BTICINO"  },
    { 0x1DA5, "CATHEXIS INNOVATIONS INC."  },
    { 0x1DA6, "Inepro BV"  },
    { 0x1DA7, "ENDRA Inc."  },
    { 0x1DA8, "VIOLET"  },
    { 0x1DA9, "In-Circuit GmbH"  },
    { 0x1DAA, "Alcatel-Lucent"  },
    { 0x1DAB, "MAGELLAN GPS"  },
    { 0x1DAC, "MOBOTIX AG"  },
    { 0x1DAD, "DATNET KFT"  },
    { 0x1DAE, "ellipsis INC."  },
    { 0x1DAF, "Breas Medical AB"  },
    { 0x1DB0, "GreenPeak Technologies NV"  },
    { 0x1DB1, "Reliable Controls Corporation"  },
    { 0x1DB2, "Duali Inc."  },
    { 0x1DB3, "Arcelik A.S."  },
    { 0x1DB4, "Montalvo Systems"  },
    { 0x1DB5, "BRYSTON LTD."  },
    { 0x1DB6, "eDimensional, Inc."  },
    { 0x1DB7, "SMedia Technology Corporation"  },
    { 0x1DB8, "HD MEDICAL INC."  },
    { 0x1DB9, "LITEN UP TECHNOLOGIES INC."  },
    { 0x1DBA, "BancTec, Inc."  },
    { 0x1DBB, "Condalo GmbH"  },
    { 0x1DBC, "Shenzhen HOJY Technology Co., Ltd."  },
    { 0x1DBD, "Terawins"  },
    { 0x1DBE, "S.R.N. Corporation"  },
    { 0x1DBF, "Signostics Pty. Ltd."  },
    { 0x1DC0, "DATAFIELD INDIA PVT.LTD."  },
    { 0x1DC1, "Laser Drive"  },
    { 0x1DC2, "Datalogic Mobile Inc."  },
    { 0x1DC3, "PoLabs"  },
    { 0x1DC4, "TRANSICS"  },
    { 0x1DC5, "Pixim Inc."  },
    { 0x1DC6, "Miyama, Inc."  },
    { 0x1DC7, "Leroy Automatique Industrielle"  },
    { 0x1DC8, "GC Corporation"  },
    { 0x1DC9, "Hitachi Koki Co., Ltd."  },
    { 0x1DCA, "The IVOXX Corp."  },
    { 0x1DCB, "IFTEST AG"  },
    { 0x1DCC, "Document Capture Technologies, Inc."  },
    { 0x1DCD, "HIN KUI MACHINE & METAL INDUSTRIAL CO., LTD."  },
    { 0x1DCE, "SIMTEC Elektronik GmbH"  },
    { 0x1DCF, "INVIX Co., Ltd."  },
    { 0x1DD0, "ABB AS, Division Automation Products"  },
    { 0x1DD1, "EFJohnson"  },
    { 0x1DD2, "LEO BODNAR"  },
    { 0x1DD3, "Dajac, Inc."  },
    { 0x1DD4, "ARMELIN WIDGET CORPORATION"  },
    { 0x1DD5, "MetaGeek, LLC"  },
    { 0x1DD6, "Solomon Technology Corp."  },
    { 0x1DD7, "REDMERE TECHNOLOGY"  },
    { 0x1DD8, "BUFFALO KOKUYO SUPPLY INC."  },
    { 0x1DD9, "EFFICERE TECHNOLOGIES"  },
    { 0x1DDA, "TA Instruments"  },
    { 0x1DDB, "Abon Touchsystems Inc."  },
    { 0x1DDC, "id Quantique"  },
    { 0x1DDD, "DOKING ELECTRONIC TECHNOLOGY CO., LTD."  },
    { 0x1DDE, "TridonicAtco"  },
    { 0x1DDF, "L&T Technology Services"  },
    { 0x1DE0, "Shenzhen Excelstor Technology Ltd."  },
    { 0x1DE1, "Actions Microelectronics Co., Ltd."  },
    { 0x1DE2, "ENTERY INDUSTRIAL CO., LTD."  },
    { 0x1DE3, "SHENZHEN REX ELECTRONICS CO., LTD."  },
    { 0x1DE4, "DAEWOO ELECTRONICS CORPORATION"  },
    { 0x1DE5, "AMONTEC"  },
    { 0x1DE6, "MICRORISC S.R.O."  },
    { 0x1DE7, "MIDAS TECHNOLOGY"  },
    { 0x1DE8, "Applied Systems Engineering, Inc."  },
    { 0x1DE9, "Seco Technology Co., Ltd."  },
    { 0x1DEA, "Yesin Electronics Technology Co., Ltd."  },
    { 0x1DEB, "SHIUH CHI PRECISION INDUSTRY CO., LTD."  },
    { 0x1DEC, "HAGER CONTROLS SAS"  },
    { 0x1DED, "COOLIT SYSTEMS, INC."  },
    { 0x1DEE, "JCM II, Inc."  },
    { 0x1DEF, "KYOTO KAGAKU CO., LTD."  },
    { 0x1DF0, "TRICKLESTAR LIMITED"  },
    { 0x1DF1, "HUATIANYUAN ELECTRONIC INDUSTRY CO., LTD."  },
    { 0x1DF2, "China Telecommunication Technology Labs - Terminals"  },
    { 0x1DF3, "CRESYN CO., LTD."  },
    { 0x1DF4, "SHEN ZHEN FORMAN PRECISION INDUSTRY CO., LTD."  },
    { 0x1DF5, "Universal Remote Control, Inc."  },
    { 0x1DF6, "TakeMS International AG"  },
    { 0x1DF7, "Mirics Semiconductor Ltd."  },
    { 0x1DF8, "The Charles Machine Works, Inc."  },
    { 0x1DF9, "Komax AG"  },
    { 0x1DFA, "BLOCKMASTER AB"  },
    { 0x1DFB, "marco Systemanalyse und Entwicklung GmbH"  },
    { 0x1DFC, "YUNNAN NANTIAN ELECTRONICS INFORMATION CO., LTD."  },
    { 0x1DFD, "Quality Thermistor, Inc."  },
    { 0x1DFE, "BEDA Precision"  },
    { 0x1DFF, "InfraRed Integrated Systems Ltd."  },
    { 0x1E00, "Jupiter Systems"  },
    { 0x1E01, "Dynalloy, Inc."  },
    { 0x1E02, "GLOBEMASTER TECHNOLOGIES CO., LTD."  },
    { 0x1E03, "OXFORD INSTRUMENTS ANALYTICAL OY"  },
    { 0x1E04, "Coolsand Technologies (Hong Kong) Ltd."  },
    { 0x1E05, "Microtronic AG"  },
    { 0x1E06, "Moore Industries International"  },
    { 0x1E07, "GETA ELECTRONICS (DONG GUAN) CO., LTD."  },
    { 0x1E08, "Inventure, Inc."  },
    { 0x1E09, "Baldwin Boxall Communication Ltd."  },
    { 0x1E0A, "NOX Medical"  },
    { 0x1E0B, "TUBITAK UEKAE"  },
    { 0x1E0C, "NATIONAL HYBRID, INC."  },
    { 0x1E0D, "NEOWAVE"  },
    { 0x1E0E, "SHANGHAI BASECOM LTD."  },
    { 0x1E0F, "mSilica Inc."  },
    { 0x1E10, "FLIR Integrated Imaging Solutions"  },
    { 0x1E11, "Hoya Xponent"  },
    { 0x1E12, "OCTRIAN"  },
    { 0x1E13, "Burgundy Electric, LLC"  },
    { 0x1E14, "YANtide Corporation"  },
    { 0x1E15, "mStation"  },
    { 0x1E16, "SMARTIO"  },
    { 0x1E17, "Mirion Technologies Inc."  },
    { 0x1E18, "MIGHT Co., Ltd."  },
    { 0x1E19, "Torus Networks Co., Ltd."  },
    { 0x1E1A, "HITEC RCD KOREA"  },
    { 0x1E1B, "e-Practical Solutions"  },
    { 0x1E1C, "CMS PRODUCTS"  },
    { 0x1E1D, "Kanguru Solutions"  },
    { 0x1E1E, "Trans New Technology, Inc."  },
    { 0x1E1F, "INVIA"  },
    { 0x1E20, "JDSU"  },
    { 0x1E21, "NEONUMERIC"  },
    { 0x1E22, "LEDCO"  },
    { 0x1E23, "Aeronix, Inc."  },
    { 0x1E24, "Cine-tal Systems, Inc."  },
    { 0x1E25, "3M Cogent, Inc."  },
    { 0x1E26, "Multi Channel Systems MCS GmbH"  },
    { 0x1E27, "NASA / Johnson Space Center / EV2"  },
    { 0x1E28, "Raptor Innovations International"  },
    { 0x1E29, "Festo AG & Co. KG"  },
    { 0x1E2A, "NANOFORTI INC."  },
    { 0x1E2B, "3M CMD (Communication Markets Division)"  },
    { 0x1E2C, "KRONIK ELEKTRONIK SANAYI VETICARET LIMITED SIRKETI"  },
    { 0x1E2D, "Cinterion Wireless Modules GmbH"  },
    { 0x1E2E, "Syrinx Industrial Electronics b.v."  },
    { 0x1E2F, "Celrun Co., Ltd."  },
    { 0x1E30, "Kohler Co."  },
    { 0x1E31, "Greatbatch"  },
    { 0x1E32, "Opti-Sciences, Inc."  },
    { 0x1E33, "KOBIAN CANADA INC."  },
    { 0x1E34, "Sensory, Inc."  },
    { 0x1E35, "BELLING Co., Ltd."  },
    { 0x1E36, "Insulet Corporation"  },
    { 0x1E37, "Rehoboth Tech. Co., Ltd."  },
    { 0x1E38, "QRS Music Technologies Inc."  },
    { 0x1E39, "YIS Corporation"  },
    { 0x1E3A, "Continental Automotive Systems Inc."  },
    { 0x1E3B, "MICROBIT 2.0 AB"  },
    { 0x1E3C, "Vapor Bus Int'l Div of Westinghouse Air Brake Tech Corp"  },
    { 0x1E3D, "Chipsbrand Technologies (HK) Co., Limited"  },
    { 0x1E3E, "EMS Aviation"  },
    { 0x1E3F, "JJ Keller & Associates Inc."  },
    { 0x1E40, "SciLog, Inc."  },
    { 0x1E41, "Cleverscope Ltd."  },
    { 0x1E42, "SSE GmbH"  },
    { 0x1E43, "Sagem Mobiles"  },
    { 0x1E44, "SHIMANO INC."  },
    { 0x1E45, "TADANO LTD."  },
    { 0x1E46, "Danfoss A/S"  },
    { 0x1E47, "HUNG TA H.T.ENTERPRISE CO., LTD."  },
    { 0x1E48, "LABAU Technology"  },
    { 0x1E49, "FES LLC"  },
    { 0x1E4A, "CHIRON TECHNOLOGY LTD."  },
    { 0x1E4B, "exxact GmbH"  },
    { 0x1E4C, "Stereotaxis, Inc."  },
    { 0x1E4D, "BST International GmbH"  },
    { 0x1E4E, "Etron Technology, Inc."  },
    { 0x1E4F, "SECOM Co., Ltd."  },
    { 0x1E50, "VILTECHMEDA UAB"  },
    { 0x1E51, "DiMoto"  },
    { 0x1E52, "SZ TELSTAR CO., LTD."  },
    { 0x1E53, "WYPLAY"  },
    { 0x1E54, "TypeMatrix Inc."  },
    { 0x1E55, "Memorysolution GmbH"  },
    { 0x1E56, "EURINTEL"  },
    { 0x1E57, "Bundesdruckerei GmbH"  },
    { 0x1E58, "Horner APG"  },
    { 0x1E59, "inTera Tecnologia"  },
    { 0x1E5A, "VOXTRONIC TECHNOLOGY"  },
    { 0x1E5B, "APRICO A/S"  },
    { 0x1E5C, "Enova Technology Corp."  },
    { 0x1E5D, "SAT Corporation"  },
    { 0x1E5E, "Touch International"  },
    { 0x1E5F, "Relpol SA"  },
    { 0x1E60, "SEA Signalisation"  },
    { 0x1E61, "Anoto AB"  },
    { 0x1E62, "Uriver Inc."  },
    { 0x1E63, "DRAEGER MEDICAL"  },
    { 0x1E64, "IMSTORAGE CO., LTD."  },
    { 0x1E65, "THE BOEING CO."  },
    { 0x1E66, "KAPSYS"  },
    { 0x1E67, "Orban/CRL Systems, Inc."  },
    { 0x1E68, "TrekStor GmbH & Co. KG"  },
    { 0x1E69, "Hormann Funkwerk Kolleda GmbH"  },
    { 0x1E6A, "RGB Spectrum"  },
    { 0x1E6B, "iRex Technologies B.V."  },
    { 0x1E6C, "Sureshotgps Pty. Ltd."  },
    { 0x1E6D, "WAN SHIH ELECTRONIC (H.K.) CO., LTD."  },
    { 0x1E6E, "F&D Feinwerk-Und Drucktechnik GmbH"  },
    { 0x1E6F, "Images Scientific Instruments Inc."  },
    { 0x1E70, "POSBRO Inc."  },
    { 0x1E71, "NZXT Corporation"  },
    { 0x1E72, "Federal Signal Corporation"  },
    { 0x1E73, "COMLINK ELECTRONICS CO., LTD."  },
    { 0x1E74, "COBY COMMUNICATIONS, LIMITED"  },
    { 0x1E75, "TLS Communication GmbH"  },
    { 0x1E76, "Proview Technology (Shenzhen) Co., Ltd."  },
    { 0x1E77, "Core Micro Technology Inc."  },
    { 0x1E78, "Flextronics R & D (Shenzhen) Co., Ltd."  },
    { 0x1E79, "ISA Co., Ltd."  },
    { 0x1E7A, "The Tsurumi-Seiki Company, Limited"  },
    { 0x1E7B, "Zurich Instruments AG"  },
    { 0x1E7C, "biostep GmbH"  },
    { 0x1E7D, "ROCCAT GmbH"  },
    { 0x1E7E, "Bright Star Engineering Inc."  },
    { 0x1E7F, "NEXS ELECTRONIC CORP."  },
    { 0x1E80, "InterDigital Communications LLC"  },
    { 0x1E81, "KIDS PREFERRED, LLC."  },
    { 0x1E82, "Nortech Systems"  },
    { 0x1E83, "AMICUS WIRELESS"  },
    { 0x1E84, "VIVAX CORPORATION"  },
    { 0x1E85, "Gigaset Communications GmbH"  },
    { 0x1E86, "Japan Meditech Co., Ltd."  },
    { 0x1E87, "W&W Communications Inc."  },
    { 0x1E88, "GBS Laboratories, LLC"  },
    { 0x1E89, "Vtion Information Technology (Fujian) Co., Ltd."  },
    { 0x1E8A, "HIBEST Electronic (DongGuan) Co., Ltd."  },
    { 0x1E8B, "ImTech, Inc."  },
    { 0x1E8C, "Data Conversion Systems Ltd."  },
    { 0x1E8D, "HIGHVOLT Prueftechnik Dresden GmbH"  },
    { 0x1E8E, "EADS Secure Networks"  },
    { 0x1E8F, "PublicSolution GmbH"  },
    { 0x1E90, "Mego Afek"  },
    { 0x1E91, "Other World Computing"  },
    { 0x1E92, "Beyond Question Learning Technologies, Inc."  },
    { 0x1E93, "GSI Group"  },
    { 0x1E94, "RealD"  },
    { 0x1E95, "DIRECTV, Inc."  },
    { 0x1E96, "BlueAnt Wireless"  },
    { 0x1E97, "TOMMYCA HONG KONG LIMITED"  },
    { 0x1E98, "COMPASS SYSTEMS CORP."  },
    { 0x1E99, "General Dynamics C4 Systems"  },
    { 0x1E9A, "MANTHAN SEMICONDUCTOR PVT. LTD."  },
    { 0x1E9B, "Netcom Sicherheitstechnik GmbH"  },
    { 0x1E9C, "FirstPaper, LLC"  },
    { 0x1E9D, "GEOTEST AG"  },
    { 0x1E9E, "InnoSys Inc."  },
    { 0x1E9F, "Chase Peabody and Associates, Inc."  },
    { 0x1EA0, "DiabloSport, Inc."  },
    { 0x1EA1, "NANOBASE"  },
    { 0x1EA2, "N.V. Nederlandsche Apparatenfabriek Nedap"  },
    { 0x1EA3, "Concraft Holding Co., Ltd."  },
    { 0x1EA4, "MOBILE SYSTEM TECHNOLOGIES INC."  },
    { 0x1EA5, "CEN LINK CO., LTD."  },
    { 0x1EA6, "novero GmbH"  },
    { 0x1EA7, "SEMITEK INTERNATIONAL (HK) HOLDING LTD."  },
    { 0x1EA8, "Shenzhen Excelsecu Data Technology Co., Ltd."  },
    { 0x1EA9, "ANDERS ELECTRONICS PLC"  },
    { 0x1EAA, "Zeebo, Inc."  },
    { 0x1EAB, "Fujian Newland Auto-ID Tech. Co., Ltd."  },
    { 0x1EAC, "Thinkware Systems"  },
    { 0x1EAD, "Industrial Control Communications, Inc."  },
    { 0x1EAE, "YESCNC CO., LTD."  },
    { 0x1EAF, "Continental Trading GmbH"  },
    { 0x1EB0, "Centers for Disease Control & Prevention (CDC)"  },
    { 0x1EB1, "Kramer Electronics Ltd."  },
    { 0x1EB2, "IWAKI CO., LTD."  },
    { 0x1EB3, "SAE MAGNETICS (HK) LTD."  },
    { 0x1EB4, "YuhDing Precision Industry (KunShan) Co., Ltd."  },
    { 0x1EB5, "Diablo Technologies Inc."  },
    { 0x1EB6, "PHYLINKS LIMITED"  },
    { 0x1EB7, "WIN WIN PRECISION INDUSTRIAL CO., LTD."  },
    { 0x1EB8, "MODACOM CO., LTD."  },
    { 0x1EB9, "Campbell Scientific Inc."  },
    { 0x1EBA, "HITTITE MICROWAVE CORP."  },
    { 0x1EBB, "NuCORE Technology, Inc."  },
    { 0x1EBC, "Beijing Novel-Super Media Investment Co., Ltd."  },
    { 0x1EBD, "Wireless Matrix Corp."  },
    { 0x1EBE, "Qwizdom, Inc."  },
    { 0x1EBF, "Yulong Computer Telecommunication Scientific"  },
    { 0x1EC0, "VIGORHOOD PHOTOELECTRIC SHENZHEN CO., LTD."  },
    { 0x1EC1, "PROTEK DEVICES"  },
    { 0x1EC2, "CHUO ELECTRONICS CO., LTD."  },
    { 0x1EC3, "ANDREAS STIHL AG & Co. KG"  },
    { 0x1EC4, "ELTRONIC SOLUTION A/S"  },
    { 0x1EC5, "SIDSA"  },
    { 0x1EC6, "PHYWORKS LTD."  },
    { 0x1EC7, "Gefen Inc."  },
    { 0x1EC8, "TelePath Technologies Co., Ltd."  },
    { 0x1EC9, "MOSER BAER INDIA LIMITED"  },
    { 0x1ECA, "Mintpass Co., Ltd."  },
    { 0x1ECB, "Advanced Mobile Telecom Co., Ltd."  },
    { 0x1ECC, "Enfora, Inc."  },
    { 0x1ECD, "Alverix Inc."  },
    { 0x1ECE, "MyungMin Systems, Inc."  },
    { 0x1ECF, "MDR Grup S.R.L."  },
    { 0x1ED0, "Hirschmann Car Communication GmbH"  },
    { 0x1ED1, "DIGITAL CHINA NETWORKS (BEIJING) LIMITED"  },
    { 0x1ED2, "Crevis Co., Ltd."  },
    { 0x1ED3, "Forsis GmbH"  },
    { 0x1ED4, "Transwitch (Israel) Ltd."  },
    { 0x1ED5, "LLC GlobalTest"  },
    { 0x1ED6, "adidas International"  },
    { 0x1ED7, "Headplay, Inc."  },
    { 0x1ED8, "Fender Musical Instruments Corp."  },
    { 0x1ED9, "ALBUMteam, Ltd."  },
    { 0x1EDA, "AIRTIES WIRELESS NETWORKS"  },
    { 0x1EDB, "BLACKMAGIC DESIGN PTY."  },
    { 0x1EDC, "B-DeltaCom"  },
    { 0x1EDD, "IRIDIUM SATELLITE LLC"  },
    { 0x1EDE, "steute Schaltgerate GmbH & Co. KG"  },
    { 0x1EDF, "Selectwireless Co., Ltd."  },
    { 0x1EE0, "KYUDEN TECHNOSYSTEMS CORPORATION"  },
    { 0x1EE1, "Matrix Key Inc."  },
    { 0x1EE2, "NOVA GAMING"  },
    { 0x1EE3, "3D INNOVATIONS, LLC"  },
    { 0x1EE4, "Luff Technology Co., Ltd."  },
    { 0x1EE5, "Spring Soft K.K."  },
    { 0x1EE6, "SHENZHEN EVERWIN PRECISION TECHNOLOGY CO., LTD."  },
    { 0x1EE7, "EPCOS"  },
    { 0x1EE8, "ONDA COMMUNICATION S.p.a."  },
    { 0x1EE9, "PC PARTNER LIMITED"  },
    { 0x1EEA, "Yullin Technologies Co., Ltd."  },
    { 0x1EEB, "GEOTATE"  },
    { 0x1EEC, "CTC Analytics AG"  },
    { 0x1EED, "Helo Oy / Helo Ltd."  },
    { 0x1EEE, "RigiSystems AG"  },
    { 0x1EEF, "I.C.Y. B.V."  },
    { 0x1EF0, "Thunder Tiger Corp."  },
    { 0x1EF1, "PQ Computing Ltd."  },
    { 0x1EF2, "Vircion Inc."  },
    { 0x1EF3, "JIANGXI SHIP ELECTRONICS CO., LTD."  },
    { 0x1EF4, "TATA ELXSI LTD."  },
    { 0x1EF5, "Impinj, Inc."  },
    { 0x1EF6, "EADS Deutschland GmbH"  },
    { 0x1EF7, "ZiiLABS Ltd."  },
    { 0x1EF8, "CRITICAL LINK, LLC"  },
    { 0x1EF9, "US Army Electronic Proving Ground"  },
    { 0x1EFA, "SEIKO Precision Inc."  },
    { 0x1EFB, "IMI Hydronic Engineering International SA"  },
    { 0x1EFC, "IMOGEN STUDIO"  },
    { 0x1EFD, "ROFIN-SINAR LASER GMBH"  },
    { 0x1EFE, "Sound Design Technologies"  },
    { 0x1EFF, "Kinemetrics, Inc."  },
    { 0x1F00, "YUEQING ZHONGLI COMPUTER ELECTRONICS CO., LTD."  },
    { 0x1F01, "Geo Studio Technology"  },
    { 0x1F02, "Australian National University"  },
    { 0x1F03, "PTW Freiburg GmbH"  },
    { 0x1F04, "Watlow"  },
    { 0x1F05, "Kyosai Technos Co., Ltd."  },
    { 0x1F06, "K.T.E.-Keter Technologies Europe"  },
    { 0x1F07, "OPTOQUEST Co., Ltd."  },
    { 0x1F08, "Digital Ally Inc."  },
    { 0x1F09, "DURAG GmbH"  },
    { 0x1F0A, "AUROX Ltd."  },
    { 0x1F0B, "INTRONIX TEST INSTURMENTS, INC."  },
    { 0x1F0C, "Fourier Systems Ltd."  },
    { 0x1F0D, "NAMOS"  },
    { 0x1F0E, "Inflexis Corporation"  },
    { 0x1F0F, "Action Technology (SZ) Co., Ltd."  },
    { 0x1F10, "LTW TECHNOLOGY CO., LTD."  },
    { 0x1F11, "VIRAGE LOGIC"  },
    { 0x1F12, "Photometrics"  },
    { 0x1F13, "CENTURY SYSTEMS Co., Ltd."  },
    { 0x1F14, "Astoria Networks GmbH"  },
    { 0x1F15, "Schmitt Industries Inc."  },
    { 0x1F16, "Olidata SpA"  },
    { 0x1F17, "APIS Device, Inc."  },
    { 0x1F18, "Teseq GmbH"  },
    { 0x1F19, "POLATIS INC."  },
    { 0x1F1A, "Sanden Retail Systems Corporation"  },
    { 0x1F1B, "NORTHROP GRUMMAN SPERRY MARINE"  },
    { 0x1F1C, "LXE, INC."  },
    { 0x1F1D, "How Weih Precision Technology (Shenzhen) Co., Ltd."  },
    { 0x1F1E, "TSIEN (UK) LTD."  },
    { 0x1F1F, "RaaX Co., Ltd."  },
    { 0x1F20, "Shenzhen Tenwei Electronics Co., Ltd."  },
    { 0x1F21, "Scosche Industries"  },
    { 0x1F22, "STAr Technologies, Inc."  },
    { 0x1F23, "KOUEI SYSTEM, LTD."  },
    { 0x1F24, "EBTRON INC."  },
    { 0x1F25, "Victron Energy B.V."  },
    { 0x1F26, "INCAP GmbH"  },
    { 0x1F27, "KEE Action Sports (Hater Paintball)"  },
    { 0x1F28, "Cal-Comp Electronics & Communications"  },
    { 0x1F29, "Analogix Semiconductor, Inc."  },
    { 0x1F2A, "Scene Double Ltd."  },
    { 0x1F2B, "JUKI CORPORATION"  },
    { 0x1F2C, "SELESTA INGEGNERIA SPA"  },
    { 0x1F2D, "Liteye Systems, Inc."  },
    { 0x1F2E, "ARMOUR GROUP PLC."  },
    { 0x1F2F, "UPOS SYSTEM SP. Z O.O."  },
    { 0x1F30, "RENA GmbH"  },
    { 0x1F31, "SASKEN COMMUNICATION TECH LTD."  },
    { 0x1F32, "COCHLEAR TECHNOLOGY CENTRE BELGIUM"  },
    { 0x1F33, "GrupoPIE Portugal, S.A."  },
    { 0x1F34, "Dutronics"  },
    { 0x1F35, "Amphenol ShouhMin Industry (ShenZhen) Co., Ltd"  },
    { 0x1F36, "ddm hopt + schuler GmbH & Co. KG"  },
    { 0x1F37, "Next Step Solutions Limited"  },
    { 0x1F38, "Kesumo, LLC"  },
    { 0x1F39, "Sumitomo Electric Networks, Inc."  },
    { 0x1F3A, "Allwinner Technology Co., Ltd."  },
    { 0x1F3B, "Biocryptodisk Sdn Bhd"  },
    { 0x1F3C, "Chang Yang Electronics Company Ltd."  },
    { 0x1F3D, "Advanced Engineering Services Co., Ltd."  },
    { 0x1F3E, "Telenot Electronic GmbH"  },
    { 0x1F3F, "SECA GmbH & Co. KG"  },
    { 0x1F40, "JiangSu Dongda Integrated Circuits Sys. Eng. Tech. Co."  },
    { 0x1F41, "Nipro Diagnostics, Inc"  },
    { 0x1F42, "ID2P TECHNOLOGIES, INC."  },
    { 0x1F43, "RAPID BRIDGE LLC"  },
    { 0x1F44, "Digital Business Process (dba: The Neat Company)"  },
    { 0x1F45, "QUALCOMM ENTERPRISE SERVICES"  },
    { 0x1F46, "Gener8, Inc."  },
    { 0x1F47, "Orb Networks, Inc."  },
    { 0x1F48, "H-TRONIC GmbH"  },
    { 0x1F49, "Exelis, Inc."  },
    { 0x1F4A, "Key Ingredient Corporation"  },
    { 0x1F4B, "Precision System Science Co., Ltd."  },
    { 0x1F4C, "Cyber Sport Pty., Ltd."  },
    { 0x1F4D, "SHENZHEN GENIATECH INC., LTD."  },
    { 0x1F4E, "OFF-NET SERVICE LIMITED"  },
    { 0x1F4F, "EXAR CORPORATION - JAPAN"  },
    { 0x1F50, "KEMPPI OY"  },
    { 0x1F51, "Helmut Hund GmbH"  },
    { 0x1F52, "Systems & Electronic Development FZCO (SEDCO)"  },
    { 0x1F53, "SK telesys"  },
    { 0x1F54, "LOEC, INC."  },
    { 0x1F55, "Fujitsu Electronics Europe GmbH"  },
    { 0x1F56, "MUT"  },
    { 0x1F57, "PIGNOLO S.P.A."  },
    { 0x1F58, "Inmarsat"  },
    { 0x1F59, "EL.MO. S.P.A."  },
    { 0x1F5A, "Micronova srl."  },
    { 0x1F5B, "KYODO COMMUNICATIONS & ELECTRONICS INC."  },
    { 0x1F5C, "MIDORI ANZEN CO., LTD."  },
    { 0x1F5D, "Mobii Systems (Pty) Ltd."  },
    { 0x1F5E, "Johnson Outdoors Marine Electronics, Inc."  },
    { 0x1F5F, "NETCLEUS SYSTEMS Corporation"  },
    { 0x1F60, "Young at Heart International Ltd."  },
    { 0x1F61, "Flexocard GmbH"  },
    { 0x1F62, "Elquest Corporation"  },
    { 0x1F63, "IriTech, Inc."  },
    { 0x1F64, "actionXL, Inc."  },
    { 0x1F65, "Taylor Technologies, Co., Ltd."  },
    { 0x1F66, "Hokkaido Electronics Corporation"  },
    { 0x1F67, "MICRO INNOVATIONS CORP."  },
    { 0x1F68, "General Dynamics UK Limited"  },
    { 0x1F69, "NVIS, Inc."  },
    { 0x1F6A, "AJA VIDEO SYSTEMS INC."  },
    { 0x1F6B, "Muve, Inc."  },
    { 0x1F6C, "Cadex Electronics Inc."  },
    { 0x1F6D, "AMTI"  },
    { 0x1F6E, "AccuVein LLC"  },
    { 0x1F6F, "ALIPHCOM, INC."  },
    { 0x1F70, "MKD Technology Inc."  },
    { 0x1F71, "Huaya Microelectronics (HK) Ltd."  },
    { 0x1F72, "GM INSTRUMENTS LTD."  },
    { 0x1F73, "Record4Free.TV AG"  },
    { 0x1F74, "UNISTO Ltd."  },
    { 0x1F75, "Innostor Co., Ltd."  },
    { 0x1F76, "CYBER-RAIN, INC."  },
    { 0x1F77, "POSITRON PUBLIC SAFETY SYSTEMS"  },
    { 0x1F78, "UNION TOOL CO."  },
    { 0x1F79, "Rosen Technology and Research Center GmbH"  },
    { 0x1F7A, "WhiteOak Controls Inc."  },
    { 0x1F7B, "AVMAP SRL"  },
    { 0x1F7C, "Voltopia e.U."  },
    { 0x1F7D, "UNICARD S.A."  },
    { 0x1F7E, "Canon India Private Limited"  },
    { 0x1F7F, "NOVA Sensors"  },
    { 0x1F80, "MagicPixel Inc."  },
    { 0x1F81, "HYB D.O.O."  },
    { 0x1F82, "TANDBERG TELECOM AS"  },
    { 0x1F83, "Beauty Up Co., Ltd."  },
    { 0x1F84, "Inverness Medical Innovations, Inc."  },
    { 0x1F85, "Netronix Inc."  },
    { 0x1F86, "Skyworth Overseas Development Limited"  },
    { 0x1F87, "STANTUM"  },
    { 0x1F88, "Modu Ltd."  },
    { 0x1F89, "Dongguan Goldconn Electronics Co., Ltd."  },
    { 0x1F8A, "Morning Star Industrial Co., Ltd."  },
    { 0x1F8B, "Rittal GmbH & Co. KG"  },
    { 0x1F8C, "Reference, LLC."  },
    { 0x1F8D, "DEVICE FUNCTIONS"  },
    { 0x1F8E, "SENSE INSIDE GmbH"  },
    { 0x1F8F, "Narda Safety Test Solutions GmbH"  },
    { 0x1F90, "PURE TECHNOLOGIES"  },
    { 0x1F91, "Wilhelm Mikroelektronik GmbH"  },
    { 0x1F92, "INTERNATIONAL TECHNIDYNE CORP."  },
    { 0x1F93, "Alcohol Monitoring Systems, Inc."  },
    { 0x1F94, "Microhard Systems Inc."  },
    { 0x1F95, "Art of Technology AG"  },
    { 0x1F96, "Ascend Geo, LLC"  },
    { 0x1F97, "OZMO, INC. DBA OZMO DEVICES"  },
    { 0x1F98, "DSP Design Limited"  },
    { 0x1F99, "TOKAI RIKEN CO., LTD."  },
    { 0x1F9A, "Barron Associates, Inc."  },
    { 0x1F9B, "UBIQUITI Networks, Inc."  },
    { 0x1F9C, "ARVOO Engineering BV"  },
    { 0x1F9D, "Tri Works"  },
    { 0x1F9E, "MUTECH LIMITED"  },
    { 0x1F9F, "CasaTools, LLC"  },
    { 0x1FA0, "XLNT IDEA, INC."  },
    { 0x1FA1, "Curtis Instruments, Inc."  },
    { 0x1FA2, "AMETEK DENMARK A/S"  },
    { 0x1FA3, "LAIRD TECHNOLOGIES"  },
    { 0x1FA4, "BRIDGEPORT INSTRUMENTS, LLC"  },
    { 0x1FA5, "DELTA DORE"  },
    { 0x1FA6, "Daylight Solutions, Inc."  },
    { 0x1FA7, "COSMOS WEB CO., LTD."  },
    { 0x1FA8, "TCL Technoly Electronics (Hui Zhou) Co., Ltd."  },
    { 0x1FA9, "Digital Information Technologies Corporation"  },
    { 0x1FAA, "Zhong Shan City Li Tai Electronic Industrial Co., Ltd."  },
    { 0x1FAB, "SAMSUNG DIGITAL IMAGING CO., LTD."  },
    { 0x1FAC, "Franklin Technology Inc."  },
    { 0x1FAD, "Cresta Technology Inc."  },
    { 0x1FAE, "Lumidigm, Inc."  },
    { 0x1FAF, "Weintek Labs, Inc."  },
    { 0x1FB0, "Discera, Inc."  },
    { 0x1FB1, "Weatronic GmbH"  },
    { 0x1FB2, "WITHINGS"  },
    { 0x1FB3, "Matchbeeper AB"  },
    { 0x1FB4, "Owl Computing Technologies, Inc."  },
    { 0x1FB5, "Unify Software and Solutions GmbH & Co. KG"  },
    { 0x1FB6, "SheKel"  },
    { 0x1FB7, "J & D Tech Co., Ltd."  },
    { 0x1FB8, "DORMA TIME + ACCESS GmbH"  },
    { 0x1FB9, "Lake Shore Cryotronics, Inc."  },
    { 0x1FBA, "DERMALOG Identification Systems GmbH"  },
    { 0x1FBB, "PC Worth Int'l Co., Ltd."  },
    { 0x1FBC, "Kurzweil Education Systems, Inc."  },
    { 0x1FBD, "STACK LTD."  },
    { 0x1FBE, "CGS"  },
    { 0x1FBF, "OVAL Corporation"  },
    { 0x1FC0, "JUNE-ON Co., Ltd."  },
    { 0x1FC1, "Blue Chip Technology Limited"  },
    { 0x1FC2, "Poken SA"  },
    { 0x1FC3, "ICOP Digital, Inc."  },
    { 0x1FC4, "Alfons Haar Maschinenbau GmbH & Co. KG"  },
    { 0x1FC5, "Adaxys Solutions AG"  },
    { 0x1FC6, "LAUREL BANK MACHINES CO., LTD."  },
    { 0x1FC7, "mrs GmbH"  },
    { 0x1FC8, "Medis Technologies Ltd."  },
    { 0x1FC9, "NXP Semiconductors"  },
    { 0x1FCA, "ON TIM Technologies Ltd."  },
    { 0x1FCB, "Thermo Process Instruments"  },
    { 0x1FCC, "Hiro"  },
    { 0x1FCD, "Aurora Scientific Inc."  },
    { 0x1FCE, "WEBSCAN Inc."  },
    { 0x1FCF, "ACK Co., Ltd."  },
    { 0x1FD0, "GILSON S.A.S."  },
    { 0x1FD1, "TEKWorx Limited"  },
    { 0x1FD2, "LG Display Co., Ltd."  },
    { 0x1FD3, "ASK SA"  },
    { 0x1FD4, "FINSECUR"  },
    { 0x1FD5, "Dream Multimedia GmbH"  },
    { 0x1FD6, "Logitek Electronic Systems, Inc."  },
    { 0x1FD7, "ASELSAN Elektronik Sanayi ve Ticaret. A.S."  },
    { 0x1FD8, "Guangzhou Tianhe Changjiang Communication Industrial Co"  },
    { 0x1FD9, "Knox Company"  },
    { 0x1FDA, "Beckwith Electric Co., Inc."  },
    { 0x1FDB, "Delphin Technology AG"  },
    { 0x1FDC, "HOSA TECHNOLOGY, INC."  },
    { 0x1FDD, "CHASE GLORY INDUSTRIAL LTD."  },
    { 0x1FDE, "ILX Lightwave"  },
    { 0x1FDF, "SEPURA PLC"  },
    { 0x1FE0, "REALFLEET Co., Ltd."  },
    { 0x1FE1, "Ubixum, Inc."  },
    { 0x1FE2, "Aetas Systems Inc."  },
    { 0x1FE3, "Amaranthine, LLC"  },
    { 0x1FE4, "HANDY TECH ELEKTRONIK GmbH"  },
    { 0x1FE5, "KUKA Roboter GmbH"  },
    { 0x1FE6, "BOOKHAM INC."  },
    { 0x1FE7, "VERTEX WIRELESS CO., LTD."  },
    { 0x1FE8, "103mm Tech"  },
    { 0x1FE9, "Harvard Bioscience"  },
    { 0x1FEA, "SIMPLO TECHNOLOGY CO., LTD."  },
    { 0x1FEB, "Tecella"  },
    { 0x1FEC, "NIAN YEONG ENTERPRISE CO., LTD."  },
    { 0x1FED, "SYSACOM R&D Plus Inc."  },
    { 0x1FEE, "GALILEO ENGINEERING SRL"  },
    { 0x1FEF, "RESOL - Elektronische Regelungen GmbH"  },
    { 0x1FF0, "Kyoto Electronics Manufacturing Co., Ltd."  },
    { 0x1FF1, "Remote Operations Solutions"  },
    { 0x1FF2, "Carl Valentin GmbH"  },
    { 0x1FF3, "SINTEF Energy Research"  },
    { 0x1FF4, "HYUNDAI PETATEL INC."  },
    { 0x1FF5, "Changzhou Wujin BEST Electronic Cables Co., Ltd."  },
    { 0x1FF6, "ClickTech LLC"  },
    { 0x1FF7, "Guangzhou Shi Rui Electronics Co., Ltd."  },
    { 0x1FF8, "Infinite Memories"  },
    { 0x1FF9, "Schulze Elektronik GmbH"  },
    { 0x1FFA, "ARYGON Technologies AG"  },
    { 0x1FFB, "Pololu Corporation"  },
    { 0x1FFC, "Azimut Production Association JSC"  },
    { 0x1FFD, "TESSERA, INC."  },
    { 0x1FFE, "HOST ENGINEERING, INC."  },
    { 0x1FFF, "Ideofy Inc."  },
    { 0x2000, "RongTong Info & Tech Co., Ltd."  },
    { 0x2001, "D-Link Corporation"  },
    { 0x2002, "DAP Technologies Ltd."  },
    { 0x2003, "detectomat GmbH"  },
    { 0x2004, "Shanghai Bellmann Digital Source Co., Ltd."  },
    { 0x2005, "Balluff GmbH"  },
    { 0x2006, "Lenovo Mobile Communication Technology Ltd."  },
    { 0x2007, "LEYIO"  },
    { 0x2008, "ThingMagic, Inc."  },
    { 0x2009, "MPEDIA"  },
    { 0x200A, "ADVANCED RELAY CORP."  },
    { 0x200B, "TRANSISTOR DEVICES INC."  },
    { 0x200C, "HANPIN ELECTRON CO., LTD."  },
    { 0x200D, "Belkin Electronic (Changzhou) Co., Ltd."  },
    { 0x200E, "DAIICHI PARTS (HK) CO., LTD."  },
    { 0x200F, "Progind Srl"  },
    { 0x2010, "Tectonica Australia Pty. Ltd."  },
    { 0x2011, "SHENZHEN HEXIN COM. TECH. CO., LTD."  },
    { 0x2012, "Applied Radar, Inc."  },
    { 0x2013, "PCTV Systems"  },
    { 0x2014, "ONKEN CORPORATION"  },
    { 0x2015, "Shenzhen Ephone Communication Technology Co., Ltd."  },
    { 0x2016, "Norbit AS"  },
    { 0x2017, "NAL Research Corporation"  },
    { 0x2018, "SilverPAC, Inc."  },
    { 0x2019, "Electronics Development Corp."  },
    { 0x201A, "Vortran Laser Technology, Inc."  },
    { 0x201B, "1064138 Ontario Ltd. O/A UNI-TEC ELECTRONICS"  },
    { 0x201C, "Freeport Resources Enterprises Corp."  },
    { 0x201D, "Dongguan Shunhui Electronic Co., Ltd."  },
    { 0x201E, "Qingdao Haier Telecom Co., Ltd."  },
    { 0x201F, "W.E.M. INC."  },
    { 0x2020, "Shanghai BroadMobi Communication Technology Co., Ltd."  },
    { 0x2021, "Smartd ltd"  },
    { 0x2022, "AMICON Ltd."  },
    { 0x2023, "Berthold Technologies GmbH & Co. KG"  },
    { 0x2024, "Shoto Technologies LLC"  },
    { 0x2025, "NANOSENSE"  },
    { 0x2026, "EASUN REYROLLE LIMITED"  },
    { 0x2027, "LOAD SYSTEMS INTERNATIONAL, INC."  },
    { 0x2028, "DETAS TECHNOLOGY LTD."  },
    { 0x2029, "MYTRAK HEALTH SYSTEM INC."  },
    { 0x202A, "Fast Forward Video, Inc."  },
    { 0x202B, "Damalini AB"  },
    { 0x202C, "Enhanced Vision"  },
    { 0x202D, "Snowbush IP (a division of Gennum)"  },
    { 0x202E, "Lumio Inc."  },
    { 0x202F, "US ARMY RDECOM-ARDEC"  },
    { 0x2030, "VITEC Multimedia"  },
    { 0x2031, "Vistec AG"  },
    { 0x2032, "GFMesstechnik GmbH"  },
    { 0x2033, "WYMA Tecnologia Ltda."  },
    { 0x2034, "iSoft Silicon, Inc."  },
    { 0x2035, "seowonintech"  },
    { 0x2036, "Eitech Co., Ltd."  },
    { 0x2037, "Control Devices Australia Pty., Ltd."  },
    { 0x2038, "Wescor Inc."  },
    { 0x2039, "SE-Elektronic GmbH"  },
    { 0x203A, "Parallels, Inc."  },
    { 0x203B, "EIT, Inc."  },
    { 0x203C, "Steptechnica Co., Ltd."  },
    { 0x203D, "Encore Electronics"  },
    { 0x203E, "Pascher Instruments AB"  },
    { 0x203F, "WPG System Pte. Ltd."  },
    { 0x2040, "Hauppauge Computer Works, Inc."  },
    { 0x2041, "WILL BEST (ELECTRONICS) LTD."  },
    { 0x2042, "Eberspaecher Electronics GmbH & Co. KG"  },
    { 0x2043, "Mobius Microsystems"  },
    { 0x2044, "NOVUS PRODUTOS ELETRONICOS LTDA."  },
    { 0x2045, "EMH - Energie-Messtechnik GmbH"  },
    { 0x2046, "AbleNet Inc."  },
    { 0x2047, "Texas Instruments Incorporated (MSP430 Group)"  },
    { 0x2048, "Hongtech Electronics Co., Ltd."  },
    { 0x2049, "APACEWAVE TECHNOLOGIES"  },
    { 0x204A, "Enclustra GmbH"  },
    { 0x204B, "HANSHIN INFORMATION TECHNOLOGY INC."  },
    { 0x204C, "M7Lab., Co., Ltd."  },
    { 0x204D, "Orthodyne Electronics"  },
    { 0x204E, "LINO MANFROTTO + CO. S.P.A."  },
    { 0x204F, "VIDEOTEC SpA"  },
    { 0x2050, "CBF Systems, Inc."  },
    { 0x2051, "N.A.T. GmbH"  },
    { 0x2052, "Movidius Ltd."  },
    { 0x2053, "HANSHIN TERMINAL CO., LTD."  },
    { 0x2054, "Source R & D Inc. (DBA WARPIA)"  },
    { 0x2055, "Opti B. I. Communications, Ltd."  },
    { 0x2056, "CliniComp International Inc."  },
    { 0x2057, "DICE ELECTRONICS, LLC"  },
    { 0x2058, "NANO RIVER TECHNOLOGIES"  },
    { 0x2059, "SMART Temps LLC"  },
    { 0x205A, "Hankook Tire"  },
    { 0x205B, "TRUMPF Medizin Systeme GmbH"  },
    { 0x205C, "Shenzhen Tronixin Electronics Co., Ltd."  },
    { 0x205D, "RESMED LTD."  },
    { 0x205E, "CTI PRODUCTS, Inc."  },
    { 0x205F, "Capella Microsystems Inc."  },
    { 0x2060, "U.S. Army Aviation & Missile R & D & Engineering Center"  },
    { 0x2061, "FIGMENT DESIGN LABORATORIES"  },
    { 0x2062, "Trulife"  },
    { 0x2063, "AirMagnet Inc."  },
    { 0x2064, "Shenzhen AnNet Technology Co., Ltd."  },
    { 0x2065, "MEASUREMENT SPECIALTIES INC."  },
    { 0x2066, "Unicorn Electronics Components Co., Ltd."  },
    { 0x2067, "TSB LAO COMPANY LIMITED"  },
    { 0x2068, "Seven 45 Studios"  },
    { 0x2069, "Vanguard Rugged Storage, LLC"  },
    { 0x206A, "Fujian Star-net Communication Co., Ltd."  },
    { 0x206B, "CETIM"  },
    { 0x206C, "Seeker Technology Corp."  },
    { 0x206D, "Hunan GreatWall Information Financial Equipment Co.Ltd."  },
    { 0x206E, "ZAO MIRCOM"  },
    { 0x206F, "JTOUCH Corporation"  },
    { 0x2070, "Infinite Response, Inc."  },
    { 0x2071, "SYSTEM S.P.A."  },
    { 0x2072, "GOOD YEAR ELECTRONIC MFG. CO., LTD."  },
    { 0x2073, "Shenzhen R-Way Technology Co., Ltd."  },
    { 0x2074, "UNIVERSAL CHAMPION ELECTROACOUSTIC TECHNOLOGY COMPANY"  },
    { 0x2075, "SecureKey Technologies Inc."  },
    { 0x2076, "SHINKAWA Sensor Technology, Inc."  },
    { 0x2077, "Shenzhen Gongjin Electronics Co., Ltd."  },
    { 0x2078, "Epsilon Electronics, Inc dba Power Acoustik Electronics"  },
    { 0x2079, "New Concept Gaming Ltd."  },
    { 0x207A, "C.E.T.W.I.N System Solutions Sweden AB"  },
    { 0x207B, "Technetix Group Ltd."  },
    { 0x207C, "NESA International, Inc."  },
    { 0x207D, "CESI Technology Co., Ltd."  },
    { 0x207E, "ENHANCED VIDEO DEVICES, INC."  },
    { 0x207F, "Profound BV"  },
    { 0x2080, "Barnes and Noble"  },
    { 0x2081, "UTRONIX Elektronikutreckling AB"  },
    { 0x2082, "EKOMINI INC."  },
    { 0x2083, "XEL SOLUTIONS LTD."  },
    { 0x2084, "I Zone Technologies Co., Ltd."  },
    { 0x2085, "SIXENSE ENTERTAINMENT INC."  },
    { 0x2086, "SHENZHEN CATIC INFORMATION TECHNOLOGY INDUSTRY CO., LTD"  },
    { 0x2087, "Cando Corporation"  },
    { 0x2088, "WALTON CHAINTECH CORPORATION"  },
    { 0x2089, "microdrones GmbH"  },
    { 0x208A, "TECHNO ROAD Inc."  },
    { 0x208B, "KONTRON EMBEDDED COMPUTERS GmbH"  },
    { 0x208C, "Linkbit, Inc."  },
    { 0x208D, "Attero Tech, LLC"  },
    { 0x208E, "Luxshare-ICT"  },
    { 0x208F, "Chi Mei Optoelectronics Corporation"  },
    { 0x2090, "Transition Networks"  },
    { 0x2091, "Callpod, Inc."  },
    { 0x2092, "Logina"  },
    { 0x2093, "Ambu A/S"  },
    { 0x2094, "Yoostar Entertainment Group, Inc."  },
    { 0x2095, "CE LINK LIMITED"  },
    { 0x2096, "Shenzhen Microconn Investment and Development Co., Ltd."  },
    { 0x2097, "USBPARTNER"  },
    { 0x2098, "TouchTable, Inc."  },
    { 0x2099, "Systematic Development Group, LLC"  },
    { 0x209A, "Avedis Zildjian Company"  },
    { 0x209B, "SATEL OY"  },
    { 0x209C, "iPulse Systems"  },
    { 0x209D, "Vector Co., Ltd."  },
    { 0x209E, "GlideTV Inc."  },
    { 0x209F, "Alcolizer Technology"  },
    { 0x20A0, "Flirc"  },
    { 0x20A1, "BRAINZSQUARE CO., LTD."  },
    { 0x20A2, "SCANMATIK"  },
    { 0x20A3, "Sterilucent"  },
    { 0x20A4, "Itron Metering Solutions"  },
    { 0x20A5, "Cardiorobotics, Inc."  },
    { 0x20A6, "ZheJiang SEENSUN Communication&Electronic Equipment Co."  },
    { 0x20A7, "GREAT LUSTRE (SPEEDY) CO., LTD."  },
    { 0x20A8, "nLighten Technologies (Shanghai) Co., Ltd."  },
    { 0x20A9, "Autotronic Controls Corp."  },
    { 0x20AA, "ED-CONTRIVE Co., Ltd."  },
    { 0x20AB, "Identification International, Inc."  },
    { 0x20AC, "Wintek Corporation"  },
    { 0x20AD, "Japan Probe Co., Ltd."  },
    { 0x20AE, "SoCChip (Wuxi Youxin IC Design Co., Ltd.)"  },
    { 0x20AF, "Shenzhen CARVE Electronics Co., Ltd."  },
    { 0x20B0, "ICOMM TELE LIMITED"  },
    { 0x20B1, "XMOS Ltd."  },
    { 0x20B2, "Clubbhouse Inventions LLC"  },
    { 0x20B3, "Hannstouch Solution Inc."  },
    { 0x20B4, "SANDBRIDGE TECHNOLOGIES, INC."  },
    { 0x20B5, "ACD Gruppe"  },
    { 0x20B6, "Bohle AG"  },
    { 0x20B7, "Qi Hardware, Inc."  },
    { 0x20B8, "PARA INDUSTRIAL CO., LTD."  },
    { 0x20B9, "TLAY Technologies Co., Ltd."  },
    { 0x20BA, "jwin Electronics Corp."  },
    { 0x20BB, "THALES TRANSPORTATION SYSTEMS"  },
    { 0x20BC, "Guangzhou Pingzhong Electronic Technology Co., Ltd."  },
    { 0x20BD, "KETEK"  },
    { 0x20BE, "BURY GmbH & Co. KG"  },
    { 0x20BF, "Dwyer Instruments, Inc."  },
    { 0x20C0, "FENGHUA KINGSUN CO., LTD."  },
    { 0x20C1, "HARWIN ASIA PTE. LTD."  },
    { 0x20C2, "Sumitomo Electric Ind., Ltd., Optical Comm. R&D Lab"  },
    { 0x20C3, "TECNOMOTOR ELETRONICA DO BRASIL S/A"  },
    { 0x20C4, "Communications Laboratories, Inc. (Comlabs)"  },
    { 0x20C5, "A.U. Physics Enterprises"  },
    { 0x20C6, "Mutto Optronics Corporation"  },
    { 0x20C7, "HMC INTERNATIONAL"  },
    { 0x20C8, "CEC TELECOM CO., LTD."  },
    { 0x20C9, "SYSTEMCORP Pty., Ltd."  },
    { 0x20CA, "TRIPHOS Co., Ltd."  },
    { 0x20CB, "Dave Smith Instruments"  },
    { 0x20CC, "TAKARA"  },
    { 0x20CD, "Schweers Informationstechnologie GmbH"  },
    { 0x20CE, "Mini-Circuits"  },
    { 0x20CF, "Gridmark Limited"  },
    { 0x20D0, "FRESENIUS VIAL"  },
    { 0x20D1, "Dascom Europe GmbH"  },
    { 0x20D2, "ROBOTEQ INC."  },
    { 0x20D3, "Provo Craft"  },
    { 0x20D4, "SCDi"  },
    { 0x20D5, "Lenexpo Inc. (dba: Atlona)"  },
    { 0x20D6, "Bensussen Deutsch & Associates, Inc. (BDA)"  },
    { 0x20D7, "SHENZHEN ZILI ELECTRONICS CO. LTD."  },
    { 0x20D8, "Changzhou Xinchao Technologies, Inc."  },
    { 0x20D9, "ZHEJIANG YONGCHENGGONG DIANSU.CO., LTD."  },
    { 0x20DA, "LumaSense Technologies A/S"  },
    { 0x20DB, "KTS GmbH"  },
    { 0x20DC, "KCS Digital, Inc."  },
    { 0x20DD, "FORTREND TAIWAN SCIENTIFIC CORP."  },
    { 0x20DE, "OneSail HK Ltd."  },
    { 0x20DF, "SIMTEC ELECTRONICS"  },
    { 0x20E0, "Realway Electronics Technology Limited"  },
    { 0x20E1, "Daiichi Co., Ltd."  },
    { 0x20E2, "ASEQ INSTRUMENTS"  },
    { 0x20E3, "LAUDA DR.R.WOBSER GMBH & CO. KG"  },
    { 0x20E4, "Onecell Technologies"  },
    { 0x20E5, "Cardreader, Inc."  },
    { 0x20E6, "Brooks Automation, Inc."  },
    { 0x20E7, "Scientific Digital Imaging plc"  },
    { 0x20E8, "Jow Tong Technology Co., Ltd."  },
    { 0x20E9, "adp Gauselmann GmbH"  },
    { 0x20EA, "CACTUS TECHNOLOGIES, LIMITED"  },
    { 0x20EB, "AOS Technologies AG"  },
    { 0x20EC, "AMBIR TECHNOLOGY, INC."  },
    { 0x20ED, "TRANZFINITY, INC."  },
    { 0x20EE, "Emotiva Audio Corp."  },
    { 0x20EF, "TIGRIS Elektronik GmbH"  },
    { 0x20F0, "Insight Technology Incorporated"  },
    { 0x20F1, "NET GmbH"  },
    { 0x20F2, "Secured Mobility"  },
    { 0x20F3, "Flexcore"  },
    { 0x20F4, "TRENDnet"  },
    { 0x20F5, "MKS Instruments - Technology for Productivity"  },
    { 0x20F6, "EXMAN ELECTRIC"  },
    { 0x20F7, "XIMEA s.r.o."  },
    { 0x20F8, "Guangzhou Somic Digital & Electronic Technology Co, Ltd"  },
    { 0x20F9, "Medical Computer Systems, Ltd."  },
    { 0x20FA, "IC Intracom"  },
    { 0x20FB, "Aptina Imaging Corporation"  },
    { 0x20FC, "PIE SOFT LAB CORPORATION"  },
    { 0x20FD, "NOVO NORDISK A/S"  },
    { 0x20FE, "Bittium USA Inc."  },
    { 0x20FF, "PNI Sensor Corp."  },
    { 0x2100, "RT Systems Inc."  },
    { 0x2101, "NAS Technologies Corp."  },
    { 0x2102, "Vitalograph Ltd."  },
    { 0x2103, "OHMORI ELECTRIC INDUSTRIES CO., LTD."  },
    { 0x2104, "Tobii AB"  },
    { 0x2105, "Retail Innovation HTT AB"  },
    { 0x2106, "Sharp Korea Corporation"  },
    { 0x2107, "Amstore CD Production Ltd."  },
    { 0x2108, "NEATO ROBOTICS"  },
    { 0x2109, "VIA Labs, Inc."  },
    { 0x210A, "PULSUS TECHNOLOGIES"  },
    { 0x210B, "Work Microwave GmbH"  },
    { 0x210C, "DOT HILL SYSTEMS"  },
    { 0x210D, "Plastoform Industries Ltd."  },
    { 0x210E, "Commscope"  },
    { 0x210F, "Tyco / Scott Health & Safety"  },
    { 0x2110, "carina system co., ltd."  },
    { 0x2111, "alphaNUCLEAR Inc."  },
    { 0x2112, "Point Of Pay Pty. Ltd."  },
    { 0x2113, "Softkinetic"  },
    { 0x2114, "Innovision Technology Corporation Ltd."  },
    { 0x2115, "Alliance Material Co., Ltd."  },
    { 0x2116, "KT Tech Inc."  },
    { 0x2117, "Frama AG"  },
    { 0x2118, "RF WINDOW"  },
    { 0x2119, "MoreDNA Technology Co., Ltd."  },
    { 0x211A, "PILLKEY HOLDING BV"  },
    { 0x211B, "MENTOR GmbH & Co. Praezisions-Bauteile KG"  },
    { 0x211C, "SWENC Technology Co., Ltd."  },
    { 0x211D, "Mutualink, Inc."  },
    { 0x211E, "Dongbu HiTek"  },
    { 0x211F, "XINETWORKS CO., LTD."  },
    { 0x2120, "Odirrus Limited"  },
    { 0x2121, "Escort Data Logging Systems Ltd."  },
    { 0x2122, "ZEDEL"  },
    { 0x2123, "SYNTEK DEVELOPMENT LTD."  },
    { 0x2124, "ELSAGDATAMAT S.P.A."  },
    { 0x2125, "FIBERPRO INC."  },
    { 0x2126, "SUZA INTERNATIONAL FRANCE"  },
    { 0x2127, "FutureDial, Inc."  },
    { 0x2128, "Naval Research Laboratory"  },
    { 0x2129, "Tokushu Denshi Kairo, Inc."  },
    { 0x212A, "Kappa optronics GmbH"  },
    { 0x212B, "GR Telecom Co., Ltd."  },
    { 0x212C, "Shenzhen Linoya Electronic Co., Ltd."  },
    { 0x212D, "Dong Guan City Wanhong Electric Co., Ltd."  },
    { 0x212E, "Amphenol AssembleTech (Xiamen) Co., Ltd."  },
    { 0x212F, "SUZUKI MUSICAL INST. MFG. CO., LTD."  },
    { 0x2130, "Sanmu Communication Technology (H.K.) Ltd."  },
    { 0x2131, "IES Co., Ltd."  },
    { 0x2132, "EDAS, Inc."  },
    { 0x2133, "SIGNOTEC GmbH"  },
    { 0x2134, "CANESTA, INC."  },
    { 0x2135, "W.O.M. World of Medicine AG"  },
    { 0x2136, "Compunow Trading Corp."  },
    { 0x2137, "Beyonics Technology Limited"  },
    { 0x2138, "iVina, Inc."  },
    { 0x2139, "Eigenlabs Ltd."  },
    { 0x213A, "Carlo Gavazzi"  },
    { 0x213B, "UICO, Inc."  },
    { 0x213C, "ICON Health & Fitness"  },
    { 0x213D, "DRS Data & Imaging Systems, Inc."  },
    { 0x213E, "Phase Matrix, Inc."  },
    { 0x213F, "Digitron Instrumentation Ltd."  },
    { 0x2140, "Sichuan Jiuzhou Electric Group Co., Ltd."  },
    { 0x2141, "ZT Group Int'l, Inc."  },
    { 0x2142, "Enginuity Communications"  },
    { 0x2143, "InDevR Inc."  },
    { 0x2144, "Sea Tel, Inc."  },
    { 0x2145, "Ballard Technology"  },
    { 0x2146, "Victorinox AG"  },
    { 0x2147, "Chin-Ban Electronics (Hong Kong) Co., Ltd."  },
    { 0x2148, "Visteon Sistemas Automotives Ltda."  },
    { 0x2149, "MasTouch Optoelectronics Technologies Co., Ltd."  },
    { 0x214A, "Interlink Electronics"  },
    { 0x214B, "AMECO TECHNOLOGIES (SHENZHEN) CO., LTD."  },
    { 0x214C, "Y Soft Corporation"  },
    { 0x214D, "SyTech Corporation"  },
    { 0x214E, "Swiftpoint Limited"  },
    { 0x214F, "Attainment Company, Inc."  },
    { 0x2150, "AZOTEQ (PTY) LTD."  },
    { 0x2151, "SeaSpace Corporation"  },
    { 0x2152, "AD Semiconductor Co., Ltd."  },
    { 0x2153, "Mastertouch Solutions Electronics Co., Ltd."  },
    { 0x2154, "Trace Lighting Ltd."  },
    { 0x2155, "Teledyne Controls"  },
    { 0x2156, "Weistech Technology Co., Ltd."  },
    { 0x2157, "Digital Imaging Technology"  },
    { 0x2158, "TA WEI TECHNOLOGY CO., LTD."  },
    { 0x2159, "TRIASX Pty Ltd."  },
    { 0x215A, "Sling Media, Inc."  },
    { 0x215B, "2D Debus & Diebold Messsysteme GmbH"  },
    { 0x215C, "OTOVATION, LLC"  },
    { 0x215D, "GeNUA mbH"  },
    { 0x215E, "ST Embedded Engineering, LLC"  },
    { 0x215F, "DECIMATOR DESIGN PTY LTD."  },
    { 0x2160, "PULOON Technology Inc."  },
    { 0x2161, "BEA SA"  },
    { 0x2162, "Prime Audio Inc."  },
    { 0x2163, "Digital Rapids Corp."  },
    { 0x2164, "Witek System"  },
    { 0x2165, "CONTROL SOLUTIONS, INC."  },
    { 0x2166, "JVC KENWOOD Corporation"  },
    { 0x2167, "Zhejiang Fousine Science & Technology Co., Ltd."  },
    { 0x2168, "TZYR HWEY ENTERPRISE CO., LTD."  },
    { 0x2169, "TIANJIN SHENNAN INFORMATION SECURITY CO., LTD."  },
    { 0x216A, "Shenzhen San Jing Electronics Co., Ltd."  },
    { 0x216B, "XceedID Corporation"  },
    { 0x216C, "UniDisplay Inc."  },
    { 0x216D, "BENSON MEDICAL INSTRUMENTS"  },
    { 0x216E, "KHOMP INDUSTRIA E COMERCIO LTDA"  },
    { 0x216F, "ALTAIR SEMICONDUCTOR"  },
    { 0x2170, "Wurtec, Inc."  },
    { 0x2171, "Bokam Engineering, Inc."  },
    { 0x2172, "Torrey Pines Logic, Inc."  },
    { 0x2173, "HUIZHOU HUANGJI PRECISIONS FLEX ELECTRONICAL CO., LTD."  },
    { 0x2174, "Transcend Information, Inc."  },
    { 0x2175, "Light Blue Optics, Inc."  },
    { 0x2176, "TMC - Allion Test Labs"  },
    { 0x2177, "CHAUVIN ARNOUX"  },
    { 0x2178, "Ion Science"  },
    { 0x2179, "UGtizer Corp."  },
    { 0x217A, "Triple Eye"  },
    { 0x217B, "BDP Semiconductors Ltd."  },
    { 0x217C, "Sensitech Inc."  },
    { 0x217D, "Bilcare Technologies Singapore Pte. Ltd."  },
    { 0x217E, "TP RADIO"  },
    { 0x217F, "REAL EAR A/S"  },
    { 0x2180, "Icare Finland Oy"  },
    { 0x2181, "GLOBAL TRAFFIC TECHNOLOGIES, LLC"  },
    { 0x2182, "XAC Automation Corp."  },
    { 0x2183, "Bonutti Research"  },
    { 0x2184, "GOOD WILL Instrument Co., Ltd."  },
    { 0x2185, "FUJIWORK Co., Ltd."  },
    { 0x2186, "Home Server Technologies Inc."  },
    { 0x2187, "ESPACE SERVICES MULTIMEDIAS"  },
    { 0x2188, "CalDigit, Inc."  },
    { 0x2189, "SEMNTECH"  },
    { 0x218A, "EXELYS LLC"  },
    { 0x218B, "Blackbird Technologies Inc."  },
    { 0x218C, "Gammadata Instrument AB"  },
    { 0x218D, "Adaptive I/O Technologies, Inc."  },
    { 0x218E, "UNITRO-Fleischmann"  },
    { 0x218F, "DHEF INC."  },
    { 0x2190, "esonic Co., Ltd."  },
    { 0x2191, "SecureAT Co., Ltd."  },
    { 0x2192, "FlexRadio Systems"  },
    { 0x2193, "Schnick-Schnack-Systems GmbH"  },
    { 0x2194, "ROTH + WEBER GmbH"  },
    { 0x2195, "Hans Eckes Hardware & Software"  },
    { 0x2196, "XPMOBILE"  },
    { 0x2197, "W & D, LLC"  },
    { 0x2198, "Wonde Proud Technology Co., Ltd."  },
    { 0x2199, "Image and Information Technology"  },
    { 0x219A, "COSMO ELECTRONICS CO., LTD."  },
    { 0x219B, "TPK Touch Solutions Inc."  },
    { 0x219C, "SEAL ONE AG"  },
    { 0x219D, "BDR Technologies Ltd."  },
    { 0x219E, "VALKEE OY"  },
    { 0x219F, "VENTIS"  },
    { 0x21A0, "AXELSPACE Corporation"  },
    { 0x21A1, "EMOTIV SYSTEMS INC."  },
    { 0x21A2, "ABB Low Voltage Products"  },
    { 0x21A3, "Optcom Co., Ltd."  },
    { 0x21A4, "ELECTRONIC ARTS"  },
    { 0x21A5, "Genesis Technology USA, Inc."  },
    { 0x21A6, "YUPITERU CORPORATION"  },
    { 0x21A7, "PAYPRINT SRL"  },
    { 0x21A8, "GE Intelligent Platforms, Inc."  },
    { 0x21A9, "Saleae LLC"  },
    { 0x21AA, "TAKASAKI KYODO COMPUTING CENTER CO., LTD."  },
    { 0x21AB, "Planeta Informatica Ltda."  },
    { 0x21AC, "infoSense Technology Inc."  },
    { 0x21AD, "Wobbegong Fitness and Therapy Products Pty. Ltd."  },
    { 0x21AE, "Philips and Neusoft Medical System Co., Ltd."  },
    { 0x21AF, "Euro-CB Phils. Inc."  },
    { 0x21B0, "Grace Industries, Incorporated"  },
    { 0x21B1, "TATA CONSULTANCY SERVICES"  },
    { 0x21B2, "Felix Meier GmbH"  },
    { 0x21B3, "Dongguan Teconn Electronics Technology Co., Ltd."  },
    { 0x21B4, "Wavelength Audio, Ltd."  },
    { 0x21B5, "SHENZHEN JASON ELECTRONICS CO., LTD."  },
    { 0x21B6, "EUROAVIONICS GmbH & Co. KG"  },
    { 0x21B7, "STAIB INSTRUMENTE GmbH"  },
    { 0x21B8, "KONTRONIK GmbH"  },
    { 0x21B9, "ZP ENGINEERING s.r.l."  },
    { 0x21BA, "SI2 MICROSYSTEMS, Ltd."  },
    { 0x21BB, "WWPass Corporation"  },
    { 0x21BC, "Skyhawke Technologies, LLC"  },
    { 0x21BD, "Code Red Technologies, Ltd."  },
    { 0x21BE, "KEC Co., Ltd."  },
    { 0x21BF, "Mayo Clinic"  },
    { 0x21C0, "PIXTREE, Inc."  },
    { 0x21C1, "Baumann Electronic Controls, LLC"  },
    { 0x21C2, "Shenzhen V-Interface Technology Co., Ltd."  },
    { 0x21C3, "MASIMO LABORATORIES INC."  },
    { 0x21C4, "Longsys Electronics (HK) Co., Ltd."  },
    { 0x21C5, "Vukic Computer Instruments GmbH"  },
    { 0x21C6, "PSS Hong Kong Limited"  },
    { 0x21C7, "Unisoku Co., Ltd."  },
    { 0x21C8, "IDONDEMAND INC."  },
    { 0x21C9, "Innoteletek, Inc."  },
    { 0x21CA, "RAE Systems Inc."  },
    { 0x21CB, "Vodafone Ltd."  },
    { 0x21CC, "ChipsWork Microelectronics Corp."  },
    { 0x21CD, "Infoxelle Co., Ltd."  },
    { 0x21CE, "Polostar Technology Corporation"  },
    { 0x21CF, "HISATOMI ELECTRIC IND. CO., LTD."  },
    { 0x21D0, "Red Rapids"  },
    { 0x21D1, "ADDER TECHNOLOGY LTD."  },
    { 0x21D2, "NeoLAB Convergence"  },
    { 0x21D3, "Compupack Technology Co., Ltd."  },
    { 0x21D4, "Eduplayer Co., Ltd."  },
    { 0x21D5, "M.G.F."  },
    { 0x21D6, "Agecodagis SARL"  },
    { 0x21D7, "VINCIAMO, Inc."  },
    { 0x21D8, "P & A Technologies, Inc."  },
    { 0x21D9, "Verification Technology, Inc."  },
    { 0x21DA, "Valor Auto Companion, Inc."  },
    { 0x21DB, "G-Max Technology Co., Ltd."  },
    { 0x21DC, "ABB S.p.A., Low Voltage Products Division"  },
    { 0x21DD, "Looxcie, Inc."  },
    { 0x21DE, "Cloud Engines, Inc."  },
    { 0x21DF, "Quanser Consulting Inc."  },
    { 0x21E0, "OpenPattern"  },
    { 0x21E1, "CAEN S.P.A."  },
    { 0x21E2, "Ascension Technology Corp."  },
    { 0x21E3, "Crest Technology Inc."  },
    { 0x21E4, "Xcellen Co., Ltd."  },
    { 0x21E5, "Kruglov Evgeniy Vladimirovich"  },
    { 0x21E6, "OCZ Technology Group"  },
    { 0x21E7, "Sagemcom Broadband SAS"  },
    { 0x21E8, "BOEHNKE + PARTNER GmbH Steuerungssysteme"  },
    { 0x21E9, "Jiafuh Metal & Plastic (ShenZhen) Co., Ltd."  },
    { 0x21EA, "JUST MAKE ELECTRONICS CO., LTD."  },
    { 0x21EB, "KOKORO CO., LTD."  },
    { 0x21EC, "ApniCure, Inc."  },
    { 0x21ED, "Accuphase Laboratories, Inc."  },
    { 0x21EE, "MAVIN TECHNOLOGY INC."  },
    { 0x21EF, "FEMTO Messtechnik GmbH"  },
    { 0x21F0, "LivingLab Development Co., Ltd."  },
    { 0x21F1, "ABS Group AB"  },
    { 0x21F2, "Palmer Environmental Ltd."  },
    { 0x21F3, "Inspired Instruments Inc."  },
    { 0x21F4, "Minebea Technologies Taiwan Co., Ltd."  },
    { 0x21F5, "Shenzhen Strong Rising Electronics Co., Ltd."  },
    { 0x21F6, "QSR Automations, Inc."  },
    { 0x21F7, "Wuerth-Elektronik eiSos GmbH & Co. KG"  },
    { 0x21F8, "Goeasily Int'l Co., Ltd."  },
    { 0x21F9, "American Thermal Instruments"  },
    { 0x21FA, "Pitsco, Inc."  },
    { 0x21FB, "HELIOS Electronic Design & Manufacture"  },
    { 0x21FC, "Thum + Mahr GmbH"  },
    { 0x21FD, "Associated Controls (Australia) Pty., Limited"  },
    { 0x21FE, "ELAP S.p.A."  },
    { 0x21FF, "DEIF A/S"  },
    { 0x2200, "Nuribom"  },
    { 0x2201, "Elan Digital Systems Ltd."  },
    { 0x2202, "Walex Electronic (Wu Xi) Co., Ltd."  },
    { 0x2203, "Shin Shin Co., Ltd."  },
    { 0x2204, "Innov-X Systems Inc."  },
    { 0x2205, "3eYamaichi Electronics Co., Ltd."  },
    { 0x2206, "Wiretek International Investment Ltd."  },
    { 0x2207, "Fuzhou Rockchip Electronics Co., Ltd."  },
    { 0x2208, "CONNFLY ELECTRONIC CO., LTD."  },
    { 0x2209, "SPoT LLC"  },
    { 0x220A, "Anton Paar GmbH"  },
    { 0x220B, "IKARIA Holdings, Inc."  },
    { 0x220C, "Island Technology Co., Ltd."  },
    { 0x220D, "Humanline Co., Ltd."  },
    { 0x220E, "NetComm Ltd."  },
    { 0x220F, "Italdata Ingegneria Dell'Idea s.p.a."  },
    { 0x2210, "Klavis Technologies"  },
    { 0x2211, "FLUID COMPONENTS INTERNATIONAL LLC"  },
    { 0x2212, "Dev-Audio Pty. Ltd. (Dev-Audio)"  },
    { 0x2213, "Ascon Co., Ltd."  },
    { 0x2214, "Pollin Electronic GmbH"  },
    { 0x2215, "InCOMM Technologies Co., Ltd."  },
    { 0x2216, "Environmental Systems Corporation"  },
    { 0x2217, "FTS Forest Technology Systems Ltd."  },
    { 0x2218, "Listen Technologies Corp."  },
    { 0x2219, "Hogahm Technology"  },
    { 0x221A, "ZTEX"  },
    { 0x221B, "Kyodo Denshi Engineering Co., Ltd."  },
    { 0x221C, "CORTEX TECHNOLOGY APS"  },
    { 0x221D, "fischertechnik GmbH"  },
    { 0x221E, "Linktec Technologies Co., Ltd."  },
    { 0x221F, "Resolution Audio"  },
    { 0x2220, "FAMAS SYSTEM S.P.A."  },
    { 0x2221, "EnovateIT Inc."  },
    { 0x2222, "SOFTMECHA"  },
    { 0x2223, "Ratioplast-Optoelectronics GmbH"  },
    { 0x2224, "LM Technologies Ltd."  },
    { 0x2225, "GETT Geratetechnik GmbH"  },
    { 0x2226, "PLANAR LLC"  },
    { 0x2227, "Northtronics Pty., Ltd."  },
    { 0x2228, "Dantec Dynamics A/S"  },
    { 0x2229, "Key Technologies, Inc."  },
    { 0x222A, "ILI TECHNOLOGY CORP."  },
    { 0x222B, "ALPHAMEDIA CO., LTD."  },
    { 0x222C, "TOHAN DENSHI KIKI Co., Ltd."  },
    { 0x222D, "LEIFHEIT AG"  },
    { 0x222E, "OXYSEC s.r.l."  },
    { 0x222F, "Tcom Technology Co., Ltd."  },
    { 0x2230, "Plugable Technologies"  },
    { 0x2231, "Coregate Inc."  },
    { 0x2232, "NAMUGA Co., Ltd."  },
    { 0x2233, "ARGtek Communication Inc."  },
    { 0x2234, "T-CONN PRECISION CORPORATION"  },
    { 0x2235, "WoundVision"  },
    { 0x2236, "ACELLA"  },
    { 0x2237, "Kobo Inc."  },
    { 0x2238, "ELMO Motion Control Ltd."  },
    { 0x2239, "PEIKER acustic GmbH & Co., KG"  },
    { 0x223A, "BKtel Communications GmbH"  },
    { 0x223B, "Crystalfontz America, Inc."  },
    { 0x223C, "Audio Research Corp."  },
    { 0x223D, "AlfaPlus Semiconductor, Inc."  },
    { 0x223E, "Home Electronics"  },
    { 0x223F, "Oga, Inc."  },
    { 0x2240, "NETTALK.COM INC."  },
    { 0x2241, "Envision Interface Engineering, LLC"  },
    { 0x2242, "Zhihe Electronics Technology Co., Ltd."  },
    { 0x2243, "EMIC CORPORATION"  },
    { 0x2244, "Kronos"  },
    { 0x2245, "ASPEED Technology Inc."  },
    { 0x2246, "Nanjing Frentec Co., Ltd."  },
    { 0x2247, "CHUNGHWA PICTURE TUBES, LTD."  },
    { 0x2248, "KAISE CORPORATION"  },
    { 0x2249, "Long Range Systems, Inc."  },
    { 0x224A, "ORMEC SYSTEMS CORP."  },
    { 0x224B, "Sirit Inc."  },
    { 0x224C, "Datron World Communications, Inc."  },
    { 0x224D, "Tescom Co., Ltd."  },
    { 0x224E, "RDH2 Science"  },
    { 0x224F, "APDM, INC."  },
    { 0x2250, "Evernew Wire & Cable Co., Ltd."  },
    { 0x2251, "QuieTek Corp."  },
    { 0x2252, "TSANSUN TECH. CO., LTD."  },
    { 0x2253, "Arpage AG"  },
    { 0x2254, "RPO"  },
    { 0x2255, "COOPER WIRELESS"  },
    { 0x2256, "Mathias Fuchss Software - Entwicklung"  },
    { 0x2257, "On the Go Video, Inc."  },
    { 0x2258, "D+H Mechatronic AG"  },
    { 0x2259, "Skypine Electronics (Shenzhen) Co., Ltd."  },
    { 0x225A, "Vivanco GmbH"  },
    { 0x225B, "Lineage Power"  },
    { 0x225C, "Digital Check Corp"  },
    { 0x225D, "Sagem Securite"  },
    { 0x225E, "Unholtz-Dickie Corp."  },
    { 0x225F, "Ace Karaoke Corp."  },
    { 0x2260, "Multigig, Inc."  },
    { 0x2261, "DOM-Sicherheitstechnik GmbH & Co. KG"  },
    { 0x2262, "VIETTEL GROUP"  },
    { 0x2263, "Nuovations"  },
    { 0x2264, "Entourage Systems, Inc."  },
    { 0x2265, "DailyCare BioMedical Inc."  },
    { 0x2266, "Psychology Software Tools, Inc."  },
    { 0x2267, "Boreal Genomics"  },
    { 0x2268, "EXSUSS, Inc."  },
    { 0x2269, "Schlumberger Ltd."  },
    { 0x226A, "Ooma, Inc."  },
    { 0x226B, "Bruker Nano GmbH"  },
    { 0x226C, "HAL Communications Corp."  },
    { 0x226D, "Wrenchman, Inc."  },
    { 0x226E, "DISPLAX"  },
    { 0x226F, "Koyo Trading Co., Ltd."  },
    { 0x2270, "XiaMen GaoLuChang Electronics Co. Ltd."  },
    { 0x2271, "Karl Storz GmbH & Co. KG"  },
    { 0x2272, "E.E.P.D."  },
    { 0x2273, "IMAX Corporation"  },
    { 0x2274, "Morgan Schaffer Inc."  },
    { 0x2275, "ReliOn Inc."  },
    { 0x2276, "Pioneer CBC"  },
    { 0x2277, "Ortho Neuro Technologies, Inc."  },
    { 0x2278, "Infratec Datentechnik GmbH"  },
    { 0x2279, "Goossens Engineering"  },
    { 0x227A, "FLOM Corporation"  },
    { 0x227B, "CYBELEC SA"  },
    { 0x227C, "S. & A.S. LTD."  },
    { 0x227D, "Unitec Co., Ltd."  },
    { 0x227E, "JSC <SATIS-TL-94>"  },
    { 0x227F, "Granite River Labs"  },
    { 0x2280, "Life Technologies Corp."  },
    { 0x2281, "GI CORPORATION"  },
    { 0x2282, "Mamiya Digital Imaging Co., Ltd."  },
    { 0x2283, "NIHON DEMPA KOGYO Co., Ltd."  },
    { 0x2284, "SuperSonic Inc."  },
    { 0x2285, "IRIS ID"  },
    { 0x2286, "Altierre Corporation"  },
    { 0x2287, "Shenzhen Oversea Win Technology Co., Ltd."  },
    { 0x2288, "Dt&C (Digital Technology and Certification)"  },
    { 0x2289, "Sun Fair Electric Wire & Cable (HK) Co., Ltd."  },
    { 0x228A, "Hotron Precision Electronic Ind. Corp."  },
    { 0x228B, "Shenzhen DLK Electronics Technology Co., Ltd."  },
    { 0x228C, "Analogic Corporation"  },
    { 0x228D, "8D TECHNOLOGIES INC."  },
    { 0x228E, "EKO Instruments Co., Ltd."  },
    { 0x228F, "SIGMATEK GmbH & Co. KG"  },
    { 0x2290, "Touchplus information Corp."  },
    { 0x2291, "Vallen Systeme GmbH"  },
    { 0x2292, "Global Industrial Services, Ltd."  },
    { 0x2293, "Berger Elektronik GmbH"  },
    { 0x2294, "KoCo Connector AG"  },
    { 0x2295, "Sound ID"  },
    { 0x2296, "Musashi Engineering Company Limited"  },
    { 0x2297, "Grain Media, Inc."  },
    { 0x2298, "PULSION Medical Systems AG"  },
    { 0x2299, "BRAIN VISION SYSTEMS (BVS)"  },
    { 0x229A, "Control Express Finland OY"  },
    { 0x229B, "SFC Smart Fuel Cell AG"  },
    { 0x229C, "Raytheon Company"  },
    { 0x229D, "Solacia Inc."  },
    { 0x229E, "JV2R - MacWay"  },
    { 0x229F, "RRC power solutions GmbH"  },
    { 0x22A0, "Winpos System Co., Ltd."  },
    { 0x22A1, "Shenzhen Jiuzhou Electric Co., Ltd."  },
    { 0x22A2, "Disruptive Ltd."  },
    { 0x22A3, "DexCom"  },
    { 0x22A4, "InnoComm Mobile Technology Corp."  },
    { 0x22A5, "Yu Jeong System Co., Ltd."  },
    { 0x22A6, "Pie Digital, Inc."  },
    { 0x22A7, "Fortinet, Inc."  },
    { 0x22A8, "OTTO"  },
    { 0x22A9, "Valor Communication, Inc."  },
    { 0x22AA, "AppliedMicro"  },
    { 0x22AB, "Trigence Semiconductor, Inc."  },
    { 0x22AC, "Sensor Switch, Inc."  },
    { 0x22AD, "DCP Microdevelopments Limited"  },
    { 0x22AE, "Buerkert Werke GmbH"  },
    { 0x22AF, "JW Fishers Mfg."  },
    { 0x22B0, "Business Security OL AB"  },
    { 0x22B1, "Secret Labs LLC"  },
    { 0x22B2, "EDGE Tech Corp."  },
    { 0x22B3, "SOMFY"  },
    { 0x22B4, "NIPPON ANTENNA Co., Ltd."  },
    { 0x22B5, "Thyracont Vacuum Instruments GmbH"  },
    { 0x22B6, "IMTRADEX Hoer-/Sprechsysteme GmbH"  },
    { 0x22B7, "Unjo AB"  },
    { 0x22B8, "Motorola Mobility Inc."  },
    { 0x22B9, "eTurboTouch Technology Inc."  },
    { 0x22BA, "Technology Innovation Holdings Ltd."  },
    { 0x22BB, "Saris Cycling Group"  },
    { 0x22BC, "OPWILL Technologies (Beijing) Co., Ltd."  },
    { 0x22BD, "Basis Software, Inc."  },
    { 0x22BE, "Cheetah-Medical Ltd."  },
    { 0x22BF, "Bit Cauldron Corporation"  },
    { 0x22C0, "ReLia Diagnostic Systems, Inc."  },
    { 0x22C1, "ATEK Products, LLC"  },
    { 0x22C2, "Fast And Safe Technology Co., Ltd."  },
    { 0x22C3, "Tsinghua Tongfang Co., Ltd."  },
    { 0x22C4, "Fresenius Medical Care Deutschland GmbH"  },
    { 0x22C5, "Himax Technologies, Inc."  },
    { 0x22C6, "Baker Hughes Production Quest"  },
    { 0x22C7, "MEMUP"  },
    { 0x22C8, "Shenzhen Xinerchang Electronics Co., Ltd."  },
    { 0x22C9, "StepOver GmbH"  },
    { 0x22CA, "Amimon Ltd."  },
    { 0x22CB, "Forware Spain S.L."  },
    { 0x22CC, "LAONEX CO., LTD."  },
    { 0x22CD, "Kinova"  },
    { 0x22CE, "Metters Industries"  },
    { 0x22CF, "Marquess Co., Limited"  },
    { 0x22D0, "Norsonic AS"  },
    { 0x22D1, "ZeitControl GmbH"  },
    { 0x22D2, "ZETT OPTICS GmbH"  },
    { 0x22D3, "FAAC SpA"  },
    { 0x22D4, "Laview Technology Ltd."  },
    { 0x22D5, "Yellow Soft Co., Ltd."  },
    { 0x22D6, "Numatic International Ltd."  },
    { 0x22D7, "IntelliTech International, Inc."  },
    { 0x22D8, "Shantery Co., Ltd."  },
    { 0x22D9, "GuangDong OPPO Mobile Telecommunications Corp., Ltd."  },
    { 0x22DA, "TXTR GmbH"  },
    { 0x22DB, "Phase One A/S"  },
    { 0x22DC, "TILERA CORPORATION"  },
    { 0x22DD, "Kawasaki Heavy Industries, Ltd."  },
    { 0x22DE, "WeTelecom"  },
    { 0x22DF, "Medicom-MTD"  },
    { 0x22E0, "Secunet Security Networks AG"  },
    { 0x22E1, "TempoTec Corp"  },
    { 0x22E2, "IDEA!"  },
    { 0x22E3, "Escort, Inc."  },
    { 0x22E4, "Shenyang Tongzhen Precision Electronic Technology Co."  },
    { 0x22E5, "Mine Safety Appliances Co."  },
    { 0x22E6, "Labo America, Inc."  },
    { 0x22E7, "ZAFFER BVBA"  },
    { 0x22E8, "Audio Partnership"  },
    { 0x22E9, "Orion Diagnostica OY"  },
    { 0x22EA, "Bit Trade One, Ltd."  },
    { 0x22EB, "Vizimax Inc."  },
    { 0x22EC, "Kozio, Inc."  },
    { 0x22ED, "HannStar Display Corp."  },
    { 0x22EE, "Struers A/S"  },
    { 0x22EF, "Edutor Technologies India Private Limited"  },
    { 0x22F0, "Allen + Heath Ltd."  },
    { 0x22F1, "DATEQ BV"  },
    { 0x22F2, "Quest Payment Systems"  },
    { 0x22F3, "Zephyr Technology Corporation"  },
    { 0x22F4, "Olive Global Holding Pvt. Ltd."  },
    { 0x22F5, "oTHE Technology Inc."  },
    { 0x22F6, "Clear Pulse Co., Ltd."  },
    { 0x22F7, "Drivven, Inc."  },
    { 0x22F8, "Universal Sats Ltd."  },
    { 0x22F9, "Compass, s.r.l."  },
    { 0x22FA, "Sifteo Inc."  },
    { 0x22FB, "Beijing Chiplight IC Design Co., Ltd."  },
    { 0x22FC, "ModusLink Global Solutions, Inc."  },
    { 0x22FD, "Miltope Corp."  },
    { 0x22FE, "Protium Technologies, Inc."  },
    { 0x22FF, "Avnet"  },
    { 0x2300, "Nanjing Magon Opto-Electrical Science & Technology Co."  },
    { 0x2301, "Imaginant Inc."  },
    { 0x2302, "Rafael Advanced Defense Systems Ltd."  },
    { 0x2303, "Grosvenor Technology Ltd."  },
    { 0x2304, "Pinnacle"  },
    { 0x2305, "Lindemann Audiotechnik GmbH"  },
    { 0x2306, "Syba Multimedia, Inc."  },
    { 0x2307, "Madboy Audio International Oy"  },
    { 0x2308, "UV Networks, Inc."  },
    { 0x2309, "TimeLink Inc."  },
    { 0x230A, "Data Locker Inc."  },
    { 0x230B, "Shanda Interactive Entertainment Limited"  },
    { 0x230C, "GarTech Enterprises, Inc."  },
    { 0x230D, "Linktop Technology Co., Ltd."  },
    { 0x230E, "eDAQ Pty., Ltd."  },
    { 0x230F, "applause.elfmimi.jp"  },
    { 0x2310, "WCE, Inc."  },
    { 0x2311, "Francotyp-Postalia GmbH"  },
    { 0x2312, "Learning Curve Brands, Inc."  },
    { 0x2313, "Kunshan Jiahua Electronics Co., Ltd."  },
    { 0x2314, "INQ Mobile Limited"  },
    { 0x2315, "Avery Design Systems, Inc."  },
    { 0x2316, "DongGuan Potec Electric Industrial Co., Ltd."  },
    { 0x2317, "Huawei Device Co., Ltd."  },
    { 0x2318, "Solar Components LLC"  },
    { 0x2319, "Loewe Opta GmbH"  },
    { 0x231A, "SANWA KAGAKU KENKYUSHO CO., LTD."  },
    { 0x231B, "winner story Co., Ltd."  },
    { 0x231C, "SONUUS LIMITED"  },
    { 0x231D, "Fervian Technologies Limited"  },
    { 0x231E, "Chongqing CYIT Communication Technologies Co., Ltd."  },
    { 0x231F, "FandF Co., Ltd."  },
    { 0x2320, "Redring AB"  },
    { 0x2321, "iKingdom Corp. (d.b.a. iConnectivity)"  },
    { 0x2322, "RichWave Technology Corp."  },
    { 0x2323, "EFI TECHNOLOGY s.r.l."  },
    { 0x2324, "Ubisense Limited"  },
    { 0x2325, "Simbex"  },
    { 0x2326, "CKM Electronics Co., Ltd."  },
    { 0x2327, "DreamSecurity"  },
    { 0x2328, "Radio Systems Corporation"  },
    { 0x2329, "Infinite Technologies JLT"  },
    { 0x232A, "Skalar Analytical b.v."  },
    { 0x232B, "Zhuhai Pantum Technology Co., Ltd."  },
    { 0x232C, "Digital Lumens"  },
    { 0x232D, "Edinburgh Instruments Ltd."  },
    { 0x232E, "EA, Elektro-Automatik GmbH & Co. KG"  },
    { 0x232F, "Motic China Group Co., Ltd."  },
    { 0x2330, "Tensorcom, Inc."  },
    { 0x2331, "PUZZLE LOGIC INC."  },
    { 0x2332, "Coges S.p.A."  },
    { 0x2333, "Zamzee Co."  },
    { 0x2334, "Opticos srl"  },
    { 0x2335, "Personable Inc."  },
    { 0x2336, "Vix Technology (Aust) Ltd."  },
    { 0x2337, "linked IP GmbH"  },
    { 0x2338, "RedE Innovations"  },
    { 0x2339, "Sierra Nevada Corporation"  },
    { 0x233A, "Telpar"  },
    { 0x233B, "taberna pro medicum GmbH"  },
    { 0x233C, "Julabo"  },
    { 0x233D, "Microtech System"  },
    { 0x233E, "Aastra Telecom Inc."  },
    { 0x233F, "Stage Tec GmbH"  },
    { 0x2340, "Teleepoch Limited"  },
    { 0x2341, "Arduino, LLC"  },
    { 0x2342, "nextEDGE Technology, K.K."  },
    { 0x2343, "AquaScan A/S"  },
    { 0x2344, "HAMBURG INDUSTRIES CO., LTD."  },
    { 0x2345, "ZOWIE GEAR"  },
    { 0x2346, "Data Transfer & Communications Ltd."  },
    { 0x2347, "iControl Networks"  },
    { 0x2348, "Ubisys Technology"  },
    { 0x2349, "P2 Engineering Group, LLC"  },
    { 0x234A, "Cypress Technology Co., Ltd."  },
    { 0x234B, "Free Software Initiative of Japan"  },
    { 0x234C, "Zenverge Inc."  },
    { 0x234D, "Skype Inc."  },
    { 0x234E, "Anewin"  },
    { 0x234F, "VaniOs Consulting"  },
    { 0x2350, "ZiiLABS Pte. Ltd."  },
    { 0x2351, "EmbCodeAB"  },
    { 0x2352, "SKYTEX Technology Inc."  },
    { 0x2353, "PHiON Technology Inc."  },
    { 0x2354, "BirdBrain Technologies LLC"  },
    { 0x2355, "Pacific Northwest National Laboratory (PNNL)"  },
    { 0x2356, "Grid Connect Inc."  },
    { 0x2357, "TP-LINK Technologies Co., Ltd."  },
    { 0x2358, "Greenconn Corporation"  },
    { 0x2359, "Shenzhen Autone-Tronic Technology Co., Ltd."  },
    { 0x235A, "Top Yang Technology Enterprise Co., Ltd."  },
    { 0x235B, "KangXiang Electronic Co., Ltd."  },
    { 0x235C, "Neuralieve"  },
    { 0x235D, "Wavepod Technologies LLC"  },
    { 0x235E, "Sage Electronic Engineering LLC"  },
    { 0x235F, "Delux Technology Co., Ltd."  },
    { 0x2360, "AudioProbe Inc."  },
    { 0x2361, "Artiza Networks, Inc."  },
    { 0x2362, "Intuity Medical"  },
    { 0x2363, "SplitFish Ltd."  },
    { 0x2364, "Friedrich Leutert GmbH & Co. KG"  },
    { 0x2365, "Midwest Microwave Solutions"  },
    { 0x2366, "Bitmanufaktur GmbH"  },
    { 0x2367, "Teenage Engineering"  },
    { 0x2368, "Peterson Electro-Musical Products, Inc."  },
    { 0x2369, "Telspan Data, LLC"  },
    { 0x236A, "SiBEAM, Inc."  },
    { 0x236B, "Era Optoelectronics Inc."  },
    { 0x236C, "ZheJiang Chunsheng Electronics Co., Ltd."  },
    { 0x236D, "e-supplies Co., Ltd."  },
    { 0x236E, "Idex ASA"  },
    { 0x236F, "Risun Electric Information Technology Co., Ltd."  },
    { 0x2370, "Vlatacom d.o.o."  },
    { 0x2371, "Zetron, Inc."  },
    { 0x2372, "Shenzhen Techaser Technologies Co., Ltd."  },
    { 0x2373, "Pumatronix Equipamentos Eletronicos Ltda."  },
    { 0x2374, "Codan Limited"  },
    { 0x2375, "Nexell Co., Ltd."  },
    { 0x2376, "Realfiction Aps"  },
    { 0x2377, "Musa srl"  },
    { 0x2378, "OnLive, INC."  },
    { 0x2379, "Geotechnical Instruments (UK) Ltd."  },
    { 0x237A, "Danatronics, Corp."  },
    { 0x237B, "YUKAI Engineering"  },
    { 0x237C, "POWERVAR"  },
    { 0x237D, "CradlePoint, Inc."  },
    { 0x237E, "Ernie Ball, Inc."  },
    { 0x237F, "He Shan World Fair Electronics Technology Ltd."  },
    { 0x2380, "Law Enforcement Associates, Inc."  },
    { 0x2381, "IPE Music"  },
    { 0x2382, "Trigaudio, Inc."  },
    { 0x2383, "Super Pioneer Co., Ltd."  },
    { 0x2384, "Tamara Electronics Design"  },
    { 0x2385, "Booyco Electronics (Pty) Ltd."  },
    { 0x2386, "Raydium Semiconductor Corporation"  },
    { 0x2387, "N&S Services, Inc. dba XIM Technologies"  },
    { 0x2388, "High Density Devices"  },
    { 0x2389, "ShenZhen Handin Tech Co., Ltd."  },
    { 0x238A, "ASAHI SANGYO CO., LTD."  },
    { 0x238B, "Hytera Communications Co., Ltd."  },
    { 0x238C, "Japan Care Net Service Corporation"  },
    { 0x238D, "OMNIO Corporation"  },
    { 0x238E, "Xtralis"  },
    { 0x238F, "TRS Star GmbH"  },
    { 0x2390, "Triex Technologies, Inc."  },
    { 0x2391, "FUKUDA CO., LTD."  },
    { 0x2392, "Deltatee Enterprises Ltd."  },
    { 0x2393, "WonATech Co., Ltd."  },
    { 0x2394, "J.MORITA MFG. CORP."  },
    { 0x2395, "CNOGA MEDICAL LTD."  },
    { 0x2396, "Advanced Multi Tech Pte. Ltd."  },
    { 0x2397, "Simaudio Ltd."  },
    { 0x2398, "Bluetechnix"  },
    { 0x2399, "Lightwares"  },
    { 0x239A, "Adafruit Industries LLC"  },
    { 0x239B, "TZ Medical, Inc."  },
    { 0x239C, "Braebon Medical Corporation"  },
    { 0x239D, "Memjet Labels, Inc."  },
    { 0x239E, "Rubin Informatikai Zrt."  },
    { 0x239F, "Nikola Engineering Inc."  },
    { 0x23A0, "BIFIT"  },
    { 0x23A1, "Pepperl+Fuchs GmbH"  },
    { 0x23A2, "Mobile Peak Holdings, Ltd."  },
    { 0x23A3, "Dongguan City ShengJing Electronics Co., Ltd."  },
    { 0x23A4, "MINGTECH CHINA CO., LTD."  },
    { 0x23A5, "Instytut Fotonowy Sp. Z o.o."  },
    { 0x23A6, "Tronical Components GmbH"  },
    { 0x23A7, "System In Frontier Inc."  },
    { 0x23A8, "Sagio A/S"  },
    { 0x23A9, "SiliconGo Microelectronics Inc."  },
    { 0x23AA, "DOK (HK) Trading Limited"  },
    { 0x23AB, "SZZT ELECTRONICS CO., LTD"  },
    { 0x23AC, "Marunix Electron Limited"  },
    { 0x23AD, "voxeljet technology GmbH"  },
    { 0x23AE, "DIGITAL DEVICES UG"  },
    { 0x23AF, "iOWA AB"  },
    { 0x23B0, "Seniorsoft Development Co., Ltd."  },
    { 0x23B1, "Riken Keiki Co., Ltd."  },
    { 0x23B2, "SEER Technology, Inc."  },
    { 0x23B3, "Straubtec GmbH & Co. KG"  },
    { 0x23B4, "Dental Wings Inc."  },
    { 0x23B5, "Crowcon Detection Instruments Limited"  },
    { 0x23B6, "FULL ELECTRONIC system"  },
    { 0x23B7, "Isca Networks"  },
    { 0x23B8, "Daruma Telecomunicacoes e Informatica S/A"  },
    { 0x23B9, "Green Energy Options Ltd."  },
    { 0x23BA, "Playback Designs LLC"  },
    { 0x23BB, "EMI STOP CORP."  },
    { 0x23BC, "ARIDIAN TECHNOLOGY COMPANY INC."  },
    { 0x23BD, "Musashi Engineering, Inc."  },
    { 0x23BE, "Raynet Technologies Pte. Ltd."  },
    { 0x23BF, "Environics Oy"  },
    { 0x23C0, "Kotec"  },
    { 0x23C1, "MakerBot Industries"  },
    { 0x23C2, "CREALOGIX E-Banking AG"  },
    { 0x23C3, "Cydle Corp."  },
    { 0x23C4, "Media Engineering"  },
    { 0x23C5, "Promega Corporation"  },
    { 0x23C6, "plawa-feinwerktechnik GmbH & Co. KG"  },
    { 0x23C7, "GCI Technologies Corp."  },
    { 0x23C8, "IML Ltd."  },
    { 0x23C9, "IRM Touch Inc."  },
    { 0x23CA, "IHP GmbH Innovations for High Performance Microelectro"  },
    { 0x23CB, "Point Core SARL"  },
    { 0x23CC, "Avitech International Corp."  },
    { 0x23CD, "Avconn Precise Connector Co., Ltd."  },
    { 0x23CE, "Gembird Electronics Ltd."  },
    { 0x23CF, "Admesy BV"  },
    { 0x23D0, "Youjie"  },
    { 0x23D1, "LUFFT Mess-und Regeltechnik GmbH"  },
    { 0x23D2, "WEAVERSMIND Inc."  },
    { 0x23D3, "RFTECH SRL"  },
    { 0x23D4, "ALLTRAX, Inc."  },
    { 0x23D5, "SerialTek"  },
    { 0x23D6, "DONGGUAN LICHENG ELECTRONICS CO., LTD."  },
    { 0x23D7, "PENNYWISE PERIPHERALS PTY. LTD."  },
    { 0x23D8, "CREATOR (CHINA) TECH CO., LTD."  },
    { 0x23D9, "SIGLEAD Inc."  },
    { 0x23DA, "THK Co., Ltd."  },
    { 0x23DB, "Sonicweld"  },
    { 0x23DC, "Phonic Ear, Inc. Frontrow Division"  },
    { 0x23DD, "Ningbo Sunny Opotech Co., Ltd."  },
    { 0x23DE, "ZAO Papillon"  },
    { 0x23DF, "WebAthletics BV"  },
    { 0x23E0, "BitifEye Digital Test Solutions GmbH"  },
    { 0x23E1, "Vidyo, Inc."  },
    { 0x23E2, "Shape Medical Systems, Inc."  },
    { 0x23E3, "Christie Digital Systems Canada Inc."  },
    { 0x23E4, "General Microsystems Sdn Bhd"  },
    { 0x23E5, "Antelope Audio"  },
    { 0x23E6, "DIGIT MOBILE INC."  },
    { 0x23E7, "ROGER Dariusz Wensker Grzegorz Wensker S.P.j."  },
    { 0x23E8, "Propellerhead Software AB"  },
    { 0x23E9, "Peregrine Technology Co., Ltd."  },
    { 0x23EA, "Inputek"  },
    { 0x23EB, "TOPPAN FORMS CO., LTD."  },
    { 0x23EC, "Alacer Biomedica Industria Eletronica Ltda."  },
    { 0x23ED, "Optomotive, mehatronika d.o.o."  },
    { 0x23EE, "Sofird, Inc."  },
    { 0x23EF, "PPHU AWEX RAFAL STANUCH"  },
    { 0x23F0, "Ecotronics Limited"  },
    { 0x23F1, "WIMM Labs"  },
    { 0x23F2, "Northern Digital Inc."  },
    { 0x23F3, "Funke Digital TV"  },
    { 0x23F4, "NXT Plc"  },
    { 0x23F5, "Speed Conn Electronics (Shenzhen) Co., Ltd."  },
    { 0x23F6, "Gamesman Ltd."  },
    { 0x23F7, "TechRhythm, Inc."  },
    { 0x23F8, "Xiangde Electronic Technologies (Shenzhen) Co., Ltd."  },
    { 0x23F9, "RT Systems (Pty) Ltd."  },
    { 0x23FA, "DJO, LLC"  },
    { 0x23FB, "Janich & Klass Computertechnik GmbH"  },
    { 0x23FC, "SesKion GmbH"  },
    { 0x23FD, "AWare, Inc."  },
    { 0x23FE, "Express Way Limited"  },
    { 0x23FF, "UIworks Electronics"  },
    { 0x2400, "Shenzhen Chuangyitong Technology Co., Ltd"  },
    { 0x2401, "Deltronic Labs"  },
    { 0x2402, "DA FACT"  },
    { 0x2403, "XTRAMUS TECHNOLOGIES"  },
    { 0x2404, "GE MDS"  },
    { 0x2405, "Custom Computer Services, Inc."  },
    { 0x2406, "WIseKey"  },
    { 0x2407, "Incasolution Co., Ltd."  },
    { 0x2408, "Catalyst Enterprises, Inc."  },
    { 0x2409, "BCInet, Inc."  },
    { 0x240A, "Infron Teknolojik Sistemleri San. Ve Tic. Ltd. STI"  },
    { 0x240B, "Kawamura Electric, Inc."  },
    { 0x240C, "Maples Micro System Corp"  },
    { 0x240D, "Chinachip Technology Limited"  },
    { 0x240E, "JEFF ROWLAND DESIGN GROUP, INC"  },
    { 0x240F, "Trantek Electronics Co., Ltd."  },
    { 0x2410, "Tenebraex Corp."  },
    { 0x2411, "Industrial Scientific Oldham SAS"  },
    { 0x2412, "Invision Biometrics Ltd."  },
    { 0x2413, "Skyviia Corporation"  },
    { 0x2414, "Leopold Kostal GmbH & Co. KG"  },
    { 0x2415, "CipherLab Co., Ltd."  },
    { 0x2416, "FUTURE DESIGNS, INC."  },
    { 0x2417, "INIT GmbH"  },
    { 0x2418, "Irphotonics"  },
    { 0x2419, "Shenzhen Dnine Technology Co., Ltd."  },
    { 0x241A, "The Silanna Group Pty. Ltd."  },
    { 0x241B, "Dongguan City Qirui Electronics Co., Ltd."  },
    { 0x241C, "ATMOS Medizin Technik GmbH & Co. KG"  },
    { 0x241D, "Redbird Flight Simulations, Inc."  },
    { 0x241E, "SHENZHEN FUNDUN TECHNOLOGY CO., LTD."  },
    { 0x241F, "Global Geo Supplies, Inc."  },
    { 0x2420, "M Seven System Limited"  },
    { 0x2421, "Anasphere, Inc."  },
    { 0x2422, "Tom Communication Industrial Co., Ltd."  },
    { 0x2423, "Bio-Med Devices Inc."  },
    { 0x2424, "CREATZ Inc."  },
    { 0x2425, "PIQX Imaging Pte. Ltd."  },
    { 0x2426, "Johnson Controls, Inc. - Building Efficiency Business"  },
    { 0x2427, "Winkelmann UK Ltd."  },
    { 0x2428, "SANTEC CORPORATION"  },
    { 0x2429, "IWSCOPE Inc."  },
    { 0x242A, "HUR OY"  },
    { 0x242B, "Philips Healthcare"  },
    { 0x242C, "ARMSTEL, Inc."  },
    { 0x242D, "Flastar Technology Co., Ltd."  },
    { 0x242E, "Vossloh-Schwabe Deutschland GmbH"  },
    { 0x242F, "GPH Co., Ltd."  },
    { 0x2430, "APE GmbH"  },
    { 0x2431, "Yamazaki Co., Ltd."  },
    { 0x2432, "Ceton Corp."  },
    { 0x2433, "Asetek A/S"  },
    { 0x2434, "NOVA electronics, Inc."  },
    { 0x2435, "PAKSENSE, INC."  },
    { 0x2436, "MediTECH Electronic GmbH"  },
    { 0x2437, "NIKETECH ELECTRONICS GROUP LIMITED"  },
    { 0x2438, "Innopower Technology Corporation"  },
    { 0x2439, "Comex Electronics AB"  },
    { 0x243A, "Mobile Devices Ingenierie"  },
    { 0x243B, "OTAX Electronics (ShenZhen) Co., Ltd."  },
    { 0x243C, "DiZiC Co., Ltd."  },
    { 0x243D, "emz - Hanauer GmbH & Co KGaA"  },
    { 0x243E, "Savi Elettronica srl"  },
    { 0x243F, "Photonic GesmbH & Co. KG"  },
    { 0x2440, "RB GeneralEkonomik"  },
    { 0x2441, "TV One"  },
    { 0x2442, "University of Central Florida"  },
    { 0x2443, "Aessent Technology Ltd."  },
    { 0x2444, "NetModule AG"  },
    { 0x2445, "TOMY Company, Ltd."  },
    { 0x2446, "Avionics Interface Technologies"  },
    { 0x2447, "Knick Elektronische Messgerate GmbH & Co. KG"  },
    { 0x2448, "Winterhalter GmbH"  },
    { 0x2449, "SHAEFER GmbH"  },
    { 0x244A, "Onzo Ltd."  },
    { 0x244B, "Applied Technical Systems"  },
    { 0x244C, "MinebeaMitsumi Inc."  },
    { 0x244D, "Pantec Biosolutions AG"  },
    { 0x244E, "ShopGuard Ltd."  },
    { 0x244F, "iWall A/S"  },
    { 0x2450, "Boule Medical AB"  },
    { 0x2451, "AEM Performance Electronics"  },
    { 0x2452, "Speeder Electronics Co., Ltd."  },
    { 0x2453, "BAANTO"  },
    { 0x2454, "Velosti Technology Limited"  },
    { 0x2455, "Anton/Bauer, Inc."  },
    { 0x2456, "CKD NIKKI DENSO CO., LTD"  },
    { 0x2457, "Alcomp. Inc."  },
    { 0x2458, "Bluegiga Technologies Oy"  },
    { 0x2459, "Secure Holdings Limited"  },
    { 0x245A, "KONDOH SEISAKUSHO Co., Ltd."  },
    { 0x245B, "Zixsys Inc."  },
    { 0x245C, "Steinbauer Electronics GmbH"  },
    { 0x245D, "ID Technologies"  },
    { 0x245E, "LNT - Automation GmbH"  },
    { 0x245F, "Chord Electronics Limited"  },
    { 0x2460, "NELS, Ltd."  },
    { 0x2461, "Beam Communications"  },
    { 0x2462, "IDENTICA S.A."  },
    { 0x2463, "BAP Precision Ltd."  },
    { 0x2464, "Nestlabs"  },
    { 0x2465, "Microsoft Surface Hub"  },
    { 0x2466, "Fractal Audio Systems, LLC"  },
    { 0x2467, "Nektar Technology, Inc."  },
    { 0x2468, "New Cosmos Electric Co., Ltd."  },
    { 0x2469, "Gloria Music Corp."  },
    { 0x246A, "UNH Interoperability Laboratory"  },
    { 0x246B, "Perfect Fortune Electric Wire & Cable (ShenZhen) Co. Ltd."  },
    { 0x246C, "Shanghai Fudan Microelectronics Co., Ltd."  },
    { 0x246D, "TrackMan A/S"  },
    { 0x246E, "Movinto Fun AB"  },
    { 0x246F, "STORK PRINTS AUSTRIA GmbH"  },
    { 0x2470, "Hale Microsystems"  },
    { 0x2471, "Bloonn Srl"  },
    { 0x2472, "Bossa Nova Robotics, Inc."  },
    { 0x2473, "Trend Control Systems Limited"  },
    { 0x2474, "Stamps.com"  },
    { 0x2475, "JCM American Corporation"  },
    { 0x2476, "Yost Engineering Inc."  },
    { 0x2477, "UbiVelox"  },
    { 0x2478, "Sonix Technology (Shenzhen) Co., Ltd."  },
    { 0x2479, "smartek d.o.o."  },
    { 0x247A, "Suzhou Jutze Technologies Co., Ltd"  },
    { 0x247B, "Digibras Industria do Brasil S.A"  },
    { 0x247C, "Fullconn Industry Inc."  },
    { 0x247D, "JARGY CO. LTD."  },
    { 0x247E, "GEWA music GmbH"  },
    { 0x247F, "Lynx Studio Technology, Inc."  },
    { 0x2480, "Omniware Inc."  },
    { 0x2481, "Shenzhen SKY DRAGON Audio-Video Technology Co., Ltd."  },
    { 0x2482, "SmartRoom LLC"  },
    { 0x2483, "Valups Corp."  },
    { 0x2484, "Unipolar Optics-Electrical Technology Co., Ltd."  },
    { 0x2485, "Dream SAS"  },
    { 0x2486, "DCG Systems, Inc."  },
    { 0x2487, "SHANGHAI VEI SHENG AUTO PARTS MANUFACTURING CO., LTD."  },
    { 0x2488, "SuperD Co., Ltd."  },
    { 0x2489, "Irvine Sensors Corporation"  },
    { 0x248A, "TeLink Semiconductor (Shanghai) Co., Ltd."  },
    { 0x248B, "DONGGUAN SYNCONN PRECISION INDUSTRY CO. LTD."  },
    { 0x248C, "Avicenna Instruments, LLC"  },
    { 0x248D, "Digital Matter Pty Ltd."  },
    { 0x248E, "Pulsar Informatics, Inc."  },
    { 0x248F, "HMS Industrial Networks AB"  },
    { 0x2490, "Zealtek electronic Co. Ltd."  },
    { 0x2491, "OBSERVATOR instruments b.v."  },
    { 0x2492, "Mofiria Corporation"  },
    { 0x2493, "Sensolutions Inc."  },
    { 0x2494, "Invoxia"  },
    { 0x2495, "Summit Semiconductor LLC"  },
    { 0x2496, "Dongguan DaTang Industrial Investment Co., Ltd."  },
    { 0x2497, "HyunWoo Electronics Co., Ltd."  },
    { 0x2498, "Aurora SFC Systems, Inc."  },
    { 0x2499, "Governors America Corp."  },
    { 0x249A, "Anedio, LLC"  },
    { 0x249B, "Miller Electric Mfg. Co."  },
    { 0x249C, "M2TECH SRL"  },
    { 0x249D, "Ken-A-Vision Manufacturing Company, Inc."  },
    { 0x249E, "Tlab West Systems AB"  },
    { 0x249F, "ABC PCB Sarl"  },
    { 0x24A0, "VIMAR SPA"  },
    { 0x24A1, "AUTONICS Corporation"  },
    { 0x24A2, "SafeTech Ltd."  },
    { 0x24A3, "BioTillion, LLC"  },
    { 0x24A4, "Primare AB"  },
    { 0x24A5, "OWANDY"  },
    { 0x24A6, "Shenzhen Pangngai Industrial Co., Ltd."  },
    { 0x24A7, "PROMAX ELECTRONICA S.A."  },
    { 0x24A8, "Hermes electronic GmbH"  },
    { 0x24A9, "ASolid Technology Co., Ltd."  },
    { 0x24AA, "Wasatch Photonics"  },
    { 0x24AB, "IMERJ LTD."  },
    { 0x24AC, "ToMiTec GmbH"  },
    { 0x24AD, "embedded brains GmbH"  },
    { 0x24AE, "Shenzhen Rapoo Technology Co., Ltd."  },
    { 0x24AF, "Integrated Corporation"  },
    { 0x24B0, "Echometer Company"  },
    { 0x24B1, "SCR Engineers Ltd."  },
    { 0x24B2, "DelSys Inc."  },
    { 0x24B3, "Simbionix Ltd."  },
    { 0x24B4, "Leema Acoustics"  },
    { 0x24B5, "3C TEK CORP."  },
    { 0x24B6, "Shenzhen New-Conn International Co., Ltd."  },
    { 0x24B7, "Medical Equipment Europe GmbH"  },
    { 0x24B8, "DongGuan CJ TOUCH Electronic Co., Ltd."  },
    { 0x24B9, "Hoshin Electronics Co., Ltd."  },
    { 0x24BA, "PRADOTEC Corporation Sdn. Bhd."  },
    { 0x24BB, "SHANGHAI LIGHTSURFING INFORMATION TECHNOLOGY CO., LTD."  },
    { 0x24BC, "Sartorius AG"  },
    { 0x24BD, "Smart Solution"  },
    { 0x24BE, "Mutewatch AB"  },
    { 0x24BF, "NBS Payment Solutions, Inc."  },
    { 0x24C0, "Chaney Instrument Co."  },
    { 0x24C1, "Maction Technologies, Inc."  },
    { 0x24C2, "DiCon Fiberoptics, Inc."  },
    { 0x24C3, "Covaris, Inc."  },
    { 0x24C4, "CMITECH Co., Ltd."  },
    { 0x24C5, "HUINTECH"  },
    { 0x24C6, "Xbox 3rd Party Partners"  },
    { 0x24C7, "Laser Technology, Inc."  },
    { 0x24C8, "CHAPP INC."  },
    { 0x24C9, "Pilot Electronic (China) Ltd."  },
    { 0x24CA, "SMARTEH d.o.o."  },
    { 0x24CB, "Servotronix Motion Control Ltd."  },
    { 0x24CC, "JSB Tech Pte. Ltd."  },
    { 0x24CD, "Viking360.com LLC"  },
    { 0x24CE, "Shenzhen Deren Electronic Co., Ltd."  },
    { 0x24CF, "Lytro, Inc."  },
    { 0x24D0, "Smith Micro Software, Inc."  },
    { 0x24D1, "POS & Solution Company"  },
    { 0x24D2, "DADT Holdings, LLC"  },
    { 0x24D3, "Lexking Technology Co., Ltd."  },
    { 0x24D4, "KOMATSU ELECTRONIC CO., LTD."  },
    { 0x24D5, "SATEL Ltd."  },
    { 0x24D6, "Develer S.r.l."  },
    { 0x24D7, "ACORDE TECHNOLOGIES"  },
    { 0x24D8, "Pittway Tecnologica Srl"  },
    { 0x24D9, "Unfors Instruments AB"  },
    { 0x24DA, "KYOCERA ELCO Korea Co., Ltd."  },
    { 0x24DB, "DDUSB Technology"  },
    { 0x24DC, "Aladdin Software Security R.D."  },
    { 0x24DD, "Kingspan Environmental Ltd."  },
    { 0x24DE, "Navicron"  },
    { 0x24DF, "ALGO System. Co"  },
    { 0x24E0, "Yoctopuce Sarl"  },
    { 0x24E1, "Paratronic S.A."  },
    { 0x24E2, "Digital Information Technology Studies (Shenzhen) Ltd."  },
    { 0x24E3, "Beijing TianYu Communication Equipment Co., Ltd."  },
    { 0x24E4, "Bytec Group Limited"  },
    { 0x24E5, "Lanmark Controls Inc."  },
    { 0x24E6, "ACI Analytical Control Instruments GmbH"  },
    { 0x24E7, "maxon motor ag"  },
    { 0x24E8, "ivee"  },
    { 0x24E9, "Microelectronics Technology Inc."  },
    { 0x24EA, "ZEBEX INDUSTRIES INC."  },
    { 0x24EB, "SHENZHEN PCTX TECHNOLOGY DEVELOPMENT CO., LTD."  },
    { 0x24EC, "CE-Infosys GmbH"  },
    { 0x24ED, "ZEN FACTORY GROUP (ASIA) LTD."  },
    { 0x24EE, "A C S Co., Ltd."  },
    { 0x24EF, "DATONG PLC"  },
    { 0x24F0, "Das Keyboard - Metadot"  },
    { 0x24F1, "Silicon Communication Technology"  },
    { 0x24F2, "Secure Electrans LTD."  },
    { 0x24F3, "MartinLogan Ltd."  },
    { 0x24F4, "Mind Media BV"  },
    { 0x24F5, "QRS Diagnostic"  },
    { 0x24F6, "Aplix IP Holdings Corporation"  },
    { 0x24F7, "Seneye Ltd."  },
    { 0x24F8, "Bang & Olufsen A/S"  },
    { 0x24F9, "TOSHIBA MITSUBISHI-ELECTRIC INDUSTRIAL SYSTEMS CORP."  },
    { 0x24FA, "Vectronix AG"  },
    { 0x24FB, "GTECH Corporation"  },
    { 0x24FC, "GPEG International"  },
    { 0x24FD, "Nichiyu Giken Kogyo Co., Ltd."  },
    { 0x24FE, "GOMETRICS, S.L."  },
    { 0x24FF, "Acroname Inc."  },
    { 0x2500, "Ettus Research LLC"  },
    { 0x2501, "Bridge Publications, Inc."  },
    { 0x2502, "Canadian Automotive Instruments Ltd."  },
    { 0x2503, "Kurth Electronic GmbH"  },
    { 0x2504, "Nemic Lambda Ltd."  },
    { 0x2505, "Xiroku Accupoint Technology Inc."  },
    { 0x2506, "Hind Technology Group"  },
    { 0x2507, "Advion BioSystems"  },
    { 0x2508, "Symplex Communications, Inc."  },
    { 0x2509, "Chain-In Electronic Co., Ltd."  },
    { 0x250A, "H-Squared"  },
    { 0x250B, "Nautilus Lifeline Ltd."  },
    { 0x250C, "PHX Inc."  },
    { 0x250D, "Alstom Grid SAS"  },
    { 0x250E, "Beijing MOPS Technology Co., Ltd."  },
    { 0x250F, "itplants ltd."  },
    { 0x2510, "SE Elektronische Systeme"  },
    { 0x2511, "Morita Tech Co., Ltd."  },
    { 0x2512, "RNDPLUS Co., Ltd."  },
    { 0x2513, "RMI Laser, LLC"  },
    { 0x2514, "Fullpower Technologies"  },
    { 0x2515, "AMITEK"  },
    { 0x2516, "Cooler Master Co., Ltd."  },
    { 0x2517, "Marel EHF"  },
    { 0x2518, "Anite Telecoms Inc."  },
    { 0x2519, "n-gineric gmbh"  },
    { 0x251A, "Daiichi Electronics"  },
    { 0x251B, "Stable Imaging Solutions, LLC"  },
    { 0x251C, "snom technology AG"  },
    { 0x251D, "Fortebio Inc."  },
    { 0x251E, "Polara Engineering, Inc."  },
    { 0x251F, "Golden Emperor International Ltd."  },
    { 0x2520, "ANA-U GmbH"  },
    { 0x2521, "Fundacion Tekniker"  },
    { 0x2522, "Light Harmonic"  },
    { 0x2523, "Recon Instruments Inc."  },
    { 0x2524, "CVRx"  },
    { 0x2525, "Barron McCann Technology Ltd."  },
    { 0x2526, "Weide Electronics Co., Ltd."  },
    { 0x2527, "Software Bisque, Inc."  },
    { 0x2528, "BittWare Inc."  },
    { 0x2529, "SUZHOU XINYA ELECTRIC COMMUNICATION CO., LTD."  },
    { 0x252A, "SUZHOU KELI TECHNOLOGY DEVELOPMENT CO., LTD."  },
    { 0x252B, "TOP Exactitude Industry (ShenZhen) Co., Ltd."  },
    { 0x252C, "VIGO System S.A."  },
    { 0x252D, "Nokia Siemens Networks"  },
    { 0x252E, "Heliox Technologies, Inc."  },
    { 0x252F, "Pentronic AB"  },
    { 0x2530, "STT Emtec AB"  },
    { 0x2531, "Proteus Industries Inc."  },
    { 0x2532, "C.R.D.E. (Cahors Group)"  },
    { 0x2533, "Osaka Micro Computer, Inc."  },
    { 0x2534, "Russia's Institute of Radionavigation and Time"  },
    { 0x2535, "ShenZhen Hogend Precision Technology Co., Ltd."  },
    { 0x2536, "Ubisys Technology Co., Ltd."  },
    { 0x2537, "Norel Systems Ltd."  },
    { 0x2538, "Cochlear Ltd."  },
    { 0x2539, "Club Electronics"  },
    { 0x253A, "System Sacom Industry Corporation"  },
    { 0x253B, "RCF S.p.a."  },
    { 0x253C, "Tri-Tech Manufacturing Inc."  },
    { 0x253D, "Koss Corporation"  },
    { 0x253E, "Creative Product Design Pty., Ltd."  },
    { 0x253F, "ORANGE IT INC."  },
    { 0x2540, "Applied Materials"  },
    { 0x2541, "Shanghai AisinoChip Electronics Technology Co., Ltd."  },
    { 0x2542, "Ditron S.R.L."  },
    { 0x2543, "Spark Dental Technology Limited"  },
    { 0x2544, "Energy Micro AS"  },
    { 0x2545, "Digital Foci, Inc."  },
    { 0x2546, "Ravensburger Spieleverlag GmbH"  },
    { 0x2547, "YiDu Technology"  },
    { 0x2548, "Pulse-Eight Limited"  },
    { 0x2549, "Librestream Technologies"  },
    { 0x254A, "Enegate Co., Ltd."  },
    { 0x254B, "Toy Toy Toy Ltd."  },
    { 0x254C, "X6D Limited"  },
    { 0x254D, "ICAR VISION SYSTEMS S.L."  },
    { 0x254E, "SHF Communication Technologies AG"  },
    { 0x254F, "Jigeon Technologies Co., Ltd."  },
    { 0x2550, "Teledyne"  },
    { 0x2551, "A.E.B. Industriale S.r.l."  },
    { 0x2552, "Striiv, Inc."  },
    { 0x2553, "C8 MediSensor"  },
    { 0x2554, "ASSA ABLOY AB"  },
    { 0x2555, "Pulse Tracer, Inc."  },
    { 0x2556, "United Radio-Electronic Technologies Co., Ltd."  },
    { 0x2557, "Robatech AG"  },
    { 0x2558, "INTECH ELECTRONICS CORP."  },
    { 0x2559, "Jangus Music, Inc. (dba Wi Digital Systems)"  },
    { 0x255A, "TaiDoc Technology Corp."  },
    { 0x255B, "NDI Technologies, Inc."  },
    { 0x255C, "HOSIWELL TECHNOLOGY CO., LTD."  },
    { 0x255D, "ATEECS"  },
    { 0x255E, "Beijing Bonxeon Technology Co., Ltd."  },
    { 0x255F, "DORNIER-LTF GmbH"  },
    { 0x2560, "e-con Systems India Private Limited"  },
    { 0x2561, "Brookhaven Instruments Corp."  },
    { 0x2562, "SHENGZHEN MAYA ELECTRONICS CREATION CO. LTD."  },
    { 0x2563, "Shenzhen ShanWan Technology Co., Ltd."  },
    { 0x2564, "TESSERA TECHNOLOGY INC."  },
    { 0x2565, "Cyclone Industries Limited"  },
    { 0x2566, "Cryptera A/S"  },
    { 0x2567, "DongGuan LongTao Electronic Co., Ltd."  },
    { 0x2568, "ALL LINK CONN. TECHNOLOGY CORP."  },
    { 0x2569, "DongGuan City MingJi Electronics Co., Ltd."  },
    { 0x256A, "TAIAN TECHNOLOGY (WUXI) Co., Ltd."  },
    { 0x256B, "Perreaux Industries Ltd."  },
    { 0x256C, "GRAPHICS TECHNOLOGY (HK) CO., LIMITED"  },
    { 0x256D, "Compal Broadband Networks, Inc."  },
    { 0x256E, "Valuest Co., Ltd."  },
    { 0x256F, "3D CONNEXION SAM"  },
    { 0x2570, "AVID Technologies, Inc."  },
    { 0x2571, "CHIPMAST TECHNOLOGY CO., LTD."  },
    { 0x2572, "Vmarker"  },
    { 0x2573, "ESI Audiotechnik GmbH"  },
    { 0x2574, "AVer Information Inc."  },
    { 0x2575, "Weida Hi-Tech Co., Ltd."  },
    { 0x2576, "AFO Co., Ltd."  },
    { 0x2577, "LCDVF LLC"  },
    { 0x2578, "MPEC Technology Limited"  },
    { 0x2579, "Dongguan Wisechamp Electronic Co., Ltd."  },
    { 0x257A, "Shanghai Yuga Information Technology Co., Ltd."  },
    { 0x257B, "shenzhen dcard smart card tech. co., ltd."  },
    { 0x257C, "Richard Woehr GmbH"  },
    { 0x257D, "Panovel Technology Corporation"  },
    { 0x257E, "RFL Electronics Inc."  },
    { 0x257F, "8devices"  },
    { 0x2580, "DJ Techtools (Golden Sol Music LLC. Is Holding Co.)"  },
    { 0x2581, "Plug-up"  },
    { 0x2582, "Helmholz GmbH & Co. KG"  },
    { 0x2583, "VECTRUX DISTRIBUTORS LLC"  },
    { 0x2584, "COSMO CO., LTD."  },
    { 0x2585, "HomeChip Ltd."  },
    { 0x2586, "PLANET Technology Corporation"  },
    { 0x2587, "Ningbo Jiatang Electronic Co., Ltd."  },
    { 0x2588, "Infinitegra, Inc."  },
    { 0x2589, "Argon Technology Corporation"  },
    { 0x258A, "Sino Wealth Electronic Ltd."  },
    { 0x258B, "KORYO ELECTRONICS CO., LTD."  },
    { 0x258C, "Fastec Imaging Corporation"  },
    { 0x258D, "Sequans Communications"  },
    { 0x258E, "ENJsoft Co., Ltd."  },
    { 0x258F, "CME"  },
    { 0x2590, "MuChip Co., Ltd."  },
    { 0x2591, "Optimus Semiconductor Inc."  },
    { 0x2592, "Quest International"  },
    { 0x2593, "CELIZION, Inc."  },
    { 0x2594, "Acsys Technologies Ltd."  },
    { 0x2595, "SANYO DENKI CO., LTD."  },
    { 0x2596, "Twisted Melon Inc."  },
    { 0x2597, "Diagnostic Systems Associates Inc."  },
    { 0x2598, "Aerocrine"  },
    { 0x2599, "Q-tag AG"  },
    { 0x259A, "TriQuint Semiconductor"  },
    { 0x259B, "INUVIO"  },
    { 0x259C, "Immedia Semiconductor Inc."  },
    { 0x259D, "RCA DA AMAZONIA LTDA"  },
    { 0x259E, "American Messaging Services LLC"  },
    { 0x259F, "THERMO KING"  },
    { 0x25A0, "Ciegus Ltd."  },
    { 0x25A1, "Suitable Technologies, Inc."  },
    { 0x25A2, "LEMKE ENG."  },
    { 0x25A3, "Nanoteq (Pty) Ltd."  },
    { 0x25A4, "ALGOLTEK, INC."  },
    { 0x25A5, "Yakel Enterprises LLC"  },
    { 0x25A6, "AADI AS"  },
    { 0x25A7, "Beken Corporation"  },
    { 0x25A8, "Guangzhou Geoelectron Science & Technology Co., Ltd."  },
    { 0x25A9, "Advanced Bionics"  },
    { 0x25AA, "Top Victory Investments Ltd. (HK)"  },
    { 0x25AB, "Carmanah Signs"  },
    { 0x25AC, "PLIGG"  },
    { 0x25AD, "Aurora Networks, Inc."  },
    { 0x25AE, "OXIPULSE"  },
    { 0x25AF, "C&A Marketing"  },
    { 0x25B0, "Musical Fidelity"  },
    { 0x25B1, "Disc Soft Ltd."  },
    { 0x25B2, "DRS-RSTA, Inc."  },
    { 0x25B3, "DongGuan Elinke Industrial Co., Ltd."  },
    { 0x25B4, "Fairhaven Health"  },
    { 0x25B5, "FlatFrog Laboratories AB"  },
    { 0x25B6, "Fructel AB"  },
    { 0x25B7, "Neomitic Technologies S.A. de C.V."  },
    { 0x25B8, "Neutronics Inc."  },
    { 0x25B9, "Nujira Ltd."  },
    { 0x25BA, "WITec Wissenschaftliche Instrumente & Technologie GmbH"  },
    { 0x25BB, "Brunner Elektronik AG"  },
    { 0x25BC, "CETRTA POT"  },
    { 0x25BD, "TECHEYE SYSTEMS INC."  },
    { 0x25BE, "Infinite Z"  },
    { 0x25BF, "Elegant Invention"  },
    { 0x25C0, "Beyond Music Industrial Co., Ltd."  },
    { 0x25C1, "Vaddio"  },
    { 0x25C2, "Smith + Nephew Inc."  },
    { 0x25C3, "Phorus"  },
    { 0x25C4, "A & R Cambridge Ltd."  },
    { 0x25C5, "Securetec Detektions Systeme AG"  },
    { 0x25C6, "AVA Group A/S"  },
    { 0x25C7, "MEGATRON Elektronik AG & Co."  },
    { 0x25C8, "Visualplanet Ltd."  },
    { 0x25C9, "Proximiant"  },
    { 0x25CA, "Hovding Sverige AB"  },
    { 0x25CB, "ELZET80 Mikrocomputer Giesler & Danne GmbH & Co. KG"  },
    { 0x25CC, "NKC Co., Ltd."  },
    { 0x25CD, "Edwards Ltd."  },
    { 0x25CE, "MYTEK DIGITAL"  },
    { 0x25CF, "Corning Optical Communications LLC"  },
    { 0x25D0, "AeVee Laboratories LLC"  },
    { 0x25D1, "TOKAI-DENSHI Inc."  },
    { 0x25D2, "MRA Tek LLC"  },
    { 0x25D3, "Zhe Jiang Huasheng Technology Co., Ltd."  },
    { 0x25D4, "LOOPCOMM TECHNOLOGY, INC."  },
    { 0x25D5, "DATATON AB"  },
    { 0x25D6, "KOUZIRO Co., Ltd."  },
    { 0x25D7, "Audiomatica srl"  },
    { 0x25D8, "Serious Integrated, Inc."  },
    { 0x25D9, "Monarch Innovative Technologies Pvt. Ltd."  },
    { 0x25DA, "NETATMO"  },
    { 0x25DB, "Merrick Industries, Inc."  },
    { 0x25DC, "Cobolt AB"  },
    { 0x25DD, "bit4id srl"  },
    { 0x25DE, "Gasmet Technologies OY"  },
    { 0x25DF, "TTE Systems Ltd."  },
    { 0x25E0, "MULTIPLEX Modellsport GmbH & Co. KG"  },
    { 0x25E1, "Daimler AG"  },
    { 0x25E2, "Domain Surgical"  },
    { 0x25E3, "SCI Innovations Ltd."  },
    { 0x25E4, "AnaJet"  },
    { 0x25E5, "ALLFLEX EUROPE"  },
    { 0x25E6, "Digital Drilling Data Systems, LLC"  },
    { 0x25E7, "EIFELWERK Butler Systeme GmbH"  },
    { 0x25E8, "ATOLL Electronique"  },
    { 0x25E9, "Leybold Vacuum"  },
    { 0x25EA, "Aeroflex Weinschel"  },
    { 0x25EB, "Medical Intubation Technology Corp."  },
    { 0x25EC, "VELUX A/S"  },
    { 0x25ED, "Logic PD"  },
    { 0x25EE, "Mimoco"  },
    { 0x25EF, "BLITZ Co., Ltd."  },
    { 0x25F0, "GOODBETTERBEST Ltd."  },
    { 0x25F1, "Eden Innovations"  },
    { 0x25F2, "Dongguan Jinyue Electronics Co., Ltd."  },
    { 0x25F3, "Kicker"  },
    { 0x25F4, "ADVANSEE"  },
    { 0x25F5, "Lucas Holding bv"  },
    { 0x25F6, "SaferZone Co., Ltd."  },
    { 0x25F7, "Engineea Remote Technologies S.L."  },
    { 0x25F8, "Keypair Co., Ltd."  },
    { 0x25F9, "Donbass Soft Ltd. & Co. KG"  },
    { 0x25FA, "SoftEther Corporation"  },
    { 0x25FB, "RICOH IMAGING COMPANY, LTD."  },
    { 0x25FC, "RWA (Hong Kong) Limited"  },
    { 0x25FD, "Neuromonics Inc."  },
    { 0x25FE, "Providence Enterprise Limited"  },
    { 0x25FF, "Watermark Medical, Inc."  },
    { 0x2600, "SMARTCORE Inc."  },
    { 0x2601, "OFI Testing Equipment, Inc."  },
    { 0x2602, "Magenta Research Ltd."  },
    { 0x2603, "Swyx Solutions AG"  },
    { 0x2604, "Shenzhen Tenda Technology, Ltd."  },
    { 0x2605, "OSRAM SYLVANIA"  },
    { 0x2606, "O-Network Engineering AB"  },
    { 0x2607, "Prox Dynamics AS"  },
    { 0x2608, "OLHO tronic GmbH"  },
    { 0x2609, "FICOSA"  },
    { 0x260A, "SPEMOT AG"  },
    { 0x260B, "Schneider Electric Canada Inc. - Division of PCT"  },
    { 0x260C, "Saiko Systems Ltd."  },
    { 0x260D, "DongGuan Togran Electronic Co., Ltd."  },
    { 0x260E, "DongGuan HYX Industrial Co., Ltd."  },
    { 0x260F, "VITY"  },
    { 0x2610, "Egan Teamboard Inc."  },
    { 0x2611, "I.C.E. Co., Ltd."  },
    { 0x2612, "Crave Innovations"  },
    { 0x2613, "Gerd Bar GmbH"  },
    { 0x2614, "VMC Consulting Corporation"  },
    { 0x2615, "Gammaflux L.P."  },
    { 0x2616, "PS Audio"  },
    { 0x2617, "Front-End Technology, Inc."  },
    { 0x2618, "MicroGate Systems Ltd."  },
    { 0x2619, "Advanced Silicon SA"  },
    { 0x261A, "Shandong Synthesis Electronic Technology Co., Ltd."  },
    { 0x261B, "INTELLIGENT ENERGY, LTD."  },
    { 0x261C, "EISST Limited"  },
    { 0x261D, "Arkham Technology"  },
    { 0x261E, "IFAM GmbH Erfurt"  },
    { 0x261F, "Cooper Industries"  },
    { 0x2620, "SUE unicon.uz Scientific, Engineering & Marketing RC"  },
    { 0x2621, "CLIXUP LLC"  },
    { 0x2622, "IAG Group Limited"  },
    { 0x2623, "SGR Audio Pty Ltd."  },
    { 0x2624, "L-3 Communications - Communications Systems West"  },
    { 0x2625, "MilDef AB"  },
    { 0x2626, "Aruba Networks"  },
    { 0x2627, "Vectron Systems AG"  },
    { 0x2628, "TEN-TEC, INC."  },
    { 0x2629, "Winstars Technology Limited"  },
    { 0x262A, "SAVITECH CORP."  },
    { 0x262B, "YTOP Electronics Technical (Kunshan) Co., Ltd."  },
    { 0x262C, "Scannx"  },
    { 0x262D, "Fujian Witsi Microelectronics Technology Co., Ltd."  },
    { 0x262E, "UNITEX Corporation"  },
    { 0x262F, "MELAG Medizintechnik oHG"  },
    { 0x2630, "ifm electronic gmbh"  },
    { 0x2631, "NEOPROT TECNOLOGIA EM INFORMATICA LTDA."  },
    { 0x2632, "ENSPERT Inc."  },
    { 0x2633, "Inno Audio & Video (HK) Limited"  },
    { 0x2634, "E.M.S. S.R.L."  },
    { 0x2635, "uHDevice Technology Ltd."  },
    { 0x2636, "MED-EL Medical Electronics"  },
    { 0x2637, "TAEWOONG MEDICAL. CO., LTD."  },
    { 0x2638, "Becker-Antriebe GmbH"  },
    { 0x2639, "Xsens Technologies B.V."  },
    { 0x263A, "Maury Microwave"  },
    { 0x263B, "Time & Data Systems International Ltd."  },
    { 0x263C, "Schultes Microcomputer-Vertriebs-GmbH & Co KG"  },
    { 0x263D, "pls Programmierbare Logik & Systeme GmbH"  },
    { 0x263E, "Odin TeleSystems Inc."  },
    { 0x263F, "ES-Experts, Ltd."  },
    { 0x2640, "Banner Engineering"  },
    { 0x2641, "PRO TUNE ELECTRONIC SYSTEMS"  },
    { 0x2642, "NPP ELIKS America Inc. DBA T&M Atlantic"  },
    { 0x2643, "COMVOX AUDIO CO., LTD."  },
    { 0x2644, "Sioux Electronics B.V."  },
    { 0x2645, "Lead Data Inc."  },
    { 0x2646, "Bel Canto Design, Ltd."  },
    { 0x2647, "FORMER ENGINEERING SERVICE CO., LTD."  },
    { 0x2648, "Telongo LLC"  },
    { 0x2649, "Soundspring Audio, Inc"  },
    { 0x264A, "THERMALTAKE Technology Co., Ltd."  },
    { 0x264B, "Industrial Indexing Systems"  },
    { 0x264C, "Si14 SpA"  },
    { 0x264D, "Wolfrum Elektronik & Avionik"  },
    { 0x264E, "3i Corporation"  },
    { 0x264F, "RF Controls, LLC"  },
    { 0x2650, "Electronics For Imaging, Inc."  },
    { 0x2651, "Otis Instruments Inc."  },
    { 0x2652, "Fallbrook Technologies, Inc."  },
    { 0x2653, "AutoHotBox"  },
    { 0x2654, "DarklingX, LLC"  },
    { 0x2655, "Moog Inc."  },
    { 0x2656, "Ashcroft Inc."  },
    { 0x2657, "Embedia Technologies Corporation"  },
    { 0x2658, "Sintermask GmbH"  },
    { 0x2659, "Sundtek"  },
    { 0x265A, "3Brain GmbH"  },
    { 0x265B, "D-tect Systems"  },
    { 0x265C, "IDEX Health + Science LLC"  },
    { 0x265D, "H. Schomaecker GmbH"  },
    { 0x265E, "JSC Engineering Centre Energoservice"  },
    { 0x265F, "Azatrax"  },
    { 0x2660, "YEONG DER (SUM-EM) Enterprises Co., Ltd."  },
    { 0x2661, "WorldCast Systems"  },
    { 0x2662, "MOOG Music Inc."  },
    { 0x2663, "JOMESA Messsysteme GmbH"  },
    { 0x2664, "NOHMI BOSAI Ltd."  },
    { 0x2665, "Yamaki Electric Corporation"  },
    { 0x2666, "BLX IC Design Corp., Ltd."  },
    { 0x2667, "SuZhou ZhongXingLian Precision Industrial Co., Ltd."  },
    { 0x2668, "Shenzhen Yuwenfa Electronic Technology Co., Ltd."  },
    { 0x2669, "ME4SURE, Inc."  },
    { 0x266A, "Linear LLC"  },
    { 0x266B, "ProSys Development Services"  },
    { 0x266C, "Brightsight BV"  },
    { 0x266D, "Ergotest Innovation A.S."  },
    { 0x266E, "Multimedia Link, Inc."  },
    { 0x266F, "Shanghai Zhengyuan Technologies Co., Ltd."  },
    { 0x2670, "Zhengzhou Xin Da Jie An Information Technology Co., Ltd"  },
    { 0x2671, "Innovative Logic"  },
    { 0x2672, "GoPro"  },
    { 0x2673, "Wadia Digital"  },
    { 0x2674, "Hoyt Monitor Technologies, LLC"  },
    { 0x2675, "Peter Huber Kaeltemaschinenbau GmbH"  },
    { 0x2676, "Basler AG"  },
    { 0x2677, "Winegard Company"  },
    { 0x2678, "Sky Deutschland GmbH & Co. KG"  },
    { 0x2679, "BESTMEDIA CD-Recordable GmbH & Co. KG"  },
    { 0x267A, "Xi'an YEP Telecommunication Technology Co., Ltd."  },
    { 0x267B, "Palpilot International Corp."  },
    { 0x267C, "OptiGene Limited"  },
    { 0x267D, "KOHZU Precision Co., Ltd."  },
    { 0x267E, "E.D. Bullard Company"  },
    { 0x267F, "Acromag Inc."  },
    { 0x2680, "DIGICO UK Limited"  },
    { 0x2681, "MYLAPS B.V."  },
    { 0x2682, "ROBOX S.P.A."  },
    { 0x2683, "Gazogiken Co., Ltd."  },
    { 0x2684, "Funkwerk Security Communications GmbH"  },
    { 0x2685, "Cardo Systems Inc."  },
    { 0x2686, "IP LABS Inc."  },
    { 0x2687, "FITBIT"  },
    { 0x2688, "Stratasys Inc."  },
    { 0x2689, "StepOver Inc."  },
    { 0x268A, "QEES"  },
    { 0x268B, "Dimension Engineering LLC"  },
    { 0x268C, "AMS-TAOS"  },
    { 0x268D, "WEISS ENGINEERING LTD."  },
    { 0x268E, "xyzmo Software GmbH"  },
    { 0x268F, "LETech Co., Ltd."  },
    { 0x2690, "K.K. Rabbit"  },
    { 0x2691, "ZINK Imaging, Inc."  },
    { 0x2692, "CELLIENT CO., LTD."  },
    { 0x2693, "Silvershore Technology Partners"  },
    { 0x2694, "RoboteX Inc."  },
    { 0x2695, "DynaGen Technologies Inc."  },
    { 0x2696, "Sensovation AG"  },
    { 0x2697, "Anfatec Instruments"  },
    { 0x2698, "EVTD Inc."  },
    { 0x2699, "ECOUS Corp."  },
    { 0x269A, "BETTER MANAGE INVESTMENTS LIMITED"  },
    { 0x269B, "Novel Data Solutions (Suzhou) Corporation"  },
    { 0x269C, "ECTRON CORPORATION"  },
    { 0x269D, "Accessible Technologies, Inc."  },
    { 0x269E, "Astro Gaming"  },
    { 0x269F, "DKL TECHNOLOGY (SHENZHEN) CO., LTD."  },
    { 0x26A0, "MIDAS"  },
    { 0x26A1, "Miris AB"  },
    { 0x26A2, "Eppendorf AG"  },
    { 0x26A3, "EMKO ELEKTRONIK SAN. VE TIC. AS"  },
    { 0x26A4, "Blue Goji"  },
    { 0x26A5, "CAL TEST ELECTRONICS, INC."  },
    { 0x26A6, "Radio Design Group, Inc."  },
    { 0x26A7, "LOG-IN, Inc."  },
    { 0x26A8, "UNIREX CORPORATION"  },
    { 0x26A9, "Research Industrial Systems IT-Engineering (RISE) GmbH"  },
    { 0x26AA, "YAESU MUSEN CO., LTD."  },
    { 0x26AB, "Motion Control Systems, Inc."  },
    { 0x26AC, "3D Robotics Inc."  },
    { 0x26AD, "Global Distribution GmbH"  },
    { 0x26AE, "Oscium"  },
    { 0x26AF, "Bombardier Transportation GmbH, TCMS Development Ctr 2"  },
    { 0x26B0, "Zhejiang Senda Electronics Co., Ltd."  },
    { 0x26B1, "Bassett Electronic Systems Limited"  },
    { 0x26B2, "RST Instruments Ltd."  },
    { 0x26B3, "Global Inkjet Systems"  },
    { 0x26B4, "Sensor Technology Limited"  },
    { 0x26B5, "ELECTROCOMPANIET AS"  },
    { 0x26B6, "Pacom Systems Pty. Ltd."  },
    { 0x26B7, "Azusatekuno"  },
    { 0x26B8, "InkControl, LLC"  },
    { 0x26B9, "Satlantic LP"  },
    { 0x26BA, "Freetronics Pty Ltd."  },
    { 0x26BB, "Omega Elektronik Sanayi ve Ticaret A.S."  },
    { 0x26BC, "CARDIN ELETTRONICA S.p.A."  },
    { 0x26BD, "Integral Memory Plc."  },
    { 0x26BE, "AKASA (ASIA) CORP."  },
    { 0x26BF, "Broadway System, Inc."  },
    { 0x26C0, "RADIODETECTION LTD."  },
    { 0x26C1, "Viola Audio Laboratories"  },
    { 0x26C2, "FUTURE UNIVERSITY HAKODATE"  },
    { 0x26C3, "HARLEY-DAVIDSON MOTOR COMPANY"  },
    { 0x26C4, "Logic Way GmbH"  },
    { 0x26C5, "TOKAI RUBBER INDUSTRIES, LTD."  },
    { 0x26C6, "GRAF-SYTECO GmbH & Co. KG"  },
    { 0x26C7, "Beijing Stone New Technology Industry Co., Ltd."  },
    { 0x26C8, "SCHMID mme - electronic product engineering"  },
    { 0x26C9, "SPM INSTRUMENT AB"  },
    { 0x26CA, "MSY Inc."  },
    { 0x26CB, "Sung Kyung Precision Co., Ltd."  },
    { 0x26CC, "Hunting Titan"  },
    { 0x26CD, "Blendology Limited"  },
    { 0x26CE, "ASRock Inc."  },
    { 0x26CF, "The Gate Technologies"  },
    { 0x26D0, "ZK Celltest, Inc."  },
    { 0x26D1, "THORLABS LTD."  },
    { 0x26D2, "Jiangsu Yinhe Electronics Co., Ltd."  },
    { 0x26D3, "VIBRATION INSTRUMENTS CO., LTD."  },
    { 0x26D4, "Truesense Imaging"  },
    { 0x26D5, "Equinox Payments, LLC"  },
    { 0x26D6, "Sistemi Elettronici Di Addonizio Luisa"  },
    { 0x26D7, "POPSPA (HK) LTD."  },
    { 0x26D8, "APR, LLC"  },
    { 0x26D9, "ATC-NY"  },
    { 0x26DA, "Dabi Atlante"  },
    { 0x26DB, "American DJ Supply"  },
    { 0x26DC, "Gato Audio"  },
    { 0x26DD, "Monnit Corp."  },
    { 0x26DE, "Velocity Micro, Inc."  },
    { 0x26DF, "University of Cambridge"  },
    { 0x26E0, "Shenzhen Shixin Digital Co., Ltd."  },
    { 0x26E1, "CrucialTec Co., Ltd."  },
    { 0x26E2, "Ingenieurbuero Dietzsch und Thiele PartG"  },
    { 0x26E3, "SHENZHEN EXCEL DIGITAL TECHNOLOGY CO., LTD."  },
    { 0x26E4, "VIZIO, Inc."  },
    { 0x26E5, "Shaghal Ltd."  },
    { 0x26E6, "ORC Manufacturing Co., Ltd."  },
    { 0x26E7, "Fishman"  },
    { 0x26E8, "Camgian Microsystems"  },
    { 0x26E9, "Lumenergi Inc."  },
    { 0x26EA, "OPTOVUE INC."  },
    { 0x26EB, "emtrion GmbH"  },
    { 0x26EC, "SLE quality engineering GmbH & Co. KG"  },
    { 0x26ED, "a.tron3d GmbH"  },
    { 0x26EE, "Grimm Audio"  },
    { 0x26EF, "TAKEBISHI CORPORATION"  },
    { 0x26F0, "EDM Corporation"  },
    { 0x26F1, "Fujian LANDI Commercial Equipment Co., Ltd."  },
    { 0x26F2, "AUDIS SARL"  },
    { 0x26F3, "Raven Systems Design, Inc."  },
    { 0x26F4, "RTW GmbH & Co. KG"  },
    { 0x26F5, "Morning Star Digital Connector Co., Ltd."  },
    { 0x26F6, "Sea-Bird Electronics"  },
    { 0x26F7, "BFFT GmbH"  },
    { 0x26F8, "Salon Transcripts, Inc."  },
    { 0x26F9, "Outstanding Technology Co., Ltd."  },
    { 0x26FA, "DAQ SYSTEM Co., Ltd."  },
    { 0x26FB, "FLIR Advanced Imaging Systems"  },
    { 0x26FC, "Raven Industries"  },
    { 0x26FD, "Foot Levelers, Inc."  },
    { 0x26FE, "ESPROS Photonics AG"  },
    { 0x26FF, "MIA Corporation"  },
    { 0x2700, "MITACHI CO., LTD."  },
    { 0x2701, "Pro Design Electronic GmbH"  },
    { 0x2702, "Hobart GmbH"  },
    { 0x2703, "Greenwave Reality Pte. Ltd."  },
    { 0x2704, "Unisun Innovation Incorporated"  },
    { 0x2705, "CardioGrip Corporation"  },
    { 0x2706, "iKey, Ltd."  },
    { 0x2707, "Bardac Corporation"  },
    { 0x2708, "Audient Limited"  },
    { 0x2709, "ZEON CORPORATION"  },
    { 0x270A, "Channel Islands Audio"  },
    { 0x270B, "MSHeli Srl"  },
    { 0x270C, "Inhon Computer Co., Ltd."  },
    { 0x270D, "ROSAND Technologies"  },
    { 0x270E, "Applied Security Inc."  },
    { 0x270F, "Western Digital, HGST"  },
    { 0x2710, "Kontron America, Inc."  },
    { 0x2711, "ASD Inc."  },
    { 0x2712, "US Army Benet Laboratories"  },
    { 0x2713, "Datalink Electronics Ltd."  },
    { 0x2714, "i'm S.p.A."  },
    { 0x2715, "Photron Limited"  },
    { 0x2716, "YUEN DA ELECTRONIC PRODUCTS FACTORY"  },
    { 0x2717, "Xiaomi Communications Co., Ltd."  },
    { 0x2718, "Tamaggo"  },
    { 0x2719, "4iiii Innovations Inc."  },
    { 0x271A, "KONE Industrial Ltd."  },
    { 0x271B, "Tec.to"  },
    { 0x271C, "KDDI Technology Corporation"  },
    { 0x271D, "Gionee Communication Equipment Co., Ltd. ShenZhen"  },
    { 0x271E, "Changzhou Traful Electronic Co., Ltd."  },
    { 0x271F, "Shanghai Nufront Electronic Technology Co., Ltd."  },
    { 0x2720, "motrona GmbH"  },
    { 0x2721, "Germaneers GmbH"  },
    { 0x2722, "TRANIT"  },
    { 0x2723, "KUK Electronic AG"  },
    { 0x2724, "XS Technology, Inc."  },
    { 0x2725, "L-3 Applied Signal & Image Technology"  },
    { 0x2726, "Universal Electronics Inc. (dba: TVIEW)"  },
    { 0x2727, "ANM OPTO LIMITED"  },
    { 0x2728, "STX-Med SPRL"  },
    { 0x2729, "Regenersis (Glenrothes) Ltd."  },
    { 0x272A, "StarLeaf Limited"  },
    { 0x272B, "VAT Vakuumventile AG"  },
    { 0x272C, "IAR Systems"  },
    { 0x272D, "AKAR GAME LTD."  },
    { 0x272E, "Teratronik elektronische Systeme GmbH"  },
    { 0x272F, "tommis gmbh, Ingenieurburo f. Nachrichtentechnik u. Aut"  },
    { 0x2730, "Camozzi spa"  },
    { 0x2731, "Pebble Audio Oy"  },
    { 0x2732, "Samsung Medison Co., Ltd."  },
    { 0x2733, "ShenZhen SunSonny Electronic Technology Co., Ltd."  },
    { 0x2734, "Wuhan XinAn LuoJia Technologies Co., Ltd."  },
    { 0x2735, "Wilk Elektronik S.A."  },
    { 0x2736, "Silver Palm Technologies LLC"  },
    { 0x2737, "Blu Controls"  },
    { 0x2738, "Bad Rabby Designs"  },
    { 0x2739, "BluePacket Communications Co., Ltd."  },
    { 0x273A, "Singular Technology Co., Ltd."  },
    { 0x273B, "TecScan Systems Inc."  },
    { 0x273C, "Etherstack Limited"  },
    { 0x273D, "Thrimona Corporation"  },
    { 0x273E, "LIFODAS"  },
    { 0x273F, "Hughski Limited"  },
    { 0x2740, "Apparent Corporation"  },
    { 0x2741, "N2 Imaging Systems"  },
    { 0x2742, "Organ Recovery Systems, Inc."  },
    { 0x2743, "XS Embedded GmbH"  },
    { 0x2744, "RIKEN KEIKI NARA MFG. Co., Ltd."  },
    { 0x2745, "Unitech Electronics Co., Ltd."  },
    { 0x2746, "Shenzhen YishunTai Metal Factory"  },
    { 0x2747, "AHA INC. Co., Ltd."  },
    { 0x2748, "Stresstech Oy"  },
    { 0x2749, "GMV SISTEMAS"  },
    { 0x274A, "Qdac Inc."  },
    { 0x274B, "Automotive Data Solutions, Inc."  },
    { 0x274C, "Atos Worldline"  },
    { 0x274D, "FXI Technologies AS"  },
    { 0x274E, "VECTRONIC Aerospace GmbH"  },
    { 0x274F, "Dacuda AG"  },
    { 0x2750, "SafeLine Sweden AB"  },
    { 0x2751, "AMI International, Inc."  },
    { 0x2752, "miniDSP Ltd."  },
    { 0x2753, "Danville Signal Processing, Inc."  },
    { 0x2754, "Trapeze Software Group, Inc."  },
    { 0x2755, "Cosmic Circuits Pvt. Ltd."  },
    { 0x2756, "Victor Hasselblad AB"  },
    { 0x2757, "HiteVision Digital Media Technology Co., Ltd."  },
    { 0x2758, "MobileEco Co., Ltd."  },
    { 0x2759, "Philip Morris Products S.A."  },
    { 0x275A, "Vertex Aquaristik GmbH"  },
    { 0x275B, "PROPACK"  },
    { 0x275C, "NITA, LLC"  },
    { 0x275D, "NewSoc Tech Limited"  },
    { 0x275E, "Scent Sciences Corporation"  },
    { 0x275F, "Vishay Measurements Group, Inc."  },
    { 0x2760, "Oxigraf, Inc."  },
    { 0x2761, "CAST Navigation LLC"  },
    { 0x2762, "FERMAX ELECTRONICA S.A.U."  },
    { 0x2763, "PRIMES GmbH"  },
    { 0x2764, "Ouman Oy"  },
    { 0x2765, "Firstbeat Technologies Ltd."  },
    { 0x2766, "LifeScan"  },
    { 0x2767, "Cheetah Hi-Tech, Inc."  },
    { 0x2768, "DongGuan City Lian Zhi Electronic Technology Co. Ltd."  },
    { 0x2769, "SPI ENGINEERING Co., Ltd."  },
    { 0x276A, "SUGIYAMA ELECTRIC SYSTEM INC."  },
    { 0x276B, "CTI INFORMATION CENTER CO., LTD."  },
    { 0x276C, "PROTEI"  },
    { 0x276D, "YSTEK Technology Company"  },
    { 0x276E, "RGB Lasersysteme GmbH"  },
    { 0x276F, "Lightware Visual Engineering"  },
    { 0x2771, "TTE Corporation"  },
    { 0x2772, "Audio Tuning Vertriebs GmbH"  },
    { 0x2773, "HILTI AG"  },
    { 0x2774, "Novasina AG"  },
    { 0x2775, "Sonardyne International Ltd."  },
    { 0x2776, "KFI Trading s.r.l."  },
    { 0x2777, "SingTrix LLC"  },
    { 0x2778, "Cypher Labs LLC"  },
    { 0x2779, "Qualnetics Corporation"  },
    { 0x277A, "Occipital, Inc."  },
    { 0x277B, "Moxtek, Inc"  },
    { 0x277C, "SignalCore, Inc."  },
    { 0x277D, "Microcom Corporation"  },
    { 0x277E, "Sportable Scoreboards, Inc."  },
    { 0x277F, "DongGuan City Shangjie Electronic Co., Ltd."  },
    { 0x2780, "M31 Technology Corp."  },
    { 0x2781, "Liteconn Co., Ltd."  },
    { 0x2782, "TTS Inc."  },
    { 0x2783, "Aktina Medical Corp."  },
    { 0x2784, "A-One Co., Ltd."  },
    { 0x2785, "Mayekawa Mfg. Co., Ltd."  },
    { 0x2786, "Switch Science, Incorporation"  },
    { 0x2787, "AVTECH Corporation"  },
    { 0x2788, "Sanwin (HK) Electronic Technology Co., Ltd."  },
    { 0x2789, "Suzhou WEIJU Electronics Technology Co., Ltd."  },
    { 0x278A, "MARSHAL Corporation"  },
    { 0x278B, "The Rotel Co., Ltd."  },
    { 0x278C, "NAGATA ELECTRIC CO., LTD."  },
    { 0x278D, "GPSports Systems Pty., Ltd."  },
    { 0x278E, "TSS AB"  },
    { 0x278F, "Bosch Sicherheitssysteme Engineering GmbH"  },
    { 0x2790, "Cobalt Digital, Inc."  },
    { 0x2791, "SunTech Medical, Inc."  },
    { 0x2792, "SYSTEC Co., Limited"  },
    { 0x2793, "i-KAIST"  },
    { 0x2794, "SilverPlus, Inc."  },
    { 0x2795, "QuantaScope Biotech"  },
    { 0x2796, "Zhejiang Wellcom Technology Co., Ltd."  },
    { 0x2797, "EUROIMMUN AG"  },
    { 0x2798, "Turning Technologies"  },
    { 0x2799, "Colorimetry Research, Inc."  },
    { 0x279A, "Naim Audio Limited"  },
    { 0x279B, "Bluefish Technologies Pty Ltd."  },
    { 0x279C, "Advanced Anaesthesia Specialists"  },
    { 0x279D, "Towa Electronics Co., Ltd."  },
    { 0x279E, "Syntronix Corporation"  },
    { 0x279F, "Hiragawa Electronics Industry Co., Ltd."  },
    { 0x27A0, "Mondokey Limited"  },
    { 0x27A1, "Autoliv Romania S.R.L."  },
    { 0x27A2, "T.I.T. ENG CO., LTD."  },
    { 0x27A3, "AU Optronics Corporation"  },
    { 0x27A4, "Digital Act Inc."  },
    { 0x27A5, "Advantest Corporation"  },
    { 0x27A6, "iRobot Corporation"  },
    { 0x27A7, "Delta Computer Systems, Inc."  },
    { 0x27A8, "Square Inc."  },
    { 0x27A9, "Global Mixed-mode Technology Inc."  },
    { 0x27AA, "Just Connector Kunshan Co., Ltd."  },
    { 0x27AB, "Shenzhen Maxmade Technology Co., Ltd."  },
    { 0x27AC, "GP Electronics (HK) Limited"  },
    { 0x27AD, "PAUL HARTMANN AG"  },
    { 0x27AE, "TeleOrbit GmbH"  },
    { 0x27AF, "HANNA Instruments, Inc."  },
    { 0x27B0, "FOXPRO Inc."  },
    { 0x27B1, "UltiMachine"  },
    { 0x27B2, "OrthoAccel Technologies, Inc."  },
    { 0x27B3, "Secure Systems Limited"  },
    { 0x27B4, "Duerkopp Adler AG"  },
    { 0x27B5, "J-MEX Inc."  },
    { 0x27B6, "TechnoKom Ltd."  },
    { 0x27B7, "Fraunhofer IMS"  },
    { 0x27B8, "ThingM Corporation"  },
    { 0x27B9, "Ziotech Corp"  },
    { 0x27BA, "Aoptix Technologies, Inc."  },
    { 0x27BB, "Plenom A/S"  },
    { 0x27BC, "KeyView"  },
    { 0x27BD, "Codethink Limited"  },
    { 0x27BE, "InHand Electronics, Inc."  },
    { 0x27BF, "Dongguan CPO Electronic Co., Ltd."  },
    { 0x27C0, "Cadwell Laboratories, Inc."  },
    { 0x27C1, "ARKAMI"  },
    { 0x27C2, "ArcBotics LLC"  },
    { 0x27C3, "Danfoss Turbocor Compressors Inc."  },
    { 0x27C4, "KRYPTUS"  },
    { 0x27C5, "SRT Marine Technology Limited"  },
    { 0x27C6, "Shenzhen Huiding Technology Co. Ltd."  },
    { 0x27C7, "TransluSense, LLC"  },
    { 0x27C8, "Rigaku Corporation"  },
    { 0x27C9, "ElaraTek LTD."  },
    { 0x27CA, "JayBird LLC"  },
    { 0x27CB, "ANXA Limited Hong Kong"  },
    { 0x27CC, "GHL Matthias Gross GmbH & Co. KG"  },
    { 0x27CD, "GHEO SA"  },
    { 0x27CE, "Double Power Technology Inc."  },
    { 0x27CF, "Weidmueller Interface GmbH & Co. KG"  },
    { 0x27D0, "Traxon Technologies Europe GmbH"  },
    { 0x27D1, "Angelbird Technologies GmbH"  },
    { 0x27D2, "EURONOVATE SA"  },
    { 0x27D3, "PRECIA MOLEN"  },
    { 0x27D4, "Blackstar Amplification Ltd."  },
    { 0x27D5, "BSkyB LTD."  },
    { 0x27D6, "T3 Innovation"  },
    { 0x27D7, "Senova Systems, Inc."  },
    { 0x27D8, "Patriot Memory"  },
    { 0x27D9, "Gallagher Group Limited"  },
    { 0x27DA, "S Net Media Inc."  },
    { 0x27DB, "Hiitop Technology Limited"  },
    { 0x27DC, "Tennant Company"  },
    { 0x27DD, "Shenzhen MinDe Electronics Technology Ltd."  },
    { 0x27DE, "Newtec Cy"  },
    { 0x27DF, "Charles Novacroft Direct Limited"  },
    { 0x27E0, "Stelulu Technology"  },
    { 0x27E1, "TRX Systems, Inc."  },
    { 0x27E2, "Natus Medical Incorproated"  },
    { 0x27E3, "Chemyx Inc."  },
    { 0x27E4, "Easybotics LLC"  },
    { 0x27E5, "Shiroshita Industrial Co., Ltd."  },
    { 0x27E6, "SENECA srl"  },
    { 0x27E7, "AVIWEST"  },
    { 0x27E8, "takwak GmbH"  },
    { 0x27E9, "Soeks Limited"  },
    { 0x27EA, "Goldmund International"  },
    { 0x27EB, "ACCUCOMM, INC."  },
    { 0x27EC, "SEETECH CO., LTD."  },
    { 0x27ED, "Tescom-Emerson Process Management"  },
    { 0x27EE, "DashLogic Inc."  },
    { 0x27EF, "TAIYO SEIKI CO., LTD."  },
    { 0x27F0, "DITECT Corporation"  },
    { 0x27F1, "VERTU Corporation Limited"  },
    { 0x27F2, "Softnautics Private Limited"  },
    { 0x27F3, "Indutherm Erwaermungsanlagen GmbH"  },
    { 0x27F4, "LEGIC Identsystems Ltd."  },
    { 0x27F5, "Relume Technologies, Inc."  },
    { 0x27F6, "Advanced Simulation Technology Inc."  },
    { 0x27F7, "Wyred 4 Sound"  },
    { 0x27F8, "Wikipad, Inc."  },
    { 0x27F9, "MIDAS Elektronik GmbH"  },
    { 0x27FA, "Afag Automation AG"  },
    { 0x27FB, "Barclays"  },
    { 0x27FC, "CAREL SPA"  },
    { 0x27FD, "GI Therapies Pty Ltd."  },
    { 0x27FE, "DONGGUAN Rakecorp Co., Ltd."  },
    { 0x27FF, "Cashway Technology Co., Ltd."  },
    { 0x2800, "iluminage, Inc."  },
    { 0x2801, "Pear Sports LLC"  },
    { 0x2802, "Moixa Technology"  },
    { 0x2803, "StarLine LLC"  },
    { 0x2804, "4MOD Technology"  },
    { 0x2805, "Shenzhen N-Pass Mobile Technology, Ltd."  },
    { 0x2806, "RF DataTech"  },
    { 0x2807, "Elliptic Laboratories AS"  },
    { 0x2808, "FocalTech Systems, Ltd."  },
    { 0x2809, "Sept Co., Ltd."  },
    { 0x280A, "Culti Co., Ltd."  },
    { 0x280B, "Dukane Corporation"  },
    { 0x280C, "Linera"  },
    { 0x280D, "Ai Electronic Industry Co., Ltd."  },
    { 0x280E, "Leaf Imaging Ltd."  },
    { 0x280F, "MBit Wireless, Inc."  },
    { 0x2810, "Aphex, LLC"  },
    { 0x2811, "DigiTalks INC."  },
    { 0x2812, "Bridge Semiconductor Corp."  },
    { 0x2813, "Brookfield Engineering Laboratories Inc."  },
    { 0x2814, "OOO SMS-Soft"  },
    { 0x2815, "KING TSUSHIN KOGYO CO., LTD."  },
    { 0x2816, "Harvard Photonix"  },
    { 0x2817, "Test Equipment Plus"  },
    { 0x2818, "Codex Digital Limited"  },
    { 0x2819, "MESSRING Systembau MSG GmbH"  },
    { 0x281A, "SWAC Automation Consult GmbH"  },
    { 0x281B, "HiES Tech s.r.o."  },
    { 0x281C, "Presidium Instruments Pte. Ltd."  },
    { 0x281D, "AISIN AW CO., LTD."  },
    { 0x281E, "Symphodia Phil"  },
    { 0x281F, "Motion Control, Inc."  },
    { 0x2820, "Sanovas"  },
    { 0x2821, "Aclima Inc."  },
    { 0x2822, "REFLEXdigital"  },
    { 0x2823, "Dongguan Jiumutong Industry Co., Ltd."  },
    { 0x2824, "Vollsun Ltd."  },
    { 0x2825, "Baumer Optronic GmbH"  },
    { 0x2826, "BSH Bosch und Siemens Hausgerate GmbH"  },
    { 0x2827, "DIGITTRADE GmbH"  },
    { 0x2828, "SAPHYMO"  },
    { 0x2829, "Scanomat A/S"  },
    { 0x282A, "REDL GmbH"  },
    { 0x282B, "Aevoe Inc."  },
    { 0x282C, "Reichert, Inc."  },
    { 0x282D, "Aeromax Technology Co., Ltd."  },
    { 0x282E, "Vectawave Technology Ltd."  },
    { 0x282F, "SANKEN ELECTRIC CO., LTD."  },
    { 0x2830, "GD-Broadband"  },
    { 0x2831, "Power Integrations"  },
    { 0x2832, "Applied Research Associates"  },
    { 0x2833, "Oculus VR LLC"  },
    { 0x2834, "JM Concept"  },
    { 0x2835, "SEIDENSHA ELECTRONICS Co., Ltd."  },
    { 0x2836, "OUYA Inc."  },
    { 0x2837, "Tunstall Healthcare (UK) Ltd."  },
    { 0x2838, "Ontorix GmbH"  },
    { 0x2839, "Grass Elektronik"  },
    { 0x283A, "HIKe Mobile Co., Ltd."  },
    { 0x283B, "Cellon Communications Technology (Shenzhen) Co., Ltd."  },
    { 0x283C, "HIGH TEK HARNESS ENTERPRISE CO., LTD."  },
    { 0x283D, "SigNET (AC) Ltd."  },
    { 0x283E, "DECATHLON SA"  },
    { 0x283F, "Elprosys Sp. Z.o.o."  },
    { 0x2840, "Taiwan Carol Electronics Co., Ltd."  },
    { 0x2841, "Artvision Technologies Inc."  },
    { 0x2842, "RobotGroup"  },
    { 0x2843, "SyncMOS Technologies International, Inc."  },
    { 0x2844, "ELSIST Srl"  },
    { 0x2845, "Systec Designs BV"  },
    { 0x2846, "ATRON electronic GmbH"  },
    { 0x2847, "TMG TE GmbH"  },
    { 0x2848, "Sentons USA, Inc."  },
    { 0x2849, "Astronics Advanced Electronic Systems Corp."  },
    { 0x284A, "Yangtze Optical Fibre and Cable Company Ltd."  },
    { 0x284B, "Leadingui Co., Ltd."  },
    { 0x284C, "Full in Hope Co., Ltd."  },
    { 0x284D, "Qltouch Tech Co., Ltd."  },
    { 0x284E, "Flysky RC Model Co., Ltd."  },
    { 0x284F, "ANTLIA SA"  },
    { 0x2850, "Intellectual Property Group SA"  },
    { 0x2851, "RETIA, a.s."  },
    { 0x2852, "Virtual Console, LLC"  },
    { 0x2853, "Ralston Instruments"  },
    { 0x2854, "Great River Technology"  },
    { 0x2855, "System Dimensions, Inc."  },
    { 0x2856, "Thales Alenia Space - Italia"  },
    { 0x2857, "Skardin Industrial Corporation"  },
    { 0x2858, "PT Doo Won Precision Indonesia"  },
    { 0x2859, "Viconn Technology (HK) Co., Ltd."  },
    { 0x285A, "AiM Touch Technology Co., Ltd."  },
    { 0x285B, "HARDWARE & SOFTWARE TECHNOLOGY CO., LTD."  },
    { 0x285C, "URMET S.p.a."  },
    { 0x285D, "Alarm.com, Inc."  },
    { 0x285E, "Occam Robotics"  },
    { 0x285F, "CyWee Group Limited"  },
    { 0x2860, "WISYCOM UNIPERSONALE s.r.l."  },
    { 0x2861, "Pacific Image Electronics Co., Ltd."  },
    { 0x2862, "DeVilbiss Healthcare LLC"  },
    { 0x2863, "BIOMATIQUES IDENTIFICATION SOLUTIONS PRIVATE LIMITED"  },
    { 0x2864, "Wenngo Inc."  },
    { 0x2865, "VIKING GmbH"  },
    { 0x2866, "SLOW CONTROL"  },
    { 0x2867, "DASCOM"  },
    { 0x2868, "Chakra Energetics Ltd."  },
    { 0x2869, "Comfort Audio AB"  },
    { 0x286A, "Dipl. - Ing. H. Horstmann GmbH"  },
    { 0x286B, "STANEO SAS"  },
    { 0x286C, "Atest-Gaz A. M. Pachole sp. j."  },
    { 0x286D, "Production Resource Group, LLC"  },
    { 0x286E, "Geosense Inc."  },
    { 0x286F, "Bretford Manufacturing Inc."  },
    { 0x2870, "Typhoon HIL, Inc."  },
    { 0x2871, "BYK-Gardner GmbH"  },
    { 0x2872, "Brite Semiconductor (Shanghai) Corporation"  },
    { 0x2873, "Spire Payments Holdings S.a.r.l."  },
    { 0x2874, "Dexter Research Center, Inc."  },
    { 0x2875, "nVideon, Inc."  },
    { 0x2876, "Safety Innovations, Inc."  },
    { 0x2877, "BrightSign LLC"  },
    { 0x2878, "Cabletech Electronics (Hong Kong) Co., Ltd."  },
    { 0x2879, "Rancore Technologies Private Limited"  },
    { 0x287A, "Shenzhen Bojuxing Industrial Development Co., Ltd."  },
    { 0x287B, "Pro-Tech"  },
    { 0x287C, "Special Recording Systems Ltd."  },
    { 0x287D, "Pettersson Elektronik AB"  },
    { 0x287E, "Silicon Designs, Inc."  },
    { 0x287F, "Beijing Jinke XinAn Technology Co., Ltd."  },
    { 0x2880, "Black Diamond Video"  },
    { 0x2881, "DX Antenna Co., Ltd."  },
    { 0x2882, "GCOMM CORPORATION"  },
    { 0x2883, "abatec group AG"  },
    { 0x2884, "Bor"  },
    { 0x2885, "Quantec SA"  },
    { 0x2886, "Seeed Technology Co., Ltd."  },
    { 0x2887, "Specwerkz"  },
    { 0x2888, "VEX Robotics, Inc."  },
    { 0x2889, "TrueVision Systems, Inc."  },
    { 0x288A, "LEXIBOOK LIMITED"  },
    { 0x288B, "Hierstar (Suzhou)"  },
    { 0x288C, "Moswell Co., Ltd."  },
    { 0x288D, "Centre for Development of Advanced Computing (C-DAC)"  },
    { 0x288E, "mce-systems Ltd."  },
    { 0x288F, "Voxx Accessories Corp."  },
    { 0x2890, "Teknic, Inc."  },
    { 0x2891, "Flytec AG"  },
    { 0x2892, "NAVIgard"  },
    { 0x2893, "LEVEL Ltd."  },
    { 0x2894, "Hovercam"  },
    { 0x2895, "INIM Electronics s.r.l."  },
    { 0x2896, "TTAF Elektronik Sanayi ve Ticaret Ltd. Sti."  },
    { 0x2897, "SDJ Technologies, Inc."  },
    { 0x2898, "Accumetrics Associates, Inc."  },
    { 0x2899, "Toptronic Industrial Co., Ltd."  },
    { 0x289A, "Scan-Sense A.S."  },
    { 0x289B, "DRACAL Technologies Inc."  },
    { 0x289C, "TLS Corp."  },
    { 0x289D, "Tyrian Systems, Inc."  },
    { 0x289E, "Esselte Leitz GmbH & Co. KG"  },
    { 0x289F, "inoage GmbH"  },
    { 0x28A0, "I-CUBE TECHNOLOGY Co., Ltd."  },
    { 0x28A1, "AVEST-SYSTEMS Private Unitary Enterprise"  },
    { 0x28A2, "Meadowlark Optics Incorporated"  },
    { 0x28A3, "SensoMotoric Instruments GmbH"  },
    { 0x28A4, "Objective Solutions Sweden AB"  },
    { 0x28A5, "TCS John Huxley"  },
    { 0x28A6, "E-SEEK Inc."  },
    { 0x28A7, "Hugo Brennenstuhl GmbH & Co. KG"  },
    { 0x28A8, "AT Sciences, LLC"  },
    { 0x28A9, "Alpha Technologies"  },
    { 0x28AA, "Realta Entertainment Group"  },
    { 0x28AB, "Navigil Ltd."  },
    { 0x28AC, "euroBRAILLE"  },
    { 0x28AD, "iDTRONIC GmbH"  },
    { 0x28AE, "Zynaptic Limited"  },
    { 0x28AF, "Sharkbay Technologies Pte. Ltd."  },
    { 0x28B0, "PMC - Sierra"  },
    { 0x28B1, "EcoTech, Inc."  },
    { 0x28B2, "Siemens Infrastructure & Cities"  },
    { 0x28B3, "Profoto AB"  },
    { 0x28B4, "TOACK Corporation"  },
    { 0x28B5, "Solacom Inc."  },
    { 0x28B6, "Alcohol Countermeasure Systems Corp."  },
    { 0x28B7, "Pleora Technologies Inc."  },
    { 0x28B8, "Swiss Authentication Research & Development AG"  },
    { 0x28B9, "Kapsch TrafficCom AB"  },
    { 0x28BA, "RSscan International NV"  },
    { 0x28BB, "ICP Systems b.v."  },
    { 0x28BC, "Cyplex Corporation"  },
    { 0x28BD, "GuangZhou Ugee Computer Technology Co., Ltd."  },
    { 0x28BE, "GMG TECH. Co., Ltd."  },
    { 0x28BF, "Vitetech Int'l Co., Ltd."  },
    { 0x28C0, "SCVNGR, Inc."  },
    { 0x28C1, "DOMMEL GmbH"  },
    { 0x28C2, "Tapko Technologies GmbH"  },
    { 0x28C3, "MITSUBISHI ELECTRIC SYSTEM & SERVICE CO., LTD."  },
    { 0x28C4, "GALA, Inc."  },
    { 0x28C5, "ShenZhen Innovate-link Precision Hardware Co., Ltd."  },
    { 0x28C6, "FASTLITE"  },
    { 0x28C7, "Ultimaker BV"  },
    { 0x28C8, "ULTRACHIP Inc."  },
    { 0x28C9, "DongGuan City DHE Wire & Cable Co., Ltd."  },
    { 0x28CA, "NUMATA Corporation"  },
    { 0x28CB, "GO engineering GmbH"  },
    { 0x28CC, "MIWA ELECTRIC CO., LTD."  },
    { 0x28CD, "SMARTMATIC INTERNATIONAL CORP."  },
    { 0x28CE, "Changzhou Shi Wujin Miqi East Electronic Co., Ltd."  },
    { 0x28CF, "Asiatelco Technologies Co."  },
    { 0x28D0, "Stryker Corporation"  },
    { 0x28D1, "Technomedica Co., Ltd."  },
    { 0x28D2, "FTK Corporation"  },
    { 0x28D3, "Golden Transmart International Co., Ltd."  },
    { 0x28D4, "DEVIALET SAS"  },
    { 0x28D5, "Vicor Corporation"  },
    { 0x28D6, "Electrogamez USA Inc."  },
    { 0x28D7, "Tekron International"  },
    { 0x28D8, "Panda Ocean Inc."  },
    { 0x28D9, "Shenzhen Yoshuo Precision Components Co., Ltd."  },
    { 0x28DA, "G.SKILL Int'l Enterprice Co., Ltd."  },
    { 0x28DB, "Konftel AB"  },
    { 0x28DC, "Power Electronics International, Inc."  },
    { 0x28DD, "AIWA COMPANY LTD. - Love Harmony (LH)"  },
    { 0x28DE, "Valve Corporation"  },
    { 0x28DF, "EMBED-IT"  },
    { 0x28E0, "PRASIMAX"  },
    { 0x28E1, "Shenzhen iSolution Technologies Co., Ltd."  },
    { 0x28E2, "Surplus Electronic Technology Co., Ltd."  },
    { 0x28E3, "Apollo Electrical Technology Co., Ltd."  },
    { 0x28E4, "RKS, Inc."  },
    { 0x28E5, "MEP TECH"  },
    { 0x28E6, "BIAMP SYSTEMS"  },
    { 0x28E7, "Glyph Production Technologies"  },
    { 0x28E8, "Jefferson Audio Video Systems, Inc."  },
    { 0x28E9, "GigaDevice Semiconductor (Beijing) Inc."  },
    { 0x28EA, "Dongguan Vast Electronics Co.,Ltd"  },
    { 0x28EB, "SHEN ZHEN SHI YUAN AI HARDWARE ELECTRONIC CO., LTD."  },
    { 0x28EC, "Transcom Instruments Co., Ltd."  },
    { 0x28ED, "Shenzhen AraTek Biometrics Technology Co., Ltd."  },
    { 0x28EE, "China Mobile Group Device Co., Ltd."  },
    { 0x28EF, "SEEFRONT GmbH"  },
    { 0x28F0, "Elcus Electronic Company JSC"  },
    { 0x28F1, "Leddartech Inc."  },
    { 0x28F2, "Applied Vision Corporation"  },
    { 0x28F3, "Clover Network"  },
    { 0x28F4, "Sonoma Wire Works"  },
    { 0x28F5, "Electrolux Laundry Systems Sweden AB"  },
    { 0x28F6, "SERVOMEX Group Ltd."  },
    { 0x28F7, "ANYWIRE CORPORATION"  },
    { 0x28F8, "VTECH Technology Corp."  },
    { 0x28F9, "Comcraft"  },
    { 0x28FA, "iProtoXi Oy"  },
    { 0x28FB, "Shin Hwa Contech Co., Ltd."  },
    { 0x28FC, "Shandong Sinochiptp Electronic Technology Co., Ltd."  },
    { 0x28FD, "Wolfson Microelectronics Plc."  },
    { 0x28FE, "Marquardt Mechatronik GmbH"  },
    { 0x28FF, "MIRAENANOTECH"  },
    { 0x2900, "Labsphere"  },
    { 0x2901, "Tolomatic Inc."  },
    { 0x2902, "Woodward Inc."  },
    { 0x2903, "Lightspeed Aviation"  },
    { 0x2904, "Charon Technologies LLC"  },
    { 0x2905, "iDea USA Products Inc."  },
    { 0x2906, "Masimo Corporation"  },
    { 0x2907, "Mimetics Inc."  },
    { 0x2908, "Shenzhen Sen5 Technology Co., Ltd."  },
    { 0x2909, "Active Mind Technology"  },
    { 0x290A, "Electronic Systems Technology, Inc."  },
    { 0x290B, "Beats Electronics LLC"  },
    { 0x290C, "R. Hamilton & Co. Ltd."  },
    { 0x290D, "IBCONN Technologies (Shenzhen) Co., Ltd."  },
    { 0x290E, "Fugoo Inc."  },
    { 0x290F, "AFL Noyes"  },
    { 0x2910, "Cree, Inc."  },
    { 0x2911, "Penetek, Inc."  },
    { 0x2912, "Management Company ATOL Ltd."  },
    { 0x2913, "Teladin Co., Ltd."  },
    { 0x2914, "Kent Displays Inc."  },
    { 0x2915, "Sage Microelectronics Corp."  },
    { 0x2916, "Yota Devices Ltd."  },
    { 0x2917, "Pan Xin Precision Electronics Co., Ltd."  },
    { 0x2918, "Gigatronik Ingolstadt GmbH"  },
    { 0x2919, "GE Analytical Instruments"  },
    { 0x291A, "Anker Technology Co., Limited"  },
    { 0x291B, "LONTEX PIOTR LONDZIN"  },
    { 0x291C, "KEISOKUKI CENTER CO., LTD."  },
    { 0x291D, "Research & Development Center ELVEES OJSC"  },
    { 0x291E, "Shanghai DynamiCode Company Ltd."  },
    { 0x291F, "CBN Inc."  },
    { 0x2920, "Fiberplex Technologies, LLC"  },
    { 0x2921, "BiovenTus, LLC"  },
    { 0x2922, "Dongguan Digi-in Digital Technology Co., Ltd."  },
    { 0x2923, "Vprime"  },
    { 0x2924, "Chinon Corporation"  },
    { 0x2925, "Flight System Consulting Inc."  },
    { 0x2926, "Wildlife Acoustics, Inc."  },
    { 0x2927, "BF1 Systems Ltd."  },
    { 0x2928, "Dongguan Sineng Electronic Technology Co., Ltd."  },
    { 0x2929, "Shenzhen Taishan Online Technology Co., Ltd."  },
    { 0x292A, "T1Visions, Inc."  },
    { 0x292B, "Precision Audio Device Lab Limited"  },
    { 0x292C, "GENUSION, Inc."  },
    { 0x292D, "Wellitec Development Limited"  },
    { 0x292E, "HOYA Service Corporation"  },
    { 0x292F, "Nanotec Electronic GmbH & Co. KG"  },
    { 0x2930, "Ineda Systems Inc."  },
    { 0x2931, "Jolla Ltd."  },
    { 0x2932, "Peraso Technologies, Inc."  },
    { 0x2933, "IEI Integration Corp."  },
    { 0x2934, "CETA Testsysteme GmbH"  },
    { 0x2935, "Nanjing Magewell Electronics Co., Ltd."  },
    { 0x2936, "LEAP Motion"  },
    { 0x2937, "Tmax Digital Inc."  },
    { 0x2938, "Aides Technology Co., Ltd."  },
    { 0x2939, "Zaber Technologies Inc."  },
    { 0x293A, "The SmarTV Company"  },
    { 0x293B, "Lucent Medical Systems, Inc."  },
    { 0x293C, "Comcast"  },
    { 0x293D, "Medicatec Inc."  },
    { 0x293E, "EIDEN Co., Ltd."  },
    { 0x293F, "Gan Zhou DPT-Technology Co., Ltd."  },
    { 0x2940, "Shenzhen Yiwanda Electronics Co., Ltd."  },
    { 0x2941, "Sanofi-Aventis Deutschland GmbH"  },
    { 0x2942, "SoftLab - NSK"  },
    { 0x2943, "ZAGG Inc."  },
    { 0x2944, "RailComm"  },
    { 0x2945, "Matrix Design Group, LLC"  },
    { 0x2946, "OnAsset Intelligence Inc."  },
    { 0x2947, "KAPELSE"  },
    { 0x2948, "Access Network Technology Limited"  },
    { 0x2949, "Shenzhen JSR Technology Co., Ltd."  },
    { 0x294A, "Shenzhen Xinguodu Technology Co., Ltd."  },
    { 0x294B, "snakebyte Asia Ltd."  },
    { 0x294C, "Terminus Circuits Pvt Ltd."  },
    { 0x294D, "Cellwise Holding Co., Ltd."  },
    { 0x294E, "SHIH HUA TECHNOLOGY LTD."  },
    { 0x294F, "Dollar Connection Ltd."  },
    { 0x2950, "Resource One Inc."  },
    { 0x2951, "Raytrix GmbH"  },
    { 0x2952, "Seba Dynatronic GmbH"  },
    { 0x2953, "Axes System sp. Z.o.o."  },
    { 0x2954, "Human Design Medical, LLC"  },
    { 0x2955, "Baidu Online Network Technology (Beijing) Co., Ltd."  },
    { 0x2956, "Alfatest Ind. e Com. Produtos Eletronicos S/A"  },
    { 0x2957, "OBSIDIAN RESEARCH CORPORATION"  },
    { 0x2958, "Eleven Engineering Inc."  },
    { 0x2959, "Inuitive"  },
    { 0x295A, "ENERMAX TECHNOLOGY CORPORATION"  },
    { 0x295B, "eflow Inc."  },
    { 0x295C, "MediaNet M. Hermsen"  },
    { 0x295D, "Positive Grid"  },
    { 0x295E, "Britelite Enterprises"  },
    { 0x295F, "Tecvox Connectivity, LLC"  },
    { 0x2960, "Power Probe, Inc."  },
    { 0x2961, "Miselu Inc."  },
    { 0x2962, "Wilocity Ltd."  },
    { 0x2963, "BIO-key International, Inc."  },
    { 0x2964, "Kintech Co., Ltd."  },
    { 0x2965, "Kortek"  },
    { 0x2966, "Schatz AG"  },
    { 0x2967, "St. Andrews Instrumentation Ltd."  },
    { 0x2968, "Phoenix Avionics Systems, LLC"  },
    { 0x2969, "Sumix"  },
    { 0x296A, "Nitero, Inc."  },
    { 0x296B, "Xacti Corporation"  },
    { 0x296C, "KNC ONE GmbH - Research & Development"  },
    { 0x296D, "Azuri Technologies Ltd"  },
    { 0x296E, "LG CNS Co., Ltd."  },
    { 0x296F, "Broadsound Corporation"  },
    { 0x2970, "MERIDIAN SOFTWARE SYSTEMS LIMITED"  },
    { 0x2971, "Ory Laboratory Ltd."  },
    { 0x2972, "FiiO Electronics Technology Co., Ltd."  },
    { 0x2973, "Wild Elektronik & Kunststoff GmbH & Co. KG"  },
    { 0x2974, "Printrbot, Inc."  },
    { 0x2975, "MPC Research Ltd."  },
    { 0x2976, "COMOTA Co., Ltd."  },
    { 0x2977, "Shenzhen Zowee Technology Co., Ltd."  },
    { 0x2978, "Imaging Solutions Group of NY, Inc."  },
    { 0x2979, "Williams Sound, LLC"  },
    { 0x297A, "Innovative Developments LLC"  },
    { 0x297B, "ALKERIA s.r.l."  },
    { 0x297C, "HashFast Technologies LLC"  },
    { 0x297D, "Krypton Solutions"  },
    { 0x297E, "Shenzhen DTEC Electronic Technology Co., Ltd."  },
    { 0x297F, "Emerging Technology (Holdings) Ltd."  },
    { 0x2980, "CiDELEC"  },
    { 0x2981, "Elektron Technology UK Limited"  },
    { 0x2982, "Ableton AG"  },
    { 0x2983, "Coyote System"  },
    { 0x2984, "Glensound Electronics Ltd."  },
    { 0x2985, "DUALO"  },
    { 0x2986, "Rapt Touch (Ireland) Ltd."  },
    { 0x2987, "Lyve Minds, Inc."  },
    { 0x2988, "3D Systems Corporation"  },
    { 0x2989, "Nanjing Fujitsu Electronics Information Technology Co., Ltd"  },
    { 0x298A, "Singeen Electronics Technologies (Dongguan) Co., Ltd."  },
    { 0x298B, "Hanil ProTech"  },
    { 0x298C, "GL Solutions Inc."  },
    { 0x298D, "NEXT Biometrics"  },
    { 0x298E, "Delta Controls"  },
    { 0x298F, "NIHON DENON CO., LTD."  },
    { 0x2990, "SHIGA MEC Company Limited"  },
    { 0x2991, "Orbitsound Ltd"  },
    { 0x2992, "Lantos Technologies, Inc."  },
    { 0x2993, "ADPlaus Technology Limited"  },
    { 0x2995, "Resodyn Corporation"  },
    { 0x2996, "Delphi Data Connectivity"  },
    { 0x2997, "Inogeni Inc."  },
    { 0x2998, "EOS S.r.l."  },
    { 0x2999, "Fourtec Technologies Ltd."  },
    { 0x299A, "Ogi Systems Ltd. by A.A. Lab Systems"  },
    { 0x299B, "Ohio Semitronics, Inc."  },
    { 0x299C, "WINTOUCH Co., Ltd."  },
    { 0x299D, "Horst Platz Beratungs und Vertriebs GmbH"  },
    { 0x299E, "TRE INNOVATORER AB"  },
    { 0x299F, "MESTEC Technologies"  },
    { 0x29A0, "Bang & Olufsen Medicom A/S"  },
    { 0x29A1, "Union Electric Plug & Connector Corp."  },
    { 0x29A2, "MUTEC GmbH"  },
    { 0x29A3, "Cista System Corporation"  },
    { 0x29A4, "Source Audio LLC"  },
    { 0x29A5, "Harbo Entertainment LLC"  },
    { 0x29A6, "Chiyoda Electronics Co., Ltd."  },
    { 0x29A7, "Tekinvest Holding Ltd."  },
    { 0x29A8, "Lester Electrical"  },
    { 0x29A9, "Smartisan Technology Co., Ltd."  },
    { 0x29AA, "Zivix, LLC"  },
    { 0x29AB, "The Eye Tribe"  },
    { 0x29AC, "Cool Control (S.D.) Ltd."  },
    { 0x29AD, "Quest Engineering & Development, Inc."  },
    { 0x29AE, "Japan Lifeline Co., Ltd."  },
    { 0x29AF, "Zhongshan K-Mate General Electronics Co., Ltd."  },
    { 0x29B0, "Diebold Financial Equipment Co., Ltd."  },
    { 0x29B1, "Dongguan Haitai Precision Electronic Technology Co Ltd"  },
    { 0x29B2, "Canova Tech"  },
    { 0x29B3, "Dowling Software"  },
    { 0x29B4, "Shenzhen Carbetter Technology Co., Ltd."  },
    { 0x29B5, "PN Devices Int'l Limited"  },
    { 0x29B6, "Gowin Technology International Holdings Limited"  },
    { 0x29B7, "X.O.Ware, Inc."  },
    { 0x29B8, "Hawk-Owl Systems"  },
    { 0x29B9, "S.I.C.E.S. S.r.l."  },
    { 0x29BA, "TOPTICA Photonics AG"  },
    { 0x29BB, "SMUFS Biometric Solutions"  },
    { 0x29BC, "IMBEL - Industria de Material Belico do Brasil"  },
    { 0x29BD, "Silicon Works"  },
    { 0x29BE, "Mamiya-OP NEQUOS Co., Ltd."  },
    { 0x29BF, "BalanceMaster, Inc."  },
    { 0x29C0, "Canopy Co."  },
    { 0x29C1, "TazTag"  },
    { 0x29C2, "Lewitt GmbH"  },
    { 0x29C3, "Noviga"  },
    { 0x29C4, "SoundHawk Corporation"  },
    { 0x29C5, "Peachtree Audio"  },
    { 0x29C6, "Shenzhen Jiali Asia Industry Co., Ltd."  },
    { 0x29C7, "HANRICO ANFU ELECTRONICS CO., LTD."  },
    { 0x29C8, "Samil CTS Co., Ltd."  },
    { 0x29C9, "BEEVC-Electronic Systems, LDA"  },
    { 0x29CA, "Cross the Road Electronics, LLC"  },
    { 0x29CB, "Xima Software"  },
    { 0x29CC, "Kodak Alaris"  },
    { 0x29CD, "Carotron, Inc."  },
    { 0x29CE, "JGR Optics Inc."  },
    { 0x29CF, "Richtek Technology Corporation"  },
    { 0x29D0, "ShenZhen Synergy Digital Co., Ltd."  },
    { 0x29D1, "Binatone Electronics Int. Ltd."  },
    { 0x29D2, "Crypto Control Limited"  },
    { 0x29D3, "HESS Cash Systems GmbH & Co. KG"  },
    { 0x29D4, "Twin Development S.A."  },
    { 0x29D5, "Alibaba Cloud Computing Ltd."  },
    { 0x29D6, "Ara Hub Design Inc."  },
    { 0x29D7, "Suritel"  },
    { 0x29D8, "Vigor Electric Corporation"  },
    { 0x29D9, "San-Eisha, Ltd."  },
    { 0x29DA, "The Modal Shop"  },
    { 0x29DB, "Shenzhen iBoard Technology Co., Ltd."  },
    { 0x29DC, "TOHO Electronics Inc."  },
    { 0x29DD, "Embedded Micro"  },
    { 0x29DE, "Korea Electric Terminal Co., Ltd."  },
    { 0x29DF, "SMIT(HK) Limited"  },
    { 0x29E0, "ARCCRA Technology Co., Ltd."  },
    { 0x29E1, "TOSEI ENGINEERING CORP."  },
    { 0x29E2, "Huatune Technology (Shanghai) Co., Ltd."  },
    { 0x29E3, "Bio-Medical Research"  },
    { 0x29E4, "Prestigio Plaza Ltd."  },
    { 0x29E5, "Dongguan Kechenda Electronic Technology Co., Ltd."  },
    { 0x29E6, "Fengshun Peiying Electro-Acoustic Co., Ltd."  },
    { 0x29E7, "Brunel University"  },
    { 0x29E8, "4Links Limited"  },
    { 0x29E9, "Quanttus, Inc."  },
    { 0x29EA, "Kinesis Corporation"  },
    { 0x29EB, "Virtuix Inc."  },
    { 0x29EC, "R. Stahl"  },
    { 0x29ED, "CERA"  },
    { 0x29EE, "Pinnacle Response Ltd."  },
    { 0x29EF, "GamePop Inc."  },
    { 0x29F0, "WirePath Home Systems dba Snap AV"  },
    { 0x29F1, "0XF8 Limited"  },
    { 0x29F2, "RECO Gesellschaft fur Industriefilterregelung mbH"  },
    { 0x29F3, "Resonessence Labs"  },
    { 0x29F4, "NeuroSky, Inc."  },
    { 0x29F5, "AirNetix, LLC"  },
    { 0x29F6, "Evoko Unlimited AB"  },
    { 0x29F7, "Matica Technologies AG"  },
    { 0x29F8, "MD ELEKTRONIK GmbH"  },
    { 0x29F9, "EnerLab, LLC"  },
    { 0x29FA, "LogTag Recorders Ltd."  },
    { 0x29FB, "JSK Co., Ltd."  },
    { 0x29FC, "Namsung Corporation"  },
    { 0x29FD, "Bad Elf, LLC"  },
    { 0x29FE, "GEO Semiconductor Inc."  },
    { 0x29FF, "Thalmic Labs Inc."  },
    { 0x2A00, "NTLab"  },
    { 0x2A01, "Amuseway Korea Co., Ltd."  },
    { 0x2A02, "OJI LTD."  },
    { 0x2A03, "dog hunter AG"  },
    { 0x2A04, "Microtech Laboratory Inc."  },
    { 0x2A05, "EXO LABS INC."  },
    { 0x2A06, "HiFiMAN Electronics"  },
    { 0x2A07, "ise GmbH"  },
    { 0x2A08, "Marshall Amplification PLC"  },
    { 0x2A09, "cytonome"  },
    { 0x2A0A, "All Star International Trading"  },
    { 0x2A0B, "Leopard Imaging Inc."  },
    { 0x2A0C, "MultiSoft Systems Ltd."  },
    { 0x2A0D, "ADVANCE Co., Ltd."  },
    { 0x2A0E, "Shenzhen DreamSource Technology Co., Ltd."  },
    { 0x2A0F, "Shenzhen Giec Electronics Co., Ltd."  },
    { 0x2A10, "Powerway Electronics Co., Ltd."  },
    { 0x2A11, "P3 Ingenieurgesellschaft mbH"  },
    { 0x2A12, "Vreo Limited"  },
    { 0x2A13, "Grabba International"  },
    { 0x2A14, "Kanex"  },
    { 0x2A15, "navAero AB"  },
    { 0x2A16, "Hella Gutmann Solutions"  },
    { 0x2A17, "UDEA Electronic Ltd."  },
    { 0x2A18, "King Abdulaziz City for Science and Technology"  },
    { 0x2A19, "Numato Systems Pvt. Ltd."  },
    { 0x2A1A, "ASCOT GmbH"  },
    { 0x2A1B, "DRS Power & Control Technologies, Inc."  },
    { 0x2A1C, "ThinkWrite"  },
    { 0x2A1D, "Oxford Nanopore Technologies"  },
    { 0x2A1E, "Obsidian Technology"  },
    { 0x2A1F, "Lucent Trans Electronics Co., Ltd."  },
    { 0x2A20, "GUOGUANG GROUP CO., LTD."  },
    { 0x2A21, "ROL Ergo AB"  },
    { 0x2A22, "CDEX CORP."  },
    { 0x2A23, "Artec Design"  },
    { 0x2A24, "CNPLUS"  },
    { 0x2A25, "Fourstar Group"  },
    { 0x2A26, "Tragant International Co., Ltd."  },
    { 0x2A27, "DongGuan LianGang Optoelectronic Technology Co., Ltd."  },
    { 0x2A28, "Higbie, LLC dba kinetuex"  },
    { 0x2A29, "PayPal, Inc."  },
    { 0x2A2A, "TARGAMITE LLC"  },
    { 0x2A2B, "NooElec Inc."  },
    { 0x2A2C, "Bkav Corporation"  },
    { 0x2A2D, "Atrust Computer Corp."  },
    { 0x2A2E, "VIA Alliance Semiconductor Co., Ltd."  },
    { 0x2A2F, "BSUN Electronics Co., Ltd."  },
    { 0x2A30, "KORR Medical Technologies"  },
    { 0x2A31, "Sandia National Laboratories"  },
    { 0x2A32, "Centre for Advanced Transport Engineering and Research"  },
    { 0x2A33, "NTT R&D Laboratories"  },
    { 0x2A34, "KT System, Inc."  },
    { 0x2A35, "Quatius Limited"  },
    { 0x2A36, "MOS Co., Ltd."  },
    { 0x2A37, "RTD Embedded Technologies, Inc."  },
    { 0x2A38, "Electronic Design Inc."  },
    { 0x2A39, "RME GmbH"  },
    { 0x2A3A, "K'NEX Limited Partnership Group"  },
    { 0x2A3B, "Eschenbach Optik GmbH"  },
    { 0x2A3C, "TRINAMIC Motion Control GmbH & Co. KG"  },
    { 0x2A3D, "FIME"  },
    { 0x2A3E, "Atlas Copco"  },
    { 0x2A3F, "Yasunaga Corporation"  },
    { 0x2A40, "Shenzhen Choseal Industrial Co., Ltd."  },
    { 0x2A41, "Canyon Semiconductor"  },
    { 0x2A42, "Spectra7 Microsystems Corp."  },
    { 0x2A43, "Ekosur S.A."  },
    { 0x2A44, "FUEL3D Technologies Limited"  },
    { 0x2A45, "Meizu Technology Co., Ltd."  },
    { 0x2A46, "Hubei Yingtong Telecommunication Cable Inc."  },
    { 0x2A47, "Mundo Reader SL"  },
    { 0x2A48, "Pointmobile"  },
    { 0x2A49, "UNOWHY"  },
    { 0x2A4A, "threeRivers 3D, Inc."  },
    { 0x2A4B, "EMULEX Corporation"  },
    { 0x2A4C, "Tianjin SharpNow Technology Co., Ltd."  },
    { 0x2A4D, "Wilder Technologies"  },
    { 0x2A4E, "Henge Docks, LLC"  },
    { 0x2A4F, "L-3 Communications Avionics Systems"  },
    { 0x2A50, "Akizuki Denshi Tsusho Co., Ltd."  },
    { 0x2A51, "Multiclet Corp."  },
    { 0x2A52, "L CARD Ltd."  },
    { 0x2A53, "x-odos GmbH"  },
    { 0x2A54, "Black Diamond Advanced Technology, LLC"  },
    { 0x2A56, "eemagine Medical Imaging Solutions GmbH"  },
    { 0x2A57, "Bellingham + Stanley Limited"  },
    { 0x2A58, "ALIGN Corporation Limited"  },
    { 0x2A59, "The Whistler Group"  },
    { 0x2A5A, "Kromek Group Plc."  },
    { 0x2A5B, "Integrity Applications Ltd."  },
    { 0x2A5C, "Dalian Zonewin Electronics Co., Ltd."  },
    { 0x2A5D, "Zhejiang Wanli Jo Ju Automation Technonolgy Co., Ltd."  },
    { 0x2A5E, "The Chemours Company"  },
    { 0x2A5F, "Tencent Technology (Shenzhen) Company Limited"  },
    { 0x2A60, "Oscadi SAS"  },
    { 0x2A61, "Ellex Medical Pty Ltd."  },
    { 0x2A62, "Flymaster Avionics, LDA"  },
    { 0x2A63, "Postek Electronics Co., Ltd."  },
    { 0x2A64, "Zhejiang Songcheng Electronics Co., Ltd."  },
    { 0x2A65, "FreeWave Technologies, Inc."  },
    { 0x2A66, "JoyLabz LLC"  },
    { 0x2A67, "Chart Industries"  },
    { 0x2A68, "CheckSum, LLC"  },
    { 0x2A69, "EDIC Systems Inc."  },
    { 0x2A6A, "PINTSCH TIEFENBACH GmbH"  },
    { 0x2A6B, "VSN Mobil"  },
    { 0x2A6C, "Silego Technology"  },
    { 0x2A6D, "SAsync, LLC"  },
    { 0x2A6E, "Bare Conductive Ltd."  },
    { 0x2A6F, "Shenzhen Justtide Tech Co., Ltd."  },
    { 0x2A70, "Shenzhen Oneplus Science and Technology Co., Inc."  },
    { 0x2A71, "Eyelock, Inc."  },
    { 0x2A72, "Omega Engineering"  },
    { 0x2A73, "IMAC Co., Ltd."  },
    { 0x2A74, "Innoflight Tech., Ltd."  },
    { 0x2A75, "Delta Dansk Elektronik, Lys & Akustik"  },
    { 0x2A76, "Microsemi Corporation (Phoenix)"  },
    { 0x2A77, "American Printing House for the Blind"  },
    { 0x2A78, "mySkin, Inc."  },
    { 0x2A79, "S.E. Technologies Limited"  },
    { 0x2A7A, "Beijing Casue Technology Co., Ltd."  },
    { 0x2A7B, "Bellwether Electronic Corp."  },
    { 0x2A7C, "Acute Technology Inc."  },
    { 0x2A7D, "ParTech, Inc."  },
    { 0x2A7E, "VAIO Corporation"  },
    { 0x2A7F, "Perixx Computer GmbH"  },
    { 0x2A80, "Smart Start Inc."  },
    { 0x2A81, "Hale Products, Inc."  },
    { 0x2A82, "Printek, Inc."  },
    { 0x2A83, "Autodesk Inc."  },
    { 0x2A84, "ATE Systems"  },
    { 0x2A85, "HANK ELECTRONICS CO., LTD"  },
    { 0x2A86, "KITRIS AG"  },
    { 0x2A87, "Kummler + Matter AG"  },
    { 0x2A88, "DFU Technology Ltd."  },
    { 0x2A89, "Robert Bosch Tool Corporation"  },
    { 0x2A8A, "Benchmark Drives GmbH & Co. KG"  },
    { 0x2A8B, "I.C. Lercher GmbH & Co. KG"  },
    { 0x2A8C, "Sonnet Technologies, Inc."  },
    { 0x2A8D, "Keysight Technologies Inc."  },
    { 0x2A8E, "Starlink Electronics Corp."  },
    { 0x2A8F, "Manutronics Vietnam Joint Stock Company"  },
    { 0x2A90, "NowComputing, LLC"  },
    { 0x2A91, "Seed Industrial Designing Co., Ltd."  },
    { 0x2A92, "Woosim Systems Inc."  },
    { 0x2A93, "Enblink Co., Ltd."  },
    { 0x2A94, "G2 Touch Co., Ltd."  },
    { 0x2A95, "Flipkart Internet Pvt. Ltd."  },
    { 0x2A96, "Micromax Informatics Ltd"  },
    { 0x2A97, "Broadway Semiconductor, Inc."  },
    { 0x2A98, "Calix"  },
    { 0x2A99, "Humanistic Robotics, Inc."  },
    { 0x2A9A, "SRAM, LLC"  },
    { 0x2A9B, "Doblet Inc."  },
    { 0x2A9C, "Olorin AB"  },
    { 0x2A9D, "LawMate International Co., Ltd."  },
    { 0x2A9E, "SEIKO SOLUTIONS Inc."  },
    { 0x2A9F, "Mobelisk LLC"  },
    { 0x2AA0, "Casco Products Corp."  },
    { 0x2AA1, "Ivanhoe (DE), Inc."  },
    { 0x2AA2, "GTI Spindle Technology, Inc."  },
    { 0x2AA3, "Strike Technologies a Division of Penbro Kelnick (Pty) Ltd"  },
    { 0x2AA4, "Voim Technologies Inc."  },
    { 0x2AA5, "Pen Generations, Inc."  },
    { 0x2AA6, "ChengFong International Limited"  },
    { 0x2AA7, "MJC Techno Co., Ltd."  },
    { 0x2AA8, "Resus Industries NV"  },
    { 0x2AA9, "Infrared Cameras Inc."  },
    { 0x2AAA, "Virtium Technology, Inc."  },
    { 0x2AAB, "Field and Company LLC, dba Leef USA"  },
    { 0x2AAC, "Elinchrom S.A."  },
    { 0x2AAD, "iCatch Technology, Inc."  },
    { 0x2AAE, "Chipone Technology (Beijing) Co., Ltd."  },
    { 0x2AAF, "Xiamen Hanin Electronic Technology Co., Ltd."  },
    { 0x2AB0, "GM Global Technology Operations LLC"  },
    { 0x2AB1, "Tesco Stores Ltd."  },
    { 0x2AB2, "Maktar, Inc."  },
    { 0x2AB3, "Key Asic Inc."  },
    { 0x2AB4, "Line Seiki Co., Ltd."  },
    { 0x2AB5, "Micro-Technica Co., Ltd."  },
    { 0x2AB6, "T+A Elektroakustik GmbH + Co. KG"  },
    { 0x2AB7, "foc.us"  },
    { 0x2AB8, "Meggitt (Orange County), Inc."  },
    { 0x2AB9, "Monsoon Solutions, Inc."  },
    { 0x2ABA, "MagneMotion Inc."  },
    { 0x2ABB, "HiDeep Inc."  },
    { 0x2ABC, "Beijing Kingrich Medical Technology Co., Ltd."  },
    { 0x2ABD, "Meeteasy Technology Limited"  },
    { 0x2ABE, "Bluink Ltd"  },
    { 0x2ABF, "Revolabs, Inc."  },
    { 0x2AC0, "POWA Technologies Ltd."  },
    { 0x2AC1, "Lattice Semiconductor Corp"  },
    { 0x2AC2, "Toreck Co., Ltd."  },
    { 0x2AC3, "Foshan Nanhai Saga Audio Equipment Co., Ltd."  },
    { 0x2AC4, "BlackBox Biometrics, Inc."  },
    { 0x2AC5, "PhotoFast Co., Ltd."  },
    { 0x2AC6, "HAKKO Corporation"  },
    { 0x2AC7, "Ultrahaptics Limited"  },
    { 0x2AC8, "SimonsVoss Technologies GmbH"  },
    { 0x2AC9, "TELPA Telekomunikasyon Tic. A.S. Brand: General Mobile"  },
    { 0x2ACA, "Toledo do Brasil Industria de Balancas Ltda."  },
    { 0x2ACB, "Pole/Zero Acquisition, Inc."  },
    { 0x2ACC, "illunis LLC"  },
    { 0x2ACD, "Silergy Corp."  },
    { 0x2ACE, "Tonetron Electronic Ltd."  },
    { 0x2ACF, "Ruffy Controls Inc."  },
    { 0x2AD0, "Holley Performance Products (CANADA) Inc."  },
    { 0x2AD1, "Pictronic GmbH"  },
    { 0x2AD2, "Allnic Audio"  },
    { 0x2AD3, "Shenzhen Hali-Power Industrial Co., Ltd."  },
    { 0x2AD4, "L&F Corporation"  },
    { 0x2AD5, "Baikal Electronics JSC"  },
    { 0x2AD6, "Cozumo, Inc."  },
    { 0x2AD7, "RHENAC Systems GmbH"  },
    { 0x2AD8, "i2s"  },
    { 0x2AD9, "Zound Industries International AB"  },
    { 0x2ADA, "McCarthy Music Corp."  },
    { 0x2ADB, "I-PEX (Dai-ichi Seiko)"  },
    { 0x2ADC, "Absolute USA"  },
    { 0x2ADD, "SEE-PLUS INDUSTRIAL LTD."  },
    { 0x2ADE, "Orga BV"  },
    { 0x2ADF, "Noiseless Security A/S"  },
    { 0x2AE0, "Auma Riester GmbH & Co. KG"  },
    { 0x2AE1, "EDEC PROGRESS CO., LTD."  },
    { 0x2AE2, "VXi Corporation"  },
    { 0x2AE3, "Jiuzhou Digital (Hong Kong) Limited"  },
    { 0x2AE4, "Next! s.c. Slawomir Piela, Bartlomiej Dryja"  },
    { 0x2AE5, "Fairphone B.V."  },
    { 0x2AE6, "e-distribuzione Spa"  },
    { 0x2AE7, "Advanced Media, Inc."  },
    { 0x2AE8, "Quintic Microelectronics (Wuxi) Co., Ltd."  },
    { 0x2AE9, "Regal Beloit Canada ULC. dba Thomson Power Systems"  },
    { 0x2AEA, "Protonex Technology Corporation"  },
    { 0x2AEB, "NovaTech, LLC"  },
    { 0x2AEC, "Ambiq Micro, Inc."  },
    { 0x2AED, "Technology Launch, LLC"  },
    { 0x2AEE, "Adapt-IP Company"  },
    { 0x2AEF, "Coronado Electronics, Inc."  },
    { 0x2AF0, "Zhejiang Yuesui Electron Stock Co., Ltd."  },
    { 0x2AF1, "Innovation Spring Tech, Inc."  },
    { 0x2AF2, "CIS Corporation"  },
    { 0x2AF3, "Rehan Electronics Ltd."  },
    { 0x2AF4, "ROLI Ltd."  },
    { 0x2AF5, "Libratone A/S"  },
    { 0x2AF6, "Nix Sensor Ltd."  },
    { 0x2AF7, "Shenzhen Hazens Automotive Electronics (SZ) Co., Ltd."  },
    { 0x2AF8, "Jiangsu Toppower Automotive Electronics Co., Ltd."  },
    { 0x2AF9, "Drapho Electronics Technology Co., Ltd."  },
    { 0x2AFA, "Yokogawa Digital Computer Corporation"  },
    { 0x2AFB, "EMC, Electronic Music Components"  },
    { 0x2AFC, "Savox Communications OY AB"  },
    { 0x2AFD, "McIntosh Laboratory, Inc."  },
    { 0x2AFE, "IntriCon"  },
    { 0x2AFF, "ARP Corporation"  },
    { 0x2B00, "Novitec Co., Ltd."  },
    { 0x2B01, "Zimi Corporation"  },
    { 0x2B02, "AMGOO Telecom Co., Ltd."  },
    { 0x2B03, "STEREOLABS"  },
    { 0x2B04, "Spark Labs, Inc."  },
    { 0x2B05, "Warn Industries"  },
    { 0x2B06, "TEControl"  },
    { 0x2B07, "ESA Elektroschaltanlagen Grimma GmbH"  },
    { 0x2B08, "KYOEI ENGINEERING Co., Ltd."  },
    { 0x2B09, "Shenzhen Lidacheng Technology Co., Ltd."  },
    { 0x2B0A, "AMICCOM Electronics Corporation"  },
    { 0x2B0B, "Qtul Enterprises"  },
    { 0x2B0C, "Goclever Sp z o.o."  },
    { 0x2B0D, "Dongguan Yulian Electronic Industrial Co., Ltd."  },
    { 0x2B0E, "Le Shi Zhi Xin Electronic Technology (Tian Jin) Limited"  },
    { 0x2B0F, "Best Integration Technology Co., Ltd."  },
    { 0x2B10, "Cardiac Insight, Inc."  },
    { 0x2B11, "Europe Net Srl"  },
    { 0x2B12, "DeepSpar"  },
    { 0x2B13, "Lightcomm Technology Co., Ltd."  },
    { 0x2B14, "EverPro Technologies Company, Ltd."  },
    { 0x2B15, "Rosenberger Hochfrequenztechnik"  },
    { 0x2B16, "Spirometrix, Inc."  },
    { 0x2B17, "Jaguar Land Rover"  },
    { 0x2B18, "ProSign GmbH"  },
    { 0x2B19, "JBSignal Co."  },
    { 0x2B1A, "Fortune Ship Technology (HK) Limited"  },
    { 0x2B1B, "Dongguan City Sanji Electronics Co., Ltd."  },
    { 0x2B1C, "Shenzhen Virtual Reality Technology Company Limited"  },
    { 0x2B1D, "Lintes Technology Co., Ltd."  },
    { 0x2B1E, "NFUZD Technology Inc"  },
    { 0x2B1F, "KinnexA, Inc."  },
    { 0x2B20, "WaveLynx Technologies Corporation"  },
    { 0x2B21, "Project Florida"  },
    { 0x2B22, "Metra Electronics Corp."  },
    { 0x2B23, "Red Hat, Inc."  },
    { 0x2B24, "KeepKey, LLC"  },
    { 0x2B25, "Logos Biosystems, Inc."  },
    { 0x2B26, "Oltrade LLC"  },
    { 0x2B27, "FluxData Incorporated"  },
    { 0x2B28, "Enovation Controls, LLC"  },
    { 0x2B29, "Lezyne"  },
    { 0x2B2A, "BDX"  },
    { 0x2B2B, "BITwave PTE LTD."  },
    { 0x2B2C, "S1nn GmbH & Co. KG"  },
    { 0x2B2D, "AEG Power Solutions GmbH"  },
    { 0x2B2E, "pei tel Communications GmbH"  },
    { 0x2B2F, "UL TS B.V."  },
    { 0x2B30, "Neratec Solutions AG"  },
    { 0x2B31, "JVIS USA, LLC"  },
    { 0x2B32, "NVS Technologies AG"  },
    { 0x2B33, "Commend International GmbH"  },
    { 0x2B34, "Seemahale Telecoms"  },
    { 0x2B35, "Assem Technology Co., Ltd."  },
    { 0x2B36, "Dongguan City Jianghan Electronics Co., Ltd."  },
    { 0x2B37, "Huizhou Desay SV Automotive Co., Ltd."  },
    { 0x2B38, "Ningbo Rixing Electronics Co., Ltd."  },
    { 0x2B39, "KANAI ELECTRONIC APPLIANCE Co., Ltd."  },
    { 0x2B3A, "Cirrus Research plc"  },
    { 0x2B3B, "ScriptPro, LLC"  },
    { 0x2B3C, "Technikos Sports Inc."  },
    { 0x2B3D, "GuangDong YuanFeng Automotive Electroics Co., Ltd."  },
    { 0x2B3E, "NewAE Technology Inc."  },
    { 0x2B3F, "ATL-SD Co., Ltd."  },
    { 0x2B40, "Matsumura Engineering Co., Ltd."  },
    { 0x2B41, "Image Match Design Inc."  },
    { 0x2B42, "NEXO S.A."  },
    { 0x2B43, "Doro AB"  },
    { 0x2B44, "Wildfire, Inc."  },
    { 0x2B45, "PRA Audio Systems, Inc."  },
    { 0x2B46, "Centerm Information Co., Ltd."  },
    { 0x2B47, "Huizhou Aorora Science & Technology Co., Ltd."  },
    { 0x2B48, "Sounding Audio Industrial Limited"  },
    { 0x2B49, "GECO Incorporated"  },
    { 0x2B4A, "Yueqing Huaxin Electronic Co., Ltd."  },
    { 0x2B4B, "China Hualu Group Co., Ltd."  },
    { 0x2B4C, "Beijing SHENQI Technology Co., Ltd."  },
    { 0x2B4D, "SMC Corporation"  },
    { 0x2B4E, "Microcabin Inc."  },
    { 0x2B4F, "Aeroscout Ltd. (Stanley Healthcare)"  },
    { 0x2B50, "Denchi Power Ltd."  },
    { 0x2B51, "Pax Instruments"  },
    { 0x2B52, "Dongguan Evermax Electronics Technology Co., Ltd."  },
    { 0x2B53, "Shenzhen Supernature Multimedia Co., Ltd."  },
    { 0x2B54, "AMPAK Technology Inc."  },
    { 0x2B55, "FUJIFILM Imaging Systems Co., Ltd."  },
    { 0x2B56, "The Crypto Group"  },
    { 0x2B57, "GIROPTIC"  },
    { 0x2B58, "DJ Sound Electronics, LLC / BiZi Inc."  },
    { 0x2B59, "ESI Motion"  },
    { 0x2B5A, "Universal Audio, Inc."  },
    { 0x2B5B, "Xiamen Home Meitu Technology Co., Ltd."  },
    { 0x2B5C, "B&B Exporting Limited"  },
    { 0x2B5D, "GSL Solutions, Inc."  },
    { 0x2B5E, "Audio Alchemy"  },
    { 0x2B5F, "b-plus GmbH"  },
    { 0x2B60, "Viking Technology"  },
    { 0x2B61, "Universal Biosensors, Inc."  },
    { 0x2B62, "ICP Entwicklungs GmbH"  },
    { 0x2B63, "Inora Technologies, Inc."  },
    { 0x2B64, "Cyanogen Inc."  },
    { 0x2B65, "Atelier Vision Corporation"  },
    { 0x2B66, "Clinton Instrument Company"  },
    { 0x2B67, "Lifesize, Inc."  },
    { 0x2B68, "FLEXIM - Flexible Industriemesstechnik GmbH"  },
    { 0x2B69, "Humax Automotive Co., Ltd."  },
    { 0x2B6A, "FUJI TECOM INC."  },
    { 0x2B6B, "Colorix SA"  },
    { 0x2B6C, "Transbit Sp. z o.o."  },
    { 0x2B6D, "SATORI ELECTRIC CO., LTD."  },
    { 0x2B6E, "Airviz Inc."  },
    { 0x2B6F, "Revolution Education Ltd."  },
    { 0x2B70, "Micran, Research & Production Company"  },
    { 0x2B71, "Zhejiang Flashforge 3D Technology Co., Ltd."  },
    { 0x2B72, "RT Corporation"  },
    { 0x2B73, "Pioneer DJ Corporation"  },
    { 0x2B74, "Embedded Intelligence, Inc."  },
    { 0x2B75, "New Matter"  },
    { 0x2B76, "Shanghai Wingtech Electronic Technology Co., Ltd."  },
    { 0x2B77, "Epiphan Systems Inc."  },
    { 0x2B78, "Elyctis"  },
    { 0x2B79, "Radio Sound, Inc."  },
    { 0x2B7A, "Spin Master Far East Ltd."  },
    { 0x2B7B, "Gigaset Digital Technology (Shenzhen) Co., Ltd."  },
    { 0x2B7C, "Noveltek Semiconductor Corp."  },
    { 0x2B7D, "ZEITEC Semiconductor Co., Ltd."  },
    { 0x2B7E, "Shenzhen Kingcome Optoelectronic Co., Ltd."  },
    { 0x2B7F, "NanoTS Co., Ltd."  },
    { 0x2B80, "Miyuki Giken Co., Ltd."  },
    { 0x2B81, "PULAX Corporation"  },
    { 0x2B82, "TELE RADIO AB"  },
    { 0x2B83, "Silicon Line GmbH"  },
    { 0x2B84, "Ever Win International Corp."  },
    { 0x2B85, "YICHUN YILIAN PRINT TECH CO., LTD."  },
    { 0x2B86, "MITSUBISHI HITACHI POWER SYSTEMS ENGINEERING CO., LTD."  },
    { 0x2B87, "ATP Industries Group Ltd."  },
    { 0x2B88, "Socionext Inc."  },
    { 0x2B89, "Ugreen Group Limited"  },
    { 0x2B8A, "Shanghai Pateo Electronic Equipment Mfg. Co., Ltd."  },
    { 0x2B8B, "Inner Mongolia Yinan Science & Technology Dev. Co., Ltd"  },
    { 0x2B8C, "EDGE I&D"  },
    { 0x2B8D, "Dr. Fritz Faulhaber GmbH & Co. KG"  },
    { 0x2B8E, "Pentair PLC"  },
    { 0x2B8F, "DxO Labs Corp."  },
    { 0x2B90, "ACR Braendli & Voegeli AG"  },
    { 0x2B91, "The Fredericks Company"  },
    { 0x2B92, "i-BLADES, Inc."  },
    { 0x2B93, "Altia Systems Inc."  },
    { 0x2B94, "ShenZhen Baoyuanda Electronics Co., Ltd."  },
    { 0x2B95, "iST - Integrated Service Technology Inc."  },
    { 0x2B96, "HYUNDAI MOBIS Co., Ltd."  },
    { 0x2B97, "Digen Co., Ltd."  },
    { 0x2B98, "Glenair, Inc."  },
    { 0x2B99, "360fly, Inc."  },
    { 0x2B9A, "HUIZHOU CHENG SHUO HARDWARE PLASTIC CO., LTD."  },
    { 0x2B9B, "Zhongshan Aute Electronics Technology Co., Ltd."  },
    { 0x2B9C, "Guangdong King Link Industrial Co., Ltd."  },
    { 0x2B9D, "HARTING Electric GmbH & Co. KG"  },
    { 0x2B9E, "ZPower LLC"  },
    { 0x2B9F, "Scietera Technologies, Inc."  },
    { 0x2BA0, "InVue Security Products"  },
    { 0x2BA1, "I-Sheng Electric Wire & Cable Co., Ltd."  },
    { 0x2BA2, "China Daheng Group Inc Beijing Image Vision Tech Branch"  },
    { 0x2BA3, "Shenzhen FeiTianXia Technology Ltd."  },
    { 0x2BA4, "Shenzhen HengJia New Energy Auto Part Co., Ltd."  },
    { 0x2BA5, "Yueguan Network Technology (Shanghai) Co., Ltd."  },
    { 0x2BA6, "Cyberith GmbH"  },
    { 0x2BA7, "77 Elektronika Kft."  },
    { 0x2BA8, "YUDU EASON ELECTRONIC CO., LTD."  },
    { 0x2BA9, "YanFeng Visteon Automotive Electronics Co., Ltd."  },
    { 0x2BAA, "New World Technologies Inc."  },
    { 0x2BAB, "Grandstream Networks, Inc."  },
    { 0x2BAC, "Polyera Corporation"  },
    { 0x2BAD, "XinJi Technologies Ltd."  },
    { 0x2BAE, "Holinail H.K. Limited"  },
    { 0x2BAF, "Getac Technology Corp."  },
    { 0x2BB0, "ITES Co., Ltd."  },
    { 0x2BB1, "Validata LLC"  },
    { 0x2BB2, "HIDEX OY"  },
    { 0x2BB3, "Elcoa Industria e Comercio Ltda"  },
    { 0x2BB4, "PRINK Srl"  },
    { 0x2BB5, "Silk ID Systems"  },
    { 0x2BB6, "3D Imaging & Simulations Corp. (3DISC)"  },
    { 0x2BB7, "Dongguan ChengXiang Industrial Co., Ltd."  },
    { 0x2BB8, "OCC (Zhuhai) Electronic Co., Ltd."  },
    { 0x2BB9, "ARGUS-SPECTRUM"  },
    { 0x2BBA, "Sinseader Electronic Co., Ltd."  },
    { 0x2BBB, "DONGGUAN YELLOW KNIFE Industrial Co., Ltd."  },
    { 0x2BBC, "Guided Ultrasonics Ltd"  },
    { 0x2BBD, "RF Creations Ltd."  },
    { 0x2BBE, "Chengyi Semiconductors (Shanghai) Co., Ltd."  },
    { 0x2BBF, "Shenzhen Shinning Electronic Co., Ltd."  },
    { 0x2BC0, "Shenzhen WFD Electronics Co., Ltd."  },
    { 0x2BC1, "Dongguan Sino Syncs Industrial Co., Ltd."  },
    { 0x2BC2, "JNTC Co., Ltd."  },
    { 0x2BC3, "Nihon Mechatronics Co., Ltd."  },
    { 0x2BC4, "SR Research Ltd."  },
    { 0x2BC5, "Orbbec 3D Tech. Int'l Inc."  },
    { 0x2BC6, "Server Technology, Inc."  },
    { 0x2BC7, "Zounds Hearing Inc."  },
    { 0x2BC8, "DONGGUAN POLIXIN ELECTRIC CO., LTD."  },
    { 0x2BC9, "Tama Electric (Suzhou) Co., Ltd."  },
    { 0x2BCA, "Exvision, Inc."  },
    { 0x2BCB, "Tanaka Electric Industry Co., Ltd."  },
    { 0x2BCC, "InoTec GmbH Organisationssysteme"  },
    { 0x2BCD, "Keyprocessor BV"  },
    { 0x2BCE, "UV Partners"  },
    { 0x2BCF, "Magtrol, Inc."  },
    { 0x2BD0, "mophie, LLC"  },
    { 0x2BD1, "Spectran LLC"  },
    { 0x2BD2, "Nabtesco Corporation"  },
    { 0x2BD3, "Dongguan ULT-unite electronic technology co., LTD"  },
    { 0x2BD4, "JL Audio, Inc."  },
    { 0x2BD5, "Cable Matters Inc."  },
    { 0x2BD6, "CoroWare, Inc."  },
    { 0x2BD7, "EcuTek International Ltd."  },
    { 0x2BD8, "ROPEX Industrie-Elektronik GmbH"  },
    { 0x2BD9, "Huddly"  },
    { 0x2BDA, "Panono GmbH"  },
    { 0x2BDB, "LOVEOX CO., LTD."  },
    { 0x2BDC, "Automation Electronics Inc."  },
    { 0x2BDD, "Charm Sciences Inc."  },
    { 0x2BDE, "Pickering Interfaces Limited"  },
    { 0x2BDF, "Hangzhou Hikvision Digital Technology Co., Ltd."  },
    { 0x2BE0, "Fullink Technology Co., Ltd"  },
    { 0x2BE1, "AutoChips Inc."  },
    { 0x2BE2, "Electric Connector Technology Co., Ltd."  },
    { 0x2BE3, "Hydac Electronic GmbH"  },
    { 0x2BE4, "Cojali S.L. ES-B13210489"  },
    { 0x2BE5, "LELTEK"  },
    { 0x2BE6, "Dongguan KaiWin Electronics Co., Ltd."  },
    { 0x2BE7, "BEFS Co., Ltd."  },
    { 0x2BE8, "Archisite, Inc."  },
    { 0x2BE9, "Magneti Marelli S.p.A Electr BL"  },
    { 0x2BEA, "Inspire Medical Systems"  },
    { 0x2BEB, "Gateworks Corporation"  },
    { 0x2BEC, "Lumantek Co., Ltd."  },
    { 0x2BED, "Econoburn LLC"  },
    { 0x2BEE, "Ventev Mobile"  },
    { 0x2BEF, "Quanta Storage Inc."  },
    { 0x2BF0, "Tech-Top Technology Limited"  },
    { 0x2BF1, "Murakami Color Research Laboratory"  },
    { 0x2BF2, "ABB India Limited"  },
    { 0x2BF3, "Photek Ltd."  },
    { 0x2BF4, "Thunderbird International DBA Spectec"  },
    { 0x2BF5, "Shenzhen YOOBAO Technology Co., Ltd."  },
    { 0x2BF6, "Shenzhen Sinotek Technology Co., Ltd."  },
    { 0x2BF7, "KEYW"  },
    { 0x2BF8, "Visual Land Inc."  },
    { 0x2BF9, "Poynt Co."  },
    { 0x2BFA, "High Country Tek"  },
    { 0x2BFB, "Strattec Advanced Logic, LLC"  },
    { 0x2BFC, "Sulon Technologies Inc."  },
    { 0x2BFD, "Kinematics GmbH"  },
    { 0x2BFE, "Novexx Solutions GmbH"  },
    { 0x2BFF, "Shindengen Electric Mfg. Co., Ltd."  },
    { 0x2C00, "MEEM SL Ltd"  },
    { 0x2C01, "Dongguan Arin Electronics Technology Co., Ltd."  },
    { 0x2C02, "DongGuan City JianNuo Electronics Co., Ltd."  },
    { 0x2C03, "Barrett Communications Pty. Ltd."  },
    { 0x2C04, "Shenzhen XOX Electronics Co., Ltd."  },
    { 0x2C05, "Protop International Inc."  },
    { 0x2C06, "Microsemi Semiconductor (US) Inc."  },
    { 0x2C07, "Webcloak LLC"  },
    { 0x2C08, "INVECAS INC."  },
    { 0x2C09, "Prediktor Medical AS"  },
    { 0x2C0A, "ATANS Technology Inc."  },
    { 0x2C0B, "Triple Win Precision Technology Co., Ltd."  },
    { 0x2C0C, "IC Realtech"  },
    { 0x2C0D, "Embrava Pty Ltd"  },
    { 0x2C0E, "Unity Scientific"  },
    { 0x2C0F, "Mantra Softech (India) Pvt Ltd"  },
    { 0x2C10, "Sinotronics Co., Ltd."  },
    { 0x2C11, "ALLBEST ELECTRONICS TECHNOLOGY CO., LTD."  },
    { 0x2C12, "Shenzhen Xin Kai Feng Electronics Factory"  },
    { 0x2C13, "MOST WELL Technology Corp."  },
    { 0x2C14, "Buffalo Memory Co., Ltd."  },
    { 0x2C15, "Xentris Wireless"  },
    { 0x2C16, "Priferential Accessories Ltd"  },
    { 0x2C17, "SVS-VISTEK GmbH"  },
    { 0x2C18, "Euclideon Pty. Ltd."  },
    { 0x2C19, "Sunlike Technology Co., Ltd."  },
    { 0x2C1A, "Young Fast Optoelectronics Co., Ltd."  },
    { 0x2C1B, "ISAW Camera Inc"  },
    { 0x2C1C, "Daesung Eltec., Ltd"  },
    { 0x2C1D, "Makita Corporation"  },
    { 0x2C1E, "Global Fire Equipment S.A."  },
    { 0x2C1F, "Cashmaster International Limited"  },
    { 0x2C20, "Pulsar Instruments Plc."  },
    { 0x2C21, "Prynt Corp."  },
    { 0x2C22, "Qanba USA, LLC"  },
    { 0x2C23, "Super Micro Computer Inc."  },
    { 0x2C24, "SONOTEC Ultraschallsensorik Halle GmbH"  },
    { 0x2C25, "Shanghai TAIDU INTELLIGENT TECHNOLOGY CO., LTD."  },
    { 0x2C26, "Micromax International Corporation"  },
    { 0x2C27, "YAWATA Electric Industrial Co., Ltd."  },
    { 0x2C28, "Granite River Labs Japan Ltd."  },
    { 0x2C29, "Coagent Enterprise Limited"  },
    { 0x2C2A, "LEIA Inc."  },
    { 0x2C2B, "NetScout Systems, Inc."  },
    { 0x2C2C, "Fortify Technologies, LLC"  },
    { 0x2C2D, "Shenzhen Ebull Technology Limited"  },
    { 0x2C2E, "Hualun Technology Co., Ltd."  },
    { 0x2C2F, "Sensel, Inc."  },
    { 0x2C30, "Ariadne's Thread (USA), Inc. dba Immerex"  },
    { 0x2C31, "tinnos"  },
    { 0x2C32, "MCS Micronic Computer Systeme GmbH"  },
    { 0x2C33, "Shinobiya.com Co., Ltd."  },
    { 0x2C34, "Xerox Business Services (Switzerland) AG"  },
    { 0x2C35, "Decto, Inc."  },
    { 0x2C36, "Bonsai Lab, Inc."  },
    { 0x2C37, "Shenzhen Adition Audio Science & Technology Co., Ltd."  },
    { 0x2C38, "Goldenconn Electronics Technology (Suzhou) Co., Ltd."  },
    { 0x2C39, "JIB Electronics Technology Co., Ltd."  },
    { 0x2C3A, "Changzhou Shinco Automotive Electronics Co., Ltd."  },
    { 0x2C3B, "Shenzhen Hangsheng Electronics Corp., Ltd."  },
    { 0x2C3C, "Beartooth Radio, Inc."  },
    { 0x2C3D, "Audience, A Knowles Company"  },
    { 0x2C3E, "Verizon Telematics, Inc."  },
    { 0x2C3F, "Nextbit Systems, Inc."  },
    { 0x2C40, "Leadtrend"  },
    { 0x2C41, "Adaptertek Technology Co., Ltd."  },
    { 0x2C42, "Feature Integration Technology Inc."  },
    { 0x2C43, "Avegant Corporation"  },
    { 0x2C44, "Digital Design Corporation"  },
    { 0x2C45, "Reid Heath Ltd."  },
    { 0x2C46, "Soehnle Industrial Solutions GmbH"  },
    { 0x2C47, "Chunghsin International Electronics Co., Ltd."  },
    { 0x2C48, "Delphi Electrical Centers (Shanghai) Co., Ltd."  },
    { 0x2C49, "Chikuma Seiki Co., Ltd."  },
    { 0x2C4A, "System Industrie Electronic GmbH"  },
    { 0x2C4B, "Huntleigh Healthcare Ltd."  },
    { 0x2C4C, "Double Robotics, Inc."  },
    { 0x2C4D, "VVETEK DOO"  },
    { 0x2C4E, "Mercusys Technologies Co., Limited"  },
    { 0x2C4F, "Canon Electronic Business Machines (H.K.) Co., Ltd."  },
    { 0x2C50, "Vinghog AS"  },
    { 0x2C51, "Lambda Acoustic"  },
    { 0x2C52, "Comio Communication Co., Ltd."  },
    { 0x2C53, "Huizhou Foryou General Electronics Co., Ltd."  },
    { 0x2C54, "LifeWatch Technologies Ltd."  },
    { 0x2C55, "Magicleap"  },
    { 0x2C56, "Pocket Radar Inc."  },
    { 0x2C57, "BMT Messtechnik GmbH"  },
    { 0x2C58, "Dyden Corporation"  },
    { 0x2C59, "EBARA CORPORATION"  },
    { 0x2C5A, "Mobilus Automotive Inc"  },
    { 0x2C5B, "Shenglan Technology Co. Ltd"  },
    { 0x2C5C, "Neusoft Corporation"  },
    { 0x2C5D, "SIP Simya Electronics Technology Co., Ltd."  },
    { 0x2C5E, "ELVES Automotive Co., Ltd"  },
    { 0x2C5F, "YOODS Co., Ltd."  },
    { 0x2C60, "Sirin LABS AG"  },
    { 0x2C61, "Jadmam Corporation dba: Boytone"  },
    { 0x2C62, "Trice Medical"  },
    { 0x2C63, "Electronica Steren, S.A. de C.V."  },
    { 0x2C64, "Creaform Inc. (Ametek Ultra Precision Technologies)"  },
    { 0x2C65, "Nokia Technologies"  },
    { 0x2C66, "EMOTIQ srl"  },
    { 0x2C67, "VentureCraft, Ltd."  },
    { 0x2C68, "EMRight Technology Co., Ltd."  },
    { 0x2C69, "BBPOS Limited"  },
    { 0x2C6A, "Joint Stock Company Research Centre Module"  },
    { 0x2C6B, "System JD Co., Ltd"  },
    { 0x2C6C, "Nano TouchSystems co., Ltd."  },
    { 0x2C6D, "Gibson Innovations"  },
    { 0x2C6E, "Shen Zhen Xian Shuo Technology Co. Ltd."  },
    { 0x2C6F, "PST Eletronica LTDA"  },
    { 0x2C70, "PERI, Inc."  },
    { 0x2C71, "Bozhou BoTong Information Technology Co., Ltd."  },
    { 0x2C72, "BlueberryE GmbH"  },
    { 0x2C73, "Qiku Internet Network Scientific (Shenzhen) Co., Ltd."  },
    { 0x2C74, "CJSC Nordavind"  },
    { 0x2C75, "Net And Print Inc."  },
    { 0x2C76, "DATAPATH LTD"  },
    { 0x2C77, "Profindustry GmbH"  },
    { 0x2C78, "BRAGI GmbH"  },
    { 0x2C79, "WAWGD, Inc. (DBA: Foresight Sports)"  },
    { 0x2C7A, "AutoNavi Software Co., Ltd."  },
    { 0x2C7B, "Beijing ASU Tech Co., Ltd."  },
    { 0x2C7C, "Anysmart Technologies Co., Ltd."  },
    { 0x2C7D, "Shenzhen Protruly Electronic Co., Ltd."  },
    { 0x2C7E, "Dongguan Allpass Electronic Co., Ltd."  },
    { 0x2C7F, "SHENZHEN D-VITEC INDUSTRIAL CO., LTD."  },
    { 0x2C80, "motomobile AG"  },
    { 0x2C81, "Indie Semiconductor"  },
    { 0x2C82, "Cloud9 Technologies LLC"  },
    { 0x2C83, "LRP electronic GmbH"  },
    { 0x2C84, "Innodezign MauRitius Limited"  },
    { 0x2C85, "Audientes"  },
    { 0x2C86, "Ultraflux"  },
    { 0x2C87, "ISKN"  },
    { 0x2C88, "K-Tronic SRL"  },
    { 0x2C89, "Younes Medical Technologies"  },
    { 0x2C8A, "Advanced Casino Electronics"  },
    { 0x2C8B, "Huizhou Dehong Technology Co., Ltd."  },
    { 0x2C8C, "PowerCenter Technology Limited"  },
    { 0x2C8D, "Mizco International, Inc."  },
    { 0x2C8E, "Unique Secure Limited"  },
    { 0x2C8F, "Regulus Company Ltd."  },
    { 0x2C90, "I. AM. PLUS, LLC"  },
    { 0x2C91, "Corigine, Inc."  },
    { 0x2C92, "Ningbo Yinzhou Shengke Electronics Co., Ltd."  },
    { 0x2C93, "SWFL Inc. dba: Filament"  },
    { 0x2C94, "HIRATSUKA Engineering Co., Ltd."  },
    { 0x2C95, "TOSHIBA MACHINE CO., LTD."  },
    { 0x2C96, "KBS Industrieelektronik GmbH"  },
    { 0x2C97, "LEDGER"  },
    { 0x2C98, "Fosfomatic Technology LLC"  },
    { 0x2C99, "Prusa Research s.r.o."  },
    { 0x2C9A, "Lawo AG"  },
    { 0x2C9B, "SPECIM, Spectral Imaging Ltd."  },
    { 0x2C9C, "Vayyar Imaging LTD."  },
    { 0x2C9D, "Nod Inc."  },
    { 0x2C9E, "Shanghai Linguo Technology Co.,Ltd."  },
    { 0x2C9F, "e-Smart Systems Pvt. Ltd."  },
    { 0x2CA0, "Leagtech Jiangxi Electronic Co., Ltd."  },
    { 0x2CA1, "Veetone Technologies Limited"  },
    { 0x2CA2, "GuangZhou MingPing Electronics Technology"  },
    { 0x2CA3, "DJI Technology Co., Ltd."  },
    { 0x2CA4, "Shenzhen Alex Technology Co., Ltd."  },
    { 0x2CA5, "Fussen Technology Co., Ltd."  },
    { 0x2CA6, "Dai-ichi Dentsu Ltd."  },
    { 0x2CA7, "Heptagon Advanced Micro Optics"  },
    { 0x2CA8, "STATSports"  },
    { 0x2CA9, "JITS TECHNOLOGY CO., LIMITED"  },
    { 0x2CAA, "LIVV Brand llc"  },
    { 0x2CAB, "AppWorld S. de R.L. de C.V."  },
    { 0x2CAC, "MGF Sviesos Konversija, UAB"  },
    { 0x2CAD, "EMS Security Group Ltd."  },
    { 0x2CAE, "Clyde Broadcast Products Ltd."  },
    { 0x2CAF, "IDS GmbH"  },
    { 0x2CB0, "Creative bits Solutions"  },
    { 0x2CB1, "Avista Corporation"  },
    { 0x2CB2, "NAGANO KEIKI CO., LTD."  },
    { 0x2CB3, "Shenzhen Bolin Image Science Technology Co., Ltd."  },
    { 0x2CB4, "Ava Enterprises, Inc. dba Boss Audio Systems"  },
    { 0x2CB5, "SUS Corp."  },
    { 0x2CB6, "Borqs Hong Kong Limited"  },
    { 0x2CB7, "Fibocom Wireless Inc."  },
    { 0x2CB8, "Shenzhen Sydixon Electronic Technology Co., Ltd."  },
    { 0x2CB9, "On-Bright Electronics (Shanghai) Co., Ltd."  },
    { 0x2CBA, "Dongguan Puxu Industrial Co., Ltd."  },
    { 0x2CBB, "Shenzhen Soling Indusrtial Co., Ltd."  },
    { 0x2CBD, "EGGCYTE, INC."  },
    { 0x2CBE, "uQontrol"  },
    { 0x2CBF, "Donggguan Yuhua Electronic Co., Ltd."  },
    { 0x2CC0, "Hangzhou Zero Zero Technology Co., Ltd."  },
    { 0x2CC1, "SIGFOX"  },
    { 0x2CC2, "Lautsprecher Teufel GmbH"  },
    { 0x2CC3, "A-VEKT K.K."  },
    { 0x2CC4, "Sanden Advanced Technology Corporation"  },
    { 0x2CC5, "Metatronics"  },
    { 0x2CC6, "Prodigy Technovations Pvt Ltd"  },
    { 0x2CC7, "EmergiTech, Inc"  },
    { 0x2CC8, "Hewlett Packard Enterprise"  },
    { 0x2CC9, "Monolithic Power Systems Inc."  },
    { 0x2CCA, "Amphenol Advanced Sensors"  },
    { 0x2CCB, "USB Memory Direct"  },
    { 0x2CCC, "Silicon Mitus Inc."  },
    { 0x2CCD, "ITOS Inc."  },
    { 0x2CCE, "SMARTY Performance King SA"  },
    { 0x2CCF, "Hypersecu Information Systems, Inc."  },
    { 0x2CD0, "Technics Global Electronics & JCE Co., Ltd."  },
    { 0x2CD1, "Tamron Co., Ltd."  },
    { 0x2CD2, "Mikrotikls S/A"  },
    { 0x2CD3, "Life Robotics Inc."  },
    { 0x2CD4, "NGK SPARK PLUG CO., LTD."  },
    { 0x2CD5, "Institut Dr. Foerster GmbH & Co. KG"  },
    { 0x2CD6, "Immersive Media"  },
    { 0x2CD7, "Cosemi Technologies Inc."  },
    { 0x2CD8, "Nanoport Technology, Inc."  },
    { 0x2CD9, "Cambrionix Ltd"  },
    { 0x2CDA, "CXUN Co. Ltd."  },
    { 0x2CDB, "China Tsp Inc"  },
    { 0x2CDC, "Sea & Sun Technology GmbH"  },
    { 0x2CDD, "IAI Corporation"  },
    { 0x2CDE, "RTI International"  },
    { 0x2CDF, "Tecno Alarm S.R.L."  },
    { 0x2CE0, "iClassmate Educational Technologies Co., Ltd."  },
    { 0x2CE1, "Gradus Group"  },
    { 0x2CE2, "Yanfeng Visteon (Chongqing) Automotive Electronics Co"  },
    { 0x2CE3, "Alcorlink Corp."  },
    { 0x2CE4, "ISBC Ltd."  },
    { 0x2CE5, "InX8 Inc dba AKiTiO"  },
    { 0x2CE6, "SDAN Tecchnology Co., Ltd."  },
    { 0x2CE7, "Lemobile Information Technology (Beijing) Co., Ltd."  },
    { 0x2CE8, "DongGuan Hongweixiang Electronic Technology Co., Ltd."  },
    { 0x2CE9, "Suzhu Jingshi Electronic Technology Co., Ltd."  },
    { 0x2CEA, "Zhong Shan City Richsound Electronic Industrial Ltd."  },
    { 0x2CEB, "Dongguang Kangbang Electronics Co., Ltd."  },
    { 0x2CEC, "Ascon Tecnologic"  },
    { 0x2CED, "KMC Controls, Inc."  },
    { 0x2CEE, "Winpower Qmadix Technology Co., Ltd."  },
    { 0x2CEF, "Toptest Technologies Co., Ltd."  },
    { 0x2CF0, "Nuand, LLC"  },
    { 0x2CF1, "DTS, Inc."  },
    { 0x2CF2, "KUNSHAN DLK Electronics Technology Co., Ltd."  },
    { 0x2CF3, "Konekt, Inc."  },
    { 0x2CF4, "CAM2 Technologies, LLC dba: Czitek"  },
    { 0x2CF5, "EBARA REFRIGERATION EQUIPMENT & SYSTEMS CO., LTD."  },
    { 0x2CF6, "Eye-Fi, Inc."  },
    { 0x2CF7, "PPST, Inc."  },
    { 0x2CF8, "Itron"  },
    { 0x2CF9, "Terrafix Ltd."  },
    { 0x2CFA, "Meta Company"  },
    { 0x2CFB, "Nanchang Haozhun Electronics Co., Ltd."  },
    { 0x2CFC, "DeLaval International AB"  },
    { 0x2CFD, "GoerTek Inc."  },
    { 0x2CFE, "Alpha Data Parallel Systems"  },
    { 0x2CFF, "ITHAKi"  },
    { 0x2D00, "VDO Cyclecomputing, Cycle Parts GmbH"  },
    { 0x2D01, "Gopod Group Limited"  },
    { 0x2D02, "Zhi Sheng Electronics Technology Co., Ltd."  },
    { 0x2D03, "ECCO Safety Group"  },
    { 0x2D05, "Technology Solutions (UK) Limited"  },
    { 0x2D06, "Jireh Industries Ltd."  },
    { 0x2D07, "MSI.TOKYO, Inc."  },
    { 0x2D08, "ZIT Ltd."  },
    { 0x2D09, "Dongguan Evervictory Electronic Co., Ltd."  },
    { 0x2D0A, "Kingsignal Technology Co., Ltd."  },
    { 0x2D0B, "IPD CO., LTD"  },
    { 0x2D0C, "B & P Automation Dynamics Ltd"  },
    { 0x2D0D, "Star Vision Electronics Limited"  },
    { 0x2D0E, "Linxee (Beijing) Technology LTD."  },
    { 0x2D0F, "M8TRIX TECH LLC"  },
    { 0x2D10, "Shenzhen San Guan Si Yuan Technology Limited"  },
    { 0x2D11, "Servelec Technologies"  },
    { 0x2D12, "SICPA Security Solutions SA"  },
    { 0x2D13, "DONG GUAN EBEN ELECTRONIC CO., LTD"  },
    { 0x2D14, "Palit Microsystems Ltd"  },
    { 0x2D15, "Si-Ware Systems"  },
    { 0x2D16, "DONGGUAN WELLINK ELECTRONIC CO., LTD."  },
    { 0x2D17, "TECHVIWIN INTERNATIONAL (HONGKONG) LIMITED"  },
    { 0x2D18, "Hui Zhou Kai Yue Electronics Co., Ltd"  },
    { 0x2D19, "Churchill Navigation"  },
    { 0x2D1A, "Phononic"  },
    { 0x2D1B, "Suzhou Yourfriend Electronic Co., Ltd."  },
    { 0x2D1C, "Club 3D BV"  },
    { 0x2D1D, "Design Pool Limited"  },
    { 0x2D1E, "Excalibur"  },
    { 0x2D1F, "Wacom Taiwan Information Co. Ltd."  },
    { 0x2D20, "UL LLC"  },
    { 0x2D21, "Koozyt, Inc."  },
    { 0x2D22, "SEIKOSHA Co., Ltd."  },
    { 0x2D23, "Shenzhen Microtest Automation Co., Ltd."  },
    { 0x2D24, "Warwick Audio Technologies Ltd"  },
    { 0x2D25, "Kronegger GmbH"  },
    { 0x2D26, "Greenfield Technology"  },
    { 0x2D27, "Global Optics Limited"  },
    { 0x2D28, "Beijing ANTVR Technology Co., LTD"  },
    { 0x2D29, "Beijing Baofengmojing Technologies Co. Ltd"  },
    { 0x2D2A, "Shenzhen ZDT Technology Co., LTD"  },
    { 0x2D2B, "STYL Solutions Pte Ltd"  },
    { 0x2D2C, "Tankya Developing Co., Limited"  },
    { 0x2D2D, "Guangzhou Botao Information Technology Co., Ltd"  },
    { 0x2D2E, "Hieyoung International (Hong Kong) Limited"  },
    { 0x2D2F, "PT Phototechnics AG"  },
    { 0x2D30, "Addasound Denmark A/S"  },
    { 0x2D31, "Synox Tech Co., Ltd."  },
    { 0x2D32, "JR Technik Co., Ltd."  },
    { 0x2D33, "Elysia-raytest GmbH"  },
    { 0x2D34, "Nureva Inc."  },
    { 0x2D35, "SIGMA TECH. CO., LTD"  },
    { 0x2D36, "Blu5 View Pte. Ltd."  },
    { 0x2D37, "Xprinter Co., Ltd"  },
    { 0x2D38, "Shanghai OXi Technology Co., Ltd"  },
    { 0x2D39, "Roofer Technology (Shenzhen) Co. Ltd"  },
    { 0x2D3A, "Le Touch (Shenzhen) Electronics Co., Ltd."  },
    { 0x2D3B, "Lencheng Electronics Co., Ltd"  },
    { 0x2D3C, "FOVE, Inc."  },
    { 0x2D3D, "Battlespace Simulations, Inc."  },
    { 0x2D3E, "Technica Del Arte BV"  },
    { 0x2D3F, "ViCentra B.V."  },
    { 0x2D40, "Beijing Pico Technology Co., Ltd."  },
    { 0x2D41, "Dongguan Mankind Plastic Electronics Co., Ltd"  },
    { 0x2D42, "Protech Electronics & Technology Limited"  },
    { 0x2D43, "OSSIC Corporation"  },
    { 0x2D44, "FAMAR FUEGUINA S.A."  },
    { 0x2D45, "JSC TION SMART MICROCLIMATE"  },
    { 0x2D46, "JSC Yukon Advanced Optics Worldwide"  },
    { 0x2D47, "INVENCO GROUP LIMITED"  },
    { 0x2D48, "StarBridge, Inc."  },
    { 0x2D49, "Shanghai Deepoon Technology Co., Ltd."  },
    { 0x2D4A, "Helioway Enterprises Co., Ltd"  },
    { 0x2D4B, "Dongguan Hongwei Electronics Co.,Ltd"  },
    { 0x2D4C, "Ixtra Tech Inc"  },
    { 0x2D4D, "Razer Inc"  },
    { 0x2D4E, "Electronic Equipment BV"  },
    { 0x2D4F, "Dongguan Hanker Electronic Technology Co., Ltd."  },
    { 0x2D50, "CryLaS - Crystal Laser Systems GmbH"  },
    { 0x2D51, "NITTA Corporation"  },
    { 0x2D52, "YiQin Electronics Co.,Ltd"  },
    { 0x2D53, "OWOW Products B.V."  },
    { 0x2D54, "C-Smartlink Information Technology Co., Ltd."  },
    { 0x2D55, "Nagravision SA"  },
    { 0x2D56, "DongGuan Kelta Electro Mechanical Products CO, LTD"  },
    { 0x2D58, "Lyra Semiconductor Incorporated"  },
    { 0x2D59, "Sunyking Technology Co., Ltd"  },
    { 0x2D5A, "Shenzhen YAAN Precision Connector Co., Ltd."  },
    { 0x2D5B, "SunTo Technology (Shen Zhen) Corporation Limited"  },
    { 0x2D5C, "Daiwoo Electronics Lo., LTD"  },
    { 0x2D5D, "Loctek Ergonomic Technology Corp."  },
    { 0x2D5E, "Sky UK Limited"  },
    { 0x2D5F, "Shanghai Yuewen information technology Co., Ltd."  },
    { 0x2D60, "Comarch S.A."  },
    { 0x2D61, "Shenzhen Hongjixin Plastic & Electronics Co., Ltd"  },
    { 0x2D62, "Weifang Genius Electronics Co.,Ltd."  },
    { 0x2D63, "Cable Technology Corp."  },
    { 0x2D64, "H.D.T. S.R.L"  },
    { 0x2D65, "DPA Microphones"  },
    { 0x2D66, "Oley Company Limited"  },
    { 0x2D67, "Fengfan (Suzhou) Audio Technology Co., Ltd."  },
    { 0x2D68, "Lumulabs d.o.o."  },
    { 0x2D6A, "AIPHONE Co., LTD"  },
    { 0x2D6B, "NetUP Inc."  },
    { 0x2D6C, "Sphericam Inc."  },
    { 0x2D6D, "Shenzhen HaiWei Technology Co., LTD"  },
    { 0x2D6E, "Jiangsu Jing Lian Electronic Technology Co., Ltd"  },
    { 0x2D6F, "Tobii Dynavox"  },
    { 0x2D70, "Zhongshan Winner Electronic Technology CO., LTD"  },
    { 0x2D71, "OVERKIZ"  },
    { 0x2D72, "DOGAWIST - Investment GmbH"  },
    { 0x2D73, "XtremeMac Sarl"  },
    { 0x2D74, "CMO America; dba ZipKord Solutions"  },
    { 0x2D75, "Shenzhen Taiji Electronics Co., Ltd."  },
    { 0x2D76, "SiliConch Systems Private Limited"  },
    { 0x2D77, "SweDeltaco AB"  },
    { 0x2D78, "Dental Imaging Technology Corporation"  },
    { 0x2D79, "Shenzhen Legendary Technologies Co., LTD."  },
    { 0x2D7A, "Dongguan JingFeng Electronics Technology Co., Ltd"  },
    { 0x2D7B, "Panasonic Lighting Americas, Inc."  },
    { 0x2D7C, "Dongguan City Qingda Electronic Co., Ltd."  },
    { 0x2D7D, "Televes S.A."  },
    { 0x2D7E, "NISSIN ELECTRIC Corporation"  },
    { 0x2D7F, "Sinar Photography AG"  },
    { 0x2D80, "Pendo Technology China Corporation"  },
    { 0x2D81, "Evollve Inc."  },
    { 0x2D82, "boud"  },
    { 0x2D84, "Zhuhai J-Speed Technology Co., Ltd."  },
    { 0x2D85, "Asahi Electronics Laboratory"  },
    { 0x2D86, "Dongguan Team Force Electronic Co., Ltd"  },
    { 0x2D87, "Zhuhai Spark Electronic Equipment Co., Ltd"  },
    { 0x2D88, "Prinics Co., Ltd."  },
    { 0x2D89, "Ekahau"  },
    { 0x2D8A, "I-O Conn (GuangDong) Technologies Co., Ltd"  },
    { 0x2D8B, "Eclatkey Semiconductor Technology Company Limited"  },
    { 0x2D8C, "Hongrida Electronic Technology Co. LTD"  },
    { 0x2D8D, "MISUMI Corporation"  },
    { 0x2D8E, "Color Sentinel Systems, LLC"  },
    { 0x2D8F, "Shenzhen Bing Chuang Wei Technology Co., Ltd."  },
    { 0x2D90, "Humanplus"  },
    { 0x2D91, "SDI Technologies Inc."  },
    { 0x2D92, "Shanghai Fengtian Electronic Co., LTD."  },
    { 0x2D93, "STK TECHNOLOGY CO., LTD."  },
    { 0x2D94, "TokenWorks Inc."  },
    { 0x2D95, "Vivo Mobile Communication Co., Ltd."  },
    { 0x2D96, "SHENZHEN WAMAXLINK ELECTRONIC TECHNOLOGY CO., LTD"  },
    { 0x2D97, "Dong Guan JingHe Electronics Technology Co., Ltd"  },
    { 0x2D98, "Shenzhen Ruiming Technology Co., Ltd."  },
    { 0x2D99, "Edifier International Limited"  },
    { 0x2D9A, "Jiangsu GuoGuang Electronic Information Technology Co.,"  },
    { 0x2D9B, "iStorage Limited"  },
    { 0x2D9C, "Global Connector Technology"  },
    { 0x2D9D, "Dongguan Suntes Electronics Technology Co., Ltd."  },
    { 0x2D9E, "Sivantos GmbH"  },
    { 0x2D9F, "SABRENT"  },
    { 0x2DA0, "IN-VISION Digital Imaging Optics GmbH"  },
    { 0x2DA1, "Koden Electronics Co., Ltd"  },
    { 0x2DA2, "CIMA SPA con socio unico"  },
    { 0x2DA3, "Superior Communications"  },
    { 0x2DA4, "GE Multilin"  },
    { 0x2DA5, "Tokai Rika Create Corporation"  },
    { 0x2DA6, "SiChuan Rui Thai Electronic Technology Co., Ltd."  },
    { 0x2DA7, "Topland Corporation"  },
    { 0x2DA8, "Harmonic Drive Systems Inc."  },
    { 0x2DA9, "ELECTRONIC ASSEMBLY GmbH"  },
    { 0x2DAA, "Shenzhen Jing Tuo Jin Electronics Co., Ltd."  },
    { 0x2DAB, "CYD Electronics (Shenzhen) Co., Ltd."  },
    { 0x2DAC, "Shenzhen YZB Electronics Technology Co., Ltd"  },
    { 0x2DAD, "GoerTek Dynaudio Co., Ltd"  },
    { 0x2DAE, "Hex Technology Limited"  },
    { 0x2DAF, "IF Link Electronics Co Limited"  },
    { 0x2DB0, "Shenzhen Welltech Cable Co., Ltd"  },
    { 0x2DB1, "DongGuan Greatek Electronics Technology Co., LTD"  },
    { 0x2DB2, "Imperx, Inc"  },
    { 0x2DB3, "i Digital Galaxy Ltd."  },
    { 0x2DB4, "Dongguan Changtuo Hardware Technology Co., Ltd."  },
    { 0x2DB5, "Fuji Ceramics Corporation"  },
    { 0x2DB6, "Kunshan 3e Electronics Co., Ltd."  },
    { 0x2DB7, "Premium Sound Solutions Sdn. Bhd."  },
    { 0x2DB8, "Foshan Yami Electric Ltd."  },
    { 0x2DB9, "Danelec Marine A/S"  },
    { 0x2DBA, "Houwa System Design, k.k"  },
    { 0x2DBB, "Huajie IMI Technology Co., Ltd."  },
    { 0x2DBC, "Mikroelektronika d.o.o"  },
    { 0x2DBD, "Shanghai Xiaoyi Technology Co., Ltd"  },
    { 0x2DBE, "MA Lighting Technology GmbH"  },
    { 0x2DBF, "Tul Corporation"  },
    { 0x2DC0, "Chipsea Technologies (Shenzhen) Corp"  },
    { 0x2DC1, "littleBits"  },
    { 0x2DC2, "MintWave Co., Ltd."  },
    { 0x2DC3, "Action Industries (M) SDN BHD"  },
    { 0x2DC4, "Six 15 Technologies"  },
    { 0x2DC5, "Cytek Biosciences, Inc."  },
    { 0x2DC6, "Dongguan Kingtron Electronics Technology Co., Ltd."  },
    { 0x2DC7, "Lacroix Sofrel"  },
    { 0x2DC8, "8BITDO TECHNOLOGY HK LIMITED"  },
    { 0x2DC9, "3T B.V."  },
    { 0x2DCA, "OEM Systems Co., Ltd."  },
    { 0x2DCB, "i-Money Technology Co., Ltd."  },
    { 0x2DCC, "Suzhou Keda Technology Co., Ltd."  },
    { 0x2DCD, "Yeonho Electronics"  },
    { 0x2DCE, "Shen Zhen Farmer Technology Co., Limited"  },
    { 0x2DCF, "Dialog Semiconductor (UK) Ltd"  },
    { 0x2DD0, "iBaby Labs, Inc"  },
    { 0x2DD1, "Empathy Co., Ltd."  },
    { 0x2DD2, "HARNICS Co., LTD."  },
    { 0x2DD3, "Viscell, LLC"  },
    { 0x2DD5, "Gingy Technology Inc."  },
    { 0x2DD6, "Suzhou SuperMax Smart System Co., Ltd."  },
    { 0x2DD7, "enRoute Co., Ltd."  },
    { 0x2DD8, "Perception Sensors and Instrumentation Ltd"  },
    { 0x2DD9, "Dong Guan Fei Tai Electronics CO., LTD."  },
    { 0x2DDA, "Miura Systems Ltd"  },
    { 0x2DDB, "Shenzhen DAK Technology Co., Ltd"  },
    { 0x2DDC, "Audiolink Co., Ltd"  },
    { 0x2DDD, "Princeton Infrared Technologies, Inc."  },
    { 0x2DDE, "The Chamberlain Group, Inc."  },
    { 0x2DDF, "BOMTECH ELECTRONICS CO., LTD."  },
    { 0x2DE0, "Active-semi, Inc"  },
    { 0x2DE1, "Jiang Su Denseting Precision Technology Co., Ltd."  },
    { 0x2DE2, "PathPartner Technology Pvt. Ltd"  },
    { 0x2DE3, "Shanghai Yitu Technology Co., Ltd."  },
    { 0x2DE4, "Best Case and Accessories, Inc."  },
    { 0x2DE5, "KaiJet Technology International Limited, Inc. dba j5create"  },
    { 0x2DE6, "Amazon Fulfillment Services, Inc."  },
    { 0x2DE7, "The LightCo, Inc."  },
    { 0x2DE8, "Shenzhen City Xiaoduan Electrical Co., LTD."  },
    { 0x2DE9, "CAR MATE MFG. CO., LTD."  },
    { 0x2DEA, "LightFactor"  },
    { 0x2DEB, "Hold-Key Electric Wire & Cable Co Ltd"  },
    { 0x2DEC, "ZNi Technology Co., Ltd"  },
    { 0x2DED, "Aquil Star Precision Industrial (Shenzhen) Co., Ltd"  },
    { 0x2DEE, "Shenzhen MeiG Smart Technology Co., Ltd"  },
    { 0x2DEF, "Kirale Technologies SL"  },
    { 0x2DF0, "CANVASBIO CO., LTD"  },
    { 0x2DF1, "Inovonics Corp"  },
    { 0x2DF2, "LIPS Corporation"  },
    { 0x2DF3, "LongSung Technology (Shanghai) Co., Ltd."  },
    { 0x2DF4, "Jumplux Technology Co., Ltd."  },
    { 0x2DF5, "Helium Systems Inc."  },
    { 0x2DF6, "Greektown Casino-Hotel, LLC"  },
    { 0x2DF7, "Fastwel Group Ltd."  },
    { 0x2DF8, "ITEST"  },
    { 0x2DF9, "EZQuest, Inc."  },
    { 0x2DFA, "3DRUDDER"  },
    { 0x2DFB, "Bren-Tronics, Inc."  },
    { 0x2DFC, "Graphic Products"  },
    { 0x2DFD, "Ubisoft Entertainment SA"  },
    { 0x2DFE, "Next Thing Co."  },
    { 0x2DFF, "Unicept GmbH"  },
    { 0x2E00, "CIB Security Inc"  },
    { 0x2E01, "Symetrix, Inc."  },
    { 0x2E02, "Softiron"  },
    { 0x2E03, "Zhejiang Dahua Technology Co., Ltd."  },
    { 0x2E04, "HMD Global Oy"  },
    { 0x2E05, "CKD Corporation"  },
    { 0x2E06, "Shenzhen Junlan Electronic Ltd"  },
    { 0x2E07, "Lafayette Instrument Company"  },
    { 0x2E08, "Zhongshan Dumei Weite Electronics Co., Ltd"  },
    { 0x2E09, "Beijing LLVision Technology Co. LTD"  },
    { 0x2E0A, "Dytran Instruments"  },
    { 0x2E0B, "Datafield Industries (HK) Ltd"  },
    { 0x2E0C, "Shenzhen Mek Intellisys PTE Ltd"  },
    { 0x2E0D, "Suzhou FanglinTechnology Co., Ltd"  },
    { 0x2E0E, "Hatteland Display AS"  },
    { 0x2E0F, "Institute for Defense Analyses / Center for Computing Sciences"  },
    { 0x2E10, "LinkMTech Inc."  },
    { 0x2E11, "ShenZhen ShenTai WeiXiang Electronics Co., Ltd"  },
    { 0x2E12, "Hongkong Chenyang Electronic Co., Limited"  },
    { 0x2E13, "Intelligent Automation (Zhuhai) Co., Ltd"  },
    { 0x2E14, "Expressive"  },
    { 0x2E15, "Now Technologies"  },
    { 0x2E16, "Glosys Inc."  },
    { 0x2E17, "Essential Products, Inc."  },
    { 0x2E18, "NorthStar Battery Company, LLC"  },
    { 0x2E19, "Additel Corporation"  },
    { 0x2E1A, "Shenzhen Arashi Vision Company Limited"  },
    { 0x2E1B, "BeiJie Electronics Technology Co., Ltd"  },
    { 0x2E1C, "Shenzhen Auto-Link World Information Technology Co., Ltd."  },
    { 0x2E1D, "Clarion (Malaysia) Sdn. Bhd."  },
    { 0x2E1E, "Sound Technology (C.Q.) Co., Ltd"  },
    { 0x2E1F, "BrainScope Company, Inc."  },
    { 0x2E20, "Guangzhou Long Do Co.,Ltd"  },
    { 0x2E21, "DOSCH&AMAND Research GmbH&CoKG"  },
    { 0x2E22, "DongGuan LinSong precision electronics CO., LTD"  },
    { 0x2E23, "Shenzhen Baojia Battery Technology Co., Ltd."  },
    { 0x2E24, "Hyperkin Inc."  },
    { 0x2E25, "Gold Cable (Zhongshan) Electronic Co., Ltd."  },
    { 0x2E26, "Monoprice, Inc."  },
    { 0x2E27, "Lion Semiconductor"  },
    { 0x2E28, "VOLTRONIC POWER TECHNOLOGY CORP."  },
    { 0x2E29, "Clas Ohlson AB"  },
    { 0x2E2B, "Shenzhen Qinps Technology Co Limited"  },
    { 0x2E2C, "Dashine Electronics Co, Ltd"  },
    { 0x2E2D, "Anaren Inc."  },
    { 0x2E2E, "First Design System Inc."  },
    { 0x2E2F, "Gulden Ophthalmics, Inc."  },
    { 0x2E30, "Andon Health Co., Ltd."  },
    { 0x2E31, "Thine Electronics, Inc."  },
    { 0x2E32, "Shenzhen Red Star Electronics Co., Ltd."  },
    { 0x2E33, "Squarehead Technology"  },
    { 0x2E34, "ALLDATA LLC"  },
    { 0x2E35, "Shenzhen PYS Industrial Co., LTD"  },
    { 0x2E36, "Depo Electronics Limited"  },
    { 0x2E37, "IRISO ELECTRONICS CO., LTD"  },
    { 0x2E38, "OHM ELECTRONIC INC."  },
    { 0x2E39, "Epic Tech, LLC"  },
    { 0x2E3A, "Nanaboshi Electric Mfg. Co., Ltd."  },
    { 0x2E3B, "uSens Inc"  },
    { 0x2E3C, "ARTERY Technology Co., Ltd."  },
    { 0x2E3D, "ASWAN ELEC. SALES CO., LTD."  },
    { 0x2E3E, "Karma Automotive"  },
    { 0x2E3F, "Poly-Planar Group LLC"  },
    { 0x2E40, "Mobile Technologies Inc"  },
    { 0x2E41, "DONGGUAN RONGDEKANG ELECTRONIC TECHNOLOGY CO., LTD."  },
    { 0x2E42, "Hunan Ronghe Microelectronics Co., Ltd."  },
    { 0x2E43, "Owl Labs, Inc"  },
    { 0x2E44, "Idealens Technology (Chengdu) Co., Ltd."  },
    { 0x2E45, "Widex A/S"  },
    { 0x2E46, "Mobileconn Technology Co., Ltd."  },
    { 0x2E47, "X-Media Tech, Inc."  },
    { 0x2E48, "Andromium Inc."  },
    { 0x2E49, "A&T Corporation"  },
    { 0x2E4A, "Xiamen Jinhaode Electronic Co., Ltd"  },
    { 0x2E4B, "ART SPA"  },
    { 0x2E4C, "Carter Duncan Corp."  },
    { 0x2E4D, "Vinpower, Inc."  },
    { 0x2E4E, "METER Group, Inc"  },
    { 0x2E4F, "Audiotec Fischer GmbH"  },
    { 0x2E50, "beyerdynamic GmbH & Co. KG"  },
    { 0x2E51, "EVER Sp. Z.o.o."  },
    { 0x2E52, "Toughbuilt Industries Inc"  },
    { 0x2E53, "Shenzhen East-Toptech Electronic Technology Co., Ltd"  },
    { 0x2E54, "Yin Run Precise Metal Products CO., LTD."  },
    { 0x2E55, "FIP Formatura Iniezione Polimeri an Aliaxis Company"  },
    { 0x2E56, "Juchin Technology (JIANGXI) Co., Ltd"  },
    { 0x2E57, "MEGWARE Computer Vertrieb und Service GmbH"  },
    { 0x2E58, "GONGNIU GROUP CO., LTD."  },
    { 0x2E59, "Maui Imaging, Inc."  },
    { 0x2E5A, "Mysher Technology Co., Ltd."  },
    { 0x2E5B, "Fitipower Integrated Technology Inc."  },
    { 0x2E5C, "Y.H.S. Co., Ltd"  },
    { 0x2E5D, "Dong Guan LM-Link Precise Electronic Co., Ltd."  },
    { 0x2E5E, "Mei Shun He Electronic Limited"  },
    { 0x2E5F, "Shenzhen BTC Technology Co., Ltd."  },
    { 0x2E60, "castAR, Inc."  },
    { 0x2E61, "NetBurner, Inc."  },
    { 0x2E62, "Will Semiconductor Co., LTD"  },
    { 0x2E63, "Polaris-Labs Shenzhen Co., Ltd"  },
    { 0x2E64, "Shenzhen Kaibao Technology Co., Ltd."  },
    { 0x2E65, "Kunshan Xintaili Precision Components Co., Ltd."  },
    { 0x2E66, "SALICRU, S.A."  },
    { 0x2E67, "Elevation Lab, Inc."  },
    { 0x2E68, "Tessonics Inc."  },
    { 0x2E69, "Swift Navigation Inc"  },
    { 0x2E6A, "Wilderness Labs Inc."  },
    { 0x2E6B, "DMX, LLC dba Mood Media"  },
    { 0x2E6C, "Uwatec AG"  },
    { 0x2E6D, "Laser Argentina S.A."  },
    { 0x2E6E, "E4D Technologies LLC"  },
    { 0x2E6F, "Areca Technology Corporation"  },
    { 0x2E70, "Revision Electronics & Power Systems Inc."  },
    { 0x2E71, "Futurepath Electronics Technology (Dongguan) Co., Ltd."  },
    { 0x2E72, "DongGuan YongHao Electronics Co., LTD"  },
    { 0x2E73, "Backyard Brains"  },
    { 0x2E74, "Magenta Labs Inc."  },
    { 0x2E75, "Shanghai Hinge Electronic Technologies Co., Ltd."  },
    { 0x2E76, "Guangdong Jinrun Electronics Co., Ltd."  },
    { 0x2E77, "LOGICDATA Electronics & Software Entwicklungs GmbH"  },
    { 0x2E78, "ES Gear Ltd."  },
    { 0x2E79, "NP System Development Co., Ltd."  },
    { 0x2E7A, "Jiangsu BDSTAR Navigation Electronic Co., Ltd."  },
    { 0x2E7B, "Terrada Music Score CO., Ltd."  },
    { 0x2E7C, "Pyramid Solutions"  },
    { 0x2E7D, "Shenzhen Xin Yong Yang Technology Co., Ltd."  },
    { 0x2E7E, "ValueHD Corporation"  },
    { 0x2E7F, "Aries Manufacturing - a division of Boss Tech Products Inc."  },
    { 0x2E80, "Join Tek Corporation Co., Ltd."  },
    { 0x2E81, "Zodiac Inflight Innovations"  },
    { 0x2E82, "Sapphire Technology Limited"  },
    { 0x2E83, "Ocean Tek Enterprise Co., Ltd."  },
    { 0x2E84, "Sheng San Electronics (Shen Zhen) Co., Ltd."  },
    { 0x2E85, "Verizon"  },
    { 0x2E86, "SBO HEARING A/S"  },
    { 0x2E87, "Shenzhen Injoinic Technology Co., Ltd."  },
    { 0x2E88, "Huada Semiconductor Corporation Limited"  },
    { 0x2E89, "Group Dekko, Inc."  },
    { 0x2E8A, "Raspberry Pi (Trading) Limited"  },
    { 0x2E8B, "Asia Optical International Ltd."  },
    { 0x2E8C, "Aisino Wincor Manufacturing (Shanghai) Co., Ltd."  },
    { 0x2E8D, "YSC Science Technique Electron (Yi Chun) Co., Ltd"  },
    { 0x2E8E, "Bitatek CO., LTD"  },
    { 0x2E8F, "Shenzhen Weiduli Technology Co., Ltd."  },
    { 0x2E90, "Wireless Media Tech CO., Limited"  },
    { 0x2E91, "Shenzhen Suprint Smart Technology Co., Ltd."  },
    { 0x2E92, "bioMerieux, Inc."  },
    { 0x2E93, "Shenzhen Huikeyuan Electronic Technology Co., Ltd."  },
    { 0x2E94, "Graviton Inc."  },
    { 0x2E95, "Scuf Gaming International, LLC"  },
    { 0x2E96, "Aspect Microsystems Corp."  },
    { 0x2E97, "Aerocool Advanced Technologies Corporation"  },
    { 0x2E98, "Nekteck, Inc."  },
    { 0x2E99, "Hynetek Semiconductor Co., Ltd"  },
    { 0x2E9A, "MS Solutions Co., Ltd."  },
    { 0x2E9B, "New Imaging Technologies"  },
    { 0x2E9C, "Shenzhen Silkway Technology Co., Ltd."  },
    { 0x2E9D, "Resolved Instruments Inc."  },
    { 0x2E9E, "SoundAI Technology Co., Ltd."  },
    { 0x2E9F, "EyeTech Digital Systems, Inc."  },
    { 0x2EA0, "Magnescale Co., Ltd."  },
    { 0x2EA1, "DASANELECTRON CO., LTD"  },
    { 0x2EA2, "Ningbo Kangda Electronic Co., Ltd."  },
    { 0x2EA3, "POSLAB Technology Corporation"  },
    { 0x2EA4, "Hubbell Incorporated (Delaware), Wiring Device Kellems Division"  },
    { 0x2EA5, "Dongguanshi Qitaiprecision Moulds Co., Ltd."  },
    { 0x2EA6, "Foreign Trade Corporation dba. Technocel"  },
    { 0x2EA7, "Muhanbit"  },
    { 0x2EA8, "Changsha JingJia Microelectronics Co., LTD."  },
    { 0x2EA9, "Yuneec International (China) Co., Ltd."  },
    { 0x2EAA, "TSUME S.A."  },
    { 0x2EAB, "Zong Cable Technology Co., Ltd."  },
    { 0x2EAC, "Jia Yang Electronics (Dongguan) Co., Ltd."  },
    { 0x2EAD, "Align Technology Inc."  },
    { 0x2EAE, "Shenzhen TOMTOP Technology Co., Ltd."  },
    { 0x2EAF, "microsonic co., ltd."  },
    { 0x2EB0, "Commtech, Inc."  },
    { 0x2EB1, "Samsung SmartThings"  },
    { 0x2EB2, "Markus Klotz GmbH"  },
    { 0x2EB3, "Shenzhen Tokwa Precision Technology Co., Ltd."  },
    { 0x2EB4, "Beijer Automotive BV"  },
    { 0x2EB5, "Dongguan HengYue Communication Technology Co., Ltd."  },
    { 0x2EB6, "The Vehicle Group LTD"  },
    { 0x2EB7, "Digital Divide Systems Ltd."  },
    { 0x2EB8, "Yueqing Nuode Electronic Technology Co., Ltd."  },
    { 0x2EB9, "SSI Computer Corp."  },
    { 0x2EBA, "Shenzhen E&C Smart Link Technology Co., Ltd."  },
    { 0x2EBB, "Shanghai Tuzheng Information Technology Co., Ltd."  },
    { 0x2EBC, "RAIDON Technology Inc."  },
    { 0x2EBD, "Netstor Technology Co., Ltd."  },
    { 0x2EBE, "Delphi Automotive Systems, LLC"  },
    { 0x2EBF, "Shenzhen D&D Technology Co., Ltd"  },
    { 0x2EC0, "GuideTech"  },
    { 0x2EC1, "Avid Identification Systems, Inc."  },
    { 0x2EC2, "Loupedeck Oy"  },
    { 0x2EC3, "Shenzhen Huntkey Electric Co., Ltd."  },
    { 0x2EC4, "tetralux S.a.r.l."  },
    { 0x2EC5, "Ariba Technology Co., LTD."  },
    { 0x2EC6, "Facebook, Inc."  },
    { 0x2EC7, "ITECH Electronic Co., Ltd."  },
    { 0x2EC8, "Ningbo Prime Electronic Co., Ltd."  },
    { 0x2EC9, "Shenzhou Rongan Technology (Beijing) Limited"  },
    { 0x2ECA, "AQuantia Corp"  },
    { 0x2ECB, "Zhejiang Quzhou Gelinte Wire and Cable Co., Ltd."  },
    { 0x2ECC, "ASR Microelectronics (Shanghai) Co., Ltd."  },
    { 0x2ECD, "EUROICC"  },
    { 0x2ECE, "E-Lead Electronic Co., Ltd."  },
    { 0x2ECF, "Fluo Technology Ltd."  },
    { 0x2ED0, "Mind Alive Inc."  },
    { 0x2ED1, "QBit Semiconductor LTD"  },
    { 0x2ED2, "APOLLO GIKEN Co., Ltd."  },
    { 0x2ED3, "Shenzhen Xinhongya Electronics Corporation"  },
    { 0x2ED4, "Butterfly Network Inc."  },
    { 0x2ED5, "QSAN Technology, Inc."  },
    { 0x2ED6, "Shenzhen Xinliyang Co., Ltd."  },
    { 0x2ED7, "Libratel Inc"  },
    { 0x2ED8, "Dongguan Lontion Industrial Co., Ltd."  },
    { 0x2ED9, "Microscopes International, LLC"  },
    { 0x2EDA, "Wenzhou Haitong Communication Electronics Co., Ltd."  },
    { 0x2EDB, "NeuroHabilitation Corporation"  },
    { 0x2EDC, "Nippon Techno Lab., Inc."  },
    { 0x2EDD, "reMarkable AS"  },
    { 0x2EDE, "Technik Industrial Company Limited"  },
    { 0x2EDF, "Huizhou Wealth Metal Micro Control Limited"  },
    { 0x2EE0, "Pogotec Inc."  },
    { 0x2EE1, "Safetrust Inc"  },
    { 0x2EE2, "Kashimura Co., Ltd."  },
    { 0x2EE3, "Kin Keung Electrical Mfg. Ltd."  },
    { 0x2EE4, "Osprey Video, Inc."  },
    { 0x2EE6, "NEURODIGITAL TECHNOLOGIES, S.L."  },
    { 0x2EE7, "GOOGFIT TECH LIMITED"  },
    { 0x2EE8, "Zunidata Systems, Inc."  },
    { 0x2EE9, "Adigal LLC"  },
    { 0x2EEA, "Loma Systems"  },
    { 0x2EEB, "Jianduan Technology (Shenzhen) Co., Ltd."  },
    { 0x2EEC, "Sensor Industries Limited"  },
    { 0x2EED, "Shenzhen Panhui Technologies Co., Ltd."  },
    { 0x2EEE, "Beijing Qunli Tiancheng Network Technology Company"  },
    { 0x2EEF, "Booz Allen Hamilton"  },
    { 0x2EF0, "Zhongshan Auxus Electronic Technology Co., Ltd."  },
    { 0x2EF1, "Tatvik Biosystems Private Limited"  },
    { 0x2EF2, "Shenzhen Goodwin Technology Co., Ltd."  },
    { 0x2FB2, "Fujitsu Limited"  },
    { 0x3176, "WHANAM ELECTRONICS CO., Ltd. MS division"  },
    { 0x3552, "BD Consumer Healthcare"  },
    { 0x3636, "INVIBRO"  },
    { 0x3884, "Nicolet Biomedical Inc., a Viasys Healthcare Co."  },
    { 0x3923, "National Instruments"  },
    { 0x4102, "iRiver"  },
    { 0x413C, "Dell Inc."  },
    { 0x4234, "Powervar Inc. (UPS Products)"  },
    { 0x4242, "USB Design By Example"  },
    { 0x4317, "Broadcom WLAN"  },
    { 0x4426, "TANITA Corporation"  },
    { 0x4745, "Beijing Tiertime Technology Co., Ltd."  },
    { 0x4791, "Western Digital, G-Tech"  },
    { 0x4909, "GE Healthcare Bio-Sciences AB"  },
    { 0x4971, "HITACHI GLOBAL STORAGE TECHNOLOGIES"  },
    { 0x4B53, "Key Soft Service"  },
    { 0x4C46, "DSPecialists GmbH"  },
    { 0x4DDC, "Data Device Corporation"  },
    { 0x5058, "ProXense, LLC"  },
    { 0x5245, "RESPIRONICS, INC."  },
    { 0x544D, "Transmeta Corporation"  },
    { 0x5543, "UC-Logic Technology Corp."  },
    { 0x5555, "Number Five, Software"  },
    { 0x55AA, "OnSpec Electronic Inc."  },
    { 0x5986, "BISON ELECTRONICS INC."  },
    { 0x6000, "TRIDENT MICROSYSTEMS (Far East) Ltd."  },
    { 0x630F, "Leapfrog Schoolhouse"  },
    { 0x636C, "CoreLogic, Inc."  },
    { 0x6400, "Springer Design, Inc."  },
    { 0x6A75, "Shanghai Jujo Electronics Co., Ltd."  },
    { 0x735F, "Beijing Techshino Technology Co., Ltd."  },
    { 0x8020, "Trinity, Inc."  },
    { 0x8086, "Intel Corporation"  },
    { 0x8087, "Intel"  },
    { 0x8829, "Beijing Daming Wuzhou Science & Technology Co., Ltd."  },
    { 0x8873, "Dengineer Co., Ltd."  },
    { 0x9696, "Digital Arts, Inc."  },
    { 0x9710, "Moschip Semiconductor Technology"  },
    { 0xA600, "ASIX s.r.o."  },
    { 0xA625, "Wuhan Tianyu Information Industry Co., Ltd."  },
    { 0xBEE5, "BEE SYSTEMS LLC"  },
    { 0xC0B8, "Corbett Life Science"  },
    { 0xC10C, "Given Imaging"  },
    { 0xCACE, "CACE Technologies"  },
    { 0xCC42, "Cardio Control NV"  },
    { 0xEA01, "Eagle Technology"  },
    { 0xEB1A, "Empia Technology, Inc."  },
    { 0xFF01, "DisplayPort (VESA)"  },
    { 0xFF02, "MHL, LLC"  },
    { 0xFF03, "MIPI Debug"  },
    { 0xFF04, "HDMI"  },
    { 0x0000, "Vendor ID not listed with USB.org"  }
};

#endif /* __VNDRLIST_H__ */

