
rule("markdown")
    add_deps("man", {order = true})
    set_extensions(".md", ".markdown")
    before_build_file(function (target, sourcefile)
        print("before_build_file: %s", sourcefile)
    end)
    on_build_file(function (target, sourcefile)
        print("on_build_file: %s", sourcefile)
    end)
    after_build_file(function (target, sourcefile)
        print("after_build_file: %s", sourcefile)
    end)

rule("man")
    set_extensions(".man")
    before_build_file(function (target, sourcefile)
        print("before_build_file: %s", sourcefile)
    end)
    on_build_file(function (target, sourcefile)
        print("on_build_file: %s", sourcefile)
    end)
    after_build_file(function (target, sourcefile)
        print("after_build_file: %s", sourcefile)
    end)

target("test")
    set_kind("binary")
    add_rules("markdown")
    add_files("src/*.c")
    add_files("src/*.md")
    add_files("src/*.man")
    before_build_file(function (target, sourcefile)
        print("target.before_build_file: %s", sourcefile)
    end)
    --[[
    on_build_file(function (target, sourcefile)
        print("target.on_build_file: %s", sourcefile)
    end)]]
    after_build_file(function (target, sourcefile)
        print("target.after_build_file: %s", sourcefile)
    end)

