
target("dep1")
    set_kind("static")
    add_files("src/*.c")
    add_cflags("-DFLAG1")
    add_cflags("-DFLAG2", {interface = true})
    add_includedirs("inc1", {public = true})
    add_defines("TEST1", {public = true})

target("dep2")
    set_kind("shared")
    add_deps("dep1")
    add_files("src/*.c")
    add_includedirs("inc2", {interface = true})
    add_defines("TEST2", {interface = true})

    on_load(function (target)
        print(target:extraconf("includedirs"))
        print(target:extraconf("defines", "TEST2"))
        print(target:extraconf("defines", "TEST2", "interface"))
        print(target:get("files"))
        print(target:get("files", {private = true}))
        print(target:get("files", {public = true}))
        print(target:get("files", {interface = true}))
        print(target:get("defines"))
        print(target:get("defines", {private = true}))
        print(target:get("defines", {public = true}))
        print(target:get("defines", {interface = true}))
    end)

target("dep3")
    set_kind("static")
    add_files("src/*.c")
    add_includedirs("inc3")

target("dep4")
    set_kind("static")
    add_files("src/*.c")
    add_includedirs("inc4", {public = true})
    add_defines("TEST4", {public = true})

target("demo")
    set_kind("binary")
    add_deps("dep2", "dep3")
    add_deps("dep4", {inherit = false})
    add_files("src/*.c")
