import { ModelType } from '../base';

export interface VideoGenerationsReq {
  model: ModelType;
  prompt: string;
  image_url?: string;
}

export interface VideoGenerationsRes {
  request_id: string; // Task number submitted by the user on the client-side or generated by the platform
  id: string; // Order number generated by the Zhipu AI open platform
  model: string; // Name of the model used for this call
  task_status: 'PROCESSING' | 'SUCCESS' | 'FAIL'; // Processing status: PROCESSING (in progress), SUCCESS (successful), FAIL (failed). Results need to be retrieved through a query.
}

export interface AsyncResultRes {
  model: string; // Model Code
  video_result: { url: string; cover_image_url: string }[]; // Video Generation Result
  url: string; // Video URL
  cover_image_url: string; // Video Cover URL
  task_status: 'PROCESSING' | 'SUCCESS' | 'FAIL'; // Processing Status: PROCESSING (in progress), SUCCESS (successful), FAIL (failed)
  request_id: string; // Task number submitted by the user on the client-side or generated by the platform
  id: string; // Order number generated by the Zhipu AI open platform
}
