// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

// The exact value to boost.
type ValueBoosterValue struct {
	typeName string
	String   string
	Double   float64
	Boolean  bool
}

func NewValueBoosterValueFromString(value string) *ValueBoosterValue {
	return &ValueBoosterValue{typeName: "string", String: value}
}

func NewValueBoosterValueFromDouble(value float64) *ValueBoosterValue {
	return &ValueBoosterValue{typeName: "double", Double: value}
}

func NewValueBoosterValueFromBoolean(value bool) *ValueBoosterValue {
	return &ValueBoosterValue{typeName: "boolean", Boolean: value}
}

func (v *ValueBoosterValue) UnmarshalJSON(data []byte) error {
	var valueString string
	if err := json.Unmarshal(data, &valueString); err == nil {
		v.typeName = "string"
		v.String = valueString
		return nil
	}
	var valueDouble float64
	if err := json.Unmarshal(data, &valueDouble); err == nil {
		v.typeName = "double"
		v.Double = valueDouble
		return nil
	}
	var valueBoolean bool
	if err := json.Unmarshal(data, &valueBoolean); err == nil {
		v.typeName = "boolean"
		v.Boolean = valueBoolean
		return nil
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, v)
}

func (v ValueBoosterValue) MarshalJSON() ([]byte, error) {
	switch v.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", v.typeName, v)
	case "string":
		return json.Marshal(v.String)
	case "double":
		return json.Marshal(v.Double)
	case "boolean":
		return json.Marshal(v.Boolean)
	}
}

type ValueBoosterValueVisitor interface {
	VisitString(string) error
	VisitDouble(float64) error
	VisitBoolean(bool) error
}

func (v *ValueBoosterValue) Accept(vv ValueBoosterValueVisitor) error {
	switch v.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", v.typeName, v)
	case "string":
		return vv.VisitString(v.String)
	case "double":
		return vv.VisitDouble(v.Double)
	case "boolean":
		return vv.VisitBoolean(v.Boolean)
	}
}
