// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
)

// UpdateRecordWithIdRequest is an in-lined request used by the UpdateRecordWithId endpoint.
type UpdateRecordWithIdRequest struct {
	// Column filters
	Columns   []*string                        `json:"-"`
	IfVersion *int                             `json:"-"`
	Body      map[string]*DataInputRecordValue `json:"-"`
}

func (u *UpdateRecordWithIdRequest) UnmarshalJSON(data []byte) error {
	var body map[string]*DataInputRecordValue
	if err := json.Unmarshal(data, &body); err != nil {
		return err
	}
	u.Body = body
	return nil
}

func (u *UpdateRecordWithIdRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(u.Body)
}
