// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

// A transaction operation
type TransactionOperation struct {
	typeName                   string
	TransactionOperationInsert *TransactionOperationInsert
	TransactionOperationUpdate *TransactionOperationUpdate
	TransactionOperationDelete *TransactionOperationDelete
	TransactionOperationGet    *TransactionOperationGet
}

func NewTransactionOperationFromTransactionOperationInsert(value *TransactionOperationInsert) *TransactionOperation {
	return &TransactionOperation{typeName: "transactionOperationInsert", TransactionOperationInsert: value}
}

func NewTransactionOperationFromTransactionOperationUpdate(value *TransactionOperationUpdate) *TransactionOperation {
	return &TransactionOperation{typeName: "transactionOperationUpdate", TransactionOperationUpdate: value}
}

func NewTransactionOperationFromTransactionOperationDelete(value *TransactionOperationDelete) *TransactionOperation {
	return &TransactionOperation{typeName: "transactionOperationDelete", TransactionOperationDelete: value}
}

func NewTransactionOperationFromTransactionOperationGet(value *TransactionOperationGet) *TransactionOperation {
	return &TransactionOperation{typeName: "transactionOperationGet", TransactionOperationGet: value}
}

func (t *TransactionOperation) UnmarshalJSON(data []byte) error {
	valueTransactionOperationInsert := new(TransactionOperationInsert)
	if err := json.Unmarshal(data, &valueTransactionOperationInsert); err == nil {
		t.typeName = "transactionOperationInsert"
		t.TransactionOperationInsert = valueTransactionOperationInsert
		return nil
	}
	valueTransactionOperationUpdate := new(TransactionOperationUpdate)
	if err := json.Unmarshal(data, &valueTransactionOperationUpdate); err == nil {
		t.typeName = "transactionOperationUpdate"
		t.TransactionOperationUpdate = valueTransactionOperationUpdate
		return nil
	}
	valueTransactionOperationDelete := new(TransactionOperationDelete)
	if err := json.Unmarshal(data, &valueTransactionOperationDelete); err == nil {
		t.typeName = "transactionOperationDelete"
		t.TransactionOperationDelete = valueTransactionOperationDelete
		return nil
	}
	valueTransactionOperationGet := new(TransactionOperationGet)
	if err := json.Unmarshal(data, &valueTransactionOperationGet); err == nil {
		t.typeName = "transactionOperationGet"
		t.TransactionOperationGet = valueTransactionOperationGet
		return nil
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, t)
}

func (t TransactionOperation) MarshalJSON() ([]byte, error) {
	switch t.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", t.typeName, t)
	case "transactionOperationInsert":
		return json.Marshal(t.TransactionOperationInsert)
	case "transactionOperationUpdate":
		return json.Marshal(t.TransactionOperationUpdate)
	case "transactionOperationDelete":
		return json.Marshal(t.TransactionOperationDelete)
	case "transactionOperationGet":
		return json.Marshal(t.TransactionOperationGet)
	}
}

type TransactionOperationVisitor interface {
	VisitTransactionOperationInsert(*TransactionOperationInsert) error
	VisitTransactionOperationUpdate(*TransactionOperationUpdate) error
	VisitTransactionOperationDelete(*TransactionOperationDelete) error
	VisitTransactionOperationGet(*TransactionOperationGet) error
}

func (t *TransactionOperation) Accept(v TransactionOperationVisitor) error {
	switch t.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", t.typeName, t)
	case "transactionOperationInsert":
		return v.VisitTransactionOperationInsert(t.TransactionOperationInsert)
	case "transactionOperationUpdate":
		return v.VisitTransactionOperationUpdate(t.TransactionOperationUpdate)
	case "transactionOperationDelete":
		return v.VisitTransactionOperationDelete(t.TransactionOperationDelete)
	case "transactionOperationGet":
		return v.VisitTransactionOperationGet(t.TransactionOperationGet)
	}
}
