// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

// A summary expression is the description of a single summary operation. It consists of a single
// key representing the operation, and a value representing the column to be operated on.
//
// The column being summarized cannot be an internal column (id, xata.*), nor the base of
// an object, i.e. if `settings` is an object with `dark_mode` as a field, you may summarize
// `settings.dark_mode` but not `settings` nor `settings.*`.
//
// We currently support several aggregation functions. Not all functions can be run on all column
// types.
//
//   - `count` is used to count the number of records in each group. Use `{"count": "*"}` to count
//     all columns present, otherwise `{"count": "<column_path>"}` to count the number of non-null
//     values are present at column path.
//
//     Count can be used on any column type, and always returns an int.
//
//   - `min` calculates the minimum value in each group. `min` is compatible with most types;
//     string, multiple, text, email, int, float, and datetime. It returns a value of the same
//     type as operated on. This means that `{"lowest_latency": {"min": "latency"}}` where
//     `latency` is an int, will always return an int.
//
//   - `max` calculates the maximum value in each group. `max` shares the same compatibility as
//     `min`.
//
//   - `sum` adds up all values in a group. `sum` can be run on `int` and `float` types, and will
//     return a value of the same type as requested.
//
//   - `average` averages all values in a group. `average` can be run on `int` and `float` types, and
//     always returns a float.
type SummaryExpression = map[string]any
