// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
	strconv "strconv"
)

// The consistency level for this request.
type SummarizeTableRequestConsistency uint8

const (
	SummarizeTableRequestConsistencyStrong SummarizeTableRequestConsistency = iota + 1
	SummarizeTableRequestConsistencyEventual
)

func (s SummarizeTableRequestConsistency) String() string {
	switch s {
	default:
		return strconv.Itoa(int(s))
	case SummarizeTableRequestConsistencyStrong:
		return "strong"
	case SummarizeTableRequestConsistencyEventual:
		return "eventual"
	}
}

func (s SummarizeTableRequestConsistency) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%q", s.String())), nil
}

func (s *SummarizeTableRequestConsistency) UnmarshalJSON(data []byte) error {
	var raw string
	if err := json.Unmarshal(data, &raw); err != nil {
		return err
	}
	switch raw {
	case "strong":
		value := SummarizeTableRequestConsistencyStrong
		*s = value
	case "eventual":
		value := SummarizeTableRequestConsistencyEventual
		*s = value
	}
	return nil
}
