// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	bytes "bytes"
	context "context"
	json "encoding/json"
	errors "errors"
	fmt "fmt"
	core "github.com/xataio/xata-go/xata/internal/fern-workspace/generated/go/core"
	io "io"
	http "net/http"
)

type SqlClient interface {
	Query(ctx context.Context, dbBranchName DbBranchName, request *SqlQueryRequest) (*SqlQueryResponse, error)
}

func NewSqlClient(opts ...core.ClientOption) SqlClient {
	options := core.NewClientOptions()
	for _, opt := range opts {
		opt(options)
	}
	return &sqlClient{
		baseURL:    options.BaseURL,
		httpClient: options.HTTPClient,
		header:     options.ToHeader(),
	}
}

type sqlClient struct {
	baseURL    string
	httpClient core.HTTPClient
	header     http.Header
}

// Run an SQL query across the database branch.
//
// The DBBranchName matches the pattern `{db_name}:{branch_name}`.
func (s *sqlClient) Query(ctx context.Context, dbBranchName DbBranchName, request *SqlQueryRequest) (*SqlQueryResponse, error) {
	baseURL := "/"
	if s.baseURL != "" {
		baseURL = s.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"db/%v/sql", dbBranchName)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 404:
			value := new(NotFoundError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 503:
			value := new(ServiceUnavailableError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *SqlQueryResponse
	if err := core.DoRequest(
		ctx,
		s.httpClient,
		endpointURL,
		http.MethodPost,
		request,
		&response,
		false,
		s.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}
