// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
	strconv "strconv"
)

type SortOrder uint8

const (
	SortOrderAsc SortOrder = iota + 1
	SortOrderDesc
	SortOrderRandom
)

func (s SortOrder) String() string {
	switch s {
	default:
		return strconv.Itoa(int(s))
	case SortOrderAsc:
		return "asc"
	case SortOrderDesc:
		return "desc"
	case SortOrderRandom:
		return "random"
	}
}

func (s SortOrder) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%q", s.String())), nil
}

func (s *SortOrder) UnmarshalJSON(data []byte) error {
	var raw string
	if err := json.Unmarshal(data, &raw); err != nil {
		return err
	}
	switch raw {
	case "asc":
		value := SortOrderAsc
		*s = value
	case "desc":
		value := SortOrderDesc
		*s = value
	case "random":
		value := SortOrderRandom
		*s = value
	}
	return nil
}
