// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

type SortExpression struct {
	typeName               string
	StringList             []string
	StringSortOrderMap     map[string]SortOrder
	StringSortOrderMapList []map[string]SortOrder
}

func NewSortExpressionFromStringList(value []string) *SortExpression {
	return &SortExpression{typeName: "stringList", StringList: value}
}

func NewSortExpressionFromStringSortOrderMap(value map[string]SortOrder) *SortExpression {
	return &SortExpression{typeName: "stringSortOrderMap", StringSortOrderMap: value}
}

func NewSortExpressionFromStringSortOrderMapList(value []map[string]SortOrder) *SortExpression {
	return &SortExpression{typeName: "stringSortOrderMapList", StringSortOrderMapList: value}
}

func (s *SortExpression) UnmarshalJSON(data []byte) error {
	var valueStringList []string
	if err := json.Unmarshal(data, &valueStringList); err == nil {
		s.typeName = "stringList"
		s.StringList = valueStringList
		return nil
	}
	var valueStringSortOrderMap map[string]SortOrder
	if err := json.Unmarshal(data, &valueStringSortOrderMap); err == nil {
		s.typeName = "stringSortOrderMap"
		s.StringSortOrderMap = valueStringSortOrderMap
		return nil
	}
	var valueStringSortOrderMapList []map[string]SortOrder
	if err := json.Unmarshal(data, &valueStringSortOrderMapList); err == nil {
		s.typeName = "stringSortOrderMapList"
		s.StringSortOrderMapList = valueStringSortOrderMapList
		return nil
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, s)
}

func (s SortExpression) MarshalJSON() ([]byte, error) {
	switch s.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", s.typeName, s)
	case "stringList":
		return json.Marshal(s.StringList)
	case "stringSortOrderMap":
		return json.Marshal(s.StringSortOrderMap)
	case "stringSortOrderMapList":
		return json.Marshal(s.StringSortOrderMapList)
	}
}

type SortExpressionVisitor interface {
	VisitStringList([]string) error
	VisitStringSortOrderMap(map[string]SortOrder) error
	VisitStringSortOrderMapList([]map[string]SortOrder) error
}

func (s *SortExpression) Accept(v SortExpressionVisitor) error {
	switch s.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", s.typeName, s)
	case "stringList":
		return v.VisitStringList(s.StringList)
	case "stringSortOrderMap":
		return v.VisitStringSortOrderMap(s.StringSortOrderMap)
	case "stringSortOrderMapList":
		return v.VisitStringSortOrderMapList(s.StringSortOrderMapList)
	}
}
