// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
	strconv "strconv"
)

type ResolveBranchResponseReasonCode uint8

const (
	ResolveBranchResponseReasonCodeFoundInMapping ResolveBranchResponseReasonCode = iota + 1
	ResolveBranchResponseReasonCodeBranchExists
	ResolveBranchResponseReasonCodeFallbackBranch
	ResolveBranchResponseReasonCodeDefaultBranch
)

func (r ResolveBranchResponseReasonCode) String() string {
	switch r {
	default:
		return strconv.Itoa(int(r))
	case ResolveBranchResponseReasonCodeFoundInMapping:
		return "FOUND_IN_MAPPING"
	case ResolveBranchResponseReasonCodeBranchExists:
		return "BRANCH_EXISTS"
	case ResolveBranchResponseReasonCodeFallbackBranch:
		return "FALLBACK_BRANCH"
	case ResolveBranchResponseReasonCodeDefaultBranch:
		return "DEFAULT_BRANCH"
	}
}

func (r ResolveBranchResponseReasonCode) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%q", r.String())), nil
}

func (r *ResolveBranchResponseReasonCode) UnmarshalJSON(data []byte) error {
	var raw string
	if err := json.Unmarshal(data, &raw); err != nil {
		return err
	}
	switch raw {
	case "FOUND_IN_MAPPING":
		value := ResolveBranchResponseReasonCodeFoundInMapping
		*r = value
	case "BRANCH_EXISTS":
		value := ResolveBranchResponseReasonCodeBranchExists
		*r = value
	case "FALLBACK_BRANCH":
		value := ResolveBranchResponseReasonCodeFallbackBranch
		*r = value
	case "DEFAULT_BRANCH":
		value := ResolveBranchResponseReasonCodeDefaultBranch
		*r = value
	}
	return nil
}
