// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

type RecordMetaXataHighlightValue struct {
	typeName         string
	StringList       []string
	StringUnknownMap map[string]any
}

func NewRecordMetaXataHighlightValueFromStringList(value []string) *RecordMetaXataHighlightValue {
	return &RecordMetaXataHighlightValue{typeName: "stringList", StringList: value}
}

func NewRecordMetaXataHighlightValueFromStringUnknownMap(value map[string]any) *RecordMetaXataHighlightValue {
	return &RecordMetaXataHighlightValue{typeName: "stringUnknownMap", StringUnknownMap: value}
}

func (r *RecordMetaXataHighlightValue) UnmarshalJSON(data []byte) error {
	var valueStringList []string
	if err := json.Unmarshal(data, &valueStringList); err == nil {
		r.typeName = "stringList"
		r.StringList = valueStringList
		return nil
	}
	var valueStringUnknownMap map[string]any
	if err := json.Unmarshal(data, &valueStringUnknownMap); err == nil {
		r.typeName = "stringUnknownMap"
		r.StringUnknownMap = valueStringUnknownMap
		return nil
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, r)
}

func (r RecordMetaXataHighlightValue) MarshalJSON() ([]byte, error) {
	switch r.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", r.typeName, r)
	case "stringList":
		return json.Marshal(r.StringList)
	case "stringUnknownMap":
		return json.Marshal(r.StringUnknownMap)
	}
}

type RecordMetaXataHighlightValueVisitor interface {
	VisitStringList([]string) error
	VisitStringUnknownMap(map[string]any) error
}

func (r *RecordMetaXataHighlightValue) Accept(v RecordMetaXataHighlightValueVisitor) error {
	switch r.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", r.typeName, r)
	case "stringList":
		return v.VisitStringList(r.StringList)
	case "stringUnknownMap":
		return v.VisitStringUnknownMap(r.StringUnknownMap)
	}
}
