// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

type RecordMetaXata struct {
	// The time when the record was created.
	CreatedAt *string `json:"createdAt,omitempty"`
	// Highlights of the record. This is used by the search APIs to indicate which fields and parts of the fields have matched the search.
	Highlight *map[string]*RecordMetaXataHighlightValue `json:"highlight,omitempty"`
	// The record's relevancy score. This is returned by the search APIs.
	Score *float64 `json:"score,omitempty"`
	// The record's table name. APIs that return records from multiple tables will set this field accordingly.
	Table *string `json:"table,omitempty"`
	// The time when the record was last updated.
	UpdatedAt *string `json:"updatedAt,omitempty"`
	// The record's version. Can be used for optimistic concurrency control.
	Version int `json:"version"`
	// Encoding/Decoding errors
	Warnings *[]string `json:"warnings,omitempty"`
}
