// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
	strconv "strconv"
)

// The consistency level for this request.
type QueryTableRequestConsistency uint8

const (
	QueryTableRequestConsistencyStrong QueryTableRequestConsistency = iota + 1
	QueryTableRequestConsistencyEventual
)

func (q QueryTableRequestConsistency) String() string {
	switch q {
	default:
		return strconv.Itoa(int(q))
	case QueryTableRequestConsistencyStrong:
		return "strong"
	case QueryTableRequestConsistencyEventual:
		return "eventual"
	}
}

func (q QueryTableRequestConsistency) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%q", q.String())), nil
}

func (q *QueryTableRequestConsistency) UnmarshalJSON(data []byte) error {
	var raw string
	if err := json.Unmarshal(data, &raw); err != nil {
		return err
	}
	switch raw {
	case "strong":
		value := QueryTableRequestConsistencyStrong
		*q = value
	case "eventual":
		value := QueryTableRequestConsistencyEventual
		*q = value
	}
	return nil
}
