// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

// Split data into buckets by dynamic numeric ranges. Accepts sub-aggregations for each bucket.
type NumericHistogramAgg struct {
	Aggs *AggExpressionMap `json:"aggs,omitempty"`
	// The column to use for bucketing. Must be of numeric type.
	Column string `json:"column"`
	// The numeric interval to use for bucketing. The resulting buckets will be ranges
	// with this value as size.
	Interval float64 `json:"interval"`
	// By default the bucket keys start with 0 and then continue in `interval` steps. The bucket
	// boundaries can be shifted by using the offset option. For example, if the `interval` is 100,
	// but you prefer the bucket boundaries to be `[50, 150), [150, 250), etc.`, you can set `offset`
	// to 50.
	Offset *float64 `json:"offset,omitempty"`
}
