// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
	strconv "strconv"
)

// Modifier to be applied to the column value, before being multiplied with the factor. The possible values are:
//   - none (default).
//   - log: common logarithm (base 10)
//   - log1p: add 1 then take the common logarithm. This ensures that the value is positive if the
//     value is between 0 and 1.
//   - ln: natural logarithm (base e)
//   - ln1p: add 1 then take the natural logarithm. This ensures that the value is positive if the
//     value is between 0 and 1.
//   - square: raise the value to the power of two.
//   - sqrt: take the square root of the value.
//   - reciprocal: reciprocate the value (if the value is `x`, the reciprocal is `1/x`).
type NumericBoosterModifier uint8

const (
	NumericBoosterModifierNone NumericBoosterModifier = iota + 1
	NumericBoosterModifierLog
	NumericBoosterModifierLog1P
	NumericBoosterModifierLn
	NumericBoosterModifierLn1P
	NumericBoosterModifierSquare
	NumericBoosterModifierSqrt
	NumericBoosterModifierReciprocal
)

func (n NumericBoosterModifier) String() string {
	switch n {
	default:
		return strconv.Itoa(int(n))
	case NumericBoosterModifierNone:
		return "none"
	case NumericBoosterModifierLog:
		return "log"
	case NumericBoosterModifierLog1P:
		return "log1p"
	case NumericBoosterModifierLn:
		return "ln"
	case NumericBoosterModifierLn1P:
		return "ln1p"
	case NumericBoosterModifierSquare:
		return "square"
	case NumericBoosterModifierSqrt:
		return "sqrt"
	case NumericBoosterModifierReciprocal:
		return "reciprocal"
	}
}

func (n NumericBoosterModifier) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%q", n.String())), nil
}

func (n *NumericBoosterModifier) UnmarshalJSON(data []byte) error {
	var raw string
	if err := json.Unmarshal(data, &raw); err != nil {
		return err
	}
	switch raw {
	case "none":
		value := NumericBoosterModifierNone
		*n = value
	case "log":
		value := NumericBoosterModifierLog
		*n = value
	case "log1p":
		value := NumericBoosterModifierLog1P
		*n = value
	case "ln":
		value := NumericBoosterModifierLn
		*n = value
	case "ln1p":
		value := NumericBoosterModifierLn1P
		*n = value
	case "square":
		value := NumericBoosterModifierSquare
		*n = value
	case "sqrt":
		value := NumericBoosterModifierSqrt
		*n = value
	case "reciprocal":
		value := NumericBoosterModifierReciprocal
		*n = value
	}
	return nil
}
