// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

// Boost records based on the value of a numeric column.
type NumericBooster struct {
	// The column in which to look for the value.
	Column string `json:"column"`
	// The factor with which to multiply the value of the column before adding it to the item score.
	Factor float64 `json:"factor"`
	// Only apply this booster to the records for which the provided filter matches.
	IfMatchesFilter *FilterExpression `json:"ifMatchesFilter,omitempty"`
	// Modifier to be applied to the column value, before being multiplied with the factor. The possible values are:
	//   - none (default).
	//   - log: common logarithm (base 10)
	//   - log1p: add 1 then take the common logarithm. This ensures that the value is positive if the
	//     value is between 0 and 1.
	//   - ln: natural logarithm (base e)
	//   - ln1p: add 1 then take the natural logarithm. This ensures that the value is positive if the
	//     value is between 0 and 1.
	//   - square: raise the value to the power of two.
	//   - sqrt: take the square root of the value.
	//   - reciprocal: reciprocate the value (if the value is `x`, the reciprocal is `1/x`).
	Modifier *NumericBoosterModifier `json:"modifier,omitempty"`
}
