// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
	strconv "strconv"
)

type MigrationRequestStatus uint8

const (
	MigrationRequestStatusOpen MigrationRequestStatus = iota + 1
	MigrationRequestStatusClosed
	MigrationRequestStatusMerging
	MigrationRequestStatusMerged
	MigrationRequestStatusFailed
)

func (m MigrationRequestStatus) String() string {
	switch m {
	default:
		return strconv.Itoa(int(m))
	case MigrationRequestStatusOpen:
		return "open"
	case MigrationRequestStatusClosed:
		return "closed"
	case MigrationRequestStatusMerging:
		return "merging"
	case MigrationRequestStatusMerged:
		return "merged"
	case MigrationRequestStatusFailed:
		return "failed"
	}
}

func (m MigrationRequestStatus) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%q", m.String())), nil
}

func (m *MigrationRequestStatus) UnmarshalJSON(data []byte) error {
	var raw string
	if err := json.Unmarshal(data, &raw); err != nil {
		return err
	}
	switch raw {
	case "open":
		value := MigrationRequestStatusOpen
		*m = value
	case "closed":
		value := MigrationRequestStatusClosed
		*m = value
	case "merging":
		value := MigrationRequestStatusMerging
		*m = value
	case "merged":
		value := MigrationRequestStatusMerged
		*m = value
	case "failed":
		value := MigrationRequestStatusFailed
		*m = value
	}
	return nil
}
