// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

type MigrationColumnOp struct {
	typeName                      string
	MigrationColumnOpAddColumn    *MigrationColumnOpAddColumn
	MigrationColumnOpRemoveColumn *MigrationColumnOpRemoveColumn
	MigrationColumnOpRenameColumn *MigrationColumnOpRenameColumn
}

func NewMigrationColumnOpFromMigrationColumnOpAddColumn(value *MigrationColumnOpAddColumn) *MigrationColumnOp {
	return &MigrationColumnOp{typeName: "migrationColumnOpAddColumn", MigrationColumnOpAddColumn: value}
}

func NewMigrationColumnOpFromMigrationColumnOpRemoveColumn(value *MigrationColumnOpRemoveColumn) *MigrationColumnOp {
	return &MigrationColumnOp{typeName: "migrationColumnOpRemoveColumn", MigrationColumnOpRemoveColumn: value}
}

func NewMigrationColumnOpFromMigrationColumnOpRenameColumn(value *MigrationColumnOpRenameColumn) *MigrationColumnOp {
	return &MigrationColumnOp{typeName: "migrationColumnOpRenameColumn", MigrationColumnOpRenameColumn: value}
}

func (m *MigrationColumnOp) UnmarshalJSON(data []byte) error {
	valueMigrationColumnOpAddColumn := new(MigrationColumnOpAddColumn)
	if err := json.Unmarshal(data, &valueMigrationColumnOpAddColumn); err == nil {
		m.typeName = "migrationColumnOpAddColumn"
		m.MigrationColumnOpAddColumn = valueMigrationColumnOpAddColumn
		return nil
	}
	valueMigrationColumnOpRemoveColumn := new(MigrationColumnOpRemoveColumn)
	if err := json.Unmarshal(data, &valueMigrationColumnOpRemoveColumn); err == nil {
		m.typeName = "migrationColumnOpRemoveColumn"
		m.MigrationColumnOpRemoveColumn = valueMigrationColumnOpRemoveColumn
		return nil
	}
	valueMigrationColumnOpRenameColumn := new(MigrationColumnOpRenameColumn)
	if err := json.Unmarshal(data, &valueMigrationColumnOpRenameColumn); err == nil {
		m.typeName = "migrationColumnOpRenameColumn"
		m.MigrationColumnOpRenameColumn = valueMigrationColumnOpRenameColumn
		return nil
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, m)
}

func (m MigrationColumnOp) MarshalJSON() ([]byte, error) {
	switch m.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", m.typeName, m)
	case "migrationColumnOpAddColumn":
		return json.Marshal(m.MigrationColumnOpAddColumn)
	case "migrationColumnOpRemoveColumn":
		return json.Marshal(m.MigrationColumnOpRemoveColumn)
	case "migrationColumnOpRenameColumn":
		return json.Marshal(m.MigrationColumnOpRenameColumn)
	}
}

type MigrationColumnOpVisitor interface {
	VisitMigrationColumnOpAddColumn(*MigrationColumnOpAddColumn) error
	VisitMigrationColumnOpRemoveColumn(*MigrationColumnOpRemoveColumn) error
	VisitMigrationColumnOpRenameColumn(*MigrationColumnOpRenameColumn) error
}

func (m *MigrationColumnOp) Accept(v MigrationColumnOpVisitor) error {
	switch m.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", m.typeName, m)
	case "migrationColumnOpAddColumn":
		return v.VisitMigrationColumnOpAddColumn(m.MigrationColumnOpAddColumn)
	case "migrationColumnOpRemoveColumn":
		return v.VisitMigrationColumnOpRemoveColumn(m.MigrationColumnOpRemoveColumn)
	case "migrationColumnOpRenameColumn":
		return v.VisitMigrationColumnOpRenameColumn(m.MigrationColumnOpRenameColumn)
	}
}
