// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

type FilterValue struct {
	typeName string
	Double   float64
	String   string
	Boolean  bool
}

func NewFilterValueFromDouble(value float64) *FilterValue {
	return &FilterValue{typeName: "double", Double: value}
}

func NewFilterValueFromString(value string) *FilterValue {
	return &FilterValue{typeName: "string", String: value}
}

func NewFilterValueFromBoolean(value bool) *FilterValue {
	return &FilterValue{typeName: "boolean", Boolean: value}
}

func (f *FilterValue) UnmarshalJSON(data []byte) error {
	var valueDouble float64
	if err := json.Unmarshal(data, &valueDouble); err == nil {
		f.typeName = "double"
		f.Double = valueDouble
		return nil
	}
	var valueString string
	if err := json.Unmarshal(data, &valueString); err == nil {
		f.typeName = "string"
		f.String = valueString
		return nil
	}
	var valueBoolean bool
	if err := json.Unmarshal(data, &valueBoolean); err == nil {
		f.typeName = "boolean"
		f.Boolean = valueBoolean
		return nil
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, f)
}

func (f FilterValue) MarshalJSON() ([]byte, error) {
	switch f.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", f.typeName, f)
	case "double":
		return json.Marshal(f.Double)
	case "string":
		return json.Marshal(f.String)
	case "boolean":
		return json.Marshal(f.Boolean)
	}
}

type FilterValueVisitor interface {
	VisitDouble(float64) error
	VisitString(string) error
	VisitBoolean(bool) error
}

func (f *FilterValue) Accept(v FilterValueVisitor) error {
	switch f.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", f.typeName, f)
	case "double":
		return v.VisitDouble(f.Double)
	case "string":
		return v.VisitString(f.String)
	case "boolean":
		return v.VisitBoolean(f.Boolean)
	}
}
