// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

type FilterRangeValue struct {
	typeName string
	Double   float64
	String   string
}

func NewFilterRangeValueFromDouble(value float64) *FilterRangeValue {
	return &FilterRangeValue{typeName: "double", Double: value}
}

func NewFilterRangeValueFromString(value string) *FilterRangeValue {
	return &FilterRangeValue{typeName: "string", String: value}
}

func (f *FilterRangeValue) UnmarshalJSON(data []byte) error {
	var valueDouble float64
	if err := json.Unmarshal(data, &valueDouble); err == nil {
		f.typeName = "double"
		f.Double = valueDouble
		return nil
	}
	var valueString string
	if err := json.Unmarshal(data, &valueString); err == nil {
		f.typeName = "string"
		f.String = valueString
		return nil
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, f)
}

func (f FilterRangeValue) MarshalJSON() ([]byte, error) {
	switch f.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", f.typeName, f)
	case "double":
		return json.Marshal(f.Double)
	case "string":
		return json.Marshal(f.String)
	}
}

type FilterRangeValueVisitor interface {
	VisitDouble(float64) error
	VisitString(string) error
}

func (f *FilterRangeValue) Accept(v FilterRangeValueVisitor) error {
	switch f.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", f.typeName, f)
	case "double":
		return v.VisitDouble(f.Double)
	case "string":
		return v.VisitString(f.String)
	}
}
