// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

type FilterPredicateOpNot struct {
	typeName            string
	FilterPredicate     *FilterPredicate
	FilterPredicateList []*FilterPredicate
}

func NewFilterPredicateOpNotFromFilterPredicate(value *FilterPredicate) *FilterPredicateOpNot {
	return &FilterPredicateOpNot{typeName: "filterPredicate", FilterPredicate: value}
}

func NewFilterPredicateOpNotFromFilterPredicateList(value []*FilterPredicate) *FilterPredicateOpNot {
	return &FilterPredicateOpNot{typeName: "filterPredicateList", FilterPredicateList: value}
}

func (f *FilterPredicateOpNot) UnmarshalJSON(data []byte) error {
	valueFilterPredicate := new(FilterPredicate)
	if err := json.Unmarshal(data, &valueFilterPredicate); err == nil {
		f.typeName = "filterPredicate"
		f.FilterPredicate = valueFilterPredicate
		return nil
	}
	var valueFilterPredicateList []*FilterPredicate
	if err := json.Unmarshal(data, &valueFilterPredicateList); err == nil {
		f.typeName = "filterPredicateList"
		f.FilterPredicateList = valueFilterPredicateList
		return nil
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, f)
}

func (f FilterPredicateOpNot) MarshalJSON() ([]byte, error) {
	switch f.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", f.typeName, f)
	case "filterPredicate":
		return json.Marshal(f.FilterPredicate)
	case "filterPredicateList":
		return json.Marshal(f.FilterPredicateList)
	}
}

type FilterPredicateOpNotVisitor interface {
	VisitFilterPredicate(*FilterPredicate) error
	VisitFilterPredicateList([]*FilterPredicate) error
}

func (f *FilterPredicateOpNot) Accept(v FilterPredicateOpNotVisitor) error {
	switch f.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", f.typeName, f)
	case "filterPredicate":
		return v.VisitFilterPredicate(f.FilterPredicate)
	case "filterPredicateList":
		return v.VisitFilterPredicateList(f.FilterPredicateList)
	}
}
