// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

type FilterPredicateOpIs struct {
	typeName        string
	FilterValue     *FilterValue
	FilterValueList []*FilterValue
}

func NewFilterPredicateOpIsFromFilterValue(value *FilterValue) *FilterPredicateOpIs {
	return &FilterPredicateOpIs{typeName: "filterValue", FilterValue: value}
}

func NewFilterPredicateOpIsFromFilterValueList(value []*FilterValue) *FilterPredicateOpIs {
	return &FilterPredicateOpIs{typeName: "filterValueList", FilterValueList: value}
}

func (f *FilterPredicateOpIs) UnmarshalJSON(data []byte) error {
	valueFilterValue := new(FilterValue)
	if err := json.Unmarshal(data, &valueFilterValue); err == nil {
		f.typeName = "filterValue"
		f.FilterValue = valueFilterValue
		return nil
	}
	var valueFilterValueList []*FilterValue
	if err := json.Unmarshal(data, &valueFilterValueList); err == nil {
		f.typeName = "filterValueList"
		f.FilterValueList = valueFilterValueList
		return nil
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, f)
}

func (f FilterPredicateOpIs) MarshalJSON() ([]byte, error) {
	switch f.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", f.typeName, f)
	case "filterValue":
		return json.Marshal(f.FilterValue)
	case "filterValueList":
		return json.Marshal(f.FilterValueList)
	}
}

type FilterPredicateOpIsVisitor interface {
	VisitFilterValue(*FilterValue) error
	VisitFilterValueList([]*FilterValue) error
}

func (f *FilterPredicateOpIs) Accept(v FilterPredicateOpIsVisitor) error {
	switch f.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", f.typeName, f)
	case "filterValue":
		return v.VisitFilterValue(f.FilterValue)
	case "filterValueList":
		return v.VisitFilterValueList(f.FilterValueList)
	}
}
