// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

// Count the number of records with an optional filter.
type CountAgg struct {
	typeName       string
	CountAggFilter *CountAggFilter
	stringLiteral  string
}

func NewCountAggFromCountAggFilter(value *CountAggFilter) *CountAgg {
	return &CountAgg{typeName: "countAggFilter", CountAggFilter: value}
}

func NewCountAggWithStringLiteral() *CountAgg {
	return &CountAgg{typeName: "stringLiteral", stringLiteral: "*"}
}

func (c *CountAgg) StringLiteral() string {
	return c.stringLiteral
}

func (c *CountAgg) UnmarshalJSON(data []byte) error {
	valueCountAggFilter := new(CountAggFilter)
	if err := json.Unmarshal(data, &valueCountAggFilter); err == nil {
		c.typeName = "countAggFilter"
		c.CountAggFilter = valueCountAggFilter
		return nil
	}
	var valueStringLiteral string
	if err := json.Unmarshal(data, &valueStringLiteral); err == nil {
		if valueStringLiteral == "*" {
			c.typeName = "stringLiteral"
			c.stringLiteral = valueStringLiteral
			return nil
		}
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, c)
}

func (c CountAgg) MarshalJSON() ([]byte, error) {
	switch c.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", c.typeName, c)
	case "countAggFilter":
		return json.Marshal(c.CountAggFilter)
	case "stringLiteral":
		return json.Marshal("*")
	}
}

type CountAggVisitor interface {
	VisitCountAggFilter(*CountAggFilter) error
	VisitStringLiteral(string) error
}

func (c *CountAgg) Accept(v CountAggVisitor) error {
	switch c.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", c.typeName, c)
	case "countAggFilter":
		return v.VisitCountAggFilter(c.CountAggFilter)
	case "stringLiteral":
		return v.VisitStringLiteral(c.stringLiteral)
	}
}
