// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	core "github.com/xataio/xata-go/xata/internal/fern-workspace/generated/go/core"
	http "net/http"
)

type Client interface {
	Branch() BranchClient
	Migrations() MigrationsClient
	SearchAndFilter() SearchAndFilterClient
	Sql() SqlClient
	Table() TableClient
	Records() RecordsClient
	Files() FilesClient
}

func NewClient(opts ...core.ClientOption) Client {
	options := core.NewClientOptions()
	for _, opt := range opts {
		opt(options)
	}
	return &client{
		baseURL:               options.BaseURL,
		httpClient:            options.HTTPClient,
		header:                options.ToHeader(),
		branchClient:          NewBranchClient(opts...),
		migrationsClient:      NewMigrationsClient(opts...),
		searchAndFilterClient: NewSearchAndFilterClient(opts...),
		sqlClient:             NewSqlClient(opts...),
		tableClient:           NewTableClient(opts...),
		recordsClient:         NewRecordsClient(opts...),
		filesClient:           NewFilesClient(opts...),
	}
}

type client struct {
	baseURL               string
	httpClient            core.HTTPClient
	header                http.Header
	branchClient          BranchClient
	migrationsClient      MigrationsClient
	searchAndFilterClient SearchAndFilterClient
	sqlClient             SqlClient
	tableClient           TableClient
	recordsClient         RecordsClient
	filesClient           FilesClient
}

func (c *client) Branch() BranchClient {
	return c.branchClient
}

func (c *client) Migrations() MigrationsClient {
	return c.migrationsClient
}

func (c *client) SearchAndFilter() SearchAndFilterClient {
	return c.searchAndFilterClient
}

func (c *client) Sql() SqlClient {
	return c.sqlClient
}

func (c *client) Table() TableClient {
	return c.tableClient
}

func (c *client) Records() RecordsClient {
	return c.recordsClient
}

func (c *client) Files() FilesClient {
	return c.filesClient
}
