// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
)

type AggResponse struct {
	typeName          string
	DoubleOptional    *float64
	AggResponseValues *AggResponseValues
}

func NewAggResponseFromDoubleOptional(value *float64) *AggResponse {
	return &AggResponse{typeName: "doubleOptional", DoubleOptional: value}
}

func NewAggResponseFromAggResponseValues(value *AggResponseValues) *AggResponse {
	return &AggResponse{typeName: "aggResponseValues", AggResponseValues: value}
}

func (a *AggResponse) UnmarshalJSON(data []byte) error {
	var valueDoubleOptional *float64
	if err := json.Unmarshal(data, &valueDoubleOptional); err == nil {
		a.typeName = "doubleOptional"
		a.DoubleOptional = valueDoubleOptional
		return nil
	}
	valueAggResponseValues := new(AggResponseValues)
	if err := json.Unmarshal(data, &valueAggResponseValues); err == nil {
		a.typeName = "aggResponseValues"
		a.AggResponseValues = valueAggResponseValues
		return nil
	}
	return fmt.Errorf("%s cannot be deserialized as a %T", data, a)
}

func (a AggResponse) MarshalJSON() ([]byte, error) {
	switch a.typeName {
	default:
		return nil, fmt.Errorf("invalid type %s in %T", a.typeName, a)
	case "doubleOptional":
		return json.Marshal(a.DoubleOptional)
	case "aggResponseValues":
		return json.Marshal(a.AggResponseValues)
	}
}

type AggResponseVisitor interface {
	VisitDoubleOptional(*float64) error
	VisitAggResponseValues(*AggResponseValues) error
}

func (a *AggResponse) Accept(v AggResponseVisitor) error {
	switch a.typeName {
	default:
		return fmt.Errorf("invalid type %s in %T", a.typeName, a)
	case "doubleOptional":
		return v.VisitDoubleOptional(a.DoubleOptional)
	case "aggResponseValues":
		return v.VisitAggResponseValues(a.AggResponseValues)
	}
}
