// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	json "encoding/json"
	fmt "fmt"
	strconv "strconv"
)

type Role uint8

const (
	RoleOwner Role = iota + 1
	RoleMaintainer
)

func (r Role) String() string {
	switch r {
	default:
		return strconv.Itoa(int(r))
	case RoleOwner:
		return "owner"
	case RoleMaintainer:
		return "maintainer"
	}
}

func (r Role) MarshalJSON() ([]byte, error) {
	return []byte(fmt.Sprintf("%q", r.String())), nil
}

func (r *Role) UnmarshalJSON(data []byte) error {
	var raw string
	if err := json.Unmarshal(data, &raw); err != nil {
		return err
	}
	switch raw {
	case "owner":
		value := RoleOwner
		*r = value
	case "maintainer":
		value := RoleMaintainer
		*r = value
	}
	return nil
}
