// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	bytes "bytes"
	context "context"
	json "encoding/json"
	errors "errors"
	fmt "fmt"
	core "github.com/xataio/xata-go/xata/internal/fern-core/generated/go/core"
	io "io"
	http "net/http"
)

type OAuthClient interface {
	GetUserOAuthClients(ctx context.Context) (*GetUserOAuthClientsResponse, error)
	DeleteUserOAuthClient(ctx context.Context, clientId OAuthClientId) error
	GetUserOAuthAccessTokens(ctx context.Context) (*GetUserOAuthAccessTokensResponse, error)
	DeleteOAuthAccessToken(ctx context.Context, token AccessToken) error
	UpdateOAuthAccessToken(ctx context.Context, token AccessToken, request *UpdateOAuthAccessTokenRequest) (*OAuthAccessToken, error)
}

func NewOAuthClient(opts ...core.ClientOption) OAuthClient {
	options := core.NewClientOptions()
	for _, opt := range opts {
		opt(options)
	}
	return &oAuthClient{
		baseURL:    options.BaseURL,
		httpClient: options.HTTPClient,
		header:     options.ToHeader(),
	}
}

type oAuthClient struct {
	baseURL    string
	httpClient core.HTTPClient
	header     http.Header
}

// Retrieve the list of OAuth Clients that a user has authorized
func (o *oAuthClient) GetUserOAuthClients(ctx context.Context) (*GetUserOAuthClientsResponse, error) {
	baseURL := "/"
	if o.baseURL != "" {
		baseURL = o.baseURL
	}
	endpointURL := baseURL + "/" + "user/oauth/clients"

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 404:
			value := new(NotFoundError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *GetUserOAuthClientsResponse
	if err := core.DoRequest(
		ctx,
		o.httpClient,
		endpointURL,
		http.MethodGet,
		nil,
		&response,
		false,
		o.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}

// Delete the oauth client for the user and revoke all access
func (o *oAuthClient) DeleteUserOAuthClient(ctx context.Context, clientId OAuthClientId) error {
	baseURL := "/"
	if o.baseURL != "" {
		baseURL = o.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"user/oauth/clients/%v", clientId)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 404:
			value := new(NotFoundError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	if err := core.DoRequest(
		ctx,
		o.httpClient,
		endpointURL,
		http.MethodDelete,
		nil,
		nil,
		false,
		o.header,
		errorDecoder,
	); err != nil {
		return err
	}
	return nil
}

// Retrieve the list of valid OAuth Access Tokens on the current user's account
func (o *oAuthClient) GetUserOAuthAccessTokens(ctx context.Context) (*GetUserOAuthAccessTokensResponse, error) {
	baseURL := "/"
	if o.baseURL != "" {
		baseURL = o.baseURL
	}
	endpointURL := baseURL + "/" + "user/oauth/tokens"

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 404:
			value := new(NotFoundError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *GetUserOAuthAccessTokensResponse
	if err := core.DoRequest(
		ctx,
		o.httpClient,
		endpointURL,
		http.MethodGet,
		nil,
		&response,
		false,
		o.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}

// Expires the access token for a third party app
func (o *oAuthClient) DeleteOAuthAccessToken(ctx context.Context, token AccessToken) error {
	baseURL := "/"
	if o.baseURL != "" {
		baseURL = o.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"user/oauth/tokens/%v", token)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 404:
			value := new(NotFoundError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 409:
			value := new(ConflictError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	if err := core.DoRequest(
		ctx,
		o.httpClient,
		endpointURL,
		http.MethodDelete,
		nil,
		nil,
		false,
		o.header,
		errorDecoder,
	); err != nil {
		return err
	}
	return nil
}

// Updates partially the access token for a third party app
func (o *oAuthClient) UpdateOAuthAccessToken(ctx context.Context, token AccessToken, request *UpdateOAuthAccessTokenRequest) (*OAuthAccessToken, error) {
	baseURL := "/"
	if o.baseURL != "" {
		baseURL = o.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"user/oauth/tokens/%v", token)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 404:
			value := new(NotFoundError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 409:
			value := new(ConflictError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *OAuthAccessToken
	if err := core.DoRequest(
		ctx,
		o.httpClient,
		endpointURL,
		http.MethodPatch,
		request,
		&response,
		false,
		o.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}
