// SPDX-License-Identifier: Apache-2.0

// This file was auto-generated by Fern from our API Definition.

package api

import (
	bytes "bytes"
	context "context"
	json "encoding/json"
	errors "errors"
	fmt "fmt"
	core "github.com/xataio/xata-go/xata/internal/fern-core/generated/go/core"
	io "io"
	http "net/http"
)

type DatabasesClient interface {
	GetDatabaseList(ctx context.Context, workspaceId WorkspaceId) (*ListDatabasesResponse, error)
	GetDatabaseMetadata(ctx context.Context, workspaceId WorkspaceId, dbName DbName) (*DatabaseMetadata, error)
	CreateDatabase(ctx context.Context, workspaceId WorkspaceId, dbName DbName, request *CreateDatabaseRequest) (*CreateDatabaseResponse, error)
	DeleteDatabase(ctx context.Context, workspaceId WorkspaceId, dbName DbName) (*DeleteDatabaseResponse, error)
	UpdateDatabaseMetadata(ctx context.Context, workspaceId WorkspaceId, dbName DbName, request *UpdateDatabaseMetadataRequest) (*DatabaseMetadata, error)
	RenameDatabase(ctx context.Context, workspaceId WorkspaceId, dbName DbName, request *RenameDatabaseRequest) (*DatabaseMetadata, error)
	ListRegions(ctx context.Context, workspaceId WorkspaceId) (*ListRegionsResponse, error)
}

func NewDatabasesClient(opts ...core.ClientOption) DatabasesClient {
	options := core.NewClientOptions()
	for _, opt := range opts {
		opt(options)
	}
	return &databasesClient{
		baseURL:    options.BaseURL,
		httpClient: options.HTTPClient,
		header:     options.ToHeader(),
	}
}

type databasesClient struct {
	baseURL    string
	httpClient core.HTTPClient
	header     http.Header
}

// List all databases available in your Workspace.
//
// Workspace ID
func (d *databasesClient) GetDatabaseList(ctx context.Context, workspaceId WorkspaceId) (*ListDatabasesResponse, error) {
	baseURL := "/"
	if d.baseURL != "" {
		baseURL = d.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"workspaces/%v/dbs", workspaceId)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *ListDatabasesResponse
	if err := core.DoRequest(
		ctx,
		d.httpClient,
		endpointURL,
		http.MethodGet,
		nil,
		&response,
		false,
		d.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}

// Retrieve metadata of the given database
//
// Workspace ID
// The Database Name
func (d *databasesClient) GetDatabaseMetadata(ctx context.Context, workspaceId WorkspaceId, dbName DbName) (*DatabaseMetadata, error) {
	baseURL := "/"
	if d.baseURL != "" {
		baseURL = d.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"workspaces/%v/dbs/%v", workspaceId, dbName)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 404:
			value := new(NotFoundError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *DatabaseMetadata
	if err := core.DoRequest(
		ctx,
		d.httpClient,
		endpointURL,
		http.MethodGet,
		nil,
		&response,
		false,
		d.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}

// Create Database with identifier name
//
// Workspace ID
// The Database Name
func (d *databasesClient) CreateDatabase(ctx context.Context, workspaceId WorkspaceId, dbName DbName, request *CreateDatabaseRequest) (*CreateDatabaseResponse, error) {
	baseURL := "/"
	if d.baseURL != "" {
		baseURL = d.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"workspaces/%v/dbs/%v", workspaceId, dbName)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 422:
			value := new(UnprocessableEntityError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *CreateDatabaseResponse
	if err := core.DoRequest(
		ctx,
		d.httpClient,
		endpointURL,
		http.MethodPut,
		request,
		&response,
		false,
		d.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}

// Delete a database and all of its branches and tables permanently.
//
// Workspace ID
// The Database Name
func (d *databasesClient) DeleteDatabase(ctx context.Context, workspaceId WorkspaceId, dbName DbName) (*DeleteDatabaseResponse, error) {
	baseURL := "/"
	if d.baseURL != "" {
		baseURL = d.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"workspaces/%v/dbs/%v", workspaceId, dbName)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 404:
			value := new(NotFoundError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *DeleteDatabaseResponse
	if err := core.DoRequest(
		ctx,
		d.httpClient,
		endpointURL,
		http.MethodDelete,
		nil,
		&response,
		false,
		d.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}

// Update the color of the selected database
//
// Workspace ID
// The Database Name
func (d *databasesClient) UpdateDatabaseMetadata(ctx context.Context, workspaceId WorkspaceId, dbName DbName, request *UpdateDatabaseMetadataRequest) (*DatabaseMetadata, error) {
	baseURL := "/"
	if d.baseURL != "" {
		baseURL = d.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"workspaces/%v/dbs/%v", workspaceId, dbName)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 404:
			value := new(NotFoundError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *DatabaseMetadata
	if err := core.DoRequest(
		ctx,
		d.httpClient,
		endpointURL,
		http.MethodPatch,
		request,
		&response,
		false,
		d.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}

// Change the name of an existing database
//
// Workspace ID
// The Database Name
func (d *databasesClient) RenameDatabase(ctx context.Context, workspaceId WorkspaceId, dbName DbName, request *RenameDatabaseRequest) (*DatabaseMetadata, error) {
	baseURL := "/"
	if d.baseURL != "" {
		baseURL = d.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"workspaces/%v/dbs/%v/rename", workspaceId, dbName)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 422:
			value := new(UnprocessableEntityError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *DatabaseMetadata
	if err := core.DoRequest(
		ctx,
		d.httpClient,
		endpointURL,
		http.MethodPost,
		request,
		&response,
		false,
		d.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}

// List regions available to create a database on
//
// Workspace ID
func (d *databasesClient) ListRegions(ctx context.Context, workspaceId WorkspaceId) (*ListRegionsResponse, error) {
	baseURL := "/"
	if d.baseURL != "" {
		baseURL = d.baseURL
	}
	endpointURL := fmt.Sprintf(baseURL+"/"+"workspaces/%v/regions", workspaceId)

	errorDecoder := func(statusCode int, body io.Reader) error {
		raw, err := io.ReadAll(body)
		if err != nil {
			return err
		}
		apiError := core.NewAPIError(statusCode, errors.New(string(raw)))
		decoder := json.NewDecoder(bytes.NewReader(raw))
		switch statusCode {
		case 400:
			value := new(BadRequestError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		case 401:
			value := new(UnauthorizedError)
			value.APIError = apiError
			if err := decoder.Decode(value); err != nil {
				return err
			}
			return value
		}
		return apiError
	}

	var response *ListRegionsResponse
	if err := core.DoRequest(
		ctx,
		d.httpClient,
		endpointURL,
		http.MethodGet,
		nil,
		&response,
		false,
		d.header,
		errorDecoder,
	); err != nil {
		return response, err
	}
	return response, nil
}
