﻿/***************************************************************************************************
 * Copyright 2024 x-tools-author(x-tools@outlook.com). All rights reserved.
 *
 * The file is encoded using "utf8 with bom", it is a part of xTools project.
 *
 * xTools is licensed according to the terms in the file LICENCE(GPL V3) in the root of the source
 * code directory.
 **************************************************************************************************/
#pragma once

#include "AbstractTransferModel.h"

namespace xTools {

class SerialPortTransferModel : public AbstractTransferModel
{
    Q_OBJECT
public:
    SerialPortTransferModel(QObject *parent = nullptr);
    ~SerialPortTransferModel() override;

    int columnCount(const QModelIndex &parent = QModelIndex()) const override;
    QVariant data(const QModelIndex &index, int role) const override;
    bool setData(const QModelIndex &index, const QVariant &value, int role) override;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const override;
    Qt::ItemFlags flags(const QModelIndex &index) const override;

protected:
    Communication *createTransfer() override;
    bool isEnableRestartingColumn(int column) const override;
};

} // namespace xTools
