# QXlsx

[![Conan Center](https://shields.io/conan/v/qxlsx)](https://conan.io/center/qxlsx)

> *Read this in other languages: [English](README.md), :kr: [한국어](README.ko.md), :ru: [Русский](README.RU.md)*

<p align="center"><img src="https://raw.githubusercontent.com/QtExcel/QXlsx/master/markdown.data/QXlsx-Desktop.png"></p>

- QXlsx - это библиотека чтения / записи файлов Excel (*. Xlsx).
   - Поскольку QtXlsxWriter больше не поддерживается, я создал новый проект, основанный на QtXlsx. (2017-)
- Язык разработки QXlsx - C++. (с Qt)
- Вам не нужно использовать статическую библиотеку или динамический общий объект с помощью QXlsx.
   - Вы также можете использовать его как статическую библиотеку.

## Как использовать
- См. [Примеры](Example.md)
- См. [Wiki](https://github.com/QtExcel/QXlsx/wiki)
- См. [FAQ](https://github.com/QtExcel/QXlsx/wiki/FAQ).

## Как настроить (Установка)

-: Рекомендуется: 
- См. [Как настроить проект QXlsx (qmake)](HowToSetProject.md)
- См. [Как настроить проект QXlsx (cmake)](HowToSetProject-cmake.md)	

## Github Actions

[![Android](https://github.com/QtExcel/QXlsx/actions/workflows/android.yml/badge.svg)](https://github.com/QtExcel/QXlsx/actions/workflows/android.yml) [![IOS](https://github.com/QtExcel/QXlsx/actions/workflows/ios.yml/badge.svg)](https://github.com/QtExcel/QXlsx/actions/workflows/ios.yml) [![MacOS](https://github.com/QtExcel/QXlsx/actions/workflows/macos.yml/badge.svg)](https://github.com/QtExcel/QXlsx/actions/workflows/macos.yml) [![Ubuntu](https://github.com/QtExcel/QXlsx/actions/workflows/ubuntu.yml/badge.svg)](https://github.com/QtExcel/QXlsx/actions/workflows/ubuntu.yml) [![Windows](https://github.com/QtExcel/QXlsx/actions/workflows/windows.yml/badge.svg)](https://github.com/QtExcel/QXlsx/actions/workflows/windows.yml) [![CMake](https://github.com/QtExcel/QXlsx/actions/workflows/cmake.yml/badge.svg)](https://github.com/QtExcel/QXlsx/actions/workflows/cmake.yml) [![cmake-ubuntu](https://github.com/QtExcel/QXlsx/actions/workflows/cmake-ubuntu.yml/badge.svg)](https://github.com/QtExcel/QXlsx/actions/workflows/cmake-ubuntu.yml)

- См. [Протестированные среды](TestEnv.md)

## Вклады
- См. [Участники] (https://github.com/QtExcel/QXlsx/graphs/contributors).

## Лицензия и ссылки
- QXlsx находится под лицензией MIT. [https://github.com/QtExcel/QXlsx] (https://github.com/QtExcel/QXlsx)
- Спасибо за создание следующих замечательных проектов. : +1:
  - Qt находится под лицензией LGPL v3 или коммерческой лицензией. [https://www.qt.io/]] (https://www.qt.io/)
  - QtXlsxWriter находится под лицензией MIT. : +1: [https://github.com/dbzhang800/QtXlsxWriter] (https://github.com/dbzhang800/QtXlsxWriter)
  - Qt-Table-Printer находится под лицензией BSD 3-Clause. [https://github.com/T0ny0/Qt-Table-Printer] (https://github.com/T0ny0/Qt-Table-Printer)
  - рекурсивно под лицензией MIT. [https://github.com/pkoretic/recurse] (https://github.com/pkoretic/recurse)
  - libfort находится под лицензией MIT. [https://github.com/seleznevae/libfort] (https://github.com/seleznevae/libfort)
  - colorprintf находится под лицензией MIT. [https://github.com/VittGam/colorprintf] (https://github.com/VittGam/colorprintf)
  - HelloActions-Qt находится под лицензией MIT. [https://github.com/jaredtao/HelloActions-Qt] (https://github.com/jaredtao/HelloActions-Qt)

##: email: Контакт
- Оставь мне вопрос. [https://github.com/QtExcel/QXlsx/issues] (https://github.com/QtExcel/QXlsx/issues)
- Если вы заинтересованы в участии в проекте, обращайтесь к нам по вопросам.
- Мой родной язык не английский, и я плохо владею английским. Пожалуйста, используйте ЛЕГКИЙ английский. :-)
- Если вы хотите перевести README.md на свой родной язык, свяжитесь со мной.
- Вы можете поднять вопрос или использовать запрос на вытягивание. (например, README.ko.md)

## Похожие проекты

### :star: <b>Qxlnt</b> [https://github.com/QtExcel/Qxlnt](https://github.com/QtExcel/Qxlnt)

<p align="center"><img src="https://github.com/QtExcel/Qxlnt/raw/master/markdown-data/Concept-QXlnt.jpg"></p>

- Qxlnt - это вспомогательный проект, который позволяет использовать xlnt в Qt.
- xlnt - отличная библиотека C ++ для использования файлов Excel xlsx.
- Я искал способ упростить использование в Qt. Конечно, cmake совместим с Qt, но пользоваться им неудобно. Итак, я создал Qxlnt.

### :star: <b>Qlibxlsxwriter</b> [https://github.com/QtExcel/Qlibxlsxwriter](https://github.com/QtExcel/Qlibxlsxwriter)

<p align="center"><img src="https://github.com/QtExcel/Qlibxlsxwriter/raw/master/markdown.data/logo.png"></p>

- Qlibxlsxwriter - это вспомогательный проект, который позволяет использовать libxlsxwriter в Qt.
- libxlsxwriter - это библиотека C для создания файлов Excel XLSX.

### :star: <b>QSimpleXlsxWriter</b> [https://github.com/QtExcel/QSimpleXlsxWriter](https://github.com/QtExcel/QSimpleXlsxWriter)

- Используйте SimpleXlsxWriter в Qt.
- SimpleXlsxWriter - это библиотека C ++ для создания файлов XLSX для MS Excel 2007 и выше.

### This Document
- Written by @NikkiKurashov (github)
- Thank you. I am sorry to forget merge your branch and file. 
