export declare const commonOptions: {
    tabSize: number;
};
export declare const tsxCompilerOptions: () => {
    jsx: import("monaco-editor").languages.typescript.JsxEmit;
    jsxFactory: string;
    jsxFragmentFactory: string;
    target: import("monaco-editor").languages.typescript.ScriptTarget;
    module: import("monaco-editor").languages.typescript.ModuleKind;
    allowSyntheticDefaultImports: boolean;
    esModuleInterop: boolean;
    allowJs: boolean;
    experimentalDecorators: boolean;
    emitDecoratorMetadata: boolean;
    moduleResolution: number;
    removeComments: boolean;
    noImplicitAny: boolean;
    strictNullChecks: boolean;
    strictFunctionTypes: boolean;
    strictPropertyInitialization: boolean;
    noImplicitThis: boolean;
    noImplicitReturns: boolean;
    alwaysStrict: boolean;
    allowUnreachableCode: boolean;
    allowUnusedLabels: boolean;
    downlevelIteration: boolean;
    noEmitHelpers: boolean;
    noLib: boolean;
    noStrictGenericChecks: boolean;
    noUnusedLocals: boolean;
    noUnusedParameters: boolean;
    preserveConstEnums: boolean;
    skipLibCheck: boolean;
    lib: string[];
};
