export declare const initialCode = "export abstract class  CommonRouter {\n    public routeByTo = false;\n    public data: Record<any, any> = {};\n    public params: Record<any, any> = {};\n    public query: Record<any, any> = {};\n    public historyLength = 0;\n\n    protected constructor(options: RouterOptions) {\n        this.init(options);\n    }\n    public abstract push(path: string, data: Record<any, any>, ...args): void\n    public abstract back(...args): void\n    public abstract init(options: RouterOptions): void\n    public abstract before(...args): boolean\n    public abstract after(...args): boolean\n}\n\nexport interface BaseRouter {\n    push(path: string, data?: Record<any, any>, ...args): void\n    back(...args): void\n}\n\nexport interface RouterOptions {\n    type: 'hash' | 'history';\n    after?: () => boolean;\n    before?: () => boolean;\n    routers?: RouterItem[];\n}\n\nexport interface RouterItem {\n    path: string;\n    element: any[] | string | Function;\n}";
