/** @type {Record<string, {iso6393: string, fixture: string}>} */
export const fixtures = {
  cmn_hans: {
    iso6393: 'cmn',
    fixture:
      '鉴于对人类家庭所有成员的固有尊严及其平等的和不移的权利的承认,乃是世界自由、正义与和平的基础, 鉴于对人权的无视和侮蔑已发展为野蛮暴行,这些暴行玷污了人类的良心,而一个人人享有言论和信仰自由并免予恐惧和匮乏的世界的来临,已被宣布为普通人民的最高愿望, 鉴于为使人类不致迫不得已铤而走险对暴政和压迫进行反叛,有必要使人权受法治的保护, 鉴于有必要促进各国间友好关系的发展, 鉴于各联合国国家的人民已在联合国宪章中重申他们对基本人权、人格尊严和价值以及男女平等权利的信念,并决心促成较大自由中的社会进步和生活水平的改善, 鉴于各会员国业已誓愿同联合国合作以促进对人权和基本自由的普遍尊重和遵行, 鉴于对这些权利和自由的普遍了解对于这个誓愿的充分实现具有很大的重要性, 因此现在,大会,发布这一世界人权宣言,作为所有人民和所有国家努力实现的共同标准,以期每一个人和社会机构经常铭念本宣言,努力通过教诲和教育促进对权利和自由的尊重,并通过国家的和国际的渐进措施,使这些权利和自由在各会员国本身人民及在其管辖下领土的人民中得到普遍和有效的承认和遵行;'
  },
  spa: {
    iso6393: 'spa',
    fixture:
      'Considerando que la libertad, la justicia y la paz en el mundo tienen por base el reconocimiento de la dignidad intrínseca y de los derechos iguales e inalienables de todos los miembros de la familia humana; Considerando que el desconocimiento y el menosprecio de los derechos humanos han originado actos de barbarie ultrajantes para la conciencia de la humanidad, y que se ha proclamado, como la aspiración más elevada del hombre, el advenimiento de un mundo en que los seres humanos, liberados del temor y de la miseria, disfruten de la libertad de palabra y de la libertad de creencias; Considerando esencial que los derechos humanos sean protegidos por un régimen de Derecho, a fin de que el hombre no se vea compelido al supremo recurso de la rebelión contra la tiranía y la opresión; Considerando también esencial promover el desarrollo de relaciones amistosas entre las naciones; Considerando que los pueblos de las Naciones Unidas han reafirmado en la Carta su fe en los derechos fundamentale'
  },
  eng: {
    iso6393: 'eng',
    fixture:
      'Whereas recognition of the inherent dignity and of the equal and inalienable rights of all members of the human family is the foundation of freedom, justice and peace in the world, Whereas disregard and contempt for human rights have resulted in barbarous acts which have outraged the conscience of mankind, and the advent of a world in which human beings shall enjoy freedom of speech and belief and freedom from fear and want has been proclaimed as the highest aspiration of the common people, Whereas it is essential, if man is not to be compelled to have recourse, as a last resort, to rebellion against tyranny and oppression, that human rights should be protected by the rule of law, Whereas it is essential to promote the development of friendly relations between nations, Whereas the peoples of the United Nations have in the Charter reaffirmed their faith in fundamental human rights, in the dignity and worth of the human person and in the equal rights of men and women and have determined '
  },
  rus: {
    iso6393: 'rus',
    fixture:
      'Принимая во внимание, что признание достоинства, присущего всем членам человеческой семьи, и равных и неотъемлемых прав их является основой свободы, справедливости и всеобщего мира; и принимая во внимание, что пренебрежение и презрение к правам человека привели к варварским актам, которые возмущают совесть человечества, и что создание такого мира, в котором люди будут иметь свободу слова и убеждений и будут свободны от страха и нужды, провозглашено как высокое стремление людей; и принимая во внимание, что необходимо, чтобы права человека охранялись властью закона в целях обеспечения того, чтобы человек не был вынужден прибегать, в качестве последнего средства, к восстанию против тирании и угнетения; и принимая во внимание, что необходимо содействовать развитию дружественных отношений между народами; и принимая во внимание, что народы Объединенных Наций подтвердили в Уставе свою веру в основные права человека, в достоинство и ценность человеческой личности и в равноправие мужчин и женщи'
  },
  arb: {
    iso6393: 'arb',
    fixture:
      'لمّا كان الاعتراف بالكرامة المتأصلة في جميع أعضاء الأسرة البشرية وبحقوقهم المتساوية الثابتة هو أساس الحرية والعدل والسلام في العالم. ولما كان تناسي حقوق الإنسان وازدراؤها قد أفضيا إلى أعمال همجية آذت الضمير الإنساني. وكان غاية ما يرنو إليه عامة البشر انبثاق عالم يتمتع فيه الفرد بحرية القول والعقيدة ويتحرر من الفزع والفاقة. ولما كان من الضروري أن يتولى القانون حماية حقوق الإنسان لكيلا يضطر المرء آخر الأمر إلى التمرد على الاستبداد والظلم. ولما كانت شعوب الأمم المتحدة قد أكدت في الميثاق من جديد إيمانها بحقوق الإنسان الأساسية وبكرامة الفرد وقدره وبما للرجال والنساء من حقوق متساوية وحزمت أمرها على أن تدفع بالرقي الاجتماعي قدمًا وأن ترفع مستوى الحياة في جو من الحرية أفسح. ولما كانت الدول الأعضاء قد تعهدت بالتعاون مع الأمم المتحدة على ضمان إطراد مراعاة حقوق الإنسان والحريات الأساسية واحترامها. ولما كان للإدراك العام لهذه الحقوق والحريات الأهمية الكبرى للوفاء التام بهذا التعهد. فإن الجمعية العامة تنادي بهذا الإعلان العالمي لحقوق الإنسان على أنه المستوى المشترك الذي ينبغي أن تستهدفه كافة الشعوب'
  },
  ben: {
    iso6393: 'ben',
    fixture:
      'যেহেতু মানব পরিবারের সকল সদস্যের সমান ও অবিচ্ছেদ্য অধিকারসমূহ এবং সহজাত মর্যাদার স্বীকৃতি‌ই হচ্ছে বিশ্বে শান্তি, স্বাধীনতা এবং ন্যায়বিচারের ভিত্তি; যেহেতু মানব অধিকারের প্রতি অবজ্ঞা এবং ঘৃণার ফলে মানুবের বিবেক লাঞ্ছিত বোধ করে এমন সব বর্বরোচিত ঘটনা সংঘটিত হয়েছে এবং যেহেতু এমন একটি পৃথিবীর উদ্ভবকে সাধারণ মানুষের সর্বোচ্চ কাঙ্খা রূপে ঘোষণা করা হয়েছে, যেখানে সকল মানুষ ধর্ম এবং বাক স্বাধীনতা ভোগ করবে এবং অভাব ও শংকামুক্ত জীবন যাপন করবে; যেহেতু মানুষ যাতে অত্যাচার ও উত্‍পীড়নের মুখে সর্বশেষ উপায় হিসেবে বিদ্রোহ করতে বাধ্য না হয় সেজন্য আ‌ইনের শাসন দ্বারা মানবাধিকার সংরক্ষণ করা অতি প্রয়োজনীয়; যেহেতু জাতিসমূহের মধ্যে বন্ধুত্বপূর্ণ সম্পর্ক উন্নয়নের প্রয়াস গ্রহণ করা অত্যাবশ্যক; যেহেতু সদস্য জাতিসমূহ জাতিসংঘের সনদে মৌলিক মানবাধিকার, মানব দেহের মর্যাদা ও মূল্য এবং নারী পুরুষের সমান অধিকারের প্রতি তাঁদের বিশ্বাস পুনর্ব্যক্ত করেছেন এবং বৃহত্তর স্বাধীনতার পরিমণ্ডলে সামাজিক উন্নতি এবং জীবনযাত্রার উন্নততর মান অর্জনে দৃঢ়প্রতিজ্ঞ হয়েছেন; যেহেতু সদস্য রাষ্ট্রসমূহ জাতিসংঘের সহযোগিতায় মানবাধিকার ও'
  },
  hin: {
    iso6393: 'hin',
    fixture:
      'चूंकि मानव परिवार के सभी सदस्यों के जन्मजात गौरव और समान तथा अविच्छिन्न अधिकार की स्वीकृति ही विश्व-शान्ति, न्याय और स्वतन्त्रता की बुनियाद है, चूंकि मानव अधिकारों के प्रति उपेक्षा और घृणा के फलस्वरूप ही ऐसे बर्बर कार्य हुए जिनसे मनुष्य की आत्मा पर अत्याचार किया गया, चूंकि एक ऐसी विश्व-व्यवस्था की उस स्थापना को ( जिसमें लोगों को भाषण और धर्म की आज़ादी तथा भय और अभाव से मुक्ति मिलेगी ) सर्वसाधारण के लिए सर्वोच्च आकांक्षा घोषित किया गया है, चूंकि अगर अन्याययुक्त शासन और जुल्म के विरुद्घ लोगों को विद्रोह करने के लिए—उसे ही अन्तिम उपाय समझ कर—मजबूर नहीं हो जाना है, तो कानून द्वारा नियम बनाकर मानव अधिकारों की रक्षा करना अनिवार्य है, चूंकि राष्ट्रों के बीच मैत्रीपूर्ण सम्बन्धों को बढ़ाना ज़रूरी है, चूंकि संयुक्त राष्ट्रों के सदस्य देशों की जनताओं ने बुनियादी मानव अधिकारों में, मानव व्यक्तित्व के गौरव और योग्यता में और नरनारियों के समान अधिकारों में अपने विश्वास को अधिकार-पत्र में दुहराया है और यह निश्चय किया है कि अधिक व्यापक स्वतन्त्रता के अन्तर्गत सामाजिक प्रगति एवं जीवन के बेहतर स्तर को ऊंचा'
  },
  por_BR: {
    iso6393: 'por',
    fixture:
      'Considerando que o reconhecimento da dignidade inerente a todos os membros da família humana e de seus direitos iguais e inalienáveis é o fundamento da liberdade, da justiça e da paz no mundo, Considerando que o desprezo e o desrespeito pelos direitos humanos resultaram em atos bárbaros que ultrajaram a consciência da Humanidade e que o advento de um mundo em que os todos gozem de liberdade de palavra, de crença e da liberdade de viverem a salvo do temor e da necessidade foi proclamado como a mais alta aspiração do ser humano comum, Considerando ser essencial que os direitos humanos sejam protegidos pelo império da lei, para que o ser humano não seja compelido, como último recurso, à rebelião contra a tirania e a opressão, Considerando ser essencial promover o desenvolvimento de relações amistosas entre as nações, Considerando que os povos das Nações Unidas reafirmaram, na Carta da ONU, sua fé nos direitos humanos fundamentais, na dignidade e no valor do ser humano e na igualdade de di'
  },
  ind: {
    iso6393: 'ind',
    fixture:
      'Menimbang bahwa pengakuan atas martabat alamiah dan hak-hak yang sama dan mutlak dari semua anggota keluarga manusia adalah dasar kemerdekaan, keadilan dan perdamaian di dunia, Menimbang bahwa mengabaikan dan memandang rendah hak-hak asasi manusia telah mengakibatkan perbuatan-perbuatan bengis yang menimbulkan rasa kemarahan hati nurani umat manusia, dan terbentuknya suatu dunia tempat manusia akan mengecap kenikmatan kebebasan berbicara dan beragama serta kebebasan dari ketakutan dan kekurangan telah dinyatakan sebagai cita-cita tertinggi dari rakyat biasa, Menimbang bahwa hak-hak asasi manusia perlu dilindungi oleh peraturan hukum supaya orang tidak akan terpaksa memilih pemberontakan sebagai usaha terakhir guna menentang kelaliman dan penindasan, Menimbang bahwa pembangunan hubungan persahabatan antara negara-negara perlu digalakkan, Menimbang bahwa bangsa-bangsa dari Perserikatan Bangsa-Bangsa sekali lagi telah menyatakan di dalam Piagam Perserikatan Bangsa-Bangsa kepercayaan merek'
  },
  jpn: {
    iso6393: 'jpn',
    fixture:
      '人類社会のすべての構成員の固有の尊厳と平等で譲ることのできない権利とを承認することは、世界における自由、正義及び平和の基礎であるので、 人権の無視及び軽侮が、人類の良心を踏みにじった野蛮行為をもたらし、言論及び信仰の自由が受けられ、恐怖及び欠乏のない世界の到来が、一般の人々の最高の願望として宣言されたので、 人間が専制と圧迫とに対する最後の手段として反逆に訴えることがないようにするためには、法の支配によって人権を保護することが肝要であるので、 諸国間の友好関係の発展を促進することが肝要であるので、国際連合の諸国民は、国連憲章において、基本的人権、人間の尊厳及び価値並びに男女の同権についての信念を再確認し、かつ、一層大きな自由のうちで社会的進歩と生活水準の向上とを促進することを決意したので、 加盟国は、国際連合と協力して、人権及び基本的自由の普遍的な尊重及び遵守の促進を達成することを誓約したので、 これらの権利及び自由に対する共通の理解は、この誓約を完全にするためにもっとも重要であるので、 よって、ここに、国連総会は、 社会の各個人及び各機関が、この世界人権宣言を常に念頭に置きながら、加盟国自身の人民の間にも、また、加盟国の管轄下にある地域の人民の間にも、これらの権利と自由との尊重を指導及び教育によって促進すること並びにそれらの普遍的措置によって確保することに努力するように、すべての人民とすべての国とが達成すべき共通の基準として、この人権宣言を公布する。'
  },
  fra: {
    iso6393: 'fra',
    fixture:
      'Considérant que la reconnaissance de la dignité inhérente à tous les membres de la famille humaine et de leurs droits égaux et inaliénables constitue le fondement de la liberté, de la justice et de la paix dans le monde, Considérant que la méconnaissance et le mépris des droits de l’homme ont conduit à des actes de barbarie qui révoltent la conscience de l’humanité et que l’avènement d’un monde où les êtres humains seront libres de parler et de croire, libérés de la terreur et de la misère, a été proclamé comme la plus haute aspiration de l’homme, Considérant qu’il est essentiel que les droits de l’homme soient protégés par un régime de droit pour que l’homme ne soit pas contraint, en suprême recours, à la révolte contre la tyrannie et l’oppression, Considérant qu’il est essentiel d’encourager le développement de relations amicales entre nations, Considérant que dans la Charte les peuples des Nations Unies ont proclamé à nouveau leur foi dans les droits fondamentaux de l’homme, dans la'
  },
  deu_1996: {
    iso6393: 'deu',
    fixture:
      'Da die Anerkennung der angeborenen Würde und der gleichen und unveräußerlichen Rechte aller Mitglieder der Gemeinschaft der Menschen die Grundlage von Freiheit, Gerechtigkeit und Frieden in der Welt bildet, da die Nichtanerkennung und Verachtung der Menschenrechte zu Akten der Barbarei geführt haben, die das Gewissen der Menschheit mit Empörung erfüllen, und da verkündet worden ist, dass einer Welt, in der die Menschen Rede‐ und Glaubensfreiheit und Freiheit von Furcht und Not genießen, das höchste Streben des Menschen gilt, da es notwendig ist, die Menschenrechte durch die Herrschaft des Rechtes zu schützen, damit der Mensch nicht gezwungen wird, als letztes Mittel zum Aufstand gegen Tyrannei und Unterdrückung zu greifen, da es notwendig ist, die Entwicklung freundschaftlicher Beziehungen zwischen den Nationen zu fördern, da die Völker der Vereinten Nationen in der Charta ihren Glauben an die grundlegenden Menschenrechte, an die Würde und den Wert der menschlichen Person und an die Gl'
  },
  jav_java: {
    iso6393: 'jav',
    fixture:
      '꧋ꦩꦤꦶꦩ꧀ꦧꦁꦩꦤꦮꦔꦏꦺꦴꦤ꧀ꦤꦶꦩꦫꦁꦩꦂꦠꦧꦠ꧀ꦲꦭꦩ꧀ꦩꦶꦪꦃꦱꦂꦠꦲꦏ꧀ꦲꦏ꧀ꦏꦁꦥꦝꦭꦤ꧀ꦥꦶꦤꦱ꧀ꦛꦶꦲꦶꦁꦱꦧꦼꦤ꧀ꦮꦂꦒꦤꦶꦁꦏꦸꦭꦮꦂꦒꦲꦸꦩꦠ꧀ꦩꦤꦸꦁꦱ꧈​ꦩꦸꦗꦸꦢ꧀ꦠꦏꦺꦭꦤ꧀ꦝꦼꦱ꧀ꦱꦤ꧀ꦤꦶꦁꦏꦩꦂꦢꦶꦏꦤ꧀ ​ꦏꦲꦢꦶꦭꦤ꧀ꦱꦂꦠꦧꦼꦝꦩꦺꦤ꧀ꦤꦶꦁꦢꦺꦴꦚ꧉​ ꧋ꦩꦤꦶꦩ꧀ꦧꦁꦩꦤꦮꦚꦶꦁꦏꦸꦂꦭꦤ꧀ꦔꦁꦒꦼꦥ꧀ꦫꦺꦩꦺꦃꦲꦏ꧀ꦲꦏ꧀ꦲꦸꦩꦠ꧀ꦩꦤꦸꦁꦱꦧꦶꦱꦚ꧀ꦗꦭꦂꦫꦶꦠꦤ꧀ꦢꦁꦠꦤ꧀ꦢꦸꦏ꧀ꦏꦱꦂꦭꦤ꧀ꦮꦼꦔꦶꦱ꧀ꦏꦁꦤꦸꦮꦸꦃꦲꦏꦺꦫꦱꦫꦸꦤ꧀ꦠꦶꦏ꧀ꦲꦠꦶꦤꦺꦲꦸꦩꦠ꧀ꦩꦤꦸꦁꦱ꧈​ꦭꦤ꧀ꦏꦧꦔꦸꦤ꧀ꦤꦺꦢꦺꦴꦚꦢꦢꦶꦥꦥꦤ꧀ꦤꦶꦁꦲꦸꦩꦠ꧀ꦩꦤꦸꦁꦱꦧꦶꦱꦔꦿꦱꦏ꧀ꦏꦏꦺꦭꦤ꧀ꦔꦭꦩ꧀ꦩꦶꦤꦶꦏ꧀ꦩꦠ꧀ꦠꦶꦁꦧꦺꦧꦱ꧀ꦩꦼꦝꦂꦥꦤꦼꦩꦸꦭꦤ꧀ꦧꦺꦧꦱ꧀ꦔꦿꦱꦸꦏ꧀ꦲꦒꦩꦱꦂꦠꦏꦭꦶꦱ꧀ꦱꦏꦫꦱꦮꦼꦢꦶꦭꦤ꧀ꦮꦱ꧀ꦱꦸꦩꦼꦭꦁꦱꦂꦠꦲꦸꦫꦶꦥ꧀ꦏꦕꦶꦁꦏꦿꦁꦔꦤ꧀​ ꦏꦥꦿꦠꦺꦭ꧀ꦭꦏ꧀ꦏꦏꦺꦢꦢꦶꦥꦿꦚꦠꦤ꧀ꦩꦶꦤꦁꦏꦢꦢꦶꦒꦼꦒꦪꦸꦃꦲꦤ꧀ꦭꦸꦲꦸꦂꦱꦏꦧꦺꦃꦲꦶꦁꦲꦸꦩꦠ꧀ꦩꦤꦸꦁꦱꦭꦸꦩ꧀ꦫꦃꦲꦸꦠꦮꦏꦮꦸꦭꦲꦭꦶꦠ꧀꧈ ꧋ꦩꦤꦶꦩ꧀ꦧꦁꦩꦤꦮꦲꦏ꧀ꦲꦏ꧀ꦲꦸꦩꦠ꧀ꦩꦤꦸꦁꦱꦥꦼꦂꦭꦸꦲꦤ꧀ꦠꦸꦏ꧀ꦥꦔꦪꦺꦴꦩ꧀ꦩꦤ꧀ꦏꦤ꧀ꦛꦶꦥꦿꦤꦠꦤ꧀ꦭꦤ꧀ꦠꦠꦤꦤ꧀ꦲꦁꦒꦼꦂꦲꦁꦒꦼꦂ꧈​ꦲꦩꦿꦶꦃꦱꦧꦼꦤ꧀ꦲꦸꦮꦺꦴꦁꦲꦺꦴꦫꦏꦥꦼꦏ꧀ꦱꦩꦶꦭꦶꦃꦔ꧀ꦭꦮꦤ꧀ꦩꦶꦤꦁꦏꦏꦸꦥꦶꦪꦺꦴꦏꦁꦥꦸꦁꦏꦱ꧀ꦱꦤ꧀ꦲꦁꦒꦺꦴꦤ꧀ꦤꦺꦔꦽꦏꦺꦴꦢꦪꦏꦁꦒꦺꦴꦔ꧀ꦭꦮꦤ꧀ꦩꦫꦁꦠꦶꦤ꧀ꦢꦏ꧀ꦢꦏ꧀ꦱꦶꦪꦭꦤ꧀ꦥꦚ꧀ꦗꦗꦃꦲꦤ꧀꧈​ ꧋ꦩꦤꦶꦩ꧀ꦧꦁꦩꦤꦮꦩꦼꦏꦂꦫꦶꦁꦥꦩꦼꦂꦢꦶꦥꦁꦒꦸꦭꦺꦴꦮꦼꦤ꧀ꦛꦃꦲꦶꦁꦱꦩ꧀ꦧꦸꦁꦥꦩꦶꦠꦿꦤ꧀ꦲꦶꦁꦲꦤ꧀ꦠꦫꦤꦶꦁꦥꦫꦧꦁꦱꦱꦧꦼꦤ꧀ꦤꦒꦫꦥꦼꦂꦭꦸꦭꦤ꧀ꦮꦶꦒꦠꦶꦢꦶꦉꦩ꧀ꦧꦏꦏ꧀ꦏꦏꦺ꧉ ꧋ꦩꦤꦶꦩ꧀ꦧꦁꦩꦤꦮꦥꦫꦧꦁꦱꦲꦶꦁꦥꦱꦫꦺꦏꦠ꧀ꦠꦤ꧀ꦧꦁꦱꦧꦁꦱ꧈​ꦲꦶꦁꦱꦗꦿꦺꦴꦤꦶꦁꦥꦶꦪꦒꦩ꧀ꦥꦱꦫꦺꦏꦠ꧀ꦠꦤ꧀ꦧꦁꦱꦧꦁꦱ꧈​ꦮꦸꦱ꧀ꦥꦝꦩꦿꦠꦺꦭ꧀ꦭꦏ꧀ꦏꦏꦺꦏꦤ꧀ꦛꦶꦠꦤ꧀ꦝꦼꦱ꧀ꦲꦁꦒꦺꦴꦤ꧀ꦤꦺꦔꦸꦒꦼꦩ꧀ꦩꦶꦩꦫꦁꦲꦏ꧀ꦲꦏ꧀ꦏꦁꦧꦏꦸꦲꦸꦩꦠ꧀ꦩꦤꦸꦁꦱ꧈​ꦩꦫꦁꦩꦂꦠꦧꦠ꧀ꦭꦤ꧀ꦲꦗꦶꦤꦶꦁꦥꦿꦶꦧꦢꦶꦤꦺꦲꦸꦩꦠ꧀​ ꦭꦤ꧀ꦩꦫꦁꦲꦏ꧀ꦲꦏ꧀ꦥꦿꦶꦪꦭꦤ꧀ꦮꦤꦶꦠꦏ'
  },
  jav: {
    iso6393: 'jav',
    fixture:
      'MANIMBANG manowo ngakoni marang martabat alamiah sarta hak-hak kang padha lan pinasthi ing saben warganing kulawarga umat manungsa, mujudake landhesaning kamardikan, kaadilan sarta bedhamening donya. MANIMBANG menawa nyingkur lan nganggep remeh hak-hak umat manungsa bisa njalari tandang tanduk kasar lan wengis kang nuwuhake rasa runtik atine umat manungsa, lan kabangune donya dadi papaning umat manungsa bisa ngrasakake lan ngalami nikmating bebas medhar panemu lan bebas ngrasuk agama sarta kalis saka rasa wedi lan was-sumelang sarta urip kacingkrangan, kapratelakake dadi pranyatan minangka dadi gegayuhan luhur sakabehing umat manungsa lumrah (kawula alit). MANIMBANG manawa hak-hak umat manungsa perlu antuk pangayoman kanthi pranatan lan tatanan angger-angger (undang-undang), amrih saben uwong ora kepeksa milih nglawan (mbrontak) minangka kupiyo kang pungkasan anggone ngrekodaya kanggo nglawan marang tindak daksiya lan panjajahan. MANIMBANG manawa mekaring pamerdi panggulowenthahing sam'
  },
  kor: {
    iso6393: 'kor',
    fixture:
      '모든 인류 구성원의 천부의 존엄성과 동등하고 양도할 수 없는 권리를 인정하는 것이 세계의 자유, 정의 및 평화의 기초이며, 인권에 대한 무시와 경멸이 인류의 양심을 격분시키는 만행을 초래하였으며, 인간이 언론과 신앙의 자유, 그리고 공포와 결핍으로부터의 자유를 누릴 수 있는 세계의 도래가 모든 사람들의 지고한 열망으로서 천명되어 왔으며, 인간이 폭정과 억압에 대항하는 마지막 수단으로서 반란을 일으키도록 강요받지 않으려면, 법에 의한 통치에 의하여 인권이 보호되어야 하는 것이 필수적이며, 국가간에 우호관계의 발전을 증진하는 것이 필수적이며, 국제연합의 모든 사람들은 그 헌장에서 기본적 인권, 인간의 존엄과 가치, 그리고 남녀의 동등한 권리에 대한 신념을 재확인하였으며, 보다 폭넓은 자유속에서 사회적 진보와 보다 나은 생활수준을 증진하기로 다짐하였고, 회원국들은 국제연합과 협력하여 인권과 기본적 자유의 보편적 존중과 준수를 증진할 것을 스스로 서약하였으며, 이러한 권리와 자유에 대한 공통의 이해가 이 서약의 완전한 이행을 위하여 가장 중요하므로, 이에, 국제연합총회는, 모든 개인과 사회 각 기관이 이 선언을 항상 유념하면서 학습 및 교육을 통하여 이러한 권리와 자유에 대한 존중을 증진하기 위하여 노력하며, 국내적 그리고 국제적인 점진적 조치를 통하여 회원국 국민들 자신과 그 관할 영토의 국민들 사이에서 이러한 권리와 자유가 보편적이고 효과적으로 인식되고 준수되도록 노력하도록 하기 위하여, 모든 사람과 국가가 성취하여야 할 공통의 기준으로서 이 세계인권선언을 선포한다.'
  },
  tel: {
    iso6393: 'tel',
    fixture:
      'ప్రతిపత్తిస్వత్వముల విషయమున మానవులెల్లరును జన్మతః స్వతంత్రులును సమానులును నగుదురు. వారు వివేదనాంతఃకరణ సంపన్నులగుటచే పరస్పరము భ్రాతృభావముతో వర్తింపవలయును.'
  },
  vie: {
    iso6393: 'vie',
    fixture:
      'Với nhận thức rằng: Việc thừa nhận nhân phẩm vốn có, các quyền bình đẳng và không thể tách rời của mọi thành viên trong gia đình nhân loại là cơ sở cho tự do, công bằng và hoà bình trên thế giới, Sự xâm phạm và coi thường nhân quyền đã dẫn đến những hành động tàn bạo xâm phạm tới lương tâm của nhân loại, và việc xây dựng một thế giới trong đó con người được tự do ngôn luận và tín ngưỡng, không còn phải chịu nỗi sợ hãi và cùng cực được coi là nguyện vọng cao cả nhất của loài người, Nhân quyền phải được pháp luật bảo vệ để mỗi người không buộc phải nổi loạn như là biện pháp cuối cùng để chống lại chế độ cường quyền và áp bức, Cần phải khuyến khích việc phát triển quan hệ bằng hữu giữa các dân tộc, Nhân dân các nước thành viên Liên Hợp Quốc trong bản Hiến chương đã một lần nữa khẳng định niềm tin của mình vào những quyền cơ bản của con người, và'
  },
  mar: {
    iso6393: 'mar',
    fixture:
      'ज्या अर्थी मानव कुटुँवातील सर्व व्यक्तींची स्वाभाविक प्रतिष्ठा व त्यांचे समान व अहरणीय अधिकार यांना मान्यता देणे हा जगांत स्वातंत्र्य, न्याय व शांतता यांच्या प्रस्थापनेवा पाया होय, ज्या अर्थी, मानवी अधिकारांची अबहेलना व अप्रतिष्ठा झाल्याने अमानुष कृत्ये घडून आली आणि त्यायोगे मानवजातीच्या सद्सद्विवेकबुद्धीवर भयंकर आघात झाला आहे, आणि म्हणून मानवांना भाषण-स्वातंत्र्याचा व श्रद्धास्वातंत्र्याचा उपभोग घेता येईल व भीतवी गरज यांपासून त्यांची मुक्तता होईल अशा जगाची उभारणी करणे ही सामान्य लोकांची सर्वोच्च आकांक्षा म्हणून घोषित करण्यात आली आहे, ज्या अर्थी, जुलूम व दडपशाही यांविरूद्ध अखेरचा उपाय म्हणून मानवाला बंड करणे भाग पडू नये यासाठी मानवी अधिकांराचे संरक्षण कायद्याने करणे अत्यावश्यक आहे, ज्या अर्थी, राष्ट्र राष्ट्रांमध्ये मित्रस्वाचे संबंध बृद्धिंगत करण्याच्या कार्यास चालना देणे अत्यावश्यक आहे, ज्या अर्थी, संयुक्त राष्ट्रसंघटनेतील सदस्य-राष्ट्रांनी सनदेत मूलभूत मानवी अधिकार मानवाची प्रतिष्ठा व महत्व स्त्रीपुरुषांचे समान अधिकार यांवरील आपवी श्रद्धा निश्यपूर्वक पुन्हा व्यक्त केली आहे आणि अधिका'
  },
  ita: {
    iso6393: 'ita',
    fixture:
      "Considerato che il riconoscimento della dignità inerente a tutti i membri della famiglia umana e dei loro diritti, uguali ed inalienabili, costituisce il fondamento della libertà, della giustizia e della pace nel mondo; Considerato che il disconoscimento e il disprezzo dei diritti umani hanno portato ad atti di barbarie che offendono la coscienza dell'umanità, e che l'avvento di un mondo in cui gli esseri umani godano della libertà di parola e di credo e della libertà dal timore e dal bisogno è stato proclamato come la più alta aspirazione dell'uomo; Considerato che è indispensabile che i diritti umani siano protetti da norme giuridiche, se si vuole evitare che l'uomo sia costretto a ricorrere, come ultima istanza, alla ribellione contro la tirannia e l'oppressione; Considerato che è indispensabile promuovere lo sviluppo di rapporti amichevoli tra le Nazioni; Considerato che i popoli delle Nazioni Unite hanno riaffermato nello Statuto la loro fede nei diritti umani fondamentali, nella "
  },
  tam: {
    iso6393: 'tam',
    fixture:
      'மனிதக் குடும்பத்தினைச் சேர்ந்த யாவரதும் உள்ளார்ந்த மரியாதையையும், அவர்கள் யாவரதும் சமமான, மாற்றத்திற்குட்படுத்த முடியாத உரிமைகளையும் அங்கீகரித்தலே உலகத்தில் சுதந்திரம், நீதி, அமைதி என்பவற்றுக்கு அடிப்படையாகவுள்ளதாதலாலும், மனித உரிமைகளை அவமதித்தலும் இகழ்தலும், மனிதகுலத்தின் மனசாட்சியை சீற்றத்திற்குள்ளாக்கியுள்ள காட்டுமிராண்டித்தனமான செயல்களுக்கு இடமளித்துள்ளதாதலாலும், பேச்சுச் சுதந்திரம், நம்பிக்கைச் சுதந்திரம், அச்சத்திலிருந்தும் வறுமையிலிருந்தும் விடுதலை ஆகியனவற்றை மனிதன் முழுமையாக அனுபவிக்கத்தக்க ஒரு உலகின் வருகையே சாதாரண மக்களின் மிகவுயர்ந்த குறிக்கோளாக எடுத்துச் சாற்றப்பட்டுள்ளதாதலாலும், கொடுங்கோன்மைக்கும், அடக்குமுறைக்கும் எதிரான இறுதித் தீர்வாக எதிரெழுச்சி செய்வதற்கு மனிதன் கட்டாயப்படுத்தப்படாமலிருக்க வேண்டுமெனில் சட்டத்தின் ஆட்சியால் மனிதவுரிமைகள் பாதுகாக்கப்படுவது இன்றியமையாததாக உள்ளதாதலாலும், நாடுகளிடையேயான நட்புறவை மேம்படுத்துவது இன்றியமையாததாக உள்ளதாதலாலும், ஐக்கிய நாடுகள் சபையிற் கூடிய எல்லா மக்களும், பட்டயத்தில் அடிப்படை மனித உரிமைகள் பற்றிய, ஒவ்வொரு மனிதப் பிறவியினதும் சு'
  },
  tur: {
    iso6393: 'tur',
    fixture:
      'İnsanlık ailesinin bütün üyelerinde bulunan haysiyetin ve bunların eşit ve devir kabul etmez haklarının tanınması hususunun, hürriyetin, adaletin ve dünya barışının temeli olmasına, İnsan haklarının tanınmaması ve hor görülmesinin insanlık vicdanını isyana sevkeden vahşiliklere sebep olmuş bulunmasına, dehşetten ve yoksulluktan kurtulmuş insanların, içinde söz ve inanma hürriyetlerine sahip olacakları bir dünyanın kurulması en yüksek amaçları oralak ilan edilmiş bulunmasına, İnsanin zulüm ve baskıya karşı son çare olarak ayaklanmaya mecbur kalmaması için insan haklarının bir hukuk rejimi ile korunmasının esaslı bir zaruret olmasına, Uluslararasında dostça ilişkiler geliştirilmesini teşvik etmenin esaslı bir zaruret olmasına, Birleşmiş Milletler halklarının, Antlaşmada, insanın ana haklarına, insan şahsının haysiyet ve değerine, erkek ve kadınların eşitliğine olan imanlarını bir kere daha ilan etmiş olmalarına ve sosyal ilerlemeyi kolaylaştırmaya, daha geniş bir hürriyet içerisinde daha'
  },
  urd: {
    iso6393: 'urd',
    fixture:
      'چونکہ ہر انسان کی ذاتی عزت اور حرمت اور انسانوں کے مساوی اور ناقابلِ انتقال حقوق کو تسلیم کرنا دنیا میں آزادی، انصاف اور امن کی بنیاد ہے، چونکہ انسانی حقوق سے لاپروائی اور ان کی بے حرمتی اکثر ایسے وحشیانہ افعال کی شکل میں ظاہر ہوئی ہے جن سے انسانیت کے ضمیر کو سخت صدمے پہنچے ہیں اور عام انسانوں کی بلند ترین آرزو یہ رہی ہے کہ ایسی دنیا وجود میں آئے جس میں تمام انسانوں کو اپنی بات کہنے اور اپنے عقیدے پر قائم رہنے کی آزادی حاصل ہو اور خوف اور احتیاج سے محفوظ رہیں، چونکہ یہ بہت ضروری ہے کہ انسانی حقوق کو قانون کی عملداری کے ذریعے محفوظ رکھا جائے۔ اگر ہم یہ نہیں چاہتے کہ انسان عاجز آ کر جبر اور استبداد کے خلاف بغاوت کرنے پر مجبور ہوں، چونکہ یہ ضروری ہے کہ قوموں کے درمیان دوستانہ تعلقات کو بڑھایا جائے، چونکہ اقوامِ متحدہ کی ممبر قوموں نے اپنے چارٹر میں بنیادی انسانی حقوق، انسانی شخصیت کی حرمت اور قدر اور مردوں اور عورتوں کے مساوی حقوق کے بارے میں اپنے عقیدے کی دوبارہ تصدیق کر دی ہے اور وسیع تر آزادی کی فضا میں معاشرتی ترقی کو تقویت دینے اور معیارِ زندگی کو بلند کرنے کا ارادہ کر لیا ہے، چونکہ '
  },
  guj: {
    iso6393: 'guj',
    fixture:
      'કેમ કે માનવકુટુંબના દરેક સભ્યની પરંપરા-પ્રાપ્ત પ્રતિષ્ઠાને અને સમાન અને અસંકામ્ય અધિકારોને માન્યતા આપવી એ જગતની સ્વતંત્રતા, ન્યાય અને શાંતિનો પાયા છે, કેમ કે માનવ અધિકારોની ઉપેક્ષા અને અપમાન કરવાથી એવાં જંગલી કત્યો પરિણમ્યાં છે કે જેણે માનવજાતના અંતઃકરણમાં બળવો જગવ્યો છે અને સામાન્ય લોકોની ઊંચામાં ઊંચી મહત્ત્વાકાંક્ષા તરીકે એવી દુનિયાના આગમનની જાહેરાત કરવામાં આવી છે, જેમાં માનવો વાણી અને વિચારની સ્વતંત્રતા ભોગવશે અને ભય તથા અછતમાંથી મુકિત મેળવશે, કેમ કે જો માણસને આખરી ઉપાય તરીકે જુલમ અને અત્યાચાર સામે બળવો પોકારવાનો આશ્રય લેવાનું દબાણ કરાવવું ન હોય તો કાયદાની સત્તા દ્વારા માનવ અધિકારોને રક્ષણ આપવું જોઇએ, કેમ કે રાષ્ટ્રો વચ્ચે મૈત્રીસંબંધોનો વિકાસ બઢાવવાનું જરૂરી છે, કેમ કે સંયુકત રાષ્ટ્રોના લોકોએ ખતપત્રમાં મૂળભૂત માનવ અધિકારોમાં માનવીની પ્રતિષ્ઠા અને મૂલ્યમાં અને સ્રીપુરુષોના સમાન અધિકારોમાં તેમની શ્રદ્ધા પુનઃ સ્થાપિત કરી છે અને વિશાળતર સ્વાતંત્ર્યમાં સામાજિક પ્રગતિ અને ઉચ્ચ જીવનધોરણ બઢાવવાનો નિશ્ચય કર્યો છે, કેમ કે સભ્ય રાજ્યોએ સંયુકત રાષ્ટ્રોના સહકારમાં માનવ અધિકારોના અને મૂળભૂત સ્વત'
  },
  pol: {
    iso6393: 'pol',
    fixture:
      'ZWAŻYWSZY, że uznanie przyrodzonej godności oraz równych i niezbywalnych praw wszystkich członków wspólnoty ludzkiej jest podstawą wolności, sprawiedliwości i pokoju świata, ZWAŻYWSZY, że nieposzanowanie i nieprzestrzeganie praw człowieka doprowadziło do aktów barbarzyństwa, które wstrząsnęły sumieniem ludzkości, i że ogłoszono uroczyście jako najwznioślejszy cel ludzkości dążenie do zbudowania takiego świata, w którym ludzie korzystać będą z wolności słowa i przekonań oraz z wolności od strachu i nędzy, ZWAŻYWSZY, że konieczne jest zawarowanie praw człowieka przepisami prawa, aby nie musiał - doprowadzony do ostateczności - uciekać się do buntu przeciw tyranii i uciskowi, ZWAŻYWSZY, że konieczne jest popieranie rozwoju przyjaznych stosunków między narodami, ZWAŻYWSZY, że Narody Zjednoczone przywróciły swą wiarę w podstawowe prawa człowieka, godność i wartość jednostki oraz w równouprawnienie mężczyzn i kobiet, oraz wyraziły swe zdecydowanie popierania postępu społecznego i poprawy war'
  },
  ukr: {
    iso6393: 'ukr',
    fixture:
      "Беручи до уваги, що визнання гідності, яка властива всім членам людської сім'ї, і рівних та невід'ємних їх прав є основою свободі, справедливості та загального миру; і беручи до уваги, що зневажання і нехтування правами людини призвели до варварських актів, які обурюють совість людства, і що створення такого світу, в якому люди будуть мати свободу слова і переконань і будуть вільні від страху і нужди, проголошено як високе прагнення людей; і беручи до уваги, що необхідно, щоб права людини охоронялися силою закону з метою забезпечення того, щоб людина не була змушена вдаватися як до останнього засобу до повстання проти тиранії і гноблення; і беручи до уваги, що необхідно сприяти розвиткові дружніх відносин між народами; і беручи до уваги, що народи Об'єднаних Націй підтвердили в Статуті свою віру в основні права людини, в гідність і цінність людської особи і в рівноправність чоловіків і жінок та вирішили сприяти соціальному прогресові і поліпшенню умов життя при більшій свободі; і беруч"
  },
  kan: {
    iso6393: 'kan',
    fixture:
      'ಮಾನವ ಕುಟುಂಬದ ಸಮಸ್ತ ಸದಸ್ಯರ ಸಹಜ ಗೌರವವನ್ನೂ ಸಮಾನವೂ ಅನನ್ಯಹಾರ್ಯವೂ ಆದ ಹಕ್ಕುಗಳನ್ನು ಅಂಗೀಕರಿಸುವುದು ಪ್ರಪಂಚದಲ್ಲಿ ಸ್ವಾತಂತ್ರ್ಯದ ಧರ್ಮಶಾಂತತೆಗಳ ತಳಹದಿಯಾಗಿರುವುದರಿಂದಲೂ. ಮಾನವ ಹಕ್ಕುಗಳಗೆ ತೋರಿಸಲ್ಪಟ್ವ ಉಪೇಕ್ಷೆ ತಿರಸ್ಕಾರಗಳು, ಮಾನವನ ಅಂತಃಕರಣವನ್ನು ದಾರುಣಗೊಳಿಸಿದಂತಹ ಕ್ರೂರಕೃತ್ಯಗಳಾಗಿ ಪರಿಣಮಿಸಿರುವುದರಿಂದಲೂ, ಮತ್ತು ಯಾವ ಪ್ರಪಂಚದಲ್ಲಿ ಮನುಷ್ಯ ಜೀವಿಗಳು ವಾಕ್‌ಸ್ವಾತಂತ್ರ್ಯ ವಿಶ್ವಾಸ ಸ್ವಾತಂತ್ರ್ಯಗಳನ್ನು ಅನುಭವಿಸುವವೋ ಯಾವ ಪ್ರಪಂಚದಲ್ಲಿ ಅಂಜಿಕೆ ಮತ್ತು ಅಭಾವಗಳಿಂದ ಮುಕ್ತವಾಗಿರುವುದು ಸಾಮಾನ್ಯ ಜನತೆಯ ಮಹದಾಶಯವೆಂಬುದಾಗಿ ಸಾರಲ್ಪಟ್ಟಿರುವುದೋ ಅಂಥಾ ಪ್ರಪಂಚದಾಗಮನವಾಗಿರುವುದರಿಂದಲೂ. ಮಾನವ ಹಕ್ಕುಗಳು ಕಾನೂನಿನ ಕಟ್ಟಳೆಯಿಂದ ಸಂರಕ್ಷಿಸಲ್ಪಡಬೇಕಾದರೆ ಮನುಷ್ಯನು ಅವಲಂಬನೆ ಹೊಂದಲು ಒತ್ತಾಯಪಡಿಸಲ್ಪಡದಿದ್ದರೆ, ಕೊನೆಯ ಉಪಾಯವಾಗಿ, ದುಷ್ಪ್ರಭುತ್ವ ಮತ್ತು ಕ್ರೂರತನಗಳನ್ನು ವಿರೋಧಿಸಿ ದಂಗೆಮಾಡುವುದು ಅತ್ಯಗತ್ಯವಾಗಿರುವುದರಿಂದಲೂ. ಜನಾಂಗಗಳಲ್ಲಿ ಸ್ನೇಹಸಂಬಂಧಗಳ ಬೆಳವಣಿಗೆಯನ್ನು ಅಭಿವೃದ್ಧಿಗೊಳಿಸುವುದು ಅಗತ್ಯವಾಗಿರುವುದರಿಂದಲೂ. ಯುಕ್ತ ರಾಷ್ಟ್ರಗಳ ಪ್ರಜೆಗಳು ಶಾಸನದಲ್ಲಿ ಮಾನವರ ಮೂಲಾಧಿಕಾರಗಳಲ್ಲಿರುವ ತಮ್ಮ ವಿಶ್ವಾಸವನ್ನೂ ಮನುಷ್ಯ ಜೀವಿಯ ಯೋಗ್ಯತೆ ಮತ್ತು ಗಾಂಭೀರ್ಯಗಳಲ್ಲಿರುವ ತಮ್ಮ ವಿಶ್ವಾಸವನ್ನೂ ಮತ್ತು ಸ್ತ್ರೀಪುರುಷರ ಸಮಾನ ಹಕ್ಕುಗಳಲ್ಲಿರುವ ತಮ್ಮ ವಿಶ್ವಾಸವನ್ನೂ ಪುನಃ ದೃಢೀಕರಿಸುವುದರಿಂದಲೂ, ಸಾಮಾ'
  },
  mai: {
    iso6393: 'mai',
    fixture:
      'जेँ कि मानव परिवारक सकल सदस्यक जन्मजात गरिमा आओर समान एवं अविच्छेद्य अधिकारकेँ स्वीकृति देब स्वतन्त्रता, न्याय आʼ विश्वशान्तिक मूलाधार थिक, जेँ कि मानवाधिकारक अवहेलना आʼ अवमाननाक परिणाम होइछ एहन नृशंस आचरण जाहिसँ मानवक अन्तःकरण मर्माहत होइत अछि आओर अवरुद्ध होइत अछि एक एहन विश्वक अवतरण जाहिमे अभिव्यक्ति आʼ विश्वासक स्वतन्त्रता तथा भय आʼ अकिंचनतासँ मुक्ति जनसामान्यक सर्वोच्च आकांक्षा घोषित हो; जेँ कि विधिसम्मत शासन द्वारा मानवाधिकारक रक्षा एहि हेतु परमावश्यक अछि जे केओ व्यक्ति अत्याचार आʼ दमनसँ बँचबाक कोनो आन उपाय नहि पाबि, शासनक विरुद्ध बागी नहि भए जाए; जेँ कि राष्ट्रसभक बीच मैत्रीपूर्ण सम्बन्ध बढ़ाएब परमावश्यक अछि; जेँ कि राष्ट्रसंघक लोक अपन चार्टर मध्य मौलिक मानवाधिकारमे, मानवक गरिमा आʼ मूल्यमे तथा स्त्री आʼ पुरुषक बीच समान अधिकारमे अपन निष्ठा पुनः परिपुष्ट कएलक अछि आओर व्यापक स्वतन्त्रताक संग सामाजिक प्रगति आʼ जीवन स्तरक समुन्नयन हेतु कृत संकल्पित अछि; जेँ कि सदस्य राष्ट्रसभ राष्ट्रसंघक सहयोगसँ मानवाधिकार आʼ मौलिक स्वतन्त्रताक सार्वभौम आदर तथा अनुपालन करबाक हेतु प्रतिबद्ध अछि; जेँ कि'
  },
  mal: {
    iso6393: 'mal',
    fixture:
      'മനുഷ്യ സമുദായത്തിന്റെ ജന്മസിദ്ധമായ അന്തസ്സും സമാവകാശവും ലോകത്തില്‍ സ്വാതന്ത്ര്യം, നീതി, സമാധാനം എന്നിവയുടെ സ്ഥാപനത്തിന്നു അടിസ്ഥാനമായിരിക്കുന്നതിനാലും മനുഷ്യാവകാശങ്ങളെ വകവെക്കാത്തതുകൊണ്ടു മനം മടുപ്പിക്കുന്ന ക്രൂര സംഭവങ്ങളുണ്ടാകുന്നതിനാലും സര്‍വ്വതോന്മുഖമായ സ്വാതന്ത്ര്യവും സമൃദ്ധിയും മനുഷ്യനു അനുഭവിക്കാവുന്ന ഒരു പുതു ലോകത്തിന്റെ സ്ഥാപനമാണ്‌ പൊതുജനങ്ങളുടെ ആഗ്രഹം എന്ന് പ്രഖ്യാപിക്കപ്പെട്ടിരിക്കുന്നതിനാലും ഹിംസാമാര്‍ഗ്ഗം സ്വീകരിക്കാതിരിക്കണമെങ്കില്‍ മനുഷ്യാവകാശങ്ങളെ നിയമാനുസൃതമായി വകവെച്ചു കൊടുക്കേണ്ടതാണെന്നുള്ളതിനാലും രാഷ്ട്രങ്ങള്‍ തമ്മില്‍ സൌഹൃദം പുലര്‍ത്തേണ്ടതാണെന്നുള്ളതിനാലും ഐക്യരാഷ്ട്ര ജനത അവരുടെ കരാറില്‍ സ്ത്രീപുരുഷ സമത്വത്തെക്കുറിച്ചും മനുഷ്യരുടെ മൌലികാവകാശത്തെക്കുറിച്ചും ജീവിതരീതി നന്നാക്കുന്നതിനെക്കുറിച്ചും ഒന്നുകൂടി ഊന്നിപ്പറഞ്ഞിരിക്കുന്നതിനാലും മനുഷ്യാവകാശങ്ങളേയും മൌലിക സ്വാതന്ത്ര്യത്തേയും അന്യോന്യം ബഹുമാനിച്ചുകൊള്ളാമെന്ന് ഐക്യരാഷ്ട്ര സമിതിയിലെ അംഗങ്ങള്‍ വാഗ്ദാനം ചെയ്തിരിക്കുന്നതിനാലും ഈ അവകാശങ്ങളേയും സ്വാതന്ത്ര്യബോധത്തേയും കുറിച്ചു പൊതുവായി അന്യോന്യം മനസ്സിലാക്കുന്നത്‌ മേല്‍പ്'
  },
  pes_1: {
    iso6393: 'pes',
    fixture:
      'از آنجا که شناسائی حیثیت ذاتی کلیهٔ اعضای خانواده بشری و حقوق یکسان و انتقال ناپذیر آنان اساس آزادی و عدالت و صلح را در جهان تشکیل میدهد، از آنجا که عدم شناسائی و تحقیر حقوق بشر منتهی به اعمال وحشیانه‌ای گردیده است که روح بشریت را بعصیان واداشته و ظهور دنیائی که در آن افراد بشر در بیان و عقیده آزاد و از ترس و فقر فارغ باشند بعنوان بالاترین آمال بشر اعلام شده است، از آنجا که اساساً حقوق انسانی را باید با اجرای قانون حمایت کرد تا بشر بعنوان آخرین علاج بقیام بر ضد ظلم و فشار مجبور نگردد، از آنجا که اساساً لازم است توسعه روابط دوستانه بین ملل را مورد تشویق قرار داد، از آنجا که مردم ملل متحد ایمان خود را بحقوق اساسی بشر و مقام و ارزش فرد انسانی و تساوی حقوق مرد و زن مجدداً در منشور اعلام کرده‌اند و تصمیم راسخ گرفته‌اند که به پیشرفت اجتماعی کمک کنند و در محیطی آزادتر وضع زندگی بهتری بوجود آورند، از آنجا که دول عضو متعهد شده‌اند که احترام جهانی و رعایت واقعی حقوق بشر و آزادی‌های اساسی را با همکاری سازمان ملل متحد تأمین کنند، از آنجا که حسن تفاهم مشترکی نسبت باین حقوق و آزادیها برای اجرای کام'
  },
  mya: {
    iso6393: 'mya',
    fixture:
      'လူခပ်သိမ်း၏ မျိုးရိုးဂုဏ်သိက္ခာနှင့်တကွ လူတိုင်းအညီအမျှခံစားခွင့်ရှိသည့် အခွင့်အရေးများကို အသိအမှတ်ပြုခြင်းသည် လူခပ်သိမ်း၏လွတ်လပ်မှု၊ တရားမျှတမှု၊ ငြိမ်းချမ်းမှုတို့၏ အခြေခံအုတ်မြစ်ဖြစ်သောကြောင့်လည်းကောင်း၊ လူ့အခွင့်ရေးများကို အရေးမထား မထီလေးစားပြုခြင်းသည် လူခပ်သိမ်း၏ အကျင့်သိက္ခာကို ချိုးဖောက် ဖျက်ဆီးတတ်သည့် ရက်စက်ကြမ်းကြုတ်သော အပြုအမှုများကို ဖြစ်ပေါ်စေခဲ့သောကြောင့်လည်းကောင်း၊ လွတ်လပ်စွာ ဖွင့်ဟပြောဆိုနိုင်မှု လွတ်လပ်စွာ သက်ဝင် ယုံကြည်နိုင်မှု၊ ကြောက်ရွံ့ခြင်း၊ ချို့ငဲ့ခြင်းတို့မှ ကင်းလွတ်စွာ အသက်မွေးနိုင်မှုတို့ကို ခံစားရယူနိုင်စေမည့် လောကတစ်ခု ပေါ်ပေါက်လာရန်အရေးကို လူခပ်သိမ်းတို့က မိမိတို့၏ အထက်သန်ဆုံးသော လိုလားချက်ဆန္ဒကြီးအဖြစ်ဖြင့် ကြွေးကြော်ကြေညာပြီး ဖြစ်သောကြောင့် လည်းကောင်း၊ လူခပ်သိမ်းတို့သည်၊ တရားလက်လွတ် နှိပ်စက်ကလူပြုမှု၊ အုပ်စိုးမှုနှင့် ဖိစီး ညှဉ်းပန်းမှု တို့ကို နောက်ဆုံး မလွှဲသာ မရှောင်သာ လက်နက် စွဲကိုင်ကာ တော်လှန်ခြင်း၊ ပုန်ကန်ခြင်းမပြုစေရန်၊ လူအခွင့်ရေး များကိုဥပဒေဖြင့် ထိန်းသိမ်းကာကွယ် ပေးရမည်ဖြစ်သောကြောင့် လည်းကောင်း၊ နိုင်ငံ အချင်းချင်း ချစ်ခင်ရင်းနှီးစွာ ဆက်ဆံရေးကို'
  },
  swh: {
    iso6393: 'swh',
    fixture:
      'Kwa kuwa kukiri heshima ya asili na haki sawa kwa binadamu wote ndio msingi wa uhuru, haki na amani duniani, Kwa kuwa kutojali na kudharau haki za binadamu kumeletea vitendo vya kishenzi ambavyo vimeharibu dhamiri ya binadamu na kwa sababu taarifa ya ulimwengu ambayo itawafanya binadamu wafurahie uhuru wao wa kusema, kusadiki na wa kutoogopa cho chote imekwisha kutangazwa kwamba ndio hamu kuu ya watu wote, Kwa kuwa ni lazima, ili mtu asishurutizwe kuomba msaada kutokana na maasi ya kupinga dhuluma na uonevu, kwamba haki za binadamu ziwe chini ya ulinzi wa sheria, Kwa kuwa ni lazima kabisa kuendeleza uhusiano wa kirafiki kati ya mataifa, Kwa kuwa watu wa Umoja wa Mataifa wamethibitisha tena katika Mkataba wao imani yao katika haki za asili, heshima na thamani ya binadamu na katika usawa wa haki kwa wanaume na wanawake, na kwa sababu wamekata shauri la kuendeleza mambo ya starehe na hali bora za maisha ya watu kwa kuwa na uhuru zaidi, Kwa kuwa Nchi zilizo Wanachama zimeahidi, kwa kushiri'
  },
  sun: {
    iso6393: 'sun',
    fixture:
      'Dumasar ku ayana timbangan yen pangakuan kana ayana martabat alamiah katut hak-hak anu sarua ti sakumna anggota kulawarga manusa nu dasarna kamerdikaan, kaadilan jeung perdamaian di dunya. Ku ayana timbangan yen ngalelewodehkeun katut nganggap enteng kana hak-hak manusa teh geus nyiptakeun polah - polah bengis anu nimbulkeun kaceuceub kana nurani manusa tur ngawangun hiji dunya tempat manusa ngasaan nikmatna kabebasan nyarita jeung ngagem agama sarta bebas tina kasieun jeung katuna, geus ditembrakkeun salaku cita-cita luhung ti rahayat biasa. Ku ayana timbangan yen hak-hak manusa teh perlu ditangtayungan ku aturan hukum sangkan ulah milih cara anu kapaksa dina ngalawan nu lalim jeung anu resep ngajajah. Ku ayana timbangan yen dina ngabina hubungan duduluran di antara nagara-nagara perlu dironjatkeun. Ku ayana timbangan yen bangsa-bangsa ti Perserikatan Bangsa-Bangsa dina Piagem Perserikatan Bangsa-Bangsa geus ngeceskeun deui ayana kapercayaan kana hak-hak dasar manusa katut hak-hak anu'
  },
  ron_2006: {
    iso6393: 'ron',
    fixture:
      'Considerând că recunoașterea demnității inerente tuturor membrilor familiei umane și a drepturilor lor egale și inalienabile constituie fundamentul libertății, dreptății și păcii în lume, Considerând că ignorarea și disprețuirea drepturilor omului au dus la acte de barbarie care revoltă conștiința omenirii și că făurirea unei lumi în care ființele umane se vor bucura de libertatea cuvântului și a convingerilor și vor fi eliberate de teamă și mizerie a fost proclamată drept cea mai înaltă aspirație a oamenilor, Considerând că este esențial ca drepturile omului să fie ocrotite de autoritatea legii pentru ca omul să nu fie silit să recurgă, ca soluție extremă, la revoltă împotriva tiraniei și asupririi, Considerând că este esențial a se încuraja dezvoltarea relațiilor prietenești între națiuni, Considerând că în Cartă popoarele Organizației Națiunilor Unite au proclamat din nou credința lor în drepturile fundamentale ale omului, în demnitatea și în valoarea persoanei umane, drepturi egale'
  },
  pan: {
    iso6393: 'pan',
    fixture:
      'ਜਦ ਕਿ ਮਨੁੱਖੀ ਪਰਿਵਾਰ ਦੇ ਸਾਰੇ ਮੈਂਬਰਾਂ ਦੀ ਧੁਰ ਅੰਦਰਲੀ ਅੰਤਰੀਵ ਸ਼ਾਨ ਅਤੇ ਬਰਾਬਰੀ ਤੇ ਨਾ ਟਾਲੇ ਜਾ ਸਕਣ ਵਾਲੇ ਅਧਿਕਾਰ ਸੰਸਾਰ ਵਿਚ ਆਜ਼ਾਦੀ, ਇਨਸਾਫ ਅਤੇ ਅਮਨ ਦੀ ਨੀਂਹ ਹਨ । ਜਦ ਕਿ ਮਨੁੱਖੀ ਅਧਿਕਾਰਾਂ ਪ੍ਰਤੀ ਨਿਰਾਦਰ ਅਤੇ ਨਫ਼ਰਤ ਦਾ ਸਿੱਟਾ ਉਜੱਡ ਕਿਸਮ ਦੀਆਂ ਕਾਰਵਾਈਆਂ ਨਿਕਲਿਆ ਹੈ ਜਿਸ ਨਾਲ ਮਾਨਵਤਾ ਦੀ ਜ਼ਮੀਰ ਨੂੰ ਸਦਮਾ ਪੁਜਾ ਹੈ । ਅਤੇ ਇਹ ਅਜਿਹੇ ਸੰਸਾਰ ਦੇ ਆਗਮਨ ਦੀ ਤਾਂਘ ਤੇ ਰੀਝ ਆਮ ਲੋਕਾਂ ਦਾ ਐਲਾਨ ਹੈ ਜਿਸ ਵਿਚ ਸਾਰਾ ਇਨਸਾਨੀ ਭਾਈਚਾਰਾ ਬੋਲਣ ਦੀ ਆਜ਼ਾਦੀ, ਵਿਸ਼ਵਾਸ ਦੀ ਆਜ਼ਾਦੀ ਅਤੇ ਡਰ ਤੇ ਗਰੀਬੀ ਤੋਂ ਆਜ਼ਾਦੀ ਮਾਣ ਸਕੇ । ਜਦਕਿ ਇਸ ਤੋਂ ਪਹਿਲਾਂ ਕਿ ਮਨੁੱਖ ਬੇਬਸ ਹੋ ਕੇ ਆਖਰੀ ਚਾਰੇ ਵਜੋਂ ਜ਼ੁਲਮ ਤੇ ਦਮਨ ਦੇ ਵਿਰੁਧ ਬਗਾਵਤ ਕਰਨ ਉਤੇ ਉੱਤਰ ਆਏ, ਇਹ ਜ਼ਰੂਰੀ ਹੈ ਕਿ ਮਨੁੱਖੀ ਅਧਿਕਾਰਾਂ ਦੀ ਰਾਖੀ ਕਾਨੂੰਨ ਰਾਹੀਂ ਕੀਤੀ ਜਾਏ । ਜਦਕਿ ਇਹ ਜ਼ਰੂਰੀ ਹੈ ਕਿ ਮੁਲਕਾਂ ਦਰਮਿਆਨ ਸੰਬੰਧਾਂ ਦੇ ਵਿਕਾਸ ਨੂੰ ਉਤਸ਼ਾਹ ਮਿਲੇ । ਜਦ ਕਿ ਸੰਯੁਕਤ ਰਾਸ਼ਟਰ ਦੇ ਦੇਸ਼ਾਂ ਨੇ ਆਪਣੇ ਚਾਰਟਰ ਵਿਚ ਮਨੁੱਖ ਦੇ ਬੁਨਿਆਦੀ ਅਧਿਕਾਰਾਂ, ਮਨੁੱਖ ਦੀ ਸ਼ਾਨੋਸ਼ੌਕਤ ਅਤੇ ਮਰਦਾਂ ਤੇ ਔਰਤਾਂ ਦੇ ਅਧਿਕਾਰਾਂ ਦੀ ਬਰਾਬਰੀ ਵਿਚ ਆਪਣਾ ਪੁਨਰਵਿਸ਼ਵਾਸ ਪ੍ਰਗਟ ਕੀਤਾ ਹੈ ਅਤੇ ਪ੍ਰਣ ਕੀਤਾ ਹੈ ਕਿ ਵਿਸ਼ਾਲ ਆਜ਼ਾਦੀ ਦੇ ਪ੍ਰਸੰਗ ਵਿਚ ਚੰਗੇਰੀ ਜਿ਼ੰਦਗੀ ਅਤੇ ਸਮਾਜਕ ਤਰੱਕੀ ਨੂੰ ਉਤਸ਼ਾਹਤ ਕੀਤਾ ਜਾਏਗਾ । ਜਦ ਕਿ ਮੈਂਬਰ ਮੁਲਕਾਂ ਨੇ ਸੰਯੁਕਤ ਰਾਸ਼ਟਰ ਦੇ ਸਹਿਯੋਗ ਨਾਲ ਇਹ ਪ੍ਰਣ ਕੀਤਾ ਹੈ ਕਿ ਉਹ ਮ'
  },
  bho: {
    iso6393: 'bho',
    fixture:
      'सबहिं के ओकर उचित सम्मान आओर मानव परिवार के सभे आदिमी के बराबरी के हक ही विश्व समुदाय के अजादी, न्याय आओर शांति के बुनियाद हवे। मानवाधिकार के उल्लंघन हरदम अमानवीय काज के कारणो होखेला जा के चलते मानवता के अंत:करण दु:खी होखेला। एक आम आदिमी के सबसे बड़ा इच्छा इहे होखेला कि इ दुनिया में ओके भाषण और विचार के आजादी मिले साथ हि डर आओर इच्छा से हो मुक्ति मिले। यदि केहु तानाशाही चाहे दमन के खिलाफ अंतिम हथियार के रूप में बगावत करे खातिर मजबूर ना होए, त ओकरा खातिर कानून के मार्फत ओकर मानवाधिकार के बचावे के इंतजाम होबे के चाही। इहो जरूरी हवे कि राष्ट्र सब के बीच दोस्ती बढ़ाएल जाए। संयुक्त राष्ट्र के लोगिन आपन चार्टर में मौलिक मानवाधिकार, मानव के सम्मान आओर उपयोगिता तथा आदिमी आओर औरत के बराबर अधिकार खातिर आपन विश्वास जतौलन हउ। साथहिं ई लोगनि स्वतंत्रता के माहौल में सामाजिक प्रगति तथा जीवन के स्तर के बढ़ावे के भी दृढ़ निश्चय कएलन ह। साथ ही सदस्य राष्ट्र सब संयुक्त राष्ट्र के मदद से मानवाधिकार आओर मौलिक स्वतंत्रता खातिर लोगिन में मान बढ़ावे के भी संकल्प लेलन ह। ओही खातिर ए संकल्प के पूरा करे के खतिर '
  },
  amh: {
    iso6393: 'amh',
    fixture: 'ስለሰብአዊ፡መብቶች፡ለማስተማር፡ የሚረዱ፡አንዳንድ፡ዘዴዎች።'
  },
  hau_NG: {
    iso6393: 'hau',
    fixture:
      "Ganin cewa ‘yanci da adalci da zaman lafiya ba za su girku a duniya ba, sai in an amince da cewa: dukkan ‘yan-adam suna da mutunci, kuma suna da hakkoki na kowa daidai da na kowa, waɗanda ba za a iya ƙwace musu ba, Ganin cewa ba abin da ya sa aka aikata abubuwa irin na lokacin jahiliyya waɗanda ke tada hankalin duniya gaba-ɗaya, illa rashin sanin hakkokin ɗan-adam da rena su. Ganin kuma cewa an bayyana cewa: muhimmin gurin da ‘yan-adam suka sa gaba shi ne, bayan sun kuɓuta daga tsananin iko da wahala, kowa ya sami damar faɗin ra'ayinsa kuma ya sa rai ga abin da zuciyarsa ta saka masa, Ganin cewa ya kamata a kafa hukumomi waɗanda za su kula da kiyayewa da hakkokin ‘yan-adam, ta hanyar girka dokoki, domin kada tsananin iko da danniya su yi yawa har su kai mutane ga yin kara ko yin tawaye, Ganin cewa ya kamata a ƙarfafa aminci tsakanin ƙasashe, Ganin cewa a cikin usular (takardar sharuɗa) al'ummu, ƙasashen duniya sun sake nuna amincewarsu da muhimman hakkokin ‘yan-adam, da mutuncinsu, da "
  },
  fuv: {
    iso6393: 'fuv',
    fixture:
      'E tuugnaadeko wonde keftingal horma kala neɗɗo e nder ɓesngu aadee e hakkeeji potɗi woni dnaɗɗuudi ndimaague potal e jam e nder aduna, E tuugnaade wonde ko baasgol heftinde kam e calogol tottude hakkeeji aade ngaddi barondiral e salaare sanndolin nde e nder aduna e kadihuccande adunam mo aade heɓi yamiroore haalde e miijiaa de no henanorii ɗum yontii ete kadi yimɓe poti jeyde koye mumen ceerta e kulol e baasal sabu aadee yiɗde ɗ um, E tuugnaade wonde ina teeŋti yo hakkeeji aadee ndeenire yamiroore laawɗinaande mbele aadee waasaa tonngeede e gullitaagol dowrowol so tawii fawaama kalfaandi kiisndi walla waawnere ɓ urtunde, E tuugnaade ina teeŋti nde ɓamtatoo ɓiyngu yummaagu hakkunde leyɗeele dimɗ uɗe, E tuugnaade e nanondiral leyɗeele caaktangal woondoore leyɗeele jowitiiɗe e hakkeeji gadani aadee bayɗi no ndimaagu, teddungal e nder potal rewɓe e worɓe. Leyɗeele ɗee koddirii e daranaade ɓamtaare renndo e ñiɓgol fannuji nguurndam moƴƴam, E tuugnaade e wonde leyɗeele dentuɗe jeytiiɗe ɗee, '
  },
  bos_cyrl: {
    iso6393: 'bos',
    fixture:
      'БУДУЋИ да су признавање уроћеног достојанства и једнаких и неотућивих права свих чланова људске обитељи темељ слободе, правде и мира у свијету, БУДУЋИ да су непоштивање и презирање права човјека имали за посљедицу акте, који су грубо вријећали савјест човјечанства, и будући да је стварање свијета у којем ће људска бића уживати слободу говора и вјеровања и слободу од страха и несташице било проглашено као највиша тежња обичних људи, БУДУЋИ да је битно да права човјека буду заштићена владавином права, да човјек не буде приморан да као посљедњем средству прибјегне побуни против тираније и угњетавања, БУДУЋИ да је битно да се унапрећује развој пријатељских односа измећу народа, БУДУЋИ да су народи Уједињених нација поново потврдили у Повељи своју вјеру у основна права човјека, у достојанство и вриједност човјекове особе и у равноправност мушкараца и жена и пошто су одлучили да унапрећују друштвени напредак и бољи животни стандард у широј слободи, БУДУЋИ да су се Државе Чланице обавезале да'
  },
  bos_latn: {
    iso6393: 'bos',
    fixture:
      'BUDUĆI da su priznavanje urođenog dostojanstva i jednakih i neotuđivih prava svih članova ljudske obitelji temelj slobode, pravde i mira u svijetu, BUDUĆI da su nepoštivanje i preziranje prava čovjeka imali za posljedicu akte, koji su grubo vrijeđali savjest čovječanstva, i budući da je stvaranje svijeta u kojem će ljudska bića uživati slobodu govora i vjerovanja i slobodu od straha i nestašice bilo proglašeno kao najviša težnja običnih ljudi, BUDUĆI da je bitno da prava čovjeka budu zastićena vladavinom prava, da čovjek ne bude primoran da kao posljednjem sredstvu pribjegne pobuni protiv tiranije i ugnjetavanja, BUDUĆI da je bitno da se unapređuje razvoj prijateljskih odnosa između naroda, BUDUĆI da su narodi Ujedinjenih nacija ponovo potvrdili u Povelji svoju vjeru u osnovna prava čovjeka, u dostojanstvo i vrijednost čovjekove osobe i u ravnopravnost muškaraca i žena i posto su odlučili da unapređuju društveni napredak i bolji životni standard u široj slobodi, BUDUĆI da su se Države '
  },
  hrv: {
    iso6393: 'hrv',
    fixture:
      'Budući da su priznavanje urođenog dostojanstva i jednakih i neotuđivih prava svih članova ljudske obitelji temelj slobode, pravde i mira u svijetu, Budući da su nepoštovanje i preziranje prava čovjeka imali za posljedicu akte, koji su grubo vrijeđali savjest čovječanstva i budući da je stvaranje svijeta u kojem će ljudska bića uživati slobodu govora i vjerovanja i slobodu od straha i nestašice bilo proglašeno kao najviša težnja običnih ljudi, Budući da je bitno da prava čovjeka budu zaštićena vladavinom prava, kako čovjek ne bi bio primoran da kao za posljednjim sredstvom posegne za pobunom protiv tiranije i ugnjetavanja, Budući da je bitno da se unapređuje razvoj prijateljskih odnosa između naroda; Budući da su narodi Ujedinjenih naroda ponovno potvrdili u Povelji svoju vjeru u osnovna prava čovjeka, u dostojanstvo i vrijednost čovjekove osobe i ravnopravnost muškaraca i žena i budući da su odlučili unapređivati društveni napredak i bolji životni standard u široj slobodi, Budući da su'
  },
  nld: {
    iso6393: 'nld',
    fixture:
      'Overwegende, dat erkenning van de inherente waardigheid en van de gelijke en onvervreemdbare rechten van alle leden van de mensengemeenschap grondslag is voor de vrijheid, gerechtigheid en vrede in de wereld; Overwegende, dat terzijdestelling van en minachting voor de rechten van de mens geleid hebben tot barbaarse handelingen, die het geweten van de mensheid geweld hebben aangedaan en dat de komst van een wereld, waarin de mensen vrijheid van meningsuiting en geloof zullen genieten, en vrij zullen zijn van vrees en gebrek, is verkondigd als het hoogste ideaal van iedere mens; Overwegende, dat het van het grootste belang is, dat de rechten van de mens beschermd worden door de suprematie van het recht, opdat de mens niet gedwongen worde om in laatste instantie zijn toevlucht te nemen tot opstand tegen tyrannie en onderdrukking; Overwegende, dat het van het grootste belang is om de ontwikkeling van vriendschappelijke betrekkingen tussen de naties te bevorderen; Overwegende, dat de volker'
  },
  srp_cyrl: {
    iso6393: 'srp',
    fixture:
      'Пошто је признавање урођеног достојанства и једнаких и неотуђивих права свих чланова људске породице темељ слободе, правде и мира у свету; пошто је непоштовање и презирање права човека водило варварским поступцима, који су вређали савест човечанства, и пошто је стварање света у којем ће људска бића уживати слободу говора и веровања и бити слободна од страха и немаштине проглашено као највиша тежња сваког човека; пошто је битно да права човека буду заштићена правним системом како човек не би био приморан да као крајњем излазу прибегне побуни против тираније и угњетавања; пошто је битно да се подстиче развој пријатељских односа међу народима; пошто су народи Уједињених нација у Повељи поново прогласили своју веру у основна права човека, у достојанство и вредност човекове личности и равноправност мушкараца и жена и пошто су одлучили да подстичу друштвени напредак и побољшају животни стандард у већој слободи; пошто су се државе чланице обавезале да у сарадњи с Уједињеним нацијама обезбеде '
  },
  srp_latn: {
    iso6393: 'srp',
    fixture:
      'Pošto je priznavanje urođenog dostojanstva i jednakih i neotuđivih prava svih članova ljudske porodice temelj slobode, pravde i mira u svetu; pošto je nepoštovanje i preziranje prava čoveka vodilo varvarskim postupcima, koji su vređali savest čovečanstva, i pošto je stvaranje sveta u kojem će ljudska bića uživati slobodu govora i verovanja i biti slobodna od straha i nemaštine proglašeno kao najviša težnja svakog čoveka; pošto je bitno da prava čoveka budu zaštićena pravnim sistemom kako čovek ne bi bio primoran da kao krajnjem izlazu pribegne pobuni protiv tiranije i ugnjetavanja; pošto je bitno da se podstiče razvoj prijateljskih odnosa među narodima; pošto su narodi Ujedinjenih nacija u Povelji ponovo proglasili svoju veru u osnovna prava čoveka, u dostojanstvo i vrednost čovekove ličnosti i ravnopravnost muškaraca i žena i pošto su odlučili da podstiču društveni napredak i poboljšaju životni standard u većoj slobodi; pošto su se države članice obavezale da u saradnji s Ujedinjenim '
  },
  tha: {
    iso6393: 'tha',
    fixture:
      'โดยที่การยอมรับนับถือเกียรติศักดิ์ประจำตัว และสิทธิเท่าเทียมกันและโอนมิได้ของบรรดา สมาชิก ทั้ง หลายแห่งครอบครัว มนุษย์เป็นหลักมูลเหตุแห่งอิสรภาพ ความยุติธรรม และสันติภาพในโลก โดยที่การไม่นำพาและการเหยียดหยามต่อสิทธิมนุษยชน ยังผลให้มีการหระทำอันป่าเถื่อน ซี่งเป็นการละเมิดมโนธรรมของมนุษยชาติอย่างร้ายแรง และใต้[ได้]มีการประกาศว่า ปณิธานสูงสุดของสามัญชนได้แก่ความต้องการให้มนุษย์มีชีวิตอยู่ในโลกด้วยอิสรภาพในการพูด และความเชื่อถือ และอิสรภาพพ้นจากความหวาดกลัวและความต้องการ โดยที่เป็นการจำเป็นอย่างยิ่งที่สิทธิมนุษยชนควรได้รับความคุ้มครองโดยหลักบังคับของกฎหมาย ถ้าไม่ประสงค์จะให้คนตกอยู่ในบังคับให้หันเข้าหาการขบถขัดขืนต่อทรราชและการกดขี่เป็นวิถีทางสุดท้าย โดยที่ประชากรแห่งสหประชาชาติได้ยืนยันไว้ในกฎบัตรถึงความเชื่อมั่นในสิทธิมนุษยชนอันเป็นหลักมูล ในเกียรติศักดิ์และคุณค่าของมนุษย์และในสิทธิเท่าเทียมกันของบรรดาชายและหญิง และได้ตกลงใจที่จะส่งเสริมความก้าวหน้าทางสังคม และมาตรฐานแห่งชีวิตที่ดีขึ้นด้วยในอิสรภาพ อันกว้างขวางยิ่งขึ้น โดยที่รัฐสมาชิกต่างปฎิญาณจะให้บรรลุถึงซึ่งการส่งเสริมการเคารพและการปฎ'
  },
  ckb: {
    iso6393: 'ckb',
    fixture:
      'Herwekî nasîna weqara pêgirê hemû endamên malbata mirovî û mafên wan ên wekhev û (jênager) bingehe azadî, dad û aşitiya cihanê pêk tîne, Herwekî nenasîn û piçûkdîtina mafên mirov rê dan barbar ku wijdana mirovhiyê didin isyanê û avakirina cihaneke ku tê de ewê heyinên mirovî di peyivîn û bawerkirinê de serbest bin, ji xof û belengaziyê rizgar bin wek xweziya bilindtirîn a mirov hate îlan kirin, Herweki bingehî ye ku mafên mirov ji alî rejîmeke hiqûqî bên parastin ji bo ku mirov mecbûr nemîne, wek çara dawîn, li dijî zorkarî û zulmê rabe, Herkekî teşwîqa pêşvebirina peywendiyên dostaniyê di navbera neteweyan de bingehî ye, Herwekî gelên Neteweyen Yekbûyî di Destûrê de ji nû ve baweriya xwe ya bi mafên bingehî yên mirov, di nav weqar û rûmeta kesê mirovî de û di wekheviya mafên mêr û jinan de, dane zanîn û diyar kirin ku ew biryardar in ku arîkarî bidin pêşveçûna çivakî û bicihkirina mecalên çêtir ên jiyanê di nav serbestiyeke mestir de, Herwekî dewletên endam qewl dane, ku bi hevkariya '
  },
  yor: {
    iso6393: 'yor',
    fixture:
      'Bí ó ti jẹ́ pé ṣíṣe àkíyèsí iyì tó jẹ́ àbímọ́ fún ẹ̀dá àti ìdọ́gba ẹ̀tọ́ ṭí kò ṣeé mú kúrò tí ẹ̀dá kọ̀ọ̀kan ní, ni òkúta ìpìlẹ̀ fún òmìnira, ìdájọ́ òdodo àti àlàáfíà lágbàáyé, Bí ó ti jẹ́ pé àìka àwọn ẹ̀tọ́ ọmọnìyàn sí àti ìkẹ́gàn àwọn ẹ̀tọ́ wọ̀nyí ti ṣe okùnfà fún àwọn ìwà búburú kan, tó mú ẹ̀rí‐ọkàn ẹ̀dá gbọgbẹ́, tó sì jẹ́ pé ìbẹ̀rẹ̀ ìgbé ayé titun, nínú èyí tí àwọn ènìyàn yóò ti ní òmìnira òrọ̀ sísọ àti òmìnira láti gba ohun tó bá wù wọ́n gbọ́, òmìnira lọ́wọ́ ẹ̀rù àti òmìnira lọ́wọ́ àìní, ni a ti kà sí àníyàn tó ga jù lọ lọ́kàn àwọn ọmọ‐èniyàn, Bí ó ti jẹ́ pé ó ṣe pàtàkì kí a dáàbò bo àwọn ẹ̀tó ọmọnìyàn lábẹ́ òfin, bí a kò bá fẹ́ ti àwọn ènìyàn láti kọjú ìjà sí ìjọba ipá àti ti amúnisìn, nígbà tí kò bá sí ọ̀nà àbáyọ mìíràn fún wọn láti bèèrè ẹ̀tọ́ wọn, Bí ó ti jẹ́ pé ó ṣe pàtàkì kí ìdàgbàsókè ìbáṣepọ̀ ti ọ̀rẹ́‐sí‐ọ̀rẹ́ wà láàrin àwọn orílẹ̀‐èdè, Bí ó ti jẹ́ pé gbogbo ọmọ Àjọ‐ìsọ̀kan orílẹ̀‐èdè àgbáyé tún ti tẹnu mọ́ ìpinnu tí wọ́n ti ṣe tẹ́lẹ̀ nínú ìwé àdéhùn wọn, pé àwọn ní ìgbàgbọ'
  },
  uzn_cyrl: {
    iso6393: 'uzn',
    fixture:
      'Инсон оиласи барча аъзоларига ҳос бўлган қадр‐қиммат ҳамда уларнинг тенг ва ажралмас ҳуқуқларини тан олиш эркинлик, адолат ва ялпи тинчликнинг асоси бўлишини эътиборга олиб, Инсон ҳуқуқларини менсимаслик ва оёқ‐ости қилиш одамзод виждонини ўртаётган ваҳшийларча қилмишларга олиб келганини ҳамда кишилар сўз ва маслак эркинлиги соҳиби бўлиб, қўрқув ва муҳтожликдан ҳоли бўлиб яшайдиган дунёни бунёд этиш одамларнинг нуфузли интилиши, деб эълон қилинганлигини эътиборга олиб, Инсон сўнгги чора сифатида зулм ва истибдодга қарши исён қилиб бош кўтаришга мажбур бўлмаслигининг олдини олиш мақсадида инсон ҳуқуқларни қонун изми билан муҳофаза этилиши зарурлигини эътиборга олиб, Халқлар ўртасида дўстона муносабатларни ривожлантиришга кўмаклашиш зарурлигини эътиборга олиб, Бирлашган Миллатларнинг халқлари Уставда инсоннинг асосий ҳуқуқларни, қадр‐қиммати ва инсон шахснинг беназирлигига ҳамда эркаклар ва аёлларнинг тенг ҳуқуқлигига ўз ишончларини тасдиқлаганликларни ҳамда катта ҳуқуқ билан ижтимоий та'
  },
  uzn_latn: {
    iso6393: 'uzn',
    fixture:
      'Inson oilasi barcha aʼzolariga hos boʻlgan qadr‐qimmat hamda ularning teng va ajralmas huquqlarini tan olish erkinlik, adolat va yalpi tinchlikning asosi boʻlishini eʼtiborga olib, Inson huquqlarini mensimaslik va oyoq‐osti qilish odamzod vijdonini oʻrtayotgan vahshiylarcha qilmishlarga olib kelganini hamda kishilar soʻz va maslak erkinligi sohibi boʻlib, qoʻrquv va muhtojlikdan holi boʻlib yashaydigan dunyoni bunyod etish odamlarning nufuzli intilishi, deb eʼlon qilinganligini eʼtiborga olib, Inson soʻnggi chora sifatida zulm va istibdodga qarshi isyon qilib bosh koʻtarishga majbur boʻlmasligining oldini olish maqsadida inson huquqlarni qonun izmi bilan muhofaza etilishi zarurligini eʼtiborga olib, Xalqlar oʻrtasida doʻstona munosabatlarni rivojlantirishga koʻmaklashish zarurligini eʼtiborga olib, Birlashgan Millatlarning xalqlari Ustavda insonning asosiy huquqlarni, qadr‐qimmati va inson shaxsning benazirligiga hamda erkaklar va ayollarning teng huquqligiga oʻz ishonchlarini tasdiqla'
  },
  mly_arab: {
    iso6393: 'zlm',
    fixture:
      'بهاواساڽ ڤڠيعترافن كأوتوهن كموليأن دان حق سامرات سرتا اساسي يڠ تق ترڤيسه باڬي سلوروه اومت مأنسي عداله اساس كبيبسن، كعاديلن دان كداماين دنيا. بهاواساڽ ڤڠاباين سرتا ڤڠهينأن ترهادڤ حق اساسي مأنسي تله ڤون مڠعاقبتكن تيندقن تركوتوق يڠ تله ملڠڬري ڤراسأن هاتي اومت مأنسي، دان مونچولڽ سبواه دنيا د مان مأنسي اكن منعمتي كبيبسن براوچڤ دان مڠانوت كڤرچايأن سرتا كبيبسن دري راستاكوت دان چيتاراس تله ڤون دأشتهاركن سباڬاي اسڤيراسي تراڬوڠ سلوروه اومت مأنسي. سكيراڽ كيت تيدق ماهو مندوروڠ مأنسي دالم كأدأن تردسق، سباڬاي ڤيليهن تراخير، ممبرونتق ممنتڠ كظاليمن سرتا ڤنيندسن، مك عداله ڤنتيڠ باڬي حق اساسي مأنسي دڤرتاهنكن اوليه كدولتن اوندڠ٢. بهاواساڽ عداله ڤنتيڠ باڬي مماجوكن ڤركمبڠن ڤرهوبوڠن ڤرصحابتن د انتارا نڬارا٢. بهاواساڽ رعيت بڠسا٢ برساتو، دالم ڤياڬمڽ تله سكالي لاڬي منڬسكن كڤرچايأن مريك ترهادڤ حق اساسي مأنسي، ترهادڤ كموليأن سرتا نيلايديري مأنسي دان ترهادڤ حق سامرات للاكي دان ڤرمڤوان دان تله منتڤكن كعزمن اونتوق مماجوكن ڤركمبڠن سوسيال دان طرف هيدوڤ يڠ لبيه سمڤرنا دالم سواسان كبيبسن يڠ لبيه لواس. بهاواساڽ نڬارا٢ ا'
  },
  mly_latn: {
    iso6393: 'zlm',
    fixture:
      'Bahawasanya pengiktirafan keutuhan kemuliaan dan hak samarata serta asasi yang tak terpisah bagi seluruh umat manusia adalah asas kebebasan,keadilan dan kedamaian dunia. Bahawasanya pengabaian serta penghinaan terhadap hak asasi manusia telah pun mengakibatkan tindakan terkutuk yang telah melanggari perasaan hati umat manusia, dan munculnya sebuah dunia di mana manusia akan menikmati kebebasan berucap dan menganut kepercayaan serta kebebasan dari rasatakut dan citarasa telah pun diisytiharkan sebagai aspirasi toragung seluruh umat manusia. Sekiranya kita tidak mahu mendorong manusia dalam keadaan terdesak, sebagai pilihan terakhir, memberontak mementang kezaliman serta penindasan, maka adalah penting bagi hak asasi manusia dipertahankan oleh kedaulatan undang-undang. Bahawasanya adalah penting bagi memajukan perkembangan perhubungan persahabatan di antara negara-negara. Bahawasanya rakyat Bangsa-Bangsa Bersatu, dalam Piagamnya telah sekali lagi menegaskan kepercayaan mereka terhadap ha'
  },
  ibo: {
    iso6393: 'ibo',
    fixture:
      "Ebe ọ bụ na nghọta ugwu ekere uwa na ikike nha anya a pụghị ịnapụ mmadụ nke dirị onye ọ bụla bi n'ụwa bụ ntụala nke inwere onwe, ikpe nkwụmọtọ na udo n'elụ ụwa. Ebe nleghara anya na nleli ikike mmadu nwegasịrị emeela ka e nwee akparamagwa enweghi uche nke gbawara obi mmadụ nile, a bịakwa ọbịbịa ụwa ebe ndi mmadụ ga‐enwejupụta ohere ikwu okwu na inwe nkwenye nakwa nlihapụ n'ụjọ na ụkọ, abụrụ ihe a mara n'okwa dị ka olile anya kachasị ibe ya nke mmadụ nkịtị. Ebe ọ dị mkpa, ma ọ bụrụ na a chọghi ikwanye mmadụ ka o were oke nnupu isi sogide ochịchị aka ike na mmegbu dị ka ihe ikpeazụ ọ pụrụ ime, na a ga‐echedo ikike mmadụ nwegasịrị site n'usoro iwu. Ebe ọ dị mkpa ịkwalite ọganihu mmekọrịta enyi na enyi n'etiti mba na ibe ya. Ebe ndi otu jikọtara mba ụwa nile bụ United Nations, n'ime Chata bụ akwụkwọ nyere ha ike kwupụtakwara ọzọ okwukwe ha n'ikike ntọala mmadụ nwegasịrị, n'ugwu na uru nke mmadụ, ya na nha anya ikike ndi dịrị nwoke na nwanyị, were nweekwa njikere ịkwalite ọganihu obodo na e"
  },
  nep: {
    iso6393: 'npi',
    fixture:
      'मानव परिवारका सबै सदस्यहरूको अन्तर्निहित मान तथा सम्मान र अवछिन्न अधिकारहरूको मान्यता नै स्वतन्त्रता, न्याय, र शान्तिको आधार भएकोले, मानव अधिकारहरू प्रति अवहेलना तथा अनादरको परिणामबाटै नै काम भड मानव जातिको अन्त स्करणमा चिट पुर्‍याइएको हुनाले र मानवहरूले धर्म र वाक स्वन्त्रता तथा भए र अभावबाट मुक्ति पाउनु पर्छ भन्ने सर्व साधारण जनताको घोषित आकांक्षा भएकोले, अत्याचार र दमनको विरुद्ध अरू उपाय नपाएर विद्रोह गर्नू नै अन्तिम उपाय हो भन्ने नउठानुन हो भने मानव अधिकारहरू कानुनी शासनद्वारा संरक्षित रहनु अति आवश्यक भएकोले, राष्ट्रहरूका बीच मैत्री सम्बन्ध वृद्धि गर्न आवश्यक भएकोले संयुक्त राष्ट्र संघका जनता हरूले मानवका मौलिक अधिकारहरू र मनुष्यको मान तथा कदर र नर -नारीहरूको सम्मान अधिकारहरू प्रति पुनः विश्वासको पुस्ट्याइँ अधिकार पत्रमा गरि बढि स्वतन्त्रताको आधारमा सामाजिक प्रगति एवं जीवनको सदस्य राष्ट्रहरू र ती राष्ट्रहरूका अधिकारमा रहेका प्रादेशिक जनताहरूमा समेत ती अधिकारहरू र स्वतन्त्र हरू को विश्वव्यापी र प्रभावशाली मान्यता प्राप्त गर्नको लागि प्रत्येक व्यक्ति र समाजको अंगले निरन्तर मनमा राखि '
  },
  ceb: {
    iso6393: 'ceb',
    fixture:
      'Samtamg ang pag-ila sa tiunay nga kabililhon ug sa managsama ug dili maagaw nga mga katungod sa tanang sakup sa tawhanong banay mao and sukaranan sa kagawasan, hustisya ug kalinaw sa kalibutan. Samtang ang wala pagtagad ug pagbiaybiay sa mga tawhanong katungod misangpot samabangis nga mga buhat nga nagbiaybiay sa tanlag sa katawhan, ug ang pag-abot sa usa ka kalibutan diin ang tanang katawhan makapahimulos/makatagamtam sa kagawasan sa pagsulti ug pagtoo ug kagawasan gikan sa kahadlok ug sa panginahanglan gimantala isip pinakahingpit nga tinguha sa yanong katawhan. Samtang kini gikinahanglan kung ang tawo dili mapugos sa pagdangop, isip katapusang dalangpan, sa pag-alsa batok sa pagpanglupig ug paglisudlisod, nga ang tawhanong mga katungod mapanalipdan pinaagi sa mga lagda sa balaod. Samtang kini gikinahanglan sa pagpauswag sa paglambo sa hinigala nga resyon tali sa mga nasud. Samtang ang katawhan sa Tinipong Kanasuran (UN) naghimo diha sa lagda sa pagmatuod pag-usab sa ilang pagsalig s'
  },
  skr: {
    iso6393: 'skr',
    fixture:
      'دنیا دے سارے انسان ہکو ڄئے تے نہ مکڻ والے حقوق تے ازادیاں گھن تے پیدا تھیڈن ۔ اقوام متحدہ نے ہر کہیں دے حقوق دی حفاظت تے ودھارے دا جھنڈا اچار کھڻ دا ارادہ کیتا ہوے ۔ جیمبڑا اقوام متحدہ دے منشور دا حصہ ہے ۔ ایندے وچ انسانی عزت تے و قار، جیادی انسانی حقوق، عزت نفس اتے لوکاں دے یقین دا اقرار کیتا ڱے ۔ اقوام متحدہ دی جنرل اسمبلی نے ڋہ دسمبر1948 کوں انسانی حقوق داعالمی منشور منظور کرتے ایند اعام اعلان کیتا ۔ اگلے صفیاں تے اینہ منشور دی پوری عبارت پیش کیتی ویندی اے ۔ منشور اچ اقوام متحدہ نے صاف تے سادہ لفظاں اچ حقوق ڋساڋتن ۔ جنباں وچ ہر کوئی برابر داشر یک ہے ۔ ایں تر یخی کار نامے دے بعد اسمبلی نے سارے شریک ملکاں تے زور ڋتاجوایں اعلان کوں عام کڔن تے ایندے ودھارے وچ حصہ ڱھئن ۔ مشلا اے جو ایکوں پوسٹر دی شکل وچ چھپوا کے جاجا تے لایا ونڄی ۔ خاص طور تے سکولاں تے ڋو جھے تعلیمی اداریاں وچ ایکوں پڑھ کے سنڑایا ونڄے ۔ ایندی تفصیلات کھول تے ڋسائی ونڄن تے ایں سلسلے وچ سیاسی جیاداں تے کہیں ملک نال کوئی فرق ناں کیتا ونڄے ۔ اے حقوق تہاڋی ملکیت ہن تے انہاں دے بارے وچ پوری معلومات حاصل کرو ۔ آپڻے تے ڋوجھیاں ک'
  },
  tgl: {
    iso6393: 'tgl',
    fixture:
      "Sapagkat ang pagkilala sa katutubong karangalan at sa pantay at di-maikakait na mga karapatan ng lahat ng nabibilang sa angkan ng tao ay siyang saligan ng kalayaan, katarungan at kapayapaan sa daigdig. Sapagkat ang pagwawalang-bahala at paglalapastangan sa mga karapatan ng tao ay nagbunga ng mga gawang di-makatao na humamak sa budhi ng sangkatauhan, at ang pagdatal ng isang daigdig na ang mga tao ay magtatamasa ng kalayaan sa pagsasalita at ng kaligtasan sa pangamba at pagdaralita ay ipinahayag na pinakamataas na mithiin ng mga karaniwang tao. Sapagkat mahalaga, kung ang tao ay di-pipiliting manghawakan bilang huling magagawa, sa paghihimagsik laban sa paniniil at pang-aapi, na ang mga karapatan ng tao'y mapangalagaan sa pamamagitan ng paghahari ng batas. Sapagkat mahalagang itaguyod ang pagpapaunlad ng mabuting pagsasamahan ng mga bansa. Sapagkat ang mga mamamayan ng Mga Bansang Nagkakaisa ay nagpatibay sa Karta ng kanilang pananalig sa mga Saligang karapatan ng tao, sa karangalan at "
  },
  hun: {
    iso6393: 'hun',
    fixture:
      'Tekintettel arra, hogy az emberiség családja minden egyes tagja méltóságának, valamint egyenlő és elidegeníthetetlen jogainak elismerése alkotja a szabadság, az igazság és a béke alapját a világon, Tekintettel arra, hogy az emberi jogok el nem ismerése és semmibevevése az emberiség lelkiismeretét fellázító barbár cselekményekhez vezetett, és hogy az ember legfőbb vágya egy olyan világ eljövetele, amelyben az elnyomástól, valamint a nyomortól megszabadult emberi lények szava és meggyőződése szabad lesz, Tekintettel annak fontosságára, hogy az emberi jogokat a jog uralma védelmezze, nehogy az ember végső szükségében a zsarnokság és az elnyomás elleni lázadásra kényszerüljön, Tekintettel arra, hogy igen lényeges a nemzetek közötti baráti kapcsolatok kifejeződésének előmozdítása, Tekintettel arra, hogy az Alapokmányban az Egyesült Nemzetek népei újból hitet tettek az alapvető emberi jogok, az emberi személyiség méltósága és értéke, a férfiak és nők egyenjogúsága mellett, valamint kinyilván'
  },
  azj_cyrl: {
    iso6393: 'azj',
    fixture:
      'Бәшәр аиләсинин бүтүн үзвләринә хас олан ләјагәт һиссинин вә онларын бәрабәр вә ајрылмаз һүгугларынын танынмасынын азадлыг, әдаләт вә үмуми сүлһүн әсасы олдуғуну нәзәрә алараг, инсан һүгугларына етинасызлыг вә нифрәтин бәшәријјәти дәһшәтә ҝәтирән барбаризм һәрәкәтләринә сәбәб олдуғуну вә инсанларын сөз вә етигад азадлығына малик, горху вә еһтијаҹдан азад олдуглары дүнјанын јарадылмасынын бәшәријјәтин ән али истәји олдуғуну нәзәрә алараг, инсанын сон васитә кими истибдад вә зүлмә гаршы гијама галхмаға мәҹбур олмамасыны тәмин етмәк үчүн инсан һүгугларынын ганунун һакимијјәти илә мүдафиә олунмасынын зәрурилијини нәзәрә алараг, халглар арасында меһрибан мүнасибәтләрин инкишафыны дәстәкләмәјин ваҹиблијини нәзәрә алараг, Бирләшмиш Милләтләрин халгларынын БМТ Низамнамәсиндә әсас инсан һүгугларына, инсан шәхсијјәтинин ләјагәт вә дәјәринә, киши вә гадынларын һүгуг бәрабәрлијинә инамларыны тәсдиг етдикләрини вә даһа ҝениш азадлыг шәраитиндә сосиал тәрәгги вә һәјат шәраитинин јахшылашдырылмасына '
  },
  azj_latn: {
    iso6393: 'azj',
    fixture:
      'Bəşər ailəsinin bütün üzvlərinə xas olan ləyaqət hissinin və onların bərabər və ayrılmaz hüquqlarının tanınmasının azadlıq, ədalət və ümumi sülhün əsası olduğunu nəzərə alaraq, insan hüquqlarına etinasızlıq və nifrətin bəşəriyyəti dəhşətə gətirən barbarizm hərəkətlərinə səbəb olduğunu və insanların söz və etiqad azadlığına malik, qorxu və ehtiyacdan azad olduqları dünyanın yaradılmasının bəşəriyyətin ən ali istəyi olduğunu nəzərə alaraq, insanın son vasitə kimi istibdad və zülmə qarşı qiyama qalxmağa məcbur olmamasını təmin etmək üçün insan hüquqlarının qanunun hakimiyyəti ilə müdafiə olunmasının zəruriliyini nəzərə alaraq, xalqlar arasında mehriban münasibətlərin inkişafını dəstəkləməyin vacibliyini nəzərə alaraq, Birləşmiş Millətlərin xalqlarının BMT Nizamnaməsində əsas insan hüquqlarına, insan şəxsiyyətinin ləyaqət və dəyərinə, kişi və qadınların hüquq bərabərliyinə inamlarını təsdiq etdiklərini və daha geniş azadlıq şəraitində sosial tərəqqi və həyat şəraitinin yaxşılaşdırılmasına '
  },
  sin: {
    iso6393: 'sin',
    fixture:
      'සියලූ මනුෂ්‍යයෝ නිදහස්ව උපත ලබා ඇත. ගරුත්වයෙන් හා අයිතිවාසිකම් සමාන වෙති. යුක්ති අයුක්ති පිළිබඳ හැඟීමෙන් හා හෘදය සාක්ෂියෙන් යුත් ඔවුනොවුන්වුන්ට සැළකිය යුත්තේ සහෝදරත්වය පිළිබඳ හැඟීමෙනි.'
  },
  koi: {
    iso6393: 'koi',
    fixture:
      'Медбы тӧдны, что морт семьяись быд членлӧн эм аслас достоинство, а сылӧн ӧткодь да мырддьытӧм правоэз лоӧ воля, справедливость да лӧнь олан понда основаӧн; медбы тӧдны, что морт правоэз нем туйӧ пуктӧм вайӧтіс ни умӧль, кӧда морт увтырлӧ оз сет овны совесть сьӧрті, и что сэтшӧм мирыс, кытӧн отирыс пондас авйыны да сернитны повтӧг, а овны нуждатӧг, лоас сьӧлӧмсянь керӧм быдӧнныс понда; и медбы тӧдны, что колӧ керны быдӧс, медбы мортлӧн пра- воэз дозирайтсисӧ законӧн и эз адззисьӧ моггез мортыслӧ лэбтісьны паныт умӧля видзӧмлӧ да дзескӧтӧмлӧ; и медбы тӧдны, что пыр колӧ отсавны отиррезлӧ ёртасьӧмын; и медбы тӧдны, что Йитӧм Нацияэзлӧн народдэз гижисӧ вын мортлісь медыджыт правоэз, вылына лэбтісӧ личностьлі дон, мужиккезлісь да инькаэзлісь ӧтыжда правоэз и кутчисисӧ эшӧ ёнжыка отсавны социальнӧй прогресс да вольнӧй олан бурсьӧтӧмын; и медбы тӧдны, что членнэз-государствоэз кӧсйисисӧ отсавны Нацияэзлӧн Йитӧм Чукӧрлӧ ӧтласа уджын, ӧтамӧд коласын морт правоэз сьӧрті бытшӧма да вольнӧя олӧмын'
  },
  ell_monotonic: {
    iso6393: 'ell',
    fixture:
      'Επειδή η αναγνώριση της αξιοπρέπειας, που είναι σύμφυτη σε όλα τα μέλη της ανθρώπινης οικογένειας, καθώς και των ίσων και αναπαλλοτρίωτων δικαιωμάτων τους αποτελεί το θεμέλιο της ελευθερίας, της δικαιοσύνης και της ειρήνης στον κόσμο. Επειδή η παραγνώριση και η περιφρόνηση των δικαιωμάτων του ανθρώπου οδήγησαν σε πράξεις βαρβαρότητας, που εξεγείρουν την ανθρώπινη συνείδηση, και η προοπτική ενός κόσμου όπου οι άνθρωποι θα είναι ελεύθεροι να μιλούν και να πιστεύουν, λυτρωμένοι από τον τρόμο και την αθλιότητα, έχει διακηρυχθεί ως η πιο υψηλή επιδίωξη του ανθρώπου. Επειδή έχει ουσιαστική σημασία να προστατεύονται τα ανθρώπινα δικαιώματα από ένα καθεστώς δικαίου, ώστε ο άνθρωπος να μην αναγκάζεται να προσφεύγει, ως έσχατο καταφύγιο, στην εξέγερση κατά της τυραννίας και της καταπίεσης. Επειδή έχει ουσιαστική σημασία να ενθαρρύνεται η ανάπτυξη φιλικών σχέσεων ανάμεσα στα έθνη. Επειδή, με τον καταστατικό Χάρτη, οι λαοί των Ηνωμένων Εθνών διακήρυξαν και πάλι την πίστη τους στα θεμελιακά δικαιώμ'
  },
  ces: {
    iso6393: 'ces',
    fixture:
      'U vědomí toho, že uznání přirozené důstojnosti a rovných a nezcizitelných práv členů lidské rodiny je základem svobody, spravedlnosti a míru ve světě, že zneuznání lidských práv a pohrdání jimi vedlo k barbarským činům, urážejícím svědomí lidstva, a že vybudování světa, ve kterém lidé, zbavení strachu a nouze, se budou těšiti svobodě projevu a přesvědčení, bylo prohlášeno za nejvyšší cíl lidu, že je nutné, aby lidská práva byla chráněna zákonem, nemá-li být člověk donucen uchylovat se, když vše ostatní selhalo, k odboji proti tyranii a útlaku, že je nutné podporovat rozvoj přátelských vztahu mezi národy, že lid Spojených národů zdůraznil v Chartě znovu svou víru v základní lidská práva, v důstojnost a hodnotu lidské osobnosti, v rovná práva mužů i žen a že se rozhodl podporovat sociální pokrok a vytvořit lepší životní podmínky ve větší svobodě, že členské státy převzaly závazek zajistit ve spolupráci s Organizací spojených národů všeobecné uznávání a zachovávání lidských práv a základn'
  },
  mag: {
    iso6393: 'mag',
    fixture:
      'सभे के ओकर उचित सम्मान तथा मानव परिवार के सब सदस्य के बराबरी के हक ही विश्व समुदाय के स्वतंत्रता, न्याय और शांति के बुनियाद हई। मानवाधिकार के उल्लंघन हरदम से अमानवीय काम के बजह से ही होव हई। जेकरा से मानवता के अंतकरण दु:खी होव हई। एक आम आदमी के सबसे बड़ा इच्छा इहे होव हई कि ए दुनिया में ओकरा भाषण और विचार के आजादी मीले साथ ही भय और इच्छा से भी मुक्ति मीले। यदि कोइयो तानाशाही या दमन के खिलाफ बगावत करे लेले मजबूर हई त ओकरा कानून से ओकर मानवाधिकार के सुरक्षा के इंतजाम होए के चाहीं। इहो आवश्यक हई कि राष्ट्र सब के बीच दोस्ती बढ़ाएल जाए। संयुक्त राष्ट्र के लोग सब अपन चार्टर में मौलिक मानवाधिकार, मानव के सम्मान और उपयोगिता तथा आदमी और औरत के बराबर अधिकार के प्रति अपन विश्वास जतेलकई हन। साथ ही उ आर स्वतंत्रता के माहौल में सामाजिक प्रगति तथा जीवन के स्तर के बढ़ावे लेल भी दृढ़ निश्चय कएलकई हन। साथ में सदस्य राष्ट्र सब संयुक्त राष्ट्र के मदद से मानवाधिकार और मौलिक स्वतंत्रता के प्रति लोग सब में इज्जत बढ़ावे लेल भी संकल्प लेलकए हन। एहि से इ संकल्प के प्राप्ति के लेल इ सब अधिकार और स्वतंत्रता के सम'
  },
  run: {
    iso6393: 'run',
    fixture:
      "Ibonye ko kwemera ko abantu bose bategerezwa guhabwa agateka n'ukubahirizwa kimwe, ari ryo shingiro ryukwishira n'ukwizana, ubutungane n'amahoro kw'isi. Ibonye ko kutemera n'ukudakwirikiza ingingo zubahiriza zina muntu vyatumye hakorwa amabi atagira uko avugwa kandi ko isi izira ubwicanyi n'amaganya, abantu bose bakavuga kandi bakemera uko bavyifuza ari yo yemejwe ko zina muntu wese anyotewe imbere ya vyose. Ibonye ko ari nkenerwa ko ingingo zubahiriza zina muntu zubahirizwa n'amategeko atomoye kugira ngo umuntu, aburaniwe, ntaruhire kwiyamiriza agahotoro n'akarenganyo, Isanze ko mu Masezerano y'Ishirahamwe Mpuzamakungu, amakungu yongeye kwemeza ko ashigikiye ingingo ngenderwako zubahiriza zina muntu wese, agateka n'agaciro twiwe; ko abantu bose bangana ata kuraba umuhungu n'umukobwa, kandi ko biyemeje gushigikira iterambere ry'abanyagihugu bakarushiriza kwishira n'ukwizana, Ibonye ko ari nkenerwa gushigikira iterambere ry'imigenderanire y'ubucuti mu makungu, Isanze ko ibihugu buhuriki"
  },
  bel: {
    iso6393: 'bel',
    fixture:
      'Прымаючы пад увагу, што прызнанне годнасці, якая ўласціва ўсім членам чалавечай сямʼі, і роўных і неадʼемных правоў іх зʼяўляецца асновай свабоды, справядлівасці і ўсеагульнага міру; і прымаючы пад увагу, што грэбаванне і пагарда да правоў чалавека прывялі да варварскіх актаў, якія абураюць сумленне чалавецтва, і што стварэнне такога свету, у якім людзі будуць мець свабоду слова і перакананняў і будуць свабодныя ад страху і галечы, абвешчана як высокае імкненне людзей; і прымаючы пад увагу, што неабходна, каб правы чалавека ахоўваліся ўладай закону з мэтай забеспячэння таго, каб чалавек не быў вымушаны ўжываць, у якасці апошняга сродку, паўстання супроць тыраніі і прыгнечання; і прымаючы пад увагу, што неабходна садзейнічаць развіццю дружалюбных адносін паміж народамі; і прымаючы пад увагу, што народы Абʼяднаных Нацый пацвердзілі ў Статуце сваю веру ў асноўныя правы чалавека, у годнасць і каштоўнасць чалавечай асобы і ў раўнапраўе мужчын і жанчын і вырашылі садзейнічаць сацыяльнаму пра'
  },
  plt: {
    iso6393: 'plt',
    fixture:
      "Heverina fa ny fankatoavana ny fahamendrehan'olombelona sy ny zony mitovy ary tsy azo tohintohinina dia anisan'ny fototry ny fahafahana, ny rariny ary ny fandriam-pahalemanana eran-tany, Heverina fa ny tsy fahafantarana sy fanaovana tsinintsinona ny zon'olombelona dia mitarika amin'ny fihetsika feno habibiana mampikomy ny fieritreretan'ny mpiara-belona. Ny fametrahana tontolo vaovao ; hivelaran'ny olona afaka eo amin'ny filazana ny hevitra sy ny finoana, ary tsy voagejan'ny tahotra sy ny fahoriana no hetaheta lehibe indrindra ho an'ny olombelona, Heverina fa ilaina ny miaro ny zon'olombelona amin'ny fametrahana rafitra tan-dalna mba tsy hitarika azy hikomy sy hanohitra ny fampihorohoroana sy ny fampijaliana, Heverina fa zava-dehibe ny famporisihana hatrany ny fifandraisana ara-pirahalahiana eo amin'ny firenen-tsamihafa, Heverina fa ny Fanjakana Mpikambana rehetra dia manaiky hanaja ny zon'olombelona sy ny fahafahana fototra, ka miara miasa amin'ny Firenena Mikambana izy amin'izany, Hev"
  },
  qug: {
    iso6393: 'qug',
    fixture:
      '\n        Kawsaypi yuyashpa, kishpiriy, paktakay, allpapachapi kasikllakawsay tiksi\n        kakpimi tukuy runakuna sumak kawsayta charichun nishpa riksin; shinallatak\n        sumaykayta(dignidad), paktapakta hayñita ayllumanta mana pi kichuchunmi\n        riksin.\n       \n        Kawsaypi yuyashpa, piñashpa mana riksina, runakunapak hayñita saruy,\n        runapura wañunakuna yuyaymi tukuysami kawsaypi sapiyashka nin.\n        Chaymi tukuysami lIakikunata IIaktakunaman apamushka. Chaymantami\n        runakunaka tukuy IIaktakunapi kaparishpa kishpirishka kawsayta yuyashpa\n        mashkay kallarin; wakcha runakuna, IIakta runakuna, upallalla kawsak\n        runakuna, shitashka runakuna kishpirinata munan. Mashná kay pachapi\n        kawsakkunami kay amsa, ñawsa, milli kawsaymanta lIukshinata munan. Kipaka\n        kishpiy rimayta, yuyayta charina kan.\n       \n        Kawsaypi yuyashpa, runakunapak hayñitaka, paypak hayñimi nishpa shuktak\n        kamachi lIikakuna kamashka kachun. Shina waKcha run'
  },
  mad: {
    iso6393: 'mad',
    fixture:
      "Saestona pangakowan drajat secara koddrat klaban hak se dha-padha sareng muttlak dhari sadajana anggota kaluwarga manossa enggi panika dasar dhari kamardikaan, keadilan sareng perdamaian e dunnya. Saestona manabi tak agateyagi sareng nganggep enteng hak-hak epon manossa badhi adaddiyagi kalakowan-kalakowan bengges se bisa mapeggel ate nuraniepon umat manossa; wujudepon settong dhunnya, palenggiyanna manossa se badhi arassaagi kenikmatan, kebebasan angocappagi pamanggi ban keyakinan sareng kebebasan dhari rassa tako' ban kemeskenan ampon daddi pernyataan aspirasi paleng tenggi dhari sadajana ra'yat biyasa. Saestona hak-hak manossa parlo e naonge kalaban peratoran hukum, sopaja oreng ta' kapaksa mele jalan berontak menangka cara paleng akher kaanguy alaban kedholiman sareng penjajahan. Saestona ce' parlona mamajuagi hubungan kakancaan eanterona nagara-nagara. Saestona bangsa-bangsa dhari Perserikatan Bangsa-Bangsa e dhalem Piagam Perserikatan Bangsa-Bangsa ampon anegessagi pole kapercaja"
  },
  nya_chinyanja: {
    iso6393: 'nya',
    fixture:
      "Popeza kuti citsimikizo ca khalidwe loyenera la munthu mu banja lonse ndico tsinde la ufulu, ungwiro ndi mtendere pa dziko liri lonse la pansi, Popeza kuti kusalabadira ufulu wa munthu kwabweretsa khalidwe la nkhalwe pa umoyo wa munthu, ndi kutinso kusintha kwa zinthu pa dziko la pansi mwakufuna kupereka ufulu weni-weni pa umoyo wa munthu aliyense ndilo funo la munthu wamba aliyense, Popeza kuti ndi kofunikira kuti ufulu wa munthu ucinjirizidwe ndi lamulo pofuna kupewa nkhondo yomenyera ufulu kukhala ngati njira yomwe munthu angagwiritse nchito pofuna kumasulidwa ku nsinga za nkhalwe, Popeza kuti ndi kofunikira kukweza umodzi pakati pa mitundu ya maiko osiyana-siyana pa dziko lonse la pansi, Popeza kuti anthu a m' maiko amene ali mamembala a bungwe la United Nations anabvomereza za kufunikira kwa ufulu wa munthu mu makhalidwe ace onse ndiponso kuti sipayenera kukhala kusiyana pakati pa mwamuna ndi mkazi m' makhalidwe ao ndikutinso maikowa anadzipereka kukweza nchito za cisangalalo ndi "
  },
  ccx: {
    iso6393: 'zyb',
    fixture:
      'Aenvih roxnyinh vunz lajmbwn bonilaiz couh miz naj caeuq mboujbienq dih genzll, dwg seiqgyaiq cwyouz,cingqnyi caeuq hozbingz dih gihcui, Aenvih yawjsiuj vuhmez yinzgenz fazcanj baenz yejmanz bauhingz, gij bauhingz neix diemqvu liengzsaem gyofengqvunz,hoeng vunz lajmbwn muengh miz aen seiqgyaiq bouxboux mizyenzlwn cwyouz caeuq sainnyangj cwyouz, vunz mboui miz maz lau, mbouj miz bouxhoj, Aenvih bwh vunz lajmbwn mboujndaej mbouj vih baucing caeuq yazbwz hwnj daeuj cauxfanj, raeuz miz bizyau hawj yinzgenz ndaej fazci baujhu, Aenvih aeu cuzcin gakguek doxdiet youxndei dih gwanhhi, Aenvih daengx lenzhozgoz guekgya dih yinzminz gaenq youq ndaw lenzhozgoz hencangh cungzsinh gyoengqde doiq gak cungj genzli,bijgangj gihbwnj yinzgenz,yinzgwz cinhnyenz,gyaciz , caeuq nanznij bingzdaengj,gyoengqde lij gietsim sevei miz cwyouz youh cinbu,ngoenz ndei gvaq ngoenz, Aenvih gak veiyenzgoz gaenq siq nyuenh caeuq lenzhozgoz hozcoz, cuzcin yawjnaek, cinhhingz yinzgenz caeuq gijbwnj cwyouz, Aenvih bouxboux '
  },
  pbu: {
    iso6393: 'pbu',
    fixture:
      'څرنګه چې دبشري کورنۍ دټولو غړو ذاتي حېثيت پيثزندنه او دهغوي پر رنګ او انتقال نه منونکي حقوق په نړۍ کښې د ازادۍ ، عدالت او سولې اساس تشکيلوي، لکه څنګه چې د بشري حقوق تحقير او د هغو نه پيژندنه په وحشيانه عملونو منجر شوي چې د بشريت روح په ګناه مجبوروي او دهغې نړۍ ظهور يي چې په هغې کښې بشر په بيان او عقيده کښې ازاد اور له ويرې او فقر څخه فارغ وي، د بشر دلوړو آمالو تر سرليک لاندي اعلان کړي دي۔ له هغه ځايه چې اساساً بايد د بشري حقوقو د قانون په اجرا کولو سره حمايت وشي، چې بشر د وروستې علاج په نوم د ظلم او فشار پر ضد په قيام مجبور نه شي، له هغه ځايه چې اساساً لازم دي چې د ملتونو تر منځ و دوستانه اړيکو پراختيا بايد تشويق شي، له هغه ځايه چې د ملګرو ملتونو خلکو د بشر بنسټي حقوقو، دانساني فرد دمقام او ارزست او د نارينه وو او ښځو د حقوقو د تساوي په هکله يو ځل بيا په منشور کښې خپل باور اعلان کړي او ټينګه پريکړه يې کړي چې له ټولنيز پر مختګ سره مرسته و کړي او په يو ازاد چاپيريال کښې د ښه ژوندانه وضع او حالات را منځ ته کړي، له هغه ځايه چې غړي هيوادونه سره متعهد شوي چې د ملګرو ملتونه په همکاري سره نړېو'
  },
  kin: {
    iso6393: 'kin',
    fixture:
      "Ikoraniro rusange lilibutsa ko: - Ugushyira ukizana, ituze n'ubutungane mu bihugu bishingiye ku karusho ka buli muntu, kadasibangana, gahamya icyubahiro akwiye n'agaciro twese duhulijeho, - Gusuzugura no kwirengagiza ako gaciro n'icyubahiro bya buli muntu nibyo byateye bamwe imigenzereze isa n'iy'inyamaswa, umutima w'umuntu utakwihanganira. Nicyogituma twemeza ko icyo umuntu wese yimilije imbere y'ibindi al'ugushyira akizana, nta nkomyi mu mvugo no mu bitekerezo, akibera aho nta nduru nta butindi, - Ali ngombwa ko hashingwa amategeko arengera ako gaciro ka buli muntu, akamulinda ubuja n'agahato, - Ikindi ngombwa nu gukomeza umubano w'ibihugu, - Ibihugu byunz'ubumwe byiyemeje muli Charte ya l'ONU kuzahora byubaha agaciro k'umuntu wese, yaba umugore yaba umugabo, bose niko bakwiye kwubahwa kimwe. Ibyo bihugu byiyemeje kandi kuzaharanira amajyambere mu mibanire m'imibereho y'abantu ku mudendezo, - Ibihugu byose byunz'ubumwe byarahiliye gufasha umuryango wa l'ONU kwubahisha hose agaciro n'"
  },
  zul: {
    iso6393: 'zul',
    fixture:
      'Ngokunjalo ukwamukelwa ngokuzuzwa kwesithunzi samalungelo alinganayo najwayelekile awowonke amalunga omndeni wesintu kuyisisekelo senkululeko, sobulungiswa noxolo emhlabeni, Ngokunjalo ukunganakwa nokwedelelwa kwamalungelo esintu kube nomphumela wezenzo zobuqaba eseziqede unembeza kubantu, kanye nomhlaba obhekwe isintu ukuba senamele inkululeko yokukhuluma nokukholwa, inkululeko yokungesabi futhi nokufuna kugunyazwe ugqozi kubobonke abantu, Ngokunjalo kudingekile, uma umuntu engenakuphoqwa ukulandela umgudu othize, njengendlela yokugcina, avukele ababusi nabacindezeli, ukuze amalungelo esintu avikelwe ngokubusa ngomthetho, Ngokunjalo kudingekile ukuba kwenyuswe ukuthuthukiswa kobungane nobudlelwane phakathi kwezizwe, Ngokunjalo abantu beNhlangano yeZizwe bayinqinisile inkolo yabo yengqalasizinda yamalungelo oluntu kuCharter, esithunzini nobuntu emalungelweni alinganayo abesilisa nabesifazane futhi bazimisele ukuqhubela phambili inqubekelaphambili yomphakathi namazinga angcono empilo en'
  },
  bul: {
    iso6393: 'bul',
    fixture:
      'Като взе предвид, че признаването на достойнството, присъщо на всички членове на човешкия род, на техните равни и неотменими права представлява основа на свободата, справедливостта и мира в света, Като взе предвид, че пренебрегването и неуважаването на правата на човека доведоха до варварски деяния, които потресоха съвестта на човечеството, и че създаването на един свят, в който хората ще се радват на свобода на словото и убежденията си и ще бъдат свободни от страх и лишения, бе провъзгласено за най‐съкровения стремеж на човека, Като взе предвид, че е необходимо правата на човека да бъдат закриляни от закона така, че човек да не бъде принуждаван да прибягва към бунт срещу тиранията и потисничеството, като последен изход, Като взе предвид, че е необходимо да се насърчава развитието на приятелски отношения между народите, Като взе предвид, че народите на Обединените нации потвърдиха в Устава своята вяра в основните права на човека, в достойнството и стойността на човешката личност, в рав'
  },
  swe: {
    iso6393: 'swe',
    fixture:
      'Enär erkännandet av det inneboende värdet hos alla medlemmar av människosläktet och av deras lika och oförytterliga rättigheter är grundvalen för frihet, rättvisa och fred i världen, enär ringaktning och förakt för de mänskliga rättigheterna lett till barbariska gärningar, som upprört mänsklighetens samvete, och enär skapandet av en värld, där människorna åtnjuta yttrandefrihet, trosfrihet samt frihet från fruktan och nöd, kungjorts som folkens högsta strävan, enär det är väsentligt för att icke människan skall tvingas att som en sista utväg tillgripa uppror mot tyranni och förtryck, att de mänskliga rättigheterna skyddas genom lagens överhöghet, enär det är väsentligt att främja utvecklandet av vänskapliga förbindelser mellan nationerna, enär Förenta Nationernas folk i stadgan ånyo uttryckt sin tro på de grundläggande mänskliga rättigheterna, den enskilda människans värdighet och värde samt männens och kvinnornas lika rättigheter, ävensom beslutat främja socialt framåtskridande och bä'
  },
  lin: {
    iso6393: 'lin',
    fixture:
      'Na botalaka ’te kondima limemya ya bato nyonso ya molongo pe makoki ma bango oyo ezali ndenge moko pe bakoki kopimela moto te ezali tina ya bonsomi, bosembo pe kimpa kati ya molongo. Na botalaka ’te komona pamba pe koboya kotosa esengeli ya moto ebatelama na bokonzi ya bosembo po te, na sima yango, moto akoma na botombiki esongo na minyokoli te, Na botalaka ’te esengeli kolendisa boyokani na kati ya bikolo, Na botalaka ’te na kati ya Mokanda ya Mibeko ya Lisanga ya Bikolo ya Molongo, bato ya molongo bayebisi lisusu lolenge bandimi maloki ya tina yo moto, limemya pe lokumu ya moto, bokokani ya makoki ya basi pe mibali pe na botalaka ’te bango bayebisi ’te bazwi mokano ya kobongisa ezaleli ya moto pe kosala ’te moto azwa bomoi malamu penza na kati ya bonsomi ya monene penza, Na botalaka ’te kozala bato nyonso na makanisi ndenge moko po na makoki pe bonsomi yango, ezali na tina monene po ’te oyo bakani elonga, LIKITA MONENE ezali koyebisa LISAKOLI YA MOLONGO OYO YA MAKOKI YA MOTO lokola e'
  },
  som: {
    iso6393: 'som',
    fixture:
      "Iyadoo aqoonsiga sharafta uu ku dhashay iyo xuquuqda maguurtada ah ee ay u siman-yihiin dadweynaha adduunku uu yahay saldhigga xorriyada, caddaaladda iyo nabadda dunida. Iyadoo aqoonsi la'aanta iyo ku tumashada xuquuqda aadanuhu ay ka dhasheen falal waxashtinimo ah oo shucuurta aadanuhu ka danqato iyo iyadoo gaaritaanka duni aadanaha ku nooli haystaan xornimo ay ku cabbiraan fikradahooda iyo waxay aaminsan yihiin iyo iyagoon qabin cabsi iyo baahi, laguna dhawaaqay inay tahay ujeedada ugu weyn ee uu dadku leeyahay. Iyadoo ay tahay lagama maarmaan in xuquuqda aadanuhu ay noqdaan kuwo sharcigu dhowro, si uusan qofku, ugu dambeynta, ugu baahan inuu xoog kaga soo horjeesto cadaadiska. Iyadoo ay tahay lagama maarmaan in sare loo qaado horumarinta xiriirka saaxiibtinimo ee ka dhexeeya Dowladaha. Iyadoo dadyowga dunidu ay ku caddeeyeen mar kale Dastuurka Qaramada Midoobay sida ay u aaminsan yihiin sharafta iyo qiimaha qofka aadamiga ah iyo sinnaata xuquuqda ragga iyo dumarka iyagoo goostay ina"
  },
  hms: {
    iso6393: 'hms',
    fixture:
      'Ad leb ghad bob did doub nend, leb leb seat mex zend yanl gaot nianb lib, zenx renb baob nend nis ad leb ghad bob did doub nend zib youl, zhenb yib gaot hol nbinl nangd jid cut. Jex zenx renb gaot wud miel renl njanl nangd sib nis yex manl nangd, leb leb sat jid nkiand mex ad leb max raot nangd, yanb senb ghob nhangb senb ghob nhangb nangd ghad bob did doub. Weib ghad mangs gangs doub nex nangd nex jex mex banb huat send hox chead mongl gaot zhenb fut jid beux jid dat, boub lies geud ful zhib lol baot hub renl njand. Lies gangs ghad bob did doub nangd guel giad jid khaob jid raot. Lianl hol guel dad ndub nangd yad yad nangd guel giad yit jind nib lianl hol guel xanb zhangd dad ndub jid pub guat jul,jid pud mix deib jid benx renl njanl, renl gel zend yanl, giab zid gaot ghaob mpad ghaob nit nangd nbinl denx njanl lib nangd xinb nianb, yeab jid pub mix lies jid zheax chud jid rut, gangs leb leb guat jid rut. Lianl hol guel dab ndub nangd guel giad jid pud jul, mix lies nhangs lianl hol g'
  },
  blu: {
    iso6393: 'hnj',
    fixture:
      'Haik zos duef ndax deb nenb houd juab tinx id cuat lenx cuat dol druax jangs muax nit zunb yinx tab nil buab zhit zangd zhit dongf nit ndas dos nit chenx renf, yaos ndax deb dax zis, hof ged tab hox pinx nit ghangb das deut; Haik zos duef nenb ndas dos nuaf zhit dluad muas tab qib dlangs qib dlend hlob hlangd dout uat shangb uat shud, dex uat shangb uat shud nad, muab ndax dex nenb nit liangx xinb shab nzhuk zhuak bual leuf; lb lob cuat lenx cuat dol sheuf muax nit ged haik fol suex shab, ged nzhes zit haib youx yol, zhit drous nchait zhit drous hef, zhit zhof chaib zhit zhof nkhek nit ndax deb yat lol zos, zhof ntuad haik uat ndax deb nenb nit zuef shab yinf vangf leuf; Haik zos wef zhit guas ndax deb nenb zhit doul del maof xind duef cangx baof zhenf zhif tab ghuab yuaf nzend shab nzend bleud, sheud bual uat shud, muax bix yaof guas nenb ndas dos sheuf ged jait ged lil baod fuf; Haik zos muax bix yaof ceub njet cuat lob gox juab ged mol ged lol zax nzhis nit hiob hlangd; Haik zos Jin'
  },
  ilo: {
    iso6393: 'ilo',
    fixture:
      'Idinto ta bigbigen iti naisigsigud a dayaw ken panagpapada ken ti di maipaidam nga kalintegan dagiti amin a puli tao nga batayan ti wayawaya, hustisya ken ikakapya ti lubong. Idinto ta iti saan nga panangi-kan-kano ken lalaisen dagiti kalinteganti tao nga nagbanag iti panagsupiat a maibusor iti konsensya ti sangkataw-an, ken iti idadateng iti meysa nga lubong a laklak-amen dagiti tao ti wayawaya a panagsao ken pammati ken awanen ti panagamak ken panagrigrigat nga inda nga inar-arapa-ap nga impakdaar dagiti kadawyan a tao. Idinto ta deytoy ti kangrunaan, tapno saan a mapilitan ti tao nga mangriribok a maibusor ti kinaulpit ken pannakaidadanes, masapul nga masalakniban babaen kadagiti annuroten ti linteg. Idinto ta deytoy ti kangrunaan tapno maiwanwan ti panag-giginnayem a nasayat dagiti amin nga pagilyan. Idinto ta dagiti umili kadagiti Nagkaykaysa nga Pagilyan ket pinasingkedanda iti Tsarter dagiti pammatida nga kalintegan madaydayaw ken panangipateg iti kinatao ken dagiti panagpapada '
  },
  kaz: {
    iso6393: 'kaz',
    fixture:
      'Адам баласы үйелменінің барлық мүшелеріне тән қадір‐қасиетін, құқықтарының теңдігі мен тартып алынбайтындығын тану, бостандық пен әділдіктің және жалпыға бірдей бейбітшіліктің негізі болып табылатынына назар аудара отырып, адам құқықтарына деген елемеушілік, менсінбеушілік адам баласы арының зығырданын қайнататын тағылық жағдайға әкеліп соғатынына және дүние жүзі адамдары сөз бен наным‐сенім бостандықтарына ие болып, үрей мен мұқтаждықтан ада бола алатын ортаны құру – адам баласының жоғары мәртебелі ұмтылысы деп жарияланғанына назар аудара отырып, адам баласы зорлық‐зомбылық пен қанауға қарсы көтеріліске мәжбүр болатын жағдайды тудырмау үшін, адам құқықтары заң билігімен қорғалуы керек екеніне назар аудара отырып, халықтар арасында достық қарым‐қатынастың дамуына жәрдемдесу керек екеніне назар аудара отырып, Біріккен Ұлттар елдері өз Жарғысында негізгі адам құқықтарына, жеке адам басының қадір‐қасиеті мен құндылығына және ерлер мен әйелдердің теңдігіне сенімдерін растап, әлеуметтік про'
  },
  uig_arab: {
    iso6393: 'uig',
    fixture:
      'ئىنسانلار ئائىلىسىنىڭ بارلىق ئەزالىرنىڭ ئۆزىگە خاس ئىززەت-ھۆرمىتىنى شۇنىڭدەك ئۇلارنىڭ باراۋەر ۋە تەۋرەنمەس ھوقۇقىنى ئەتراپ قىلىشنىڭ دۇنياۋى ئەركىنلىك، ھەققانىيەت ۋە تىنچلىقنىڭ ئاساسى ئىكەنلىكى، كىشىلىك ھوقۇقىغا ئېتىبارسىز قاراش ۋە ھاقارەت كەلتۈرۈش ئەۋج ئېلىپ كىشىلەرنىڭ ۋىجدانىنى بولغايدىغان ياۋۇز زوراۋانلىققا ئايلانغانلىقى، ھەممە ئادەم سۆز ئەركىنلىكى ۋە ئېتىقاد ئەركىنلىكىدىن بەھرىمەن بولىدىغان ھەمدە ۋەھىمە ۋە نامراتلىقتىن خالىي بولىدىغان دۇنيانىڭ يېتىپ كېلىشى ئاددىي خەلقنىڭ ئالىي ئارزۇسى دەپ ئېلان قىلىنغانلىقى، ئىنسانلانىڭ ئىلاجىسىزلىقتىن زوراۋانلىق ۋە زۇلۇم ئۈستىدە ئىسيان كۆتۈرىمىز دەپ تەۋەككۇلىگە ھەرىكەت قىلىپ يۇرمەسلىكى ئۈچۈن، كىشىلىك ھوقۇقىنى قانۇن ئارقىلىق ئىدارە قىلىش يولى بىلەن قوغداش زۆرۈر بولغانلىقى، دۆلەتلەر ئارا دوستلۇق مۈناسىۋىتىنىڭ تەرەققىياتىنى ئالغا سۈرۇش زۆرۈرلۇكى، بىرلەشكەن دۆلەتلەر تەشكىلارتىغا ئەزا دۆلەتلەر خەلقىنىڭ بىرلەشكەن دۆلەتلەر خارتىيىسىدە ئۆزلىنىڭ ئاساسي كىشىلىك ھوقۇقى، ئىسانىي ئىززەت-ھۆرمىتى ۋە قەدىر-قىممىتى شۇنىڭدەك ئەر-ئاياللارنىڭ باراۋەرلىك ھوقۇقى توغرىسى'
  },
  uig_latn: {
    iso6393: 'uig',
    fixture:
      "insanlar ailisining barliq ezalirining özige xas izzet-hörmitini shuningdek ularning barwer we tewrenmes hoquqini etrap qilishning dunyawi erkinlik, heqqaniyet we tinchliqning asasi ikenliki. kixilik hoquqigha étibarsiz qarash we haqaret kelturush ewj élip kixilerning wijdanini bulghaydighan yawuz zorawanliqqa aylan'ghanliqi, hemme adem söz erkinliki we étikad erkinlikidin behrimen bolidighan hemde wehime we namratliqtin xaliy bolidighan dunyaning yetip kélishi addiy xelqning aliy arzusi dep élan qilin'ghanliqi. insanlarning ilajisizliqtin zorawanliq we zulum ustide isyan köturimiz dep tewekkulige heriket qilip yurmesliki üchün, kishilik hoquqini qanun arqiliq idare qilish yoli bilen qoghdash zörür bolghanliqi, döletler ara dosttluq munasiwetning tereqqiyatini algha sürüsh zörürluki. birleshken döletler teshkilatigha eza döletler xelqining birleshken döletler xartiyiside özlirining asasiy kishilik hoquqi, insaniy izzet-hörmiti we qedir-qimmiti shuningdek er-ayallarning barawerlik hoquq"
  },
  hat_popular: {
    iso6393: 'hat',
    fixture:
      'Lè nou sonje ke desizyon rekonèt valè chak moun genyen nan li menm-menm kòm moun, desizyon rekonèt tout moun gen menm dwa egalego, dwa pèsonn pa ka wete nan men yo, desizyon sa a se veritab baz libète, veritab baz lajistis ak lapè sou tè a. Lè nou sonje ke inyorans ak mepri dwa moun, konn lakòz divès move zak sovaj, zak ki revolte konsyans mezi moun sou tè a, san nou pa bliye ke, pi gwo espwa nou kòm moun, sèke yon jou va rive lè chak kretyen-vivan va gen libète lapawòl, libète pou li gen konviksyon pèsonel li, yon jou lè tout moun va santi yo debarase ak lapèrèz ak lamizè sou tè a. Lè nou sonje nesesite pou gen yon seri règleman ki pou pwoteje dwa moun sou tè a, dekwa pou lèzòm pa toujou santi yo oblije pran lèzam pou delivre tèt yo anba chèf k ap kraze brize ak moun k ap fè abi. Lè nou sonje nesesite pou nou ankouraje tout nasyon tabli relasyon bon zanmitay antre yo. Lè nou sonje ke nan batistè Nasyonzini an menm, pèp peyi manm yo te retounen deklare ankò, ke yo gen lafwa nan dwa fon'
  },
  khm: {
    iso6393: 'khm',
    fixture:
      'ដោយយល់ឃើញថា ការទទួលស្គាល់សេចក្ដីថ្លៃថ្នូរជាប់ពីកំណើត និងសិទ្ធិស្មើភាពគ្នា និងសិទ្ធិមិនអាច លក់ ដូរ ផ្ទេរ ឬដកហូតបានរបស់សមាជិកទាំងអស់នៃគ្រួសារមនុស្ស គឺជាគ្រឹះនៃសេរីភាព យុត្ដិធម៌ និងសន្ដិភាពក្នុងពិភពលោក។ ដោយយល់ឃើញថា ការមិនទទួលស្គាល់ និងការប្រមាថមើលងាយសិទ្ធិមនុស្ស នាំឱ្យមានអំពើ ព្រៃផ្សៃសាហាវយង់ឃ្នង ធ្វើឱ្យក្ដៅក្រហាយដល់សតិសម្បជញ្ញៈមនុស្សជាតិ និងថា ការឈានដល់ពិភពលោកមួយ ដែលមនុស្សទាំងឡាយមានសេរីភាពក្នុងការនិយាយស្ដី និងជំនឿ និងភាពរួចផុតពីការភ័យ ខ្លាច និងទុគ៌តភាព ត្រូវបានប្រកាសថាជាសេចក្ដីប្រាថ្នាដ៏ខ្ពស់បំផុតរបស់មនុស្សទូទៅ។ ដោយយល់ឃើញថា ជាការចាំបាច់ ដែលសិទ្ធិមនុស្សត្រូវតែបានការពារដោយនីតិរដ្ឋ ដើម្បីជៀសវាងកុំឱ្យមនុស្សបង្ខំចិត្ដជាចុងក្រោយបង្អស់ បះបោរប្រឆាំងទល់នឹងអំណាចផ្ដាច់ការ និងការគាបសង្កត់។ ដោយយល់ឃើញថា ជាការចាំបាច់ ដែលត្រូវលើកស្ទួយការពង្រីកទំនាក់ទំនងជាមិត្ដភាព រវាង ប្រជាជាតិនានា។ ដោយយល់ឃើញថា ប្រជាជាតិទាំងឡាយនៃសហប្រជាជាតិ បានប្រកាសបញ្ជាក់សារជាថ្មីក្នុង ធម្មនុញ្ញសហប្រជាជាតិ នូវជំនឿរបស់ខ្លួនទៅលើសិទ្ធិមូលដ្ឋាននៃមនុស្ស លើសេចក្ដីថ្លៃថ្នូរ លើតម្លៃរបស់ មនុស្ស និងលើសមភាពនៃសិទ្ធិរវាងបុរសនិងស្ដ្រី ហើយប្ដេជ្ញាលើ'
  },
  pes_2: {
    iso6393: 'prs',
    fixture:
      'از آنجا که شناسائی حیثیت ذاتی کلیهٔ اعضای خانواده بشری و حقوق یکسان و انتقال ناپذیر آنان اساس آزادی و عدالت و صلح را در جهان تشکیل میدهد، از آنجا که عدم شناسائی و تحقیر حقوق بشر منجر به اعمال وحشیانه‌یی گردیده است که روح بشریت را به عصیان واداشته و ظهور دنیایی که در آن افراد بشر در بیان و عقیده آزاد و از ترس و فقر فارغ باشند بعنوان بالاترین آمال بشر اعلام شده است، از آنجا که اساساً حقوق انسانی را باید با اجرای قانون حمایت کرد تا بشر به عنوان آخرین علاج به قیام بر ضد ظلم و فشار مجبور نگردد، از آنجا که اساساً لازم است توسعه روابط دوستانه بین ملل را مورد تشویق قرار داد، از آنجا که مردم ملل متحد باور خود را بحقوق اساسی بشر و مقام و ارزش فرد انسانی و تساوی حقوق مرد و زن مجدداً در منشور اعلام کرده‌اند و تصمیم راسخ گرفته‌اند که به پیشرفت اجتماعی کمک کنند و در محیط آزاد وضع زندگی بهتری بوجود آورند، از آنجا که دول عضو متعهد شده‌اند که احترام جهانی و رعایت واقعی حقوق بشر و آزادیهای اساسی را با همکاری سازمان ملل متحد تأمین کنند، از آنجا که حسن تفاهم مشترک نسبت به این حقوق و آزادیها برای اجرای کا'
  },
  hil: {
    iso6393: 'hil',
    fixture:
      'Tungod kay ang pagkilala sang duna nga dungog kag ang alalangay kag di madula nga mga katarungan sang tanan nga lahi sang tao amo ang pundasyon sang kahilwayan, katarungan kag kalinong sang kalibutan. Tungod kay ang pagpabaya kag paghamak sa mga katarungang pangkataohan ngabunga sang mga kalapastangan nga labag sa konsyensya sang kataohan, kag ang pag-abot sang isa ka kalibutan nga maangkon sang mga tao ang kahilwayan sa paghambal kag pagsalig kag ang kaluwasan sa kahadlok kag kabudlayan nga ginpahayag ang pinakamataas nga handum sang kinaandan nga tao. Tungod kay ini isa ka malahalon, agod ang tao indi mapilitan nga magpamatok tuhoy sa kalupitan kag pagpigos, nga ang mga katarungang pangkataohan dapat amligan paagi sa kasuguan. Tungod kay pinakamalahalon nga pasanyugon ang paghanas sang malapit nga kaangtanan sang mga pungsod. Tungod kay ang mga pumuluyo sang Mga Naghiliusa nga Pungsod nagapamatuod sa ilang Karta sang ila pagtuo sa nagapanguna nga mga katarungang pangkataohan, sa dung'
  },
  sna: {
    iso6393: 'sna',
    fixture:
      'Sezvo kucherechedza hunhu nekodzero yakayenzana yomunhu wese pasi pose iriyo mviromviro yomutongero uri pachokwadi norunyararo panyika. Sezvo kusatevera nekusvora kodzero dzevanhu zvakamboita kuti kuve noutsinye hwakarwadza pfungwa dzevanhu pasi pose, nokuuya kwenyika inevanhu vachafadzwa norusununguko nokutaura zvavanoda zvakapikirwa sezvinangwa zvinodiwa kuvanhu vese vese. Sezvo chiri chinhu chinokosha, kana munhu asingazomanikidzirwa kuita somukana wokupedzisira, kupandukira hutongi hwakaipa kana hudzvanyiriri, kuti, kodzero dzevanhu dzichengetedzwe nohutongi hwomutemo. Sezvo vanhu vese veMubatanidzwa weNyika, muchisununguko ichi, varatidzazve chitendero chavo mukodzero dzavanhu dzinokosha, uyewo muhunhu nohukoshi homunhu wega wega, munezvekodzero yakayenzana yavanhurume navanhukadzi, zvekare vazvishingisa kukurudzira budiriro mumagariro nokusimudzirwa kohupenyu huri nani murusununguko rwunokosha rwakawedzerwa. Sezvo kunzwisisa pamwechete kodzero idzi norusununguko zvichikosha zvaka'
  },
  tat: {
    iso6393: 'tat',
    fixture:
      'Кешелек гаиләсенең бөтен әгъзаларына хас булган тигез һәм аерылгысыз хокукларны һәм кеше дәрәҗәсен тануның гаделлек һәм гомуни тынычлыкның нигезе икәнең истә тотып, кеше хокукларына кимсетеп һәм җирәнеп каруның вәхшилеккә китерүен, кешелек намусын уятуын, кешеләрнең үз карашларына һәм сүз ирегенә ия булган, куркудан, мохтаҗлыктан азат булган тормыш тозүнең кешеләрнең боск омтылышы икәнең игълан итүне истә тотып, җәберләүгә һәм изслүгә каршы соңгы чара итен кеше баш күтәрергә меҗбүр булмасын өчен аның хокукларын закон коче белән саклау зарурлыгын истә тотып, Кешенең төп хокукларына, шәхеснең абруена һәм кыйммәтенә, хатын кызларның һәм ирләрнең тигез хокуклылыгына, Берләшкән Милләтләр халыклары үзләренең ышанычын Уставта раславын һәм тагын да зуррак иреккә ирешеп, иҗтумагый үсешкә, тормыш шартларын яхшыртуга ярдәм итәргә ниятләвен истә тотып, Берләшкен Милләтләр Оешмасы әгъзасы булган дәүләтләрнең кеше хокукларын, төп ирекләрне уртак хөрмәт итүдә һәм саклауда булышлык күрсәтүне үз бурычл'
  },
  xho: {
    iso6393: 'xho',
    fixture:
      'Njengoko iimfanelo zesidima soluntu semvelo kunye neemfanelo zoluntu‐jikelele olungenakunikelwa olusisisekelo senkululeko, ubulungisa noxolo emhlabeni. Njengoko ukungananzi nokudelelwa kweemfanelo zoluntu ezingunobangela weziphumo zobukrwada ezithi zibangele ingcwangu kwisazela soluntu, kunye nesiqalo nokufika kwelizwe apho uluntu luza kuxhamla ukuthetha ngokukhululekileyo, inkolo nenkululeko engenaloyiko kunye neemfuno ezazisiweyo njengeminqweno yoluntu‐jikelele. Kwananjalo kubalulekile ke ngoko, ukuba umntu anganyanzeliswa ukufumana uncedo, okwetyeli lokugqibela, ukuchasa ubundlobongela nengcindezelo, kuba iimfanelo zesidima sobuntu mazikhuselwe ngolawulo lomthetho. Njengokuba kubalulekile ukukhuthaza kokwandiswa kobuhlobo nemvisiswano phakathi kwezizwe. Njengoko uluntu Lwezizwe Ezimanyeneyo luthe lwaqinisekisa kukubaluleka kweemfanelo zesidima soluntu, oku kuxabiseka kwesidima nokuxabiseka koluntu nakwiimfanelo zamadoda namakhosikazi, bathe bazimisela ukukhuthaza inkqubela yezentlal'
  },
  hye: {
    iso6393: 'hye',
    fixture:
      'Քանզի մարդկային ընտանիքի բոլոր անդամներին ներհատուկ արժանապատվությունը և հավասար ու անօտարելի իրավունքները աշխարհի ազատության, արդարության ու խաղաղության հիմքն են․ Քանզի մարդու իրավունքների նկատմամբ քամահրանքն ու արհամարհանքը հանգեցրել են մարդկության խիղճը խռոված բարբարոսական գործողությունների, և քանի որ այնպիսի աշխարհի ստեղծումը, ուր մարդիկ կվայելեն խոսքի ու համոզմունքների ազատություն և զերծ կլինեն վախից ու կարիքից հռչակվել է որպես մարդկանց բարձրագույն ձգտում․ Քանզի անհրաժեշտ է, որպեսզի մարդը, որպես մի վերջին միջոցի, չդիմի ապստամբության ընդդեմ բռնության ու ճնշման, օրենքի իշխանությամբ պաշտպանել մարդու իրավունքները․ Քանզի անհրաժեշտ է նպաստել ազգերի միջև բարեկամական հարաբերությունների զարգացմանը․ Քանզի Միավորված ազգերի ժողովուրդները կանոնադրության մեջ վերահավաստել են իրենց հավատը մարդու հիմնական իրավունքների, անձի արժանապատվության ու արժեքի, տղամարդու ու կնոջ հավասար իրավունքների նկատմամբ և որոշել են ավելի մեծ ազատության պայմաններում նպաստել սոցիալական առաջընթացին ու կյանքի պայմանների բա'
  },
  min: {
    iso6393: 'min',
    fixture:
      'Sasungguahnyo pangakuan taradok martabat dasar dan hak-hak nan samo sarato mutlak dari tiok anggota kaluarga manusia adolah landasan dari kamardekaan, kaadilan dan pardamaian di dunia; Sasungguahnyo sikap tak paduli dan malecehkan hak-hak asasi manusia tabukti mangakibatkan parilaku biadab nan sangat malukoi nurani umat manusia, dan alah dicanangkannyo suatu dunia di ma tiok urang dapek manikmati kabebasan manyampaikan pandapek, bakayakinan, dan kabebasan dari raso takuik dan dari kakurangan, sabagai cito-cito paliang tinggi dari sadonyo urang; Sasungguahnyo supayo urang indak tapaso mamiliah barontak sabagai usaho pangabisan untuak manantang kazaliman dan panindasan, Hak-hak Asasi Manusia paralu dijamin malalui tartib hukum; Sasungguahnyo paralu bana mamajukan pangambangan hubuangan basahabat di antaro banso-banso di dunia; Sasungguahnyo dalam Piagam Perserikatan Bangsa-Bangsa sadonyo anggota alah mangukuahkan baliak kayakinan taradok hak-hak asasi manusia nan mandasar, taradok martab'
  },
  afr: {
    iso6393: 'afr',
    fixture:
      'AANGESIEN erkenning vir die inherente waardigheid en die gelyke en onvervreembare reg van alle lede van die menslike ras die basis vir vryheid, geregtigheid en vrede in die wereld is; AANGESIEN minagting vir menseregte barbaarse dade wat die gewete van die mens aangetas het en die aanvang van ’n wereld waarin mense vryheid van spraak, geloof, vrees en behoefte het, gesien word as die hoogste aspirasie van die gemiddelde mens; AANGESIEN dit noodsaaklik is dat menseregte deur die wet beskerm word ten einde te voorkom dat mense nie gedwing gaan word om in opstand teen tirannie en onderdrukking te kom nie; AANGESIEN dit noodsaaklik is om die ontwikkeling van vriendelike bande tussen nasies aan te moedig; AANGESIEN die volke wat lid van die Verenigde Volke Organisasie is, hul geloof in fundamentele menseregte in die Handves beklemtoon, in die waardigheid en waarde van die menslike persoon, in die gelyke regte van mans en vrouens en dit ten doel het om sosiale vooruitgang en ’n beter lewensp'
  },
  lua: {
    iso6393: 'lua',
    fixture:
      'Pa kumona ne, kwitaba se bantu bonsu ba pa buloba badi ne buneme ne makokeshi amwe ne a kashidi ke nshindamenu wa budikadidi, bwakane ne bupole pa buloba bujima; Pa kumona ne, dibenga kumanya ne dipepeja dya makokeshi a muntu bidi bifikisha ku ngenzelu mishadile idi mwa kunyengabaja myoyi ya munda ya bantu; pa kumona ne kufikisha bantu ku nsombelu udibo mwa kwikala bakula ne biitaba cidibo baswe, kabayi ne bowa anyi lutatu ke kiipacila kanene ka muntu yonso; Pa kumona ne bidi bikengela kwenza mikenji idi mwa kukuba makokeshi a muntu yonsu ne kubenga kufikisha bantu ku ditombokela dya bukalenge bwa cinyangu ne bushipyanganyi, Pa kumona ne matunga a Nsangila wa Buka-bisamba (ONU) adi mashindike ditaba dyawu mu makokeshi mashindame ne mushinga wa muntu yonso mu bobumwe bwa makokeshi a balume ne bakaji, mu dyangata mapangadika a kutungunuja nombelu mulenga wa bantu mu budikadidi; Pa kumona ne ditunga ne ditunga dyonsu, pamwe ne Nsangilu wa Bukwa-bisamba mbangate maangadika a kunemeka ne kw'
  },
  sat: {
    iso6393: 'sat',
    fixture: 'ᱫᱟ᱕ ᱨᱮᱡ ᱜᱚᱫ'
  },
  bod: {
    iso6393: 'bod',
    fixture:
      '༈ འགྲོ་བ་མིའི་ཁྱིམ་ཚང་ཁག་གི་ནང་མི་ཡོངས་ལ་རང་བཞིན་ཉིད་ནས་ཡོད་པའི་ཆེ་མཐོངས་དང་འདྲ་མཉམ། སུས་ཀྱང་འཕྲོག་ཏུ་མི་རུང་བའི་ཐོབ་ཐང་བཅས་ཀྱི་གནད་དོན་རྟོགས པར་བྱེད་པ་ནི། འཛམ་གླིང་ནང་གི་རང་དབང་དང༌། དྲང་བདེན། ཞི་བདེ་བཅས་ཀྱི་རྣང་གཞི་ལྟེ་བ་ཡིན། འགྲོ་བ་མིའི་ཐོབ་ཐང་ལ་སྣང་ཆུང་ཁྱད་གསོད་དང༌། དམའ་འབེབས་བྱས་པ་ལ་བརྟེན་ནས་ཀླ་ཀློའི་བྱེད་སྟངས་ཤིག་བྱུང་ཡོད་པ་སྟེ། དེ་ནི་མིའི་རིགས་ཀྱི་བསམ་ཚུལ་བཟང་པོ་དང་མི་མཐུན་པའི་གནས་ཚུལ་ཞིག་བྱུང་བ་རེད།འགྲོ་བ་མིའི་རིགས་ལ་གཏམ་བརྗོད་དང༌། དད་མོས་ཀྱི་རང་དབང་སྐུང་སྐྱོབ། དགོས་མཁོ་སྒྲུབ་པའི་རང་དབང་བཅས་ལ་ལོངས་སུ་སྤྱད་ཆོག་པའི་འཛམ་གླིང་ཞིག་འབྱུང་ཐབས་དེ་ནི་སྤྱིར་བཏང་མི་མང་ཡོངས་ཀྱི་རེ་འདོད་ཆེ་ཤོས་ཤིག་ཏུ་ངེས་པ་རྒྱ་ཁྱབ་ཡོངས་སུ་གྲགས་པ་ཡིན། སྐྱེ་བོ་དག་གིས་འུ་ཐུག་ཐབས་ཟད་ཀྱིས་རྐྱེན་པས་བཙན་དབང་དང༌། གཉའ་གནོན་ལ་ངོ་རྒོལ་སྒེར་ལངས་བྱེད་པའི་མཐའ་མའི་བྱ་ཐབས་ལག་བསྟར་མི་དགོས་པ་ཞིག་བྱེད་ན། དེ་ནི་ཁྲིམས་ལུགས་དྲང་འཛིན་གྱི་སྒོ་ནས་འགྲོ་བ་མིའི་ཐོབ་ཐང་ལ་སྲུང་བརྩི་བྱེད་པ་དེ་རང་གལ་གནད་ཆེ་བ་ཡིན། རྒྱལ་ཁབ་ཁག་གི་དབར་མཛའ་མཐུན་གྱི་འབྲེལ་བ་ཡར་རྒྱས་གོང་འཕེལ་གཏོང་རྒྱུར་འབད་བརྩོན་ཆེ་བསྐྱེད་དགོས་པ་དེ་ནི་ཧ་ཅང་གལ་གནད་ཆེ་བ་ཞིག་ཡིན། མཉ'
  },
  tir: {
    iso6393: 'tir',
    fixture:
      'ኦብ ዓለም ንናይ ኩሎም ሰባት ተፈጥሮኦዊ ክብሪትን ንማዕሪን ዘይገሃሱን ሰብኦዊ መሰላትን ምቕባል መሰሪት ነፃነት፣ ፍትሕን ሰላምን ስለ ዝኾነ፣ ንሰብኦዊ መሰላት ኦብ ግምት ዘይምእታውን ምጥሓስን ንሕልና ወዲ ሰብ ዘቑሰለን ኦሪሜናዊ ተግባራት ዘስዓበን ምዃኑ ፣ ናይ ዘሪባን እምነትን ነፃነት ዘለዋ፣ ካብ ፍርሕን ፀገምን ነፃ ዝኾነት ዓለም ንክትህልው ዝለዓለ ትምኒት ደቂ ሰባት ምዃኑ ስለ ዝተኦምነሉ፣ ወዲ ሰብ ምልኪን ወፅዓን ንምውጋድ ሓይሊ ንክጥቀም ምእንቲ ከይግደድ ሰብኦዊ መሰላት ብሕጊ ክኽበሩ ኦድላዪ ስለዝኾነ፣ ኦብ መንጎ ሃገራት ምሕዝነታዊ ዝምድናታት ንኽዓቢ ምሕጋዝ ኦድላዪ ስለዝኾነ፣ ህዝብታት ውድብ ሕቡራት መንግስታት ኦብ ቻርተር ውድብ ሕቡራት መንግስታት ንመሰሪታዊ ሰብኦዊ መሰላት፣ ንኽብርን ልዕልነትን ሰብኦዊ ፍጡር፣ ንማዕሪ መሰላት ደቂ ተባዕትዮን ደቂ ኦንስትዮን ዘለዎም እምነት ብምርግጋፆምን ኦብ ዝሰፍሐ ነፃነት ከዓ ማሕበራዊ ምዕባለን ዝሐሸ ደሪጃ መነባብሮን ንምዝርጋሕ ዝወሰኑን ስለዝኾነ፣ ኦባል መንግስታት ምስ ውድብ ሕቡራት መንግስታት ብምትሕግጋዝ ሰብኦዊ መሰላትን መሰሪታዊ ነፃነታትን ዓለምለኻዊ ጠመተን ሓለዋን ምእንቲ ክሪኽቡ ንምፅዓር ዝጠልቡ ስለዝኾነ፣ እዚ ጠለብ’ዚ መሊኡ ንክሪጋገፅ ብዛዕባ እዞም መሰላትን ነፃነታትን እዚኦቶም ሓባራዊ ግንዛበ ምሓዝ ብጣዕሚ ኦድላዪ ስለዝኾነ፣ ስለዚ ሓፈሻዊ ጉባኤ ውድብ ሕቡራት መንግስታት ኩሎም ህዝብታትን ኩሎም ሃገራትን ክሳብ ሕድሕድ ውልቀሰብን ክሳብ ሕድሕድ ክፍሊ ማሕበሪጠ ሰብን ነዚ ድንጋገ እዚ ኩሉ ጊዜ ብምዝካር እዞም መሰላት እዚኦቶም ኦኽብሮት ንክሪኽቡ ብምስትምሃርን ብትምህርትን ንክፅዕሩ፣ ከምኡ’ውን ብሃገራውን ዓለምለኻውን ማዕበልቲ ስጉምቲታት፡ ኦብ ህዝብታት ኦባል ሃገራትን ኦብ ግዝኦቶም ኦብ ዘለዉ ህዝብታትን ሓ'
  },
  fin: {
    iso6393: 'fin',
    fixture:
      'Kun ihmiskunnan kaikkien jäsenten luonnollisen arvon ja heidän yhtäläisten ja luovuttamattomien oikeuksiensa tunnustaminen on vapauden, oikeudenmukaisuuden ja rauhan perustana maailmassa, kun ihmisoikeuksia on väheksytty tai ne on jätetty huomiota vaille, on tapahtunut raakalaistekoja, jotka ovat järkyttäneet ihmiskunnan omaatuntoa, ja kun kansojen korkeimmaksi päämääräksi on julistettu sellaisen maailman luominen, missä ihmiset voivat vapaasti nauttia sanan ja uskon vapautta sekä elää vapaina pelosta ja puutteesta, kun on välttämätöntä, että ihmisoikeudet turvataan oikeusjärjestyksellä, jotta ihmisten ei olisi pakko viimeisenä keinona nousta kapinaan pakkovaltaa ja sortoa vastaan, kun on tähdellistä edistää ystävällisten suhteiden kehittymistä kansojen välille, kun Yhdistyneiden Kansakuntien kansat ovat peruskirjassa vahvistaneet uskonsa ihmisten perusoikeuksiin, ihmisyksilön arvoon ja merkitykseen sekä miesten ja naisten yhtäläisiin oikeuksiin ja kun ne ovat ilmaisseet vakaan tahtons'
  },
  slk: {
    iso6393: 'slk',
    fixture:
      'Vo vedomí že uznanie prirodzenej dôstojnosti a rovnych a neodcudzite ľných práv členov ľudskej rodiny je základom slobody, spravodlivosti a mieru na svete, že zneuznanie ľudských práv a pohrdanie nimi viedlo k barbarským činom, ktoré urážajú svedomie ľudstva, a že vybudovanie sveta, v ktorom ľudia, zbavení strachu a núdze, budú sa tešiť slobode prejavu a presvedčenia, bolo vyhlásené za najvyšší cieľ ľudu, že je nutné, aby sa ľudsk práva chránily zákonom, ak nemá byť človek donúteý uchýliť sa, keď všetko ostatné zlyhalo, k odboju proti tyranii a útlaku, že je nutné podporovať rozvoj priateľských vzťahov medzi národmi, že ľud Spojených národov zdoraznil v Charte znovu svoju vieru v základné ľudské práva, v dostojnosť a hodnotu ľudskej osobnosti, v rovnaké práva mužov a žien a že sa rozhodol podporovať sociálny pokrok a vytvoriť lepšie životné podmienky za vačšej slobody, že členské štáty prevzaly závazok zaistiť v spolupráci s Organizáciou Spojeých národov všeobecné uznávanie a zachováva'
  },
  tuk_cyrl: {
    iso6393: 'tuk',
    fixture:
      'Баш ассемблея әхлиумумы парахатчылыгың, адалатлылыгың ве азатлыгың эсасы болуп дурян адамзат машгаласының агзаларының хеммесине махсус болан мертебесини, дең дереҗели ве айрылмаян хукукларыны гөз өңүнде тутуп, адам хукукларына болан әсгермезлик этмегиң ве йигренҗиң адамзадың выҗданыны гахар‐газаба мүндүрйән вагшычылыклы херекете гетирмеклигини ве адамларың бейик ниетиниң ыглан эдиши ялы адамлар сөз ве пикир азатлыгына эе болуп, горкудан ве мәтәчликден азат болуп яшар ялы дүнйәни гурмаклыгы гөз өңүнде тутуп, адам өзүниң иң соңкы серишдеси хөкмүнде залымлыга ве эзъет бермә гаршы сөвеше галмага меҗбур болмазлыгыны үпҗүн эдер ялы адам хукукларыны кануның гүйҗүниң горамалыдыгыны гөз өңүнде тутуп, Бирлешен Миллетлер Гурамасы өз Уставында адамың эсасы хукукларына, адамзат шахсыетиниң гымматына ве мертебесине, ве эркеклер билен аялларың дең хукугына болан ынамыны ыкрар этмегини ве гиңишлейин азатлыкда дурмуш шертлериниң говуланмагына ве социал өсүше ярдам этмек барадакы карарыны гөз өңүнде тут'
  },
  tuk_latn: {
    iso6393: 'tuk',
    fixture:
      'Adamzat kowmunyň agzalaryna deň derejede degişli mertebäniň we olaryň deň we aýrylmaz hukuklarynyň ykrar edilmeginiň azatlygyň, adalatyň hem‐de ählumumy dynçlygyň esasy bolup durýandygyny göz öňünde tutup; we Adam hukuklarynyň äsgerilmezliginiň we ýigrenilmeginiň adamzat ynsabyny haýykdyrýan wagşyçylyk aktlaryna getirendigini hem‐de adamlaryň söz we wyždan azatlygyna ýe we gorkudyr mätäçlikden azat boljak dünýäsiniň döredilmeginiň adamlaryň belent ymtylyşy diýlip yglan edilendigini göz öňünde tutup; we Zulmuň we sütemiň garşysyna iň soňky serişde hökmünde adamynyň gozgalaňa baş götermek zerurlygyny aradan aýyrmak maksady bilen adam hukuklarynyň kanunyň häkimligi tarapyndan goralmagyny göz öňünde tutup; we Halklaryň arasyndaky dostlukly gatnaşyklaryň ösmegine ýardam etmek zerurlygyny göz öňünde tutup; we Birleşen Milletleriň halklarynyň esasy adam hukuklaryna, adam şahsyýetiniň mertebesine we gymmatyna, erkegiňdir aýalyň deňhukuklylygyna öz ynamlaryny Düzgünnamada tassyklandyklaryny we '
  },
  dan: {
    iso6393: 'dan',
    fixture:
      'Da anerkendelse af den mennesket iboende værdighed og af de lige og ufortabelige rettigheder for alle medlemmer af den menneskelige familie er grundlaget for frihed, retfærdighed og fred i verden, da tilsidesættelse af og foragt for menneskerettighederne har ført til barbariske handlinger, der har oprørt menneskehedens samvittighed, og da skabelsen af en verden, hvor menneskene nyder tale- og trosfrihed og frihed for frygt og nød, er blevet forkyndt som folkenes højeste mål, da det er af afgørende betydning, at menneskerettighederne beskyttes af loven, hvis ikke mennesket som en sidste udvej skal tvinges til at gøre oprør mod tyranni og undertrykkelse, da det er af afgørende betydning at fremme udviklingen af venskabelige forhold mellem nationerne, da De forenede Nationers folk i pagten påny har bekræftet deres tro på fundamentale menneskerettigheder, på menneskets værdighed og værd og på lige rettigheder for mænd og kvinder, og har besluttet at fremme sociale fremskridt og højne levev'
  },
  nob: {
    iso6393: 'nob',
    fixture:
      'Da anerkjennelsen av menneskeverd og like og umistelige rettigheter for alle medlemmer av menneskeslekten er grunnlaget for frihet, rettferdighet og fred i verden, da tilsidesettelse av og forakt for menneskerettighetene har ført til barbariske handlinger som har rystet menneskehetens samvittighet, og da framveksten av en verden hvor menneskene har tale- og trosfrihet og frihet fra frykt og nød, er blitt kunngjort som folkenes høyeste mål, da det er nødvendig at menneskerettighetene blir beskyttet av loven for at menneskene ikke skal tvinges til som siste utvei å gjøre opprør mot tyranni og undertrykkelse, da det er viktig å fremme utviklingen av vennskapelige forhold mellom nasjonene, da De Forente Nasjoners folk i Pakten på ny har bekreftet sin tro på grunnleggende menneskerettigheter, på menneskeverd og på like rett for menn og kvinner og har besluttet å arbeide for sosialt framskritt og bedre levevilkår under større Frihet, da medlemsstatene har forpliktet seg til i samarbeid med D'
  },
  suk: {
    iso6393: 'suk',
    fixture:
      'GUNGUNO yimanyikile giki ikujo lya ng’wa munhu na sekge ya banhu muwelelo hu shili jandije ja wiyabi, sekge na mhola ya welelo, GUNGUNO ubudalahi bo sekge ya banhu hi jile jandije ja shitwa ja bubi ha welelo, na giki yigubiho welelo iyo banhu bakwiyagalula na wiyabi bo guhaya na guzunya na gubiza badi na boba bosebose hangi, hu wisagiji bo ng’hana. GUNGUNO idakililwe sekge ya banhu ilang’hanwe na butongeji bo jilagilo ja nsi huna buluhiwa na wibonelwa butizubizaho na gwenheleja banhu kulema na kubagalukila batongeji ba nsi. GUNGUNO idakililwe kubeja bunwani bo nsi na nsi. GUNGUNO L’Ibilinga lya Mahanga lyamala gubitya ng’w ihane lyalyo buzunya bo sekge, ngw’ikujo na nsolobo ya banhu ba buli mbika bakima na bagosha na lyalamula gwenha mhandika nhale ya budula bo kigasije ka banhu mu wiyabi butale. GUNGUNO nsi ja mahanga jizunilija jihamo na ng’wibilingo gwa Mahanga gwenha ikujo, sekge ya banhu na wiyabi mu welelo. GUNGUNO ukujimana sekge nu wiyabi bo banhu shili shinhu sha solobo nhale '
  },
  als: {
    iso6393: 'als',
    fixture:
      "Mbasi njohja e dinjitetit të lindur të të drejtave të barabarta dhe të patjetërsueshme të të gjithë anëtarëve të familjes njerëzore është themeli i lirisë, drejtësisë dhe paqes në botë; mbasi mosrespektimi dhe përbuzja e të drejtave të njeriut ka çuar drejt akteve barbare, të cilat kanë ofenduar ndërgjegjen e njerëzimit, dhe mbasi krijimi i botës në të cilën njerëzit do të gëzojnë lirinë e fjalës, të besimit dhe lirinë nga frika e skamja është proklamuar si dëshira më e lartë e çdo njeriu; mbasi është e nevojshme që të drejtat e njeriut të mbrohen me dispozita juridike, kështu që njeriu të mos jetë i shtrënguar që në pikën e fundit t'i përvishet kryengritjes kundër tiranisë dhe shtypjes; mbasi është e nevojshme që të nxitet zhvillimi i marrëdhënieve miqësore midis kombeve; mbasi popujt e Kombeve të Bashkuara vërtetuan përsëri në Kartë besimin e tyre në të drejtat themelore të njeriut, në dinjitetin dhe vlerën e personit të njeriut dhe barazinë midis burrave dhe grave dhe mbasi vendosën"
  },
  sag: {
    iso6393: 'sag',
    fixture:
      'Na hïngängö bîanî atene nëngö terê tî zo na lïngbïngö terê tî ângangü tî lo laâ sï ayeke na gündâ tî zarä , tî nzönî ngbanga na tî sîrîrî na ndö tî dûnîa, Na hïngängö nî pëpëe na këngö ândiä tî bata nëngö terë tî zo laâ adü kpälë tî birä sô abi ngonzo na bê tî âhalëzo, ngâ sï gängö tî mbênî finî ködörö sô âhalëzo kûe alîngbi tî tene tënë tî bê tî âla, tî mäbê tî âla afa nî töngana taâ kötä bêkü tî âzo tî ndö tî gïgî, Ayeke kötä yê mîngi tî tene azî lë na ndö tî ândiä tî bata nëngö terê tî zo gï na lëngö mbênî gerê tî ndiä ndâli tî sïönî sêgbïä na lëngö pâsi, Na hïngängö nî atene ayeke kötä yê mîngi tî mû ngangü na mäïngö tî lëngö söngö na pöpö tî ködörö ndê ndê, Na hïngängö nî atene na yâ tî sêndiä halëzo tî bêndo tî gïgî afa tî finî nî mäbê tî âla na âtaâ ndiä tî zo , na nëngö terë ngâ na kötä tî zo na lïngbïngö terê tî ângangü tî kôlï na wâlï, sï âla atene ânï yeke sâra ngangü kûê tî mäïngö tî sêdutï tî zo na lëngö ânzönî lêgë tî dutï na yâ tî mbênî kötä zarä , Na hïngängö nî atene â'
  },
  nno: {
    iso6393: 'nno',
    fixture:
      'Då det å godkjenne det naturlege menneskeverdet med like og umissande rettar for alle menneske på jorda er grunnlaget for fridom, rettferd og fred i verda, og då hån og vørdsløyse mot menneskerettane har ført til barbariske handlingar som har skaka samvitet til menneskeretta, er framvoksteren i den verda der menneska skal ha talefridom og trusfridom og vere løyste frå otte og naud, kunngjord som det høgste målet for kvart menneske, og då det er nødvendig at menneskerettane blir verna om av lover slik at menneska ikkje blir tvinga til å finne den siste utvegen i å gjere opprør mot tyranni og trælekår, og då det er nødvendig å arbeide for betre tilhøve mellom nasjonane, og då folka i Dei Sameinte Nasjonane har stadfest trua si i denne pakta, på grunnleggjande menneskerettar, på menneskeverd og på same rett for mann og kvinne, og har vedteke å arbeide for sosiale framsteg og betre levevilkår i større fridom, og då medlemsstatane har bunde seg til å fremje allmenn vørdnad for pakta og hald'
  },
  heb: {
    iso6393: 'heb',
    fixture:
      'הואיל והכרה בכבוד הטבעי אשר לכל בני משפחת האדם ובזכויותיהם השוות והבלתי נפקעות הוא יסוד החופש, הצדק והשלום בעולם. הואיל והזלזול בזכויות האדם וביזוין הבשילו מעשים פראיים שפגעו קשה במצפונה של האנושות; ובנין עולם, שבו ייהנו כל יצורי אנוש מחירות הדיבור והאמונה ומן החירות מפחד וממחסור, הוכרז כראש שאיפותיו של כל אדם. הואיל והכרח חיוני הוא שזכויות האדם תהיינה מוגנות בכוח שלטונו של החוק, שלא יהא האדם אנוס, כמפלט אחרון, להשליך את יהבו על מרידה בעריצות ובדיכוי. הואיל והכרח חיוני הוא לקדם את התפתחותם של יחסי ידידות בין האומות. הואיל והעמים המאוגדים בארגון האומות המאוחדות חזרו ואישרו במגילה את אמונתם בזכויות היסוד של האדם, בכבודה ובערכה של אישיותו ובזכות שווה לגבר ולאשה; ומנוי וגמור אתם לסייע לקדמה חברתית ולהעלאת רמת החיים בתוך יתר חירות. הואיל והמדינות החברות התחייבו לפעול, בשיתוף עם ארגון האומות המאוחדות, לטיפול יחס כבוד כללי אל זכויות האדם ואל חירויות היסוד והקפדה על קיומן. הואיל והבנה משותפת במהותן של זכויות וחירויות אלה הוא תנאי חשוב לקיומה השלם של התחייבות זו. לפיכך מכריזה העצרת באזני כל באי'
  },
  mos: {
    iso6393: 'mos',
    fixture:
      'B wilgame tɩ ninsaal bʊʊd fãa tara a burkĩndlim la a yel-segdɩ tõod sẽn pa yɩɩd a to, tɩ b pa tõen n dɩk tõod-bãmb n koos bɩ n tek a badawã, n yaa dũni wã bãan gãaga, ned fãa sẽn so a vɩɩm tɩ yembd kaala, la wẽg-taab kaalem dũni wã pʊgẽ yẽgrã. B wilgame tɩ ninsaal sẽn da tog ne yel-segdɩ ninsã kaalmã waa ne bi-beelem la pãng buud toor-toor sẽn sãam dũni wã zãng sũuri, la b yãkamen moon tɩ dũni ning sẽn na n wa zĩnd-a tɩ ninsaalbã na n wa so b mense, n tõe n gom b sẽn date, n tẽ b sẽn date, n wa yi rabeem, yaeesg la far buudã fãa pʊgẽ wã, n yaa ninsaal sẽn baood ne a sũur fãa n yɩɩdã. Tɩ sẽn yɩɩd fãa yaa tɩ ninsaal yel-segdɩ wã tog n paamame tɩ b koglg-b ne noy buud sẽn na yɩl tɩ ned ra wa bao a sẽn na maan n põs pãn-wõrdem b sẽn maand-a n kong n wẽneg n kẽ wẽnem maan n lebs pʊgẽ wã. D sẽn mi tɩ segdame tɩ d keng tẽms ne taab zood yõkr zĩndgrã. D sẽn mi tɩ nasõzini (tẽmsã fãa lagem-n-taar kãsengã) le mooname n wilg b tẽeb ninsaal burkĩndlem la a tɩrlem pãnga, p'
  },
  tgk: {
    iso6393: 'tgk',
    fixture:
      'Бо дарназардошти ин, ки этирофи қадру қимат ба ҳамаи аҳли башар хос буда, ҳуқуқи баробар ва дахлнопазири онҳо асоси озодӣ, адолат ва сулҳи умум аст; бо дарназардошти ин, ки таҳкиру беэътиноӣ ба ҳуқуқи башар боиси сурат гирифтани аъмоли ваҳшиёнае гардидааст, ки виҷдони башариятро сахт озурда мегардонад ва эҷоди чунин дунёе, ки дар он одамон дар сухан ва ақида озод ва аз тарсу эҳтиёҷ фориғ бошанд, ҳамчун волотарин орзуи одамон эълон гардидааст; бо дарназардошти ин, ки ҳуқуқи башар бояд бо хукми қонун ҳимоят карда шавад, то башар ҳамчун охирин илоҷ ба қиёми зидди зулму истибдод маҷбуп нагардад; бо дарназардошти ин, ки халқҳои Милали Муттаҳид имони худро ба ҳуқуқи асосии башар, шараф ва қимати шахсияти инсонию баробари ҳуқуқи марду зан дар Оинномаи эълон кардаанд ва қарор додаанд, ки ба пешрафти иҷтимоӣ мусоидат карда ва дар муҳити озодтар вазъи зиндагии беҳтаре ба вуҷуд оваранд; бо дарназардошти ин, ки давлатҳои аъзо ӯхдадор шудаанд ба эҳтироми риояи воқеии ҳуқуқи башар ва озодиҳои асосӣ '
  },
  cat: {
    iso6393: 'cat',
    fixture:
      'Considerant que el reconeixement de la dignitat inherent i dels drets iguals i inalienables de tots els membres de la família humana és el fonament de la llibertat, la justícia i la pau en el món, Considerant que el desconeixement i el menyspreu dels drets humans han originat actes de barbàrie que han ultratjat la consciència de la humanitat; i que s’ha proclamat com l’aspiració més elevada de tothom l’adveniment d’un món on els éssers humans, deslliurats del temor i la misèria, puguin gaudir de llibertat d’expressió i de creença, Considerant que és essencial que els drets humans siguin protegits per un règim de dret per tal que les persones no es vegin forçades, com a últim recurs, a la rebel·lió contra la tirania i l’opressió, Considerant també que és essencial de promoure el desenvolupament de relacions amistoses entre les nacions, Considerant que els pobles de les Nacions Unides han ratificat en la Carta llur fe en els drets humans fonamentals, en la dignitat i el valor de la perso'
  },
  sot: {
    iso6393: 'sot',
    fixture:
      'Ka hona he, ho amohela seriti seo motho a tswalwang le sona ha mmoho le ditokelo tse lekanang tseo motho a ke keng a di amohuwa tsa batho bohle, ke mohlodi wa tokoloho, toka le kgotso lefatsheng. Ka hona he, ho se natse le ho tella ditokelo tsa botho, ho tswetse diketso tsa bohlaha tse tamukantseng letswalo la batho, mme tsena di entse hore ho labalabelwe lefatshe leo ho lona batho ba tlang ho thabela bolokolohi ba ho bua le tumelo, le bolokolohi ditlamong tsa matswalo le bohloki. Tsena he ho thwe ke tabatabelo e hodimodimo ya batho ka kakaretso. Ka hona he, ho a hlokahala, ha motho a sa dumellwa ho ba le boipiletso, e le monyetla wa ho qetela, hore a hanane le tlatlapo le kgatello. Ka lebaka lena ditokelo tsa botho di tlamehile ho sireletswa ke taolo ya molao. Ka hona he, taba ya bohlokwa ke ho kgothallesta ntshetsopele ya dikamano tsa setwalle matjhabeng. Ka hona he, batho ba Matjhaba a Kopaneng, ho molao wa motheo wa bona, ba tiisa botjha tumelo ya bona ya ditokelo tsa motheo tsa bo'
  },
  kat: {
    iso6393: 'kat',
    fixture:
      'ვინაიდან ადამიანთა ოჯახის ყველა წევრისათვის დამახასიათებელი ღირსების და თანასწორი და განუყოფელი უფლებების აღიარება წარმოადგენს თავისუფლების, სამართლიანობის და საყოველთაო მშვიდობის საფუძველს; და ვინაიდან, ადამიანის უფლებათა უგულებელყოფამ და აბუჩად აგდებამ გამოიწვია ბარბაროსული აქტები, რაც აღაშფოთებს კაცობრიობის სინდისს, და რომ ისეთი მსოფლიოს შექმნა, რომელშიც ადამიანებს ექნებათ სიტყვისა და რწმენის თავისუფლება, და რომელშიც ისინი იცხოვრებენ შიშისა და გაჭირვების გარეშე, გამოცხადებულია ადამიანთა მაღალ მისწრაფებად, ვინაიდან, აუცილებელია, რომ ადამიანის უფლებებს იცავდეს კანონი, იმის უზრუნველსაყოფად, რათა ადამიანი იძულებული არ გახდეს მიმართოს აჯანყებას, როგორც ტირანიისა და ჩაგვრის წინააღმდეგ უკანასკნელ საშუალებას, ვინაიდან, აუცილებელია ხელის შეწყობა ერთა შორის მეგობრულ ურთიერთობათა განვითარებისათვის, ვინაიდან, გაერთიანებული ერების ხალხებმა წესდებაში დაადასტურეს თავიანთი რწმენა ადამიანის ძირითადი უფლებებისადმი, ადამიანის პიროვნების ღირსებისა და ღირებულების და კაცებისა და ქალების თანასწორუფლებიანო'
  },
  bcl: {
    iso6393: 'bcl',
    fixture:
      'Huli ta an pagkamidbid kan dignidad intrinseca asin an parantay asin inalienableng mga derechos kan gabos na miembros kan familia humana iyo an fundacion nin katalinkasan , justicia asin katoninongan sa bilog na kinaban, Huli ta an ginikanan nin mga makangirongirhat na mga gawe laban sa conciencia nin katawohan iyo an pagbalga asin pagmenos kan derechos humanos, asin ta sa pagpahayag na an pinakahalangkaw na kamawotan nin katawohan iyo an magkaigwa nin sarong kinaban na kun saen an gabos na tawo mayo nin pagkatakot asin miseria, asin igwang katalinkasan sa pagtaram asin man katalinkasan nin pagtubod, Huli ta mahalaga na mabantayan an derechos humanos sa irarom nin sistemang may pagkuyog sa ley, tanganing an tawo dai mapiritan na magrebelde, bilang ultimong paagi, laban sa tirania asin opresion, Huli ta mahalagang pakusogon an kaboronyogan nin mga naciones, Huli ta sa Carta, an mga banwaan kan Naciones Unidas nagpahayag liwat kan saindang pagtubod sa mga fundamental na derechos humanos,'
  },
  glg: {
    iso6393: 'glg',
    fixture:
      'A liberdade, a xustiza e a paz no mundo teñen por base o recoñecemento da dignidade intrínseca e dos dereitos iguais e inalienables de tódolos membros da familia humana; O descoñecemento e o menosprezo dos dereitos da persoa orixinaron actos de barbarie aldraxantes para a conciencia da humanidade; proclamouse, como a aspiración máis elevada da persoa, o advento dun mundo no que os seres humanos, liberados do temor e da miseria, disfruten da liberdade de palabra e da liberdade de crenzas; Esencial que os dereitos da persoa sexan protexidos por un ríxime de dereito, co fin de que a persoa non se vexa compelida ó supremo recurso da rebelión contra a tiranía e a opresión; Tamén esencial promover o desenvolvemento de relacións amigables entre as nacións; Os pobos das Nacións Unidas reafirmaron na Carta a súa fe nos dereitos fundamentais da persoa, na dignidade e o valor do ser humano e na igualdade de dereitos de homes e mulleres; declaráronse resoltos a promover o progreso social e a eleva'
  },
  lao: {
    iso6393: 'lao',
    fixture:
      'ດ້ວຍເຫດວ່າ: ການຮັບຮູ້ກຽດຕິສັກອັນມີປະຈຳຢູ່ຕົວບຸກຄົນໃນວົງສະກຸນຂອງມະນຸດທຸກໆຄົນ ແລະ ການຮັບຮູ້ສິດສະເໝີພາບ ແລະ ສະເຖຍລະພາບຂອງບຸກຄົນເຫຼົ່ານັ້ນ ປະກອບເປັນຮາກຖານຂອງສິດເສລີພາບ ຍຸດຕິທຳ ແລະ ສັນຕິພາບຂອງໂລກ. ດ້ວຍເຫດວ່າ: ການບໍ່ຮັບຮູ້ ແລະ ໜີ່ນປະໝາດຕໍ່ສິດຂອງມະນຸດນັ້ນໄດ້ເປັນຕົ້ນເຫດໃຫ້ເກີດການກະທຳຢ່າງປ່າເຖື່ອນຊື່ງຈະເຮັດໃຫ້ແຄ້ນໃຈຕໍ່ມະໂນທຳຂອງມະນຸດ ແລະ ເຫັນວ່າການນຳຊື່ງໂລກມະນຸດທີ່ຈະມີອິດສະຫຼະໃນການສະແດງຄວາມເວົ້າ ແລະ ຄວາມເຊື່ອຖືຊື່ງຈະພົ້ນຈາກຄວາມຫວາດຫວັ່ນ ຢ້ານກົວ ແລະ ຍາກຈົນຂົ້ນແຄ້ນນັ້ນໄດ້ຖືກປະກາດວ່າ: ເປັນຄວາມປາຖະໜາອັນຍອດຍີ່ງຂອງມະນຸດ. ດ້ວຍເຫດວ່າ: ມີຄວາມສຳຄັນທີ່ຕ້ອງລະບຽບສິດປ້ອງກັນສິດທັງຫຼາຍຂອງມະນຸດເພື່ອບໍ່ໃຫ້ບຸກຄົນຖືກບັງຄັບໃຈໃຫ້ຕໍ່ສູ້ຄວາມບຽດບຽນຂ້ຽວແຂ້ນແລະຄວາມກົດຂີ່ຂົ່ມເຫງຈົນເຫຼືອວິໃສ. ດ້ວຍເຫດວ່າ: ເປັນຂໍ້ສຳຄັນທີ່ຕ້ອງເຊີດຊູສຳພັນທະໄມຕີລະຫວ່າງປະເທດຊາດໃຫ້ດີຍີ່ງຂື້ນ; ດ້ວຍເຫດວ່າ: ໃນກົດໝາຍໂລກນັ້ນປະຊາຊົນແຫ່ງສະຫະປະຊາຊາດໄດ້ປະກາດຢືນຢັນຄວາມເຊື່ອຖືຂອງຕົນອີກໃນສິດສຳຄັນຂອງມະນຸດ ໃນກຽດຕິສັກ ແລະ ຄຸນຄ່າຂອງບຸກຄົນໃນຄວາມສະເໝີພາບຂອງສິດສ່ວນບຸກຄົນຜູ້ຊາຍ ຫຼື ຜູ້ຍິງ ແລະ ເຫັນວ່າ:ປະຊາຊົນເຫຼົ່ານັ້ນໄດ້ປະກາດຕົນເປັນຜູ້ຈະເລີນພໍແລ້ວທີ່ຈະຊ່ວຍສະໜັບສະໜູນຄ'
  },
  lit: {
    iso6393: 'lit',
    fixture:
      'Atsižvelgdama į tai, kad visiems žmonių giminės nariams būdingo orumo ir lygių bei neatimamų teisių pripažinimas yra laisvės, teisingumo ir taikos pasaulyje pagrindas; atsižvelgdama į tai, kad žmogaus teisių visiškas nepaisymas ir niekinimas pastūmėjo vykdyti barbariškus aktus, piktinančius žmonijos sąžinę, o sukūrimas pasaulio, kuriame žmonės turės žodžio ir įsitikinimų laisvę ir bus išlaisvinti iš baimės ir skurdo pančių, paskelbtas kaip kilniausias žmogaus siekimas; atsižvelgdama į tai, jog būtinai reikia, kad žmogaus teises saugotų įstatymo galia, dėl to, kad jis nebūtų priverstas imtis, kaip kraštutinės priemonės, sukilimo prieš tironiją ir priespaudą; atsižvelgdama į tai, jog būtinai reikia remti draugiškų santykių tarp tautų vystymą; atsižvelgdama į tai, kad Suvienytųjų Nacijų Organizacijos įstatuose tautos vėl įtvirtino savo tikėjimą pagrindinėmis žmogaus teisėmis, žmogaus, kaip asmenybės, orumu ir vertingumu, lygiomis vyrų ir moterų teisėmis ir pareiškė, jog esančios pasiryžus'
  },
  umb: {
    iso6393: 'umb',
    fixture:
      'Okukolela ukulihiso ekalo lityamela kovimata mata vyepata lyomanu kwenda omoko yasoka kwavosi. Kwenda yesunga yilinga ombembwa yimwe yapana yesunga kwenda yombembwa v’olwali. Okukolela eci kacakulihiwile kwenda esepwiso lyomoko yomunu, lyatwala kokuponda, okungwalisa olondunge vyowiñgi kwenda ekalu lyolwali lumwe muna vakwamwenyo vakaliyela okuvangula kwenda okulitava, vayovoka kusumba kwenda kusuka , yalombolwiwa ndeyi yavelapo hayo yalelapo vali keswimo liwa lyomunu. Okukolela okuti cavelapo okweca ulongo kokwamako okulyeca kukamba wolofeka. Olukolela okuti vukanda owiñgi wofokeka vyalikongela, wasapula onjanja yokaliye etavo lyawo komoko yavelapo yomunu, kekalo kwenda esilivilo lyomwenyo womunu, okulisoka komoko yalume kwenda yakayi kwenda yilombolola utoyi wokweca okwamako kwowingi kwenda okweca ekalo lyaposoka lyomwenyo v’eyovo limwe lyavelapo. Okukolela okuti olofeka vyalityamela vyatyamela okukwata, okulikwatisako l’elisokiyo lyolofeka vilikwete omunga, esumbilo lyolwali kwenda '
  },
  tsn: {
    iso6393: 'tsn',
    fixture:
      'Go ntse jalo gore kamogelo ya tlhago ya seriti le tekatekano le ditshwanelo tse di sa amologanngweng tsa ditokololo tsotlhe tsa losika lwa motho ke motheo wa kgololosego, bosiamisi le kagiso mo lefatseng. Go ntse jalo gore go itlhokomolosa le go nyatsa ditshwanelo tsa botho go tlhotse ditiragalo tsa bolalome tse di šsakgaditseng maikutlo a batho mo tshimologong ya lefatshe le mo go lona batho ba itumelelang kgololosego ya go bua le tumedi, le kgololosego mo go boifeng le go eletseng, di goeleditswe jaaka dikeletso tse di kwa godimo tsa batho botlhe. Go ntse jalo gore go botlhokwa, fa motho a sa patelesege go tsaya tsela esele, jaaka ona mokgwa wa bofelo, go ema kgatlhanong le bagagapa le kgatelelo, gore ditshwanelo tsa botho di sirelediwe ke puso ya molao. Go ntse jalo gore go botlhokwa go tsweletsa kgolo ya dikgalologano tsa botsalano fa gare ga ditšhaba. Go ntse jalo gore Ditšhaba Kopano ka Lokwalo lo, ba tiiseditse tumelo ya bona mo motheong wa ditshwanelo tsa botho, mo seriting le '
  },
  vec: {
    iso6393: 'vec',
    fixture:
      'Considarà che el reconosimento de ła dinjità inerente a tuti i menbri de ła fameja umana e de i só deriti, conpanji e inałienàbiłi, el costituise el fondamento de ła łibartà, de ła justisia e de ła paze inte’l mondo; Considarà che el desconosimento e el despreso de i deriti umani i ga portà a ati de barbarità che i ofende ła cosiensa de l’umanità, e che el rivar de un mondo ndove che i èsari umani i gode de ła łibartà de paroła e de credo e de ła łibartà da ła paura e da’l bezonjo el ze stà proclamà cofà ła pì alta aspirasion de l’omo; Considarà ch’A ze indespensàbiłe che i deriti umani i sie protezesti da norme zurìdeghe, se A se vołe evitar che l’omo el sie costreto a recórar, cofà ùltima istansa, a ła rebełion contro de ła tiranìa e l’opresion; Considarà ch’A ze indespensàbiłe promóvar el dezviłupo de raporti da amighi intrà Nasion; Considarà che i pòpołi de łe Nasion Unìe i ga reafermà inte ła Carta ła só fede inte i deriti umani fondamentałi, inte ła dinjità e inte’l vałor de ła p'
  },
  nso: {
    iso6393: 'nso',
    fixture:
      'Le ge re dutše re tseba gore seriti seo motho a belegilwego ka sona le tekatekanelo gammogo le ditokelo tšeo di sa tšeelwego kgang tša batho ka moka ke motheo wa tokologo ya toka le khutšo lefseng ka bophara. Le ge re dutše re tseba gore go se elwe hloko le go phaelwa ka thoko ga ditokelo tša botho go tlišitše dilešadihlong tšeo di rumutšego le go šišinya maikutlo le letswalo la botho bathong, go tla ga pono le tebelelo ye mpsha mo lefaseng yeo e ikemišeditšego go ela hloko gore batho ba swanetše go ipshina ka tokologo ya polelo, ya bodumedi gammogo le go se tšhoge selo goba gona go duma, go dirile gore se se boletšwego ka mo godimo e be dinyakwa tša maemo a godimodimo tša batho ka moka. Le ge re dutše re tseba gore go bohlokwa, ntle le ge motho a gapeletšwa ke mabaka, go thibela ka gohlegohle pušo ya mmušakatshipi le kgatelelo gore ditokelo tša botho di swanetše go šireletšwa ke molao. Le ge re dutše re tseba gore go bohlokwa go godiša tšweletšopele ya segwera magareng a ditšhaba. Le '
  },
  ban: {
    iso6393: 'ban',
    fixture:
      'Manimbang riantukan pangangken ring subhakarma lan hak-hak sane pateh tur pastika saking paguyuban kulawarga manusa sami inggih punika dasar kemerdekaan, keadilan lan perdamaian ring jagat. Manimbang riantukan ngelempasang lan ngandapang hak azasi manusia janten ngawinang parilaksana-parilaksana sane kaon sane ngawinang rasa kroda sajeroning herdaya (unteng pekayunan) manusapada, tur kamanggehang jagat genah manusa pacang muponin bebas mawicara lan maagama tur luput saking rasa ajrih miwah kakirangan, punika sampun kajantenang pinaka tatujon pilih utama saking para jana. Manimbang riantukan hak-hak manusa patut kaayomin malarapan peraturan hukum mangda para jana nenten kadulumuk milih pamargi andaga utsaha penguntat maka panungkas kaduratmakan miwah penjajahan. Manimbang riantukan ngupapira paiketan pasawitran ring sajeroning negara-negara patut kautsahayang. Manimbang riantukan wangsa-wangsa saking Perserikatan Bangsa-Bangsa sajeroning Piagem Perserikatan Bangsa-Bangsa sampun mategesa'
  },
  bug: {
    iso6393: 'bug',
    fixture:
      "Pura ritimbang nasengnge dipattongengngi ri asengnge allebbireng napanjajie puang seuwae na hak-hak pada nappunnai manengnge salasureng padatta rupa tau ianaro simulangenna riasengnge merdeka e . Ade'e na atennangengnge tuo ri linoe. Pura ritimbang nasengnge gau de'e nasipakalebbireng pole padatta rupa tau ianaro mancaji pangkaukang makassara najajianni maggoppo maneng accairengnge na ajapparu'e ri laleng atina rupa tau. na ri purennuangi rijajiangi seddi lino naonroi'e padatta rupa tau ye'paneddingi'e riasengnge ininnawa mappau ada tongeng na ininawa suju'e ri Puang seuwae sibawa ininnawa leppe'e pole riasengnge akkitaureng na teggennekengnge pura mancaji seddi purennuang marilaleng pole taumaegae. Pura ritimbang nasengnge hak-hak padatta rupa tau parellu riatoro ri lalenna sure hukung'e, narekko de wedding seddi seddi tau nateru-terusi molai laleng salae na nasengnge laleng madeceng naola makkuraga pacelliri sifa' salae ye temmappakasitaue. Pura ritimbang nasengnge sipakau ripadatta "
  },
  knc: {
    iso6393: 'knc',
    fixture:
      'Adəgaima tada adamganabebe nəmngalwonzə kambaata adə-a nəmnduaso kalkalnzə-a hakkiwanzə Alanjo-adə shima ferno nəmkambe-a jirebe-a nəlefabe-aro dunya ngason asutəna, Adəgaima hakkiwa adamganabero cistəgə ba-a fallaktə-abe sawowuro kəndowa halye kurzənyi waazə hangal adamganabero karega rozəgəna, kuru dunya duwo suron adamganasoye tamtam hakkinza manabe-a nzasarabe-a kuru nambe duwo dalil baaro citə-a jero-abedə shima awo talaawaye təmazana woro warmowotə, Adəgaima awo məradətənadə susu adamganaga dunon təkkə nəmzaləm-a njokuno-a kəriwutəbedəro howum maibeye hakkiwanzaga səliwodəma, Adəgaima awo məradətənadə tawaa-a nəmkam-a indikate lardəwaben haptaadəma, Adəgaima ummawa Lardəwa Tawakkata Dunyabeye suro Tawakamdəben kamburshenza kəla hakkiwa adamganaben nanazaana, kəla daraja-a nəmngalwo-a adamganabe-a kəla kamu-a kwa-a hakkinza kalkal-aben kasadə gozana tamtam-a kəndəga ngəla-a hapsaa nambe gayaga fandoro, Adəgaima Lardəwa Memba Kaapkadəbe woso wadəga gozana, tawaa Lardəwa Tawakkata D'
  },
  kng: {
    iso6393: 'kng',
    fixture:
      'Nakutalaka ti kutambula ngenda ya binama nyonso ya dikanda na ya baluve ya bawu a kudedakana mpe yina balenda kuyimina bawu ve ke lufulu ya kimpwanza, ya budedede mpe ya ngemba na kati ya yinza muvimba. Nakutalaka ti bunzimbu mpe mvwezolo baluve ya muntu metumia kusala mavanga ya bunyama, yina ke dasukisaka bantu mpe na kutalaka dyaka ti nkwizulu ya yinza, sika bantu kevwandaka na kimpwanza ya kuzonza mpe ya kukwikila, sika bantu kekuluka na boma mpe na bumputu ya kulutila zababakana mutindu dikani mosi yanene ya muntu. Nakutalaka ti ya ke mfumu samu ti baluve ya muntu fwana kukengidilwa na luyalu yina kezitisaka misiku samu na kusala ti muntu fwana kutombuka ve ntangu nyonso na luyalu yina kezitisaka ve misiku. Nakutalaka ti ya ke mfumu na kukindisa nkudusulu ya kinkundi kati ya bayinsi. Nakutalaka ti na kati ya Mukanda ya Misiku, makamba ya Bayinsi ya Yinza zabisaka dyaka kiminu ya bawu na baluve ya mfumu ya muntu, na ngenda mpe buzitu ya muntu na budedede va baluve ya babakala na ua'
  },
  ibb: {
    iso6393: 'ibb',
    fixture:
      'Kpukpuru owo emana ye ukemukem ye asana asana unen ye ndamana uboho-ufin. Mboho Edidiana Kiet Ofuri Ekondo enehede ebiere ndimum nkama, ndisuan etop mbana, nyun mkpeme mme ndamana unen kpukpuru owo. Ediyime ndinam utom emi oto ke mbet emi Mbobo Edidiana Kiet Ofuri Ekondo ekebierede emi eneherede osonode mbuotidem kpukpuru owo ke ofuri ekondo abana mme ndamana unen owo ye uku mmo ye se owo odotde. Ke nwed Edisuan Etop Mbana Mme Unen Owo Ke Ekondo, Mboho Edidiana Kiet Ofuri Ekondo enam anwana ke mem mem usun, mme unen emi enyenede kpukpuru owo ukem ukem. Mme unen emi enyene mbufo Mmo edi unen mbufo Mbufo emehe ye mme mbet ye mme unen emi enyun enwam ndisuan etop emi, nyun mkpeme mmo no idem mbufo kpa ye mmo eken nte mbufo. Ntono Ibuot Iko Koro ndidiono ndamana uku ye mme ukem ukem ye asana asana unen emi enyenede ubon owo edi ntono uboho-ufin, unen, ye emem ke ekondo, Koro unana ndikpeme kpa ye ndibat mme unen owo ke ikpuikpu ada obom ye ibak ibak edu uwem edi, emi etimerede esit owo; ko'
  },
  lug: {
    iso6393: 'lug',
    fixture:
      "Ekitiibwa ky'omuntu eky'obutonde; okwenkanankana, wamu n'obuyinza obutayinza kugyibwawo ebyabantu bonna, gwe musingi gw'eddembe; obwenkanya n'emirembe mu nsi. Obanga abantu sibakikozesa kujeema 'ngeky' okulwanyisa ekisembayo, okwetaasa obufuzi obukambwe okutulugunya, kyetaagisa eddembe ly'obuntu okuba nga lifugibwa amateeka. Ekibiina ky'amawanga amagatte, mu kiwandiiko kyakyo kikakasa nga bwekikkiririza mu ddembe ly'obuntu era ne mu kittibwa n'omuwendo gw'omuntu era kimaliridde okukubiriza abantu okugenda mu maaso n'okulwanyisa omutindo gw'embeera y'obulamu bwabwe mu ddembe erisingawo. Amawanga g'amemba geeyamye okukolaganira awamu n'ekibiina ky'Amawanga Amagattere mu kukubiriza abantu abali okussamu ekitiibwa n'okukuuma eddembe ly'obuntu n'emisingi gyalyo. Okutegeera obulungi obuyinza (rughts) n'eddembe ly'obuntu kikulu nnyo mu kutuukiriza obweyamo obwo mubujjuvu. Olwekyo, Olukiiko ttabamiruka (General Assembly) olw'amawanga Amagatte, iulangirira Ekirangiriro EKIFUGA EDDEMBE LY'ABANTU"
  },
  ace: {
    iso6393: 'ace',
    fixture:
      'Ta bileung‐bileung ranub lam puan han tok deulapan di dalam raga ta timang‐timang Peunyataan Umum nyan na tujoh bilangan paleng utama; Teuseubot bak phon “martabat alamiah” hak nyang pantaih makheulok manusia hak‐hak nyang saban dan muteulak sah teumpat teumeuduk “kemerdekaan, keadilan, perdamaian dunia”; Suai kedua nyang ditimang‐timang dipandang hana yum oreung abeihna leu that buet awak nyan lagee binatang beungeh meuradang hatee manusia; Rasa teumakot tiep uroue sabee udep ngon matee hana leu bida hoe hoe nyang tajak hana bebah lee sang donya nyoe ka akhee tamong neuraka meubacut na yum di nyawong ureung peupeu meulinteung dilaboih saja nyang keuh seubab nyan hai teungku piyeung seurata ureung haroik merdeka; Suai neumboi lhee cuba timang lom atoe ngon hukom hak asasi manusia nyang keuh cara peuteunang kaom liwat Peusyarikatan Bangsa‐Bangsa keupeut diseubut peukong hubongan ngon dan rakan di leu neugara nyang keulimong, kheun Piagam nyan peuyakin bandum keu hak asasi manusia nyang '
  },
  bam: {
    iso6393: 'bam',
    fixture:
      'K’a d’a kan ko dine hɔrɔnɲa ni tilennenɲa ni lafiya sintin ye hadamaden bɛɛ danbe dɔnni n’u josiraw danmakɛɲneni ye, K’a d’a kan ko hadamaden josiraw n’u kɔnni kɛra dannajuguya caman sababu ye minnu bɛ maaya ɲugun, ani ko hadamaden haju bɛɛ la gɛlɛnman ye de ka diɲe kura dabali min den si tɛ bali k’a hakilila fɔ nink’a dannasira batu, min den bɛɛ tangalen bɛ bagabagali ni ɲani ma, K’a d’a kan ko a tɛ ɲɛ fo hadamaden josiraw ka lakana sariyabatufanga de fe yaasa muruti kana kɛ mɔgɔ ma jagoya ye tɔɲɔn ni degun kanma, K’a d’a kan ko kanu jiidili ka kan ka kɔkɔrɔdon kabilaw ni ɲɔgɔn cɛ, K’a d’a kan ko Diɲe kabilatɔn y’a ɲaniya dantigɛ kokura, kabilaw Bɛnkansɛbɛn kɔnɔ, ko ale sirilen bɛ hadamaden josira bɛrɛw la, hadamaden danbe n’a kiimɛ na, cɛ ni muso josiraw kɛɲɛni na, ani ko a b’a cɛsire maaya ka taa ɲe, diɲɛnatigɛ ka nɔgɔya hɔrɔnɲa jiidilen kɔnɔ, K’a d’a kan ko tɔndenjamana bɛɛ y’a kandi ko a bɛ fara Kabilatɔn kan ka hadamaden josiraw n’a ka hɔrɔnɲa bɛrɛ lakana ani k’u waleya diɲe bɛɛ '
  },
  tzm: {
    iso6393: 'tzm',
    fixture:
      "Imi asmussen n lḥwerma i ttalasen akkw yâggalen n twachult talsawt d yizerfan n sen yemsawan, d nitni i d llsas n tlelli, taghdemt akkw d- tifrat deg wmadal (di ddunit). Imi kra n widn nesmussun ara izerfan n wemdan d widn iḥeqqren s lkhwedm n lewḥuch yesserfayen tamsakwit n talsa akkw d- tlilin umadal and'ara hedren u and'ara yamnen yemdanen s tlelli idg ur yelli la aseṛheb la lmizirya, d nettat i d asirem âlayan n wemdan. Imi tebbwi - dd nnig kra yellan ad ttuḥudden izerfan n wemdan s nnidam azerfan i wakkn ur yettuḥerrs ara wemdan di taggara alamma yughal d amnafeg ḍadd temḥeqranit akkw d unaghur. Imi yessefk ad tennerni tegmi d wassaghen n tmidwa d lemḥibba gar yeghlanen. Imi di lqanun izerfan n wemdan imudan n ledjnas yedduklen berrḥen i tikkelt tajḍidt laman n sen deg zerfan ilsasiyen n wemdan di ccherf akkw d wazal n bnadem di tugdut izerfan n tulawin d yergazen u berrḥen belli qeṣden ad snernin aqeddem amgarwan u ad sbed'den tigwnatin timenyafin n tudert di tlelli "
  },
  ydd: {
    iso6393: 'ydd',
    fixture:
      'היות װי דער סאַמער גרונט פֿון פֿרײַהײט, יושר, און שלום אױף דער גאָרער װעלט באַשטײט פֿון אָנערקענען דעם תּוכיקן כּבֿוד און די גלײַכע און ניט־איבערטראָגלעכע רעכט פֿון אַלע מיטגלידער פֿון דער מענטשישער משפּחה, היות װי איגנאָרירן און ביטול צו די מענטשנרעכט האָבן גורם געװען באַרבאַרישע אַקטן װאָס האָבן אָנגעװאָרפֿן אַ גרױל אױף אַלע מענטשן, און היות װי די העכסטע האָפֿנונג פֿון די אומות העולם איז אַז די צײַט זאָל אָנקומען װען מענטשן זאָלן געניסן פֿון פֿרײַהײט, אי פֿון רעדן אי פֿון גלױבן, און קײנער זאָל ניט לײַדן פֿון קײן מורא אָדער נױט, היות װי געזעץ און יושר מוזן פֿאַרטײדיקן מענטשנרעכט, טאָמער מען װעט זיך אין נױט נעמען רעבעלירן קעגן טיראַניע און באַדריקונג, היות װי דערמוטיקן די אַנטװיקלונג פֿון פֿרײַנטלעכע באַציונגען צװישן לענדער איז אַן עיקר, היות װי די פֿעלקער פֿון די פֿאַראײניקטע פֿעלקער האָבן אין זײער טשאַרטער אונטערגעשטריכט זײער גלױבן אין גרונטלעכע מענטשנרעכט, אין דעם כּבֿוד און װערט פֿון יעדן מענטש, און אין די גלײַכע רעכט פֿון מענער און פֿרױען, און היות װי זײ האָבן באַשלאָסן דערמוטיקן '
  },
  kmb: {
    iso6393: 'kmb',
    fixture:
      'Mu kutala kuma o ujitu wa kijingu wa tokala ku phunga yose ya mwiji wa’athu ni yoso ya itokelu ya sokelela ki itena ku ilanduka idibanga dimatekenu dya ufolo, dya difundisu ni dya kutululuka mu ngongo. Mu kutala kuma o kukamba kwijya ni kudituna o itokelu ya muthu ya ambata mu ibangelu ya ku dijiba kuma ifutukisa o kubhanza kwa athu ni kuma o ngongo iza mwene o athu endakala ni kubanduluka mu kuzwela ni mu kwandala, akula ku woma ni ku wadyama, yai a ikola kala o kwandala kwavulu dingi kwa muthu. Mu kutala kuma kyene kyawaba o kukulisa o kukula kwa kudibana kwa ukamba mukaxi kya jixi. Mu kutala kuma mu mukanda wa athu wa jixi jadisokeka atangela lwamukwa o kixikinu kye mu itokelu ya dyanga ya muthu, mu kijingu ni kidunda kya muthu, mu kusokela kwa itokelu ya mala ni ahatu ni kuma atangela ni kukaka o kutenesa o kukuka kwa mundu ni abeka ixexilu ya mbote ya mwenyu mu ufolo wa kulu. Mu kutala kuma o jixi jadisokeka asoto kikwatesu mu ku dibana ni phunga ya jixi jadisokeka, o kuxila kwa n'
  },
  lun: {
    iso6393: 'lun',
    fixture:
      'Kuhitila mu kwiteja nakulemesha muntu, chakubuka kwambula chisaka cha muntu wejima munu mukayi hichikunku kwafuma kulubuka nakudimena, wusompeshi hamu na kuwunda munu mu kayi kejima. Kubula kulondela nshimbi ja wuntu chinaleteshi kubula kutiyangana hakachi kwawantu atela kwikala na nshimbi jakudihoshela kuditongojokela chakadi kutiya nachu woma, chuma chalema mu kuhanda kwamuntu. Chekala chasweja kulema neyi abuli kunukanjikija nakukenga kufubukila akwawu adi na kumukakesha, ilanga muntu watela kukinge wa na nshimbi. Mu chitiyangenu chawaka United Nations, eteja chikuhwelelu chawu mu nshimbi ja wuntu, ekala iyala hela mubanda, nikumona nawu antu enjima anatwali kumbidi chahandilu. Matunga amu United Nations adishika kumona nawu hadichitiyangenu, kalemesha ni kulondela nshimbi ja wuntu. Nshimbi yeniyi ya kayi kejima ya Wuntu wa Muntu, hi njila yimu yakuwahishilamu chihandilu chawantu hamu nanyidimu yamatunga, dichi muntu wejima hela yipompelu yawantu eteja kulondela nshimbi yamuchidiwu '
  },
  shn: {
    iso6393: 'shn',
    fixture:
      'ႁပ်ႉႁွင်းတူၺ်းထိုင်တေႃႇ သုၼ်ႇလႆႈသုၼ်ႇပဵၼ် ဢၼ်ၵူၼ်းၵူႊၵေႃႉထုၵ်ႇလီၸၢမ်ႇပူၺ်ႈၵူႊၵေႃႉၵူႊၵူၼ်း ၸွမ်းလူၺ်ႈ ၵုင်ႇမုၼ်ၸိူဝ်ႉၶိူဝ်းၽႂ်မၼ်းၼၼ်ႉ ပဵၼ်ပိုၼ်ႉထၢၼ်လူင် တႃႇၸၢဝ်းၵူၼ်းတင်းလုမ်ႈ တေလႆႈမီးလွင်ႈထၢင်ႇႁၢင်ႊလွတ်ႈလႅဝ်း၊ မီးလွင်ႈၽဵင်ႇပဵင်းၸွမ်းထမ်း၊ မီးလွင်ႈၵတ်းယဵၼ်လႄႈသင်၊ ဢမ်ႇၼပ်ႉယမ်တေႃႇသုၼ်ႇလႆႈသုၼ်ႇပဵၼ်ၵူၼ်းၼႆႉ ၵိူတ်ႇပဵၼ် မႃး ၵၢၼ်ႁုၵ်းႁၢႆႉမိူၵ်ႈမႂ်ႈလူင် ဢၼ်ယႃႉလႅဝ်ၵုင်ႇမုၼ် ၸၢဝ်းၵူၼ်းတင်းလုမ်ႈလႄႈသင်၊ ပိုၼ်ၽၢဝ်ႇဝႆႉဝႃႈ ၼင်ႇႁိုဝ် တေ လႆႈပဵၼ်မႃး ၶူင်းၵၢင်လူင် ဢၼ်မီးလွင်ႈလႆႈလၢတ်ႈၸႃ လွတ်ႈလႅဝ်းထၢင်ႇႁၢင်ႊ၊ လွင်ႈလႆႈၵိူဝ်းယမ်ၼပ်ႉထိုဝ် တၢမ်ၼင်ႇ ၵၢင်ၸႂ်ၽႂ်မၼ်းလွတ်ႈလႅဝ်း၊ လွင်ႈဢမ်ႇလႆႈၵူဝ်ႁႄ လႆႈႁႃၵိၼ်လဵင်ႉတွင်ႉဢိမ်ႇတဵမ်ၸိူဝ်းၼႆႉ လႄႈသင်၊ ယွၼ်ႉပိူဝ်ႈ ၶီႇၼဵၵ်းတဵၵ်းတဵင်ပေႉၵိၼ် ၽွင်းငမ်းၵၼ်၊ ၶႃတူဝ်ၶႃၸႂ်ၵၼ်သေ ၼင်ႇႁိုဝ် ၵူၼ်းတင်းလုမ်ႈ ယိူၼ်ႉဢမ်ႇလႆႈသေ တေဢမ်ႇလႆႈဝၵ်ႉ ၶိူင်ႈယိပ်း လုၵ်ႉၽိုၼ်ႉတေႃႇၵၼ်ၼၼ်ႉ တၵ်းတေလႆႈဢဝ်ၾိင်ႈမိူင်းသေ ၵႅတ်ႇၶေႁၵ်ႉသႃပၼ်လႄႈသင်၊ ၼင်ႇႁိုဝ်ၸိုင်ႈမိူင်းၸိူဝ်းၼႆႉ တေၶဝ်ႈဢွၵ်ႇမိုတ်ႈၵိုဝ်းၸမ်ၸႂ်ၵၼ်သေ ၶတ်းၸႂ်ပွင်သၢင်ႈ တႃႇတေၶိုၼ်ႈယႂ်ႇမႂ်ႇသုင် ၵႂႃႇလႄႈ သင်၊ လုၵ်ႈၸုမ်း ၸၢတ်ႈၸိုင်ႈလုမ်ႈၾႃႉၶဝ်ၼႆႉ ႁပ်ႉပၢၵ်ႇဝႆႉတီ'
  },
  war: {
    iso6393: 'war',
    fixture:
      'Tungod han pagkilal-a nga an tiunay nga dignidad ug katpong ngan diri-maiwasan nga mga katungod hadton mga kaapihan kanan tawo pamilya amo an pinatatamakan han katalwasan, hustisya kalinawan han kalibutan; Tungod han pagpasibaya ug pagbiay-biaya han kanan mga tawo katungod nga nahingadto hin mga magpakarima-dima nga mga buhat ug nakapahangit han katawhan, ug dumangat han pag-abot hin bag-o nga panahaon diin an mga katawhan magpapahimulos han ira katadungan pagyakan ug pagtuo hin waray ikahahadlok ug an katalwas tikang hin mga kabaraka ug pahingulang iginsaysay nga amo an pinakahitaas nga hingyap han mga molupyo; Tungod nga kinahanglan gud, agud an tawo diri mapiritan paggapil, ha iya katapusan nga paningkamot, pag-ato pagraugdauga ha iya, igan an mga katadungan han tawo panalipdan gud ha balaud; Tungod nga kinahanglanon gud an pagpaudway han nagtutubo nga pagkasarangkay han mga nasud; Tungod kay an mga katawhan han un nagotco pagtangdo han ira tuluohan bahin han kanan tawo panguna nga '
  },
  dyu: {
    iso6393: 'dyu',
    fixture:
      'K’à mìna à mà kó dúnya’ mànton’ bɛɛ ká kan ni bònya ye, àni kó bɛɛ ká kan sàriya’ la làkika’ la, kó ò le be bɛɛ ya hɔrɔnya’ sàbati, kà bɛɛ kánya ɲásuma’ dúnya’ sìgi’ la. K’à mìna à mà kó mɔgɔya hákɛ lɔnbaliya’ ni à jàtebáliya’ nàna ni níjuguya’ syáman ye dúnya kɔnɔ, minw kà hádamadenw dùsu’ kàsi, àni K’à mìna à mà tèle kúra min bɔra, à fɔra kó kúma’ mín ká dí mín yé, ò bé ò fɔ, kó díina’ mín ká dí mín yé, ò bé ò kɛ, kó mɔgɔw kà síran ɲgɔn ɲá, ò bánna, kó fàgantánya júgu bánna, ò kùma’ kɛra bɛnkan ye min kɛra hamamadenw haminankoba ye, K’à mìna à mà kó kà mɔgɔya’ hákɛ’ látanga ní sàriya’ sìgili’ yé sèn kán, ò yé wájibi yé wálasa mɔgɔw kàna wájibiya kà múruti bènkánni’ kánma, àni fàngajúgu’ kánma, K’à mìna à mà à ká kán tériya’ yé kɛ jàmanaw ni ɲgɔn cɛ, K’à mìna à mà dúnya’ mùmɛ sáratikan’ ná, Dúnya’ Jàmanaw yá tɔnba’ màntonw bɛɛ kà à yìra kó ù lánin bɛ mɔgɔya’ hákɛyabaw’ la, ù lánin bɛ hádamadenya’ tá bònya’ ní à lànbe’ la, ù lánin bɛ cɛw ní mùsow ya kányaɲgɔnmaya’ lá hákɛ’ lá, ní ù kà '
  },
  wol: {
    iso6393: 'wol',
    fixture:
      'Ñu jàpp te nangu ne sagu doomi aadama ak sañ-sañam yépp-dañu yam te kenn mënukóo jalgati, te lu lépp nekk na cës laay ci taxufeex ci mbirum àtte ak jàmm ci biir àdduna. Ñu jàpp ne ñakk xam ak soofantal sañ-sañi doomi aadama indi na aymusiba yu tar tax képp kuy dund fippu. Temano egsi na ba mu nekk ci doomi aadama ñu mën a wax, xalaat, ci seen coobare, bundxatal, nàkk dëddu leen. Ñu jàpp ne am na solo lool ñu aar sañ-sañi doomu aadama ak ay matukaay ci wàllu yoon; ngir doomu aadama moomu kenn du ko sonal, muy fippu ci nootaange ak lu koy bunduxatal. Ñu jàpp ne am na solo lool ñu góor-goorlu ba gën a rataxal jokkalante gi diggante xeet yi. Ñu jàpp ne ci bataaxal boobule mbootaayu xeet yi yeesalaat na ay pas-pasam jëme ko ci sañ-sani doomi aadama yu tolloo, ci sag, ci bir lépp lu aju ci dundin diggante góor ak jigéen, ci biir tawfeex gu yaa. Ñu jàpp ne réew yi ci bokk jël nañu ay matukaay ngir dëgëral jokkalante gi ak mbootaayu xeet yi, ñu naw it bu baax sann-sañi doomi aadama ak tawfeex '
  },
  kir: {
    iso6393: 'kir',
    fixture:
      'Адамзат үй‐бүлөсүнүн бардык мүчөлөрүнөтаандык болгон жогорку беделди жана алардын бирдей жана ажырагыс укуктарын таануу эркиндиктин, адилеттү үлүктүн жана жалпы тынчтыктын негизи болуп санала тургандыгын эске алуу менен; жана адам укуктарын этибарга албоо жана жеккөрүү адамзатынын абийирин козгогон жырткычтык актыларга алып келгендигин жана адамдар сөз эркиндиги менен ынанымга ээ болгон, эчнерседен коркпогон жана эч нерсеге муктаж болбогон дүйнөнүтүзүү адамдардын эң жогорку умтулуусу катарыжарыялангандыгын эске алуу менен; жана адам акыркы арга катары зомбулукка жана эзүүгү каршы күтүрүлүүгө аргасыз блбошун камсыз кылуу максатында адам укуктары мыйзамдын күчү менен корголууга тийиш экендигин эске алуу менен; жана элдердин ортосундагы достук мамилелерди өнүктүрүүгө көмөктөшүү зарыл экендигин эске алуу менен; жана Бириккен Улуттардын элдери Уставда адамдардын негизги укуктарына, адам инсанынын беделине жана баркына, эркектер менен аялдардын тең укуктуулугуна ишенгендиктерин ырасташкандык'
  },
  nds: {
    iso6393: 'nds',
    fixture:
      'Vunwegen wat dat Anerkennen vun de Wüürd, mit de all Minschen baren sünd, un de Rechten, de all Maten vun de Gemeenschupp vun de Minschen hebbt un de gliek un nich to verköpen sünd, de Grundlaag vun Frieheit un Freden in de Welt is, un wat dat recht und billig togeiht, vunwegen wat dat Verkennen un Minnachten vun de Minschen rechten to unminschlich Doon föhrt hett, un dat Geweten vun de Minschen daarvun vull is vun Schann, is dat vör nehmste Wark vun de Minschen dat Buen vun een Welt, wo elk un een seggen un gloven dröff, wat he will un he frie is vun Bang sien un Noot, vunwegen wat dat nödig is, de Minschenrechten dörch dat Regeern vun’t Recht Schuul geven, dat de Minsch nich dwungen as lest Middel Wedderpart to hollen Tyrannei un Ünnerdrücken, vunwegen wat dat nödig is, dat mang de Natschonen föddert ward, wat se fründlich mit eenanner ümgaht, vunwegen wat de Völker vun de Vereenten Natschonen mit düsse Charta noch mehr daar up ruut wüllt un dat so besloten hebbt: dat se fastholen an'
  },
  fuf: {
    iso6393: 'fuf',
    fixture:
      'TAWEEDE NDELO HETTAARE, NUNDHAL E BHUTTU ADUNAAN KO ANNDUDE WONDE NDIMU HERTINAAGU NEDDHANKE EN FOW E HANDANDHI BHE DHIN, KO PLIDYI Dhi BONTATAA, DHI BHE FOTATA E MUN; TAWEEDE, MADDYEEDE E BIKKHTAARE HANDANDHI NEDDHO WONUNO SABU AAWASEEDYI TIKKINAY DHI KALA DYON MIIDYO MOYYHO, E TAWDE FOTTONAAMA WONDE KALA NEDDHO KO FAADANII KO ADUNA MO YIMBHE BHEN FOW TAWATA NO HEITII E MUN, NO WAAWI DYANTAADE MAA MIIDYOO KO BHE FAALAA, HARA BHE FAALAA, HAHA BHE DHENYHITAAKI TILFERE MA TAMPERE; TAWEEDE, SINAA E LEYDI TEDDIN NDI HANDANDHI NEDDHO, AADEN TAWAY, SI O HEBHAY FAABO, BEE SI O MURTAN NDYAGGU E BHITTAARE; TAWEEDE, TAMBITAGOL SEMBINA WELDIGALE HUUWONDIRAL E HAKKUNDE LEYDHE KO HAGHIIGHA; TAWEEDE KO WONI KA NDER POTTAL, DYAMAADYI POTTAL LEYDHE ADUNA DHEN FENNYINNO FAHIN HOOLAARE HANDIIDYI KELENHI NEDDHANKE DHIN, E NDER NDIMU E BHANTAL NEDDHANKE, E NDER FOTONDIRAL HANDIIDYI WORBHE E REWBHE, TAWI BHE FENNYINII WAKKILAARE FII BHANTAL NEDDHANKEWAL, E NYNNUGOL PEHE KELENHE, FII NGURDAN E NDER HETTAARE'
  },
  mkd: {
    iso6393: 'mkd',
    fixture:
      'Бидејќи признавањето на вроденото достоинство, и на еднаквите и неотуѓиви права на сите членови на човештвото се темелите на слободата, правдата и мирот во светот; Бидејќи непочитувањето и омаловажувањето на човековите права резултираа со варварски постапки што претставуваат навреда на човековата совест и бидејќи создавањето на свет во кој луѓето ќе ја уживаат слободата на говор и убедување и ќе бидат ослободени од стравот од војна и сиромаштија, се прогласува како најголем идеал на сите луѓе; Бидејќи е суштествено човековите права да бидат заштитени со закон, а човекот да не биде принуден последен излез да бара во побуната против тиранијата и угнетувањето; Бидејќи е суштествено да се унапредува развојот на пријателските односи меѓу народите; Бидејќи народите на Обединетите нации со повелбата ја потврдија нивната верба во основните човекови права, во достоинството и вредноста на човековата личност и во еднаквите права на мажите и жените и се одлучија да го потпомагаат општествениот нап'
  },
  vmw: {
    iso6393: 'vmw',
    fixture:
      'Okhala wira osaamiha n’edignidade ya kunla pinatamu n’editeito sawe soolikana ni sakhwawe eri variyari wa eliberdade, wa esaria ni murettele mulumwenkuni; Okhala wira ohisuwela n’ohisamiha edireito sa mutthu sinniiriha itthu sonanara n’ekiiso ya olumwenku onkhala awe pinatamu moota ontthuna awe, ehihasiwaka ni mutthu mukhwawe walaa ni osikhini, pihimmwe okhala etthu yulupale enlompwawe mutthu; Okhala wi itthu yulupale okhaviherya edireito sa mutthu variyari v’regime ya edireito, ohitthyawele ekhotto wi akhume opuro onihosiwawe; Okhala wi v’alupale okhaviherya makhalelo amurettele ni ilapo sikina; Okhala wi Mupapheloni Ipovo sa Nações Unidas Sihimmwe wiwelela edireito sa mutthu, edignidade ni evalor ya pinatamu. Epaphelo yela en’himya edireito sikhaleke soolikala alopwana n’athiyana ni alipiheraka okhavihera makhalelo oorera, variyari v’eliberdade s’elapo soothene; Okhala wi ilapo soothene sikhanle membro sa Nações Unidas sohiwanana olalea, sikhaviheranaka ni Nações Unidas, ottitthimiha'
  },
  zgh: {
    iso6393: 'zgh',
    fixture:
      'ⵍⵍⵉⵖ ⵜⴳⴰ ⵜⵓⴽⵣⴰ ⵏ ⵓⵍⵍⴰⵍⵓ ⵏ ⴽⴰⵢⴳⴰⵜ ⵢⴰⵏ ⵖ ⵜⴰⵡⵊⴰ ⵜⴰⵏⴰⴼⴳⴰⵏⵜ ⴷ ⵓⵎⴳⵉⴷⴷⵉ ⵏ ⵉⵣⵔⴼⴰⵏ ⵏⵏⵙⵏ ⵜⵉⵔⵙⴰⵍ ⵏ ⵜⴷⵔⴼⵉⵜ ⴷ ⵜⵣⵔⴼⵜ ⴷ ⵓⴼⵔⴰ ⵖ ⵓⵎⴰⴹⴰⵍ. ⵜⴳ ⵜⴰⵎⵜⵜⴰⵡⵜ ⵏ ⵉⵣⵔⴼⴰⵏ ⵏ ⵓⴼⴳⴰⵏ ⴰⴷ ⵉⵜⵜⴰⵡⵉⵏ ⵜⵓⴳⵜⵜ ⵏ ⵎⴰⴷ ⵉⵀⵔⵛⵏ ⴰⵔ ⵉⵙⴼⴰⴼⴰ ⴰⴼⵔⴰⴽ ⵏ ⵓⴼⴳⴰⵏ, ⴰⴼⴰⴷ ⴰⴷ ⵢⵉⵍⵉ ⵢⴰⵏ ⵓⵎⴰⴹⴰⵍ ⵏⵏⴰ ⵖ ⵜⵜⵉⵍⵉ ⴷⴰⵔ ⵓⴼⴳⴰⵏ ⵜⴰⴷⵔⴼⵉⵜ ⵏ ⵡⴰⵡⴰⵍ ⴷ ⵓⵙⴳⴷ, ⵢⴰⵏⴼ ⵉ ⴰⵙⴷⵉⴷⵉ ⴷ ⵜⴰⵎⵎⴰⵔⴰ. ⴷ ⵍⵍⵉⵖ ⵉⴳⴰ ⵓⴼⵔⴰⴳ ⵏ ⵉⵣⵔⴼⴰⵏⵏ ⵏ ⵓⵎⴷⴰⵏ ⵢⴰⵏ ⵓⴼⴳⴳⴰⴳ ⵏ ⵢⴰⵏ ⵓⵏⴳⵔⴰⵡ ⵏ ⵉⵣⵔⴼⴰⵏⵏ ⴰⴼⴰⴷ ⴰⴼⴳⴰⵏ ⴰⴷ ⵓⵔ ⵉⵙⵜⵉ, ⴳ ⵜⵢⵉⵔⴰ, ⴰⵖⵡⵡⵖ ⵎⴳⴰⵍ ⵏ ⵜⴷⵏⴽⴰ ⴷ ⵓⵥⵍⴰⴳ; ⴷ ⵍⵍⵉⵖ ⵉⵇⵇⴰⵏ ⴰⴷ ⵜⴷⵓⵙ ⵜⵎⵔⵏⵉⵡⵜ ⵏ ⵜⵓⵇⵇⵏⵉⵡⵉⵏ ⵏ ⵜⵉⴷⴷⵓⴽⵍⴰ ⵏⴳⵔ ⵏ ⵜⵎⵜⵜⴰ, ⴷ ⵍⵍⵉⵖ ⵉⵍⵍⴰ ⴳ ⵜⵏⵜⵜⴰⵎⵜ ⵉⴷ ⵉⴳⴷⵓⴷⵏ ⵏ ⵜⵎⵜⵜⴰ ⵉⵎⵓⵏⵏ ⵏⵏⴰⵏ ⴷⵉⵖ ⵜⴰⴼⵍⵙⵜ ⵏⵏⵙⵏ ⴳ ⵉⵣⵔⴼⴰⵏⵏ ⵉⴼⴳⴳⴰⴳⵏ ⵏ ⵓⴼⴳⴰⵏ, ⴷ ⵜⵉⵣⵉ ⴷ ⵡⴰⵜⵉⴳ ⵏ ⵡⵓⴷⵎ ⴰⵏⴼⴳⴰⵏ, ⴷ ⵓⵎⴳⵉⴷⴷⵉ ⵏ ⵉⵣⵔⴼⴰⵏⵏ ⵏ ⵉⵔⴳⴰⵣⵏ ⴷ ⵜⵡⵜⵎⵉⵏ, ⵔⵏⵓⵏ ⵏⵏⴰⵏ ⵉⵙ ⵔⴰⵏ ⴰⴷ ⵙⵎⵖⵓⵔⵏ ⴰⵍⴰⵢ ⴰⵏⴰⵎⵓⵏ ⴷ ⵜⴼⴰⴷⵉⵡⵉⵏ ⵉⵖⵓⴷⴰⵏ ⵏ ⵜⵓⴷⵔⵜ ⴳ ⵜⵍⵍⴰ ⵜⴷⵔⴼⵉⵜ ⵉⵎⵇⵇⵓⵔⵏ, ⴷ ⵍⵍⵉⵖ ⵎⵙⵓⵛⴽⴰⵏ ⵉⵡⴰⵏⴽⵏ ⵉⴳⵎⴰⵎⵏ, ⵙ ⵜⵡⵙⵉⵏ ⵏ ⵜⵎⴰⴷⴷⴰⵙⵜ ⵏ ⵜⵎⵜⵜⴰ ⵉⵎⵓⵏⵏ, ⴰⴼⴰⴷ ⴰⴷ ⵢⵉⵍⵉ ⵡⵣⵔⴰⴽ ⴰⵎⴰⴹⵍⴰⵏ ⴰⵎⵙⴽⴰⵔ ⵏ ⵜⴷⵔⴼⵉⵢⵉⵏ ⴷ ⵉⵣⵔⴼⴰⵏ ⵉⴼⴳⴳⴰⴳⵏ ⵏ ⵓⴼⴳⴰⵏ, ⴷ ⵍⵍⵉⵖ ⵉⴳⴰ ⵓⴼⵔⴰⴽ ⵙ ⵉⵣⵔⴼⴰⵏ ⴷ ⵜⴷⵔⴼⵉⵜ ⴰⵙⴽⴽⵉⵏ ⴰⴽⵙⵡⴰⵜ ⴼⴰⴷⴷ ⴰⴷ ⵉⵜⵜⵓⴳ ⵓⵙⵓⵖⵏ ⴰⴷ, ⵉⵙⵙⴰⴼⵖ ⴷ ⵓⴳⵔⴰⵡ ⴰⵎⴰⵜⴰⵢ ⴰⵍⵖⵓ ⴰⵎⴰⴹⵍⴰⵏ ⵏ ⵉⵣⵔⴼⴰⵏ ⵏ ⵓⴼⴳ'
  },
  ewe: {
    iso6393: 'ewe',
    fixture:
      'Esi woɖe dzesi kɔtɛe be, amegbetɔwo katã ƒe gomekpɔkpɔ sɔsɔe, anye gɔmeɖokpe na amegbetɔƒomea ƒe ablɔɖemenɔnɔ, nuteƒewɔwɔ kple ŋutiƒaƒa le xexeame ta la. Esi eme va kɔ ƒãa be, ablɔɖevinyenye si nye amegbetɔ ɖesiaɖe tɔ la ŋu mabumabu akpɔ gbɔe wòtso be hlɔ̃nuwɔwɔ ɖe amegbetɔƒomea ŋu va bɔ ta la, amewo ƒe dzitsinya va tsi tre ɖe nuwɔna vloe sia ŋuti ale woɖe adzɔgbe heɖoe kplikpaa be, le egbe xexe sia me la, ele be amegbetɔ nanɔ agbe le ablɔɖe me, aɖe eƒe didi agblɔ ƒaa vɔvɔ manɔmee, asubɔ nusi dzi wòxɔ se, avo tso ŋɔdzidodoname si me eye hiãkame maganye agbenɔnɔ ƒe afɔklinu na ame hahoawo o ŋuti la, Esi woɖo kpe edzi be, ehiã be se nadzɔ Amegbetɔ ƒe Ablɔɖevinyenye ŋu Kpeɖodzinya la ŋu, be ameteteɖeto kple funyafunyawɔwɔ ame magawɔe be ame aɖeke nayi eɖokui ta ʋli gei la to aglãdzedze me o ŋuti la, Esi wohiã vevie be woado dukɔ kple dukɔwo dome kadodo ɖe ŋgɔ le xexemedukɔwo katã dome ta la, Esi Xexeme Dukɔ Ƒoƒuawo ɖe adzɔgbe le woƒe Ɖoɖo si te wode asie la me be, to Amegbetɔ ƒe ablɔɖevin'
  },
  khk: {
    iso6393: 'khk',
    fixture:
      'Хүн төрөлхтөний гэр бүлийн бүх гишүүнд угаас заяасан нэр төр болон тэдний тэгш, салшгүй эрхийг хүлээн зөвшөөрөх нь эрх чөлөө, шударга ёс, бүх нийтийн энх тайвны үндэс мөнийг иш үндэс болгон, хүний эрхийг үл тоомсорлох, басамжлах нь зон олны жигшлийг төрүүлсэн балмад үлйдэлд хүргэж байсан бөгөөд хүмүүс үг хэл, итгэл үнэмшилтэй байх, эрх ёөлөөтэй, айх аюулгүй, гачигдал зовлонгүй дэлхий ертөнцийг бий болгох нь хүн ардын эрхэм дээд эрмэлзлэл мөн хэмээн үзэж, хүмүүс эзэрхэг засаглал, дарлалын эсрэг өөрийн эрхгүй эцсийн арга болгон зэвсэглэн босоход хүргэхгүйн тулд хүний эрхийг хуулиар хамгаалах нь зайлшгүй чухал гэдгийг анхааран, улс түмний хооронд нөхөрсөг харилцаа хөгжүүлэхэд тус дөхөм үзүүлэх шаардлагатайг харгалзан, Нэгдсэн Үндэстний Байгууллагад нэгдсэн улс түмэн хүний үндсэн эрх, бие хүний нэр төр, үнэ хүндийг сахин хамгаалах, эрэгтэй, эмэгтэйчүүдийн тэгш эрхэд итгэл төгс байгаагаа Дүрэмдээ нотолж, улам өргөн эрх ёөлөөт нөхцөлд нийгмийн дэвшил, амьдралын нөхцлийг сайжруулахад дөхөм үз'
  },
  slv: {
    iso6393: 'slv',
    fixture:
      'ker pomeni priznanje prirojenega človeškega dostojanstva vseh članov človeške družbe in njihovih enakih in neodtujljivih pravic temelj svobode, pravičnosti in miru na svetu; ker sta zanikanje in teptanje človekovih pravic pripeljala do barbarskih dejanj, žaljivih za človeško vest, in ker je bila stvaritev sveta, v katerem bi imeli vsi ljudje svobodo govora in verovanja in v katerem ne bi živeli v strahu in pomanjkanju, spoznana za najvišje prizadevanje človeštva; ker je nujno potrebno, da se človekove pravice zavarujejo z močjo prava, da človek ne bi bil prisiljen zatekati se v skrajni sili k uporu zoper tiranijo in nasilje; ker je nujno potrebno pospeševati razvoj prijateljskih odnosov med narodi; ker so ljudstva Združenih narodov ponovno potrdila svojo vero v temeljne človekove pravice in dostojanstvo in vrednost človekove osebnosti, v enakopravnost moških in žensk in se odločila, da bodo podpirala družbeni napredek in ustvarjanje boljših življenjskih pogojev v večji svobodi; ker so '
  },
  ayr: {
    iso6393: 'ayr',
    fixture:
      "UNANCHASA, aka pachana jaqejh munañanïsina, cheqpacha amuyasisa, cheqa thakir sarjhatasa, jilan sullkanjama arnaqasa, jan nuwasisa utjañaru wayt'asiñ yati; UNANCHASA, jaqen walinkañapataki wakisir arunaka armasna, yaqhep jaqejh masinakaparu khuyañ autuyi, mututanakasti, uñatatasisa, wajcha kankañapa atipasna, jan khitirus ajhsarasa, cheq-cheqa qhana arumpi arustatasjhapjhe; UNANCHASA, jaqen walinkañapataki inoqat arujha arjhatatäñapaw jan jaqe ñanqhachirinakaru ch'ajhwa qalítasna waninchapjhañapataki; UNANCHASA, taqpacha markanakajh kunti munapjhe ukanaka jikjhatañatakiejh jupanakpacha sumäñat arusthapisipjhañapaw; UNANCHASA, Mathapit Mayachat Markanakan Arupa taqjhatasna akham markanakajh amuyasi: Taqe mayniwa, chachas warmis, jaqe kankañanísinjha, ch 'amachasisna má ch 'ulla chachjama jaqen walinkañapa jíkjhatañaru wayt'asipjhe; UNANCHASA, taqe mrakanakajh Matahapit Markanakamp chika akham amtapjhe: sapaqat markanjha aniw jaqejh inaki arknaqatäkaspati; jakañapans yänakapans arjhatatä"
  },
  bem: {
    iso6393: 'bem',
    fixture:
      'Apo kwaba ukwishiba ubucindami bwa muntu nomulinganya pamo ne nsambu shishifwile kufumyapo ku muntunse nge shinte lya buntungwa, umulinganya pamo nomutende pano isonde, Apo uku kana posako mano nokusula insambu sha muntu fya lenga imicitile ya bunkalwe yikalifya amatontonkanyo ya bantu, elyo nokupilibula imikalile ya mu calo umo abantu bonse bengala sekelamo mu nsambu sha kulanda nokusumina ifyo balefwaya ukubikapo nokula ikala ukwabula icintinya nokubulilwa fyalisoswa nge fikabila nganshi umuntu onse, Apo cikankala, nga cakuti umuntu tali nokula patikishiwa ukuilubula, nge nshila yakushalikishako, ukulasangukila aba buluku nabalya banyantilila abanabo, mukuti insambu sha muntu shifwile ukucingililwa na mafunde, Apo caba cikankala ukutwala pantanshi icumfwano pakati ka fyalo, Apo abantu bamu kabungwe kafyalo fyaikatana muli kalata balibwekeshapo isubilo mu nsambu, mu bucindami no bukankala bwa muntu pamo nomulingaya pakati ka baume nabanakashi pamo nokuipela ukutwalilila abuyantanshi m'
  },
  emk: {
    iso6393: 'emk',
    fixture:
      'Bani fabadenɲa tɔmasere le ye, hɔrɔya ni telen ani jususuma di dunuɲa dɔ, Bani adamaya lasabati lɔnbaliya ni a la gboyaɲɛ le nanin benkanni di mɛn ka mɔɔlu lamuriti, ka kɛ sababu di fana ka mɔɔlu kunna fulen, ka alu lɔ hɔrɔya ɲinina ka alu bɔ misikinaya dɔ, Bani adamaya lakanda ye wajibi le di, fo jamana ye kɛ jamana dafani le di sariya bolo ma, wole ye a kɛla mɔɔlu tɛ muriti ka don jɛdɛ makadan waa la, Bani jamanalu la tɛɛbɛn ni alu la kaninteya ye fen ne di mɛn kakan ka sɛnbɛnteya, Bani jamana mɛnnu ye "ONU" dɛkuruba kɔnɔ, wolu bara alu kan di ko alu di adamaden nakadan, ka a lawuriki ka ban ka cɛ ni muno lakaɲa ko bɛɛ dɔ, Bani alu bara alu kan di fana, ko alu di adamaya lafasa, ka adamaden la hɔrɔya dafa sila bɛɛ kan, Bani, bɛɛ bɛnni miriya kelen ma, ka a lɔ adamaya lasabati ma, wo ye wajibi le di bɛɛ ɲɛ, walako miriya wo ye se lataamala sila bɛɛ kan, "ONU" gbaraba bara a kandi: ko adamaden lakanda sariya ɲin bara kɛ dunuɲa bɛɛ ye wajibi di, sa bɛɛ ye a to i hankili la, ka i tɛsidi,'
  },
  bci: {
    iso6393: 'bci',
    fixture:
      "Kɛ ɔ fin kɛ sran kwlakwa i sran bulɛ ɔ fin blɔlɔ'n ti, kɛ i sran-mmla ɔ nin sran kwlakwla liɛ'n sɛ'n ti, kɛ isɔ nin ye ɔ nin fɔundi, nanwlɛ atin, aklunjɔɛ ba mɛn nun'n ti Kɛ ɔ fin kɛ sɛ be si'a sran-mmla mun, nan sɛ be bu'a be like fi, i sɔ nin yɛ ɔ fa sa tɛtɛ yewa'n ba'nti, sangɛ kɛ ɔ fin kɛ be seli kɛ mɛn nga mɔ i nun sran mun be di be fɔundi, mɔ be kwla be kan be klunklo ndɛ, be kwla be sɔ be klunklo like, mɔ sɛkunlɛ ɔ nin yalɛ b'a jaso su, i sɔ mɛn mɔ be wan sran kundɛ i dan'n ti Kɛ ɔ fin kɛ i dan lika nin yɛ le kɛ ɔ fata kɛ mmla su awa yɛ ɔ nian sran-mmla mun be suɔ, kɛ ɔ ko yo nan b'a mianmian-man sran nan w'a faman ya w'a jaso-man be nga be fa kwlalɛ nin sran tɛtɛ yolɛ be fa be tintin i su be wun'n ti Kɛ ɔ fin kɛ like nga ɔ ti kpa dan yɛlɛ mɛn mun b'afiɛn janvuɛ kekle diwa'n ti Kɛ ɔ fin kɛ mɛn unmuan nun nvle mun be yali be wan be kan be sie su yekun kɛ be te lafi sran-mmla su dan, sran ɔ ti like dan, ɔ le'a gua, bla nin yasua be sɛ. Be wan i sɔ'n ti, like nga ba ko yo nan sran "
  },
  btb: {
    iso6393: 'bum',
    fixture:
      "Eyóñ bia noñ na fili, sosoo ai mvoe bia so bia olugu biave ekokom mod. Eyóñ bia noñ na fili ya nyol ai a nsisim ene dzom ya mod ose ayi, adzeñe fe, ai na ndimi, tege yene, ebiandi y'akar so e minsingi ai minyanda a minnam. Eyóñ bia noñ na ngomena ayian kala enyiñ asu e na bod be za bam nge batibili bo. Eyóñ bia noñ na fulu mbga etam, fulu anyañ, fulu ediñ ndzo ene mfi asu mie bod ya minnam. Eyóñ bia noñ na Akōk Memvende Ekuan Elad Meyoñ amem na aluman asu na enyiñ bod bese etebe etu dzia. Eyóñ bia noñ na abui minnam mbamena ai Ekuan Elad meyoñ mo yebe ovañ ye na si ese ebaala memvende m'enyiñ ma. ai na ovañ te otôbo mbog vom ose. Binga yen hne na Ekuan Elad meyoñ y'anoñ Akōk Memvende ya Mengan bod ane zen, ane ndzoñ bia yian wulu asu etie fili dzaan. Antoa na a zen te, a ndzoñ te nnam ose obele nkil woe, ve da, ntsogan one mbog: olugu etie mod."
  },
  epo: {
    iso6393: 'epo',
    fixture:
      'Pro tio, ke agnosko de la esenca digno kaj de la egalaj kaj nefordoneblaj rajtoj de ĉiuj membroj de la homara familio estas la fundamento de libero, justo kaj paco en la mondo, Pro tio, ke malagnosko kaj malestimo de la homaj rajtoj rezultigis barbarajn agojn, kiuj forte ofendis la konsciencon de la homaro, kaj ke la efektiviĝo de tia mondo, en kiu la homoj ĝuos liberecon de parolo kaj de kredo kaj liberiĝon el timo kaj bezono, estas proklamita kiel la plej alta aspiro de ordinaraj homoj, Pro tio, ke nepre necesas, se la homoj ne estu devigitaj, sen alia elektebla vojo, ribeli kontraŭ tiranismo kaj subpremo, ke la homaj rajtoj estu protektataj de la leĝo, Pro tio, ke nepre necesas evoluigi amikajn rilatojn inter la nacioj, Pro tio, ke la popoloj de Unuiĝintaj Nacioj en la Ĉarto reasertis sian firman kredon je la fundamentaj homaj rajtoj, je la digno kaj valoro de la homa personeco kaj je la egalaj rajtoj de viroj kaj virinoj, kaj firme decidis antaŭenigi socian progreson kaj pli altniv'
  },
  pam: {
    iso6393: 'pam',
    fixture:
      'Uling ing pamangilala king likas a karangalan at king pante at ding e alingad a karapatan ding sablang lahi ding tau iyang pundasyun na ning kalayaan, hustisiya at kapayapan king yatu. Dapat aintingdian ding sablang bibilug karing sablang pamilya king atin la naman karapatan kalupa ra ding aliwang tau. Anggang iti e tamu aintindian, e miral ing kalayan, hustisiya at kapayapan. Uling e tamu pa maie ulaga at pamanamak karing karapatang pantau mamungang pamaglapastangan labag king konsensiya da ring sablang tau, at dasan mu rin king yatu king atamasa ring tau ing kalayan king pamagsalita at pamaniwala at kalayan king pamagnasa, pamikakunu at kasakitan a iyang papakilala nang pekamatas a kapagnasan ning karaniwang tau. Lebagan do ring karapatang pantau ding dakal a tau. Ding gera at aliwa pang kararaptanan ilang bibie pasakit karing tau agpang king istorya at king mabilug a yatu. Ing yatu a nung nokaring ding tau atamasa ra ing karapatang magsalita nanu man ing a isip da, mamili king saril'
  },
  tiv: {
    iso6393: 'tiv',
    fixture:
      'Er i fe er, icivir man mkpeiyol u ior mba ken tsombor u umace ka imaagh ki mlu u kpan ga man mer u ijir sha mimi man bem u tar cii, Er se fe ser, mban u iko-iwan, man u nengen er, akaa a i doo u a er a orumace ve a lu vough la gba kwagh ga yô, ka i er a or caveraa je i kera bee orumace ga, sha nahan yô, isharen i vesen shin tar hegen yô, ka u umace cii ma ve lu a ian u ôron kwagh ken igbar, pasen jighjigh ve u nan, lun ken mlu u cian suluwa suluwa ga, shin ken ibanave kpaa ga, Er i doo u a nzughul a ma kweior zan zan je a hingir u vea kera fa kwagh ugenegh u vea er ga, saa u moughun num a mba ve lu nan ve ican yum la yô, hemba kan a inja u hanma tar u lu aa atindi aa a lu a iwasen sha u kuran ior mba ve lu isheer yô, sha hanma gbenda u bo cii, Er i lu semakwagh u kenden a mzehemen u mtem u bem bem u ityar sha won cii, Er ior mba ken Mzough u Ityar sha won cii atindi a ve a seer taver jighjigh man mkepeiyol u umace man civir man ulum u hanmaor, nomsoor kua kwase cii ve lu kwaghmôm yô, v'
  },
  tpi: {
    iso6393: 'tpi',
    fixture:
      'Long luksave olsem olgeta manmeri mas igat respek, na olgeta manmeri long dispela graun igat wankain raits long bihainim laik bilong ol, long gat lo na oda na gat gutpela sindaun. Long ol hap nambaut taim manmeri i no luksave long raits bilong ol narapela manmeri, dispela tingting we ol manmeri mas gat fridom long toktok, gat fridom blong igat bilip, fridom long noken poret na fridom long laikim ol kainkain samting. Dispela em i bikpela samting bilong olgeta manmeri. Long wanem em i gutpela stret, sapos man i no inap hariapim narapela long halivim em, olsem laspela samting, long i go egensim man o meri igat olgeta pawa insait long kantri na husat i save lukautim ol pipol bilong em long nogut pasin tasol, na dispela raits blong ol manmeri em lo bai lukautim na banisim. Long wanem, em i gutpela stret long strongim pasin bilong kamapim gutpela sindaun namel long ol kantri. Long tingting bilong ol manmeri we i memba bilong Yunaited Nesens insait long Jata, strongim gen bilop bilong ol long'
  },
  ven: {
    iso6393: 'ven',
    fixture:
      'Vhunga u ḓivhea ha u dzhiela nṱha lwa mvele ya tshirunzi tsha muthu na ndingano na pfanelo dza vhathu vhoṱhe zwi murango wa mbofholowo, vhulamukanyi na mulalo ḽifhasini, Vhunga u dzhielwa fhasi na u tsikeledzwa ha pfanelo dza vhathu ho bveledza zwiito zwa vhuveveru vhu fhandulaho luvalo lwa muthu, na u ḓa ha shango ḽine khaḽo vhathu vha ḓo ḓiphina nga mbofholowo ya u amba na u tenda kha zwine vha funa, na u vhofholowa kha nyofho na zwinyagwa ḽo ḓivhadzwaho sa dzangalelo ḽihulwane ḽa vhathu zwavho, Vhunga zwi zwa ndeme, arali muthu a sa faneli u kombetshedzwa nga u shaya iṅwe nḓila, u vutshela vhutambudzi na vhutsikeledzi, uri pfanelo dza vhuthu dzi tsireledzwe nga tshumiso ya mulayo, Vhunga zwi zwa vhuṱhogwa u ṱuṱuwedza mvelaphanḓa ya vhukonani havhuḓi vhukati ha dzitshaka, Vhunga vhathu vha Mbumbano ya Dzitshaka vho khwaṱhisedza kha Tshata lutendo lwavho kha pfanelo dza vhuthu dza ndeme, kha tshirunzi na ndeme ya vhuvha ha muthu na kha ndingano ya pfanelo dza vhanna na vhafumakadzi na'
  },
  ssw: {
    iso6393: 'ssw',
    fixture:
      'Njengoba kwatiswa ngekubakhona ngekwemvelo kwesitfunti sebuntfu, nekulingana lokufananako, nangekuba nemalungelo langenakwemukwa noma langenakutsatfwa kulelo nalelo lilunga lelingumndeni webuntfu, konkhe loku‐ke kungumgogodla noma kusisekelo senkhululeko, sekwenta lokulungile nesekuba nekuthula emhlabeni wonkhe jikelele, Nanjengoba , kunganaki nekwedzelela emalungelo ebuntfu kugcine sekudale tento letinelunya nebulwane kwabuye futsi kwatfukutselisa nembeza wesintfu sonkhe, kwashabalalisa sifiso nekulobitela kwekutsi etikhatsini letitako sintfu sitawutfokotela kuba nenkhululeko yekukhuluma, nekukholwa, nenkhululeko yekuhlala ngaphandle kokwesaba nekweswela, konkhe loku‐ke sekumenyetelwe njengetifiso letimcoka kabi eluntfwini, Nanjengoba‐ke kwekutsi lomunye umuntfu akufanele kutsi aze aphoceleleke kubalekela noma ekucindzetelelekeni kutsi atsatse tinyatselo letitsite kuze atikhiphe ekuphatfweni ngelunya nangekucindzetelwa, kuze emalungelo esintfu avikeleke ngalokusemtsetfweni, Njengoba k'
  },
  nyn: {
    iso6393: 'nyn',
    fixture:
      "Ekitiinisa ky'omuntu ekyobuhangwa nikiingana nobushoborozi obutakabaasa kwihwaho eka yabantu boona heza niyo ntandikirro y'oburinganiza omu nsi yoona. Obutagyendera ahaabugabe bw'abantu burugiremi ebikorwa bibi ebisiisire emiteekatekyere y'abantu kandi okuhika ahabwire bw'abantu baraagirire obugabe bw'okugamba ekibarikwenda bakikiririza n'omu kibarikwenda bataine kibari kutiina nikyo abantu baburiijo bashemereire kurwanirira. Omuntu ku araabe atari wokugyemwa kugomera obutegyeki bubi nikimanyisa ngu obugabe bw'omuntu bushemerire kurindwa entegyeka ey'amateeka. Ekibiina ky'Amahanga Ageeteraine omu kihaandiiko kyakyo nikihamiza kimwe kukirikwikiriza omu magara g'obuntu nomukitiinisa n'omuhendo gwomuntu kandi kimaririra okukora ekikirikubaasa kureebeka ngu omutindo gwamagara obushoborozi n'amagara g'omuntu nikihuru munonga omu kuhikiriza ekigyendererwa kyekihandiko eki. Nahabwekyo Orukiiko Orwanahanga Ageeteraine (General Assembly) rurangirire ENTUURA Y'OBUNTU AHA BANTU OMUNSI YOONA. Aban"
  },
  kbd: {
    iso6393: 'kbd',
    fixture:
      'Дунейпсо Къэрал Зэгухьэныгъэм (ДКъЗ) и Зэхуэсым егъэӏур; Дунейпсо цӏыхугъэм къыхиубыдэ дэтхэнэ зы цӏыхури зэгухьэныгъэри; мы джэпсалъэр сытым щыгъуи я нэгум щӏагъэтурэ мыбы къыщыхэщ цӏыху хуэфащэхэмрэ хуитыныгъэхэмрэ я нэӏэ зэрытрагъэтым, хуащӏ лъытэныгъэм егъэджэныгъэ-гъэсэныгъэ гъуэгукӏэ зрагъэужьыну; хэгъэгу кӏуэцӏхэми дунейпсоми кӏуэхукӏэ нэхъри зыщызужь амалхэр зыхуагъэщхьэпэурэ мы зэгухьэныгъэшхуэм хэт къэралхэм езым я лъэпкъхэри, я унафэм щӏагъэт нэгъуэщӏ къэралхэм я лъэпкъхэри къызэщӏиубыдэу, дунейпсом и дэнэ щӏыпӏи мы цӏыху хуэфащэхэмрэ хуитыныгъэхэмрэ лъэщу щызрагъэкӏуэным, къыщащтэным, щагъэзэщӏэным хущӏэкъунхэу, цӏыху хуэфащэхэм теухуауэ жылагъуэхэми лъэпкъхэми я зэхуэдэ идеал щапхъэхэр къэзыгъэув мы дунейпсо джэпсалъэр.'
  },
  iii: {
    iso6393: 'iii',
    fixture:
      'ꃰꊿꑱꈐꊿꂷꃅꐥꋭꐯꒈꃅꐥꌠꌋꆀꌅꅍꏚꍆꌠꆹ，ꋧꃅꄿꐨ，ꑗꉬꌋꆀꄮꐽꃅꐥꌠꅉꃀꉬ。 ꊽꋩꅍꏭꉜꀋꒉꌠꌋꆀꉜꄸꑠꆹꅢꎆꌊꆀꍀꆿꃅꇏꅊꀐ，ꃅꇏꋋꈨꆹꃰꊿꂄꉌꇬꍍꄀꌠꉬ，ꊿꂷꈀꐥꃅꐥꋭꅇꉉꈋꍣꌋꆀꑇꌠꄿꐨꐥ，ꄷꀋꁨꐬꀋꆠꃅꐥꌠꌋꆀꇮꃪꃅꑟꇁꌠꋧꃅꂶꌠꆹ，ꈍꄮꅉꆐꉹꁌꏓꂱꀊꂤꉌꉪꅉꉬꄷꄜꇬꄀꄉꀐ。 ꃰꊿꇬꐥꀋꄐꄉꊾꍅꊿꅷꌠꐤꁏꑠꆹ，ꏦꃤꇬꄉꀧꋭꌠꌅꅍꉬ。 ꇩꏤꈀꐥꌠꇢꊭꇬꐮꄮꃅꐥꃆꂮꀻꎆꌠꊥꎆꄻꅐ。 ꉻꏑꇩꏤꏓꂱꐥꇯꌠꏦꃤꁢꊧꇬꊿꊇꌅꅍꊿꑌꇐꁌꐨꌋꆀꅪꃰꐥꒈꃅꐥꌠꌅꅍꑠꉈꑴꌌꉉꄜꋊ，ꄷꀋꁨꀋꎪꃅꄿꐨꊼꇅꀉꒉꃅꐥꌠꐧꋦꀒꁨꆹꌠꌋꆀꐥꐨꄺꅐꌠꀻꎆꆹꎻ。 ꄚꐊꌠꇩꏤꆹꀋꎪꃅꉻꏑꇩꏤꌋꆀꐯꇯꊽꌅꅍꌋꅿꄿꐨꇬꁌꒉꄷꀋꁨꇫꍬꌬꇫꊥꎆꏤꄉꀐ。 ꌅꅍꌋꆀꄿꐨꋋꈨꊿꃅꇫꅉꐚꌠꆹ，ꃅꐮꏤꒃꋋꏢꇬꃅꇬꑟꌠꆹꀋꉬꀋꉆꌠꉬ，ꑠꅹꃆꃀꀉꒉꋋꂷ，ꋧꃅꊽꌅꅍꋋꏢꌌꄜꋊ，ꉹꁌꏓꂱꈀꐥꌠꌋꆀꇩꏤꈀꐥꃅꊋꇤꄉꃅꇫꑟꂿꄷꌠꇬꎕꏦꏢꉬ，ꊾꂷꇫꐥꌠꌋꆀꐧꋦꏲꉻꈀꐥꌠꃅꅉꅉꃅꇬꎺꄉꌶ，ꊋꇤꃅꉙꂘꌠꇬꈴꄉꌅꅍꌋꆀꄿꐨꁌꒉꌠꊥꎆ，ꉈꑴꇩꏤꌋꆀꇩꏤꇢꊭꇬꈴꏁꁈꄉ，ꌅꅍꌋꆀꋋꈨꁳꉻꏑꇩꏤꈧ ꌠꉹꁌꏓꂱꊨꏦꏲꄸ，ꊿꃅꇬꏚꍆꇬꈴꄉꃅꏢꅊꎻ。'
  },
  yao: {
    iso6393: 'yao',
    fixture:
      "Aga ni maufulu gakasapagwa nago mundu jwalijose gigalembekwe ni chiwanja cha United Nations mumkamulano wakolanjikwa Universal Declaration of Human Rights. Pa 10 December, 1948, chiwanja cha United Nations chajitichisye mitwe ja ufulu wa chipago wa mundu jwalijose. M'buku aji tugagopolele mchiyao kuti wandu wa chiyao apate upile wakugamanya nambo soni kugakamulisya masengo maufulu gakulekanganalekangana ga chipago. Ayi tuyitesile soni kuti wandu amanyilile mwampaka apatile chikamuchisyo naga ayiweni kuti boma, mundu, kampani, kapena mpingo yikumlepekasya kutama ni ufulu wakwe mpela yiwatite pakumpa Mlungu. Chiwanja cha United Nations chilichitamilisye jele mitweji, chayiwendile yilambo yayili mamembala gakwe kuti ijenesye posepose jele mitweji kuti wandu ajimanyilie nikujikamulisya masengo. M'yoyo, kugopolelekwa kwa-jele mitweji mchiyao lili litala limpepe lya kamuchisya kwenesya ngani ja ufulu wachipago, nambo soni kuti wandu asimichisye kuti ilambo ni iwanja yenjinji yikusosa kuti wa"
  },
  lav: {
    iso6393: 'lvs',
    fixture:
      'Ievērojot, ka visiem cilvēku sabiedrības locekļiem piemītošās pašcieņas un viņu vienlīdzīgu un neatņemamu tiesību atzīšana ir brīvības, taisnīguma un vispārēja miera pamats, un ievērojot, ka cilvēku tiesību necienīšana un nicināšana noved pie barbariskiem aktiem, kas izraisa sašutumu cilvēces apziņā, un ka tādas pasaules radīšana pasludināta kā cilvēku augstākie centieni, kurā cilvēkiem būs vārda un pārliecības brīvība un tie būs brīvi no bailēm un trūkuma, un ievērojot, ka nepieciešams, lai cilvēka tiesības aizsargātu likuma spēks un cilvēks nebūtu spiests izmantot kā pēdējo līdzekli sacelšanos pret tirāniju un apspiestību, un ievērojot, ka nepieciešams veicināt draudzīgu attiecību attīstību starp tautām, un ievērojot, ka Apvienoto Nāciju tautas Statūtos apliecināja savu ticību cilvēka pamattiesībām, cilvēka personības pašcieņai un vērtībai un vīriešu un sieviešu līdztiesībai un apņēmās sekmēt sociālo progresu un labākus dzīves apstākļus vislielākās brīvības apstākļos, un ievērojot, k'
  },
  quz: {
    iso6393: 'quz',
    fixture:
      'Pachantin ayllu wawaq allin kausaypi kananta yuyaykuspan, kay kamachikuy paqarin. Runaq kausay qasi kusi kausaypi kananpaq, tukuy llakipi kaspapas "justicia" taripananpaq. Kikin runakayninta runa masinkunawan reqsichispa kausananpaq. Runaq runa kayninta sarunchasqata rikuspan, wakin ima mil lay salqa runakunaq runa masinta ku\'muchisqanta, waqachisqanta rikuspan, kay ancha sut\'i kamachikuykuna rikhurin, ashwan allin, ashwan sumaq kausay runaq taripananpaq; mana imamanta manchakuspa, mana yarqayta muchuspa, sut\'i simipi rimarispa qasi kausaypi kananpaq. Runapaqpuni tukuy ima allinkunapas kamasqa karqan. Chay kamasqa kasqanta reqsispan; "derechon" kasqanta yachaspan kay simikuna kamakun qharipas warmipas kushkachasqalla kausanankupaq, sapa p\'unchay ashwanta jananchakuspa. Kausanankupaq: paykuna ukhupipas, llapa ayllu runa uldiupipas, sapanka runataqmi tukuy llakimanta qespisqalla purikunan, llapa "mundo" pachantinman qasi kausay mast\'arikunanpaq. Teqse muyuntin "munduq" "estadonkuna" juñu'
  },
  src: {
    iso6393: 'src',
    fixture:
      "Cunsiderende chi su reconnoschimentu de sa dinnidade inerente a totu sos membros de sa famìlia umana e de sos deretos issoro eguales e inalienàbiles costìtuit su fundamentu de sa libertade, de sa zustìssia e de sa paghe in su mundu, Cunsiderende chi su misconnoschimentu e su dispretziu de sos deretos de s'òmine ant zutu a atziones de barbaridade chi bulluzant sa cussèntzia de s'umanidade e chi sa bènnida de unu mundu in ue sos èsseres umanos ant a esser lìberos de faeddare e de creer, liberados dae su terrore e dae sa misèria, est proclamadu comente s'isetu prus mannu de s'òmine, Cunsiderende chi est essentziale chi sos deretos de s'òmine siant garantidos dae unu rezìmene de deretu, a manera chi s'òmine non siat custrintu prus, comente remediu estremu, a si bortare contra a sa tirannia e a s'opressione, Cunsiderende chi est essentziale a animare s'isvilupu de sas relatziones de amighèntzia intre sas natziones, Cunsiderende chi in sa Carta sos pòpulos de sas Natziones Unidas ant proclam"
  },
  rmy: {
    iso6393: 'rup',
    fixture:
      'Ti-atsea câ pricânushtearea-a nâmuziljei nativâ shi-ndrepturli egali shi nealienabili-a tutâlor membrilji-a taifâljei a omlui easti fimelju-a li-bertatiljei, a-ndriptatiuljei shi-a irinjiljei din lumi, Ti-atsea câ nitinjisearea shi atimusearea-a-andrepturlor a omlui dutsea la comportâri barbari cari u prusvulisea sinidisea-a uminitatiljei, sh-ti-atsea câ adrariljei lumi tu cari iatsâli umineshtsâ va s-hârseascâ di libertatea di zbor shi pisti shi va s-hibâ liberi di firca shi urfanjea easti proclamatâ ti nai ma analtul ideal a cafi unlui om, Ti-atsea câ important easti câ-ndrepturli-a omlui s-hibâ afiriti cu sistemlu juridic câ s-nu hibâ omlu pimtu pi-atsea ta s-mutâ contra-a tiraniiljei shi tirinsearea, Ti-atsea câ important easti câ sâ-lji si da indati developarea-a relatsiilor di uspitsâlji anamisa di miletsli, Ti-atsea câ miletsli-a Natsiunilor Uniti cu Harta nica nâ oarâ u confirmarâ pistusinea-a lor la-ndrepturli fundamentali-a omlui, la nâmuzea shi valoarea-a personalitatiljei u'
  },
  sco: {
    iso6393: 'sco',
    fixture:
      'Forsameikle as kenning for the inherent dignity and for the richts, equal and nane-alienable, o aw members o the human faimily is the foond o freedom, justice and peace in the warld, Forsameikle as misregaird and contemption for human richts hes resultit in barbour acts that hes scunnert the conscience o mankind, and the advent o a warld whaur aw human sowels enjoys freedom o thocht and speech, and quittance frae dearth and dreid hes been proclaimed the tapmaist aspiration o the commonty, Forsameikle as it is necessar, gin man be no gart tak recourse tae rebellion as a hinmaist resort conter tirannie and dounhaudenment, that human richts shuld be beildit by the rule o law, Forsameikle as it is necessar tae gar freendly relations atween nations aye win forrit, Forsameikle as the peoples o the Unitit Nations hes in the Chairter affirmit aince mair their faith in fundamental human richts, in the dignity and worth o the human person and in the equal richts o men and wemen and hes resolved '
  },
  tso_MZ: {
    iso6393: 'tso',
    fixture:
      "Hi ku xixima le svaku a ku hlonipha ka lisima ni tinfanelo leti ti lumbaka a lixaka la ximunhu y ndlela yò sungula leyi yi fanelaka ku landziwa a ku kota ku a vanhu va hanya è nkhululekeni, hi kurhula ni ku fana à misaveni; Hi ku tiva le svaku a ku kala ku tiva ni ku xixima a tinfanelo tà wumunhu ku bzalile nsele leyi yi nga hombolokisa mahanyele ni mapimisele ya ximunhu, ni ku tiva le svaku a ku navela kukulu ka vanhu va misava y ku hanya è kurhuleni, na va nga thxaviseliwi kumbe ku hanya hi wusiwana, na va nga thxavi ku khuluma, ku veka mavonele kumbe ku kholwa; Hi ku xixima le svaku y sva lisima a ku vikela tà tinfanelo tà ximunhu hi ku bzàla mafùmele lawa ma hloniphaka tinfanelo lèti, svanga ndlela ya ku heta wupfukeli leli vanhu va liyendlaka hi kola ka kutwa tixànisà ni wukhinyavèzi; Hi ku xixima le svaku y sva lisima a ku seketela ni kuyandzisa a wunghani xikarhi ka matiku hin'kwawu ya misava; Hi ku xixima le svaku a svithsungu sva matiku ya misava svi haxile, hi kola ka papèla,"
  },
  men: {
    iso6393: 'men',
    fixture:
      'A jifa kiliyei na kɛ numu vuu kpɛlɛɛ ti maa hɛwulei lɔ towa kpaupau le laha va, tɔnya kɛɛ ndilɛli dunyihu. A jifa ngawulɛɛhu kɛɛ baagbuala nuvugaa ti lɔnyisia ma ti wanga a pie hindangaa na hii i wotɛa a nɛmahugili waa nuvuu ma, dunya ninahu mia mahoingɔ muvuu i gu i yɛpɛ kia ngi longɔla, kɛɛ ngi lanayei kɛɛ ngi lima hinda. A jifa maa ii houni nu mu vuu i wote a kɔ gɔmɔ mahaya nyamu nyamu kɛɛ nduwɔ ya yeya, kɛ mahoingɔɛ sawei i nuvuu lɔnyii mavale, A jifa mahoingɔ ndiamɔyei na ndɔlesialuahu i lɛgulɔma, A jifa nungei nasia ti ndɔlei kpɛlɛ ti woyilɛi na hu ti lanaya gɛnga kɔlɔ yayilingɔihu, Kɛɛ nuvuu lɔnya, ngi nuvuu ya, ngi yɛyei kɛɛ hindui taa nyahii ti lɔnyɛi maahɛwu lei, kɛɛ gbɔma ti ti lia yilinga kɔ yange yange kɛɛ ndevu yekpe la i lɛ gulɔma. A jifa ndɔlei nasia ti dunyi hu ti lahei wumbua a ngoyila kɔɔ ti tɔ kɛ baagɔ ma a yɛlɔ na nuvuu va kɛɛ ngi lɔnya ya va, A jifa kiliyei yaa numu kpɛlɛhu hinda yayilingɔi ji a lɛlɔ gulɔma, Fale naa Komɛwai na ta toli a Gɛnɛla Asɛmbili Ndɛnga Yɛ '
  },
  fon: {
    iso6393: 'fon',
    fixture:
      'Ee nyi ɖɔ hɛnnu ɖokpo mɛ ɔ, mɛ ɖokpoɖokpo ka do susu tɔn, bɔ acɛ ɖokpo ɔ wɛ mɛbi ɖo bo e ma sixu kan fɛn kpon é ɖi mɛɖesusi jijɛ, hwɛjijɔzinzan, kpodo fifa ni tiin nu wɛkɛ ɔ bi e ɔ, Ee nyi ɖɔ nukumamɔ jɛ numɛ kpodo wangbɛnu sɛn ɖeɖee na zɔn bɔ gbɛtɔ na do tiin nyi lɛ wɛ nɔ dɔn alannuwiwa ɖee nɔ zɔn bɔ gbɛtɔ nɔ fɔn gu e, lo bɔ nu taji ɖee hudo gbɛtɔ ɔ wɛ nyi ɖɔ gbɛ e mɛ gbɛtɔ lɛ ma na nɔ mɛkannu ɖo xoɖiɖɔ sin alinu kpodo nuɖiɖi lo bo na tɔn sin adohuhu kpodo ya kpo mɛ é ɔ, Ee nyi ɖɔ dandanmɛ wɛ e ɖo na jɛ hun do sɛn ɖee na zɔn bɔ gbɛtɔ na do tiin nyi le gbɔn acɛɖiɖo sin alinu se na zɔn bɔ gbɛtɔ ma na lin ɖɔ emi ɖo na ɖe emiɖee sin mɛkannu kpo yadonumɛ kpo e ɔ, Ee nyi ɖɔ é ɖo dandanmɛ bɔ e ɖɔ na ɖe alinu wennyinyi ee ɖo na tiin nyi ɖo to ɖokpoɖokpo tɛntin e ɔ, Ee nyi ɖɔ, ɖo xwedowema elɔ mɛ o wɛkɛ ɔ bi lɛ vɔ mɔ nu jɛ acɛ kpo do sisi dodo e gbɛtɔ ɖo na ɖo e, ɖo mɛɖesunɔnyinyi kpodo susu e do na xɔ nu gbɛtɔ e ɖo acɛ kpodo sisi sunnu kpodo nyɔnu tɔn kpo na nyi ɖokpo ɔ; lo bɔ ye lɛ yalɔ akɔ́'
  },
  nhn: {
    iso6393: 'nhn',
    fixture:
      'Yolki, pampa ni tlatepanitalotl, ni tlasenkauajkayotl iuan ni kuali nemilistli ipan ni tlalpan, yaya ni moneki moixmatis uan monemilis, ijkinoj nochi kuali tiitstosej ika touampoyouaj. Pampa tlaj amo tikixmatij tlatepanitalistli uan tlen kuali nemilistli ipan ni tlalpan, yeka onkatok kualantli, onkatok tlateuilistli, onkatok majmajtli uan sekinok tlamantli teixpanolistli; yeka moneki ma kuali timouikakaj ika nochi touampoyouaj, ma amo onkaj majmajyotl uan teixpanolistli; moneki ma onkaj yejyektlalistli, ma titlajtlajtokaj uan ma tijneltokakaj tlen tojuantij tijnekij tijneltokasej uan amo tlen ma topanti, kenke, pampa tijnekij ma onkaj tlatepanitalistli. Pampa ni tlatepanitalotl moneki ma tiyejyekokaj, ma tijchiuakaj uan ma tijmanauikaj; ma nojkia kiixmatikaj tekiuajtinij, uejueyij tekiuajtinij, ijkinoj amo onkas nopeka se akajya touampoj san tlen ueli kinekis techchiuilis, technauatis, kinekis technauatis ma tijchiuakaj se tlamantli tlen amo kuali; yeka ni tlatepanitalotl tlauel moneki'
  },
  dip: {
    iso6393: 'dip',
    fixture:
      'Nä caa athëëk tö e baai thök e thai yic gäm ku yithkën thoŋ tö e nyiinkën, kek aalau enhom ku thoŋ, ku dör e pinynhom. Ku nä ci yiith e raan mar ekɔc nhiim, ku dhalkek bi kuöc lööi bɛ̈i epion e raanic, ku aye raan thök eben waai bi bɛn epinynhom bi raan liɛ̈k e lau enhom e jamdeic, ku thëëk yanhde, ku ci bën rioc, ku ŋɔŋ. Ku na pɛth bi lööŋ raan aaköuny, bi raan cii nyany e rin eköuc löui ye löui yën, ku tɛŋ enyin piny. Ku nä ci wut ethai matyiic, yen gam e cök elööŋiic lön de raan yith tëëm kua thɛ̈ɛ̈k, ku na thöŋ möc nhöm këk e tik e yithiic kua ci tëëm bik röt aaköuny bi pir piath baai ku lɛ̈u yic. Ku na ci bɛ̈i tö akutic gam bik ka cin mat kek akut e mawuut epinynhom(UN), bik yith e raan ku lau enhöm kua thɛ̈ɛ̈k aatiit. Ku na ŋic eben lön e yith kak ku lau enhöm alëŋ köuny dit kua thɛ̈k e gɛ̈m gɛ̈m ken yic. Ka kut dit adhël. cööt ecɛ̈ɛ̈l ken yic erin yith e raan, erin yën e tën eröm ethai eben thin, ku(UN), wic bi raan tic e ciɛ̈ŋic ku tëu ka nyiin piny ecɛ̈ɛ̈l ken yic, bi athɛ̈k e'
  },
  kde: {
    iso6393: 'kde',
    fixture:
      'Lisiku lya 10 Disemba 1948, Lukumbi Lukulu lwa Umoja wa Vilambo lunihaula na kuhumya lilove lya vilambo lya wasa wa vanu. Lilove alino lihumile baada ya chilambo chohechohe kupanyana ding’ondo ding’ulu dimbili. Lukumbi anelwo lulembedile kila chilambo chihumye lilove alino livahwikile vanu vake kwa kulangudya, kusomesa, kusomela, kuhaula n’disule na n’disehemu dinji kuvele na ilimu. Ili kuhinikiha kuchidono wasa wa vanu unawuniwa, na Tansania inaunila wasa anewo, lilove alino lihumile M’chimakonde ili valembela usoma vavike wasa wene mun’tima mwavo vene na vanu vanji. Koka chive chihinde cha kukonyelela kuwuniwa kwa wasa wene m’manu na lyene lipanda. Vanu vohevohe vavelekwa valendene na wasa wavo unalandana. Umoja wa Vilambo uhumije lilove alino m’malove lapeyapeya na lakakamadidye ili kila munu amale wasa wake. Wasa unang’owo wako. Uumale wasa wako, yangata uvahaulila vanji vanu na uwunile wasa wene muchi wako na wa vanji vanu.'
  },
  kbp: {
    iso6393: 'kbp',
    fixture:
      'Yee ɖitisaa se pʊmʊna ɛyaa se pɛwɛɛ kɩmaŋ wala ɛsɩndaa nɛ pɩkɛna wazaɣ pʊyʊ kɔyɔ, ɖitisaa ɖɔɖɔ se peeɖe ɛjaɖɛ yɔɔ tɩ-yɔɔ wɛʊ, toovonum nɛ lahɛzɩyɛ palɩɣna; Ɖɩnaa se ɛyʊ wala tɔm kɩɩsɩŋ nɛ tɩ-yɔɔ kɩɩɖɔŋ palabɩna nɛ kɩwɛɛkɩm tɔyɩ nɛ pɩcɛyɩɣ ɛyaa. Mbʊ pacaɣ se ɛjaɖɛ ɛlɛɣzɩ wɛtʊ, ɛyaa wɛɛ pa-tɩ yɔɔ, pɔyɔɔdʊʊ yem faaa nɛ pɩwɩlɩ se palɩ kʊñɔŋ taa, sɔɔndʊ ɛɛtasɩɣ-wɛ kpaʊ; Yee waɖɛ kewiyaɣ ɛkandayɩɣ ɛyʊ wala yɔɔ camɩyɛ kɔyɔ, wiɖiyi pɩɩkaɣ ɛyʊ ɛnʊ kɛnaʊ kɩjɛyʊʊ se ɛkʊyɩ kewiyaɣ ŋga kɔ-yɔɔ se kalakɩ-ɩ ñaŋ; Pʊwɛ camɩyɛ se pasɩna ajɛya, akpeeti nɛ ala taabalɩyɛ ɖʊʊ tʊmɩyɛ ɖeu nɛ puhuuna-yɛ; Ɖinaa se ajɛya kɩgbɛndʊʊ ŋgbɛyɛ paɣtʊ takayaɣ taa kɛ ɛyaa kpeekpe tasɩ tisuu ɛyʊ wala nɛ ɛ-wazaɣ pɔ-tɔm, nɛ pɔtɔ se abalaa nɛ halaa pɛwɛ kɩmaŋ wala ana a-ɛsɩndaa; mbʊ labɩna nɛ paka ñʊʊ se pekpeetiɣ samaɣ sɩnaʊ tʊmɩyɛ yɔɔ nɛ pɩsa pɛwɛɛ pa-tɩ yɔɔ camɩyɛ; Ajɛya kɩgbɛdʊʊ ŋgbɛyɛ taa ajɛya tisaa se alakɩ nɛ ɛyaa kpeekpe ña ɛyʊ wala, ɛlɛ pʊwɛɛ se ŋgbɛyɛ ɛɖʊ-yɛ nisi; Yee ɛyaa tɩŋgɛ ɩwɛna lɩmaɣzɩyɛ kʊɖʊmɖɩyɛ ɛyʊ wala n'
  },
  tem: {
    iso6393: 'tem',
    fixture:
      'Ɔwa ta salata kʌsɔthnɛ ʌyiki a komʌnɛ aŋ fəm akəpet, ɔwa yi ʌmari məthənʌnɛ a komʌnɛ ŋa‐e, ŋa yi ʌŋgbeth ŋa rʌwankom, mʌlompi, yi mʌthɔfəl ka nɔru. Ɔwa, kʌ kʌlʌ agbʌp yi kʌsay ʌmari ma aŋfəm akəpet mʌ po kʌrʌ kʌdifəthʌnɛ ʌke po ləsər tʌtemp ta aŋfəm akəpet, ɔwa kə po kʌrʌ ka rʌru ʌre, pə yi naŋrʌ aŋfəm akəpet maŋba naŋ rʌwankom ra kʌfɔf, kʌtʌŋ ɛdina, kəte ba rənes kəpa ye, ʌŋe ŋʌ tha yi mʌfela ma aŋfəm akəpet thɔŋ bɛ nɔru. Ɔwa ɔ fisa ti, kʌmʌ a te gbɔndar aŋfəm rə tʌy o tʌy bɛ mə yɔ ŋa aŋ thʌnthonɛ tə kəfumpər aŋe bət ʌŋfɔsɔ mə thʌlər ŋa‐e, ɔwa tʌsoma, a yi təkə bot ɛthɔ məkunkəla ŋa‐e. Ɔwa a yi təkə sakəthi ʌkɛra ʌke dɛr o dɛr, təkə yɔ tʌthɔf ta rʌru bɛ təmanɛ. Ɔwa tʌsoma aŋfəm ŋa tʌthɔf bɛ aŋ wopʌnɛ ka rʌru, aŋ bot ka mʌsekrʌnɛ maŋ təkə beŋ kʌmʌ aŋ gbasi ɔfu fəlen malane ma kʌsɔŋ aŋfəm akəpet ʌmari akomʌnɛ ŋa, ka ayiki yi to wuni kəpet ɔ yi‐e, kəpa runiŋaŋi, yi bom ŋaŋ a thənanɛ. Ɔwa aŋ bɛŋ təkə səkʌ ro di rʌwankom yi mayi mʌkolo mʌ aŋfəm akəpet. Ɔwa rokɔm kati bɛ tʌthɔf ʌte yi ka ʌŋ'
  },
  toi: {
    iso6393: 'toi',
    fixture:
      'Mbuli mbokunga kulemeka muntu oonse ncizyalilwa ca lwaanguluko lwa mikwasyi yoonse kuba matalikilo akuliiba, kukwabililwa amulawo alimwi aluumuno munyika: Kakuli kutalemeka alimwi akutyola milawo ya lwaanguluko lwa muntu kuleta micito yabujayi mibyaabi kulanyemya akutakkazyika kabotu bantu alimwi kwazungaanya nyika kuti ijane nzila yakwaangulula bantu kuti kabaliiba kukanana zyobayanda alimwi akutobela zyobasyoma alimwi akwaanguluka kwakutayoowa kwakaambilizyigwa kuba nenzila mpati veelede kuyumya muntu. Kakuli ncintu cipati, kuti muntu tasungilizyi kulomba lugwasyo kuba nenzila ilikke yamamanino, ulakonzya kucita zyintu zyimbi zyibyaabi zyakulikwabilila kudyaamininwa, kuti buumi bwa muntu weelede kukwabililwa amulawo. Kakuli ncintu cipati kusumpula lumvwano akati kamasi, kakuli bantu bamasi aali mu mbunga ya United Nations mu milawo ya malembo amumbunga eeyi akasyomenzya lusyomo mu milawo ya lwaanguluko lwa muntu, kubulemu alimwi abuvubi bwamuntu alimwi alwanguluko lweelene ku basankw'
  },
  est: {
    iso6393: 'ekk',
    fixture:
      'Pidades silmas, et inimkonna kõigi liikmete väärikuse, nende võrdsuse ning võõrandamatute õiguste tunnustamine on vabaduse, õigluse ja üldise rahu alus; ja pidades silmas, et inimõiguste põlastamine ja hülgamine on viinud barbaarsusteni, mis piinavad inimkonna südametunnistust, ja et sellise maailma loomine, kus inimestel on veendumuste ja sõnavabadus ning kus nad ei tarvitse tunda hirmu ega puudust, on inimeste üllaks püüdluseks kuulutatud; ja pidades silmas vajadust, et inimõigusi kaitseks seaduse võim selleks, et inimene ei oleks sunnitud viimase abinõuna üles tõusma türannia ja rõhumise vastu; ja pidades silmas, et on vaja kaasa aidata sõbralike suhete arendamisele rahvaste vahel ja; pidades silmas,et ühinenud rahvaste perre kuuluvad rahavad on põhikirjas kinnitanud oma usku inimese põhiõigustesse, inimisiksuse väärikusse ja väärtusse ning meeste ja naiste võrdõiguslikkusesse ning on otsustanud kaasa aidata sotsiaalsele progressile ja elutingimuste parandamisele suurema vabaduse ju'
  },
  snk: {
    iso6393: 'snk',
    fixture:
      'O ga na a faayi nan ti saran xabiilanun doronde do I taqu tinamto ya na du-kiteye, teleŋontaaxun do jamun gondoman ŋa duna noxo. O ga na a faayi nan ti soron taqun turvinbalaaxun do i roxomaxantaaxun yan ña sababu xonintan gollu ñanŋen dunasu maxa. Ken ya ni haadama renmum su ga natene do kiyi kurunba be i ga digaamunu, i ga batiini ti i sago, i xannun laabanto kannu do kori su da. O ga na a taayi nan ti haadama tenmun taqun nan siri tangeene ti tanka teleŋonte kuudo a nan maxa fiite katta gollu burn ñanŋen do marandi moxo bure. O ga na a faayi nan ti mejanŋaaxun nan siri ñaana jamaanun naxa. O ga na a faayi nan ti Duna feddi xooren da sigira xerexerente kini haadama renmum taqu i sigindi kayitin noxo, a doronden do seren xanuye, xawancaaxu yugun do yaxarun naxa. O ga na a faayi ti jamaanu ku ga kafim i ga da laayidun raga nan ti i wa sikki do haadama renmun taqun koroosinden batte. O ga na a faayi nan ti a su nan siri me-mukku taqun do du kiteyen ga ni ke be. Batu xooren da haadama re'
  },
  cjk: {
    iso6393: 'cjk',
    fixture:
      'Ha kulemesa uningikiso wa yeswe ize inatela hali mbunga yeswe ya cisemuka nyi ize inatela eswe cimwikha nyi kusa ize inatela ha kutama, ya kusamba nyi kutama kanawa mu cifuci. Kweca kulemesa uningikiso nyi kweca ize inatela hali muthu ya kuneha muvundo mba mbunge mujivunduka; hi kuhanjyeka ceswaco anazange, kupulwila ihungumwona nyi halamba, ce anakasa nyi ulemu wa manyonga ja muthu. Ha kulemesa citanga ca ulemu ca kwaha utunu wa kukolesa ulikate hakaci kaisamba. Kulemesa mukanda wa mbunga ya akwa Nacoes Unidas, kasa ceka nawa ufulyelo wa hakusa ulitele ulemu wa muthu, ulitele umuwikha haly malunga nyi mapwo, nyi ahanjikile nyi kulisela ku kolesa kwokesa ulikate nyi kusa itanga yakutwama mwono upema mu usokoka unene. Ha kulemesa makulwana ce Nguvulu kalisela ku kukolesa kupwa cimwikha nyi akwa kululika ifuci ya inunga, kuvumbika mbunga yeswe nyi ene akwa ulitele wa muthu nyi kusokoka ca ulemu. Ha kulemesa hawano manyonga a mbunga akutala hakutela nyi kusokoka ce cilemu kuhi ana hanga c'
  },
  ada: {
    iso6393: 'ada',
    fixture:
      'Be abɔ nɛ a le odehe si himi nɛ Mawu bɔ adesahi tsuo nɛ a hi si ngɛ je mi, nɛ e ha nɔ tsuaa nɔ he blɔhi sɔsɔɛ, nɛ nɔ ko be he blɔ nɛ e kpɔɔ ngɛ a dɛ ɔ, e ji he jɔmi kɛ dami same yemi kɛ tue mi jɔmi a sipoku ngɛ je mi. Be abɔ nɛ adesa he blɔhi a nɔ tue gbomi kɛ he guɛ gbemi wo basabasa ni peemihi kɛ ba gba je ɔ tsuo nya he je ɔ, a ngɔ nɔ kaa jehanɛ ɔ, adesa maa ye gbeye kɛ ohia nɔ kunimi, nɛ e ma na hemi kɛ yemi kɛ nya kɛ tu munyu, nɛ enɛ ɔmɛ ji nimli gu ɔmɛ a hiami nihi nɛ pe kulaa. Be abɔ nɛ, ke nɔ́ ko hɛwi nɔ ko ɔ, e be gidigidi nɔ́ ko pee kaa e nyagbe he pulemi nɔ́ kɛ si yi kpɛti wawɛ nɔ yemi kɛ nɔ nɔ nyɛmi he je ɔ, e he hia kaa a wo mlaa pɛ kɛ pee adesa he blɔhi a he fami nɔ́. Be abɔ nɛ kake peemi he hia he je ɔ, e sa kaa a to blɔ nya kɛ ha ma kɛ ma a kake peemi nɔ yami. Be abɔ nɛ Je Mahi A Kake Peemi Kuu ɔ ma a hemi kɛ yemi nɔ mi ekohu ngɛ Womi ɔ mi, ngɛ adesa he blɔhi klɛdɛɛ nɛ e ngɛ, kɛ odehe nɛ e ji, kɛ e he jua wami, kɛ nyumu kɛ yo a he blɔ sɔsɔɛ nɛ a hɛɛ ɔ, a fia pɛɛ si kaa a'
  },
  aii: {
    iso6393: 'aii',
    fixture:
      'ܡܢ ܣܒܒ ܡܘܕܝܬܐ ܒܐܝܩܪܐ ܫܪܫܢܝܐ ܠܟܠܗ ܗܕܡܐ ܕܟܠܦܬ ܕܒܪܢܫܘܬܐ ܘܒܙܕܩܐ ܠܐ ܡܬܝܗܒ݂ܢܐ ܐܝܢܐ ܐܣܟܝܡܐ ܕܚܐܪܘܬܐ ܘܟܝܢܘܬܐ ܘܫܠܡܐ ܓܘ ܬܝܒ݂ܠ. ܡܢ ܣܒܒ ܦܠܛܐ ܕܠܐ ܡܝܩܪܬܐ ܘܡܣܠܝܬܐ ܕܙܕܩܐ ܐܢܫܝܐ ܝܒ݂ܕܥܢܐ ܠܥܒ݂ܕܘܝܬܐ ܒܪܒܪܝܐ ܘܥܓܙܢܐ ܠܐܢܝܬ ܕܒܪܢܫܘܬܐ. ܘܐܬܵܝܬܵܐ ܚܕ ܕܘܢܝܐ ܐܝܟܐ ܕܒܪܢܫܐ ܒܕ ܦܨܚ ܒܚܐܪܘܬܐ ܕܗܡܙܡܬܐ ܘܗܝܡܢܘܬܐ ܘܚܐܪܘܬܐ ܡܢ ܙܕܪܘܥܬܐ ܘܣܢܝܩܘܬܐ ܦܝܫܝ ܡܘܪܒ݂ܚܐ ܐܝܟ ܐܢܝ ܢܝܼܫܐ ܒܘܫ ܥܠܝܐ ܕܐܢܫܐ ܥܝܕܝܐ. ܡܢ ܣܒܒ ܐܢܢܩܝܬܐܝܠܗ ܩܐ ܩܢܘܢ ܫܐܩܠ ܫܘܦܐ ܠܢܛܪܬܐ ܙܕܩܐ ܕܒܪܢܫܐ ܩܐ ܠܐ ܥܒ݂ܕ ܡܪܘܕܘܬܐ ܕܪܩܒܠ ܕܛܪܘܢܐ ܘܙܠܘܡܝܐ. ܡܢ ܣܒܒ ܥܡܹܐ ܕܐܡܘܬܐ ܡܚܝܕܐ ܡܫܪܘܪܢܐ ܓܘ ܥܘܬܕܐ ܗܝܡܢܘܬܝ ܓܘ ܙܕܩܐ ܐܢܫܝܐ ܘܓܘ ܐܝܩܪܐ ܦܪܨܘܦܝܐ ܘܒܪܒܪܘܬܐ ܓܘ ܙܕܩܐ ܘܫܘܝܐ ܕܢܫܐ ܘܕܟ݂ܪܐ. ܘܩܒ݂ܘܠܢܐ ܠܬܡܘܡܐ ܠܡܛܘܪܬܐ ܫܘܫܛܐ ܫܘܬܦܝܐ ܘܡܪܡܬܐ ܕܚܝܐ ܥܠ ܚܕ ܕܪܓ݂ܐ ܒܘܫ ܥܠܝܐ ܓܘ ܚܕ ܐܐܪ ܕܚܐܪܘܬܐ ܒܘܫ ܪܘܚܬܐ. ܘܡܢ ܣܒܒ ܕܐܬܪܘܬܐ ܗܕܡܐ ܩܒ݂ܘܠܢܐ ܕܗܝܪܐ ܥܡ ܐܡܘܬܐ ܡܚܝܕܐ ܠܡܪܘܚܬܐ ܕܙܕܩܐ ܐܢܫܝܐ ܘܢܛܪܬܐ ܚܐܪܘܬܐ ܫܪܫܢܝܬܐ. ܐܝܟܐ ܦܪܡܝܬܐ ܟܠܢܝܬܐ ܠܐܢܐ ܙܕܩܐ ܘܚܐܪܘܝܬܐ ܐܝܢܐ ܐܢܢܩܝܐ ܠܬܡܡܬܐ ܐܗܐ ܩܘܠܐ. ܒܘܕ ܐܗܐ ܟܢܘܫܝܐ ܓܘܢܝܐ܆ ܡܘܕܘܝܠܗ ܕܐܗܐ ܒܘܕܩܐ ܬܝܒ݂ܠܝܐ ܕܙܕܩܐ ܐܢܫܝܐ ܐܝܠܐ ܚܕ ܡܟܡܠܬܐ ܓܘܢܝܬܐ ܩܐ ܟܠܗ ܐܢܫܐ ܘܐܬܪܘܬܐ ܠܦܘܬ ܢܝܫܐ ܕܟܠ ܦܪܣܘܦܐ ܘܟܠ ܓܘܫܡܐ ܕܫܘܬܦܘܬܐ ܕܬܚܪܐ ܗܡܫܐ ܠܐܗܐ ܥܘܬܕܐ ܘܓ̰ܪܒܝ ܠܡܩܪܝܬܐ ܘ'
  },
  quy: {
    iso6393: 'quy',
    fixture:
      'QAWARISUNYA: Libre kawsakuywan kay pachapi tukuy imapi hawka kawsakuyqa sumaq sapichasqam kachkan kaykunapi: Lliw runakunaqa mamanchikpa wachakuwasqanchikmantapunim mana pipapas usuchisqan allin qawasqa hinaspa igual derechoyoq kananchik. QAWARISUNYA: Runakunam tukuy mana allin ruwaykunaman chayarunku, runapa derechonkunata mana sumaqta reqsispanku otaq yachachkaspankupas chaykunata mana kaqpaqpas hapispanku, lliw runakunam munanchik hamuq punchawkunapi allin kawsakuyta; tukuy manchakuykuna hinaspa muchuyllapi wakcha kaykuna chinkaruptinqa lliw runakunam mana manchakuspaña rimarisun imam umanchikpi kaqta, mana manchakuspataqmi chaskisun imam yachay munasqanchiktapas. QAWARISUNYA: Kananmi Runakunapa Derechon waqaychaq munayniyoq kamachikuykuna, chay kamachikuykunam mana pimanpas sayapakuspa yanapanan derechon valechiy munaq sarutyasqa hinaspa usuchisqa runakunata. QAWARISUNYA: Kay pachapi nacionkuna amistadta armanankupaqmi sonqonchikpi munaypaq-munananchik hinaspam chay munayta cheqech'
  },
  rmn: {
    iso6393: 'rmn',
    fixture:
      'Dikhindor so o prinzaripen e manuśenqe somandrune demnimnasqoro thaj e barabar aj bixasaraver hakaja savorre zenenqere and-i manuśikani famělia si i bàza e mestimnasqi, e ćaće krisaqi aj e aćhõmnasqi and-i lùmia, Dikhindor so o bango prinzaripen thaj o uśtavipen e manuśikane hakajenqo ligarde zi nesave zuklimata, save dukhaven o ilo ta o vogi e manuśikanimnasqo, Dikhindor so o avipen jekhe lumiaqo, anda savi e manuśa śaj vakeren aj paćan mestes so mangen thaj anda savi nanaj te ovel dar aj ćororipen, si i maj opruni aspirŕcia e manuśesqiri, Dikhindor so si trebutno te ovel jekh kanon rakhimnasqe e hakaja manuśikane, te na ovel o manuś ligardo, sar maj palutni zor, and-o maripen mamuj- tirŕnia thaj o uśtavipen, Dikhindor so si trebutno te luludõn amalikane relàcie maśkar-e nàcie e lumiaqe, Dikhindor so e sela e Unisarde Themenqoro palem afirmisarde and-o Baro Lil so paćan and-e manuśikane bazutne hakaja, and-o demnipen aj molipen sarkole manuśikane zenesqo aj and-o barabaripen maśkar-e '
  },
  bin: {
    iso6393: 'bin',
    fixture:
      'Vbene a na mie wee ayere ero wee etin ne o kheke emwan hia fere oro re eyato oghe arhiegbe, emwanta kevbe ofunmwengbe vbe agbon. Vbene a na mie wee etin emwin ne o kheke ne omwan ne a ma ka yo, ne o si uyinmwen obuluku-obuluza, ne o rhu emwan aro ekhoe, kevbe agbon node ne emwan nagbon gha na ghao rhie orhienrhien arriegbe ne omwan ya ta emwen ne o ho ne o ta vbe uwu amuentinyan kevbe arhiegbe hin obo ohan ke aimwen rre, ne a ya wewe zeevbe ida-eho oghe emwan kekan hia, Vbene a ne mie wee emwin ne o kere ne o wee na ghe ye atua tua emwan, ne iran ghe ya gha gbodan ghe uyinmwen ne o wegbe kevbe oderhu emwan ne i mween ase serrio wee ne ilele, oghe uhi ru gue etin omwan ne o khekee, Vbene a na mie wee okere na ru alaghodaro oghe ayin-kugbe vbe ose vbe adese uhunmwun evbo hia, Vbene a na mie wee Akugbe Uhunmwun Evbo hia tae guobo vbe Ebe Emwanmwan Emwe Iruemwin ne iran gben wee iran mween amuentin yan etin nii ne o kheke omwan we ne ikpia kevbe ikhuo gha re umwonmwen vbe ilele etin ne o k'
  },
  gaa: {
    iso6393: 'gaa',
    fixture:
      'Akɛni aŋɔɔ nɔ akɛ afɔ gbɔmɛi adesai fɛɛ akɛ mɛi ni yeɔ egbɔ kɛ heyeli ko ni anyɛŋ ashɔ̃ yɛ amɛdɛŋ, ni nomɛi ji heyeli, jalɛsane kɛ toiŋjɔlɛ shishifãi yɛ je lɛ mli hewɔ lɛ, Akɛni bu ni abuuu, kɛ asaŋ gbɔmɔ adesa hegbɛi anɔ ni anaanaa yɛ shikpɔŋ lɛ etsɔ gbɔmɔ yitsoŋ ni eha efeɔ yiwalɛ nii, kɛ amrɔ nɛɛ gbɛgbelemɔ akɛ mɛi foji anine ashɛ amɛshweenii anɔ bɔ ni amɛaanyɛ amɛwie nɔ ni amɛsusuɔ yɛ nɔ ko he, amɛhe nɔ ni amɛsusuɔ akɛ eja gbɛ pɛ amɛye, akanyɛ awo amɛhe gbeyei dɔŋŋ, ni asaŋ akakama amɛ nɔ ko nɔ ko hewɔ lɛ, Akɛni suɔmɔ ni asumɔɔɔ akɛ atsɔɔ gbɛ kroko nɔ ajieɔ yiwalɛ nɔyeli ko hewɔ ni ehiaa akɛ awo mla ni baafã gbɔmɔ adesa hegbɛi ahe hewɔ lɛ, Akɛni ehe hiaa akɛ akã he aha naanyobɔɔ ahi maji ateŋ hewɔ lɛ, Akɛni mɛi ni yɔɔ Jeŋmaji Ekomefeemɔ Ku lɛ mli lɛ ema amɛhemɔkɛyeli ni amɛyɔɔ yɛ gbɔmɔ adesa mli, kɛ agbojee kɛ egbɔyeli ni kã hii kɛ yei ateŋ nɔ aduatsɔ, ni amɛtswa amɛfai shi hu akɛ amɛbaabɔ mɔdɛŋ koni shihilɛ mli aŋɔɔ fe tsuutsu, ni heyeli ahe shi jogbaŋŋ taakɛ ato he gbɛjianɔ y'
  },
  ndo: {
    iso6393: 'ndo',
    fixture:
      'Uuna mpoka pwa taambwa ko esimano lyomuntu pavalo nuuthikepamwe osho wo uuthemba wopaumwene waantu ayehe yomezimo lyuuntu ogwo omukanka gwemanguluko, uuyuki nombili muuyuni. Uuna mpoka uuthemba womuntu inaau simanekwa nowa dhinika e tau tanaukile monkalo yuupwidhi mboka tau yono po eiuvo lyuuntu nonkalo moka aantu taa ka nyanyukilwa nokukala ye na emanguluko lyokupopya neitaalo osho wo emanguluko kuutile nokoompumbwe ongoshilalakanenwa sha simana shaantu ayehe. Uuna mpoka sha pumbiwa opo omuntu kaa thiminikwe a hogolole ongonkatu yahugunina opo a ninge oshipotha mokukondjitha uuhepeki nethiminiko, opo uuthemba wuuntu wu gamenwe pampango. Uuna mpoka sha pumbiwa okuhumitha komeho ekoko Iyekwatathano Iyopankalathano ewanawa pokati kiigwana. Uuna aantu yIigwanahangano mEkotampango yu ulika einekelo Iyawo muuthemba womuntu, mondilo nomondjundo yuuntu womuntu nuuthikepamwe wuuthemba waakiintu naalumentu noya tokola okuhumitha komeho eputuko Iyopankalathano osho wo omuthika omwaanawa gwonkala'
  }
}
