---@mod xcodebuild.features Features
---@brief [[
--- - Support for iOS, iPadOS, watchOS, tvOS, visionOS, and macOS.
--- - Support for Swift Packages (building & testing).
--- - Project-based configuration.
--- - Project Manager to deal with project files without using Xcode.
--- - Assets Manager to manage images, colors, and data assets.
--- - Test Explorer to visually present a tree with all tests and results.
--- - Built using official command line tools like `xcodebuild` and `xcrun simctl`.
--- - Actions to build, run, debug, and test apps on simulators and
---   physical devices.
--- - Environment variables and run arguments management.
--- - Buffer integration with test results
---   (code coverage, success & failure marks, duration, extra diagnostics).
--- - Code coverage report with customizable levels.
--- - Advanced log parser to detect all errors, warnings, and failing tests.
--- - `nvim-tree`, `neo-tree.nvim`, and `oil.nvim` integration that automatically
---   reflects all file tree operations and updates Xcode project file.
--- - `nvim-dap` integration to let you easily build, run, and debug apps.
--- - `nvim-dap-ui` integration to show app logs in the console window.
--- - `lualine.nvim` integration to show selected device, test plan,
---   and other project settings.
--- - `swift-snapshot-testing` integration to present diff views for failing snapshot tests.
--- - `Quick` integration to show test results for tests written using `Quick` framework.
--- - `Swift Testing` integration to show test results for tests written using `Swift Testing` framework.
--- - Auto-detection of the target membership for new files.
--- - Picker with all available plugin actions.
--- - Highly customizable (many config options, auto commands, highlights,
---   and user commands).
---
---Availability of features
---
--- |             | Device (iOS <17) | Device (iOS 17+) | via Network (<17 / 17+) | Simulator | MacOS |
--- | :---------: | :--------------: | :--------------: | :---------------------: | :-------: | :---: |
--- |    build    |        🛠️        |        ✅        |         ❌ / ✅         |    ✅     |  ✅   |
--- | (un)install |        🛠️        |        ✅        |         🛠️ / ✅         |    ✅     |  ❌   |
--- |   launch    |        🛠️        |        ✅        |         🛠️ / ✅         |    ✅     |  ✅   |
--- |  run tests  |        🛠️        |        ✅        |         ❌ / ✅         |    ✅     |  ✅   |
--- |    debug    |        🛠️        |       🔐 🛠️      |           ❌            |    ✅     |  ✅   |
--- | debug tests |        ❌        |        ❌        |           ❌            |    ✅     |  ✅   |
--- |  app logs   |        🪲         |       🪲         |          ❌            |    ✅     |  🪲    |
---
---
--- 🔐 - requires passwordless `sudo` permission to `tools/remote_debugger`
---      script (see |xcodebuild.remote-debugger|).
---
--- 🛠️ - available if pymobiledevice3 is installed.
---
--- 🪲  - available while debugging.
---
---@brief ]]

local M = {}
return M
