/**
 * A function definition for that can be called by providers.
 */
export type FunctionDefinition = {
  /**
   * The name of the function to be called. Must be a-z, A-Z, 0-9, or contain
   * underscores and dashes, with a maximum length of 64.
   */
  name: string

  /**
   * The parameters the functions accepts, described as a JSON Schema object. See the
   * [guide](https://platform.openai.com/docs/guides/gpt/function-calling) for
   * examples, and the
   * [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for
   * documentation about the format.
   *
   * To describe a function that accepts no parameters, provide the value
   * `{"type": "object", "properties": {}}`.
   */
  parameters: Record<string, unknown>

  /**
   * A description of what the function does, used by the model to choose when and
   * how to call the function.
   */
  description?: string
}

/**
 * A function configuration for AIbitat.
 */
export type FunctionConfig = FunctionDefinition & {
  /**
   * The arguments to call the function with, as generated by the model in JSON
   * format. Note that the model does not always generate valid JSON, and may
   * hallucinate parameters not defined by your function schema. Validate the
   * arguments in your code before calling your function.
   */
  handler: (...params: any[]) => Promise<string> | string
}

/**
 * A function call from the completion.
 */
export type FunctionCall = {
  /**
   * The name of the function to call.
   */
  name: string

  /**
   * The arguments to call the function with, as generated by the model in JSON
   * format. Note that the model does not always generate valid JSON, and may
   * hallucinate parameters not defined by your function schema. Validate the
   * arguments in your code before calling your function.
   */
  arguments: object
}

// export type FunctionResponse = {}
