# 十二、开放重定向漏洞

> 作者：Peter Yaworski

> 译者：[飞龙](https://github.com/)

> 协议：[CC BY-NC-SA 4.0](http://creativecommons.org/licenses/by-nc-sa/4.0/)

## 描述

根据 OWASP，开放重定向出现在应用接受参数并将用户重定向到该参数值，并且没有对该值进行任何校验的时候。

这个漏洞用于钓鱼攻击，便于让用户无意中浏览恶意站点，滥用给定站点的信任并将用户引导到另一个站点，恶意站点作为重定向目的地，可以将其准备成合法站点的样子，并尝试收集个人或敏感信息。

> 链接

> 查看 [OWASP 无验证重定向和转发速查表](https://www.owasp.org/index.php/Unvalidated_Redirects_and_Forwards_Cheat_Sheet)

## 示例

### 1\. Shopify 主题安装开放重定向

难度：低

URL：`app.shopify.com/services/google/themes/preview/supply–blue?domain_name=XX`

链接：`https://hackerone.com/reports/1019622`

报告日期：2015.11.25

奖金：$500

描述：

Shopify 的平台允许商店管理员自定义商店外观。为此，管理员需要安装主题。这里的漏洞时，主题安装页面会解释重定向参数，并向用户浏览器返回 301 重定向，而不验证重定向的目标。

因此，如果用户访问`https://app.shopify.com/services/google/themes/preview/supply– blue?domain_name=example.com`，它会重定向到`http://example.com/admin`。

恶意用户能够在该域部署站点，并尝试对无意识的用户执行钓鱼攻击。

> 重要结论

> 我这里再说一遍，不是所有漏洞都很复杂。这里的开放重定向只需要将重定向参数修改为外部站点。

### 2\. Shopify 登录开放重定向

难度：中

URL：`http://mystore.myshopify.com/account/login`

报告链接：`https://hackerone.com/reports/103772`

报告日期：2015.12.6

奖金：$500

描述：

这个开放重定向非常类似于上面讨论的主题安装漏洞，但是这里。漏洞在用户登录，并且使用参数`?checkout_url`之后出现。例如：

http://mystore.myshopify.com/account/login?checkout_url=.np

因此，当用户访问链接并登录，它会被重定向到：

https://mystore.myshopify.com.np/

它实际上完全不是 Shopify 的域。

### 3\. HackerOne 间隔重定向

难度：中

URL：无

报告链接：https://hackerone.com/reports/111968

报告日期：2016.1.20

奖金：$500

描述：

这里的间隔重定向指代一些重定向，在重定向期间不发生停顿，来告诉你你正在被重定向。

HackerOne 实际上在报告中提供了该漏洞的纯语言描述：

> `hackerone.com`连接被视为可信连接，包括`/zendesk_session`前面的那些。任何人都可以创建自定义的 Zendesk 账户，它会重定向到不可信的站点，并在`/redirect_to_account?state= param;`提供该功能。并且由于 Zendesk 允许账户之间的非间隔重定向，你会被引导到任何不可信站点，而没有任何警告。

> 了解 Zendesk 的原始问题之后，我们选择将带有`zendesk_session`的链接视为外部链接，点击时会渲染一个外部的图标和间隔警告页面。

所以这里，Mahmoud Jamal（是的，和 Google XSS 漏洞中的人一样）创建了`company.zendesk.com`并将：

```html
<script>document.location.href = "http://evil.com";</script>
```

通过 Zendesk 的主题编辑器添加到了头文件中。之后，传递这个链接：

```
https://hackerone.com/zendesk_session?locale_id=1&return_to=https://support.hackerone.com/ping/redirect_to_account?state=company:/
```

它用于重定向到生成的 Zendesk 会话。

现在，有趣的是，Mahmoud 向 Zendesk 报告了这个重定向个问题，Zendesk 说他并没有看到任何问题。所以，自然而然，它继续挖掘这个漏洞，看看如何才能利用。

> 重要结论

> 我们在应用逻辑一章中讨论了它，但它重复出现在这里，在你搜索漏洞时，要注意站点所使用的的服务，因为在你的搜索过程中，它们每个都代表一种新的攻击向量。这里，这个漏洞可以通过组合 Zendesk 的 HackerOne 使用方法，以及已知的所允许的重定向来实现。

> 此外，在你寻找 bug 时，阅读和回应你的报告的人有时不能马上理解安全影响。这就是我在漏洞报告中编写这一章的原因。如果你往前推进一小步，并且在你的报告中解释安全映像，它会确保顺利解决。

> 但是，即使是这样，公司有时候也会不理解你。如果是这样，像 Mahmoud 所做的一样，保持挖掘，并看看是否可以证明它可以利用，或者将其和其它漏洞组合来展示影响。

## 总结

开放重定向个允许恶意攻击者将人们重定向到未知的恶意站点。就像这些例子展示的那样，寻找他们需要锐利的观察。有时会出现易于发现的`redirect_to=`，`domain_name=`，`checkout_url=`，以及其它。这种类型的漏洞依赖信任的滥用，其中受害者被诱导来访问攻击者的站点，并认为他们正在浏览他们认可的站点。

通常，当 URL 作为参数传递给 Web 请求时，你可以发现它们。要留意并玩转 URL 地址，以便观察是否接受外部站点的链接。

此外，HackerOne 间隔重定向展示了二者的重要性。当你寻找漏洞时，识别站点所用的工具和服务，以及有时在被认可和接受之前，你需要坚持并清晰展示漏洞。
