# 第二章 进程

> 作者：[Allen B. Downey](http://greenteapress.com/wp/)

> 原文：[Chapter 2  Processes](http://greenteapress.com/thinkos/html/thinkos003.html)

> 译者：[飞龙](https://github.com/)

> 协议：[CC BY-NC-SA 4.0](http://creativecommons.org/licenses/by-nc-sa/4.0/)

## 2.1 抽象和虚拟化

在我们谈论进程之前，我打算先定义几个东西：

+   抽象（Abstraction）：抽象是复杂事物的简单表示。例如，如果你开车的话，应该知道车轮向左转的时候车也会向左行驶，反之亦然。当然，方向盘由一系列机械和传动系统所连接，用于使轮子转向，并且轮子和路面的相互作用方式也很复杂。但是作为一个司机，你通常不需要考虑这些细节。你可以仅仅建立方向盘的心智模型，这种心智模型就是一个抽象。

    软件工程的很大一部分就是设计类似这样的抽象，允许用户和其它程序员使用强大而复杂的系统，而不必知道其实现的细节。
    
+   虚拟化（Virtualization）：一类非常重要的抽象就是虚拟化，它是创建可取的幻像的过程。例如，许多公共图书馆都参与了馆际合作，允许它们互相借阅图书。当我需要一本书时，有时它在我的本地图书馆的架子上，但更多情况下它会被运到其它的馆藏中。无论是哪一种，我都会收到它可借阅的提醒。我并不需要知道它来自哪里，我也不需要知道我的图书馆拥有哪一本书。一般来说，这个系统创建了一个幻象，好像我的图书馆拥有全世界的每一本书。

    在物理上，我的图书馆的馆藏可能很小，但是虚拟上我能获得的馆藏包含了馆际合作的每一本书。
    
    另外一个例子，大多数电脑都只连接到一个网络中，而这个网络又链接到其它网络，等等。我们所谈论的“互联网”，是一系列网络和协议的合集，它将数据包从一个网络传送到另一个网络。从用户和程序员的角度来看，整个系统的行为就像是互联网的每台计算机都互相连接。物理连接的数量十分少，但是虚拟连接的数量十分庞大。

“虚拟”这个词通常用于虚拟机的语境中，它是一种软件，可以创建运行特定系统的专用计算机的幻象。实际上，虚拟机可能和其它虚拟机一起运行在不同的操作系统上。

在虚拟化的语境中，我们通常把真实发生的事情叫做“物理的”，而把虚拟上发生的事情叫做“逻辑的”或者“抽象的”。

## 2.2 隔离

工程最重要的原则之一就是隔离（Isolation）：当你设计一个带有多个组件的系统时，将它彼此隔离是个很好的方法，这样某个组件中的改变就不会对其它组件造成不良影响。

操作系统最重要的目标之一，就是将每个进程和其它进程隔离，使程序员不必考虑每个可能的交互情况。提供这种隔离的软件对象叫做进程（Process）。

进程是表示运行中程序的软件对象。我按照面向对象编程把它称之为“软件对象”。通常一个对象包含数据，并且提供用于操作数据的方法。进程正是包含以下数据的对象：

+ 程序文本，通常是机器语言的指令序列。
+ 程序相关的数据，包括静态数据（编译时分配）和动态数据，后者包括运行时的栈和堆。
+ 任何等待中的IO状态。例如，如果进程正在等待从磁盘中读取的数据，或者从网络到达的数据包，这些操作的状态也是进程的一部分。
+ 程序的硬件状态，这包括储存在寄存器中的数据，状态信息，以及程序计数器，它表示当前执行了哪个指令。

通常一个进程运行一个程序，但是对于进程来说，加载并运行新的程序也是可能的。

也可以在多于一个进程中运行相同的程序，这非常常见。这种情况下，各个进程共享程序文本，但是拥有不同的数据和硬件状态。

大多数操作系统提供了隔离进程的基本功能：

+ 多任务：大多数操作系统有能力在几乎任何时候中断一个进程，保存它的硬件状态，并且在以后恢复它。通常，程序员不需要考虑这些中断。程序的行为就像在一个专用的处理器上持续运行，除了两条指令之间的时间是不可预测的。
+ 虚拟内存：大多数操作系统会创建幻象，每个进程看似拥有独立内存片并且孤立于其他进程。同样，程序员通常也不需要考虑虚拟内存如何工作，他们可以当做每个程序都拥有专用的内存片来处理。
+ 设备抽象：运行于同一台计算机的进程共享磁盘、网络接口、显卡和其它硬件。如果进程直接和这些硬件交互而不加协调，就一定会产生混乱。例如，一个进程预期的网络数据可能会被另一个进程读取。或者多个进程可能尝试在磁盘的相同位置储存数据。操作系统负责通过提供合适的抽象来维持秩序。

作为程序员，你不需要知道太多关于这些功能如何实现的事情。但是如果你很好奇，你可以在这个屏蔽层的后面发现一大堆有趣的事情。而且，如果你知道其中所发生的事情，你会成为更好的程序员。

## 2.3 Unix 进程

当我写这本书的时候，我最关注的进程就是我的文本编辑器，Emacs。偶尔我也会切换到终端窗口，它是一个运行Unix shell并提供命令行接口的窗口。

当我移动鼠标时，窗口的管理器会被唤醒，看到鼠标在终端窗口上方，并且唤醒终端。终端又唤醒shell。如果我在shell中键入`make`，它就会创建一个新的进程来运行Make。Make会创建另一个进程来运行LaTeX，之后另一个进程会显示结果。

如果我需要查询一些东西，我会切换到另一个桌面，这会再次唤醒窗口管理器。如果我点击Web浏览器的图标，窗口管理器会创建进程来运行Web浏览器。许多浏览器，类似Chrome，会为每个窗口和每个选项卡创建新的进程。

并且这些只是我所了解的进程，同时还有许多其它进程“在后台”运行。它们中许多都在执行操作系统相关的工作。

Unix命令`ps`能打印出运行中进程的信息。如果你在终端里运行它，可能会看到这些：

```
  PID TTY          TIME CMD
 2687 pts/1    00:00:00 bash
 2801 pts/1    00:01:24 emacs
24762 pts/1    00:00:00 ps
```

第一列是唯一的进程ID。第二列是创建进程的终端，“TTY”代表“电传打字机”（Teletypewriter），它是原始的机械终端。

第三行是用于该进程的处理器时间总计，依次为时、分、秒。最后一行是所运行进程的名称。这个例子中，`bash`是shell的名称，用于解释我键入到终端中的命令。Emacs是我的文本编辑器，而`ps`是生成这份输出的程序。

通常，`ps`只会列出有关当前终端的进程。如果你使用`-e`选项，你会得到所有进程（也包括属于其他用户的进程，我认为这是个安全缺陷）。

在我的系统上有233个进程，下面是它们的一部分：

```
  PID TTY          TIME CMD
    1 ?        00:00:17 init
    2 ?        00:00:00 kthreadd
    3 ?        00:00:02 ksoftirqd/0
    4 ?        00:00:00 kworker/0:0
    8 ?        00:00:00 migration/0
    9 ?        00:00:00 rcu_bh
   10 ?        00:00:16 rcu_sched
   47 ?        00:00:00 cpuset
   48 ?        00:00:00 khelper
   49 ?        00:00:00 kdevtmpfs
   50 ?        00:00:00 netns
   51 ?        00:00:00 bdi-default
   52 ?        00:00:00 kintegrityd
   53 ?        00:00:00 kblockd
   54 ?        00:00:00 ata_sff
   55 ?        00:00:00 khubd
   56 ?        00:00:00 md
   57 ?        00:00:00 devfreq_wq
```

`init`是操作系统启动时首先创建的进程。它又会创建许多其它进程，之后会闲置，直到它创建的进程运行完毕。

`kthreadd`是操作系统用于创建新的“线程”的进程。之后我们将会谈论更多关于线程的东西，但是你暂时你可以认为线程是一种进程。
