# 第零章 前言

> 作者：[Allen B. Downey](http://greenteapress.com/wp/)

> 原文：[Chapter 0  Preface](http://greenteapress.com/thinkos/html/thinkos001.html)

> 译者：[飞龙](https://github.com/)

> 协议：[CC BY-NC-SA 4.0](http://creativecommons.org/licenses/by-nc-sa/4.0/)

在许多计算机科学的课程中，操作系统都是高级话题。学生在上这门课之前，它们已经知道了如何使用C语言编程，他们也可能上过计算机体系结构（组成原理）的课程。通常这门课的目标是让学生们接触操作系统的设计与实现，并带有一些他们未来在该领域所研究的隐含假设，或者让他们手写OS的一部分。

这本书为一些不同的读者准备，并且具有不同的目标。我为欧林工学院中一门叫做软件系统的课程编写了它。

多数学生在学完Python编程之后上了这门课，所以目标之一就是帮助他们学习C语言。对于课程的这一部分，我使用了O’Reilly的《Head First C》（中译本为《嗨翻C语言》）作为补充。

我的一些学生从没有写过操作系统，但是它们中许多人都会使用C语言编写底层的应用，或者与嵌入式打交道。我的课程包括操作系统的要素、网络、数据库、和嵌入式系统，而且强调了程序员需要知道的一些话题。

这本书并不假设你学过计算机体系结构。在讲解过程中，我会解释所需的东西。

如果这本书成功了，它会带给你对程序运行中所发生事情的深入理解，并且你可以使它们运行速度更快以及更加可靠。

第一章解释了编译语言和解释语言的一些差异，以及编译器工作原理的一些洞察。推荐阅读《嗨翻C语言》的第一章。

第二章解释了操作系统如何使用进程来保证运行中的程序不相互影响。

第三章解释了虚拟内存和地址翻译。推荐阅读《嗨翻C语言》的第二章。

第四章有关文件系统和数据流。推荐阅读《嗨翻C语言》的第三章。

第五章描述了数值、字母和其它值如何编码，同时展示了按位运算。

第六章解释了如何使用动态内存管理，它如何工作。推荐阅读《嗨翻C语言》的第六章。

第七章有关缓存和存储器层次结构。

第八章有关多任务和调度。

第九章有关POSIX线程和互斥体。推荐阅读《嗨翻C语言》的第十二章，和《Little Book of Semaphores》的第一和第二章。

第十章有关POSIX条件变量和生产者/消费者问题。推荐阅读《Little Book of Semaphores》的第三和第四章。

第十一章有关POSIX信号量和C中的实现。

## 这份草稿的注解

本书的当前版本（v0.5）是个初稿。当我处理文字时，我还没有把图片放进来。所以我确信有些地方的解释加上图片之后会更好。

## 0.1 代码的使用

本书的示例代码可以在[https://github.com/AllenDowney/ThinkOS](https://github.com/AllenDowney/ThinkOS)访问。Git是一个版本控制系统，它允许你跟踪项目所组成的文件。Git控制下的一系列文件叫做**仓库**。GitHub是一个为Git仓库提供储存空间的托管服务，以及一个便利的Web界面。

我的仓库的GitHub的主页提供了如下方式来获取代码：

+ 你可以通过点击“Fork”按钮，在GitHub上创建我的仓库的一份副本。如果你没有GitHub账号，你需要创建一个。在Fork之后，你在GitHub上就有了自己的仓库，你可以在本书编写的过程中，将其用于跟踪你编写的代码。之后你可以克隆这个仓库，也就是说你可以将文件复制到自己的电脑上。
+ 或者你可以克隆我的仓库。你并不需要GitHub账号来完成它，但是你不能将你的修改写回GitHub。
+ 如果你完全不想使用Git，你可以使用GitHub页面右下角的按钮，下载以Zip打包的文件。

## 贡献者名单

如果你需要提供建议或纠错，请向[downey@allendowney.com](mailto:downey@allendowney.com)发送邮件。如果我基于你的反馈作出修改，我会将你添加到贡献者名单中（除非你要求被忽略）。

如果你包含了错误所在句子的一小部分，我会很容易找到它。页面和章节的号码也可以，但是不是十分易于处理。多谢了！

+ 我要感谢欧林工学院软件系统课上的所有学生，他们在2014春季学期测试了这本书的初稿。他们纠正了许多错误，并提了很多有用的建议。我很欣赏他们的开拓精神！
+ Donald Robertson 指出了两个打字错误。
+ Jim Tyson 提交了两个纠正。
+ James P Giannoules 指出了一处复制粘贴错误。
+ Andy Engle 给出了GB和GiB的差异。
+ Aashish Karki 指出了一些错误的语法。
