export const Heart = (props: React.SVGProps<SVGSVGElement>) => (
  <svg width='14' height='14' viewBox='0 0 14 14' fill='none' {...props}>
    <path
      d='M11.0832 8.16667C11.9523 7.315 12.8332 6.29417 12.8332 4.95833C12.8332 4.10743 12.4952 3.29138 11.8935 2.6897C11.2918 2.08802 10.4757 1.75 9.62484 1.75C8.59817 1.75 7.87484 2.04167 6.99984 2.91667C6.12484 2.04167 5.4015 1.75 4.37484 1.75C3.52393 1.75 2.70788 2.08802 2.1062 2.6897C1.50452 3.29138 1.1665 4.10743 1.1665 4.95833C1.1665 6.3 2.0415 7.32083 2.9165 8.16667L6.99984 12.25L11.0832 8.16667Z'
      strokeWidth='1.5'
      strokeLinecap='round'
      strokeLinejoin='round'
    />
  </svg>
)

export const Typescript = (props: React.SVGProps<SVGSVGElement>) => (
  <svg width='14' height='14' fill='none' viewBox='0 0 14 14' {...props}>
    <path
      fill='currentColor'
      d='M10.425 3.606c.372.087.71.282.972.56.144.152.27.32.373.5.005.02-.671.475-1.081.728-.015.01-.074-.054-.14-.153a.882.882 0 00-.732-.438c-.47-.032-.774.215-.772.627a.569.569 0 00.067.292c.103.214.296.343.9.605 1.114.479 1.591.795 1.886 1.244a2.256 2.256 0 01.182 1.895 2.084 2.084 0 01-1.72 1.232 4.769 4.769 0 01-1.185-.013 2.857 2.857 0 01-1.582-.824 2.747 2.747 0 01-.405-.6c.046-.033.093-.064.143-.09l.578-.333.448-.263.093.136c.158.226.359.418.59.566a1.444 1.444 0 001.514-.077.676.676 0 00.087-.863c-.12-.173-.367-.319-1.069-.623a3.85 3.85 0 01-1.465-.899 2.05 2.05 0 01-.427-.777 3.113 3.113 0 01-.027-.992A1.895 1.895 0 019.247 3.57a3.937 3.937 0 011.178.036zm-3.65.65l.004.635H4.754v5.752H3.325v-5.75H1.3v-.625c-.006-.214 0-.428.017-.642.008-.01 1.24-.014 2.732-.012l2.718.008.008.633z'
    />
  </svg>
)

export const Go = (props: React.SVGProps<SVGSVGElement>) => (
  <svg width='14' height='14' fill='none' viewBox='0 0 14 14' {...props}>
    <g fill='currentColor' clipPath='url(#clip0_169_24)'>
      <path d='M6.856 5.489c-.585.148-.984.26-1.559.408-.14.037-.148.047-.269-.093-.14-.157-.241-.26-.436-.352-.585-.288-1.15-.204-1.68.139-.63.408-.955 1.011-.946 1.763.01.742.52 1.355 1.253 1.457.63.083 1.16-.14 1.577-.612.084-.103.158-.214.25-.344h-1.79c-.195 0-.242-.12-.177-.278.121-.288.344-.77.474-1.012a.25.25 0 01.232-.148h3.377c-.018.25-.018.501-.055.752a3.957 3.957 0 01-.761 1.818c-.668.882-1.54 1.43-2.645 1.578-.91.12-1.754-.056-2.496-.613a2.915 2.915 0 01-1.179-2.06c-.12-1.011.177-1.92.79-2.719.658-.863 1.53-1.41 2.597-1.605.873-.158 1.708-.056 2.46.455.491.325.844.77 1.076 1.308.056.084.018.13-.093.158z'></path>
      <path d='M9.927 10.62c-.844-.018-1.614-.26-2.264-.816a2.91 2.91 0 01-1.002-1.791c-.167-1.049.12-1.977.752-2.802.677-.891 1.494-1.355 2.598-1.55.946-.167 1.837-.074 2.644.473.734.501 1.188 1.179 1.309 2.07.158 1.252-.204 2.273-1.067 3.145-.613.622-1.364 1.012-2.227 1.188-.25.046-.501.056-.743.083zm2.209-3.748c-.01-.121-.01-.214-.028-.307-.167-.918-1.011-1.438-1.893-1.234-.863.195-1.42.743-1.624 1.615A1.528 1.528 0 009.445 8.7c.51.222 1.02.194 1.512-.056.733-.38 1.132-.974 1.179-1.772z'></path>
    </g>
    <defs>
      <clipPath id='clip0_169_24'>
        <path fill='#fff' d='M0 0H14V14H0z' />
      </clipPath>
    </defs>
  </svg>
)

export const React = (props: React.SVGProps<SVGSVGElement>) => (
  <svg width='14' height='14' fill='none' viewBox='0 0 14 14' {...props}>
    <path fill='currentColor' d='M8.172 6.99c0-.628-.525-1.137-1.172-1.137-.647 0-1.172.509-1.172 1.136 0 .628.525 1.137 1.172 1.137.647 0 1.172-.509 1.172-1.137z' />
    <path
      fill='currentColor'
      fillRule='evenodd'
      d='M10.806 4.88c.248-.975.559-2.784-.538-3.397-1.091-.61-2.512.56-3.262 1.262C6.258 2.049 4.798.885 3.702 1.5c-1.091.612-.755 2.39-.502 3.372-1.018.28-2.763.884-2.763 2.117 0 1.23 1.744 1.887 2.755 2.167-.254.987-.573 2.74.52 3.351 1.1.615 2.555-.522 3.312-1.232.755.707 2.162 1.85 3.254 1.238 1.095-.615.81-2.399.557-3.386.98-.28 2.727-.923 2.727-2.138 0-1.221-1.754-1.83-2.756-2.11zm-.124 3.724c-.166-.51-.39-1.052-.665-1.612.262-.547.478-1.082.64-1.588.734.206 2.345.678 2.345 1.585 0 .917-1.546 1.393-2.32 1.615zm-.685 3.439c-.815.457-2.025-.638-2.582-1.158.37-.392.74-.848 1.1-1.354a13.459 13.459 0 001.777-.266c.178.698.523 2.318-.295 2.778zm-6.005-.007c-.815-.455-.443-2.02-.256-2.746.538.115 1.133.198 1.769.248.363.495.743.95 1.126 1.35-.473.444-1.82 1.606-2.64 1.148zM.998 6.99c0-.92 1.602-1.388 2.353-1.593.164.517.38 1.059.64 1.607a12.989 12.989 0 00-.648 1.63C2.627 8.434.998 7.91.998 6.989zM3.983 1.97c.818-.459 2.087.66 2.63 1.163-.381.397-.758.849-1.118 1.341-.617.056-1.208.145-1.751.264-.204-.791-.578-2.31.239-2.768zm4.933 3.095c.419.051.82.12 1.197.203-.113.351-.254.719-.42 1.096a18.01 18.01 0 00-.777-1.299zm-1.91-1.544c.259.272.518.575.773.904a17.018 17.018 0 00-1.552 0c.255-.326.517-.63.78-.904zM4.312 6.363a11.76 11.76 0 01-.417-1.101c.375-.081.774-.148 1.19-.198-.278.421-.536.855-.773 1.3zm.785 2.59c-.43-.046-.835-.109-1.21-.188.116-.363.26-.74.426-1.123.24.449.501.887.784 1.312zm1.925 1.543c-.266-.278-.531-.585-.79-.916.52.02 1.04.02 1.56-.003-.255.337-.513.645-.77.92zm2.676-2.874c.175.388.323.763.44 1.12-.38.084-.79.152-1.224.202.28-.43.543-.87.784-1.322zM8.202 9.01c-.795.055-1.595.054-2.39.004A15.28 15.28 0 014.61 7.003c.346-.698.745-1.37 1.195-2.009a16.307 16.307 0 012.392 0c.446.64.845 1.31 1.199 2-.35.698-.751 1.37-1.194 2.016zm1.786-7.056c.819.458.454 2.083.276 2.79a13.821 13.821 0 00-1.755-.27c-.361-.497-.735-.95-1.11-1.342.55-.514 1.779-1.631 2.59-1.178z'
      clipRule='evenodd'
    />
  </svg>
)

export const Next = (props: React.SVGProps<SVGSVGElement>) => (
  <svg width='14' height='14' fill='none' viewBox='0 0 14 14' {...props}>
    <path
      fill='currentColor'
      d='M6.607 1.003l-.182.017a6.014 6.014 0 00-5.371 5.107c-.048.33-.054.427-.054.874s.006.544.054.874a6.024 6.024 0 004.104 4.847c.39.126.8.211 1.267.263.182.02.968.02 1.15 0a6.059 6.059 0 002.162-.632c.103-.053.123-.067.109-.079-.01-.007-.45-.597-.977-1.31l-.96-1.296L6.707 7.89a171.038 171.038 0 00-1.21-1.778c-.005-.001-.01.79-.013 1.755-.003 1.69-.004 1.758-.025 1.798a.213.213 0 01-.104.106c-.037.019-.07.023-.247.023h-.203l-.054-.034a.22.22 0 01-.079-.086l-.024-.053.002-2.351.004-2.353.036-.046a.322.322 0 01.087-.071c.048-.024.067-.026.27-.026.239 0 .279.01.341.077.018.019.669 1 1.447 2.18l2.368 3.586.95 1.439.048-.032a6.16 6.16 0 001.233-1.081 5.971 5.971 0 001.412-3.067c.048-.33.054-.427.054-.874s-.006-.544-.054-.874a6.024 6.024 0 00-5.354-5.109 15.508 15.508 0 00-.985-.015zm2.456 3.629a.237.237 0 01.119.138c.01.03.012.683.01 2.153L9.187 9.03l-.372-.57-.373-.57V6.358c0-.99.005-1.548.012-1.575a.24.24 0 01.116-.147c.048-.025.065-.027.25-.027.173 0 .204.002.242.023zM10.723 12.923c-.048.03-.063.05-.02.027.03-.018.078-.055.07-.056a.282.282 0 00-.05.029zm-.095.061c-.024.02-.024.02.006.006.016-.008.03-.018.03-.02 0-.012-.007-.009-.036.014zm-.068.041c-.025.02-.025.02.005.006.017-.008.03-.018.03-.02 0-.012-.006-.009-.035.014zm-.068.041c-.025.02-.025.02.005.006.017-.008.03-.018.03-.02 0-.012-.007-.009-.035.014zm-.104.055c-.052.027-.05.038.002.012a.14.14 0 00.041-.027c0-.01 0-.008-.043.015z'
    />
  </svg>
)

export const HTML = (props: React.SVGProps<SVGSVGElement>) => (
  <svg width='14' height='14' fill='none' viewBox='0 0 14 14' {...props}>
    <g fillRule='evenodd' clipPath='url(#clip0_171_23)' clipRule='evenodd'>
      <path fill='currentColor' d='M12 1l-1.002 10.799L6.493 13l-4.492-1.2L1 1h11z' />
      <path fill='currentColor' d='M6.5 12.082l3.64-.97.856-9.23H6.5v10.2z' />
      <path
        fill='#3D3D3D'
        d='M4.552 4.532h1.949V3.208H3.047l.032.355.338 3.65H6.5V5.89h-1.82l-.127-1.357zm.31 3.344H3.48l.193 2.08 2.822.753.006-.002V9.329l-.006.002-1.534-.398-.099-1.057z'
      />
      <path
        fill='#3D3D3D'
        d='M6.496 7.214H8.19l-.16 1.718-1.535.398v1.378l2.823-.753.02-.224.324-3.487.034-.355H6.496v1.325zm0-2.685v.003H9.82l.028-.298.063-.671.032-.356H6.496v1.322z'
      />
    </g>
    <defs>
      <clipPath id='clip0_171_23'>
        <path fill='transparent' d='M0 0H11V12H0z' transform='translate(1 1)' />
      </clipPath>
    </defs>
  </svg>
)

export const GitHub = (props: React.SVGProps<SVGSVGElement>) => (
  <svg width='14' height='14' fill='none' viewBox='0 0 14 14' {...props}>
    <path
      fill='currentColor'
      fillRule='evenodd'
      d='M7.005 1C3.685 1 1 3.75 1 7.152c0 2.72 1.72 5.022 4.106 5.836.298.062.408-.132.408-.295 0-.143-.01-.631-.01-1.14-1.67.366-2.018-.734-2.018-.734-.269-.713-.667-.896-.667-.896-.546-.377.04-.377.04-.377.607.04.925.631.925.631.537.937 1.402.673 1.75.51.05-.398.208-.673.377-.826C4.58 9.72 3.177 9.19 3.177 6.826c0-.672.239-1.222.617-1.65-.06-.153-.269-.784.06-1.63 0 0 .506-.163 1.65.632.49-.135.994-.203 1.501-.204.507 0 1.024.071 1.501.204 1.144-.795 1.65-.632 1.65-.632.329.846.12 1.477.06 1.63.388.428.617.978.617 1.65 0 2.363-1.402 2.883-2.744 3.035.218.194.407.56.407 1.141 0 .825-.01 1.487-.01 1.691 0 .163.11.357.408.296C11.28 12.172 13 9.872 13 7.152 13.01 3.75 10.316 1 7.005 1z'
      clipRule='evenodd'
    />
  </svg>
)

export const Loading = (props: React.SVGProps<SVGSVGElement>) => (
  <svg width='14' height='14' fill='none' viewBox='0 0 14 14' {...props}>
    <g stroke='currentColor' strokeLinecap='round' strokeLinejoin='round' strokeWidth='2' clipPath='url(#clip0_176_15)'>
      <path d='M7 1.167V3.5M9.45 4.55l1.692-1.692M10.5 7h2.333M9.45 9.45l1.692 1.692M7 10.5v2.333M2.858 11.142L4.55 9.45M1.167 7H3.5M2.858 2.858L4.55 4.55' />
    </g>
    <defs>
      <clipPath id='clip0_176_15'>
        <path fill='currentColor' d='M0 0H14V14H0z' />
      </clipPath>
    </defs>
  </svg>
)

export const Close = (props: React.SVGProps<SVGSVGElement>) => (
  <svg width='14' height='14' fill='none' viewBox='0 0 14 14' {...props}>
    <path stroke='currentColor' strokeLinecap='round' strokeLinejoin='round' strokeWidth='2' d='M10.5 3.5l-7 7M3.5 3.5l7 7' />
  </svg>
)

export function getFileIcon(name: string) {
  const ext = name.split('.').pop()

  switch (ext) {
    case 'ts':
      return <Typescript />
    case 'go':
      return <Go />
    case 'react':
      return <React />
    case 'react-native':
      return <React />
    case 'next':
      return <Next />
    case 'html':
      return <HTML />
    default:
      return
  }
}
