/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-lix2.c                                                              */
/* asn2wrs.py -b -q -L -p lix2 -c ./lix2.cnf -s ./packet-lix2-template -D . -O ../.. lix2.asn */

/* packet-lix2-template.c
 * Routines for Lawful Interception X2 xIRI event dissection
 *
 * See 3GPP TS33.128 V18.5.0
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "config.h"

#include <epan/packet.h>
#include <epan/conversation.h>
#include <epan/asn1.h>
#include <wsutil/array.h>

#include "packet-ber.h"
#include "packet-e164.h"
#include "packet-e212.h"
#include "packet-gsm_a_common.h"
#include "packet-gtpv2.h"

#define PNAME  "X2 xIRI payload"
#define PSNAME "xIRI"
#define PFNAME "xiri"

void proto_reg_handoff_lix2(void);
void proto_register_lix2(void);

/* Initialize the protocol and registered fields */
static int proto_lix2;
static dissector_handle_t lix2_handle;


static int hf_lix2_XIRIPayload_PDU;               /* XIRIPayload */
static int hf_lix2_xIRIPayloadOID;                /* RELATIVE_OID */
static int hf_lix2_event;                         /* XIRIEvent */
static int hf_lix2_registration;                  /* AMFRegistration */
static int hf_lix2_deregistration;                /* AMFDeregistration */
static int hf_lix2_locationUpdate;                /* AMFLocationUpdate */
static int hf_lix2_startOfInterceptionWithRegisteredUE;  /* AMFStartOfInterceptionWithRegisteredUE */
static int hf_lix2_unsuccessfulAMProcedure;       /* AMFUnsuccessfulProcedure */
static int hf_lix2_pDUSessionEstablishment;       /* SMFPDUSessionEstablishment */
static int hf_lix2_pDUSessionModification;        /* SMFPDUSessionModification */
static int hf_lix2_pDUSessionRelease;             /* SMFPDUSessionRelease */
static int hf_lix2_startOfInterceptionWithEstablishedPDUSession;  /* SMFStartOfInterceptionWithEstablishedPDUSession */
static int hf_lix2_unsuccessfulSMProcedure;       /* SMFUnsuccessfulProcedure */
static int hf_lix2_servingSystemMessage;          /* UDMServingSystemMessage */
static int hf_lix2_sMSMessage;                    /* SMSMessage */
static int hf_lix2_lALSReport;                    /* LALSReport */
static int hf_lix2_pDHeaderReport;                /* PDHeaderReport */
static int hf_lix2_pDSummaryReport;               /* PDSummaryReport */
static int hf_lix2_mMSSend;                       /* MMSSend */
static int hf_lix2_mMSSendByNonLocalTarget;       /* MMSSendByNonLocalTarget */
static int hf_lix2_mMSNotification;               /* MMSNotification */
static int hf_lix2_mMSSendToNonLocalTarget;       /* MMSSendToNonLocalTarget */
static int hf_lix2_mMSNotificationResponse;       /* MMSNotificationResponse */
static int hf_lix2_mMSRetrieval;                  /* MMSRetrieval */
static int hf_lix2_mMSDeliveryAck;                /* MMSDeliveryAck */
static int hf_lix2_mMSForward;                    /* MMSForward */
static int hf_lix2_mMSDeleteFromRelay;            /* MMSDeleteFromRelay */
static int hf_lix2_mMSDeliveryReport;             /* MMSDeliveryReport */
static int hf_lix2_mMSDeliveryReportNonLocalTarget;  /* MMSDeliveryReportNonLocalTarget */
static int hf_lix2_mMSReadReport;                 /* MMSReadReport */
static int hf_lix2_mMSReadReportNonLocalTarget;   /* MMSReadReportNonLocalTarget */
static int hf_lix2_mMSCancel;                     /* MMSCancel */
static int hf_lix2_mMSMBoxStore;                  /* MMSMBoxStore */
static int hf_lix2_mMSMBoxUpload;                 /* MMSMBoxUpload */
static int hf_lix2_mMSMBoxDelete;                 /* MMSMBoxDelete */
static int hf_lix2_mMSMBoxViewRequest;            /* MMSMBoxViewRequest */
static int hf_lix2_mMSMBoxViewResponse;           /* MMSMBoxViewResponse */
static int hf_lix2_pTCRegistration;               /* PTCRegistration */
static int hf_lix2_pTCSessionInitiation;          /* PTCSessionInitiation */
static int hf_lix2_pTCSessionAbandon;             /* PTCSessionAbandon */
static int hf_lix2_pTCSessionStart;               /* PTCSessionStart */
static int hf_lix2_pTCSessionEnd;                 /* PTCSessionEnd */
static int hf_lix2_pTCStartOfInterception;        /* PTCStartOfInterception */
static int hf_lix2_pTCPreEstablishedSession;      /* PTCPreEstablishedSession */
static int hf_lix2_pTCInstantPersonalAlert;       /* PTCInstantPersonalAlert */
static int hf_lix2_pTCPartyJoin;                  /* PTCPartyJoin */
static int hf_lix2_pTCPartyDrop;                  /* PTCPartyDrop */
static int hf_lix2_pTCPartyHold;                  /* PTCPartyHold */
static int hf_lix2_pTCMediaModification;          /* PTCMediaModification */
static int hf_lix2_pTCGroupAdvertisement;         /* PTCGroupAdvertisement */
static int hf_lix2_pTCFloorControl;               /* PTCFloorControl */
static int hf_lix2_pTCTargetPresence;             /* PTCTargetPresence */
static int hf_lix2_pTCParticipantPresence;        /* PTCParticipantPresence */
static int hf_lix2_pTCListManagement;             /* PTCListManagement */
static int hf_lix2_pTCAccessPolicy;               /* PTCAccessPolicy */
static int hf_lix2_subscriberRecordChangeMessage;  /* UDMSubscriberRecordChangeMessage */
static int hf_lix2_cancelLocationMessage;         /* UDMCancelLocationMessage */
static int hf_lix2_sMSReport;                     /* SMSReport */
static int hf_lix2_sMFMAPDUSessionEstablishment;  /* SMFMAPDUSessionEstablishment */
static int hf_lix2_sMFMAPDUSessionModification;   /* SMFMAPDUSessionModification */
static int hf_lix2_sMFMAPDUSessionRelease;        /* SMFMAPDUSessionRelease */
static int hf_lix2_startOfInterceptionWithEstablishedMAPDUSession;  /* SMFStartOfInterceptionWithEstablishedMAPDUSession */
static int hf_lix2_unsuccessfulMASMProcedure;     /* SMFMAUnsuccessfulProcedure */
static int hf_lix2_aMFIdentifierAssociation;      /* AMFIdentifierAssociation */
static int hf_lix2_mMEIdentifierAssociation;      /* MMEIdentifierAssociation */
static int hf_lix2_sMFPDUtoMAPDUSessionModification;  /* SMFPDUtoMAPDUSessionModification */
static int hf_lix2_nEFPDUSessionEstablishment;    /* NEFPDUSessionEstablishment */
static int hf_lix2_nEFPDUSessionModification;     /* NEFPDUSessionModification */
static int hf_lix2_nEFPDUSessionRelease;          /* NEFPDUSessionRelease */
static int hf_lix2_nEFUnsuccessfulProcedure;      /* NEFUnsuccessfulProcedure */
static int hf_lix2_nEFStartOfInterceptionWithEstablishedPDUSession;  /* NEFStartOfInterceptionWithEstablishedPDUSession */
static int hf_lix2_nEFdeviceTrigger;              /* NEFDeviceTrigger */
static int hf_lix2_nEFdeviceTriggerReplace;       /* NEFDeviceTriggerReplace */
static int hf_lix2_nEFdeviceTriggerCancellation;  /* NEFDeviceTriggerCancellation */
static int hf_lix2_nEFdeviceTriggerReportNotify;  /* NEFDeviceTriggerReportNotify */
static int hf_lix2_nEFMSISDNLessMOSMS;            /* NEFMSISDNLessMOSMS */
static int hf_lix2_nEFExpectedUEBehaviourUpdate;  /* NEFExpectedUEBehaviourUpdate */
static int hf_lix2_sCEFPDNConnectionEstablishment;  /* SCEFPDNConnectionEstablishment */
static int hf_lix2_sCEFPDNConnectionUpdate;       /* SCEFPDNConnectionUpdate */
static int hf_lix2_sCEFPDNConnectionRelease;      /* SCEFPDNConnectionRelease */
static int hf_lix2_sCEFUnsuccessfulProcedure;     /* SCEFUnsuccessfulProcedure */
static int hf_lix2_sCEFStartOfInterceptionWithEstablishedPDNConnection;  /* SCEFStartOfInterceptionWithEstablishedPDNConnection */
static int hf_lix2_sCEFdeviceTrigger;             /* SCEFDeviceTrigger */
static int hf_lix2_sCEFdeviceTriggerReplace;      /* SCEFDeviceTriggerReplace */
static int hf_lix2_sCEFdeviceTriggerCancellation;  /* SCEFDeviceTriggerCancellation */
static int hf_lix2_sCEFdeviceTriggerReportNotify;  /* SCEFDeviceTriggerReportNotify */
static int hf_lix2_sCEFMSISDNLessMOSMS;           /* SCEFMSISDNLessMOSMS */
static int hf_lix2_sCEFCommunicationPatternUpdate;  /* SCEFCommunicationPatternUpdate */
static int hf_lix2_mMEAttach;                     /* MMEAttach */
static int hf_lix2_mMEDetach;                     /* MMEDetach */
static int hf_lix2_mMELocationUpdate;             /* MMELocationUpdate */
static int hf_lix2_mMEStartOfInterceptionWithEPSAttachedUE;  /* MMEStartOfInterceptionWithEPSAttachedUE */
static int hf_lix2_mMEUnsuccessfulProcedure;      /* MMEUnsuccessfulProcedure */
static int hf_lix2_aAnFAnchorKeyRegister;         /* AAnFAnchorKeyRegister */
static int hf_lix2_aAnFKAKMAApplicationKeyGet;    /* AAnFKAKMAApplicationKeyGet */
static int hf_lix2_aAnFStartOfInterceptWithEstablishedAKMAKeyMaterial;  /* AAnFStartOfInterceptWithEstablishedAKMAKeyMaterial */
static int hf_lix2_aAnFAKMAContextRemovalRecord;  /* AAnFAKMAContextRemovalRecord */
static int hf_lix2_aFAKMAApplicationKeyRefresh;   /* AFAKMAApplicationKeyRefresh */
static int hf_lix2_aFStartOfInterceptWithEstablishedAKMAApplicationKey;  /* AFStartOfInterceptWithEstablishedAKMAApplicationKey */
static int hf_lix2_aFAuxiliarySecurityParameterEstablishment;  /* AFAuxiliarySecurityParameterEstablishment */
static int hf_lix2_aFApplicationKeyRemoval;       /* AFApplicationKeyRemoval */
static int hf_lix2_n9HRPDUSessionInfo;            /* N9HRPDUSessionInfo */
static int hf_lix2_s8HRBearerInfo;                /* S8HRBearerInfo */
static int hf_lix2_separatedLocationReporting;    /* SeparatedLocationReporting */
static int hf_lix2_sTIRSHAKENSignatureGeneration;  /* STIRSHAKENSignatureGeneration */
static int hf_lix2_sTIRSHAKENSignatureValidation;  /* STIRSHAKENSignatureValidation */
static int hf_lix2_iMSMessage;                    /* IMSMessage */
static int hf_lix2_startOfInterceptionForActiveIMSSession;  /* StartOfInterceptionForActiveIMSSession */
static int hf_lix2_iMSCCUnavailable;              /* IMSCCUnavailable */
static int hf_lix2_uDMLocationInformationResult;  /* UDMLocationInformationResult */
static int hf_lix2_uDMUEInformationResponse;      /* UDMUEInformationResponse */
static int hf_lix2_uDMUEAuthenticationResponse;   /* UDMUEAuthenticationResponse */
static int hf_lix2_positioningInfoTransfer;       /* AMFPositioningInfoTransfer */
static int hf_lix2_mMEPositioningInfoTransfer;    /* MMEPositioningInfoTransfer */
static int hf_lix2_aMFRANHandoverCommand;         /* AMFRANHandoverCommand */
static int hf_lix2_aMFRANHandoverRequest;         /* AMFRANHandoverRequest */
static int hf_lix2_eESEECRegistration;            /* EESEECRegistration */
static int hf_lix2_eESEASDiscovery;               /* EESEASDiscovery */
static int hf_lix2_eESEASDiscoverySubscription;   /* EESEASDiscoverySubscription */
static int hf_lix2_eESEASDiscoveryNotification;   /* EESEASDiscoveryNotification */
static int hf_lix2_eESAppContextRelocation;       /* EESAppContextRelocation */
static int hf_lix2_eESACRSubscription;            /* EESACRSubscription */
static int hf_lix2_eESACRNotification;            /* EESACRNotification */
static int hf_lix2_eESEECContextRelocation;       /* EESEECContextRelocation */
static int hf_lix2_eESStartOfInterceptionWithRegisteredEEC;  /* EESStartOfInterceptionWithRegisteredEEC */
static int hf_lix2_uDMStartOfInterceptionWithRegisteredTarget;  /* UDMStartOfInterceptionWithRegisteredTarget */
static int hf_lix2_fiveGMSAFServiceAccessInformation;  /* FiveGMSAFServiceAccessInformation */
static int hf_lix2_fiveGMSAFConsumptionReporting;  /* FiveGMSAFConsumptionReporting */
static int hf_lix2_fiveGMSAFDynamicPolicyInvocation;  /* FiveGMSAFDynamicPolicyInvocation */
static int hf_lix2_fiveGMSAFMetricsReporting;     /* FiveGMSAFMetricsReporting */
static int hf_lix2_fiveGMSAFNetworkAssistance;    /* FiveGMSAFNetworkAssistance */
static int hf_lix2_fiveGMSAFUnsuccessfulProcedure;  /* FiveGMSAFUnsuccessfulProcedure */
static int hf_lix2_fiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE;  /* FiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE */
static int hf_lix2_aMFUEConfigurationUpdate;      /* AMFUEConfigurationUpdate */
static int hf_lix2_hSSServingSystemMessage;       /* HSSServingSystemMessage */
static int hf_lix2_hSSStartOfInterceptionWithRegisteredTarget;  /* HSSStartOfInterceptionWithRegisteredTarget */
static int hf_lix2_nEFAFSessionWithQoSProvision;  /* NEFAFSessionWithQoSProvision */
static int hf_lix2_nEFAFSessionWithQoSNotification;  /* NEFAFSessionWithQoSNotification */
static int hf_lix2_sCEFASSessionWithQoSProvision;  /* SCEFASSessionWithQoSProvision */
static int hf_lix2_sCEFASSessionWithQoSNotification;  /* SCEFASSessionWithQoSNotification */
static int hf_lix2_aMFRANTraceReport;             /* AMFRANTraceReport */
static int hf_lix2_rCSRegistration;               /* RCSRegistration */
static int hf_lix2_rCSMessage;                    /* RCSMessage */
static int hf_lix2_rCSCapabilityDiscovery;        /* RCSCapabilityDiscovery */
static int hf_lix2_rCSSessionEstablishment;       /* RCSSessionEstablishment */
static int hf_lix2_rCSSessionModification;        /* RCSSessionModification */
static int hf_lix2_rCSSessionRelease;             /* RCSSessionRelease */
static int hf_lix2_aMFUEPolicyTransfer;           /* AMFUEPolicyTransfer */
static int hf_lix2_aMFUEServiceAccept;            /* AMFUEServiceAccept */
static int hf_lix2_ePSRANHandoverCommand;         /* EPSRANHandoverCommand */
static int hf_lix2_ePSRANHandoverRequest;         /* EPSRANHandoverRequest */
static int hf_lix2_mMERANTraceReport;             /* MMERANTraceReport */
static int hf_lix2_mMEUEServiceAccept;            /* MMEUEServiceAccept */
static int hf_lix2_nWDAFEventsSubscription;       /* NWDAFEventsSubscription */
static int hf_lix2_nWDAFEventsNotification;       /* NWDAFEventsNotification */
static int hf_lix2_nWDAFAnalyticsInfoQuery;       /* NWDAFAnalyticsInfoQuery */
static int hf_lix2_nWDAFRoamingAnalyticsSubscription;  /* NWDAFRoamingAnalyticsSubscription */
static int hf_lix2_nWDAFRoamingAnalyticsNotification;  /* NWDAFRoamingAnalyticsNotification */
static int hf_lix2_startOfInterceptForRegisteredRCSUser;  /* StartOfInterceptForRegisteredRCSUser */
static int hf_lix2_startOfInterceptWithEstablisedRCSSession;  /* StartOfInterceptWithEstablisedRCSSession */
static int hf_lix2_uDMProSeTargetIdentifierDeconcealment;  /* UDMProSeTargetIdentifierDeconcealment */
static int hf_lix2_uDMProSeTargetAuthentication;  /* UDMProSeTargetAuthentication */
static int hf_lix2_iRIPayloadOID;                 /* RELATIVE_OID */
static int hf_lix2_event_01;                      /* IRIEvent */
static int hf_lix2_targetIdentifiers;             /* SEQUENCE_OF_IRITargetIdentifier */
static int hf_lix2_targetIdentifiers_item;        /* IRITargetIdentifier */
static int hf_lix2_mediatedFromIndicator;         /* MediatedFromIndicator */
static int hf_lix2_mDFCellSiteReport;             /* MDFCellSiteReport */
static int hf_lix2_identifier;                    /* TargetIdentifier */
static int hf_lix2_provenance;                    /* TargetIdentifierProvenance */
static int hf_lix2_xIRIRelativeOID;               /* RELATIVE_OID */
static int hf_lix2_cCPayloadOID;                  /* RELATIVE_OID */
static int hf_lix2_pDU;                           /* CCPDU */
static int hf_lix2_uPFCCPDU;                      /* UPFCCPDU */
static int hf_lix2_extendedUPFCCPDU;              /* ExtendedUPFCCPDU */
static int hf_lix2_mMSCCPDU;                      /* MMSCCPDU */
static int hf_lix2_nIDDCCPDU;                     /* NIDDCCPDU */
static int hf_lix2_pTCCCPDU;                      /* PTCCCPDU */
static int hf_lix2_iMSCCPDU;                      /* IMSCCPDU */
static int hf_lix2_rCSCCPDU;                      /* RCSCCPDU */
static int hf_lix2_lINotificationPayloadOID;      /* RELATIVE_OID */
static int hf_lix2_notification;                  /* LINotificationMessage */
static int hf_lix2_lINotification;                /* LINotification */
static int hf_lix2_sUPI;                          /* SUPI */
static int hf_lix2_pEI;                           /* PEI */
static int hf_lix2_pDUSessionID;                  /* PDUSessionID */
static int hf_lix2_location;                      /* Location */
static int hf_lix2_sNSSAI;                        /* SNSSAI */
static int hf_lix2_dNN;                           /* DNN */
static int hf_lix2_messageCause;                  /* N9HRMessageCause */
static int hf_lix2_iMSI;                          /* IMSI */
static int hf_lix2_iMEI;                          /* IMEI */
static int hf_lix2_bearerID;                      /* EPSBearerID */
static int hf_lix2_linkedBearerID;                /* EPSBearerID */
static int hf_lix2_aPN;                           /* APN */
static int hf_lix2_sGWIPAddress;                  /* IPAddress */
static int hf_lix2_messageCause_01;               /* S8HRMessageCause */
static int hf_lix2_gPSI;                          /* GPSI */
static int hf_lix2_nEFID;                         /* NEFID */
static int hf_lix2_rDSSupport;                    /* RDSSupport */
static int hf_lix2_sMFID;                         /* SMFID */
static int hf_lix2_aFID;                          /* AFID */
static int hf_lix2_initiator;                     /* Initiator */
static int hf_lix2_rDSSourcePortNumber;           /* RDSPortNumber */
static int hf_lix2_rDSDestinationPortNumber;      /* RDSPortNumber */
static int hf_lix2_applicationID;                 /* ApplicationID */
static int hf_lix2_rDSAction;                     /* RDSAction */
static int hf_lix2_serializationFormat;           /* SerializationFormat */
static int hf_lix2_timeOfFirstPacket;             /* Timestamp */
static int hf_lix2_timeOfLastPacket;              /* Timestamp */
static int hf_lix2_uplinkVolume;                  /* INTEGER */
static int hf_lix2_downlinkVolume;                /* INTEGER */
static int hf_lix2_releaseCause;                  /* NEFReleaseCause */
static int hf_lix2_failureCause;                  /* NEFFailureCause */
static int hf_lix2_triggerId;                     /* TriggerID */
static int hf_lix2_triggerPayload;                /* TriggerPayload */
static int hf_lix2_validityPeriod;                /* INTEGER */
static int hf_lix2_priorityDT;                    /* PriorityDT */
static int hf_lix2_sourcePortId;                  /* PortNumber */
static int hf_lix2_destinationPortId;             /* PortNumber */
static int hf_lix2_deviceTriggerDeliveryResult;   /* DeviceTriggerDeliveryResult */
static int hf_lix2_terminatingSMSParty;           /* AFID */
static int hf_lix2_sMS;                           /* SMSTPDUData */
static int hf_lix2_sourcePort;                    /* PortNumber */
static int hf_lix2_destinationPort;               /* PortNumber */
static int hf_lix2_expectedUEMovingTrajectory;    /* SEQUENCE_OF_UMTLocationArea5G */
static int hf_lix2_expectedUEMovingTrajectory_item;  /* UMTLocationArea5G */
static int hf_lix2_stationaryIndication;          /* StationaryIndication */
static int hf_lix2_communicationDurationTime;     /* INTEGER */
static int hf_lix2_periodicTime;                  /* INTEGER */
static int hf_lix2_scheduledCommunicationTime;    /* ScheduledCommunicationTime */
static int hf_lix2_scheduledCommunicationType;    /* ScheduledCommunicationType */
static int hf_lix2_batteryIndication;             /* BatteryIndication */
static int hf_lix2_trafficProfile;                /* TrafficProfile */
static int hf_lix2_expectedTimeAndDayOfWeekInTrajectory;  /* SEQUENCE_OF_UMTLocationArea5G */
static int hf_lix2_expectedTimeAndDayOfWeekInTrajectory_item;  /* UMTLocationArea5G */
static int hf_lix2_validityTime;                  /* Timestamp */
static int hf_lix2_aFSessionWithQoSOpType;        /* AForASSessionWithQoSOpType */
static int hf_lix2_aFSessionWithQoSSubscription;  /* SBIType */
static int hf_lix2_aFSessionWithQoSSubscriptionPatch;  /* SBIType */
static int hf_lix2_aFSessionWithQoSResponseCode;  /* AForASSessionWithQoSResponseCode */
static int hf_lix2_userPlaneNotificationData;     /* SBIType */
static int hf_lix2_aForASSessionWithQoSResponseCode;  /* AForASSessionWithQoSResponseCode */
static int hf_lix2_days;                          /* SEQUENCE_OF_Daytime */
static int hf_lix2_days_item;                     /* Daytime */
static int hf_lix2_timeOfDay;                     /* Daytime */
static int hf_lix2_durationSec;                   /* INTEGER */
static int hf_lix2_location_01;                   /* NRLocation */
static int hf_lix2_daysOfWeek;                    /* Day */
static int hf_lix2_timeOfDayStart;                /* Timestamp */
static int hf_lix2_timeOfDayEnd;                  /* Timestamp */
static int hf_lix2_mSISDN;                        /* MSISDN */
static int hf_lix2_externalIdentifier;            /* NAI */
static int hf_lix2_ePSBearerID;                   /* EPSBearerID */
static int hf_lix2_sCEFID;                        /* SCEFID */
static int hf_lix2_sCSASID;                       /* SCSASID */
static int hf_lix2_releaseCause_01;               /* SCEFReleaseCause */
static int hf_lix2_failureCause_01;               /* SCEFFailureCause */
static int hf_lix2_externalIdentifie;             /* NAI */
static int hf_lix2_terminatingSMSParty_01;        /* SCSASID */
static int hf_lix2_periodicCommunicationIndicator;  /* PeriodicCommunicationIndicator */
static int hf_lix2_aSSessionWithQoSOpType;        /* AForASSessionWithQoSOpType */
static int hf_lix2_aSSessionWithQoSSubscription;  /* SBIType */
static int hf_lix2_aSSessionWithQoSSubscriptionPatch;  /* SBIType */
static int hf_lix2_aSSessionWithQoSResponseCode;  /* AForASSessionWithQoSResponseCode */
static int hf_lix2_aKID;                          /* NAI */
static int hf_lix2_kAKMA;                         /* KAKMA */
static int hf_lix2_type;                          /* KeyGetType */
static int hf_lix2_keyInfo;                       /* AFKeyInfo */
static int hf_lix2_aFKeyList;                     /* SEQUENCE_OF_AFKeyInfo */
static int hf_lix2_aFKeyList_item;                /* AFKeyInfo */
static int hf_lix2_nFID;                          /* NFID */
static int hf_lix2_aFFQDN;                        /* FQDN */
static int hf_lix2_uaProtocolID;                  /* UAProtocolID */
static int hf_lix2_tls12;                         /* TLS12UAStarParams */
static int hf_lix2_generic;                       /* GenericUAStarParams */
static int hf_lix2_genericClientParams;           /* OCTET_STRING */
static int hf_lix2_genericServerParams;           /* OCTET_STRING */
static int hf_lix2_TLSCipherSuite_item;           /* INTEGER_0_255 */
static int hf_lix2_preMasterSecret;               /* OCTET_STRING_SIZE_48 */
static int hf_lix2_masterSecret;                  /* OCTET_STRING_SIZE_48 */
static int hf_lix2_pRFAlgorithm;                  /* TLSPRFAlgorithm */
static int hf_lix2_cipherSuite;                   /* TLSCipherSuite */
static int hf_lix2_cipherType;                    /* TLSCipherType */
static int hf_lix2_encKeyLength;                  /* INTEGER_0_255 */
static int hf_lix2_blockLength;                   /* INTEGER_0_255 */
static int hf_lix2_fixedIVLength;                 /* INTEGER_0_255 */
static int hf_lix2_recordIVLength;                /* INTEGER_0_255 */
static int hf_lix2_macLength;                     /* INTEGER_0_255 */
static int hf_lix2_macKeyLength;                  /* INTEGER_0_255 */
static int hf_lix2_compressionAlgorithm;          /* TLSCompressionAlgorithm */
static int hf_lix2_clientRandom;                  /* OCTET_STRING_SIZE_32 */
static int hf_lix2_serverRandom;                  /* OCTET_STRING_SIZE_32 */
static int hf_lix2_clientSequenceNumber;          /* INTEGER */
static int hf_lix2_serverSequenceNumber;          /* INTEGER */
static int hf_lix2_sessionID;                     /* OCTET_STRING_SIZE_0_32 */
static int hf_lix2_tLSServerExtensions;           /* OCTET_STRING_SIZE_0_65535 */
static int hf_lix2_tLSClientExtensions;           /* OCTET_STRING_SIZE_0_65535 */
static int hf_lix2_aFID_01;                       /* AKMAAFID */
static int hf_lix2_kAF;                           /* KAF */
static int hf_lix2_kAFExpTime;                    /* KAFExpiryTime */
static int hf_lix2_uaStarParams;                  /* UAStarParams */
static int hf_lix2_aFID_02;                       /* FQDN */
static int hf_lix2_kAFParamList;                  /* SEQUENCE_OF_AFSecurityParams */
static int hf_lix2_kAFParamList_item;             /* AFSecurityParams */
static int hf_lix2_aFSecurityParams;              /* AFSecurityParams */
static int hf_lix2_removalCause;                  /* AFKeyRemovalCause */
static int hf_lix2_registrationType;              /* AMFRegistrationType */
static int hf_lix2_registrationResult;            /* AMFRegistrationResult */
static int hf_lix2_slice;                         /* Slice */
static int hf_lix2_sUCI;                          /* SUCI */
static int hf_lix2_gUTI;                          /* FiveGGUTI */
static int hf_lix2_non3GPPAccessEndpoint;         /* UEEndpointAddress */
static int hf_lix2_fiveGSTAIList;                 /* TAIList */
static int hf_lix2_sMSOverNasIndicator;           /* SMSOverNASIndicator */
static int hf_lix2_oldGUTI;                       /* EPS5GGUTI */
static int hf_lix2_eMM5GRegStatus;                /* EMM5GMMStatus */
static int hf_lix2_nonIMEISVPEI;                  /* NonIMEISVPEI */
static int hf_lix2_mACRestIndicator;              /* MACRestrictionIndicator */
static int hf_lix2_pagingRestrictionIndicator;    /* PagingRestrictionIndicator */
static int hf_lix2_rATType;                       /* RATType */
static int hf_lix2_rRCEstablishmentCause;         /* RRCEstablishmentCause */
static int hf_lix2_nGInformation;                 /* NGInformation */
static int hf_lix2_nASTransportInitialInformation;  /* NASTransportInitialInformation */
static int hf_lix2_sORTransparentContainer;       /* SORTransparentContainer */
static int hf_lix2_equivalentPLMNList;            /* PLMNList */
static int hf_lix2_fiveGMMCapability;             /* FiveGMMCapability */
static int hf_lix2_initialRANUEContextSetup;      /* InitialRANUEContextSetup */
static int hf_lix2_mUSIMUERequestType;            /* MUSIMUERequestType */
static int hf_lix2_unavailabilityPeriodDuration;  /* UnavailabilityPeriodDuration */
static int hf_lix2_fiveGSUpdateType;              /* FiveGSUpdateType */
static int hf_lix2_uEAreaIndication;              /* UEAreaIndication */
static int hf_lix2_establishmentCauseNon3GPPAccess;  /* EstablishmentCauseNon3GPPAccess */
static int hf_lix2_deregistrationDirection;       /* AMFDirection */
static int hf_lix2_accessType;                    /* AccessType */
static int hf_lix2_cause;                         /* FiveGMMCause */
static int hf_lix2_switchOffIndicator;            /* SwitchOffIndicator */
static int hf_lix2_reRegRequiredIndicator;        /* ReRegRequiredIndicator */
static int hf_lix2_deprecatedSMSOverNASIndicator;  /* SMSOverNASIndicator */
static int hf_lix2_deprecatedOldGUTI;             /* EPS5GGUTI */
static int hf_lix2_timeOfRegistration;            /* Timestamp */
static int hf_lix2_sMSOverNASIndicator;           /* SMSOverNASIndicator */
static int hf_lix2_uEPolicy;                      /* UEPolicy */
static int hf_lix2_failedProcedureType;           /* AMFFailedProcedureType */
static int hf_lix2_failureCause_02;               /* AMFFailureCause */
static int hf_lix2_requestedSlice;                /* NSSAI */
static int hf_lix2_nRPPaMessage;                  /* OCTET_STRING */
static int hf_lix2_lPPMessage;                    /* OCTET_STRING */
static int hf_lix2_lcsCorrelationId;              /* UTF8String_SIZE_1_255 */
static int hf_lix2_userIdentifiers;               /* UserIdentifiers */
static int hf_lix2_aMFUENGAPID;                   /* AMFUENGAPID */
static int hf_lix2_rANUENGAPID;                   /* RANUENGAPID */
static int hf_lix2_handoverType;                  /* HandoverType */
static int hf_lix2_targetToSourceContainer;       /* RANTargetToSourceContainer */
static int hf_lix2_handoverCause;                 /* HandoverCause */
static int hf_lix2_pDUSessionResourceInformation;  /* PDUSessionResourceInformation */
static int hf_lix2_mobilityRestrictionList;       /* MobilityRestrictionList */
static int hf_lix2_locationReportingRequestType;  /* LocationReportingRequestType */
static int hf_lix2_nPNAccessInformation;          /* NPNAccessInformation */
static int hf_lix2_sourceToTargetContainer;       /* RANSourceToTargetContainer */
static int hf_lix2_gUTI_01;                       /* GUTI */
static int hf_lix2_serviceAreaList;               /* ServiceAreaList */
static int hf_lix2_traceRecordType;               /* TraceRecordType */
static int hf_lix2_traceDirection;                /* TraceDirection */
static int hf_lix2_deprecatedTraceActivationInfo;  /* TraceActivationInfo */
static int hf_lix2_nGRANCGI;                      /* NCGI */
static int hf_lix2_globalRANNodeID;               /* GlobalRANNodeID */
static int hf_lix2_traceCollectionEntityInfo;     /* TraceCollectionEntityInfo */
static int hf_lix2_aMFTraceData;                  /* XMLType */
static int hf_lix2_traceActivation;               /* TraceActivation */
static int hf_lix2_serviceMessageIdentity;        /* ServiceMessageIdentity */
static int hf_lix2_serviceType;                   /* OCTET_STRING_SIZE_1 */
static int hf_lix2_fiveGTMSI;                     /* FiveGTMSI */
static int hf_lix2_uplinkDataStatus;              /* OCTET_STRING_SIZE_2_32 */
static int hf_lix2_pDUSessionStatus;              /* OCTET_STRING_SIZE_2_32 */
static int hf_lix2_deprecatedUERequestType;       /* FiveGSMRequestType */
static int hf_lix2_pagingRestriction;             /* PagingRestrictionIndicator */
static int hf_lix2_forbiddenTAIList;              /* TAIList */
static int hf_lix2_uERequestType;                 /* MUSIMUERequestType */
static int hf_lix2_aMFRegionID;                   /* AMFRegionID */
static int hf_lix2_aMFSetID;                      /* AMFSetID */
static int hf_lix2_aMFPointer;                    /* AMFPointer */
static int hf_lix2_fiveGMMCause;                  /* FiveGMMCause */
static int hf_lix2_fiveGSMCause;                  /* FiveGSMCause */
static int hf_lix2_serviceRequest;                /* OCTET_STRING */
static int hf_lix2_serviceAccept;                 /* OCTET_STRING */
static int hf_lix2_nGRANTraceID;                  /* OCTET_STRING_SIZE_8 */
static int hf_lix2_interfacestoTrace;             /* BIT_STRING_SIZE_8 */
static int hf_lix2_traceDepth;                    /* TraceDepth */
static int hf_lix2_traceCollectionEntityIPAddress;  /* IPAddress */
static int hf_lix2_mDTConfiguration;              /* MDTConfiguration */
static int hf_lix2_traceCollectionEntityIPAddress_01;  /* BIT_STRING_SIZE_1_160_ */
static int hf_lix2_traceCollectionEntityURI;      /* UTF8String */
static int hf_lix2_iABNodeIndication;             /* BOOLEAN */
static int hf_lix2_eDTSession;                    /* BOOLEAN */
static int hf_lix2_authenticatedIndication;       /* BOOLEAN */
static int hf_lix2_nPNAccessInformation_01;       /* CellCAGList */
static int hf_lix2_rEDCAPIndication;              /* REDCAPIndication */
static int hf_lix2_rANNodeName;                   /* RANNodeName */
static int hf_lix2_supportedTAList;               /* SupportedTAList */
static int hf_lix2_extendedRANNodeName;           /* RANNodeName */
static int hf_lix2_pLMNSupportList;               /* PLMNSupportList */
static int hf_lix2_iABSupported;                  /* BOOLEAN */
static int hf_lix2_PLMNSupportList_item;          /* PLMNSupportItem */
static int hf_lix2_pLMNIdentity;                  /* PLMNID */
static int hf_lix2_nPNSupport;                    /* NID */
static int hf_lix2_onboardingSupport;             /* BOOLEAN */
static int hf_lix2_gNBDUID;                       /* INTEGER_0_68719476735 */
static int hf_lix2_gNBDUName;                     /* UTF8String */
static int hf_lix2_gNBCUName;                     /* UTF8String */
static int hf_lix2_gNBDUServedCells;              /* SEQUENCE_SIZE_1_MAX_OF_RANCGI */
static int hf_lix2_gNBDUServedCells_item;         /* RANCGI */
static int hf_lix2_extendedGNBDUName;             /* UTF8String */
static int hf_lix2_extendedGNBCUName;             /* UTF8String */
static int hf_lix2_ePCEstablishmentCause;         /* EstablishmentCause */
static int hf_lix2_fiveGCEstablishmentCause;      /* EstablishmentCause */
static int hf_lix2_oldAMF;                        /* GUAMI */
static int hf_lix2_pDUSessionSetupRequest;        /* SEQUENCE_SIZE_1_MAX_OF_PDUSessionSetupRequestItem */
static int hf_lix2_pDUSessionSetupRequest_item;   /* PDUSessionSetupRequestItem */
static int hf_lix2_allowedNSSAI;                  /* AllowedNSSAI */
static int hf_lix2_uERadioCapability;             /* UERadioCapability */
static int hf_lix2_rATFrequencySelectionPriority;  /* RATFrequencySelectionPriority */
static int hf_lix2_uERadioCapabilityForPaging;    /* UERadioCapabilityForPaging */
static int hf_lix2_iABAuthorizedIndicator;        /* IABAuthorizedIndicator */
static int hf_lix2_nRV2XServicesAuthorization;    /* NRV2XServicesAuthorization */
static int hf_lix2_lTEV2XServiceAuthorization;    /* LTEV2XServiceAuthorization */
static int hf_lix2_rGLevelWirelineAccessCharacteristics;  /* OCTET_STRING */
static int hf_lix2_uERadioCapabilityID;           /* OCTET_STRING */
static int hf_lix2_targetNSSAIInfo;               /* TargetNSSAIInfo */
static int hf_lix2_fiveGProSeAuthorizationIndication;  /* FiveGProSeAuthorizationIndication */
static int hf_lix2_uERadioCapibilityNR;           /* OCTET_STRING */
static int hf_lix2_uERadioCapabilityEUTRA;        /* OCTET_STRING */
static int hf_lix2_uERadioCapabilityForPagingOfNR;  /* OCTET_STRING */
static int hf_lix2_uERadioCapabilityForPagingOfEUTRA;  /* OCTET_STRING */
static int hf_lix2_uERadioCapabilityForPagingOfNBIoT;  /* OCTET_STRING */
static int hf_lix2_v2XVehicleUEAuthorizationIndicator;  /* V2XUEAuthorizationIndicator */
static int hf_lix2_v2XPedestrianUEAuthorizationIndicator;  /* V2XUEAuthorizationIndicator */
static int hf_lix2_targetSNSSAIList;              /* NSSAI */
static int hf_lix2_fiveGProSeDirectDiscovery;     /* FiveGProSeAuthorizationIndicator */
static int hf_lix2_fiveGProSeDirectCommunication;  /* FiveGProSeAuthorizationIndicator */
static int hf_lix2_fiveGProSeL2UEToNetworkRelay;  /* FiveGProSeAuthorizationIndicator */
static int hf_lix2_fiveGProSeL3UEToNetworkRelay;  /* FiveGProSeAuthorizationIndicator */
static int hf_lix2_fiveGProSeL2RemoteUE;          /* FiveGProSeAuthorizationIndicator */
static int hf_lix2_country;                       /* UTF8String_SIZE_2 */
static int hf_lix2_internationalAreaIndication;   /* BOOLEAN */
static int hf_lix2_sUPIUnauthenticated;           /* SUPIUnauthenticatedIndication */
static int hf_lix2_gTPTunnelID;                   /* FTEID */
static int hf_lix2_pDUSessionType;                /* PDUSessionType */
static int hf_lix2_uEEndpoint;                    /* SEQUENCE_OF_UEEndpointAddress */
static int hf_lix2_uEEndpoint_item;               /* UEEndpointAddress */
static int hf_lix2_aMFID;                         /* AMFID */
static int hf_lix2_hSMFURI;                       /* HSMFURI */
static int hf_lix2_requestType;                   /* FiveGSMRequestType */
static int hf_lix2_sMPDUDNRequest;                /* SMPDUDNRequest */
static int hf_lix2_uEEPSPDNConnection;            /* UEEPSPDNConnection */
static int hf_lix2_ePS5GSComboInfo;               /* EPS5GSComboInfo */
static int hf_lix2_selectedDNN;                   /* DNN */
static int hf_lix2_servingNetwork;                /* SMFServingNetwork */
static int hf_lix2_oldPDUSessionID;               /* PDUSessionID */
static int hf_lix2_handoverState;                 /* HandoverState */
static int hf_lix2_gTPTunnelInfo;                 /* GTPTunnelInfo */
static int hf_lix2_pCCRules;                      /* PCCRuleSet */
static int hf_lix2_ePSPDNConnectionEstablishment;  /* EPSPDNConnectionEstablishment */
static int hf_lix2_satelliteBackhaulCategory;     /* SBIType */
static int hf_lix2_gEOSatelliteID;                /* GEOSatelliteID */
static int hf_lix2_uEEndpoint_01;                 /* UEEndpointAddress */
static int hf_lix2_ePSPDNConnectionModification;  /* EPSPDNConnectionModification */
static int hf_lix2_uPPathChange;                  /* UPPathChange */
static int hf_lix2_pFDDataForApp;                 /* PFDDataForApp */
static int hf_lix2_cause_01;                      /* SMFErrorCodes */
static int hf_lix2_nGAPCause;                     /* NGAPCauseInt */
static int hf_lix2_pCCRuleIDs;                    /* PCCRuleIDSet */
static int hf_lix2_ePSPDNConnectionRelease;       /* EPSPDNConnectionRelease */
static int hf_lix2_timeOfSessionEstablishment;    /* Timestamp */
static int hf_lix2_ePSStartOfInterceptionWithEstablishedPDNConnection;  /* EPSStartOfInterceptionWithEstablishedPDNConnection */
static int hf_lix2_pFDDataForApps;                /* PFDDataForApps */
static int hf_lix2_failedProcedureType_01;        /* SMFFailedProcedureType */
static int hf_lix2_failureCause_03;               /* FiveGSMCause */
static int hf_lix2_requestIndication;             /* RequestIndication */
static int hf_lix2_aTSSSContainer;                /* ATSSSContainer */
static int hf_lix2_accessInfo;                    /* SEQUENCE_OF_AccessInfo */
static int hf_lix2_accessInfo_item;               /* AccessInfo */
static int hf_lix2_mAUpgradeIndication;           /* SMFMAUpgradeIndication */
static int hf_lix2_ePSPDNCnxInfo;                 /* SMFEPSPDNCnxInfo */
static int hf_lix2_mAAcceptedIndication;          /* SMFMAAcceptedIndication */
static int hf_lix2_pLMNID;                        /* PLMNID */
static int hf_lix2_nID;                           /* NID */
static int hf_lix2_establishmentStatus;           /* EstablishmentStatus */
static int hf_lix2_aNTypeToReactivate;            /* AccessType */
static int hf_lix2_dLQOSFlowTunnelInformation;    /* QOSFlowTunnelInformation */
static int hf_lix2_additionalDLQOSFlowTunnelInformation;  /* QOSFlowTunnelInformationList */
static int hf_lix2_redundantDLQOSFlowTunnelInformation;  /* QOSFlowTunnelInformationList */
static int hf_lix2_additionalredundantDLQOSFlowTunnelInformation;  /* QOSFlowTunnelInformationList */
static int hf_lix2_uLNGUUPTunnelInformation;      /* FTEID */
static int hf_lix2_additionalULNGUUPTunnelInformation;  /* FTEIDList */
static int hf_lix2_dLRANTunnelInformation;        /* DLRANTunnelInformation */
static int hf_lix2_group;                         /* NGAPCauseGroupInt */
static int hf_lix2_value;                         /* NGAPCauseValueInt */
static int hf_lix2_uPTunnelInformation;           /* FTEID */
static int hf_lix2_associatedQOSFlowList;         /* QOSFlowLists */
static int hf_lix2_QOSFlowTunnelInformationList_item;  /* QOSFlowTunnelInformation */
static int hf_lix2_QOSFlowLists_item;             /* QOSFlowList */
static int hf_lix2_qFI;                           /* QFI */
static int hf_lix2_qOSRules;                      /* QOSRules */
static int hf_lix2_eBI;                           /* EPSBearerID */
static int hf_lix2_qOSFlowDescription;            /* QOSFlowDescription */
static int hf_lix2_qOSFlowProfile;                /* QOSFlowProfile */
static int hf_lix2_associatedANType;              /* AccessType */
static int hf_lix2_defaultQOSRuleIndication;      /* BOOLEAN */
static int hf_lix2_fiveQI;                        /* FiveQI */
static int hf_lix2_pCCRuleID;                     /* PCCRuleID */
static int hf_lix2_appId;                         /* UTF8String */
static int hf_lix2_flowInfos;                     /* FlowInformationSet */
static int hf_lix2_appReloc;                      /* BOOLEAN */
static int hf_lix2_simConnInd;                    /* BOOLEAN */
static int hf_lix2_simConnTerm;                   /* INTEGER */
static int hf_lix2_maxAllowedUpLat;               /* INTEGER */
static int hf_lix2_trafficRoutes;                 /* RouteToLocationSet */
static int hf_lix2_trafficSteeringPolIdDl;        /* UTF8String */
static int hf_lix2_trafficSteeringPolIdUl;        /* UTF8String */
static int hf_lix2_deprecatedSourceDNAI;          /* DNAI */
static int hf_lix2_deprecatedTargetDNAI;          /* DNAI */
static int hf_lix2_deprecatedDNAIChangeType;      /* DNAIChangeType */
static int hf_lix2_deprecatedSourceUEIPAddr;      /* IPAddress */
static int hf_lix2_deprecatedTargetUEIPAddr;      /* IPAddress */
static int hf_lix2_sourceTrafficRouting;          /* RouteToLocation */
static int hf_lix2_targetTrafficRouting;          /* RouteToLocation */
static int hf_lix2_eASIPReplaceInfos;             /* EASIPReplaceInfos */
static int hf_lix2_sourceDNAI;                    /* DNAI */
static int hf_lix2_targetDNAI;                    /* DNAI */
static int hf_lix2_dNAIChangeType;                /* DNAIChangeType */
static int hf_lix2_sourceUEIPAddr;                /* IPAddress */
static int hf_lix2_targetUEIPAddr;                /* IPAddress */
static int hf_lix2_mACAddress;                    /* MACAddress */
static int hf_lix2_PCCRuleSet_item;               /* PCCRule */
static int hf_lix2_PCCRuleIDSet_item;             /* PCCRuleID */
static int hf_lix2_FlowInformationSet_item;       /* FlowInformation */
static int hf_lix2_RouteToLocationSet_item;       /* RouteToLocation */
static int hf_lix2_flowDescription;               /* FlowDescription */
static int hf_lix2_ethFlowDescription;            /* EthFlowDescription */
static int hf_lix2_tosTrafficClass;               /* OCTET_STRING_SIZE_2 */
static int hf_lix2_spi;                           /* OCTET_STRING_SIZE_4 */
static int hf_lix2_flowLabel;                     /* OCTET_STRING_SIZE_3 */
static int hf_lix2_flowDirection;                 /* FlowDirection */
static int hf_lix2_sourceIPAddress;               /* IPAddressOrRangeOrAny */
static int hf_lix2_destinationIPAddress;          /* IPAddressOrRangeOrAny */
static int hf_lix2_sourcePortNumber;              /* PortNumber */
static int hf_lix2_destinationPortNumber;         /* PortNumber */
static int hf_lix2_protocol;                      /* NextLayerProtocolOrAny */
static int hf_lix2_iPAddress;                     /* IPAddress */
static int hf_lix2_ipAddressRange;                /* IPMask */
static int hf_lix2_anyIPAddress;                  /* AnyIPAddress */
static int hf_lix2_fromIPAddress;                 /* IPAddress */
static int hf_lix2_toIPAddress;                   /* IPAddress */
static int hf_lix2_nextLayerProtocol;             /* NextLayerProtocol */
static int hf_lix2_anyNextLayerProtocol;          /* AnyNextLayerProtocol */
static int hf_lix2_destMacAddress;                /* MACAddress */
static int hf_lix2_ethType;                       /* OCTET_STRING_SIZE_2 */
static int hf_lix2_fDesc;                         /* FlowDescription */
static int hf_lix2_fDir;                          /* FDir */
static int hf_lix2_sourceMacAddress;              /* MACAddress */
static int hf_lix2_vlanTags;                      /* SET_OF_VLANTag */
static int hf_lix2_vlanTags_item;                 /* VLANTag */
static int hf_lix2_srcMacAddrEnd;                 /* MACAddress */
static int hf_lix2_destMacAddrEnd;                /* MACAddress */
static int hf_lix2_priority;                      /* BIT_STRING_SIZE_3 */
static int hf_lix2_cFI;                           /* BIT_STRING_SIZE_1 */
static int hf_lix2_vLANID;                        /* BIT_STRING_SIZE_12 */
static int hf_lix2_dNAI;                          /* DNAI */
static int hf_lix2_routeInfo;                     /* RouteInfo */
static int hf_lix2_iPAddressTunnelEndpoint;       /* IPAddress */
static int hf_lix2_uDPPortNumberTunnelEndpoint;   /* PortNumber */
static int hf_lix2_sourceEASAddress;              /* EASServerAddress */
static int hf_lix2_targetEASAddress;              /* EASServerAddress */
static int hf_lix2_port;                          /* PortNumber */
static int hf_lix2_ePSSubscriberIDs;              /* EPSSubscriberIDs */
static int hf_lix2_iMSIUnauthenticated;           /* IMSIUnauthenticatedIndication */
static int hf_lix2_defaultBearerID;               /* EPSBearerID */
static int hf_lix2_pDNConnectionType;             /* PDNConnectionType */
static int hf_lix2_uEEndpoints;                   /* SEQUENCE_OF_UEEndpointAddress */
static int hf_lix2_uEEndpoints_item;              /* UEEndpointAddress */
static int hf_lix2_additionalLocation;            /* Location */
static int hf_lix2_requestType_01;                /* EPSPDNConnectionRequestType */
static int hf_lix2_protocolConfigurationOptions;  /* PDNProtocolConfigurationOptions */
static int hf_lix2_bearerContextsCreated;         /* SEQUENCE_OF_EPSBearerContextCreated */
static int hf_lix2_bearerContextsCreated_item;    /* EPSBearerContextCreated */
static int hf_lix2_bearerContextsMarkedForRemoval;  /* SEQUENCE_OF_EPSBearerContextForRemoval */
static int hf_lix2_bearerContextsMarkedForRemoval_item;  /* EPSBearerContextForRemoval */
static int hf_lix2_indicationFlags;               /* PDNConnectionIndicationFlags */
static int hf_lix2_handoverIndication;            /* PDNHandoverIndication */
static int hf_lix2_nBIFOMSupport;                 /* PDNNBIFOMSupport */
static int hf_lix2_fiveGSInterworkingInfo;        /* FiveGSInterworkingInfo */
static int hf_lix2_cSRMFI;                        /* CSRMFI */
static int hf_lix2_restorationOfPDNConnectionsSupport;  /* RestorationOfPDNConnectionsSupport */
static int hf_lix2_pGWChangeIndication;           /* PGWChangeIndication */
static int hf_lix2_pGWRNSI;                       /* PGWRNSI */
static int hf_lix2_bearerContextsModified;        /* SEQUENCE_OF_EPSBearerContextModified */
static int hf_lix2_bearerContextsModified_item;   /* EPSBearerContextModified */
static int hf_lix2_bearersDeleted;                /* SEQUENCE_OF_EPSBearersDeleted */
static int hf_lix2_bearersDeleted_item;           /* EPSBearersDeleted */
static int hf_lix2_rANNASCause;                   /* EPSRANNASCause */
static int hf_lix2_scopeIndication;               /* EPSPDNConnectionReleaseScopeIndication */
static int hf_lix2_bearerContexts;                /* SEQUENCE_OF_EPSBearerContext */
static int hf_lix2_bearerContexts_item;           /* EPSBearerContext */
static int hf_lix2_PFDDataForApps_item;           /* PFDDataForApp */
static int hf_lix2_aPPId;                         /* UTF8String */
static int hf_lix2_pFDs;                          /* PFDs */
static int hf_lix2_PFDs_item;                     /* PFD */
static int hf_lix2_pFDId;                         /* UTF8String */
static int hf_lix2_pFDFlowDescriptions;           /* PFDFlowDescriptions */
static int hf_lix2_urls;                          /* PFDURLs */
static int hf_lix2_domainNames;                   /* DomainNames */
static int hf_lix2_dnProtocol;                    /* DnProtocol */
static int hf_lix2_PFDURLs_item;                  /* UTF8String */
static int hf_lix2_PFDFlowDescriptions_item;      /* PFDFlowDescription */
static int hf_lix2_DomainNames_item;              /* UTF8String */
static int hf_lix2_serverIPAddress;               /* IPAddress */
static int hf_lix2_serverPortNumber;              /* PortNumber */
static int hf_lix2_ePSInterworkingIndication;     /* EPSInterworkingIndication */
static int hf_lix2_ePSPDNCnxInfo_01;              /* EPSPDNCnxInfo */
static int hf_lix2_ePSBearerInfo;                 /* EPSBearerInfo */
static int hf_lix2_pGWS8ControlPlaneFTEID;        /* FTEID */
static int hf_lix2_EPSBearerInfo_item;            /* EPSBearers */
static int hf_lix2_pGWS8UserPlaneFTEID;           /* FTEID */
static int hf_lix2_qCI;                           /* QCI */
static int hf_lix2_uPGTPTunnelInfo;               /* GTPTunnelInfo */
static int hf_lix2_bearerQOS;                     /* EPSBearerQOS */
static int hf_lix2_cause_02;                      /* EPSBearerCreationCauseValue */
static int hf_lix2_cause_03;                      /* EPSBearerModificationCauseValue */
static int hf_lix2_linkedBearerIDs;               /* SEQUENCE_OF_EPSBearerID */
static int hf_lix2_linkedBearerIDs_item;          /* EPSBearerID */
static int hf_lix2_linkedEPSBearerID;             /* EPSBearerID */
static int hf_lix2_ePSBearerIDs;                  /* SEQUENCE_OF_EPSBearerID */
static int hf_lix2_ePSBearerIDs_item;             /* EPSBearerID */
static int hf_lix2_cause_04;                      /* EPSBearerDeletionCauseValue */
static int hf_lix2_deleteBearerResponse;          /* EPSDeleteBearerResponse */
static int hf_lix2_bearerContexts_01;             /* SEQUENCE_OF_EPSDeleteBearerContext */
static int hf_lix2_bearerContexts_item_01;        /* EPSDeleteBearerContext */
static int hf_lix2_cause_05;                      /* EPSBearerRemovalCauseValue */
static int hf_lix2_maximumUplinkBitRate;          /* BitrateBinKBPS */
static int hf_lix2_maximumDownlinkBitRate;        /* BitrateBinKBPS */
static int hf_lix2_guaranteedUplinkBitRate;       /* BitrateBinKBPS */
static int hf_lix2_guaranteedDownlinkBitRate;     /* BitrateBinKBPS */
static int hf_lix2_priorityLevel;                 /* EPSQOSPriority */
static int hf_lix2_controlPlaneSenderFTEID;       /* FTEID */
static int hf_lix2_controlPlanePGWS5S8FTEID;      /* FTEID */
static int hf_lix2_s1UeNodeBFTEID;                /* FTEID */
static int hf_lix2_s5S8SGWFTEID;                  /* FTEID */
static int hf_lix2_s5S8PGWFTEID;                  /* FTEID */
static int hf_lix2_s2bUePDGFTEID;                 /* FTEID */
static int hf_lix2_s2aUePDGFTEID;                 /* FTEID */
static int hf_lix2_fiveGSInterworkingIndicator;   /* FiveGSInterworkingIndicator */
static int hf_lix2_fiveGSInterworkingWithoutN26;  /* FiveGSInterworkingWithoutN26 */
static int hf_lix2_fiveGCNotRestrictedSupport;    /* FiveGCNotRestrictedSupport */
static int hf_lix2_requestPCO;                    /* T_requestPCO */
static int hf_lix2_requestAPCO;                   /* T_requestAPCO */
static int hf_lix2_requestEPCO;                   /* T_requestEPCO */
static int hf_lix2_responsePCO;                   /* T_responsePCO */
static int hf_lix2_responseAPCO;                  /* T_responseAPCO */
static int hf_lix2_responseEPCO;                  /* T_responseEPCO */
static int hf_lix2_fiveGSGTPTunnels;              /* FiveGSGTPTunnels */
static int hf_lix2_ePSGTPTunnels;                 /* EPSGTPTunnels */
static int hf_lix2_payload;                       /* UPFCCPDUPayload */
static int hf_lix2_uPFIPCC;                       /* OCTET_STRING */
static int hf_lix2_uPFEthernetCC;                 /* OCTET_STRING */
static int hf_lix2_uPFUnstructuredCC;             /* OCTET_STRING */
static int hf_lix2_gUAMI;                         /* GUAMI */
static int hf_lix2_gUMMEI;                        /* GUMMEI */
static int hf_lix2_servingSystemMethod;           /* UDMServingSystemMethod */
static int hf_lix2_serviceID;                     /* ServiceID */
static int hf_lix2_roamingIndicator;              /* RoamingIndicator */
static int hf_lix2_oldPEI;                        /* PEI */
static int hf_lix2_oldSUPI;                       /* SUPI */
static int hf_lix2_oldGPSI;                       /* GPSI */
static int hf_lix2_oldserviceID;                  /* ServiceID */
static int hf_lix2_subscriberRecordChangeMethod;  /* UDMSubscriberRecordChangeMethod */
static int hf_lix2_cancelLocationMethod;          /* UDMCancelLocationMethod */
static int hf_lix2_aMFDeregistrationInfo;         /* UDMAMFDeregistrationInfo */
static int hf_lix2_deregistrationData;            /* UDMDeregistrationData */
static int hf_lix2_locationInfoRequest;           /* UDMLocationInfoRequest */
static int hf_lix2_vPLMNID;                       /* PLMNID */
static int hf_lix2_currentLocationIndicator;      /* BOOLEAN */
static int hf_lix2_aMFInstanceID;                 /* NFID */
static int hf_lix2_sMSFInstanceID;                /* NFID */
static int hf_lix2_problemDetails;                /* UDMProblemDetails */
static int hf_lix2_tADSInfo;                      /* UEContextInfo */
static int hf_lix2_fiveGSUserStateInfo;           /* FiveGSUserStateInfo */
static int hf_lix2_fiveGSRVCCInfo;                /* FiveGSRVCCInfo */
static int hf_lix2_authenticationInfoRequest;     /* UDMAuthenticationInfoRequest */
static int hf_lix2_aKMAIndicator;                 /* BOOLEAN */
static int hf_lix2_authAAA;                       /* BOOLEAN */
static int hf_lix2_pvsInfo;                       /* ServerAddressingInfoList */
static int hf_lix2_uDMSubscriptionDataSets;       /* SBIType */
static int hf_lix2_servingNetworkName;            /* UTF8String */
static int hf_lix2_relayServiceCode;              /* INTEGER */
static int hf_lix2_authenticationType;            /* PrimaryAuthenticationType */
static int hf_lix2_ServerAddressingInfoList_item;  /* ServerAddressingInfo */
static int hf_lix2_iPv4Address;                   /* IPv4Address */
static int hf_lix2_iPv6Address;                   /* IPv6Address */
static int hf_lix2_fQDNList;                      /* FQDNList */
static int hf_lix2_FQDNList_item;                 /* FQDN */
static int hf_lix2_nSSAI;                         /* NSSAI */
static int hf_lix2_cAGID;                         /* SEQUENCE_OF_CAGID */
static int hf_lix2_cAGID_item;                    /* CAGID */
static int hf_lix2_infoRequestType;               /* UDMInfoRequestType */
static int hf_lix2_rGAuthCtx;                     /* SEQUENCE_SIZE_1_MAX_OF_SubscriberIdentifier */
static int hf_lix2_rGAuthCtx_item;                /* SubscriberIdentifier */
static int hf_lix2_authType;                      /* PrimaryAuthenticationType */
static int hf_lix2_servingNetworkName_01;         /* PLMNID */
static int hf_lix2_aUSFInstanceID;                /* NFID */
static int hf_lix2_cellCAGInfo;                   /* CAGID */
static int hf_lix2_n5GCIndicator;                 /* BOOLEAN */
static int hf_lix2_requested5GSLocation;          /* BOOLEAN */
static int hf_lix2_requestedCurrentLocation;      /* BOOLEAN */
static int hf_lix2_requestedRATType;              /* BOOLEAN */
static int hf_lix2_requestedTimeZone;             /* BOOLEAN */
static int hf_lix2_requestedServingNode;          /* BOOLEAN */
static int hf_lix2_cause_06;                      /* UDMProblemDetailsCause */
static int hf_lix2_uDMDefinedCause;               /* UDMDefinedCause */
static int hf_lix2_otherCause;                    /* UDMProblemDetailsOtherCause */
static int hf_lix2_problemDetailsType;            /* UTF8String */
static int hf_lix2_title;                         /* UTF8String */
static int hf_lix2_status;                        /* INTEGER */
static int hf_lix2_detail;                        /* UTF8String */
static int hf_lix2_instance;                      /* UTF8String */
static int hf_lix2_cause_07;                      /* UTF8String */
static int hf_lix2_uDMInvalidParameters;          /* UDMInvalidParameters */
static int hf_lix2_uDMSupportedFeatures;          /* UTF8String */
static int hf_lix2_parameter;                     /* UTF8String */
static int hf_lix2_reason;                        /* UTF8String */
static int hf_lix2_purgeFlag;                     /* BOOLEAN */
static int hf_lix2_deregReason;                   /* UDMDeregReason */
static int hf_lix2_originatingSMSParty;           /* SMSParty */
static int hf_lix2_terminatingSMSParty_02;        /* SMSParty */
static int hf_lix2_direction;                     /* Direction */
static int hf_lix2_linkTransferStatus;            /* SMSTransferStatus */
static int hf_lix2_otherMessage;                  /* SMSOtherMessageIndication */
static int hf_lix2_peerNFAddress;                 /* SMSNFAddress */
static int hf_lix2_peerNFType;                    /* SMSNFType */
static int hf_lix2_sMSTPDUData;                   /* SMSTPDUData */
static int hf_lix2_messageType;                   /* SMSMessageType */
static int hf_lix2_rPMessageReference;            /* SMSRPMessageReference */
static int hf_lix2_sMSAddress;                    /* SMSAddress */
static int hf_lix2_e164Number;                    /* E164Number */
static int hf_lix2_sMSTPDU;                       /* SMSTPDU */
static int hf_lix2_truncatedSMSTPDU;              /* TruncatedSMSTPDU */
static int hf_lix2_redactedSMSTPDU;               /* SMSTPDU */
static int hf_lix2_threeGPP2SMSTPDU;              /* ThreeGPP2SMSTPDU */
static int hf_lix2_redacted3GPP2SMSTPDU;          /* ThreeGPP2SMSTPDU */
static int hf_lix2_transactionID;                 /* UTF8String */
static int hf_lix2_version;                       /* MMSVersion */
static int hf_lix2_dateTime;                      /* Timestamp */
static int hf_lix2_originatingMMSParty;           /* MMSParty */
static int hf_lix2_terminatingMMSParty;           /* SEQUENCE_OF_MMSParty */
static int hf_lix2_terminatingMMSParty_item;      /* MMSParty */
static int hf_lix2_cCRecipients;                  /* SEQUENCE_OF_MMSParty */
static int hf_lix2_cCRecipients_item;             /* MMSParty */
static int hf_lix2_bCCRecipients;                 /* SEQUENCE_OF_MMSParty */
static int hf_lix2_bCCRecipients_item;            /* MMSParty */
static int hf_lix2_direction_01;                  /* MMSDirection */
static int hf_lix2_subject;                       /* MMSSubject */
static int hf_lix2_messageClass;                  /* MMSMessageClass */
static int hf_lix2_expiry;                        /* MMSExpiry */
static int hf_lix2_desiredDeliveryTime;           /* Timestamp */
static int hf_lix2_priority_01;                   /* MMSPriority */
static int hf_lix2_senderVisibility;              /* BOOLEAN */
static int hf_lix2_deliveryReport;                /* BOOLEAN */
static int hf_lix2_readReport;                    /* BOOLEAN */
static int hf_lix2_store;                         /* BOOLEAN */
static int hf_lix2_state;                         /* MMState */
static int hf_lix2_flags;                         /* MMFlags */
static int hf_lix2_replyCharging;                 /* MMSReplyCharging */
static int hf_lix2_applicID;                      /* UTF8String */
static int hf_lix2_replyApplicID;                 /* UTF8String */
static int hf_lix2_auxApplicInfo;                 /* UTF8String */
static int hf_lix2_contentClass;                  /* MMSContentClass */
static int hf_lix2_dRMContent;                    /* BOOLEAN */
static int hf_lix2_adaptationAllowed;             /* MMSAdaptation */
static int hf_lix2_contentType;                   /* MMSContentType */
static int hf_lix2_responseStatus;                /* MMSResponseStatus */
static int hf_lix2_responseStatusText;            /* UTF8String */
static int hf_lix2_messageID;                     /* UTF8String */
static int hf_lix2_forwardCount;                  /* INTEGER */
static int hf_lix2_previouslySentBy;              /* MMSPreviouslySentBy */
static int hf_lix2_prevSentByDateTime;            /* Timestamp */
static int hf_lix2_deliveryReportRequested;       /* BOOLEAN */
static int hf_lix2_stored;                        /* BOOLEAN */
static int hf_lix2_messageSize;                   /* INTEGER */
static int hf_lix2_status_01;                     /* MMStatus */
static int hf_lix2_reportAllowed;                 /* BOOLEAN */
static int hf_lix2_retrieveStatus;                /* MMSRetrieveStatus */
static int hf_lix2_retrieveStatusText;            /* UTF8String */
static int hf_lix2_replaceID;                     /* UTF8String */
static int hf_lix2_contentType_01;                /* UTF8String */
static int hf_lix2_deliveryReportAllowed;         /* BOOLEAN */
static int hf_lix2_contentLocationReq;            /* UTF8String */
static int hf_lix2_contentLocationConf;           /* UTF8String */
static int hf_lix2_storeStatus;                   /* MMSStoreStatus */
static int hf_lix2_storeStatusText;               /* UTF8String */
static int hf_lix2_contentLocationReq_01;         /* T_contentLocationReq */
static int hf_lix2_contentLocationReq_item;       /* UTF8String */
static int hf_lix2_contentLocationConf_01;        /* T_contentLocationConf */
static int hf_lix2_contentLocationConf_item;      /* UTF8String */
static int hf_lix2_deleteResponseStatus;          /* MMSDeleteResponseStatus */
static int hf_lix2_deleteResponseText;            /* T_deleteResponseText */
static int hf_lix2_deleteResponseText_item;       /* UTF8String */
static int hf_lix2_contentLocation;               /* UTF8String */
static int hf_lix2_mMessages;                     /* SEQUENCE_OF_MMBoxDescription */
static int hf_lix2_mMessages_item;                /* MMBoxDescription */
static int hf_lix2_contentLocationReq_02;         /* T_contentLocationReq_01 */
static int hf_lix2_contentLocationConf_02;        /* T_contentLocationConf_01 */
static int hf_lix2_responseStatus_01;             /* MMSDeleteResponseStatus */
static int hf_lix2_mMSDateTime;                   /* Timestamp */
static int hf_lix2_forwardToOriginator;           /* BOOLEAN */
static int hf_lix2_statusExtension;               /* MMStatusExtension */
static int hf_lix2_statusText;                    /* MMStatusText */
static int hf_lix2_originatingMMSParty_01;        /* SEQUENCE_OF_MMSParty */
static int hf_lix2_originatingMMSParty_item;      /* MMSParty */
static int hf_lix2_readStatus;                    /* MMSReadStatus */
static int hf_lix2_readStatusText;                /* MMSReadStatusText */
static int hf_lix2_cancelID;                      /* UTF8String */
static int hf_lix2_state_01;                      /* SEQUENCE_OF_MMState */
static int hf_lix2_state_item;                    /* MMState */
static int hf_lix2_flags_01;                      /* SEQUENCE_OF_MMFlags */
static int hf_lix2_flags_item;                    /* MMFlags */
static int hf_lix2_start;                         /* INTEGER */
static int hf_lix2_limit;                         /* INTEGER */
static int hf_lix2_attributes;                    /* T_attributes */
static int hf_lix2_attributes_item;               /* UTF8String */
static int hf_lix2_totals;                        /* INTEGER */
static int hf_lix2_quotas;                        /* MMSQuota */
static int hf_lix2_attributes_01;                 /* T_attributes_01 */
static int hf_lix2_mMSTotals;                     /* BOOLEAN */
static int hf_lix2_mMSQuotas;                     /* BOOLEAN */
static int hf_lix2_deliveryTime;                  /* Timestamp */
static int hf_lix2_previouslySentByDateTime;      /* Timestamp */
static int hf_lix2_mMSContent;                    /* OCTET_STRING */
static int hf_lix2_allowed;                       /* BOOLEAN */
static int hf_lix2_overriden;                     /* BOOLEAN */
static int hf_lix2_reference;                     /* UTF8String */
static int hf_lix2_value_01;                      /* UTF8String */
static int hf_lix2_expiryPeriod;                  /* INTEGER */
static int hf_lix2_periodFormat;                  /* MMSPeriodFormat */
static int hf_lix2_length;                        /* INTEGER */
static int hf_lix2_flag;                          /* MMStateFlag */
static int hf_lix2_flagString;                    /* UTF8String */
static int hf_lix2_mMSPartyIDs;                   /* SEQUENCE_OF_MMSPartyID */
static int hf_lix2_mMSPartyIDs_item;              /* MMSPartyID */
static int hf_lix2_nonLocalID;                    /* NonLocalID */
static int hf_lix2_emailAddress;                  /* EmailAddress */
static int hf_lix2_iMPU;                          /* IMPU */
static int hf_lix2_iMPI;                          /* IMPI */
static int hf_lix2_previouslySentByParty;         /* MMSParty */
static int hf_lix2_sequenceNumber;                /* INTEGER */
static int hf_lix2_previousSendDateTime;          /* Timestamp */
static int hf_lix2_MMSPreviouslySentBy_item;      /* MMSPreviouslySent */
static int hf_lix2_quota;                         /* INTEGER */
static int hf_lix2_quotaUnit;                     /* MMSQuotaUnit */
static int hf_lix2_majorVersion;                  /* INTEGER */
static int hf_lix2_minorVersion;                  /* INTEGER */
static int hf_lix2_pTCTargetInformation;          /* PTCTargetInformation */
static int hf_lix2_pTCServerURI;                  /* UTF8String */
static int hf_lix2_pTCRegistrationRequest;        /* PTCRegistrationRequest */
static int hf_lix2_pTCRegistrationOutcome;        /* PTCRegistrationOutcome */
static int hf_lix2_pTCDirection;                  /* Direction */
static int hf_lix2_pTCSessionInfo;                /* PTCSessionInfo */
static int hf_lix2_pTCOriginatingID;              /* PTCTargetInformation */
static int hf_lix2_pTCParticipants;               /* SEQUENCE_OF_PTCTargetInformation */
static int hf_lix2_pTCParticipants_item;          /* PTCTargetInformation */
static int hf_lix2_pTCParticipantPresenceStatus;  /* MultipleParticipantPresenceStatus */
static int hf_lix2_pTCBearerCapability;           /* UTF8String */
static int hf_lix2_pTCHost;                       /* PTCTargetInformation */
static int hf_lix2_pTCAbandonCause;               /* INTEGER */
static int hf_lix2_pTCSessionEndCause;            /* PTCSessionEndCause */
static int hf_lix2_preEstSessionID;               /* PTCSessionInfo */
static int hf_lix2_pTCMediaStreamAvail;           /* BOOLEAN */
static int hf_lix2_rTPSetting;                    /* RTPSetting */
static int hf_lix2_pTCMediaCapability;            /* UTF8String */
static int hf_lix2_pTCPreEstSessionID;            /* PTCSessionInfo */
static int hf_lix2_pTCPreEstStatus;               /* PTCPreEstStatus */
static int hf_lix2_pTCFailureCode;                /* PTCFailureCode */
static int hf_lix2_pTCIPAPartyID;                 /* PTCTargetInformation */
static int hf_lix2_pTCIPADirection;               /* Direction */
static int hf_lix2_pTCPartyDrop_01;               /* PTCTargetInformation */
static int hf_lix2_pTCParticipantPresenceStatus_01;  /* PTCParticipantPresenceStatus */
static int hf_lix2_pTCHoldID;                     /* SEQUENCE_OF_PTCTargetInformation */
static int hf_lix2_pTCHoldID_item;                /* PTCTargetInformation */
static int hf_lix2_pTCHoldRetrieveInd;            /* BOOLEAN */
static int hf_lix2_pTCIDList;                     /* SEQUENCE_OF_PTCTargetInformation */
static int hf_lix2_pTCIDList_item;                /* PTCTargetInformation */
static int hf_lix2_pTCGroupAuthRule;              /* PTCGroupAuthRule */
static int hf_lix2_pTCGroupAdSender;              /* PTCTargetInformation */
static int hf_lix2_pTCGroupNickname;              /* UTF8String */
static int hf_lix2_pTCSessioninfo;                /* PTCSessionInfo */
static int hf_lix2_pTCFloorActivity;              /* SEQUENCE_OF_PTCFloorActivity */
static int hf_lix2_pTCFloorActivity_item;         /* PTCFloorActivity */
static int hf_lix2_pTCFloorSpeakerID;             /* PTCTargetInformation */
static int hf_lix2_pTCMaxTBTime;                  /* INTEGER */
static int hf_lix2_pTCQueuedFloorControl;         /* BOOLEAN */
static int hf_lix2_pTCQueuedPosition;             /* INTEGER */
static int hf_lix2_pTCTalkBurstPriority;          /* PTCTBPriorityLevel */
static int hf_lix2_pTCTalkBurstReason;            /* PTCTBReasonCode */
static int hf_lix2_pTCTargetPresenceStatus;       /* PTCParticipantPresenceStatus */
static int hf_lix2_pTCListManagementType;         /* PTCListManagementType */
static int hf_lix2_pTCListManagementAction;       /* PTCListManagementAction */
static int hf_lix2_pTCListManagementFailure;      /* PTCListManagementFailure */
static int hf_lix2_pTCContactID;                  /* PTCTargetInformation */
static int hf_lix2_pTCIDList_01;                  /* SEQUENCE_OF_PTCIDList */
static int hf_lix2_pTCIDList_item_01;             /* PTCIDList */
static int hf_lix2_pTCAccessPolicyType;           /* PTCAccessPolicyType */
static int hf_lix2_pTCUserAccessPolicy;           /* PTCUserAccessPolicy */
static int hf_lix2_pTCAccessPolicyFailure;        /* PTCAccessPolicyFailure */
static int hf_lix2_identifiers;                   /* SEQUENCE_SIZE_1_MAX_OF_PTCIdentifiers */
static int hf_lix2_identifiers_item;              /* PTCIdentifiers */
static int hf_lix2_mCPTTID;                       /* UTF8String */
static int hf_lix2_instanceIdentifierURN;         /* UTF8String */
static int hf_lix2_pTCChatGroupID;                /* PTCChatGroupID */
static int hf_lix2_pTCSessionURI;                 /* UTF8String */
static int hf_lix2_pTCSessionType;                /* PTCSessionType */
static int hf_lix2_MultipleParticipantPresenceStatus_item;  /* PTCParticipantPresenceStatus */
static int hf_lix2_presenceID;                    /* PTCTargetInformation */
static int hf_lix2_presenceType;                  /* PTCPresenceType */
static int hf_lix2_presenceStatus;                /* BOOLEAN */
static int hf_lix2_portNumber;                    /* PortNumber */
static int hf_lix2_pTCPartyID;                    /* PTCTargetInformation */
static int hf_lix2_groupIdentity;                 /* UTF8String */
static int hf_lix2_payload_01;                    /* IMSPayload */
static int hf_lix2_sessionDirection;              /* SessionDirection */
static int hf_lix2_voIPRoamingIndication;         /* VoIPRoamingIndication */
static int hf_lix2_accessNetworkInformation;      /* SEQUENCE_OF_SIPAccessNetworkInformation */
static int hf_lix2_accessNetworkInformation_item;  /* SIPAccessNetworkInformation */
static int hf_lix2_cellularNetworkInformation;    /* SEQUENCE_OF_SIPCellularNetworkInformation */
static int hf_lix2_cellularNetworkInformation_item;  /* SIPCellularNetworkInformation */
static int hf_lix2_originatingId;                 /* SEQUENCE_OF_IMPU */
static int hf_lix2_originatingId_item;            /* IMPU */
static int hf_lix2_terminatingId;                 /* IMPU */
static int hf_lix2_sDPState;                      /* T_sDPState */
static int hf_lix2_sDPState_item;                 /* OCTET_STRING */
static int hf_lix2_diversionIdentity;             /* IMPU */
static int hf_lix2_cCUnavailableReason;           /* UTF8String */
static int hf_lix2_sDPState_01;                   /* OCTET_STRING */
static int hf_lix2_payload_02;                    /* IMSCCPDUPayload */
static int hf_lix2_sDPInfo;                       /* OCTET_STRING */
static int hf_lix2_encapsulatedSIPMessage;        /* SIPMessage */
static int hf_lix2_modifiedSIPMessage;            /* ModifiedSIPMessage */
static int hf_lix2_modifiedSIPContent;            /* SIPMessage */
static int hf_lix2_modifications;                 /* PayloadModifications */
static int hf_lix2_iPSourceAddress;               /* IPAddress */
static int hf_lix2_iPDestinationAddress;          /* IPAddress */
static int hf_lix2_sIPContent;                    /* OCTET_STRING */
static int hf_lix2_pASSporTs;                     /* SEQUENCE_OF_PASSporT */
static int hf_lix2_pASSporTs_item;                /* PASSporT */
static int hf_lix2_rCDTerminalDisplayInfo;        /* RCDDisplayInfo */
static int hf_lix2_eCNAMTerminalDisplayInfo;      /* ECNAMDisplayInfo */
static int hf_lix2_sHAKENValidationResult;        /* SHAKENValidationResult */
static int hf_lix2_sHAKENFailureStatusCode;       /* SHAKENFailureStatusCode */
static int hf_lix2_pASSporTHeader;                /* PASSporTHeader */
static int hf_lix2_pASSporTPayload;               /* PASSporTPayload */
static int hf_lix2_pASSporTSignature;             /* OCTET_STRING */
static int hf_lix2_type_01;                       /* JWSTokenType */
static int hf_lix2_algorithm;                     /* UTF8String */
static int hf_lix2_ppt;                           /* UTF8String */
static int hf_lix2_x5u;                           /* UTF8String */
static int hf_lix2_issuedAtTime;                  /* GeneralizedTime */
static int hf_lix2_originator;                    /* STIRSHAKENOriginator */
static int hf_lix2_destination;                   /* STIRSHAKENDestinations */
static int hf_lix2_attestation;                   /* Attestation */
static int hf_lix2_origId;                        /* UTF8String */
static int hf_lix2_diversion;                     /* STIRSHAKENDestination */
static int hf_lix2_telephoneNumber;               /* STIRSHAKENTN */
static int hf_lix2_sTIRSHAKENURI;                 /* UTF8String */
static int hf_lix2_STIRSHAKENDestinations_item;   /* STIRSHAKENDestination */
static int hf_lix2_name;                          /* UTF8String */
static int hf_lix2_additionalInfo;                /* OCTET_STRING */
static int hf_lix2_jcd;                           /* OCTET_STRING */
static int hf_lix2_jcl;                           /* OCTET_STRING */
static int hf_lix2_rCSTargetIdentities;           /* SEQUENCE_SIZE_1_MAX_OF_RCSIdentity */
static int hf_lix2_rCSTargetIdentities_item;      /* RCSIdentity */
static int hf_lix2_rCSRegistrationType;           /* RCSRegistrationType */
static int hf_lix2_rCSRegistrationUpdateRequest;  /* IMSPayload */
static int hf_lix2_rCSRegistrationUpdateResponse;  /* IMSPayload */
static int hf_lix2_groupChatSessionID;            /* RCSGroupChatSessionID */
static int hf_lix2_originatingIdentity;           /* SEQUENCE_SIZE_1_MAX_OF_RCSIdentity */
static int hf_lix2_originatingIdentity_item;      /* RCSIdentity */
static int hf_lix2_destinationIdentities;         /* RCSDestinations */
static int hf_lix2_messageType_01;                /* RCSMessageType */
static int hf_lix2_conversationID;                /* RCSConversationID */
static int hf_lix2_contributionID;                /* RCSContributionID */
static int hf_lix2_inReplyToContributionID;       /* RCSContributionID */
static int hf_lix2_messageID_01;                  /* IMDNMessageID */
static int hf_lix2_messagePayload;                /* RCSPayload */
static int hf_lix2_sessionReplaces;               /* RCSContributionID */
static int hf_lix2_rCSSessionType;                /* RCSSessionType */
static int hf_lix2_sessionDirection_01;           /* Direction */
static int hf_lix2_rCSSessionMessage;             /* RCSSIPSessionMessage */
static int hf_lix2_sessionEndpoints;              /* RCSSessionEndpoints */
static int hf_lix2_rCSSIPSessionMessage;          /* RCSSIPSessionMessage */
static int hf_lix2_rCSTargetContactIdentities;    /* SEQUENCE_SIZE_1_MAX_OF_RCSIdentity */
static int hf_lix2_rCSTargetContactIdentities_item;  /* RCSIdentity */
static int hf_lix2_sIPMessage;                    /* IMSPayload */
static int hf_lix2_rCSRegistrationInformation;    /* SEQUENCE_SIZE_1_MAX_OF_RCSRegistrationInformation */
static int hf_lix2_rCSRegistrationInformation_item;  /* RCSRegistrationInformation */
static int hf_lix2_userOnline;                    /* BOOLEAN */
static int hf_lix2_additionalInstanceLocation;    /* SEQUENCE_SIZE_1_MAX_OF_AdditionalInstanceLocation */
static int hf_lix2_additionalInstanceLocation_item;  /* AdditionalInstanceLocation */
static int hf_lix2_participants;                  /* SEQUENCE_SIZE_1_MAX_OF_RCSDestinations */
static int hf_lix2_participants_item;             /* RCSDestinations */
static int hf_lix2_rCSSessionEndpoints;           /* RCSSessionEndpoints */
static int hf_lix2_rCSSessionLegs;                /* SEQUENCE_SIZE_1_MAX_OF_RCSSIPSessionExchange */
static int hf_lix2_rCSSessionLegs_item;           /* RCSSIPSessionExchange */
static int hf_lix2_rCSSessionInformation;         /* SEQUENCE_SIZE_1_MAX_OF_RCSSessionContext */
static int hf_lix2_rCSSessionInformation_item;    /* RCSSessionContext */
static int hf_lix2_encapsulatedRCSPayload;        /* EncapsulatedRCSPayload */
static int hf_lix2_instance_01;                   /* SIPEndpoint */
static int hf_lix2_path;                          /* UTF8String */
static int hf_lix2_RCSDestinations_item;          /* RCSDestination */
static int hf_lix2_RCSDestination_item;           /* RCSIdentity */
static int hf_lix2_fiveGSIdentities;              /* FiveGSSubscriberIDs */
static int hf_lix2_ePSIdentities;                 /* EPSSubscriberIDs */
static int hf_lix2_iMSIdentities;                 /* IMSSubscriberIDs */
static int hf_lix2_sIPRegistration;               /* RCSSIPRegistrationExchange */
static int hf_lix2_userProfile;                   /* XMLType */
static int hf_lix2_multiDevice;                   /* XMLType */
static int hf_lix2_presenceDocument;              /* XMLType */
static int hf_lix2_cPMSessionInfo;                /* MIMEEntity */
static int hf_lix2_sessionLeg;                    /* RCSSessionLeg */
static int hf_lix2_sIPRequest;                    /* IMSPayload */
static int hf_lix2_sIPResponse;                   /* IMSPayload */
static int hf_lix2_rCSSessionResult;              /* RCSSessionResult */
static int hf_lix2_mSRPPathInfo;                  /* MSRPPath */
static int hf_lix2_registrationType_01;           /* RegistrationType */
static int hf_lix2_eECID;                         /* UTF8String */
static int hf_lix2_aCProfiles;                    /* ACProfiles */
static int hf_lix2_eECServiceContSupport;         /* ACRScenarios */
static int hf_lix2_expirationTime;                /* Timestamp */
static int hf_lix2_eECContextID;                  /* UTF8String */
static int hf_lix2_srcEESID;                      /* UTF8String */
static int hf_lix2_unfulfilledACProfiles;         /* UnfulfilledACProfiles */
static int hf_lix2_failureResponse;               /* FailureResponse */
static int hf_lix2_eASDiscoveryFilter;            /* EASDiscoveryFilter */
static int hf_lix2_uELocation;                    /* Location */
static int hf_lix2_eASTargetDNAIs;                /* DNAIs */
static int hf_lix2_discoveredEAS;                 /* DiscoveredEAS */
static int hf_lix2_subscriptionType;              /* SubscriptionType */
static int hf_lix2_eASEventType;                  /* EASEventType */
static int hf_lix2_eASDynamicInfoFilter;          /* EASDynamicInfoFilter */
static int hf_lix2_subscriptionId;                /* UTF8String */
static int hf_lix2_subscriptionID;                /* UTF8String */
static int hf_lix2_eventType;                     /* EASEventType */
static int hf_lix2_eESACRDetOrInit;               /* EESACRDetOrInit */
static int hf_lix2_aCRDetermineReq;               /* ACRDetermineReq */
static int hf_lix2_aCRInitiateReq;                /* ACRInitiateReq */
static int hf_lix2_eASID;                         /* EASID */
static int hf_lix2_aCID;                          /* ACID */
static int hf_lix2_sEASEndpoint;                  /* EASEndpoint */
static int hf_lix2_tEASEndpoint;                  /* EASEndpoint */
static int hf_lix2_previousTEASEndpoint;          /* EASEndpoint */
static int hf_lix2_routeReq;                      /* RouteToLocation */
static int hf_lix2_eASIDs;                        /* EASIDs */
static int hf_lix2_aCIDs;                         /* ACIDs */
static int hf_lix2_eventIDs;                      /* ACREventIDs */
static int hf_lix2_eventID;                       /* ACREventIDs */
static int hf_lix2_targetInfo;                    /* TargetInfo */
static int hf_lix2_aCRRes;                        /* BOOLEAN */
static int hf_lix2_failReason;                    /* UTF8String */
static int hf_lix2_uELoc;                         /* Location */
static int hf_lix2_ACProfiles_item;               /* ACProfile */
static int hf_lix2_aCType;                        /* UTF8String */
static int hf_lix2_aCSchedule;                    /* Daytime */
static int hf_lix2_expACGeoServArea;              /* Location */
static int hf_lix2_eASsInfo;                      /* EASsInfo */
static int hf_lix2_aCServiceContSupport;          /* ACRScenarios */
static int hf_lix2_ACRScenarios_item;             /* ACRScenario */
static int hf_lix2_UnfulfilledACProfiles_item;    /* UnfulfilledACProfile */
static int hf_lix2_reason_01;                     /* UnfulfilledACProfileReason */
static int hf_lix2_EASsInfo_item;                 /* EASInfo */
static int hf_lix2_expectedSvcKPIs;               /* ServiceKPIs */
static int hf_lix2_minimumReqSvcKPIs;             /* ServiceKPIs */
static int hf_lix2_connectionBandwidth;           /* INTEGER */
static int hf_lix2_requestRate;                   /* INTEGER */
static int hf_lix2_responseTime;                  /* INTEGER */
static int hf_lix2_requestedAvailability;         /* INTEGER */
static int hf_lix2_requestedCompute;              /* OCTET_STRING */
static int hf_lix2_requestedGraphCompute;         /* OCTET_STRING */
static int hf_lix2_requestedMemory;               /* OCTET_STRING */
static int hf_lix2_requestedStorage;              /* OCTET_STRING */
static int hf_lix2_aCsCharacteristics;            /* ACProfiles */
static int hf_lix2_eASCharacteristics;            /* EASsCharacteristics */
static int hf_lix2_EASsCharacteristics_item;      /* EASCharacteristics */
static int hf_lix2_aSPID;                         /* UTF8String */
static int hf_lix2_eASType;                       /* UTF8String */
static int hf_lix2_eASSchedule;                   /* Daytime */
static int hf_lix2_eASProfile;                    /* EASProfile */
static int hf_lix2_eASServiceArea;                /* Location */
static int hf_lix2_eASServicePermLevel;           /* UTF8String */
static int hf_lix2_eASServiceFeatures;            /* EASServiceFeatures */
static int hf_lix2_DNAIs_item;                    /* DNAI */
static int hf_lix2_lifetime;                      /* INTEGER */
static int hf_lix2_eASEndpoint;                   /* EASEndpoint */
static int hf_lix2_eASDescription;                /* UTF8String */
static int hf_lix2_eASServiceKPIs;                /* ServiceKPIs */
static int hf_lix2_eASServiceContSupport;         /* ACRScenarios */
static int hf_lix2_appLocs;                       /* RouteToLocations */
static int hf_lix2_eASStatus;                     /* EASStatus */
static int hf_lix2_fQDN;                          /* FQDN */
static int hf_lix2_iPv4Addresses;                 /* IPv4Addresses */
static int hf_lix2_iPv6Addresses;                 /* IPv6Addresses */
static int hf_lix2_uRI;                           /* UTF8String */
static int hf_lix2_RouteToLocations_item;         /* RouteToLocation */
static int hf_lix2_EASServiceFeatures_item;       /* EASServiceFeature */
static int hf_lix2_ACIDs_item;                    /* ACID */
static int hf_lix2_IPv4Addresses_item;            /* IPv4Address */
static int hf_lix2_IPv6Addresses_item;            /* IPv6Address */
static int hf_lix2_eASId;                         /* EASID */
static int hf_lix2_eASStatus_01;                  /* BOOLEAN */
static int hf_lix2_eASAcIDs;                      /* BOOLEAN */
static int hf_lix2_eASDesc;                       /* BOOLEAN */
static int hf_lix2_eASPt;                         /* BOOLEAN */
static int hf_lix2_eASFeature;                    /* BOOLEAN */
static int hf_lix2_eASSchedule_01;                /* BOOLEAN */
static int hf_lix2_eASSvcArea;                    /* BOOLEAN */
static int hf_lix2_eASSvcKpi;                     /* BOOLEAN */
static int hf_lix2_eASSvcCont;                    /* BOOLEAN */
static int hf_lix2_EASIDs_item;                   /* EASID */
static int hf_lix2_targetEESInfo;                 /* EDNConfigurationInfo */
static int hf_lix2_eDNConnectionInfo;             /* EDNConnectionInfo */
static int hf_lix2_eESsInfo;                      /* EESsInfo */
static int hf_lix2_serviceArea;                   /* Location */
static int hf_lix2_EESsInfo_item;                 /* EESInfo */
static int hf_lix2_eESID;                         /* EESID */
static int hf_lix2_eESEndpoint;                   /* EESEndpoint */
static int hf_lix2_dNAIS;                         /* DNAIs */
static int hf_lix2_serviceAccessInformationResource;  /* SBIType */
static int hf_lix2_consumptionReport;             /* SBIType */
static int hf_lix2_dynamicPolicyResource;         /* SBIType */
static int hf_lix2_dPIoperationType;              /* DPIOperationType */
static int hf_lix2_metricsReport;                 /* XMLType */
static int hf_lix2_networkAssistanceSessionResource;  /* SBIType */
static int hf_lix2_nAOperationType;               /* NAOperationType */
static int hf_lix2_fiveGMSAFUnsuccessfulOperation;  /* FiveGMSAFUnsuccessfulOperation */
static int hf_lix2_fiveGMSAFErrorCode;            /* FiveGMSAFErrorCode */
static int hf_lix2_nWDAFConsumerNFType;           /* NWDAFConsumerNFType */
static int hf_lix2_nWDAFEventsSubscriptionOpType;  /* NWDAFEventsSubscriptionOpType */
static int hf_lix2_nWDAFSubscribedEventList;      /* SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent */
static int hf_lix2_nWDAFSubscribedEventList_item;  /* NWDAFEvent */
static int hf_lix2_nWDAFEventsSubscription_01;    /* SBIType */
static int hf_lix2_nWDAFEventsSubscriptionID;     /* UTF8String */
static int hf_lix2_nWDAFEventsSubscriptionResponseCode;  /* NWDAFEventsSubscriptionResponseCode */
static int hf_lix2_nWDAFNotifiedEventList;        /* SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent */
static int hf_lix2_nWDAFNotifiedEventList_item;   /* NWDAFEvent */
static int hf_lix2_nWDAFEventsNotification_01;    /* SBIType */
static int hf_lix2_nWDAFEvent;                    /* NWDAFEvent */
static int hf_lix2_nWDAFEventReportingRequirement;  /* SBIType */
static int hf_lix2_nWDAFEventFilter;              /* SBIType */
static int hf_lix2_nWDAFAnalyticsData;            /* SBIType */
static int hf_lix2_nWDAFAnalyticsInfoResponseCode;  /* NWDAFAnalyticsInfoResponseCode */
static int hf_lix2_deprecatedPEI;                 /* PEI */
static int hf_lix2_sourceIPAddress_01;            /* IPAddress */
static int hf_lix2_destinationIPAddress_01;       /* IPAddress */
static int hf_lix2_iPv6flowLabel;                 /* IPv6FlowLabel */
static int hf_lix2_packetSize;                    /* INTEGER */
static int hf_lix2_pDSRSummaryTrigger;            /* PDSRSummaryTrigger */
static int hf_lix2_firstPacketTimestamp;          /* Timestamp */
static int hf_lix2_lastPacketTimestamp;           /* Timestamp */
static int hf_lix2_packetCount;                   /* INTEGER */
static int hf_lix2_byteCount;                     /* INTEGER */
static int hf_lix2_useSessionTrigger;             /* BOOLEAN */
static int hf_lix2_tAIList;                       /* TAIList */
static int hf_lix2_mMEUES1APID;                   /* MMEUES1APID */
static int hf_lix2_eNBUES1APID;                   /* RANUES1APID */
static int hf_lix2_handoverType_01;               /* EPSHandoverType */
static int hf_lix2_eRABsToBeForwarded;            /* ERABContextList */
static int hf_lix2_eRABsToRelease;                /* ERABReleaseList */
static int hf_lix2_targetToSourceContainers;      /* SEQUENCE_SIZE_1_MAX_OF_RANTargetToSourceContainer */
static int hf_lix2_targetToSourceContainers_item;  /* RANTargetToSourceContainer */
static int hf_lix2_handoverCause_01;              /* EPSRANCause */
static int hf_lix2_cSGInfo;                       /* EPSCSGInfo */
static int hf_lix2_admittedCSGID;                 /* CSGID */
static int hf_lix2_ePSRANUEContext;               /* EPSRANUEContext */
static int hf_lix2_attachType;                    /* EPSAttachType */
static int hf_lix2_attachResult;                  /* EPSAttachResult */
static int hf_lix2_ePSTAIList;                    /* TAIList */
static int hf_lix2_sMSServiceStatus;              /* EPSSMSServiceStatus */
static int hf_lix2_oldGUTI_01;                    /* GUTI */
static int hf_lix2_s1Information;                 /* S1Information */
static int hf_lix2_nASTransportInitialInformation_01;  /* EPSNASTransportInitialInformation */
static int hf_lix2_ePSUENetworkCapability;        /* EPSUENetworkCapability */
static int hf_lix2_initailRANUEContextSetup;      /* EPSRANUEContext */
static int hf_lix2_ePSNetworkPolicy;              /* EPSNetworkPolicy */
static int hf_lix2_detachDirection;               /* MMEDirection */
static int hf_lix2_detachType;                    /* EPSDetachType */
static int hf_lix2_cause_08;                      /* EMMCause */
static int hf_lix2_traceActivationInfo;           /* TraceActivation */
static int hf_lix2_eUTRANCGI;                     /* ECGI */
static int hf_lix2_mMETraceData;                  /* XMLType */
static int hf_lix2_mTMSI;                         /* TMSI */
static int hf_lix2_cSFBResponse;                  /* OCTET_STRING_SIZE_1 */
static int hf_lix2_uEEPSBearerContextStatus;      /* OCTET_STRING_SIZE_2 */
static int hf_lix2_controlPlaneServiceType;       /* OCTET_STRING_SIZE_1 */
static int hf_lix2_failedProcedureType_02;        /* MMEFailedProcedureType */
static int hf_lix2_failureCause_04;               /* MMEFailureCause */
static int hf_lix2_lPPaMessage;                   /* OCTET_STRING */
static int hf_lix2_mMELCSCorrelationId;           /* OCTET_STRING_SIZE_4 */
static int hf_lix2_hENBTransportLayerAddress;     /* IPAddr */
static int hf_lix2_uDPPortNumber;                 /* PortNumber */
static int hf_lix2_eNGNBID;                       /* GNbID */
static int hf_lix2_supportedTAList_01;            /* TACList */
static int hf_lix2_broadcastPLMN;                 /* PLMNList */
static int hf_lix2_ConnectedENGNBList_item;       /* ConnectedENGNB */
static int hf_lix2_cSGID;                         /* CSGID */
static int hf_lix2_cSGMembershipStatus;           /* CSGMembershipIndication */
static int hf_lix2_rANUES1APID;                   /* RANUES1APID */
static int hf_lix2_eRABSetupRequest;              /* ERABContextList */
static int hf_lix2_handoverRestrictionList;       /* EPSHandoverRestrictionList */
static int hf_lix2_uERadioCapability_01;          /* EPSUERadioCapability */
static int hf_lix2_cSFallbackIndicator;           /* EPSCSFallbackIndicator */
static int hf_lix2_proSeAuthorized;               /* EPSProSeAuthorization */
static int hf_lix2_lTEV2XServicesAuthorized;      /* LTEV2XServiceAuthorization */
static int hf_lix2_aerialUESubscription;          /* AerialUESubscriptionIndicator */
static int hf_lix2_subscriptionBasedUEDifferentiationIndication;  /* EPSSubscriptionBasedUEDifferentiationIndication */
static int hf_lix2_relayNodeIndicator;            /* BOOLEAN */
static int hf_lix2_bBFTunnelInformation;          /* BBFTunnelInformation */
static int hf_lix2_lTENTNTAIInformation;          /* LTENTNTAIInformation */
static int hf_lix2_eRABID;                        /* EPSBearerID */
static int hf_lix2_eRABQoSParameters;             /* ERABQoSParameters */
static int hf_lix2_transportLayerAddress;         /* IPAddr */
static int hf_lix2_uLGTPTEID;                     /* FTEID */
static int hf_lix2_dLGTPTEID;                     /* FTEID */
static int hf_lix2_ERABContextList_item;          /* ERABContext */
static int hf_lix2_cause_09;                      /* EPSRANCause */
static int hf_lix2_ERABReleaseList_item;          /* ERABError */
static int hf_lix2_pLMN;                          /* PLMNID */
static int hf_lix2_tACListInLTENTN;               /* TACList */
static int hf_lix2_uETAC;                         /* TAC */
static int hf_lix2_eMMCause;                      /* EMMCause */
static int hf_lix2_eSMCause;                      /* ESMCause */
static int hf_lix2_servedPLMNs;                   /* PLMNSupportList */
static int hf_lix2_MMEServedGUMMEIList_item;      /* MMEServedGUMMEI */
static int hf_lix2_cSGIDList;                     /* CSGIDList */
static int hf_lix2_connectedENGNBList;            /* ConnectedENGNBList */
static int hf_lix2_mMEServedGUMMEIList;           /* MMEServedGUMMEIList */
static int hf_lix2_notificationType;              /* LINotificationType */
static int hf_lix2_appliedTargetID;               /* TargetIdentifier */
static int hf_lix2_appliedDeliveryInformation;    /* SEQUENCE_OF_LIAppliedDeliveryInformation */
static int hf_lix2_appliedDeliveryInformation_item;  /* LIAppliedDeliveryInformation */
static int hf_lix2_appliedStartTime;              /* Timestamp */
static int hf_lix2_appliedEndTime;                /* Timestamp */
static int hf_lix2_appliedTargetIsLocal;          /* BOOLEAN */
static int hf_lix2_appliedTargetIsNonLocal;       /* BOOLEAN */
static int hf_lix2_hI2DeliveryIPAddress;          /* IPAddress */
static int hf_lix2_hI2DeliveryPortNumber;         /* PortNumber */
static int hf_lix2_hI3DeliveryIPAddress;          /* IPAddress */
static int hf_lix2_hI3DeliveryPortNumber;         /* PortNumber */
static int hf_lix2_MDFCellSiteReport_item;        /* CellInformation */
static int hf_lix2_eMMRegStatus;                  /* EMMRegStatus */
static int hf_lix2_fiveGMMStatus;                 /* FiveGMMStatus */
static int hf_lix2_fiveGGUTI;                     /* FiveGGUTI */
static int hf_lix2_oldPLMNID;                     /* PLMNID */
static int hf_lix2_newPLMNID;                     /* PLMNID */
static int hf_lix2_responseCodes;                 /* UTF8String */
static int hf_lix2_hSSIdentities;                 /* HSSIdentities */
static int hf_lix2_subscriptionDataSets;          /* SubscriptionDataSets */
static int hf_lix2_pSUserState;                   /* SBIType */
static int hf_lix2_iMSSubscriberIDs;              /* IMSSubscriberIDs */
static int hf_lix2_iMSSubscriptionData;           /* SBIType */
static int hf_lix2_AllowedNSSAI_item;             /* NSSAI */
static int hf_lix2_AllowedTACs_item;              /* TAC */
static int hf_lix2_areaOfInterestTAIList;         /* AreaOfInterestTAIList */
static int hf_lix2_areaOfInterestCellList;        /* AreaOfInterestCellList */
static int hf_lix2_areaOfInterestRANNodeList;     /* AreaOfInterestRANNodeList */
static int hf_lix2_AreaOfInterestCellList_item;   /* NCGI */
static int hf_lix2_areaOfInterest;                /* AreaOfInterest */
static int hf_lix2_AreaOfInterestRANNodeList_item;  /* GlobalRANNodeID */
static int hf_lix2_AreaOfInterestTAIList_item;    /* TAI */
static int hf_lix2_tAISliceSupportList;           /* TAISliceSupportList */
static int hf_lix2_CellCAGList_item;              /* CAGID */
static int hf_lix2_EquivalentPLMNs_item;          /* PLMNID */
static int hf_lix2_mCC;                           /* MCC */
static int hf_lix2_mNC;                           /* MNC */
static int hf_lix2_fiveGSSubscriberID;            /* SEQUENCE_SIZE_1_MAX_OF_FiveGSSubscriberID */
static int hf_lix2_fiveGSSubscriberID_item;       /* FiveGSSubscriberID */
static int hf_lix2_uE5GSRVCCCapability;           /* BOOLEAN */
static int hf_lix2_sessionTransferNumber;         /* UTF8String */
static int hf_lix2_correlationMSISDN;             /* MSISDN */
static int hf_lix2_fiveGSUserState;               /* FiveGSUserState */
static int hf_lix2_forbiddenTACs;                 /* ForbiddenTACs */
static int hf_lix2_ForbiddenTACs_item;            /* TAC */
static int hf_lix2_tEID;                          /* INTEGER_0_4294967295 */
static int hf_lix2_FTEIDList_item;                /* FTEID */
static int hf_lix2_nAI;                           /* NAI */
static int hf_lix2_mMEID;                         /* MMEID */
static int hf_lix2_mMEGroupID;                    /* MMEGroupID */
static int hf_lix2_mMECode;                       /* MMECode */
static int hf_lix2_radioNetwork;                  /* CauseRadioNetwork */
static int hf_lix2_transport;                     /* CauseTransport */
static int hf_lix2_nas;                           /* CauseNas */
static int hf_lix2_protocol_01;                   /* CauseProtocol */
static int hf_lix2_misc;                          /* CauseMisc */
static int hf_lix2_sIPURI;                        /* SIPURI */
static int hf_lix2_tELURI;                        /* TELURI */
static int hf_lix2_LocationAreaOfInterestList_item;  /* AreaOfInterestItem */
static int hf_lix2_eventType_01;                  /* LocationEventType */
static int hf_lix2_reportArea;                    /* LocationReportArea */
static int hf_lix2_areaOfInterestList;            /* LocationAreaOfInterestList */
static int hf_lix2_mMEGI;                         /* MMEGI */
static int hf_lix2_mMEC;                          /* MMEC */
static int hf_lix2_servingPLMN;                   /* PLMNID */
static int hf_lix2_equivalentPLMNs;               /* EquivalentPLMNs */
static int hf_lix2_rATRestrictions;               /* RATRestrictions */
static int hf_lix2_forbiddenAreaInformation;      /* ForbiddenAreaInformation */
static int hf_lix2_serviceAreaInformation;        /* ServiceAreaInformation */
static int hf_lix2_eUI64;                         /* EUI64 */
static int hf_lix2_pNINPNAccessInformation;       /* CellCAGList */
static int hf_lix2_NSSAI_item;                    /* SNSSAI */
static int hf_lix2_PLMNList_item;                 /* PLMNID */
static int hf_lix2_iMEISV;                        /* IMEISV */
static int hf_lix2_rANNodeNameVisible;            /* OCTET_STRING */
static int hf_lix2_rANNodeNameUTF8;               /* UTF8String */
static int hf_lix2_RATRestrictions_item;          /* RATRestrictionItem */
static int hf_lix2_rATRestrictionInformation;     /* RATRestrictionInformation */
static int hf_lix2_RejectedNSSAI_item;            /* RejectedSNSSAI */
static int hf_lix2_causeValue;                    /* RejectedSliceCauseValue */
static int hf_lix2_ServiceAreaInformation_item;   /* ServiceAreaInfo */
static int hf_lix2_allowedTACs;                   /* AllowedTACs */
static int hf_lix2_notAllowedTACs;                /* ForbiddenTACs */
static int hf_lix2_allowedNSSAI_01;               /* NSSAI */
static int hf_lix2_configuredNSSAI;               /* NSSAI */
static int hf_lix2_rejectedNSSAI;                 /* RejectedNSSAI */
static int hf_lix2_sliceServiceType;              /* INTEGER_0_255 */
static int hf_lix2_sliceDifferentiator;           /* OCTET_STRING_SIZE_3 */
static int hf_lix2_mappedHPLMNSliceServiceType;   /* INTEGER_0_255 */
static int hf_lix2_mappedHPLMNSliceDifferentiator;  /* OCTET_STRING_SIZE_3 */
static int hf_lix2_routingIndicator;              /* RoutingIndicator */
static int hf_lix2_protectionSchemeID;            /* ProtectionSchemeID */
static int hf_lix2_homeNetworkPublicKeyID;        /* HomeNetworkPublicKeyID */
static int hf_lix2_schemeOutput;                  /* SchemeOutput */
static int hf_lix2_routingIndicatorLength;        /* INTEGER_1_4 */
static int hf_lix2_sUPIType;                      /* SUPIType */
static int hf_lix2_homeNetworkIdentifier;         /* HomeNetworkIdentifier */
static int hf_lix2_SupportedTAList_item;          /* TAItem */
static int hf_lix2_tAC;                           /* TAC */
static int hf_lix2_broadcastPLMNList;             /* SEQUENCE_SIZE_1_MAX_OF_BroadcastPLMNItem */
static int hf_lix2_broadcastPLMNList_item;        /* BroadcastPLMNItem */
static int hf_lix2_rATinformation;                /* RATInformation */
static int hf_lix2_TAISliceSupportList_item;      /* SNSSAI */
static int hf_lix2_ethernetAddress;               /* MACAddress */
static int hf_lix2_supportVoPS;                   /* BOOLEAN */
static int hf_lix2_supportVoPSNon3GPP;            /* BOOLEAN */
static int hf_lix2_lastActiveTime;                /* Timestamp */
static int hf_lix2_fiveGSSubscriberIDs;           /* FiveGSSubscriberIDs */
static int hf_lix2_locationInfo;                  /* LocationInfo */
static int hf_lix2_positioningInfo;               /* PositioningInfo */
static int hf_lix2_locationPresenceReport;        /* LocationPresenceReport */
static int hf_lix2_fourGPositioningInfo;          /* FourGPositioningInfo */
static int hf_lix2_fourGLocationInfo;             /* FourGLocationInfo */
static int hf_lix2_iMSLocation;                   /* IMSLocation */
static int hf_lix2_geographicalCoordinates;       /* GeographicalCoordinates */
static int hf_lix2_azimuth;                       /* INTEGER_0_359 */
static int hf_lix2_operatorSpecificInformation;   /* UTF8String */
static int hf_lix2_userLocation;                  /* UserLocation */
static int hf_lix2_currentLoc;                    /* BOOLEAN */
static int hf_lix2_geoInfo;                       /* GeographicArea */
static int hf_lix2_timeZone;                      /* TimeZone */
static int hf_lix2_additionalCellIDs;             /* SEQUENCE_OF_CellInformation */
static int hf_lix2_additionalCellIDs_item;        /* CellInformation */
static int hf_lix2_eUTRALocation;                 /* EUTRALocation */
static int hf_lix2_nRLocation;                    /* NRLocation */
static int hf_lix2_n3GALocation;                  /* N3GALocation */
static int hf_lix2_uTRALocation;                  /* UTRALocation */
static int hf_lix2_gERALocation;                  /* GERALocation */
static int hf_lix2_tAI;                           /* TAI */
static int hf_lix2_eCGI;                          /* ECGI */
static int hf_lix2_ageOfLocationInfo;             /* AgeOfLocation */
static int hf_lix2_uELocationTimestamp;           /* Timestamp */
static int hf_lix2_geographicalInformation;       /* UTF8String */
static int hf_lix2_geodeticInformation;           /* UTF8String */
static int hf_lix2_globalNGENbID;                 /* GlobalRANNodeID */
static int hf_lix2_cellSiteInformation;           /* CellSiteInformation */
static int hf_lix2_globalENbID;                   /* GlobalRANNodeID */
static int hf_lix2_ignoreTAI;                     /* BOOLEAN */
static int hf_lix2_ignoreECGI;                    /* BOOLEAN */
static int hf_lix2_nCGI;                          /* NCGI */
static int hf_lix2_globalGNbID;                   /* GlobalRANNodeID */
static int hf_lix2_ignoreNCGI;                    /* BOOLEAN */
static int hf_lix2_nRNTNTAIInfo;                  /* NRNTNTAIInfo */
static int hf_lix2_iABMTUserLocation;             /* IABMTUserLocation */
static int hf_lix2_n3IWFID;                       /* N3IWFIDNGAP */
static int hf_lix2_uEIPAddr;                      /* IPAddr */
static int hf_lix2_portNumber_01;                 /* INTEGER */
static int hf_lix2_tNAPID;                        /* TNAPID */
static int hf_lix2_tWAPID;                        /* TWAPID */
static int hf_lix2_hFCNodeID;                     /* HFCNodeID */
static int hf_lix2_gLI;                           /* GLI */
static int hf_lix2_w5GBANLineType;                /* W5GBANLineType */
static int hf_lix2_gCI;                           /* GCI */
static int hf_lix2_protocol_02;                   /* TransportProtocol */
static int hf_lix2_cGI;                           /* CGI */
static int hf_lix2_sAI;                           /* SAI */
static int hf_lix2_lAI;                           /* LAI */
static int hf_lix2_rAI;                           /* RAI */
static int hf_lix2_ageOfLocationInfo_01;          /* INTEGER */
static int hf_lix2_locationNumber;                /* E164Number */
static int hf_lix2_vLRNumber;                     /* UTF8String */
static int hf_lix2_mSCNumber;                     /* UTF8String */
static int hf_lix2_pANIHeaderInfo;                /* SEQUENCE_OF_PANIHeaderInfo */
static int hf_lix2_pANIHeaderInfo_item;           /* PANIHeaderInfo */
static int hf_lix2_geolocationHeaderInfo;         /* SEQUENCE_OF_SIPGeolocationHeaderInfo */
static int hf_lix2_geolocationHeaderInfo_item;    /* SIPGeolocationHeaderInfo */
static int hf_lix2_cNIHeaderInfo;                 /* SEQUENCE_OF_SIPCNIHeaderInfo */
static int hf_lix2_cNIHeaderInfo_item;            /* SIPCNIHeaderInfo */
static int hf_lix2_iPv4Addr;                      /* IPv4Address */
static int hf_lix2_iPv6Addr;                      /* IPv6Address */
static int hf_lix2_aNNodeID;                      /* ANNodeID */
static int hf_lix2_n3IWFID_01;                    /* N3IWFIDSBI */
static int hf_lix2_gNbID;                         /* GNbID */
static int hf_lix2_nGENbID;                       /* NGENbID */
static int hf_lix2_eNbID;                         /* ENbID */
static int hf_lix2_wAGFID;                        /* WAGFID */
static int hf_lix2_tNGFID;                        /* TNGFID */
static int hf_lix2_cellID;                        /* CellID */
static int hf_lix2_lAC;                           /* LAC */
static int hf_lix2_sAC;                           /* SAC */
static int hf_lix2_rAC;                           /* RAC */
static int hf_lix2_eUTRACellID;                   /* EUTRACellID */
static int hf_lix2_TACList_item;                  /* TAC */
static int hf_lix2_TAIList_item;                  /* TAI */
static int hf_lix2_nRCellID;                      /* NRCellID */
static int hf_lix2_rANCGI;                        /* RANCGI */
static int hf_lix2_cellSiteinformation;           /* CellSiteInformation */
static int hf_lix2_timeOfLocation;                /* Timestamp */
static int hf_lix2_cellRadioRelatedInformation;   /* CellRadioRelatedInformation */
static int hf_lix2_band;                          /* RFBand */
static int hf_lix2_f1Information;                 /* F1Information */
static int hf_lix2_sSID;                          /* SSID */
static int hf_lix2_bSSID;                         /* BSSID */
static int hf_lix2_civicAddress;                  /* CivicAddressBytes */
static int hf_lix2_macroNGENbID;                  /* BIT_STRING_SIZE_20 */
static int hf_lix2_shortMacroNGENbID;             /* BIT_STRING_SIZE_18 */
static int hf_lix2_longMacroNGENbID;              /* BIT_STRING_SIZE_21 */
static int hf_lix2_macroENbID;                    /* BIT_STRING_SIZE_20 */
static int hf_lix2_homeENbID;                     /* BIT_STRING_SIZE_28 */
static int hf_lix2_shortMacroENbID;               /* BIT_STRING_SIZE_18 */
static int hf_lix2_longMacroENbID;                /* BIT_STRING_SIZE_21 */
static int hf_lix2_positionInfo;                  /* LocationData */
static int hf_lix2_rawMLPResponse;                /* RawMLPResponse */
static int hf_lix2_mLPPositionData;               /* UTF8String */
static int hf_lix2_mLPErrorCode;                  /* INTEGER_1_699 */
static int hf_lix2_locationEstimate;              /* GeographicArea */
static int hf_lix2_accuracyFulfilmentIndicator;   /* AccuracyFulfilmentIndicator */
static int hf_lix2_ageOfLocationEstimate;         /* AgeOfLocation */
static int hf_lix2_velocityEstimate;              /* VelocityEstimate */
static int hf_lix2_civicAddress_01;               /* CivicAddress */
static int hf_lix2_positioningDataList;           /* SET_OF_PositioningMethodAndUsage */
static int hf_lix2_positioningDataList_item;      /* PositioningMethodAndUsage */
static int hf_lix2_gNSSPositioningDataList;       /* SET_OF_GNSSPositioningMethodAndUsage */
static int hf_lix2_gNSSPositioningDataList_item;  /* GNSSPositioningMethodAndUsage */
static int hf_lix2_altitude;                      /* Altitude */
static int hf_lix2_barometricPressure;            /* BarometricPressure */
static int hf_lix2_gERANPositioningData;          /* GERANPositioningData */
static int hf_lix2_gERANGANSSPositioningData;     /* GERANGANSSPositioningData */
static int hf_lix2_uTRANPositioningData;          /* UTRANPositioningData */
static int hf_lix2_uTRANGANSSPositioningData;     /* UTRANGANSSPositioningData */
static int hf_lix2_uTRANAdditionalPositioningData;  /* UTRANAdditionalPositioningData */
static int hf_lix2_locationData;                  /* LocationData */
static int hf_lix2_eSMLCCellInfo;                 /* ESMLCCellInfo */
static int hf_lix2_gERANPositioningInfo;          /* GERANPositioningInfo */
static int hf_lix2_uTRANPositioningInfo;          /* UTRANPositioningInfo */
static int hf_lix2_ePSLocationInformation;        /* EPSLocationInformation */
static int hf_lix2_ePSUserLocationInformation;    /* EPSUserLocationInformation */
static int hf_lix2_mMELocationInformation;        /* MMELocationInformation */
static int hf_lix2_sGSNLocationInformation;       /* SGSNLocationInformation */
static int hf_lix2_geographicalInformation_01;    /* GeographicalInformationOctet */
static int hf_lix2_geodeticInformation_01;        /* GeodeticInformationOctet */
static int hf_lix2_currentLocationRetrieved;      /* BOOLEAN */
static int hf_lix2_ageOfLocationInformation;      /* INTEGER */
static int hf_lix2_userCSGInformation;            /* UserCSGInformation */
static int hf_lix2_cSGAccessMode;                 /* CSGAccessMode */
static int hf_lix2_cSGMembershipIndication;       /* CSGMembershipIndication */
static int hf_lix2_CSGIDList_item;                /* CSGID */
static int hf_lix2_cellPortionID;                 /* CellPortionID */
static int hf_lix2_type_02;                       /* AMFEventType */
static int hf_lix2_timestamp;                     /* Timestamp */
static int hf_lix2_areaList;                      /* SET_OF_AMFEventArea */
static int hf_lix2_areaList_item;                 /* AMFEventArea */
static int hf_lix2_accessTypes;                   /* SET_OF_AccessType */
static int hf_lix2_accessTypes_item;              /* AccessType */
static int hf_lix2_rMInfoList;                    /* SET_OF_RMInfo */
static int hf_lix2_rMInfoList_item;               /* RMInfo */
static int hf_lix2_cMInfoList;                    /* SET_OF_CMInfo */
static int hf_lix2_cMInfoList_item;               /* CMInfo */
static int hf_lix2_reachability;                  /* UEReachability */
static int hf_lix2_location_02;                   /* UserLocation */
static int hf_lix2_presenceInfo;                  /* PresenceInfo */
static int hf_lix2_lADNInfo;                      /* LADNInfo */
static int hf_lix2_presenceState;                 /* PresenceState */
static int hf_lix2_trackingAreaList;              /* SET_OF_TAI */
static int hf_lix2_trackingAreaList_item;         /* TAI */
static int hf_lix2_eCGIList;                      /* SET_OF_ECGI */
static int hf_lix2_eCGIList_item;                 /* ECGI */
static int hf_lix2_nCGIList;                      /* SET_OF_NCGI */
static int hf_lix2_nCGIList_item;                 /* NCGI */
static int hf_lix2_globalRANNodeIDList;           /* SET_OF_GlobalRANNodeID */
static int hf_lix2_globalRANNodeIDList_item;      /* GlobalRANNodeID */
static int hf_lix2_globalENbIDList;               /* SET_OF_GlobalRANNodeID */
static int hf_lix2_globalENbIDList_item;          /* GlobalRANNodeID */
static int hf_lix2_lADN;                          /* UTF8String */
static int hf_lix2_presence;                      /* PresenceState */
static int hf_lix2_rMState;                       /* RMState */
static int hf_lix2_cMState;                       /* CMState */
static int hf_lix2_point;                         /* Point */
static int hf_lix2_pointUncertaintyCircle;        /* PointUncertaintyCircle */
static int hf_lix2_pointUncertaintyEllipse;       /* PointUncertaintyEllipse */
static int hf_lix2_polygon;                       /* Polygon */
static int hf_lix2_pointAltitude;                 /* PointAltitude */
static int hf_lix2_pointAltitudeUncertainty;      /* PointAltitudeUncertainty */
static int hf_lix2_ellipsoidArc;                  /* EllipsoidArc */
static int hf_lix2_horVelocity;                   /* HorizontalVelocity */
static int hf_lix2_horWithVertVelocity;           /* HorizontalWithVerticalVelocity */
static int hf_lix2_horVelocityWithUncertainty;    /* HorizontalVelocityWithUncertainty */
static int hf_lix2_horWithVertVelocityAndUncertainty;  /* HorizontalWithVerticalVelocityAndUncertainty */
static int hf_lix2_country_01;                    /* UTF8String */
static int hf_lix2_a1;                            /* UTF8String */
static int hf_lix2_a2;                            /* UTF8String */
static int hf_lix2_a3;                            /* UTF8String */
static int hf_lix2_a4;                            /* UTF8String */
static int hf_lix2_a5;                            /* UTF8String */
static int hf_lix2_a6;                            /* UTF8String */
static int hf_lix2_prd;                           /* UTF8String */
static int hf_lix2_pod;                           /* UTF8String */
static int hf_lix2_sts;                           /* UTF8String */
static int hf_lix2_hno;                           /* UTF8String */
static int hf_lix2_hns;                           /* UTF8String */
static int hf_lix2_lmk;                           /* UTF8String */
static int hf_lix2_loc;                           /* UTF8String */
static int hf_lix2_nam;                           /* UTF8String */
static int hf_lix2_pc;                            /* UTF8String */
static int hf_lix2_bld;                           /* UTF8String */
static int hf_lix2_unit;                          /* UTF8String */
static int hf_lix2_flr;                           /* UTF8String */
static int hf_lix2_room;                          /* UTF8String */
static int hf_lix2_plc;                           /* UTF8String */
static int hf_lix2_pcn;                           /* UTF8String */
static int hf_lix2_pobox;                         /* UTF8String */
static int hf_lix2_addcode;                       /* UTF8String */
static int hf_lix2_seat;                          /* UTF8String */
static int hf_lix2_rd;                            /* UTF8String */
static int hf_lix2_rdsec;                         /* UTF8String */
static int hf_lix2_rdbr;                          /* UTF8String */
static int hf_lix2_rdsubbr;                       /* UTF8String */
static int hf_lix2_prm;                           /* UTF8String */
static int hf_lix2_pom;                           /* UTF8String */
static int hf_lix2_method;                        /* PositioningMethod */
static int hf_lix2_mode;                          /* PositioningMode */
static int hf_lix2_usage;                         /* Usage */
static int hf_lix2_methodCode;                    /* MethodCode */
static int hf_lix2_gNSS;                          /* GNSSID */
static int hf_lix2_deprecatedUncertainty;         /* Uncertainty */
static int hf_lix2_uncertaintySBI;                /* UncertaintySBI */
static int hf_lix2_uncertainty;                   /* UncertaintyEllipse */
static int hf_lix2_confidence;                    /* Confidence */
static int hf_lix2_pointList;                     /* SET_SIZE_3_15_OF_GeographicalCoordinates */
static int hf_lix2_pointList_item;                /* GeographicalCoordinates */
static int hf_lix2_point_01;                      /* GeographicalCoordinates */
static int hf_lix2_uncertaintyEllipse;            /* UncertaintyEllipse */
static int hf_lix2_deprecatedUncertaintyAltitude;  /* Uncertainty */
static int hf_lix2_uncertaintyAltitudeSBI;        /* UncertaintySBI */
static int hf_lix2_innerRadius;                   /* InnerRadius */
static int hf_lix2_deprecatedUncertaintyRadius;   /* Uncertainty */
static int hf_lix2_offsetAngle;                   /* Angle */
static int hf_lix2_includedAngle;                 /* Angle */
static int hf_lix2_uncertaintyRadiusSBI;          /* UncertaintySBI */
static int hf_lix2_latitude;                      /* UTF8String */
static int hf_lix2_longitude;                     /* UTF8String */
static int hf_lix2_mapDatumInformation;           /* OGCURN */
static int hf_lix2_deprecatedSemiMajor;           /* Uncertainty */
static int hf_lix2_deprecatedSemiMinor;           /* Uncertainty */
static int hf_lix2_orientationMajor;              /* Orientation */
static int hf_lix2_semiMajorSBI;                  /* UncertaintySBI */
static int hf_lix2_semiMinorSBI;                  /* UncertaintySBI */
static int hf_lix2_hSpeed;                        /* HorizontalSpeed */
static int hf_lix2_bearing;                       /* Angle */
static int hf_lix2_vSpeed;                        /* VerticalSpeed */
static int hf_lix2_vDirection;                    /* VerticalDirection */
static int hf_lix2_uncertainty_01;                /* SpeedUncertainty */
static int hf_lix2_hUncertainty;                  /* SpeedUncertainty */
static int hf_lix2_vUncertainty;                  /* SpeedUncertainty */
static int hf_lix2_accessNetworkInformation_01;   /* SIPAccessNetworkInformation */
static int hf_lix2_accessInfo_01;                 /* SEQUENCE_OF_SIPAccessInfo */
static int hf_lix2_accessInfo_item_01;            /* SIPAccessInfo */
static int hf_lix2_pANILocation;                  /* SEQUENCE_OF_SIPLocationInfo */
static int hf_lix2_pANILocation_item;             /* SIPLocationInfo */
static int hf_lix2_locationValue;                 /* UTF8String */
static int hf_lix2_cidInfo;                       /* UTF8String */
static int hf_lix2_accessInfo_02;                 /* SIPAccessInfo */
static int hf_lix2_cellInfoAge;                   /* SIPCNICellInfoAge */
static int hf_lix2_cellInformation;               /* CellInformation */
static int hf_lix2_accessNetworkInfo;             /* UTF8String */
static int hf_lix2_cellularNetworkInformation_01;  /* SIPCellularNetworkInformation */
static int hf_lix2_cellularAccessInfo;            /* SEQUENCE_OF_SIPCellularAccessInfo */
static int hf_lix2_cellularAccessInfo_item;       /* SIPCellularAccessInfo */
static int hf_lix2_cNILocation;                   /* SEQUENCE_OF_SIPLocationInfo */
static int hf_lix2_cNILocation_item;              /* SIPLocationInfo */
static int hf_lix2_cellularNetworkInfo;           /* UTF8String */
static int hf_lix2_tACListNRNTN;                  /* SEQUENCE_SIZE_1_MAX_OF_TAC */
static int hf_lix2_tACListNRNTN_item;             /* TAC */
static int hf_lix2_uELocationDerivedNTNTAC;       /* TAC */
static int hf_lix2_nRCGI;                         /* NCGI */
static int hf_lix2_fullPayload;                   /* EncapsulatedRCSPayload */
static int hf_lix2_modifiedPayload;               /* ModifiedRCSPayload */
static int hf_lix2_mIME;                          /* MIMEEntity */
static int hf_lix2_mSRP;                          /* MSRPMessage */
static int hf_lix2_sIP;                           /* SIPMessage */
static int hf_lix2_modifiedRCSPayload;            /* EncapsulatedRCSPayload */
static int hf_lix2_modificationList;              /* SEQUENCE_OF_PayloadModification */
static int hf_lix2_modificationList_item;         /* PayloadModification */
static int hf_lix2_predefinedModification;        /* PredefinedPayloadModification */
static int hf_lix2_describedModification;         /* PayloadModificationDescription */
static int hf_lix2_modificationLocation;          /* ModificationLocation */
static int hf_lix2_modificationType;              /* ModificationType */
static int hf_lix2_jSONPointer;                   /* UTF8String */
static int hf_lix2_xPath;                         /* UTF8String */
static int hf_lix2_sIPHeader;                     /* UTF8String */
static int hf_lix2_sIPBody;                       /* NULL */
static int hf_lix2_mIMEHeader;                    /* UTF8String */
static int hf_lix2_mIMEBody;                      /* MIMEBody */
static int hf_lix2_uTF8Location;                  /* IndexRange */
static int hf_lix2_octetLocation;                 /* IndexRange */
static int hf_lix2_aBNFRule;                      /* ABNFRuleLocation */
static int hf_lix2_removed;                       /* PayloadInformationRemoved */
static int hf_lix2_replacedWithCharacters;        /* PayloadInformationReplacedWithCharacters */
static int hf_lix2_replacedWithOctets;            /* OCTET_STRING */
static int hf_lix2_replacedWithBits;              /* BIT_STRING */
static int hf_lix2_charactersRemoved;             /* INTEGER */
static int hf_lix2_octetsRemoved;                 /* INTEGER */
static int hf_lix2_bitsRemoved;                   /* INTEGER */
static int hf_lix2_characters;                    /* UTF8String */
static int hf_lix2_end;                           /* INTEGER */
static int hf_lix2_encapsulatedMSRP;              /* EncapsulatedMSRP */
static int hf_lix2_sBIReference;                  /* SBIReference */
static int hf_lix2_sBIValue;                      /* SBIValue */
static int hf_lix2_xMLNamespace;                  /* XMLNamespace */
static int hf_lix2_xMLValue;                      /* XMLValue */
static int hf_lix2_contentType_02;                /* MIMEContentType */
static int hf_lix2_encapsulatedMIMEEntity;        /* EncapsulatedMIMEEntity */
static int hf_lix2_index;                         /* INTEGER */
static int hf_lix2_fullBody;                      /* NULL */
static int hf_lix2_bodyPart;                      /* MIMEPartIdentifier */
static int hf_lix2_moduleIdentifier;              /* OBJECT_IDENTIFIER */
static int hf_lix2_aSNReference;                  /* ExternalASNReference */
static int hf_lix2_encodedASNValue;               /* ExternalASNValue */
static int hf_lix2_bER;                           /* OCTET_STRING */
static int hf_lix2_alignedPER;                    /* OCTET_STRING */

static int ett_lix2_eps_indicationflags;
static int ett_lix2_XIRIPayload;
static int ett_lix2_XIRIEvent;
static int ett_lix2_IRIPayload;
static int ett_lix2_SEQUENCE_OF_IRITargetIdentifier;
static int ett_lix2_IRIEvent;
static int ett_lix2_IRITargetIdentifier;
static int ett_lix2_MediatedFromIndicator;
static int ett_lix2_CCPayload;
static int ett_lix2_CCPDU;
static int ett_lix2_LINotificationPayload;
static int ett_lix2_LINotificationMessage;
static int ett_lix2_N9HRPDUSessionInfo;
static int ett_lix2_S8HRBearerInfo;
static int ett_lix2_NEFPDUSessionEstablishment;
static int ett_lix2_NEFPDUSessionModification;
static int ett_lix2_NEFPDUSessionRelease;
static int ett_lix2_NEFUnsuccessfulProcedure;
static int ett_lix2_NEFStartOfInterceptionWithEstablishedPDUSession;
static int ett_lix2_NEFDeviceTrigger;
static int ett_lix2_NEFDeviceTriggerReplace;
static int ett_lix2_NEFDeviceTriggerCancellation;
static int ett_lix2_NEFDeviceTriggerReportNotify;
static int ett_lix2_NEFMSISDNLessMOSMS;
static int ett_lix2_NEFExpectedUEBehaviourUpdate;
static int ett_lix2_SEQUENCE_OF_UMTLocationArea5G;
static int ett_lix2_NEFAFSessionWithQoSProvision;
static int ett_lix2_NEFAFSessionWithQoSNotification;
static int ett_lix2_ScheduledCommunicationTime;
static int ett_lix2_SEQUENCE_OF_Daytime;
static int ett_lix2_UMTLocationArea5G;
static int ett_lix2_Daytime;
static int ett_lix2_SCEFPDNConnectionEstablishment;
static int ett_lix2_SCEFPDNConnectionUpdate;
static int ett_lix2_SCEFPDNConnectionRelease;
static int ett_lix2_SCEFUnsuccessfulProcedure;
static int ett_lix2_SCEFStartOfInterceptionWithEstablishedPDNConnection;
static int ett_lix2_SCEFDeviceTrigger;
static int ett_lix2_SCEFDeviceTriggerReplace;
static int ett_lix2_SCEFDeviceTriggerCancellation;
static int ett_lix2_SCEFDeviceTriggerReportNotify;
static int ett_lix2_SCEFMSISDNLessMOSMS;
static int ett_lix2_SCEFCommunicationPatternUpdate;
static int ett_lix2_SCEFASSessionWithQoSProvision;
static int ett_lix2_SCEFASSessionWithQoSNotification;
static int ett_lix2_AAnFAnchorKeyRegister;
static int ett_lix2_AAnFKAKMAApplicationKeyGet;
static int ett_lix2_AAnFStartOfInterceptWithEstablishedAKMAKeyMaterial;
static int ett_lix2_SEQUENCE_OF_AFKeyInfo;
static int ett_lix2_AAnFAKMAContextRemovalRecord;
static int ett_lix2_AKMAAFID;
static int ett_lix2_UAStarParams;
static int ett_lix2_GenericUAStarParams;
static int ett_lix2_TLSCipherSuite;
static int ett_lix2_TLS12UAStarParams;
static int ett_lix2_AFKeyInfo;
static int ett_lix2_AFAKMAApplicationKeyRefresh;
static int ett_lix2_AFStartOfInterceptWithEstablishedAKMAApplicationKey;
static int ett_lix2_SEQUENCE_OF_AFSecurityParams;
static int ett_lix2_AFAuxiliarySecurityParameterEstablishment;
static int ett_lix2_AFSecurityParams;
static int ett_lix2_AFApplicationKeyRemoval;
static int ett_lix2_AMFRegistration;
static int ett_lix2_AMFDeregistration;
static int ett_lix2_AMFLocationUpdate;
static int ett_lix2_AMFStartOfInterceptionWithRegisteredUE;
static int ett_lix2_AMFUnsuccessfulProcedure;
static int ett_lix2_AMFPositioningInfoTransfer;
static int ett_lix2_AMFRANHandoverCommand;
static int ett_lix2_AMFRANHandoverRequest;
static int ett_lix2_AMFUEConfigurationUpdate;
static int ett_lix2_AMFRANTraceReport;
static int ett_lix2_AMFUEPolicyTransfer;
static int ett_lix2_AMFUEServiceAccept;
static int ett_lix2_AMFID;
static int ett_lix2_AMFFailureCause;
static int ett_lix2_ServiceMessageIdentity;
static int ett_lix2_TraceActivationInfo;
static int ett_lix2_TraceCollectionEntityInfo;
static int ett_lix2_NASTransportInitialInformation;
static int ett_lix2_NGInformation;
static int ett_lix2_PLMNSupportList;
static int ett_lix2_PLMNSupportItem;
static int ett_lix2_F1Information;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RANCGI;
static int ett_lix2_RRCEstablishmentCause;
static int ett_lix2_InitialRANUEContextSetup;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_PDUSessionSetupRequestItem;
static int ett_lix2_PDUSessionSetupRequestItem;
static int ett_lix2_UERadioCapability;
static int ett_lix2_UERadioCapabilityForPaging;
static int ett_lix2_NRV2XServicesAuthorization;
static int ett_lix2_LTEV2XServiceAuthorization;
static int ett_lix2_TargetNSSAIInfo;
static int ett_lix2_FiveGProSeAuthorizationIndication;
static int ett_lix2_UEAreaIndication;
static int ett_lix2_SMFPDUSessionEstablishment;
static int ett_lix2_SEQUENCE_OF_UEEndpointAddress;
static int ett_lix2_SMFPDUSessionModification;
static int ett_lix2_SMFPDUSessionRelease;
static int ett_lix2_SMFStartOfInterceptionWithEstablishedPDUSession;
static int ett_lix2_SMFUnsuccessfulProcedure;
static int ett_lix2_SMFPDUtoMAPDUSessionModification;
static int ett_lix2_SMFMAPDUSessionEstablishment;
static int ett_lix2_SEQUENCE_OF_AccessInfo;
static int ett_lix2_SMFMAPDUSessionModification;
static int ett_lix2_SMFMAPDUSessionRelease;
static int ett_lix2_SMFStartOfInterceptionWithEstablishedMAPDUSession;
static int ett_lix2_SMFMAUnsuccessfulProcedure;
static int ett_lix2_SMFServingNetwork;
static int ett_lix2_AccessInfo;
static int ett_lix2_DLRANTunnelInformation;
static int ett_lix2_FiveGSGTPTunnels;
static int ett_lix2_NGAPCauseInt;
static int ett_lix2_QOSFlowTunnelInformation;
static int ett_lix2_QOSFlowTunnelInformationList;
static int ett_lix2_QOSFlowLists;
static int ett_lix2_QOSFlowList;
static int ett_lix2_QOSFlowProfile;
static int ett_lix2_PCCRule;
static int ett_lix2_UPPathChange;
static int ett_lix2_PCCRuleSet;
static int ett_lix2_PCCRuleIDSet;
static int ett_lix2_FlowInformationSet;
static int ett_lix2_RouteToLocationSet;
static int ett_lix2_FlowInformation;
static int ett_lix2_FlowDescription;
static int ett_lix2_IPAddressOrRangeOrAny;
static int ett_lix2_IPMask;
static int ett_lix2_NextLayerProtocolOrAny;
static int ett_lix2_EthFlowDescription;
static int ett_lix2_SET_OF_VLANTag;
static int ett_lix2_VLANTag;
static int ett_lix2_RouteToLocation;
static int ett_lix2_RouteInfo;
static int ett_lix2_EASIPReplaceInfos;
static int ett_lix2_EASServerAddress;
static int ett_lix2_EPSPDNConnectionEstablishment;
static int ett_lix2_SEQUENCE_OF_EPSBearerContextCreated;
static int ett_lix2_SEQUENCE_OF_EPSBearerContextForRemoval;
static int ett_lix2_EPSPDNConnectionModification;
static int ett_lix2_SEQUENCE_OF_EPSBearerContextModified;
static int ett_lix2_SEQUENCE_OF_EPSBearersDeleted;
static int ett_lix2_EPSPDNConnectionRelease;
static int ett_lix2_EPSStartOfInterceptionWithEstablishedPDNConnection;
static int ett_lix2_SEQUENCE_OF_EPSBearerContext;
static int ett_lix2_PFDDataForApps;
static int ett_lix2_PFDDataForApp;
static int ett_lix2_PFDs;
static int ett_lix2_PFD;
static int ett_lix2_PFDURLs;
static int ett_lix2_PFDFlowDescriptions;
static int ett_lix2_DomainNames;
static int ett_lix2_PFDFlowDescription;
static int ett_lix2_EPS5GSComboInfo;
static int ett_lix2_EPSSubscriberIDs;
static int ett_lix2_EPSPDNCnxInfo;
static int ett_lix2_EPSBearerInfo;
static int ett_lix2_EPSBearers;
static int ett_lix2_EPSBearerContext;
static int ett_lix2_EPSBearerContextCreated;
static int ett_lix2_EPSBearerContextModified;
static int ett_lix2_SEQUENCE_OF_EPSBearerID;
static int ett_lix2_EPSBearersDeleted;
static int ett_lix2_EPSDeleteBearerResponse;
static int ett_lix2_SEQUENCE_OF_EPSDeleteBearerContext;
static int ett_lix2_EPSDeleteBearerContext;
static int ett_lix2_EPSBearerContextForRemoval;
static int ett_lix2_EPSBearerQOS;
static int ett_lix2_EPSGTPTunnels;
static int ett_lix2_FiveGSInterworkingInfo;
static int ett_lix2_PDNProtocolConfigurationOptions;
static int ett_lix2_GTPTunnelInfo;
static int ett_lix2_ExtendedUPFCCPDU;
static int ett_lix2_UPFCCPDUPayload;
static int ett_lix2_UDMServingSystemMessage;
static int ett_lix2_UDMSubscriberRecordChangeMessage;
static int ett_lix2_UDMCancelLocationMessage;
static int ett_lix2_UDMLocationInformationResult;
static int ett_lix2_UDMUEInformationResponse;
static int ett_lix2_UDMUEAuthenticationResponse;
static int ett_lix2_UDMStartOfInterceptionWithRegisteredTarget;
static int ett_lix2_UDMProSeTargetIdentifierDeconcealment;
static int ett_lix2_UDMProSeTargetAuthentication;
static int ett_lix2_ServerAddressingInfoList;
static int ett_lix2_ServerAddressingInfo;
static int ett_lix2_FQDNList;
static int ett_lix2_ServiceID;
static int ett_lix2_SEQUENCE_OF_CAGID;
static int ett_lix2_UDMAuthenticationInfoRequest;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_SubscriberIdentifier;
static int ett_lix2_UDMLocationInfoRequest;
static int ett_lix2_UDMProblemDetails;
static int ett_lix2_UDMProblemDetailsCause;
static int ett_lix2_UDMProblemDetailsOtherCause;
static int ett_lix2_UDMInvalidParameters;
static int ett_lix2_UDMAMFDeregistrationInfo;
static int ett_lix2_UDMDeregistrationData;
static int ett_lix2_SMSMessage;
static int ett_lix2_SMSReport;
static int ett_lix2_SMSParty;
static int ett_lix2_SMSNFAddress;
static int ett_lix2_SMSTPDUData;
static int ett_lix2_MMSSend;
static int ett_lix2_SEQUENCE_OF_MMSParty;
static int ett_lix2_MMSSendByNonLocalTarget;
static int ett_lix2_MMSNotification;
static int ett_lix2_MMSSendToNonLocalTarget;
static int ett_lix2_MMSNotificationResponse;
static int ett_lix2_MMSRetrieval;
static int ett_lix2_MMSDeliveryAck;
static int ett_lix2_MMSForward;
static int ett_lix2_MMSDeleteFromRelay;
static int ett_lix2_T_contentLocationReq;
static int ett_lix2_T_contentLocationConf;
static int ett_lix2_T_deleteResponseText;
static int ett_lix2_MMSMBoxStore;
static int ett_lix2_MMSMBoxUpload;
static int ett_lix2_SEQUENCE_OF_MMBoxDescription;
static int ett_lix2_MMSMBoxDelete;
static int ett_lix2_T_contentLocationReq_01;
static int ett_lix2_T_contentLocationConf_01;
static int ett_lix2_MMSDeliveryReport;
static int ett_lix2_MMSDeliveryReportNonLocalTarget;
static int ett_lix2_MMSReadReport;
static int ett_lix2_MMSReadReportNonLocalTarget;
static int ett_lix2_MMSCancel;
static int ett_lix2_MMSMBoxViewRequest;
static int ett_lix2_SEQUENCE_OF_MMState;
static int ett_lix2_SEQUENCE_OF_MMFlags;
static int ett_lix2_T_attributes;
static int ett_lix2_MMSMBoxViewResponse;
static int ett_lix2_T_attributes_01;
static int ett_lix2_MMBoxDescription;
static int ett_lix2_MMSCCPDU;
static int ett_lix2_MMSAdaptation;
static int ett_lix2_MMSElementDescriptor;
static int ett_lix2_MMSExpiry;
static int ett_lix2_MMFlags;
static int ett_lix2_MMSParty;
static int ett_lix2_SEQUENCE_OF_MMSPartyID;
static int ett_lix2_MMSPartyID;
static int ett_lix2_MMSPreviouslySent;
static int ett_lix2_MMSPreviouslySentBy;
static int ett_lix2_MMSQuota;
static int ett_lix2_MMSVersion;
static int ett_lix2_PTCRegistration;
static int ett_lix2_PTCSessionInitiation;
static int ett_lix2_SEQUENCE_OF_PTCTargetInformation;
static int ett_lix2_PTCSessionAbandon;
static int ett_lix2_PTCSessionStart;
static int ett_lix2_PTCSessionEnd;
static int ett_lix2_PTCStartOfInterception;
static int ett_lix2_PTCPreEstablishedSession;
static int ett_lix2_PTCInstantPersonalAlert;
static int ett_lix2_PTCPartyJoin;
static int ett_lix2_PTCPartyDrop;
static int ett_lix2_PTCPartyHold;
static int ett_lix2_PTCMediaModification;
static int ett_lix2_PTCGroupAdvertisement;
static int ett_lix2_PTCFloorControl;
static int ett_lix2_SEQUENCE_OF_PTCFloorActivity;
static int ett_lix2_PTCTargetPresence;
static int ett_lix2_PTCParticipantPresence;
static int ett_lix2_PTCListManagement;
static int ett_lix2_SEQUENCE_OF_PTCIDList;
static int ett_lix2_PTCAccessPolicy;
static int ett_lix2_PTCTargetInformation;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_PTCIdentifiers;
static int ett_lix2_PTCIdentifiers;
static int ett_lix2_PTCSessionInfo;
static int ett_lix2_MultipleParticipantPresenceStatus;
static int ett_lix2_PTCParticipantPresenceStatus;
static int ett_lix2_RTPSetting;
static int ett_lix2_PTCIDList;
static int ett_lix2_PTCChatGroupID;
static int ett_lix2_IMSMessage;
static int ett_lix2_SEQUENCE_OF_SIPAccessNetworkInformation;
static int ett_lix2_SEQUENCE_OF_SIPCellularNetworkInformation;
static int ett_lix2_StartOfInterceptionForActiveIMSSession;
static int ett_lix2_SEQUENCE_OF_IMPU;
static int ett_lix2_T_sDPState;
static int ett_lix2_IMSCCUnavailable;
static int ett_lix2_IMSCCPDU;
static int ett_lix2_IMSPayload;
static int ett_lix2_ModifiedSIPMessage;
static int ett_lix2_SIPMessage;
static int ett_lix2_STIRSHAKENSignatureGeneration;
static int ett_lix2_SEQUENCE_OF_PASSporT;
static int ett_lix2_STIRSHAKENSignatureValidation;
static int ett_lix2_PASSporT;
static int ett_lix2_PASSporTHeader;
static int ett_lix2_PASSporTPayload;
static int ett_lix2_STIRSHAKENOriginator;
static int ett_lix2_STIRSHAKENDestinations;
static int ett_lix2_STIRSHAKENDestination;
static int ett_lix2_STIRSHAKENTN;
static int ett_lix2_ECNAMDisplayInfo;
static int ett_lix2_RCDDisplayInfo;
static int ett_lix2_RCSRegistration;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity;
static int ett_lix2_RCSMessage;
static int ett_lix2_RCSSessionEstablishment;
static int ett_lix2_RCSSessionModification;
static int ett_lix2_RCSSessionRelease;
static int ett_lix2_RCSCapabilityDiscovery;
static int ett_lix2_StartOfInterceptForRegisteredRCSUser;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSRegistrationInformation;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_AdditionalInstanceLocation;
static int ett_lix2_StartOfInterceptWithEstablisedRCSSession;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSDestinations;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSSIPSessionExchange;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSSessionContext;
static int ett_lix2_RCSCCPDU;
static int ett_lix2_AdditionalInstanceLocation;
static int ett_lix2_MSRPPath;
static int ett_lix2_RCSDestinations;
static int ett_lix2_RCSDestination;
static int ett_lix2_RCSIdentity;
static int ett_lix2_RCSRegistrationInformation;
static int ett_lix2_RCSSessionContext;
static int ett_lix2_RCSSIPRegistrationExchange;
static int ett_lix2_RCSSIPSessionExchange;
static int ett_lix2_RCSSIPSessionMessage;
static int ett_lix2_EESEECRegistration;
static int ett_lix2_EESEASDiscovery;
static int ett_lix2_EESEASDiscoverySubscription;
static int ett_lix2_EESEASDiscoveryNotification;
static int ett_lix2_EESAppContextRelocation;
static int ett_lix2_EESACRDetOrInit;
static int ett_lix2_ACRDetermineReq;
static int ett_lix2_ACRInitiateReq;
static int ett_lix2_EESACRSubscription;
static int ett_lix2_EESACRNotification;
static int ett_lix2_EESEECContextRelocation;
static int ett_lix2_EESStartOfInterceptionWithRegisteredEEC;
static int ett_lix2_ACProfiles;
static int ett_lix2_ACProfile;
static int ett_lix2_ACRScenarios;
static int ett_lix2_UnfulfilledACProfiles;
static int ett_lix2_UnfulfilledACProfile;
static int ett_lix2_EASsInfo;
static int ett_lix2_EASInfo;
static int ett_lix2_ServiceKPIs;
static int ett_lix2_EASDiscoveryFilter;
static int ett_lix2_EASsCharacteristics;
static int ett_lix2_EASCharacteristics;
static int ett_lix2_DNAIs;
static int ett_lix2_DiscoveredEAS;
static int ett_lix2_EASProfile;
static int ett_lix2_EASEndpoint;
static int ett_lix2_RouteToLocations;
static int ett_lix2_EASServiceFeatures;
static int ett_lix2_ACIDs;
static int ett_lix2_IPv4Addresses;
static int ett_lix2_IPv6Addresses;
static int ett_lix2_EASDynamicInfoFilter;
static int ett_lix2_EASIDs;
static int ett_lix2_TargetInfo;
static int ett_lix2_EDNConfigurationInfo;
static int ett_lix2_EDNConnectionInfo;
static int ett_lix2_EESsInfo;
static int ett_lix2_EESInfo;
static int ett_lix2_EESEndpoint;
static int ett_lix2_FiveGMSAFServiceAccessInformation;
static int ett_lix2_FiveGMSAFConsumptionReporting;
static int ett_lix2_FiveGMSAFDynamicPolicyInvocation;
static int ett_lix2_FiveGMSAFMetricsReporting;
static int ett_lix2_FiveGMSAFNetworkAssistance;
static int ett_lix2_FiveGMSAFUnsuccessfulProcedure;
static int ett_lix2_FiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE;
static int ett_lix2_NWDAFEventsSubscription;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent;
static int ett_lix2_NWDAFEventsNotification;
static int ett_lix2_NWDAFAnalyticsInfoQuery;
static int ett_lix2_NWDAFRoamingAnalyticsSubscription;
static int ett_lix2_NWDAFRoamingAnalyticsNotification;
static int ett_lix2_LALSReport;
static int ett_lix2_PDHeaderReport;
static int ett_lix2_PDSummaryReport;
static int ett_lix2_AMFIdentifierAssociation;
static int ett_lix2_MMEIdentifierAssociation;
static int ett_lix2_EPSRANHandoverCommand;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RANTargetToSourceContainer;
static int ett_lix2_EPSRANHandoverRequest;
static int ett_lix2_MMEAttach;
static int ett_lix2_MMEDetach;
static int ett_lix2_MMELocationUpdate;
static int ett_lix2_MMERANTraceReport;
static int ett_lix2_MMEStartOfInterceptionWithEPSAttachedUE;
static int ett_lix2_MMEUEServiceAccept;
static int ett_lix2_MMEUnsuccessfulProcedure;
static int ett_lix2_MMEPositioningInfoTransfer;
static int ett_lix2_BBFTunnelInformation;
static int ett_lix2_ConnectedENGNB;
static int ett_lix2_ConnectedENGNBList;
static int ett_lix2_EPSCSGInfo;
static int ett_lix2_EPSRANUEContext;
static int ett_lix2_EPSNASTransportInitialInformation;
static int ett_lix2_ERABQoSParameters;
static int ett_lix2_ERABContext;
static int ett_lix2_ERABContextList;
static int ett_lix2_ERABError;
static int ett_lix2_ERABReleaseList;
static int ett_lix2_LTENTNTAIInformation;
static int ett_lix2_MMEFailureCause;
static int ett_lix2_MMEServedGUMMEI;
static int ett_lix2_MMEServedGUMMEIList;
static int ett_lix2_S1Information;
static int ett_lix2_LINotification;
static int ett_lix2_SEQUENCE_OF_LIAppliedDeliveryInformation;
static int ett_lix2_LIAppliedDeliveryInformation;
static int ett_lix2_MDFCellSiteReport;
static int ett_lix2_EMM5GMMStatus;
static int ett_lix2_EPS5GGUTI;
static int ett_lix2_SeparatedLocationReporting;
static int ett_lix2_HSSServingSystemMessage;
static int ett_lix2_HSSStartOfInterceptionWithRegisteredTarget;
static int ett_lix2_HSSIdentities;
static int ett_lix2_SubscriptionDataSets;
static int ett_lix2_AllowedNSSAI;
static int ett_lix2_AllowedTACs;
static int ett_lix2_AreaOfInterest;
static int ett_lix2_AreaOfInterestCellList;
static int ett_lix2_AreaOfInterestItem;
static int ett_lix2_AreaOfInterestRANNodeList;
static int ett_lix2_AreaOfInterestTAIList;
static int ett_lix2_BroadcastPLMNItem;
static int ett_lix2_CellCAGList;
static int ett_lix2_EquivalentPLMNs;
static int ett_lix2_FiveGGUTI;
static int ett_lix2_FiveGSSubscriberID;
static int ett_lix2_FiveGSSubscriberIDs;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_FiveGSSubscriberID;
static int ett_lix2_FiveGSRVCCInfo;
static int ett_lix2_FiveGSUserStateInfo;
static int ett_lix2_ForbiddenAreaInformation;
static int ett_lix2_ForbiddenTACs;
static int ett_lix2_FTEID;
static int ett_lix2_FTEIDList;
static int ett_lix2_GPSI;
static int ett_lix2_GUAMI;
static int ett_lix2_GUMMEI;
static int ett_lix2_GUTI;
static int ett_lix2_HandoverCause;
static int ett_lix2_IMPU;
static int ett_lix2_IMSSubscriberIDs;
static int ett_lix2_IPAddress;
static int ett_lix2_LocationAreaOfInterestList;
static int ett_lix2_LocationReportingRequestType;
static int ett_lix2_MMEID;
static int ett_lix2_MobilityRestrictionList;
static int ett_lix2_NonIMEISVPEI;
static int ett_lix2_NPNAccessInformation;
static int ett_lix2_NSSAI;
static int ett_lix2_PLMNID;
static int ett_lix2_PLMNList;
static int ett_lix2_PDUSessionResourceInformation;
static int ett_lix2_PEI;
static int ett_lix2_RANNodeName;
static int ett_lix2_RATRestrictions;
static int ett_lix2_RATRestrictionItem;
static int ett_lix2_RejectedNSSAI;
static int ett_lix2_RejectedSNSSAI;
static int ett_lix2_ServiceAreaInformation;
static int ett_lix2_ServiceAreaInfo;
static int ett_lix2_Slice;
static int ett_lix2_SNSSAI;
static int ett_lix2_SubscriberIdentifier;
static int ett_lix2_SUCI;
static int ett_lix2_SUPI;
static int ett_lix2_SupportedTAList;
static int ett_lix2_TAItem;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_BroadcastPLMNItem;
static int ett_lix2_TAISliceSupportList;
static int ett_lix2_TargetIdentifier;
static int ett_lix2_UEContextInfo;
static int ett_lix2_UEEndpointAddress;
static int ett_lix2_UserIdentifiers;
static int ett_lix2_Location;
static int ett_lix2_CellSiteInformation;
static int ett_lix2_LocationInfo;
static int ett_lix2_SEQUENCE_OF_CellInformation;
static int ett_lix2_UserLocation;
static int ett_lix2_EUTRALocation;
static int ett_lix2_NRLocation;
static int ett_lix2_N3GALocation;
static int ett_lix2_UTRALocation;
static int ett_lix2_GERALocation;
static int ett_lix2_IMSLocation;
static int ett_lix2_SEQUENCE_OF_PANIHeaderInfo;
static int ett_lix2_SEQUENCE_OF_SIPGeolocationHeaderInfo;
static int ett_lix2_SEQUENCE_OF_SIPCNIHeaderInfo;
static int ett_lix2_IPAddr;
static int ett_lix2_GlobalRANNodeID;
static int ett_lix2_ANNodeID;
static int ett_lix2_TAI;
static int ett_lix2_CGI;
static int ett_lix2_LAI;
static int ett_lix2_SAI;
static int ett_lix2_RAI;
static int ett_lix2_ECGI;
static int ett_lix2_TACList;
static int ett_lix2_TAIList;
static int ett_lix2_NCGI;
static int ett_lix2_RANCGI;
static int ett_lix2_CellInformation;
static int ett_lix2_CellRadioRelatedInformation;
static int ett_lix2_TNAPID;
static int ett_lix2_TWAPID;
static int ett_lix2_NGENbID;
static int ett_lix2_ENbID;
static int ett_lix2_PositioningInfo;
static int ett_lix2_RawMLPResponse;
static int ett_lix2_LocationData;
static int ett_lix2_SET_OF_PositioningMethodAndUsage;
static int ett_lix2_SET_OF_GNSSPositioningMethodAndUsage;
static int ett_lix2_GERANPositioningInfo;
static int ett_lix2_UTRANPositioningInfo;
static int ett_lix2_FourGPositioningInfo;
static int ett_lix2_FourGLocationInfo;
static int ett_lix2_EPSLocationInformation;
static int ett_lix2_MMELocationInformation;
static int ett_lix2_UserCSGInformation;
static int ett_lix2_CSGIDList;
static int ett_lix2_SGSNLocationInformation;
static int ett_lix2_ESMLCCellInfo;
static int ett_lix2_LocationPresenceReport;
static int ett_lix2_SET_OF_AMFEventArea;
static int ett_lix2_SET_OF_AccessType;
static int ett_lix2_SET_OF_RMInfo;
static int ett_lix2_SET_OF_CMInfo;
static int ett_lix2_AMFEventArea;
static int ett_lix2_PresenceInfo;
static int ett_lix2_SET_OF_TAI;
static int ett_lix2_SET_OF_ECGI;
static int ett_lix2_SET_OF_NCGI;
static int ett_lix2_SET_OF_GlobalRANNodeID;
static int ett_lix2_LADNInfo;
static int ett_lix2_RMInfo;
static int ett_lix2_CMInfo;
static int ett_lix2_GeographicArea;
static int ett_lix2_VelocityEstimate;
static int ett_lix2_CivicAddress;
static int ett_lix2_PositioningMethodAndUsage;
static int ett_lix2_GNSSPositioningMethodAndUsage;
static int ett_lix2_Point;
static int ett_lix2_PointUncertaintyCircle;
static int ett_lix2_PointUncertaintyEllipse;
static int ett_lix2_Polygon;
static int ett_lix2_SET_SIZE_3_15_OF_GeographicalCoordinates;
static int ett_lix2_PointAltitude;
static int ett_lix2_PointAltitudeUncertainty;
static int ett_lix2_EllipsoidArc;
static int ett_lix2_GeographicalCoordinates;
static int ett_lix2_UncertaintyEllipse;
static int ett_lix2_HorizontalVelocity;
static int ett_lix2_HorizontalWithVerticalVelocity;
static int ett_lix2_HorizontalVelocityWithUncertainty;
static int ett_lix2_HorizontalWithVerticalVelocityAndUncertainty;
static int ett_lix2_PANIHeaderInfo;
static int ett_lix2_SEQUENCE_OF_SIPAccessInfo;
static int ett_lix2_SEQUENCE_OF_SIPLocationInfo;
static int ett_lix2_SIPGeolocationHeaderInfo;
static int ett_lix2_SIPCellularAccessInfo;
static int ett_lix2_SIPLocationInfo;
static int ett_lix2_SIPAccessNetworkInformation;
static int ett_lix2_SIPCNIHeaderInfo;
static int ett_lix2_SEQUENCE_OF_SIPCellularAccessInfo;
static int ett_lix2_SIPCellularNetworkInformation;
static int ett_lix2_NRNTNTAIInfo;
static int ett_lix2_SEQUENCE_SIZE_1_MAX_OF_TAC;
static int ett_lix2_IABMTUserLocation;
static int ett_lix2_RCSPayload;
static int ett_lix2_EncapsulatedRCSPayload;
static int ett_lix2_ModifiedRCSPayload;
static int ett_lix2_PayloadModifications;
static int ett_lix2_SEQUENCE_OF_PayloadModification;
static int ett_lix2_PayloadModification;
static int ett_lix2_PayloadModificationDescription;
static int ett_lix2_ModificationLocation;
static int ett_lix2_ModificationType;
static int ett_lix2_PayloadInformationRemoved;
static int ett_lix2_PayloadInformationReplacedWithCharacters;
static int ett_lix2_IndexRange;
static int ett_lix2_MSRPMessage;
static int ett_lix2_SBIType;
static int ett_lix2_XMLType;
static int ett_lix2_MIMEEntity;
static int ett_lix2_MIMEPartIdentifier;
static int ett_lix2_MIMEBody;
static int ett_lix2_ExternalASNType;
static int ett_lix2_ExternalASNValue;



static int
dissect_lix2_RELATIVE_OID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_relative_oid(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}


static const value_string lix2_AMFRegistrationType_vals[] = {
  {   1, "initial" },
  {   2, "mobility" },
  {   3, "periodic" },
  {   4, "emergency" },
  {   5, "sNPNOnboarding" },
  {   6, "disasterMobility" },
  {   7, "disasterInitial" },
  { 0, NULL }
};


static int
dissect_lix2_AMFRegistrationType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_AMFRegistrationResult_vals[] = {
  {   1, "threeGPPAccess" },
  {   2, "nonThreeGPPAccess" },
  {   3, "threeGPPAndNonThreeGPPAccess" },
  { 0, NULL }
};


static int
dissect_lix2_AMFRegistrationResult(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_INTEGER_0_255(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_OCTET_STRING_SIZE_3(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t SNSSAI_sequence[] = {
  { &hf_lix2_sliceServiceType, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_255 },
  { &hf_lix2_sliceDifferentiator, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_3 },
  { &hf_lix2_mappedHPLMNSliceServiceType, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_255 },
  { &hf_lix2_mappedHPLMNSliceDifferentiator, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_3 },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SNSSAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SNSSAI_sequence, hf_index, ett_lix2_SNSSAI);

  return offset;
}


static const ber_sequence_t NSSAI_sequence_of[1] = {
  { &hf_lix2_NSSAI_item     , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_SNSSAI },
};

static int
dissect_lix2_NSSAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      NSSAI_sequence_of, hf_index, ett_lix2_NSSAI);

  return offset;
}



static int
dissect_lix2_RejectedSliceCauseValue(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t RejectedSNSSAI_sequence[] = {
  { &hf_lix2_causeValue     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RejectedSliceCauseValue },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RejectedSNSSAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RejectedSNSSAI_sequence, hf_index, ett_lix2_RejectedSNSSAI);

  return offset;
}


static const ber_sequence_t RejectedNSSAI_sequence_of[1] = {
  { &hf_lix2_RejectedNSSAI_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_RejectedSNSSAI },
};

static int
dissect_lix2_RejectedNSSAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      RejectedNSSAI_sequence_of, hf_index, ett_lix2_RejectedNSSAI);

  return offset;
}


static const ber_sequence_t Slice_sequence[] = {
  { &hf_lix2_allowedNSSAI_01, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NSSAI },
  { &hf_lix2_configuredNSSAI, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NSSAI },
  { &hf_lix2_rejectedNSSAI  , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RejectedNSSAI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_Slice(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   Slice_sequence, hf_index, ett_lix2_Slice);

  return offset;
}



static int
dissect_lix2_IMSI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  unsigned tvb_len;

  /*
   * Derived from the International Mobile Subscription Identity defined in TS 23.003 [19] clause 2.1 and clause 2.2.
   */

  tvb_len = tvb_reported_length(tvb);

  dissect_e212_utf8_imsi(tvb, actx->pinfo, tree, offset, tvb_len);

  offset = tvb_len;


  return offset;
}



static int
dissect_lix2_NAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_SUPI_vals[] = {
  {   1, "iMSI" },
  {   2, "nAI" },
  { 0, NULL }
};

static const ber_choice_t SUPI_choice[] = {
  {   1, &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  {   2, &hf_lix2_nAI            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SUPI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 SUPI_choice, hf_index, ett_lix2_SUPI,
                                 NULL);

  return offset;
}



static int
dissect_lix2_MCC(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_NumericString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_MNC(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_NumericString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_RoutingIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_ProtectionSchemeID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_HomeNetworkPublicKeyID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_SchemeOutput(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_INTEGER_1_4(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_SUPIType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_HomeNetworkIdentifier(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t SUCI_sequence[] = {
  { &hf_lix2_mCC            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MCC },
  { &hf_lix2_mNC            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MNC },
  { &hf_lix2_routingIndicator, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RoutingIndicator },
  { &hf_lix2_protectionSchemeID, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_ProtectionSchemeID },
  { &hf_lix2_homeNetworkPublicKeyID, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_HomeNetworkPublicKeyID },
  { &hf_lix2_schemeOutput   , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_SchemeOutput },
  { &hf_lix2_routingIndicatorLength, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_1_4 },
  { &hf_lix2_sUPIType       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUPIType },
  { &hf_lix2_homeNetworkIdentifier, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HomeNetworkIdentifier },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SUCI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SUCI_sequence, hf_index, ett_lix2_SUCI);

  return offset;
}



static int
dissect_lix2_IMEI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_NumericString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_IMEISV(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_NumericString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_MACAddress(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_EUI64(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_PEI_vals[] = {
  {   1, "iMEI" },
  {   2, "iMEISV" },
  {   3, "mACAddress" },
  {   4, "eUI64" },
  { 0, NULL }
};

static const ber_choice_t PEI_choice[] = {
  {   1, &hf_lix2_iMEI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  {   2, &hf_lix2_iMEISV         , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_IMEISV },
  {   3, &hf_lix2_mACAddress     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_MACAddress },
  {   4, &hf_lix2_eUI64          , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_EUI64 },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PEI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 PEI_choice, hf_index, ett_lix2_PEI,
                                 NULL);

  return offset;
}



static int
dissect_lix2_MSISDN(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  unsigned tvb_len;

  /*
   * Derived from the MSISDN defined in TS 23.003 [19] clause 3.3.
   */

  tvb_len = tvb_reported_length(tvb);

  //dissect_e212_utf8_imsi(tvb, actx->pinfo, tree, offset, tvb_len);
  dissect_e164_msisdn(tvb, tree, offset, tvb_len, E164_ENC_UTF8);

  offset = tvb_len;



  return offset;
}


static const value_string lix2_GPSI_vals[] = {
  {   1, "mSISDN" },
  {   2, "nAI" },
  { 0, NULL }
};

static const ber_choice_t GPSI_choice[] = {
  {   1, &hf_lix2_mSISDN         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  {   2, &hf_lix2_nAI            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GPSI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 GPSI_choice, hf_index, ett_lix2_GPSI,
                                 NULL);

  return offset;
}



static int
dissect_lix2_AMFRegionID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_AMFSetID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_AMFPointer(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_FiveGTMSI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t FiveGGUTI_sequence[] = {
  { &hf_lix2_mCC            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MCC },
  { &hf_lix2_mNC            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MNC },
  { &hf_lix2_aMFRegionID    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRegionID },
  { &hf_lix2_aMFSetID       , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_AMFSetID },
  { &hf_lix2_aMFPointer     , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_AMFPointer },
  { &hf_lix2_fiveGTMSI      , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGTMSI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGGUTI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGGUTI_sequence, hf_index, ett_lix2_FiveGGUTI);

  return offset;
}


static const ber_sequence_t PLMNID_sequence[] = {
  { &hf_lix2_mCC            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MCC },
  { &hf_lix2_mNC            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MNC },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PLMNID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PLMNID_sequence, hf_index, ett_lix2_PLMNID);

  return offset;
}



static int
dissect_lix2_TAC(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_NID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t TAI_sequence[] = {
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_tAC            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_TAC },
  { &hf_lix2_nID            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_TAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   TAI_sequence, hf_index, ett_lix2_TAI);

  return offset;
}



static int
dissect_lix2_EUTRACellID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}


static const ber_sequence_t ECGI_sequence[] = {
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_eUTRACellID    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EUTRACellID },
  { &hf_lix2_nID            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ECGI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ECGI_sequence, hf_index, ett_lix2_ECGI);

  return offset;
}



static int
dissect_lix2_AgeOfLocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_Timestamp(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_GeneralizedTime(implicit_tag, actx, tree, tvb, offset, hf_index);

  return offset;
}



static int
dissect_lix2_UTF8String(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_N3IWFIDSBI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_GNbID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}



static int
dissect_lix2_BIT_STRING_SIZE_20(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}



static int
dissect_lix2_BIT_STRING_SIZE_18(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}



static int
dissect_lix2_BIT_STRING_SIZE_21(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}


static const value_string lix2_NGENbID_vals[] = {
  {   1, "macroNGENbID" },
  {   2, "shortMacroNGENbID" },
  {   3, "longMacroNGENbID" },
  { 0, NULL }
};

static const ber_choice_t NGENbID_choice[] = {
  {   1, &hf_lix2_macroNGENbID   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_20 },
  {   2, &hf_lix2_shortMacroNGENbID, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_18 },
  {   3, &hf_lix2_longMacroNGENbID, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_21 },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NGENbID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 NGENbID_choice, hf_index, ett_lix2_NGENbID,
                                 NULL);

  return offset;
}



static int
dissect_lix2_BIT_STRING_SIZE_28(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}


static const value_string lix2_ENbID_vals[] = {
  {   1, "macroENbID" },
  {   2, "homeENbID" },
  {   3, "shortMacroENbID" },
  {   4, "longMacroENbID" },
  { 0, NULL }
};

static const ber_choice_t ENbID_choice[] = {
  {   1, &hf_lix2_macroENbID     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_20 },
  {   2, &hf_lix2_homeENbID      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_28 },
  {   3, &hf_lix2_shortMacroENbID, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_18 },
  {   4, &hf_lix2_longMacroENbID , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_21 },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ENbID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 ENbID_choice, hf_index, ett_lix2_ENbID,
                                 NULL);

  return offset;
}



static int
dissect_lix2_WAGFID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_TNGFID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_ANNodeID_vals[] = {
  {   1, "n3IWFID" },
  {   2, "gNbID" },
  {   3, "nGENbID" },
  {   4, "eNbID" },
  {   5, "wAGFID" },
  {   6, "tNGFID" },
  { 0, NULL }
};

static const ber_choice_t ANNodeID_choice[] = {
  {   1, &hf_lix2_n3IWFID_01     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_N3IWFIDSBI },
  {   2, &hf_lix2_gNbID          , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_GNbID },
  {   3, &hf_lix2_nGENbID        , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_NGENbID },
  {   4, &hf_lix2_eNbID          , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_ENbID },
  {   5, &hf_lix2_wAGFID         , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_WAGFID },
  {   6, &hf_lix2_tNGFID         , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_TNGFID },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ANNodeID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 ANNodeID_choice, hf_index, ett_lix2_ANNodeID,
                                 NULL);

  return offset;
}


static const ber_sequence_t GlobalRANNodeID_sequence[] = {
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_aNNodeID       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_ANNodeID },
  { &hf_lix2_nID            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GlobalRANNodeID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   GlobalRANNodeID_sequence, hf_index, ett_lix2_GlobalRANNodeID);

  return offset;
}



static int
dissect_lix2_OGCURN(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t GeographicalCoordinates_sequence[] = {
  { &hf_lix2_latitude       , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_longitude      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_mapDatumInformation, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OGCURN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GeographicalCoordinates(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   GeographicalCoordinates_sequence, hf_index, ett_lix2_GeographicalCoordinates);

  return offset;
}



static int
dissect_lix2_INTEGER_0_359(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t CellSiteInformation_sequence[] = {
  { &hf_lix2_geographicalCoordinates, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GeographicalCoordinates },
  { &hf_lix2_azimuth        , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_359 },
  { &hf_lix2_operatorSpecificInformation, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_CellSiteInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   CellSiteInformation_sequence, hf_index, ett_lix2_CellSiteInformation);

  return offset;
}



static int
dissect_lix2_BOOLEAN(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}


static const ber_sequence_t EUTRALocation_sequence[] = {
  { &hf_lix2_tAI            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_TAI },
  { &hf_lix2_eCGI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_ECGI },
  { &hf_lix2_ageOfLocationInfo, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AgeOfLocation },
  { &hf_lix2_uELocationTimestamp, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_geographicalInformation, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_geodeticInformation, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_globalNGENbID  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GlobalRANNodeID },
  { &hf_lix2_cellSiteInformation, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CellSiteInformation },
  { &hf_lix2_globalENbID    , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GlobalRANNodeID },
  { &hf_lix2_ignoreTAI      , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_ignoreECGI     , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EUTRALocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EUTRALocation_sequence, hf_index, ett_lix2_EUTRALocation);

  return offset;
}



static int
dissect_lix2_NRCellID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}


static const ber_sequence_t NCGI_sequence[] = {
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_nRCellID       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NRCellID },
  { &hf_lix2_nID            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NCGI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NCGI_sequence, hf_index, ett_lix2_NCGI);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_TAC_sequence_of[1] = {
  { &hf_lix2_tACListNRNTN_item, BER_CLASS_UNI, BER_UNI_TAG_OCTETSTRING, BER_FLAGS_NOOWNTAG, dissect_lix2_TAC },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_TAC(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_TAC_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_TAC);

  return offset;
}


static const ber_sequence_t NRNTNTAIInfo_sequence[] = {
  { &hf_lix2_servingPLMN    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_tACListNRNTN   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_TAC },
  { &hf_lix2_uELocationDerivedNTNTAC, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAC },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NRNTNTAIInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NRNTNTAIInfo_sequence, hf_index, ett_lix2_NRNTNTAIInfo);

  return offset;
}


static const ber_sequence_t IABMTUserLocation_sequence[] = {
  { &hf_lix2_nRCGI          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NCGI },
  { &hf_lix2_tAI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IABMTUserLocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   IABMTUserLocation_sequence, hf_index, ett_lix2_IABMTUserLocation);

  return offset;
}


static const ber_sequence_t NRLocation_sequence[] = {
  { &hf_lix2_tAI            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_TAI },
  { &hf_lix2_nCGI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NCGI },
  { &hf_lix2_ageOfLocationInfo, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AgeOfLocation },
  { &hf_lix2_uELocationTimestamp, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_geographicalInformation, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_geodeticInformation, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_globalGNbID    , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GlobalRANNodeID },
  { &hf_lix2_cellSiteInformation, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CellSiteInformation },
  { &hf_lix2_ignoreNCGI     , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_nRNTNTAIInfo   , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NRNTNTAIInfo },
  { &hf_lix2_iABMTUserLocation, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IABMTUserLocation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NRLocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NRLocation_sequence, hf_index, ett_lix2_NRLocation);

  return offset;
}



static int
dissect_lix2_N3IWFIDNGAP(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}



static int
dissect_lix2_IPv4Address(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_IPv6Address(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t IPAddr_sequence[] = {
  { &hf_lix2_iPv4Addr       , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv4Address },
  { &hf_lix2_iPv6Addr       , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv6Address },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IPAddr(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   IPAddr_sequence, hf_index, ett_lix2_IPAddr);

  return offset;
}



static int
dissect_lix2_INTEGER(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_SSID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_BSSID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_CivicAddressBytes(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t TNAPID_sequence[] = {
  { &hf_lix2_sSID           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SSID },
  { &hf_lix2_bSSID          , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BSSID },
  { &hf_lix2_civicAddress   , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CivicAddressBytes },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_TNAPID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   TNAPID_sequence, hf_index, ett_lix2_TNAPID);

  return offset;
}


static const ber_sequence_t TWAPID_sequence[] = {
  { &hf_lix2_sSID           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SSID },
  { &hf_lix2_bSSID          , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BSSID },
  { &hf_lix2_civicAddress   , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CivicAddressBytes },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_TWAPID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   TWAPID_sequence, hf_index, ett_lix2_TWAPID);

  return offset;
}



static int
dissect_lix2_HFCNodeID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_GLI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_W5GBANLineType_vals[] = {
  {   1, "dSL" },
  {   2, "pON" },
  { 0, NULL }
};


static int
dissect_lix2_W5GBANLineType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_GCI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_TransportProtocol_vals[] = {
  {   1, "uDP" },
  {   2, "tCP" },
  { 0, NULL }
};


static int
dissect_lix2_TransportProtocol(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t N3GALocation_sequence[] = {
  { &hf_lix2_tAI            , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAI },
  { &hf_lix2_n3IWFID        , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_N3IWFIDNGAP },
  { &hf_lix2_uEIPAddr       , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPAddr },
  { &hf_lix2_portNumber_01  , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_tNAPID         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TNAPID },
  { &hf_lix2_tWAPID         , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TWAPID },
  { &hf_lix2_hFCNodeID      , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HFCNodeID },
  { &hf_lix2_gLI            , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GLI },
  { &hf_lix2_w5GBANLineType , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_W5GBANLineType },
  { &hf_lix2_gCI            , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GCI },
  { &hf_lix2_ageOfLocationInfo, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AgeOfLocation },
  { &hf_lix2_uELocationTimestamp, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_protocol_02    , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TransportProtocol },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_N3GALocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   N3GALocation_sequence, hf_index, ett_lix2_N3GALocation);

  return offset;
}



static int
dissect_lix2_LAC(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t LAI_sequence[] = {
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_lAC            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_LAC },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LAI_sequence, hf_index, ett_lix2_LAI);

  return offset;
}



static int
dissect_lix2_CellID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t CGI_sequence[] = {
  { &hf_lix2_lAI            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_LAI },
  { &hf_lix2_cellID         , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_CellID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_CGI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   CGI_sequence, hf_index, ett_lix2_CGI);

  return offset;
}



static int
dissect_lix2_SAC(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t SAI_sequence[] = {
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_lAC            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_LAC },
  { &hf_lix2_sAC            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SAC },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SAI_sequence, hf_index, ett_lix2_SAI);

  return offset;
}



static int
dissect_lix2_RAC(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t RAI_sequence[] = {
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_lAC            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_LAC },
  { &hf_lix2_rAC            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RAC },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RAI_sequence, hf_index, ett_lix2_RAI);

  return offset;
}


static const ber_sequence_t UTRALocation_sequence[] = {
  { &hf_lix2_cGI            , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CGI },
  { &hf_lix2_sAI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SAI },
  { &hf_lix2_lAI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LAI },
  { &hf_lix2_rAI            , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RAI },
  { &hf_lix2_ageOfLocationInfo_01, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_uELocationTimestamp, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_geographicalInformation, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_geodeticInformation, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_cellSiteInformation, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CellSiteInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UTRALocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UTRALocation_sequence, hf_index, ett_lix2_UTRALocation);

  return offset;
}



static int
dissect_lix2_E164Number(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_NumericString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t GERALocation_sequence[] = {
  { &hf_lix2_locationNumber , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_E164Number },
  { &hf_lix2_cGI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CGI },
  { &hf_lix2_rAI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RAI },
  { &hf_lix2_sAI            , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SAI },
  { &hf_lix2_lAI            , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LAI },
  { &hf_lix2_vLRNumber      , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_mSCNumber      , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_ageOfLocationInfo_01, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_uELocationTimestamp, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_geographicalInformation, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_geodeticInformation, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_cellSiteInformation, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CellSiteInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GERALocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   GERALocation_sequence, hf_index, ett_lix2_GERALocation);

  return offset;
}


static const ber_sequence_t UserLocation_sequence[] = {
  { &hf_lix2_eUTRALocation  , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EUTRALocation },
  { &hf_lix2_nRLocation     , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NRLocation },
  { &hf_lix2_n3GALocation   , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_N3GALocation },
  { &hf_lix2_uTRALocation   , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTRALocation },
  { &hf_lix2_gERALocation   , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GERALocation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UserLocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UserLocation_sequence, hf_index, ett_lix2_UserLocation);

  return offset;
}


static const ber_sequence_t Point_sequence[] = {
  { &hf_lix2_geographicalCoordinates, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GeographicalCoordinates },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_Point(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   Point_sequence, hf_index, ett_lix2_Point);

  return offset;
}



static int
dissect_lix2_Uncertainty(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_UncertaintySBI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t PointUncertaintyCircle_sequence[] = {
  { &hf_lix2_geographicalCoordinates, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GeographicalCoordinates },
  { &hf_lix2_deprecatedUncertainty, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Uncertainty },
  { &hf_lix2_uncertaintySBI , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UncertaintySBI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PointUncertaintyCircle(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PointUncertaintyCircle_sequence, hf_index, ett_lix2_PointUncertaintyCircle);

  return offset;
}



static int
dissect_lix2_Orientation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t UncertaintyEllipse_sequence[] = {
  { &hf_lix2_deprecatedSemiMajor, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_Uncertainty },
  { &hf_lix2_deprecatedSemiMinor, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Uncertainty },
  { &hf_lix2_orientationMajor, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_Orientation },
  { &hf_lix2_semiMajorSBI   , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UncertaintySBI },
  { &hf_lix2_semiMinorSBI   , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UncertaintySBI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UncertaintyEllipse(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UncertaintyEllipse_sequence, hf_index, ett_lix2_UncertaintyEllipse);

  return offset;
}



static int
dissect_lix2_Confidence(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t PointUncertaintyEllipse_sequence[] = {
  { &hf_lix2_geographicalCoordinates, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GeographicalCoordinates },
  { &hf_lix2_uncertainty    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UncertaintyEllipse },
  { &hf_lix2_confidence     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_Confidence },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PointUncertaintyEllipse(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PointUncertaintyEllipse_sequence, hf_index, ett_lix2_PointUncertaintyEllipse);

  return offset;
}


static const ber_sequence_t SET_SIZE_3_15_OF_GeographicalCoordinates_set_of[1] = {
  { &hf_lix2_pointList_item , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_GeographicalCoordinates },
};

static int
dissect_lix2_SET_SIZE_3_15_OF_GeographicalCoordinates(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_SIZE_3_15_OF_GeographicalCoordinates_set_of, hf_index, ett_lix2_SET_SIZE_3_15_OF_GeographicalCoordinates);

  return offset;
}


static const ber_sequence_t Polygon_sequence[] = {
  { &hf_lix2_pointList      , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SET_SIZE_3_15_OF_GeographicalCoordinates },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_Polygon(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   Polygon_sequence, hf_index, ett_lix2_Polygon);

  return offset;
}



static int
dissect_lix2_Altitude(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t PointAltitude_sequence[] = {
  { &hf_lix2_point_01       , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GeographicalCoordinates },
  { &hf_lix2_altitude       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Altitude },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PointAltitude(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PointAltitude_sequence, hf_index, ett_lix2_PointAltitude);

  return offset;
}


static const ber_sequence_t PointAltitudeUncertainty_sequence[] = {
  { &hf_lix2_point_01       , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GeographicalCoordinates },
  { &hf_lix2_altitude       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Altitude },
  { &hf_lix2_uncertaintyEllipse, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UncertaintyEllipse },
  { &hf_lix2_deprecatedUncertaintyAltitude, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_Uncertainty },
  { &hf_lix2_confidence     , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_Confidence },
  { &hf_lix2_uncertaintyAltitudeSBI, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UncertaintySBI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PointAltitudeUncertainty(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PointAltitudeUncertainty_sequence, hf_index, ett_lix2_PointAltitudeUncertainty);

  return offset;
}



static int
dissect_lix2_InnerRadius(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_Angle(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t EllipsoidArc_sequence[] = {
  { &hf_lix2_point_01       , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GeographicalCoordinates },
  { &hf_lix2_innerRadius    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_InnerRadius },
  { &hf_lix2_deprecatedUncertaintyRadius, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_Uncertainty },
  { &hf_lix2_offsetAngle    , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_Angle },
  { &hf_lix2_includedAngle  , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_Angle },
  { &hf_lix2_confidence     , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_Confidence },
  { &hf_lix2_uncertaintyRadiusSBI, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UncertaintySBI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EllipsoidArc(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EllipsoidArc_sequence, hf_index, ett_lix2_EllipsoidArc);

  return offset;
}


static const value_string lix2_GeographicArea_vals[] = {
  {   1, "point" },
  {   2, "pointUncertaintyCircle" },
  {   3, "pointUncertaintyEllipse" },
  {   4, "polygon" },
  {   5, "pointAltitude" },
  {   6, "pointAltitudeUncertainty" },
  {   7, "ellipsoidArc" },
  { 0, NULL }
};

static const ber_choice_t GeographicArea_choice[] = {
  {   1, &hf_lix2_point          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_Point },
  {   2, &hf_lix2_pointUncertaintyCircle, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PointUncertaintyCircle },
  {   3, &hf_lix2_pointUncertaintyEllipse, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PointUncertaintyEllipse },
  {   4, &hf_lix2_polygon        , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_Polygon },
  {   5, &hf_lix2_pointAltitude  , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PointAltitude },
  {   6, &hf_lix2_pointAltitudeUncertainty, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_PointAltitudeUncertainty },
  {   7, &hf_lix2_ellipsoidArc   , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_EllipsoidArc },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GeographicArea(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 GeographicArea_choice, hf_index, ett_lix2_GeographicArea,
                                 NULL);

  return offset;
}


static const value_string lix2_RATType_vals[] = {
  {   1, "nR" },
  {   2, "eUTRA" },
  {   3, "wLAN" },
  {   4, "virtual" },
  {   5, "nBIOT" },
  {   6, "wireline" },
  {   7, "wirelineCable" },
  {   8, "wirelineBBF" },
  {   9, "lTEM" },
  {  10, "nRU" },
  {  11, "eUTRAU" },
  {  12, "trustedN3GA" },
  {  13, "trustedWLAN" },
  {  14, "uTRA" },
  {  15, "gERA" },
  {  16, "nRLEO" },
  {  17, "nRMEO" },
  {  18, "nRGEO" },
  {  19, "nROTHERSAT" },
  {  20, "nRREDCAP" },
  { 0, NULL }
};


static int
dissect_lix2_RATType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_TimeZone(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_RANCGI_vals[] = {
  {   1, "eCGI" },
  {   2, "nCGI" },
  {   3, "cGI" },
  { 0, NULL }
};

static const ber_choice_t RANCGI_choice[] = {
  {   1, &hf_lix2_eCGI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_ECGI },
  {   2, &hf_lix2_nCGI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NCGI },
  {   3, &hf_lix2_cGI            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_CGI },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RANCGI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 RANCGI_choice, hf_index, ett_lix2_RANCGI,
                                 NULL);

  return offset;
}



static int
dissect_lix2_OCTET_STRING(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_RANNodeName_vals[] = {
  {   1, "rANNodeNameVisible" },
  {   2, "rANNodeNameUTF8" },
  { 0, NULL }
};

static const ber_choice_t RANNodeName_choice[] = {
  {   1, &hf_lix2_rANNodeNameVisible, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  {   2, &hf_lix2_rANNodeNameUTF8, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RANNodeName(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 RANNodeName_choice, hf_index, ett_lix2_RANNodeName,
                                 NULL);

  return offset;
}


static const ber_sequence_t TAISliceSupportList_sequence_of[1] = {
  { &hf_lix2_TAISliceSupportList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_SNSSAI },
};

static int
dissect_lix2_TAISliceSupportList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      TAISliceSupportList_sequence_of, hf_index, ett_lix2_TAISliceSupportList);

  return offset;
}


static const ber_sequence_t BroadcastPLMNItem_sequence[] = {
  { &hf_lix2_pLMNIdentity   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_tAISliceSupportList, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_TAISliceSupportList },
  { &hf_lix2_nPNSupport     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_NID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_BroadcastPLMNItem(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   BroadcastPLMNItem_sequence, hf_index, ett_lix2_BroadcastPLMNItem);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_BroadcastPLMNItem_sequence_of[1] = {
  { &hf_lix2_broadcastPLMNList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_BroadcastPLMNItem },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_BroadcastPLMNItem(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_BroadcastPLMNItem_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_BroadcastPLMNItem);

  return offset;
}


static const value_string lix2_RATInformation_vals[] = {
  {   1, "unlicensed" },
  {   2, "nBIoT" },
  {   3, "nRLEO" },
  {   4, "nRMEO" },
  {   5, "nRGEO" },
  {   6, "nROTHERSAT" },
  { 0, NULL }
};


static int
dissect_lix2_RATInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t TAItem_sequence[] = {
  { &hf_lix2_tAC            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_TAC },
  { &hf_lix2_broadcastPLMNList, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_BroadcastPLMNItem },
  { &hf_lix2_rATinformation , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_TAItem(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   TAItem_sequence, hf_index, ett_lix2_TAItem);

  return offset;
}


static const ber_sequence_t SupportedTAList_sequence_of[1] = {
  { &hf_lix2_SupportedTAList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_TAItem },
};

static int
dissect_lix2_SupportedTAList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SupportedTAList_sequence_of, hf_index, ett_lix2_SupportedTAList);

  return offset;
}


static const ber_sequence_t PLMNSupportItem_sequence[] = {
  { &hf_lix2_pLMNIdentity   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_nPNSupport     , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NID },
  { &hf_lix2_onboardingSupport, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PLMNSupportItem(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PLMNSupportItem_sequence, hf_index, ett_lix2_PLMNSupportItem);

  return offset;
}


static const ber_sequence_t PLMNSupportList_sequence_of[1] = {
  { &hf_lix2_PLMNSupportList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PLMNSupportItem },
};

static int
dissect_lix2_PLMNSupportList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      PLMNSupportList_sequence_of, hf_index, ett_lix2_PLMNSupportList);

  return offset;
}


static const ber_sequence_t NGInformation_sequence[] = {
  { &hf_lix2_globalRANNodeID, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GlobalRANNodeID },
  { &hf_lix2_rANNodeName    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RANNodeName },
  { &hf_lix2_supportedTAList, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SupportedTAList },
  { &hf_lix2_extendedRANNodeName, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RANNodeName },
  { &hf_lix2_pLMNSupportList, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNSupportList },
  { &hf_lix2_iABSupported   , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NGInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NGInformation_sequence, hf_index, ett_lix2_NGInformation);

  return offset;
}



static int
dissect_lix2_INTEGER_0_68719476735(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer64(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_RANCGI_sequence_of[1] = {
  { &hf_lix2_gNBDUServedCells_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RANCGI },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RANCGI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_RANCGI_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RANCGI);

  return offset;
}


static const ber_sequence_t F1Information_sequence[] = {
  { &hf_lix2_gNBDUID        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_68719476735 },
  { &hf_lix2_gNBDUName      , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_gNBCUName      , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_gNBDUServedCells, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RANCGI },
  { &hf_lix2_extendedGNBDUName, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_extendedGNBCUName, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_F1Information(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   F1Information_sequence, hf_index, ett_lix2_F1Information);

  return offset;
}


static const value_string lix2_CellRadioRelatedInformation_vals[] = {
  {   1, "nGInformation" },
  {   2, "f1Information" },
  { 0, NULL }
};

static const ber_choice_t CellRadioRelatedInformation_choice[] = {
  {   1, &hf_lix2_nGInformation  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NGInformation },
  {   2, &hf_lix2_f1Information  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_F1Information },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_CellRadioRelatedInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 CellRadioRelatedInformation_choice, hf_index, ett_lix2_CellRadioRelatedInformation,
                                 NULL);

  return offset;
}



static int
dissect_lix2_RFBand(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t CellInformation_sequence[] = {
  { &hf_lix2_rANCGI         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RANCGI },
  { &hf_lix2_cellSiteinformation, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CellSiteInformation },
  { &hf_lix2_timeOfLocation , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_cellRadioRelatedInformation, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_CellRadioRelatedInformation },
  { &hf_lix2_band           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RFBand },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_CellInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   CellInformation_sequence, hf_index, ett_lix2_CellInformation);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_CellInformation_sequence_of[1] = {
  { &hf_lix2_additionalCellIDs_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_CellInformation },
};

static int
dissect_lix2_SEQUENCE_OF_CellInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_CellInformation_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_CellInformation);

  return offset;
}


static const ber_sequence_t LocationInfo_sequence[] = {
  { &hf_lix2_userLocation   , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UserLocation },
  { &hf_lix2_currentLoc     , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_geoInfo        , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GeographicArea },
  { &hf_lix2_rATType        , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_timeZone       , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TimeZone },
  { &hf_lix2_additionalCellIDs, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_CellInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LocationInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LocationInfo_sequence, hf_index, ett_lix2_LocationInfo);

  return offset;
}


static const value_string lix2_AccuracyFulfilmentIndicator_vals[] = {
  {   1, "requestedAccuracyFulfilled" },
  {   2, "requestedAccuracyNotFulfilled" },
  { 0, NULL }
};


static int
dissect_lix2_AccuracyFulfilmentIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_HorizontalSpeed(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t HorizontalVelocity_sequence[] = {
  { &hf_lix2_hSpeed         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_HorizontalSpeed },
  { &hf_lix2_bearing        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Angle },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_HorizontalVelocity(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   HorizontalVelocity_sequence, hf_index, ett_lix2_HorizontalVelocity);

  return offset;
}



static int
dissect_lix2_VerticalSpeed(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_VerticalDirection_vals[] = {
  {   1, "upward" },
  {   2, "downward" },
  { 0, NULL }
};


static int
dissect_lix2_VerticalDirection(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t HorizontalWithVerticalVelocity_sequence[] = {
  { &hf_lix2_hSpeed         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_HorizontalSpeed },
  { &hf_lix2_bearing        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Angle },
  { &hf_lix2_vSpeed         , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_VerticalSpeed },
  { &hf_lix2_vDirection     , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_VerticalDirection },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_HorizontalWithVerticalVelocity(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   HorizontalWithVerticalVelocity_sequence, hf_index, ett_lix2_HorizontalWithVerticalVelocity);

  return offset;
}



static int
dissect_lix2_SpeedUncertainty(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t HorizontalVelocityWithUncertainty_sequence[] = {
  { &hf_lix2_hSpeed         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_HorizontalSpeed },
  { &hf_lix2_bearing        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Angle },
  { &hf_lix2_uncertainty_01 , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SpeedUncertainty },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_HorizontalVelocityWithUncertainty(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   HorizontalVelocityWithUncertainty_sequence, hf_index, ett_lix2_HorizontalVelocityWithUncertainty);

  return offset;
}


static const ber_sequence_t HorizontalWithVerticalVelocityAndUncertainty_sequence[] = {
  { &hf_lix2_hSpeed         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_HorizontalSpeed },
  { &hf_lix2_bearing        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Angle },
  { &hf_lix2_vSpeed         , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_VerticalSpeed },
  { &hf_lix2_vDirection     , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_VerticalDirection },
  { &hf_lix2_hUncertainty   , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_SpeedUncertainty },
  { &hf_lix2_vUncertainty   , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_SpeedUncertainty },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_HorizontalWithVerticalVelocityAndUncertainty(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   HorizontalWithVerticalVelocityAndUncertainty_sequence, hf_index, ett_lix2_HorizontalWithVerticalVelocityAndUncertainty);

  return offset;
}


static const value_string lix2_VelocityEstimate_vals[] = {
  {   1, "horVelocity" },
  {   2, "horWithVertVelocity" },
  {   3, "horVelocityWithUncertainty" },
  {   4, "horWithVertVelocityAndUncertainty" },
  { 0, NULL }
};

static const ber_choice_t VelocityEstimate_choice[] = {
  {   1, &hf_lix2_horVelocity    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_HorizontalVelocity },
  {   2, &hf_lix2_horWithVertVelocity, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_HorizontalWithVerticalVelocity },
  {   3, &hf_lix2_horVelocityWithUncertainty, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_HorizontalVelocityWithUncertainty },
  {   4, &hf_lix2_horWithVertVelocityAndUncertainty, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_HorizontalWithVerticalVelocityAndUncertainty },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_VelocityEstimate(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 VelocityEstimate_choice, hf_index, ett_lix2_VelocityEstimate,
                                 NULL);

  return offset;
}


static const ber_sequence_t CivicAddress_sequence[] = {
  { &hf_lix2_country_01     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_a1             , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_a2             , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_a3             , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_a4             , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_a5             , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_a6             , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_prd            , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pod            , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_sts            , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_hno            , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_hns            , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_lmk            , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_loc            , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_nam            , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pc             , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_bld            , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_unit           , BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_flr            , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_room           , BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_plc            , BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pcn            , BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pobox          , BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_addcode        , BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_seat           , BER_CLASS_CON, 25, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_rd             , BER_CLASS_CON, 26, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_rdsec          , BER_CLASS_CON, 27, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_rdbr           , BER_CLASS_CON, 28, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_rdsubbr        , BER_CLASS_CON, 29, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_prm            , BER_CLASS_CON, 30, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pom            , BER_CLASS_CON, 31, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_CivicAddress(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   CivicAddress_sequence, hf_index, ett_lix2_CivicAddress);

  return offset;
}


static const value_string lix2_PositioningMethod_vals[] = {
  {   1, "cellID" },
  {   2, "eCID" },
  {   3, "oTDOA" },
  {   4, "barometricPressure" },
  {   5, "wLAN" },
  {   6, "bluetooth" },
  {   7, "mBS" },
  {   8, "motionSensor" },
  {   9, "dLTDOA" },
  {  10, "dLAOD" },
  {  11, "multiRTT" },
  {  12, "nRECID" },
  {  13, "uLTDOA" },
  {  14, "uLAOA" },
  {  15, "networkSpecific" },
  { 0, NULL }
};


static int
dissect_lix2_PositioningMethod(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_PositioningMode_vals[] = {
  {   1, "uEBased" },
  {   2, "uEAssisted" },
  {   3, "conventional" },
  { 0, NULL }
};


static int
dissect_lix2_PositioningMode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_Usage_vals[] = {
  {   1, "unsuccess" },
  {   2, "successResultsNotUsed" },
  {   3, "successResultsUsedToVerifyLocation" },
  {   4, "successResultsUsedToGenerateLocation" },
  {   5, "successMethodNotDetermined" },
  { 0, NULL }
};


static int
dissect_lix2_Usage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_MethodCode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t PositioningMethodAndUsage_sequence[] = {
  { &hf_lix2_method         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PositioningMethod },
  { &hf_lix2_mode           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PositioningMode },
  { &hf_lix2_usage          , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_Usage },
  { &hf_lix2_methodCode     , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MethodCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PositioningMethodAndUsage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PositioningMethodAndUsage_sequence, hf_index, ett_lix2_PositioningMethodAndUsage);

  return offset;
}


static const ber_sequence_t SET_OF_PositioningMethodAndUsage_set_of[1] = {
  { &hf_lix2_positioningDataList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PositioningMethodAndUsage },
};

static int
dissect_lix2_SET_OF_PositioningMethodAndUsage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_PositioningMethodAndUsage_set_of, hf_index, ett_lix2_SET_OF_PositioningMethodAndUsage);

  return offset;
}


static const value_string lix2_GNSSID_vals[] = {
  {   1, "gPS" },
  {   2, "galileo" },
  {   3, "sBAS" },
  {   4, "modernizedGPS" },
  {   5, "qZSS" },
  {   6, "gLONASS" },
  {   7, "bDS" },
  {   8, "nAVIC" },
  { 0, NULL }
};


static int
dissect_lix2_GNSSID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t GNSSPositioningMethodAndUsage_sequence[] = {
  { &hf_lix2_mode           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PositioningMode },
  { &hf_lix2_gNSS           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_GNSSID },
  { &hf_lix2_usage          , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_Usage },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GNSSPositioningMethodAndUsage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   GNSSPositioningMethodAndUsage_sequence, hf_index, ett_lix2_GNSSPositioningMethodAndUsage);

  return offset;
}


static const ber_sequence_t SET_OF_GNSSPositioningMethodAndUsage_set_of[1] = {
  { &hf_lix2_gNSSPositioningDataList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_GNSSPositioningMethodAndUsage },
};

static int
dissect_lix2_SET_OF_GNSSPositioningMethodAndUsage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_GNSSPositioningMethodAndUsage_set_of, hf_index, ett_lix2_SET_OF_GNSSPositioningMethodAndUsage);

  return offset;
}



static int
dissect_lix2_BarometricPressure(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t LocationData_sequence[] = {
  { &hf_lix2_locationEstimate, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GeographicArea },
  { &hf_lix2_accuracyFulfilmentIndicator, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccuracyFulfilmentIndicator },
  { &hf_lix2_ageOfLocationEstimate, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AgeOfLocation },
  { &hf_lix2_velocityEstimate, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_VelocityEstimate },
  { &hf_lix2_civicAddress_01, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CivicAddress },
  { &hf_lix2_positioningDataList, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_PositioningMethodAndUsage },
  { &hf_lix2_gNSSPositioningDataList, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_GNSSPositioningMethodAndUsage },
  { &hf_lix2_eCGI           , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ECGI },
  { &hf_lix2_nCGI           , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NCGI },
  { &hf_lix2_altitude       , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Altitude },
  { &hf_lix2_barometricPressure, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BarometricPressure },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LocationData(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LocationData_sequence, hf_index, ett_lix2_LocationData);

  return offset;
}



static int
dissect_lix2_INTEGER_1_699(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const value_string lix2_RawMLPResponse_vals[] = {
  {   1, "mLPPositionData" },
  {   2, "mLPErrorCode" },
  { 0, NULL }
};

static const ber_choice_t RawMLPResponse_choice[] = {
  {   1, &hf_lix2_mLPPositionData, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  {   2, &hf_lix2_mLPErrorCode   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_1_699 },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RawMLPResponse(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 RawMLPResponse_choice, hf_index, ett_lix2_RawMLPResponse,
                                 NULL);

  return offset;
}


static const ber_sequence_t PositioningInfo_sequence[] = {
  { &hf_lix2_positionInfo   , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LocationData },
  { &hf_lix2_rawMLPResponse , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RawMLPResponse },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PositioningInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PositioningInfo_sequence, hf_index, ett_lix2_PositioningInfo);

  return offset;
}


static const value_string lix2_AMFEventType_vals[] = {
  {   1, "locationReport" },
  {   2, "presenceInAOIReport" },
  { 0, NULL }
};


static int
dissect_lix2_AMFEventType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_PresenceState_vals[] = {
  {   1, "inArea" },
  {   2, "outOfArea" },
  {   3, "unknown" },
  {   4, "inactive" },
  { 0, NULL }
};


static int
dissect_lix2_PresenceState(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SET_OF_TAI_set_of[1] = {
  { &hf_lix2_trackingAreaList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_TAI },
};

static int
dissect_lix2_SET_OF_TAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_TAI_set_of, hf_index, ett_lix2_SET_OF_TAI);

  return offset;
}


static const ber_sequence_t SET_OF_ECGI_set_of[1] = {
  { &hf_lix2_eCGIList_item  , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_ECGI },
};

static int
dissect_lix2_SET_OF_ECGI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_ECGI_set_of, hf_index, ett_lix2_SET_OF_ECGI);

  return offset;
}


static const ber_sequence_t SET_OF_NCGI_set_of[1] = {
  { &hf_lix2_nCGIList_item  , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_NCGI },
};

static int
dissect_lix2_SET_OF_NCGI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_NCGI_set_of, hf_index, ett_lix2_SET_OF_NCGI);

  return offset;
}


static const ber_sequence_t SET_OF_GlobalRANNodeID_set_of[1] = {
  { &hf_lix2_globalRANNodeIDList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_GlobalRANNodeID },
};

static int
dissect_lix2_SET_OF_GlobalRANNodeID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_GlobalRANNodeID_set_of, hf_index, ett_lix2_SET_OF_GlobalRANNodeID);

  return offset;
}


static const ber_sequence_t PresenceInfo_sequence[] = {
  { &hf_lix2_presenceState  , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PresenceState },
  { &hf_lix2_trackingAreaList, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_TAI },
  { &hf_lix2_eCGIList       , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_ECGI },
  { &hf_lix2_nCGIList       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_NCGI },
  { &hf_lix2_globalRANNodeIDList, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_GlobalRANNodeID },
  { &hf_lix2_globalENbIDList, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_GlobalRANNodeID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PresenceInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PresenceInfo_sequence, hf_index, ett_lix2_PresenceInfo);

  return offset;
}


static const ber_sequence_t LADNInfo_sequence[] = {
  { &hf_lix2_lADN           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_presence       , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PresenceState },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LADNInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LADNInfo_sequence, hf_index, ett_lix2_LADNInfo);

  return offset;
}


static const ber_sequence_t AMFEventArea_sequence[] = {
  { &hf_lix2_presenceInfo   , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PresenceInfo },
  { &hf_lix2_lADNInfo       , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LADNInfo },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFEventArea(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFEventArea_sequence, hf_index, ett_lix2_AMFEventArea);

  return offset;
}


static const ber_sequence_t SET_OF_AMFEventArea_set_of[1] = {
  { &hf_lix2_areaList_item  , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_AMFEventArea },
};

static int
dissect_lix2_SET_OF_AMFEventArea(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_AMFEventArea_set_of, hf_index, ett_lix2_SET_OF_AMFEventArea);

  return offset;
}


static const value_string lix2_AccessType_vals[] = {
  {   1, "threeGPPAccess" },
  {   2, "nonThreeGPPAccess" },
  {   3, "threeGPPandNonThreeGPPAccess" },
  { 0, NULL }
};


static int
dissect_lix2_AccessType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SET_OF_AccessType_set_of[1] = {
  { &hf_lix2_accessTypes_item, BER_CLASS_UNI, BER_UNI_TAG_ENUMERATED, BER_FLAGS_NOOWNTAG, dissect_lix2_AccessType },
};

static int
dissect_lix2_SET_OF_AccessType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_AccessType_set_of, hf_index, ett_lix2_SET_OF_AccessType);

  return offset;
}


static const value_string lix2_RMState_vals[] = {
  {   1, "registered" },
  {   2, "deregistered" },
  { 0, NULL }
};


static int
dissect_lix2_RMState(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t RMInfo_sequence[] = {
  { &hf_lix2_rMState        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RMState },
  { &hf_lix2_accessType     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RMInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RMInfo_sequence, hf_index, ett_lix2_RMInfo);

  return offset;
}


static const ber_sequence_t SET_OF_RMInfo_set_of[1] = {
  { &hf_lix2_rMInfoList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_RMInfo },
};

static int
dissect_lix2_SET_OF_RMInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_RMInfo_set_of, hf_index, ett_lix2_SET_OF_RMInfo);

  return offset;
}


static const value_string lix2_CMState_vals[] = {
  {   1, "idle" },
  {   2, "connected" },
  { 0, NULL }
};


static int
dissect_lix2_CMState(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t CMInfo_sequence[] = {
  { &hf_lix2_cMState        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_CMState },
  { &hf_lix2_accessType     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_CMInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   CMInfo_sequence, hf_index, ett_lix2_CMInfo);

  return offset;
}


static const ber_sequence_t SET_OF_CMInfo_set_of[1] = {
  { &hf_lix2_cMInfoList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_CMInfo },
};

static int
dissect_lix2_SET_OF_CMInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_CMInfo_set_of, hf_index, ett_lix2_SET_OF_CMInfo);

  return offset;
}


static const value_string lix2_UEReachability_vals[] = {
  {   1, "unreachable" },
  {   2, "reachable" },
  {   3, "regulatoryOnly" },
  { 0, NULL }
};


static int
dissect_lix2_UEReachability(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t LocationPresenceReport_sequence[] = {
  { &hf_lix2_type_02        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AMFEventType },
  { &hf_lix2_timestamp      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_areaList       , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_AMFEventArea },
  { &hf_lix2_timeZone       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TimeZone },
  { &hf_lix2_accessTypes    , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_AccessType },
  { &hf_lix2_rMInfoList     , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_RMInfo },
  { &hf_lix2_cMInfoList     , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_CMInfo },
  { &hf_lix2_reachability   , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEReachability },
  { &hf_lix2_location_02    , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UserLocation },
  { &hf_lix2_additionalCellIDs, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_CellInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LocationPresenceReport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LocationPresenceReport_sequence, hf_index, ett_lix2_LocationPresenceReport);

  return offset;
}



static int
dissect_lix2_CellPortionID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t ESMLCCellInfo_sequence[] = {
  { &hf_lix2_eCGI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_ECGI },
  { &hf_lix2_cellPortionID  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_CellPortionID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ESMLCCellInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ESMLCCellInfo_sequence, hf_index, ett_lix2_ESMLCCellInfo);

  return offset;
}



static int
dissect_lix2_GERANPositioningData(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_GERANGANSSPositioningData(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t GERANPositioningInfo_sequence[] = {
  { &hf_lix2_gERANPositioningData, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GERANPositioningData },
  { &hf_lix2_gERANGANSSPositioningData, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GERANGANSSPositioningData },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GERANPositioningInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   GERANPositioningInfo_sequence, hf_index, ett_lix2_GERANPositioningInfo);

  return offset;
}



static int
dissect_lix2_UTRANPositioningData(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_UTRANGANSSPositioningData(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_UTRANAdditionalPositioningData(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t UTRANPositioningInfo_sequence[] = {
  { &hf_lix2_uTRANPositioningData, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTRANPositioningData },
  { &hf_lix2_uTRANGANSSPositioningData, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTRANGANSSPositioningData },
  { &hf_lix2_uTRANAdditionalPositioningData, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTRANAdditionalPositioningData },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UTRANPositioningInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UTRANPositioningInfo_sequence, hf_index, ett_lix2_UTRANPositioningInfo);

  return offset;
}


static const ber_sequence_t FourGPositioningInfo_sequence[] = {
  { &hf_lix2_locationData   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_LocationData },
  { &hf_lix2_cGI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CGI },
  { &hf_lix2_sAI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SAI },
  { &hf_lix2_eSMLCCellInfo  , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ESMLCCellInfo },
  { &hf_lix2_gERANPositioningInfo, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GERANPositioningInfo },
  { &hf_lix2_uTRANPositioningInfo, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTRANPositioningInfo },
  { &hf_lix2_rawMLPResponse , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RawMLPResponse },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FourGPositioningInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FourGPositioningInfo_sequence, hf_index, ett_lix2_FourGPositioningInfo);

  return offset;
}



static int
dissect_lix2_GeographicalInformationOctet(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_GeodeticInformationOctet(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_CSGID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const value_string lix2_CSGAccessMode_vals[] = {
  {   1, "closedMode" },
  {   2, "hybridMode" },
  { 0, NULL }
};


static int
dissect_lix2_CSGAccessMode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_CSGMembershipIndication_vals[] = {
  {   1, "notCSGMember" },
  {   2, "cSGMember" },
  { 0, NULL }
};


static int
dissect_lix2_CSGMembershipIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t UserCSGInformation_sequence[] = {
  { &hf_lix2_cSGID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_CSGID },
  { &hf_lix2_cSGAccessMode  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_CSGAccessMode },
  { &hf_lix2_cSGMembershipIndication, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_CSGMembershipIndication },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UserCSGInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UserCSGInformation_sequence, hf_index, ett_lix2_UserCSGInformation);

  return offset;
}


static const ber_sequence_t MMELocationInformation_sequence[] = {
  { &hf_lix2_eCGI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ECGI },
  { &hf_lix2_tAI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAI },
  { &hf_lix2_geographicalInformation_01, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GeographicalInformationOctet },
  { &hf_lix2_geodeticInformation_01, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GeodeticInformationOctet },
  { &hf_lix2_currentLocationRetrieved, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_ageOfLocationInformation, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_userCSGInformation, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UserCSGInformation },
  { &hf_lix2_eNbID          , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_ENbID },
  { &hf_lix2_additionalCellIDs, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_CellInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMELocationInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMELocationInformation_sequence, hf_index, ett_lix2_MMELocationInformation);

  return offset;
}


static const ber_sequence_t SGSNLocationInformation_sequence[] = {
  { &hf_lix2_cGI            , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CGI },
  { &hf_lix2_lAI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LAI },
  { &hf_lix2_sAI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SAI },
  { &hf_lix2_rAI            , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RAI },
  { &hf_lix2_geographicalInformation_01, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GeographicalInformationOctet },
  { &hf_lix2_geodeticInformation_01, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GeodeticInformationOctet },
  { &hf_lix2_currentLocationRetrieved, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_ageOfLocationInformation, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_userCSGInformation, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UserCSGInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SGSNLocationInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SGSNLocationInformation_sequence, hf_index, ett_lix2_SGSNLocationInformation);

  return offset;
}


static const ber_sequence_t EPSLocationInformation_sequence[] = {
  { &hf_lix2_mMELocationInformation, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMELocationInformation },
  { &hf_lix2_sGSNLocationInformation, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SGSNLocationInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSLocationInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSLocationInformation_sequence, hf_index, ett_lix2_EPSLocationInformation);

  return offset;
}



static int
dissect_lix2_EPSUserLocationInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_FourGLocationInfo_vals[] = {
  {   1, "ePSLocationInformation" },
  {   2, "ePSUserLocationInformation" },
  { 0, NULL }
};

static const ber_choice_t FourGLocationInfo_choice[] = {
  {   1, &hf_lix2_ePSLocationInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSLocationInformation },
  {   2, &hf_lix2_ePSUserLocationInformation, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSUserLocationInformation },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FourGLocationInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 FourGLocationInfo_choice, hf_index, ett_lix2_FourGLocationInfo,
                                 NULL);

  return offset;
}


static const ber_sequence_t SIPAccessNetworkInformation_sequence[] = {
  { &hf_lix2_accessNetworkInfo, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_servingPLMN    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SIPAccessNetworkInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SIPAccessNetworkInformation_sequence, hf_index, ett_lix2_SIPAccessNetworkInformation);

  return offset;
}



static int
dissect_lix2_SIPAccessInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_SIPAccessInfo_sequence_of[1] = {
  { &hf_lix2_accessInfo_item_01, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_SIPAccessInfo },
};

static int
dissect_lix2_SEQUENCE_OF_SIPAccessInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_SIPAccessInfo_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_SIPAccessInfo);

  return offset;
}


static const ber_sequence_t SIPLocationInfo_sequence[] = {
  { &hf_lix2_locationInfo   , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LocationInfo },
  { &hf_lix2_cellInformation, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CellInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SIPLocationInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SIPLocationInfo_sequence, hf_index, ett_lix2_SIPLocationInfo);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_SIPLocationInfo_sequence_of[1] = {
  { &hf_lix2_pANILocation_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_SIPLocationInfo },
};

static int
dissect_lix2_SEQUENCE_OF_SIPLocationInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_SIPLocationInfo_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_SIPLocationInfo);

  return offset;
}


static const ber_sequence_t PANIHeaderInfo_sequence[] = {
  { &hf_lix2_accessNetworkInformation_01, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SIPAccessNetworkInformation },
  { &hf_lix2_accessInfo_01  , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_SIPAccessInfo },
  { &hf_lix2_pANILocation   , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_SIPLocationInfo },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PANIHeaderInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PANIHeaderInfo_sequence, hf_index, ett_lix2_PANIHeaderInfo);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_PANIHeaderInfo_sequence_of[1] = {
  { &hf_lix2_pANIHeaderInfo_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PANIHeaderInfo },
};

static int
dissect_lix2_SEQUENCE_OF_PANIHeaderInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_PANIHeaderInfo_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_PANIHeaderInfo);

  return offset;
}


static const ber_sequence_t SIPGeolocationHeaderInfo_sequence[] = {
  { &hf_lix2_locationValue  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_cidInfo        , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SIPGeolocationHeaderInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SIPGeolocationHeaderInfo_sequence, hf_index, ett_lix2_SIPGeolocationHeaderInfo);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_SIPGeolocationHeaderInfo_sequence_of[1] = {
  { &hf_lix2_geolocationHeaderInfo_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_SIPGeolocationHeaderInfo },
};

static int
dissect_lix2_SEQUENCE_OF_SIPGeolocationHeaderInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_SIPGeolocationHeaderInfo_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_SIPGeolocationHeaderInfo);

  return offset;
}


static const ber_sequence_t SIPCellularNetworkInformation_sequence[] = {
  { &hf_lix2_cellularNetworkInfo, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_servingPLMN    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SIPCellularNetworkInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SIPCellularNetworkInformation_sequence, hf_index, ett_lix2_SIPCellularNetworkInformation);

  return offset;
}



static int
dissect_lix2_SIPCNICellInfoAge(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t SIPCellularAccessInfo_sequence[] = {
  { &hf_lix2_accessInfo_02  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SIPAccessInfo },
  { &hf_lix2_cellInfoAge    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SIPCNICellInfoAge },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SIPCellularAccessInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SIPCellularAccessInfo_sequence, hf_index, ett_lix2_SIPCellularAccessInfo);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_SIPCellularAccessInfo_sequence_of[1] = {
  { &hf_lix2_cellularAccessInfo_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_SIPCellularAccessInfo },
};

static int
dissect_lix2_SEQUENCE_OF_SIPCellularAccessInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_SIPCellularAccessInfo_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_SIPCellularAccessInfo);

  return offset;
}


static const ber_sequence_t SIPCNIHeaderInfo_sequence[] = {
  { &hf_lix2_cellularNetworkInformation_01, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SIPCellularNetworkInformation },
  { &hf_lix2_cellularAccessInfo, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_SIPCellularAccessInfo },
  { &hf_lix2_cNILocation    , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_SIPLocationInfo },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SIPCNIHeaderInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SIPCNIHeaderInfo_sequence, hf_index, ett_lix2_SIPCNIHeaderInfo);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_SIPCNIHeaderInfo_sequence_of[1] = {
  { &hf_lix2_cNIHeaderInfo_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_SIPCNIHeaderInfo },
};

static int
dissect_lix2_SEQUENCE_OF_SIPCNIHeaderInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_SIPCNIHeaderInfo_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_SIPCNIHeaderInfo);

  return offset;
}


static const ber_sequence_t IMSLocation_sequence[] = {
  { &hf_lix2_pANIHeaderInfo , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PANIHeaderInfo },
  { &hf_lix2_geolocationHeaderInfo, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_SIPGeolocationHeaderInfo },
  { &hf_lix2_cNIHeaderInfo  , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_SIPCNIHeaderInfo },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IMSLocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   IMSLocation_sequence, hf_index, ett_lix2_IMSLocation);

  return offset;
}


static const ber_sequence_t Location_sequence[] = {
  { &hf_lix2_locationInfo   , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LocationInfo },
  { &hf_lix2_positioningInfo, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PositioningInfo },
  { &hf_lix2_locationPresenceReport, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LocationPresenceReport },
  { &hf_lix2_fourGPositioningInfo, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FourGPositioningInfo },
  { &hf_lix2_fourGLocationInfo, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_FourGLocationInfo },
  { &hf_lix2_iMSLocation    , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSLocation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_Location(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   Location_sequence, hf_index, ett_lix2_Location);

  return offset;
}


static const value_string lix2_UEEndpointAddress_vals[] = {
  {   1, "iPv4Address" },
  {   2, "iPv6Address" },
  {   3, "ethernetAddress" },
  { 0, NULL }
};

static const ber_choice_t UEEndpointAddress_choice[] = {
  {   1, &hf_lix2_iPv4Address    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IPv4Address },
  {   2, &hf_lix2_iPv6Address    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_IPv6Address },
  {   3, &hf_lix2_ethernetAddress, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_MACAddress },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UEEndpointAddress(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 UEEndpointAddress_choice, hf_index, ett_lix2_UEEndpointAddress,
                                 NULL);

  return offset;
}


static const ber_sequence_t TAIList_sequence_of[1] = {
  { &hf_lix2_TAIList_item   , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_TAI },
};

static int
dissect_lix2_TAIList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      TAIList_sequence_of, hf_index, ett_lix2_TAIList);

  return offset;
}


static const value_string lix2_SMSOverNASIndicator_vals[] = {
  {   1, "sMSOverNASNotAllowed" },
  {   2, "sMSOverNASAllowed" },
  { 0, NULL }
};


static int
dissect_lix2_SMSOverNASIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_MMEGroupID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_MMECode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_TMSI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t GUTI_sequence[] = {
  { &hf_lix2_mCC            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MCC },
  { &hf_lix2_mNC            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MNC },
  { &hf_lix2_mMEGroupID     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_MMEGroupID },
  { &hf_lix2_mMECode        , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_MMECode },
  { &hf_lix2_mTMSI          , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_TMSI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GUTI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   GUTI_sequence, hf_index, ett_lix2_GUTI);

  return offset;
}


static const value_string lix2_EPS5GGUTI_vals[] = {
  {   1, "gUTI" },
  {   2, "fiveGGUTI" },
  { 0, NULL }
};

static const ber_choice_t EPS5GGUTI_choice[] = {
  {   1, &hf_lix2_gUTI_01        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  {   2, &hf_lix2_fiveGGUTI      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGGUTI },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPS5GGUTI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 EPS5GGUTI_choice, hf_index, ett_lix2_EPS5GGUTI,
                                 NULL);

  return offset;
}


static const value_string lix2_EMMRegStatus_vals[] = {
  {   1, "uEEMMRegistered" },
  {   2, "uENotEMMRegistered" },
  { 0, NULL }
};


static int
dissect_lix2_EMMRegStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_FiveGMMStatus_vals[] = {
  {   1, "uE5GMMRegistered" },
  {   2, "uENot5GMMRegistered" },
  { 0, NULL }
};


static int
dissect_lix2_FiveGMMStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t EMM5GMMStatus_sequence[] = {
  { &hf_lix2_eMMRegStatus   , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EMMRegStatus },
  { &hf_lix2_fiveGMMStatus  , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMMStatus },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EMM5GMMStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EMM5GMMStatus_sequence, hf_index, ett_lix2_EMM5GMMStatus);

  return offset;
}


static const value_string lix2_NonIMEISVPEI_vals[] = {
  {   1, "mACAddress" },
  {   2, "eUI64" },
  { 0, NULL }
};

static const ber_choice_t NonIMEISVPEI_choice[] = {
  {   1, &hf_lix2_mACAddress     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MACAddress },
  {   2, &hf_lix2_eUI64          , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EUI64 },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NonIMEISVPEI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 NonIMEISVPEI_choice, hf_index, ett_lix2_NonIMEISVPEI,
                                 NULL);

  return offset;
}


static const value_string lix2_MACRestrictionIndicator_vals[] = {
  {   1, "noResrictions" },
  {   2, "mACAddressNotUseableAsEquipmentIdentifier" },
  {   3, "unknown" },
  { 0, NULL }
};


static int
dissect_lix2_MACRestrictionIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_PagingRestrictionIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_EstablishmentCause_vals[] = {
  {   1, "emergency" },
  {   2, "highPriorityAccess" },
  {   3, "mtAccess" },
  {   4, "moSignalling" },
  {   5, "moData" },
  {   6, "moVoiceCall" },
  {   7, "moVideoCall" },
  {   8, "moSMS" },
  {   9, "mpsPriorityAccess" },
  {  10, "mcsPriorityAccess" },
  {  11, "notAvailable" },
  {  12, "exceptionData" },
  { 0, NULL }
};


static int
dissect_lix2_EstablishmentCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_RRCEstablishmentCause_vals[] = {
  {   1, "ePCEstablishmentCause" },
  {   2, "fiveGCEstablishmentCause" },
  { 0, NULL }
};

static const ber_choice_t RRCEstablishmentCause_choice[] = {
  {   1, &hf_lix2_ePCEstablishmentCause, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EstablishmentCause },
  {   2, &hf_lix2_fiveGCEstablishmentCause, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EstablishmentCause },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RRCEstablishmentCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 RRCEstablishmentCause_choice, hf_index, ett_lix2_RRCEstablishmentCause,
                                 NULL);

  return offset;
}



static int
dissect_lix2_RANUENGAPID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_CAGID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t CellCAGList_sequence_of[1] = {
  { &hf_lix2_CellCAGList_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_CAGID },
};

static int
dissect_lix2_CellCAGList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      CellCAGList_sequence_of, hf_index, ett_lix2_CellCAGList);

  return offset;
}


static const value_string lix2_REDCAPIndication_vals[] = {
  {   1, "redCAP" },
  { 0, NULL }
};


static int
dissect_lix2_REDCAPIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NASTransportInitialInformation_sequence[] = {
  { &hf_lix2_rANUENGAPID    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RANUENGAPID },
  { &hf_lix2_iABNodeIndication, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_eDTSession     , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_authenticatedIndication, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_nPNAccessInformation_01, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CellCAGList },
  { &hf_lix2_rEDCAPIndication, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_REDCAPIndication },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NASTransportInitialInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NASTransportInitialInformation_sequence, hf_index, ett_lix2_NASTransportInitialInformation);

  return offset;
}



static int
dissect_lix2_SORTransparentContainer(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t PLMNList_sequence_of[1] = {
  { &hf_lix2_PLMNList_item  , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PLMNID },
};

static int
dissect_lix2_PLMNList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      PLMNList_sequence_of, hf_index, ett_lix2_PLMNList);

  return offset;
}



static int
dissect_lix2_FiveGMMCapability(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_AMFUENGAPID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer64(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t AMFID_sequence[] = {
  { &hf_lix2_aMFRegionID    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRegionID },
  { &hf_lix2_aMFSetID       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AMFSetID },
  { &hf_lix2_aMFPointer     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_AMFPointer },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFID_sequence, hf_index, ett_lix2_AMFID);

  return offset;
}


static const ber_sequence_t GUAMI_sequence[] = {
  { &hf_lix2_aMFID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AMFID },
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GUAMI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   GUAMI_sequence, hf_index, ett_lix2_GUAMI);

  return offset;
}



static int
dissect_lix2_PDUSessionID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t PDUSessionSetupRequestItem_sequence[] = {
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PDUSessionSetupRequestItem(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PDUSessionSetupRequestItem_sequence, hf_index, ett_lix2_PDUSessionSetupRequestItem);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_PDUSessionSetupRequestItem_sequence_of[1] = {
  { &hf_lix2_pDUSessionSetupRequest_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PDUSessionSetupRequestItem },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_PDUSessionSetupRequestItem(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_PDUSessionSetupRequestItem_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_PDUSessionSetupRequestItem);

  return offset;
}


static const ber_sequence_t AllowedNSSAI_sequence_of[1] = {
  { &hf_lix2_AllowedNSSAI_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_NSSAI },
};

static int
dissect_lix2_AllowedNSSAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      AllowedNSSAI_sequence_of, hf_index, ett_lix2_AllowedNSSAI);

  return offset;
}


static const ber_sequence_t EquivalentPLMNs_sequence_of[1] = {
  { &hf_lix2_EquivalentPLMNs_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PLMNID },
};

static int
dissect_lix2_EquivalentPLMNs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      EquivalentPLMNs_sequence_of, hf_index, ett_lix2_EquivalentPLMNs);

  return offset;
}



static int
dissect_lix2_RATRestrictionInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}


static const ber_sequence_t RATRestrictionItem_sequence[] = {
  { &hf_lix2_pLMNIdentity   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_rATRestrictionInformation, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_RATRestrictionInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RATRestrictionItem(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RATRestrictionItem_sequence, hf_index, ett_lix2_RATRestrictionItem);

  return offset;
}


static const ber_sequence_t RATRestrictions_sequence_of[1] = {
  { &hf_lix2_RATRestrictions_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_RATRestrictionItem },
};

static int
dissect_lix2_RATRestrictions(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      RATRestrictions_sequence_of, hf_index, ett_lix2_RATRestrictions);

  return offset;
}


static const ber_sequence_t ForbiddenTACs_sequence_of[1] = {
  { &hf_lix2_ForbiddenTACs_item, BER_CLASS_UNI, BER_UNI_TAG_OCTETSTRING, BER_FLAGS_NOOWNTAG, dissect_lix2_TAC },
};

static int
dissect_lix2_ForbiddenTACs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      ForbiddenTACs_sequence_of, hf_index, ett_lix2_ForbiddenTACs);

  return offset;
}


static const ber_sequence_t ForbiddenAreaInformation_sequence[] = {
  { &hf_lix2_pLMNIdentity   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_forbiddenTACs  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_ForbiddenTACs },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ForbiddenAreaInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ForbiddenAreaInformation_sequence, hf_index, ett_lix2_ForbiddenAreaInformation);

  return offset;
}


static const ber_sequence_t AllowedTACs_sequence_of[1] = {
  { &hf_lix2_AllowedTACs_item, BER_CLASS_UNI, BER_UNI_TAG_OCTETSTRING, BER_FLAGS_NOOWNTAG, dissect_lix2_TAC },
};

static int
dissect_lix2_AllowedTACs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      AllowedTACs_sequence_of, hf_index, ett_lix2_AllowedTACs);

  return offset;
}


static const ber_sequence_t ServiceAreaInfo_sequence[] = {
  { &hf_lix2_pLMNIdentity   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_allowedTACs    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AllowedTACs },
  { &hf_lix2_notAllowedTACs , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ForbiddenTACs },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ServiceAreaInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ServiceAreaInfo_sequence, hf_index, ett_lix2_ServiceAreaInfo);

  return offset;
}


static const ber_sequence_t ServiceAreaInformation_sequence_of[1] = {
  { &hf_lix2_ServiceAreaInformation_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_ServiceAreaInfo },
};

static int
dissect_lix2_ServiceAreaInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      ServiceAreaInformation_sequence_of, hf_index, ett_lix2_ServiceAreaInformation);

  return offset;
}


static const ber_sequence_t MobilityRestrictionList_sequence[] = {
  { &hf_lix2_servingPLMN    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_equivalentPLMNs, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EquivalentPLMNs },
  { &hf_lix2_rATRestrictions, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATRestrictions },
  { &hf_lix2_forbiddenAreaInformation, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ForbiddenAreaInformation },
  { &hf_lix2_serviceAreaInformation, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ServiceAreaInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MobilityRestrictionList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MobilityRestrictionList_sequence, hf_index, ett_lix2_MobilityRestrictionList);

  return offset;
}


static const ber_sequence_t UERadioCapability_sequence[] = {
  { &hf_lix2_uERadioCapibilityNR, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_uERadioCapabilityEUTRA, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UERadioCapability(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UERadioCapability_sequence, hf_index, ett_lix2_UERadioCapability);

  return offset;
}



static int
dissect_lix2_RATFrequencySelectionPriority(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t UERadioCapabilityForPaging_sequence[] = {
  { &hf_lix2_uERadioCapabilityForPagingOfNR, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_uERadioCapabilityForPagingOfEUTRA, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_uERadioCapabilityForPagingOfNBIoT, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UERadioCapabilityForPaging(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UERadioCapabilityForPaging_sequence, hf_index, ett_lix2_UERadioCapabilityForPaging);

  return offset;
}


static const value_string lix2_IABAuthorizedIndicator_vals[] = {
  {   1, "authorized" },
  {   2, "notAuthorized" },
  { 0, NULL }
};


static int
dissect_lix2_IABAuthorizedIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_V2XUEAuthorizationIndicator_vals[] = {
  {   1, "authorized" },
  {   2, "notAuthorized" },
  { 0, NULL }
};


static int
dissect_lix2_V2XUEAuthorizationIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NRV2XServicesAuthorization_sequence[] = {
  { &hf_lix2_v2XVehicleUEAuthorizationIndicator, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_V2XUEAuthorizationIndicator },
  { &hf_lix2_v2XPedestrianUEAuthorizationIndicator, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_V2XUEAuthorizationIndicator },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NRV2XServicesAuthorization(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NRV2XServicesAuthorization_sequence, hf_index, ett_lix2_NRV2XServicesAuthorization);

  return offset;
}


static const ber_sequence_t LTEV2XServiceAuthorization_sequence[] = {
  { &hf_lix2_v2XVehicleUEAuthorizationIndicator, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_V2XUEAuthorizationIndicator },
  { &hf_lix2_v2XPedestrianUEAuthorizationIndicator, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_V2XUEAuthorizationIndicator },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LTEV2XServiceAuthorization(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LTEV2XServiceAuthorization_sequence, hf_index, ett_lix2_LTEV2XServiceAuthorization);

  return offset;
}


static const ber_sequence_t TargetNSSAIInfo_sequence[] = {
  { &hf_lix2_targetSNSSAIList, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NSSAI },
  { &hf_lix2_rATFrequencySelectionPriority, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_RATFrequencySelectionPriority },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_TargetNSSAIInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   TargetNSSAIInfo_sequence, hf_index, ett_lix2_TargetNSSAIInfo);

  return offset;
}


static const value_string lix2_FiveGProSeAuthorizationIndicator_vals[] = {
  {   1, "authorized" },
  {   2, "notAuthorized" },
  { 0, NULL }
};


static int
dissect_lix2_FiveGProSeAuthorizationIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t FiveGProSeAuthorizationIndication_sequence[] = {
  { &hf_lix2_fiveGProSeDirectDiscovery, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGProSeAuthorizationIndicator },
  { &hf_lix2_fiveGProSeDirectCommunication, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGProSeAuthorizationIndicator },
  { &hf_lix2_fiveGProSeL2UEToNetworkRelay, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGProSeAuthorizationIndicator },
  { &hf_lix2_fiveGProSeL3UEToNetworkRelay, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGProSeAuthorizationIndicator },
  { &hf_lix2_fiveGProSeL2RemoteUE, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGProSeAuthorizationIndicator },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGProSeAuthorizationIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGProSeAuthorizationIndication_sequence, hf_index, ett_lix2_FiveGProSeAuthorizationIndication);

  return offset;
}


static const ber_sequence_t InitialRANUEContextSetup_sequence[] = {
  { &hf_lix2_aMFUENGAPID    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUENGAPID },
  { &hf_lix2_rANUENGAPID    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_RANUENGAPID },
  { &hf_lix2_oldAMF         , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUAMI },
  { &hf_lix2_pDUSessionSetupRequest, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_PDUSessionSetupRequestItem },
  { &hf_lix2_allowedNSSAI   , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_AllowedNSSAI },
  { &hf_lix2_mobilityRestrictionList, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MobilityRestrictionList },
  { &hf_lix2_uERadioCapability, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UERadioCapability },
  { &hf_lix2_rATFrequencySelectionPriority, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATFrequencySelectionPriority },
  { &hf_lix2_uERadioCapabilityForPaging, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UERadioCapabilityForPaging },
  { &hf_lix2_iABAuthorizedIndicator, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IABAuthorizedIndicator },
  { &hf_lix2_nRV2XServicesAuthorization, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NRV2XServicesAuthorization },
  { &hf_lix2_lTEV2XServiceAuthorization, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LTEV2XServiceAuthorization },
  { &hf_lix2_rGLevelWirelineAccessCharacteristics, BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_uERadioCapabilityID, BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_targetNSSAIInfo, BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TargetNSSAIInfo },
  { &hf_lix2_fiveGProSeAuthorizationIndication, BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGProSeAuthorizationIndication },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_InitialRANUEContextSetup(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   InitialRANUEContextSetup_sequence, hf_index, ett_lix2_InitialRANUEContextSetup);

  return offset;
}



static int
dissect_lix2_MUSIMUERequestType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_UnavailabilityPeriodDuration(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_FiveGSUpdateType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_UTF8String_SIZE_2(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t UEAreaIndication_sequence[] = {
  { &hf_lix2_country        , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String_SIZE_2 },
  { &hf_lix2_internationalAreaIndication, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UEAreaIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UEAreaIndication_sequence, hf_index, ett_lix2_UEAreaIndication);

  return offset;
}



static int
dissect_lix2_EstablishmentCauseNon3GPPAccess(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t AMFRegistration_sequence[] = {
  { &hf_lix2_registrationType, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRegistrationType },
  { &hf_lix2_registrationResult, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRegistrationResult },
  { &hf_lix2_slice          , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Slice },
  { &hf_lix2_sUPI           , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUCI           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUTI           , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGGUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_fiveGSTAIList  , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAIList },
  { &hf_lix2_sMSOverNasIndicator, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMSOverNASIndicator },
  { &hf_lix2_oldGUTI        , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_EPS5GGUTI },
  { &hf_lix2_eMM5GRegStatus , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EMM5GMMStatus },
  { &hf_lix2_nonIMEISVPEI   , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_NonIMEISVPEI },
  { &hf_lix2_mACRestIndicator, BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MACRestrictionIndicator },
  { &hf_lix2_pagingRestrictionIndicator, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PagingRestrictionIndicator },
  { &hf_lix2_rATType        , BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_rRCEstablishmentCause, BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RRCEstablishmentCause },
  { &hf_lix2_nGInformation  , BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NGInformation },
  { &hf_lix2_nASTransportInitialInformation, BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NASTransportInitialInformation },
  { &hf_lix2_sORTransparentContainer, BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SORTransparentContainer },
  { &hf_lix2_equivalentPLMNList, BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PLMNList },
  { &hf_lix2_fiveGMMCapability, BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMMCapability },
  { &hf_lix2_initialRANUEContextSetup, BER_CLASS_CON, 25, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_InitialRANUEContextSetup },
  { &hf_lix2_mUSIMUERequestType, BER_CLASS_CON, 26, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MUSIMUERequestType },
  { &hf_lix2_unavailabilityPeriodDuration, BER_CLASS_CON, 27, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UnavailabilityPeriodDuration },
  { &hf_lix2_fiveGSUpdateType, BER_CLASS_CON, 28, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSUpdateType },
  { &hf_lix2_uEAreaIndication, BER_CLASS_CON, 29, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEAreaIndication },
  { &hf_lix2_establishmentCauseNon3GPPAccess, BER_CLASS_CON, 30, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EstablishmentCauseNon3GPPAccess },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFRegistration(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFRegistration_sequence, hf_index, ett_lix2_AMFRegistration);

  return offset;
}


static const value_string lix2_AMFDirection_vals[] = {
  {   1, "networkInitiated" },
  {   2, "uEInitiated" },
  { 0, NULL }
};


static int
dissect_lix2_AMFDirection(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_FiveGMMCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const value_string lix2_SwitchOffIndicator_vals[] = {
  {   1, "normalDetach" },
  {   2, "switchOff" },
  { 0, NULL }
};


static int
dissect_lix2_SwitchOffIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_ReRegRequiredIndicator_vals[] = {
  {   1, "reRegistrationRequired" },
  {   2, "reRegistrationNotRequired" },
  { 0, NULL }
};


static int
dissect_lix2_ReRegRequiredIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t AMFDeregistration_sequence[] = {
  { &hf_lix2_deregistrationDirection, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AMFDirection },
  { &hf_lix2_accessType     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_sUPI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUCI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUTI           , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGGUTI },
  { &hf_lix2_cause          , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMMCause },
  { &hf_lix2_location       , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_switchOffIndicator, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SwitchOffIndicator },
  { &hf_lix2_reRegRequiredIndicator, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ReRegRequiredIndicator },
  { &hf_lix2_unavailabilityPeriodDuration, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UnavailabilityPeriodDuration },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFDeregistration(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFDeregistration_sequence, hf_index, ett_lix2_AMFDeregistration);

  return offset;
}


static const ber_sequence_t AMFLocationUpdate_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUCI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUTI           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGGUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_deprecatedSMSOverNASIndicator, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMSOverNASIndicator },
  { &hf_lix2_deprecatedOldGUTI, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_EPS5GGUTI },
  { &hf_lix2_uEAreaIndication, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEAreaIndication },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFLocationUpdate(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFLocationUpdate_sequence, hf_index, ett_lix2_AMFLocationUpdate);

  return offset;
}



static int
dissect_lix2_UEPolicy(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t AMFStartOfInterceptionWithRegisteredUE_sequence[] = {
  { &hf_lix2_registrationResult, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRegistrationResult },
  { &hf_lix2_registrationType, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AMFRegistrationType },
  { &hf_lix2_slice          , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Slice },
  { &hf_lix2_sUPI           , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUCI           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUTI           , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGGUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_timeOfRegistration, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_fiveGSTAIList  , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAIList },
  { &hf_lix2_sMSOverNASIndicator, BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMSOverNASIndicator },
  { &hf_lix2_oldGUTI        , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_EPS5GGUTI },
  { &hf_lix2_eMM5GRegStatus , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EMM5GMMStatus },
  { &hf_lix2_sORTransparentContainer, BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SORTransparentContainer },
  { &hf_lix2_uEPolicy       , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEPolicy },
  { &hf_lix2_unavailabilityPeriodDuration, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UnavailabilityPeriodDuration },
  { &hf_lix2_fiveGSUpdateType, BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSUpdateType },
  { &hf_lix2_uEAreaIndication, BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEAreaIndication },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFStartOfInterceptionWithRegisteredUE(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFStartOfInterceptionWithRegisteredUE_sequence, hf_index, ett_lix2_AMFStartOfInterceptionWithRegisteredUE);

  return offset;
}


static const value_string lix2_AMFFailedProcedureType_vals[] = {
  {   1, "registration" },
  {   2, "sMS" },
  {   3, "pDUSessionEstablishment" },
  { 0, NULL }
};


static int
dissect_lix2_AMFFailedProcedureType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_FiveGSMCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const value_string lix2_AMFFailureCause_vals[] = {
  {   1, "fiveGMMCause" },
  {   2, "fiveGSMCause" },
  { 0, NULL }
};

static const ber_choice_t AMFFailureCause_choice[] = {
  {   1, &hf_lix2_fiveGMMCause   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMMCause },
  {   2, &hf_lix2_fiveGSMCause   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMCause },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFFailureCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 AMFFailureCause_choice, hf_index, ett_lix2_AMFFailureCause,
                                 NULL);

  return offset;
}


static const ber_sequence_t AMFUnsuccessfulProcedure_sequence[] = {
  { &hf_lix2_failedProcedureType, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AMFFailedProcedureType },
  { &hf_lix2_failureCause_02, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_AMFFailureCause },
  { &hf_lix2_requestedSlice , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NSSAI },
  { &hf_lix2_sUPI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUCI           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUTI           , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGGUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFUnsuccessfulProcedure(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFUnsuccessfulProcedure_sequence, hf_index, ett_lix2_AMFUnsuccessfulProcedure);

  return offset;
}



static int
dissect_lix2_SUPIUnauthenticatedIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_INTEGER_0_4294967295(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t FTEID_sequence[] = {
  { &hf_lix2_tEID           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_4294967295 },
  { &hf_lix2_iPv4Address    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv4Address },
  { &hf_lix2_iPv6Address    , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv6Address },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FTEID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FTEID_sequence, hf_index, ett_lix2_FTEID);

  return offset;
}


static const value_string lix2_PDUSessionType_vals[] = {
  {   1, "iPv4" },
  {   2, "iPv6" },
  {   3, "iPv4v6" },
  {   4, "unstructured" },
  {   5, "ethernet" },
  { 0, NULL }
};


static int
dissect_lix2_PDUSessionType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_UEEndpointAddress_sequence_of[1] = {
  { &hf_lix2_uEEndpoint_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
};

static int
dissect_lix2_SEQUENCE_OF_UEEndpointAddress(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_UEEndpointAddress_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_UEEndpointAddress);

  return offset;
}



static int
dissect_lix2_DNN(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_HSMFURI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_FiveGSMRequestType_vals[] = {
  {   1, "initialRequest" },
  {   2, "existingPDUSession" },
  {   3, "initialEmergencyRequest" },
  {   4, "existingEmergencyPDUSession" },
  {   5, "modificationRequest" },
  {   6, "reserved" },
  {   7, "mAPDURequest" },
  { 0, NULL }
};


static int
dissect_lix2_FiveGSMRequestType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_SMPDUDNRequest(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_UEEPSPDNConnection(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_EPSInterworkingIndication_vals[] = {
  {   1, "none" },
  {   2, "withN26" },
  {   3, "withoutN26" },
  {   4, "iwkNon3GPP" },
  { 0, NULL }
};


static int
dissect_lix2_EPSInterworkingIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t EPSSubscriberIDs_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSSubscriberIDs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSSubscriberIDs_sequence, hf_index, ett_lix2_EPSSubscriberIDs);

  return offset;
}



static int
dissect_lix2_EPSBearerID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t EPSPDNCnxInfo_sequence[] = {
  { &hf_lix2_pGWS8ControlPlaneFTEID, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_linkedBearerID , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSPDNCnxInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSPDNCnxInfo_sequence, hf_index, ett_lix2_EPSPDNCnxInfo);

  return offset;
}



static int
dissect_lix2_QCI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t EPSBearers_sequence[] = {
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_pGWS8UserPlaneFTEID, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_qCI            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_QCI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSBearers(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSBearers_sequence, hf_index, ett_lix2_EPSBearers);

  return offset;
}


static const ber_sequence_t EPSBearerInfo_sequence_of[1] = {
  { &hf_lix2_EPSBearerInfo_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_EPSBearers },
};

static int
dissect_lix2_EPSBearerInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      EPSBearerInfo_sequence_of, hf_index, ett_lix2_EPSBearerInfo);

  return offset;
}


static const ber_sequence_t EPS5GSComboInfo_sequence[] = {
  { &hf_lix2_ePSInterworkingIndication, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSInterworkingIndication },
  { &hf_lix2_ePSSubscriberIDs, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSSubscriberIDs },
  { &hf_lix2_ePSPDNCnxInfo_01, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNCnxInfo },
  { &hf_lix2_ePSBearerInfo  , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerInfo },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPS5GSComboInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPS5GSComboInfo_sequence, hf_index, ett_lix2_EPS5GSComboInfo);

  return offset;
}


static const ber_sequence_t SMFServingNetwork_sequence[] = {
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_nID            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFServingNetwork(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFServingNetwork_sequence, hf_index, ett_lix2_SMFServingNetwork);

  return offset;
}


static const value_string lix2_HandoverState_vals[] = {
  {   1, "none" },
  {   2, "preparing" },
  {   3, "prepared" },
  {   4, "completed" },
  {   5, "cancelled" },
  { 0, NULL }
};


static int
dissect_lix2_HandoverState(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t FTEIDList_sequence_of[1] = {
  { &hf_lix2_FTEIDList_item , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_FTEID },
};

static int
dissect_lix2_FTEIDList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      FTEIDList_sequence_of, hf_index, ett_lix2_FTEIDList);

  return offset;
}



static int
dissect_lix2_QFI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_QOSRules(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_QOSFlowDescription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_FiveQI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t QOSFlowProfile_sequence[] = {
  { &hf_lix2_fiveQI         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_FiveQI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_QOSFlowProfile(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   QOSFlowProfile_sequence, hf_index, ett_lix2_QOSFlowProfile);

  return offset;
}


static const ber_sequence_t QOSFlowList_sequence[] = {
  { &hf_lix2_qFI            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_QFI },
  { &hf_lix2_qOSRules       , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_QOSRules },
  { &hf_lix2_eBI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_qOSFlowDescription, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_QOSFlowDescription },
  { &hf_lix2_qOSFlowProfile , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_QOSFlowProfile },
  { &hf_lix2_associatedANType, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_defaultQOSRuleIndication, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_QOSFlowList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   QOSFlowList_sequence, hf_index, ett_lix2_QOSFlowList);

  return offset;
}


static const ber_sequence_t QOSFlowLists_sequence_of[1] = {
  { &hf_lix2_QOSFlowLists_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_QOSFlowList },
};

static int
dissect_lix2_QOSFlowLists(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      QOSFlowLists_sequence_of, hf_index, ett_lix2_QOSFlowLists);

  return offset;
}


static const ber_sequence_t QOSFlowTunnelInformation_sequence[] = {
  { &hf_lix2_uPTunnelInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_associatedQOSFlowList, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_QOSFlowLists },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_QOSFlowTunnelInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   QOSFlowTunnelInformation_sequence, hf_index, ett_lix2_QOSFlowTunnelInformation);

  return offset;
}


static const ber_sequence_t QOSFlowTunnelInformationList_sequence_of[1] = {
  { &hf_lix2_QOSFlowTunnelInformationList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_QOSFlowTunnelInformation },
};

static int
dissect_lix2_QOSFlowTunnelInformationList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      QOSFlowTunnelInformationList_sequence_of, hf_index, ett_lix2_QOSFlowTunnelInformationList);

  return offset;
}


static const ber_sequence_t DLRANTunnelInformation_sequence[] = {
  { &hf_lix2_dLQOSFlowTunnelInformation, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_QOSFlowTunnelInformation },
  { &hf_lix2_additionalDLQOSFlowTunnelInformation, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_QOSFlowTunnelInformationList },
  { &hf_lix2_redundantDLQOSFlowTunnelInformation, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_QOSFlowTunnelInformationList },
  { &hf_lix2_additionalredundantDLQOSFlowTunnelInformation, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_QOSFlowTunnelInformationList },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_DLRANTunnelInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   DLRANTunnelInformation_sequence, hf_index, ett_lix2_DLRANTunnelInformation);

  return offset;
}


static const ber_sequence_t FiveGSGTPTunnels_sequence[] = {
  { &hf_lix2_uLNGUUPTunnelInformation, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_additionalULNGUUPTunnelInformation, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEIDList },
  { &hf_lix2_dLRANTunnelInformation, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DLRANTunnelInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGSGTPTunnels(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGSGTPTunnels_sequence, hf_index, ett_lix2_FiveGSGTPTunnels);

  return offset;
}


static const ber_sequence_t EPSGTPTunnels_sequence[] = {
  { &hf_lix2_controlPlaneSenderFTEID, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_controlPlanePGWS5S8FTEID, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_s1UeNodeBFTEID , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_s5S8SGWFTEID   , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_s5S8PGWFTEID   , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_s2bUePDGFTEID  , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_s2aUePDGFTEID  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSGTPTunnels(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSGTPTunnels_sequence, hf_index, ett_lix2_EPSGTPTunnels);

  return offset;
}


static const ber_sequence_t GTPTunnelInfo_sequence[] = {
  { &hf_lix2_fiveGSGTPTunnels, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSGTPTunnels },
  { &hf_lix2_ePSGTPTunnels  , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSGTPTunnels },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GTPTunnelInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   GTPTunnelInfo_sequence, hf_index, ett_lix2_GTPTunnelInfo);

  return offset;
}



static int
dissect_lix2_PCCRuleID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_IPAddress_vals[] = {
  {   1, "iPv4Address" },
  {   2, "iPv6Address" },
  { 0, NULL }
};

static const ber_choice_t IPAddress_choice[] = {
  {   1, &hf_lix2_iPv4Address    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IPv4Address },
  {   2, &hf_lix2_iPv6Address    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_IPv6Address },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IPAddress(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 IPAddress_choice, hf_index, ett_lix2_IPAddress,
                                 NULL);

  return offset;
}


static const ber_sequence_t IPMask_sequence[] = {
  { &hf_lix2_fromIPAddress  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_toIPAddress    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IPMask(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   IPMask_sequence, hf_index, ett_lix2_IPMask);

  return offset;
}


static const value_string lix2_AnyIPAddress_vals[] = {
  {   1, "any" },
  { 0, NULL }
};


static int
dissect_lix2_AnyIPAddress(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_IPAddressOrRangeOrAny_vals[] = {
  {   1, "iPAddress" },
  {   2, "ipAddressRange" },
  {   3, "anyIPAddress" },
  { 0, NULL }
};

static const ber_choice_t IPAddressOrRangeOrAny_choice[] = {
  {   1, &hf_lix2_iPAddress      , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IPAddress },
  {   2, &hf_lix2_ipAddressRange , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_IPMask },
  {   3, &hf_lix2_anyIPAddress   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_AnyIPAddress },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IPAddressOrRangeOrAny(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 IPAddressOrRangeOrAny_choice, hf_index, ett_lix2_IPAddressOrRangeOrAny,
                                 NULL);

  return offset;
}



static int
dissect_lix2_PortNumber(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_NextLayerProtocol(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const value_string lix2_AnyNextLayerProtocol_vals[] = {
  {   1, "ip" },
  { 0, NULL }
};


static int
dissect_lix2_AnyNextLayerProtocol(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_NextLayerProtocolOrAny_vals[] = {
  {   1, "nextLayerProtocol" },
  {   2, "anyNextLayerProtocol" },
  { 0, NULL }
};

static const ber_choice_t NextLayerProtocolOrAny_choice[] = {
  {   1, &hf_lix2_nextLayerProtocol, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NextLayerProtocol },
  {   2, &hf_lix2_anyNextLayerProtocol, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AnyNextLayerProtocol },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NextLayerProtocolOrAny(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 NextLayerProtocolOrAny_choice, hf_index, ett_lix2_NextLayerProtocolOrAny,
                                 NULL);

  return offset;
}


static const ber_sequence_t FlowDescription_sequence[] = {
  { &hf_lix2_sourceIPAddress, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddressOrRangeOrAny },
  { &hf_lix2_destinationIPAddress, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddressOrRangeOrAny },
  { &hf_lix2_sourcePortNumber, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_destinationPortNumber, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_protocol       , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_NextLayerProtocolOrAny },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FlowDescription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FlowDescription_sequence, hf_index, ett_lix2_FlowDescription);

  return offset;
}



static int
dissect_lix2_OCTET_STRING_SIZE_2(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_FDir_vals[] = {
  {   1, "downlink" },
  { 0, NULL }
};


static int
dissect_lix2_FDir(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_BIT_STRING_SIZE_3(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}



static int
dissect_lix2_BIT_STRING_SIZE_1(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}



static int
dissect_lix2_BIT_STRING_SIZE_12(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}


static const ber_sequence_t VLANTag_sequence[] = {
  { &hf_lix2_priority       , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_3 },
  { &hf_lix2_cFI            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_1 },
  { &hf_lix2_vLANID         , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_12 },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_VLANTag(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   VLANTag_sequence, hf_index, ett_lix2_VLANTag);

  return offset;
}


static const ber_sequence_t SET_OF_VLANTag_set_of[1] = {
  { &hf_lix2_vlanTags_item  , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_VLANTag },
};

static int
dissect_lix2_SET_OF_VLANTag(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 SET_OF_VLANTag_set_of, hf_index, ett_lix2_SET_OF_VLANTag);

  return offset;
}


static const ber_sequence_t EthFlowDescription_sequence[] = {
  { &hf_lix2_destMacAddress , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MACAddress },
  { &hf_lix2_ethType        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_2 },
  { &hf_lix2_fDesc          , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FlowDescription },
  { &hf_lix2_fDir           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FDir },
  { &hf_lix2_sourceMacAddress, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MACAddress },
  { &hf_lix2_vlanTags       , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_SET_OF_VLANTag },
  { &hf_lix2_srcMacAddrEnd  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MACAddress },
  { &hf_lix2_destMacAddrEnd , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MACAddress },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EthFlowDescription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EthFlowDescription_sequence, hf_index, ett_lix2_EthFlowDescription);

  return offset;
}



static int
dissect_lix2_OCTET_STRING_SIZE_4(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_FlowDirection_vals[] = {
  {   1, "downlinkOnly" },
  {   2, "uplinkOnly" },
  {   3, "dowlinkAndUplink" },
  { 0, NULL }
};


static int
dissect_lix2_FlowDirection(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t FlowInformation_sequence[] = {
  { &hf_lix2_flowDescription, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FlowDescription },
  { &hf_lix2_ethFlowDescription, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EthFlowDescription },
  { &hf_lix2_tosTrafficClass, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_2 },
  { &hf_lix2_spi            , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_4 },
  { &hf_lix2_flowLabel      , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_3 },
  { &hf_lix2_flowDirection  , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FlowDirection },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FlowInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FlowInformation_sequence, hf_index, ett_lix2_FlowInformation);

  return offset;
}


static const ber_sequence_t FlowInformationSet_set_of[1] = {
  { &hf_lix2_FlowInformationSet_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_FlowInformation },
};

static int
dissect_lix2_FlowInformationSet(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 FlowInformationSet_set_of, hf_index, ett_lix2_FlowInformationSet);

  return offset;
}



static int
dissect_lix2_DNAI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t RouteInfo_sequence[] = {
  { &hf_lix2_iPAddressTunnelEndpoint, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_uDPPortNumberTunnelEndpoint, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RouteInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RouteInfo_sequence, hf_index, ett_lix2_RouteInfo);

  return offset;
}


static const ber_sequence_t RouteToLocation_sequence[] = {
  { &hf_lix2_dNAI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_DNAI },
  { &hf_lix2_routeInfo      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_RouteInfo },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RouteToLocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RouteToLocation_sequence, hf_index, ett_lix2_RouteToLocation);

  return offset;
}


static const ber_sequence_t RouteToLocationSet_set_of[1] = {
  { &hf_lix2_RouteToLocationSet_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_RouteToLocation },
};

static int
dissect_lix2_RouteToLocationSet(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 RouteToLocationSet_set_of, hf_index, ett_lix2_RouteToLocationSet);

  return offset;
}


static const value_string lix2_DNAIChangeType_vals[] = {
  {   1, "early" },
  {   2, "earlyAndLate" },
  {   3, "late" },
  { 0, NULL }
};


static int
dissect_lix2_DNAIChangeType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t EASServerAddress_sequence[] = {
  { &hf_lix2_iPAddress      , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_port           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EASServerAddress(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EASServerAddress_sequence, hf_index, ett_lix2_EASServerAddress);

  return offset;
}


static const ber_sequence_t EASIPReplaceInfos_sequence[] = {
  { &hf_lix2_sourceEASAddress, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EASServerAddress },
  { &hf_lix2_targetEASAddress, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EASServerAddress },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EASIPReplaceInfos(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EASIPReplaceInfos_sequence, hf_index, ett_lix2_EASIPReplaceInfos);

  return offset;
}


static const ber_sequence_t PCCRule_sequence[] = {
  { &hf_lix2_pCCRuleID      , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PCCRuleID },
  { &hf_lix2_appId          , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_flowInfos      , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FlowInformationSet },
  { &hf_lix2_appReloc       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_simConnInd     , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_simConnTerm    , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_maxAllowedUpLat, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_trafficRoutes  , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_RouteToLocationSet },
  { &hf_lix2_trafficSteeringPolIdDl, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_trafficSteeringPolIdUl, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_deprecatedSourceDNAI, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNAI },
  { &hf_lix2_deprecatedTargetDNAI, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNAI },
  { &hf_lix2_deprecatedDNAIChangeType, BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNAIChangeType },
  { &hf_lix2_deprecatedSourceUEIPAddr, BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_deprecatedTargetUEIPAddr, BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_sourceTrafficRouting, BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RouteToLocation },
  { &hf_lix2_targetTrafficRouting, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RouteToLocation },
  { &hf_lix2_eASIPReplaceInfos, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASIPReplaceInfos },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PCCRule(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PCCRule_sequence, hf_index, ett_lix2_PCCRule);

  return offset;
}


static const ber_sequence_t PCCRuleSet_set_of[1] = {
  { &hf_lix2_PCCRuleSet_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PCCRule },
};

static int
dissect_lix2_PCCRuleSet(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 PCCRuleSet_set_of, hf_index, ett_lix2_PCCRuleSet);

  return offset;
}



static int
dissect_lix2_IMSIUnauthenticatedIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}


static const value_string lix2_PDNConnectionType_vals[] = {
  {   1, "iPv4" },
  {   2, "iPv6" },
  {   3, "iPv4v6" },
  {   4, "nonIP" },
  {   5, "ethernet" },
  { 0, NULL }
};


static int
dissect_lix2_PDNConnectionType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_APN(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_EPSPDNConnectionRequestType_vals[] = {
  {   1, "initialRequest" },
  {   2, "handover" },
  {   3, "rLOS" },
  {   4, "emergency" },
  {   5, "handoverOfEmergencyBearerServices" },
  {   6, "reserved" },
  { 0, NULL }
};


static int
dissect_lix2_EPSPDNConnectionRequestType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_T_requestPCO(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  unsigned tvb_len;

  tvb_len = tvb_reported_length(tvb);

  actx->pinfo->link_dir = P2P_DIR_UL;
  de_sm_pco(tvb, tree, actx->pinfo, 0, tvb_len, NULL, 0);

  offset = tvb_len;


  return offset;
}



static int
dissect_lix2_T_requestAPCO(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  unsigned tvb_len;

  tvb_len = tvb_reported_length(tvb);

  actx->pinfo->link_dir = P2P_DIR_UL;
  de_sm_pco(tvb, tree, actx->pinfo, 0, tvb_len, NULL, 0);

  offset = tvb_len;


  return offset;
}



static int
dissect_lix2_T_requestEPCO(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  unsigned tvb_len;

  tvb_len = tvb_reported_length(tvb);

  actx->pinfo->link_dir = P2P_DIR_UL;
  de_sm_pco(tvb, tree, actx->pinfo, 0, tvb_len, NULL, 0);

  offset = tvb_len;


  return offset;
}



static int
dissect_lix2_T_responsePCO(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  unsigned tvb_len;

  tvb_len = tvb_reported_length(tvb);

  actx->pinfo->link_dir = P2P_DIR_DL;
  de_sm_pco(tvb, tree, actx->pinfo, 0, tvb_len, NULL, 0);

  offset = tvb_len;


  return offset;
}



static int
dissect_lix2_T_responseAPCO(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  unsigned tvb_len;

  tvb_len = tvb_reported_length(tvb);

  actx->pinfo->link_dir = P2P_DIR_DL;
  de_sm_pco(tvb, tree, actx->pinfo, 0, tvb_len, NULL, 0);

  offset = tvb_len;


  return offset;
}



static int
dissect_lix2_T_responseEPCO(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  unsigned tvb_len;

  tvb_len = tvb_reported_length(tvb);

  actx->pinfo->link_dir = P2P_DIR_DL;
  de_sm_pco(tvb, tree, actx->pinfo, 0, tvb_len, NULL, 0);

  offset = tvb_len;


  return offset;
}


static const ber_sequence_t PDNProtocolConfigurationOptions_sequence[] = {
  { &hf_lix2_requestPCO     , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_T_requestPCO },
  { &hf_lix2_requestAPCO    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_T_requestAPCO },
  { &hf_lix2_requestEPCO    , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_T_requestEPCO },
  { &hf_lix2_responsePCO    , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_T_responsePCO },
  { &hf_lix2_responseAPCO   , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_T_responseAPCO },
  { &hf_lix2_responseEPCO   , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_T_responseEPCO },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PDNProtocolConfigurationOptions(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PDNProtocolConfigurationOptions_sequence, hf_index, ett_lix2_PDNProtocolConfigurationOptions);

  return offset;
}



static int
dissect_lix2_EPSBearerCreationCauseValue(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_BitrateBinKBPS(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_EPSQOSPriority(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t EPSBearerQOS_sequence[] = {
  { &hf_lix2_qCI            , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_QCI },
  { &hf_lix2_maximumUplinkBitRate, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BitrateBinKBPS },
  { &hf_lix2_maximumDownlinkBitRate, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BitrateBinKBPS },
  { &hf_lix2_guaranteedUplinkBitRate, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BitrateBinKBPS },
  { &hf_lix2_guaranteedDownlinkBitRate, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BitrateBinKBPS },
  { &hf_lix2_priorityLevel  , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSQOSPriority },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSBearerQOS(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSBearerQOS_sequence, hf_index, ett_lix2_EPSBearerQOS);

  return offset;
}


static const ber_sequence_t EPSBearerContextCreated_sequence[] = {
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_cause_02       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerCreationCauseValue },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_bearerQOS      , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerQOS },
  { &hf_lix2_protocolConfigurationOptions, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNProtocolConfigurationOptions },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSBearerContextCreated(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSBearerContextCreated_sequence, hf_index, ett_lix2_EPSBearerContextCreated);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_EPSBearerContextCreated_sequence_of[1] = {
  { &hf_lix2_bearerContextsCreated_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_EPSBearerContextCreated },
};

static int
dissect_lix2_SEQUENCE_OF_EPSBearerContextCreated(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_EPSBearerContextCreated_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_EPSBearerContextCreated);

  return offset;
}



static int
dissect_lix2_EPSBearerRemovalCauseValue(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t EPSBearerContextForRemoval_sequence[] = {
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_cause_05       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerRemovalCauseValue },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSBearerContextForRemoval(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSBearerContextForRemoval_sequence, hf_index, ett_lix2_EPSBearerContextForRemoval);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_EPSBearerContextForRemoval_sequence_of[1] = {
  { &hf_lix2_bearerContextsMarkedForRemoval_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_EPSBearerContextForRemoval },
};

static int
dissect_lix2_SEQUENCE_OF_EPSBearerContextForRemoval(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_EPSBearerContextForRemoval_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_EPSBearerContextForRemoval);

  return offset;
}



static int
dissect_lix2_PDNConnectionIndicationFlags(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  proto_tree *eps_indicationFlags_tree;
  unsigned tvb_len;

  /*
   * 8.22 User Location Info (ULI)
   * 3GPP TS 29.274
   */

  tvb_len = tvb_reported_length(tvb);
  eps_indicationFlags_tree = proto_tree_add_subtree(tree, tvb, 0, tvb_len, ett_lix2_eps_indicationflags, NULL, "indicationFlags");

  dissect_gtpv2_ind(tvb, actx->pinfo, eps_indicationFlags_tree, NULL, tvb_len, 0, 0, NULL);

  offset = tvb_len;


  return offset;
}



static int
dissect_lix2_PDNHandoverIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_PDNNBIFOMSupport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_FiveGSInterworkingIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_FiveGSInterworkingWithoutN26(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_FiveGCNotRestrictedSupport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}


static const ber_sequence_t FiveGSInterworkingInfo_sequence[] = {
  { &hf_lix2_fiveGSInterworkingIndicator, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSInterworkingIndicator },
  { &hf_lix2_fiveGSInterworkingWithoutN26, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSInterworkingWithoutN26 },
  { &hf_lix2_fiveGCNotRestrictedSupport, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGCNotRestrictedSupport },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGSInterworkingInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGSInterworkingInfo_sequence, hf_index, ett_lix2_FiveGSInterworkingInfo);

  return offset;
}



static int
dissect_lix2_CSRMFI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_RestorationOfPDNConnectionsSupport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_PGWChangeIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_PGWRNSI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}


static const ber_sequence_t EPSPDNConnectionEstablishment_sequence[] = {
  { &hf_lix2_ePSSubscriberIDs, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSSubscriberIDs },
  { &hf_lix2_iMSIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSIUnauthenticatedIndication },
  { &hf_lix2_defaultBearerID, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_pDNConnectionType, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PDNConnectionType },
  { &hf_lix2_uEEndpoints    , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UEEndpointAddress },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_location       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_additionalLocation, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_aPN            , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_APN },
  { &hf_lix2_requestType_01 , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionRequestType },
  { &hf_lix2_accessType     , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_rATType        , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_protocolConfigurationOptions, BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNProtocolConfigurationOptions },
  { &hf_lix2_servingNetwork , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFServingNetwork },
  { &hf_lix2_sMPDUDNRequest , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMPDUDNRequest },
  { &hf_lix2_bearerContextsCreated, BER_CLASS_CON, 17, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSBearerContextCreated },
  { &hf_lix2_bearerContextsMarkedForRemoval, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSBearerContextForRemoval },
  { &hf_lix2_indicationFlags, BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNConnectionIndicationFlags },
  { &hf_lix2_handoverIndication, BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNHandoverIndication },
  { &hf_lix2_nBIFOMSupport  , BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNNBIFOMSupport },
  { &hf_lix2_fiveGSInterworkingInfo, BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSInterworkingInfo },
  { &hf_lix2_cSRMFI         , BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CSRMFI },
  { &hf_lix2_restorationOfPDNConnectionsSupport, BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RestorationOfPDNConnectionsSupport },
  { &hf_lix2_pGWChangeIndication, BER_CLASS_CON, 25, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PGWChangeIndication },
  { &hf_lix2_pGWRNSI        , BER_CLASS_CON, 26, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PGWRNSI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSPDNConnectionEstablishment(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSPDNConnectionEstablishment_sequence, hf_index, ett_lix2_EPSPDNConnectionEstablishment);

  return offset;
}



static int
dissect_lix2_SBIReference(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_SBIValue(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t SBIType_sequence[] = {
  { &hf_lix2_sBIReference   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SBIReference },
  { &hf_lix2_sBIValue       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SBIValue },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SBIType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SBIType_sequence, hf_index, ett_lix2_SBIType);

  return offset;
}



static int
dissect_lix2_GEOSatelliteID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t SMFPDUSessionEstablishment_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUPIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUPIUnauthenticatedIndication },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_gTPTunnelID    , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_pDUSessionType , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionType },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_uEEndpoint     , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UEEndpointAddress },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_location       , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_dNN            , BER_CLASS_CON, 12, BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_aMFID          , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AMFID },
  { &hf_lix2_hSMFURI        , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HSMFURI },
  { &hf_lix2_requestType    , BER_CLASS_CON, 15, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMRequestType },
  { &hf_lix2_accessType     , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_rATType        , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_sMPDUDNRequest , BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMPDUDNRequest },
  { &hf_lix2_uEEPSPDNConnection, BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEEPSPDNConnection },
  { &hf_lix2_ePS5GSComboInfo, BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPS5GSComboInfo },
  { &hf_lix2_selectedDNN    , BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_servingNetwork , BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFServingNetwork },
  { &hf_lix2_oldPDUSessionID, BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_handoverState  , BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HandoverState },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 25, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_pCCRules       , BER_CLASS_CON, 26, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PCCRuleSet },
  { &hf_lix2_ePSPDNConnectionEstablishment, BER_CLASS_CON, 27, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionEstablishment },
  { &hf_lix2_satelliteBackhaulCategory, BER_CLASS_CON, 28, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_gEOSatelliteID , BER_CLASS_CON, 29, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GEOSatelliteID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFPDUSessionEstablishment(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFPDUSessionEstablishment_sequence, hf_index, ett_lix2_SMFPDUSessionEstablishment);

  return offset;
}



static int
dissect_lix2_EPSBearerModificationCauseValue(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_EPSBearerID_sequence_of[1] = {
  { &hf_lix2_linkedBearerIDs_item, BER_CLASS_UNI, BER_UNI_TAG_INTEGER, BER_FLAGS_NOOWNTAG, dissect_lix2_EPSBearerID },
};

static int
dissect_lix2_SEQUENCE_OF_EPSBearerID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_EPSBearerID_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_EPSBearerID);

  return offset;
}


static const ber_sequence_t EPSBearerContextModified_sequence[] = {
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_cause_03       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerModificationCauseValue },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_bearerQOS      , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerQOS },
  { &hf_lix2_protocolConfigurationOptions, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNProtocolConfigurationOptions },
  { &hf_lix2_linkedBearerIDs, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSBearerID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSBearerContextModified(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSBearerContextModified_sequence, hf_index, ett_lix2_EPSBearerContextModified);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_EPSBearerContextModified_sequence_of[1] = {
  { &hf_lix2_bearerContextsModified_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_EPSBearerContextModified },
};

static int
dissect_lix2_SEQUENCE_OF_EPSBearerContextModified(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_EPSBearerContextModified_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_EPSBearerContextModified);

  return offset;
}



static int
dissect_lix2_EPSBearerDeletionCauseValue(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_EPSRANNASCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t EPSDeleteBearerContext_sequence[] = {
  { &hf_lix2_cause_04       , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerDeletionCauseValue },
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_protocolConfigurationOptions, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNProtocolConfigurationOptions },
  { &hf_lix2_rANNASCause    , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANNASCause },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSDeleteBearerContext(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSDeleteBearerContext_sequence, hf_index, ett_lix2_EPSDeleteBearerContext);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_EPSDeleteBearerContext_sequence_of[1] = {
  { &hf_lix2_bearerContexts_item_01, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_EPSDeleteBearerContext },
};

static int
dissect_lix2_SEQUENCE_OF_EPSDeleteBearerContext(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_EPSDeleteBearerContext_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_EPSDeleteBearerContext);

  return offset;
}


static const ber_sequence_t EPSDeleteBearerResponse_sequence[] = {
  { &hf_lix2_cause_04       , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerDeletionCauseValue },
  { &hf_lix2_linkedEPSBearerID, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_bearerContexts_01, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSDeleteBearerContext },
  { &hf_lix2_protocolConfigurationOptions, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNProtocolConfigurationOptions },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSDeleteBearerResponse(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSDeleteBearerResponse_sequence, hf_index, ett_lix2_EPSDeleteBearerResponse);

  return offset;
}


static const ber_sequence_t EPSBearersDeleted_sequence[] = {
  { &hf_lix2_linkedEPSBearerID, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_ePSBearerIDs   , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSBearerID },
  { &hf_lix2_protocolConfigurationOptions, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNProtocolConfigurationOptions },
  { &hf_lix2_cause_04       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerDeletionCauseValue },
  { &hf_lix2_deleteBearerResponse, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_EPSDeleteBearerResponse },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSBearersDeleted(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSBearersDeleted_sequence, hf_index, ett_lix2_EPSBearersDeleted);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_EPSBearersDeleted_sequence_of[1] = {
  { &hf_lix2_bearersDeleted_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_EPSBearersDeleted },
};

static int
dissect_lix2_SEQUENCE_OF_EPSBearersDeleted(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_EPSBearersDeleted_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_EPSBearersDeleted);

  return offset;
}


static const ber_sequence_t EPSPDNConnectionModification_sequence[] = {
  { &hf_lix2_ePSSubscriberIDs, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSSubscriberIDs },
  { &hf_lix2_iMSIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSIUnauthenticatedIndication },
  { &hf_lix2_defaultBearerID, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_pDNConnectionType, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PDNConnectionType },
  { &hf_lix2_uEEndpoints    , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UEEndpointAddress },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_location       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_additionalLocation, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_aPN            , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_APN },
  { &hf_lix2_requestType_01 , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionRequestType },
  { &hf_lix2_accessType     , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_rATType        , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_protocolConfigurationOptions, BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNProtocolConfigurationOptions },
  { &hf_lix2_servingNetwork , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFServingNetwork },
  { &hf_lix2_sMPDUDNRequest , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMPDUDNRequest },
  { &hf_lix2_bearerContextsCreated, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSBearerContextCreated },
  { &hf_lix2_bearerContextsModified, BER_CLASS_CON, 18, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSBearerContextModified },
  { &hf_lix2_bearerContextsMarkedForRemoval, BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSBearerContextForRemoval },
  { &hf_lix2_bearersDeleted , BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSBearersDeleted },
  { &hf_lix2_indicationFlags, BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNConnectionIndicationFlags },
  { &hf_lix2_handoverIndication, BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNHandoverIndication },
  { &hf_lix2_nBIFOMSupport  , BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNNBIFOMSupport },
  { &hf_lix2_fiveGSInterworkingInfo, BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSInterworkingInfo },
  { &hf_lix2_cSRMFI         , BER_CLASS_CON, 25, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CSRMFI },
  { &hf_lix2_restorationOfPDNConnectionsSupport, BER_CLASS_CON, 26, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RestorationOfPDNConnectionsSupport },
  { &hf_lix2_pGWChangeIndication, BER_CLASS_CON, 27, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PGWChangeIndication },
  { &hf_lix2_pGWRNSI        , BER_CLASS_CON, 28, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PGWRNSI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSPDNConnectionModification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSPDNConnectionModification_sequence, hf_index, ett_lix2_EPSPDNConnectionModification);

  return offset;
}


static const ber_sequence_t UPPathChange_sequence[] = {
  { &hf_lix2_sourceDNAI     , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNAI },
  { &hf_lix2_targetDNAI     , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNAI },
  { &hf_lix2_dNAIChangeType , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNAIChangeType },
  { &hf_lix2_sourceUEIPAddr , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_targetUEIPAddr , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_sourceTrafficRouting, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RouteToLocation },
  { &hf_lix2_targetTrafficRouting, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RouteToLocation },
  { &hf_lix2_mACAddress     , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MACAddress },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UPPathChange(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UPPathChange_sequence, hf_index, ett_lix2_UPPathChange);

  return offset;
}


static const ber_sequence_t PFDFlowDescription_sequence[] = {
  { &hf_lix2_nextLayerProtocol, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NextLayerProtocol },
  { &hf_lix2_serverIPAddress, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_serverPortNumber, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PFDFlowDescription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PFDFlowDescription_sequence, hf_index, ett_lix2_PFDFlowDescription);

  return offset;
}


static const ber_sequence_t PFDFlowDescriptions_set_of[1] = {
  { &hf_lix2_PFDFlowDescriptions_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PFDFlowDescription },
};

static int
dissect_lix2_PFDFlowDescriptions(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 PFDFlowDescriptions_set_of, hf_index, ett_lix2_PFDFlowDescriptions);

  return offset;
}


static const ber_sequence_t PFDURLs_set_of[1] = {
  { &hf_lix2_PFDURLs_item   , BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_UTF8String },
};

static int
dissect_lix2_PFDURLs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 PFDURLs_set_of, hf_index, ett_lix2_PFDURLs);

  return offset;
}


static const ber_sequence_t DomainNames_set_of[1] = {
  { &hf_lix2_DomainNames_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_UTF8String },
};

static int
dissect_lix2_DomainNames(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 DomainNames_set_of, hf_index, ett_lix2_DomainNames);

  return offset;
}


static const value_string lix2_DnProtocol_vals[] = {
  {   1, "dnsQname" },
  {   2, "tlsSni" },
  {   3, "tlsSan" },
  {   4, "tlsScn" },
  { 0, NULL }
};


static int
dissect_lix2_DnProtocol(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PFD_sequence[] = {
  { &hf_lix2_pFDId          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pFDFlowDescriptions, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PFDFlowDescriptions },
  { &hf_lix2_urls           , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PFDURLs },
  { &hf_lix2_domainNames    , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_DomainNames },
  { &hf_lix2_dnProtocol     , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_DnProtocol },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PFD(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PFD_sequence, hf_index, ett_lix2_PFD);

  return offset;
}


static const ber_sequence_t PFDs_set_of[1] = {
  { &hf_lix2_PFDs_item      , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PFD },
};

static int
dissect_lix2_PFDs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 PFDs_set_of, hf_index, ett_lix2_PFDs);

  return offset;
}


static const ber_sequence_t PFDDataForApp_sequence[] = {
  { &hf_lix2_aPPId          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pFDs           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PFDs },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PFDDataForApp(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PFDDataForApp_sequence, hf_index, ett_lix2_PFDDataForApp);

  return offset;
}


static const ber_sequence_t SMFPDUSessionModification_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUPIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUPIUnauthenticatedIndication },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_location       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_requestType    , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMRequestType },
  { &hf_lix2_accessType     , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_rATType        , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_ePS5GSComboInfo, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPS5GSComboInfo },
  { &hf_lix2_uEEndpoint_01  , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_servingNetwork , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFServingNetwork },
  { &hf_lix2_handoverState  , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HandoverState },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_pCCRules       , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PCCRuleSet },
  { &hf_lix2_ePSPDNConnectionModification, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionModification },
  { &hf_lix2_uPPathChange   , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UPPathChange },
  { &hf_lix2_pFDDataForApp  , BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PFDDataForApp },
  { &hf_lix2_satelliteBackhaulCategory, BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_gEOSatelliteID , BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GEOSatelliteID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFPDUSessionModification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFPDUSessionModification_sequence, hf_index, ett_lix2_SMFPDUSessionModification);

  return offset;
}



static int
dissect_lix2_SMFErrorCodes(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_NGAPCauseGroupInt(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_NGAPCauseValueInt(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t NGAPCauseInt_sequence[] = {
  { &hf_lix2_group          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NGAPCauseGroupInt },
  { &hf_lix2_value          , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NGAPCauseValueInt },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NGAPCauseInt(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NGAPCauseInt_sequence, hf_index, ett_lix2_NGAPCauseInt);

  return offset;
}


static const ber_sequence_t PCCRuleIDSet_set_of[1] = {
  { &hf_lix2_PCCRuleIDSet_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_PCCRuleID },
};

static int
dissect_lix2_PCCRuleIDSet(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 PCCRuleIDSet_set_of, hf_index, ett_lix2_PCCRuleIDSet);

  return offset;
}



static int
dissect_lix2_EPSPDNConnectionReleaseScopeIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}


static const ber_sequence_t EPSPDNConnectionRelease_sequence[] = {
  { &hf_lix2_ePSSubscriberIDs, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSSubscriberIDs },
  { &hf_lix2_iMSIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSIUnauthenticatedIndication },
  { &hf_lix2_defaultBearerID, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_location       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_rANNASCause    , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANNASCause },
  { &hf_lix2_pDNConnectionType, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_PDNConnectionType },
  { &hf_lix2_indicationFlags, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNConnectionIndicationFlags },
  { &hf_lix2_scopeIndication, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionReleaseScopeIndication },
  { &hf_lix2_bearersDeleted , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSBearersDeleted },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSPDNConnectionRelease(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSPDNConnectionRelease_sequence, hf_index, ett_lix2_EPSPDNConnectionRelease);

  return offset;
}


static const ber_sequence_t SMFPDUSessionRelease_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_timeOfFirstPacket, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_timeOfLastPacket, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_uplinkVolume   , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_downlinkVolume , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_location       , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_cause_01       , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFErrorCodes },
  { &hf_lix2_ePS5GSComboInfo, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPS5GSComboInfo },
  { &hf_lix2_nGAPCause      , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NGAPCauseInt },
  { &hf_lix2_fiveGMMCause   , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMMCause },
  { &hf_lix2_pCCRuleIDs     , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PCCRuleIDSet },
  { &hf_lix2_ePSPDNConnectionRelease, BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionRelease },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFPDUSessionRelease(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFPDUSessionRelease_sequence, hf_index, ett_lix2_SMFPDUSessionRelease);

  return offset;
}


static const ber_sequence_t EPSBearerContext_sequence[] = {
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_uPGTPTunnelInfo, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_bearerQOS      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerQOS },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSBearerContext(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSBearerContext_sequence, hf_index, ett_lix2_EPSBearerContext);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_EPSBearerContext_sequence_of[1] = {
  { &hf_lix2_bearerContexts_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_EPSBearerContext },
};

static int
dissect_lix2_SEQUENCE_OF_EPSBearerContext(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_EPSBearerContext_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_EPSBearerContext);

  return offset;
}


static const ber_sequence_t EPSStartOfInterceptionWithEstablishedPDNConnection_sequence[] = {
  { &hf_lix2_ePSSubscriberIDs, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSSubscriberIDs },
  { &hf_lix2_iMSIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSIUnauthenticatedIndication },
  { &hf_lix2_defaultBearerID, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_pDNConnectionType, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PDNConnectionType },
  { &hf_lix2_uEEndpoints    , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UEEndpointAddress },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_location       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_additionalLocation, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_aPN            , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_APN },
  { &hf_lix2_requestType_01 , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionRequestType },
  { &hf_lix2_accessType     , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_rATType        , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_protocolConfigurationOptions, BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDNProtocolConfigurationOptions },
  { &hf_lix2_servingNetwork , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFServingNetwork },
  { &hf_lix2_sMPDUDNRequest , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMPDUDNRequest },
  { &hf_lix2_bearerContexts , BER_CLASS_CON, 17, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_EPSBearerContext },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSStartOfInterceptionWithEstablishedPDNConnection(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSStartOfInterceptionWithEstablishedPDNConnection_sequence, hf_index, ett_lix2_EPSStartOfInterceptionWithEstablishedPDNConnection);

  return offset;
}


static const ber_sequence_t PFDDataForApps_set_of[1] = {
  { &hf_lix2_PFDDataForApps_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PFDDataForApp },
};

static int
dissect_lix2_PFDDataForApps(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 PFDDataForApps_set_of, hf_index, ett_lix2_PFDDataForApps);

  return offset;
}


static const ber_sequence_t SMFStartOfInterceptionWithEstablishedPDUSession_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUPIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUPIUnauthenticatedIndication },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_gTPTunnelID    , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_pDUSessionType , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionType },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_uEEndpoint     , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UEEndpointAddress },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_location       , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_dNN            , BER_CLASS_CON, 12, BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_aMFID          , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AMFID },
  { &hf_lix2_hSMFURI        , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HSMFURI },
  { &hf_lix2_requestType    , BER_CLASS_CON, 15, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMRequestType },
  { &hf_lix2_accessType     , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_rATType        , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_sMPDUDNRequest , BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMPDUDNRequest },
  { &hf_lix2_timeOfSessionEstablishment, BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_ePS5GSComboInfo, BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPS5GSComboInfo },
  { &hf_lix2_uEEPSPDNConnection, BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEEPSPDNConnection },
  { &hf_lix2_servingNetwork , BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFServingNetwork },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_pCCRules       , BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PCCRuleSet },
  { &hf_lix2_ePSStartOfInterceptionWithEstablishedPDNConnection, BER_CLASS_CON, 25, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSStartOfInterceptionWithEstablishedPDNConnection },
  { &hf_lix2_pFDDataForApps , BER_CLASS_CON, 26, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PFDDataForApps },
  { &hf_lix2_satelliteBackhaulCategory, BER_CLASS_CON, 27, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_gEOSatelliteID , BER_CLASS_CON, 28, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GEOSatelliteID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFStartOfInterceptionWithEstablishedPDUSession(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFStartOfInterceptionWithEstablishedPDUSession_sequence, hf_index, ett_lix2_SMFStartOfInterceptionWithEstablishedPDUSession);

  return offset;
}


static const value_string lix2_SMFFailedProcedureType_vals[] = {
  {   1, "pDUSessionEstablishment" },
  {   2, "pDUSessionModification" },
  {   3, "pDUSessionRelease" },
  { 0, NULL }
};


static int
dissect_lix2_SMFFailedProcedureType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_Initiator_vals[] = {
  {   1, "uE" },
  {   2, "network" },
  {   3, "unknown" },
  { 0, NULL }
};


static int
dissect_lix2_Initiator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SMFUnsuccessfulProcedure_sequence[] = {
  { &hf_lix2_failedProcedureType_01, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SMFFailedProcedureType },
  { &hf_lix2_failureCause_03, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMCause },
  { &hf_lix2_initiator      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_Initiator },
  { &hf_lix2_requestedSlice , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NSSAI },
  { &hf_lix2_sUPI           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUPIUnauthenticated, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUPIUnauthenticatedIndication },
  { &hf_lix2_pEI            , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_uEEndpoint     , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UEEndpointAddress },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_dNN            , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_aMFID          , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AMFID },
  { &hf_lix2_hSMFURI        , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HSMFURI },
  { &hf_lix2_requestType    , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMRequestType },
  { &hf_lix2_accessType     , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_rATType        , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_sMPDUDNRequest , BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMPDUDNRequest },
  { &hf_lix2_location       , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFUnsuccessfulProcedure(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFUnsuccessfulProcedure_sequence, hf_index, ett_lix2_SMFUnsuccessfulProcedure);

  return offset;
}



static int
dissect_lix2_MMEGI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_NumericString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_MMEC(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_NumericString,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t MMEID_sequence[] = {
  { &hf_lix2_mMEGI          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMEGI },
  { &hf_lix2_mMEC           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMEC },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMEID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMEID_sequence, hf_index, ett_lix2_MMEID);

  return offset;
}


static const ber_sequence_t GUMMEI_sequence[] = {
  { &hf_lix2_mMEID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMEID },
  { &hf_lix2_mCC            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MCC },
  { &hf_lix2_mNC            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_MNC },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GUMMEI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   GUMMEI_sequence, hf_index, ett_lix2_GUMMEI);

  return offset;
}


static const value_string lix2_UDMServingSystemMethod_vals[] = {
  {   0, "amf3GPPAccessRegistration" },
  {   1, "amfNon3GPPAccessRegistration" },
  {   2, "unknown" },
  { 0, NULL }
};


static int
dissect_lix2_UDMServingSystemMethod(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_CAGID_sequence_of[1] = {
  { &hf_lix2_cAGID_item     , BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_CAGID },
};

static int
dissect_lix2_SEQUENCE_OF_CAGID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_CAGID_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_CAGID);

  return offset;
}


static const ber_sequence_t ServiceID_sequence[] = {
  { &hf_lix2_nSSAI          , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NSSAI },
  { &hf_lix2_cAGID          , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_CAGID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ServiceID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ServiceID_sequence, hf_index, ett_lix2_ServiceID);

  return offset;
}



static int
dissect_lix2_RoamingIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}


static const ber_sequence_t UDMServingSystemMessage_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUAMI          , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUAMI },
  { &hf_lix2_gUMMEI         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUMMEI },
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_servingSystemMethod, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_UDMServingSystemMethod },
  { &hf_lix2_serviceID      , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ServiceID },
  { &hf_lix2_roamingIndicator, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RoamingIndicator },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMServingSystemMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMServingSystemMessage_sequence, hf_index, ett_lix2_UDMServingSystemMessage);

  return offset;
}



static int
dissect_lix2_SMSAddress(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t SMSParty_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_sMSAddress     , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMSAddress },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMSParty(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMSParty_sequence, hf_index, ett_lix2_SMSParty);

  return offset;
}


static const value_string lix2_Direction_vals[] = {
  {   1, "fromTarget" },
  {   2, "toTarget" },
  { 0, NULL }
};


static int
dissect_lix2_Direction(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_SMSTransferStatus_vals[] = {
  {   1, "transferSucceeded" },
  {   2, "transferFailed" },
  {   3, "undefined" },
  { 0, NULL }
};


static int
dissect_lix2_SMSTransferStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_SMSOtherMessageIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}


static const value_string lix2_SMSNFAddress_vals[] = {
  {   1, "iPAddress" },
  {   2, "e164Number" },
  { 0, NULL }
};

static const ber_choice_t SMSNFAddress_choice[] = {
  {   1, &hf_lix2_iPAddress      , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IPAddress },
  {   2, &hf_lix2_e164Number     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_E164Number },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMSNFAddress(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 SMSNFAddress_choice, hf_index, ett_lix2_SMSNFAddress,
                                 NULL);

  return offset;
}


static const value_string lix2_SMSNFType_vals[] = {
  {   1, "sMSGMSC" },
  {   2, "iWMSC" },
  {   3, "sMSRouter" },
  { 0, NULL }
};


static int
dissect_lix2_SMSNFType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_SMSTPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_TruncatedSMSTPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_ThreeGPP2SMSTPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_SMSTPDUData_vals[] = {
  {   1, "sMSTPDU" },
  {   2, "truncatedSMSTPDU" },
  {   3, "redactedSMSTPDU" },
  {   4, "threeGPP2SMSTPDU" },
  {   5, "redacted3GPP2SMSTPDU" },
  { 0, NULL }
};

static const ber_choice_t SMSTPDUData_choice[] = {
  {   1, &hf_lix2_sMSTPDU        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SMSTPDU },
  {   2, &hf_lix2_truncatedSMSTPDU, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_TruncatedSMSTPDU },
  {   3, &hf_lix2_redactedSMSTPDU, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SMSTPDU },
  {   4, &hf_lix2_threeGPP2SMSTPDU, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_ThreeGPP2SMSTPDU },
  {   5, &hf_lix2_redacted3GPP2SMSTPDU, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_ThreeGPP2SMSTPDU },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMSTPDUData(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 SMSTPDUData_choice, hf_index, ett_lix2_SMSTPDUData,
                                 NULL);

  return offset;
}


static const value_string lix2_SMSMessageType_vals[] = {
  {   1, "deliver" },
  {   2, "deliverReportAck" },
  {   3, "deliverReportError" },
  {   4, "statusReport" },
  {   5, "command" },
  {   6, "submit" },
  {   7, "submitReportAck" },
  {   8, "submitReportError" },
  {   9, "reserved" },
  { 0, NULL }
};


static int
dissect_lix2_SMSMessageType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_SMSRPMessageReference(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t SMSMessage_sequence[] = {
  { &hf_lix2_originatingSMSParty, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SMSParty },
  { &hf_lix2_terminatingSMSParty_02, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SMSParty },
  { &hf_lix2_direction      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_linkTransferStatus, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SMSTransferStatus },
  { &hf_lix2_otherMessage   , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMSOtherMessageIndication },
  { &hf_lix2_location       , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_peerNFAddress  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SMSNFAddress },
  { &hf_lix2_peerNFType     , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMSNFType },
  { &hf_lix2_sMSTPDUData    , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SMSTPDUData },
  { &hf_lix2_messageType    , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMSMessageType },
  { &hf_lix2_rPMessageReference, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMSRPMessageReference },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMSMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMSMessage_sequence, hf_index, ett_lix2_SMSMessage);

  return offset;
}



static int
dissect_lix2_SIPURI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_TELURI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_IMPU_vals[] = {
  {   1, "sIPURI" },
  {   2, "tELURI" },
  { 0, NULL }
};

static const ber_choice_t IMPU_choice[] = {
  {   1, &hf_lix2_sIPURI         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SIPURI },
  {   2, &hf_lix2_tELURI         , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_TELURI },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IMPU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 IMPU_choice, hf_index, ett_lix2_IMPU,
                                 NULL);

  return offset;
}


static const ber_sequence_t LALSReport_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_deprecatedPEI  , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_location       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_iMPU           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMPU },
  { &hf_lix2_iMSI           , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LALSReport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LALSReport_sequence, hf_index, ett_lix2_LALSReport);

  return offset;
}



static int
dissect_lix2_IPv6FlowLabel(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t PDHeaderReport_sequence[] = {
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_sourceIPAddress_01, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_sourcePort     , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_destinationIPAddress_01, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_destinationPort, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_nextLayerProtocol, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_NextLayerProtocol },
  { &hf_lix2_iPv6flowLabel  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv6FlowLabel },
  { &hf_lix2_direction      , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_packetSize     , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PDHeaderReport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PDHeaderReport_sequence, hf_index, ett_lix2_PDHeaderReport);

  return offset;
}


static const value_string lix2_PDSRSummaryTrigger_vals[] = {
  {   1, "timerExpiry" },
  {   2, "packetCount" },
  {   3, "byteCount" },
  {   4, "startOfFlow" },
  {   5, "endOfFlow" },
  { 0, NULL }
};


static int
dissect_lix2_PDSRSummaryTrigger(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PDSummaryReport_sequence[] = {
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_sourceIPAddress_01, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_sourcePort     , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_destinationIPAddress_01, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_destinationPort, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_nextLayerProtocol, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_NextLayerProtocol },
  { &hf_lix2_iPv6flowLabel  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv6FlowLabel },
  { &hf_lix2_direction      , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pDSRSummaryTrigger, BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_PDSRSummaryTrigger },
  { &hf_lix2_firstPacketTimestamp, BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_lastPacketTimestamp, BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_packetCount    , BER_CLASS_CON, 12, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_byteCount      , BER_CLASS_CON, 13, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_useSessionTrigger, BER_CLASS_CON, 14, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PDSummaryReport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PDSummaryReport_sequence, hf_index, ett_lix2_PDSummaryReport);

  return offset;
}


static const ber_sequence_t MMSVersion_sequence[] = {
  { &hf_lix2_majorVersion   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_minorVersion   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSVersion(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSVersion_sequence, hf_index, ett_lix2_MMSVersion);

  return offset;
}



static int
dissect_lix2_EmailAddress(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_IMPI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lix2_NAI(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string lix2_MMSPartyID_vals[] = {
  {   1, "e164Number" },
  {   2, "emailAddress" },
  {   3, "iMSI" },
  {   4, "iMPU" },
  {   5, "iMPI" },
  {   6, "sUPI" },
  {   7, "gPSI" },
  { 0, NULL }
};

static const ber_choice_t MMSPartyID_choice[] = {
  {   1, &hf_lix2_e164Number     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_E164Number },
  {   2, &hf_lix2_emailAddress   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EmailAddress },
  {   3, &hf_lix2_iMSI           , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  {   4, &hf_lix2_iMPU           , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_IMPU },
  {   5, &hf_lix2_iMPI           , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_IMPI },
  {   6, &hf_lix2_sUPI           , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_SUPI },
  {   7, &hf_lix2_gPSI           , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_GPSI },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSPartyID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 MMSPartyID_choice, hf_index, ett_lix2_MMSPartyID,
                                 NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_MMSPartyID_sequence_of[1] = {
  { &hf_lix2_mMSPartyIDs_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_MMSPartyID },
};

static int
dissect_lix2_SEQUENCE_OF_MMSPartyID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_MMSPartyID_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_MMSPartyID);

  return offset;
}


static const value_string lix2_NonLocalID_vals[] = {
  {   1, "local" },
  {   2, "nonLocal" },
  { 0, NULL }
};


static int
dissect_lix2_NonLocalID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMSParty_sequence[] = {
  { &hf_lix2_mMSPartyIDs    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSPartyID },
  { &hf_lix2_nonLocalID     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NonLocalID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSParty(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSParty_sequence, hf_index, ett_lix2_MMSParty);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_MMSParty_sequence_of[1] = {
  { &hf_lix2_terminatingMMSParty_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_MMSParty },
};

static int
dissect_lix2_SEQUENCE_OF_MMSParty(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_MMSParty_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_MMSParty);

  return offset;
}


static const value_string lix2_MMSDirection_vals[] = {
  {   0, "fromTarget" },
  {   1, "toTarget" },
  { 0, NULL }
};


static int
dissect_lix2_MMSDirection(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_MMSSubject(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_MMSMessageClass_vals[] = {
  {   1, "personal" },
  {   2, "advertisement" },
  {   3, "informational" },
  {   4, "auto" },
  { 0, NULL }
};


static int
dissect_lix2_MMSMessageClass(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_MMSPeriodFormat_vals[] = {
  {   1, "absolute" },
  {   2, "relative" },
  { 0, NULL }
};


static int
dissect_lix2_MMSPeriodFormat(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMSExpiry_sequence[] = {
  { &hf_lix2_expiryPeriod   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_periodFormat   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSPeriodFormat },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSExpiry(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSExpiry_sequence, hf_index, ett_lix2_MMSExpiry);

  return offset;
}


static const value_string lix2_MMSPriority_vals[] = {
  {   1, "low" },
  {   2, "normal" },
  {   3, "high" },
  { 0, NULL }
};


static int
dissect_lix2_MMSPriority(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_MMState_vals[] = {
  {   1, "draft" },
  {   2, "sent" },
  {   3, "new" },
  {   4, "retrieved" },
  {   5, "forwarded" },
  { 0, NULL }
};


static int
dissect_lix2_MMState(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_MMStateFlag_vals[] = {
  {   1, "add" },
  {   2, "remove" },
  {   3, "filter" },
  { 0, NULL }
};


static int
dissect_lix2_MMStateFlag(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMFlags_sequence[] = {
  { &hf_lix2_length         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_flag           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMStateFlag },
  { &hf_lix2_flagString     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMFlags(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMFlags_sequence, hf_index, ett_lix2_MMFlags);

  return offset;
}


static const value_string lix2_MMSReplyCharging_vals[] = {
  {   0, "requested" },
  {   1, "requestedTextOnly" },
  {   2, "accepted" },
  {   3, "acceptedTextOnly" },
  { 0, NULL }
};


static int
dissect_lix2_MMSReplyCharging(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_MMSContentClass_vals[] = {
  {   1, "text" },
  {   2, "imageBasic" },
  {   3, "imageRich" },
  {   4, "videoBasic" },
  {   5, "videoRich" },
  {   6, "megaPixel" },
  {   7, "contentBasic" },
  {   8, "contentRich" },
  { 0, NULL }
};


static int
dissect_lix2_MMSContentClass(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMSAdaptation_sequence[] = {
  { &hf_lix2_allowed        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_overriden      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSAdaptation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSAdaptation_sequence, hf_index, ett_lix2_MMSAdaptation);

  return offset;
}



static int
dissect_lix2_MMSContentType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_MMSResponseStatus_vals[] = {
  {   1, "ok" },
  {   2, "errorUnspecified" },
  {   3, "errorServiceDenied" },
  {   4, "errorMessageFormatCorrupt" },
  {   5, "errorSendingAddressUnresolved" },
  {   6, "errorMessageNotFound" },
  {   7, "errorNetworkProblem" },
  {   8, "errorContentNotAccepted" },
  {   9, "errorUnsupportedMessage" },
  {  10, "errorTransientFailure" },
  {  11, "errorTransientSendingAddressUnresolved" },
  {  12, "errorTransientMessageNotFound" },
  {  13, "errorTransientNetworkProblem" },
  {  14, "errorTransientPartialSuccess" },
  {  15, "errorPermanentFailure" },
  {  16, "errorPermanentServiceDenied" },
  {  17, "errorPermanentMessageFormatCorrupt" },
  {  18, "errorPermanentSendingAddressUnresolved" },
  {  19, "errorPermanentMessageNotFound" },
  {  20, "errorPermanentContentNotAccepted" },
  {  21, "errorPermanentReplyChargingLimitationsNotMet" },
  {  22, "errorPermanentReplyChargingRequestNotAccepted" },
  {  23, "errorPermanentReplyChargingForwardingDenied" },
  {  24, "errorPermanentReplyChargingNotSupported" },
  {  25, "errorPermanentAddressHidingNotSupported" },
  {  26, "errorPermanentLackOfPrepaid" },
  { 0, NULL }
};


static int
dissect_lix2_MMSResponseStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMSSend_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_dateTime       , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_originatingMMSParty, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_MMSParty },
  { &hf_lix2_terminatingMMSParty, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_cCRecipients   , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_bCCRecipients  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_subject        , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSSubject },
  { &hf_lix2_messageClass   , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSMessageClass },
  { &hf_lix2_expiry         , BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_MMSExpiry },
  { &hf_lix2_desiredDeliveryTime, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_priority_01    , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSPriority },
  { &hf_lix2_senderVisibility, BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_deliveryReport , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_readReport     , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_store          , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_state          , BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMState },
  { &hf_lix2_flags          , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMFlags },
  { &hf_lix2_replyCharging  , BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSReplyCharging },
  { &hf_lix2_applicID       , BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_replyApplicID  , BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_auxApplicInfo  , BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_contentClass   , BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSContentClass },
  { &hf_lix2_dRMContent     , BER_CLASS_CON, 25, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_adaptationAllowed, BER_CLASS_CON, 26, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSAdaptation },
  { &hf_lix2_contentType    , BER_CLASS_CON, 27, BER_FLAGS_IMPLTAG, dissect_lix2_MMSContentType },
  { &hf_lix2_responseStatus , BER_CLASS_CON, 28, BER_FLAGS_IMPLTAG, dissect_lix2_MMSResponseStatus },
  { &hf_lix2_responseStatusText, BER_CLASS_CON, 29, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_messageID      , BER_CLASS_CON, 30, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSSend(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSSend_sequence, hf_index, ett_lix2_MMSSend);

  return offset;
}


static const ber_sequence_t MMSPreviouslySent_sequence[] = {
  { &hf_lix2_previouslySentByParty, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMSParty },
  { &hf_lix2_sequenceNumber , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_previousSendDateTime, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSPreviouslySent(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSPreviouslySent_sequence, hf_index, ett_lix2_MMSPreviouslySent);

  return offset;
}


static const ber_sequence_t MMSPreviouslySentBy_sequence_of[1] = {
  { &hf_lix2_MMSPreviouslySentBy_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_MMSPreviouslySent },
};

static int
dissect_lix2_MMSPreviouslySentBy(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      MMSPreviouslySentBy_sequence_of, hf_index, ett_lix2_MMSPreviouslySentBy);

  return offset;
}


static const ber_sequence_t MMSSendByNonLocalTarget_sequence[] = {
  { &hf_lix2_version        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_transactionID  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_messageID      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_terminatingMMSParty, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_originatingMMSParty, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_MMSParty },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_contentType    , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_MMSContentType },
  { &hf_lix2_messageClass   , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSMessageClass },
  { &hf_lix2_dateTime       , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_expiry         , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSExpiry },
  { &hf_lix2_deliveryReport , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_priority_01    , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSPriority },
  { &hf_lix2_senderVisibility, BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_readReport     , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_subject        , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSSubject },
  { &hf_lix2_forwardCount   , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_previouslySentBy, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSPreviouslySentBy },
  { &hf_lix2_prevSentByDateTime, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_applicID       , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_replyApplicID  , BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_auxApplicInfo  , BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_contentClass   , BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSContentClass },
  { &hf_lix2_dRMContent     , BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_adaptationAllowed, BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSAdaptation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSSendByNonLocalTarget(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSSendByNonLocalTarget_sequence, hf_index, ett_lix2_MMSSendByNonLocalTarget);

  return offset;
}


static const ber_sequence_t MMSNotification_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_originatingMMSParty, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSParty },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_subject        , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSSubject },
  { &hf_lix2_deliveryReportRequested, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_stored         , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_messageClass   , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMessageClass },
  { &hf_lix2_priority_01    , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSPriority },
  { &hf_lix2_messageSize    , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_expiry         , BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_MMSExpiry },
  { &hf_lix2_replyCharging  , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSReplyCharging },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSNotification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSNotification_sequence, hf_index, ett_lix2_MMSNotification);

  return offset;
}


static const ber_sequence_t MMSSendToNonLocalTarget_sequence[] = {
  { &hf_lix2_version        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_transactionID  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_messageID      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_terminatingMMSParty, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_originatingMMSParty, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_MMSParty },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_contentType    , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_MMSContentType },
  { &hf_lix2_messageClass   , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSMessageClass },
  { &hf_lix2_dateTime       , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_expiry         , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSExpiry },
  { &hf_lix2_deliveryReport , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_priority_01    , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSPriority },
  { &hf_lix2_senderVisibility, BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_readReport     , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_subject        , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSSubject },
  { &hf_lix2_forwardCount   , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_previouslySentBy, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSPreviouslySentBy },
  { &hf_lix2_prevSentByDateTime, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_applicID       , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_replyApplicID  , BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_auxApplicInfo  , BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_contentClass   , BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSContentClass },
  { &hf_lix2_dRMContent     , BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_adaptationAllowed, BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSAdaptation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSSendToNonLocalTarget(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSSendToNonLocalTarget_sequence, hf_index, ett_lix2_MMSSendToNonLocalTarget);

  return offset;
}


static const value_string lix2_MMStatus_vals[] = {
  {   1, "expired" },
  {   2, "retrieved" },
  {   3, "rejected" },
  {   4, "deferred" },
  {   5, "unrecognized" },
  {   6, "indeterminate" },
  {   7, "forwarded" },
  {   8, "unreachable" },
  { 0, NULL }
};


static int
dissect_lix2_MMStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMSNotificationResponse_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_status_01      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_MMStatus },
  { &hf_lix2_reportAllowed  , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSNotificationResponse(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSNotificationResponse_sequence, hf_index, ett_lix2_MMSNotificationResponse);

  return offset;
}


static const value_string lix2_MMSRetrieveStatus_vals[] = {
  {   1, "success" },
  {   2, "errorTransientFailure" },
  {   3, "errorTransientMessageNotFound" },
  {   4, "errorTransientNetworkProblem" },
  {   5, "errorPermanentFailure" },
  {   6, "errorPermanentServiceDenied" },
  {   7, "errorPermanentMessageNotFound" },
  {   8, "errorPermanentContentUnsupported" },
  { 0, NULL }
};


static int
dissect_lix2_MMSRetrieveStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMSRetrieval_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_messageID      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_dateTime       , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_originatingMMSParty, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSParty },
  { &hf_lix2_previouslySentBy, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSPreviouslySentBy },
  { &hf_lix2_prevSentByDateTime, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_terminatingMMSParty, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_cCRecipients   , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_subject        , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSSubject },
  { &hf_lix2_state          , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMState },
  { &hf_lix2_flags          , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMFlags },
  { &hf_lix2_messageClass   , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSMessageClass },
  { &hf_lix2_priority_01    , BER_CLASS_CON, 15, BER_FLAGS_IMPLTAG, dissect_lix2_MMSPriority },
  { &hf_lix2_deliveryReport , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_readReport     , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_replyCharging  , BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSReplyCharging },
  { &hf_lix2_retrieveStatus , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSRetrieveStatus },
  { &hf_lix2_retrieveStatusText, BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_applicID       , BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_replyApplicID  , BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_auxApplicInfo  , BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_contentClass   , BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSContentClass },
  { &hf_lix2_dRMContent     , BER_CLASS_CON, 25, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_replaceID      , BER_CLASS_CON, 26, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_contentType_01 , BER_CLASS_CON, 27, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSRetrieval(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSRetrieval_sequence, hf_index, ett_lix2_MMSRetrieval);

  return offset;
}


static const ber_sequence_t MMSDeliveryAck_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_reportAllowed  , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_status_01      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_MMStatus },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSDeliveryAck(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSDeliveryAck_sequence, hf_index, ett_lix2_MMSDeliveryAck);

  return offset;
}


static const value_string lix2_MMSStoreStatus_vals[] = {
  {   1, "success" },
  {   2, "errorTransientFailure" },
  {   3, "errorTransientNetworkProblem" },
  {   4, "errorPermanentFailure" },
  {   5, "errorPermanentServiceDenied" },
  {   6, "errorPermanentMessageFormatCorrupt" },
  {   7, "errorPermanentMessageNotFound" },
  {   8, "errorMMBoxFull" },
  { 0, NULL }
};


static int
dissect_lix2_MMSStoreStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMSForward_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_dateTime       , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_originatingMMSParty, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_MMSParty },
  { &hf_lix2_terminatingMMSParty, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_cCRecipients   , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_bCCRecipients  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_expiry         , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSExpiry },
  { &hf_lix2_desiredDeliveryTime, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_deliveryReportAllowed, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_deliveryReport , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_store          , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_state          , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMState },
  { &hf_lix2_flags          , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMFlags },
  { &hf_lix2_contentLocationReq, BER_CLASS_CON, 16, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_replyCharging  , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSReplyCharging },
  { &hf_lix2_responseStatus , BER_CLASS_CON, 18, BER_FLAGS_IMPLTAG, dissect_lix2_MMSResponseStatus },
  { &hf_lix2_responseStatusText, BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_messageID      , BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_contentLocationConf, BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_storeStatus    , BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSStoreStatus },
  { &hf_lix2_storeStatusText, BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSForward(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSForward_sequence, hf_index, ett_lix2_MMSForward);

  return offset;
}


static const ber_sequence_t T_contentLocationReq_sequence_of[1] = {
  { &hf_lix2_contentLocationReq_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_UTF8String },
};

static int
dissect_lix2_T_contentLocationReq(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      T_contentLocationReq_sequence_of, hf_index, ett_lix2_T_contentLocationReq);

  return offset;
}


static const ber_sequence_t T_contentLocationConf_sequence_of[1] = {
  { &hf_lix2_contentLocationConf_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_UTF8String },
};

static int
dissect_lix2_T_contentLocationConf(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      T_contentLocationConf_sequence_of, hf_index, ett_lix2_T_contentLocationConf);

  return offset;
}


static const value_string lix2_MMSDeleteResponseStatus_vals[] = {
  {   1, "ok" },
  {   2, "errorUnspecified" },
  {   3, "errorServiceDenied" },
  {   4, "errorMessageFormatCorrupt" },
  {   5, "errorSendingAddressUnresolved" },
  {   6, "errorMessageNotFound" },
  {   7, "errorNetworkProblem" },
  {   8, "errorContentNotAccepted" },
  {   9, "errorUnsupportedMessage" },
  {  10, "errorTransientFailure" },
  {  11, "errorTransientSendingAddressUnresolved" },
  {  12, "errorTransientMessageNotFound" },
  {  13, "errorTransientNetworkProblem" },
  {  14, "errorTransientPartialSuccess" },
  {  15, "errorPermanentFailure" },
  {  16, "errorPermanentServiceDenied" },
  {  17, "errorPermanentMessageFormatCorrupt" },
  {  18, "errorPermanentSendingAddressUnresolved" },
  {  19, "errorPermanentMessageNotFound" },
  {  20, "errorPermanentContentNotAccepted" },
  {  21, "errorPermanentReplyChargingLimitationsNotMet" },
  {  22, "errorPermanentReplyChargingRequestNotAccepted" },
  {  23, "errorPermanentReplyChargingForwardingDenied" },
  {  24, "errorPermanentReplyChargingNotSupported" },
  {  25, "errorPermanentAddressHidingNotSupported" },
  {  26, "errorPermanentLackOfPrepaid" },
  { 0, NULL }
};


static int
dissect_lix2_MMSDeleteResponseStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t T_deleteResponseText_sequence_of[1] = {
  { &hf_lix2_deleteResponseText_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_UTF8String },
};

static int
dissect_lix2_T_deleteResponseText(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      T_deleteResponseText_sequence_of, hf_index, ett_lix2_T_deleteResponseText);

  return offset;
}


static const ber_sequence_t MMSDeleteFromRelay_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_contentLocationReq_01, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_T_contentLocationReq },
  { &hf_lix2_contentLocationConf_01, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_T_contentLocationConf },
  { &hf_lix2_deleteResponseStatus, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDeleteResponseStatus },
  { &hf_lix2_deleteResponseText, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_T_deleteResponseText },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSDeleteFromRelay(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSDeleteFromRelay_sequence, hf_index, ett_lix2_MMSDeleteFromRelay);

  return offset;
}


static const ber_sequence_t MMSDeliveryReport_sequence[] = {
  { &hf_lix2_version        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_messageID      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_terminatingMMSParty, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_mMSDateTime    , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_responseStatus , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_MMSResponseStatus },
  { &hf_lix2_responseStatusText, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_applicID       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_replyApplicID  , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_auxApplicInfo  , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSDeliveryReport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSDeliveryReport_sequence, hf_index, ett_lix2_MMSDeliveryReport);

  return offset;
}


static const value_string lix2_MMStatusExtension_vals[] = {
  {   0, "rejectionByMMSRecipient" },
  {   1, "rejectionByOtherRS" },
  { 0, NULL }
};


static int
dissect_lix2_MMStatusExtension(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_MMStatusText(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t MMSDeliveryReportNonLocalTarget_sequence[] = {
  { &hf_lix2_version        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_transactionID  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_messageID      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_terminatingMMSParty, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_originatingMMSParty, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_MMSParty },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_mMSDateTime    , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_forwardToOriginator, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_status_01      , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_MMStatus },
  { &hf_lix2_statusExtension, BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_MMStatusExtension },
  { &hf_lix2_statusText     , BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_MMStatusText },
  { &hf_lix2_applicID       , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_replyApplicID  , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_auxApplicInfo  , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSDeliveryReportNonLocalTarget(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSDeliveryReportNonLocalTarget_sequence, hf_index, ett_lix2_MMSDeliveryReportNonLocalTarget);

  return offset;
}


static const value_string lix2_MMSReadStatus_vals[] = {
  {   1, "read" },
  {   2, "deletedWithoutBeingRead" },
  { 0, NULL }
};


static int
dissect_lix2_MMSReadStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMSReadReport_sequence[] = {
  { &hf_lix2_version        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_messageID      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_terminatingMMSParty, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_originatingMMSParty_01, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_mMSDateTime    , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_readStatus     , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_MMSReadStatus },
  { &hf_lix2_applicID       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_replyApplicID  , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_auxApplicInfo  , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSReadReport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSReadReport_sequence, hf_index, ett_lix2_MMSReadReport);

  return offset;
}



static int
dissect_lix2_MMSReadStatusText(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t MMSReadReportNonLocalTarget_sequence[] = {
  { &hf_lix2_version        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_transactionID  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_terminatingMMSParty, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_originatingMMSParty_01, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_messageID      , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_mMSDateTime    , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_readStatus     , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_MMSReadStatus },
  { &hf_lix2_readStatusText , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSReadStatusText },
  { &hf_lix2_applicID       , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_replyApplicID  , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_auxApplicInfo  , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSReadReportNonLocalTarget(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSReadReportNonLocalTarget_sequence, hf_index, ett_lix2_MMSReadReportNonLocalTarget);

  return offset;
}


static const ber_sequence_t MMSCancel_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_cancelID       , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSCancel(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSCancel_sequence, hf_index, ett_lix2_MMSCancel);

  return offset;
}


static const ber_sequence_t MMSMBoxStore_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_contentLocationReq, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_state          , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMState },
  { &hf_lix2_flags          , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMFlags },
  { &hf_lix2_contentLocationConf, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_storeStatus    , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_MMSStoreStatus },
  { &hf_lix2_storeStatusText, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSMBoxStore(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSMBoxStore_sequence, hf_index, ett_lix2_MMSMBoxStore);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_MMFlags_sequence_of[1] = {
  { &hf_lix2_flags_item     , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_MMFlags },
};

static int
dissect_lix2_SEQUENCE_OF_MMFlags(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_MMFlags_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_MMFlags);

  return offset;
}


static const ber_sequence_t MMBoxDescription_sequence[] = {
  { &hf_lix2_contentLocation, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_messageID      , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_state          , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMState },
  { &hf_lix2_flags_01       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMFlags },
  { &hf_lix2_dateTime       , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_originatingMMSParty, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSParty },
  { &hf_lix2_terminatingMMSParty, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_cCRecipients   , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_bCCRecipients  , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMSParty },
  { &hf_lix2_messageClass   , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSMessageClass },
  { &hf_lix2_subject        , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSSubject },
  { &hf_lix2_priority_01    , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSPriority },
  { &hf_lix2_deliveryTime   , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_readReport     , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_messageSize    , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_replyCharging  , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSReplyCharging },
  { &hf_lix2_previouslySentBy, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSPreviouslySentBy },
  { &hf_lix2_previouslySentByDateTime, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_contentType_01 , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMBoxDescription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMBoxDescription_sequence, hf_index, ett_lix2_MMBoxDescription);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_MMBoxDescription_sequence_of[1] = {
  { &hf_lix2_mMessages_item , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_MMBoxDescription },
};

static int
dissect_lix2_SEQUENCE_OF_MMBoxDescription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_MMBoxDescription_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_MMBoxDescription);

  return offset;
}


static const ber_sequence_t MMSMBoxUpload_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_state          , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMState },
  { &hf_lix2_flags          , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMFlags },
  { &hf_lix2_contentType_01 , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_contentLocation, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_storeStatus    , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_MMSStoreStatus },
  { &hf_lix2_storeStatusText, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_mMessages      , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMBoxDescription },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSMBoxUpload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSMBoxUpload_sequence, hf_index, ett_lix2_MMSMBoxUpload);

  return offset;
}


static const ber_sequence_t T_contentLocationReq_01_sequence_of[1] = {
  { &hf_lix2_contentLocationReq_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_UTF8String },
};

static int
dissect_lix2_T_contentLocationReq_01(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      T_contentLocationReq_01_sequence_of, hf_index, ett_lix2_T_contentLocationReq_01);

  return offset;
}


static const ber_sequence_t T_contentLocationConf_01_sequence_of[1] = {
  { &hf_lix2_contentLocationConf_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_UTF8String },
};

static int
dissect_lix2_T_contentLocationConf_01(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      T_contentLocationConf_01_sequence_of, hf_index, ett_lix2_T_contentLocationConf_01);

  return offset;
}


static const ber_sequence_t MMSMBoxDelete_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_direction_01   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDirection },
  { &hf_lix2_contentLocationReq_02, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_T_contentLocationReq_01 },
  { &hf_lix2_contentLocationConf_02, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_T_contentLocationConf_01 },
  { &hf_lix2_responseStatus_01, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDeleteResponseStatus },
  { &hf_lix2_responseStatusText, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSMBoxDelete(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSMBoxDelete_sequence, hf_index, ett_lix2_MMSMBoxDelete);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_MMState_sequence_of[1] = {
  { &hf_lix2_state_item     , BER_CLASS_UNI, BER_UNI_TAG_ENUMERATED, BER_FLAGS_NOOWNTAG, dissect_lix2_MMState },
};

static int
dissect_lix2_SEQUENCE_OF_MMState(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_MMState_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_MMState);

  return offset;
}


static const ber_sequence_t T_attributes_sequence_of[1] = {
  { &hf_lix2_attributes_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_UTF8String },
};

static int
dissect_lix2_T_attributes(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      T_attributes_sequence_of, hf_index, ett_lix2_T_attributes);

  return offset;
}


static const value_string lix2_MMSQuotaUnit_vals[] = {
  {   1, "numMessages" },
  {   2, "bytes" },
  { 0, NULL }
};


static int
dissect_lix2_MMSQuotaUnit(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMSQuota_sequence[] = {
  { &hf_lix2_quota          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_quotaUnit      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSQuotaUnit },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSQuota(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSQuota_sequence, hf_index, ett_lix2_MMSQuota);

  return offset;
}


static const ber_sequence_t MMSMBoxViewRequest_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_contentLocation, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_state_01       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMState },
  { &hf_lix2_flags_01       , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMFlags },
  { &hf_lix2_start          , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_limit          , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_attributes     , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_T_attributes },
  { &hf_lix2_totals         , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_quotas         , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MMSQuota },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSMBoxViewRequest(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSMBoxViewRequest_sequence, hf_index, ett_lix2_MMSMBoxViewRequest);

  return offset;
}


static const ber_sequence_t T_attributes_01_sequence_of[1] = {
  { &hf_lix2_attributes_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_UTF8String },
};

static int
dissect_lix2_T_attributes_01(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      T_attributes_01_sequence_of, hf_index, ett_lix2_T_attributes_01);

  return offset;
}


static const ber_sequence_t MMSMBoxViewResponse_sequence[] = {
  { &hf_lix2_transactionID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_version        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_contentLocation, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_state_01       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMState },
  { &hf_lix2_flags_01       , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMFlags },
  { &hf_lix2_start          , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_limit          , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_attributes_01  , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_T_attributes_01 },
  { &hf_lix2_mMSTotals      , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_mMSQuotas      , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_mMessages      , BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_MMBoxDescription },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSMBoxViewResponse(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSMBoxViewResponse_sequence, hf_index, ett_lix2_MMSMBoxViewResponse);

  return offset;
}


static const ber_sequence_t PTCChatGroupID_sequence[] = {
  { &hf_lix2_groupIdentity  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCChatGroupID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCChatGroupID_sequence, hf_index, ett_lix2_PTCChatGroupID);

  return offset;
}


static const value_string lix2_PTCIdentifiers_vals[] = {
  {   1, "mCPTTID" },
  {   2, "instanceIdentifierURN" },
  {   3, "pTCChatGroupID" },
  {   4, "iMPU" },
  {   5, "iMPI" },
  { 0, NULL }
};

static const ber_choice_t PTCIdentifiers_choice[] = {
  {   1, &hf_lix2_mCPTTID        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  {   2, &hf_lix2_instanceIdentifierURN, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  {   3, &hf_lix2_pTCChatGroupID , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PTCChatGroupID },
  {   4, &hf_lix2_iMPU           , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_IMPU },
  {   5, &hf_lix2_iMPI           , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_IMPI },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCIdentifiers(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 PTCIdentifiers_choice, hf_index, ett_lix2_PTCIdentifiers,
                                 NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_PTCIdentifiers_sequence_of[1] = {
  { &hf_lix2_identifiers_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PTCIdentifiers },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_PTCIdentifiers(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_PTCIdentifiers_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_PTCIdentifiers);

  return offset;
}


static const ber_sequence_t PTCTargetInformation_sequence[] = {
  { &hf_lix2_identifiers    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_PTCIdentifiers },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCTargetInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCTargetInformation_sequence, hf_index, ett_lix2_PTCTargetInformation);

  return offset;
}


static const value_string lix2_PTCRegistrationRequest_vals[] = {
  {   1, "register" },
  {   2, "reRegister" },
  {   3, "deRegister" },
  { 0, NULL }
};


static int
dissect_lix2_PTCRegistrationRequest(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_PTCRegistrationOutcome_vals[] = {
  {   1, "success" },
  {   2, "failure" },
  { 0, NULL }
};


static int
dissect_lix2_PTCRegistrationOutcome(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PTCRegistration_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCServerURI   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pTCRegistrationRequest, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PTCRegistrationRequest },
  { &hf_lix2_pTCRegistrationOutcome, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_PTCRegistrationOutcome },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCRegistration(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCRegistration_sequence, hf_index, ett_lix2_PTCRegistration);

  return offset;
}


static const value_string lix2_PTCSessionType_vals[] = {
  {   1, "ondemand" },
  {   2, "preEstablished" },
  {   3, "adhoc" },
  {   4, "prearranged" },
  {   5, "groupSession" },
  { 0, NULL }
};


static int
dissect_lix2_PTCSessionType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PTCSessionInfo_sequence[] = {
  { &hf_lix2_pTCSessionURI  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pTCSessionType , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCSessionInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCSessionInfo_sequence, hf_index, ett_lix2_PTCSessionInfo);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_PTCTargetInformation_sequence_of[1] = {
  { &hf_lix2_pTCParticipants_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PTCTargetInformation },
};

static int
dissect_lix2_SEQUENCE_OF_PTCTargetInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_PTCTargetInformation_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_PTCTargetInformation);

  return offset;
}


static const value_string lix2_PTCPresenceType_vals[] = {
  {   1, "pTCClient" },
  {   2, "pTCGroup" },
  { 0, NULL }
};


static int
dissect_lix2_PTCPresenceType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PTCParticipantPresenceStatus_sequence[] = {
  { &hf_lix2_presenceID     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_presenceType   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PTCPresenceType },
  { &hf_lix2_presenceStatus , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCParticipantPresenceStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCParticipantPresenceStatus_sequence, hf_index, ett_lix2_PTCParticipantPresenceStatus);

  return offset;
}


static const ber_sequence_t MultipleParticipantPresenceStatus_sequence_of[1] = {
  { &hf_lix2_MultipleParticipantPresenceStatus_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PTCParticipantPresenceStatus },
};

static int
dissect_lix2_MultipleParticipantPresenceStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      MultipleParticipantPresenceStatus_sequence_of, hf_index, ett_lix2_MultipleParticipantPresenceStatus);

  return offset;
}


static const ber_sequence_t PTCSessionInitiation_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCServerURI   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pTCSessionInfo , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCOriginatingID, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCParticipants, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PTCTargetInformation },
  { &hf_lix2_pTCParticipantPresenceStatus, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MultipleParticipantPresenceStatus },
  { &hf_lix2_location       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_pTCBearerCapability, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pTCHost        , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCSessionInitiation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCSessionInitiation_sequence, hf_index, ett_lix2_PTCSessionInitiation);

  return offset;
}


static const ber_sequence_t PTCSessionAbandon_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCSessionInfo , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_location       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_pTCAbandonCause, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCSessionAbandon(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCSessionAbandon_sequence, hf_index, ett_lix2_PTCSessionAbandon);

  return offset;
}


static const ber_sequence_t PTCSessionStart_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCServerURI   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pTCSessionInfo , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCOriginatingID, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCParticipants, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PTCTargetInformation },
  { &hf_lix2_pTCParticipantPresenceStatus, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MultipleParticipantPresenceStatus },
  { &hf_lix2_location       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_pTCHost        , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCBearerCapability, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCSessionStart(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCSessionStart_sequence, hf_index, ett_lix2_PTCSessionStart);

  return offset;
}


static const value_string lix2_PTCSessionEndCause_vals[] = {
  {   1, "initiaterLeavesSession" },
  {   2, "definedParticipantLeaves" },
  {   3, "numberOfParticipants" },
  {   4, "sessionTimerExpired" },
  {   5, "pTCSpeechInactive" },
  {   6, "allMediaTypesInactive" },
  { 0, NULL }
};


static int
dissect_lix2_PTCSessionEndCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PTCSessionEnd_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCServerURI   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pTCSessionInfo , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCParticipants, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PTCTargetInformation },
  { &hf_lix2_location       , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_pTCSessionEndCause, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionEndCause },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCSessionEnd(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCSessionEnd_sequence, hf_index, ett_lix2_PTCSessionEnd);

  return offset;
}


static const ber_sequence_t PTCStartOfInterception_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_preEstSessionID, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCOriginatingID, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCSessionInfo , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCHost        , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCParticipants, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PTCTargetInformation },
  { &hf_lix2_pTCMediaStreamAvail, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_pTCBearerCapability, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCStartOfInterception(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCStartOfInterception_sequence, hf_index, ett_lix2_PTCStartOfInterception);

  return offset;
}


static const ber_sequence_t RTPSetting_sequence[] = {
  { &hf_lix2_iPAddress      , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_portNumber     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RTPSetting(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RTPSetting_sequence, hf_index, ett_lix2_RTPSetting);

  return offset;
}


static const value_string lix2_PTCPreEstStatus_vals[] = {
  {   1, "established" },
  {   2, "modified" },
  {   3, "released" },
  { 0, NULL }
};


static int
dissect_lix2_PTCPreEstStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_PTCFailureCode_vals[] = {
  {   1, "sessionCannotBeEstablished" },
  {   2, "sessionCannotBeModified" },
  { 0, NULL }
};


static int
dissect_lix2_PTCFailureCode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PTCPreEstablishedSession_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCServerURI   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_rTPSetting     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RTPSetting },
  { &hf_lix2_pTCMediaCapability, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_pTCPreEstSessionID, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCPreEstStatus, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_PTCPreEstStatus },
  { &hf_lix2_pTCMediaStreamAvail, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_location       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_pTCFailureCode , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCFailureCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCPreEstablishedSession(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCPreEstablishedSession_sequence, hf_index, ett_lix2_PTCPreEstablishedSession);

  return offset;
}


static const ber_sequence_t PTCInstantPersonalAlert_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCIPAPartyID  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCIPADirection, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCInstantPersonalAlert(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCInstantPersonalAlert_sequence, hf_index, ett_lix2_PTCInstantPersonalAlert);

  return offset;
}


static const ber_sequence_t PTCPartyJoin_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCSessionInfo , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCParticipants, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PTCTargetInformation },
  { &hf_lix2_pTCParticipantPresenceStatus, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MultipleParticipantPresenceStatus },
  { &hf_lix2_pTCMediaStreamAvail, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_pTCBearerCapability, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCPartyJoin(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCPartyJoin_sequence, hf_index, ett_lix2_PTCPartyJoin);

  return offset;
}


static const ber_sequence_t PTCPartyDrop_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCSessionInfo , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCPartyDrop_01, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCParticipantPresenceStatus_01, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCParticipantPresenceStatus },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCPartyDrop(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCPartyDrop_sequence, hf_index, ett_lix2_PTCPartyDrop);

  return offset;
}


static const ber_sequence_t PTCPartyHold_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCSessionInfo , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCParticipants, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PTCTargetInformation },
  { &hf_lix2_pTCHoldID      , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PTCTargetInformation },
  { &hf_lix2_pTCHoldRetrieveInd, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCPartyHold(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCPartyHold_sequence, hf_index, ett_lix2_PTCPartyHold);

  return offset;
}


static const ber_sequence_t PTCMediaModification_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCSessionInfo , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCMediaStreamAvail, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_pTCBearerCapability, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCMediaModification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCMediaModification_sequence, hf_index, ett_lix2_PTCMediaModification);

  return offset;
}


static const value_string lix2_PTCGroupAuthRule_vals[] = {
  {   1, "allowInitiatingPTCSession" },
  {   2, "blockInitiatingPTCSession" },
  {   3, "allowJoiningPTCSession" },
  {   4, "blockJoiningPTCSession" },
  {   5, "allowAddParticipants" },
  {   6, "blockAddParticipants" },
  {   7, "allowSubscriptionPTCSessionState" },
  {   8, "blockSubscriptionPTCSessionState" },
  {   9, "allowAnonymity" },
  {  10, "forbidAnonymity" },
  { 0, NULL }
};


static int
dissect_lix2_PTCGroupAuthRule(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PTCGroupAdvertisement_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCIDList      , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PTCTargetInformation },
  { &hf_lix2_pTCGroupAuthRule, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCGroupAuthRule },
  { &hf_lix2_pTCGroupAdSender, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCGroupNickname, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCGroupAdvertisement(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCGroupAdvertisement_sequence, hf_index, ett_lix2_PTCGroupAdvertisement);

  return offset;
}


static const value_string lix2_PTCFloorActivity_vals[] = {
  {   1, "tBCPRequest" },
  {   2, "tBCPGranted" },
  {   3, "tBCPDeny" },
  {   4, "tBCPIdle" },
  {   5, "tBCPTaken" },
  {   6, "tBCPRevoke" },
  {   7, "tBCPQueued" },
  {   8, "tBCPRelease" },
  { 0, NULL }
};


static int
dissect_lix2_PTCFloorActivity(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_PTCFloorActivity_sequence_of[1] = {
  { &hf_lix2_pTCFloorActivity_item, BER_CLASS_UNI, BER_UNI_TAG_ENUMERATED, BER_FLAGS_NOOWNTAG, dissect_lix2_PTCFloorActivity },
};

static int
dissect_lix2_SEQUENCE_OF_PTCFloorActivity(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_PTCFloorActivity_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_PTCFloorActivity);

  return offset;
}


static const value_string lix2_PTCTBPriorityLevel_vals[] = {
  {   1, "preEmptive" },
  {   2, "highPriority" },
  {   3, "normalPriority" },
  {   4, "listenOnly" },
  { 0, NULL }
};


static int
dissect_lix2_PTCTBPriorityLevel(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_PTCTBReasonCode_vals[] = {
  {   1, "noQueuingAllowed" },
  {   2, "oneParticipantSession" },
  {   3, "listenOnly" },
  {   4, "exceededMaxDuration" },
  {   5, "tBPrevented" },
  { 0, NULL }
};


static int
dissect_lix2_PTCTBReasonCode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PTCFloorControl_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCSessioninfo , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInfo },
  { &hf_lix2_pTCFloorActivity, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PTCFloorActivity },
  { &hf_lix2_pTCFloorSpeakerID, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCMaxTBTime   , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_pTCQueuedFloorControl, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_pTCQueuedPosition, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_pTCTalkBurstPriority, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCTBPriorityLevel },
  { &hf_lix2_pTCTalkBurstReason, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCTBReasonCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCFloorControl(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCFloorControl_sequence, hf_index, ett_lix2_PTCFloorControl);

  return offset;
}


static const ber_sequence_t PTCTargetPresence_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCTargetPresenceStatus, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PTCParticipantPresenceStatus },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCTargetPresence(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCTargetPresence_sequence, hf_index, ett_lix2_PTCTargetPresence);

  return offset;
}


static const ber_sequence_t PTCParticipantPresence_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCParticipantPresenceStatus_01, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PTCParticipantPresenceStatus },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCParticipantPresence(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCParticipantPresence_sequence, hf_index, ett_lix2_PTCParticipantPresence);

  return offset;
}


static const value_string lix2_PTCListManagementType_vals[] = {
  {   1, "contactListManagementAttempt" },
  {   2, "groupListManagementAttempt" },
  {   3, "contactListManagementResult" },
  {   4, "groupListManagementResult" },
  {   5, "requestUnsuccessful" },
  { 0, NULL }
};


static int
dissect_lix2_PTCListManagementType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_PTCListManagementAction_vals[] = {
  {   1, "create" },
  {   2, "modify" },
  {   3, "retrieve" },
  {   4, "delete" },
  {   5, "notify" },
  { 0, NULL }
};


static int
dissect_lix2_PTCListManagementAction(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_PTCListManagementFailure_vals[] = {
  {   1, "requestUnsuccessful" },
  {   2, "requestUnknown" },
  { 0, NULL }
};


static int
dissect_lix2_PTCListManagementFailure(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PTCIDList_sequence[] = {
  { &hf_lix2_pTCPartyID     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCChatGroupID , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PTCChatGroupID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCIDList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCIDList_sequence, hf_index, ett_lix2_PTCIDList);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_PTCIDList_sequence_of[1] = {
  { &hf_lix2_pTCIDList_item_01, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PTCIDList },
};

static int
dissect_lix2_SEQUENCE_OF_PTCIDList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_PTCIDList_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_PTCIDList);

  return offset;
}


static const ber_sequence_t PTCListManagement_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCListManagementType, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCListManagementType },
  { &hf_lix2_pTCListManagementAction, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCListManagementAction },
  { &hf_lix2_pTCListManagementFailure, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCListManagementFailure },
  { &hf_lix2_pTCContactID   , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCIDList_01   , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PTCIDList },
  { &hf_lix2_pTCHost        , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCListManagement(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCListManagement_sequence, hf_index, ett_lix2_PTCListManagement);

  return offset;
}


static const value_string lix2_PTCAccessPolicyType_vals[] = {
  {   1, "pTCUserAccessPolicyAttempt" },
  {   2, "groupAuthorizationRulesAttempt" },
  {   3, "pTCUserAccessPolicyQuery" },
  {   4, "groupAuthorizationRulesQuery" },
  {   5, "pTCUserAccessPolicyResult" },
  {   6, "groupAuthorizationRulesResult" },
  {   7, "requestUnsuccessful" },
  { 0, NULL }
};


static int
dissect_lix2_PTCAccessPolicyType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_PTCUserAccessPolicy_vals[] = {
  {   1, "allowIncomingPTCSessionRequest" },
  {   2, "blockIncomingPTCSessionRequest" },
  {   3, "allowAutoAnswerMode" },
  {   4, "allowOverrideManualAnswerMode" },
  { 0, NULL }
};


static int
dissect_lix2_PTCUserAccessPolicy(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_PTCAccessPolicyFailure_vals[] = {
  {   1, "requestUnsuccessful" },
  {   2, "requestUnknown" },
  { 0, NULL }
};


static int
dissect_lix2_PTCAccessPolicyFailure(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PTCAccessPolicy_sequence[] = {
  { &hf_lix2_pTCTargetInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCDirection   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_pTCAccessPolicyType, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCAccessPolicyType },
  { &hf_lix2_pTCUserAccessPolicy, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCUserAccessPolicy },
  { &hf_lix2_pTCGroupAuthRule, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCGroupAuthRule },
  { &hf_lix2_pTCContactID   , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetInformation },
  { &hf_lix2_pTCAccessPolicyFailure, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PTCAccessPolicyFailure },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PTCAccessPolicy(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PTCAccessPolicy_sequence, hf_index, ett_lix2_PTCAccessPolicy);

  return offset;
}


static const value_string lix2_UDMSubscriberRecordChangeMethod_vals[] = {
  {   1, "pEIChange" },
  {   2, "sUPIChange" },
  {   3, "gPSIChange" },
  {   4, "uEDeprovisioning" },
  {   5, "unknown" },
  {   6, "serviceIDChange" },
  { 0, NULL }
};


static int
dissect_lix2_UDMSubscriberRecordChangeMethod(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t UDMSubscriberRecordChangeMessage_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_oldPEI         , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_oldSUPI        , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_oldGPSI        , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_oldserviceID   , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ServiceID },
  { &hf_lix2_subscriberRecordChangeMethod, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_UDMSubscriberRecordChangeMethod },
  { &hf_lix2_serviceID      , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ServiceID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMSubscriberRecordChangeMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMSubscriberRecordChangeMessage_sequence, hf_index, ett_lix2_UDMSubscriberRecordChangeMessage);

  return offset;
}


static const value_string lix2_UDMCancelLocationMethod_vals[] = {
  {   1, "aMF3GPPAccessDeregistration" },
  {   2, "aMFNon3GPPAccessDeregistration" },
  {   3, "uDMDeregistration" },
  {   4, "unknown" },
  { 0, NULL }
};


static int
dissect_lix2_UDMCancelLocationMethod(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t UDMAMFDeregistrationInfo_sequence[] = {
  { &hf_lix2_gUAMI          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GUAMI },
  { &hf_lix2_purgeFlag      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMAMFDeregistrationInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMAMFDeregistrationInfo_sequence, hf_index, ett_lix2_UDMAMFDeregistrationInfo);

  return offset;
}


static const value_string lix2_UDMDeregReason_vals[] = {
  {   1, "uEInitialRegistration" },
  {   2, "uERegistrationAreaChange" },
  {   3, "subscriptionWithdrawn" },
  {   4, "fiveGSToEPSMobility" },
  {   5, "fiveGSToEPSMobilityUeInitialRegistration" },
  {   6, "reregistrationRequired" },
  {   7, "sMFContextTransferred" },
  {   8, "duplicatePDUSession" },
  {   9, "fiveGSRVCCToUTRANMobility" },
  {  10, "pDUSessionReactivationRequired" },
  {  11, "disasterConditionTerminated" },
  { 0, NULL }
};


static int
dissect_lix2_UDMDeregReason(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t UDMDeregistrationData_sequence[] = {
  { &hf_lix2_deregReason    , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UDMDeregReason },
  { &hf_lix2_accessType     , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMDeregistrationData(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMDeregistrationData_sequence, hf_index, ett_lix2_UDMDeregistrationData);

  return offset;
}


static const ber_sequence_t UDMCancelLocationMessage_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUAMI          , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUAMI },
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_cancelLocationMethod, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_UDMCancelLocationMethod },
  { &hf_lix2_aMFDeregistrationInfo, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UDMAMFDeregistrationInfo },
  { &hf_lix2_deregistrationData, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UDMDeregistrationData },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMCancelLocationMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMCancelLocationMessage_sequence, hf_index, ett_lix2_UDMCancelLocationMessage);

  return offset;
}


static const ber_sequence_t SMSReport_sequence[] = {
  { &hf_lix2_location       , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_sMSTPDUData    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SMSTPDUData },
  { &hf_lix2_messageType    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SMSMessageType },
  { &hf_lix2_rPMessageReference, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SMSRPMessageReference },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMSReport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMSReport_sequence, hf_index, ett_lix2_SMSReport);

  return offset;
}


static const value_string lix2_EstablishmentStatus_vals[] = {
  {   0, "established" },
  {   1, "released" },
  { 0, NULL }
};


static int
dissect_lix2_EstablishmentStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t AccessInfo_sequence[] = {
  { &hf_lix2_accessType     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_rATType        , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_gTPTunnelID    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_establishmentStatus, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_EstablishmentStatus },
  { &hf_lix2_aNTypeToReactivate, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_satelliteBackhaulCategory, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_gEOSatelliteID , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GEOSatelliteID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AccessInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AccessInfo_sequence, hf_index, ett_lix2_AccessInfo);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_AccessInfo_sequence_of[1] = {
  { &hf_lix2_accessInfo_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_AccessInfo },
};

static int
dissect_lix2_SEQUENCE_OF_AccessInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_AccessInfo_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_AccessInfo);

  return offset;
}



static int
dissect_lix2_SMFMAUpgradeIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_SMFEPSPDNCnxInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_SMFMAAcceptedIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_ATSSSContainer(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t SMFMAPDUSessionEstablishment_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUPIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUPIUnauthenticatedIndication },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_pDUSessionType , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionType },
  { &hf_lix2_accessInfo     , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_AccessInfo },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_uEEndpoint     , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UEEndpointAddress },
  { &hf_lix2_location       , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_dNN            , BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_aMFID          , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AMFID },
  { &hf_lix2_hSMFURI        , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HSMFURI },
  { &hf_lix2_requestType    , BER_CLASS_CON, 14, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMRequestType },
  { &hf_lix2_sMPDUDNRequest , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMPDUDNRequest },
  { &hf_lix2_servingNetwork , BER_CLASS_CON, 16, BER_FLAGS_IMPLTAG, dissect_lix2_SMFServingNetwork },
  { &hf_lix2_oldPDUSessionID, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_mAUpgradeIndication, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAUpgradeIndication },
  { &hf_lix2_ePSPDNCnxInfo  , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFEPSPDNCnxInfo },
  { &hf_lix2_mAAcceptedIndication, BER_CLASS_CON, 20, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAAcceptedIndication },
  { &hf_lix2_aTSSSContainer , BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ATSSSContainer },
  { &hf_lix2_uEEPSPDNConnection, BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEEPSPDNConnection },
  { &hf_lix2_ePS5GSComboInfo, BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPS5GSComboInfo },
  { &hf_lix2_selectedDNN    , BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_handoverState  , BER_CLASS_CON, 25, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HandoverState },
  { &hf_lix2_pCCRules       , BER_CLASS_CON, 26, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PCCRuleSet },
  { &hf_lix2_ePSPDNConnectionEstablishment, BER_CLASS_CON, 27, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionEstablishment },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFMAPDUSessionEstablishment(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFMAPDUSessionEstablishment_sequence, hf_index, ett_lix2_SMFMAPDUSessionEstablishment);

  return offset;
}


static const ber_sequence_t SMFMAPDUSessionModification_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUPIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUPIUnauthenticatedIndication },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_accessInfo     , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_AccessInfo },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_location       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_requestType    , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMRequestType },
  { &hf_lix2_servingNetwork , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_SMFServingNetwork },
  { &hf_lix2_oldPDUSessionID, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_mAUpgradeIndication, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAUpgradeIndication },
  { &hf_lix2_ePSPDNCnxInfo  , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFEPSPDNCnxInfo },
  { &hf_lix2_mAAcceptedIndication, BER_CLASS_CON, 14, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAAcceptedIndication },
  { &hf_lix2_aTSSSContainer , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ATSSSContainer },
  { &hf_lix2_uEEPSPDNConnection, BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEEPSPDNConnection },
  { &hf_lix2_ePS5GSComboInfo, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPS5GSComboInfo },
  { &hf_lix2_handoverState  , BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HandoverState },
  { &hf_lix2_pCCRules       , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PCCRuleSet },
  { &hf_lix2_uPPathChange   , BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UPPathChange },
  { &hf_lix2_pFDDataForApp  , BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PFDDataForApp },
  { &hf_lix2_ePSPDNConnectionModification, BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionModification },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFMAPDUSessionModification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFMAPDUSessionModification_sequence, hf_index, ett_lix2_SMFMAPDUSessionModification);

  return offset;
}


static const ber_sequence_t SMFMAPDUSessionRelease_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_timeOfFirstPacket, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_timeOfLastPacket, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_uplinkVolume   , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_downlinkVolume , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_location       , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_cause_01       , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFErrorCodes },
  { &hf_lix2_nGAPCause      , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NGAPCauseInt },
  { &hf_lix2_fiveGMMCause   , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMMCause },
  { &hf_lix2_pCCRuleIDs     , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PCCRuleIDSet },
  { &hf_lix2_ePSPDNConnectionRelease, BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionRelease },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFMAPDUSessionRelease(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFMAPDUSessionRelease_sequence, hf_index, ett_lix2_SMFMAPDUSessionRelease);

  return offset;
}


static const ber_sequence_t SMFStartOfInterceptionWithEstablishedMAPDUSession_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUPIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUPIUnauthenticatedIndication },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_pDUSessionType , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionType },
  { &hf_lix2_accessInfo     , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_AccessInfo },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_uEEndpoint     , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UEEndpointAddress },
  { &hf_lix2_location       , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_dNN            , BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_aMFID          , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AMFID },
  { &hf_lix2_hSMFURI        , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HSMFURI },
  { &hf_lix2_requestType    , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMRequestType },
  { &hf_lix2_sMPDUDNRequest , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMPDUDNRequest },
  { &hf_lix2_servingNetwork , BER_CLASS_CON, 16, BER_FLAGS_IMPLTAG, dissect_lix2_SMFServingNetwork },
  { &hf_lix2_oldPDUSessionID, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_mAUpgradeIndication, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAUpgradeIndication },
  { &hf_lix2_ePSPDNCnxInfo  , BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFEPSPDNCnxInfo },
  { &hf_lix2_mAAcceptedIndication, BER_CLASS_CON, 20, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAAcceptedIndication },
  { &hf_lix2_aTSSSContainer , BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ATSSSContainer },
  { &hf_lix2_ePS5GSComboInfo, BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPS5GSComboInfo },
  { &hf_lix2_uEEPSPDNConnection, BER_CLASS_CON, 23, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEEPSPDNConnection },
  { &hf_lix2_pCCRules       , BER_CLASS_CON, 24, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PCCRuleSet },
  { &hf_lix2_pFDDataForApps , BER_CLASS_CON, 25, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PFDDataForApps },
  { &hf_lix2_ePSStartOfInterceptionWithEstablishedPDNConnection, BER_CLASS_CON, 26, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSStartOfInterceptionWithEstablishedPDNConnection },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFStartOfInterceptionWithEstablishedMAPDUSession(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFStartOfInterceptionWithEstablishedMAPDUSession_sequence, hf_index, ett_lix2_SMFStartOfInterceptionWithEstablishedMAPDUSession);

  return offset;
}


static const ber_sequence_t SMFMAUnsuccessfulProcedure_sequence[] = {
  { &hf_lix2_failedProcedureType_01, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SMFFailedProcedureType },
  { &hf_lix2_failureCause_03, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMCause },
  { &hf_lix2_requestedSlice , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NSSAI },
  { &hf_lix2_initiator      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_Initiator },
  { &hf_lix2_sUPI           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUPIUnauthenticated, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUPIUnauthenticatedIndication },
  { &hf_lix2_pEI            , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_accessInfo     , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_AccessInfo },
  { &hf_lix2_uEEndpoint     , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UEEndpointAddress },
  { &hf_lix2_location       , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_dNN            , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_aMFID          , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AMFID },
  { &hf_lix2_hSMFURI        , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HSMFURI },
  { &hf_lix2_requestType    , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMRequestType },
  { &hf_lix2_sMPDUDNRequest , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMPDUDNRequest },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFMAUnsuccessfulProcedure(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFMAUnsuccessfulProcedure_sequence, hf_index, ett_lix2_SMFMAUnsuccessfulProcedure);

  return offset;
}


static const ber_sequence_t AMFIdentifierAssociation_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUCI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUTI           , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGGUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_fiveGSTAIList  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAIList },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFIdentifierAssociation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFIdentifierAssociation_sequence, hf_index, ett_lix2_AMFIdentifierAssociation);

  return offset;
}


static const ber_sequence_t MMEIdentifierAssociation_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_gUTI_01        , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_tAIList        , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAIList },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMEIdentifierAssociation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMEIdentifierAssociation_sequence, hf_index, ett_lix2_MMEIdentifierAssociation);

  return offset;
}


static const value_string lix2_RequestIndication_vals[] = {
  {   0, "uEREQPDUSESMOD" },
  {   1, "uEREQPDUSESREL" },
  {   2, "pDUSESMOB" },
  {   3, "nWREQPDUSESAUTH" },
  {   4, "nWREQPDUSESMOD" },
  {   5, "nWREQPDUSESREL" },
  {   6, "eBIASSIGNMENTREQ" },
  {   7, "rELDUETO5GANREQUEST" },
  { 0, NULL }
};


static int
dissect_lix2_RequestIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SMFPDUtoMAPDUSessionModification_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUPIUnauthenticated, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUPIUnauthenticatedIndication },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_location       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_requestType    , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMRequestType },
  { &hf_lix2_accessType     , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_rATType        , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_requestIndication, BER_CLASS_CON, 12, BER_FLAGS_IMPLTAG, dissect_lix2_RequestIndication },
  { &hf_lix2_aTSSSContainer , BER_CLASS_CON, 13, BER_FLAGS_IMPLTAG, dissect_lix2_ATSSSContainer },
  { &hf_lix2_uEEndpoint_01  , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_servingNetwork , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMFServingNetwork },
  { &hf_lix2_handoverState  , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_HandoverState },
  { &hf_lix2_gTPTunnelInfo  , BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GTPTunnelInfo },
  { &hf_lix2_ePSPDNConnectionModification, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSPDNConnectionModification },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SMFPDUtoMAPDUSessionModification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SMFPDUtoMAPDUSessionModification_sequence, hf_index, ett_lix2_SMFPDUtoMAPDUSessionModification);

  return offset;
}



static int
dissect_lix2_NEFID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_RDSSupport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_boolean(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_SMFID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_AFID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t NEFPDUSessionEstablishment_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_nEFID          , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_NEFID },
  { &hf_lix2_dNN            , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_rDSSupport     , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_RDSSupport },
  { &hf_lix2_sMFID          , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_SMFID },
  { &hf_lix2_aFID           , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFPDUSessionEstablishment(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFPDUSessionEstablishment_sequence, hf_index, ett_lix2_NEFPDUSessionEstablishment);

  return offset;
}



static int
dissect_lix2_RDSPortNumber(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}



static int
dissect_lix2_ApplicationID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_RDSAction_vals[] = {
  {   1, "reservePort" },
  {   2, "releasePort" },
  { 0, NULL }
};


static int
dissect_lix2_RDSAction(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_SerializationFormat_vals[] = {
  {   1, "xml" },
  {   2, "json" },
  {   3, "cbor" },
  { 0, NULL }
};


static int
dissect_lix2_SerializationFormat(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NEFPDUSessionModification_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_initiator      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_Initiator },
  { &hf_lix2_rDSSourcePortNumber, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RDSPortNumber },
  { &hf_lix2_rDSDestinationPortNumber, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RDSPortNumber },
  { &hf_lix2_applicationID  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ApplicationID },
  { &hf_lix2_aFID           , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { &hf_lix2_rDSAction      , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RDSAction },
  { &hf_lix2_serializationFormat, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SerializationFormat },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFPDUSessionModification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFPDUSessionModification_sequence, hf_index, ett_lix2_NEFPDUSessionModification);

  return offset;
}


static const value_string lix2_NEFReleaseCause_vals[] = {
  {   1, "sMFRelease" },
  {   2, "dNRelease" },
  {   3, "uDMRelease" },
  {   4, "cHFRelease" },
  {   5, "localConfigurationPolicy" },
  {   6, "unknownCause" },
  { 0, NULL }
};


static int
dissect_lix2_NEFReleaseCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NEFPDUSessionRelease_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_timeOfFirstPacket, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_timeOfLastPacket, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_uplinkVolume   , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_downlinkVolume , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_releaseCause   , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_NEFReleaseCause },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFPDUSessionRelease(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFPDUSessionRelease_sequence, hf_index, ett_lix2_NEFPDUSessionRelease);

  return offset;
}


static const value_string lix2_NEFFailureCause_vals[] = {
  {   1, "userUnknown" },
  {   2, "niddConfigurationNotAvailable" },
  {   3, "contextNotFound" },
  {   4, "portNotFree" },
  {   5, "portNotAssociatedWithSpecifiedApplication" },
  { 0, NULL }
};


static int
dissect_lix2_NEFFailureCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NEFUnsuccessfulProcedure_sequence[] = {
  { &hf_lix2_failureCause   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NEFFailureCause },
  { &hf_lix2_sUPI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_dNN            , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_rDSDestinationPortNumber, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_RDSPortNumber },
  { &hf_lix2_applicationID  , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_ApplicationID },
  { &hf_lix2_aFID           , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFUnsuccessfulProcedure(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFUnsuccessfulProcedure_sequence, hf_index, ett_lix2_NEFUnsuccessfulProcedure);

  return offset;
}


static const ber_sequence_t NEFStartOfInterceptionWithEstablishedPDUSession_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_dNN            , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_nEFID          , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_NEFID },
  { &hf_lix2_rDSSupport     , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_RDSSupport },
  { &hf_lix2_sMFID          , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_SMFID },
  { &hf_lix2_aFID           , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFStartOfInterceptionWithEstablishedPDUSession(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFStartOfInterceptionWithEstablishedPDUSession_sequence, hf_index, ett_lix2_NEFStartOfInterceptionWithEstablishedPDUSession);

  return offset;
}



static int
dissect_lix2_TriggerID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_TriggerPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_PriorityDT_vals[] = {
  {   1, "noPriority" },
  {   2, "priority" },
  { 0, NULL }
};


static int
dissect_lix2_PriorityDT(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NEFDeviceTrigger_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_triggerId      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_TriggerID },
  { &hf_lix2_aFID           , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { &hf_lix2_triggerPayload , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TriggerPayload },
  { &hf_lix2_validityPeriod , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_priorityDT     , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PriorityDT },
  { &hf_lix2_sourcePortId   , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_destinationPortId, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFDeviceTrigger(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFDeviceTrigger_sequence, hf_index, ett_lix2_NEFDeviceTrigger);

  return offset;
}


static const ber_sequence_t NEFDeviceTriggerReplace_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_triggerId      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_TriggerID },
  { &hf_lix2_aFID           , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { &hf_lix2_triggerPayload , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TriggerPayload },
  { &hf_lix2_validityPeriod , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_priorityDT     , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PriorityDT },
  { &hf_lix2_sourcePortId   , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_destinationPortId, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFDeviceTriggerReplace(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFDeviceTriggerReplace_sequence, hf_index, ett_lix2_NEFDeviceTriggerReplace);

  return offset;
}


static const ber_sequence_t NEFDeviceTriggerCancellation_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_triggerId      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_TriggerID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFDeviceTriggerCancellation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFDeviceTriggerCancellation_sequence, hf_index, ett_lix2_NEFDeviceTriggerCancellation);

  return offset;
}


static const value_string lix2_DeviceTriggerDeliveryResult_vals[] = {
  {   1, "success" },
  {   2, "unknown" },
  {   3, "failure" },
  {   4, "triggered" },
  {   5, "expired" },
  {   6, "unconfirmed" },
  {   7, "replaced" },
  {   8, "terminate" },
  { 0, NULL }
};


static int
dissect_lix2_DeviceTriggerDeliveryResult(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NEFDeviceTriggerReportNotify_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_triggerId      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_TriggerID },
  { &hf_lix2_deviceTriggerDeliveryResult, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_DeviceTriggerDeliveryResult },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFDeviceTriggerReportNotify(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFDeviceTriggerReportNotify_sequence, hf_index, ett_lix2_NEFDeviceTriggerReportNotify);

  return offset;
}


static const ber_sequence_t NEFMSISDNLessMOSMS_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_terminatingSMSParty, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { &hf_lix2_sMS            , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SMSTPDUData },
  { &hf_lix2_sourcePort     , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_destinationPort, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFMSISDNLessMOSMS(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFMSISDNLessMOSMS_sequence, hf_index, ett_lix2_NEFMSISDNLessMOSMS);

  return offset;
}


static const value_string lix2_Day_vals[] = {
  {   1, "monday" },
  {   2, "tuesday" },
  {   3, "wednesday" },
  {   4, "thursday" },
  {   5, "friday" },
  {   6, "saturday" },
  {   7, "sunday" },
  { 0, NULL }
};


static int
dissect_lix2_Day(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t Daytime_sequence[] = {
  { &hf_lix2_daysOfWeek     , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Day },
  { &hf_lix2_timeOfDayStart , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_timeOfDayEnd   , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_Daytime(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   Daytime_sequence, hf_index, ett_lix2_Daytime);

  return offset;
}


static const ber_sequence_t UMTLocationArea5G_sequence[] = {
  { &hf_lix2_timeOfDay      , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_Daytime },
  { &hf_lix2_durationSec    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_location_01    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_NRLocation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UMTLocationArea5G(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UMTLocationArea5G_sequence, hf_index, ett_lix2_UMTLocationArea5G);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_UMTLocationArea5G_sequence_of[1] = {
  { &hf_lix2_expectedUEMovingTrajectory_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_UMTLocationArea5G },
};

static int
dissect_lix2_SEQUENCE_OF_UMTLocationArea5G(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_UMTLocationArea5G_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_UMTLocationArea5G);

  return offset;
}


static const value_string lix2_StationaryIndication_vals[] = {
  {   1, "stationary" },
  {   2, "mobile" },
  { 0, NULL }
};


static int
dissect_lix2_StationaryIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_Daytime_sequence_of[1] = {
  { &hf_lix2_days_item      , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_Daytime },
};

static int
dissect_lix2_SEQUENCE_OF_Daytime(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_Daytime_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_Daytime);

  return offset;
}


static const ber_sequence_t ScheduledCommunicationTime_sequence[] = {
  { &hf_lix2_days           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_Daytime },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ScheduledCommunicationTime(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ScheduledCommunicationTime_sequence, hf_index, ett_lix2_ScheduledCommunicationTime);

  return offset;
}


static const value_string lix2_ScheduledCommunicationType_vals[] = {
  {   1, "downlinkOnly" },
  {   2, "uplinkOnly" },
  {   3, "bidirectional" },
  { 0, NULL }
};


static int
dissect_lix2_ScheduledCommunicationType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_BatteryIndication_vals[] = {
  {   1, "batteryRecharge" },
  {   2, "batteryReplace" },
  {   3, "batteryNoRecharge" },
  {   4, "batteryNoReplace" },
  {   5, "noBattery" },
  { 0, NULL }
};


static int
dissect_lix2_BatteryIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_TrafficProfile_vals[] = {
  {   1, "singleTransUL" },
  {   2, "singleTransDL" },
  {   3, "dualTransULFirst" },
  {   4, "dualTransDLFirst" },
  {   5, "multiTrans" },
  { 0, NULL }
};


static int
dissect_lix2_TrafficProfile(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NEFExpectedUEBehaviourUpdate_sequence[] = {
  { &hf_lix2_gPSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_expectedUEMovingTrajectory, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UMTLocationArea5G },
  { &hf_lix2_stationaryIndication, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_StationaryIndication },
  { &hf_lix2_communicationDurationTime, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_periodicTime   , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_scheduledCommunicationTime, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ScheduledCommunicationTime },
  { &hf_lix2_scheduledCommunicationType, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ScheduledCommunicationType },
  { &hf_lix2_batteryIndication, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BatteryIndication },
  { &hf_lix2_trafficProfile , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TrafficProfile },
  { &hf_lix2_expectedTimeAndDayOfWeekInTrajectory, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UMTLocationArea5G },
  { &hf_lix2_aFID           , BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { &hf_lix2_validityTime   , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFExpectedUEBehaviourUpdate(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFExpectedUEBehaviourUpdate_sequence, hf_index, ett_lix2_NEFExpectedUEBehaviourUpdate);

  return offset;
}



static int
dissect_lix2_SCEFID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_SCSASID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t SCEFPDNConnectionEstablishment_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_sCEFID         , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFID },
  { &hf_lix2_aPN            , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_APN },
  { &hf_lix2_rDSSupport     , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_RDSSupport },
  { &hf_lix2_sCSASID        , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_SCSASID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFPDNConnectionEstablishment(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFPDNConnectionEstablishment_sequence, hf_index, ett_lix2_SCEFPDNConnectionEstablishment);

  return offset;
}


static const ber_sequence_t SCEFPDNConnectionUpdate_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_initiator      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_Initiator },
  { &hf_lix2_rDSSourcePortNumber, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RDSPortNumber },
  { &hf_lix2_rDSDestinationPortNumber, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RDSPortNumber },
  { &hf_lix2_applicationID  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ApplicationID },
  { &hf_lix2_sCSASID        , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SCSASID },
  { &hf_lix2_rDSAction      , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RDSAction },
  { &hf_lix2_serializationFormat, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SerializationFormat },
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFPDNConnectionUpdate(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFPDNConnectionUpdate_sequence, hf_index, ett_lix2_SCEFPDNConnectionUpdate);

  return offset;
}


static const value_string lix2_SCEFReleaseCause_vals[] = {
  {   1, "mMERelease" },
  {   2, "dNRelease" },
  {   3, "hSSRelease" },
  {   4, "localConfigurationPolicy" },
  {   5, "unknownCause" },
  { 0, NULL }
};


static int
dissect_lix2_SCEFReleaseCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SCEFPDNConnectionRelease_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_timeOfFirstPacket, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_timeOfLastPacket, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_uplinkVolume   , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_downlinkVolume , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_releaseCause_01, BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFReleaseCause },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFPDNConnectionRelease(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFPDNConnectionRelease_sequence, hf_index, ett_lix2_SCEFPDNConnectionRelease);

  return offset;
}


static const value_string lix2_SCEFFailureCause_vals[] = {
  {   1, "userUnknown" },
  {   2, "niddConfigurationNotAvailable" },
  {   3, "invalidEPSBearer" },
  {   4, "operationNotAllowed" },
  {   5, "portNotFree" },
  {   6, "portNotAssociatedWithSpecifiedApplication" },
  { 0, NULL }
};


static int
dissect_lix2_SCEFFailureCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SCEFUnsuccessfulProcedure_sequence[] = {
  { &hf_lix2_failureCause_01, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFFailureCause },
  { &hf_lix2_iMSI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_aPN            , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_APN },
  { &hf_lix2_rDSDestinationPortNumber, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RDSPortNumber },
  { &hf_lix2_applicationID  , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ApplicationID },
  { &hf_lix2_sCSASID        , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_SCSASID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFUnsuccessfulProcedure(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFUnsuccessfulProcedure_sequence, hf_index, ett_lix2_SCEFUnsuccessfulProcedure);

  return offset;
}


static const ber_sequence_t SCEFStartOfInterceptionWithEstablishedPDNConnection_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { &hf_lix2_ePSBearerID    , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_sCEFID         , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFID },
  { &hf_lix2_aPN            , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_APN },
  { &hf_lix2_rDSSupport     , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_RDSSupport },
  { &hf_lix2_sCSASID        , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_SCSASID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFStartOfInterceptionWithEstablishedPDNConnection(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFStartOfInterceptionWithEstablishedPDNConnection_sequence, hf_index, ett_lix2_SCEFStartOfInterceptionWithEstablishedPDNConnection);

  return offset;
}


static const ber_sequence_t SCEFDeviceTrigger_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_triggerId      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_TriggerID },
  { &hf_lix2_sCSASID        , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SCSASID },
  { &hf_lix2_triggerPayload , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TriggerPayload },
  { &hf_lix2_validityPeriod , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_priorityDT     , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PriorityDT },
  { &hf_lix2_sourcePortId   , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_destinationPortId, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFDeviceTrigger(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFDeviceTrigger_sequence, hf_index, ett_lix2_SCEFDeviceTrigger);

  return offset;
}


static const ber_sequence_t SCEFDeviceTriggerReplace_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_triggerId      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_TriggerID },
  { &hf_lix2_sCSASID        , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SCSASID },
  { &hf_lix2_triggerPayload , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TriggerPayload },
  { &hf_lix2_validityPeriod , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_priorityDT     , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PriorityDT },
  { &hf_lix2_sourcePortId   , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_destinationPortId, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFDeviceTriggerReplace(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFDeviceTriggerReplace_sequence, hf_index, ett_lix2_SCEFDeviceTriggerReplace);

  return offset;
}


static const ber_sequence_t SCEFDeviceTriggerCancellation_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_triggerId      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_TriggerID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFDeviceTriggerCancellation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFDeviceTriggerCancellation_sequence, hf_index, ett_lix2_SCEFDeviceTriggerCancellation);

  return offset;
}


static const ber_sequence_t SCEFDeviceTriggerReportNotify_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_triggerId      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_TriggerID },
  { &hf_lix2_deviceTriggerDeliveryResult, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_DeviceTriggerDeliveryResult },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFDeviceTriggerReportNotify(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFDeviceTriggerReportNotify_sequence, hf_index, ett_lix2_SCEFDeviceTriggerReportNotify);

  return offset;
}


static const ber_sequence_t SCEFMSISDNLessMOSMS_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifie, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_terminatingSMSParty_01, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SCSASID },
  { &hf_lix2_sMS            , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SMSTPDUData },
  { &hf_lix2_sourcePort     , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_destinationPort, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFMSISDNLessMOSMS(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFMSISDNLessMOSMS_sequence, hf_index, ett_lix2_SCEFMSISDNLessMOSMS);

  return offset;
}


static const value_string lix2_PeriodicCommunicationIndicator_vals[] = {
  {   1, "periodic" },
  {   2, "nonPeriodic" },
  { 0, NULL }
};


static int
dissect_lix2_PeriodicCommunicationIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SCEFCommunicationPatternUpdate_sequence[] = {
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_periodicCommunicationIndicator, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PeriodicCommunicationIndicator },
  { &hf_lix2_communicationDurationTime, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_periodicTime   , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_scheduledCommunicationTime, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ScheduledCommunicationTime },
  { &hf_lix2_scheduledCommunicationType, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ScheduledCommunicationType },
  { &hf_lix2_stationaryIndication, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_StationaryIndication },
  { &hf_lix2_batteryIndication, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BatteryIndication },
  { &hf_lix2_trafficProfile , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TrafficProfile },
  { &hf_lix2_expectedUEMovingTrajectory, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_UMTLocationArea5G },
  { &hf_lix2_sCSASID        , BER_CLASS_CON, 13, BER_FLAGS_IMPLTAG, dissect_lix2_SCSASID },
  { &hf_lix2_validityTime   , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFCommunicationPatternUpdate(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFCommunicationPatternUpdate_sequence, hf_index, ett_lix2_SCEFCommunicationPatternUpdate);

  return offset;
}


static const value_string lix2_EPSAttachType_vals[] = {
  {   1, "ePSAttach" },
  {   2, "combinedEPSIMSIAttach" },
  {   3, "ePSRLOSAttach" },
  {   4, "ePSEmergencyAttach" },
  {   5, "reserved" },
  { 0, NULL }
};


static int
dissect_lix2_EPSAttachType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_EPSAttachResult_vals[] = {
  {   1, "ePSOnly" },
  {   2, "combinedEPSIMSI" },
  { 0, NULL }
};


static int
dissect_lix2_EPSAttachResult(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_EPSSMSServiceStatus_vals[] = {
  {   1, "sMSServicesNotAvailable" },
  {   2, "sMSServicesNotAvailableInThisPLMN" },
  {   3, "networkFailure" },
  {   4, "congestion" },
  { 0, NULL }
};


static int
dissect_lix2_EPSSMSServiceStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t CSGIDList_sequence_of[1] = {
  { &hf_lix2_CSGIDList_item , BER_CLASS_UNI, BER_UNI_TAG_INTEGER, BER_FLAGS_NOOWNTAG, dissect_lix2_CSGID },
};

static int
dissect_lix2_CSGIDList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      CSGIDList_sequence_of, hf_index, ett_lix2_CSGIDList);

  return offset;
}


static const ber_sequence_t TACList_sequence_of[1] = {
  { &hf_lix2_TACList_item   , BER_CLASS_UNI, BER_UNI_TAG_OCTETSTRING, BER_FLAGS_NOOWNTAG, dissect_lix2_TAC },
};

static int
dissect_lix2_TACList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      TACList_sequence_of, hf_index, ett_lix2_TACList);

  return offset;
}


static const ber_sequence_t ConnectedENGNB_sequence[] = {
  { &hf_lix2_eNGNBID        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GNbID },
  { &hf_lix2_supportedTAList_01, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_TACList },
  { &hf_lix2_broadcastPLMN  , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNList },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ConnectedENGNB(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ConnectedENGNB_sequence, hf_index, ett_lix2_ConnectedENGNB);

  return offset;
}


static const ber_sequence_t ConnectedENGNBList_sequence_of[1] = {
  { &hf_lix2_ConnectedENGNBList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_ConnectedENGNB },
};

static int
dissect_lix2_ConnectedENGNBList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      ConnectedENGNBList_sequence_of, hf_index, ett_lix2_ConnectedENGNBList);

  return offset;
}


static const ber_sequence_t MMEServedGUMMEI_sequence[] = {
  { &hf_lix2_servedPLMNs    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNSupportList },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMEServedGUMMEI(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMEServedGUMMEI_sequence, hf_index, ett_lix2_MMEServedGUMMEI);

  return offset;
}


static const ber_sequence_t MMEServedGUMMEIList_sequence_of[1] = {
  { &hf_lix2_MMEServedGUMMEIList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_MMEServedGUMMEI },
};

static int
dissect_lix2_MMEServedGUMMEIList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      MMEServedGUMMEIList_sequence_of, hf_index, ett_lix2_MMEServedGUMMEIList);

  return offset;
}


static const ber_sequence_t S1Information_sequence[] = {
  { &hf_lix2_globalRANNodeID, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GlobalRANNodeID },
  { &hf_lix2_rANNodeName    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RANNodeName },
  { &hf_lix2_supportedTAList, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SupportedTAList },
  { &hf_lix2_cSGIDList      , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CSGIDList },
  { &hf_lix2_connectedENGNBList, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ConnectedENGNBList },
  { &hf_lix2_mMEServedGUMMEIList, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_MMEServedGUMMEIList },
  { &hf_lix2_iABSupported   , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_S1Information(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   S1Information_sequence, hf_index, ett_lix2_S1Information);

  return offset;
}



static int
dissect_lix2_RANUES1APID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t BBFTunnelInformation_sequence[] = {
  { &hf_lix2_hENBTransportLayerAddress, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IPAddr },
  { &hf_lix2_uDPPortNumber  , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_BBFTunnelInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   BBFTunnelInformation_sequence, hf_index, ett_lix2_BBFTunnelInformation);

  return offset;
}


static const ber_sequence_t LTENTNTAIInformation_sequence[] = {
  { &hf_lix2_pLMN           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_tACListInLTENTN, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_TACList },
  { &hf_lix2_uETAC          , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAC },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LTENTNTAIInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LTENTNTAIInformation_sequence, hf_index, ett_lix2_LTENTNTAIInformation);

  return offset;
}


static const ber_sequence_t EPSNASTransportInitialInformation_sequence[] = {
  { &hf_lix2_rANUES1APID    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RANUES1APID },
  { &hf_lix2_relayNodeIndicator, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_bBFTunnelInformation, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BBFTunnelInformation },
  { &hf_lix2_eDTSession     , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_iABNodeIndication, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_lTENTNTAIInformation, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LTENTNTAIInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSNASTransportInitialInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSNASTransportInitialInformation_sequence, hf_index, ett_lix2_EPSNASTransportInitialInformation);

  return offset;
}



static int
dissect_lix2_EPSUENetworkCapability(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_MMEUES1APID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t ERABQoSParameters_sequence[] = {
  { &hf_lix2_qCI            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_QCI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ERABQoSParameters(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ERABQoSParameters_sequence, hf_index, ett_lix2_ERABQoSParameters);

  return offset;
}


static const ber_sequence_t ERABContext_sequence[] = {
  { &hf_lix2_eRABID         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_eRABQoSParameters, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ERABQoSParameters },
  { &hf_lix2_transportLayerAddress, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPAddr },
  { &hf_lix2_uLGTPTEID      , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { &hf_lix2_dLGTPTEID      , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FTEID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ERABContext(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ERABContext_sequence, hf_index, ett_lix2_ERABContext);

  return offset;
}


static const ber_sequence_t ERABContextList_sequence_of[1] = {
  { &hf_lix2_ERABContextList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_ERABContext },
};

static int
dissect_lix2_ERABContextList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      ERABContextList_sequence_of, hf_index, ett_lix2_ERABContextList);

  return offset;
}



static int
dissect_lix2_OBJECT_IDENTIFIER(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_object_identifier(implicit_tag, actx, tree, tvb, offset, hf_index, NULL);

  return offset;
}



static int
dissect_lix2_ExternalASNReference(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_ExternalASNValue_vals[] = {
  {   1, "bER" },
  {   2, "alignedPER" },
  { 0, NULL }
};

static const ber_choice_t ExternalASNValue_choice[] = {
  {   1, &hf_lix2_bER            , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  {   2, &hf_lix2_alignedPER     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ExternalASNValue(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 ExternalASNValue_choice, hf_index, ett_lix2_ExternalASNValue,
                                 NULL);

  return offset;
}


static const ber_sequence_t ExternalASNType_sequence[] = {
  { &hf_lix2_moduleIdentifier, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_OBJECT_IDENTIFIER },
  { &hf_lix2_aSNReference   , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ExternalASNReference },
  { &hf_lix2_encodedASNValue, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_ExternalASNValue },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ExternalASNType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ExternalASNType_sequence, hf_index, ett_lix2_ExternalASNType);

  return offset;
}



static int
dissect_lix2_EPSHandoverRestrictionList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lix2_ExternalASNType(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_lix2_EPSUERadioCapability(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_EPSCSFallbackIndicator_vals[] = {
  {   1, "cSFallbackRequired" },
  {   2, "cSFallbackHighPriority" },
  { 0, NULL }
};


static int
dissect_lix2_EPSCSFallbackIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_EPSProSeAuthorization(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lix2_ExternalASNType(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string lix2_AerialUESubscriptionIndicator_vals[] = {
  {   1, "authorized" },
  {   2, "notAuthorized" },
  { 0, NULL }
};


static int
dissect_lix2_AerialUESubscriptionIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_EPSSubscriptionBasedUEDifferentiationIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lix2_ExternalASNType(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}


static const ber_sequence_t EPSRANUEContext_sequence[] = {
  { &hf_lix2_mMEUES1APID    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMEUES1APID },
  { &hf_lix2_rANUES1APID    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_RANUES1APID },
  { &hf_lix2_eRABSetupRequest, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ERABContextList },
  { &hf_lix2_handoverRestrictionList, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSHandoverRestrictionList },
  { &hf_lix2_uERadioCapability_01, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSUERadioCapability },
  { &hf_lix2_rATFrequencySelectionPriority, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATFrequencySelectionPriority },
  { &hf_lix2_cSFallbackIndicator, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSCSFallbackIndicator },
  { &hf_lix2_proSeAuthorized, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSProSeAuthorization },
  { &hf_lix2_lTEV2XServicesAuthorized, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LTEV2XServiceAuthorization },
  { &hf_lix2_aerialUESubscription, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AerialUESubscriptionIndicator },
  { &hf_lix2_subscriptionBasedUEDifferentiationIndication, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSSubscriptionBasedUEDifferentiationIndication },
  { &hf_lix2_iABAuthorizedIndicator, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IABAuthorizedIndicator },
  { &hf_lix2_nRV2XServicesAuthorization, BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NRV2XServicesAuthorization },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSRANUEContext(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSRANUEContext_sequence, hf_index, ett_lix2_EPSRANUEContext);

  return offset;
}



static int
dissect_lix2_EPSNetworkPolicy(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t MMEAttach_sequence[] = {
  { &hf_lix2_attachType     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSAttachType },
  { &hf_lix2_attachResult   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSAttachResult },
  { &hf_lix2_iMSI           , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_gUTI_01        , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_ePSTAIList     , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAIList },
  { &hf_lix2_sMSServiceStatus, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSSMSServiceStatus },
  { &hf_lix2_oldGUTI_01     , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  { &hf_lix2_eMM5GRegStatus , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EMM5GMMStatus },
  { &hf_lix2_pagingRestrictionIndicator, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PagingRestrictionIndicator },
  { &hf_lix2_rATType        , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_rRCEstablishmentCause, BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RRCEstablishmentCause },
  { &hf_lix2_s1Information  , BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_S1Information },
  { &hf_lix2_nASTransportInitialInformation_01, BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSNASTransportInitialInformation },
  { &hf_lix2_equivalentPLMNList, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PLMNList },
  { &hf_lix2_ePSUENetworkCapability, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSUENetworkCapability },
  { &hf_lix2_initailRANUEContextSetup, BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANUEContext },
  { &hf_lix2_mUSIMUERequestType, BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MUSIMUERequestType },
  { &hf_lix2_ePSNetworkPolicy, BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSNetworkPolicy },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMEAttach(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMEAttach_sequence, hf_index, ett_lix2_MMEAttach);

  return offset;
}


static const value_string lix2_MMEDirection_vals[] = {
  {   1, "networkInitiated" },
  {   2, "uEInitiated" },
  { 0, NULL }
};


static int
dissect_lix2_MMEDirection(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_EPSDetachType_vals[] = {
  {   1, "ePSDetach" },
  {   2, "iMSIDetach" },
  {   3, "combinedEPSIMSIDetach" },
  {   4, "reAttachRequired" },
  {   5, "reAttachNotRequired" },
  {   6, "reserved" },
  { 0, NULL }
};


static int
dissect_lix2_EPSDetachType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_EMMCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t MMEDetach_sequence[] = {
  { &hf_lix2_detachDirection, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMEDirection },
  { &hf_lix2_detachType     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSDetachType },
  { &hf_lix2_iMSI           , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_gUTI_01        , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  { &hf_lix2_cause_08       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EMMCause },
  { &hf_lix2_location       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_switchOffIndicator, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SwitchOffIndicator },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMEDetach(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMEDetach_sequence, hf_index, ett_lix2_MMEDetach);

  return offset;
}


static const ber_sequence_t MMELocationUpdate_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_gUTI_01        , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_oldGUTI_01     , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  { &hf_lix2_sMSServiceStatus, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSSMSServiceStatus },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMELocationUpdate(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMELocationUpdate_sequence, hf_index, ett_lix2_MMELocationUpdate);

  return offset;
}


static const ber_sequence_t MMEStartOfInterceptionWithEPSAttachedUE_sequence[] = {
  { &hf_lix2_attachType     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSAttachType },
  { &hf_lix2_attachResult   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSAttachResult },
  { &hf_lix2_iMSI           , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_gUTI_01        , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_ePSTAIList     , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAIList },
  { &hf_lix2_sMSServiceStatus, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSSMSServiceStatus },
  { &hf_lix2_eMM5GRegStatus , BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EMM5GMMStatus },
  { &hf_lix2_pagingRestrictionIndicator, BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PagingRestrictionIndicator },
  { &hf_lix2_rATType        , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_rRCEstablishmentCause, BER_CLASS_CON, 15, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RRCEstablishmentCause },
  { &hf_lix2_s1Information  , BER_CLASS_CON, 16, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_S1Information },
  { &hf_lix2_nASTransportInitialInformation_01, BER_CLASS_CON, 17, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSNASTransportInitialInformation },
  { &hf_lix2_equivalentPLMNList, BER_CLASS_CON, 18, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PLMNList },
  { &hf_lix2_ePSUENetworkCapability, BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSUENetworkCapability },
  { &hf_lix2_initailRANUEContextSetup, BER_CLASS_CON, 20, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANUEContext },
  { &hf_lix2_mUSIMUERequestType, BER_CLASS_CON, 21, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MUSIMUERequestType },
  { &hf_lix2_ePSNetworkPolicy, BER_CLASS_CON, 22, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSNetworkPolicy },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMEStartOfInterceptionWithEPSAttachedUE(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMEStartOfInterceptionWithEPSAttachedUE_sequence, hf_index, ett_lix2_MMEStartOfInterceptionWithEPSAttachedUE);

  return offset;
}


static const value_string lix2_MMEFailedProcedureType_vals[] = {
  {   1, "attachReject" },
  {   2, "authenticationReject" },
  {   3, "securityModeReject" },
  {   4, "serviceReject" },
  {   5, "trackingAreaUpdateReject" },
  {   6, "activateDedicatedEPSBearerContextReject" },
  {   7, "activateDefaultEPSBearerContextReject" },
  {   8, "bearerResourceAllocationReject" },
  {   9, "bearerResourceModificationReject" },
  {  10, "modifyEPSBearerContectReject" },
  {  11, "pDNConnectivityReject" },
  {  12, "pDNDisconnectReject" },
  { 0, NULL }
};


static int
dissect_lix2_MMEFailedProcedureType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_ESMCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const value_string lix2_MMEFailureCause_vals[] = {
  {   1, "eMMCause" },
  {   2, "eSMCause" },
  { 0, NULL }
};

static const ber_choice_t MMEFailureCause_choice[] = {
  {   1, &hf_lix2_eMMCause       , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EMMCause },
  {   2, &hf_lix2_eSMCause       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_ESMCause },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMEFailureCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 MMEFailureCause_choice, hf_index, ett_lix2_MMEFailureCause,
                                 NULL);

  return offset;
}


static const ber_sequence_t MMEUnsuccessfulProcedure_sequence[] = {
  { &hf_lix2_failedProcedureType_02, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMEFailedProcedureType },
  { &hf_lix2_failureCause_04, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_MMEFailureCause },
  { &hf_lix2_iMSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_gUTI_01        , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMEUnsuccessfulProcedure(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMEUnsuccessfulProcedure_sequence, hf_index, ett_lix2_MMEUnsuccessfulProcedure);

  return offset;
}



static int
dissect_lix2_KAKMA(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t AAnFAnchorKeyRegister_sequence[] = {
  { &hf_lix2_aKID           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_sUPI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_kAKMA          , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_KAKMA },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AAnFAnchorKeyRegister(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AAnFAnchorKeyRegister_sequence, hf_index, ett_lix2_AAnFAnchorKeyRegister);

  return offset;
}


static const value_string lix2_KeyGetType_vals[] = {
  {   1, "internal" },
  {   2, "external" },
  { 0, NULL }
};


static int
dissect_lix2_KeyGetType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_FQDN(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_UAProtocolID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t AKMAAFID_sequence[] = {
  { &hf_lix2_aFFQDN         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_FQDN },
  { &hf_lix2_uaProtocolID   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UAProtocolID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AKMAAFID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AKMAAFID_sequence, hf_index, ett_lix2_AKMAAFID);

  return offset;
}



static int
dissect_lix2_KAF(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_KAFExpiryTime(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_GeneralizedTime(implicit_tag, actx, tree, tvb, offset, hf_index);

  return offset;
}


static const ber_sequence_t AFKeyInfo_sequence[] = {
  { &hf_lix2_aFID_01        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AKMAAFID },
  { &hf_lix2_kAF            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_KAF },
  { &hf_lix2_kAFExpTime     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_KAFExpiryTime },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AFKeyInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AFKeyInfo_sequence, hf_index, ett_lix2_AFKeyInfo);

  return offset;
}


static const ber_sequence_t AAnFKAKMAApplicationKeyGet_sequence[] = {
  { &hf_lix2_type           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_KeyGetType },
  { &hf_lix2_aKID           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_keyInfo        , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_AFKeyInfo },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AAnFKAKMAApplicationKeyGet(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AAnFKAKMAApplicationKeyGet_sequence, hf_index, ett_lix2_AAnFKAKMAApplicationKeyGet);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_AFKeyInfo_sequence_of[1] = {
  { &hf_lix2_aFKeyList_item , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_AFKeyInfo },
};

static int
dissect_lix2_SEQUENCE_OF_AFKeyInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_AFKeyInfo_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_AFKeyInfo);

  return offset;
}


static const ber_sequence_t AAnFStartOfInterceptWithEstablishedAKMAKeyMaterial_sequence[] = {
  { &hf_lix2_aKID           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_kAKMA          , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_KAKMA },
  { &hf_lix2_aFKeyList      , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_AFKeyInfo },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AAnFStartOfInterceptWithEstablishedAKMAKeyMaterial(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AAnFStartOfInterceptWithEstablishedAKMAKeyMaterial_sequence, hf_index, ett_lix2_AAnFStartOfInterceptWithEstablishedAKMAKeyMaterial);

  return offset;
}



static int
dissect_lix2_NFID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t AAnFAKMAContextRemovalRecord_sequence[] = {
  { &hf_lix2_aKID           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_nFID           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NFID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AAnFAKMAContextRemovalRecord(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AAnFAKMAContextRemovalRecord_sequence, hf_index, ett_lix2_AAnFAKMAContextRemovalRecord);

  return offset;
}



static int
dissect_lix2_OCTET_STRING_SIZE_48(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_TLSPRFAlgorithm_vals[] = {
  {   1, "rfc5246" },
  { 0, NULL }
};


static int
dissect_lix2_TLSPRFAlgorithm(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t TLSCipherSuite_sequence_of[1] = {
  { &hf_lix2_TLSCipherSuite_item, BER_CLASS_UNI, BER_UNI_TAG_INTEGER, BER_FLAGS_NOOWNTAG, dissect_lix2_INTEGER_0_255 },
};

static int
dissect_lix2_TLSCipherSuite(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      TLSCipherSuite_sequence_of, hf_index, ett_lix2_TLSCipherSuite);

  return offset;
}


static const value_string lix2_TLSCipherType_vals[] = {
  {   1, "stream" },
  {   2, "block" },
  {   3, "aead" },
  { 0, NULL }
};


static int
dissect_lix2_TLSCipherType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_TLSCompressionAlgorithm_vals[] = {
  {   1, "null" },
  {   2, "deflate" },
  { 0, NULL }
};


static int
dissect_lix2_TLSCompressionAlgorithm(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_OCTET_STRING_SIZE_32(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_OCTET_STRING_SIZE_0_32(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_OCTET_STRING_SIZE_0_65535(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t TLS12UAStarParams_sequence[] = {
  { &hf_lix2_preMasterSecret, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_48 },
  { &hf_lix2_masterSecret   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_48 },
  { &hf_lix2_pRFAlgorithm   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_TLSPRFAlgorithm },
  { &hf_lix2_cipherSuite    , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_TLSCipherSuite },
  { &hf_lix2_cipherType     , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_TLSCipherType },
  { &hf_lix2_encKeyLength   , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_255 },
  { &hf_lix2_blockLength    , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_255 },
  { &hf_lix2_fixedIVLength  , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_255 },
  { &hf_lix2_recordIVLength , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_255 },
  { &hf_lix2_macLength      , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_255 },
  { &hf_lix2_macKeyLength   , BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER_0_255 },
  { &hf_lix2_compressionAlgorithm, BER_CLASS_CON, 12, BER_FLAGS_IMPLTAG, dissect_lix2_TLSCompressionAlgorithm },
  { &hf_lix2_clientRandom   , BER_CLASS_CON, 13, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_32 },
  { &hf_lix2_serverRandom   , BER_CLASS_CON, 14, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_32 },
  { &hf_lix2_clientSequenceNumber, BER_CLASS_CON, 15, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_serverSequenceNumber, BER_CLASS_CON, 16, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_sessionID      , BER_CLASS_CON, 17, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_0_32 },
  { &hf_lix2_tLSServerExtensions, BER_CLASS_CON, 18, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_0_65535 },
  { &hf_lix2_tLSClientExtensions, BER_CLASS_CON, 19, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_0_65535 },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_TLS12UAStarParams(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   TLS12UAStarParams_sequence, hf_index, ett_lix2_TLS12UAStarParams);

  return offset;
}


static const ber_sequence_t GenericUAStarParams_sequence[] = {
  { &hf_lix2_genericClientParams, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_genericServerParams, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_GenericUAStarParams(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   GenericUAStarParams_sequence, hf_index, ett_lix2_GenericUAStarParams);

  return offset;
}


static const value_string lix2_UAStarParams_vals[] = {
  {   1, "tls12" },
  {   2, "generic" },
  { 0, NULL }
};

static const ber_choice_t UAStarParams_choice[] = {
  {   1, &hf_lix2_tls12          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_TLS12UAStarParams },
  {   2, &hf_lix2_generic        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_GenericUAStarParams },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UAStarParams(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 UAStarParams_choice, hf_index, ett_lix2_UAStarParams,
                                 NULL);

  return offset;
}


static const ber_sequence_t AFAKMAApplicationKeyRefresh_sequence[] = {
  { &hf_lix2_aFID           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { &hf_lix2_aKID           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_kAF            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_KAF },
  { &hf_lix2_uaStarParams   , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UAStarParams },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AFAKMAApplicationKeyRefresh(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AFAKMAApplicationKeyRefresh_sequence, hf_index, ett_lix2_AFAKMAApplicationKeyRefresh);

  return offset;
}


static const ber_sequence_t AFSecurityParams_sequence[] = {
  { &hf_lix2_aFID           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { &hf_lix2_aKID           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_kAF            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_KAF },
  { &hf_lix2_uaStarParams   , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UAStarParams },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AFSecurityParams(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AFSecurityParams_sequence, hf_index, ett_lix2_AFSecurityParams);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_AFSecurityParams_sequence_of[1] = {
  { &hf_lix2_kAFParamList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_AFSecurityParams },
};

static int
dissect_lix2_SEQUENCE_OF_AFSecurityParams(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_AFSecurityParams_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_AFSecurityParams);

  return offset;
}


static const ber_sequence_t AFStartOfInterceptWithEstablishedAKMAApplicationKey_sequence[] = {
  { &hf_lix2_aFID_02        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_FQDN },
  { &hf_lix2_aKID           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_kAFParamList   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_AFSecurityParams },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AFStartOfInterceptWithEstablishedAKMAApplicationKey(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AFStartOfInterceptWithEstablishedAKMAApplicationKey_sequence, hf_index, ett_lix2_AFStartOfInterceptWithEstablishedAKMAApplicationKey);

  return offset;
}


static const ber_sequence_t AFAuxiliarySecurityParameterEstablishment_sequence[] = {
  { &hf_lix2_aFSecurityParams, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AFSecurityParams },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AFAuxiliarySecurityParameterEstablishment(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AFAuxiliarySecurityParameterEstablishment_sequence, hf_index, ett_lix2_AFAuxiliarySecurityParameterEstablishment);

  return offset;
}


static const value_string lix2_AFKeyRemovalCause_vals[] = {
  {   1, "unknown" },
  {   2, "keyExpiry" },
  {   3, "applicationSpecific" },
  { 0, NULL }
};


static int
dissect_lix2_AFKeyRemovalCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t AFApplicationKeyRemoval_sequence[] = {
  { &hf_lix2_aFID           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { &hf_lix2_aKID           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_removalCause   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_AFKeyRemovalCause },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AFApplicationKeyRemoval(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AFApplicationKeyRemoval_sequence, hf_index, ett_lix2_AFApplicationKeyRemoval);

  return offset;
}


static const value_string lix2_N9HRMessageCause_vals[] = {
  {   1, "pDUSessionEstablished" },
  {   2, "pDUSessionModified" },
  {   3, "pDUSessionReleased" },
  {   4, "updatedLocationAvailable" },
  {   5, "sMFChanged" },
  {   6, "other" },
  {   7, "hRLIEnabled" },
  { 0, NULL }
};


static int
dissect_lix2_N9HRMessageCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t N9HRPDUSessionInfo_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { &hf_lix2_location       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_dNN            , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_messageCause   , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_N9HRMessageCause },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_N9HRPDUSessionInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   N9HRPDUSessionInfo_sequence, hf_index, ett_lix2_N9HRPDUSessionInfo);

  return offset;
}


static const value_string lix2_S8HRMessageCause_vals[] = {
  {   1, "bearerActivated" },
  {   2, "bearerModified" },
  {   3, "bearerDeleted" },
  {   4, "pDNDisconnected" },
  {   5, "updatedLocationAvailable" },
  {   6, "sGWChanged" },
  {   7, "other" },
  {   8, "hRLIEnabled" },
  { 0, NULL }
};


static int
dissect_lix2_S8HRMessageCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t S8HRBearerInfo_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { &hf_lix2_bearerID       , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_linkedBearerID , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_location       , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_aPN            , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_APN },
  { &hf_lix2_sGWIPAddress   , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_messageCause_01, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_S8HRMessageCause },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_S8HRBearerInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   S8HRBearerInfo_sequence, hf_index, ett_lix2_S8HRBearerInfo);

  return offset;
}


static const ber_sequence_t SeparatedLocationReporting_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUCI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUTI           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGGUTI },
  { &hf_lix2_location       , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_non3GPPAccessEndpoint, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UEEndpointAddress },
  { &hf_lix2_rATType        , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_ePSIdentities  , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSSubscriberIDs },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SeparatedLocationReporting(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SeparatedLocationReporting_sequence, hf_index, ett_lix2_SeparatedLocationReporting);

  return offset;
}


static const value_string lix2_JWSTokenType_vals[] = {
  {   1, "passport" },
  { 0, NULL }
};


static int
dissect_lix2_JWSTokenType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PASSporTHeader_sequence[] = {
  { &hf_lix2_type_01        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_JWSTokenType },
  { &hf_lix2_algorithm      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_ppt            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_x5u            , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PASSporTHeader(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PASSporTHeader_sequence, hf_index, ett_lix2_PASSporTHeader);

  return offset;
}



static int
dissect_lix2_GeneralizedTime(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_GeneralizedTime(implicit_tag, actx, tree, tvb, offset, hf_index);

  return offset;
}


static const value_string lix2_STIRSHAKENTN_vals[] = {
  {   1, "mSISDN" },
  { 0, NULL }
};

static const ber_choice_t STIRSHAKENTN_choice[] = {
  {   1, &hf_lix2_mSISDN         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_STIRSHAKENTN(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 STIRSHAKENTN_choice, hf_index, ett_lix2_STIRSHAKENTN,
                                 NULL);

  return offset;
}


static const value_string lix2_STIRSHAKENOriginator_vals[] = {
  {   1, "telephoneNumber" },
  {   2, "sTIRSHAKENURI" },
  { 0, NULL }
};

static const ber_choice_t STIRSHAKENOriginator_choice[] = {
  {   1, &hf_lix2_telephoneNumber, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_STIRSHAKENTN },
  {   2, &hf_lix2_sTIRSHAKENURI  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_STIRSHAKENOriginator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 STIRSHAKENOriginator_choice, hf_index, ett_lix2_STIRSHAKENOriginator,
                                 NULL);

  return offset;
}


static const value_string lix2_STIRSHAKENDestination_vals[] = {
  {   1, "telephoneNumber" },
  {   2, "sTIRSHAKENURI" },
  { 0, NULL }
};

static const ber_choice_t STIRSHAKENDestination_choice[] = {
  {   1, &hf_lix2_telephoneNumber, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_STIRSHAKENTN },
  {   2, &hf_lix2_sTIRSHAKENURI  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_STIRSHAKENDestination(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 STIRSHAKENDestination_choice, hf_index, ett_lix2_STIRSHAKENDestination,
                                 NULL);

  return offset;
}


static const ber_sequence_t STIRSHAKENDestinations_sequence_of[1] = {
  { &hf_lix2_STIRSHAKENDestinations_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_STIRSHAKENDestination },
};

static int
dissect_lix2_STIRSHAKENDestinations(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      STIRSHAKENDestinations_sequence_of, hf_index, ett_lix2_STIRSHAKENDestinations);

  return offset;
}


static const value_string lix2_Attestation_vals[] = {
  {   1, "attestationA" },
  {   2, "attestationB" },
  {   3, "attestationC" },
  { 0, NULL }
};


static int
dissect_lix2_Attestation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t PASSporTPayload_sequence[] = {
  { &hf_lix2_issuedAtTime   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_GeneralizedTime },
  { &hf_lix2_originator     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_STIRSHAKENOriginator },
  { &hf_lix2_destination    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_STIRSHAKENDestinations },
  { &hf_lix2_attestation    , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_Attestation },
  { &hf_lix2_origId         , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_diversion      , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_STIRSHAKENDestination },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PASSporTPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PASSporTPayload_sequence, hf_index, ett_lix2_PASSporTPayload);

  return offset;
}


static const ber_sequence_t PASSporT_sequence[] = {
  { &hf_lix2_pASSporTHeader , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PASSporTHeader },
  { &hf_lix2_pASSporTPayload, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PASSporTPayload },
  { &hf_lix2_pASSporTSignature, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PASSporT(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PASSporT_sequence, hf_index, ett_lix2_PASSporT);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_PASSporT_sequence_of[1] = {
  { &hf_lix2_pASSporTs_item , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_PASSporT },
};

static int
dissect_lix2_SEQUENCE_OF_PASSporT(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_PASSporT_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_PASSporT);

  return offset;
}


static const ber_sequence_t SIPMessage_sequence[] = {
  { &hf_lix2_iPSourceAddress, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_iPDestinationAddress, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_sIPContent     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SIPMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SIPMessage_sequence, hf_index, ett_lix2_SIPMessage);

  return offset;
}


static const ber_sequence_t STIRSHAKENSignatureGeneration_sequence[] = {
  { &hf_lix2_pASSporTs      , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PASSporT },
  { &hf_lix2_encapsulatedSIPMessage, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SIPMessage },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_STIRSHAKENSignatureGeneration(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   STIRSHAKENSignatureGeneration_sequence, hf_index, ett_lix2_STIRSHAKENSignatureGeneration);

  return offset;
}


static const ber_sequence_t RCDDisplayInfo_sequence[] = {
  { &hf_lix2_name           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_jcd            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_jcl            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCDDisplayInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RCDDisplayInfo_sequence, hf_index, ett_lix2_RCDDisplayInfo);

  return offset;
}


static const ber_sequence_t ECNAMDisplayInfo_sequence[] = {
  { &hf_lix2_name           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_additionalInfo , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ECNAMDisplayInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ECNAMDisplayInfo_sequence, hf_index, ett_lix2_ECNAMDisplayInfo);

  return offset;
}


static const value_string lix2_SHAKENValidationResult_vals[] = {
  {   1, "tNValidationPassed" },
  {   2, "tNValidationFailed" },
  {   3, "noTNValidation" },
  { 0, NULL }
};


static int
dissect_lix2_SHAKENValidationResult(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_SHAKENFailureStatusCode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                                NULL);

  return offset;
}


static const ber_sequence_t STIRSHAKENSignatureValidation_sequence[] = {
  { &hf_lix2_pASSporTs      , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PASSporT },
  { &hf_lix2_rCDTerminalDisplayInfo, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RCDDisplayInfo },
  { &hf_lix2_eCNAMTerminalDisplayInfo, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ECNAMDisplayInfo },
  { &hf_lix2_sHAKENValidationResult, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SHAKENValidationResult },
  { &hf_lix2_sHAKENFailureStatusCode, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SHAKENFailureStatusCode },
  { &hf_lix2_encapsulatedSIPMessage, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SIPMessage },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_STIRSHAKENSignatureValidation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   STIRSHAKENSignatureValidation_sequence, hf_index, ett_lix2_STIRSHAKENSignatureValidation);

  return offset;
}


static const value_string lix2_PredefinedPayloadModification_vals[] = {
  {   1, "pANILocationRemoval" },
  {   2, "cNILocationRemoval" },
  {   3, "sIPGeolocationInfoRemoval" },
  {   4, "presenceInformationLocationRemoval" },
  {   5, "tS33128SMSTPDURedaction" },
  {   6, "tS33128TruncatedSMSTPDU" },
  {   7, "iMSTextContentRemoval" },
  {   8, "iMSSubjectContentRemoval" },
  {   9, "rCSPresenceLocationRemoval" },
  {  10, "rCSCPIMLocationRemoval" },
  {  11, "rCSTextContentRemoval" },
  {  12, "rCSSubjectContentRemoval" },
  {  13, "rCSGeolocationPUSHContentRemoval" },
  {  14, "rCSFileURLContentRemoval" },
  {  15, "threeGPP2SMSUserDataRedaction" },
  { 0, NULL }
};


static int
dissect_lix2_PredefinedPayloadModification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_NULL(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_null(implicit_tag, actx, tree, tvb, offset, hf_index);

  return offset;
}


static const value_string lix2_MIMEPartIdentifier_vals[] = {
  {   1, "index" },
  { 0, NULL }
};

static const ber_choice_t MIMEPartIdentifier_choice[] = {
  {   1, &hf_lix2_index          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MIMEPartIdentifier(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 MIMEPartIdentifier_choice, hf_index, ett_lix2_MIMEPartIdentifier,
                                 NULL);

  return offset;
}


static const value_string lix2_MIMEBody_vals[] = {
  {   1, "fullBody" },
  {   2, "bodyPart" },
  { 0, NULL }
};

static const ber_choice_t MIMEBody_choice[] = {
  {   1, &hf_lix2_fullBody       , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_NULL },
  {   2, &hf_lix2_bodyPart       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MIMEPartIdentifier },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MIMEBody(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 MIMEBody_choice, hf_index, ett_lix2_MIMEBody,
                                 NULL);

  return offset;
}


static const ber_sequence_t IndexRange_sequence[] = {
  { &hf_lix2_start          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_end            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IndexRange(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   IndexRange_sequence, hf_index, ett_lix2_IndexRange);

  return offset;
}



static int
dissect_lix2_ABNFRuleLocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const value_string lix2_ModificationLocation_vals[] = {
  {   1, "jSONPointer" },
  {   2, "xPath" },
  {   3, "sIPHeader" },
  {   4, "sIPBody" },
  {   5, "mIMEHeader" },
  {   6, "mIMEBody" },
  {   7, "uTF8Location" },
  {   8, "octetLocation" },
  {   9, "aBNFRule" },
  { 0, NULL }
};

static const ber_choice_t ModificationLocation_choice[] = {
  {   1, &hf_lix2_jSONPointer    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  {   2, &hf_lix2_xPath          , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  {   3, &hf_lix2_sIPHeader      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  {   4, &hf_lix2_sIPBody        , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_NULL },
  {   5, &hf_lix2_mIMEHeader     , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  {   6, &hf_lix2_mIMEBody       , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_MIMEBody },
  {   7, &hf_lix2_uTF8Location   , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_IndexRange },
  {   8, &hf_lix2_octetLocation  , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_IndexRange },
  {   9, &hf_lix2_aBNFRule       , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_ABNFRuleLocation },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ModificationLocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 ModificationLocation_choice, hf_index, ett_lix2_ModificationLocation,
                                 NULL);

  return offset;
}


static const value_string lix2_PayloadInformationRemoved_vals[] = {
  {   1, "charactersRemoved" },
  {   2, "octetsRemoved" },
  {   3, "bitsRemoved" },
  { 0, NULL }
};

static const ber_choice_t PayloadInformationRemoved_choice[] = {
  {   1, &hf_lix2_charactersRemoved, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  {   2, &hf_lix2_octetsRemoved  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  {   3, &hf_lix2_bitsRemoved    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PayloadInformationRemoved(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 PayloadInformationRemoved_choice, hf_index, ett_lix2_PayloadInformationRemoved,
                                 NULL);

  return offset;
}


static const ber_sequence_t PayloadInformationReplacedWithCharacters_sequence[] = {
  { &hf_lix2_characters     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PayloadInformationReplacedWithCharacters(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PayloadInformationReplacedWithCharacters_sequence, hf_index, ett_lix2_PayloadInformationReplacedWithCharacters);

  return offset;
}



static int
dissect_lix2_BIT_STRING(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}


static const value_string lix2_ModificationType_vals[] = {
  {   1, "removed" },
  {   2, "replacedWithCharacters" },
  {   3, "replacedWithOctets" },
  {   4, "replacedWithBits" },
  { 0, NULL }
};

static const ber_choice_t ModificationType_choice[] = {
  {   1, &hf_lix2_removed        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PayloadInformationRemoved },
  {   2, &hf_lix2_replacedWithCharacters, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PayloadInformationReplacedWithCharacters },
  {   3, &hf_lix2_replacedWithOctets, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  {   4, &hf_lix2_replacedWithBits, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ModificationType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 ModificationType_choice, hf_index, ett_lix2_ModificationType,
                                 NULL);

  return offset;
}


static const ber_sequence_t PayloadModificationDescription_sequence[] = {
  { &hf_lix2_modificationLocation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_ModificationLocation },
  { &hf_lix2_modificationType, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_ModificationType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PayloadModificationDescription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PayloadModificationDescription_sequence, hf_index, ett_lix2_PayloadModificationDescription);

  return offset;
}


static const value_string lix2_PayloadModification_vals[] = {
  {   1, "predefinedModification" },
  {   2, "describedModification" },
  { 0, NULL }
};

static const ber_choice_t PayloadModification_choice[] = {
  {   1, &hf_lix2_predefinedModification, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PredefinedPayloadModification },
  {   2, &hf_lix2_describedModification, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PayloadModificationDescription },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PayloadModification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 PayloadModification_choice, hf_index, ett_lix2_PayloadModification,
                                 NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_PayloadModification_sequence_of[1] = {
  { &hf_lix2_modificationList_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PayloadModification },
};

static int
dissect_lix2_SEQUENCE_OF_PayloadModification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_PayloadModification_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_PayloadModification);

  return offset;
}


static const ber_sequence_t PayloadModifications_sequence[] = {
  { &hf_lix2_modificationList, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_PayloadModification },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PayloadModifications(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PayloadModifications_sequence, hf_index, ett_lix2_PayloadModifications);

  return offset;
}


static const ber_sequence_t ModifiedSIPMessage_sequence[] = {
  { &hf_lix2_modifiedSIPContent, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SIPMessage },
  { &hf_lix2_modifications  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PayloadModifications },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ModifiedSIPMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ModifiedSIPMessage_sequence, hf_index, ett_lix2_ModifiedSIPMessage);

  return offset;
}


static const value_string lix2_IMSPayload_vals[] = {
  {   1, "encapsulatedSIPMessage" },
  {   2, "modifiedSIPMessage" },
  { 0, NULL }
};

static const ber_choice_t IMSPayload_choice[] = {
  {   1, &hf_lix2_encapsulatedSIPMessage, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SIPMessage },
  {   2, &hf_lix2_modifiedSIPMessage, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_ModifiedSIPMessage },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IMSPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 IMSPayload_choice, hf_index, ett_lix2_IMSPayload,
                                 NULL);

  return offset;
}


static const value_string lix2_SessionDirection_vals[] = {
  {   1, "fromTarget" },
  {   2, "toTarget" },
  {   3, "combined" },
  {   4, "indeterminate" },
  { 0, NULL }
};


static int
dissect_lix2_SessionDirection(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_VoIPRoamingIndication_vals[] = {
  {   1, "roamingLBO" },
  {   2, "roamingS8HR" },
  {   3, "roamingN9HR" },
  { 0, NULL }
};


static int
dissect_lix2_VoIPRoamingIndication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_SIPAccessNetworkInformation_sequence_of[1] = {
  { &hf_lix2_accessNetworkInformation_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_SIPAccessNetworkInformation },
};

static int
dissect_lix2_SEQUENCE_OF_SIPAccessNetworkInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_SIPAccessNetworkInformation_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_SIPAccessNetworkInformation);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_SIPCellularNetworkInformation_sequence_of[1] = {
  { &hf_lix2_cellularNetworkInformation_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_SIPCellularNetworkInformation },
};

static int
dissect_lix2_SEQUENCE_OF_SIPCellularNetworkInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_SIPCellularNetworkInformation_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_SIPCellularNetworkInformation);

  return offset;
}


static const ber_sequence_t IMSMessage_sequence[] = {
  { &hf_lix2_payload_01     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMSPayload },
  { &hf_lix2_sessionDirection, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SessionDirection },
  { &hf_lix2_voIPRoamingIndication, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_VoIPRoamingIndication },
  { &hf_lix2_location       , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_accessNetworkInformation, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_SIPAccessNetworkInformation },
  { &hf_lix2_cellularNetworkInformation, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_SIPCellularNetworkInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IMSMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   IMSMessage_sequence, hf_index, ett_lix2_IMSMessage);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_IMPU_sequence_of[1] = {
  { &hf_lix2_originatingId_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMPU },
};

static int
dissect_lix2_SEQUENCE_OF_IMPU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_IMPU_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_IMPU);

  return offset;
}


static const ber_sequence_t T_sDPState_sequence_of[1] = {
  { &hf_lix2_sDPState_item  , BER_CLASS_UNI, BER_UNI_TAG_OCTETSTRING, BER_FLAGS_NOOWNTAG, dissect_lix2_OCTET_STRING },
};

static int
dissect_lix2_T_sDPState(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      T_sDPState_sequence_of, hf_index, ett_lix2_T_sDPState);

  return offset;
}


static const ber_sequence_t StartOfInterceptionForActiveIMSSession_sequence[] = {
  { &hf_lix2_originatingId  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_IMPU },
  { &hf_lix2_terminatingId  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMPU },
  { &hf_lix2_sDPState       , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_T_sDPState },
  { &hf_lix2_diversionIdentity, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMPU },
  { &hf_lix2_voIPRoamingIndication, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_VoIPRoamingIndication },
  { &hf_lix2_location       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_accessNetworkInformation, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_SIPAccessNetworkInformation },
  { &hf_lix2_cellularNetworkInformation, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_SIPCellularNetworkInformation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_StartOfInterceptionForActiveIMSSession(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   StartOfInterceptionForActiveIMSSession_sequence, hf_index, ett_lix2_StartOfInterceptionForActiveIMSSession);

  return offset;
}


static const ber_sequence_t IMSCCUnavailable_sequence[] = {
  { &hf_lix2_cCUnavailableReason, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_sDPState_01    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IMSCCUnavailable(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   IMSCCUnavailable_sequence, hf_index, ett_lix2_IMSCCUnavailable);

  return offset;
}


static const ber_sequence_t UDMLocationInfoRequest_sequence[] = {
  { &hf_lix2_requested5GSLocation, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_requestedCurrentLocation, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_requestedRATType, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_requestedTimeZone, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_requestedServingNode, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMLocationInfoRequest(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMLocationInfoRequest_sequence, hf_index, ett_lix2_UDMLocationInfoRequest);

  return offset;
}


static const value_string lix2_UDMDefinedCause_vals[] = {
  {   1, "userNotFound" },
  {   2, "dataNotFound" },
  {   3, "contextNotFound" },
  {   4, "subscriptionNotFound" },
  {   5, "other" },
  { 0, NULL }
};


static int
dissect_lix2_UDMDefinedCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t UDMInvalidParameters_sequence[] = {
  { &hf_lix2_parameter      , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_reason         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMInvalidParameters(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMInvalidParameters_sequence, hf_index, ett_lix2_UDMInvalidParameters);

  return offset;
}


static const ber_sequence_t UDMProblemDetailsOtherCause_sequence[] = {
  { &hf_lix2_problemDetailsType, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_title          , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_status         , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_detail         , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_instance       , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_cause_07       , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_uDMInvalidParameters, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_UDMInvalidParameters },
  { &hf_lix2_uDMSupportedFeatures, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMProblemDetailsOtherCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMProblemDetailsOtherCause_sequence, hf_index, ett_lix2_UDMProblemDetailsOtherCause);

  return offset;
}


static const value_string lix2_UDMProblemDetailsCause_vals[] = {
  {   1, "uDMDefinedCause" },
  {   2, "otherCause" },
  { 0, NULL }
};

static const ber_choice_t UDMProblemDetailsCause_choice[] = {
  {   1, &hf_lix2_uDMDefinedCause, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UDMDefinedCause },
  {   2, &hf_lix2_otherCause     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UDMProblemDetailsOtherCause },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMProblemDetailsCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 UDMProblemDetailsCause_choice, hf_index, ett_lix2_UDMProblemDetailsCause,
                                 NULL);

  return offset;
}


static const ber_sequence_t UDMProblemDetails_sequence[] = {
  { &hf_lix2_cause_06       , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UDMProblemDetailsCause },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMProblemDetails(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMProblemDetails_sequence, hf_index, ett_lix2_UDMProblemDetails);

  return offset;
}


static const ber_sequence_t UDMLocationInformationResult_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_locationInfoRequest, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_UDMLocationInfoRequest },
  { &hf_lix2_vPLMNID        , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_currentLocationIndicator, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_aMFInstanceID  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NFID },
  { &hf_lix2_sMSFInstanceID , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NFID },
  { &hf_lix2_location       , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_rATType        , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { &hf_lix2_problemDetails , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UDMProblemDetails },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMLocationInformationResult(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMLocationInformationResult_sequence, hf_index, ett_lix2_UDMLocationInformationResult);

  return offset;
}


static const ber_sequence_t UEContextInfo_sequence[] = {
  { &hf_lix2_supportVoPS    , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_supportVoPSNon3GPP, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_lastActiveTime , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_accessType     , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { &hf_lix2_rATType        , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RATType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UEContextInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UEContextInfo_sequence, hf_index, ett_lix2_UEContextInfo);

  return offset;
}


static const value_string lix2_FiveGSUserState_vals[] = {
  {   1, "deregistered" },
  {   2, "registeredNotReachableForPaging" },
  {   3, "registeredReachableForPaging" },
  {   4, "connectedNotReachableForPaging" },
  {   5, "connectedReachableForPaging" },
  {   6, "notProvidedFromAMF" },
  { 0, NULL }
};


static int
dissect_lix2_FiveGSUserState(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t FiveGSUserStateInfo_sequence[] = {
  { &hf_lix2_fiveGSUserState, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSUserState },
  { &hf_lix2_accessType     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AccessType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGSUserStateInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGSUserStateInfo_sequence, hf_index, ett_lix2_FiveGSUserStateInfo);

  return offset;
}


static const ber_sequence_t FiveGSRVCCInfo_sequence[] = {
  { &hf_lix2_uE5GSRVCCCapability, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_sessionTransferNumber, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_correlationMSISDN, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGSRVCCInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGSRVCCInfo_sequence, hf_index, ett_lix2_FiveGSRVCCInfo);

  return offset;
}


static const ber_sequence_t UDMUEInformationResponse_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_tADSInfo       , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UEContextInfo },
  { &hf_lix2_fiveGSUserStateInfo, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSUserStateInfo },
  { &hf_lix2_fiveGSRVCCInfo , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSRVCCInfo },
  { &hf_lix2_problemDetails , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UDMProblemDetails },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMUEInformationResponse(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMUEInformationResponse_sequence, hf_index, ett_lix2_UDMUEInformationResponse);

  return offset;
}


static const value_string lix2_UDMInfoRequestType_vals[] = {
  {   1, "hSS" },
  {   2, "aUSF" },
  {   3, "other" },
  { 0, NULL }
};


static int
dissect_lix2_UDMInfoRequestType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_SubscriberIdentifier_vals[] = {
  {   1, "sUCI" },
  {   2, "sUPI" },
  { 0, NULL }
};

static const ber_choice_t SubscriberIdentifier_choice[] = {
  {   1, &hf_lix2_sUCI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  {   2, &hf_lix2_sUPI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SUPI },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SubscriberIdentifier(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 SubscriberIdentifier_choice, hf_index, ett_lix2_SubscriberIdentifier,
                                 NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_SubscriberIdentifier_sequence_of[1] = {
  { &hf_lix2_rGAuthCtx_item , BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SubscriberIdentifier },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_SubscriberIdentifier(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_SubscriberIdentifier_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_SubscriberIdentifier);

  return offset;
}


static const value_string lix2_PrimaryAuthenticationType_vals[] = {
  {   1, "eAPAKAPrime" },
  {   2, "fiveGAKA" },
  {   3, "eAPTLS" },
  {   4, "none" },
  {   5, "ePSAKA" },
  {   6, "eAPAKA" },
  {   7, "iMSAKA" },
  {   8, "gBAAKA" },
  {   9, "uMTSAKA" },
  { 0, NULL }
};


static int
dissect_lix2_PrimaryAuthenticationType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t UDMAuthenticationInfoRequest_sequence[] = {
  { &hf_lix2_infoRequestType, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UDMInfoRequestType },
  { &hf_lix2_rGAuthCtx      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_SubscriberIdentifier },
  { &hf_lix2_authType       , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PrimaryAuthenticationType },
  { &hf_lix2_servingNetworkName_01, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_aUSFInstanceID , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NFID },
  { &hf_lix2_cellCAGInfo    , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CAGID },
  { &hf_lix2_n5GCIndicator  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMAuthenticationInfoRequest(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMAuthenticationInfoRequest_sequence, hf_index, ett_lix2_UDMAuthenticationInfoRequest);

  return offset;
}


static const ber_sequence_t FQDNList_sequence_of[1] = {
  { &hf_lix2_FQDNList_item  , BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_FQDN },
};

static int
dissect_lix2_FQDNList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      FQDNList_sequence_of, hf_index, ett_lix2_FQDNList);

  return offset;
}


static const ber_sequence_t ServerAddressingInfo_sequence[] = {
  { &hf_lix2_iPv4Address    , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv4Address },
  { &hf_lix2_iPv6Address    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv6Address },
  { &hf_lix2_fQDNList       , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FQDNList },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ServerAddressingInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ServerAddressingInfo_sequence, hf_index, ett_lix2_ServerAddressingInfo);

  return offset;
}


static const ber_sequence_t ServerAddressingInfoList_sequence_of[1] = {
  { &hf_lix2_ServerAddressingInfoList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_ServerAddressingInfo },
};

static int
dissect_lix2_ServerAddressingInfoList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      ServerAddressingInfoList_sequence_of, hf_index, ett_lix2_ServerAddressingInfoList);

  return offset;
}


static const ber_sequence_t UDMUEAuthenticationResponse_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_authenticationInfoRequest, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UDMAuthenticationInfoRequest },
  { &hf_lix2_aKMAIndicator  , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_problemDetails , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UDMProblemDetails },
  { &hf_lix2_authAAA        , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_pvsInfo        , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ServerAddressingInfoList },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMUEAuthenticationResponse(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMUEAuthenticationResponse_sequence, hf_index, ett_lix2_UDMUEAuthenticationResponse);

  return offset;
}



static int
dissect_lix2_UTF8String_SIZE_1_255(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t AMFPositioningInfoTransfer_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUCI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUTI           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGGUTI },
  { &hf_lix2_nRPPaMessage   , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_lPPMessage     , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_lcsCorrelationId, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String_SIZE_1_255 },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFPositioningInfoTransfer(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFPositioningInfoTransfer_sequence, hf_index, ett_lix2_AMFPositioningInfoTransfer);

  return offset;
}


static const ber_sequence_t MMEPositioningInfoTransfer_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_iMEI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_gUTI_01        , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  { &hf_lix2_lPPaMessage    , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_lPPMessage     , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_mMELCSCorrelationId, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_4 },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMEPositioningInfoTransfer(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMEPositioningInfoTransfer_sequence, hf_index, ett_lix2_MMEPositioningInfoTransfer);

  return offset;
}


static const value_string lix2_FiveGSSubscriberID_vals[] = {
  {   1, "sUPI" },
  {   2, "sUCI" },
  {   3, "pEI" },
  {   4, "gPSI" },
  { 0, NULL }
};

static const ber_choice_t FiveGSSubscriberID_choice[] = {
  {   1, &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SUPI },
  {   2, &hf_lix2_sUCI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  {   3, &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PEI },
  {   4, &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_GPSI },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGSSubscriberID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 FiveGSSubscriberID_choice, hf_index, ett_lix2_FiveGSSubscriberID,
                                 NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_FiveGSSubscriberID_sequence_of[1] = {
  { &hf_lix2_fiveGSSubscriberID_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_FiveGSSubscriberID },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_FiveGSSubscriberID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_FiveGSSubscriberID_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_FiveGSSubscriberID);

  return offset;
}


static const ber_sequence_t FiveGSSubscriberIDs_sequence[] = {
  { &hf_lix2_fiveGSSubscriberID, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_FiveGSSubscriberID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGSSubscriberIDs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGSSubscriberIDs_sequence, hf_index, ett_lix2_FiveGSSubscriberIDs);

  return offset;
}


static const ber_sequence_t UserIdentifiers_sequence[] = {
  { &hf_lix2_fiveGSSubscriberIDs, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSSubscriberIDs },
  { &hf_lix2_ePSSubscriberIDs, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSSubscriberIDs },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UserIdentifiers(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UserIdentifiers_sequence, hf_index, ett_lix2_UserIdentifiers);

  return offset;
}


static const value_string lix2_HandoverType_vals[] = {
  {   1, "intra5GS" },
  {   2, "fiveGStoEPS" },
  {   3, "ePSto5GS" },
  {   4, "fiveGStoUTRA" },
  { 0, NULL }
};


static int
dissect_lix2_HandoverType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_RANTargetToSourceContainer(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t AMFRANHandoverCommand_sequence[] = {
  { &hf_lix2_userIdentifiers, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UserIdentifiers },
  { &hf_lix2_aMFUENGAPID    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUENGAPID },
  { &hf_lix2_rANUENGAPID    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RANUENGAPID },
  { &hf_lix2_handoverType   , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_HandoverType },
  { &hf_lix2_targetToSourceContainer, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_RANTargetToSourceContainer },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFRANHandoverCommand(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFRANHandoverCommand_sequence, hf_index, ett_lix2_AMFRANHandoverCommand);

  return offset;
}


static const value_string lix2_CauseRadioNetwork_vals[] = {
  {   1, "unspecified" },
  {   2, "txnrelocoverallExpiry" },
  {   3, "successfulHandover" },
  {   4, "releaseDueToNGRANGeneratedReason" },
  {   5, "releaseDueTo5gcGeneratedReason" },
  {   6, "handoverCancelled" },
  {   7, "partialHandover" },
  {   8, "hoFailureInTarget5GCNGRANNodeOrTargetSystem" },
  {   9, "hoTargetNotAllowed" },
  {  10, "tNGRelocOverallExpiry" },
  {  11, "tNGRelocPrepExpiry" },
  {  12, "cellNotAvailable" },
  {  13, "unknownTargetID" },
  {  14, "noRadioResourcesAvailableInTargetCell" },
  {  15, "unknownLocalUENGAPID" },
  {  16, "inconsistentRemoteUENGAPID" },
  {  17, "handoverDesirableForRadioReason" },
  {  18, "timeCriticalHandover" },
  {  19, "resourceOptimisationHandover" },
  {  20, "reduceLoadInServingCell" },
  {  21, "userInactivity" },
  {  22, "radioConnectionWithUELost" },
  {  23, "radioResourcesNotAvailable" },
  {  24, "invalidQoSCombination" },
  {  25, "failureInRadioInterfaceProcedure" },
  {  26, "interactionWithOtherProcedure" },
  {  27, "unknownPDUSessionID" },
  {  29, "multiplePDUSessionIDInstances" },
  {  30, "multipleQoSFlowIDInstances" },
  {  31, "encryptionAndOrIntegrityProtectionAlgorithmsNotSupported" },
  {  32, "nGIntraSystemHandoverTriggered" },
  {  33, "nGInterSystemHandoverTriggered" },
  {  34, "xNHandoverTriggered" },
  {  35, "notSupported5QIValue" },
  {  36, "uEContextTransfer" },
  {  37, "iMSVoiceeEPSFallbackOrRATFallbackTriggered" },
  {  38, "uPIntegrityProtectioNotPossible" },
  {  39, "uPConfidentialityProtectionNotPossible" },
  {  40, "sliceNotSupported" },
  {  41, "uEInRRCInactiveStateNotReachable" },
  {  42, "redirection" },
  {  43, "resourcesNotAvailableForTheSlice" },
  {  44, "uEMaxIntegrityProtectedDataRateReason" },
  {  45, "releaseDueToCNDetectedMobility" },
  {  46, "n26InterfaceNotAvailable" },
  {  47, "releaseDueToPreemption" },
  {  48, "multipleLocationReportingReferenceIDInstances" },
  {  49, "rSNNotAvailableForTheUP" },
  {  50, "nPMAccessDenied" },
  {  51, "cAGOnlyAccessDenied" },
  {  52, "insufficientUECapabilities" },
  { 0, NULL }
};


static int
dissect_lix2_CauseRadioNetwork(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_CauseTransport_vals[] = {
  {   1, "transportResourceUnavailable" },
  {   2, "unspecified" },
  { 0, NULL }
};


static int
dissect_lix2_CauseTransport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_CauseNas_vals[] = {
  {   1, "normalRelease" },
  {   2, "authenticationFailure" },
  {   3, "deregister" },
  {   4, "unspecified" },
  { 0, NULL }
};


static int
dissect_lix2_CauseNas(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_CauseProtocol_vals[] = {
  {   1, "transferSyntaxError" },
  {   2, "abstractSyntaxError-reject" },
  {   3, "abstractSyntaxErrorIgnoreAndNotify" },
  {   4, "messageNotCompatibleWithReceiverState" },
  {   5, "semanticError" },
  {   6, "abstractSyntaxErrorFalselyConstructedMessage" },
  {   7, "unspecified" },
  { 0, NULL }
};


static int
dissect_lix2_CauseProtocol(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_CauseMisc_vals[] = {
  {   1, "controlProcessingOverload" },
  {   2, "notEnoughUserPlaneProcessingResources" },
  {   3, "hardwareFailure" },
  {   4, "oMIntervention" },
  {   5, "unknownPLMNOrSNPN" },
  {   6, "unspecified" },
  { 0, NULL }
};


static int
dissect_lix2_CauseMisc(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_HandoverCause_vals[] = {
  {   1, "radioNetwork" },
  {   2, "transport" },
  {   3, "nas" },
  {   4, "protocol" },
  {   5, "misc" },
  { 0, NULL }
};

static const ber_choice_t HandoverCause_choice[] = {
  {   1, &hf_lix2_radioNetwork   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_CauseRadioNetwork },
  {   2, &hf_lix2_transport      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_CauseTransport },
  {   3, &hf_lix2_nas            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_CauseNas },
  {   4, &hf_lix2_protocol_01    , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_CauseProtocol },
  {   5, &hf_lix2_misc           , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_CauseMisc },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_HandoverCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 HandoverCause_choice, hf_index, ett_lix2_HandoverCause,
                                 NULL);

  return offset;
}


static const ber_sequence_t PDUSessionResourceInformation_sequence[] = {
  { &hf_lix2_pDUSessionID   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionID },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_PDUSessionResourceInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   PDUSessionResourceInformation_sequence, hf_index, ett_lix2_PDUSessionResourceInformation);

  return offset;
}


static const value_string lix2_LocationEventType_vals[] = {
  {   1, "direct" },
  {   2, "changeOfServeCell" },
  {   3, "uEPrescenceInAreaOfInterest" },
  {   4, "stopChangeOfServeCell" },
  {   5, "stopUEPresenceInAreaOfInterest" },
  {   6, "cancelLocationReportingForTheUE" },
  { 0, NULL }
};


static int
dissect_lix2_LocationEventType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_LocationReportArea_vals[] = {
  {   1, "cell" },
  { 0, NULL }
};


static int
dissect_lix2_LocationReportArea(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t AreaOfInterestTAIList_sequence_of[1] = {
  { &hf_lix2_AreaOfInterestTAIList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_TAI },
};

static int
dissect_lix2_AreaOfInterestTAIList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      AreaOfInterestTAIList_sequence_of, hf_index, ett_lix2_AreaOfInterestTAIList);

  return offset;
}


static const ber_sequence_t AreaOfInterestCellList_sequence_of[1] = {
  { &hf_lix2_AreaOfInterestCellList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_NCGI },
};

static int
dissect_lix2_AreaOfInterestCellList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      AreaOfInterestCellList_sequence_of, hf_index, ett_lix2_AreaOfInterestCellList);

  return offset;
}


static const ber_sequence_t AreaOfInterestRANNodeList_sequence_of[1] = {
  { &hf_lix2_AreaOfInterestRANNodeList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_GlobalRANNodeID },
};

static int
dissect_lix2_AreaOfInterestRANNodeList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      AreaOfInterestRANNodeList_sequence_of, hf_index, ett_lix2_AreaOfInterestRANNodeList);

  return offset;
}


static const ber_sequence_t AreaOfInterest_sequence[] = {
  { &hf_lix2_areaOfInterestTAIList, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AreaOfInterestTAIList },
  { &hf_lix2_areaOfInterestCellList, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AreaOfInterestCellList },
  { &hf_lix2_areaOfInterestRANNodeList, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AreaOfInterestRANNodeList },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AreaOfInterest(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AreaOfInterest_sequence, hf_index, ett_lix2_AreaOfInterest);

  return offset;
}


static const ber_sequence_t AreaOfInterestItem_sequence[] = {
  { &hf_lix2_areaOfInterest , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AreaOfInterest },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AreaOfInterestItem(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AreaOfInterestItem_sequence, hf_index, ett_lix2_AreaOfInterestItem);

  return offset;
}


static const ber_sequence_t LocationAreaOfInterestList_sequence_of[1] = {
  { &hf_lix2_LocationAreaOfInterestList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_AreaOfInterestItem },
};

static int
dissect_lix2_LocationAreaOfInterestList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      LocationAreaOfInterestList_sequence_of, hf_index, ett_lix2_LocationAreaOfInterestList);

  return offset;
}


static const ber_sequence_t LocationReportingRequestType_sequence[] = {
  { &hf_lix2_eventType_01   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_LocationEventType },
  { &hf_lix2_reportArea     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_LocationReportArea },
  { &hf_lix2_areaOfInterestList, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_LocationAreaOfInterestList },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LocationReportingRequestType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LocationReportingRequestType_sequence, hf_index, ett_lix2_LocationReportingRequestType);

  return offset;
}


static const value_string lix2_NPNAccessInformation_vals[] = {
  {   1, "pNINPNAccessInformation" },
  { 0, NULL }
};

static const ber_choice_t NPNAccessInformation_choice[] = {
  {   1, &hf_lix2_pNINPNAccessInformation, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_CellCAGList },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NPNAccessInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 NPNAccessInformation_choice, hf_index, ett_lix2_NPNAccessInformation,
                                 NULL);

  return offset;
}



static int
dissect_lix2_RANSourceToTargetContainer(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t AMFRANHandoverRequest_sequence[] = {
  { &hf_lix2_userIdentifiers, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UserIdentifiers },
  { &hf_lix2_aMFUENGAPID    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUENGAPID },
  { &hf_lix2_rANUENGAPID    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RANUENGAPID },
  { &hf_lix2_handoverType   , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_HandoverType },
  { &hf_lix2_handoverCause  , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_HandoverCause },
  { &hf_lix2_pDUSessionResourceInformation, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_PDUSessionResourceInformation },
  { &hf_lix2_mobilityRestrictionList, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MobilityRestrictionList },
  { &hf_lix2_locationReportingRequestType, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_LocationReportingRequestType },
  { &hf_lix2_targetToSourceContainer, BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_RANTargetToSourceContainer },
  { &hf_lix2_nPNAccessInformation, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_NPNAccessInformation },
  { &hf_lix2_sourceToTargetContainer, BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_RANSourceToTargetContainer },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFRANHandoverRequest(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFRANHandoverRequest_sequence, hf_index, ett_lix2_AMFRANHandoverRequest);

  return offset;
}


static const value_string lix2_RegistrationType_vals[] = {
  {   1, "registration" },
  {   2, "registrationUpdate" },
  {   3, "deregistration" },
  { 0, NULL }
};


static int
dissect_lix2_RegistrationType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_ACID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_EASID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t ServiceKPIs_sequence[] = {
  { &hf_lix2_connectionBandwidth, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_requestRate    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_responseTime   , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_requestedAvailability, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_requestedCompute, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_requestedGraphCompute, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_requestedMemory, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { &hf_lix2_requestedStorage, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ServiceKPIs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ServiceKPIs_sequence, hf_index, ett_lix2_ServiceKPIs);

  return offset;
}


static const ber_sequence_t EASInfo_sequence[] = {
  { &hf_lix2_eASID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EASID },
  { &hf_lix2_expectedSvcKPIs, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ServiceKPIs },
  { &hf_lix2_minimumReqSvcKPIs, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ServiceKPIs },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EASInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EASInfo_sequence, hf_index, ett_lix2_EASInfo);

  return offset;
}


static const ber_sequence_t EASsInfo_set_of[1] = {
  { &hf_lix2_EASsInfo_item  , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_EASInfo },
};

static int
dissect_lix2_EASsInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 EASsInfo_set_of, hf_index, ett_lix2_EASsInfo);

  return offset;
}


static const value_string lix2_ACRScenario_vals[] = {
  {   1, "eECInitiated" },
  {   2, "eECExecutedViaSourceEES" },
  {   3, "eECExecutedViaTargetEES" },
  {   4, "sourceEASDecided" },
  {   5, "sourceEESExecuted" },
  {   6, "eELManagedACR" },
  { 0, NULL }
};


static int
dissect_lix2_ACRScenario(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t ACRScenarios_set_of[1] = {
  { &hf_lix2_ACRScenarios_item, BER_CLASS_UNI, BER_UNI_TAG_ENUMERATED, BER_FLAGS_NOOWNTAG, dissect_lix2_ACRScenario },
};

static int
dissect_lix2_ACRScenarios(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 ACRScenarios_set_of, hf_index, ett_lix2_ACRScenarios);

  return offset;
}


static const ber_sequence_t ACProfile_sequence[] = {
  { &hf_lix2_aCID           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_ACID },
  { &hf_lix2_aCType         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_aCSchedule     , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Daytime },
  { &hf_lix2_expACGeoServArea, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_eASsInfo       , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASsInfo },
  { &hf_lix2_aCServiceContSupport, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACRScenarios },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ACProfile(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ACProfile_sequence, hf_index, ett_lix2_ACProfile);

  return offset;
}


static const ber_sequence_t ACProfiles_set_of[1] = {
  { &hf_lix2_ACProfiles_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_ACProfile },
};

static int
dissect_lix2_ACProfiles(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 ACProfiles_set_of, hf_index, ett_lix2_ACProfiles);

  return offset;
}


static const value_string lix2_UnfulfilledACProfileReason_vals[] = {
  {   1, "eASNotAvailable" },
  {   2, "requirementsUnfulfilled" },
  { 0, NULL }
};


static int
dissect_lix2_UnfulfilledACProfileReason(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t UnfulfilledACProfile_sequence[] = {
  { &hf_lix2_aCID           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_ACID },
  { &hf_lix2_reason_01      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UnfulfilledACProfileReason },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UnfulfilledACProfile(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UnfulfilledACProfile_sequence, hf_index, ett_lix2_UnfulfilledACProfile);

  return offset;
}


static const ber_sequence_t UnfulfilledACProfiles_set_of[1] = {
  { &hf_lix2_UnfulfilledACProfiles_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_UnfulfilledACProfile },
};

static int
dissect_lix2_UnfulfilledACProfiles(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 UnfulfilledACProfiles_set_of, hf_index, ett_lix2_UnfulfilledACProfiles);

  return offset;
}


static const value_string lix2_FailureResponse_vals[] = {
  {   1, "error400" },
  {   2, "error401" },
  {   3, "error403" },
  {   4, "error404" },
  {   5, "error406" },
  {   6, "error411" },
  {   7, "error413" },
  {   8, "error415" },
  {   9, "error429" },
  {  10, "error500" },
  {  11, "error503" },
  { 0, NULL }
};


static int
dissect_lix2_FailureResponse(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t EESEECRegistration_sequence[] = {
  { &hf_lix2_registrationType_01, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RegistrationType },
  { &hf_lix2_eECID          , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_aCProfiles     , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACProfiles },
  { &hf_lix2_eECServiceContSupport, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACRScenarios },
  { &hf_lix2_expirationTime , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_eECContextID   , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_srcEESID       , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_unfulfilledACProfiles, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UnfulfilledACProfiles },
  { &hf_lix2_failureResponse, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FailureResponse },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESEECRegistration(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESEECRegistration_sequence, hf_index, ett_lix2_EESEECRegistration);

  return offset;
}


static const ber_sequence_t IPv4Addresses_set_of[1] = {
  { &hf_lix2_IPv4Addresses_item, BER_CLASS_UNI, BER_UNI_TAG_OCTETSTRING, BER_FLAGS_NOOWNTAG, dissect_lix2_IPv4Address },
};

static int
dissect_lix2_IPv4Addresses(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 IPv4Addresses_set_of, hf_index, ett_lix2_IPv4Addresses);

  return offset;
}


static const ber_sequence_t IPv6Addresses_set_of[1] = {
  { &hf_lix2_IPv6Addresses_item, BER_CLASS_UNI, BER_UNI_TAG_OCTETSTRING, BER_FLAGS_NOOWNTAG, dissect_lix2_IPv6Address },
};

static int
dissect_lix2_IPv6Addresses(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 IPv6Addresses_set_of, hf_index, ett_lix2_IPv6Addresses);

  return offset;
}


static const ber_sequence_t EASEndpoint_sequence[] = {
  { &hf_lix2_fQDN           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FQDN },
  { &hf_lix2_iPv4Addresses  , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv4Addresses },
  { &hf_lix2_iPv6Addresses  , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv6Addresses },
  { &hf_lix2_uRI            , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EASEndpoint(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EASEndpoint_sequence, hf_index, ett_lix2_EASEndpoint);

  return offset;
}


static const ber_sequence_t ACIDs_set_of[1] = {
  { &hf_lix2_ACIDs_item     , BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_ACID },
};

static int
dissect_lix2_ACIDs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 ACIDs_set_of, hf_index, ett_lix2_ACIDs);

  return offset;
}



static int
dissect_lix2_EASServiceFeature(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t EASServiceFeatures_set_of[1] = {
  { &hf_lix2_EASServiceFeatures_item, BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_EASServiceFeature },
};

static int
dissect_lix2_EASServiceFeatures(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 EASServiceFeatures_set_of, hf_index, ett_lix2_EASServiceFeatures);

  return offset;
}


static const ber_sequence_t RouteToLocations_set_of[1] = {
  { &hf_lix2_RouteToLocations_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_RouteToLocation },
};

static int
dissect_lix2_RouteToLocations(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 RouteToLocations_set_of, hf_index, ett_lix2_RouteToLocations);

  return offset;
}


static const value_string lix2_EASStatus_vals[] = {
  {   1, "enabled" },
  {   2, "disabled" },
  { 0, NULL }
};


static int
dissect_lix2_EASStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t EASProfile_sequence[] = {
  { &hf_lix2_eASID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EASID },
  { &hf_lix2_eASEndpoint    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EASEndpoint },
  { &hf_lix2_aCIDs          , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACIDs },
  { &hf_lix2_aSPID          , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_eASType        , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_eASDescription , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_eASSchedule    , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Daytime },
  { &hf_lix2_eASServiceArea , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_eASServiceKPIs , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ServiceKPIs },
  { &hf_lix2_eASServicePermLevel, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_eASServiceFeatures, BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASServiceFeatures },
  { &hf_lix2_eASServiceContSupport, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACRScenarios },
  { &hf_lix2_appLocs        , BER_CLASS_CON, 13, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RouteToLocations },
  { &hf_lix2_eASStatus      , BER_CLASS_CON, 14, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASStatus },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EASProfile(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EASProfile_sequence, hf_index, ett_lix2_EASProfile);

  return offset;
}


static const ber_sequence_t EASCharacteristics_sequence[] = {
  { &hf_lix2_eASID          , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASID },
  { &hf_lix2_aSPID          , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_eASType        , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_eASSchedule    , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Daytime },
  { &hf_lix2_eASProfile     , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASProfile },
  { &hf_lix2_eASServiceArea , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_eASServicePermLevel, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_eASServiceFeatures, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASServiceFeatures },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EASCharacteristics(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EASCharacteristics_sequence, hf_index, ett_lix2_EASCharacteristics);

  return offset;
}


static const ber_sequence_t EASsCharacteristics_set_of[1] = {
  { &hf_lix2_EASsCharacteristics_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_EASCharacteristics },
};

static int
dissect_lix2_EASsCharacteristics(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 EASsCharacteristics_set_of, hf_index, ett_lix2_EASsCharacteristics);

  return offset;
}


static const value_string lix2_EASDiscoveryFilter_vals[] = {
  {   1, "aCsCharacteristics" },
  {   2, "eASCharacteristics" },
  { 0, NULL }
};

static const ber_choice_t EASDiscoveryFilter_choice[] = {
  {   1, &hf_lix2_aCsCharacteristics, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_ACProfiles },
  {   2, &hf_lix2_eASCharacteristics, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EASsCharacteristics },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EASDiscoveryFilter(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 EASDiscoveryFilter_choice, hf_index, ett_lix2_EASDiscoveryFilter,
                                 NULL);

  return offset;
}


static const ber_sequence_t DNAIs_set_of[1] = {
  { &hf_lix2_DNAIs_item     , BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_DNAI },
};

static int
dissect_lix2_DNAIs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 DNAIs_set_of, hf_index, ett_lix2_DNAIs);

  return offset;
}


static const ber_sequence_t DiscoveredEAS_sequence[] = {
  { &hf_lix2_eASProfile     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EASProfile },
  { &hf_lix2_lifetime       , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_DiscoveredEAS(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   DiscoveredEAS_sequence, hf_index, ett_lix2_DiscoveredEAS);

  return offset;
}


static const ber_sequence_t EESEASDiscovery_sequence[] = {
  { &hf_lix2_eECID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_eASDiscoveryFilter, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_EASDiscoveryFilter },
  { &hf_lix2_eECServiceContSupport, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACRScenarios },
  { &hf_lix2_uELocation     , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_eASTargetDNAIs , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNAIs },
  { &hf_lix2_discoveredEAS  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DiscoveredEAS },
  { &hf_lix2_failureResponse, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FailureResponse },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESEASDiscovery(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESEASDiscovery_sequence, hf_index, ett_lix2_EESEASDiscovery);

  return offset;
}


static const value_string lix2_SubscriptionType_vals[] = {
  {   1, "subscription" },
  {   2, "subscriptionUpdate" },
  {   3, "unsubscription" },
  { 0, NULL }
};


static int
dissect_lix2_SubscriptionType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_EASEventType_vals[] = {
  {   1, "eASAvailabilityChange" },
  {   2, "eASDynamicInfoChange" },
  { 0, NULL }
};


static int
dissect_lix2_EASEventType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t EASDynamicInfoFilter_sequence[] = {
  { &hf_lix2_eASId          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EASID },
  { &hf_lix2_eASStatus_01   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_eASAcIDs       , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_eASDesc        , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_eASPt          , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_eASFeature     , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_eASSchedule_01 , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_eASSvcArea     , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_eASSvcKpi      , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_eASSvcCont     , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EASDynamicInfoFilter(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EASDynamicInfoFilter_sequence, hf_index, ett_lix2_EASDynamicInfoFilter);

  return offset;
}


static const ber_sequence_t EESEASDiscoverySubscription_sequence[] = {
  { &hf_lix2_eECID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_subscriptionType, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SubscriptionType },
  { &hf_lix2_eASEventType   , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_EASEventType },
  { &hf_lix2_eASDiscoveryFilter, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_EASDiscoveryFilter },
  { &hf_lix2_eASDynamicInfoFilter, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASDynamicInfoFilter },
  { &hf_lix2_eECServiceContSupport, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACRScenarios },
  { &hf_lix2_expirationTime , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_subscriptionId , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_failureResponse, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FailureResponse },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESEASDiscoverySubscription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESEASDiscoverySubscription_sequence, hf_index, ett_lix2_EESEASDiscoverySubscription);

  return offset;
}


static const ber_sequence_t EESEASDiscoveryNotification_sequence[] = {
  { &hf_lix2_subscriptionID , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_eventType      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EASEventType },
  { &hf_lix2_discoveredEAS  , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_DiscoveredEAS },
  { &hf_lix2_failureResponse, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FailureResponse },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESEASDiscoveryNotification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESEASDiscoveryNotification_sequence, hf_index, ett_lix2_EESEASDiscoveryNotification);

  return offset;
}


static const ber_sequence_t ACRDetermineReq_sequence[] = {
  { &hf_lix2_eASID          , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASID },
  { &hf_lix2_aCID           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACID },
  { &hf_lix2_sEASEndpoint   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_EASEndpoint },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ACRDetermineReq(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ACRDetermineReq_sequence, hf_index, ett_lix2_ACRDetermineReq);

  return offset;
}


static const ber_sequence_t ACRInitiateReq_sequence[] = {
  { &hf_lix2_eASID          , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASID },
  { &hf_lix2_aCID           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACID },
  { &hf_lix2_tEASEndpoint   , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_EASEndpoint },
  { &hf_lix2_sEASEndpoint   , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASEndpoint },
  { &hf_lix2_previousTEASEndpoint, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASEndpoint },
  { &hf_lix2_routeReq       , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RouteToLocation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ACRInitiateReq(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ACRInitiateReq_sequence, hf_index, ett_lix2_ACRInitiateReq);

  return offset;
}


static const value_string lix2_EESACRDetOrInit_vals[] = {
  {   1, "aCRDetermineReq" },
  {   2, "aCRInitiateReq" },
  { 0, NULL }
};

static const ber_choice_t EESACRDetOrInit_choice[] = {
  {   1, &hf_lix2_aCRDetermineReq, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_ACRDetermineReq },
  {   2, &hf_lix2_aCRInitiateReq , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_ACRInitiateReq },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESACRDetOrInit(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 EESACRDetOrInit_choice, hf_index, ett_lix2_EESACRDetOrInit,
                                 NULL);

  return offset;
}


static const ber_sequence_t EESAppContextRelocation_sequence[] = {
  { &hf_lix2_eECID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_eESACRDetOrInit, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_EESACRDetOrInit },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESAppContextRelocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESAppContextRelocation_sequence, hf_index, ett_lix2_EESAppContextRelocation);

  return offset;
}


static const ber_sequence_t EASIDs_set_of[1] = {
  { &hf_lix2_EASIDs_item    , BER_CLASS_UNI, BER_UNI_TAG_UTF8String, BER_FLAGS_NOOWNTAG, dissect_lix2_EASID },
};

static int
dissect_lix2_EASIDs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 EASIDs_set_of, hf_index, ett_lix2_EASIDs);

  return offset;
}


static const value_string lix2_ACREventIDs_vals[] = {
  {   1, "targetInformation" },
  {   2, "aCRComplete" },
  { 0, NULL }
};


static int
dissect_lix2_ACREventIDs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t EESACRSubscription_sequence[] = {
  { &hf_lix2_eECID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_subscriptionType, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SubscriptionType },
  { &hf_lix2_expirationTime , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_eASIDs         , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_EASIDs },
  { &hf_lix2_aCIDs          , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACIDs },
  { &hf_lix2_eventIDs       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACREventIDs },
  { &hf_lix2_subscriptionId , BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_failureResponse, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FailureResponse },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESACRSubscription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESACRSubscription_sequence, hf_index, ett_lix2_EESACRSubscription);

  return offset;
}


static const ber_sequence_t EDNConnectionInfo_sequence[] = {
  { &hf_lix2_dNN            , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNN },
  { &hf_lix2_sNSSAI         , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SNSSAI },
  { &hf_lix2_serviceArea    , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EDNConnectionInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EDNConnectionInfo_sequence, hf_index, ett_lix2_EDNConnectionInfo);

  return offset;
}



static int
dissect_lix2_EESID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t EESEndpoint_sequence[] = {
  { &hf_lix2_fQDN           , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FQDN },
  { &hf_lix2_iPv4Addresses  , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv4Addresses },
  { &hf_lix2_iPv6Addresses  , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IPv6Addresses },
  { &hf_lix2_uRI            , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESEndpoint(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESEndpoint_sequence, hf_index, ett_lix2_EESEndpoint);

  return offset;
}


static const ber_sequence_t EESInfo_sequence[] = {
  { &hf_lix2_eESID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EESID },
  { &hf_lix2_eESEndpoint    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EESEndpoint },
  { &hf_lix2_eASIDs         , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EASIDs },
  { &hf_lix2_serviceArea    , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_dNAIS          , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_DNAIs },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESInfo_sequence, hf_index, ett_lix2_EESInfo);

  return offset;
}


static const ber_sequence_t EESsInfo_set_of[1] = {
  { &hf_lix2_EESsInfo_item  , BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_EESInfo },
};

static int
dissect_lix2_EESsInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_set_of(implicit_tag, actx, tree, tvb, offset,
                                 EESsInfo_set_of, hf_index, ett_lix2_EESsInfo);

  return offset;
}


static const ber_sequence_t EDNConfigurationInfo_sequence[] = {
  { &hf_lix2_eDNConnectionInfo, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EDNConnectionInfo },
  { &hf_lix2_eESsInfo       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EESsInfo },
  { &hf_lix2_lifetime       , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EDNConfigurationInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EDNConfigurationInfo_sequence, hf_index, ett_lix2_EDNConfigurationInfo);

  return offset;
}


static const ber_sequence_t TargetInfo_sequence[] = {
  { &hf_lix2_discoveredEAS  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_DiscoveredEAS },
  { &hf_lix2_targetEESInfo  , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EDNConfigurationInfo },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_TargetInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   TargetInfo_sequence, hf_index, ett_lix2_TargetInfo);

  return offset;
}


static const ber_sequence_t EESACRNotification_sequence[] = {
  { &hf_lix2_subscriptionID , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_eASID          , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EASID },
  { &hf_lix2_eventID        , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_ACREventIDs },
  { &hf_lix2_targetInfo     , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TargetInfo },
  { &hf_lix2_aCRRes         , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_failReason     , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESACRNotification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESACRNotification_sequence, hf_index, ett_lix2_EESACRNotification);

  return offset;
}


static const ber_sequence_t EESEECContextRelocation_sequence[] = {
  { &hf_lix2_eECID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_eECContextID   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_uELoc          , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_aCProfiles     , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACProfiles },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESEECContextRelocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESEECContextRelocation_sequence, hf_index, ett_lix2_EESEECContextRelocation);

  return offset;
}


static const ber_sequence_t EESStartOfInterceptionWithRegisteredEEC_sequence[] = {
  { &hf_lix2_eECID          , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_aCProfiles     , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACProfiles },
  { &hf_lix2_eECServiceContSupport, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ACRScenarios },
  { &hf_lix2_expirationTime , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_eECContextID   , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_srcEESID       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_unfulfilledACProfiles, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UnfulfilledACProfiles },
  { &hf_lix2_timeOfRegistration, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EESStartOfInterceptionWithRegisteredEEC(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EESStartOfInterceptionWithRegisteredEEC_sequence, hf_index, ett_lix2_EESStartOfInterceptionWithRegisteredEEC);

  return offset;
}


static const ber_sequence_t UDMStartOfInterceptionWithRegisteredTarget_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_uDMSubscriptionDataSets, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMStartOfInterceptionWithRegisteredTarget(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMStartOfInterceptionWithRegisteredTarget_sequence, hf_index, ett_lix2_UDMStartOfInterceptionWithRegisteredTarget);

  return offset;
}


static const ber_sequence_t FiveGMSAFServiceAccessInformation_sequence[] = {
  { &hf_lix2_gPSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_serviceAccessInformationResource, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGMSAFServiceAccessInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGMSAFServiceAccessInformation_sequence, hf_index, ett_lix2_FiveGMSAFServiceAccessInformation);

  return offset;
}


static const ber_sequence_t FiveGMSAFConsumptionReporting_sequence[] = {
  { &hf_lix2_gPSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_consumptionReport, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGMSAFConsumptionReporting(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGMSAFConsumptionReporting_sequence, hf_index, ett_lix2_FiveGMSAFConsumptionReporting);

  return offset;
}


static const value_string lix2_DPIOperationType_vals[] = {
  {   1, "createDynamicPolicy" },
  {   2, "retrieveDynamicPolicy" },
  {   3, "updateDynamicPolicy" },
  {   4, "patchDynamicPolicy" },
  {   5, "destroyDynamicPolicy" },
  { 0, NULL }
};


static int
dissect_lix2_DPIOperationType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t FiveGMSAFDynamicPolicyInvocation_sequence[] = {
  { &hf_lix2_gPSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_dynamicPolicyResource, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_dPIoperationType, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_DPIOperationType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGMSAFDynamicPolicyInvocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGMSAFDynamicPolicyInvocation_sequence, hf_index, ett_lix2_FiveGMSAFDynamicPolicyInvocation);

  return offset;
}



static int
dissect_lix2_XMLNamespace(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_XMLValue(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t XMLType_sequence[] = {
  { &hf_lix2_xMLNamespace   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_XMLNamespace },
  { &hf_lix2_xMLValue       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_XMLValue },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_XMLType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   XMLType_sequence, hf_index, ett_lix2_XMLType);

  return offset;
}


static const ber_sequence_t FiveGMSAFMetricsReporting_sequence[] = {
  { &hf_lix2_gPSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_metricsReport  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_XMLType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGMSAFMetricsReporting(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGMSAFMetricsReporting_sequence, hf_index, ett_lix2_FiveGMSAFMetricsReporting);

  return offset;
}


static const value_string lix2_NAOperationType_vals[] = {
  {   1, "createNetworkAssistanceSession" },
  {   2, "retrieveNetworkAssistanceSession" },
  {   3, "updateNetworkAssistanceSession" },
  {   4, "patchNetworkAssistanceSession" },
  {   5, "destroyNetworkAssistanceSession" },
  {   6, "requestBitRateRecommendation" },
  {   7, "requestDeliveryBoost" },
  { 0, NULL }
};


static int
dissect_lix2_NAOperationType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t FiveGMSAFNetworkAssistance_sequence[] = {
  { &hf_lix2_gPSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_networkAssistanceSessionResource, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_nAOperationType, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_NAOperationType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGMSAFNetworkAssistance(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGMSAFNetworkAssistance_sequence, hf_index, ett_lix2_FiveGMSAFNetworkAssistance);

  return offset;
}


static const value_string lix2_FiveGMSAFUnsuccessfulOperation_vals[] = {
  {   1, "retrieveServiceAccessInformation" },
  {   2, "submitConsumptionReport" },
  {   3, "submitMetricsReport" },
  {   4, "createDynamicPolicy" },
  {   5, "retrieveDynamicPolicy" },
  {   6, "updateDynamicPolicy" },
  {   7, "patchDynamicPolicy" },
  {   8, "destroyDynamicPolicy" },
  {   9, "createNetworkAssistanceSession" },
  {  10, "retrieveNetworkAssistanceSession" },
  {  11, "updateNetworkAssistanceSession" },
  {  12, "patchNetworkAssistanceSession" },
  {  13, "destroyNetworkAssistanceSession" },
  {  14, "requestBitRateRecommendation" },
  {  15, "requestDeliveryBoost" },
  { 0, NULL }
};


static int
dissect_lix2_FiveGMSAFUnsuccessfulOperation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_FiveGMSAFErrorCode_vals[] = {
  {   1, "badRequest400" },
  {   2, "unauthorized401" },
  {   3, "notFound404" },
  {   4, "unsupportedMediaType415" },
  { 0, NULL }
};


static int
dissect_lix2_FiveGMSAFErrorCode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t FiveGMSAFUnsuccessfulProcedure_sequence[] = {
  { &hf_lix2_gPSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_fiveGMSAFUnsuccessfulOperation, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFUnsuccessfulOperation },
  { &hf_lix2_fiveGMSAFErrorCode, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFErrorCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGMSAFUnsuccessfulProcedure(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGMSAFUnsuccessfulProcedure_sequence, hf_index, ett_lix2_FiveGMSAFUnsuccessfulProcedure);

  return offset;
}


static const ber_sequence_t FiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE_sequence[] = {
  { &hf_lix2_gPSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_serviceAccessInformationResource, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_FiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   FiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE_sequence, hf_index, ett_lix2_FiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE);

  return offset;
}



static int
dissect_lix2_ServiceAreaList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t AMFUEConfigurationUpdate_sequence[] = {
  { &hf_lix2_userIdentifiers, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UserIdentifiers },
  { &hf_lix2_gUTI_01        , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_GUTI },
  { &hf_lix2_oldGUTI        , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_EPS5GGUTI },
  { &hf_lix2_fiveGSTAIList  , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAIList },
  { &hf_lix2_slice          , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Slice },
  { &hf_lix2_serviceAreaList, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ServiceAreaList },
  { &hf_lix2_registrationResult, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_AMFRegistrationResult },
  { &hf_lix2_sMSOverNASIndicator, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SMSOverNASIndicator },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFUEConfigurationUpdate(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFUEConfigurationUpdate_sequence, hf_index, ett_lix2_AMFUEConfigurationUpdate);

  return offset;
}


static const ber_sequence_t HSSServingSystemMessage_sequence[] = {
  { &hf_lix2_iMSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  { &hf_lix2_oldPLMNID      , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_newPLMNID      , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_roamingIndicator, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_RoamingIndicator },
  { &hf_lix2_responseCodes  , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_HSSServingSystemMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   HSSServingSystemMessage_sequence, hf_index, ett_lix2_HSSServingSystemMessage);

  return offset;
}


static const value_string lix2_IMSSubscriberIDs_vals[] = {
  {   1, "iMPI" },
  {   2, "iMPU" },
  { 0, NULL }
};

static const ber_choice_t IMSSubscriberIDs_choice[] = {
  {   1, &hf_lix2_iMPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IMPI },
  {   2, &hf_lix2_iMPU           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_IMPU },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IMSSubscriberIDs(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 IMSSubscriberIDs_choice, hf_index, ett_lix2_IMSSubscriberIDs,
                                 NULL);

  return offset;
}


static const ber_sequence_t HSSIdentities_sequence[] = {
  { &hf_lix2_ePSSubscriberIDs, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSSubscriberIDs },
  { &hf_lix2_iMSSubscriberIDs, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMSSubscriberIDs },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_HSSIdentities(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   HSSIdentities_sequence, hf_index, ett_lix2_HSSIdentities);

  return offset;
}


static const value_string lix2_SubscriptionDataSets_vals[] = {
  {   1, "iMSSubscriptionData" },
  { 0, NULL }
};

static const ber_choice_t SubscriptionDataSets_choice[] = {
  {   1, &hf_lix2_iMSSubscriptionData, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SubscriptionDataSets(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 SubscriptionDataSets_choice, hf_index, ett_lix2_SubscriptionDataSets,
                                 NULL);

  return offset;
}


static const ber_sequence_t HSSStartOfInterceptionWithRegisteredTarget_sequence[] = {
  { &hf_lix2_hSSIdentities  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_HSSIdentities },
  { &hf_lix2_subscriptionDataSets, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SubscriptionDataSets },
  { &hf_lix2_pSUserState    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_HSSStartOfInterceptionWithRegisteredTarget(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   HSSStartOfInterceptionWithRegisteredTarget_sequence, hf_index, ett_lix2_HSSStartOfInterceptionWithRegisteredTarget);

  return offset;
}


static const value_string lix2_AForASSessionWithQoSOpType_vals[] = {
  {   1, "pOST" },
  {   2, "pUT" },
  {   3, "pATCH" },
  {   4, "dELETE" },
  { 0, NULL }
};


static int
dissect_lix2_AForASSessionWithQoSOpType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_AForASSessionWithQoSResponseCode_vals[] = {
  {   1, "oK200" },
  {   2, "created201" },
  {   3, "noContent204" },
  {   4, "temporaryRedirect307" },
  {   5, "permanentRedirect308" },
  {   6, "badRequest400" },
  {   7, "unauthorized401" },
  {   8, "forbidden403" },
  {   9, "notFound404" },
  {  10, "notAcceptable406" },
  {  11, "lengthRequired411" },
  {  12, "unsupportedMediaType415" },
  {  13, "tooManyRequests429" },
  {  14, "internalServerError500" },
  {  15, "serviceUnavailable503" },
  { 0, NULL }
};


static int
dissect_lix2_AForASSessionWithQoSResponseCode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NEFAFSessionWithQoSProvision_sequence[] = {
  { &hf_lix2_gPSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_aFID           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { &hf_lix2_aFSessionWithQoSOpType, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_AForASSessionWithQoSOpType },
  { &hf_lix2_aFSessionWithQoSSubscription, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_aFSessionWithQoSSubscriptionPatch, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_aFSessionWithQoSResponseCode, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_AForASSessionWithQoSResponseCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFAFSessionWithQoSProvision(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFAFSessionWithQoSProvision_sequence, hf_index, ett_lix2_NEFAFSessionWithQoSProvision);

  return offset;
}


static const ber_sequence_t NEFAFSessionWithQoSNotification_sequence[] = {
  { &hf_lix2_gPSI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_aFID           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AFID },
  { &hf_lix2_userPlaneNotificationData, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_aForASSessionWithQoSResponseCode, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_AForASSessionWithQoSResponseCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NEFAFSessionWithQoSNotification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NEFAFSessionWithQoSNotification_sequence, hf_index, ett_lix2_NEFAFSessionWithQoSNotification);

  return offset;
}


static const ber_sequence_t SCEFASSessionWithQoSProvision_sequence[] = {
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_sCSASID        , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SCSASID },
  { &hf_lix2_aSSessionWithQoSOpType, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_AForASSessionWithQoSOpType },
  { &hf_lix2_aSSessionWithQoSSubscription, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_aSSessionWithQoSSubscriptionPatch, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_aSSessionWithQoSResponseCode, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_AForASSessionWithQoSResponseCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFASSessionWithQoSProvision(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFASSessionWithQoSProvision_sequence, hf_index, ett_lix2_SCEFASSessionWithQoSProvision);

  return offset;
}


static const ber_sequence_t SCEFASSessionWithQoSNotification_sequence[] = {
  { &hf_lix2_mSISDN         , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  { &hf_lix2_externalIdentifier, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  { &hf_lix2_sCSASID        , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SCSASID },
  { &hf_lix2_userPlaneNotificationData, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_aSSessionWithQoSResponseCode, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_AForASSessionWithQoSResponseCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_SCEFASSessionWithQoSNotification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   SCEFASSessionWithQoSNotification_sequence, hf_index, ett_lix2_SCEFASSessionWithQoSNotification);

  return offset;
}


static const value_string lix2_TraceRecordType_vals[] = {
  {   1, "traceStart" },
  {   2, "cellTrafficTrace" },
  {   3, "traceDataDelivery" },
  {   4, "traceDeactivation" },
  { 0, NULL }
};


static int
dissect_lix2_TraceRecordType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_TraceDirection_vals[] = {
  {   1, "toAMF" },
  {   2, "fromAMF" },
  {   3, "toMME" },
  {   4, "fromMME" },
  { 0, NULL }
};


static int
dissect_lix2_TraceDirection(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_OCTET_STRING_SIZE_8(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_BIT_STRING_SIZE_8(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}


static const value_string lix2_TraceDepth_vals[] = {
  {   1, "minimum" },
  {   2, "medium" },
  {   3, "maximum" },
  {   4, "minimumWithoutVendorSpecificExtension" },
  {   5, "mediumWithoutVendorSpecificExtension" },
  {   6, "maximumWithoutVendorSpecificExtension" },
  { 0, NULL }
};


static int
dissect_lix2_TraceDepth(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_MDTConfiguration_vals[] = {
  {   1, "mDTConfigurationNR" },
  {   2, "mDTConfigurationEUTRA" },
  { 0, NULL }
};


static int
dissect_lix2_MDTConfiguration(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t TraceActivationInfo_sequence[] = {
  { &hf_lix2_nGRANTraceID   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_8 },
  { &hf_lix2_interfacestoTrace, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_8 },
  { &hf_lix2_traceDepth     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_TraceDepth },
  { &hf_lix2_traceCollectionEntityIPAddress, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_mDTConfiguration, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MDTConfiguration },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_TraceActivationInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   TraceActivationInfo_sequence, hf_index, ett_lix2_TraceActivationInfo);

  return offset;
}



static int
dissect_lix2_BIT_STRING_SIZE_1_160_(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_bitstring(implicit_tag, actx, tree, tvb, offset,
                                    NULL, 0, hf_index, -1,
                                    NULL);

  return offset;
}


static const ber_sequence_t TraceCollectionEntityInfo_sequence[] = {
  { &hf_lix2_traceCollectionEntityIPAddress_01, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_BIT_STRING_SIZE_1_160_ },
  { &hf_lix2_traceCollectionEntityURI, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_TraceCollectionEntityInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   TraceCollectionEntityInfo_sequence, hf_index, ett_lix2_TraceCollectionEntityInfo);

  return offset;
}



static int
dissect_lix2_TraceActivation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lix2_ExternalASNType(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}


static const ber_sequence_t AMFRANTraceReport_sequence[] = {
  { &hf_lix2_userIdentifiers, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UserIdentifiers },
  { &hf_lix2_aMFUENGAPID    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUENGAPID },
  { &hf_lix2_rANUENGAPID    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RANUENGAPID },
  { &hf_lix2_traceRecordType, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_TraceRecordType },
  { &hf_lix2_traceDirection , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_TraceDirection },
  { &hf_lix2_deprecatedTraceActivationInfo, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TraceActivationInfo },
  { &hf_lix2_nGRANCGI       , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_NCGI },
  { &hf_lix2_globalRANNodeID, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_GlobalRANNodeID },
  { &hf_lix2_traceCollectionEntityInfo, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TraceCollectionEntityInfo },
  { &hf_lix2_aMFTraceData   , BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_XMLType },
  { &hf_lix2_location       , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_traceActivation, BER_CLASS_CON, 12, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TraceActivation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFRANTraceReport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFRANTraceReport_sequence, hf_index, ett_lix2_AMFRANTraceReport);

  return offset;
}


static const value_string lix2_RCSIdentity_vals[] = {
  {   1, "fiveGSIdentities" },
  {   2, "ePSIdentities" },
  {   3, "iMSIdentities" },
  { 0, NULL }
};

static const ber_choice_t RCSIdentity_choice[] = {
  {   1, &hf_lix2_fiveGSIdentities, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSSubscriberIDs },
  {   2, &hf_lix2_ePSIdentities  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSSubscriberIDs },
  {   3, &hf_lix2_iMSIdentities  , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_IMSSubscriberIDs },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSIdentity(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 RCSIdentity_choice, hf_index, ett_lix2_RCSIdentity,
                                 NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_RCSIdentity_sequence_of[1] = {
  { &hf_lix2_rCSTargetIdentities_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RCSIdentity },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_RCSIdentity_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity);

  return offset;
}


static const value_string lix2_RCSRegistrationType_vals[] = {
  {   1, "registration" },
  {   2, "reRegistration" },
  {   3, "uEDeregistration" },
  {   4, "networkDeregistration" },
  { 0, NULL }
};


static int
dissect_lix2_RCSRegistrationType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t RCSRegistration_sequence[] = {
  { &hf_lix2_rCSTargetIdentities, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity },
  { &hf_lix2_rCSRegistrationType, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_RCSRegistrationType },
  { &hf_lix2_rCSRegistrationUpdateRequest, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMSPayload },
  { &hf_lix2_rCSRegistrationUpdateResponse, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMSPayload },
  { &hf_lix2_location       , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSRegistration(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RCSRegistration_sequence, hf_index, ett_lix2_RCSRegistration);

  return offset;
}



static int
dissect_lix2_RCSGroupChatSessionID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lix2_SIPURI(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}


static const ber_sequence_t RCSDestination_sequence_of[1] = {
  { &hf_lix2_RCSDestination_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RCSIdentity },
};

static int
dissect_lix2_RCSDestination(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      RCSDestination_sequence_of, hf_index, ett_lix2_RCSDestination);

  return offset;
}


static const ber_sequence_t RCSDestinations_sequence_of[1] = {
  { &hf_lix2_RCSDestinations_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_RCSDestination },
};

static int
dissect_lix2_RCSDestinations(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      RCSDestinations_sequence_of, hf_index, ett_lix2_RCSDestinations);

  return offset;
}


static const value_string lix2_RCSMessageType_vals[] = {
  {   1, "messageWithUserContent" },
  {   2, "fileTransferMessage" },
  {   3, "geoLocationPUSHMessage" },
  {   4, "iMDNNotification" },
  { 0, NULL }
};


static int
dissect_lix2_RCSMessageType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}



static int
dissect_lix2_UUID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_RCSConversationID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lix2_UUID(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_lix2_RCSContributionID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lix2_UUID(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_lix2_IMDNMessageID(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_MIMEContentType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}



static int
dissect_lix2_EncapsulatedMIMEEntity(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t MIMEEntity_sequence[] = {
  { &hf_lix2_contentType_02 , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MIMEContentType },
  { &hf_lix2_encapsulatedMIMEEntity, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EncapsulatedMIMEEntity },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MIMEEntity(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MIMEEntity_sequence, hf_index, ett_lix2_MIMEEntity);

  return offset;
}



static int
dissect_lix2_EncapsulatedMSRP(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t MSRPMessage_sequence[] = {
  { &hf_lix2_encapsulatedMSRP, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EncapsulatedMSRP },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MSRPMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MSRPMessage_sequence, hf_index, ett_lix2_MSRPMessage);

  return offset;
}


static const value_string lix2_EncapsulatedRCSPayload_vals[] = {
  {   1, "mIME" },
  {   2, "mSRP" },
  {   3, "sIP" },
  { 0, NULL }
};

static const ber_choice_t EncapsulatedRCSPayload_choice[] = {
  {   1, &hf_lix2_mIME           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MIMEEntity },
  {   2, &hf_lix2_mSRP           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MSRPMessage },
  {   3, &hf_lix2_sIP            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SIPMessage },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EncapsulatedRCSPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 EncapsulatedRCSPayload_choice, hf_index, ett_lix2_EncapsulatedRCSPayload,
                                 NULL);

  return offset;
}


static const ber_sequence_t ModifiedRCSPayload_sequence[] = {
  { &hf_lix2_modifiedRCSPayload, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_EncapsulatedRCSPayload },
  { &hf_lix2_modifications  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PayloadModifications },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ModifiedRCSPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ModifiedRCSPayload_sequence, hf_index, ett_lix2_ModifiedRCSPayload);

  return offset;
}


static const value_string lix2_RCSPayload_vals[] = {
  {   1, "fullPayload" },
  {   2, "modifiedPayload" },
  { 0, NULL }
};

static const ber_choice_t RCSPayload_choice[] = {
  {   1, &hf_lix2_fullPayload    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EncapsulatedRCSPayload },
  {   2, &hf_lix2_modifiedPayload, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_ModifiedRCSPayload },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 RCSPayload_choice, hf_index, ett_lix2_RCSPayload,
                                 NULL);

  return offset;
}


static const ber_sequence_t RCSMessage_sequence[] = {
  { &hf_lix2_rCSTargetIdentities, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity },
  { &hf_lix2_groupChatSessionID, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RCSGroupChatSessionID },
  { &hf_lix2_originatingIdentity, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity },
  { &hf_lix2_destinationIdentities, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_RCSDestinations },
  { &hf_lix2_direction      , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_messageType_01 , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_RCSMessageType },
  { &hf_lix2_conversationID , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_RCSConversationID },
  { &hf_lix2_contributionID , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_RCSContributionID },
  { &hf_lix2_inReplyToContributionID, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RCSContributionID },
  { &hf_lix2_messageID_01   , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_IMDNMessageID },
  { &hf_lix2_location       , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_messagePayload , BER_CLASS_CON, 12, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RCSPayload },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RCSMessage_sequence, hf_index, ett_lix2_RCSMessage);

  return offset;
}


static const ber_sequence_t RCSCapabilityDiscovery_sequence[] = {
  { &hf_lix2_rCSTargetIdentities, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity },
  { &hf_lix2_rCSTargetContactIdentities, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity },
  { &hf_lix2_sIPMessage     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMSPayload },
  { &hf_lix2_direction      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_location       , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSCapabilityDiscovery(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RCSCapabilityDiscovery_sequence, hf_index, ett_lix2_RCSCapabilityDiscovery);

  return offset;
}


static const value_string lix2_RCSSessionType_vals[] = {
  {   1, "largeMessageStandalone" },
  {   2, "oneTo1Chat" },
  { 0, NULL }
};


static int
dissect_lix2_RCSSessionType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_RCSSessionLeg_vals[] = {
  {   1, "remoteLeg" },
  {   2, "localLeg" },
  { 0, NULL }
};


static int
dissect_lix2_RCSSessionLeg(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_RCSSessionResult_vals[] = {
  {   1, "newLegRequested" },
  {   2, "newLegEstablished" },
  {   3, "legModificationRequested" },
  {   4, "legModificationComplete" },
  {   5, "legRemovalRequest" },
  {   6, "legRemovalComplete" },
  { 0, NULL }
};


static int
dissect_lix2_RCSSessionResult(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MSRPPath_sequence[] = {
  { &hf_lix2_path           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MSRPPath(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MSRPPath_sequence, hf_index, ett_lix2_MSRPPath);

  return offset;
}


static const ber_sequence_t RCSSIPSessionMessage_sequence[] = {
  { &hf_lix2_sessionLeg     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionLeg },
  { &hf_lix2_sIPMessage     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMSPayload },
  { &hf_lix2_rCSSessionResult, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionResult },
  { &hf_lix2_mSRPPathInfo   , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_MSRPPath },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSSIPSessionMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RCSSIPSessionMessage_sequence, hf_index, ett_lix2_RCSSIPSessionMessage);

  return offset;
}


static const ber_sequence_t RCSSessionEstablishment_sequence[] = {
  { &hf_lix2_rCSTargetIdentities, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity },
  { &hf_lix2_conversationID , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_RCSConversationID },
  { &hf_lix2_contributionID , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RCSContributionID },
  { &hf_lix2_inReplyToContributionID, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RCSContributionID },
  { &hf_lix2_sessionReplaces, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RCSContributionID },
  { &hf_lix2_rCSSessionType , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionType },
  { &hf_lix2_sessionDirection_01, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_rCSSessionMessage, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSIPSessionMessage },
  { &hf_lix2_location       , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSSessionEstablishment(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RCSSessionEstablishment_sequence, hf_index, ett_lix2_RCSSessionEstablishment);

  return offset;
}


static const value_string lix2_RCSSessionEndpoints_vals[] = {
  {   1, "remoteOnly" },
  {   2, "localOnly" },
  {   3, "localAndRemote" },
  { 0, NULL }
};


static int
dissect_lix2_RCSSessionEndpoints(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t RCSSessionModification_sequence[] = {
  { &hf_lix2_rCSTargetIdentities, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity },
  { &hf_lix2_conversationID , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_RCSConversationID },
  { &hf_lix2_contributionID , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RCSContributionID },
  { &hf_lix2_inReplyToContributionID, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RCSContributionID },
  { &hf_lix2_sessionReplaces, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_RCSContributionID },
  { &hf_lix2_rCSSessionType , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionType },
  { &hf_lix2_sessionDirection_01, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_sessionEndpoints, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionEndpoints },
  { &hf_lix2_rCSSIPSessionMessage, BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSIPSessionMessage },
  { &hf_lix2_location       , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSSessionModification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RCSSessionModification_sequence, hf_index, ett_lix2_RCSSessionModification);

  return offset;
}


static const ber_sequence_t RCSSessionRelease_sequence[] = {
  { &hf_lix2_rCSTargetIdentities, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity },
  { &hf_lix2_conversationID , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_RCSConversationID },
  { &hf_lix2_contributionID , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RCSContributionID },
  { &hf_lix2_rCSSessionType , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionType },
  { &hf_lix2_sessionDirection_01, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_Direction },
  { &hf_lix2_rCSSIPSessionMessage, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSIPSessionMessage },
  { &hf_lix2_location       , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSSessionRelease(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RCSSessionRelease_sequence, hf_index, ett_lix2_RCSSessionRelease);

  return offset;
}


static const ber_sequence_t AMFUEPolicyTransfer_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUCI           , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  { &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_PEI },
  { &hf_lix2_gPSI           , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_GPSI },
  { &hf_lix2_gUTI           , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGGUTI },
  { &hf_lix2_uEPolicy       , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_UEPolicy },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFUEPolicyTransfer(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFUEPolicyTransfer_sequence, hf_index, ett_lix2_AMFUEPolicyTransfer);

  return offset;
}


static const value_string lix2_ServiceMessageIdentity_vals[] = {
  {   1, "serviceRequest" },
  {   2, "serviceAccept" },
  { 0, NULL }
};

static const ber_choice_t ServiceMessageIdentity_choice[] = {
  {   1, &hf_lix2_serviceRequest , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  {   2, &hf_lix2_serviceAccept  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ServiceMessageIdentity(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 ServiceMessageIdentity_choice, hf_index, ett_lix2_ServiceMessageIdentity,
                                 NULL);

  return offset;
}



static int
dissect_lix2_OCTET_STRING_SIZE_1(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_OCTET_STRING_SIZE_2_32(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t AMFUEServiceAccept_sequence[] = {
  { &hf_lix2_userIdentifiers, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UserIdentifiers },
  { &hf_lix2_serviceMessageIdentity, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_ServiceMessageIdentity },
  { &hf_lix2_serviceType    , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_1 },
  { &hf_lix2_fiveGTMSI      , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGTMSI },
  { &hf_lix2_uplinkDataStatus, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_2_32 },
  { &hf_lix2_pDUSessionStatus, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_2_32 },
  { &hf_lix2_deprecatedUERequestType, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_FiveGSMRequestType },
  { &hf_lix2_pagingRestriction, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PagingRestrictionIndicator },
  { &hf_lix2_forbiddenTAIList, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TAIList },
  { &hf_lix2_uERequestType  , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MUSIMUERequestType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AMFUEServiceAccept(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AMFUEServiceAccept_sequence, hf_index, ett_lix2_AMFUEServiceAccept);

  return offset;
}



static int
dissect_lix2_EPSHandoverType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lix2_ExternalASNType(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_lix2_EPSRANCause(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_lix2_ExternalASNType(implicit_tag, tvb, offset, actx, tree, hf_index);

  return offset;
}


static const ber_sequence_t ERABError_sequence[] = {
  { &hf_lix2_eRABID         , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EPSBearerID },
  { &hf_lix2_cause_09       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANCause },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ERABError(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ERABError_sequence, hf_index, ett_lix2_ERABError);

  return offset;
}


static const ber_sequence_t ERABReleaseList_sequence_of[1] = {
  { &hf_lix2_ERABReleaseList_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_ERABError },
};

static int
dissect_lix2_ERABReleaseList(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      ERABReleaseList_sequence_of, hf_index, ett_lix2_ERABReleaseList);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_RANTargetToSourceContainer_sequence_of[1] = {
  { &hf_lix2_targetToSourceContainers_item, BER_CLASS_UNI, BER_UNI_TAG_OCTETSTRING, BER_FLAGS_NOOWNTAG, dissect_lix2_RANTargetToSourceContainer },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RANTargetToSourceContainer(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_RANTargetToSourceContainer_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RANTargetToSourceContainer);

  return offset;
}


static const ber_sequence_t EPSRANHandoverCommand_sequence[] = {
  { &hf_lix2_userIdentifiers, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UserIdentifiers },
  { &hf_lix2_mMEUES1APID    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMEUES1APID },
  { &hf_lix2_eNBUES1APID    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RANUES1APID },
  { &hf_lix2_handoverType_01, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_EPSHandoverType },
  { &hf_lix2_eRABsToBeForwarded, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ERABContextList },
  { &hf_lix2_eRABsToRelease , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_ERABReleaseList },
  { &hf_lix2_targetToSourceContainers, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RANTargetToSourceContainer },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSRANHandoverCommand(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSRANHandoverCommand_sequence, hf_index, ett_lix2_EPSRANHandoverCommand);

  return offset;
}


static const ber_sequence_t EPSCSGInfo_sequence[] = {
  { &hf_lix2_cSGID          , BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CSGID },
  { &hf_lix2_cSGMembershipStatus, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CSGMembershipIndication },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSCSGInfo(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSCSGInfo_sequence, hf_index, ett_lix2_EPSCSGInfo);

  return offset;
}


static const ber_sequence_t EPSRANHandoverRequest_sequence[] = {
  { &hf_lix2_userIdentifiers, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UserIdentifiers },
  { &hf_lix2_handoverType_01, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_EPSHandoverType },
  { &hf_lix2_handoverCause_01, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANCause },
  { &hf_lix2_sourceToTargetContainer, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_RANSourceToTargetContainer },
  { &hf_lix2_cSGInfo        , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_EPSCSGInfo },
  { &hf_lix2_targetToSourceContainer, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_RANTargetToSourceContainer },
  { &hf_lix2_admittedCSGID  , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_CSGID },
  { &hf_lix2_ePSRANUEContext, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANUEContext },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_EPSRANHandoverRequest(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   EPSRANHandoverRequest_sequence, hf_index, ett_lix2_EPSRANHandoverRequest);

  return offset;
}


static const ber_sequence_t MMERANTraceReport_sequence[] = {
  { &hf_lix2_userIdentifiers, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UserIdentifiers },
  { &hf_lix2_mMEUES1APID    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_MMEUES1APID },
  { &hf_lix2_eNBUES1APID    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RANUES1APID },
  { &hf_lix2_traceRecordType, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_TraceRecordType },
  { &hf_lix2_traceDirection , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_TraceDirection },
  { &hf_lix2_traceActivationInfo, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TraceActivation },
  { &hf_lix2_eUTRANCGI      , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_ECGI },
  { &hf_lix2_globalRANNodeID, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_GlobalRANNodeID },
  { &hf_lix2_traceCollectionEntityInfo, BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TraceCollectionEntityInfo },
  { &hf_lix2_mMETraceData   , BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_XMLType },
  { &hf_lix2_location       , BER_CLASS_CON, 11, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMERANTraceReport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMERANTraceReport_sequence, hf_index, ett_lix2_MMERANTraceReport);

  return offset;
}


static const ber_sequence_t MMEUEServiceAccept_sequence[] = {
  { &hf_lix2_userIdentifiers, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UserIdentifiers },
  { &hf_lix2_serviceType    , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_1 },
  { &hf_lix2_mTMSI          , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TMSI },
  { &hf_lix2_cSFBResponse   , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_1 },
  { &hf_lix2_uEEPSBearerContextStatus, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_2 },
  { &hf_lix2_uERequestType  , BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_MUSIMUERequestType },
  { &hf_lix2_pagingRestriction, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PagingRestrictionIndicator },
  { &hf_lix2_controlPlaneServiceType, BER_CLASS_CON, 8, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING_SIZE_1 },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMEUEServiceAccept(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMEUEServiceAccept_sequence, hf_index, ett_lix2_MMEUEServiceAccept);

  return offset;
}


static const value_string lix2_NWDAFConsumerNFType_vals[] = {
  {   1, "pCF" },
  {   2, "nSSF" },
  {   3, "aMF" },
  {   4, "sMF" },
  {   5, "nEF" },
  {   6, "aF" },
  {   7, "lMF" },
  {   8, "oAM" },
  {   9, "nWDAF" },
  {  10, "dCCF" },
  {  11, "cEF" },
  { 0, NULL }
};


static int
dissect_lix2_NWDAFConsumerNFType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_NWDAFEventsSubscriptionOpType_vals[] = {
  {   1, "pOST" },
  {   2, "pUT" },
  {   3, "dELETE" },
  { 0, NULL }
};


static int
dissect_lix2_NWDAFEventsSubscriptionOpType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const value_string lix2_NWDAFEvent_vals[] = {
  {   1, "serviceExperience" },
  {   2, "uEMobility" },
  {   3, "uEComm" },
  {   4, "abnormalBehaviour" },
  {   5, "dispersion" },
  {   6, "relativeProximity" },
  {   7, "pDUSessionTraffic" },
  { 0, NULL }
};


static int
dissect_lix2_NWDAFEvent(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent_sequence_of[1] = {
  { &hf_lix2_nWDAFSubscribedEventList_item, BER_CLASS_UNI, BER_UNI_TAG_ENUMERATED, BER_FLAGS_NOOWNTAG, dissect_lix2_NWDAFEvent },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent);

  return offset;
}


static const value_string lix2_NWDAFEventsSubscriptionResponseCode_vals[] = {
  {   1, "oK200" },
  {   2, "created201" },
  {   3, "noContent204" },
  {   4, "temporaryRedirect307" },
  {   5, "permanentRedirect308" },
  {   6, "badRequest400" },
  {   7, "unauthorized401" },
  {   8, "forbidden403" },
  {   9, "notFound404" },
  {  10, "notAcceptable406" },
  {  11, "lengthRequired411" },
  {  12, "payloadTooLarge413" },
  {  13, "unsupportedMediaType415" },
  {  14, "tooManyRequests429" },
  {  15, "internalServerError500" },
  {  16, "notImplemented501" },
  {  17, "badGateway502" },
  {  18, "serviceUnavailable503" },
  { 0, NULL }
};


static int
dissect_lix2_NWDAFEventsSubscriptionResponseCode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NWDAFEventsSubscription_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_nWDAFConsumerNFType, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFConsumerNFType },
  { &hf_lix2_nWDAFEventsSubscriptionOpType, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFEventsSubscriptionOpType },
  { &hf_lix2_nWDAFSubscribedEventList, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent },
  { &hf_lix2_nWDAFEventsSubscription_01, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_nWDAFEventsSubscriptionID, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_nWDAFEventsSubscriptionResponseCode, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFEventsSubscriptionResponseCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NWDAFEventsSubscription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NWDAFEventsSubscription_sequence, hf_index, ett_lix2_NWDAFEventsSubscription);

  return offset;
}


static const ber_sequence_t NWDAFEventsNotification_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_nWDAFNotifiedEventList, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent },
  { &hf_lix2_nWDAFEventsNotification_01, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NWDAFEventsNotification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NWDAFEventsNotification_sequence, hf_index, ett_lix2_NWDAFEventsNotification);

  return offset;
}


static const value_string lix2_NWDAFAnalyticsInfoResponseCode_vals[] = {
  {   1, "oK200" },
  {   2, "noContent204" },
  {   3, "badRequest400" },
  {   4, "unauthorized401" },
  {   5, "forbidden403" },
  {   6, "notFound404" },
  {   7, "notAcceptable406" },
  {   8, "uRITooLong414" },
  {   9, "tooManyRequests429" },
  {  10, "internalServerError500" },
  {  11, "badGateway502" },
  {  12, "serviceUnavailable503" },
  { 0, NULL }
};


static int
dissect_lix2_NWDAFAnalyticsInfoResponseCode(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t NWDAFAnalyticsInfoQuery_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_nWDAFEvent     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFEvent },
  { &hf_lix2_nWDAFEventReportingRequirement, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_nWDAFEventFilter, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_nWDAFAnalyticsData, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_nWDAFAnalyticsInfoResponseCode, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFAnalyticsInfoResponseCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NWDAFAnalyticsInfoQuery(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NWDAFAnalyticsInfoQuery_sequence, hf_index, ett_lix2_NWDAFAnalyticsInfoQuery);

  return offset;
}


static const ber_sequence_t NWDAFRoamingAnalyticsSubscription_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_pLMNID         , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_PLMNID },
  { &hf_lix2_nWDAFEventsSubscriptionOpType, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFEventsSubscriptionOpType },
  { &hf_lix2_nWDAFSubscribedEventList, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent },
  { &hf_lix2_nWDAFEventsSubscription_01, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { &hf_lix2_nWDAFEventsSubscriptionID, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_nWDAFEventsSubscriptionResponseCode, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFEventsSubscriptionResponseCode },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NWDAFRoamingAnalyticsSubscription(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NWDAFRoamingAnalyticsSubscription_sequence, hf_index, ett_lix2_NWDAFRoamingAnalyticsSubscription);

  return offset;
}


static const ber_sequence_t NWDAFRoamingAnalyticsNotification_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_nWDAFNotifiedEventList, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_NWDAFEvent },
  { &hf_lix2_nWDAFEventsNotification_01, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_SBIType },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_NWDAFRoamingAnalyticsNotification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   NWDAFRoamingAnalyticsNotification_sequence, hf_index, ett_lix2_NWDAFRoamingAnalyticsNotification);

  return offset;
}


static const ber_sequence_t RCSSIPRegistrationExchange_sequence[] = {
  { &hf_lix2_rCSRegistrationUpdateRequest, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMSPayload },
  { &hf_lix2_rCSRegistrationUpdateResponse, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMSPayload },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSSIPRegistrationExchange(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RCSSIPRegistrationExchange_sequence, hf_index, ett_lix2_RCSSIPRegistrationExchange);

  return offset;
}


static const value_string lix2_RCSRegistrationInformation_vals[] = {
  {   1, "sIPRegistration" },
  {   2, "userProfile" },
  {   3, "multiDevice" },
  {   4, "presenceDocument" },
  { 0, NULL }
};

static const ber_choice_t RCSRegistrationInformation_choice[] = {
  {   1, &hf_lix2_sIPRegistration, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSIPRegistrationExchange },
  {   2, &hf_lix2_userProfile    , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_XMLType },
  {   3, &hf_lix2_multiDevice    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_XMLType },
  {   4, &hf_lix2_presenceDocument, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_XMLType },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSRegistrationInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 RCSRegistrationInformation_choice, hf_index, ett_lix2_RCSRegistrationInformation,
                                 NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_RCSRegistrationInformation_sequence_of[1] = {
  { &hf_lix2_rCSRegistrationInformation_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RCSRegistrationInformation },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSRegistrationInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_RCSRegistrationInformation_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSRegistrationInformation);

  return offset;
}



static int
dissect_lix2_SIPEndpoint(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_restricted_string(implicit_tag, BER_UNI_TAG_UTF8String,
                                            actx, tree, tvb, offset, hf_index,
                                            NULL);

  return offset;
}


static const ber_sequence_t AdditionalInstanceLocation_sequence[] = {
  { &hf_lix2_instance_01    , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SIPEndpoint },
  { &hf_lix2_location       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_AdditionalInstanceLocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   AdditionalInstanceLocation_sequence, hf_index, ett_lix2_AdditionalInstanceLocation);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_AdditionalInstanceLocation_sequence_of[1] = {
  { &hf_lix2_additionalInstanceLocation_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_AdditionalInstanceLocation },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_AdditionalInstanceLocation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_AdditionalInstanceLocation_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_AdditionalInstanceLocation);

  return offset;
}


static const ber_sequence_t StartOfInterceptForRegisteredRCSUser_sequence[] = {
  { &hf_lix2_rCSTargetIdentities, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity },
  { &hf_lix2_rCSRegistrationInformation, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSRegistrationInformation },
  { &hf_lix2_userOnline     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_location       , BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_additionalInstanceLocation, BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_AdditionalInstanceLocation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_StartOfInterceptForRegisteredRCSUser(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   StartOfInterceptForRegisteredRCSUser_sequence, hf_index, ett_lix2_StartOfInterceptForRegisteredRCSUser);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_RCSDestinations_sequence_of[1] = {
  { &hf_lix2_participants_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_RCSDestinations },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSDestinations(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_RCSDestinations_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSDestinations);

  return offset;
}


static const ber_sequence_t RCSSIPSessionExchange_sequence[] = {
  { &hf_lix2_sessionLeg     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionLeg },
  { &hf_lix2_sIPRequest     , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMSPayload },
  { &hf_lix2_sIPResponse    , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IMSPayload },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSSIPSessionExchange(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   RCSSIPSessionExchange_sequence, hf_index, ett_lix2_RCSSIPSessionExchange);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_RCSSIPSessionExchange_sequence_of[1] = {
  { &hf_lix2_rCSSessionLegs_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_RCSSIPSessionExchange },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSSIPSessionExchange(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_RCSSIPSessionExchange_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSSIPSessionExchange);

  return offset;
}


static const value_string lix2_RCSSessionContext_vals[] = {
  {   1, "cPMSessionInfo" },
  { 0, NULL }
};

static const ber_choice_t RCSSessionContext_choice[] = {
  {   1, &hf_lix2_cPMSessionInfo , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MIMEEntity },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSSessionContext(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 RCSSessionContext_choice, hf_index, ett_lix2_RCSSessionContext,
                                 NULL);

  return offset;
}


static const ber_sequence_t SEQUENCE_SIZE_1_MAX_OF_RCSSessionContext_sequence_of[1] = {
  { &hf_lix2_rCSSessionInformation_item, BER_CLASS_ANY/*choice*/, -1/*choice*/, BER_FLAGS_NOOWNTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_RCSSessionContext },
};

static int
dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSSessionContext(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_SIZE_1_MAX_OF_RCSSessionContext_sequence_of, hf_index, ett_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSSessionContext);

  return offset;
}


static const ber_sequence_t StartOfInterceptWithEstablisedRCSSession_sequence[] = {
  { &hf_lix2_rCSTargetIdentities, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSIdentity },
  { &hf_lix2_participants   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSDestinations },
  { &hf_lix2_conversationID , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_RCSConversationID },
  { &hf_lix2_contributionID , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_RCSContributionID },
  { &hf_lix2_rCSSessionType , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionType },
  { &hf_lix2_rCSSessionEndpoints, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionEndpoints },
  { &hf_lix2_rCSSessionLegs , BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSSIPSessionExchange },
  { &hf_lix2_rCSSessionInformation, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_RCSSessionContext },
  { &hf_lix2_location       , BER_CLASS_CON, 9, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Location },
  { &hf_lix2_additionalInstanceLocation, BER_CLASS_CON, 10, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_SIZE_1_MAX_OF_AdditionalInstanceLocation },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_StartOfInterceptWithEstablisedRCSSession(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   StartOfInterceptWithEstablisedRCSSession_sequence, hf_index, ett_lix2_StartOfInterceptWithEstablisedRCSSession);

  return offset;
}


static const ber_sequence_t UDMProSeTargetIdentifierDeconcealment_sequence[] = {
  { &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { &hf_lix2_sUCI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_SUCI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMProSeTargetIdentifierDeconcealment(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMProSeTargetIdentifierDeconcealment_sequence, hf_index, ett_lix2_UDMProSeTargetIdentifierDeconcealment);

  return offset;
}


static const ber_sequence_t UDMProSeTargetAuthentication_sequence[] = {
  { &hf_lix2_servingNetworkName, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_relayServiceCode, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_INTEGER },
  { &hf_lix2_authenticationType, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PrimaryAuthenticationType },
  { &hf_lix2_sUPI           , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_SUPI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UDMProSeTargetAuthentication(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   UDMProSeTargetAuthentication_sequence, hf_index, ett_lix2_UDMProSeTargetAuthentication);

  return offset;
}


static const value_string lix2_XIRIEvent_vals[] = {
  {   1, "registration" },
  {   2, "deregistration" },
  {   3, "locationUpdate" },
  {   4, "startOfInterceptionWithRegisteredUE" },
  {   5, "unsuccessfulAMProcedure" },
  {   6, "pDUSessionEstablishment" },
  {   7, "pDUSessionModification" },
  {   8, "pDUSessionRelease" },
  {   9, "startOfInterceptionWithEstablishedPDUSession" },
  {  10, "unsuccessfulSMProcedure" },
  {  11, "servingSystemMessage" },
  {  12, "sMSMessage" },
  {  13, "lALSReport" },
  {  14, "pDHeaderReport" },
  {  15, "pDSummaryReport" },
  {  17, "mMSSend" },
  {  18, "mMSSendByNonLocalTarget" },
  {  19, "mMSNotification" },
  {  20, "mMSSendToNonLocalTarget" },
  {  21, "mMSNotificationResponse" },
  {  22, "mMSRetrieval" },
  {  23, "mMSDeliveryAck" },
  {  24, "mMSForward" },
  {  25, "mMSDeleteFromRelay" },
  {  26, "mMSDeliveryReport" },
  {  27, "mMSDeliveryReportNonLocalTarget" },
  {  28, "mMSReadReport" },
  {  29, "mMSReadReportNonLocalTarget" },
  {  30, "mMSCancel" },
  {  31, "mMSMBoxStore" },
  {  32, "mMSMBoxUpload" },
  {  33, "mMSMBoxDelete" },
  {  34, "mMSMBoxViewRequest" },
  {  35, "mMSMBoxViewResponse" },
  {  36, "pTCRegistration" },
  {  37, "pTCSessionInitiation" },
  {  38, "pTCSessionAbandon" },
  {  39, "pTCSessionStart" },
  {  40, "pTCSessionEnd" },
  {  41, "pTCStartOfInterception" },
  {  42, "pTCPreEstablishedSession" },
  {  43, "pTCInstantPersonalAlert" },
  {  44, "pTCPartyJoin" },
  {  45, "pTCPartyDrop" },
  {  46, "pTCPartyHold" },
  {  47, "pTCMediaModification" },
  {  48, "pTCGroupAdvertisement" },
  {  49, "pTCFloorControl" },
  {  50, "pTCTargetPresence" },
  {  51, "pTCParticipantPresence" },
  {  52, "pTCListManagement" },
  {  53, "pTCAccessPolicy" },
  {  54, "subscriberRecordChangeMessage" },
  {  55, "cancelLocationMessage" },
  {  56, "sMSReport" },
  {  57, "sMFMAPDUSessionEstablishment" },
  {  58, "sMFMAPDUSessionModification" },
  {  59, "sMFMAPDUSessionRelease" },
  {  60, "startOfInterceptionWithEstablishedMAPDUSession" },
  {  61, "unsuccessfulMASMProcedure" },
  {  62, "aMFIdentifierAssociation" },
  {  63, "mMEIdentifierAssociation" },
  {  64, "sMFPDUtoMAPDUSessionModification" },
  {  65, "nEFPDUSessionEstablishment" },
  {  66, "nEFPDUSessionModification" },
  {  67, "nEFPDUSessionRelease" },
  {  68, "nEFUnsuccessfulProcedure" },
  {  69, "nEFStartOfInterceptionWithEstablishedPDUSession" },
  {  70, "nEFdeviceTrigger" },
  {  71, "nEFdeviceTriggerReplace" },
  {  72, "nEFdeviceTriggerCancellation" },
  {  73, "nEFdeviceTriggerReportNotify" },
  {  74, "nEFMSISDNLessMOSMS" },
  {  75, "nEFExpectedUEBehaviourUpdate" },
  {  76, "sCEFPDNConnectionEstablishment" },
  {  77, "sCEFPDNConnectionUpdate" },
  {  78, "sCEFPDNConnectionRelease" },
  {  79, "sCEFUnsuccessfulProcedure" },
  {  80, "sCEFStartOfInterceptionWithEstablishedPDNConnection" },
  {  81, "sCEFdeviceTrigger" },
  {  82, "sCEFdeviceTriggerReplace" },
  {  83, "sCEFdeviceTriggerCancellation" },
  {  84, "sCEFdeviceTriggerReportNotify" },
  {  85, "sCEFMSISDNLessMOSMS" },
  {  86, "sCEFCommunicationPatternUpdate" },
  {  87, "mMEAttach" },
  {  88, "mMEDetach" },
  {  89, "mMELocationUpdate" },
  {  90, "mMEStartOfInterceptionWithEPSAttachedUE" },
  {  91, "mMEUnsuccessfulProcedure" },
  {  92, "aAnFAnchorKeyRegister" },
  {  93, "aAnFKAKMAApplicationKeyGet" },
  {  94, "aAnFStartOfInterceptWithEstablishedAKMAKeyMaterial" },
  {  95, "aAnFAKMAContextRemovalRecord" },
  {  96, "aFAKMAApplicationKeyRefresh" },
  {  97, "aFStartOfInterceptWithEstablishedAKMAApplicationKey" },
  {  98, "aFAuxiliarySecurityParameterEstablishment" },
  {  99, "aFApplicationKeyRemoval" },
  { 100, "n9HRPDUSessionInfo" },
  { 101, "s8HRBearerInfo" },
  { 102, "separatedLocationReporting" },
  { 103, "sTIRSHAKENSignatureGeneration" },
  { 104, "sTIRSHAKENSignatureValidation" },
  { 105, "iMSMessage" },
  { 106, "startOfInterceptionForActiveIMSSession" },
  { 107, "iMSCCUnavailable" },
  { 108, "uDMLocationInformationResult" },
  { 109, "uDMUEInformationResponse" },
  { 110, "uDMUEAuthenticationResponse" },
  { 111, "positioningInfoTransfer" },
  { 112, "mMEPositioningInfoTransfer" },
  { 113, "aMFRANHandoverCommand" },
  { 114, "aMFRANHandoverRequest" },
  { 115, "eESEECRegistration" },
  { 116, "eESEASDiscovery" },
  { 117, "eESEASDiscoverySubscription" },
  { 118, "eESEASDiscoveryNotification" },
  { 119, "eESAppContextRelocation" },
  { 120, "eESACRSubscription" },
  { 121, "eESACRNotification" },
  { 122, "eESEECContextRelocation" },
  { 123, "eESStartOfInterceptionWithRegisteredEEC" },
  { 124, "uDMStartOfInterceptionWithRegisteredTarget" },
  { 125, "fiveGMSAFServiceAccessInformation" },
  { 126, "fiveGMSAFConsumptionReporting" },
  { 127, "fiveGMSAFDynamicPolicyInvocation" },
  { 128, "fiveGMSAFMetricsReporting" },
  { 129, "fiveGMSAFNetworkAssistance" },
  { 130, "fiveGMSAFUnsuccessfulProcedure" },
  { 131, "fiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE" },
  { 132, "aMFUEConfigurationUpdate" },
  { 133, "hSSServingSystemMessage" },
  { 134, "hSSStartOfInterceptionWithRegisteredTarget" },
  { 135, "nEFAFSessionWithQoSProvision" },
  { 136, "nEFAFSessionWithQoSNotification" },
  { 137, "sCEFASSessionWithQoSProvision" },
  { 138, "sCEFASSessionWithQoSNotification" },
  { 139, "aMFRANTraceReport" },
  { 140, "rCSRegistration" },
  { 141, "rCSMessage" },
  { 142, "rCSCapabilityDiscovery" },
  { 143, "rCSSessionEstablishment" },
  { 144, "rCSSessionModification" },
  { 145, "rCSSessionRelease" },
  { 146, "aMFUEPolicyTransfer" },
  { 147, "aMFUEServiceAccept" },
  { 148, "ePSRANHandoverCommand" },
  { 149, "ePSRANHandoverRequest" },
  { 150, "mMERANTraceReport" },
  { 151, "mMEUEServiceAccept" },
  { 152, "nWDAFEventsSubscription" },
  { 153, "nWDAFEventsNotification" },
  { 154, "nWDAFAnalyticsInfoQuery" },
  { 155, "nWDAFRoamingAnalyticsSubscription" },
  { 156, "nWDAFRoamingAnalyticsNotification" },
  { 157, "startOfInterceptForRegisteredRCSUser" },
  { 158, "startOfInterceptWithEstablisedRCSSession" },
  { 159, "uDMProSeTargetIdentifierDeconcealment" },
  { 160, "uDMProSeTargetAuthentication" },
  { 0, NULL }
};

static const ber_choice_t XIRIEvent_choice[] = {
  {   1, &hf_lix2_registration   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRegistration },
  {   2, &hf_lix2_deregistration , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AMFDeregistration },
  {   3, &hf_lix2_locationUpdate , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_AMFLocationUpdate },
  {   4, &hf_lix2_startOfInterceptionWithRegisteredUE, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_AMFStartOfInterceptionWithRegisteredUE },
  {   5, &hf_lix2_unsuccessfulAMProcedure, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUnsuccessfulProcedure },
  {   6, &hf_lix2_pDUSessionEstablishment, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_SMFPDUSessionEstablishment },
  {   7, &hf_lix2_pDUSessionModification, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_SMFPDUSessionModification },
  {   8, &hf_lix2_pDUSessionRelease, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_SMFPDUSessionRelease },
  {   9, &hf_lix2_startOfInterceptionWithEstablishedPDUSession, BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_SMFStartOfInterceptionWithEstablishedPDUSession },
  {  10, &hf_lix2_unsuccessfulSMProcedure, BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_SMFUnsuccessfulProcedure },
  {  11, &hf_lix2_servingSystemMessage, BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_UDMServingSystemMessage },
  {  12, &hf_lix2_sMSMessage     , BER_CLASS_CON, 12, BER_FLAGS_IMPLTAG, dissect_lix2_SMSMessage },
  {  13, &hf_lix2_lALSReport     , BER_CLASS_CON, 13, BER_FLAGS_IMPLTAG, dissect_lix2_LALSReport },
  {  14, &hf_lix2_pDHeaderReport , BER_CLASS_CON, 14, BER_FLAGS_IMPLTAG, dissect_lix2_PDHeaderReport },
  {  15, &hf_lix2_pDSummaryReport, BER_CLASS_CON, 15, BER_FLAGS_IMPLTAG, dissect_lix2_PDSummaryReport },
  {  17, &hf_lix2_mMSSend        , BER_CLASS_CON, 17, BER_FLAGS_IMPLTAG, dissect_lix2_MMSSend },
  {  18, &hf_lix2_mMSSendByNonLocalTarget, BER_CLASS_CON, 18, BER_FLAGS_IMPLTAG, dissect_lix2_MMSSendByNonLocalTarget },
  {  19, &hf_lix2_mMSNotification, BER_CLASS_CON, 19, BER_FLAGS_IMPLTAG, dissect_lix2_MMSNotification },
  {  20, &hf_lix2_mMSSendToNonLocalTarget, BER_CLASS_CON, 20, BER_FLAGS_IMPLTAG, dissect_lix2_MMSSendToNonLocalTarget },
  {  21, &hf_lix2_mMSNotificationResponse, BER_CLASS_CON, 21, BER_FLAGS_IMPLTAG, dissect_lix2_MMSNotificationResponse },
  {  22, &hf_lix2_mMSRetrieval   , BER_CLASS_CON, 22, BER_FLAGS_IMPLTAG, dissect_lix2_MMSRetrieval },
  {  23, &hf_lix2_mMSDeliveryAck , BER_CLASS_CON, 23, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDeliveryAck },
  {  24, &hf_lix2_mMSForward     , BER_CLASS_CON, 24, BER_FLAGS_IMPLTAG, dissect_lix2_MMSForward },
  {  25, &hf_lix2_mMSDeleteFromRelay, BER_CLASS_CON, 25, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDeleteFromRelay },
  {  26, &hf_lix2_mMSDeliveryReport, BER_CLASS_CON, 26, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDeliveryReport },
  {  27, &hf_lix2_mMSDeliveryReportNonLocalTarget, BER_CLASS_CON, 27, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDeliveryReportNonLocalTarget },
  {  28, &hf_lix2_mMSReadReport  , BER_CLASS_CON, 28, BER_FLAGS_IMPLTAG, dissect_lix2_MMSReadReport },
  {  29, &hf_lix2_mMSReadReportNonLocalTarget, BER_CLASS_CON, 29, BER_FLAGS_IMPLTAG, dissect_lix2_MMSReadReportNonLocalTarget },
  {  30, &hf_lix2_mMSCancel      , BER_CLASS_CON, 30, BER_FLAGS_IMPLTAG, dissect_lix2_MMSCancel },
  {  31, &hf_lix2_mMSMBoxStore   , BER_CLASS_CON, 31, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMBoxStore },
  {  32, &hf_lix2_mMSMBoxUpload  , BER_CLASS_CON, 32, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMBoxUpload },
  {  33, &hf_lix2_mMSMBoxDelete  , BER_CLASS_CON, 33, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMBoxDelete },
  {  34, &hf_lix2_mMSMBoxViewRequest, BER_CLASS_CON, 34, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMBoxViewRequest },
  {  35, &hf_lix2_mMSMBoxViewResponse, BER_CLASS_CON, 35, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMBoxViewResponse },
  {  36, &hf_lix2_pTCRegistration, BER_CLASS_CON, 36, BER_FLAGS_IMPLTAG, dissect_lix2_PTCRegistration },
  {  37, &hf_lix2_pTCSessionInitiation, BER_CLASS_CON, 37, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInitiation },
  {  38, &hf_lix2_pTCSessionAbandon, BER_CLASS_CON, 38, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionAbandon },
  {  39, &hf_lix2_pTCSessionStart, BER_CLASS_CON, 39, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionStart },
  {  40, &hf_lix2_pTCSessionEnd  , BER_CLASS_CON, 40, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionEnd },
  {  41, &hf_lix2_pTCStartOfInterception, BER_CLASS_CON, 41, BER_FLAGS_IMPLTAG, dissect_lix2_PTCStartOfInterception },
  {  42, &hf_lix2_pTCPreEstablishedSession, BER_CLASS_CON, 42, BER_FLAGS_IMPLTAG, dissect_lix2_PTCPreEstablishedSession },
  {  43, &hf_lix2_pTCInstantPersonalAlert, BER_CLASS_CON, 43, BER_FLAGS_IMPLTAG, dissect_lix2_PTCInstantPersonalAlert },
  {  44, &hf_lix2_pTCPartyJoin   , BER_CLASS_CON, 44, BER_FLAGS_IMPLTAG, dissect_lix2_PTCPartyJoin },
  {  45, &hf_lix2_pTCPartyDrop   , BER_CLASS_CON, 45, BER_FLAGS_IMPLTAG, dissect_lix2_PTCPartyDrop },
  {  46, &hf_lix2_pTCPartyHold   , BER_CLASS_CON, 46, BER_FLAGS_IMPLTAG, dissect_lix2_PTCPartyHold },
  {  47, &hf_lix2_pTCMediaModification, BER_CLASS_CON, 47, BER_FLAGS_IMPLTAG, dissect_lix2_PTCMediaModification },
  {  48, &hf_lix2_pTCGroupAdvertisement, BER_CLASS_CON, 48, BER_FLAGS_IMPLTAG, dissect_lix2_PTCGroupAdvertisement },
  {  49, &hf_lix2_pTCFloorControl, BER_CLASS_CON, 49, BER_FLAGS_IMPLTAG, dissect_lix2_PTCFloorControl },
  {  50, &hf_lix2_pTCTargetPresence, BER_CLASS_CON, 50, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetPresence },
  {  51, &hf_lix2_pTCParticipantPresence, BER_CLASS_CON, 51, BER_FLAGS_IMPLTAG, dissect_lix2_PTCParticipantPresence },
  {  52, &hf_lix2_pTCListManagement, BER_CLASS_CON, 52, BER_FLAGS_IMPLTAG, dissect_lix2_PTCListManagement },
  {  53, &hf_lix2_pTCAccessPolicy, BER_CLASS_CON, 53, BER_FLAGS_IMPLTAG, dissect_lix2_PTCAccessPolicy },
  {  54, &hf_lix2_subscriberRecordChangeMessage, BER_CLASS_CON, 54, BER_FLAGS_IMPLTAG, dissect_lix2_UDMSubscriberRecordChangeMessage },
  {  55, &hf_lix2_cancelLocationMessage, BER_CLASS_CON, 55, BER_FLAGS_IMPLTAG, dissect_lix2_UDMCancelLocationMessage },
  {  56, &hf_lix2_sMSReport      , BER_CLASS_CON, 56, BER_FLAGS_IMPLTAG, dissect_lix2_SMSReport },
  {  57, &hf_lix2_sMFMAPDUSessionEstablishment, BER_CLASS_CON, 57, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAPDUSessionEstablishment },
  {  58, &hf_lix2_sMFMAPDUSessionModification, BER_CLASS_CON, 58, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAPDUSessionModification },
  {  59, &hf_lix2_sMFMAPDUSessionRelease, BER_CLASS_CON, 59, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAPDUSessionRelease },
  {  60, &hf_lix2_startOfInterceptionWithEstablishedMAPDUSession, BER_CLASS_CON, 60, BER_FLAGS_IMPLTAG, dissect_lix2_SMFStartOfInterceptionWithEstablishedMAPDUSession },
  {  61, &hf_lix2_unsuccessfulMASMProcedure, BER_CLASS_CON, 61, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAUnsuccessfulProcedure },
  {  62, &hf_lix2_aMFIdentifierAssociation, BER_CLASS_CON, 62, BER_FLAGS_IMPLTAG, dissect_lix2_AMFIdentifierAssociation },
  {  63, &hf_lix2_mMEIdentifierAssociation, BER_CLASS_CON, 63, BER_FLAGS_IMPLTAG, dissect_lix2_MMEIdentifierAssociation },
  {  64, &hf_lix2_sMFPDUtoMAPDUSessionModification, BER_CLASS_CON, 64, BER_FLAGS_IMPLTAG, dissect_lix2_SMFPDUtoMAPDUSessionModification },
  {  65, &hf_lix2_nEFPDUSessionEstablishment, BER_CLASS_CON, 65, BER_FLAGS_IMPLTAG, dissect_lix2_NEFPDUSessionEstablishment },
  {  66, &hf_lix2_nEFPDUSessionModification, BER_CLASS_CON, 66, BER_FLAGS_IMPLTAG, dissect_lix2_NEFPDUSessionModification },
  {  67, &hf_lix2_nEFPDUSessionRelease, BER_CLASS_CON, 67, BER_FLAGS_IMPLTAG, dissect_lix2_NEFPDUSessionRelease },
  {  68, &hf_lix2_nEFUnsuccessfulProcedure, BER_CLASS_CON, 68, BER_FLAGS_IMPLTAG, dissect_lix2_NEFUnsuccessfulProcedure },
  {  69, &hf_lix2_nEFStartOfInterceptionWithEstablishedPDUSession, BER_CLASS_CON, 69, BER_FLAGS_IMPLTAG, dissect_lix2_NEFStartOfInterceptionWithEstablishedPDUSession },
  {  70, &hf_lix2_nEFdeviceTrigger, BER_CLASS_CON, 70, BER_FLAGS_IMPLTAG, dissect_lix2_NEFDeviceTrigger },
  {  71, &hf_lix2_nEFdeviceTriggerReplace, BER_CLASS_CON, 71, BER_FLAGS_IMPLTAG, dissect_lix2_NEFDeviceTriggerReplace },
  {  72, &hf_lix2_nEFdeviceTriggerCancellation, BER_CLASS_CON, 72, BER_FLAGS_IMPLTAG, dissect_lix2_NEFDeviceTriggerCancellation },
  {  73, &hf_lix2_nEFdeviceTriggerReportNotify, BER_CLASS_CON, 73, BER_FLAGS_IMPLTAG, dissect_lix2_NEFDeviceTriggerReportNotify },
  {  74, &hf_lix2_nEFMSISDNLessMOSMS, BER_CLASS_CON, 74, BER_FLAGS_IMPLTAG, dissect_lix2_NEFMSISDNLessMOSMS },
  {  75, &hf_lix2_nEFExpectedUEBehaviourUpdate, BER_CLASS_CON, 75, BER_FLAGS_IMPLTAG, dissect_lix2_NEFExpectedUEBehaviourUpdate },
  {  76, &hf_lix2_sCEFPDNConnectionEstablishment, BER_CLASS_CON, 76, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFPDNConnectionEstablishment },
  {  77, &hf_lix2_sCEFPDNConnectionUpdate, BER_CLASS_CON, 77, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFPDNConnectionUpdate },
  {  78, &hf_lix2_sCEFPDNConnectionRelease, BER_CLASS_CON, 78, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFPDNConnectionRelease },
  {  79, &hf_lix2_sCEFUnsuccessfulProcedure, BER_CLASS_CON, 79, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFUnsuccessfulProcedure },
  {  80, &hf_lix2_sCEFStartOfInterceptionWithEstablishedPDNConnection, BER_CLASS_CON, 80, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFStartOfInterceptionWithEstablishedPDNConnection },
  {  81, &hf_lix2_sCEFdeviceTrigger, BER_CLASS_CON, 81, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFDeviceTrigger },
  {  82, &hf_lix2_sCEFdeviceTriggerReplace, BER_CLASS_CON, 82, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFDeviceTriggerReplace },
  {  83, &hf_lix2_sCEFdeviceTriggerCancellation, BER_CLASS_CON, 83, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFDeviceTriggerCancellation },
  {  84, &hf_lix2_sCEFdeviceTriggerReportNotify, BER_CLASS_CON, 84, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFDeviceTriggerReportNotify },
  {  85, &hf_lix2_sCEFMSISDNLessMOSMS, BER_CLASS_CON, 85, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFMSISDNLessMOSMS },
  {  86, &hf_lix2_sCEFCommunicationPatternUpdate, BER_CLASS_CON, 86, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFCommunicationPatternUpdate },
  {  87, &hf_lix2_mMEAttach      , BER_CLASS_CON, 87, BER_FLAGS_IMPLTAG, dissect_lix2_MMEAttach },
  {  88, &hf_lix2_mMEDetach      , BER_CLASS_CON, 88, BER_FLAGS_IMPLTAG, dissect_lix2_MMEDetach },
  {  89, &hf_lix2_mMELocationUpdate, BER_CLASS_CON, 89, BER_FLAGS_IMPLTAG, dissect_lix2_MMELocationUpdate },
  {  90, &hf_lix2_mMEStartOfInterceptionWithEPSAttachedUE, BER_CLASS_CON, 90, BER_FLAGS_IMPLTAG, dissect_lix2_MMEStartOfInterceptionWithEPSAttachedUE },
  {  91, &hf_lix2_mMEUnsuccessfulProcedure, BER_CLASS_CON, 91, BER_FLAGS_IMPLTAG, dissect_lix2_MMEUnsuccessfulProcedure },
  {  92, &hf_lix2_aAnFAnchorKeyRegister, BER_CLASS_CON, 92, BER_FLAGS_IMPLTAG, dissect_lix2_AAnFAnchorKeyRegister },
  {  93, &hf_lix2_aAnFKAKMAApplicationKeyGet, BER_CLASS_CON, 93, BER_FLAGS_IMPLTAG, dissect_lix2_AAnFKAKMAApplicationKeyGet },
  {  94, &hf_lix2_aAnFStartOfInterceptWithEstablishedAKMAKeyMaterial, BER_CLASS_CON, 94, BER_FLAGS_IMPLTAG, dissect_lix2_AAnFStartOfInterceptWithEstablishedAKMAKeyMaterial },
  {  95, &hf_lix2_aAnFAKMAContextRemovalRecord, BER_CLASS_CON, 95, BER_FLAGS_IMPLTAG, dissect_lix2_AAnFAKMAContextRemovalRecord },
  {  96, &hf_lix2_aFAKMAApplicationKeyRefresh, BER_CLASS_CON, 96, BER_FLAGS_IMPLTAG, dissect_lix2_AFAKMAApplicationKeyRefresh },
  {  97, &hf_lix2_aFStartOfInterceptWithEstablishedAKMAApplicationKey, BER_CLASS_CON, 97, BER_FLAGS_IMPLTAG, dissect_lix2_AFStartOfInterceptWithEstablishedAKMAApplicationKey },
  {  98, &hf_lix2_aFAuxiliarySecurityParameterEstablishment, BER_CLASS_CON, 98, BER_FLAGS_IMPLTAG, dissect_lix2_AFAuxiliarySecurityParameterEstablishment },
  {  99, &hf_lix2_aFApplicationKeyRemoval, BER_CLASS_CON, 99, BER_FLAGS_IMPLTAG, dissect_lix2_AFApplicationKeyRemoval },
  { 100, &hf_lix2_n9HRPDUSessionInfo, BER_CLASS_CON, 100, BER_FLAGS_IMPLTAG, dissect_lix2_N9HRPDUSessionInfo },
  { 101, &hf_lix2_s8HRBearerInfo , BER_CLASS_CON, 101, BER_FLAGS_IMPLTAG, dissect_lix2_S8HRBearerInfo },
  { 102, &hf_lix2_separatedLocationReporting, BER_CLASS_CON, 102, BER_FLAGS_IMPLTAG, dissect_lix2_SeparatedLocationReporting },
  { 103, &hf_lix2_sTIRSHAKENSignatureGeneration, BER_CLASS_CON, 103, BER_FLAGS_IMPLTAG, dissect_lix2_STIRSHAKENSignatureGeneration },
  { 104, &hf_lix2_sTIRSHAKENSignatureValidation, BER_CLASS_CON, 104, BER_FLAGS_IMPLTAG, dissect_lix2_STIRSHAKENSignatureValidation },
  { 105, &hf_lix2_iMSMessage     , BER_CLASS_CON, 105, BER_FLAGS_IMPLTAG, dissect_lix2_IMSMessage },
  { 106, &hf_lix2_startOfInterceptionForActiveIMSSession, BER_CLASS_CON, 106, BER_FLAGS_IMPLTAG, dissect_lix2_StartOfInterceptionForActiveIMSSession },
  { 107, &hf_lix2_iMSCCUnavailable, BER_CLASS_CON, 107, BER_FLAGS_IMPLTAG, dissect_lix2_IMSCCUnavailable },
  { 108, &hf_lix2_uDMLocationInformationResult, BER_CLASS_CON, 108, BER_FLAGS_IMPLTAG, dissect_lix2_UDMLocationInformationResult },
  { 109, &hf_lix2_uDMUEInformationResponse, BER_CLASS_CON, 109, BER_FLAGS_IMPLTAG, dissect_lix2_UDMUEInformationResponse },
  { 110, &hf_lix2_uDMUEAuthenticationResponse, BER_CLASS_CON, 110, BER_FLAGS_IMPLTAG, dissect_lix2_UDMUEAuthenticationResponse },
  { 111, &hf_lix2_positioningInfoTransfer, BER_CLASS_CON, 111, BER_FLAGS_IMPLTAG, dissect_lix2_AMFPositioningInfoTransfer },
  { 112, &hf_lix2_mMEPositioningInfoTransfer, BER_CLASS_CON, 112, BER_FLAGS_IMPLTAG, dissect_lix2_MMEPositioningInfoTransfer },
  { 113, &hf_lix2_aMFRANHandoverCommand, BER_CLASS_CON, 113, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRANHandoverCommand },
  { 114, &hf_lix2_aMFRANHandoverRequest, BER_CLASS_CON, 114, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRANHandoverRequest },
  { 115, &hf_lix2_eESEECRegistration, BER_CLASS_CON, 115, BER_FLAGS_IMPLTAG, dissect_lix2_EESEECRegistration },
  { 116, &hf_lix2_eESEASDiscovery, BER_CLASS_CON, 116, BER_FLAGS_IMPLTAG, dissect_lix2_EESEASDiscovery },
  { 117, &hf_lix2_eESEASDiscoverySubscription, BER_CLASS_CON, 117, BER_FLAGS_IMPLTAG, dissect_lix2_EESEASDiscoverySubscription },
  { 118, &hf_lix2_eESEASDiscoveryNotification, BER_CLASS_CON, 118, BER_FLAGS_IMPLTAG, dissect_lix2_EESEASDiscoveryNotification },
  { 119, &hf_lix2_eESAppContextRelocation, BER_CLASS_CON, 119, BER_FLAGS_IMPLTAG, dissect_lix2_EESAppContextRelocation },
  { 120, &hf_lix2_eESACRSubscription, BER_CLASS_CON, 120, BER_FLAGS_IMPLTAG, dissect_lix2_EESACRSubscription },
  { 121, &hf_lix2_eESACRNotification, BER_CLASS_CON, 121, BER_FLAGS_IMPLTAG, dissect_lix2_EESACRNotification },
  { 122, &hf_lix2_eESEECContextRelocation, BER_CLASS_CON, 122, BER_FLAGS_IMPLTAG, dissect_lix2_EESEECContextRelocation },
  { 123, &hf_lix2_eESStartOfInterceptionWithRegisteredEEC, BER_CLASS_CON, 123, BER_FLAGS_IMPLTAG, dissect_lix2_EESStartOfInterceptionWithRegisteredEEC },
  { 124, &hf_lix2_uDMStartOfInterceptionWithRegisteredTarget, BER_CLASS_CON, 124, BER_FLAGS_IMPLTAG, dissect_lix2_UDMStartOfInterceptionWithRegisteredTarget },
  { 125, &hf_lix2_fiveGMSAFServiceAccessInformation, BER_CLASS_CON, 125, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFServiceAccessInformation },
  { 126, &hf_lix2_fiveGMSAFConsumptionReporting, BER_CLASS_CON, 126, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFConsumptionReporting },
  { 127, &hf_lix2_fiveGMSAFDynamicPolicyInvocation, BER_CLASS_CON, 127, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFDynamicPolicyInvocation },
  { 128, &hf_lix2_fiveGMSAFMetricsReporting, BER_CLASS_CON, 128, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFMetricsReporting },
  { 129, &hf_lix2_fiveGMSAFNetworkAssistance, BER_CLASS_CON, 129, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFNetworkAssistance },
  { 130, &hf_lix2_fiveGMSAFUnsuccessfulProcedure, BER_CLASS_CON, 130, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFUnsuccessfulProcedure },
  { 131, &hf_lix2_fiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE, BER_CLASS_CON, 131, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE },
  { 132, &hf_lix2_aMFUEConfigurationUpdate, BER_CLASS_CON, 132, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUEConfigurationUpdate },
  { 133, &hf_lix2_hSSServingSystemMessage, BER_CLASS_CON, 133, BER_FLAGS_IMPLTAG, dissect_lix2_HSSServingSystemMessage },
  { 134, &hf_lix2_hSSStartOfInterceptionWithRegisteredTarget, BER_CLASS_CON, 134, BER_FLAGS_IMPLTAG, dissect_lix2_HSSStartOfInterceptionWithRegisteredTarget },
  { 135, &hf_lix2_nEFAFSessionWithQoSProvision, BER_CLASS_CON, 135, BER_FLAGS_IMPLTAG, dissect_lix2_NEFAFSessionWithQoSProvision },
  { 136, &hf_lix2_nEFAFSessionWithQoSNotification, BER_CLASS_CON, 136, BER_FLAGS_IMPLTAG, dissect_lix2_NEFAFSessionWithQoSNotification },
  { 137, &hf_lix2_sCEFASSessionWithQoSProvision, BER_CLASS_CON, 137, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFASSessionWithQoSProvision },
  { 138, &hf_lix2_sCEFASSessionWithQoSNotification, BER_CLASS_CON, 138, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFASSessionWithQoSNotification },
  { 139, &hf_lix2_aMFRANTraceReport, BER_CLASS_CON, 139, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRANTraceReport },
  { 140, &hf_lix2_rCSRegistration, BER_CLASS_CON, 140, BER_FLAGS_IMPLTAG, dissect_lix2_RCSRegistration },
  { 141, &hf_lix2_rCSMessage     , BER_CLASS_CON, 141, BER_FLAGS_IMPLTAG, dissect_lix2_RCSMessage },
  { 142, &hf_lix2_rCSCapabilityDiscovery, BER_CLASS_CON, 142, BER_FLAGS_IMPLTAG, dissect_lix2_RCSCapabilityDiscovery },
  { 143, &hf_lix2_rCSSessionEstablishment, BER_CLASS_CON, 143, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionEstablishment },
  { 144, &hf_lix2_rCSSessionModification, BER_CLASS_CON, 144, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionModification },
  { 145, &hf_lix2_rCSSessionRelease, BER_CLASS_CON, 145, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionRelease },
  { 146, &hf_lix2_aMFUEPolicyTransfer, BER_CLASS_CON, 146, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUEPolicyTransfer },
  { 147, &hf_lix2_aMFUEServiceAccept, BER_CLASS_CON, 147, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUEServiceAccept },
  { 148, &hf_lix2_ePSRANHandoverCommand, BER_CLASS_CON, 148, BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANHandoverCommand },
  { 149, &hf_lix2_ePSRANHandoverRequest, BER_CLASS_CON, 149, BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANHandoverRequest },
  { 150, &hf_lix2_mMERANTraceReport, BER_CLASS_CON, 150, BER_FLAGS_IMPLTAG, dissect_lix2_MMERANTraceReport },
  { 151, &hf_lix2_mMEUEServiceAccept, BER_CLASS_CON, 151, BER_FLAGS_IMPLTAG, dissect_lix2_MMEUEServiceAccept },
  { 152, &hf_lix2_nWDAFEventsSubscription, BER_CLASS_CON, 152, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFEventsSubscription },
  { 153, &hf_lix2_nWDAFEventsNotification, BER_CLASS_CON, 153, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFEventsNotification },
  { 154, &hf_lix2_nWDAFAnalyticsInfoQuery, BER_CLASS_CON, 154, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFAnalyticsInfoQuery },
  { 155, &hf_lix2_nWDAFRoamingAnalyticsSubscription, BER_CLASS_CON, 155, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFRoamingAnalyticsSubscription },
  { 156, &hf_lix2_nWDAFRoamingAnalyticsNotification, BER_CLASS_CON, 156, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFRoamingAnalyticsNotification },
  { 157, &hf_lix2_startOfInterceptForRegisteredRCSUser, BER_CLASS_CON, 157, BER_FLAGS_IMPLTAG, dissect_lix2_StartOfInterceptForRegisteredRCSUser },
  { 158, &hf_lix2_startOfInterceptWithEstablisedRCSSession, BER_CLASS_CON, 158, BER_FLAGS_IMPLTAG, dissect_lix2_StartOfInterceptWithEstablisedRCSSession },
  { 159, &hf_lix2_uDMProSeTargetIdentifierDeconcealment, BER_CLASS_CON, 159, BER_FLAGS_IMPLTAG, dissect_lix2_UDMProSeTargetIdentifierDeconcealment },
  { 160, &hf_lix2_uDMProSeTargetAuthentication, BER_CLASS_CON, 160, BER_FLAGS_IMPLTAG, dissect_lix2_UDMProSeTargetAuthentication },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_XIRIEvent(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 XIRIEvent_choice, hf_index, ett_lix2_XIRIEvent,
                                 NULL);

  return offset;
}


static const ber_sequence_t XIRIPayload_sequence[] = {
  { &hf_lix2_xIRIPayloadOID , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RELATIVE_OID },
  { &hf_lix2_event          , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_XIRIEvent },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_XIRIPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   XIRIPayload_sequence, hf_index, ett_lix2_XIRIPayload);

  return offset;
}


static const ber_sequence_t MDFCellSiteReport_sequence_of[1] = {
  { &hf_lix2_MDFCellSiteReport_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_CellInformation },
};

static int
dissect_lix2_MDFCellSiteReport(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      MDFCellSiteReport_sequence_of, hf_index, ett_lix2_MDFCellSiteReport);

  return offset;
}


static const value_string lix2_IRIEvent_vals[] = {
  {   1, "registration" },
  {   2, "deregistration" },
  {   3, "locationUpdate" },
  {   4, "startOfInterceptionWithRegisteredUE" },
  {   5, "unsuccessfulAMProcedure" },
  {   6, "pDUSessionEstablishment" },
  {   7, "pDUSessionModification" },
  {   8, "pDUSessionRelease" },
  {   9, "startOfInterceptionWithEstablishedPDUSession" },
  {  10, "unsuccessfulSMProcedure" },
  {  11, "servingSystemMessage" },
  {  12, "sMSMessage" },
  {  13, "lALSReport" },
  {  14, "pDHeaderReport" },
  {  15, "pDSummaryReport" },
  {  16, "mDFCellSiteReport" },
  {  17, "mMSSend" },
  {  18, "mMSSendByNonLocalTarget" },
  {  19, "mMSNotification" },
  {  20, "mMSSendToNonLocalTarget" },
  {  21, "mMSNotificationResponse" },
  {  22, "mMSRetrieval" },
  {  23, "mMSDeliveryAck" },
  {  24, "mMSForward" },
  {  25, "mMSDeleteFromRelay" },
  {  26, "mMSDeliveryReport" },
  {  27, "mMSDeliveryReportNonLocalTarget" },
  {  28, "mMSReadReport" },
  {  29, "mMSReadReportNonLocalTarget" },
  {  30, "mMSCancel" },
  {  31, "mMSMBoxStore" },
  {  32, "mMSMBoxUpload" },
  {  33, "mMSMBoxDelete" },
  {  34, "mMSMBoxViewRequest" },
  {  35, "mMSMBoxViewResponse" },
  {  36, "pTCRegistration" },
  {  37, "pTCSessionInitiation" },
  {  38, "pTCSessionAbandon" },
  {  39, "pTCSessionStart" },
  {  40, "pTCSessionEnd" },
  {  41, "pTCStartOfInterception" },
  {  42, "pTCPreEstablishedSession" },
  {  43, "pTCInstantPersonalAlert" },
  {  44, "pTCPartyJoin" },
  {  45, "pTCPartyDrop" },
  {  46, "pTCPartyHold" },
  {  47, "pTCMediaModification" },
  {  48, "pTCGroupAdvertisement" },
  {  49, "pTCFloorControl" },
  {  50, "pTCTargetPresence" },
  {  51, "pTCParticipantPresence" },
  {  52, "pTCListManagement" },
  {  53, "pTCAccessPolicy" },
  {  54, "subscriberRecordChangeMessage" },
  {  55, "cancelLocationMessage" },
  {  56, "sMSReport" },
  {  57, "sMFMAPDUSessionEstablishment" },
  {  58, "sMFMAPDUSessionModification" },
  {  59, "sMFMAPDUSessionRelease" },
  {  60, "startOfInterceptionWithEstablishedMAPDUSession" },
  {  61, "unsuccessfulMASMProcedure" },
  {  62, "aMFIdentifierAssociation" },
  {  63, "mMEIdentifierAssociation" },
  {  64, "sMFPDUtoMAPDUSessionModification" },
  {  65, "nEFPDUSessionEstablishment" },
  {  66, "nEFPDUSessionModification" },
  {  67, "nEFPDUSessionRelease" },
  {  68, "nEFUnsuccessfulProcedure" },
  {  69, "nEFStartOfInterceptionWithEstablishedPDUSession" },
  {  70, "nEFdeviceTrigger" },
  {  71, "nEFdeviceTriggerReplace" },
  {  72, "nEFdeviceTriggerCancellation" },
  {  73, "nEFdeviceTriggerReportNotify" },
  {  74, "nEFMSISDNLessMOSMS" },
  {  75, "nEFExpectedUEBehaviourUpdate" },
  {  76, "sCEFPDNConnectionEstablishment" },
  {  77, "sCEFPDNConnectionUpdate" },
  {  78, "sCEFPDNConnectionRelease" },
  {  79, "sCEFUnsuccessfulProcedure" },
  {  80, "sCEFStartOfInterceptionWithEstablishedPDNConnection" },
  {  81, "sCEFdeviceTrigger" },
  {  82, "sCEFdeviceTriggerReplace" },
  {  83, "sCEFdeviceTriggerCancellation" },
  {  84, "sCEFdeviceTriggerReportNotify" },
  {  85, "sCEFMSISDNLessMOSMS" },
  {  86, "sCEFCommunicationPatternUpdate" },
  {  87, "mMEAttach" },
  {  88, "mMEDetach" },
  {  89, "mMELocationUpdate" },
  {  90, "mMEStartOfInterceptionWithEPSAttachedUE" },
  {  91, "mMEUnsuccessfulProcedure" },
  {  92, "aAnFAnchorKeyRegister" },
  {  93, "aAnFKAKMAApplicationKeyGet" },
  {  94, "aAnFStartOfInterceptWithEstablishedAKMAKeyMaterial" },
  {  95, "aAnFAKMAContextRemovalRecord" },
  {  96, "aFAKMAApplicationKeyRefresh" },
  {  97, "aFStartOfInterceptWithEstablishedAKMAApplicationKey" },
  {  98, "aFAuxiliarySecurityParameterEstablishment" },
  {  99, "aFApplicationKeyRemoval" },
  { 102, "separatedLocationReporting" },
  { 103, "sTIRSHAKENSignatureGeneration" },
  { 104, "sTIRSHAKENSignatureValidation" },
  { 105, "iMSMessage" },
  { 106, "startOfInterceptionForActiveIMSSession" },
  { 107, "iMSCCUnavailable" },
  { 108, "uDMLocationInformationResult" },
  { 109, "uDMUEInformationResponse" },
  { 110, "uDMUEAuthenticationResponse" },
  { 111, "positioningInfoTransfer" },
  { 112, "mMEPositioningInfoTransfer" },
  { 113, "aMFRANHandoverCommand" },
  { 114, "aMFRANHandoverRequest" },
  { 115, "eESEECRegistration" },
  { 116, "eESEASDiscovery" },
  { 117, "eESEASDiscoverySubscription" },
  { 118, "eESEASDiscoveryNotification" },
  { 119, "eESAppContextRelocation" },
  { 120, "eESACRSubscription" },
  { 121, "eESACRNotification" },
  { 122, "eESEECContextRelocation" },
  { 123, "eESStartOfInterceptionWithRegisteredEEC" },
  { 124, "uDMStartOfInterceptionWithRegisteredTarget" },
  { 125, "fiveGMSAFServiceAccessInformation" },
  { 126, "fiveGMSAFConsumptionReporting" },
  { 127, "fiveGMSAFDynamicPolicyInvocation" },
  { 128, "fiveGMSAFMetricsReporting" },
  { 129, "fiveGMSAFNetworkAssistance" },
  { 130, "fiveGMSAFUnsuccessfulProcedure" },
  { 131, "fiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE" },
  { 132, "aMFUEConfigurationUpdate" },
  { 133, "hSSServingSystemMessage" },
  { 134, "hSSStartOfInterceptionWithRegisteredTarget" },
  { 135, "nEFAFSessionWithQoSProvision" },
  { 136, "nEFAFSessionWithQoSNotification" },
  { 137, "sCEFASSessionWithQoSProvision" },
  { 138, "sCEFASSessionWithQoSNotification" },
  { 139, "aMFRANTraceReport" },
  { 140, "rCSRegistration" },
  { 141, "rCSMessage" },
  { 142, "rCSCapabilityDiscovery" },
  { 143, "rCSSessionEstablishment" },
  { 144, "rCSSessionModification" },
  { 145, "rCSSessionRelease" },
  { 146, "aMFUEPolicyTransfer" },
  { 147, "aMFUEServiceAccept" },
  { 148, "ePSRANHandoverCommand" },
  { 149, "ePSRANHandoverRequest" },
  { 150, "mMERANTraceReport" },
  { 151, "mMEUEServiceAccept" },
  { 152, "nWDAFEventsSubscription" },
  { 153, "nWDAFEventsNotification" },
  { 154, "nWDAFAnalyticsInfoQuery" },
  { 155, "nWDAFRoamingAnalyticsSubscription" },
  { 156, "nWDAFRoamingAnalyticsNotification" },
  { 157, "startOfInterceptForRegisteredRCSUser" },
  { 158, "startOfInterceptWithEstablisedRCSSession" },
  { 159, "uDMProSeTargetIdentifierDeconcealment" },
  { 160, "uDMProSeTargetAuthentication" },
  { 0, NULL }
};

static const ber_choice_t IRIEvent_choice[] = {
  {   1, &hf_lix2_registration   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRegistration },
  {   2, &hf_lix2_deregistration , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_AMFDeregistration },
  {   3, &hf_lix2_locationUpdate , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_AMFLocationUpdate },
  {   4, &hf_lix2_startOfInterceptionWithRegisteredUE, BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_AMFStartOfInterceptionWithRegisteredUE },
  {   5, &hf_lix2_unsuccessfulAMProcedure, BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUnsuccessfulProcedure },
  {   6, &hf_lix2_pDUSessionEstablishment, BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_SMFPDUSessionEstablishment },
  {   7, &hf_lix2_pDUSessionModification, BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_SMFPDUSessionModification },
  {   8, &hf_lix2_pDUSessionRelease, BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_SMFPDUSessionRelease },
  {   9, &hf_lix2_startOfInterceptionWithEstablishedPDUSession, BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_SMFStartOfInterceptionWithEstablishedPDUSession },
  {  10, &hf_lix2_unsuccessfulSMProcedure, BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_SMFUnsuccessfulProcedure },
  {  11, &hf_lix2_servingSystemMessage, BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_UDMServingSystemMessage },
  {  12, &hf_lix2_sMSMessage     , BER_CLASS_CON, 12, BER_FLAGS_IMPLTAG, dissect_lix2_SMSMessage },
  {  13, &hf_lix2_lALSReport     , BER_CLASS_CON, 13, BER_FLAGS_IMPLTAG, dissect_lix2_LALSReport },
  {  14, &hf_lix2_pDHeaderReport , BER_CLASS_CON, 14, BER_FLAGS_IMPLTAG, dissect_lix2_PDHeaderReport },
  {  15, &hf_lix2_pDSummaryReport, BER_CLASS_CON, 15, BER_FLAGS_IMPLTAG, dissect_lix2_PDSummaryReport },
  {  16, &hf_lix2_mDFCellSiteReport, BER_CLASS_CON, 16, BER_FLAGS_IMPLTAG, dissect_lix2_MDFCellSiteReport },
  {  17, &hf_lix2_mMSSend        , BER_CLASS_CON, 17, BER_FLAGS_IMPLTAG, dissect_lix2_MMSSend },
  {  18, &hf_lix2_mMSSendByNonLocalTarget, BER_CLASS_CON, 18, BER_FLAGS_IMPLTAG, dissect_lix2_MMSSendByNonLocalTarget },
  {  19, &hf_lix2_mMSNotification, BER_CLASS_CON, 19, BER_FLAGS_IMPLTAG, dissect_lix2_MMSNotification },
  {  20, &hf_lix2_mMSSendToNonLocalTarget, BER_CLASS_CON, 20, BER_FLAGS_IMPLTAG, dissect_lix2_MMSSendToNonLocalTarget },
  {  21, &hf_lix2_mMSNotificationResponse, BER_CLASS_CON, 21, BER_FLAGS_IMPLTAG, dissect_lix2_MMSNotificationResponse },
  {  22, &hf_lix2_mMSRetrieval   , BER_CLASS_CON, 22, BER_FLAGS_IMPLTAG, dissect_lix2_MMSRetrieval },
  {  23, &hf_lix2_mMSDeliveryAck , BER_CLASS_CON, 23, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDeliveryAck },
  {  24, &hf_lix2_mMSForward     , BER_CLASS_CON, 24, BER_FLAGS_IMPLTAG, dissect_lix2_MMSForward },
  {  25, &hf_lix2_mMSDeleteFromRelay, BER_CLASS_CON, 25, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDeleteFromRelay },
  {  26, &hf_lix2_mMSDeliveryReport, BER_CLASS_CON, 26, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDeliveryReport },
  {  27, &hf_lix2_mMSDeliveryReportNonLocalTarget, BER_CLASS_CON, 27, BER_FLAGS_IMPLTAG, dissect_lix2_MMSDeliveryReportNonLocalTarget },
  {  28, &hf_lix2_mMSReadReport  , BER_CLASS_CON, 28, BER_FLAGS_IMPLTAG, dissect_lix2_MMSReadReport },
  {  29, &hf_lix2_mMSReadReportNonLocalTarget, BER_CLASS_CON, 29, BER_FLAGS_IMPLTAG, dissect_lix2_MMSReadReportNonLocalTarget },
  {  30, &hf_lix2_mMSCancel      , BER_CLASS_CON, 30, BER_FLAGS_IMPLTAG, dissect_lix2_MMSCancel },
  {  31, &hf_lix2_mMSMBoxStore   , BER_CLASS_CON, 31, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMBoxStore },
  {  32, &hf_lix2_mMSMBoxUpload  , BER_CLASS_CON, 32, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMBoxUpload },
  {  33, &hf_lix2_mMSMBoxDelete  , BER_CLASS_CON, 33, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMBoxDelete },
  {  34, &hf_lix2_mMSMBoxViewRequest, BER_CLASS_CON, 34, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMBoxViewRequest },
  {  35, &hf_lix2_mMSMBoxViewResponse, BER_CLASS_CON, 35, BER_FLAGS_IMPLTAG, dissect_lix2_MMSMBoxViewResponse },
  {  36, &hf_lix2_pTCRegistration, BER_CLASS_CON, 36, BER_FLAGS_IMPLTAG, dissect_lix2_PTCRegistration },
  {  37, &hf_lix2_pTCSessionInitiation, BER_CLASS_CON, 37, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionInitiation },
  {  38, &hf_lix2_pTCSessionAbandon, BER_CLASS_CON, 38, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionAbandon },
  {  39, &hf_lix2_pTCSessionStart, BER_CLASS_CON, 39, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionStart },
  {  40, &hf_lix2_pTCSessionEnd  , BER_CLASS_CON, 40, BER_FLAGS_IMPLTAG, dissect_lix2_PTCSessionEnd },
  {  41, &hf_lix2_pTCStartOfInterception, BER_CLASS_CON, 41, BER_FLAGS_IMPLTAG, dissect_lix2_PTCStartOfInterception },
  {  42, &hf_lix2_pTCPreEstablishedSession, BER_CLASS_CON, 42, BER_FLAGS_IMPLTAG, dissect_lix2_PTCPreEstablishedSession },
  {  43, &hf_lix2_pTCInstantPersonalAlert, BER_CLASS_CON, 43, BER_FLAGS_IMPLTAG, dissect_lix2_PTCInstantPersonalAlert },
  {  44, &hf_lix2_pTCPartyJoin   , BER_CLASS_CON, 44, BER_FLAGS_IMPLTAG, dissect_lix2_PTCPartyJoin },
  {  45, &hf_lix2_pTCPartyDrop   , BER_CLASS_CON, 45, BER_FLAGS_IMPLTAG, dissect_lix2_PTCPartyDrop },
  {  46, &hf_lix2_pTCPartyHold   , BER_CLASS_CON, 46, BER_FLAGS_IMPLTAG, dissect_lix2_PTCPartyHold },
  {  47, &hf_lix2_pTCMediaModification, BER_CLASS_CON, 47, BER_FLAGS_IMPLTAG, dissect_lix2_PTCMediaModification },
  {  48, &hf_lix2_pTCGroupAdvertisement, BER_CLASS_CON, 48, BER_FLAGS_IMPLTAG, dissect_lix2_PTCGroupAdvertisement },
  {  49, &hf_lix2_pTCFloorControl, BER_CLASS_CON, 49, BER_FLAGS_IMPLTAG, dissect_lix2_PTCFloorControl },
  {  50, &hf_lix2_pTCTargetPresence, BER_CLASS_CON, 50, BER_FLAGS_IMPLTAG, dissect_lix2_PTCTargetPresence },
  {  51, &hf_lix2_pTCParticipantPresence, BER_CLASS_CON, 51, BER_FLAGS_IMPLTAG, dissect_lix2_PTCParticipantPresence },
  {  52, &hf_lix2_pTCListManagement, BER_CLASS_CON, 52, BER_FLAGS_IMPLTAG, dissect_lix2_PTCListManagement },
  {  53, &hf_lix2_pTCAccessPolicy, BER_CLASS_CON, 53, BER_FLAGS_IMPLTAG, dissect_lix2_PTCAccessPolicy },
  {  54, &hf_lix2_subscriberRecordChangeMessage, BER_CLASS_CON, 54, BER_FLAGS_IMPLTAG, dissect_lix2_UDMSubscriberRecordChangeMessage },
  {  55, &hf_lix2_cancelLocationMessage, BER_CLASS_CON, 55, BER_FLAGS_IMPLTAG, dissect_lix2_UDMCancelLocationMessage },
  {  56, &hf_lix2_sMSReport      , BER_CLASS_CON, 56, BER_FLAGS_IMPLTAG, dissect_lix2_SMSReport },
  {  57, &hf_lix2_sMFMAPDUSessionEstablishment, BER_CLASS_CON, 57, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAPDUSessionEstablishment },
  {  58, &hf_lix2_sMFMAPDUSessionModification, BER_CLASS_CON, 58, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAPDUSessionModification },
  {  59, &hf_lix2_sMFMAPDUSessionRelease, BER_CLASS_CON, 59, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAPDUSessionRelease },
  {  60, &hf_lix2_startOfInterceptionWithEstablishedMAPDUSession, BER_CLASS_CON, 60, BER_FLAGS_IMPLTAG, dissect_lix2_SMFStartOfInterceptionWithEstablishedMAPDUSession },
  {  61, &hf_lix2_unsuccessfulMASMProcedure, BER_CLASS_CON, 61, BER_FLAGS_IMPLTAG, dissect_lix2_SMFMAUnsuccessfulProcedure },
  {  62, &hf_lix2_aMFIdentifierAssociation, BER_CLASS_CON, 62, BER_FLAGS_IMPLTAG, dissect_lix2_AMFIdentifierAssociation },
  {  63, &hf_lix2_mMEIdentifierAssociation, BER_CLASS_CON, 63, BER_FLAGS_IMPLTAG, dissect_lix2_MMEIdentifierAssociation },
  {  64, &hf_lix2_sMFPDUtoMAPDUSessionModification, BER_CLASS_CON, 64, BER_FLAGS_IMPLTAG, dissect_lix2_SMFPDUtoMAPDUSessionModification },
  {  65, &hf_lix2_nEFPDUSessionEstablishment, BER_CLASS_CON, 65, BER_FLAGS_IMPLTAG, dissect_lix2_NEFPDUSessionEstablishment },
  {  66, &hf_lix2_nEFPDUSessionModification, BER_CLASS_CON, 66, BER_FLAGS_IMPLTAG, dissect_lix2_NEFPDUSessionModification },
  {  67, &hf_lix2_nEFPDUSessionRelease, BER_CLASS_CON, 67, BER_FLAGS_IMPLTAG, dissect_lix2_NEFPDUSessionRelease },
  {  68, &hf_lix2_nEFUnsuccessfulProcedure, BER_CLASS_CON, 68, BER_FLAGS_IMPLTAG, dissect_lix2_NEFUnsuccessfulProcedure },
  {  69, &hf_lix2_nEFStartOfInterceptionWithEstablishedPDUSession, BER_CLASS_CON, 69, BER_FLAGS_IMPLTAG, dissect_lix2_NEFStartOfInterceptionWithEstablishedPDUSession },
  {  70, &hf_lix2_nEFdeviceTrigger, BER_CLASS_CON, 70, BER_FLAGS_IMPLTAG, dissect_lix2_NEFDeviceTrigger },
  {  71, &hf_lix2_nEFdeviceTriggerReplace, BER_CLASS_CON, 71, BER_FLAGS_IMPLTAG, dissect_lix2_NEFDeviceTriggerReplace },
  {  72, &hf_lix2_nEFdeviceTriggerCancellation, BER_CLASS_CON, 72, BER_FLAGS_IMPLTAG, dissect_lix2_NEFDeviceTriggerCancellation },
  {  73, &hf_lix2_nEFdeviceTriggerReportNotify, BER_CLASS_CON, 73, BER_FLAGS_IMPLTAG, dissect_lix2_NEFDeviceTriggerReportNotify },
  {  74, &hf_lix2_nEFMSISDNLessMOSMS, BER_CLASS_CON, 74, BER_FLAGS_IMPLTAG, dissect_lix2_NEFMSISDNLessMOSMS },
  {  75, &hf_lix2_nEFExpectedUEBehaviourUpdate, BER_CLASS_CON, 75, BER_FLAGS_IMPLTAG, dissect_lix2_NEFExpectedUEBehaviourUpdate },
  {  76, &hf_lix2_sCEFPDNConnectionEstablishment, BER_CLASS_CON, 76, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFPDNConnectionEstablishment },
  {  77, &hf_lix2_sCEFPDNConnectionUpdate, BER_CLASS_CON, 77, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFPDNConnectionUpdate },
  {  78, &hf_lix2_sCEFPDNConnectionRelease, BER_CLASS_CON, 78, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFPDNConnectionRelease },
  {  79, &hf_lix2_sCEFUnsuccessfulProcedure, BER_CLASS_CON, 79, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFUnsuccessfulProcedure },
  {  80, &hf_lix2_sCEFStartOfInterceptionWithEstablishedPDNConnection, BER_CLASS_CON, 80, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFStartOfInterceptionWithEstablishedPDNConnection },
  {  81, &hf_lix2_sCEFdeviceTrigger, BER_CLASS_CON, 81, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFDeviceTrigger },
  {  82, &hf_lix2_sCEFdeviceTriggerReplace, BER_CLASS_CON, 82, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFDeviceTriggerReplace },
  {  83, &hf_lix2_sCEFdeviceTriggerCancellation, BER_CLASS_CON, 83, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFDeviceTriggerCancellation },
  {  84, &hf_lix2_sCEFdeviceTriggerReportNotify, BER_CLASS_CON, 84, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFDeviceTriggerReportNotify },
  {  85, &hf_lix2_sCEFMSISDNLessMOSMS, BER_CLASS_CON, 85, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFMSISDNLessMOSMS },
  {  86, &hf_lix2_sCEFCommunicationPatternUpdate, BER_CLASS_CON, 86, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFCommunicationPatternUpdate },
  {  87, &hf_lix2_mMEAttach      , BER_CLASS_CON, 87, BER_FLAGS_IMPLTAG, dissect_lix2_MMEAttach },
  {  88, &hf_lix2_mMEDetach      , BER_CLASS_CON, 88, BER_FLAGS_IMPLTAG, dissect_lix2_MMEDetach },
  {  89, &hf_lix2_mMELocationUpdate, BER_CLASS_CON, 89, BER_FLAGS_IMPLTAG, dissect_lix2_MMELocationUpdate },
  {  90, &hf_lix2_mMEStartOfInterceptionWithEPSAttachedUE, BER_CLASS_CON, 90, BER_FLAGS_IMPLTAG, dissect_lix2_MMEStartOfInterceptionWithEPSAttachedUE },
  {  91, &hf_lix2_mMEUnsuccessfulProcedure, BER_CLASS_CON, 91, BER_FLAGS_IMPLTAG, dissect_lix2_MMEUnsuccessfulProcedure },
  {  92, &hf_lix2_aAnFAnchorKeyRegister, BER_CLASS_CON, 92, BER_FLAGS_IMPLTAG, dissect_lix2_AAnFAnchorKeyRegister },
  {  93, &hf_lix2_aAnFKAKMAApplicationKeyGet, BER_CLASS_CON, 93, BER_FLAGS_IMPLTAG, dissect_lix2_AAnFKAKMAApplicationKeyGet },
  {  94, &hf_lix2_aAnFStartOfInterceptWithEstablishedAKMAKeyMaterial, BER_CLASS_CON, 94, BER_FLAGS_IMPLTAG, dissect_lix2_AAnFStartOfInterceptWithEstablishedAKMAKeyMaterial },
  {  95, &hf_lix2_aAnFAKMAContextRemovalRecord, BER_CLASS_CON, 95, BER_FLAGS_IMPLTAG, dissect_lix2_AAnFAKMAContextRemovalRecord },
  {  96, &hf_lix2_aFAKMAApplicationKeyRefresh, BER_CLASS_CON, 96, BER_FLAGS_IMPLTAG, dissect_lix2_AFAKMAApplicationKeyRefresh },
  {  97, &hf_lix2_aFStartOfInterceptWithEstablishedAKMAApplicationKey, BER_CLASS_CON, 97, BER_FLAGS_IMPLTAG, dissect_lix2_AFStartOfInterceptWithEstablishedAKMAApplicationKey },
  {  98, &hf_lix2_aFAuxiliarySecurityParameterEstablishment, BER_CLASS_CON, 98, BER_FLAGS_IMPLTAG, dissect_lix2_AFAuxiliarySecurityParameterEstablishment },
  {  99, &hf_lix2_aFApplicationKeyRemoval, BER_CLASS_CON, 99, BER_FLAGS_IMPLTAG, dissect_lix2_AFApplicationKeyRemoval },
  { 102, &hf_lix2_separatedLocationReporting, BER_CLASS_CON, 102, BER_FLAGS_IMPLTAG, dissect_lix2_SeparatedLocationReporting },
  { 103, &hf_lix2_sTIRSHAKENSignatureGeneration, BER_CLASS_CON, 103, BER_FLAGS_IMPLTAG, dissect_lix2_STIRSHAKENSignatureGeneration },
  { 104, &hf_lix2_sTIRSHAKENSignatureValidation, BER_CLASS_CON, 104, BER_FLAGS_IMPLTAG, dissect_lix2_STIRSHAKENSignatureValidation },
  { 105, &hf_lix2_iMSMessage     , BER_CLASS_CON, 105, BER_FLAGS_IMPLTAG, dissect_lix2_IMSMessage },
  { 106, &hf_lix2_startOfInterceptionForActiveIMSSession, BER_CLASS_CON, 106, BER_FLAGS_IMPLTAG, dissect_lix2_StartOfInterceptionForActiveIMSSession },
  { 107, &hf_lix2_iMSCCUnavailable, BER_CLASS_CON, 107, BER_FLAGS_IMPLTAG, dissect_lix2_IMSCCUnavailable },
  { 108, &hf_lix2_uDMLocationInformationResult, BER_CLASS_CON, 108, BER_FLAGS_IMPLTAG, dissect_lix2_UDMLocationInformationResult },
  { 109, &hf_lix2_uDMUEInformationResponse, BER_CLASS_CON, 109, BER_FLAGS_IMPLTAG, dissect_lix2_UDMUEInformationResponse },
  { 110, &hf_lix2_uDMUEAuthenticationResponse, BER_CLASS_CON, 110, BER_FLAGS_IMPLTAG, dissect_lix2_UDMUEAuthenticationResponse },
  { 111, &hf_lix2_positioningInfoTransfer, BER_CLASS_CON, 111, BER_FLAGS_IMPLTAG, dissect_lix2_AMFPositioningInfoTransfer },
  { 112, &hf_lix2_mMEPositioningInfoTransfer, BER_CLASS_CON, 112, BER_FLAGS_IMPLTAG, dissect_lix2_MMEPositioningInfoTransfer },
  { 113, &hf_lix2_aMFRANHandoverCommand, BER_CLASS_CON, 113, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRANHandoverCommand },
  { 114, &hf_lix2_aMFRANHandoverRequest, BER_CLASS_CON, 114, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRANHandoverRequest },
  { 115, &hf_lix2_eESEECRegistration, BER_CLASS_CON, 115, BER_FLAGS_IMPLTAG, dissect_lix2_EESEECRegistration },
  { 116, &hf_lix2_eESEASDiscovery, BER_CLASS_CON, 116, BER_FLAGS_IMPLTAG, dissect_lix2_EESEASDiscovery },
  { 117, &hf_lix2_eESEASDiscoverySubscription, BER_CLASS_CON, 117, BER_FLAGS_IMPLTAG, dissect_lix2_EESEASDiscoverySubscription },
  { 118, &hf_lix2_eESEASDiscoveryNotification, BER_CLASS_CON, 118, BER_FLAGS_IMPLTAG, dissect_lix2_EESEASDiscoveryNotification },
  { 119, &hf_lix2_eESAppContextRelocation, BER_CLASS_CON, 119, BER_FLAGS_IMPLTAG, dissect_lix2_EESAppContextRelocation },
  { 120, &hf_lix2_eESACRSubscription, BER_CLASS_CON, 120, BER_FLAGS_IMPLTAG, dissect_lix2_EESACRSubscription },
  { 121, &hf_lix2_eESACRNotification, BER_CLASS_CON, 121, BER_FLAGS_IMPLTAG, dissect_lix2_EESACRNotification },
  { 122, &hf_lix2_eESEECContextRelocation, BER_CLASS_CON, 122, BER_FLAGS_IMPLTAG, dissect_lix2_EESEECContextRelocation },
  { 123, &hf_lix2_eESStartOfInterceptionWithRegisteredEEC, BER_CLASS_CON, 123, BER_FLAGS_IMPLTAG, dissect_lix2_EESStartOfInterceptionWithRegisteredEEC },
  { 124, &hf_lix2_uDMStartOfInterceptionWithRegisteredTarget, BER_CLASS_CON, 124, BER_FLAGS_IMPLTAG, dissect_lix2_UDMStartOfInterceptionWithRegisteredTarget },
  { 125, &hf_lix2_fiveGMSAFServiceAccessInformation, BER_CLASS_CON, 125, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFServiceAccessInformation },
  { 126, &hf_lix2_fiveGMSAFConsumptionReporting, BER_CLASS_CON, 126, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFConsumptionReporting },
  { 127, &hf_lix2_fiveGMSAFDynamicPolicyInvocation, BER_CLASS_CON, 127, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFDynamicPolicyInvocation },
  { 128, &hf_lix2_fiveGMSAFMetricsReporting, BER_CLASS_CON, 128, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFMetricsReporting },
  { 129, &hf_lix2_fiveGMSAFNetworkAssistance, BER_CLASS_CON, 129, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFNetworkAssistance },
  { 130, &hf_lix2_fiveGMSAFUnsuccessfulProcedure, BER_CLASS_CON, 130, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFUnsuccessfulProcedure },
  { 131, &hf_lix2_fiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE, BER_CLASS_CON, 131, BER_FLAGS_IMPLTAG, dissect_lix2_FiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE },
  { 132, &hf_lix2_aMFUEConfigurationUpdate, BER_CLASS_CON, 132, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUEConfigurationUpdate },
  { 133, &hf_lix2_hSSServingSystemMessage, BER_CLASS_CON, 133, BER_FLAGS_IMPLTAG, dissect_lix2_HSSServingSystemMessage },
  { 134, &hf_lix2_hSSStartOfInterceptionWithRegisteredTarget, BER_CLASS_CON, 134, BER_FLAGS_IMPLTAG, dissect_lix2_HSSStartOfInterceptionWithRegisteredTarget },
  { 135, &hf_lix2_nEFAFSessionWithQoSProvision, BER_CLASS_CON, 135, BER_FLAGS_IMPLTAG, dissect_lix2_NEFAFSessionWithQoSProvision },
  { 136, &hf_lix2_nEFAFSessionWithQoSNotification, BER_CLASS_CON, 136, BER_FLAGS_IMPLTAG, dissect_lix2_NEFAFSessionWithQoSNotification },
  { 137, &hf_lix2_sCEFASSessionWithQoSProvision, BER_CLASS_CON, 137, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFASSessionWithQoSProvision },
  { 138, &hf_lix2_sCEFASSessionWithQoSNotification, BER_CLASS_CON, 138, BER_FLAGS_IMPLTAG, dissect_lix2_SCEFASSessionWithQoSNotification },
  { 139, &hf_lix2_aMFRANTraceReport, BER_CLASS_CON, 139, BER_FLAGS_IMPLTAG, dissect_lix2_AMFRANTraceReport },
  { 140, &hf_lix2_rCSRegistration, BER_CLASS_CON, 140, BER_FLAGS_IMPLTAG, dissect_lix2_RCSRegistration },
  { 141, &hf_lix2_rCSMessage     , BER_CLASS_CON, 141, BER_FLAGS_IMPLTAG, dissect_lix2_RCSMessage },
  { 142, &hf_lix2_rCSCapabilityDiscovery, BER_CLASS_CON, 142, BER_FLAGS_IMPLTAG, dissect_lix2_RCSCapabilityDiscovery },
  { 143, &hf_lix2_rCSSessionEstablishment, BER_CLASS_CON, 143, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionEstablishment },
  { 144, &hf_lix2_rCSSessionModification, BER_CLASS_CON, 144, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionModification },
  { 145, &hf_lix2_rCSSessionRelease, BER_CLASS_CON, 145, BER_FLAGS_IMPLTAG, dissect_lix2_RCSSessionRelease },
  { 146, &hf_lix2_aMFUEPolicyTransfer, BER_CLASS_CON, 146, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUEPolicyTransfer },
  { 147, &hf_lix2_aMFUEServiceAccept, BER_CLASS_CON, 147, BER_FLAGS_IMPLTAG, dissect_lix2_AMFUEServiceAccept },
  { 148, &hf_lix2_ePSRANHandoverCommand, BER_CLASS_CON, 148, BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANHandoverCommand },
  { 149, &hf_lix2_ePSRANHandoverRequest, BER_CLASS_CON, 149, BER_FLAGS_IMPLTAG, dissect_lix2_EPSRANHandoverRequest },
  { 150, &hf_lix2_mMERANTraceReport, BER_CLASS_CON, 150, BER_FLAGS_IMPLTAG, dissect_lix2_MMERANTraceReport },
  { 151, &hf_lix2_mMEUEServiceAccept, BER_CLASS_CON, 151, BER_FLAGS_IMPLTAG, dissect_lix2_MMEUEServiceAccept },
  { 152, &hf_lix2_nWDAFEventsSubscription, BER_CLASS_CON, 152, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFEventsSubscription },
  { 153, &hf_lix2_nWDAFEventsNotification, BER_CLASS_CON, 153, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFEventsNotification },
  { 154, &hf_lix2_nWDAFAnalyticsInfoQuery, BER_CLASS_CON, 154, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFAnalyticsInfoQuery },
  { 155, &hf_lix2_nWDAFRoamingAnalyticsSubscription, BER_CLASS_CON, 155, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFRoamingAnalyticsSubscription },
  { 156, &hf_lix2_nWDAFRoamingAnalyticsNotification, BER_CLASS_CON, 156, BER_FLAGS_IMPLTAG, dissect_lix2_NWDAFRoamingAnalyticsNotification },
  { 157, &hf_lix2_startOfInterceptForRegisteredRCSUser, BER_CLASS_CON, 157, BER_FLAGS_IMPLTAG, dissect_lix2_StartOfInterceptForRegisteredRCSUser },
  { 158, &hf_lix2_startOfInterceptWithEstablisedRCSSession, BER_CLASS_CON, 158, BER_FLAGS_IMPLTAG, dissect_lix2_StartOfInterceptWithEstablisedRCSSession },
  { 159, &hf_lix2_uDMProSeTargetIdentifierDeconcealment, BER_CLASS_CON, 159, BER_FLAGS_IMPLTAG, dissect_lix2_UDMProSeTargetIdentifierDeconcealment },
  { 160, &hf_lix2_uDMProSeTargetAuthentication, BER_CLASS_CON, 160, BER_FLAGS_IMPLTAG, dissect_lix2_UDMProSeTargetAuthentication },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IRIEvent(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 IRIEvent_choice, hf_index, ett_lix2_IRIEvent,
                                 NULL);

  return offset;
}


static const value_string lix2_TargetIdentifier_vals[] = {
  {   1, "sUPI" },
  {   2, "iMSI" },
  {   3, "pEI" },
  {   4, "iMEI" },
  {   5, "gPSI" },
  {   6, "mSISDN" },
  {   7, "nAI" },
  {   8, "iPv4Address" },
  {   9, "iPv6Address" },
  {  10, "ethernetAddress" },
  {  11, "iMPU" },
  {  12, "iMPI" },
  {  13, "e164Number" },
  {  14, "emailAddress" },
  {  15, "mCPTTID" },
  {  16, "instanceIdentifierURN" },
  {  17, "pTCChatGroupID" },
  { 0, NULL }
};

static const ber_choice_t TargetIdentifier_choice[] = {
  {   1, &hf_lix2_sUPI           , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_SUPI },
  {   2, &hf_lix2_iMSI           , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_IMSI },
  {   3, &hf_lix2_pEI            , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_PEI },
  {   4, &hf_lix2_iMEI           , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_IMEI },
  {   5, &hf_lix2_gPSI           , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_GPSI },
  {   6, &hf_lix2_mSISDN         , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_MSISDN },
  {   7, &hf_lix2_nAI            , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_NAI },
  {   8, &hf_lix2_iPv4Address    , BER_CLASS_CON, 8, BER_FLAGS_IMPLTAG, dissect_lix2_IPv4Address },
  {   9, &hf_lix2_iPv6Address    , BER_CLASS_CON, 9, BER_FLAGS_IMPLTAG, dissect_lix2_IPv6Address },
  {  10, &hf_lix2_ethernetAddress, BER_CLASS_CON, 10, BER_FLAGS_IMPLTAG, dissect_lix2_MACAddress },
  {  11, &hf_lix2_iMPU           , BER_CLASS_CON, 11, BER_FLAGS_IMPLTAG, dissect_lix2_IMPU },
  {  12, &hf_lix2_iMPI           , BER_CLASS_CON, 12, BER_FLAGS_IMPLTAG, dissect_lix2_IMPI },
  {  13, &hf_lix2_e164Number     , BER_CLASS_CON, 13, BER_FLAGS_IMPLTAG, dissect_lix2_E164Number },
  {  14, &hf_lix2_emailAddress   , BER_CLASS_CON, 14, BER_FLAGS_IMPLTAG, dissect_lix2_EmailAddress },
  {  15, &hf_lix2_mCPTTID        , BER_CLASS_CON, 15, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  {  16, &hf_lix2_instanceIdentifierURN, BER_CLASS_CON, 16, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  {  17, &hf_lix2_pTCChatGroupID , BER_CLASS_CON, 17, BER_FLAGS_IMPLTAG, dissect_lix2_PTCChatGroupID },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_TargetIdentifier(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 TargetIdentifier_choice, hf_index, ett_lix2_TargetIdentifier,
                                 NULL);

  return offset;
}


static const value_string lix2_TargetIdentifierProvenance_vals[] = {
  {   1, "lEAProvided" },
  {   2, "observed" },
  {   3, "matchedOn" },
  {   4, "other" },
  { 0, NULL }
};


static int
dissect_lix2_TargetIdentifierProvenance(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t IRITargetIdentifier_sequence[] = {
  { &hf_lix2_identifier     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_TargetIdentifier },
  { &hf_lix2_provenance     , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_TargetIdentifierProvenance },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IRITargetIdentifier(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   IRITargetIdentifier_sequence, hf_index, ett_lix2_IRITargetIdentifier);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_IRITargetIdentifier_sequence_of[1] = {
  { &hf_lix2_targetIdentifiers_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_IRITargetIdentifier },
};

static int
dissect_lix2_SEQUENCE_OF_IRITargetIdentifier(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_IRITargetIdentifier_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_IRITargetIdentifier);

  return offset;
}


static const value_string lix2_MediatedFromIndicator_vals[] = {
  {   1, "xIRIRelativeOID" },
  { 0, NULL }
};

static const ber_choice_t MediatedFromIndicator_choice[] = {
  {   1, &hf_lix2_xIRIRelativeOID, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RELATIVE_OID },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MediatedFromIndicator(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 MediatedFromIndicator_choice, hf_index, ett_lix2_MediatedFromIndicator,
                                 NULL);

  return offset;
}


static const ber_sequence_t IRIPayload_sequence[] = {
  { &hf_lix2_iRIPayloadOID  , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RELATIVE_OID },
  { &hf_lix2_event_01       , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IRIEvent },
  { &hf_lix2_targetIdentifiers, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_IRITargetIdentifier },
  { &hf_lix2_mediatedFromIndicator, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_MediatedFromIndicator },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IRIPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   IRIPayload_sequence, hf_index, ett_lix2_IRIPayload);

  return offset;
}



static int
dissect_lix2_UPFCCPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const value_string lix2_UPFCCPDUPayload_vals[] = {
  {   1, "uPFIPCC" },
  {   2, "uPFEthernetCC" },
  {   3, "uPFUnstructuredCC" },
  { 0, NULL }
};

static const ber_choice_t UPFCCPDUPayload_choice[] = {
  {   1, &hf_lix2_uPFIPCC        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  {   2, &hf_lix2_uPFEthernetCC  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  {   3, &hf_lix2_uPFUnstructuredCC, BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_UPFCCPDUPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 UPFCCPDUPayload_choice, hf_index, ett_lix2_UPFCCPDUPayload,
                                 NULL);

  return offset;
}


static const ber_sequence_t ExtendedUPFCCPDU_sequence[] = {
  { &hf_lix2_payload        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_UPFCCPDUPayload },
  { &hf_lix2_qFI            , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_QFI },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_ExtendedUPFCCPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   ExtendedUPFCCPDU_sequence, hf_index, ett_lix2_ExtendedUPFCCPDU);

  return offset;
}


static const ber_sequence_t MMSCCPDU_sequence[] = {
  { &hf_lix2_version        , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_MMSVersion },
  { &hf_lix2_transactionID  , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_mMSContent     , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSCCPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSCCPDU_sequence, hf_index, ett_lix2_MMSCCPDU);

  return offset;
}



static int
dissect_lix2_NIDDCCPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_PTCCCPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}



static int
dissect_lix2_IMSCCPDUPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_octet_string(implicit_tag, actx, tree, tvb, offset, hf_index,
                                       NULL);

  return offset;
}


static const ber_sequence_t IMSCCPDU_sequence[] = {
  { &hf_lix2_payload_02     , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_IMSCCPDUPayload },
  { &hf_lix2_sDPInfo        , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_OCTET_STRING },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_IMSCCPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   IMSCCPDU_sequence, hf_index, ett_lix2_IMSCCPDU);

  return offset;
}


static const value_string lix2_RCSCCPDU_vals[] = {
  {   1, "encapsulatedRCSPayload" },
  { 0, NULL }
};

static const ber_choice_t RCSCCPDU_choice[] = {
  {   1, &hf_lix2_encapsulatedRCSPayload, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_EncapsulatedRCSPayload },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_RCSCCPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 RCSCCPDU_choice, hf_index, ett_lix2_RCSCCPDU,
                                 NULL);

  return offset;
}


static const value_string lix2_CCPDU_vals[] = {
  {   1, "uPFCCPDU" },
  {   2, "extendedUPFCCPDU" },
  {   3, "mMSCCPDU" },
  {   4, "nIDDCCPDU" },
  {   5, "pTCCCPDU" },
  {   6, "iMSCCPDU" },
  {   7, "rCSCCPDU" },
  { 0, NULL }
};

static const ber_choice_t CCPDU_choice[] = {
  {   1, &hf_lix2_uPFCCPDU       , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UPFCCPDU },
  {   2, &hf_lix2_extendedUPFCCPDU, BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG, dissect_lix2_ExtendedUPFCCPDU },
  {   3, &hf_lix2_mMSCCPDU       , BER_CLASS_CON, 3, BER_FLAGS_IMPLTAG, dissect_lix2_MMSCCPDU },
  {   4, &hf_lix2_nIDDCCPDU      , BER_CLASS_CON, 4, BER_FLAGS_IMPLTAG, dissect_lix2_NIDDCCPDU },
  {   5, &hf_lix2_pTCCCPDU       , BER_CLASS_CON, 5, BER_FLAGS_IMPLTAG, dissect_lix2_PTCCCPDU },
  {   6, &hf_lix2_iMSCCPDU       , BER_CLASS_CON, 6, BER_FLAGS_IMPLTAG, dissect_lix2_IMSCCPDU },
  {   7, &hf_lix2_rCSCCPDU       , BER_CLASS_CON, 7, BER_FLAGS_IMPLTAG, dissect_lix2_RCSCCPDU },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_CCPDU(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 CCPDU_choice, hf_index, ett_lix2_CCPDU,
                                 NULL);

  return offset;
}


static const ber_sequence_t CCPayload_sequence[] = {
  { &hf_lix2_cCPayloadOID   , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RELATIVE_OID },
  { &hf_lix2_pDU            , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_CCPDU },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_CCPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   CCPayload_sequence, hf_index, ett_lix2_CCPayload);

  return offset;
}


static const value_string lix2_LINotificationType_vals[] = {
  {   1, "activation" },
  {   2, "deactivation" },
  {   3, "modification" },
  { 0, NULL }
};


static int
dissect_lix2_LINotificationType(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t LIAppliedDeliveryInformation_sequence[] = {
  { &hf_lix2_hI2DeliveryIPAddress, BER_CLASS_CON, 1, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_hI2DeliveryPortNumber, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { &hf_lix2_hI3DeliveryIPAddress, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_IPAddress },
  { &hf_lix2_hI3DeliveryPortNumber, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_PortNumber },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LIAppliedDeliveryInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LIAppliedDeliveryInformation_sequence, hf_index, ett_lix2_LIAppliedDeliveryInformation);

  return offset;
}


static const ber_sequence_t SEQUENCE_OF_LIAppliedDeliveryInformation_sequence_of[1] = {
  { &hf_lix2_appliedDeliveryInformation_item, BER_CLASS_UNI, BER_UNI_TAG_SEQUENCE, BER_FLAGS_NOOWNTAG, dissect_lix2_LIAppliedDeliveryInformation },
};

static int
dissect_lix2_SEQUENCE_OF_LIAppliedDeliveryInformation(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence_of(implicit_tag, actx, tree, tvb, offset,
                                      SEQUENCE_OF_LIAppliedDeliveryInformation_sequence_of, hf_index, ett_lix2_SEQUENCE_OF_LIAppliedDeliveryInformation);

  return offset;
}


static const ber_sequence_t LINotification_sequence[] = {
  { &hf_lix2_notificationType, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_LINotificationType },
  { &hf_lix2_appliedTargetID, BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_TargetIdentifier },
  { &hf_lix2_appliedDeliveryInformation, BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_SEQUENCE_OF_LIAppliedDeliveryInformation },
  { &hf_lix2_appliedStartTime, BER_CLASS_CON, 4, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_appliedEndTime , BER_CLASS_CON, 5, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_Timestamp },
  { &hf_lix2_appliedTargetIsLocal, BER_CLASS_CON, 6, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { &hf_lix2_appliedTargetIsNonLocal, BER_CLASS_CON, 7, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_BOOLEAN },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LINotification(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LINotification_sequence, hf_index, ett_lix2_LINotification);

  return offset;
}


static const value_string lix2_LINotificationMessage_vals[] = {
  {   1, "lINotification" },
  { 0, NULL }
};

static const ber_choice_t LINotificationMessage_choice[] = {
  {   1, &hf_lix2_lINotification , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_LINotification },
  { 0, NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LINotificationMessage(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_choice(actx, tree, tvb, offset,
                                 LINotificationMessage_choice, hf_index, ett_lix2_LINotificationMessage,
                                 NULL);

  return offset;
}


static const ber_sequence_t LINotificationPayload_sequence[] = {
  { &hf_lix2_lINotificationPayloadOID, BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_RELATIVE_OID },
  { &hf_lix2_notification   , BER_CLASS_CON, 2, BER_FLAGS_IMPLTAG|BER_FLAGS_NOTCHKTAG, dissect_lix2_LINotificationMessage },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_LINotificationPayload(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   LINotificationPayload_sequence, hf_index, ett_lix2_LINotificationPayload);

  return offset;
}


static const value_string lix2_MMSCancelStatus_vals[] = {
  {   1, "cancelRequestSuccessfullyReceived" },
  {   2, "cancelRequestCorrupted" },
  { 0, NULL }
};


static int
dissect_lix2_MMSCancelStatus(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_integer(implicit_tag, actx, tree, tvb, offset, hf_index,
                                  NULL);

  return offset;
}


static const ber_sequence_t MMSElementDescriptor_sequence[] = {
  { &hf_lix2_reference      , BER_CLASS_CON, 1, BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_parameter      , BER_CLASS_CON, 2, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { &hf_lix2_value_01       , BER_CLASS_CON, 3, BER_FLAGS_OPTIONAL|BER_FLAGS_IMPLTAG, dissect_lix2_UTF8String },
  { NULL, 0, 0, 0, NULL }
};

static int
dissect_lix2_MMSElementDescriptor(bool implicit_tag _U_, tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_ber_sequence(implicit_tag, actx, tree, tvb, offset,
                                   MMSElementDescriptor_sequence, hf_index, ett_lix2_MMSElementDescriptor);

  return offset;
}

/*--- PDUs ---*/

static int dissect_XIRIPayload_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_) {
  int offset = 0;
  asn1_ctx_t asn1_ctx;
  asn1_ctx_init(&asn1_ctx, ASN1_ENC_BER, true, pinfo);
  offset = dissect_lix2_XIRIPayload(false, tvb, offset, &asn1_ctx, tree, hf_lix2_XIRIPayload_PDU);
  return offset;
}


/*--- proto_register_lix2 -------------------------------------------*/
void proto_register_lix2(void) {

  /* List of fields */
  static hf_register_info hf[] = {
    { &hf_lix2_XIRIPayload_PDU,
      { "XIRIPayload", "lix2.XIRIPayload_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_xIRIPayloadOID,
      { "xIRIPayloadOID", "lix2.xIRIPayloadOID",
        FT_REL_OID, BASE_NONE, NULL, 0,
        "RELATIVE_OID", HFILL }},
    { &hf_lix2_event,
      { "event", "lix2.event",
        FT_UINT32, BASE_DEC, VALS(lix2_XIRIEvent_vals), 0,
        "XIRIEvent", HFILL }},
    { &hf_lix2_registration,
      { "registration", "lix2.registration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AMFRegistration", HFILL }},
    { &hf_lix2_deregistration,
      { "deregistration", "lix2.deregistration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AMFDeregistration", HFILL }},
    { &hf_lix2_locationUpdate,
      { "locationUpdate", "lix2.locationUpdate_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AMFLocationUpdate", HFILL }},
    { &hf_lix2_startOfInterceptionWithRegisteredUE,
      { "startOfInterceptionWithRegisteredUE", "lix2.startOfInterceptionWithRegisteredUE_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AMFStartOfInterceptionWithRegisteredUE", HFILL }},
    { &hf_lix2_unsuccessfulAMProcedure,
      { "unsuccessfulAMProcedure", "lix2.unsuccessfulAMProcedure_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AMFUnsuccessfulProcedure", HFILL }},
    { &hf_lix2_pDUSessionEstablishment,
      { "pDUSessionEstablishment", "lix2.pDUSessionEstablishment_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "SMFPDUSessionEstablishment", HFILL }},
    { &hf_lix2_pDUSessionModification,
      { "pDUSessionModification", "lix2.pDUSessionModification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "SMFPDUSessionModification", HFILL }},
    { &hf_lix2_pDUSessionRelease,
      { "pDUSessionRelease", "lix2.pDUSessionRelease_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "SMFPDUSessionRelease", HFILL }},
    { &hf_lix2_startOfInterceptionWithEstablishedPDUSession,
      { "startOfInterceptionWithEstablishedPDUSession", "lix2.startOfInterceptionWithEstablishedPDUSession_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "SMFStartOfInterceptionWithEstablishedPDUSession", HFILL }},
    { &hf_lix2_unsuccessfulSMProcedure,
      { "unsuccessfulSMProcedure", "lix2.unsuccessfulSMProcedure_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "SMFUnsuccessfulProcedure", HFILL }},
    { &hf_lix2_servingSystemMessage,
      { "servingSystemMessage", "lix2.servingSystemMessage_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "UDMServingSystemMessage", HFILL }},
    { &hf_lix2_sMSMessage,
      { "sMSMessage", "lix2.sMSMessage_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_lALSReport,
      { "lALSReport", "lix2.lALSReport_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pDHeaderReport,
      { "pDHeaderReport", "lix2.pDHeaderReport_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pDSummaryReport,
      { "pDSummaryReport", "lix2.pDSummaryReport_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSSend,
      { "mMSSend", "lix2.mMSSend_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSSendByNonLocalTarget,
      { "mMSSendByNonLocalTarget", "lix2.mMSSendByNonLocalTarget_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSNotification,
      { "mMSNotification", "lix2.mMSNotification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSSendToNonLocalTarget,
      { "mMSSendToNonLocalTarget", "lix2.mMSSendToNonLocalTarget_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSNotificationResponse,
      { "mMSNotificationResponse", "lix2.mMSNotificationResponse_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSRetrieval,
      { "mMSRetrieval", "lix2.mMSRetrieval_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSDeliveryAck,
      { "mMSDeliveryAck", "lix2.mMSDeliveryAck_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSForward,
      { "mMSForward", "lix2.mMSForward_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSDeleteFromRelay,
      { "mMSDeleteFromRelay", "lix2.mMSDeleteFromRelay_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSDeliveryReport,
      { "mMSDeliveryReport", "lix2.mMSDeliveryReport_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSDeliveryReportNonLocalTarget,
      { "mMSDeliveryReportNonLocalTarget", "lix2.mMSDeliveryReportNonLocalTarget_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSReadReport,
      { "mMSReadReport", "lix2.mMSReadReport_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSReadReportNonLocalTarget,
      { "mMSReadReportNonLocalTarget", "lix2.mMSReadReportNonLocalTarget_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSCancel,
      { "mMSCancel", "lix2.mMSCancel_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSMBoxStore,
      { "mMSMBoxStore", "lix2.mMSMBoxStore_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSMBoxUpload,
      { "mMSMBoxUpload", "lix2.mMSMBoxUpload_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSMBoxDelete,
      { "mMSMBoxDelete", "lix2.mMSMBoxDelete_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSMBoxViewRequest,
      { "mMSMBoxViewRequest", "lix2.mMSMBoxViewRequest_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSMBoxViewResponse,
      { "mMSMBoxViewResponse", "lix2.mMSMBoxViewResponse_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCRegistration,
      { "pTCRegistration", "lix2.pTCRegistration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCSessionInitiation,
      { "pTCSessionInitiation", "lix2.pTCSessionInitiation_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCSessionAbandon,
      { "pTCSessionAbandon", "lix2.pTCSessionAbandon_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCSessionStart,
      { "pTCSessionStart", "lix2.pTCSessionStart_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCSessionEnd,
      { "pTCSessionEnd", "lix2.pTCSessionEnd_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCStartOfInterception,
      { "pTCStartOfInterception", "lix2.pTCStartOfInterception_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCPreEstablishedSession,
      { "pTCPreEstablishedSession", "lix2.pTCPreEstablishedSession_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCInstantPersonalAlert,
      { "pTCInstantPersonalAlert", "lix2.pTCInstantPersonalAlert_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCPartyJoin,
      { "pTCPartyJoin", "lix2.pTCPartyJoin_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCPartyDrop,
      { "pTCPartyDrop", "lix2.pTCPartyDrop_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCPartyHold,
      { "pTCPartyHold", "lix2.pTCPartyHold_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCMediaModification,
      { "pTCMediaModification", "lix2.pTCMediaModification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCGroupAdvertisement,
      { "pTCGroupAdvertisement", "lix2.pTCGroupAdvertisement_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCFloorControl,
      { "pTCFloorControl", "lix2.pTCFloorControl_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCTargetPresence,
      { "pTCTargetPresence", "lix2.pTCTargetPresence_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCParticipantPresence,
      { "pTCParticipantPresence", "lix2.pTCParticipantPresence_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCListManagement,
      { "pTCListManagement", "lix2.pTCListManagement_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCAccessPolicy,
      { "pTCAccessPolicy", "lix2.pTCAccessPolicy_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_subscriberRecordChangeMessage,
      { "subscriberRecordChangeMessage", "lix2.subscriberRecordChangeMessage_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "UDMSubscriberRecordChangeMessage", HFILL }},
    { &hf_lix2_cancelLocationMessage,
      { "cancelLocationMessage", "lix2.cancelLocationMessage_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "UDMCancelLocationMessage", HFILL }},
    { &hf_lix2_sMSReport,
      { "sMSReport", "lix2.sMSReport_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sMFMAPDUSessionEstablishment,
      { "sMFMAPDUSessionEstablishment", "lix2.sMFMAPDUSessionEstablishment_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sMFMAPDUSessionModification,
      { "sMFMAPDUSessionModification", "lix2.sMFMAPDUSessionModification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sMFMAPDUSessionRelease,
      { "sMFMAPDUSessionRelease", "lix2.sMFMAPDUSessionRelease_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_startOfInterceptionWithEstablishedMAPDUSession,
      { "startOfInterceptionWithEstablishedMAPDUSession", "lix2.startOfInterceptionWithEstablishedMAPDUSession_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "SMFStartOfInterceptionWithEstablishedMAPDUSession", HFILL }},
    { &hf_lix2_unsuccessfulMASMProcedure,
      { "unsuccessfulMASMProcedure", "lix2.unsuccessfulMASMProcedure_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "SMFMAUnsuccessfulProcedure", HFILL }},
    { &hf_lix2_aMFIdentifierAssociation,
      { "aMFIdentifierAssociation", "lix2.aMFIdentifierAssociation_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMEIdentifierAssociation,
      { "mMEIdentifierAssociation", "lix2.mMEIdentifierAssociation_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sMFPDUtoMAPDUSessionModification,
      { "sMFPDUtoMAPDUSessionModification", "lix2.sMFPDUtoMAPDUSessionModification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFPDUSessionEstablishment,
      { "nEFPDUSessionEstablishment", "lix2.nEFPDUSessionEstablishment_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFPDUSessionModification,
      { "nEFPDUSessionModification", "lix2.nEFPDUSessionModification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFPDUSessionRelease,
      { "nEFPDUSessionRelease", "lix2.nEFPDUSessionRelease_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFUnsuccessfulProcedure,
      { "nEFUnsuccessfulProcedure", "lix2.nEFUnsuccessfulProcedure_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFStartOfInterceptionWithEstablishedPDUSession,
      { "nEFStartOfInterceptionWithEstablishedPDUSession", "lix2.nEFStartOfInterceptionWithEstablishedPDUSession_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFdeviceTrigger,
      { "nEFdeviceTrigger", "lix2.nEFdeviceTrigger_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFdeviceTriggerReplace,
      { "nEFdeviceTriggerReplace", "lix2.nEFdeviceTriggerReplace_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFdeviceTriggerCancellation,
      { "nEFdeviceTriggerCancellation", "lix2.nEFdeviceTriggerCancellation_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFdeviceTriggerReportNotify,
      { "nEFdeviceTriggerReportNotify", "lix2.nEFdeviceTriggerReportNotify_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFMSISDNLessMOSMS,
      { "nEFMSISDNLessMOSMS", "lix2.nEFMSISDNLessMOSMS_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFExpectedUEBehaviourUpdate,
      { "nEFExpectedUEBehaviourUpdate", "lix2.nEFExpectedUEBehaviourUpdate_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFPDNConnectionEstablishment,
      { "sCEFPDNConnectionEstablishment", "lix2.sCEFPDNConnectionEstablishment_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFPDNConnectionUpdate,
      { "sCEFPDNConnectionUpdate", "lix2.sCEFPDNConnectionUpdate_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFPDNConnectionRelease,
      { "sCEFPDNConnectionRelease", "lix2.sCEFPDNConnectionRelease_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFUnsuccessfulProcedure,
      { "sCEFUnsuccessfulProcedure", "lix2.sCEFUnsuccessfulProcedure_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFStartOfInterceptionWithEstablishedPDNConnection,
      { "sCEFStartOfInterceptionWithEstablishedPDNConnection", "lix2.sCEFStartOfInterceptionWithEstablishedPDNConnection_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFdeviceTrigger,
      { "sCEFdeviceTrigger", "lix2.sCEFdeviceTrigger_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFdeviceTriggerReplace,
      { "sCEFdeviceTriggerReplace", "lix2.sCEFdeviceTriggerReplace_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFdeviceTriggerCancellation,
      { "sCEFdeviceTriggerCancellation", "lix2.sCEFdeviceTriggerCancellation_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFdeviceTriggerReportNotify,
      { "sCEFdeviceTriggerReportNotify", "lix2.sCEFdeviceTriggerReportNotify_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFMSISDNLessMOSMS,
      { "sCEFMSISDNLessMOSMS", "lix2.sCEFMSISDNLessMOSMS_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFCommunicationPatternUpdate,
      { "sCEFCommunicationPatternUpdate", "lix2.sCEFCommunicationPatternUpdate_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMEAttach,
      { "mMEAttach", "lix2.mMEAttach_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMEDetach,
      { "mMEDetach", "lix2.mMEDetach_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMELocationUpdate,
      { "mMELocationUpdate", "lix2.mMELocationUpdate_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMEStartOfInterceptionWithEPSAttachedUE,
      { "mMEStartOfInterceptionWithEPSAttachedUE", "lix2.mMEStartOfInterceptionWithEPSAttachedUE_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMEUnsuccessfulProcedure,
      { "mMEUnsuccessfulProcedure", "lix2.mMEUnsuccessfulProcedure_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aAnFAnchorKeyRegister,
      { "aAnFAnchorKeyRegister", "lix2.aAnFAnchorKeyRegister_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aAnFKAKMAApplicationKeyGet,
      { "aAnFKAKMAApplicationKeyGet", "lix2.aAnFKAKMAApplicationKeyGet_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aAnFStartOfInterceptWithEstablishedAKMAKeyMaterial,
      { "aAnFStartOfInterceptWithEstablishedAKMAKeyMaterial", "lix2.aAnFStartOfInterceptWithEstablishedAKMAKeyMaterial_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aAnFAKMAContextRemovalRecord,
      { "aAnFAKMAContextRemovalRecord", "lix2.aAnFAKMAContextRemovalRecord_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aFAKMAApplicationKeyRefresh,
      { "aFAKMAApplicationKeyRefresh", "lix2.aFAKMAApplicationKeyRefresh_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aFStartOfInterceptWithEstablishedAKMAApplicationKey,
      { "aFStartOfInterceptWithEstablishedAKMAApplicationKey", "lix2.aFStartOfInterceptWithEstablishedAKMAApplicationKey_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aFAuxiliarySecurityParameterEstablishment,
      { "aFAuxiliarySecurityParameterEstablishment", "lix2.aFAuxiliarySecurityParameterEstablishment_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aFApplicationKeyRemoval,
      { "aFApplicationKeyRemoval", "lix2.aFApplicationKeyRemoval_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_n9HRPDUSessionInfo,
      { "n9HRPDUSessionInfo", "lix2.n9HRPDUSessionInfo_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_s8HRBearerInfo,
      { "s8HRBearerInfo", "lix2.s8HRBearerInfo_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_separatedLocationReporting,
      { "separatedLocationReporting", "lix2.separatedLocationReporting_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sTIRSHAKENSignatureGeneration,
      { "sTIRSHAKENSignatureGeneration", "lix2.sTIRSHAKENSignatureGeneration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sTIRSHAKENSignatureValidation,
      { "sTIRSHAKENSignatureValidation", "lix2.sTIRSHAKENSignatureValidation_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_iMSMessage,
      { "iMSMessage", "lix2.iMSMessage_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_startOfInterceptionForActiveIMSSession,
      { "startOfInterceptionForActiveIMSSession", "lix2.startOfInterceptionForActiveIMSSession_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_iMSCCUnavailable,
      { "iMSCCUnavailable", "lix2.iMSCCUnavailable_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_uDMLocationInformationResult,
      { "uDMLocationInformationResult", "lix2.uDMLocationInformationResult_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_uDMUEInformationResponse,
      { "uDMUEInformationResponse", "lix2.uDMUEInformationResponse_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_uDMUEAuthenticationResponse,
      { "uDMUEAuthenticationResponse", "lix2.uDMUEAuthenticationResponse_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_positioningInfoTransfer,
      { "positioningInfoTransfer", "lix2.positioningInfoTransfer_element",
        FT_NONE, BASE_NONE, NULL, 0,
        "AMFPositioningInfoTransfer", HFILL }},
    { &hf_lix2_mMEPositioningInfoTransfer,
      { "mMEPositioningInfoTransfer", "lix2.mMEPositioningInfoTransfer_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aMFRANHandoverCommand,
      { "aMFRANHandoverCommand", "lix2.aMFRANHandoverCommand_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aMFRANHandoverRequest,
      { "aMFRANHandoverRequest", "lix2.aMFRANHandoverRequest_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_eESEECRegistration,
      { "eESEECRegistration", "lix2.eESEECRegistration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_eESEASDiscovery,
      { "eESEASDiscovery", "lix2.eESEASDiscovery_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_eESEASDiscoverySubscription,
      { "eESEASDiscoverySubscription", "lix2.eESEASDiscoverySubscription_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_eESEASDiscoveryNotification,
      { "eESEASDiscoveryNotification", "lix2.eESEASDiscoveryNotification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_eESAppContextRelocation,
      { "eESAppContextRelocation", "lix2.eESAppContextRelocation_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_eESACRSubscription,
      { "eESACRSubscription", "lix2.eESACRSubscription_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_eESACRNotification,
      { "eESACRNotification", "lix2.eESACRNotification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_eESEECContextRelocation,
      { "eESEECContextRelocation", "lix2.eESEECContextRelocation_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_eESStartOfInterceptionWithRegisteredEEC,
      { "eESStartOfInterceptionWithRegisteredEEC", "lix2.eESStartOfInterceptionWithRegisteredEEC_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_uDMStartOfInterceptionWithRegisteredTarget,
      { "uDMStartOfInterceptionWithRegisteredTarget", "lix2.uDMStartOfInterceptionWithRegisteredTarget_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_fiveGMSAFServiceAccessInformation,
      { "fiveGMSAFServiceAccessInformation", "lix2.fiveGMSAFServiceAccessInformation_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_fiveGMSAFConsumptionReporting,
      { "fiveGMSAFConsumptionReporting", "lix2.fiveGMSAFConsumptionReporting_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_fiveGMSAFDynamicPolicyInvocation,
      { "fiveGMSAFDynamicPolicyInvocation", "lix2.fiveGMSAFDynamicPolicyInvocation_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_fiveGMSAFMetricsReporting,
      { "fiveGMSAFMetricsReporting", "lix2.fiveGMSAFMetricsReporting_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_fiveGMSAFNetworkAssistance,
      { "fiveGMSAFNetworkAssistance", "lix2.fiveGMSAFNetworkAssistance_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_fiveGMSAFUnsuccessfulProcedure,
      { "fiveGMSAFUnsuccessfulProcedure", "lix2.fiveGMSAFUnsuccessfulProcedure_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_fiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE,
      { "fiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE", "lix2.fiveGMSAFStartOfInterceptionWithAlreadyConfiguredUE_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aMFUEConfigurationUpdate,
      { "aMFUEConfigurationUpdate", "lix2.aMFUEConfigurationUpdate_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_hSSServingSystemMessage,
      { "hSSServingSystemMessage", "lix2.hSSServingSystemMessage_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_hSSStartOfInterceptionWithRegisteredTarget,
      { "hSSStartOfInterceptionWithRegisteredTarget", "lix2.hSSStartOfInterceptionWithRegisteredTarget_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFAFSessionWithQoSProvision,
      { "nEFAFSessionWithQoSProvision", "lix2.nEFAFSessionWithQoSProvision_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nEFAFSessionWithQoSNotification,
      { "nEFAFSessionWithQoSNotification", "lix2.nEFAFSessionWithQoSNotification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFASSessionWithQoSProvision,
      { "sCEFASSessionWithQoSProvision", "lix2.sCEFASSessionWithQoSProvision_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sCEFASSessionWithQoSNotification,
      { "sCEFASSessionWithQoSNotification", "lix2.sCEFASSessionWithQoSNotification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aMFRANTraceReport,
      { "aMFRANTraceReport", "lix2.aMFRANTraceReport_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_rCSRegistration,
      { "rCSRegistration", "lix2.rCSRegistration_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_rCSMessage,
      { "rCSMessage", "lix2.rCSMessage_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_rCSCapabilityDiscovery,
      { "rCSCapabilityDiscovery", "lix2.rCSCapabilityDiscovery_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_rCSSessionEstablishment,
      { "rCSSessionEstablishment", "lix2.rCSSessionEstablishment_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_rCSSessionModification,
      { "rCSSessionModification", "lix2.rCSSessionModification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_rCSSessionRelease,
      { "rCSSessionRelease", "lix2.rCSSessionRelease_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aMFUEPolicyTransfer,
      { "aMFUEPolicyTransfer", "lix2.aMFUEPolicyTransfer_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aMFUEServiceAccept,
      { "aMFUEServiceAccept", "lix2.aMFUEServiceAccept_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_ePSRANHandoverCommand,
      { "ePSRANHandoverCommand", "lix2.ePSRANHandoverCommand_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_ePSRANHandoverRequest,
      { "ePSRANHandoverRequest", "lix2.ePSRANHandoverRequest_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMERANTraceReport,
      { "mMERANTraceReport", "lix2.mMERANTraceReport_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMEUEServiceAccept,
      { "mMEUEServiceAccept", "lix2.mMEUEServiceAccept_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nWDAFEventsSubscription,
      { "nWDAFEventsSubscription", "lix2.nWDAFEventsSubscription_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nWDAFEventsNotification,
      { "nWDAFEventsNotification", "lix2.nWDAFEventsNotification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nWDAFAnalyticsInfoQuery,
      { "nWDAFAnalyticsInfoQuery", "lix2.nWDAFAnalyticsInfoQuery_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nWDAFRoamingAnalyticsSubscription,
      { "nWDAFRoamingAnalyticsSubscription", "lix2.nWDAFRoamingAnalyticsSubscription_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nWDAFRoamingAnalyticsNotification,
      { "nWDAFRoamingAnalyticsNotification", "lix2.nWDAFRoamingAnalyticsNotification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_startOfInterceptForRegisteredRCSUser,
      { "startOfInterceptForRegisteredRCSUser", "lix2.startOfInterceptForRegisteredRCSUser_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_startOfInterceptWithEstablisedRCSSession,
      { "startOfInterceptWithEstablisedRCSSession", "lix2.startOfInterceptWithEstablisedRCSSession_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_uDMProSeTargetIdentifierDeconcealment,
      { "uDMProSeTargetIdentifierDeconcealment", "lix2.uDMProSeTargetIdentifierDeconcealment_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_uDMProSeTargetAuthentication,
      { "uDMProSeTargetAuthentication", "lix2.uDMProSeTargetAuthentication_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_iRIPayloadOID,
      { "iRIPayloadOID", "lix2.iRIPayloadOID",
        FT_REL_OID, BASE_NONE, NULL, 0,
        "RELATIVE_OID", HFILL }},
    { &hf_lix2_event_01,
      { "event", "lix2.event",
        FT_UINT32, BASE_DEC, VALS(lix2_IRIEvent_vals), 0,
        "IRIEvent", HFILL }},
    { &hf_lix2_targetIdentifiers,
      { "targetIdentifiers", "lix2.targetIdentifiers",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SEQUENCE_OF_IRITargetIdentifier", HFILL }},
    { &hf_lix2_targetIdentifiers_item,
      { "IRITargetIdentifier", "lix2.IRITargetIdentifier_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mediatedFromIndicator,
      { "mediatedFromIndicator", "lix2.mediatedFromIndicator",
        FT_UINT32, BASE_DEC, VALS(lix2_MediatedFromIndicator_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_mDFCellSiteReport,
      { "mDFCellSiteReport", "lix2.mDFCellSiteReport",
        FT_UINT32, BASE_DEC, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_identifier,
      { "identifier", "lix2.identifier",
        FT_UINT32, BASE_DEC, VALS(lix2_TargetIdentifier_vals), 0,
        "TargetIdentifier", HFILL }},
    { &hf_lix2_provenance,
      { "provenance", "lix2.provenance",
        FT_UINT32, BASE_DEC, VALS(lix2_TargetIdentifierProvenance_vals), 0,
        "TargetIdentifierProvenance", HFILL }},
    { &hf_lix2_xIRIRelativeOID,
      { "xIRIRelativeOID", "lix2.xIRIRelativeOID",
        FT_REL_OID, BASE_NONE, NULL, 0,
        "RELATIVE_OID", HFILL }},
    { &hf_lix2_cCPayloadOID,
      { "cCPayloadOID", "lix2.cCPayloadOID",
        FT_REL_OID, BASE_NONE, NULL, 0,
        "RELATIVE_OID", HFILL }},
    { &hf_lix2_pDU,
      { "pDU", "lix2.pDU",
        FT_UINT32, BASE_DEC, VALS(lix2_CCPDU_vals), 0,
        "CCPDU", HFILL }},
    { &hf_lix2_uPFCCPDU,
      { "uPFCCPDU", "lix2.uPFCCPDU",
        FT_BYTES, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_extendedUPFCCPDU,
      { "extendedUPFCCPDU", "lix2.extendedUPFCCPDU_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_mMSCCPDU,
      { "mMSCCPDU", "lix2.mMSCCPDU_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_nIDDCCPDU,
      { "nIDDCCPDU", "lix2.nIDDCCPDU",
        FT_BYTES, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_pTCCCPDU,
      { "pTCCCPDU", "lix2.pTCCCPDU",
        FT_BYTES, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_iMSCCPDU,
      { "iMSCCPDU", "lix2.iMSCCPDU_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_rCSCCPDU,
      { "rCSCCPDU", "lix2.rCSCCPDU",
        FT_UINT32, BASE_DEC, VALS(lix2_RCSCCPDU_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_lINotificationPayloadOID,
      { "lINotificationPayloadOID", "lix2.lINotificationPayloadOID",
        FT_REL_OID, BASE_NONE, NULL, 0,
        "RELATIVE_OID", HFILL }},
    { &hf_lix2_notification,
      { "notification", "lix2.notification",
        FT_UINT32, BASE_DEC, VALS(lix2_LINotificationMessage_vals), 0,
        "LINotificationMessage", HFILL }},
    { &hf_lix2_lINotification,
      { "lINotification", "lix2.lINotification_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sUPI,
      { "sUPI", "lix2.sUPI",
        FT_UINT32, BASE_DEC, VALS(lix2_SUPI_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_pEI,
      { "pEI", "lix2.pEI",
        FT_UINT32, BASE_DEC, VALS(lix2_PEI_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_pDUSessionID,
      { "pDUSessionID", "lix2.pDUSessionID",
        FT_UINT32, BASE_DEC, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_location,
      { "location", "lix2.location_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sNSSAI,
      { "sNSSAI", "lix2.sNSSAI_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_dNN,
      { "dNN", "lix2.dNN",
        FT_STRING, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_messageCause,
      { "messageCause", "lix2.messageCause",
        FT_UINT32, BASE_DEC, VALS(lix2_N9HRMessageCause_vals), 0,
        "N9HRMessageCause", HFILL }},
    { &hf_lix2_iMSI,
      { "iMSI", "lix2.iMSI",
        FT_STRING, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_iMEI,
      { "iMEI", "lix2.iMEI",
        FT_STRING, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_bearerID,
      { "bearerID", "lix2.bearerID",
        FT_UINT32, BASE_DEC, NULL, 0,
        "EPSBearerID", HFILL }},
    { &hf_lix2_linkedBearerID,
      { "linkedBearerID", "lix2.linkedBearerID",
        FT_UINT32, BASE_DEC, NULL, 0,
        "EPSBearerID", HFILL }},
    { &hf_lix2_aPN,
      { "aPN", "lix2.aPN",
        FT_STRING, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sGWIPAddress,
      { "sGWIPAddress", "lix2.sGWIPAddress",
        FT_UINT32, BASE_DEC, VALS(lix2_IPAddress_vals), 0,
        "IPAddress", HFILL }},
    { &hf_lix2_messageCause_01,
      { "messageCause", "lix2.messageCause",
        FT_UINT32, BASE_DEC, VALS(lix2_S8HRMessageCause_vals), 0,
        "S8HRMessageCause", HFILL }},
    { &hf_lix2_gPSI,
      { "gPSI", "lix2.gPSI",
        FT_UINT32, BASE_DEC, VALS(lix2_GPSI_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_nEFID,
      { "nEFID", "lix2.nEFID",
        FT_STRING, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_rDSSupport,
      { "rDSSupport", "lix2.rDSSupport",
        FT_BOOLEAN, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_sMFID,
      { "sMFID", "lix2.sMFID",
        FT_STRING, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_aFID,
      { "aFID", "lix2.aFID",
        FT_STRING, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_initiator,
      { "initiator", "lix2.initiator",
        FT_UINT32, BASE_DEC, VALS(lix2_Initiator_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_rDSSourcePortNumber,
      { "rDSSourcePortNumber", "lix2.rDSSourcePortNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RDSPortNumber", HFILL }},
    { &hf_lix2_rDSDestinationPortNumber,
      { "rDSDestinationPortNumber", "lix2.rDSDestinationPortNumber",
        FT_UINT32, BASE_DEC, NULL, 0,
        "RDSPortNumber", HFILL }},
    { &hf_lix2_applicationID,
      { "applicationID", "lix2.applicationID",
        FT_BYTES, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_rDSAction,
      { "rDSAction", "lix2.rDSAction",
        FT_UINT32, BASE_DEC, VALS(lix2_RDSAction_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_serializationFormat,
      { "serializationFormat", "lix2.serializationFormat",
        FT_UINT32, BASE_DEC, VALS(lix2_SerializationFormat_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_timeOfFirstPacket,
      { "timeOfFirstPacket", "lix2.timeOfFirstPacket",
        FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0,
        "Timestamp", HFILL }},
    { &hf_lix2_timeOfLastPacket,
      { "timeOfLastPacket", "lix2.timeOfLastPacket",
        FT_ABSOLUTE_TIME, ABSOLUTE_TIME_UTC, NULL, 0,
        "Timestamp", HFILL }},
    { &hf_lix2_uplinkVolume,
      { "uplinkVolume", "lix2.uplinkVolume",
        FT_INT32, BASE_DEC, NULL, 0,
        "INTEGER", HFILL }},
    { &hf_lix2_downlinkVolume,
      { "downlinkVolume", "lix2.downlinkVolume",
        FT_INT32, BASE_DEC, NULL, 0,
        "INTEGER", HFILL }},
    { &hf_lix2_releaseCause,
      { "releaseCause", "lix2.releaseCause",
        FT_UINT32, BASE_DEC, VALS(lix2_NEFReleaseCause_vals), 0,
        "NEFReleaseCause", HFILL }},
    { &hf_lix2_failureCause,
      { "failureCause", "lix2.failureCause",
        FT_UINT32, BASE_DEC, VALS(lix2_NEFFailureCause_vals), 0,
        "NEFFailureCause", HFILL }},
    { &hf_lix2_triggerId,
      { "triggerId", "lix2.triggerId",
        FT_STRING, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_triggerPayload,
      { "triggerPayload", "lix2.triggerPayload",
        FT_BYTES, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_validityPeriod,
      { "validityPeriod", "lix2.validityPeriod",
        FT_INT32, BASE_DEC, NULL, 0,
        "INTEGER", HFILL }},
    { &hf_lix2_priorityDT,
      { "priorityDT", "lix2.priorityDT",
        FT_UINT32, BASE_DEC, VALS(lix2_PriorityDT_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_sourcePortId,
      { "sourcePortId", "lix2.sourcePortId",
        FT_UINT32, BASE_DEC, NULL, 0,
        "PortNumber", HFILL }},
    { &hf_lix2_destinationPortId,
      { "destinationPortId", "lix2.destinationPortId",
        FT_UINT32, BASE_DEC, NULL, 0,
        "PortNumber", HFILL }},
    { &hf_lix2_deviceTriggerDeliveryResult,
      { "deviceTriggerDeliveryResult", "lix2.deviceTriggerDeliveryResult",
        FT_UINT32, BASE_DEC, VALS(lix2_DeviceTriggerDeliveryResult_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_terminatingSMSParty,
      { "terminatingSMSParty", "lix2.terminatingSMSParty",
        FT_STRING, BASE_NONE, NULL, 0,
        "AFID", HFILL }},
    { &hf_lix2_sMS,
      { "sMS", "lix2.sMS",
        FT_UINT32, BASE_DEC, VALS(lix2_SMSTPDUData_vals), 0,
        "SMSTPDUData", HFILL }},
    { &hf_lix2_sourcePort,
      { "sourcePort", "lix2.sourcePort",
        FT_UINT32, BASE_DEC, NULL, 0,
        "PortNumber", HFILL }},
    { &hf_lix2_destinationPort,
      { "destinationPort", "lix2.destinationPort",
        FT_UINT32, BASE_DEC, NULL, 0,
        "PortNumber", HFILL }},
    { &hf_lix2_expectedUEMovingTrajectory,
      { "expectedUEMovingTrajectory", "lix2.expectedUEMovingTrajectory",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SEQUENCE_OF_UMTLocationArea5G", HFILL }},
    { &hf_lix2_expectedUEMovingTrajectory_item,
      { "UMTLocationArea5G", "lix2.UMTLocationArea5G_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_stationaryIndication,
      { "stationaryIndication", "lix2.stationaryIndication",
        FT_UINT32, BASE_DEC, VALS(lix2_StationaryIndication_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_communicationDurationTime,
      { "communicationDurationTime", "lix2.communicationDurationTime",
        FT_INT32, BASE_DEC, NULL, 0,
        "INTEGER", HFILL }},
    { &hf_lix2_periodicTime,
      { "periodicTime", "lix2.periodicTime",
        FT_INT32, BASE_DEC, NULL, 0,
        "INTEGER", HFILL }},
    { &hf_lix2_scheduledCommunicationTime,
      { "scheduledCommunicationTime", "lix2.scheduledCommunicationTime_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_scheduledCommunicationType,
      { "scheduledCommunicationType", "lix2.scheduledCommunicationType",
        FT_UINT32, BASE_DEC, VALS(lix2_ScheduledCommunicationType_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_batteryIndication,
      { "batteryIndication", "lix2.batteryIndication",
        FT_UINT32, BASE_DEC, VALS(lix2_BatteryIndication_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_trafficProfile,
      { "trafficProfile", "lix2.trafficProfile",
        FT_UINT32, BASE_DEC, VALS(lix2_TrafficProfile_vals), 0,
        NULL, HFILL }},
    { &hf_lix2_expectedTimeAndDayOfWeekInTrajectory,
      { "expectedTimeAndDayOfWeekInTrajectory", "lix2.expectedTimeAndDayOfWeekInTrajectory",
        FT_UINT32, BASE_DEC, NULL, 0,
        "SEQUENCE_OF_UMTLocationArea5G", HFILL }},
    { &hf_lix2_expectedTimeAndDayOfWeekInTrajectory_item,
      { "UMTLocationArea5G", "lix2.UMTLocationArea5G_element",
        FT_NONE, BASE_NONE, NULL, 0,
        NULL, HFILL }},
    { &hf_lix2_validityTime,
      { "validityTime", "lix2.validit