(function(){"use strict";var register=function(cytoscape,dagre){if(!cytoscape||!dagre){return}var isFunction=function(o){return typeof o==="function"};var defaults={nodeSep:undefined,edgeSep:undefined,rankSep:undefined,rankDir:undefined,minLen:function(edge){return 1},edgeWeight:function(edge){return 1},fit:true,padding:30,spacingFactor:undefined,animate:false,animationDuration:500,animationEasing:undefined,boundingBox:undefined,ready:function(){},stop:function(){}};function DagreLayout(options){var opts=this.options={};for(var i in defaults){opts[i]=defaults[i]}for(var i in options){opts[i]=options[i]}}DagreLayout.prototype.run=function(){var options=this.options;var layout=this;var cy=options.cy;var eles=options.eles;var getVal=function(ele,val){return isFunction(val)?val.apply(ele,[ele]):val};var bb=options.boundingBox||{x1:0,y1:0,w:cy.width(),h:cy.height()};if(bb.x2===undefined){bb.x2=bb.x1+bb.w}if(bb.w===undefined){bb.w=bb.x2-bb.x1}if(bb.y2===undefined){bb.y2=bb.y1+bb.h}if(bb.h===undefined){bb.h=bb.y2-bb.y1}var g=new dagre.graphlib.Graph({multigraph:true,compound:true});var gObj={};var setGObj=function(name,val){if(val!=null){gObj[name]=val}};setGObj("nodesep",options.nodeSep);setGObj("edgesep",options.edgeSep);setGObj("ranksep",options.rankSep);setGObj("rankdir",options.rankDir);g.setGraph(gObj);g.setDefaultEdgeLabel(function(){return{}});g.setDefaultNodeLabel(function(){return{}});var nodes=eles.nodes();for(var i=0;i<nodes.length;i++){var node=nodes[i];var nbb=node.boundingBox();g.setNode(node.id(),{width:nbb.w,height:nbb.h,name:node.id()})}for(var i=0;i<nodes.length;i++){var node=nodes[i];if(node.isChild()){g.setParent(node.id(),node.parent().id())}}var edges=eles.edges().stdFilter(function(edge){return!edge.source().isParent()&&!edge.target().isParent()});for(var i=0;i<edges.length;i++){var edge=edges[i];g.setEdge(edge.source().id(),edge.target().id(),{minlen:getVal(edge,options.minLen),weight:getVal(edge,options.edgeWeight),name:edge.id()},edge.id())}dagre.layout(g);var gNodeIds=g.nodes();for(var i=0;i<gNodeIds.length;i++){var id=gNodeIds[i];var n=g.node(id);cy.getElementById(id).scratch().dagre=n}var dagreBB;if(options.boundingBox){dagreBB={x1:Infinity,x2:-Infinity,y1:Infinity,y2:-Infinity};nodes.forEach(function(node){var dModel=node.scratch().dagre;dagreBB.x1=Math.min(dagreBB.x1,dModel.x);dagreBB.x2=Math.max(dagreBB.x2,dModel.x);dagreBB.y1=Math.min(dagreBB.y1,dModel.y);dagreBB.y2=Math.max(dagreBB.y2,dModel.y)});dagreBB.w=dagreBB.x2-dagreBB.x1;dagreBB.h=dagreBB.y2-dagreBB.y1}else{dagreBB=bb}var constrainPos=function(p){if(options.boundingBox){var xPct=dagreBB.w===0?0:(p.x-dagreBB.x1)/dagreBB.w;var yPct=dagreBB.h===0?0:(p.y-dagreBB.y1)/dagreBB.h;return{x:bb.x1+xPct*bb.w,y:bb.y1+yPct*bb.h}}else{return p}};nodes.layoutPositions(layout,options,function(ele){ele=typeof ele==="object"?ele:this;var dModel=ele.scratch().dagre;return constrainPos({x:dModel.x,y:dModel.y})});return this};cytoscape("layout","dagre",DagreLayout)};if(typeof module!=="undefined"&&module.exports){module.exports=function(cytoscape,dagre){register(cytoscape,dagre||require("dagre"))}}else if(typeof define!=="undefined"&&define.amd){define("cytoscape-dagre",function(){return register})}if(typeof cytoscape!=="undefined"&&typeof dagre!=="undefined"){register(cytoscape,dagre)}})();