from setuptools import setup, find_packages

with open("README.md", "r") as f:
    long_description = f.read()

setup(
    name="wplay",
    version="8.0.5",
    install_requires=["argparse >= 1.4.0",
                      "beautifulsoup4>=4.8.1",
                      "colorama>=0.4.3",
                      "dateTime>=4.3",
                      "decorator>=4.4.2",
                      "flake8>=3.7.9",
                      "google>=2.0.3",
                      "gTTS==2.1.1",
                      "newsapi-python>=0.2.6",
                      "phonenumbers==8.10.2",
                      "playsound>=1.2.2",
                      "prompt_toolkit==1.0.14",
                      "psutil>=5.7.0",
                      "pyfiglet>=0.8.post1",
                      "pyflakes>=2.2.0",
                      "Pygments>=2.6.1",
                      "pyppeteer>=0.0.25",
                      "python-dotenv==0.12.0",
                      "python-telegram-bot>=11.1.0",
                      "requests>=2.22.0",
                      "transitions>=0.7.2",
                      "urllib3>=1.25.8",
                      "websockets>=8.1",
                      "whaaaaat>=0.5.2",
                      ],
    packages=find_packages(),
    description="command line software to play with your WhatsApp",
    long_description=long_description,
    long_description_content_type="text/markdown",
    author="Rohit Potter, Alexandre Calil",
    author_email="rohitpotter12@gmail.com, alexandrecalilmf@gmail.com",
    license="MIT",
    python_requires=">=3.6",
    url="https://github.com/rpotter12/whatsapp-play/",
    download_url="https://pypi.org/project/wplay/",
    keywords=[
        "whatsapp",
        "whatsapp cli",
        "whatsapp api",
        "whatsapp service"
        "whatsapp chat",
        "message blast",
        "message timer",
        "whatsapp terminal",
        "whatsapp news",
        "whatsapp schedule",
        "tracker",
        "online tracking",
        "save-chat"
    ],
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3 :: Only",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    entry_points={"console_scripts": ["wplay = wplay.__main__:main"]},
)
