# 关于hosts的使用

## 工作原理及存在的问题

启用后, app会在本地启动一个代理服务器用于转发流量, 如果指定了域名对应的ip地址, 代理服务器将直接通过ip与目标服务器建立连接.

使用这种方式可以解决Dart中无法手动校验证书的问题, 在Dart中如果尝试直接通过ip建立https连接, 将会出现证书校验错误, 
如果忽略证书校验, 将存在严重的安全性问题. 代理服务器似乎是此问题的唯一解法.

由于eh被通过sni嗅探的方式封锁, 因此必须绕过sni嗅探才能解决问题. 目前没有好的解决方式, app中将直接通过ip建立https连接并忽略证书校验.

## 配置文件书写方式

使用json, 如果不了解, 可以去搜索json的格式

退出修改页面时将自动保存文件, 如果修改了端口, 需要手动重启代理服务器

### port

指定代理服务器的端口, 如果端口与其它程序冲突, 在此处修改

### rule

指定域名的ip地址

### sni

尝试访问列在此处的域名时, app将使用绕过sni嗅探方式工作, 这将降低安全性

## 示例

这是app的默认配置

```json
{
    "port": 7891,
    "rule": {
          "picaapi.picacomic.com": "104.21.91.145",
          "img.picacomic.com": "104.21.91.145",
          "storage1.picacomic.com": "104.21.91.145",
          "storage-b.picacomic.com": "104.21.91.145",
          "e-hentai.org": "172.67.0.127",
          "exhentai.org": "178.175.129.254"
    },
    "sni": [
        "e-hentai.org",
        "exhentai.org"
    ]
}
```