function stopDef(e) {
    if (e && e.preventDefault) e.preventDefault();
    else window.event.returnValue = false;
    return false;
}

$(function () {
    /**
     * ajax-post
     * 将链接转换为ajax请求，并交给handleAjax处理
     * 参数：
     * data-confirm：如果存在，则点击后发出提示。
     * 示例：<a href="xxx" class="ajax-post">Test</a>
     */
    $(document).on('click', '.ajax-post', function (e) {
        //取消默认动作，防止跳转页面
        stopDef(e);

        //获取参数（属性）
        var url = $(this).attr('href');
        var confirmText = $(this).attr('data-confirm');
        var delSelecter=$(this).attr('delete');
        var _this=$(this);
        //如果需要的话，发出确认提示信息
        // if (confirmText) {
        //     var result = confirm(confirmText);
        //     if (!result) {
        //         return false;
        //     }
        // }

        //发送AJAX请求
        $.post(url, {}, function (a, b, c) {
            if(a.status==='success'&&delSelecter)_this.parents(delSelecter).remove();
            handleAjax(a);
        });
    });
    /**
     * ajax-get
     * 将链接转换为ajax请求，并交给handleAjax处理
     * 参数：
     * data-confirm：如果存在，则点击后发出提示。
     * 示例：<a href="xxx" class="ajax-post">Test</a>
     */
    $(document).on('click', '.ajax-get', function (e) {
        //取消默认动作，防止跳转页面
        stopDef(e);

        //获取参数（属性）
        var url = $(this).attr('href');
        var confirmText = $(this).attr('data-confirm');
        var delSelecter=$(this).attr('delete');
        var _this=$(this);
        //如果需要的话，发出确认提示信息
        // if (confirmText) {
        //     var result = confirm(confirmText);
        //     if (!result) {
        //         return false;
        //     }
        // }

        //发送AJAX请求
        $.get(url, {}, function (a, b, c) {
            if(a.status==='success'&&delSelecter)_this.parents(delSelecter).remove();
            handleAjax(a);
        });
    });
    /**
     * ajax-form
     * 通过ajax提交表单，通过oneplus提示消息
     * 示例：<form class="ajax-form" method="post" action="xxx">
     */
    $(document).on('submit', 'form.ajax-form', function (e) {
        //取消默认动作，防止表单两次提交
        stopDef(e);
        //禁用提交按钮，防止重复提交
        var form = $(this);
        $('[type=submit]', form).addClass('disabled');

        //获取提交地址，方式
        var action = $(this).attr('action');
        var method = $(this).attr('method');

        //检测提交地址
        if (!action) {
            return false;
        }

        //默认提交方式为get
        if (!method) {
            method = 'get';
        }

        //获取表单内容
        var formContent = $(this).serialize();

        //发送提交请求
        var callable;
        if (method == 'post') {
            callable = $.post;
        } else {
            callable = $.get;
        }
        callable(action, formContent, function (a) {
            handleAjax(a);
            $('[type=submit]', form).removeClass('disabled');
        });

        //返回
        return false;
    });
    /**
     * ajax-form
     * 通过ajax提交表单，通过oneplus提示消息
     * 示例：<form class="ajax-form" method="post" action="xxx">
     */
    $(document).on('submit', 'form.ajax-form-file', function (e) {
        //取消默认动作，防止表单两次提交
        stopDef(e);

        //禁用提交按钮，防止重复提交
        var form = $(this);
        $('[type=submit]', form).addClass('disabled');

        //获取提交地址，方式
        var action = $(this).attr('action');
        var method = $(this).attr('method');

        //检测提交地址
        if (!action) {
            return false;
        }

        //默认提交方式为get
        // if (!method) {
        //     method = 'get';
        // }

        //获取表单内容
        // var formContent = $(this).serialize();
        formContent= new FormData($(this)[0]);
        //发送提交请求
        var callable;
        // if (method == 'post') {
        //     callable = $.post;
        //
        // } else {
        //     callable = $.get;
        // }
        method=method === 'post' ? 'post' :'get';
        // callable(
        //     action, formContent, function (a) {
        //     handleAjax(a);
        //     $('[type=submit]', form).removeClass('disabled');
        // });
        $.ajax({
            type:method,
            url:action,
            data:formContent,
            processData: false,  // 不处理数据
            contentType: false ,  // 不设置内容类型
            success:function (a) {
                handleAjax(a);
                $('[type=submit]', form).removeClass('disabled');
            }
        },'json');
        //返回
        return false;
    });
    $(document).on('change','input[type="file"].ajax-file',function (e) {
        var _this=$(this)
        var filePath=$(this).val();
        if(filePath.length <3)return ;
        $(this).addClass('disabled');
        var action=$(this).attr('href');
        var formContent=new FormData();
        var callback=_this.attr('callback');

        formContent.append($(this).attr('name'),$(this)[0].files[0]);
        // });
        $.ajax({
            type:'post',
            url:action,
            data:formContent,
            processData: false,  // 不处理数据
            contentType: false ,  // 不设置内容类型
            success:function (a) {
                if(a.data&&a.data.file){
                    $(this).val(a.data.file);
                    var target=_this.attr('data-target');
                    var targetDom=$('input[name="'+target+'"]');
                    if(targetDom.length > 0)targetDom.val(a.data.file).change()
                }
                console.log(callback);
                callback&&typeof(window[callback])==='function'&&window[callback](_this);
                handleAjax(a);
                $(this).removeClass('disabled');
            }
        },'json');

    })
});
/**
 * 操纵toastor的便捷类
 * @type {{success: success, error: error, info: info, warning: warning}}
 */
var toast = {
    /**
     * 成功提示
     * @param text 内容
     * @param title 标题
     */
    success: function (text, title) {

        // toastr.options = {
        //     "closeButton": true,
        //     "debug": false,
        //     "positionClass": "toast-top-center",
        //     "onclick": null,
        //     "showDuration": "1000",
        //     "hideDuration": "1000",
        //     "timeOut": "5000",
        //     "extendedTimeOut": "1000",
        //     "showEasing": "swing",
        //     "hideEasing": "linear",
        //     "showMethod": "fadeIn",
        //     "hideMethod": "fadeOut"
        // }
        layui.use('layer',function () {
            let layer = layui.layer;
            layer.msg(text, {icon: 6})
        })
        // toastr.success(text, title);
    },
    /**
     * 失败提示
     * @param text 内容
     * @param title 标题
     */
    error: function (text, title) {
        layui.use('layer',function () {
            let layer = layui.layer;
            layer.msg(text, {icon: 5})
        })
    },
    /**
     * 信息提示
     * @param text 内容
     * @param title 标题
     */
    info: function (text, title) {
        layui.use('layer',function () {
            let layer = layui.layer;
            layer.msg(text, {icon: 3})
        })
    },
    /**
     * 警告提示
     * @param text 内容
     * @param title 标题
     */
    warning: function (text, title) {
        layui.use('layer',function () {
            let layer = layui.layer;
            layer.msg(text, {icon: 7})
        })
    }
}

/**
 * Ajax系列
 */

/**
 * 处理ajax返回结果
 */
function handleAjax(a) {
    //如果需要跳转的话，消息的末尾附上即将跳转字样
    if (a.url) {
        a.msg += '，页面即将跳转～';
    }

    //弹出提示消息
    if (a.status==='success') {
        toast.success(a.msg, '温馨提示');
    } else {
        toast.error(a.msg, '温馨提示');
    }

    //需要跳转的话就跳转
    var interval = 1500;
    if(a.data){
        if (a.data.url == "refresh") {
            setTimeout(function () {
                location.href = location.href;
            }, interval);
        } else if (a.data.url) {
            setTimeout(function () {
                location.href = a.data.url;
            }, interval);
        }
    }

}
$(".a-upload input[type='file']").on("change",function(){
    var filePath=$(this).val();
    let nameDom=$(this).parents('.a-upload').find('.file_name');
    if(filePath.length >= 4 ){
        var arr=filePath.split('\\');
        var fileName=arr[arr.length-1];
        console.log(filePath);
        nameDom.text(fileName);
    }else{
        nameDom.text("");
        nameDom.text("您未上传文件，或者您上传文件类型有误！").show();
        return false
    }
})