<?php

/**
 * ҵ΢ŻصϢӽʾ.
 *
 * @copyright Copyright (c) 1998-2014 Tencent Inc.
 */


include_once "sha1.php";
include_once "xmlparse.php";
include_once "pkcs7Encoder.php";
include_once "errorCode.php";

class WXBizMsgCrypt
{
	private $m_sToken;
	private $m_sEncodingAesKey;
	private $m_sReceiveId;

	/**
	 * 캯
	 * @param $token string õtoken
	 * @param $encodingAesKey string õEncodingAESKey
	 * @param $receiveId string, ͬӦóͬid
	 */
	public function __construct($token, $encodingAesKey, $receiveId)
	{
		$this->m_sToken = $token;
		$this->m_sEncodingAesKey = $encodingAesKey;
		$this->m_sReceiveId = $receiveId;
	}
	
    /*
	*֤URL
    *@param sMsgSignature: ǩӦURLmsg_signature
    *@param sTimeStamp: ʱӦURLtimestamp
    *@param sNonce: ӦURLnonce
    *@param sEchoStr: ӦURLechostr
    *@param sReplyEchoStr: ֮echostrreturn0ʱЧ
    *@returnɹ0ʧܷضӦĴ
	*/
	public function VerifyURL($sMsgSignature, $sTimeStamp, $sNonce, $sEchoStr, &$sReplyEchoStr)
	{
		if (strlen($this->m_sEncodingAesKey) != 43) {
			return ErrorCode::$IllegalAesKey;
		}

		$pc = new Prpcrypt($this->m_sEncodingAesKey);
		//verify msg_signature
		$sha1 = new SHA1;
		$array = $sha1->getSHA1($this->m_sToken, $sTimeStamp, $sNonce, $sEchoStr);
		$ret = $array[0];

		if ($ret != 0) {
			return $ret;
		}

		$signature = $array[1];
		if ($signature != $sMsgSignature) {
			return ErrorCode::$ValidateSignatureError;
		}

		$result = $pc->decrypt($sEchoStr, $this->m_sReceiveId);
		if ($result[0] != 0) {
			return $result[0];
		}
		$sReplyEchoStr = $result[1];

		return ErrorCode::$OK;
	}
	/**
	 * ƽ̨ظûϢܴ.
	 * <ol>
	 *    <li>Ҫ͵ϢAES-CBC</li>
	 *    <li>ɰȫǩ</li>
	 *    <li>ϢĺͰȫǩxmlʽ</li>
	 * </ol>
	 *
	 * @param $replyMsg string ƽ̨ظûϢxmlʽַ
	 * @param $timeStamp string ʱԼɣҲURLtimestamp
	 * @param $nonce string ԼɣҲURLnonce
	 * @param &$encryptMsg string ܺĿֱӻظûģmsg_signature, timestamp, nonce, encryptxmlʽַ,
	 *                      return0ʱЧ
	 *
	 * @return int ɹ0ʧܷضӦĴ
	 */
	public function EncryptMsg($sReplyMsg, $sTimeStamp, $sNonce, &$sEncryptMsg)
	{
		$pc = new Prpcrypt($this->m_sEncodingAesKey);

		//
		$array = $pc->encrypt($sReplyMsg, $this->m_sReceiveId);
		$ret = $array[0];
		if ($ret != 0) {
			return $ret;
		}

		if ($sTimeStamp == null) {
			$sTimeStamp = time();
		}
		$encrypt = $array[1];

		//ɰȫǩ
		$sha1 = new SHA1;
		$array = $sha1->getSHA1($this->m_sToken, $sTimeStamp, $sNonce, $encrypt);
		$ret = $array[0];
		if ($ret != 0) {
			return $ret;
		}
		$signature = $array[1];

		//ɷ͵xml
		$xmlparse = new XMLParse;
		$sEncryptMsg = $xmlparse->generate($encrypt, $signature, $sTimeStamp, $sNonce);
		return ErrorCode::$OK;
	}


	/**
	 * Ϣʵԣһȡܺ.
	 * <ol>
	 *    <li>յɰȫǩǩ֤</li>
	 *    <li>֤ͨȡxmlеļϢ</li>
	 *    <li>Ϣн</li>
	 * </ol>
	 *
	 * @param $msgSignature string ǩӦURLmsg_signature
	 * @param $timestamp string ʱ ӦURLtimestamp
	 * @param $nonce string ӦURLnonce
	 * @param $postData string ģӦPOST
	 * @param &$msg string ܺԭģreturn0ʱЧ
	 *
	 * @return int ɹ0ʧܷضӦĴ
	 */
	public function DecryptMsg($sMsgSignature, $sTimeStamp = null, $sNonce, $sPostData, &$sMsg)
	{
		if (strlen($this->m_sEncodingAesKey) != 43) {
			return ErrorCode::$IllegalAesKey;
		}

		$pc = new Prpcrypt($this->m_sEncodingAesKey);

		//ȡ
		$xmlparse = new XMLParse;
		$array = $xmlparse->extract($sPostData);
		$ret = $array[0];

		if ($ret != 0) {
			return $ret;
		}

		if ($sTimeStamp == null) {
			$sTimeStamp = time();
		}

		$encrypt = $array[1];

		//֤ȫǩ
		$sha1 = new SHA1;
		$array = $sha1->getSHA1($this->m_sToken, $sTimeStamp, $sNonce, $encrypt);
		$ret = $array[0];

		if ($ret != 0) {
			return $ret;
		}

		$signature = $array[1];
		if ($signature != $sMsgSignature) {
			return ErrorCode::$ValidateSignatureError;
		}

		$result = $pc->decrypt($encrypt, $this->m_sReceiveId);
		if ($result[0] != 0) {
			return $result[0];
		}
		$sMsg = $result[1];

		return ErrorCode::$OK;
	}

}